//
//  PXAppDelegate.m
//  Pixen-XCode
//
//  Created by Andy Matuschak on Tue Dec 09 2003.
//  Copyright (c) 2003 Open Sword Group. All rights reserved.
//

#import "PXAppDelegate.h"
#import "PXToolPaletteController.h"
#import "PXColorPaletteController.h"
#import "PXToolPropertiesController.h"
#import "PXPreferencesController.h"
#import "PXWelcomeController.h"

@implementation PXAppDelegate

- (BOOL)applicationShouldOpenUntitledFile:(NSApplication *)sender
{
    return NO;
}

- (void)checkForUncleanCrash
{
	NSArray *dirtyFiles = [[NSUserDefaults standardUserDefaults] objectForKey:@"PXDirtyFiles"];
	if (dirtyFiles == nil || [dirtyFiles count] < 1) {
		return;
	}
	
	NSEnumerator *dirtyFileEnumerator = [dirtyFiles objectEnumerator];
	NSString *dirtyFile;
	while (dirtyFile = [dirtyFileEnumerator nextObject]) {
		if ([[NSFileManager defaultManager] fileExistsAtPath:dirtyFile]) {
			[[[NSDocumentController sharedDocumentController] openDocumentWithContentsOfFile:dirtyFile display:YES] setFileName:nil];
			[[NSFileManager defaultManager] removeFileAtPath:dirtyFile handler:nil];
		}
	}
	
	[[NSUserDefaults standardUserDefaults] setObject:[NSArray array] forKey:@"PXDirtyFiles"];
		
	[[NSAlert alertWithMessageText:@"Crash Recovery" defaultButton:@"OK" alternateButton:nil otherButton:nil informativeTextWithFormat:@"Pixen appears to have crashed with unsaved changes the last time it was run.  The affected files' backups have been opened for you.  If you would like to save them over the original files, you'll have to use \"Save As...\" and overwrite them."] runModal];
}

- init
{
    [super init];
    toolPaletteController = [PXToolPaletteController palette];
    colorPaletteController = [PXColorPaletteController palette];
    toolPropertiesController = [PXToolPropertiesController properties];
	if ([[NSUserDefaults standardUserDefaults] boolForKey:@"PXToolPropertiesIsOpen"])
	{
		[toolPropertiesController showWindow:self];
	}
	if (![[NSUserDefaults standardUserDefaults] boolForKey:@"PXColorPaletteIsOpen"] && ([[NSUserDefaults standardUserDefaults] objectForKey:@"PXColorPaletteIsOpen"] != nil))
	{
		[[colorPaletteController window] performClose:self];
	}
    return self;
}

- (IBAction)showToolProperties:sender;
{
    [toolPropertiesController showWindow:self];
}

- (IBAction)showColorPalette:sender
{
    [colorPaletteController showWindow:self];
}

- (IBAction)showPreferences:sender
{
	[[PXPreferencesController preferences] showWindow:self];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    [[toolPaletteController window] display];
    [[colorPaletteController window] display];
	[self checkForUncleanCrash];
	if (![[NSUserDefaults standardUserDefaults] boolForKey:@"PXHasRunBefore"])
	{
		[[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"UKUpdateCheckerCheckAtStartup"];
		[[NSUserDefaults standardUserDefaults] setInteger:120 forKey:@"PXAutosaveInterval"];
		id welcome = [[PXWelcomeController alloc] init];
		[welcome showWindow:self];
		[[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"PXHasRunBefore"];
	}
}

- (IBAction)discoverPixen:sender
{
	id welcome = [[PXWelcomeController alloc] init];
	[welcome showWindow:self];	
}

@end
