<!---
Do not edit this file. This file rendered from templates/readme.md.
See Contributing for how to update this file.
--->

```
pipx --help
usage: pipx [-h] [--version]
            {install,inject,upgrade,upgrade-all,uninstall,uninstall-all,reinstall-all,list,run,runpip,ensurepath}
            ...

Install and execute binaries from Python packages.

Binaries can either be installed globally into isolated Virtual Environments
or run directly in an temporary Virtual Environment.

Virtual Environment location is ~/.local/pipx/venvs.
Symlinks to binaries are placed in ~/.local/bin.
These locations can be overridden with the environment variables
PIPX_HOME and PIPX_BIN_DIR, respectively. (Virtual Environments will
be installed to $PIPX_HOME/venvs)

optional arguments:
  -h, --help            show this help message and exit
  --version             Print version and exit

subcommands:
  Get help for commands with pipx COMMAND --help

  {install,inject,upgrade,upgrade-all,uninstall,uninstall-all,reinstall-all,list,run,runpip,ensurepath}
    install             Install a package
    inject              Install packages into an existing Virtual Environment
    upgrade             Upgrade a package
    upgrade-all         Upgrade all packages. Runs `pip install -U <pkgname>`
                        for each package.
    uninstall           Uninstall a package
    uninstall-all       Uninstall all packages
    reinstall-all       Reinstall all packages with a different Python
                        executable
    list                List installed packages
    run                 Download the latest version of a package to a
                        temporary virtual environment, then run a binary from
                        it. Also compatible with local `__pypackages__`
                        directory (experimental).
    runpip              Run pip in an existing pipx-managed Virtual
                        Environment
    ensurepath          Deprecated, will be removed in a future release. Use
                        `userpath` instead.

```


### pipx install

```
pipx install --help
usage: pipx install [-h] [--spec SPEC] [--include-deps] [--verbose] [--force]
                    [--python PYTHON] [--system-site-packages]
                    [--index-url INDEX_URL] [--editable] [--pip-args PIP_ARGS]
                    package

The install command is the preferred way to globally install binaries
from python packages on your system. It creates an isolated virtual
environment for the package, then ensures the package's binaries are
accessible on your $PATH.

The result: binaries you can run from anywhere, located in packages
you can cleanly upgrade or uninstall. Guaranteed to not have
dependency version conflicts or interfere with your OS's python
packages. 'sudo' is not required to do this.

pipx install PACKAGE
pipx install --python PYTHON PACKAGE
pipx install --spec VCS_URL PACKAGE
pipx install --spec ZIP_FILE PACKAGE
pipx install --spec TAR_GZ_FILE PACKAGE

The argument to `--spec` is passed directly to `pip install`.

The default virtual environment location is ~/.local/pipx
and can be overridden by setting the environment variable `PIPX_HOME`
 (Virtual Environments will be installed to `$PIPX_HOME/venvs`).

The default binary location is ~/.local/bin and can be
overridden by setting the environment variable `PIPX_BIN_DIR`.

positional arguments:
  package               package name

optional arguments:
  -h, --help            show this help message and exit
  --spec SPEC           The package name or specific installation source
                        passed to pip. Runs `pip install -U SPEC`. For example
                        `--spec mypackage==2.0.0` or `--spec
                        git+https://github.com/user/repo.git@branch`
  --include-deps        Include binaries of dependent packages
  --verbose
  --force               Install even when the package has already been
                        installed
  --python PYTHON       The Python executable used to create the Virtual
                        Environment and run the associated binary/binaries.
                        Must be v3.3+.
  --system-site-packages
                        Give the virtual environment access to the system
                        site-packages dir.
  --index-url INDEX_URL, -i INDEX_URL
                        Base URL of Python Package Index
  --editable, -e        Install a project in editable mode
  --pip-args PIP_ARGS   Arbitrary pip arguments to pass directly to pip
                        install/upgrade commands

```


#### `pipx install` examples
```
pipx install pycowsay
pipx install --python python3.6 pycowsay
pipx install --python python3.7 pycowsay
pipx install --spec git+https://github.com/ambv/black black
pipx --spec git+https://github.com/ambv/black.git@branch-name black
pipx --spec git+https://github.com/ambv/black.git@git-hash black
pipx install --spec https://github.com/ambv/black/archive/18.9b0.zip black
pipx install --spec black[d] black
pipx install --include-deps jupyter
```

### pipx run

```
pipx run --help
usage: pipx run [-h] [--no-cache] [--pypackages] [--spec SPEC] [--verbose]
                [--python PYTHON] [--system-site-packages]
                [--index-url INDEX_URL] [--editable] [--pip-args PIP_ARGS]
                binary [binary_args [binary_args ...]]

Download the latest version of a package to a temporary virtual environment,
then run a binary from it. The environment will be cached
and re-used for up to 14 days. This
means subsequent calls to 'run' for the same package will be faster
since they can re-use the cached Virtual Environment.

In support of PEP 582 'run' will use binaries found in a local __pypackages__
 directory, if present. Please note that this behavior is experimental,
 and is a acts as a companion tool to pythonloc. It may be modified or
 removed in the future. See https://github.com/cs01/pythonloc.

positional arguments:
  binary                binary/package name
  binary_args           arguments passed to the binary when it is invoked

optional arguments:
  -h, --help            show this help message and exit
  --no-cache            Do not re-use cached virtual environment if it exists
  --pypackages          Require binary to be run from local __pypackages__
                        directory
  --spec SPEC           The package name or specific installation source
                        passed to pip. Runs `pip install -U SPEC`. For example
                        `--spec mypackage==2.0.0` or `--spec
                        git+https://github.com/user/repo.git@branch`
  --verbose
  --python PYTHON       The Python version to run package's CLI binary with.
                        Must be v3.3+.
  --system-site-packages
                        Give the virtual environment access to the system
                        site-packages dir.
  --index-url INDEX_URL, -i INDEX_URL
                        Base URL of Python Package Index
  --editable, -e        Install a project in editable mode
  --pip-args PIP_ARGS   Arbitrary pip arguments to pass directly to pip
                        install/upgrade commands

```


#### `pipx run` examples

pipx enables you to test various combinations of Python versions and package versions in ephemeral environments:
```
pipx run BINARY  # latest version of binary is run with python3
pipx --spec PACKAGE==2.0.0 run BINARY  # specific version of package is run
pipx --python 3.4 run BINARY  # Installed and invoked with specific Python version
pipx --python 3.7 --spec PACKAGE=1.7.3 run BINARY
pipx --spec git+https://url.git run BINARY  # latest version on master is run
pipx --spec git+https://url.git@branch run BINARY
pipx --spec git+https://url.git@hash run BINARY
pipx run pycowsay moo
pipx --version  # prints pipx version
pipx run pycowsay  --version  # prints pycowsay version
pipx --python pythonX pycowsay
pipx --spec pycowsay==2.0 pycowsay --version
pipx --spec git+https://github.com/ambv/black.git black
pipx --spec git+https://github.com/ambv/black.git@branch-name black
pipx --spec git+https://github.com/ambv/black.git@git-hash black
pipx --spec https://github.com/ambv/black/archive/18.9b0.zip black --help
pipx https://gist.githubusercontent.com/cs01/fa721a17a326e551ede048c5088f9e0f/raw/6bdfbb6e9c1132b1c38fdd2f195d4a24c540c324/pipx-demo.py
```


### pipx upgrade

```
pipx upgrade --help
usage: pipx upgrade [-h] [--spec SPEC] [--include-deps]
                    [--system-site-packages] [--index-url INDEX_URL]
                    [--editable] [--pip-args PIP_ARGS] [--verbose]
                    package

Upgrade a package in a pipx-managed Virtual Environment by running 'pip
install --upgrade PACKAGE'

positional arguments:
  package

optional arguments:
  -h, --help            show this help message and exit
  --spec SPEC           The package name or specific installation source
                        passed to pip. Runs `pip install -U SPEC`. For example
                        `--spec mypackage==2.0.0` or `--spec
                        git+https://github.com/user/repo.git@branch`
  --include-deps        Include binaries of dependent packages
  --system-site-packages
                        Give the virtual environment access to the system
                        site-packages dir.
  --index-url INDEX_URL, -i INDEX_URL
                        Base URL of Python Package Index
  --editable, -e        Install a project in editable mode
  --pip-args PIP_ARGS   Arbitrary pip arguments to pass directly to pip
                        install/upgrade commands
  --verbose

```


### pipx upgrade-all

```
pipx upgrade-all --help
usage: pipx upgrade-all [-h] [--include-deps] [--system-site-packages]
                        [--index-url INDEX_URL] [--editable]
                        [--pip-args PIP_ARGS] [--skip SKIP [SKIP ...]]
                        [--verbose]

Upgrades all packages within their virtual environments by running 'pip
install --upgrade PACKAGE'

optional arguments:
  -h, --help            show this help message and exit
  --include-deps        Include binaries of dependent packages
  --system-site-packages
                        Give the virtual environment access to the system
                        site-packages dir.
  --index-url INDEX_URL, -i INDEX_URL
                        Base URL of Python Package Index
  --editable, -e        Install a project in editable mode
  --pip-args PIP_ARGS   Arbitrary pip arguments to pass directly to pip
                        install/upgrade commands
  --skip SKIP [SKIP ...]
                        skip these packages
  --verbose

```


### pipx inject

```
pipx inject --help
usage: pipx inject [-h] [--include-binaries] [--include-deps]
                   [--system-site-packages] [--index-url INDEX_URL]
                   [--editable] [--pip-args PIP_ARGS] [--verbose]
                   package dependencies [dependencies ...]

Installs packages to an existing pipx-managed virtual environment.

positional arguments:
  package               Name of the existing pipx-managed Virtual Environment
                        to inject into
  dependencies          the packages to inject into the Virtual Environment

optional arguments:
  -h, --help            show this help message and exit
  --include-binaries    Add binaries from the injected packages onto your PATH
  --include-deps        Include binaries of dependent packages
  --system-site-packages
                        Give the virtual environment access to the system
                        site-packages dir.
  --index-url INDEX_URL, -i INDEX_URL
                        Base URL of Python Package Index
  --editable, -e        Install a project in editable mode
  --pip-args PIP_ARGS   Arbitrary pip arguments to pass directly to pip
                        install/upgrade commands
  --verbose

```


#### `pipx inject` example

One use of the inject command is setting up a REPL with some useful extra packages.

```
pipx install ptpython
pipx inject ptpython requests pendulum
```

After running the above commands, you will be able to import and use the `requests` and `pendulum` packages inside a `ptpython` repl.

### pipx uninstall

```
pipx uninstall --help
usage: pipx uninstall [-h] [--verbose] package

Uninstalls a pipx-managed Virtual Environment by deleting it and any files
that point to its binaries.

positional arguments:
  package

optional arguments:
  -h, --help  show this help message and exit
  --verbose

```


### pipx uninstall-all

```
pipx uninstall-all --help
usage: pipx uninstall-all [-h] [--verbose]

Uninstall all pipx-managed packages

optional arguments:
  -h, --help  show this help message and exit
  --verbose

```


### pipx reinstall-all

```
pipx reinstall-all --help
usage: pipx reinstall-all [-h] [--include-deps] [--system-site-packages]
                          [--index-url INDEX_URL] [--editable]
                          [--pip-args PIP_ARGS] [--skip SKIP [SKIP ...]]
                          [--verbose]
                          python

Reinstalls all packages using a different version of Python.

Packages are uninstalled, then installed with pipx install PACKAGE.
This is useful if you upgraded to a new version of Python and want
all your packages to use the latest as well.

If you originally installed a package from a source other than PyPI,
this command may behave in unexpected ways since it will reinstall from PyPI.

positional arguments:
  python

optional arguments:
  -h, --help            show this help message and exit
  --include-deps        Include binaries of dependent packages
  --system-site-packages
                        Give the virtual environment access to the system
                        site-packages dir.
  --index-url INDEX_URL, -i INDEX_URL
                        Base URL of Python Package Index
  --editable, -e        Install a project in editable mode
  --pip-args PIP_ARGS   Arbitrary pip arguments to pass directly to pip
                        install/upgrade commands
  --skip SKIP [SKIP ...]
                        skip these packages
  --verbose

```


### pipx list

```
pipx list --help
usage: pipx list [-h] [--verbose]

List packages and binariess installed with pipx

optional arguments:
  -h, --help  show this help message and exit
  --verbose

```


#### `pipx list` example
```
> pipx list
venvs are in /Users/user/.local/pipx/venvs
binaries are exposed on your $PATH at /Users/user/.local/bin
   package black 18.9b0, Python 3.7.0
    - black
    - blackd
   package pipx 0.10.0, Python 3.7.0
    - pipx
```

### pipx runpip

```
pipx runpip --help
usage: pipx runpip [-h] [--verbose] package [pipargs [pipargs ...]]

Run pip in an existing pipx-managed Virtual Environment

positional arguments:
  package     Name of the existing pipx-managed Virtual Environment to run pip
              in
  pipargs     Arguments to forward to pip command

optional arguments:
  -h, --help  show this help message and exit
  --verbose

```
