#!/bin/sh
###########################################################################
#
# Create a fixed IP address
#
# If not connected to DHCP, the computer will use a fixed IP address
# (192.168.1.50 in this example).
# If your radio has a fixed IP address in the same subnet, this
# makes it easy to use the radio with a direct cable between RaspPi and radio
#
###########################################################################
#
cd $HOME

cat > etc_network_eth0 << '#EOF'
auto eth0
  iface eth0 inet static
  address 191.168.1.50
  netmask 255.255.255.0
  gateway 192.168.1.1
  dns-nameservers 192.168.1.1
#EOF
sudo cp etc_network_eth0  /etc/network/interfaces.d/eth0

rm etc_network_eth0
