#!/bin/sh
##########################################################
#
# Create Desktop Icons and startup scripts
# for piHPSDR, fldigi, wsjtx, FreeDV
#
##########################################################

cd $HOME
#
# We invoke pihpsdr through a "shell script wrapper".
# This way we can take care the HPSDR logo is found
# and combine the stdout and stderr output into a single
# log file.
#
cat > $HOME/pihpsdr/pihpsdr.sh << '#EOF'
#!/bin/sh
cd $HOME/pihpsdr
rm -f hpsdr.png
cp release/pihpsdr/hpsdr.png hpsdr.png
./pihpsdr >pihpsdr.log 2>&1
#EOF
chmod 755 $HOME/pihpsdr/pihpsdr.sh

#
# The desktop files are created "the pedestrian way"
# then we can insert the actual home dir
#
FILE=$HOME/Desktop/pihpsdr.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=piHPSDR"                                      >> $FILE
echo "Icon=$HOME/pihpsdr/release/pihpsdr/hpsdr_icon.png" >> $FILE
echo "Exec=$HOME/pihpsdr/pihpsdr.sh"                     >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

FILE=$HOME/Desktop/fldigi.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=Fldigi"                                       >> $FILE
echo "Icon=$HOME/fldigi/data/fldigi-psk.png"             >> $FILE
echo "Exec=$HOME//fldigi/src/fldigi"                     >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

FILE=$HOME/Desktop/wsjtx.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=wsjtx"                                        >> $FILE
echo "Icon=$HOME/wsjtx/icons/Unix/wsjtx_icon.png"        >> $FILE
echo "Exec=$HOME/wsjtx/bin/wsjtx"                        >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE

FILE=$HOME/Desktop/freedv.desktop
echo "[Desktop Entry]"                                    > $FILE
echo "Name=FreeDV"                                       >> $FILE
echo "Icon=$HOME/freedv-gui/contrib/freedv128x128.png"   >> $FILE
echo "Exec=$HOME/freedv-gui/build_linux/src/freedv"      >> $FILE
echo "Type=Application"                                  >> $FILE
echo "Terminal=false"                                    >> $FILE
echo "StartupNotify=false"                               >> $FILE
