///
/// Access control for objects.
///	@file		ownership.cpp - pianod
///	@author		Perette Barella
///	@date		2014-12-28
///	@copyright	Copyright 2014-2016 Devious Fish.  All rights reserved.
///

#include <config.h>

#include <cassert>

#include <string>

#include "ownership.h"
#include "users.h"


PrimaryOwnership::PrimaryOwnership (void) {

}
PrimaryOwnership::PrimaryOwnership (Type rule, User *owneruser) {
    access = rule;
    owner = owneruser;
};
PrimaryOwnership::~PrimaryOwnership (void) {
    abandon ();
}

const std::string &PrimaryOwnership::ownerName (void) const {
    static const std::string noowner = "(Unowned)";
    if (owner) return owner->username();
    return noowner;
};

void PrimaryOwnership::abandon (void) {
    owner = nullptr;
    access = Type::DISOWNED;
}

void PrimaryOwnership::abandon (const User *user) {
    if (user == owner) {
        owner = nullptr;
        access = Type::DISOWNED;
    }
}

bool PrimaryOwnership::isOwnedBy (const User *user) const {
    assert (access != Type::DISOWNED || owner == nullptr);
    return (user != nullptr && owner == user);
}


bool PrimaryOwnership::hasPermission (const User *user, Action action) const {
    assert (access != Type::DISOWNED || owner == nullptr);
    return ((user != nullptr && owner == user) ||
            (int (action) < int (access)));
}


bool SubordinateOwnership::isOwnedBy (const User *user) const {
    if (!parentOwner()) return false;
    return parentOwner()->isOwnedBy (user);
}

bool SubordinateOwnership::hasPermission (const User *user, Action action) const {
    if (!parentOwner()) return false;
    return parentOwner()->hasPermission (user, action);
}



//const static OWNERSHIP_LOOKUP ownership_def [] = {
//};

OwnershipLookup OWNERSHIP ( {
    { "Disowned",       Ownership::Type::DISOWNED },
    { "Private",        Ownership::Type::PRIVATE },
    { "Shared",         Ownership::Type::SHARED },
    { "Published",      Ownership::Type::PUBLISHED },
    { "Public",         Ownership::Type::PUBLIC }
} );
