///
/// Source parameters for sources based on music library.
///	@file		musiclibraryparameters.h - pianod
///	@author		Perette Barella
///	@date		20150-03-16
///	@copyright	Copyright (c) 2015-2020 Devious Fish. All rights reserved.
///

#pragma once

#include <config.h>

#include <football.h>

#include "mediaparameters.h"
#include "musiclibrary.h"

namespace MusicLibrary {
    typedef enum library_scan_frequency_t {
        SCAN_NEVER,
        SCAN_ON_LOAD,
        SCAN_EVERY_LOAD,
        SCAN_DAILY
    } ScanFrequency;

    extern const LookupTable <ScanFrequency> RescanModes;



    struct LibraryParameters : public Media::SourceParameters {
        int recent_bias = BIAS_NEUTRAL;  ///< Amount of bias to apply for time since last play.
        int rating_bias = BIAS_NEUTRAL;  ///< Amount of bias to apply for user ratings.
        ScanFrequency scan_frequency = SCAN_NEVER;

        LibraryParameters (Ownership::Type perm, User *user);
        LibraryParameters (const UserData::StringDictionary &src);
        virtual bool persist (UserData::StringDictionary &dest) const override;
    };



    typedef enum library_parameter_id_t {
        RECENT_BIAS = 5000,
        RATING_BIAS,
        RESCAN_BEHAVIOR
    } LibraryParameterId;

    extern const FB_PARSE_DEFINITION library_options [];
    extern int interpretLibraryBasedParameters (Football::GenericOptionParser &parser,
                                                int cmd, LibraryParameters &result);

    template <typename DataObjectType, typename OptionEnum> class ParameterParser
    : public Media::SourceParameterParser<DataObjectType, OptionEnum> {
        typedef Media::SourceParameterParser<DataObjectType, OptionEnum> base_type;
    public:
        using library_parameters = ParameterParser<DataObjectType, OptionEnum>;
        using base_type::argv;
        using base_type::addStatements;
        ParameterParser () {
            addStatements (library_options);
        };
        virtual int handleOption (OptionEnum cmd, DataObjectType &result) override {
            return interpretLibraryBasedParameters(*this, cmd, result);
        };
    };

    extern ParameterParser<LibraryParameters, LibraryParameterId> parameterParser;

}

