///
/// Playlist / Artist / Album / Song datatypes that are self-implemented.
/// Each datatype / data item exists independent of the others; there
/// are no references to eachother.  (Contrast with songlibrary.)
///	@file		encapmusic.cpp - pianod
///	@author		Perette Barella
///	@date		2014-12-09
///	@copyright	Copyright 2014-2017 Devious Fish.  All rights reserved.
///

#include <config.h>

#include <cassert>

#include <string>

#include "encapmusic.h"
#include "mediaunit.h"

using namespace std;
/*
 *              Songs
 */

void EncapsulatedSong::playlist (PianodPlaylist *play) {
    _playlist = play;
};



/*
 *              Playlists
 */

MetaPlaylist::MetaPlaylist (Media::Source *const source,
                            PianodPlaylist::PlaylistType type) :
EncapsulatedPlaylist (source) {
    assert (type == PianodPlaylist::MIX ||
            type == PianodPlaylist::EVERYTHING ||
            type == PianodPlaylist::TRANSIENT);
    playlistType (type);
    const char *word = (type == PianodPlaylist::MIX ? "mix" :
                        type == PianodPlaylist::EVERYTHING ? "bibliotheque" :
                        "transient");
    playlistName (string (source->kind()) + " " + source->name() + " " + word);
    playlistId (word);
}
bool MetaPlaylist::includedInMix (void) const {
    assert (!"Metaplaylist mix inclusion requested");
    return false;
};

void MetaPlaylist::includedInMix (bool) {
    assert (!"Metaplaylist mix inclusion changed");
};

void MetaPlaylist::rename (const std::string &) {
    assert (!"Metaplaylist rename attempted");
    throw CommandError (E_BUG);
}
void MetaPlaylist::erase () {
    assert (!"Metaplaylist delete attempted");
    throw CommandError (E_BUG);
}

