///
/// JSON formatter
/// A simple JSON formatter using the Parsnip library.
/// @file       json_format.cpp - JSON formatter
/// @author     Perette Barella
/// @date       2019-05-01
/// @copyright  Copyright 2019-2020 Devious Fish. All rights reserved.
///

#include <istream>
#include <iostream>
#include <fstream>

#include "parsnip.h"

void reformat (std::istream &src) {
    try {
        Parsnip::Data data = Parsnip::parse_json (src);
        data.toJson (std::cout, 0) << std::endl;
    } catch (const Parsnip::Exception &ex) {
        std::cerr << ex.what() << std::endl;
    }
    return;
}


int main (int argc, const char **argv) {
    if (argc <= 1) {
        reformat (std::cin);
    } else {
        for (int i = 1; i< argc; i++) {
            std::ifstream in (*(argv + i));
            reformat (in);
        }
    }
}

