///
/// Output using ffmpeg's libavdevices libraries.
///	@file		avdeviceoutput.h - pianod2
///	@author		Perette Barella
///	@date		2016-02-04
///	@copyright	Copyright (c) 2016-2018 Devious Fish. All rights reserved.
///

#ifndef __pianod2__avdeviceoutput__
#define __pianod2__avdeviceoutput__

#include <config.h>

#include <memory>

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdocumentation"
extern "C" {
#include <libavformat/avformat.h>
#include <libavcodec/avcodec.h>
}
#pragma GCC diagnostic pop

#include "audiooutput.h"

namespace Audio {
    /// Output class for libavdevice.
    class AvDeviceOutput : public Output {
        struct CodecDeleter {
            void operator() (AVCodecContext *coder) {
                avcodec_free_context (&coder);
            }
        };

        AVCodec *codec = nullptr;
        AVFormatContext *context = nullptr;
        AVStream *stream = nullptr;
        std::unique_ptr <AVCodecContext, CodecDeleter> codec_context;
        AVPacket packet;
        int min_flush_time = 0; ///< milliseconds
        int max_flush_time = 2000; ///< milliseconds
        const int flush_time_quanta = 100; ///< milliseconds
    public:
        AvDeviceOutput (const AudioSettings &settings,
                        const AudioFormat &format);
        virtual ~AvDeviceOutput ();
        virtual bool play (void *buffer, unsigned numberOfBytes) override;
    };

}

#endif /* defined(__pianod2__avdeviceoutput__) */
