///
/// HTTP client request provider.
/// @file       httpclient.h - pianod project
/// @author     Perette Barella
/// @date       2020-03-24
/// @copyright  Copyright 2020 Devious Fish. All rights reserved.
///

#pragma once

#include <string>
#include <sstream>
#include <exception>
#include <unordered_map>
#include <ostream>
#include <iostream>

#include <curl/curl.h>

class HttpClient {
    CURL *session;
    bool debug {false};
    
public:
    class Exception : public std::exception {
    private:
        std::string explanation;
    public:
        Exception (const char *reason = "HTTP error");
        Exception (const char *function, CURLcode code);
        Exception (const char *function, CURLcode code, const char *detail);
        Exception (CURLcode code, const char *detail);
        virtual const char *what() const noexcept override final {
            return explanation.c_str();
        }
    };

    enum class RequestType {
        Head,
        Get,
        Post
    };

    using StringDict = std::unordered_map<std::string, std::string>;
    struct Request {
        mutable bool debug {false};
        RequestType type {RequestType::Get};
        std::string URL;
        std::string proxy;
        StringDict headers;
        StringDict cookies;
        std::string body;
        void dump (std::ostream & = std::cerr) const;
    };

    struct Response {
        bool debug {false};
        bool awaiting_http_status_line {true};
        CURLcode curl_code;
        int http_status{0};
        std::string http_status_text;
        bool header_corruption{false};
        StringDict headers;
        StringDict cookies;
        std::string body;
        void dump (std::ostream & = std::cerr) const;
    };

    HttpClient (bool dbx = false);
    ~HttpClient ();
    HttpClient (const HttpClient &) = delete;
    HttpClient (HttpClient &&) = delete;
    HttpClient &operator= (const HttpClient &) = delete;
    HttpClient &operator= (HttpClient &&) = delete;
    const Response performHttpRequest (const Request &request);
};
