///
/// Parser for audio options.
/// Parse audio options for creating or reconfiguring a room.
///	@file		audiooptionsparser.h - pianod2
///	@author		Perette Barella
///	@date		2015-11-23
///	@copyright	  Copyright (c) 2015-2017 Devious Fish. All rights reserved.
///

#ifndef __pianod2__audiooptionsparser__
#define __pianod2__audiooptionsparser__

#include <config.h>

#include <footparser.h>

#include "connection.h"

#include "fundamentals.h"

/// Support for parsing audio options into the AudioSettings structure.
namespace AudioOptions {
    enum class Option {
        Driver = 1,
        Device,
        Id,
        Options,
        Server,
        Library,
        Volume,
        CrossfadeTime,
        CrossfadeLevel,
        PrerollTime
    };

    void validate (const AudioSettings);

    /** AudioOptions is the parser that fills in the AudioSettings structure. */
    class Parser : public Football::OptionParser<AudioSettings, Option> {
        virtual int handleOption (Option option, AudioSettings &dest) override;
    public:
        Parser ();
        int interpret (const std::vector<std::string> &options, AudioSettings &result, PianodConnection &conn);
    };

    extern Parser parser;
}

#endif /* defined(__pianod2__audiooptionsparser__) */
