# 
# Support functions for ncurses library & include checking.
# @file       dfncurses.cpp - DF_CHECK_NCURSES
# @author     Perette Barella
# @date       2020-05-11
# @copyright  Copyright 2020 Devious Fish. All rights reserved.
#
# DF_CHECK_IPV6([additional-yes],[additional-no])
# Defines HAVE_NCURSES and sets ncurses_LIBS if it is available
# (both header and library).
# Side-effects: Compilation language is set to C.

AC_DEFUN([DF_CHECK_NCURSES], [
    AC_LANG([C])
    AC_CHECK_HEADERS([term.h], [
	AC_CHECK_LIB([ncurses], [setupterm], [
	    AC_DEFINE(HAVE_NCURSES, [1], [Define this symbol if you have NCURSES support])
            AC_SUBST([ncurses_LIBS], [-lncurses])
	    $2
        ], [
	    $3
	])
    ], [
	$3
    ])
])
