//
//  fb_utility.c
//  pianod
//
//  Created by Perette Barella on 2014-03-26.
//
//

#include <stdio.h>
#include <stdbool.h>
#include <assert.h>
#include <stdlib.h>
#include <memory.h>

#include "fb_public.h"

/* calloc() with ability to expand the allocated data. */
bool fb_expandcalloc (void **data, size_t *capacity, size_t newcapacity, size_t itemsize) {
    assert ((capacity != 0) == (data != NULL));
    if (newcapacity <= *capacity) {
        /* It's big enough already */
        return true;
    }
    /* Expand in reasonable chunks when necessary, not by drips. */
    size_t mincapacity = *capacity * 2 + 25;
    if (mincapacity > newcapacity) {
        newcapacity = mincapacity;
    }
    size_t oldsize = *capacity * itemsize;
    size_t newsize = newcapacity * itemsize;
    char *newdata = realloc (*data, newsize);
    if (!newdata) {
        return false;
    }
    *data = (void *) newdata;
    memset(newdata + oldsize, 0, newsize - oldsize);
    *capacity = newcapacity;
    return true;
}

