/*
 *  fb_public.h
 *  Player
 *
 *  Created by Perette Barella on 2012-03-03.
 *  Copyright 2012 Devious Fish. All rights reserved.
 *
 */

#include <stdarg.h>
#include <stdbool.h>
#include <sys/types.h>
#include <netinet/in.h>

#ifndef __FB_PUBLIC__
#define __FB_PUBLIC__

/* Event types returned from the socket manager */
typedef enum fb_event_type_t {
	FB_EVENT_CONNECT = 1,	/* Connection */
	FB_EVENT_INPUT,			/* Connection */
	FB_EVENT_CLOSE,			/* Connection */
	FB_EVENT_STOPPED,		/* Service */
	FB_EVENT_ITERATOR,		/* Iterator response */
	FB_EVENT_ITERATOR_CLOSE,/* Iterator response, when closing */
	FB_EVENT_WRITABLE,		/* User thingies only */
	FB_EVENT_READABLE,		/* User thingies only */
	FB_EVENT_FAULTING,		/* User thingies only */
	FB_EVENT_TIMEOUT
} FB_EVENTTYPE;

/* Events are returned in this structure */
typedef struct fb_event_t {
	int magic; /* Enums and ints are same thing, right? :( TODO: Fix this */
	FB_EVENTTYPE type;
	int socket;
	void *context; /* Provided for connections, or if supplied for user thingies */
	struct fb_connection_t *connection; /* For connect, close, and input */
	struct fb_service_t *service; /* All connection events and service closed */
	char *command; /* A command received on a connection, raw form */
	int argc;
	char **argv; /* A command received on a connection, pre-parsed */
} FB_EVENT;


typedef struct fb_parse_definition_t {
	int response;	/* The value to return when this is the command */
	char *statement;	/* The command line */
} FB_PARSE_DEFINITION;


typedef enum fb_parse_error_t {
	FB_PARSE_FAILURE = 0,
	FB_PARSE_INCOMPLETE = -1,
	FB_PARSE_INVALID_KEYWORD = -2,
	FB_PARSE_EXTRA_TERMS = -3,
	FB_PARSE_NUMERIC = -4
} FB_PARSE_ERROR;

/* "Legitimate", i.e. published API, subroutines */
extern FB_EVENT *fb_wait ();
extern FB_EVENT *fb_poll ();
extern FB_EVENT *fb_poll_until (time_t untilwhen);
extern FB_EVENT *fb_poll_with_timeout (double timeout);

extern struct fb_service_t *fb_create_service (in_port_t port, int nqueue, size_t contextsize);
extern void fb_close_service (struct fb_service_t *service);

extern FB_EVENT *fb_accept_file (struct fb_service_t *service, char *filename);
extern void fb_close_connection (struct fb_connection_t *connection);
extern ssize_t fb_fprintf (void *thing, const char *format, ...);
extern ssize_t fb_vfprintf (void *thing, const char *format, va_list parameters);
extern ssize_t fb_bfprintf (void *thing, const char *format, ...);
extern ssize_t fb_bvfprintf (void *thing, const char *format, va_list parameters);

extern struct fb_parser_t *fb_create_parser (void);
extern bool fb_parser_add_statements (struct fb_parser_t *parser, const FB_PARSE_DEFINITION def[], const int count);
extern int fb_interpret (const struct fb_parser_t *parser, char *const *argv, char **errorpoint);
extern void fb_parser_destroy (struct fb_parser_t *parser);

extern struct fb_iterator_t *fb_new_iterator (struct fb_service_t *service);
extern FB_EVENT *fb_iterate_next (struct fb_iterator_t *it);
extern void fb_destroy_iterator (struct fb_iterator_t *it);
extern void fb_accept_input (struct fb_connection_t *connection, bool input);
	
#endif
