<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2021 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){function aa(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}}
var c=[""],e=[256],f=["","t"],n=["","id"],ba=["","vid"],r=["","type"],t=["","width"],u={flags:3089},v=["","height"],ca=["","show_id"],w=["","track_id"],z=["","album_id"],B=[[/(?:)/,c]],da=["","video_id"],ea=["","user","id"],fa=["","type","id"],ha=["","id","type"],ia=["","fid","eid"],ja=["","episode_id"],ka=["","user","slug"],la=["","playlist_id"],ma=/"id"\\s*:\\s*"(\\w+)"/,na=["","oid","vid","hash"],oa=["","channel","clip_id"],pa=["","athlete","highlight"],qa=["","account_id","event_id"],C={d:[],s:!1},
ra={d:[],s:!0},sa=["","show_id","episode_id","t"],ta=[[/globalnews\\.ca\\/video\\/(\\d+)/,n]],ua=[/hudl\\.com\\/video\\/(\\w+)(?![\\w\\/])/,n],va=[/flickr\\.com\\/photos\\/[^\\/]+\\/(\\d+)/,n],wa=[[/([-\\w]+)\\.castos\\.com\\/player\\/(\\d+)/,["","host","id"]]],xa=[[/247sports\\.com\\/PlayerSport\\/[-\\w]*(\\d+)\\/Embed/,["","player_id"]]],ya=[/hudl\\.com\\/video\\/\\d+\\/(\\d+)\\/([\\da-f]+)/,pa],za=[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|i18n\\/share\\/video)\\/(\\d+)/,n]],Aa=[[/(?:open|play)\\.spotify\\.com\\/(?:user\\/[-.\\w]+\\/)?((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,
n]],Ba=[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],G=[function(a,b){var d={},g;for(g in b.b){var q=b.b[g],h=!1;if(g in a.b){h=q.d;var l=g,p=a.b[g];D.k=l;for(var k=0;k<h.length&&(p=h[k](p,l),!1!==p);++k);delete D.k;h=p}!1!==h?d[g]=h:"undefined"!==typeof q.x?d[g]=q.x:q.s&&E(a)}Ca(a,d)}],Da={d:[function(a){var b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],s:!1},Ea={x:360,d:Ba,s:!1},Fa={x:640,d:Ba,s:!1},
H={e:e,b:{id:C},h:1,d:G,f:10,j:u,g:5E3},Ga={e:e,b:{id:C,user:C},h:1,d:G,f:10,j:u,g:5E3},Ha={e:e,b:{height:Ea,id:C,width:Fa},h:1,d:G,f:10,j:u,g:5E3},Ia=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$vAMAZON_ASSOCIATE_TAG"/><xsl:param$vAMAZON_ASSOCIATE_TAG_CA"/><xsl:param$vAMAZON_ASSOCIATE_TAG_DE"/><xsl:param$vAMAZON_ASSOCIATE_TAG_ES"/><xsl:param$vAMAZON_ASSOCIATE_TAG_FR"/><xsl:param$vAMAZON_ASSOCIATE_TAG_IN"/><xsl:param$vAMAZON_ASSOCIATE_TAG_IT"/><xsl:param$vAMAZON_ASSOCIATE_TAG_JP"/><xsl:param$vAMAZON_ASSOCIATE_TAG_UK"/><xsl:param$vMEDIAEMBED_THEME"/>$eABCNEWS"><$r$dabcnews"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//abcnews.go.com/video/embed?id={@id}"$g$b/></$r></$r>$i$eACAST"><$m$dacast"$f"$l$p$kno"$ohttps://embed.acast.com/{@show_id}/{@episode_id}?seek={@t}"$gborder:0;height:188px;max-width:900px;width:100%"/>$i$eAMAZON"><$r$damazon"$g$c120px"><$r$g$a200%"><$m$f"$l$p$kno"$gbackground:url(https://www.amazon.com/favicon.ico) center no-repeat;$b><$n$vsrc">//ws-<$w><$u$t@tld=\\\'jp\\\'">fe</$u><$u$t@tld and contains(\\\'desfrinituk\\\',@tld)">eu</$u><$q>na</$q></$w>.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=<$w><$u$t@tld=\\\'ca\\\'">15&amp;t=$h$AMAZON_ASSOCIATE_TAG_CA"/></$u><$u$t@tld=\\\'de\\\'">3&amp;t=$h$AMAZON_ASSOCIATE_TAG_DE"/></$u><$u$t@tld=\\\'es\\\'">30&amp;t=$h$AMAZON_ASSOCIATE_TAG_ES"/></$u><$u$t@tld=\\\'fr\\\'">8&amp;t=$h$AMAZON_ASSOCIATE_TAG_FR"/></$u><$u$t@tld=\\\'in\\\'">31&amp;t=$h$AMAZON_ASSOCIATE_TAG_IN"/></$u><$u$t@tld=\\\'it\\\'">29&amp;t=$h$AMAZON_ASSOCIATE_TAG_IT"/></$u><$u$t@tld=\\\'jp\\\'">9&amp;t=$h$AMAZON_ASSOCIATE_TAG_JP"/></$u><$u$t@tld=\\\'uk\\\'">2&amp;t=$h$AMAZON_ASSOCIATE_TAG_UK"/></$u><$q>1&amp;t=$h$AMAZON_ASSOCIATE_TAG"/></$q></$w>&amp;asins=$h@id"/></$n></$m></$r></$r>$i$eANCHOR"><$m$danchor"$f"$l$p$kno"$o//anchor.fm/x/embed/episodes/x-{@id}"$gborder:0;height:102px;max-width:768px;width:100%"/>$i$eAPPLEPODCASTS"><$m$dapplepodcasts" allow="autoplay *;encrypted-media *"$f"$l$p$kno"><$w><$u$t@episode_id"><$n$vsrc">https://embed.podcasts.apple.com/$h@country"/>/podcast/episode/id$h@podcast_id"/>?theme=$h$MEDIAEMBED_THEME"/>&amp;i=$h@episode_id"/></$n><$n$v$y>border:0;height:175px;max-width:900px;width:100%</$n></$u><$q><$n$vsrc">https://embed.podcasts.apple.com/$h@country"/>/podcast/episode/id$h@podcast_id"/>?theme=$h$MEDIAEMBED_THEME"/></$n><$n$v$y>border:0;height:450px;max-width:900px;width:100%</$n></$q></$w></$m>$i$eAUDIOBOOM"><$m$daudioboom"$f"$l$p$kno"$o//audioboom.com/posts/{@id}/embed/v3"$gborder:0;height:150px;max-width:700px;width:100%"/>$i$eAUDIOMACK"><$m$daudiomack"$f"$l$p$kno"><$w><$u$t@mode=\\\'album\\\'"><$n$vsrc">https://www.audiomack.com/embed/album/<$w><$u$t@id">$h@id"/></$u><$q>$h@artist"/>/$h@title"/></$q></$w></$n><$n$v$y>border:0;height:400px;max-width:900px;width:100%</$n></$u><$q><$n$vsrc">https://www.audiomack.com/embed/song/<$w><$u$t@id">$h@id"/></$u><$q>$h@artist"/>/$h@title"/></$q></$w></$n><$n$v$y>border:0;height:252px;max-width:900px;width:100%</$n></$q></$w></$m>$i$eAUDIUS"><$m$daudius"$f"$l$p$kno"><$n$vsrc">https://audius.co/embed/<$w><$u$t@track_id">track/$h@track_id"/>?flavor=compact</$u><$u$t@album_id">album/$h@album_id"/>?flavor=card</$u><$q>playlist/$h@playlist_id"/>?flavor=card</$q></$w></$n><$n$v$y>border:0;height:<$w><$u$t@track_id">12</$u><$q>48</$q></$w>0px;max-width:<$w><$u$t@track_id">9</$u><$q>4</$q></$w>00px;width:100%</$n></$m>$i$eBANDCAMP"><$r$dbandcamp"$g$c400px"><$r$g$a100%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$w><$u$t@album_id">album=$h@album_id"/><xsl:if$t@track_num">/t=$h@track_num"/></xsl:if></$u><$q>track=$h@track_id"/></$q></$w><xsl:if$t$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</xsl:if></$n></$m></$r></$r>$i$eBBCNEWS"><$r$dbbcnews"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//www.bbc.com/news/av-embeds/<$w><$u$tstarts-with(@playlist,\\\'/news/\\\')"><$w><$u$tcontains(@playlist,\\\'-\\\')">$hsubstring-after(substring-after(translate(@playlist,\\\'A\\\',\\\'#\\\'),\\\'news/\\\'),\\\'-\\\')"/></$u><$q>$hsubstring-after(translate(@playlist,\\\'A\\\',\\\'/\\\'),\\\'/news/\\\')"/></$q></$w></$u><$u$tcontains(@id,\\\'/\\\')">$hsubstring-after(@id,\\\'/\\\')"/></$u><$q>$h@id"/></$q></$w></$n></$m></$r></$r>$i$eBITCHUTE"><$r$dbitchute"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.bitchute.com/embed/{@id}/"$g$b/></$r></$r>$i$eBLEACHERREPORT"><$r$dbleacherreport"$g$c320px"><$r$g$a100%"><$m$f"$l$p$kno"$o//bleacherreport.com/video_embed?id={@id}&amp;library=video-cms"$g$b/></$r></$r>$i$eBRIGHTCOVE"><$r$dbrightcove"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">https://<$w><$u$t@bckey">link.brightcove.com/services/player/bcpid$h@bcpid"/>?bckey=$h@bckey"/>&amp;bctid=$h@bctid"/>&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640</$u><$q>players.brightcove.net/$h@bcpid"/>/default_default/index.html?videoId=$h@bctid"/></$q></$w></$n></$m></$r></$r>$i$eCASTOS"><$m$dcastos"$f"$l$p$kno"$ohttps://player.castos.com/player/{@id}"$gborder:0;height:150px;max-width:900px;width:100%"/>$i$eCBSNEWS"><$r$dcbsnews"$g$c640px"><$r><$w><$u$tcontains(@id,\\\'-\\\')"><$n$v$y>$a56.25%</$n><$m$f"$l$p$kno"$ohttps://www.cbsnews.com/embed/videos/{@id}/"$g$b/></$u><$u$t@pid"><$n$v$y>$a62.1875%;padding-bottom:calc(56.25% + 38px)</$n><object data="//www.cbsnews.com/common/video/cbsnews_player.swf"$g$x type="application/x-shockwave-flash" typemustmatch="">$z<param$vflashvars" value="pType=embed&amp;si=254&amp;pid={@pid}"/></object></$u><$q><$n$v$y>$a62.5%;padding-bottom:calc(56.25% + 40px)</$n><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf"$g$x type="application/x-shockwave-flash" typemustmatch="">$z<param$vflashvars" value="si=254&amp;contentValue={@id}"/></object></$q></$w></$r></$r>$i$eCLYP"><$m$dclyp"$f"$l$p$kno"$ohttps://clyp.it/{@id}/widget"$gborder:0;height:265px;max-width:900px;width:100%"/>$i$eCNBC"><$r$dcnbc"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid={@id}&amp;size=640_360"$g$b/></$r></$r>$i$eCNN"><$r$dcnn"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//fave.api.cnn.io/v1/fav/?video={@id}&amp;customer=cnn&amp;edition=international&amp;env=prod"$g$b/></$r></$r>$i$eCNNMONEY"><$r$dcnnmoney"$g$c560px"><$r$g$a64.285714%"><$m$f"$l$p$kno"$o//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&amp;width=560&amp;height=360"$g$b/></$r></$r>$i$eCODEPEN"><$m$dcodepen"$f"$l$p$kno"$ohttps://codepen.io/{@user}/embed/{@id}?height=400&amp;default-tab=html,result"$gborder:0;height:400px;width:100%"/>$i$eCOMEDYCENTRAL"><$r$dcomedycentral"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//media.mtvnservices.com/embed/{@id}"$g$b/></$r></$r>$i$eCOUB"><$r$dcoub"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//coub.com/embed/{@id}"$g$b/></$r></$r>$i$eDAILYMOTION"><$r$ddailymotion"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//www.dailymotion.com/embed/video/$h@id"/><xsl:if$t@t">?start=$h@t"/></xsl:if></$n></$m></$r></$r>$i$eDEMOCRACYNOW"><$r$ddemocracynow"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//www.democracynow.org/embed/<$w><$u$tcontains(@id,\\\'/headlines\\\')">headlines/$hsubstring-before(@id,\\\'/headlines\\\')"/></$u><$u$tstarts-with(@id,\\\'2\\\')">story/$h@id"/></$u><$u$tstarts-with(@id,\\\'shows/\\\')">show/$hsubstring-after(@id,\\\'/\\\')"/></$u><$q>$h@id"/></$q></$w></$n></$m></$r></$r>$i$eDUMPERT"><$r$ddumpert"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.dumpert.nl/embed/{translate(@id,\\\'/\\\',\\\'_\\\')}"$g$b/></$r></$r>$i$eEIGHTTRACKS"><$r$deighttracks"$g$c400px"><$r$g$a100%"><$m$f"$l$p$kno"$o//8tracks.com/mixes/{@id}/player_v3_universal"$g$b/></$r></$r>$i$eESPN"><$r$despn"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.espn.com/core/video/$m?id={@id}"$g$b/></$r></$r>$i$eFACEBOOK"><$m$dfacebook"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/facebook.min.html#{@type}{@id}"$gborder:0;height:360px;max-width:640px;width:100%"/>$i$eFALSTAD"><$m$dfalstad"$f"$l$p$kno"$gborder:0;height:500px;max-height:90vh;width:100%"><$n$vsrc">https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c<$w><$u$t@cct">ct=$h@cct"/></$u><$q>tz=$h@ctz"/></$q></$w></$n></$m>$i$eFLICKR"><$r$dflickr"$g$c500px"><$r$g$a100%"><$m$f"$l$p$kno"$ohttps://www.flickr.com/photos/_/{@id}/player/"$g$b/></$r></$r>$i$eFOXNEWS"><$r$dfoxnews"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//video.foxnews.com/v/video-embed.html?video_id={@id}"$g$b/></$r></$r>$i$eFUNNYORDIE"><$r$dfunnyordie"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.funnyordie.com/embed/{@id}"$g$b/></$r></$r>$i$eGAMESPOT"><$r$dgamespot"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.gamespot.com/videos/embed/{@id}/"$g$b/></$r></$r>$i$eGETTY"><$r$dgetty"$g$c{@width}px"><$r><$n$v$y>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$o//embed.gettyimages.com/embed/{@id}?et={@et}&amp;tld=com&amp;sig={@sig}&amp;caption=false&amp;ver=1"$g$b/></$r></$r>$i$eGFYCAT"><$r$dgfycat"$g$c{@width}px"><$r><$n$v$y>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*(@height+44)div@width"/>%;padding-bottom:calc($h100*@height div@width"/>% + 44px)</xsl:if></$n><$m$f"$l$p$kno"$o//gfycat.com/ifr/{@id}?hd=1"$g$b/></$r></$r>$i$eGIFS"><$r$dgifs"$g$c{@width}px"><$r><$n$v$y>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$o//gifs.com/embed/{@id}"$g$b/></$r></$r>$i$eGIPHY"><$r$dgiphy"$g$c{@width}px"><$r><$n$v$y>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$g$b><$n$vsrc">//giphy.com/embed/$h@id"/><xsl:if$t@type=\\\'video\\\'">/video</xsl:if></$n></$m></$r></$r>$i$eGIST"><$m$dgist"$f"$s$y$l$p onload="$j$k"$ohttps://s9e.github.io/$m/2/gist.min.html#{@id}"$gborder:0;height:180px;width:100%"/>$i$eGLOBALNEWS"><$r$dglobalnews"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//globalnews.ca/video/embed/{@id}/"$g$b/></$r></$r>$i$eGOFUNDME"><$r$dgofundme"$g$c349px"><$r$g$a118.911175%;padding-bottom:calc(59.312321% + 208px)"><$m$f"$l$p$kno"$o//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund={@id}&amp;image=1&amp;coinfo=1"$g$b/></$r></$r>$i$eGOOGLEDRIVE"><$r$dgoogledrive"$g$c640px"><$r$g$a75%"><$m$f"$l$p$kno"$o//drive.google.com/file/d/{@id}/preview"$g$b/></$r></$r>$i$eGOOGLEPLUS"><$m$dgoogleplus"$f"$s$y$l$p onload="$j$kno"$gborder:0;height:240px;max-width:450px;width:100%"><$n$vsrc">https://s9e.github.io/$m/2/googleplus.min.html#<$w><$u$t@oid">$h@oid"/></$u><$q>+$h@name"/></$q></$w>/posts/$h@pid"/></$n></$m>$i$eGOOGLESHEETS"><$w><$u$t@type=\\\'chart\\\'"><$r$dgooglesheets"$g$c600px"><$r$g$a62%"><$m$f"$l$p$kno"$ohttps://docs.google.com/spreadsheets/d/{@id}/pubchart?oid={@oid}&amp;format=interactive"$g$b/></$r></$r></$u><$q><$m$dgooglesheets"$f"$l$p$kno"$gborder:0;height:500px;resize:vertical;width:100%"><$n$vsrc">https://docs.google.com/spreadsheets/d/$h@id"/>/p<$w><$u$tstarts-with(@id,\\\'e/\\\')">ubhtml?widget=true&amp;headers=false</$u><$q>review</$q></$w>#gid=$h@gid"/></$n></$m></$q></$w>$i$eHUDL"><$r$dhudl"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//www.hudl.com/embed/<$w><$u$t@id">video/$h@id"/></$u><$q>athlete/$h@athlete"/>/highlights/$h@highlight"/></$q></$w></$n></$m></$r></$r>$i$eHULU"><$r$dhulu"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://secure.hulu.com/embed/{@id}"$g$b/></$r></$r>$i$eIGN"><$r$dign"$g$c468px"><$r$g$a56.196581%"><$m$f"$l$p$kno"$o//widgets.ign.com/video/embed/content.html?url={@id}"$g$b/></$r></$r>$i$eIMDB"><$r$dimdb"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&amp;width=640"$g$b/></$r></$r>$i$eIMGUR"><$m$dimgur"$f"$s$y$l$p onload="var c=new MessageChannel;c.port1.onmessage=function(e){{var d=e.data.split(\\\' \\\');style.height=d[0]+\\\'px\\\';style.width=d[1]+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'https://s9e.github.io\\\',[c.port2])"$kno"$gborder:0;height:400px;max-width:100%;width:542px"><$n$vsrc">https://s9e.github.io/$m/2/imgur.min.html#<xsl:if$t@type=\\\'album\\\'">a/</xsl:if>$h@id"/></$n></$m>$i$eINDIEGOGO"><$r$dindiegogo"$g$c222px"><$r$g$a200.45045%"><$m$f"$l$p$kno"$o//www.indiegogo.com/project/{@id}/embedded"$g$b/></$r></$r>$i$eINSTAGRAM"><$m$dinstagram"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/instagram.min.html#{@id}"$gbackground:url(https://www.instagram.com/static/images/ico/favicon.svg/fc72dd4bfde8.svg) no-repeat 50% 50% / 50%;border:0;height:540px;max-width:540px;width:100%"/>$i$eINTERNETARCHIVE"><$w><$u$tcontains(@id,\\\'playlist=1\\\')"><$m$dinternetarchive"$f"$l$p$kno"$ohttps://archive.org/embed/{@id}&amp;list_height=150"$gborder:0;height:170px;max-width:640px;width:100%"/></$u><$q><$r$dinternetarchive"$g$c{@width}px"><$r><$n$v$y>display:block;overflow:hidden;position:relative;<xsl:if$t@width&gt;0">padding-bottom:$h100*@height div@width"/>%</xsl:if></$n><$m$f"$l$p$kno"$ohttps://archive.org/embed/{@id}"$g$b/></$r></$r></$q></$w>$i$eIZLESENE"><$r$dizlesene"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.izlesene.com/embedplayer/{@id}?autoplay=0"$g$b/></$r></$r>$i$eJSFIDDLE"><$m$djsfiddle"$f"$l$p$kno"$o//jsfiddle.net/{@id}/{@revision}/embedded/{$MEDIAEMBED_THEME}/"$gborder:0;height:400px;width:100%"/>$i$eJWPLATFORM"><$r$djwplatform"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//content.jwplatform.com/players/{@id}.html"$g$b/></$r></$r>$i$eKALTURA"><$r$dkaltura"$g$c640px"><$r$g$a61.875%;padding-bottom:calc(56.25% + 36px)"><$m$f"$l$p$kno"$g$b><$n$vsrc">https://cdnapisec.kaltura.com/p/$h@partner_id"/>/sp/<$w><$u$t@sp">$h@sp"/></$u><$q>$h@partner_id"/>00</$q></$w>/embedIframeJs/uiconf_id/$h@uiconf_id"/>/partner_id/$h@partner_id"/>?$membed=true&amp;entry_id=$h@entry_id"/></$n></$m></$r></$r>$i$eKHL"><$r$dkhl"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//video.khl.ru/$m/feed/start/{@id}?type_id=18&amp;width=560&amp;height=315"$g$b/></$r></$r>$i$eKICKSTARTER"><$r$dkickstarter"><$w><$u$t@video"><$n$v$y>$c640px</$n><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.kickstarter.com/projects/{@id}/widget/video.html"$g$b/></$r></$u><$q><$n$v$y>$c220px</$n><$r$g$a190.909091%"><$m$f"$l$p$kno"$o//www.kickstarter.com/projects/{@id}/widget/card.html"$g$b/></$r></$q></$w></$r>$i$eLIBSYN"><$m$dlibsyn"$f"$l$p$kno"$o//html5-player.libsyn.com/embed/episode/id/{@id}/thumbnail/no"$gborder:0;height:90px;max-width:900px;width:100%"/>$i$eLIVELEAK"><$r$dliveleak"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.liveleak.com/e/{@id}"$g$b/></$r></$r>$i$eLIVESTREAM"><$r$dlivestream"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//<$w><$u$t@clip_id">cdn.livestream.com/embed/$h@channel"/>?layout=4&amp;autoplay=false&amp;clip=$h@clip_id"/></$u><$q>livestream.com/accounts/$h@account_id"/>/events/$h@event_id"/><xsl:if$t@video_id">/videos/$h@video_id"/></xsl:if>/player?autoPlay=false</$q></$w></$n></$m></$r></$r>$i$eMAILRU"><$r$dmailru"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://my.mail.ru/video/embed/{@id}"$g$b/></$r></$r>$i$eMEDIUM"><$m$dmedium"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/medium.min.html#{@id}"$gborder:0;height:316px;max-width:900px;width:100%"/>$i$eMEGAPHONE"><$m$dmegaphone"$f"$l$p$kno"$gborder:0;height:200px;max-width:900px;width:100%"><$n$vsrc">https://player.megaphone.fm/$h@id"/><xsl:if$t$MEDIAEMBED_THEME=\\\'light\\\'">?light=true</xsl:if></$n></$m>$i$eMETACAFE"><$r$dmetacafe"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.metacafe.com/embed/{@id}/"$g$b/></$r></$r>$i$eMIXCLOUD"><$r$dmixcloud"$g$c400px"><$r$g$a100%"><$m$f"$l$p$kno"$o//www.mixcloud.com/widget/$m/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&amp;embed_type=widget_standard"$g$b/></$r></$r>$i$eMLB"><$r$dmlb"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.mlb.com/video/share/c-{@id}"$g$b/></$r></$r>$i$eMRCTV"><$r$dmrctv"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.mrctv.org/embed/{@id}"$g$b/></$r></$r>$i$eMSNBC"><$r$dmsnbc"$g$c640px"><$r><$w><$u$tcontains(@id,\\\'_\\\')"><$n$v$y>$a68.75%;padding-bottom:calc(56.25% + 80px)</$n><$m$f"$l$p$kno"$o//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid={@id}"$g$b/></$u><$q><$n$v$y>$a56.25%</$n><$m$f"$l$p$kno"$ohttps://www.msnbc.com/msnbc/embedded-video/{@id}"$g$b/></$q></$w></$r></$r>$i$eNATGEOCHANNEL"><$r$dnatgeochannel"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//channel.nationalgeographic.com/{@id}/embed/"$g$b/></$r></$r>$i$eNATGEOVIDEO"><$r$dnatgeovideo"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}"$g$b/></$r></$r>$i$eNBCNEWS"><$r$dnbcnews"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.nbcnews.com/widget/video-embed/{@id}"$g$b/></$r></$r>$i$eNBCSPORTS"><$r$dnbcsports"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl="$g$b/></$r></$r>$i$eNHL"><$r$dnhl"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">https://www.nhl.com/video/embed<xsl:if$t@t">/t-$h@t"/></xsl:if><xsl:if$t@c">/c-$h@c"/></xsl:if>?autostart=false</$n></$m></$r></$r>$i$eNPR"><$m$dnpr"$f"$l$p$kno"$o//www.npr.org/player/embed/{@i}/{@m}"$gborder:0;height:228px;max-width:800px;width:100%"/>$i$eNYTIMES"><$r$dnytimes"$g$c585px"><$r$g$a68.376068%"><$m$f"$l$p$kno"$o//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}"$g$b/></$r></$r>$i$eODYSEE"><$r$dodysee"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://odysee.com/$/embed/-/{@id}"$g$b/></$r></$r>$i$eORFIUM"><$m$dorfium"$f"$l$p$kno"><$n$vsrc">https://www.orfium.com/embedded/<$w><$u$t@album_id">album/$h@album_id"/></$u><$u$t@playlist_id">playlist/$h@playlist_id"/></$u><$u$t@set_id">live-set/$h@set_id"/></$u><$q>track/$h@track_id"/></$q></$w></$n><$n$v$y>border:0;height:<$w><$u$t@album_id">550</$u><$q>275</$q></$w>px;max-width:900px;width:100%</$n></$m>$i$ePASTEBIN"><$m$dpastebin"$f"$l$p$k"$o//pastebin.com/embed_$m.php?i={@id}"$gborder:0;height:300px;resize:vertical;width:100%"/>$i$ePINTEREST"><$m$dpinterest"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/pinterest.min.html#{@id}"><$n$v$y>border:0;height:360px;max-width:<$w><$u$tcontains(@id,\\\'/\\\')">730</$u><$q>345</$q></$w>px;width:100%</$n></$m>$i$ePODBEAN"><$m$dpodbean"$f"$l$p$kno"$ohttps://www.podbean.com/player-v2/?i={@id}"$gborder:0;height:150px;max-width:900px;width:100%"/>$i$ePREZI"><$r$dprezi"$g$c550px"><$r$g$a72.727273%"><$m$f"$l$p$kno"$o//prezi.com/embed/{@id}/"$g$b/></$r></$r>$i$eREDDIT"><$m$dreddit"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/reddit.min.html#{@id}{@path}"$gborder:0;height:165px;max-width:800px;width:100%"/>$i$eRUMBLE"><$r$drumble"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://rumble.com/embed/{@id}/"$g$b/></$r></$r>$i$eRUTUBE"><$r$drutube"$g$c720px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//rutube.ru/play/embed/{@id}"$g$b/></$r></$r>$i$eSCRIBD"><$m$dscribd"$f"$l$p$kno"$ohttps://www.scribd.com/embeds/{@id}/content?view_mode=scroll&amp;show_recommendations=false"$gborder:0;height:500px;resize:vertical;width:100%"/>$i$eSENDVID"><$r$dsendvid"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//sendvid.com/embed/{@id}"$g$b/></$r></$r>$i$eSLIDESHARE"><$r$dslideshare"$g$c427px"><$r$g$a83.372365%"><$m$f"$l$p$kno"$o//www.slideshare.net/slideshow/embed_code/{@id}"$g$b/></$r></$r>$i$eSOUNDCLOUD"><$m$dsoundcloud"$f"$l$p$kno"><$n$vsrc">https://w.soundcloud.com/player/?url=<$w><$u$t@playlist_id">https%3A//api.soundcloud.com/playlists/$h@playlist_id"/></$u><$u$t@track_id">https%3A//api.soundcloud.com/tracks/$h@track_id"/>&amp;secret_token=$h@secret_token"/></$u><$q><xsl:if$tnot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</xsl:if>$h@id"/></$q></$w></$n><$n$v$y>border:0;height:<$w><$u$t@playlist_id or contains(@id,\\\'/sets/\\\')">450</$u><$q>166</$q></$w>px;max-width:900px;width:100%</$n></$m>$i$eSPORCLE"><$m$dsporcle"$f"$s$y$l$p onload="var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\\\'px\\\'}};contentWindow.postMessage(\\\'s9e:init\\\',\\\'*\\\',[c.port2])"$kno"$ohttps://s9e.github.io/$m/2/sporcle.min.html#{@id}"$gborder:0;height:535px;max-width:820px;width:100%"/>$i$eSPORTSNET"><$r$dsportsnet"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId={@id}"$g$b/></$r></$r>$i$eSPOTIFY"><$w><$u$tstarts-with(@id,\\\'episode/\\\')or starts-with(@id,\\\'show/\\\')"><$m$dspotify" allow="encrypted-media"$f"$l$p$kno"$ohttps://open.spotify.com/embed/{@id}"$gborder:0;height:152px;max-width:900px;width:100%"/></$u><$q><$r$dspotify"$g$c320px"><$r$g$a125%;padding-bottom:calc(100% + 80px)"><$m allow="encrypted-media"$f"$l$p$kno"$ohttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"$g$b/></$r></$r></$q></$w>$i$eSPREAKER"><$m$dspreaker"$f"$l$p$kno"$ohttps://widget.spreaker.com/player?episode_id={@episode_id}&amp;show_id={@show_id}&amp;theme={$MEDIAEMBED_THEME}"$gborder:0;height:{400-200*boolean(@episode_id)}px;max-width:900px;width:100%"/>$i$eSTEAMSTORE"><$m$dsteamstore"$f"$l$p$kno"$o//store.steampowered.com/widget/{@id}"$gborder:0;height:190px;max-width:900px;width:100%"/>$i$eSTITCHER"><$m$dstitcher"$f"$l$p$kno"$ohttps://www.stitcher.com/embed/{@fid}/{@eid}"$gborder:0;height:150px;max-width:900px;width:100%"/>$i$eSTRAWPOLL"><$r$dstrawpoll"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$k"$o//www.strawpoll.me/embed_1/{@id}"$g$b/></$r></$r>$i$eSTREAMABLE"><$r$dstreamable"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//streamable.com/e/{@id}"$g$b/></$r></$r>$i$eSTREAMJA"><$r$dstreamja"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://streamja.com/embed/{@id}"$g$b/></$r></$r>$i$eTEAMCOCO"><$r$dteamcoco"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//teamcoco.com/embed/v/{@id}"$g$b/></$r></$r>$i$eTED"><$r$dted"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//embed.ted.com/$h@id"/><xsl:if$tnot(contains(@id,\\\'.html\\\'))">.html</xsl:if></$n></$m></$r></$r>$i$eTELEGRAM"><$m$dtelegram"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/telegram.min.html#{@id}"$gborder:0;height:96px;max-width:500px;width:100%"/>$i$eTHEATLANTIC"><$r$dtheatlantic"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.theatlantic.com/video/$m/{@id}/"$g$b/></$r></$r>$i$eTHEGUARDIAN"><$r$dtheguardian"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//embed.theguardian.com/embed/video/{@id}"$g$b/></$r></$r>$i$eTHEONION"><$r$dtheonion"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.theonion.com/video_embed/?id={@id}"$g$b/></$r></$r>$i$eTIKTOK"><$r$dtiktok"$g$c340px"><$r$g$a205.882353%"><$m$f"$l$p$kno"$o//www.tiktok.com/embed/{@id}"$g$b/></$r></$r>$i$eTMZ"><$r$dtmz"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}"$g$b/></$r></$r>$i$eTRADINGVIEW"><$m$dtradingview"$f"$l$p$kno"$gborder:0;height:400px;width:100%"><$n$vsrc">https://s.tradingview.com/<$w><$u$t@symbol">widgetembed/?interval=D&amp;symbol=$htranslate(@symbol,\\\'-\\\',\\\':\\\')"/></$u><$q>embed/$h@chart"/></$q></$w></$n></$m>$i$eTRAILERADDICT"><$r$dtraileraddict"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//v.traileraddict.com/{@id}"$g$b/></$r></$r>$i$eTRENDINGVIEWS"><$r$dtrendingviews"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://mydailyfreedom.com/tv/embed/{@id}"$g$b/></$r></$r>$i$eTUMBLR"><$m$dtumblr"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/tumblr.min.html#{@key}/{@id}"$gborder:0;height:300px;max-width:520px;width:100%"/>$i$eTWENTYFOURSEVENSPORTS"><$w><$u$t@video_id"><$r$dtwentyfoursevensports"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.cbssports.com/video/player/embed?args=player_id%3D{@video_id}%26channel%3Dmobilevideo%26pcid%3D{@video_id}%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue"$g$b/></$r></$r></$u><$q><$m$dtwentyfoursevensports"$f"$l$p onload="window.addEventListener(\\\'message\\\',function(e){{if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\\\'px\\\'}})"$kno"$ohttps://247sports.com/PlayerSport/{@player_id}/Embed/"$gborder:0;height:200px;max-width:600px;width:100%"/></$q></$w>$i$eTWITCH"><$r$dtwitch"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p onload="contentWindow.postMessage(\\\'\\\',\\\'https://s9e.github.io\\\')"$kno"$ohttps://s9e.github.io/$m/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$g$b/></$r></$r>$i$eTWITTER"><$m$dtwitter" allow="autoplay *"$f"$s$y$l$p onload="$j$kno"$ohttps://s9e.github.io/$m/2/twitter.min.html#{@id}{$MEDIAEMBED_THEME}"$gborder:0;height:250px;max-width:550px;width:100%"/>$i$eUSTREAM"><$r$dustream"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//www.ustream.tv/embed/<$w><$u$t@vid">recorded/$h@vid"/></$u><$q>$h@cid"/></$q></$w>?html5ui</$n></$m></$r></$r>$i$eVBOX7"><$r$dvbox7"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//vbox7.com/emb/external.php?vid={@id}"$g$b/></$r></$r>$i$eVEOH"><$r$dveoh"$g$c640px"><$r$g$a62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v{@id}&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous"$g$x type="application/x-shockwave-flash" typemustmatch="">$z</object></$r></$r>$i$eVEVO"><$r$dvevo"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://embed.vevo.com/?isrc={@id}"$g$b/></$r></$r>$i$eVIDEODETECTIVE"><$r$dvideodetective"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid={@id}"$g$b/></$r></$r>$i$eVIMEO"><$r$dvimeo"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$g$b><$n$vsrc">//player.vimeo.com/video/$h@id"/><xsl:if$t@t">#t=$h@t"/></xsl:if></$n></$m></$r></$r>$i$eVINE"><$r$dvine"$g$c480px"><$r$g$a100%"><$m$f"$l$p$kno"$ohttps://vine.co/v/{@id}/embed/simple?audio=1"$g$b/></$r></$r>$i$eVK"><$r$dvk"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//vk.com/video_ext.php?oid={@oid}&amp;id={@vid}&amp;hash={@hash}&amp;hd=1"$g$b/></$r></$r>$i$eVOCAROO"><$r$dvocaroo"><$w><$u$tstarts-with(@id,\\\'s0\\\')or starts-with(@id,\\\'s1\\\')"><$n$v$y>$c148px</$n><$r$g$a29.72973%"><object data="//vocaroo.com/player.swf?playMediaID={@id}&amp;autoplay=0"$g$x type="application/x-shockwave-flash" typemustmatch="">$z</object></$r></$u><$q><$n$v$y>$c300px</$n><$r$g$a20%"><$m$f"$l$p$kno"$ohttps://vocaroo.com/embed/{@id}"$g$b/></$r></$q></$w></$r>$i$eVOX"><$r$dvox"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//player.ooyala.com/$m.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec={@id}"$g$b/></$r></$r>$i$eWASHINGTONPOST"><$r$dwashingtonpost"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//www.washingtonpost.com/video/c/embed/{@id}"$g$b/></$r></$r>$i$eWISTIA"><$w><$u$t@type=\\\'audio\\\'"><$m$dwistia"$f"$l$p$kno"$ohttps://fast.wistia.net/embed/$m/{@id}"$gborder:0;height:218px;max-width:900px;width:100%"/></$u><$q><$r$dwistia"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://fast.wistia.net/embed/$m/{@id}"$g$b/></$r></$r></$q></$w>$i$eWSHH"><$r$dwshh"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//worldstarhiphop.com/embed/{@id}"$g$b/></$r></$r>$i$eWSJ"><$r$dwsj"$g$c512px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//video-api.wsj.com/api-video/player/$m.html?guid={@id}"$g$b/></$r></$r>$i$eXBOXCLIPS"><$r$dxboxclips"$g$c560px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//gameclips.io/{@user}/{@id}/embed"$g$b/></$r></$r>$i$eXBOXDVR"><$r$dxboxdvr"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//gamerdvr.com/gamer/{@user}/video/{@id}/embed"$g$b/></$r></$r>$i$eYOUKU"><$r$dyouku"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$o//player.youku.com/embed/{@id}"$g$b/></$r></$r>$i$eYOUMAKER"><$r$dyoumaker"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$ohttps://www.youmaker.com/embed/{@id}"$g$b/></$r></$r>$i$eYOUTUBE"><$r$dyoutube"$g$c640px"><$r$g$a56.25%"><$m$f"$l$p$kno"$gbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$b><$n$vsrc">https://www.youtube.com/embed/$h@id"/><xsl:if$t@list">?list=$h@list"/></xsl:if><xsl:if$t@t"><$w><$u$t@list">&amp;</$u><$q>?</$q></$w>start=$h@t"/></xsl:if></$n></$m></$r></$r>$i$ebr"><br/>$i$ee|i|s"/>$ep"><p><xsl:apply-templates/></p>$i</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$c:"display:inline-block;width:100%;max-width:",$d:\' data-s9e-mediaembed="\',$e:\'<xsl:template match="\',$f:\' allowfullscreen="\',$g:\' style="\',$h:\'<xsl:value-of select="\',$i:"</xsl:template>",$j:"var c=new MessageChannel;c.port1.onmessage=function(e){{style.height=e.data+\'px\'}};contentWindow.postMessage(\'s9e:init\',\'https://s9e.github.io\',[c.port2])\\"",
$k:\' scrolling="\',$l:\' loading="\',$m:"iframe",$n:"xsl:attribute",$o:\' src="\',$p:\'lazy"\',$q:"xsl:otherwise",$r:"span",$s:\' data-s9e-livepreview-ignore-attrs="\',$t:\' test="\',$u:"xsl:when",$v:\' name="\',$w:"xsl:choose",$x:\'height:100%;left:0;position:absolute;width:100%"\',$y:\'style"\',$z:\'<param name="allowfullscreen" value="true"/>\'}[a]});function Ja(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"};return a.replace(/[<>&"]/g,function(d){return b[d]})}
function Ka(a){var b={"<":"&lt;",">":"&gt;","&":"&amp;"};return a.replace(/[<>&]/g,function(d){return b[d]})}function La(){this.o={};this.r=[]}La.prototype.add=function(a,b,d){d=d||{};"attrName"in d||!this.k||(d.attrName=this.k);"tag"in d||!this.l||(d.tag=this.l);this.o[a]&&this.o[a].forEach(function(g){g(b,d)});this.r.push([a,b,d])};La.prototype.getLogs=function(){return this.r};La.prototype.on=function(a,b){this.o[a].push(b)};function Ma(a,b){D.add("debug",a,b)}
function J(a,b,d,g,q){this.p=+a;this.name=b;this.k=+d;this.l=+g;this.w=+q||0;this.b={};this.y=[];isNaN(a+d+g)&&E(this)}J.prototype.o=!1;function E(a){a.o||(a.o=!0,a.y.forEach(function(b){E(b)}))}function Na(a,b){Oa(a,b)?(a.u=b,b.r=a,a.y.push(b),a.o&&E(b)):Oa(b,a)&&(a.r=b,b.u=a)}function Oa(a,b){return a.name===b.name&&1===a.p&&2===b.p&&a.k<=a.k}function Pa(a){var b={},d;for(d in a.b)b[d]=a.b[d];return b}function Qa(a,b){return a.o||!Oa(b,a)||a.r&&a.r!==b||b.u&&b.u!==a?!1:!0}
function Ca(a,b){a.b={};for(var d in b)a.b[d]=b[d]}
var K,Ra,L,M,N,Sa,D=new La,O,P,R={MediaEmbed:{F:function(a,b){b.forEach(function(d){var g=d[0][0];Q(3,"MEDIA",d[0][1],g.length,-10).b.url=g})},A:"://",B:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,C:5E4}},S,Ta={"MediaEmbed.hosts":{"247sports.com":"twentyfoursevensports","8tracks.com":"eighttracks","abcnews.go.com":"abcnews","acast.com":"acast","amazon.ca":"amazon","amazon.co.jp":"amazon","amazon.co.uk":"amazon","amazon.com":"amazon","amazon.de":"amazon","amazon.es":"amazon","amazon.fr":"amazon","amazon.in":"amazon",
"amazon.it":"amazon","anchor.fm":"anchor","archive.org":"internetarchive","audioboo.fm":"audioboom","audioboom.com":"audioboom","audiomack.com":"audiomack","audius.co":"audius","bandcamp.com":"bandcamp","bbc.co.uk":"bbcnews","bbc.com":"bbcnews","bitchute.com":"bitchute","bleacherreport.com":"bleacherreport","castos.com":"castos","cbsnews.com":"cbsnews","cc.com":"comedycentral","channel.nationalgeographic.com":"natgeochannel","clyp.it":"clyp","cnbc.com":"cnbc","cnn.com":"cnn","codepen.io":"codepen",
"comedycentral.com":"comedycentral","coub.com":"coub","dai.ly":"dailymotion","dailymotion.com":"dailymotion","democracynow.org":"democracynow","docs.google.com":"googlesheets","drive.google.com":"googledrive","dumpert.nl":"dumpert","espn.com":"espn","espn.go.com":"espn","facebook.com":"facebook","falstad.com":"falstad","fb.watch":"facebook","flic.kr":"flickr","flickr.com":"flickr","funnyordie.com":"funnyordie","gameclips.io":"xboxclips","gamerdvr.com":"xboxdvr","gamespot.com":"gamespot","gettyimages.be":"getty",
"gettyimages.cn":"getty","gettyimages.co.jp":"getty","gettyimages.co.uk":"getty","gettyimages.com":"getty","gettyimages.com.au":"getty","gettyimages.de":"getty","gettyimages.dk":"getty","gettyimages.es":"getty","gettyimages.fr":"getty","gettyimages.ie":"getty","gettyimages.it":"getty","gettyimages.nl":"getty","gettyimages.pt":"getty","gettyimages.se":"getty","gfycat.com":"gfycat","gifs.com":"gifs","giphy.com":"giphy","github.com":"gist","globalnews.ca":"globalnews","gofundme.com":"gofundme","gty.im":"getty",
"hudl.com":"hudl","hulu.com":"hulu","ign.com":"ign","imdb.com":"imdb","imgur.com":"imgur","indiegogo.com":"indiegogo","instagram.com":"instagram","izlesene.com":"izlesene","jsfiddle.net":"jsfiddle","jwplatform.com":"jwplatform","kaltura.com":"kaltura","kickstarter.com":"kickstarter","libsyn.com":"libsyn","link.brightcove.com":"brightcove","link.tospotify.com":"spotify","liveleak.com":"liveleak","livestre.am":"livestream","livestream.com":"livestream","medium.com":"medium","megaphone.fm":"megaphone",
"megaphone.link":"megaphone","metacafe.com":"metacafe","mixcloud.com":"mixcloud","mlb.com":"mlb","money.cnn.com":"cnnmoney","mrctv.org":"mrctv","msnbc.com":"msnbc","my.mail.ru":"mailru","mydailyfreedom.com":"trendingviews","n.pr":"npr","nbcnews.com":"nbcnews","nbcsports.com":"nbcsports","nhl.com":"nhl","npr.org":"npr","nytimes.com":"nytimes","odysee.com":"odysee","open.spotify.com":"spotify","orfium.com":"orfium","pastebin.com":"pastebin","pinterest.com":"pinterest","play.spotify.com":"spotify","players.brightcove.net":"brightcove",
"plus.google.com":"googleplus","podbean.com":"podbean","podcasts.apple.com":"applepodcasts","prezi.com":"prezi","reddit.com":"reddit","rumble.com":"rumble","rutube.ru":"rutube","scribd.com":"scribd","sendvid.com":"sendvid","slideshare.net":"slideshare","soundcloud.com":"soundcloud","sporcle.com":"sporcle","sportsnet.ca":"sportsnet","spreaker.com":"spreaker","stitcher.com":"stitcher","store.steampowered.com":"steamstore","strawpoll.me":"strawpoll","streamable.com":"streamable","streamja.com":"streamja",
"t.me":"telegram","teamcoco.com":"teamcoco","ted.com":"ted","theatlantic.com":"theatlantic","theguardian.com":"theguardian","theonion.com":"theonion","tiktok.com":"tiktok","tmz.com":"tmz","tradingview.com":"tradingview","traileraddict.com":"traileraddict","trendingviews.co":"trendingviews","tumblr.com":"tumblr","twitch.tv":"twitch","twitter.com":"twitter","ustream.tv":"ustream","vbox7.com":"vbox7","veoh.com":"veoh","vevo.com":"vevo","video.foxnews.com":"foxnews","video.khl.ru":"khl","video.nationalgeographic.com":"natgeovideo",
"videodetective.com":"videodetective","vimeo.com":"vimeo","vine.co":"vine","vk.com":"vk","vkontakte.ru":"vk","voca.ro":"vocaroo","vocaroo.com":"vocaroo","vox.com":"vox","washingtonpost.com":"washingtonpost","wistia.com":"wistia","worldstar.com":"wshh","worldstarhiphop.com":"wshh","wsj.com":"wsj","xboxclips.com":"xboxclips","xboxdvr.com":"xboxdvr","youku.com":"youku","youmaker.com":"youmaker","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{abcnews:[[[/abcnews\\.go\\.com\\/(?:video\\/embed\\?id=|[^\\/]+\\/video\\/[^\\/]+-)(\\d+)/,
n]],[]],acast:[[[/play\\.acast\\.com\\/s\\/([-.\\w]+)\\/([-.\\w]+)(?:\\?seek=(\\d+))?/,sa],[/shows\\.acast\\.com\\/([-.\\w]+)\\/episodes\\/([-.\\w]+)(?:\\?seek=(\\d+))?/,sa]],[{a:[[/"showId":"([-0-9a-f]+)/,ca],[/"id":"([-0-9a-f]+)/,ja]],match:[[/play\\.acast\\.com\\/s\\/[-.\\w]+\\/./,c],[/shows\\.acast\\.com\\/[-.\\w]+\\/episodes\\/./,c]],n:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}"}]],amazon:[[[/\\/(?:dp|gp\\/product)\\/([A-Z0-9]+)/,n],[/amazon\\.(?:co\\.)?(ca|de|es|fr|in|it|jp|uk)/,["","tld"]]],[]],
anchor:[[[/anchor.fm\\/(?:[-\\w]+\\/)*episodes\\/(?:[-\\w]+-)(\\w+)(?![-\\w])/,n]],[]],applepodcasts:[[[/podcasts\\.apple\\.com\\/(\\w+)\\/podcast\\/[-\\w]*\\/id(\\d+)(?:\\?i=(\\d+))?/,["","country","podcast_id","episode_id"]]],[]],audioboom:[[[/audioboo(?:\\.f|m\\.co)m\\/(?:boo|post)s\\/(\\d+)/,n]],[]],audiomack:[[[/audiomack\\.com\\/(album|song)\\/([-\\w]+)\\/([-\\w]+)/,["","mode","artist","title"]],[/audiomack\\.com\\/([-\\w]+)\\/(album|song)\\/([-\\w]+)/,["","artist","mode","title"]]],[]],audius:[[],[{a:[[ma,w]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/(?!album\\/|playlist\\/)([%\\-.\\w]+)/,
ka]],n:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}"},{a:[[ma,z]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/album\\/([%\\-.\\w]+)/,ka]],n:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}"},{a:[[ma,la]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/playlist\\/([%\\-.\\w]+)/,ka]],n:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}"}]],bandcamp:[[],[{a:[[/\\/album=(\\d+)/,
z]],match:[[/bandcamp\\.com\\/album\\/./,c]]},{a:[[/"album_id":(\\d+)/,z],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,w]],match:[[/bandcamp\\.com\\/track\\/./,c]]}]],bbcnews:[[[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/(?:\\w+-)+(\\d+)/,n],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/embed\\/(\\w+\\/\\d+)/,n],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/\\w+\\/(\\d+)/,n],[/bbc\\.co(?:m|\\.uk)\\/news\\/av-embeds\\/(\\d+)/,n]],[]],bitchute:[[[/bitchute\\.com\\/(?:embed|video)\\/([-\\w]+)/,n]],
[]],bleacherreport:[[],[{a:[[/id="video-([-\\w]+)/,n],[/video_embed\\?id=([-\\w]+)/,n]],match:[[/\\/articles\\/./,c]]}]],brightcove:[[[/link\\.brightcove\\.com\\/services\\/player\\/bcpid(\\d+).*?bckey=([-,~\\w]+).*?bctid=(\\d+)/,["","bcpid","bckey","bctid"]],[/players\\.brightcove\\.net\\/(\\d+)\\/.*?videoId=(\\d+)/,["","bcpid","bctid"]]],[]],castos:[wa,[{a:wa,match:[[/castos\\.com\\/(?:podcasts\\/[^\\/]*\\/)?episodes\\/./,c]]}]],cbsnews:[[[/cbsnews\\.com\\/videos?\\/(?!watch\\/)([-\\w]+)/,n],[/cbsnews\\.com\\/video\\/watch\\/\\?id=(\\d+)/,
n]],[]],clyp:[[[/clyp\\.it\\/(?!user\\/)(\\w+)/,n]],[]],cnbc:[[[/cnbc\\.com\\/gallery\\/\\?video=(\\d+)/,n]],[{a:[[/byGuid=(\\d+)/,n]],match:[[/cnbc\\.com\\/video\\/20\\d\\d\\/\\d\\d\\/\\d\\d\\/\\w/,c]]}]],cnn:[[[/cnn.com\\/videos\\/(.*\\.cnn)/,n],[/cnn\\.com\\/video\\/data\\/2\\.0\\/video\\/(.*\\.cnn)/,n]],[]],cnnmoney:[[[/money\\.cnn\\.com\\/video\\/(.*\\.cnnmoney)/,n]],[]],codepen:[[[/codepen\\.io\\/([-\\w]+)\\/(?:details|embed|full|live|pen)\\/(\\w+)/,ea]],[]],comedycentral:[[],[{a:[[/(mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)/,n]],match:[[/c(?:c|omedycentral)\\.com\\/(?:full-episode|video-clip)s\\//,
c]]}]],coub:[[[/coub\\.com\\/view\\/(\\w+)/,n]],[]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,n],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,n],[/start=(\\d+)/,f]],[]],democracynow:[[[/democracynow.org\\/(?:embed\\/)?((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)/,n]],[{a:[[/democracynow\\.org\\/((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)\' rel=\'canonical/,n]],match:[[/m\\.democracynow\\.org\\/stories\\/\\d/,c]]}]],dumpert:[[[/dumpert\\.nl\\/(?:item|mediabase)\\/(\\d+[\\/_]\\w+)/,n]],[]],
eighttracks:[[[/8tracks\\.com\\/[-\\w]+\\/(\\d+)(?=#|$)/,n]],[{a:[[/eighttracks:\\/\\/mix\\/(\\d+)/,n]],match:[[/8tracks\\.com\\/[-\\w]+\\/\\D/,c]]}]],espn:[[[/video\\/(?:clip(?:\\?id=|\\/_\\/id\\/))?(\\d+)/,n]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,n],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,r],[/facebook\\.com\\/watch\\/\\?([pv])=/,
r],[/facebook.com\\/groups\\/[^\\/]*\\/(p)osts\\/(\\d+)/,fa]],[{a:[[/facebook\\.com\\/watch\\/\\?(v)=(\\d+)/,fa],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/(\\d+)/,["","user","type","id"]]],q:"User-agent: PHP (not Mozilla)",match:[[/fb\\.watch\\/./,c]]}]],falstad:[[[/falstad\\.com\\/circuit\\/circuitjs\\.html\\?c(?:ct=([^&]+)|tz=([-+=\\w]+))/,["","cct","ctz"]]],[]],flickr:[[va,[/flic\\.kr\\/(?!p\\/)[^\\/]+\\/(\\d+)/,n]],[{a:[va],match:[[/flic\\.kr\\/p\\/(\\w+)/,["","short"]]],n:"https://www.flickr.com/photo.gne?rb=1&short={@short}"}]],
foxnews:[[[/video\\.foxnews\\.com\\/v\\/(\\d+)/,n]],[]],funnyordie:[[[/funnyordie\\.com\\/videos\\/([0-9a-f]+)/,n]],[]],gamespot:[[[/gamespot\\.com.*?\\/(?:events|videos)\\/.*?-(\\d+)\\/(?:[#?].*)?$/,n]],[]],getty:[[[/gty\\.im\\/(\\d+)/,n],[/gettyimages\\.[.\\w]+\\/detail(?=\\/).*?\\/(\\d+)/,n],[/#[-\\w]*picture-id(\\d+)$/,n]],[{a:[[/"height":[ "]*(\\d+)/,v],[/"width":[ "]*(\\d+)/,t],[/\\bid[=:][\'"]?([-=\\w]+)/,["","et"]],[/\\bsig[=:][\'"]?([-=\\w]+)/,["","sig"]]],match:B,n:"https://embed.gettyimages.com/preview/{@id}"}]],gfycat:[[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?(\\w+)/,
n]],[{a:[[/\\/ifr\\/(\\w+)/,n]],match:[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?[a-z]/,c]],n:"https://gfycat.com/ifr/{@id}"},{a:[[/"height":(\\d+)/,v],[/"width":(\\d+)/,t]],match:B,n:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}"}]],gifs:[[[/gifs\\.com\\/(?:gif\\/)?(\\w+)/,n]],[{a:[[/meta property="og:image:width" content="(\\d+)/,t],[/meta property="og:image:height" content="(\\d+)/,v]],match:B,n:"https://gifs.com/gif/{@id}"}]],giphy:[[[/giphy\\.com\\/(gif|video|webp)\\w+\\/(?:[-\\w]+-)*(\\w+)/,
fa],[/giphy\\.com\\/media\\/(\\w+)\\/\\w+\\.(gif|webp)/,ha],[/i\\.giphy\\.com\\/(\\w+)\\.(gif|webp)/,ha]],[{a:[[/"height"\\s*:\\s*(\\d+)/,v],[/"width"\\s*:\\s*(\\d+)/,t]],match:B,n:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif"}]],gist:[[[/gist\\.github\\.com\\/((?:[-\\w]+\\/)?[\\da-f]+(?:\\/[\\da-f]+)?\\b(?!\\/archive))/,n]],[]],globalnews:[ta,[{a:ta,match:[[/globalnews\\.ca\\/video\\/rd\\//,c]]}]],gofundme:[[[/gofundme\\.com\\/(\\w+)(?![^#?])/,n]],[]],googledrive:[[[/drive\\.google\\.com\\/.*?(?:file\\/d\\/|id=)([-\\w]+)/,
n]],[]],googleplus:[[[/\\/\\/plus\\.google\\.com\\/(?:u\\/\\d+\\/)?(?:\\+([^\\/]+)|(\\d+))\\/posts\\/(\\w+)/,["","name","oid","pid"]]],[]],googlesheets:[[[/docs\\.google\\.com\\/spreadsheet(?:\\/ccc\\?key=|(?:[^e]\\/)+)((?:e\\/)?[-\\w]+)/,n],[/oid=(\\d+)/,["","oid"]],[/#gid=(\\d+)/,["","gid"]],[/\\/pub(chart)/,r]],[]],hudl:[[[/hudl\\.com\\/athlete\\/(\\d+)\\/highlights\\/([\\da-f]+)/,pa],ya,ua],[{a:[ya,ua],match:[[/hudl\\.com\\/v\\//,c]]}]],hulu:[[],[{a:[[/eid=([-\\w]+)/,n]],match:[[/hulu\\.com\\/watch\\//,c]]}]],ign:[[[/(https?:\\/\\/.*?ign\\.com\\/videos\\/.+)/i,
n]],[]],imdb:[[],[{a:[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)\\/[\\/\\w]*embed/,n]],match:[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)/,n]],n:"https://www.imdb.com/video/imdb/vi{@id}/imdb/embed"}]],imgur:[[[/imgur\\.com\\/(a\\/\\w+)/,n],[/i\\.imgur\\.com\\/(\\w{5,7})[lms]?\\./,n],[/imgur\\.com\\/(\\w+)(?![\\w.\\/])/,n]],[{a:[[/data-id="([\\w\\/]+)"/,n]],match:[[/imgur\\.com\\/(?![art]\\/|user\\/)((?:gallery\\/)?\\w+)(?![\\w.])/,["","path"]]],n:"https://api.imgur.com/oembed.xml?url=/{@path}"}]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,n]],
[]],instagram:[[[/instagram\\.com\\/(?:p|reel|tv)\\/([-\\w]+)/,n]],[]],internetarchive:[[],[{a:[[/meta property="twitter:player" content="https:\\/\\/archive.org\\/embed\\/([^\\/"]+)/,n],[/meta property="og:video:width" content="(\\d+)/,t],[/meta property="og:video:height" content="(\\d+)/,v]],match:[[/archive\\.org\\/(?:details|embed)\\//,c]]}]],izlesene:[[[/izlesene\\.com\\/video\\/[-\\w]+\\/(\\d+)/,n]],[]],jsfiddle:[[[/jsfiddle.net\\/(?:(\\w+)\\/)?(?!\\d+\\b|embedded\\b|show\\b)(\\w+)\\b(?:\\/(\\d+)\\b)?/,["","user","id","revision"]]],
[]],jwplatform:[[[/jwplatform\\.com\\/\\w+\\/([-\\w]+)/,n]],[]],kaltura:[[[/\\/p(?:artner_id)?\\/(\\d+)\\//,["","partner_id"]],[/\\/sp\\/(\\d+)\\//,["","sp"]],[/\\/uiconf_id\\/(\\d+)\\//,["","uiconf_id"]],[/\\bentry_id[=\\/](\\w+)/,["","entry_id"]]],[{a:[[/kaltura\\.com\\/+p\\/(\\d+)\\/sp\\/(\\d+)\\/\\w*\\/uiconf_id\\/(\\d+)\\/.*?\\bentry_id=(\\w+)/,["","partner_id","sp","uiconf_id","entry_id"]]],match:[[/kaltura\\.com\\/(?:media\\/t|tiny)\\/./,c]]}]],khl:[[],[{a:[[/\\/feed\\/start\\/([\\/\\w]+)/,n]],match:[[/video\\.khl\\.ru\\/(?:event|quote)s\\/\\d/,
c]]}]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],libsyn:[[],[{a:[[/embed\\/episode\\/id\\/(\\d+)/,n]],match:[[/(?!\\.mp3)....$/,c]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,n]],[{a:[[/liveleak\\.com\\/e\\/(\\w+)/,n]],match:[[/liveleak\\.com\\/view\\?t=/,c]]}]],livestream:[[[/livestream\\.com\\/accounts\\/(\\d+)\\/events\\/(\\d+)/,qa],[/\\/videos\\/(\\d+)/,da],[/original\\.livestream\\.com\\/(\\w+)\\/video\\?clipId=([-\\w]+)/,oa]],
[{a:[[/accounts\\/(\\d+)\\/events\\/(\\d+)/,qa]],match:[[/livestream\\.com\\/(?!accounts\\/\\d+\\/events\\/\\d)/,c]]},{a:[[/\\/\\/original\\.livestream\\.com\\/(\\w+)\\/video\\/([-\\w]+)/,oa]],match:[[/livestre.am/,c]]}]],mailru:[[],[{a:[[/"itemId": ?"?(\\d+)/,n]],match:[[/my\\.mail\\.ru\\/\\w+\\/\\w+\\/video\\/\\w+\\/\\d/,c]]}]],medium:[[[/medium\\.com\\/(?:s\\/\\w+\\/|@?[-\\w]+\\/)?(?:\\w+-)*([0-9a-f]+)(?!\\w)/,n]],[]],megaphone:[[[/megaphone\\.fm\\/.*?\\?(?:e|selected)=(\\w+)/,n],[/(?:dcs|player|traffic)\\.megaphone\\.fm\\/(\\w+)/,n],[/megaphone\\.link\\/(\\w+)/,
n]],[]],metacafe:[[[/metacafe\\.com\\/watch\\/(\\d+)/,n]],[]],mixcloud:[[[/mixcloud\\.com\\/(?!categories|tag)([-\\w]+\\/[^\\/&]+)\\//,n]],[]],mlb:[[[/mlb\\.com\\/video\\/(?:[-\\w\\/]+\\/)?(?:c-|v|[-\\w]+-c)(\\d+)/,n]],[]],mrctv:[[],[{a:[[/mrctv\\.org\\/embed\\/(\\d+)/,n]],match:[[/mrctv\\.org\\/videos\\/./,c]]}]],msnbc:[[],[{a:[[/embedded-video\\/(?!undefined)(\\w+)/,n]],match:[[/msnbc\\.com\\/[-\\w]+\\/watch\\//,c],[/on\\.msnbc\\.com\\/./,c]]}]],natgeochannel:[[[/channel\\.nationalgeographic\\.com\\/([-\\/\\w]+\\/videos\\/[-\\w]+)/,n]],
[]],natgeovideo:[[],[{a:[[/guid="([-\\w]+)"/,n]],match:[[/video\\.nationalgeographic\\.com\\/(?:tv|video)\\/\\w/,c]]}]],nbcnews:[[[/nbcnews\\.com\\/(?:widget\\/video-embed\\/|video\\/[-\\w]+-)(\\d+)/,n]],[]],nbcsports:[[],[{a:[[/select\\/media\\/(\\w+)/,n]],match:[[/nbcsports\\.com\\/video\\/./,c]]}]],nhl:[[[/nhl\\.com\\/(?:\\w+\\/)?video(?:\\/(?![ct]-)[-\\w]+)?(?:\\/t-(\\d+))?(?:\\/c-(\\d+))?/,["","t","c"]]],[]],npr:[[],[{a:[[/player\\/embed\\/(\\d+)\\/(\\d+)/,["","i","m"]]],q:"Cookie: trackingChoice=false; choiceVersion=1",match:[[/npr\\.org\\/[\\/\\w]+\\/\\d+/,
c],[/n\\.pr\\/\\w/,c]]}]],nytimes:[[[/nytimes\\.com\\/video\\/[a-z]+\\/(?:[a-z]+\\/)?(\\d+)/,n],[/nytimes\\.com\\/video\\/\\d+\\/\\d+\\/\\d+\\/[a-z]+\\/(\\d+)/,n]],[{a:[[/\\/video\\/movies\\/(\\d+)/,n]],match:[[/nytimes\\.com\\/movie(?:s\\/movie)?\\/(\\d+)\\/[-\\w]+\\/trailers/,["","playlist"]]],n:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true"}]],odysee:[[[/odysee\\.com\\/(?:[^\\/:]+:|\\$\\/\\w+\\/[^\\/:]+\\/)(\\w{40})/,n]],[{a:[[/odysee\\.com\\/[^\\/:]+:(\\w{40})/,n]],match:[[/odysee\\.com\\/@[^\\/:]+:\\w+\\/./,c]]}]],
orfium:[[[/album\\/(\\d+)/,z],[/playlist\\/(\\d+)/,la],[/live-set\\/(\\d+)/,["","set_id"]],[/track\\/(\\d+)/,w]],[]],pastebin:[[[/pastebin\\.com\\/(?!u\\/)(?:\\w+(?:\\.php\\?i=|\\/))?(\\w+)/,n]],[]],pinterest:[[[/pinterest.com\\/pin\\/(\\d+)/,n],[/pinterest.com\\/(?!_\\/|discover\\/|explore\\/|news_hub\\/|pin\\/|search\\/)([-\\w]+\\/[-\\w]+)/,n]],[]],podbean:[[[/podbean\\.com\\/(?:[-\\w]+\\/)*(?:player[-\\w]*\\/|\\w+\\/pb-)([-\\w]+)/,n]],[{a:[[/podbean\\.com\\/player[^\\/]*\\/\\?i=([-\\w]+)/,n]],match:[[/podbean\\.com\\/(?:media\\/shar)?e\\/(?!pb-)/,
c]]}]],prezi:[[[/\\/\\/prezi\\.com\\/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)\\/)(\\w+)\\//,n]],[]],reddit:[[[/(\\w+\\/comments\\/\\w+(?:\\/\\w+\\/\\w+)?)/,n]],[]],rumble:[[[/rumble\\.com\\/embed\\/(\\w+)/,n]],[{a:[[/video"?:"(\\w+)/,n]],match:[[/rumble\\.com\\/(?!embed\\/)./,c]]}]],rutube:[[[/rutube\\.ru\\/(?:play\\/embed|tracks)\\/(\\d+)/,n]],[{a:[[/rutube\\.ru\\/play\\/embed\\/(\\d+)/,
n]],q:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.0.0 Safari/537.36",match:[[/rutube\\.ru\\/video\\/([0-9a-f]{32})/,ba]],n:"https://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/"}]],scribd:[[[/scribd\\.com\\/(?:mobile\\/)?(?:doc(?:ument)?|presentation)\\/(\\d+)/,n]],[]],sendvid:[[[/sendvid\\.com\\/(\\w+)/,n]],[]],slideshare:[[[/slideshare\\.net\\/[^\\/]+\\/[-\\w]+-(\\d{6,})$/,n]],[{a:[[/"presentationId":(\\d+)/,n]],match:[[/slideshare\\.net\\/[^\\/]+\\/\\w(?![-\\w]+-\\d{6,}$)/,
c]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,n],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,la],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists|tracks)[-\\w]+\\/[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{a:[[/soundcloud:tracks:(\\d+)/,w]],q:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,c]]},{a:[[/soundcloud:\\/\\/playlists:(\\d+)/,
la]],q:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/[-\\w]+\\/sets\\//,c]]}]],sporcle:[[[/sporcle.com\\/framed\\/.*?gid=(\\w+)/,n]],[{a:[[/encodedGameID\\W+(\\w+)/,n]],match:[[/sporcle\\.com\\/games\\/(?!\\w*category\\/)[-\\w]+\\/[-\\w]/,c]]}]],sportsnet:[[],[{a:[[/bc_videos\\s*:\\s*(\\d+)/,n]],match:B}]],spotify:[Aa,[{a:Aa,q:"User-agent: PHP (not Mozilla)",match:[[/link\\.tospotify\\.com\\/./,c]]}]],spreaker:[[[/spreaker\\.com\\/episode\\/(\\d+)/,ja]],[{a:[[/episode_id=(\\d+)/,ja],[/show_id=(\\d+)/,ca]],match:[[/(.+\\/(?:show\\/|user\\/.+\\/).+)/,
["","url"]]],n:"https://api.spreaker.com/oembed?format=json&url={@url}"}]],steamstore:[[[/store.steampowered.com\\/app\\/(\\d+)/,n]],[]],stitcher:[[[/\\/(?:embed|splayer\\/f)\\/(\\d+)\\/(\\d+)/,ia]],[{a:[[/\\/embed\\/(\\d+)\\/(\\d+)/,ia]],match:[[/\\/(?:podcast\\/|show\\/|s\\?)/,c]]}]],strawpoll:[[[/strawpoll\\.me\\/(\\d+)/,n]],[]],streamable:[[[/streamable\\.com\\/(?:e\\/)?(\\w+)/,n]],[]],streamja:[[[/streamja\\.com\\/(?!login|signup|terms|videos)(\\w+)/,n]],[]],teamcoco:[[[/teamcoco\\.com\\/video\\/(\\d+)/,n]],[{a:[[/embed\\/v\\/(\\d+)/,
n]],match:[[/teamcoco\\.com\\/video\\/\\D/,c]]}]],ted:[[[/ted\\.com\\/((?:talk|playlist)s\\/[-\\w]+(?:\\.html)?)(?![-\\w]|\\/transcript)/i,n]],[]],telegram:[[[/\\/\\/t.me\\/(?!addstickers\\/|joinchat\\/)(\\w+\\/\\d+)/,n]],[]],theatlantic:[[[/theatlantic\\.com\\/video\\/index\\/(\\d+)/,n]],[]],theguardian:[[[/theguardian\\.com\\/(\\w+\\/video\\/20(?:0[0-9]|1[0-7])[-\\/\\w]+)/,n]],[]],theonion:[[[/theonion\\.com\\/video\\/[-\\w]+[-,](\\d+)/,n]],[]],tiktok:[za,[{a:za,q:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",
match:[[/\\/\\/vm\\.tiktok\\.com\\/./,c]]}]],tmz:[[[/tmz\\.com\\/videos\\/(\\w+)/,n]],[]],tradingview:[[[/tradingview\\.com\\/(?:chart\\/[^\\/]+|i)\\/(\\w+)/,["","chart"]],[/tradingview\\.com\\/symbols\\/([-:\\w]+)/,["","symbol"]]],[]],traileraddict:[[],[{a:[[/v\\.traileraddict\\.com\\/(\\d+)/,n]],match:[[/traileraddict\\.com\\/(?!tags\\/)[^\\/]+\\/./,c]]}]],trendingviews:[[[/(?:mydailyfreedom\\.com|trendingviews\\.co)\\/(?:tv\\/)?(?:embed|video)\\/(?:[^\\/]+-)?(\\d+)/,n]],[]],tumblr:[[[/([-\\w]+)\\.tumblr\\.com\\/post\\/(\\d+)/,["","name",
"id"]]],[{a:[[/did=\\\\u0022([-\\w]+)/,["","did"]],[/embed\\\\\\/post\\\\\\/([-\\w]+)/,["","key"]]],q:"User-agent: curl",match:[[/\\w\\.tumblr\\.com\\/post\\/\\d/,c]],n:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}"}]],twentyfoursevensports:[xa,[{a:xa,q:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Player\\/[-\\w]*\\d/,c]]},{a:[[/embedVideoContainer_(\\d+)/,da]],q:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",
match:[[/247sports\\.com\\/Video\\/./,c]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,da],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/([-\\w]+))?/,oa],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,f],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?([-\\w]+)/,oa]],[]],twitter:[[[/twitter\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,n]],[]],ustream:[[[/ustream\\.tv\\/recorded\\/(\\d+)/,ba]],[{a:[[/embed\\/(\\d+)/,["","cid"]]],match:[[/ustream\\.tv\\/(?!explore\\/|platform\\/|recorded\\/|search\\?|upcoming$|user\\/)(?:channel\\/)?[-\\w]+/,
c]]}]],vbox7:[[[/vbox7\\.com\\/play:([\\da-f]+)/,n]],[]],veoh:[[[/veoh\\.com\\/(?:m\\/watch\\.php\\?v=|watch\\/)v(\\w+)/,n]],[]],vevo:[[[/vevo\\.com\\/watch\\/(.*?\\/)?([A-Z]+\\d+)/,["","","id"]]],[]],videodetective:[[[/videodetective\\.com\\/\\w+\\/[-\\w]+\\/(?:trailer\\/P0*)?(\\d+)/,n]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)/,n],[/#t=([\\dhms]+)/,f]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,n]],[]],vk:[[[/vk(?:\\.com|ontakte\\.ru)\\/(?:[\\w.]+\\?z=)?video(-?\\d+)_(\\d+).*?hash=([0-9a-f]+)/,na],[/vk(?:\\.com|ontakte\\.ru)\\/video_ext\\.php\\?oid=(-?\\d+)&id=(\\d+)&hash=([0-9a-f]+)/,
na]],[{a:[[/meta property="og:video" content=".*?oid=(-?\\d+).*?id=(\\d+).*?hash=([0-9a-f]+)/,na]],q:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/^(?!.*?hash=)/,c]]}]],vocaroo:[[[/voca(?:\\.ro|roo\\.com)\\/(?:i\\/)?(\\w+)/,n]],[]],vox:[[[/vox.com\\/.*#ooid=([-\\w]+)/,n]],[]],washingtonpost:[[[/washingtonpost\\.com\\/video\\/c\\/\\w+\\/([-0-9a-f]+)/,n],[/washingtonpost\\.com\\/video\\/[-\\/\\w]+\\/([-0-9a-f]+)_video\\.html/,n]],[]],wistia:[[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)(\\w+)/,
n]],[{a:[[/"type":"(?:\\w+_)?(audio)/,r]],match:[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)\\w/,c]],n:"https://fast.wistia.net/embed/iframe/{@id}"}]],wshh:[[[/worldstar(?:hiphop)?\\.com\\/(?:emb|featur)ed\\/(\\d+)/,n]],[{a:[[/v: ?"?(\\d+)/,n]],match:[[/worldstar(?:hiphop)?\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,c]]}]],wsj:[[[/wsj\\.com\\/[^#]*#!([-0-9A-F]{36})/,n],[/wsj\\.com\\/video\\/[^\\/]+\\/([-0-9A-F]{36})/,n]],[{a:[[/guid=([-0-9A-F]{36})/,n]],match:[[/on\\.wsj\\.com\\/\\w/,c]]}]],xboxclips:[[[/(?:gameclips\\.io|xboxclips\\.com)\\/(?!game\\/)([^\\/]+)\\/(?!screenshots\\/)([-0-9a-f]+)/,
ea]],[]],xboxdvr:[[[/(?:gamer|xbox)dvr\\.com\\/gamer\\/([^\\/]+)\\/video\\/(\\d+)/,ea]],[]],youku:[[[/youku\\.com\\/v(?:_show|ideo)\\/id_(\\w+=*)/,n]],[]],youmaker:[[[/youmaker\\.com\\/(?:embed|v(?:ideo)?)\\/([-\\w]+)/,n]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|shorts\\/|v\\/|attribution_link.*?v%3D)([-\\w]+)/,n],[/youtu\\.be\\/([-\\w]+)/,n],[/[#&?]t=(\\d[\\dhms]*)/,f],[/[&?]list=([-\\w]+)/,["","list"]]],[]]},urlConfig:{G:/^https?$/i}},Ua={e:[771],flags:0},T={ABCNEWS:H,ACAST:{e:e,b:{episode_id:C,show_id:C,t:C},h:1,
d:G,f:10,j:u,g:5E3},AMAZON:{e:e,b:{id:ra,tld:C},h:1,d:G,f:10,j:u,g:5E3},ANCHOR:H,APPLEPODCASTS:{e:e,b:{country:C,episode_id:C,podcast_id:C},h:1,d:G,f:10,j:u,g:5E3},AUDIOBOOM:H,AUDIOMACK:{e:e,b:{artist:C,mode:C,title:C},h:1,d:G,f:10,j:u,g:5E3},AUDIUS:{e:e,b:{album_id:C,playlist_id:C,track_id:C},h:1,d:G,f:10,j:u,g:5E3},BANDCAMP:{e:e,b:{album_id:C,track_id:C,track_num:C},h:1,d:G,f:10,j:u,g:5E3},BBCNEWS:H,BITCHUTE:H,BLEACHERREPORT:H,BRIGHTCOVE:{e:e,b:{bckey:C,bcpid:C,bctid:C},h:1,d:G,f:10,j:u,g:5E3},
CASTOS:{e:e,b:{host:C,id:C},h:1,d:G,f:10,j:u,g:5E3},CBSNEWS:H,CLYP:H,CNBC:H,CNN:H,CNNMONEY:H,CODEPEN:Ga,COMEDYCENTRAL:H,COUB:H,DAILYMOTION:{e:e,b:{id:C,t:C},h:1,d:G,f:10,j:u,g:5E3},DEMOCRACYNOW:H,DUMPERT:H,EIGHTTRACKS:H,ESPN:H,FACEBOOK:{e:e,b:{id:C,type:C,user:C},h:1,d:G,f:10,j:u,g:5E3},FALSTAD:{e:e,b:{cct:C,ctz:C},h:1,d:G,f:10,j:u,g:5E3},FLICKR:H,FOXNEWS:H,FUNNYORDIE:H,GAMESPOT:H,GETTY:{e:e,b:{et:C,height:Ea,id:C,sig:C,width:Fa},h:1,d:G,f:10,j:u,g:5E3},GFYCAT:Ha,GIFS:Ha,GIPHY:{e:e,b:{height:Ea,id:C,
type:C,width:Fa},h:1,d:G,f:10,j:u,g:5E3},GIST:H,GLOBALNEWS:H,GOFUNDME:H,GOOGLEDRIVE:H,GOOGLEPLUS:{e:e,b:{name:{d:[function(a){return decodeURIComponent(""+a)}],s:!1},oid:C,pid:C},h:1,d:G,f:10,j:u,g:5E3},GOOGLESHEETS:{e:e,b:{gid:C,id:C,oid:C,type:C},h:1,d:G,f:10,j:u,g:5E3},HUDL:{e:e,b:{athlete:C,highlight:C,id:C},h:1,d:G,f:10,j:u,g:5E3},HULU:H,IGN:H,IMDB:H,IMGUR:H,INDIEGOGO:H,INSTAGRAM:H,INTERNETARCHIVE:{e:e,b:{height:Ea,id:{d:[function(){return!1}],s:!1},width:Fa},h:1,d:G,f:10,j:u,g:5E3},IZLESENE:H,
JSFIDDLE:{e:e,b:{id:C,revision:C,user:C},h:1,d:G,f:10,j:u,g:5E3},JWPLATFORM:H,KALTURA:{e:e,b:{entry_id:ra,partner_id:ra,sp:C,uiconf_id:ra},h:1,d:G,f:10,j:u,g:5E3},KHL:H,KICKSTARTER:{e:e,b:{card:C,id:C,video:C},h:1,d:G,f:10,j:u,g:5E3},LIBSYN:H,LIVELEAK:H,LIVESTREAM:{e:e,b:{account_id:C,channel:C,clip_id:C,event_id:C,video_id:C},h:1,d:G,f:10,j:u,g:5E3},MAILRU:H,MEDIA:{e:[770],b:{},h:0,d:[function(a){return function(b,d,g){function q(h,l,p){var k=!1;p.forEach(function(m){var x=m[1],A=m[0].exec(l);A&&
(k=!0,x.forEach(function(I,y){""<A[y]&&""<I&&(h[I]=A[y])}))});return k}(function(h,l,p){E(h);if("url"in h.b){var k=h.b.url,m;a:{for(m=/^https?:\\/\\/([^\\/]+)/.exec(k.toLowerCase())[1]||"";""<m;){if(l[m]){m=l[m];break a}m=m.replace(/^[^.]*./,"")}m=""}if(p[m]){l={};q(l,k,p[m][0]);a:{for(var x in l){p=!1;break a}p=!0}if(!p){p=h.k;x=h.u;if(x){var A=h.l;k=x.k;x=x.l}else A=0,k=h.k+h.l,x=0;m=m.toUpperCase();h=h.w;k=Q(2,m,k,x,-h||0);h=Q(1,m,p,A,h||0);Na(h,k);Ca(h,l)}}}})(b,d,g)}(a,Ta["MediaEmbed.hosts"],Ta["MediaEmbed.sites"],
Ta.cacheDir)}],f:10,j:{flags:513},g:5E3},MEDIUM:H,MEGAPHONE:H,METACAFE:H,MIXCLOUD:H,MLB:H,MRCTV:H,MSNBC:H,NATGEOCHANNEL:H,NATGEOVIDEO:H,NBCNEWS:H,NBCSPORTS:H,NHL:{e:e,b:{c:C,t:C},h:1,d:G,f:10,j:u,g:5E3},NPR:{e:e,b:{i:C,m:C},h:1,d:G,f:10,j:u,g:5E3},NYTIMES:H,ODYSEE:H,ORFIUM:{e:e,b:{album_id:C,playlist_id:C,set_id:C,track_id:C},h:1,d:G,f:10,j:u,g:5E3},PASTEBIN:H,PINTEREST:H,PODBEAN:H,PREZI:H,REDDIT:H,RUMBLE:H,RUTUBE:H,SCRIBD:H,SENDVID:H,SLIDESHARE:H,SOUNDCLOUD:{e:e,b:{id:C,playlist_id:C,secret_token:C,
track_id:C},h:1,d:G,f:10,j:u,g:5E3},SPORCLE:H,SPORTSNET:H,SPOTIFY:H,SPREAKER:{e:e,b:{episode_id:C,show_id:C},h:1,d:G,f:10,j:u,g:5E3},STEAMSTORE:H,STITCHER:{e:e,b:{eid:C,fid:C},h:1,d:G,f:10,j:u,g:5E3},STRAWPOLL:H,STREAMABLE:H,STREAMJA:H,TEAMCOCO:H,TED:H,TELEGRAM:H,THEATLANTIC:H,THEGUARDIAN:H,THEONION:H,TIKTOK:H,TMZ:H,TRADINGVIEW:{e:e,b:{chart:C,symbol:C},h:1,d:G,f:10,j:u,g:5E3},TRAILERADDICT:H,TRENDINGVIEWS:H,TUMBLR:{e:e,b:{did:C,id:C,key:C,name:C},h:1,d:G,f:10,j:u,g:5E3},TWENTYFOURSEVENSPORTS:{e:e,
b:{player_id:C,video_id:C},h:1,d:G,f:10,j:u,g:5E3},TWITCH:{e:e,b:{channel:C,clip_id:C,t:C,video_id:C},h:1,d:G,f:10,j:u,g:5E3},TWITTER:H,USTREAM:{e:e,b:{cid:C,vid:C},h:1,d:G,f:10,j:u,g:5E3},VBOX7:H,VEOH:H,VEVO:H,VIDEODETECTIVE:H,VIMEO:{e:e,b:{id:C,t:Da},h:1,d:G,f:10,j:u,g:5E3},VINE:H,VK:{e:e,b:{hash:C,oid:C,vid:C},h:1,d:G,f:10,j:u,g:5E3},VOCAROO:H,VOX:H,WASHINGTONPOST:H,WISTIA:{e:e,b:{id:C,type:C},h:1,d:G,f:10,j:u,g:5E3},WSHH:H,WSJ:H,XBOXCLIPS:Ga,XBOXDVR:Ga,YOUKU:H,YOUMAKER:H,YOUTUBE:{e:e,b:{id:{d:[function(a){return/^[-0-9A-Za-z_]+$/.test(a)?
a:!1}],s:!1},list:C,t:Da},h:1,d:G,f:10,j:u,g:5E3}},U,Va,V,W,Wa=0,X;
function Xa(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]+/g,"");var b=D;b.r=[];delete b.k;delete b.l;K={};Ra={};M=0;N=null;Sa=!1;O=[];P="";S=0;U=[];Va=!1;V=a;W=V.length;X=0;L=Ua;L.z=!1;++Wa;a=Wa;for(var d in R)if(!R[d].v)a:{b=d;var g=R[b];if(!(g.A&&0>V.indexOf(g.A))){var q=[];if("undefined"!==typeof g.B&&"undefined"!==typeof g.C){q=void 0;var h=g.B;g=g.C;h.lastIndex=0;for(var l=[],p=0;++p<=g&&(q=h.exec(V));){for(var k=q.index,m=[[q[0],k]],x=0;++x<q.length;){var A=q[x];void 0===
A?m.push(["",-1]):(m.push([A,V.indexOf(A,k)]),k+=A.length)}l.push(m)}q=l;if(!q.length)break a}(0,R[b].F)(V,q)}}Ya();Y(W,!0);do d=P,P=P.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(P!==d);P=P.replace(/<\\/i><i>/g,"");P=P.replace(/[\\x00-\\x08\\x0B-\\x1F]/g,"");P=P.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,Za);d=Sa?"r":"t";P="<"+d+">"+P+"</"+d+">";if(Wa!==a)throw"The parser has been reset during execution";1E4<M&&D.add("warn","Fixing cost limit exceeded",void 0);return P}
function $a(a){var b={},d;for(d in T[a])b[d]=T[a][d];return T[a]=b}function Za(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function ab(a){Sa=!0;var b=a.name,d=a.k,g=a.l,q=0;Y(d,!(a.p&1));var h=g?Ka(V.substring(d,d+g)):"";if(a.p&1){P+="<"+b;var l=Pa(a),p=[],k;for(k in l)p.push(k);p.sort(function(m,x){return m>x?1:-1});p.forEach(function(m){P+=" "+m+\'="\'+Ja(l[m].toString()).replace(/\\n/g,"&#10;")+\'"\'});P=3===a.p?g?P+(">"+h+"</"+b+">"):P+"/>":g?P+("><s>"+h+"</s>"):P+">"}else g&&(P+="<e>"+h+"</e>"),P+="</"+b+">";for(X=S=d+g;q&&X<W&&"\\n"===V[X];)--q,++X}
function Y(a,b){var d=0;b&&(L.flags&8?d=-1:b=!1);S>=a&&b&&bb();if(X>S){var g=Math.min(a,X);P+=V.substring(S,g);S=g;S>=a&&b&&bb()}var q=a;for(g=0;d&&--q>=S;){var h=V[q];if(" "!==h&&"\\n"!==h&&"\\t"!==h)break;"\\n"===h&&--d;++g}a-=g;a>S&&(d=Ka(V.substring(S,a)),P+=d);b&&bb();g&&(P+=V.substring(a,a+g));S=a+g}function cb(a){var b=a.k;a=a.l;var d=V.substring(b,b+a);Y(b,!1);P+="<i>"+Ka(d)+"</i>";Sa=!0;S=b+a}function bb(){L.z&&(P+="</p>",L.z=!1)}
function Ya(){if(U.length){for(var a in T)K[a]=0,Ra[a]=0;do{for(;U.length;)Va||db(),N=U.pop(),eb();O.forEach(function(b){var d=Q(2,b.name,W,0,0);Na(d,b)})}while(U.length)}}
function eb(){L.flags&64&&!Qa(N,O[O.length-1])&&!(-1<"br i pb v".indexOf(N.name))&&E(N);var a=N.k,b=N.l;if(S>a&&!N.o){var d;if((d=N.r)&&0<=O.indexOf(d)){Na(Q(2,d.name,S,Math.max(0,a+b-S),0),d);return}if("i"===N.name&&(a=a+b-S,0<a)){b=S;Q(3,"i",b,Math.min(a,W-b),0);return}E(N)}if(!N.o)if("i"===N.name)cb(N);else if("br"===N.name)L.flags&1024||(Y(N.k,!1),P+="<br/>");else if("pb"===N.name)Y(N.k,!0);else if("v"===N.name)a=L.flags,L.flags=N.flags,Y(N.k+N.l,!1),L.flags=a;else if(N.p&1)if(a=N,b=a.name,d=
T[b],Ra[b]>=d.g)D.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:d.g}),E(a);else{var g=a,q=T[g.name];D.l=g;for(var h=0;h<q.d.length&&!g.o;++h)q.d[h](g,q);delete D.l;a.o||(K[b]>=d.f?(D.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:d.f}),E(a)):(d=T[b].h,L.e[d>>3]&1<<(d&7)?(!(a.flags&1&&3!==a.p)||a.u||U.length&&Qa(U[U.length-1],a)||(b=new J(3,b,a.k,a.l),Ca(b,Pa(a)),b.flags=a.flags,a=b),ab(a),fb(a)):(b={tag:a,tagName:b},0<a.l?D.add("warn","Tag is not allowed in this context",
b):Ma("Tag is not allowed in this context",b),E(a))))}else gb()}
function gb(){var a=N;if(K[a.name]){for(var b=[],d=O.length;0<=--d;){var g=O[d];if(Qa(a,g))break;b.push(g);++M}if(0>d)Ma("Skipping end tag with no start tag",{tag:a});else{b.forEach(function(){});var q=0,h=[];b.forEach(function(k){var m=k.name;q&&(k.flags&2?h.push(k):q=!1);m=new J(2,m,a.k,0);m.flags=k.flags;ab(m);hb()});ab(a);hb();if(b.length&&1E4>M){g=S;for(d=U.length;0<=--d&&1E4>++M;){var l=U[d];if(l.k>g||l.p&1)break;for(var p=b.length;0<=--p&&1E4>++M;)if(Qa(l,b[p])){b.splice(p,1);h[p]&&h.splice(p,
1);g=Math.max(g,l.k+l.l);break}}g>S&&cb(new J(3,"i",S,g-S))}h.forEach(function(k){var m=Q(k.p,k.name,S,0,k.w);Ca(m,Pa(k));(k=k.u)&&Na(m,k)})}}}function hb(){var a=O.pop();--K[a.name];L=L.D}function fb(a){var b=a.name,d=a.flags,g=T[b];++Ra[b];if(3!==a.p){var q=[];L.e.forEach(function(l,p){d&512||(l=l&65280|l>>8);q.push(g.e[p]&l)});var h=d|L.flags&32;h&16&&(h&=-33);++K[b];O.push(a);L={D:L};L.e=q;L.flags=h}}
function Q(a,b,d,g,q){a=new J(a,b,d,g,q||0);T[b]&&(a.flags=T[b].j.flags);if(!(T[b]||-1<"br i pb v".indexOf(a.name))||0>g||0>d||d+g>W||/[\\uDC00-\\uDFFF]/.test(V.substring(d,d+1)+V.substring(d+g,d+g+1)))E(a);else if(T[b]&&T[b].v)D.add("warn","Tag is disabled",{tag:a,tagName:b}),E(a);else if(Va){b=U.length;for(d=ib(a);0<b&&d>ib(U[b-1]);)U[b]=U[b-1],--b;U[b]=a}else U.push(a);return a}
function db(){for(var a={},b=[],d=U.length;0<=--d;){var g=U[d],q=ib(g,d);b.push(q);a[q]=g}b.sort();d=b.length;for(U=[];0<=--d;)U.push(a[b[d]]);Va=!0}function ib(a,b){var d=0<=a.w,g=a.w;d||(g+=1073741824);var q=0<a.l,h;q?h=W-a.l:h={2:0,3:1,1:2}[a.p];return jb(a.k)+ +d+jb(g)+ +q+jb(h)+jb(b||0)}function jb(a){a=a.toString(16);return"        ".substring(a.length)+a}var kb="undefined"===typeof DOMParser||"undefined"===typeof XSLTProcessor;
function lb(a){if(kb){var b=new ActiveXObject("MSXML2.FreeThreadedDOMDocument.6.0");b.async=!1;b.validateOnParse=!1;b.loadXML(a)}else b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}function mb(a,b){if(kb){var d=b.createElement("div");b=b.createDocumentFragment();Z.input=lb(a);Z.transform();for(d.innerHTML=Z.output;d.firstChild;)b.appendChild(d.firstChild);return b}return Z.transformToFragment(lb(a),b)}var Z,nb=lb(Ia);
if(kb){var ob=new ActiveXObject("MSXML2.XSLTemplate.6.0");ob.stylesheet=nb;Z=ob.createProcessor()}else Z=new XSLTProcessor,Z.importStylesheet(nb);window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){R[a]&&(R[a].v=!0)},disableTag:function(a){T[a]&&($a(a).v=!0)},enablePlugin:function(a){R[a]&&(R[a].v=!1)},enableTag:function(a){T[a]&&($a(a).v=!1)},getLogger:function(){return D},parse:Xa,preview:function(a,b){function d(l,p){var k=l.childNodes;p=p.childNodes;for(var m=k.length,x=p.length,A,I,y=0,F=0;y<m&&y<x;){A=k[y];I=p[y];if(!g(A,I))break;++y}for(var pb=Math.min(m-y,x-y);F<pb;){A=k[m-(F+1)];I=p[x-(F+1)];if(!g(A,I))break;++F}for(m-=F;--m>=y;)l.removeChild(k[m]),
h=l;k=x-F;if(!(y>=k)){x=q.createDocumentFragment();m=y;do I=p[m],h=x.appendChild(I);while(m<--k);F?l.insertBefore(x,l.childNodes[y]):l.appendChild(x)}}function g(l,p){if(l.nodeName!==p.nodeName||l.nodeType!==p.nodeType)return!1;if(l instanceof HTMLElement&&p instanceof HTMLElement){if(!l.isEqualNode(p)){for(var k=l.attributes,m=p.attributes,x=m.length,A=k.length,I=" "+l.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";0<=--A;){var y=k[A],F=y.namespaceURI;y=y.name;-1<I.indexOf(" "+y+" ")||p.hasAttributeNS(F,
y)||(l.removeAttributeNS(F,y),h=l)}for(A=x;0<=--A;)k=m[A],F=k.namespaceURI,y=k.name,k=k.value,-1<I.indexOf(" "+y+" ")||k===l.getAttributeNS(F,y)||(l.setAttributeNS(F,y,k),h=l);d(l,p)}}else 3!==l.nodeType&&8!==l.nodeType||l.nodeValue===p.nodeValue||(l.nodeValue=p.nodeValue,h=l);return!0}var q=b.ownerDocument;if(!q)throw"Target does not have a ownerDocument";a=mb(Xa(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),q);var h=b;"undefined"!==typeof window&&"chrome"in window&&a.querySelectorAll("script").forEach(function(l){var p=
document.createElement("script");var k=l.attributes;var m="undefined"!=typeof Symbol&&Symbol.iterator&&k[Symbol.iterator];k=m?m.call(k):{next:aa(k)};for(m=k.next();!m.done;m=k.next())m=m.value,p.setAttribute(m.name,m.value);p.textContent=l.textContent;l.parentNode.replaceChild(p,l)});d(b,a);return h},registeredVars:Ta,setNestingLimit:function(a,b){T[a]&&($a(a).f=b)},setParameter:function(a,b){kb?Z.addParameter(a,b,""):Z.setParameter(null,a,b)},setTagLimit:function(a,b){T[a]&&($a(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:174:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"acast.com";s:5:"acast";s:9:"amazon.ca";s:6:"amazon";s:12:"amazon.co.uk";s:6:"amazon";s:12:"amazon.co.jp";s:6:"amazon";s:10:"amazon.com";s:6:"amazon";s:9:"amazon.de";s:6:"amazon";s:9:"amazon.es";s:6:"amazon";s:9:"amazon.fr";s:6:"amazon";s:9:"amazon.in";s:6:"amazon";s:9:"amazon.it";s:6:"amazon";s:9:"anchor.fm";s:6:"anchor";s:18:"podcasts.apple.com";s:13:"applepodcasts";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:9:"audius.co";s:6:"audius";s:12:"bandcamp.com";s:8:"bandcamp";s:9:"bbc.co.uk";s:7:"bbcnews";s:7:"bbc.com";s:7:"bbcnews";s:12:"bitchute.com";s:8:"bitchute";s:18:"bleacherreport.com";s:14:"bleacherreport";s:19:"link.brightcove.com";s:10:"brightcove";s:22:"players.brightcove.net";s:10:"brightcove";s:10:"castos.com";s:6:"castos";s:11:"cbsnews.com";s:7:"cbsnews";s:7:"clyp.it";s:4:"clyp";s:8:"cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:10:"codepen.io";s:7:"codepen";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:8:"fb.watch";s:8:"facebook";s:11:"falstad.com";s:7:"falstad";s:7:"flic.kr";s:6:"flickr";s:10:"flickr.com";s:6:"flickr";s:17:"video.foxnews.com";s:7:"foxnews";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:10:"gfycat.com";s:6:"gfycat";s:8:"gifs.com";s:4:"gifs";s:9:"giphy.com";s:5:"giphy";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:12:"jsfiddle.net";s:8:"jsfiddle";s:14:"jwplatform.com";s:10:"jwplatform";s:11:"kaltura.com";s:7:"kaltura";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:10:"libsyn.com";s:6:"libsyn";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:10:"medium.com";s:6:"medium";s:12:"megaphone.fm";s:9:"megaphone";s:14:"megaphone.link";s:9:"megaphone";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:13:"nbcsports.com";s:9:"nbcsports";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"odysee.com";s:6:"odysee";s:10:"orfium.com";s:6:"orfium";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:10:"rumble.com";s:6:"rumble";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:11:"sendvid.com";s:7:"sendvid";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:11:"sporcle.com";s:7:"sporcle";s:12:"sportsnet.ca";s:9:"sportsnet";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:12:"spreaker.com";s:8:"spreaker";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"stitcher.com";s:8:"stitcher";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"streamja.com";s:8:"streamja";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:4:"t.me";s:8:"telegram";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:10:"tiktok.com";s:6:"tiktok";s:7:"tmz.com";s:3:"tmz";s:15:"tradingview.com";s:11:"tradingview";s:17:"traileraddict.com";s:13:"traileraddict";s:18:"mydailyfreedom.com";s:13:"trendingviews";s:16:"trendingviews.co";s:13:"trendingviews";s:10:"tumblr.com";s:6:"tumblr";s:13:"247sports.com";s:21:"twentyfoursevensports";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:18:"videodetective.com";s:14:"videodetective";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:7:"voca.ro";s:7:"vocaroo";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:10:"wistia.com";s:6:"wistia";s:13:"worldstar.com";s:4:"wshh";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:12:"gameclips.io";s:9:"xboxclips";s:13:"xboxclips.com";s:9:"xboxclips";s:12:"gamerdvr.com";s:7:"xboxdvr";s:11:"xboxdvr.com";s:7:"xboxdvr";s:9:"youku.com";s:5:"youku";s:12:"youmaker.com";s:8:"youmaker";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:131:{s:7:"abcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:68:"!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}}i:1;a:0:{}}s:5:"acast";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:84:"@play\\.acast\\.com/s/(?\'show_id\'[-.\\w]+)/(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"show_id";i:2;s:10:"episode_id";i:3;s:1:"t";}}i:1;a:2:{i:0;s:92:"@shows\\.acast\\.com/(?\'show_id\'[-.\\w]+)/episodes/(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;R:199;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:34:"@"showId":"(?\'show_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:7:"show_id";}}i:1;a:2:{i:0;s:33:"@"id":"(?\'episode_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"episode_id";}}}s:5:"match";a:2:{i:0;a:2:{i:0;s:30:"@play\\.acast\\.com/s/[-.\\w]+/.@";i:1;a:1:{i:0;s:0:"";}}i:1;a:2:{i:0;s:38:"@shows\\.acast\\.com/[-.\\w]+/episodes/.@";i:1;R:222;}}s:3:"url";s:71:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}";}}}s:6:"amazon";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:1;R:191;}i:1;a:2:{i:0;s:50:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|in|it|jp|uk)#";i:1;a:2:{i:0;s:0:"";i:1;s:3:"tld";}}}i:1;R:194;}s:6:"anchor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@anchor.fm/(?:[-\\w]+/)*?episodes/(?:[-\\w]+-)(?\'id\'\\w+)(?![-\\w])@";i:1;R:191;}}i:1;R:194;}s:13:"applepodcasts";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:101:"@podcasts\\.apple\\.com/(?\'country\'\\w+)/podcast/[-\\w]*/id(?\'podcast_id\'\\d+)(?:\\?i=(?\'episode_id\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"country";i:2;s:10:"podcast_id";i:3;s:10:"episode_id";}}}i:1;R:194;}s:9:"audioboom";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:9:"audiomack";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:71:"!audiomack\\.com/(?\'mode\'album|song)/(?\'artist\'[-\\w]+)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:6:"artist";i:3;s:5:"title";}}i:1;a:2:{i:0;s:71:"!audiomack\\.com/(?\'artist\'[-\\w]+)/(?\'mode\'album|song)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:6:"artist";i:2;s:4:"mode";i:3;s:5:"title";}}}i:1;R:194;}s:6:"audius";a:2:{i:0;R:194;i:1;a:3:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'track_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:75:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/(?!album/|playlist/)(?\'slug\'[%\\-.\\w]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"slug";}}}s:3:"url";s:94:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}";}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'album_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:61:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/album/(?\'slug\'[%\\-.\\w]+)@";i:1;R:281;}}s:3:"url";s:100:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}";}i:2;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!"id"\\s*:\\s*"(?\'playlist_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:64:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/playlist/(?\'slug\'[%\\-.\\w]+)@";i:1;R:281;}}s:3:"url";s:103:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}";}}}s:8:"bandcamp";a:2:{i:0;R:194;i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;R:290;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;R:222;}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:290;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;R:275;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:222;}}}}}s:7:"bbcnews";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:67:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/(?:\\w+-)+(?\'id\'\\d+)@";i:1;R:191;}i:1;a:2:{i:0;s:68:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/embed/(?\'id\'\\w+/\\d+)@";i:1;R:191;}i:2;a:2:{i:0;s:62:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/\\w+/(?\'id\'\\d+)@";i:1;R:191;}i:3;a:2:{i:0;s:45:"@bbc\\.co(?:m|\\.uk)/news/av-embeds/(?\'id\'\\d+)@";i:1;R:191;}}i:1;R:194;}s:8:"bitchute";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"@bitchute\\.com/(?:embed|video)/(?\'id\'[-\\w]+)@";i:1;R:191;}}i:1;R:194;}s:14:"bleacherreport";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!id="video-(?\'id\'[-\\w]+)!";i:1;R:191;}i:1;a:2:{i:0;s:31:"!video_embed\\?id=(?\'id\'[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!/articles/.!";i:1;R:222;}}}}}s:10:"brightcove";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:107:"@link\\.brightcove\\.com/services/player/bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bckey";i:3;s:5:"bctid";}}i:1;a:2:{i:0;s:65:"@players\\.brightcove\\.net/(?\'bcpid\'\\d+)/.*?videoId=(?\'bctid\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}i:1;R:194;}s:6:"castos";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:48:"@(?\'host\'[-\\w]+)\\.castos\\.com/player/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"host";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:372;s:5:"match";a:1:{i:0;a:2:{i:0;s:45:"@castos\\.com/(?:podcasts/[^/]*+/)?episodes/.@";i:1;R:222;}}}}}s:7:"cbsnews";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"#cbsnews\\.com/videos?/(?!watch/)(?\'id\'[-\\w]+)#";i:1;R:191;}i:1;a:2:{i:0;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:1;R:191;}}i:1;R:194;}s:4:"clyp";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"@clyp\\.it/(?!user/)(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:4:"cnbc";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!byGuid=(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"!cnbc\\.com/video/20\\d\\d/\\d\\d/\\d\\d/\\w!";i:1;R:222;}}}}}s:3:"cnn";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;R:191;}i:1;a:2:{i:0;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:1;R:191;}}i:1;R:194;}s:8:"cnnmoney";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:1;R:191;}}i:1;R:194;}s:7:"codepen";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:72:"!codepen\\.io/(?\'user\'[-\\w]+)/(?:details|embed|full|live|pen)/(?\'id\'\\w+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}}i:1;R:194;}s:13:"comedycentral";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;R:222;}}}}}s:4:"coub";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;R:191;}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:191;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:194;}s:12:"democracynow";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;R:222;}}}}}s:7:"dumpert";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!dumpert\\.nl/(?:item|mediabase)/(?\'id\'\\d+[/_]\\w+)!";i:1;R:191;}}i:1;R:194;}s:11:"eighttracks";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!8tracks\\.com/[-\\w]+/\\D!";i:1;R:222;}}}}}s:4:"espn";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:1;R:191;}}i:1;R:194;}s:8:"facebook";a:2:{i:0;a:5:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:191;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:492;}i:4;a:2:{i:0;s:53:"@facebook.com/groups/[^/]*/(?\'type\'p)osts/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:45:"@facebook\\.com/watch/\\?(?\'type\'v)=(?\'id\'\\d+)@";i:1;R:499;}i:1;a:2:{i:0;s:58:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/(?\'id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";i:3;s:2:"id";}}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"@fb\\.watch/.@";i:1;R:222;}}}}}s:7:"falstad";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:81:"!falstad\\.com/circuit/circuitjs\\.html\\?c(?:ct=(?\'cct\'[^&]+)|tz=(?\'ctz\'[-+=\\w]+))!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"cct";i:2;s:3:"ctz";}}}i:1;R:194;}s:6:"flickr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"@flickr\\.com/photos/[^/]+/(?\'id\'\\d+)@";i:1;R:191;}i:1;a:2:{i:0;s:33:"@flic\\.kr/(?!p/)[^/]+/(?\'id\'\\d+)@";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;R:529;}s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"@flic\\.kr/p/(?\'short\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:5:"short";}}}s:3:"url";s:52:"https://www.flickr.com/photo.gne?rb=1&short={@short}";}}}s:7:"foxnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:10:"funnyordie";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:1;R:191;}}i:1;R:194;}s:8:"gamespot";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:1;R:191;}}i:1;R:194;}s:5:"getty";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:20:"!gty\\.im/(?\'id\'\\d+)!";i:1;R:191;}i:1;a:2:{i:0;s:47:"!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!";i:1;R:191;}i:2;a:2:{i:0;s:30:"!#[-\\w]*picture-id(?\'id\'\\d+)$!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:4:{i:0;a:2:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"height";}}i:1;a:2:{i:0;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"width";}}i:2;a:2:{i:0;s:29:"!\\bid[=:][\'"]?(?\'et\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"et";}}i:3;a:2:{i:0;s:31:"!\\bsig[=:][\'"]?(?\'sig\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"sig";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:2:"//";i:1;R:222;}}s:3:"url";s:43:"https://embed.gettyimages.com/preview/{@id}";}}}s:6:"gfycat";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?(?\'id\'\\w+)#";i:1;R:191;}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:17:"!/ifr/(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:87:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?[a-z]#";i:1;R:222;}}s:3:"url";s:28:"https://gfycat.com/ifr/{@id}";}i:1;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!"height":(?\'height\'\\d+)!";i:1;R:568;}i:1;a:2:{i:0;s:23:"!"width":(?\'width\'\\d+)!";i:1;R:573;}}s:5:"match";R:586;s:3:"url";s:61:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}";}}}s:4:"gifs";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;R:573;}i:1;a:2:{i:0;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";i:1;R:568;}}s:5:"match";R:586;s:3:"url";s:26:"https://gifs.com/gif/{@id}";}}}s:5:"giphy";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:62:"!giphy\\.com/(?\'type\'gif|video|webp)\\w+/(?:[-\\w]+-)*(?\'id\'\\w+)!";i:1;R:499;}i:1;a:2:{i:0;s:52:"!giphy\\.com/media/(?\'id\'\\w+)/\\w+\\.(?\'type\'gif|webp)!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"type";}}i:2;a:2:{i:0;s:45:"!i\\.giphy\\.com/(?\'id\'\\w+)\\.(?\'type\'gif|webp)!";i:1;R:628;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!"height"\\s*:\\s*(?\'height\'\\d+)!";i:1;R:568;}i:1;a:2:{i:0;s:29:"!"width"\\s*:\\s*(?\'width\'\\d+)!";i:1;R:573;}}s:5:"match";R:586;s:3:"url";s:83:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif";}}}s:4:"gist";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:75:"@gist\\.github\\.com/(?\'id\'(?:[-\\w]+/)?[\\da-f]+(?:/[\\da-f]+)?\\b(?!/archive))@";i:1;R:191;}}i:1;R:194;}s:10:"globalnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:647;s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!globalnews\\.ca/video/rd/!";i:1;R:222;}}}}}s:8:"gofundme";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:1;R:191;}}i:1;R:194;}s:11:"googledrive";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:10:"googleplus";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}i:1;R:194;}s:12:"googlesheets";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:76:"@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|(?:[^e]/)+)(?\'id\'(?:e/)?[-\\w]+)@";i:1;R:191;}i:1;a:2:{i:0;s:17:"@oid=(?\'oid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"oid";}}i:2;a:2:{i:0;s:18:"@#gid=(?\'gid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"gid";}}i:3;a:2:{i:0;s:20:"@/pub(?\'type\'chart)@";i:1;R:492;}}i:1;R:194;}s:4:"hudl";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:2:{i:0;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:1;R:692;}i:2;a:2:{i:0;s:37:"@hudl\\.com/video/(?\'id\'\\w+)(?![\\w/])@";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;R:696;i:1;R:698;}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!hudl\\.com/v/!";i:1;R:222;}}}}}s:4:"hulu";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!eid=(?\'id\'[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:18:"!hulu\\.com/watch/!";i:1;R:222;}}}}}s:3:"ign";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:40:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!i";i:1;R:191;}}i:1;R:194;}s:4:"imdb";a:2:{i:0;R:194;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:45:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)/[/\\w]*?embed!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:32:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)!";i:1;R:191;}}s:3:"url";s:50:"https://www.imdb.com/video/imdb/vi{@id}/imdb/embed";}}}s:5:"imgur";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:25:"@imgur\\.com/(?\'id\'a/\\w+)@";i:1;R:191;}i:1;a:2:{i:0;s:38:"@i\\.imgur\\.com/(?\'id\'\\w{5,7})[lms]?\\.@";i:1;R:191;}i:2;a:2:{i:0;s:33:"@imgur\\.com/(?\'id\'\\w+)(?![\\w./])@";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"@data-id="(?\'id\'[\\w/]+)"@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:63:"@imgur\\.com/(?![art]/|user/)(?\'path\'(?:gallery/)?\\w+)(?![\\w.])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:3:"url";s:45:"https://api.imgur.com/oembed.xml?url=/{@path}";}}}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!instagram\\.com/(?:p|reel|tv)/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:15:"internetarchive";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;R:191;}i:1;a:2:{i:0;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:1;R:573;}i:2;a:2:{i:0;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";i:1;R:568;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!archive\\.org/(?:details|embed)/!";i:1;R:222;}}}}}s:8:"izlesene";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:8:"jsfiddle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:96:"@jsfiddle.net/(?:(?\'user\'\\w+)/)?(?!\\d+\\b|embedded\\b|show\\b)(?\'id\'\\w+)\\b(?:/(?\'revision\'\\d+)\\b)?@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";i:3;s:8:"revision";}}}i:1;R:194;}s:10:"jwplatform";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:7:"kaltura";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:38:"@/p(?:artner_id)?/(?\'partner_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"partner_id";}}i:1;a:2:{i:0;s:17:"@/sp/(?\'sp\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:2:"sp";}}i:2;a:2:{i:0;s:31:"@/uiconf_id/(?\'uiconf_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:9:"uiconf_id";}}i:3;a:2:{i:0;s:32:"@\\bentry_id[=/](?\'entry_id\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:8:"entry_id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:113:"@kaltura\\.com/+p/(?\'partner_id\'\\d+)/sp/(?\'sp\'\\d+)/\\w*/uiconf_id/(?\'uiconf_id\'\\d+)/.*?\\bentry_id=(?\'entry_id\'\\w+)@";i:1;a:5:{i:0;s:0:"";i:1;s:10:"partner_id";i:2;s:2:"sp";i:3;s:9:"uiconf_id";i:4;s:8:"entry_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"@kaltura\\.com/(?:media/t|tiny)/.@";i:1;R:222;}}}}}s:3:"khl";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;R:222;}}}}}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:194;}s:6:"libsyn";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;R:222;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:222;}}}}}s:10:"livestream";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:2:{i:0;s:26:"!/videos/(?\'video_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:2:{i:0;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;R:866;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@livestream\\.com/(?!accounts/\\d+/events/\\d)@";i:1;R:222;}}}i:1;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:1;R:877;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!livestre.am!";i:1;R:222;}}}}}s:6:"mailru";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!"itemId": ?"?(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;R:222;}}}}}s:6:"medium";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"#medium\\.com/(?:s/\\w+/|@?[-\\w]+/)?(?:\\w+-)*(?\'id\'[0-9a-f]+)(?!\\w)#";i:1;R:191;}}i:1;R:194;}s:9:"megaphone";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:46:"@megaphone\\.fm/.*?\\?(?:e|selected)=(?\'id\'\\w+)@";i:1;R:191;}i:1;a:2:{i:0;s:50:"@(?:dcs|player|traffic)\\.megaphone\\.fm/(?\'id\'\\w+)@";i:1;R:191;}i:2;a:2:{i:0;s:28:"@megaphone\\.link/(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:8:"metacafe";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:8:"mixcloud";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:1;R:191;}}i:1;R:194;}s:3:"mlb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"#mlb\\.com/video/(?:[-\\w/]+/)?(?:c-|v|[-\\w]+-c)(?\'id\'\\d+)#";i:1;R:191;}}i:1;R:194;}s:5:"mrctv";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;R:222;}}}}}s:5:"msnbc";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:40:"@embedded-video/(?!undefined)(?\'id\'\\w+)@";i:1;R:191;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;R:222;}i:1;a:2:{i:0;s:18:"@on\\.msnbc\\.com/.@";i:1;R:222;}}}}}s:13:"natgeochannel";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:1;R:191;}}i:1;R:194;}s:11:"natgeovideo";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;R:222;}}}}}s:7:"nbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:9:"nbcsports";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!select/media/(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!nbcsports\\.com/video/.!";i:1;R:222;}}}}}s:3:"nhl";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}}i:1;R:194;}s:3:"npr";a:2:{i:0;R:194;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:1:"i";i:2;s:1:"m";}}}s:6:"header";s:45:"Cookie: trackingChoice=false; choiceVersion=1";s:5:"match";a:2:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;R:222;}i:1;a:2:{i:0;s:10:"!n\\.pr/\\w!";i:1;R:222;}}}}}s:7:"nytimes";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;R:191;}i:1;a:2:{i:0;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:26:"!/video/movies/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"playlist";}}}s:3:"url";s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}}s:6:"odysee";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:53:"#odysee\\.com/(?:[^/:]+:|\\$/\\w+/[^/:]+/)(?\'id\'\\w{40})#";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"#odysee\\.com/[^/:]+:(?\'id\'\\w{40})#";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"#odysee\\.com/@[^/:]+:\\w+/.#";i:1;R:222;}}}}}s:6:"orfium";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:24:"@album/(?\'album_id\'\\d+)@";i:1;R:290;}i:1;a:2:{i:0;s:30:"@playlist/(?\'playlist_id\'\\d+)@";i:1;R:301;}i:2;a:2:{i:0;s:25:"@live-set/(?\'set_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:6:"set_id";}}i:3;a:2:{i:0;s:24:"@track/(?\'track_id\'\\d+)@";i:1;R:275;}}i:1;R:194;}s:8:"pastebin";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:9:"pinterest";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:1;R:191;}i:1;a:2:{i:0;s:84:"@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@";i:1;R:191;}}i:1;R:194;}s:7:"podbean";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:65:"!podbean\\.com/(?:[-\\w]+/)*(?:player[-\\w]*/|\\w+/pb-)(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"!podbean\\.com/player[^/]*/\\?i=(?\'id\'[-\\w]+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"@podbean\\.com/(?:media/shar)?e/(?!pb-)@";i:1;R:222;}}}}}s:5:"prezi";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:1;R:191;}}i:1;R:194;}s:6:"reddit";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!(?\'id\'\\w+/comments/\\w+(?:/\\w+/\\w+)?)!";i:1;R:191;}}i:1;R:194;}s:6:"rumble";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rumble\\.com/embed/(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:21:"!video"?:"(?\'id\'\\w+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"#rumble\\.com/(?!embed/).#";i:1;R:222;}}}}}s:6:"rutube";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"!rutube\\.ru/(?:play/embed|tracks)/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!rutube\\.ru/play/embed/(?\'id\'\\d+)!";i:1;R:191;}}s:6:"header";s:110:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.0.0 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"!rutube\\.ru/video/(?\'vid\'[0-9a-f]{32})!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}s:3:"url";s:65:"https://rutube.ru/api/oembed/?url=https://rutube.ru/video/{@vid}/";}}}s:6:"scribd";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:67:"!scribd\\.com/(?:mobile/)?(?:doc(?:ument)?|presentation)/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:7:"sendvid";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!sendvid\\.com/(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:10:"slideshare";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!"presentationId":(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@slideshare\\.net/[^/]+/\\w(?![-\\w]+-\\d{6,}$)@";i:1;R:222;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:191;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;R:301;}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";i:1;R:275;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:222;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"@soundcloud://playlists:(?\'playlist_id\'\\d+)@";i:1;R:301;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:30:"@soundcloud\\.com/[-\\w]+/sets/@";i:1;R:222;}}}}}s:7:"sporcle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"#sporcle.com/framed/.*?gid=(?\'id\'\\w+)#";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"#encodedGameID\\W+(?\'id\'\\w+)#";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"#sporcle\\.com/games/(?!\\w*category/)[-\\w]+/[-\\w]#";i:1;R:222;}}}}}s:9:"sportsnet";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"@bc_videos\\s*:\\s*(?\'id\'\\d+)@";i:1;R:191;}}s:5:"match";R:586;}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?:user/[-.\\w]+/)?(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1174;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!link\\.tospotify\\.com/.!";i:1;R:222;}}}}}s:8:"spreaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!spreaker\\.com/episode/(?\'episode_id\'\\d+)!";i:1;R:216;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!episode_id=(?\'episode_id\'\\d+)!";i:1;R:216;}i:1;a:2:{i:0;s:25:"!show_id=(?\'show_id\'\\d+)!";i:1;R:211;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!(?\'url\'.+/(?:show/|user/.+/).+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"url";}}}s:3:"url";s:54:"https://api.spreaker.com/oembed?format=json&url={@url}";}}}s:10:"steamstore";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:8:"stitcher";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!/(?:embed|splayer/f)/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"fid";i:2;s:3:"eid";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:32:"!/embed/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;R:1209;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!/(?:podcast/|show/|s\\?)!";i:1;R:222;}}}}}s:9:"strawpoll";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:10:"streamable";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!streamable\\.com/(?:e/)?(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:8:"streamja";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@streamja\\.com/(?!login|signup|terms|videos)(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:8:"teamcoco";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:20:"!embed/v/(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!teamcoco\\.com/video/\\D!";i:1;R:222;}}}}}s:3:"ted";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:1;R:191;}}i:1;R:194;}s:8:"telegram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"@//t.me/(?!addstickers/|joinchat/)(?\'id\'\\w+/\\d+)@";i:1;R:191;}}i:1;R:194;}s:11:"theatlantic";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:11:"theguardian";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!theguardian\\.com/(?\'id\'\\w+/video/20(?:0[0-9]|1[0-7])[-/\\w]+)!";i:1;R:191;}}i:1;R:194;}s:8:"theonion";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:6:"tiktok";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:61:"#tiktok\\.com/(?:@[.\\w]+/video|v|i18n/share/video)/(?\'id\'\\d+)#";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1266;s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"#//vm\\.tiktok\\.com/.#";i:1;R:222;}}}}}s:3:"tmz";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:1;R:191;}}i:1;R:194;}s:11:"tradingview";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!tradingview\\.com/(?:chart/[^/]+|i)/(?\'chart\'\\w+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"chart";}}i:1;a:2:{i:0;s:45:"!tradingview\\.com/symbols/(?\'symbol\'[-:\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"symbol";}}}i:1;R:194;}s:13:"traileraddict";a:2:{i:0;R:194;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;R:222;}}}}}s:13:"trendingviews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:89:"!(?:mydailyfreedom\\.com|trendingviews\\.co)/(?:tv/)?(?:embed|video)/(?:[^/]+-)?(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:6:"tumblr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:27:"!did=\\\\u0022(?\'did\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"did";}}i:1;a:2:{i:0;s:31:"!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"key";}}}s:6:"header";s:16:"User-agent: curl";s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;R:222;}}s:3:"url";s:75:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}";}}}s:21:"twentyfoursevensports";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!247sports\\.com/PlayerSport/[-\\w]*?(?\'player_id\'\\d+)/Embed!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"player_id";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";R:1331;s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!247sports\\.com/Player/[-\\w]*?\\d!";i:1;R:222;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:38:"!embedVideoContainer_(?\'video_id\'\\d+)!";i:1;R:872;}}s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!247sports\\.com/Video/.!";i:1;R:222;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;R:872;}i:1;a:2:{i:0;s:73:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'[-\\w]+))?#";i:1;R:877;}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:445;}i:3;a:2:{i:0;s:59:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'[-\\w]+)#";i:1;R:877;}}i:1;R:194;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@twitter\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:191;}}i:1;R:194;}s:7:"ustream";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:1;R:1097;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!embed/(?\'cid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"cid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;R:222;}}}}}s:5:"vbox7";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:1;R:191;}}i:1;R:194;}s:4:"veoh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:4:"vevo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!vevo\\.com/watch/(.*?/)?(?\'id\'[A-Z]+\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}}i:1;R:194;}s:14:"videodetective";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:1;R:191;}}i:1;R:194;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";i:1;R:191;}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:445;}}i:1;R:194;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:191;}}i:1;R:194;}s:2:"vk";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:97:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}i:1;a:2:{i:0;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:1;R:1414;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:99:"#meta property="og:video" content=".*?oid=(?\'oid\'-?\\d+).*?id=(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)#";i:1;R:1414;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:15:"#^(?!.*?hash=)#";i:1;R:222;}}}}}s:7:"vocaroo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!voca(?:\\.ro|roo\\.com)/(?:i/)?(?\'id\'\\w+)!";i:1;R:191;}}i:1;R:194;}s:3:"vox";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:14:"washingtonpost";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:1;R:191;}i:1;a:2:{i:0;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:1;R:191;}}i:1;R:194;}s:6:"wistia";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)(?\'id\'\\w+)!";i:1;R:191;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:33:"!"type":"(?:\\w+_)?(?\'type\'audio)!";i:1;R:492;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:55:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)\\w!";i:1;R:222;}}s:3:"url";s:42:"https://fast.wistia.net/embed/iframe/{@id}";}}}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!worldstar(?:hiphop)?\\.com/(?:emb|featur)ed/(?\'id\'\\d+)!";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:18:"!v: ?"?(?\'id\'\\d+)!";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:54:"!worldstar(?:hiphop)?\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:222;}}}}}s:3:"wsj";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;R:191;}i:1;a:2:{i:0;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:1;R:191;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";i:1;R:191;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;R:222;}}}}}s:9:"xboxclips";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"@(?:gameclips\\.io|xboxclips\\.com)/(?!game/)(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:1;R:420;}}i:1;R:194;}s:7:"xboxdvr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!(?:gamer|xbox)dvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:1;R:420;}}i:1;R:194;}s:5:"youku";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+=*)!";i:1;R:191;}}i:1;R:194;}s:8:"youmaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!youmaker\\.com/(?:embed|v(?:ideo)?)/(?\'id\'[-\\w]+)!";i:1;R:191;}}i:1;R:194;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:77:"!youtube\\.com/(?:watch.*?v=|shorts/|v/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:191;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:191;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:445;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;R:194;}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:1:{i:0;i:771;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:132:{s:7:"ABCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:194;}}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:1:{i:0;i:256;}}s:5:"ACAST";a:7:{s:10:"attributes";a:3:{s:10:"episode_id";R:1519;s:7:"show_id";R:1519;s:1:"t";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"AMAZON";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:8:"required";b:1;s:11:"filterChain";R:194;}s:3:"tld";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"ANCHOR";R:1517;s:13:"APPLEPODCASTS";a:7:{s:10:"attributes";a:3:{s:7:"country";R:1519;s:10:"episode_id";R:1519;s:10:"podcast_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:9:"AUDIOBOOM";R:1517;s:9:"AUDIOMACK";a:7:{s:10:"attributes";a:3:{s:6:"artist";R:1519;s:4:"mode";R:1519;s:5:"title";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"AUDIUS";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1519;s:11:"playlist_id";R:1519;s:8:"track_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1519;s:8:"track_id";R:1519;s:9:"track_num";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"BBCNEWS";R:1517;s:8:"BITCHUTE";R:1517;s:14:"BLEACHERREPORT";R:1517;s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:3:{s:5:"bckey";R:1519;s:5:"bcpid";R:1519;s:5:"bctid";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"CASTOS";a:7:{s:10:"attributes";a:2:{s:4:"host";R:1519;s:2:"id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"CBSNEWS";R:1517;s:4:"CLYP";R:1517;s:4:"CNBC";R:1517;s:3:"CNN";R:1517;s:8:"CNNMONEY";R:1517;s:7:"CODEPEN";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1519;s:4:"user";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:13:"COMEDYCENTRAL";R:1517;s:4:"COUB";R:1517;s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1519;s:1:"t";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:12:"DEMOCRACYNOW";R:1517;s:7:"DUMPERT";R:1517;s:11:"EIGHTTRACKS";R:1517;s:4:"ESPN";R:1517;s:8:"FACEBOOK";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1519;s:4:"type";R:1519;s:4:"user";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"FALSTAD";a:7:{s:10:"attributes";a:2:{s:3:"cct";R:1519;s:3:"ctz";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"FLICKR";R:1517;s:7:"FOXNEWS";R:1517;s:10:"FUNNYORDIE";R:1517;s:8:"GAMESPOT";R:1517;s:5:"GETTY";a:7:{s:10:"attributes";a:5:{s:2:"et";R:1519;s:6:"height";a:3:{s:12:"defaultValue";i:360;s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}s:2:"id";R:1519;s:3:"sig";R:1519;s:5:"width";a:3:{s:12:"defaultValue";i:640;s:11:"filterChain";R:1602;s:8:"required";b:0;}}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"GFYCAT";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1600;s:2:"id";R:1519;s:5:"width";R:1608;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:4:"GIFS";R:1614;s:5:"GIPHY";a:7:{s:10:"attributes";a:4:{s:6:"height";R:1600;s:2:"id";R:1519;s:4:"type";R:1519;s:5:"width";R:1608;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:4:"GIST";R:1517;s:10:"GLOBALNEWS";R:1517;s:8:"GOFUNDME";R:1517;s:11:"GOOGLEDRIVE";R:1517;s:10:"GOOGLEPLUS";a:7:{s:10:"attributes";a:3:{s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";R:1605;}}s:8:"required";b:0;}s:3:"oid";R:1519;s:3:"pid";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:12:"GOOGLESHEETS";a:7:{s:10:"attributes";a:4:{s:3:"gid";R:1519;s:2:"id";R:1519;s:3:"oid";R:1519;s:4:"type";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:4:"HUDL";a:7:{s:10:"attributes";a:3:{s:7:"athlete";R:1519;s:9:"highlight";R:1519;s:2:"id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:4:"HULU";R:1517;s:3:"IGN";R:1517;s:4:"IMDB";R:1517;s:5:"IMGUR";R:1517;s:9:"INDIEGOGO";R:1517;s:9:"INSTAGRAM";R:1517;s:15:"INTERNETARCHIVE";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1600;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:23:"htmlspecialchars_decode";s:6:"params";R:1605;}}s:8:"required";b:0;}s:5:"width";R:1608;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:8:"IZLESENE";R:1517;s:8:"JSFIDDLE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1519;s:8:"revision";R:1519;s:4:"user";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:10:"JWPLATFORM";R:1517;s:7:"KALTURA";a:7:{s:10:"attributes";a:4:{s:8:"entry_id";R:1543;s:10:"partner_id";R:1543;s:2:"sp";R:1519;s:9:"uiconf_id";R:1543;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:3:"KHL";R:1517;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:1519;s:2:"id";R:1519;s:5:"video";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"LIBSYN";R:1517;s:8:"LIVELEAK";R:1517;s:10:"LIVESTREAM";a:7:{s:10:"attributes";a:5:{s:10:"account_id";R:1519;s:7:"channel";R:1519;s:7:"clip_id";R:1519;s:8:"event_id";R:1519;s:8:"video_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"MAILRU";R:1517;s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:194;s:9:"bitNumber";i:0;s:7:"allowed";a:1:{i:0;i:770;}}s:6:"MEDIUM";R:1517;s:9:"MEGAPHONE";R:1517;s:8:"METACAFE";R:1517;s:8:"MIXCLOUD";R:1517;s:3:"MLB";R:1517;s:5:"MRCTV";R:1517;s:5:"MSNBC";R:1517;s:13:"NATGEOCHANNEL";R:1517;s:11:"NATGEOVIDEO";R:1517;s:7:"NBCNEWS";R:1517;s:9:"NBCSPORTS";R:1517;s:3:"NHL";a:7:{s:10:"attributes";a:2:{s:1:"c";R:1519;s:1:"t";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:3:"NPR";a:7:{s:10:"attributes";a:2:{s:1:"i";R:1519;s:1:"m";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"NYTIMES";R:1517;s:6:"ODYSEE";R:1517;s:6:"ORFIUM";a:7:{s:10:"attributes";a:4:{s:8:"album_id";R:1519;s:11:"playlist_id";R:1519;s:6:"set_id";R:1519;s:8:"track_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:8:"PASTEBIN";R:1517;s:9:"PINTEREST";R:1517;s:7:"PODBEAN";R:1517;s:5:"PREZI";R:1517;s:6:"REDDIT";R:1517;s:6:"RUMBLE";R:1517;s:6:"RUTUBE";R:1517;s:6:"SCRIBD";R:1517;s:7:"SENDVID";R:1517;s:10:"SLIDESHARE";R:1517;s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:1519;s:11:"playlist_id";R:1519;s:12:"secret_token";R:1519;s:8:"track_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"SPORCLE";R:1517;s:9:"SPORTSNET";R:1517;s:7:"SPOTIFY";R:1517;s:8:"SPREAKER";a:7:{s:10:"attributes";a:2:{s:10:"episode_id";R:1519;s:7:"show_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:10:"STEAMSTORE";R:1517;s:8:"STITCHER";a:7:{s:10:"attributes";a:2:{s:3:"eid";R:1519;s:3:"fid";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:9:"STRAWPOLL";R:1517;s:10:"STREAMABLE";R:1517;s:8:"STREAMJA";R:1517;s:8:"TEAMCOCO";R:1517;s:3:"TED";R:1517;s:8:"TELEGRAM";R:1517;s:11:"THEATLANTIC";R:1517;s:11:"THEGUARDIAN";R:1517;s:8:"THEONION";R:1517;s:6:"TIKTOK";R:1517;s:3:"TMZ";R:1517;s:11:"TRADINGVIEW";a:7:{s:10:"attributes";a:2:{s:5:"chart";R:1519;s:6:"symbol";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:13:"TRAILERADDICT";R:1517;s:13:"TRENDINGVIEWS";R:1517;s:6:"TUMBLR";a:7:{s:10:"attributes";a:4:{s:3:"did";R:1519;s:2:"id";R:1519;s:3:"key";R:1519;s:4:"name";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:21:"TWENTYFOURSEVENSPORTS";a:7:{s:10:"attributes";a:2:{s:9:"player_id";R:1519;s:8:"video_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:1519;s:7:"clip_id";R:1519;s:1:"t";R:1519;s:8:"video_id";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"TWITTER";R:1517;s:7:"USTREAM";a:7:{s:10:"attributes";a:2:{s:3:"cid";R:1519;s:3:"vid";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:5:"VBOX7";R:1517;s:4:"VEOH";R:1517;s:4:"VEVO";R:1517;s:14:"VIDEODETECTIVE";R:1517;s:5:"VIMEO";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1519;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:1605;}}s:8:"required";b:0;}}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:4:"VINE";R:1517;s:2:"VK";a:7:{s:10:"attributes";a:3:{s:4:"hash";R:1519;s:3:"oid";R:1519;s:3:"vid";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:7:"VOCAROO";R:1517;s:3:"VOX";R:1517;s:14:"WASHINGTONPOST";R:1517;s:6:"WISTIA";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1519;s:4:"type";R:1519;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}s:4:"WSHH";R:1517;s:3:"WSJ";R:1517;s:9:"XBOXCLIPS";R:1578;s:7:"XBOXDVR";R:1578;s:5:"YOUKU";R:1517;s:8:"YOUMAKER";R:1517;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:4:"list";R:1519;s:1:"t";R:1748;}s:11:"filterChain";R:1521;s:12:"nestingLimit";i:10;s:5:"rules";R:1530;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1534;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:10:{s:20:"AMAZON_ASSOCIATE_TAG";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_CA";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_DE";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_ES";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_FR";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IN";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IT";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_JP";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_UK";s:0:"";s:16:"MEDIAEMBED_THEME";s:0:"";}}');
	}
}