/* Generated by re2c 2.0.3 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))


static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API zend_result zend_lex_tstring(zval *zv, unsigned char *ident)
{
	unsigned char *end = ident;
	while ((*end >= 'a' && *end <= 'z') || (*end >= 'A' && *end <= 'Z') || *end == '_') {
		end++;
	}

	size_t length = end - ident;
	if (length == 0) {
		ZEND_ASSERT(ident[0] == '<' && ident[1] == '?' && ident[2] == '=');
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, (char *) ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char *) ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		file_handle->in_list = 1;
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	file_handle->in_list = 1;

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_copy(file_handle->filename);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		zend_init_static_variables_map_ptr(op_array);
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, ZSTR_VAL(file_handle->filename));
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, ZSTR_VAL(file_handle->filename));
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, zend_string *filename) {
	zval code_zv;
	bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zend_string *filename)
{
	zend_file_handle file_handle;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	zend_stream_init_filename_ex(&file_handle, filename);

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(filename);
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, zend_string *filename)
{
	char *buf;
	size_t size, old_len;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);
	zend_set_compiled_filename(filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_string *filename_str;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	filename_str = zend_string_init(filename, strlen(filename), 0);
	zend_prepare_string_for_scanning(&tmp, filename_str);
	zend_string_release(filename_str);
	BEGIN(ST_IN_SCRIPTING);
	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_destroy_file_handle(&file_handle);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zend_string *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *filename)
{
	zend_lex_state original_lex_state;
	zval str_zv;
	zend_string *filename_str = zend_string_init(filename, strlen(filename), 0);
	ZVAL_STR_COPY(&str_zv, str);
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&str_zv, filename_str);
	zend_string_release(filename_str);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&str_zv);
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, bool using_spaces,
	bool newline_at_start, bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end(void)
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  18,   2,   0,   0,   2,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 18,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			236, 236, 204, 204, 204, 204, 204, 204, 
			140, 140,   0,   0,   0,   0,   0,   0, 
			  0, 136, 136, 136, 136, 136, 136,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  0, 136, 136, 136, 136, 136, 136,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   0, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy4;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy2;
		case ' ':
		case '!':	goto yy7;
		case '"':	goto yy9;
		case '#':	goto yy11;
		case '$':	goto yy13;
		case '%':	goto yy14;
		case '&':	goto yy15;
		case '\'':	goto yy17;
		case '(':	goto yy19;
		case ')':
		case ']':	goto yy21;
		case '*':	goto yy23;
		case '+':	goto yy24;
		case ',':
		case ';':
		case '@':
		case '~':	goto yy25;
		case '-':	goto yy26;
		case '.':	goto yy27;
		case '/':	goto yy28;
		case '0':	goto yy29;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy31;
		case ':':	goto yy33;
		case '<':	goto yy34;
		case '=':	goto yy35;
		case '>':	goto yy36;
		case '?':	goto yy37;
		case 'A':
		case 'a':	goto yy38;
		case 'B':
		case 'b':	goto yy40;
		case 'C':
		case 'c':	goto yy41;
		case 'D':
		case 'd':	goto yy42;
		case 'E':
		case 'e':	goto yy43;
		case 'F':
		case 'f':	goto yy44;
		case 'G':
		case 'g':	goto yy45;
		case 'I':
		case 'i':	goto yy48;
		case 'L':
		case 'l':	goto yy49;
		case 'M':
		case 'm':	goto yy50;
		case 'N':
		case 'n':	goto yy51;
		case 'O':
		case 'o':	goto yy52;
		case 'P':
		case 'p':	goto yy53;
		case 'R':
		case 'r':	goto yy54;
		case 'S':
		case 's':	goto yy55;
		case 'T':
		case 't':	goto yy56;
		case 'U':
		case 'u':	goto yy57;
		case 'V':
		case 'v':	goto yy58;
		case 'W':
		case 'w':	goto yy59;
		case 'X':
		case 'x':	goto yy60;
		case 'Y':
		case 'y':	goto yy61;
		case '[':	goto yy62;
		case '\\':	goto yy63;
		case '^':	goto yy65;
		case '_':	goto yy66;
		case '`':	goto yy67;
		case '{':	goto yy69;
		case '|':	goto yy71;
		case '}':	goto yy72;
		default:	goto yy46;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy74;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '[') goto yy76;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy8;
			if (yych <= 'Z') goto yy78;
			if (yych <= '^') goto yy8;
			goto yy78;
		} else {
			if (yych <= '`') goto yy8;
			if (yych <= 'z') goto yy78;
			if (yych <= 0x7F) goto yy8;
			goto yy78;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy81;
		goto yy8;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy83;
		}
		if (yych <= '&') {
			if (yych == '$') goto yy86;
			if (yych >= '&') goto yy88;
		} else {
			if (yych <= '.') {
				if (yych >= '.') goto yy90;
			} else {
				if (yych == '=') goto yy91;
			}
		}
yy16:
		YYDEBUG(16, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AMPERSAND_NOT_FOLLOWED_BY_VAR_OR_VARARG);
}
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy94;
					if (yych >= ' ') goto yy94;
				} else {
					if (yych <= '@') goto yy20;
					if (yych != 'C') goto yy94;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy94;
					if (yych >= 'I') goto yy94;
				} else {
					if (yych == 'O') goto yy94;
					if (yych >= 'R') goto yy94;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy94;
					if (yych >= 'a') goto yy94;
				} else {
					if (yych == 'd') goto yy94;
					if (yych >= 'f') goto yy94;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy94;
					if (yych >= 'o') goto yy94;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy94;
					} else {
						if (yych == 'u') goto yy94;
					}
				}
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(22, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy104;
		if (yych == '=') goto yy106;
		goto yy8;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy108;
		if (yych == '=') goto yy110;
		goto yy8;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		goto yy8;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy112;
			goto yy8;
		} else {
			if (yych <= '=') goto yy114;
			if (yych <= '>') goto yy116;
			goto yy8;
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy118;
			goto yy8;
		} else {
			if (yych <= '9') goto yy119;
			if (yych == '=') goto yy122;
			goto yy8;
		}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy124;
			goto yy8;
		} else {
			if (yych <= '/') goto yy126;
			if (yych == '=') goto yy127;
			goto yy8;
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'N') {
				if (yych == 'B') goto yy130;
				goto yy32;
			} else {
				if (yych <= 'O') goto yy132;
				if (yych <= 'W') goto yy32;
				goto yy133;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy130;
				goto yy32;
			} else {
				if (yych <= 'o') goto yy132;
				if (yych == 'x') goto yy133;
				goto yy32;
			}
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	bool is_octal = lnum[0] == '0';
	bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy31;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy129;
			if (yych <= 'D') goto yy30;
			goto yy131;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy30;
				goto yy134;
			} else {
				if (yych == 'e') goto yy131;
				goto yy30;
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy135;
		goto yy8;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy8;
		if (yych <= '<') goto yy137;
		if (yych <= '=') goto yy139;
		if (yych <= '>') goto yy141;
		goto yy8;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy142;
		if (yych <= '>') goto yy144;
		goto yy8;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy146;
		if (yych <= '>') goto yy148;
		goto yy8;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy150;
			goto yy8;
		} else {
			if (yych <= '>') goto yy151;
			if (yych <= '?') goto yy153;
			goto yy8;
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy155;
				goto yy47;
			} else {
				if (yych <= 'N') goto yy156;
				if (yych <= 'Q') goto yy47;
				if (yych <= 'R') goto yy157;
				goto yy158;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy155;
				if (yych <= 'm') goto yy47;
				goto yy156;
			} else {
				if (yych <= 'q') goto yy47;
				if (yych <= 'r') goto yy157;
				if (yych <= 's') goto yy158;
				goto yy47;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy47;
				goto yy9;
			} else {
				if (yych == '\'') goto yy17;
				goto yy47;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy161;
				if (yych <= 'Q') goto yy47;
				goto yy162;
			} else {
				if (yych == 'r') goto yy162;
				goto yy47;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy163;
				goto yy47;
			} else {
				if (yych <= 'L') goto yy164;
				if (yych <= 'N') goto yy47;
				goto yy165;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy163;
				goto yy47;
			} else {
				if (yych <= 'l') goto yy164;
				if (yych == 'o') goto yy165;
				goto yy47;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy166;
				goto yy47;
			} else {
				if (yych <= 'I') goto yy167;
				if (yych <= 'N') goto yy47;
				goto yy168;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy166;
				goto yy47;
			} else {
				if (yych <= 'i') goto yy167;
				if (yych == 'o') goto yy168;
				goto yy47;
			}
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy170;
		case 'L':
		case 'l':	goto yy171;
		case 'M':
		case 'm':	goto yy172;
		case 'N':
		case 'n':	goto yy173;
		case 'V':
		case 'v':	goto yy174;
		case 'X':
		case 'x':	goto yy175;
		default:	goto yy47;
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy176;
				goto yy47;
			} else {
				if (yych <= 'N') goto yy177;
				if (yych <= 'O') goto yy179;
				if (yych <= 'T') goto yy47;
				goto yy180;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy176;
				if (yych <= 'm') goto yy47;
				goto yy177;
			} else {
				if (yych <= 'o') goto yy179;
				if (yych == 'u') goto yy180;
				goto yy47;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy181;
			if (yych <= 'N') goto yy47;
			goto yy182;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy47;
				goto yy181;
			} else {
				if (yych == 'o') goto yy182;
				goto yy47;
			}
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy47:
		YYDEBUG(47, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
		goto yy39;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy183;
				goto yy47;
			} else {
				if (yych <= 'M') goto yy185;
				if (yych <= 'N') goto yy186;
				if (yych <= 'R') goto yy47;
				goto yy187;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy183;
				if (yych <= 'l') goto yy47;
				goto yy185;
			} else {
				if (yych <= 'n') goto yy186;
				if (yych == 's') goto yy187;
				goto yy47;
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy188;
		if (yych == 'i') goto yy188;
		goto yy47;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy189;
		if (yych == 'a') goto yy189;
		goto yy47;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy190;
			if (yych <= 'D') goto yy47;
			goto yy191;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy190;
			} else {
				if (yych == 'e') goto yy191;
				goto yy47;
			}
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy192;
		if (yych == 'r') goto yy192;
		goto yy47;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy194;
			if (yych <= 'T') goto yy47;
			goto yy195;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy47;
				goto yy194;
			} else {
				if (yych == 'u') goto yy195;
				goto yy47;
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy196;
		if (yych == 'e') goto yy196;
		goto yy47;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy197;
			if (yych <= 'V') goto yy47;
			goto yy198;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy47;
				goto yy197;
			} else {
				if (yych == 'w') goto yy198;
				goto yy47;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy199;
			if (yych <= 'Q') goto yy47;
			goto yy200;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy47;
				goto yy199;
			} else {
				if (yych == 'r') goto yy200;
				goto yy47;
			}
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy201;
			if (yych <= 'R') goto yy47;
			goto yy202;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy47;
				goto yy201;
			} else {
				if (yych == 's') goto yy202;
				goto yy47;
			}
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy203;
		if (yych == 'a') goto yy203;
		goto yy47;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy204;
		if (yych == 'h') goto yy204;
		goto yy47;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy205;
		if (yych == 'o') goto yy205;
		goto yy47;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy206;
		if (yych == 'i') goto yy206;
		goto yy47;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		goto yy20;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy64;
			if (yych <= 'Z') goto yy207;
			if (yych >= '_') goto yy207;
		} else {
			if (yych <= '`') goto yy64;
			if (yych <= 'z') goto yy207;
			if (yych >= 0x80) goto yy207;
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy210;
		goto yy8;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy212;
		goto yy47;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(70, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy213;
		if (yych == '|') goto yy215;
		goto yy8;
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy217;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(79, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy78;
			} else {
				if (yych <= '@') goto yy80;
				if (yych <= 'Z') goto yy78;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy78;
			} else {
				if (yych <= 'z') goto yy78;
				if (yych >= 0x80) goto yy78;
			}
		}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy83;
		}
		if (yych == '$') goto yy86;
		if (yych == '.') goto yy90;
yy85:
		YYDEBUG(85, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 45) {
			if (yyaccept <= 22) {
				if (yyaccept <= 11) {
					if (yyaccept <= 5) {
						if (yyaccept <= 2) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy16;
								} else {
									goto yy20;
								}
							} else {
								goto yy8;
							}
						} else {
							if (yyaccept <= 4) {
								if (yyaccept == 3) {
									goto yy30;
								} else {
									goto yy39;
								}
							} else {
								goto yy121;
							}
						}
					} else {
						if (yyaccept <= 8) {
							if (yyaccept <= 7) {
								if (yyaccept == 6) {
									goto yy125;
								} else {
									goto yy138;
								}
							} else {
								goto yy159;
							}
						} else {
							if (yyaccept <= 10) {
								if (yyaccept == 9) {
									goto yy169;
								} else {
									goto yy178;
								}
							} else {
								goto yy184;
							}
						}
					}
				} else {
					if (yyaccept <= 17) {
						if (yyaccept <= 14) {
							if (yyaccept <= 13) {
								if (yyaccept == 12) {
									goto yy193;
								} else {
									goto yy209;
								}
							} else {
								goto yy238;
							}
						} else {
							if (yyaccept <= 16) {
								if (yyaccept == 15) {
									goto yy244;
								} else {
									goto yy247;
								}
							} else {
								goto yy266;
							}
						}
					} else {
						if (yyaccept <= 20) {
							if (yyaccept <= 19) {
								if (yyaccept == 18) {
									goto yy270;
								} else {
									goto yy282;
								}
							} else {
								goto yy293;
							}
						} else {
							if (yyaccept == 21) {
								goto yy306;
							} else {
								goto yy317;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 34) {
					if (yyaccept <= 28) {
						if (yyaccept <= 25) {
							if (yyaccept <= 24) {
								if (yyaccept == 23) {
									goto yy320;
								} else {
									goto yy322;
								}
							} else {
								goto yy325;
							}
						} else {
							if (yyaccept <= 27) {
								if (yyaccept == 26) {
									goto yy357;
								} else {
									goto yy366;
								}
							} else {
								goto yy368;
							}
						}
					} else {
						if (yyaccept <= 31) {
							if (yyaccept <= 30) {
								if (yyaccept == 29) {
									goto yy377;
								} else {
									goto yy379;
								}
							} else {
								goto yy386;
							}
						} else {
							if (yyaccept <= 33) {
								if (yyaccept == 32) {
									goto yy393;
								} else {
									goto yy442;
								}
							} else {
								goto yy444;
							}
						}
					}
				} else {
					if (yyaccept <= 40) {
						if (yyaccept <= 37) {
							if (yyaccept <= 36) {
								if (yyaccept == 35) {
									goto yy447;
								} else {
									goto yy449;
								}
							} else {
								goto yy451;
							}
						} else {
							if (yyaccept <= 39) {
								if (yyaccept == 38) {
									goto yy453;
								} else {
									goto yy459;
								}
							} else {
								goto yy463;
							}
						}
					} else {
						if (yyaccept <= 43) {
							if (yyaccept <= 42) {
								if (yyaccept == 41) {
									goto yy470;
								} else {
									goto yy480;
								}
							} else {
								goto yy482;
							}
						} else {
							if (yyaccept == 44) {
								goto yy485;
							} else {
								goto yy494;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 68) {
				if (yyaccept <= 57) {
					if (yyaccept <= 51) {
						if (yyaccept <= 48) {
							if (yyaccept <= 47) {
								if (yyaccept == 46) {
									goto yy496;
								} else {
									goto yy498;
								}
							} else {
								goto yy500;
							}
						} else {
							if (yyaccept <= 50) {
								if (yyaccept == 49) {
									goto yy502;
								} else {
									goto yy537;
								}
							} else {
								goto yy540;
							}
						}
					} else {
						if (yyaccept <= 54) {
							if (yyaccept <= 53) {
								if (yyaccept == 52) {
									goto yy544;
								} else {
									goto yy552;
								}
							} else {
								goto yy562;
							}
						} else {
							if (yyaccept <= 56) {
								if (yyaccept == 55) {
									goto yy565;
								} else {
									goto yy567;
								}
							} else {
								goto yy569;
							}
						}
					}
				} else {
					if (yyaccept <= 63) {
						if (yyaccept <= 60) {
							if (yyaccept <= 59) {
								if (yyaccept == 58) {
									goto yy597;
								} else {
									goto yy599;
								}
							} else {
								goto yy607;
							}
						} else {
							if (yyaccept <= 62) {
								if (yyaccept == 61) {
									goto yy609;
								} else {
									goto yy611;
								}
							} else {
								goto yy615;
							}
						}
					} else {
						if (yyaccept <= 66) {
							if (yyaccept <= 65) {
								if (yyaccept == 64) {
									goto yy621;
								} else {
									goto yy624;
								}
							} else {
								goto yy628;
							}
						} else {
							if (yyaccept == 67) {
								goto yy641;
							} else {
								goto yy643;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 80) {
					if (yyaccept <= 74) {
						if (yyaccept <= 71) {
							if (yyaccept <= 70) {
								if (yyaccept == 69) {
									goto yy645;
								} else {
									goto yy650;
								}
							} else {
								goto yy654;
							}
						} else {
							if (yyaccept <= 73) {
								if (yyaccept == 72) {
									goto yy666;
								} else {
									goto yy670;
								}
							} else {
								goto yy677;
							}
						}
					} else {
						if (yyaccept <= 77) {
							if (yyaccept <= 76) {
								if (yyaccept == 75) {
									goto yy684;
								} else {
									goto yy686;
								}
							} else {
								goto yy688;
							}
						} else {
							if (yyaccept <= 79) {
								if (yyaccept == 78) {
									goto yy690;
								} else {
									goto yy694;
								}
							} else {
								goto yy700;
							}
						}
					}
				} else {
					if (yyaccept <= 86) {
						if (yyaccept <= 83) {
							if (yyaccept <= 82) {
								if (yyaccept == 81) {
									goto yy702;
								} else {
									goto yy704;
								}
							} else {
								goto yy708;
							}
						} else {
							if (yyaccept <= 85) {
								if (yyaccept == 84) {
									goto yy711;
								} else {
									goto yy718;
								}
							} else {
								goto yy725;
							}
						}
					} else {
						if (yyaccept <= 89) {
							if (yyaccept <= 88) {
								if (yyaccept == 87) {
									goto yy736;
								} else {
									goto yy738;
								}
							} else {
								goto yy740;
							}
						} else {
							if (yyaccept == 90) {
								goto yy746;
							} else {
								goto yy749;
							}
						}
					}
				}
			}
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(1);
	RETURN_TOKEN(T_AMPERSAND_FOLLOWED_BY_VAR_OR_VARARG);
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy219;
		goto yy85;
yy91:
		YYDEBUG(91, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy94:
		YYDEBUG(94, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy93;
					if (yych <= 0x1F) goto yy85;
					goto yy93;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy85;
					} else {
						if (yych <= 'B') goto yy96;
						if (yych <= 'C') goto yy85;
						goto yy97;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy98;
					if (yych <= 'H') goto yy85;
					goto yy99;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy85;
						goto yy100;
					} else {
						if (yych <= 'Q') goto yy85;
						if (yych <= 'R') goto yy101;
						goto yy102;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy103;
					if (yych <= '`') goto yy85;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy96;
						goto yy85;
					} else {
						if (yych <= 'd') goto yy97;
						if (yych <= 'e') goto yy85;
						goto yy98;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy85;
						goto yy99;
					} else {
						if (yych == 'o') goto yy100;
						goto yy85;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy101;
						goto yy102;
					} else {
						if (yych == 'u') goto yy103;
						goto yy85;
					}
				}
			}
		}
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy220;
		if (yych == 'r') goto yy220;
		goto yy85;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy221;
			if (yych <= 'N') goto yy85;
			goto yy222;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy85;
				goto yy221;
			} else {
				if (yych == 'o') goto yy222;
				goto yy85;
			}
		}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy223;
		if (yych == 'o') goto yy223;
		goto yy85;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy224;
		if (yych == 'l') goto yy224;
		goto yy85;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy225;
		if (yych == 'n') goto yy225;
		goto yy85;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy226;
		if (yych == 'b') goto yy226;
		goto yy85;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy227;
		if (yych == 'e') goto yy227;
		goto yy85;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy228;
		if (yych == 't') goto yy228;
		goto yy85;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy229;
		if (yych == 'n') goto yy229;
		goto yy85;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy230;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy232;
		goto yy85;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy120:
		YYDEBUG(120, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy121;
			if (yych <= '9') goto yy119;
			if (yych >= 'E') goto yy131;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy234;
			} else {
				if (yych == 'e') goto yy131;
			}
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy235;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy126:
		YYDEBUG(126, *YYCURSOR);
		++YYCURSOR;
		goto yy12;
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy121;
		goto yy120;
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy236;
		}
		goto yy85;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy239;
			goto yy85;
		} else {
			if (yych <= '-') goto yy239;
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy240;
			goto yy85;
		}
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy242;
		}
		goto yy85;
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy245;
		}
		goto yy85;
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy31;
		}
		goto yy85;
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy138;
		if (yych <= '<') goto yy248;
		if (yych <= '=') goto yy250;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy252;
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
		goto yy75;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy254;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy146:
		YYDEBUG(146, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy256;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy258;
		goto yy85;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy260;
		if (yych == '\r') goto yy261;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy262;
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy264;
		if (yych == 's') goto yy264;
		goto yy47;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy265;
		if (yych == 'd') goto yy265;
		goto yy47;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy267;
		if (yych == 'r') goto yy267;
		goto yy47;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy268;
			if (yych <= '^') goto yy85;
			goto yy268;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy268;
			if (yych <= 0x7F) goto yy85;
			goto yy268;
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy271;
		goto yy85;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy272;
		if (yych == 'e') goto yy272;
		goto yy47;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy47;
				goto yy273;
			} else {
				if (yych <= 'R') goto yy47;
				if (yych <= 'S') goto yy274;
				goto yy275;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy273;
				goto yy47;
			} else {
				if (yych <= 's') goto yy274;
				if (yych <= 't') goto yy275;
				goto yy47;
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy276;
			if (yych <= 'N') goto yy47;
			goto yy277;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy276;
			} else {
				if (yych == 'o') goto yy277;
				goto yy47;
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy278;
		if (yych == 'n') goto yy278;
		goto yy47;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy279;
			if (yych <= 'E') goto yy47;
			goto yy280;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy47;
				goto yy279;
			} else {
				if (yych == 'f') goto yy280;
				goto yy47;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy281;
		if (yych == 'e') goto yy281;
		goto yy47;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy283;
		if (yych == 'h') goto yy283;
		goto yy47;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy284;
		if (yych == 's') goto yy284;
		goto yy47;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy285;
		if (yych == 'p') goto yy285;
		goto yy47;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'D') goto yy286;
			if (yych <= 'T') goto yy47;
			goto yy287;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy47;
				goto yy286;
			} else {
				if (yych == 'u') goto yy287;
				goto yy47;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy288;
		if (yych == 'a') goto yy288;
		goto yy47;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy289;
			if (yych <= 'S') goto yy47;
			goto yy290;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy289;
			} else {
				if (yych == 't') goto yy290;
				goto yy47;
			}
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy291;
		if (yych == 'n') goto yy291;
		goto yy47;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy292;
		if (yych == 'r') goto yy292;
		goto yy47;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy294;
		if (yych == 'n') goto yy294;
		goto yy47;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy295;
		if (yych == 'o') goto yy295;
		goto yy47;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy296;
		if (yych == 't') goto yy296;
		goto yy47;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy297;
		if (yych == 'p') goto yy297;
		goto yy47;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy47;
				goto yy298;
			} else {
				if (yych <= 'R') goto yy47;
				if (yych <= 'S') goto yy299;
				goto yy300;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy298;
				goto yy47;
			} else {
				if (yych <= 's') goto yy299;
				if (yych <= 't') goto yy300;
				goto yy47;
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy301;
		if (yych == 's') goto yy301;
		goto yy47;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy302;
		if (yych == 's') goto yy302;
		goto yy47;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy303;
		if (yych == 't') goto yy303;
		goto yy47;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy304;
		if (yych == 'm') goto yy304;
		goto yy47;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy305;
		if (yych == 'w') goto yy305;
		goto yy47;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy307;
			if (yych <= 'N') goto yy47;
			goto yy308;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy307;
			} else {
				if (yych == 'o') goto yy308;
				goto yy47;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy309;
		if (yych == 'b') goto yy309;
		goto yy47;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'Q') goto yy310;
			if (yych <= 'S') goto yy47;
			goto yy311;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy47;
				goto yy310;
			} else {
				if (yych == 't') goto yy311;
				goto yy47;
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy312;
		if (yych == 'a') goto yy312;
		goto yy47;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy313;
		if (yych == 'i') goto yy313;
		goto yy47;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy314;
		if (yych == 'r') goto yy314;
		goto yy47;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy315;
			if (yych <= 'X') goto yy47;
			goto yy316;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy315;
			} else {
				if (yych == 'y') goto yy316;
				goto yy47;
			}
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy318;
		if (yych == 's') goto yy318;
		goto yy47;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy319;
		if (yych == 'e') goto yy319;
		goto yy47;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy321;
		if (yych == 'r') goto yy321;
		goto yy47;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy323;
		if (yych == 'i') goto yy323;
		goto yy47;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy324;
		if (yych == 'r') goto yy324;
		goto yy47;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy326;
		if (yych == 'e') goto yy326;
		goto yy47;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy209;
				if (yych <= '9') goto yy207;
			} else {
				if (yych <= 'Z') goto yy207;
				if (yych >= '\\') goto yy327;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy207;
			} else {
				if (yych <= 'z') goto yy207;
				if (yych >= 0x80) goto yy207;
			}
		}
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy328;
		case 'D':
		case 'd':	goto yy329;
		case 'F':
		case 'f':	goto yy330;
		case 'H':
		case 'h':	goto yy331;
		case 'L':
		case 'l':	goto yy332;
		case 'M':
		case 'm':	goto yy333;
		case 'N':
		case 'n':	goto yy334;
		case 'T':
		case 't':	goto yy335;
		default:	goto yy47;
		}
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy86;
		goto yy85;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy336;
		if (yych == 'r') goto yy336;
		goto yy85;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy337;
		if (yych == 'n') goto yy337;
		goto yy85;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy338;
		if (yych == 'o') goto yy338;
		goto yy85;
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy339;
		if (yych == 'u') goto yy339;
		goto yy85;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy340;
		if (yych == 'o') goto yy340;
		goto yy85;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy341;
		if (yych == 't') goto yy341;
		goto yy85;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy342;
		if (yych == 'j') goto yy342;
		goto yy85;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy343;
		if (yych == 'a') goto yy343;
		goto yy85;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy344;
		if (yych == 'r') goto yy344;
		goto yy85;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy345;
		if (yych == 's') goto yy345;
		goto yy85;
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy234:
		YYDEBUG(234, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych <= '9') goto yy119;
		goto yy85;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy85;
			if (yych <= '\n') goto yy346;
			goto yy85;
		} else {
			if (yych <= '\r') goto yy346;
			if (yych == ' ') goto yy346;
			goto yy85;
		}
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(237, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy236;
		}
		if (yych == '_') goto yy130;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych >= ':') goto yy85;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		if (yych <= '/') goto yy121;
		if (yych <= '9') goto yy240;
		if (yych == '_') goto yy239;
		goto yy121;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 15;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(243, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy242;
		}
		if (yych == '_') goto yy132;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0o" */
	size_t len = yyleng - 2;
	char *end, *octal = yytext + 2;
	bool contains_underscores = (memchr(octal, '_', len) != NULL);

	/* Skip any leading 0s */
	while (len > 0 && (*octal == '0' || *octal == '_')) {
		++octal;
		--len;
	}

	if (len == 0) {
		ZVAL_LONG(zendlval, 0);
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	if (contains_underscores) {
		octal = estrndup(octal, len);
		strip_underscores(octal, &len);
	}

	errno = 0;

	ZVAL_LONG(zendlval, ZEND_STRTOL(octal, &end, 8));

	ZEND_ASSERT(end == octal + len);

	if (!errno) {
		if (contains_underscores) {
			efree(octal);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	/* Overflow */
	ZEND_ASSERT(errno == ERANGE);
	/* Reset errno */
	errno = 0;

	/* zend_oct_strtod skips leading '0' */
	ZVAL_DOUBLE(zendlval, zend_oct_strtod(octal, (const char **)&end));
	ZEND_ASSERT(!errno);
	ZEND_ASSERT(end == octal + len);
	if (contains_underscores) {
		efree(octal);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 16;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy245;
		}
		if (yych == '_') goto yy133;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(249, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy248;
				if (yych <= 0x1F) goto yy85;
				goto yy248;
			} else {
				if (yych == '"') goto yy348;
				if (yych <= '&') goto yy85;
				goto yy349;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy85;
				if (yych <= 'Z') goto yy350;
				if (yych <= '^') goto yy85;
				goto yy350;
			} else {
				if (yych <= '`') goto yy85;
				if (yych <= 'z') goto yy350;
				if (yych <= 0x7F) goto yy85;
				goto yy350;
			}
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy254:
		YYDEBUG(254, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(257, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy260:
		YYDEBUG(260, *YYCURSOR);
		++YYCURSOR;
		goto yy152;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy260;
		goto yy152;
yy262:
		YYDEBUG(262, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy352;
		if (yych == 't') goto yy352;
		goto yy47;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy353;
		if (yych == 'a') goto yy353;
		goto yy47;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 18;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(269, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy270;
				if (yych <= '9') goto yy268;
			} else {
				if (yych <= 'Z') goto yy268;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy268;
			} else {
				if (yych <= 'z') goto yy268;
				if (yych >= 0x80) goto yy268;
			}
		}
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy248;
		goto yy85;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy354;
		if (yych == 'a') goto yy354;
		goto yy47;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy355;
		if (yych == 'l') goto yy355;
		goto yy47;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy356;
		if (yych == 'e') goto yy356;
		goto yy47;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy358;
		if (yych == 'c') goto yy358;
		goto yy47;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy359;
		if (yych == 's') goto yy359;
		goto yy47;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy360;
		if (yych == 'n') goto yy360;
		goto yy47;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy47;
			if (yych <= 'S') goto yy361;
			goto yy362;
		} else {
			if (yych <= 'r') goto yy47;
			if (yych <= 's') goto yy361;
			if (yych <= 't') goto yy362;
			goto yy47;
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy47;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy364;
		if (yych == 'a') goto yy364;
		goto yy47;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy365;
		if (yych == 'o') goto yy365;
		goto yy47;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy367;
		if (yych == 'e') goto yy367;
		goto yy47;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy369;
		if (yych == 't') goto yy369;
		goto yy47;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'D':
		case 'd':	goto yy370;
		case 'F':
		case 'f':	goto yy371;
		case 'I':
		case 'i':	goto yy372;
		case 'S':
		case 's':	goto yy373;
		case 'W':
		case 'w':	goto yy374;
		default:	goto yy47;
		}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy375;
		if (yych == 'm') goto yy375;
		goto yy47;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy376;
		if (yych == 'l') goto yy376;
		goto yy47;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy378;
		if (yych == 't') goto yy378;
		goto yy47;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy380;
		if (yych == 'e') goto yy380;
		goto yy47;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy381;
		if (yych == 'a') goto yy381;
		goto yy47;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy293;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'E') goto yy382;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'e') goto yy382;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy383;
		if (yych == 'c') goto yy383;
		goto yy47;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy384;
		if (yych == 'b') goto yy384;
		goto yy47;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy385;
		if (yych == 'o') goto yy385;
		goto yy47;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy387;
		if (yych == 'l') goto yy387;
		goto yy47;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy388;
		if (yych == 'l') goto yy388;
		goto yy47;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy389;
		if (yych == 't') goto yy389;
		goto yy47;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy390;
		if (yych == 'e') goto yy390;
		goto yy47;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy391;
		if (yych == 'e') goto yy391;
		goto yy47;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy392;
		if (yych == 't') goto yy392;
		goto yy47;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy394;
		if (yych == 'c') goto yy394;
		goto yy47;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy395;
		if (yych == 'e') goto yy395;
		goto yy47;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy396;
			if (yych <= 'U') goto yy47;
			goto yy397;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy47;
				goto yy396;
			} else {
				if (yych == 'v') goto yy397;
				goto yy47;
			}
		}
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy398;
		if (yych == 't') goto yy398;
		goto yy47;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy399;
		if (yych == 'l') goto yy399;
		goto yy47;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy400;
		if (yych == 'u') goto yy400;
		goto yy47;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy401;
		if (yych == 'u') goto yy401;
		goto yy47;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy402;
		if (yych == 't') goto yy402;
		goto yy47;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy403;
		if (yych == 't') goto yy403;
		goto yy47;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy404;
		if (yych == 'o') goto yy404;
		goto yy47;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy405;
		if (yych == 'i') goto yy405;
		goto yy47;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy406;
		if (yych == 'e') goto yy406;
		goto yy47;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy323:
		YYDEBUG(323, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy407;
		if (yych == 'l') goto yy407;
		goto yy47;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy408;
		if (yych == 'l') goto yy408;
		goto yy47;
yy327:
		YYDEBUG(327, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy207;
			if (yych <= '^') goto yy85;
			goto yy207;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy207;
			if (yych <= 0x7F) goto yy85;
			goto yy207;
		}
yy328:
		YYDEBUG(328, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy409;
		if (yych == 'l') goto yy409;
		goto yy47;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy410;
		if (yych == 'i') goto yy410;
		goto yy47;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy411;
			if (yych <= 'T') goto yy47;
			goto yy412;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy47;
				goto yy411;
			} else {
				if (yych == 'u') goto yy412;
				goto yy47;
			}
		}
yy331:
		YYDEBUG(331, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy413;
		if (yych == 'a') goto yy413;
		goto yy47;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy414;
		if (yych == 'i') goto yy414;
		goto yy47;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy415;
		if (yych == 'e') goto yy415;
		goto yy47;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy416;
		if (yych == 'a') goto yy416;
		goto yy47;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy417;
		if (yych == 'r') goto yy417;
		goto yy47;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy418;
		if (yych == 'a') goto yy418;
		goto yy85;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy419;
		if (yych == 'a') goto yy419;
		goto yy85;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy420;
		if (yych == 'l') goto yy420;
		goto yy85;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy421;
		if (yych == 'b') goto yy421;
		goto yy85;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy422;
		if (yych == 'a') goto yy422;
		goto yy85;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy427;
		if (yych == 'e') goto yy427;
		goto yy424;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy428;
		if (yych == 'e') goto yy428;
		goto yy85;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy429;
		if (yych == 'l') goto yy429;
		goto yy85;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy431;
		if (yych == 'i') goto yy431;
		goto yy85;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy432;
		if (yych == 'e') goto yy432;
		goto yy85;
yy346:
		YYDEBUG(346, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(347, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy125;
			if (yych <= '\n') goto yy346;
			goto yy125;
		} else {
			if (yych <= '\r') goto yy346;
			if (yych == ' ') goto yy346;
			goto yy125;
		}
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy85;
		if (yych <= '/') goto yy434;
		if (yych <= '9') goto yy85;
		goto yy434;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy85;
		if (yych <= '/') goto yy436;
		if (yych <= '9') goto yy85;
		goto yy436;
yy350:
		YYDEBUG(350, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(351, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy437;
				goto yy85;
			} else {
				if (yych <= '\r') goto yy439;
				if (yych <= '/') goto yy85;
				if (yych <= '9') goto yy350;
				goto yy85;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy350;
				if (yych <= '^') goto yy85;
				goto yy350;
			} else {
				if (yych <= '`') goto yy85;
				if (yych <= 'z') goto yy350;
				if (yych <= 0x7F) goto yy85;
				goto yy350;
			}
		}
yy352:
		YYDEBUG(352, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy440;
		if (yych == 'r') goto yy440;
		goto yy47;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy441;
		if (yych == 'y') goto yy441;
		goto yy47;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy443;
		if (yych == 'k') goto yy443;
		goto yy47;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy445;
		if (yych == 'a') goto yy445;
		goto yy47;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy358:
		YYDEBUG(358, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy446;
		if (yych == 'h') goto yy446;
		goto yy47;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy448;
		if (yych == 's') goto yy448;
		goto yy47;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy450;
		if (yych == 'e') goto yy450;
		goto yy47;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy452;
		if (yych == 't') goto yy452;
		goto yy47;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy454;
		if (yych == 'i') goto yy454;
		goto yy47;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy455;
		if (yych == 'a') goto yy455;
		goto yy47;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy456;
		if (yych == 'u') goto yy456;
		goto yy47;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy367:
		YYDEBUG(367, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy368;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'I') goto yy457;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'i') goto yy457;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy368:
		YYDEBUG(368, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy369:
		YYDEBUG(369, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy458;
		if (yych == 'y') goto yy458;
		goto yy47;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy460;
		if (yych == 'e') goto yy460;
		goto yy47;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy461;
		if (yych == 'o') goto yy461;
		goto yy47;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy462;
		if (yych == 'f') goto yy462;
		goto yy47;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy464;
		if (yych == 'w') goto yy464;
		goto yy47;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy465;
		if (yych == 'h') goto yy465;
		goto yy47;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy47;
			if (yych <= '\n') goto yy466;
			goto yy47;
		} else {
			if (yych <= '\r') goto yy466;
			if (yych == ' ') goto yy466;
			goto yy47;
		}
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy468;
		if (yych == 'n') goto yy468;
		goto yy47;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy469;
		if (yych == 'l') goto yy469;
		goto yy47;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy471;
		if (yych == 'a') goto yy471;
		goto yy47;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy472;
		if (yych == 't') goto yy472;
		goto yy47;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy473;
		if (yych == 'a') goto yy473;
		goto yy47;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy387:
		YYDEBUG(387, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy474;
		if (yych == 'e') goto yy474;
		goto yy47;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy475;
		if (yych == 'u') goto yy475;
		goto yy47;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy476;
			if (yych <= 'D') goto yy47;
			goto yy477;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy47;
				goto yy476;
			} else {
				if (yych == 'e') goto yy477;
				goto yy47;
			}
		}
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy478;
		if (yych == 'r') goto yy478;
		goto yy47;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy479;
		if (yych == 't') goto yy479;
		goto yy47;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy393:
		YYDEBUG(393, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy481;
		if (yych == 'h') goto yy481;
		goto yy47;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy483;
		if (yych == 's') goto yy483;
		goto yy47;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy484;
		if (yych == 't') goto yy484;
		goto yy47;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy486;
		if (yych == 'a') goto yy486;
		goto yy47;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy487;
		if (yych == 'e') goto yy487;
		goto yy47;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy488;
		if (yych == 'i') goto yy488;
		goto yy47;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy489;
		if (yych == 'i') goto yy489;
		goto yy47;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy490;
		if (yych == 'r') goto yy490;
		goto yy47;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy491;
		if (yych == 'i') goto yy491;
		goto yy47;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy492;
		if (yych == 'c') goto yy492;
		goto yy47;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy493;
		if (yych == 'w') goto yy493;
		goto yy47;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy495;
		if (yych == 't') goto yy495;
		goto yy47;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy497;
		if (yych == 't') goto yy497;
		goto yy47;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy499;
		if (yych == 'e') goto yy499;
		goto yy47;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy501;
		if (yych == 'd') goto yy501;
		goto yy47;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy503;
		if (yych == 'a') goto yy503;
		goto yy47;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy504;
		if (yych == 'r') goto yy504;
		goto yy47;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy505;
		if (yych == 'l') goto yy505;
		goto yy47;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy506;
		if (yych == 'n') goto yy506;
		goto yy47;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy507;
		if (yych == 'l') goto yy507;
		goto yy47;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy508;
		if (yych == 'n') goto yy508;
		goto yy47;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy509;
		if (yych == 't') goto yy509;
		goto yy47;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy510;
		if (yych == 'm') goto yy510;
		goto yy47;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy511;
		if (yych == 'a') goto yy511;
		goto yy47;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy512;
		if (yych == 'y') goto yy512;
		goto yy85;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy514;
		if (yych == 'r') goto yy514;
		goto yy85;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy519;
		if (yych == 'e') goto yy519;
		goto yy516;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy520;
		if (yych == 'l') goto yy520;
		goto yy85;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy521;
		if (yych == 't') goto yy521;
		goto yy85;
yy423:
		YYDEBUG(423, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy424:
		YYDEBUG(424, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy423;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy423;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(425, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(426, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy523;
		if (yych == 'g') goto yy523;
		goto yy85;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy524;
		if (yych == 'c') goto yy524;
		goto yy85;
yy429:
		YYDEBUG(429, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(430, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy429;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy429;
			if (yych == ')') goto yy525;
			goto yy85;
		}
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy527;
		if (yych == 'n') goto yy527;
		goto yy85;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy528;
		if (yych == 't') goto yy528;
		goto yy85;
yy433:
		YYDEBUG(433, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy434:
		YYDEBUG(434, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy530;
				goto yy85;
			} else {
				if (yych <= '9') goto yy433;
				if (yych <= '@') goto yy85;
				goto yy433;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy433;
				goto yy85;
			} else {
				if (yych <= 'z') goto yy433;
				if (yych <= 0x7F) goto yy85;
				goto yy433;
			}
		}
yy435:
		YYDEBUG(435, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy436:
		YYDEBUG(436, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy530;
				goto yy85;
			} else {
				if (yych <= '9') goto yy435;
				if (yych <= '@') goto yy85;
				goto yy435;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy435;
				goto yy85;
			} else {
				if (yych <= 'z') goto yy435;
				if (yych <= 0x7F) goto yy85;
				goto yy435;
			}
		}
yy437:
		YYDEBUG(437, *YYCURSOR);
		++YYCURSOR;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy437;
		goto yy438;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy531;
		if (yych == 'a') goto yy531;
		goto yy47;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy443:
		YYDEBUG(443, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy445:
		YYDEBUG(445, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy532;
		if (yych == 'b') goto yy532;
		goto yy47;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy447:
		YYDEBUG(447, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy452:
		YYDEBUG(452, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy454:
		YYDEBUG(454, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy533;
		if (yych == 'n') goto yy533;
		goto yy47;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy534;
		if (yych == 'r') goto yy534;
		goto yy47;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy535;
		if (yych == 'l') goto yy535;
		goto yy47;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy536;
		if (yych == 'f') goto yy536;
		goto yy47;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy460:
		YYDEBUG(460, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy538;
		if (yych == 'c') goto yy538;
		goto yy47;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy539;
		if (yych == 'r') goto yy539;
		goto yy47;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy541;
		if (yych == 'i') goto yy541;
		goto yy47;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy542;
		if (yych == 'i') goto yy542;
		goto yy47;
yy466:
		YYDEBUG(466, *YYCURSOR);
		++YYCURSOR;
		YYFILL(10);
		yych = *YYCURSOR;
		YYDEBUG(467, *YYCURSOR);
		if (yych <= 'I') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy85;
					goto yy466;
				} else {
					if (yych == '\r') goto yy466;
					goto yy85;
				}
			} else {
				if (yych <= 'D') {
					if (yych <= ' ') goto yy466;
					if (yych <= '@') goto yy85;
					goto yy543;
				} else {
					if (yych <= 'E') goto yy545;
					if (yych <= 'H') goto yy543;
					goto yy546;
				}
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '^') {
					if (yych <= 'Z') goto yy543;
					goto yy85;
				} else {
					if (yych == '`') goto yy85;
					goto yy543;
				}
			} else {
				if (yych <= 'i') {
					if (yych <= 'e') goto yy545;
					if (yych <= 'h') goto yy543;
					goto yy546;
				} else {
					if (yych <= 'z') goto yy543;
					if (yych <= 0x7F) goto yy85;
					goto yy543;
				}
			}
		}
yy468:
		YYDEBUG(468, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy547;
		if (yych == 'd') goto yy547;
		goto yy47;
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy470;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'L') goto yy548;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'l') goto yy548;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy549;
		if (yych == 'c') goto yy549;
		goto yy47;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy550;
		if (yych == 'i') goto yy550;
		goto yy47;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy551;
		if (yych == 'l') goto yy551;
		goto yy47;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy553;
		if (yych == 'm') goto yy553;
		goto yy47;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy554;
		if (yych == 'd') goto yy554;
		goto yy47;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy555;
		if (yych == 'n') goto yy555;
		goto yy47;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy556;
		if (yych == 'a') goto yy556;
		goto yy47;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy557;
		if (yych == 'f') goto yy557;
		goto yy47;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy483:
		YYDEBUG(483, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy558;
		if (yych == 'p') goto yy558;
		goto yy47;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy486:
		YYDEBUG(486, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy559;
		if (yych == 't') goto yy559;
		goto yy47;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy560;
		if (yych == 'c') goto yy560;
		goto yy47;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy561;
		if (yych == 'c') goto yy561;
		goto yy47;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy563;
		if (yych == 'r') goto yy563;
		goto yy47;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy564;
		if (yych == 'n') goto yy564;
		goto yy47;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy566;
		if (yych == 'c') goto yy566;
		goto yy47;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy568;
		if (yych == 'h') goto yy568;
		goto yy47;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy495:
		YYDEBUG(495, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy502;
			if (yych <= '\n') goto yy570;
			if (yych >= '\r') goto yy570;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy570;
			} else {
				if (yych == '\\') goto yy160;
			}
		}
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy572;
		if (yych == 's') goto yy572;
		goto yy47;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy573;
		goto yy47;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy574;
		if (yych == 'e') goto yy574;
		goto yy47;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy575;
		if (yych == 'c') goto yy575;
		goto yy47;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy576;
		if (yych == 't') goto yy576;
		goto yy47;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy577;
		if (yych == 'e') goto yy577;
		goto yy47;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy578;
		if (yych == 'h') goto yy578;
		goto yy47;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy579;
		if (yych == 'e') goto yy579;
		goto yy47;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy580;
		if (yych == 'i') goto yy580;
		goto yy47;
yy512:
		YYDEBUG(512, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(513, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy512;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy512;
			if (yych == ')') goto yy581;
			goto yy85;
		}
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy583;
		if (yych == 'y') goto yy583;
		goto yy85;
yy515:
		YYDEBUG(515, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy516:
		YYDEBUG(516, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy515;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy515;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(517, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy585;
		if (yych == 'a') goto yy585;
		goto yy85;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy521;
		if (yych != 'e') goto yy85;
yy521:
		YYDEBUG(521, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(522, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy521;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy521;
			if (yych == ')') goto yy586;
			goto yy85;
		}
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy588;
		if (yych == 'e') goto yy588;
		goto yy85;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy589;
		if (yych == 't') goto yy589;
		goto yy85;
yy525:
		YYDEBUG(525, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(526, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy583;
		if (yych == 'g') goto yy583;
		goto yy85;
yy528:
		YYDEBUG(528, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(529, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy528;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy528;
			if (yych == ')') goto yy591;
			goto yy85;
		}
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy437;
		if (yych == '\r') goto yy439;
		goto yy85;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy593;
		if (yych == 'c') goto yy593;
		goto yy47;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy594;
		if (yych == 'l') goto yy594;
		goto yy47;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy595;
		if (yych == 'u') goto yy595;
		goto yy47;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy596;
		if (yych == 'e') goto yy596;
		goto yy47;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy598;
		if (yych == 't') goto yy598;
		goto yy47;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy600;
		if (yych == 'l') goto yy600;
		goto yy47;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy540;
				if (yych <= '9') goto yy46;
				if (yych >= 'A') goto yy46;
			} else {
				if (yych <= 'E') goto yy601;
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy46;
				if (yych >= 'a') goto yy46;
			} else {
				if (yych <= 'e') goto yy601;
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy602;
		if (yych == 't') goto yy602;
		goto yy47;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy603;
		if (yych == 'l') goto yy603;
		goto yy47;
yy543:
		YYDEBUG(543, *YYCURSOR);
		++YYCURSOR;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_IDENT(T_ENUM);
}
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'X') goto yy604;
		if (yych == 'x') goto yy604;
		goto yy544;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy605;
		if (yych == 'm') goto yy605;
		goto yy544;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy606;
		if (yych == 's') goto yy606;
		goto yy47;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy608;
		if (yych == 'y') goto yy608;
		goto yy47;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy610;
		if (yych == 'h') goto yy610;
		goto yy47;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy612;
		if (yych == 'o') goto yy612;
		goto yy47;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy613;
		if (yych == 'e') goto yy613;
		goto yy47;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy614;
		if (yych == 'e') goto yy614;
		goto yy47;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy616;
		if (yych == 'c') goto yy616;
		goto yy47;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy617;
		if (yych == 'd') goto yy617;
		goto yy47;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy618;
		if (yych == 'a') goto yy618;
		goto yy47;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy619;
		if (yych == 'a') goto yy619;
		goto yy47;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy620;
		if (yych == 'e') goto yy620;
		goto yy47;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy622;
		if (yych == 't') goto yy622;
		goto yy47;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy563:
		YYDEBUG(563, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy623;
		if (yych == 'e') goto yy623;
		goto yy47;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy570:
		YYDEBUG(570, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(571, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy85;
				goto yy570;
			} else {
				if (yych == '\r') goto yy570;
				goto yy85;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy570;
				if (yych <= 'E') goto yy85;
				goto yy625;
			} else {
				if (yych == 'f') goto yy625;
				goto yy85;
			}
		}
yy572:
		YYDEBUG(572, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy626;
		if (yych == 's') goto yy626;
		goto yy47;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy627;
		goto yy47;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy629;
		goto yy47;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy630;
		if (yych == 't') goto yy630;
		goto yy47;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy631;
		goto yy47;
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy632;
		goto yy47;
yy578:
		YYDEBUG(578, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy633;
		if (yych == 'o') goto yy633;
		goto yy47;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy634;
		if (yych == 's') goto yy634;
		goto yy47;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy635;
		if (yych == 't') goto yy635;
		goto yy47;
yy581:
		YYDEBUG(581, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(582, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy583:
		YYDEBUG(583, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(584, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy583;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy583;
			if (yych == ')') goto yy636;
			goto yy85;
		}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy515;
		if (yych == 'n') goto yy515;
		goto yy85;
yy586:
		YYDEBUG(586, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(587, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy423;
		if (yych == 'r') goto yy423;
		goto yy85;
yy589:
		YYDEBUG(589, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(590, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy589;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy589;
			if (yych == ')') goto yy638;
			goto yy85;
		}
yy591:
		YYDEBUG(591, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(592, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy640;
		if (yych == 't') goto yy640;
		goto yy47;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy642;
		if (yych == 'e') goto yy642;
		goto yy47;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy644;
		if (yych == 'e') goto yy644;
		goto yy47;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy598:
		YYDEBUG(598, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy646;
		if (yych == 'a') goto yy646;
		goto yy47;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy647;
		if (yych == 'a') goto yy647;
		goto yy47;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy648;
		if (yych == 'c') goto yy648;
		goto yy47;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy649;
		if (yych == 'e') goto yy649;
		goto yy47;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy651;
		if (yych == 't') goto yy651;
		goto yy85;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy652;
		if (yych == 'p') goto yy652;
		goto yy85;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy653;
		if (yych == 'n') goto yy653;
		goto yy47;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy655;
		if (yych == 'n') goto yy655;
		goto yy47;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy615;
				if (yych <= '9') goto yy46;
			} else {
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy656;
			} else {
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy657;
		if (yych == 'e') goto yy657;
		goto yy47;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy658;
		if (yych == 'o') goto yy658;
		goto yy47;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy659;
		if (yych == 'c') goto yy659;
		goto yy47;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy660;
		if (yych == 'c') goto yy660;
		goto yy47;
yy620:
		YYDEBUG(620, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy622:
		YYDEBUG(622, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy661;
		if (yych == 'e') goto yy661;
		goto yy47;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy624;
				if (yych <= '9') goto yy46;
			} else {
				if (yych <= 'Z') goto yy46;
				if (yych >= '\\') goto yy160;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy662;
			} else {
				if (yych <= 'z') goto yy46;
				if (yych >= 0x80) goto yy46;
			}
		}
yy624:
		YYDEBUG(624, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy663;
		if (yych == 'r') goto yy663;
		goto yy85;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy664;
		goto yy47;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy628:
		YYDEBUG(628, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy629:
		YYDEBUG(629, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy665;
		goto yy47;
yy630:
		YYDEBUG(630, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy667;
		if (yych == 'i') goto yy667;
		goto yy47;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy668;
		if (yych == 'c') goto yy668;
		goto yy47;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy669;
		goto yy47;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy671;
		if (yych == 'd') goto yy671;
		goto yy47;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy672;
		if (yych == 'p') goto yy672;
		goto yy47;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy673;
		goto yy47;
yy636:
		YYDEBUG(636, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy638:
		YYDEBUG(638, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(639, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy644:
		YYDEBUG(644, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy646:
		YYDEBUG(646, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy674;
		if (yych == 'r') goto yy674;
		goto yy47;
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy675;
		if (yych == 'c') goto yy675;
		goto yy47;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy676;
		if (yych == 'h') goto yy676;
		goto yy47;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy678;
		if (yych == 'e') goto yy678;
		goto yy85;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy679;
		if (yych == 'l') goto yy679;
		goto yy85;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy655:
		YYDEBUG(655, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy680;
		if (yych == 't') goto yy680;
		goto yy47;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy681;
		if (yych == 'o') goto yy681;
		goto yy47;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy682;
		if (yych == 'o') goto yy682;
		goto yy47;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy683;
		if (yych == 'f') goto yy683;
		goto yy47;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy685;
		if (yych == 'e') goto yy685;
		goto yy47;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy687;
		if (yych == 'e') goto yy687;
		goto yy47;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy689;
		if (yych == 'd') goto yy689;
		goto yy47;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy691;
		if (yych == 'o') goto yy691;
		goto yy47;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy692;
		if (yych == 'o') goto yy692;
		goto yy85;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy693;
		goto yy47;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy695;
		if (yych == 'o') goto yy695;
		goto yy47;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy696;
		if (yych == 'o') goto yy696;
		goto yy47;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy671:
		YYDEBUG(671, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy697;
		goto yy47;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy698;
		if (yych == 'a') goto yy698;
		goto yy47;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy699;
		goto yy47;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy701;
		if (yych == 'e') goto yy701;
		goto yy47;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy703;
		if (yych == 'h') goto yy703;
		goto yy47;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy705;
		if (yych == 'n') goto yy705;
		goto yy85;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy706;
		if (yych == 'e') goto yy706;
		goto yy85;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy707;
		if (yych == 's') goto yy707;
		goto yy47;
yy681:
		YYDEBUG(681, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy709;
		if (yych == 'n') goto yy709;
		goto yy47;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy710;
		if (yych == 'f') goto yy710;
		goto yy47;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy685:
		YYDEBUG(685, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy712;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy691:
		YYDEBUG(691, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy713;
		if (yych == 'n') goto yy713;
		goto yy47;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy714;
		if (yych == 'm') goto yy714;
		goto yy85;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy715;
		if (yych == 'n') goto yy715;
		goto yy47;
yy696:
		YYDEBUG(696, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy716;
		if (yych == 'm') goto yy716;
		goto yy47;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy717;
		goto yy47;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy719;
		if (yych == 'c') goto yy719;
		goto yy47;
yy699:
		YYDEBUG(699, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy701:
		YYDEBUG(701, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy703:
		YYDEBUG(703, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy720;
		if (yych == 'd') goto yy720;
		goto yy85;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy721;
		if (yych == 'm') goto yy721;
		goto yy85;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yyaccept = 83;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy709:
		YYDEBUG(709, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy722;
		if (yych == 'c') goto yy722;
		goto yy47;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy85;
			if (yych <= 'Z') goto yy723;
			if (yych <= '^') goto yy85;
			goto yy723;
		} else {
			if (yych <= '`') goto yy85;
			if (yych <= 'z') goto yy723;
			if (yych <= 0x7F) goto yy85;
			goto yy723;
		}
yy713:
		YYDEBUG(713, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy726;
		if (yych == 'c') goto yy726;
		goto yy47;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy727;
				goto yy85;
			} else {
				if (yych <= '@') goto yy727;
				if (yych <= 'Z') goto yy85;
				goto yy727;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy85;
				goto yy727;
			} else {
				if (yych <= 'z') goto yy85;
				if (yych <= 0x7F) goto yy727;
				goto yy85;
			}
		}
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy729;
		goto yy47;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy730;
		if (yych == 'p') goto yy730;
		goto yy47;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yyaccept = 85;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy731;
		if (yych == 'e') goto yy731;
		goto yy47;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy732;
		if (yych == 's') goto yy732;
		goto yy85;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy734;
		if (yych == 'e') goto yy734;
		goto yy85;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy735;
		if (yych == 'e') goto yy735;
		goto yy47;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yyaccept = 86;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(724, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy725;
				if (yych <= '9') goto yy723;
			} else {
				if (yych <= 'Z') goto yy723;
				if (yych >= '\\') goto yy712;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy723;
			} else {
				if (yych <= 'z') goto yy723;
				if (yych >= 0x80) goto yy723;
			}
		}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy726:
		YYDEBUG(726, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy737;
		if (yych == 'e') goto yy737;
		goto yy47;
yy727:
		YYDEBUG(727, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(728, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy729:
		YYDEBUG(729, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy739;
		goto yy47;
yy730:
		YYDEBUG(730, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy741;
		if (yych == 'i') goto yy741;
		goto yy47;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy742;
		goto yy47;
yy732:
		YYDEBUG(732, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(733, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy743;
		if (yych == 'n') goto yy743;
		goto yy85;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yyaccept = 87;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 88;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyaccept = 89;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy741:
		YYDEBUG(741, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy744;
		if (yych == 'l') goto yy744;
		goto yy47;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy745;
		goto yy47;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy720;
		if (yych == 't') goto yy720;
		goto yy85;
yy744:
		YYDEBUG(744, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy747;
		if (yych == 'e') goto yy747;
		goto yy47;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yyaccept = 90;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy747:
		YYDEBUG(747, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy748;
		if (yych != 'r') goto yy47;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yyaccept = 91;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy46;
		}
		if (yych == '\\') goto yy160;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(750, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy754;
		}
		if (yych <= 'Z') {
			if (yych <= '>') {
				if (yych == '-') goto yy757;
			} else {
				if (yych <= '?') goto yy758;
				if (yych >= 'A') goto yy759;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy759;
			} else {
				if (yych <= 'z') goto yy759;
				if (yych >= 0x80) goto yy759;
			}
		}
		YYDEBUG(752, *YYCURSOR);
		++YYCURSOR;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy754:
		YYDEBUG(754, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(755, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy754;
		}
		YYDEBUG(756, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy762;
		goto yy753;
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy764;
		goto yy753;
yy759:
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(760, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy759;
		}
		YYDEBUG(761, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy762:
		YYDEBUG(762, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(763, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy766;
		YYDEBUG(765, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy753;
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(767, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(768, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy772;
		} else {
			if (yych <= '`') goto yy773;
			if (yych == '{') goto yy775;
		}
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
yy771:
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy772:
		YYDEBUG(772, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy771;
			if (yych <= 'Z') goto yy776;
			if (yych <= '^') goto yy771;
			goto yy776;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy771;
				goto yy776;
			} else {
				if (yych <= '{') goto yy779;
				if (yych <= 0x7F) goto yy771;
				goto yy776;
			}
		}
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(774, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy775:
		YYDEBUG(775, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy781;
		goto yy771;
yy776:
		YYDEBUG(776, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(777, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy776;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy783;
		} else {
			if (yych <= '?') goto yy785;
			if (yych <= '@') goto yy778;
			if (yych <= '[') goto yy786;
		}
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(780, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy781:
		YYDEBUG(781, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(782, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy783:
		YYDEBUG(783, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy788;
yy784:
		YYDEBUG(784, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy778;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy789;
		goto yy784;
yy786:
		YYDEBUG(786, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy784;
			if (yych <= 'Z') goto yy790;
			if (yych <= '^') goto yy784;
			goto yy790;
		} else {
			if (yych <= '`') goto yy784;
			if (yych <= 'z') goto yy790;
			if (yych <= 0x7F) goto yy784;
			goto yy790;
		}
yy789:
		YYDEBUG(789, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy792;
		goto yy784;
yy790:
		YYDEBUG(790, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(791, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy792:
		YYDEBUG(792, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy784;
			if (yych <= 'Z') goto yy793;
			if (yych <= '^') goto yy784;
		} else {
			if (yych <= '`') goto yy784;
			if (yych <= 'z') goto yy793;
			if (yych <= 0x7F) goto yy784;
		}
yy793:
		YYDEBUG(793, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(794, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(795, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy799;
		} else {
			if (yych <= '$') goto yy801;
			if (yych == '{') goto yy802;
		}
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(800, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy801:
		YYDEBUG(801, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy798;
			if (yych <= 'Z') goto yy803;
			if (yych <= '^') goto yy798;
			goto yy803;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy798;
				goto yy803;
			} else {
				if (yych <= '{') goto yy806;
				if (yych <= 0x7F) goto yy798;
				goto yy803;
			}
		}
yy802:
		YYDEBUG(802, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy808;
		goto yy798;
yy803:
		YYDEBUG(803, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(804, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy803;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy810;
		} else {
			if (yych <= '?') goto yy812;
			if (yych <= '@') goto yy805;
			if (yych <= '[') goto yy813;
		}
yy805:
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(807, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(809, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy815;
yy811:
		YYDEBUG(811, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy805;
yy812:
		YYDEBUG(812, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy816;
		goto yy811;
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy815:
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy811;
			if (yych <= 'Z') goto yy817;
			if (yych <= '^') goto yy811;
			goto yy817;
		} else {
			if (yych <= '`') goto yy811;
			if (yych <= 'z') goto yy817;
			if (yych <= 0x7F) goto yy811;
			goto yy817;
		}
yy816:
		YYDEBUG(816, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy819;
		goto yy811;
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy819:
		YYDEBUG(819, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy811;
			if (yych <= 'Z') goto yy820;
			if (yych <= '^') goto yy811;
		} else {
			if (yych <= '`') goto yy811;
			if (yych <= 'z') goto yy820;
			if (yych <= 0x7F) goto yy811;
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(821, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(822, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy826;
		if (yych == '{') goto yy827;
		YYDEBUG(824, *YYCURSOR);
		++YYCURSOR;
yy825:
		YYDEBUG(825, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy826:
		YYDEBUG(826, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy825;
			if (yych <= 'Z') goto yy828;
			if (yych <= '^') goto yy825;
			goto yy828;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy825;
				goto yy828;
			} else {
				if (yych <= '{') goto yy831;
				if (yych <= 0x7F) goto yy825;
				goto yy828;
			}
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy833;
		goto yy825;
yy828:
		YYDEBUG(828, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(829, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy828;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy835;
		} else {
			if (yych <= '?') goto yy837;
			if (yych <= '@') goto yy830;
			if (yych <= '[') goto yy838;
		}
yy830:
		YYDEBUG(830, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy831:
		YYDEBUG(831, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(832, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy833:
		YYDEBUG(833, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(834, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy835:
		YYDEBUG(835, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy840;
yy836:
		YYDEBUG(836, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy830;
yy837:
		YYDEBUG(837, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy841;
		goto yy836;
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(839, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy836;
			if (yych <= 'Z') goto yy842;
			if (yych <= '^') goto yy836;
			goto yy842;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy842;
			if (yych <= 0x7F) goto yy836;
			goto yy842;
		}
yy841:
		YYDEBUG(841, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy844;
		goto yy836;
yy842:
		YYDEBUG(842, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(843, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy844:
		YYDEBUG(844, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy836;
			if (yych <= 'Z') goto yy845;
			if (yych <= '^') goto yy836;
		} else {
			if (yych <= '`') goto yy836;
			if (yych <= 'z') goto yy845;
			if (yych <= 0x7F) goto yy836;
		}
yy845:
		YYDEBUG(845, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(846, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(847, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy849;
			if (yych <= 'Z') goto yy851;
			if (yych >= '_') goto yy851;
		} else {
			if (yych <= '`') goto yy849;
			if (yych <= 'z') goto yy851;
			if (yych >= 0x80) goto yy851;
		}
yy849:
		YYDEBUG(849, *YYCURSOR);
		++YYCURSOR;
yy850:
		YYDEBUG(850, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy851:
		YYDEBUG(851, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy850;
				if (yych <= '9') goto yy853;
				goto yy850;
			} else {
				if (yych <= '[') goto yy853;
				if (yych <= '^') goto yy850;
				goto yy853;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy850;
				if (yych <= 'z') goto yy853;
				goto yy850;
			} else {
				if (yych <= '}') goto yy853;
				if (yych <= 0x7F) goto yy850;
				goto yy853;
			}
		}
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy853:
		YYDEBUG(853, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy852;
		}
		if (yych <= '@') goto yy854;
		if (yych <= '[') goto yy855;
		if (yych == '}') goto yy855;
yy854:
		YYDEBUG(854, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy850;
yy855:
		YYDEBUG(855, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(856, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			248, 248, 216, 216, 216, 216, 216, 216, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(857, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy859;
					if (yych <= '\n') goto yy861;
				} else {
					if (yych <= '\r') goto yy861;
					if (yych >= ' ') goto yy861;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy863;
					if (yych <= '#') goto yy861;
					goto yy865;
				} else {
					if (yych == '\'') goto yy861;
					if (yych <= '/') goto yy863;
					goto yy866;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy868;
					if (yych <= '@') goto yy863;
					goto yy870;
				} else {
					if (yych <= '[') goto yy863;
					if (yych <= '\\') goto yy861;
					goto yy873;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy870;
					goto yy863;
				} else {
					if (yych <= 'z') goto yy870;
					if (yych <= '~') goto yy863;
					if (yych >= 0x80) goto yy870;
				}
			}
		}
yy859:
		YYDEBUG(859, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(860, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy861:
		YYDEBUG(861, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(862, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy863:
		YYDEBUG(863, *YYCURSOR);
		++YYCURSOR;
yy864:
		YYDEBUG(864, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy865:
		YYDEBUG(865, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy864;
			if (yych <= 'Z') goto yy875;
			if (yych <= '^') goto yy864;
			goto yy875;
		} else {
			if (yych <= '`') goto yy864;
			if (yych <= 'z') goto yy875;
			if (yych <= 0x7F) goto yy864;
			goto yy875;
		}
yy866:
		YYDEBUG(866, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'B') {
				if (yych <= '/') goto yy867;
				if (yych <= '9') goto yy878;
				if (yych >= 'B') goto yy881;
			} else {
				if (yych == 'O') goto yy883;
				if (yych >= 'X') goto yy884;
			}
		} else {
			if (yych <= 'b') {
				if (yych == '_') goto yy885;
				if (yych >= 'b') goto yy881;
			} else {
				if (yych <= 'o') {
					if (yych >= 'o') goto yy883;
				} else {
					if (yych == 'x') goto yy884;
				}
			}
		}
yy867:
		YYDEBUG(867, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy868:
		YYDEBUG(868, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(869, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy868;
		}
		if (yych == '_') goto yy885;
		goto yy867;
yy870:
		YYDEBUG(870, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(871, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy870;
		}
		YYDEBUG(872, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy873:
		YYDEBUG(873, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(874, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy875:
		YYDEBUG(875, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(876, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy875;
			} else {
				if (yych <= '@') goto yy877;
				if (yych <= 'Z') goto yy875;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy875;
			} else {
				if (yych <= 'z') goto yy875;
				if (yych >= 0x80) goto yy875;
			}
		}
yy877:
		YYDEBUG(877, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy878:
		YYDEBUG(878, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(879, *YYCURSOR);
		if (yych <= '/') goto yy880;
		if (yych <= '9') goto yy878;
		if (yych == '_') goto yy885;
yy880:
		YYDEBUG(880, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy881:
		YYDEBUG(881, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy886;
		}
yy882:
		YYDEBUG(882, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy867;
		} else {
			goto yy880;
		}
yy883:
		YYDEBUG(883, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy888;
		}
		goto yy882;
yy884:
		YYDEBUG(884, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy890;
		}
		goto yy882;
yy885:
		YYDEBUG(885, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy882;
		if (yych <= '9') goto yy878;
		goto yy882;
yy886:
		YYDEBUG(886, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(887, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy886;
		}
		if (yych == '_') goto yy881;
		goto yy880;
yy888:
		YYDEBUG(888, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(889, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy888;
		}
		if (yych == '_') goto yy883;
		goto yy880;
yy890:
		YYDEBUG(890, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(891, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy890;
		}
		if (yych == '_') goto yy884;
		goto yy880;
	}
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(892, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy896;
		YYDEBUG(894, *YYCURSOR);
		++YYCURSOR;
yy895:
		YYDEBUG(895, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy896:
		YYDEBUG(896, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy895;
yy897:
		YYDEBUG(897, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(898, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy897;
		}
		YYDEBUG(899, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(900, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(901, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy905;
	YYDEBUG(903, *YYCURSOR);
	++YYCURSOR;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy904;
	YYDEBUG(906, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy908;
	} else {
		if (yych <= 'P') goto yy910;
		if (yych == 'p') goto yy910;
	}
yy907:
	YYDEBUG(907, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy908:
	YYDEBUG(908, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(909, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy912;
	if (yych == 'h') goto yy912;
yy911:
	YYDEBUG(911, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy907;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy913;
	if (yych != 'p') goto yy911;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy914;
		if (yych <= '\n') goto yy915;
	} else {
		if (yych <= '\r') goto yy917;
		if (yych == ' ') goto yy915;
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy915:
	YYDEBUG(915, *YYCURSOR);
	++YYCURSOR;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy915;
	goto yy916;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(918, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(920, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(921, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(922, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(924, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(925, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident = SCNG(yy_text);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
