/* Generated by re2c 2.0.3 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@php.net>                                 |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6

#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
ZEND_API size_t ini_scanner_globals_offset;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

#define ZEND_SYSTEM_INI CG(ini_parser_unbuffered_errors)

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yyleng) {                                 \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng && (                              \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, ZEND_SYSTEM_INI))


#define RETURN_TOKEN(type, str, len) {                             \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED &&            \
		(YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW))) {\
		zend_ini_copy_typed_value(ini_lval, type, str, len);       \
	} else {                                                       \
		zend_ini_copy_value(ini_lval, str, len);                   \
	}                                                              \
	return type;                                                   \
}

static inline zend_result convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow, NULL)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			ZEND_FALLTHROUGH;
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner() */
static zend_result init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_string_copy(fh->filename);
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner() */
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		zend_string_release(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno() */
ZEND_COLD int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename() */
ZEND_COLD char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ZSTR_VAL(ini_filename) : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning() */
zend_result zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning() */
zend_result zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string() */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy11;
		}
		switch (yych) {
		case '\t':	goto yy5;
		case '\n':	goto yy8;
		case '\r':	goto yy10;
		case ' ':
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy13;
		case ';':	goto yy15;
		case '=':	goto yy17;
		case 'F':
		case 'f':	goto yy20;
		case 'N':
		case 'n':	goto yy21;
		case 'O':
		case 'o':	goto yy22;
		case 'T':
		case 't':	goto yy23;
		case 'Y':
		case 'y':	goto yy24;
		case '[':	goto yy25;
		default:	goto yy2;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy3:
		YYDEBUG(3, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy2;
		}
		if (yych <= '=') goto yy4;
		if (yych <= '[') goto yy27;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(6, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy5;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy7;
			if (yych <= '\n') goto yy8;
			if (yych >= '\r') goto yy10;
		} else {
			if (yych <= ';') {
				if (yych >= ';') goto yy15;
			} else {
				if (yych == '=') goto yy17;
			}
		}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		++YYCURSOR;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy8;
		goto yy9;
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(12, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy11;
		}
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy2;
					if (yych <= '\t') goto yy5;
					goto yy8;
				} else {
					if (yych == '\r') goto yy10;
					goto yy2;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy2;
					goto yy4;
				} else {
					if (yych == '&') goto yy4;
					goto yy2;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy4;
					if (yych <= ':') goto yy2;
					goto yy15;
				} else {
					if (yych == '=') goto yy17;
					goto yy2;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy27;
					if (yych <= ']') goto yy2;
					goto yy4;
				} else {
					if (yych <= 'z') goto yy2;
					if (yych <= '~') goto yy4;
					goto yy2;
				}
			}
		}
yy13:
		YYDEBUG(13, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(14, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
yy15:
		YYDEBUG(15, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(16, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy15;
		}
		if (yych <= '\n') goto yy30;
		goto yy32;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		if (yych == '\t') goto yy17;
		if (yych == ' ') goto yy17;
		YYDEBUG(19, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_RAW);
	} else {
		BEGIN(ST_VALUE);
	}
	return '=';
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy33;
		if (yych == 'a') goto yy33;
		goto yy3;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy34;
			if (yych <= 'T') goto yy3;
			goto yy36;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy3;
				goto yy34;
			} else {
				if (yych == 'u') goto yy36;
				goto yy3;
			}
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy37;
			if (yych <= 'M') goto yy3;
			goto yy38;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy3;
				goto yy37;
			} else {
				if (yych == 'n') goto yy38;
				goto yy3;
			}
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy41;
		if (yych == 'r') goto yy41;
		goto yy3;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy42;
		if (yych == 'e') goto yy42;
		goto yy3;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		BEGIN(ST_SECTION_RAW);
	} else {
		BEGIN(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yych == '\t') goto yy27;
		if (yych == ' ') goto yy27;
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	BEGIN(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy30;
		goto yy31;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy43;
		if (yych == 'l') goto yy43;
		goto yy3;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy3;
					if (yych <= '\t') goto yy44;
				} else {
					if (yych != '\r') goto yy3;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy46;
					if (yych >= '#') goto yy3;
				} else {
					if (yych == '%') goto yy3;
					if (yych >= '\'') goto yy3;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy35;
					if (yych <= ':') goto yy3;
				} else {
					if (yych == '=') goto yy35;
					if (yych <= 'M') goto yy3;
					goto yy48;
				}
			} else {
				if (yych <= 'm') {
					if (yych != '^') goto yy3;
				} else {
					if (yych <= 'n') goto yy48;
					if (yych <= 'z') goto yy3;
					if (yych >= 0x7F) goto yy3;
				}
			}
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy49;
		if (yych == 'l') goto yy49;
		goto yy3;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy46;
		if (yych == 'f') goto yy46;
		goto yy3;
yy38:
		YYDEBUG(38, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(39, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy2;
					if (yych <= '\t') goto yy50;
				} else {
					if (yych != '\r') goto yy2;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy38;
					if (yych >= '#') goto yy2;
				} else {
					if (yych == '%') goto yy2;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy2;
					if (yych >= '*') goto yy2;
				} else {
					if (yych == '<') goto yy2;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy27;
					goto yy2;
				} else {
					if (yych <= '^') goto yy40;
					if (yych <= 'z') goto yy2;
					if (yych >= 0x7F) goto yy2;
				}
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy52;
		if (yych == 'u') goto yy52;
		goto yy3;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy38;
		if (yych == 's') goto yy38;
		goto yy3;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy48;
		if (yych == 's') goto yy48;
		goto yy3;
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(45, *YYCURSOR);
		if (yych == '\t') goto yy44;
		if (yych == ' ') goto yy44;
		goto yy35;
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy2;
					if (yych <= '\t') goto yy44;
					goto yy35;
				} else {
					if (yych == '\r') goto yy35;
					goto yy2;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy46;
					if (yych <= '"') goto yy35;
					goto yy2;
				} else {
					if (yych == '%') goto yy2;
					goto yy35;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy2;
					if (yych <= ')') goto yy35;
					goto yy2;
				} else {
					if (yych == '<') goto yy2;
					goto yy35;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy27;
					goto yy2;
				} else {
					if (yych <= '^') goto yy35;
					if (yych <= 'z') goto yy2;
					if (yych <= '~') goto yy35;
					goto yy2;
				}
			}
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy46;
		if (yych == 'e') goto yy46;
		goto yy3;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy53;
		if (yych == 'l') goto yy53;
		goto yy3;
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(51, *YYCURSOR);
		if (yych == '\t') goto yy50;
		if (yych == ' ') goto yy50;
		goto yy40;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy38;
		if (yych == 'e') goto yy38;
		goto yy3;
yy53:
		YYDEBUG(53, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(54, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy2;
					if (yych <= '\t') goto yy56;
				} else {
					if (yych != '\r') goto yy2;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy53;
					if (yych >= '#') goto yy2;
				} else {
					if (yych == '%') goto yy2;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy2;
					if (yych >= '*') goto yy2;
				} else {
					if (yych == '<') goto yy2;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy27;
					goto yy2;
				} else {
					if (yych <= '^') goto yy55;
					if (yych <= 'z') goto yy2;
					if (yych >= 0x7F) goto yy2;
				}
			}
		}
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		if (yych == '\t') goto yy56;
		if (yych == ' ') goto yy56;
		goto yy55;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(58, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy63;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy60;
					if (yych <= '\n') goto yy65;
				} else {
					if (yych <= '\r') goto yy65;
					if (yych >= '"') goto yy67;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy69;
				} else {
					if (yych <= '\'') goto yy70;
					if (yych <= ',') goto yy60;
					if (yych <= '.') goto yy71;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy72;
					if (yych >= ';') goto yy65;
				} else {
					if (yych <= '@') goto yy60;
					if (yych <= 'Z') goto yy75;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy78;
					if (yych <= ']') goto yy79;
				} else {
					if (yych == '`') goto yy60;
					if (yych <= 'z') goto yy75;
				}
			}
		}
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy61:
		YYDEBUG(61, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy60;
		}
		if (yych <= '"') goto yy62;
		if (yych <= '$') goto yy81;
		if (yych <= ';') goto yy62;
		if (yych <= '\\') goto yy78;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy63;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy60;
				if (yych <= '\n') goto yy62;
				if (yych <= '\f') goto yy60;
				goto yy62;
			} else {
				if (yych == '"') goto yy67;
				if (yych <= '#') goto yy60;
				goto yy81;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy62;
				if (yych <= ':') goto yy60;
				goto yy62;
			} else {
				if (yych <= '[') goto yy60;
				if (yych <= '\\') goto yy78;
				if (yych <= ']') goto yy79;
				goto yy60;
			}
		}
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy66;
			if (yych <= '[') goto yy60;
			goto yy83;
		} else {
			if (yych == '{') goto yy85;
			goto yy60;
		}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy87;
		}
		goto yy66;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy89;
		goto yy61;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy72;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy74;
				if (yych <= '\f') goto yy60;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy60;
				} else {
					if (yych == '$') goto yy81;
					goto yy60;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy74;
				if (yych == '.') goto yy89;
				goto yy60;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy60;
				} else {
					if (yych <= '\\') goto yy78;
					if (yych >= '^') goto yy60;
				}
			}
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy75;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy77;
				if (yych <= '\f') goto yy60;
			} else {
				if (yych == '"') goto yy77;
				if (yych <= '#') goto yy60;
				goto yy81;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy77;
				if (yych <= ':') goto yy60;
			} else {
				if (yych <= '[') goto yy60;
				if (yych <= '\\') goto yy78;
				if (yych >= '^') goto yy60;
			}
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy60;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy82;
			if (yych <= '[') goto yy60;
			goto yy83;
		} else {
			if (yych != '{') goto yy60;
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy62;
			} else {
				goto yy74;
			}
		} else {
			goto yy77;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy83;
		}
		goto yy60;
yy85:
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(88, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy87;
		}
		goto yy91;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(90, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy74;
				if (yych <= '\f') goto yy60;
				goto yy74;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy60;
					goto yy74;
				} else {
					if (yych == '$') goto yy81;
					goto yy60;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy74;
				if (yych <= '/') goto yy60;
				if (yych <= '9') goto yy89;
				goto yy60;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy74;
					goto yy60;
				} else {
					if (yych <= '\\') goto yy78;
					if (yych <= ']') goto yy74;
					goto yy60;
				}
			}
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(93, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy98;
		}
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy95;
					if (yych <= '\n') goto yy100;
				} else {
					if (yych <= '\r') goto yy100;
					if (yych >= '"') goto yy102;
				}
			} else {
				if (yych <= '&') {
					if (yych == '$') goto yy104;
				} else {
					if (yych <= '\'') goto yy105;
					if (yych <= ',') goto yy95;
					if (yych <= '.') goto yy106;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= ';') {
					if (yych <= '9') goto yy107;
					if (yych >= ';') goto yy100;
				} else {
					if (yych <= '@') goto yy95;
					if (yych <= 'Z') goto yy110;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '\\') goto yy113;
					if (yych <= ']') goto yy114;
				} else {
					if (yych == '`') goto yy95;
					if (yych <= 'z') goto yy110;
				}
			}
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy96:
		YYDEBUG(96, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy95;
		}
		if (yych <= '"') goto yy97;
		if (yych <= '$') goto yy117;
		if (yych <= ';') goto yy97;
		if (yych <= '\\') goto yy113;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(99, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy98;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy95;
				if (yych <= '\n') goto yy97;
				if (yych <= '\f') goto yy95;
				goto yy97;
			} else {
				if (yych == '"') goto yy102;
				if (yych <= '#') goto yy95;
				goto yy117;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy97;
				if (yych <= ':') goto yy95;
				goto yy97;
			} else {
				if (yych <= '[') goto yy95;
				if (yych <= '\\') goto yy113;
				if (yych <= ']') goto yy97;
				goto yy95;
			}
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy101;
			if (yych <= '[') goto yy95;
			goto yy119;
		} else {
			if (yych == '{') goto yy121;
			goto yy95;
		}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy123;
		}
		goto yy101;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy96;
		if (yych <= '9') goto yy125;
		goto yy96;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy107;
		}
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy109;
				if (yych <= '\f') goto yy95;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy95;
				} else {
					if (yych == '$') goto yy117;
					goto yy95;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy109;
				if (yych == '.') goto yy125;
				goto yy95;
			} else {
				if (yych <= '[') {
					if (yych >= '<') goto yy95;
				} else {
					if (yych <= '\\') goto yy113;
					if (yych >= '^') goto yy95;
				}
			}
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy110;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy112;
				if (yych <= '\f') goto yy95;
			} else {
				if (yych == '"') goto yy112;
				if (yych <= '#') goto yy95;
				goto yy117;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy112;
				if (yych <= ':') goto yy95;
			} else {
				if (yych <= '[') goto yy95;
				if (yych <= '\\') goto yy113;
				if (yych >= '^') goto yy95;
			}
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy95;
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy116;
			if (yych <= '\t') goto yy114;
			if (yych <= '\n') goto yy127;
		} else {
			if (yych <= '\r') goto yy128;
			if (yych == ' ') goto yy114;
		}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy117:
		YYDEBUG(117, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy118;
			if (yych <= '[') goto yy95;
			goto yy119;
		} else {
			if (yych != '{') goto yy95;
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy97;
			} else {
				goto yy109;
			}
		} else {
			goto yy112;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy119;
		}
		goto yy95;
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy123;
		}
		goto yy129;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy109;
				if (yych <= '\f') goto yy95;
				goto yy109;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy95;
					goto yy109;
				} else {
					if (yych == '$') goto yy117;
					goto yy95;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy109;
				if (yych <= '/') goto yy95;
				if (yych <= '9') goto yy125;
				goto yy95;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy109;
					goto yy95;
				} else {
					if (yych <= '\\') goto yy113;
					if (yych <= ']') goto yy109;
					goto yy95;
				}
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		goto yy116;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy127;
		goto yy116;
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 80,  82,  82,  82,  82,  82,  82,  82, 
			 82,  84,  64,  82,  82,  64,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 84,  80,  80,  82, 208,  82,  80,  16, 
			 80,  80,  82,  82,  82,  82,  82,  82, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  82,  80,  82,  80,  82,  82, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  82,  82,  80, 114, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  80,  82,  80,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
		};
		YYDEBUG(131, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy138;
		}
		switch (yych) {
		case 0x00:	goto yy133;
		case '\t':
		case '\n':	goto yy141;
		case '\r':	goto yy143;
		case ' ':
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy144;
		case '"':	goto yy147;
		case '$':	goto yy149;
		case '\'':	goto yy150;
		case '-':
		case '.':	goto yy151;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy152;
		case ';':	goto yy155;
		case '=':	goto yy157;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy159;
		case 'F':
		case 'f':	goto yy162;
		case 'N':
		case 'n':	goto yy163;
		case 'O':
		case 'o':	goto yy164;
		case 'T':
		case 't':	goto yy165;
		case 'Y':
		case 'y':	goto yy166;
		default:	goto yy135;
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy136:
		YYDEBUG(136, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy135;
		}
		if (yych <= '"') goto yy137;
		if (yych <= '$') goto yy167;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(139, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy138;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy140;
			if (yych <= '\n') goto yy141;
			if (yych >= '\r') goto yy143;
		} else {
			if (yych <= '"') {
				if (yych >= '"') goto yy147;
			} else {
				if (yych == ';') goto yy155;
			}
		}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy141;
		goto yy142;
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(145, *YYCURSOR);
		if (yych == '\t') goto yy144;
		if (yych == ' ') goto yy144;
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Boolean operators */
	return yytext[0];
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy134;
			if (yych <= '[') goto yy135;
			goto yy169;
		} else {
			if (yych == '{') goto yy170;
			goto yy135;
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy172;
		}
		goto yy134;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy136;
		if (yych <= '9') goto yy174;
		goto yy136;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy152;
		}
		if (yych <= '-') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy154;
					if (yych <= 0x08) goto yy135;
				} else {
					if (yych != '\r') goto yy135;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy154;
					if (yych <= '#') goto yy135;
					goto yy167;
				} else {
					if (yych <= '%') goto yy135;
					if (yych >= '*') goto yy135;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '.') goto yy174;
					if (yych <= ':') goto yy135;
				} else {
					if (yych != '=') goto yy135;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy154;
					if (yych <= '{') goto yy135;
				} else {
					if (yych != '~') goto yy135;
				}
			}
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy155;
		}
		if (yych <= '\n') goto yy176;
		goto yy178;
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(158, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy159;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy135;
				} else {
					if (yych <= '\n') goto yy161;
					if (yych <= '\f') goto yy135;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy135;
					if (yych >= '#') goto yy135;
				} else {
					if (yych <= '$') goto yy167;
					if (yych <= '%') goto yy135;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy135;
				} else {
					if (yych != '=') goto yy135;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy161;
					if (yych <= '{') goto yy135;
				} else {
					if (yych != '~') goto yy135;
				}
			}
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					goto yy136;
				} else {
					if (yych <= '9') goto yy159;
					if (yych == ';') goto yy161;
					goto yy136;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy161;
					if (yych <= '@') goto yy136;
					goto yy179;
				} else {
					if (yych <= 'Z') goto yy159;
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					goto yy159;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy136;
					if (yych <= 'a') goto yy179;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					if (yych <= '\n') goto yy161;
					goto yy136;
				} else {
					if (yych <= '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					if (yych <= '"') goto yy161;
					goto yy136;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					if (yych <= '9') goto yy159;
					goto yy136;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy161;
						goto yy136;
					} else {
						if (yych <= '=') goto yy161;
						if (yych <= '@') goto yy136;
						goto yy159;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy180;
					if (yych == 'U') goto yy182;
					goto yy159;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy136;
						goto yy161;
					} else {
						if (yych == '`') goto yy136;
						goto yy159;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy180;
					if (yych == 'u') goto yy182;
					goto yy159;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy136;
						goto yy161;
					} else {
						if (yych == '~') goto yy161;
						goto yy136;
					}
				}
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					if (yych <= '\n') goto yy161;
					goto yy136;
				} else {
					if (yych <= '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					if (yych <= '"') goto yy161;
					goto yy136;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					if (yych <= '9') goto yy159;
					goto yy136;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy161;
						goto yy136;
					} else {
						if (yych <= '=') goto yy161;
						if (yych <= '@') goto yy136;
						goto yy159;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy183;
					if (yych == 'N') goto yy184;
					goto yy159;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy136;
						goto yy161;
					} else {
						if (yych == '`') goto yy136;
						goto yy159;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy183;
					if (yych == 'n') goto yy184;
					goto yy159;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy136;
						goto yy161;
					} else {
						if (yych == '~') goto yy161;
						goto yy136;
					}
				}
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'R') goto yy186;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy186;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'E') goto yy187;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy187;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy168;
			if (yych <= '[') goto yy135;
			goto yy169;
		} else {
			if (yych != '{') goto yy135;
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy137;
				} else {
					goto yy154;
				}
			} else {
				goto yy161;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy181;
				} else {
					goto yy185;
				}
			} else {
				goto yy202;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy188;
		}
		goto yy135;
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy172;
		}
		goto yy190;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(175, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy154;
					if (yych <= 0x08) goto yy135;
					goto yy154;
				} else {
					if (yych == '\r') goto yy154;
					goto yy135;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy154;
					if (yych <= '#') goto yy135;
					goto yy167;
				} else {
					if (yych <= '%') goto yy135;
					if (yych <= ')') goto yy154;
					goto yy135;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy174;
					if (yych <= ':') goto yy135;
					goto yy154;
				} else {
					if (yych == '=') goto yy154;
					goto yy135;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy154;
					if (yych <= '{') goto yy135;
					goto yy154;
				} else {
					if (yych == '~') goto yy154;
					goto yy135;
				}
			}
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy176;
		goto yy177;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'L') goto yy192;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy192;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy181;
					if (yych <= 0x08) goto yy136;
					if (yych <= '\t') goto yy193;
				} else {
					if (yych == '\r') goto yy181;
					if (yych <= 0x1F) goto yy136;
					goto yy193;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy181;
					if (yych <= '%') goto yy136;
					if (yych >= '*') goto yy136;
				} else {
					if (yych <= '9') goto yy159;
					if (yych != ';') goto yy136;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy181;
					if (yych <= '@') goto yy136;
					if (yych <= 'M') goto yy159;
					goto yy195;
				} else {
					if (yych <= 'Z') goto yy159;
					if (yych <= ']') goto yy136;
					if (yych >= '_') goto yy159;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy136;
					if (yych == 'n') goto yy195;
					goto yy159;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy136;
					} else {
						if (yych != '~') goto yy136;
					}
				}
			}
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'L') goto yy196;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy196;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'F') goto yy197;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy197;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy159;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy136;
				} else {
					if (yych <= '\t') goto yy198;
					if (yych >= '\v') goto yy136;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy185;
					if (yych <= 0x1F) goto yy136;
					goto yy198;
				} else {
					if (yych <= '"') goto yy185;
					if (yych <= '%') goto yy136;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy136;
				} else {
					if (yych != '=') goto yy136;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy185;
					if (yych <= '{') goto yy136;
				} else {
					if (yych != '~') goto yy136;
				}
			}
		}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'U') goto yy200;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy200;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'S') goto yy184;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy184;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy188;
		}
		if (yych <= 0x00) goto yy137;
		if (yych == '\\') goto yy169;
		goto yy135;
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'S') goto yy195;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy195;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		if (yych == '\t') goto yy193;
		if (yych == ' ') goto yy193;
		goto yy181;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'E') goto yy197;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy197;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'L') goto yy201;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy201;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy159;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy181;
					goto yy136;
				} else {
					if (yych <= '\t') goto yy193;
					if (yych <= '\n') goto yy181;
					goto yy136;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy181;
					if (yych <= 0x1F) goto yy136;
					goto yy193;
				} else {
					if (yych <= '"') goto yy181;
					if (yych <= '%') goto yy136;
					goto yy181;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy136;
					goto yy181;
				} else {
					if (yych == '=') goto yy181;
					goto yy136;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy181;
					if (yych <= '{') goto yy136;
					goto yy181;
				} else {
					if (yych == '~') goto yy181;
					goto yy136;
				}
			}
		}
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yych == '\t') goto yy198;
		if (yych == ' ') goto yy198;
		goto yy185;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy161;
					if (yych <= 0x08) goto yy136;
					goto yy161;
				} else {
					if (yych == '\r') goto yy161;
					if (yych <= 0x1F) goto yy136;
					goto yy161;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy136;
					if (yych <= ')') goto yy161;
					if (yych <= '/') goto yy136;
					goto yy159;
				} else {
					if (yych == ';') goto yy161;
					if (yych <= '<') goto yy136;
					goto yy161;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy136;
					if (yych == 'E') goto yy184;
					goto yy159;
				} else {
					if (yych <= ']') goto yy136;
					if (yych <= '^') goto yy161;
					if (yych <= '_') goto yy159;
					goto yy136;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy184;
					if (yych <= 'z') goto yy159;
					goto yy136;
				} else {
					if (yych == '}') goto yy136;
					if (yych <= '~') goto yy161;
					goto yy136;
				}
			}
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy159;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy136;
				} else {
					if (yych <= '\t') goto yy203;
					if (yych >= '\v') goto yy136;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy202;
					if (yych <= 0x1F) goto yy136;
					goto yy203;
				} else {
					if (yych <= '"') goto yy202;
					if (yych <= '%') goto yy136;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy136;
				} else {
					if (yych != '=') goto yy136;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy202;
					if (yych <= '{') goto yy136;
				} else {
					if (yych != '~') goto yy136;
				}
			}
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yych == '\t') goto yy203;
		if (yych == ' ') goto yy203;
		goto yy202;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(205, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy207;
		}
		if (yych <= '\r') goto yy210;
		goto yy212;
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy207;
		}
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy212;
		}
		if (yych <= 0x08) goto yy214;
		if (yych <= '\n') goto yy215;
		if (yych == '\r') goto yy216;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		goto yy214;
yy216:
		YYDEBUG(216, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy215;
		goto yy214;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(217, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy221;
		if (yych == '$') goto yy224;
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy221;
		}
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy220;
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(227, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy229;
		}
		if (yych == '}') goto yy234;
		goto yy232;
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy229;
		}
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy234:
		YYDEBUG(234, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(235, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(236, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy240;
			} else {
				if (yych <= '\t') goto yy242;
				if (yych <= '\n') goto yy243;
				goto yy240;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy245;
				if (yych <= 0x1F) goto yy240;
				goto yy242;
			} else {
				if (yych == ';') goto yy246;
				goto yy240;
			}
		}
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	EAT_LEADING_WHITESPACE();
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				YYCURSOR++;
				break;
			case '"':
				if (yytext[0] == '"') {
					sc = NULL;
				}
				YYCURSOR++;
				break;
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	if (sc) {
		yyleng = sc - SCNG(yy_text);
	} else {
		yyleng = YYCURSOR - SCNG(yy_text);
	}

	EAT_TRAILING_WHITESPACE();

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}

	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy241;
			if (yych <= '\n') goto yy249;
			if (yych <= '\f') goto yy241;
			goto yy249;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy241;
				goto yy249;
			} else {
				if (yych == ';') goto yy249;
				goto yy241;
			}
		}
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy243;
		goto yy244;
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(247, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy246;
		}
		if (yych <= '\n') goto yy251;
		goto yy253;
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy249:
		YYDEBUG(249, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy248;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy250;
			if (yych <= '\n') goto yy243;
		} else {
			if (yych <= '\r') goto yy245;
			if (yych == ';') goto yy246;
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy251;
		goto yy252;
	}
}

}
