/* Generated by re2c 2.1.1 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))


static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API zend_result zend_lex_tstring(zval *zv, unsigned char *ident)
{
	unsigned char *end = ident;
	while ((*end >= 'a' && *end <= 'z') || (*end >= 'A' && *end <= 'Z') || *end == '_') {
		end++;
	}

	size_t length = end - ident;
	if (length == 0) {
		ZEND_ASSERT(ident[0] == '<' && ident[1] == '?' && ident[2] == '=');
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, (char *) ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char *) ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		file_handle->in_list = 1;
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	file_handle->in_list = 1;

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_copy(file_handle->filename);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		zend_init_static_variables_map_ptr(op_array);
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, ZSTR_VAL(file_handle->filename));
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, ZSTR_VAL(file_handle->filename));
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, zend_string *filename) {
	zval code_zv;
	bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zend_string *filename)
{
	zend_file_handle file_handle;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	zend_stream_init_filename_ex(&file_handle, filename);

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(filename);
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, zend_string *filename)
{
	char *buf;
	size_t size, old_len;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);
	zend_set_compiled_filename(filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_string *filename_str;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	filename_str = zend_string_init(filename, strlen(filename), 0);
	zend_prepare_string_for_scanning(&tmp, filename_str);
	zend_string_release(filename_str);
	BEGIN(ST_IN_SCRIPTING);
	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_destroy_file_handle(&file_handle);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zend_string *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *filename)
{
	zend_lex_state original_lex_state;
	zval str_zv;
	zend_string *filename_str = zend_string_init(filename, strlen(filename), 0);
	ZVAL_STR_COPY(&str_zv, str);
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&str_zv, filename_str);
	zend_string_release(filename_str);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&str_zv);
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, bool using_spaces,
	bool newline_at_start, bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end(void)
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  18,   2,   0,   0,   2,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 18,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			236, 236, 204, 204, 204, 204, 204, 204, 
			140, 140,   0,   0,   0,   0,   0,   0, 
			  0, 136, 136, 136, 136, 136, 136,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  0, 136, 136, 136, 136, 136, 136,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   0, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy4;
		}
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\t':
		case '\n':
		case '\v':
		case '\f':
		case '\r':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy2;
		case ' ':
		case '!':	goto yy7;
		case '"':	goto yy9;
		case '#':	goto yy11;
		case '$':	goto yy13;
		case '%':	goto yy14;
		case '&':	goto yy15;
		case '\'':	goto yy16;
		case '(':	goto yy18;
		case ')':
		case ']':	goto yy20;
		case '*':	goto yy22;
		case '+':	goto yy23;
		case ',':
		case ';':
		case '@':
		case '~':	goto yy24;
		case '-':	goto yy25;
		case '.':	goto yy26;
		case '/':	goto yy27;
		case '0':	goto yy28;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy30;
		case ':':	goto yy32;
		case '<':	goto yy33;
		case '=':	goto yy34;
		case '>':	goto yy35;
		case '?':	goto yy36;
		case 'A':
		case 'a':	goto yy37;
		case 'B':
		case 'b':	goto yy39;
		case 'C':
		case 'c':	goto yy40;
		case 'D':
		case 'd':	goto yy41;
		case 'E':
		case 'e':	goto yy42;
		case 'F':
		case 'f':	goto yy43;
		case 'G':
		case 'g':	goto yy44;
		case 'I':
		case 'i':	goto yy47;
		case 'L':
		case 'l':	goto yy48;
		case 'M':
		case 'm':	goto yy49;
		case 'N':
		case 'n':	goto yy50;
		case 'O':
		case 'o':	goto yy51;
		case 'P':
		case 'p':	goto yy52;
		case 'R':
		case 'r':	goto yy53;
		case 'S':
		case 's':	goto yy54;
		case 'T':
		case 't':	goto yy55;
		case 'U':
		case 'u':	goto yy56;
		case 'V':
		case 'v':	goto yy57;
		case 'W':
		case 'w':	goto yy58;
		case 'X':
		case 'x':	goto yy59;
		case 'Y':
		case 'y':	goto yy60;
		case '[':	goto yy61;
		case '\\':	goto yy62;
		case '^':	goto yy64;
		case '_':	goto yy65;
		case '`':	goto yy66;
		case '{':	goto yy68;
		case '|':	goto yy70;
		case '}':	goto yy71;
		default:	goto yy45;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(5, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy4;
		}
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy73;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '[') goto yy75;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy8;
			if (yych <= 'Z') goto yy77;
			if (yych <= '^') goto yy8;
			goto yy77;
		} else {
			if (yych <= '`') goto yy8;
			if (yych <= 'z') goto yy77;
			if (yych <= 0x7F) goto yy8;
			goto yy77;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy80;
		goto yy8;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy82;
		if (yych == '=') goto yy84;
		goto yy8;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy18:
		YYDEBUG(18, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy87;
					if (yych >= ' ') goto yy87;
				} else {
					if (yych <= '@') goto yy19;
					if (yych != 'C') goto yy87;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy87;
					if (yych >= 'I') goto yy87;
				} else {
					if (yych == 'O') goto yy87;
					if (yych >= 'R') goto yy87;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy87;
					if (yych >= 'a') goto yy87;
				} else {
					if (yych == 'd') goto yy87;
					if (yych >= 'f') goto yy87;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy87;
					if (yych >= 'o') goto yy87;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy87;
					} else {
						if (yych == 'u') goto yy87;
					}
				}
			}
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(21, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy98;
		if (yych == '=') goto yy100;
		goto yy8;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy102;
		if (yych == '=') goto yy104;
		goto yy8;
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		goto yy8;
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy106;
			goto yy8;
		} else {
			if (yych <= '=') goto yy108;
			if (yych <= '>') goto yy110;
			goto yy8;
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy112;
			goto yy8;
		} else {
			if (yych <= '9') goto yy113;
			if (yych == '=') goto yy116;
			goto yy8;
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy118;
			goto yy8;
		} else {
			if (yych <= '/') goto yy120;
			if (yych == '=') goto yy121;
			goto yy8;
		}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'N') {
				if (yych == 'B') goto yy124;
				goto yy31;
			} else {
				if (yych <= 'O') goto yy126;
				if (yych <= 'W') goto yy31;
				goto yy127;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy124;
				goto yy31;
			} else {
				if (yych <= 'o') goto yy126;
				if (yych == 'x') goto yy127;
				goto yy31;
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	bool is_octal = lnum[0] == '0';
	bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy31:
		YYDEBUG(31, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy30;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy123;
			if (yych <= 'D') goto yy29;
			goto yy125;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy29;
				goto yy128;
			} else {
				if (yych == 'e') goto yy125;
				goto yy29;
			}
		}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy129;
		goto yy8;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy8;
		if (yych <= '<') goto yy131;
		if (yych <= '=') goto yy133;
		if (yych <= '>') goto yy135;
		goto yy8;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy136;
		if (yych <= '>') goto yy138;
		goto yy8;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy8;
		if (yych <= '=') goto yy140;
		if (yych <= '>') goto yy142;
		goto yy8;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy144;
			goto yy8;
		} else {
			if (yych <= '>') goto yy145;
			if (yych <= '?') goto yy147;
			goto yy8;
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy149;
				goto yy46;
			} else {
				if (yych <= 'N') goto yy150;
				if (yych <= 'Q') goto yy46;
				if (yych <= 'R') goto yy151;
				goto yy152;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy149;
				if (yych <= 'm') goto yy46;
				goto yy150;
			} else {
				if (yych <= 'q') goto yy46;
				if (yych <= 'r') goto yy151;
				if (yych <= 's') goto yy152;
				goto yy46;
			}
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy46;
				goto yy9;
			} else {
				if (yych == '\'') goto yy16;
				goto yy46;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy155;
				if (yych <= 'Q') goto yy46;
				goto yy156;
			} else {
				if (yych == 'r') goto yy156;
				goto yy46;
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy157;
				goto yy46;
			} else {
				if (yych <= 'L') goto yy158;
				if (yych <= 'N') goto yy46;
				goto yy159;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy157;
				goto yy46;
			} else {
				if (yych <= 'l') goto yy158;
				if (yych == 'o') goto yy159;
				goto yy46;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy160;
				goto yy46;
			} else {
				if (yych <= 'I') goto yy161;
				if (yych <= 'N') goto yy46;
				goto yy162;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy160;
				goto yy46;
			} else {
				if (yych <= 'i') goto yy161;
				if (yych == 'o') goto yy162;
				goto yy46;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy164;
		case 'L':
		case 'l':	goto yy165;
		case 'M':
		case 'm':	goto yy166;
		case 'N':
		case 'n':	goto yy167;
		case 'V':
		case 'v':	goto yy168;
		case 'X':
		case 'x':	goto yy169;
		default:	goto yy46;
		}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy170;
				goto yy46;
			} else {
				if (yych <= 'N') goto yy171;
				if (yych <= 'O') goto yy173;
				if (yych <= 'T') goto yy46;
				goto yy174;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy170;
				if (yych <= 'm') goto yy46;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy173;
				if (yych == 'u') goto yy174;
				goto yy46;
			}
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy175;
			if (yych <= 'N') goto yy46;
			goto yy176;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy46;
				goto yy175;
			} else {
				if (yych == 'o') goto yy176;
				goto yy46;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy46:
		YYDEBUG(46, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
		goto yy38;
yy47:
		YYDEBUG(47, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy177;
				goto yy46;
			} else {
				if (yych <= 'M') goto yy179;
				if (yych <= 'N') goto yy180;
				if (yych <= 'R') goto yy46;
				goto yy181;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy177;
				if (yych <= 'l') goto yy46;
				goto yy179;
			} else {
				if (yych <= 'n') goto yy180;
				if (yych == 's') goto yy181;
				goto yy46;
			}
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy182;
		if (yych == 'i') goto yy182;
		goto yy46;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy183;
		if (yych == 'a') goto yy183;
		goto yy46;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy184;
			if (yych <= 'D') goto yy46;
			goto yy185;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy46;
				goto yy184;
			} else {
				if (yych == 'e') goto yy185;
				goto yy46;
			}
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy186;
		if (yych == 'r') goto yy186;
		goto yy46;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy188;
			if (yych <= 'T') goto yy46;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy46;
				goto yy188;
			} else {
				if (yych == 'u') goto yy189;
				goto yy46;
			}
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy190;
		if (yych == 'e') goto yy190;
		goto yy46;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy191;
			if (yych <= 'V') goto yy46;
			goto yy192;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy46;
				goto yy191;
			} else {
				if (yych == 'w') goto yy192;
				goto yy46;
			}
		}
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy193;
			if (yych <= 'Q') goto yy46;
			goto yy194;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy46;
				goto yy193;
			} else {
				if (yych == 'r') goto yy194;
				goto yy46;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy195;
			if (yych <= 'R') goto yy46;
			goto yy196;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy46;
				goto yy195;
			} else {
				if (yych == 's') goto yy196;
				goto yy46;
			}
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy197;
		if (yych == 'a') goto yy197;
		goto yy46;
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy198;
		if (yych == 'h') goto yy198;
		goto yy46;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy199;
		if (yych == 'o') goto yy199;
		goto yy46;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy200;
		if (yych == 'i') goto yy200;
		goto yy46;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		goto yy19;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy63;
			if (yych <= 'Z') goto yy201;
			if (yych >= '_') goto yy201;
		} else {
			if (yych <= '`') goto yy63;
			if (yych <= 'z') goto yy201;
			if (yych >= 0x80) goto yy201;
		}
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy204;
		goto yy8;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy206;
		goto yy46;
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(69, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy207;
		if (yych == '|') goto yy209;
		goto yy8;
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy211;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy75:
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(78, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy77;
			} else {
				if (yych <= '@') goto yy79;
				if (yych <= 'Z') goto yy77;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy77;
			} else {
				if (yych <= 'z') goto yy77;
				if (yych >= 0x80) goto yy77;
			}
		}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(85, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy87:
		YYDEBUG(87, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy86;
		}
		switch (yych) {
		case 'A':
		case 'a':	goto yy89;
		case 'B':
		case 'b':	goto yy90;
		case 'D':
		case 'd':	goto yy91;
		case 'F':
		case 'f':	goto yy92;
		case 'I':
		case 'i':	goto yy93;
		case 'O':
		case 'o':	goto yy94;
		case 'R':
		case 'r':	goto yy95;
		case 'S':
		case 's':	goto yy96;
		case 'U':
		case 'u':	goto yy97;
		default:	goto yy88;
		}
yy88:
		YYDEBUG(88, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 45) {
			if (yyaccept <= 22) {
				if (yyaccept <= 11) {
					if (yyaccept <= 5) {
						if (yyaccept <= 2) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy19;
								} else {
									goto yy8;
								}
							} else {
								goto yy29;
							}
						} else {
							if (yyaccept <= 4) {
								if (yyaccept == 3) {
									goto yy38;
								} else {
									goto yy115;
								}
							} else {
								goto yy119;
							}
						}
					} else {
						if (yyaccept <= 8) {
							if (yyaccept <= 7) {
								if (yyaccept == 6) {
									goto yy132;
								} else {
									goto yy153;
								}
							} else {
								goto yy163;
							}
						} else {
							if (yyaccept <= 10) {
								if (yyaccept == 9) {
									goto yy172;
								} else {
									goto yy178;
								}
							} else {
								goto yy187;
							}
						}
					}
				} else {
					if (yyaccept <= 17) {
						if (yyaccept <= 14) {
							if (yyaccept <= 13) {
								if (yyaccept == 12) {
									goto yy203;
								} else {
									goto yy231;
								}
							} else {
								goto yy237;
							}
						} else {
							if (yyaccept <= 16) {
								if (yyaccept == 15) {
									goto yy240;
								} else {
									goto yy259;
								}
							} else {
								goto yy263;
							}
						}
					} else {
						if (yyaccept <= 20) {
							if (yyaccept <= 19) {
								if (yyaccept == 18) {
									goto yy275;
								} else {
									goto yy286;
								}
							} else {
								goto yy299;
							}
						} else {
							if (yyaccept == 21) {
								goto yy310;
							} else {
								goto yy313;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 34) {
					if (yyaccept <= 28) {
						if (yyaccept <= 25) {
							if (yyaccept <= 24) {
								if (yyaccept == 23) {
									goto yy315;
								} else {
									goto yy318;
								}
							} else {
								goto yy350;
							}
						} else {
							if (yyaccept <= 27) {
								if (yyaccept == 26) {
									goto yy359;
								} else {
									goto yy361;
								}
							} else {
								goto yy370;
							}
						}
					} else {
						if (yyaccept <= 31) {
							if (yyaccept <= 30) {
								if (yyaccept == 29) {
									goto yy372;
								} else {
									goto yy379;
								}
							} else {
								goto yy386;
							}
						} else {
							if (yyaccept <= 33) {
								if (yyaccept == 32) {
									goto yy435;
								} else {
									goto yy437;
								}
							} else {
								goto yy440;
							}
						}
					}
				} else {
					if (yyaccept <= 40) {
						if (yyaccept <= 37) {
							if (yyaccept <= 36) {
								if (yyaccept == 35) {
									goto yy442;
								} else {
									goto yy444;
								}
							} else {
								goto yy446;
							}
						} else {
							if (yyaccept <= 39) {
								if (yyaccept == 38) {
									goto yy452;
								} else {
									goto yy456;
								}
							} else {
								goto yy463;
							}
						}
					} else {
						if (yyaccept <= 43) {
							if (yyaccept <= 42) {
								if (yyaccept == 41) {
									goto yy473;
								} else {
									goto yy475;
								}
							} else {
								goto yy478;
							}
						} else {
							if (yyaccept == 44) {
								goto yy487;
							} else {
								goto yy489;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 68) {
				if (yyaccept <= 57) {
					if (yyaccept <= 51) {
						if (yyaccept <= 48) {
							if (yyaccept <= 47) {
								if (yyaccept == 46) {
									goto yy491;
								} else {
									goto yy493;
								}
							} else {
								goto yy495;
							}
						} else {
							if (yyaccept <= 50) {
								if (yyaccept == 49) {
									goto yy530;
								} else {
									goto yy533;
								}
							} else {
								goto yy537;
							}
						}
					} else {
						if (yyaccept <= 54) {
							if (yyaccept <= 53) {
								if (yyaccept == 52) {
									goto yy545;
								} else {
									goto yy555;
								}
							} else {
								goto yy558;
							}
						} else {
							if (yyaccept <= 56) {
								if (yyaccept == 55) {
									goto yy560;
								} else {
									goto yy562;
								}
							} else {
								goto yy590;
							}
						}
					}
				} else {
					if (yyaccept <= 63) {
						if (yyaccept <= 60) {
							if (yyaccept <= 59) {
								if (yyaccept == 58) {
									goto yy592;
								} else {
									goto yy600;
								}
							} else {
								goto yy602;
							}
						} else {
							if (yyaccept <= 62) {
								if (yyaccept == 61) {
									goto yy604;
								} else {
									goto yy608;
								}
							} else {
								goto yy614;
							}
						}
					} else {
						if (yyaccept <= 66) {
							if (yyaccept <= 65) {
								if (yyaccept == 64) {
									goto yy617;
								} else {
									goto yy621;
								}
							} else {
								goto yy634;
							}
						} else {
							if (yyaccept == 67) {
								goto yy636;
							} else {
								goto yy638;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 79) {
					if (yyaccept <= 74) {
						if (yyaccept <= 71) {
							if (yyaccept <= 70) {
								if (yyaccept == 69) {
									goto yy643;
								} else {
									goto yy647;
								}
							} else {
								goto yy659;
							}
						} else {
							if (yyaccept <= 73) {
								if (yyaccept == 72) {
									goto yy663;
								} else {
									goto yy670;
								}
							} else {
								goto yy677;
							}
						}
					} else {
						if (yyaccept <= 77) {
							if (yyaccept <= 76) {
								if (yyaccept == 75) {
									goto yy679;
								} else {
									goto yy681;
								}
							} else {
								goto yy683;
							}
						} else {
							if (yyaccept == 78) {
								goto yy687;
							} else {
								goto yy693;
							}
						}
					}
				} else {
					if (yyaccept <= 85) {
						if (yyaccept <= 82) {
							if (yyaccept <= 81) {
								if (yyaccept == 80) {
									goto yy695;
								} else {
									goto yy697;
								}
							} else {
								goto yy701;
							}
						} else {
							if (yyaccept <= 84) {
								if (yyaccept == 83) {
									goto yy704;
								} else {
									goto yy711;
								}
							} else {
								goto yy718;
							}
						}
					} else {
						if (yyaccept <= 88) {
							if (yyaccept <= 87) {
								if (yyaccept == 86) {
									goto yy729;
								} else {
									goto yy731;
								}
							} else {
								goto yy733;
							}
						} else {
							if (yyaccept == 89) {
								goto yy739;
							} else {
								goto yy742;
							}
						}
					}
				}
			}
		}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy213;
		if (yych == 'r') goto yy213;
		goto yy88;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy214;
			if (yych <= 'N') goto yy88;
			goto yy215;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy88;
				goto yy214;
			} else {
				if (yych == 'o') goto yy215;
				goto yy88;
			}
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy216;
		if (yych == 'o') goto yy216;
		goto yy88;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy217;
		if (yych == 'l') goto yy217;
		goto yy88;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy218;
		if (yych == 'n') goto yy218;
		goto yy88;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy219;
		if (yych == 'b') goto yy219;
		goto yy88;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy220;
		if (yych == 'e') goto yy220;
		goto yy88;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy221;
		if (yych == 't') goto yy221;
		goto yy88;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy222;
		if (yych == 'n') goto yy222;
		goto yy88;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy223;
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(101, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy225;
		goto yy88;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy114:
		YYDEBUG(114, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy113;
			if (yych >= 'E') goto yy125;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy227;
			} else {
				if (yych == 'e') goto yy125;
			}
		}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy228;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		goto yy12;
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy115;
		goto yy114;
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy229;
		}
		goto yy88;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy232;
			goto yy88;
		} else {
			if (yych <= '-') goto yy232;
			if (yych <= '/') goto yy88;
			if (yych <= '9') goto yy233;
			goto yy88;
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy235;
		}
		goto yy88;
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy238;
		}
		goto yy88;
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy30;
		}
		goto yy88;
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy132;
		if (yych <= '<') goto yy241;
		if (yych <= '=') goto yy243;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy245;
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
		goto yy74;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy247;
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(139, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy249;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy251;
		goto yy88;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy253;
		if (yych == '\r') goto yy254;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy255;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy257;
		if (yych == 's') goto yy257;
		goto yy46;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy258;
		if (yych == 'd') goto yy258;
		goto yy46;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy260;
		if (yych == 'r') goto yy260;
		goto yy46;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy154:
		YYDEBUG(154, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy88;
			if (yych <= 'Z') goto yy261;
			if (yych <= '^') goto yy88;
			goto yy261;
		} else {
			if (yych <= '`') goto yy88;
			if (yych <= 'z') goto yy261;
			if (yych <= 0x7F) goto yy88;
			goto yy261;
		}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy264;
		goto yy88;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy265;
		if (yych == 'e') goto yy265;
		goto yy46;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy46;
				goto yy266;
			} else {
				if (yych <= 'R') goto yy46;
				if (yych <= 'S') goto yy267;
				goto yy268;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy266;
				goto yy46;
			} else {
				if (yych <= 's') goto yy267;
				if (yych <= 't') goto yy268;
				goto yy46;
			}
		}
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy269;
			if (yych <= 'N') goto yy46;
			goto yy270;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy46;
				goto yy269;
			} else {
				if (yych == 'o') goto yy270;
				goto yy46;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy271;
		if (yych == 'n') goto yy271;
		goto yy46;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy272;
			if (yych <= 'E') goto yy46;
			goto yy273;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy46;
				goto yy272;
			} else {
				if (yych == 'f') goto yy273;
				goto yy46;
			}
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy274;
		if (yych == 'e') goto yy274;
		goto yy46;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy276;
		if (yych == 'h') goto yy276;
		goto yy46;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy277;
		if (yych == 's') goto yy277;
		goto yy46;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy278;
		if (yych == 'p') goto yy278;
		goto yy46;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'D') goto yy279;
			if (yych <= 'T') goto yy46;
			goto yy280;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy46;
				goto yy279;
			} else {
				if (yych == 'u') goto yy280;
				goto yy46;
			}
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy281;
		if (yych == 'a') goto yy281;
		goto yy46;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy282;
			if (yych <= 'S') goto yy46;
			goto yy283;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy46;
				goto yy282;
			} else {
				if (yych == 't') goto yy283;
				goto yy46;
			}
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy284;
		if (yych == 'n') goto yy284;
		goto yy46;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy285;
		if (yych == 'r') goto yy285;
		goto yy46;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy287;
		if (yych == 'n') goto yy287;
		goto yy46;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy288;
		if (yych == 'o') goto yy288;
		goto yy46;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy289;
		if (yych == 't') goto yy289;
		goto yy46;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy290;
		if (yych == 'p') goto yy290;
		goto yy46;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy46;
				goto yy291;
			} else {
				if (yych <= 'R') goto yy46;
				if (yych <= 'S') goto yy292;
				goto yy293;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy291;
				goto yy46;
			} else {
				if (yych <= 's') goto yy292;
				if (yych <= 't') goto yy293;
				goto yy46;
			}
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy294;
		if (yych == 's') goto yy294;
		goto yy46;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy295;
		if (yych == 's') goto yy295;
		goto yy46;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy296;
		if (yych == 't') goto yy296;
		goto yy46;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy297;
		if (yych == 'm') goto yy297;
		goto yy46;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy298;
		if (yych == 'w') goto yy298;
		goto yy46;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy300;
			if (yych <= 'N') goto yy46;
			goto yy301;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy46;
				goto yy300;
			} else {
				if (yych == 'o') goto yy301;
				goto yy46;
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy302;
		if (yych == 'b') goto yy302;
		goto yy46;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'Q') goto yy303;
			if (yych <= 'S') goto yy46;
			goto yy304;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy46;
				goto yy303;
			} else {
				if (yych == 't') goto yy304;
				goto yy46;
			}
		}
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy305;
		if (yych == 'a') goto yy305;
		goto yy46;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy306;
		if (yych == 'i') goto yy306;
		goto yy46;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy307;
		if (yych == 'r') goto yy307;
		goto yy46;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy308;
			if (yych <= 'X') goto yy46;
			goto yy309;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy46;
				goto yy308;
			} else {
				if (yych == 'y') goto yy309;
				goto yy46;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy311;
		if (yych == 's') goto yy311;
		goto yy46;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy312;
		if (yych == 'e') goto yy312;
		goto yy46;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy314;
		if (yych == 'r') goto yy314;
		goto yy46;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy316;
		if (yych == 'i') goto yy316;
		goto yy46;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy317;
		if (yych == 'r') goto yy317;
		goto yy46;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy319;
		if (yych == 'e') goto yy319;
		goto yy46;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 12;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(202, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy203;
				if (yych <= '9') goto yy201;
			} else {
				if (yych <= 'Z') goto yy201;
				if (yych >= '\\') goto yy320;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy201;
			} else {
				if (yych <= 'z') goto yy201;
				if (yych >= 0x80) goto yy201;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'C':
		case 'c':	goto yy321;
		case 'D':
		case 'd':	goto yy322;
		case 'F':
		case 'f':	goto yy323;
		case 'H':
		case 'h':	goto yy324;
		case 'L':
		case 'l':	goto yy325;
		case 'M':
		case 'm':	goto yy326;
		case 'N':
		case 'n':	goto yy327;
		case 'T':
		case 't':	goto yy328;
		default:	goto yy46;
		}
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy213:
		YYDEBUG(213, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy329;
		if (yych == 'r') goto yy329;
		goto yy88;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy330;
		if (yych == 'n') goto yy330;
		goto yy88;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy331;
		if (yych == 'o') goto yy331;
		goto yy88;
yy216:
		YYDEBUG(216, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy332;
		if (yych == 'u') goto yy332;
		goto yy88;
yy217:
		YYDEBUG(217, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy333;
		if (yych == 'o') goto yy333;
		goto yy88;
yy218:
		YYDEBUG(218, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy334;
		if (yych == 't') goto yy334;
		goto yy88;
yy219:
		YYDEBUG(219, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy335;
		if (yych == 'j') goto yy335;
		goto yy88;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy336;
		if (yych == 'a') goto yy336;
		goto yy88;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy337;
		if (yych == 'r') goto yy337;
		goto yy88;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy338;
		if (yych == 's') goto yy338;
		goto yy88;
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy88;
		if (yych <= '9') goto yy113;
		goto yy88;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy88;
			if (yych <= '\n') goto yy339;
			goto yy88;
		} else {
			if (yych <= '\r') goto yy339;
			if (yych == ' ') goto yy339;
			goto yy88;
		}
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy229;
		}
		if (yych == '_') goto yy124;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy88;
		if (yych >= ':') goto yy88;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		if (yych <= '/') goto yy115;
		if (yych <= '9') goto yy233;
		if (yych == '_') goto yy232;
		goto yy115;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy235;
		}
		if (yych == '_') goto yy126;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0o" */
	size_t len = yyleng - 2;
	char *end, *octal = yytext + 2;
	bool contains_underscores = (memchr(octal, '_', len) != NULL);

	/* Skip any leading 0s */
	while (len > 0 && (*octal == '0' || *octal == '_')) {
		++octal;
		--len;
	}

	if (len == 0) {
		ZVAL_LONG(zendlval, 0);
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	if (contains_underscores) {
		octal = estrndup(octal, len);
		strip_underscores(octal, &len);
	}

	errno = 0;

	ZVAL_LONG(zendlval, ZEND_STRTOL(octal, &end, 8));

	ZEND_ASSERT(end == octal + len);

	if (!errno) {
		if (contains_underscores) {
			efree(octal);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	/* Overflow */
	ZEND_ASSERT(errno == ERANGE);
	/* Reset errno */
	errno = 0;

	/* zend_oct_strtod skips leading '0' */
	ZVAL_DOUBLE(zendlval, zend_oct_strtod(octal, (const char **)&end));
	ZEND_ASSERT(!errno);
	ZEND_ASSERT(end == octal + len);
	if (contains_underscores) {
		efree(octal);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyaccept = 15;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy238;
		}
		if (yych == '_') goto yy127;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(242, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy241;
				if (yych <= 0x1F) goto yy88;
				goto yy241;
			} else {
				if (yych == '"') goto yy341;
				if (yych <= '&') goto yy88;
				goto yy342;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy88;
				if (yych <= 'Z') goto yy343;
				if (yych <= '^') goto yy88;
				goto yy343;
			} else {
				if (yych <= '`') goto yy88;
				if (yych <= 'z') goto yy343;
				if (yych <= 0x7F) goto yy88;
				goto yy343;
			}
		}
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		++YYCURSOR;
		goto yy146;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy253;
		goto yy146;
yy255:
		YYDEBUG(255, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy345;
		if (yych == 't') goto yy345;
		goto yy46;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyaccept = 16;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy346;
		if (yych == 'a') goto yy346;
		goto yy46;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 17;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(262, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy263;
				if (yych <= '9') goto yy261;
			} else {
				if (yych <= 'Z') goto yy261;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy261;
			} else {
				if (yych <= 'z') goto yy261;
				if (yych >= 0x80) goto yy261;
			}
		}
yy263:
		YYDEBUG(263, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy241;
		goto yy88;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy347;
		if (yych == 'a') goto yy347;
		goto yy46;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy348;
		if (yych == 'l') goto yy348;
		goto yy46;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy349;
		if (yych == 'e') goto yy349;
		goto yy46;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy351;
		if (yych == 'c') goto yy351;
		goto yy46;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy352;
		if (yych == 's') goto yy352;
		goto yy46;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy353;
		if (yych == 'n') goto yy353;
		goto yy46;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy46;
			if (yych <= 'S') goto yy354;
			goto yy355;
		} else {
			if (yych <= 'r') goto yy46;
			if (yych <= 's') goto yy354;
			if (yych <= 't') goto yy355;
			goto yy46;
		}
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy356;
		if (yych == 'l') goto yy356;
		goto yy46;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy357;
		if (yych == 'a') goto yy357;
		goto yy46;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy358;
		if (yych == 'o') goto yy358;
		goto yy46;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy360;
		if (yych == 'e') goto yy360;
		goto yy46;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy362;
		if (yych == 't') goto yy362;
		goto yy46;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
		case 'D':
		case 'd':	goto yy363;
		case 'F':
		case 'f':	goto yy364;
		case 'I':
		case 'i':	goto yy365;
		case 'S':
		case 's':	goto yy366;
		case 'W':
		case 'w':	goto yy367;
		default:	goto yy46;
		}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy368;
		if (yych == 'm') goto yy368;
		goto yy46;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy369;
		if (yych == 'l') goto yy369;
		goto yy46;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy371;
		if (yych == 't') goto yy371;
		goto yy46;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy373;
		if (yych == 'e') goto yy373;
		goto yy46;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy374;
		if (yych == 'a') goto yy374;
		goto yy46;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy286;
				if (yych <= '9') goto yy45;
				if (yych >= 'A') goto yy45;
			} else {
				if (yych <= 'E') goto yy375;
				if (yych <= 'Z') goto yy45;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy45;
				if (yych >= 'a') goto yy45;
			} else {
				if (yych <= 'e') goto yy375;
				if (yych <= 'z') goto yy45;
				if (yych >= 0x80) goto yy45;
			}
		}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy376;
		if (yych == 'c') goto yy376;
		goto yy46;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy377;
		if (yych == 'b') goto yy377;
		goto yy46;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy378;
		if (yych == 'o') goto yy378;
		goto yy46;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy380;
		if (yych == 'l') goto yy380;
		goto yy46;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy381;
		if (yych == 'l') goto yy381;
		goto yy46;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy382;
		if (yych == 't') goto yy382;
		goto yy46;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy383;
		if (yych == 'e') goto yy383;
		goto yy46;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy384;
		if (yych == 'e') goto yy384;
		goto yy46;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy385;
		if (yych == 't') goto yy385;
		goto yy46;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy387;
		if (yych == 'c') goto yy387;
		goto yy46;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy388;
		if (yych == 'e') goto yy388;
		goto yy46;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy389;
			if (yych <= 'U') goto yy46;
			goto yy390;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy46;
				goto yy389;
			} else {
				if (yych == 'v') goto yy390;
				goto yy46;
			}
		}
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy391;
		if (yych == 't') goto yy391;
		goto yy46;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy392;
		if (yych == 'l') goto yy392;
		goto yy46;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy393;
		if (yych == 'u') goto yy393;
		goto yy46;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy394;
		if (yych == 'u') goto yy394;
		goto yy46;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy395;
		if (yych == 't') goto yy395;
		goto yy46;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy396;
		if (yych == 't') goto yy396;
		goto yy46;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy397;
		if (yych == 'o') goto yy397;
		goto yy46;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy398;
		if (yych == 'i') goto yy398;
		goto yy46;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy399;
		if (yych == 'e') goto yy399;
		goto yy46;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy314:
		YYDEBUG(314, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy400;
		if (yych == 'l') goto yy400;
		goto yy46;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy401;
		if (yych == 'l') goto yy401;
		goto yy46;
yy320:
		YYDEBUG(320, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy88;
			if (yych <= 'Z') goto yy201;
			if (yych <= '^') goto yy88;
			goto yy201;
		} else {
			if (yych <= '`') goto yy88;
			if (yych <= 'z') goto yy201;
			if (yych <= 0x7F) goto yy88;
			goto yy201;
		}
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy402;
		if (yych == 'l') goto yy402;
		goto yy46;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy403;
		if (yych == 'i') goto yy403;
		goto yy46;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy404;
			if (yych <= 'T') goto yy46;
			goto yy405;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy46;
				goto yy404;
			} else {
				if (yych == 'u') goto yy405;
				goto yy46;
			}
		}
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy406;
		if (yych == 'a') goto yy406;
		goto yy46;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy407;
		if (yych == 'i') goto yy407;
		goto yy46;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy408;
		if (yych == 'e') goto yy408;
		goto yy46;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy409;
		if (yych == 'a') goto yy409;
		goto yy46;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy410;
		if (yych == 'r') goto yy410;
		goto yy46;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy411;
		if (yych == 'a') goto yy411;
		goto yy88;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy412;
		if (yych == 'a') goto yy412;
		goto yy88;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy413;
		if (yych == 'l') goto yy413;
		goto yy88;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy414;
		if (yych == 'b') goto yy414;
		goto yy88;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy415;
		if (yych == 'a') goto yy415;
		goto yy88;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy420;
		if (yych == 'e') goto yy420;
		goto yy417;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy421;
		if (yych == 'e') goto yy421;
		goto yy88;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy422;
		if (yych == 'l') goto yy422;
		goto yy88;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy424;
		if (yych == 'i') goto yy424;
		goto yy88;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy425;
		if (yych == 'e') goto yy425;
		goto yy88;
yy339:
		YYDEBUG(339, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(340, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy119;
			if (yych <= '\n') goto yy339;
			goto yy119;
		} else {
			if (yych <= '\r') goto yy339;
			if (yych == ' ') goto yy339;
			goto yy119;
		}
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy88;
		if (yych <= '/') goto yy427;
		if (yych <= '9') goto yy88;
		goto yy427;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy88;
		if (yych <= '/') goto yy429;
		if (yych <= '9') goto yy88;
		goto yy429;
yy343:
		YYDEBUG(343, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(344, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy430;
				goto yy88;
			} else {
				if (yych <= '\r') goto yy432;
				if (yych <= '/') goto yy88;
				if (yych <= '9') goto yy343;
				goto yy88;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy343;
				if (yych <= '^') goto yy88;
				goto yy343;
			} else {
				if (yych <= '`') goto yy88;
				if (yych <= 'z') goto yy343;
				if (yych <= 0x7F) goto yy88;
				goto yy343;
			}
		}
yy345:
		YYDEBUG(345, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy433;
		if (yych == 'r') goto yy433;
		goto yy46;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy434;
		if (yych == 'y') goto yy434;
		goto yy46;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy436;
		if (yych == 'k') goto yy436;
		goto yy46;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy438;
		if (yych == 'a') goto yy438;
		goto yy46;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy351:
		YYDEBUG(351, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy439;
		if (yych == 'h') goto yy439;
		goto yy46;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy441;
		if (yych == 's') goto yy441;
		goto yy46;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy443;
		if (yych == 'e') goto yy443;
		goto yy46;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy445;
		if (yych == 't') goto yy445;
		goto yy46;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy447;
		if (yych == 'i') goto yy447;
		goto yy46;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy448;
		if (yych == 'a') goto yy448;
		goto yy46;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy449;
		if (yych == 'u') goto yy449;
		goto yy46;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy360:
		YYDEBUG(360, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy361;
				if (yych <= '9') goto yy45;
				if (yych >= 'A') goto yy45;
			} else {
				if (yych <= 'I') goto yy450;
				if (yych <= 'Z') goto yy45;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy45;
				if (yych >= 'a') goto yy45;
			} else {
				if (yych <= 'i') goto yy450;
				if (yych <= 'z') goto yy45;
				if (yych >= 0x80) goto yy45;
			}
		}
yy361:
		YYDEBUG(361, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy362:
		YYDEBUG(362, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy451;
		if (yych == 'y') goto yy451;
		goto yy46;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy453;
		if (yych == 'e') goto yy453;
		goto yy46;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy454;
		if (yych == 'o') goto yy454;
		goto yy46;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy455;
		if (yych == 'f') goto yy455;
		goto yy46;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy457;
		if (yych == 'w') goto yy457;
		goto yy46;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy458;
		if (yych == 'h') goto yy458;
		goto yy46;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy46;
			if (yych <= '\n') goto yy459;
			goto yy46;
		} else {
			if (yych <= '\r') goto yy459;
			if (yych == ' ') goto yy459;
			goto yy46;
		}
yy369:
		YYDEBUG(369, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy461;
		if (yych == 'n') goto yy461;
		goto yy46;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy462;
		if (yych == 'l') goto yy462;
		goto yy46;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy464;
		if (yych == 'a') goto yy464;
		goto yy46;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy465;
		if (yych == 't') goto yy465;
		goto yy46;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy466;
		if (yych == 'a') goto yy466;
		goto yy46;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy467;
		if (yych == 'e') goto yy467;
		goto yy46;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy468;
		if (yych == 'u') goto yy468;
		goto yy46;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy469;
			if (yych <= 'D') goto yy46;
			goto yy470;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy46;
				goto yy469;
			} else {
				if (yych == 'e') goto yy470;
				goto yy46;
			}
		}
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy471;
		if (yych == 'r') goto yy471;
		goto yy46;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy472;
		if (yych == 't') goto yy472;
		goto yy46;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy387:
		YYDEBUG(387, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy474;
		if (yych == 'h') goto yy474;
		goto yy46;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy476;
		if (yych == 's') goto yy476;
		goto yy46;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy477;
		if (yych == 't') goto yy477;
		goto yy46;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy479;
		if (yych == 'a') goto yy479;
		goto yy46;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy480;
		if (yych == 'e') goto yy480;
		goto yy46;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy481;
		if (yych == 'i') goto yy481;
		goto yy46;
yy393:
		YYDEBUG(393, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy482;
		if (yych == 'i') goto yy482;
		goto yy46;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy483;
		if (yych == 'r') goto yy483;
		goto yy46;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy484;
		if (yych == 'i') goto yy484;
		goto yy46;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy485;
		if (yych == 'c') goto yy485;
		goto yy46;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy486;
		if (yych == 'w') goto yy486;
		goto yy46;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy488;
		if (yych == 't') goto yy488;
		goto yy46;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy490;
		if (yych == 't') goto yy490;
		goto yy46;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy492;
		if (yych == 'e') goto yy492;
		goto yy46;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy494;
		if (yych == 'd') goto yy494;
		goto yy46;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy496;
		if (yych == 'a') goto yy496;
		goto yy46;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy497;
		if (yych == 'r') goto yy497;
		goto yy46;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy498;
		if (yych == 'l') goto yy498;
		goto yy46;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy499;
		if (yych == 'n') goto yy499;
		goto yy46;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy500;
		if (yych == 'l') goto yy500;
		goto yy46;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy501;
		if (yych == 'n') goto yy501;
		goto yy46;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy502;
		if (yych == 't') goto yy502;
		goto yy46;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy503;
		if (yych == 'm') goto yy503;
		goto yy46;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy504;
		if (yych == 'a') goto yy504;
		goto yy46;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy505;
		if (yych == 'y') goto yy505;
		goto yy88;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy507;
		if (yych == 'r') goto yy507;
		goto yy88;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy512;
		if (yych == 'e') goto yy512;
		goto yy509;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy513;
		if (yych == 'l') goto yy513;
		goto yy88;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy514;
		if (yych == 't') goto yy514;
		goto yy88;
yy416:
		YYDEBUG(416, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy417:
		YYDEBUG(417, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy416;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy416;
			if (yych != ')') goto yy88;
		}
		YYDEBUG(418, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy516;
		if (yych == 'g') goto yy516;
		goto yy88;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy517;
		if (yych == 'c') goto yy517;
		goto yy88;
yy422:
		YYDEBUG(422, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(423, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy422;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy422;
			if (yych == ')') goto yy518;
			goto yy88;
		}
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy520;
		if (yych == 'n') goto yy520;
		goto yy88;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy521;
		if (yych == 't') goto yy521;
		goto yy88;
yy426:
		YYDEBUG(426, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy427:
		YYDEBUG(427, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy523;
				goto yy88;
			} else {
				if (yych <= '9') goto yy426;
				if (yych <= '@') goto yy88;
				goto yy426;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy426;
				goto yy88;
			} else {
				if (yych <= 'z') goto yy426;
				if (yych <= 0x7F) goto yy88;
				goto yy426;
			}
		}
yy428:
		YYDEBUG(428, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy429:
		YYDEBUG(429, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy523;
				goto yy88;
			} else {
				if (yych <= '9') goto yy428;
				if (yych <= '@') goto yy88;
				goto yy428;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy428;
				goto yy88;
			} else {
				if (yych <= 'z') goto yy428;
				if (yych <= 0x7F) goto yy88;
				goto yy428;
			}
		}
yy430:
		YYDEBUG(430, *YYCURSOR);
		++YYCURSOR;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy430;
		goto yy431;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy524;
		if (yych == 'a') goto yy524;
		goto yy46;
yy434:
		YYDEBUG(434, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy436:
		YYDEBUG(436, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy438:
		YYDEBUG(438, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy525;
		if (yych == 'b') goto yy525;
		goto yy46;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy441:
		YYDEBUG(441, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy443:
		YYDEBUG(443, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy445:
		YYDEBUG(445, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy447:
		YYDEBUG(447, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy526;
		if (yych == 'n') goto yy526;
		goto yy46;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy527;
		if (yych == 'r') goto yy527;
		goto yy46;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy528;
		if (yych == 'l') goto yy528;
		goto yy46;
yy450:
		YYDEBUG(450, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy529;
		if (yych == 'f') goto yy529;
		goto yy46;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy453:
		YYDEBUG(453, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy531;
		if (yych == 'c') goto yy531;
		goto yy46;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy532;
		if (yych == 'r') goto yy532;
		goto yy46;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy534;
		if (yych == 'i') goto yy534;
		goto yy46;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy535;
		if (yych == 'i') goto yy535;
		goto yy46;
yy459:
		YYDEBUG(459, *YYCURSOR);
		++YYCURSOR;
		YYFILL(10);
		yych = *YYCURSOR;
		YYDEBUG(460, *YYCURSOR);
		if (yych <= 'I') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy88;
					goto yy459;
				} else {
					if (yych == '\r') goto yy459;
					goto yy88;
				}
			} else {
				if (yych <= 'D') {
					if (yych <= ' ') goto yy459;
					if (yych <= '@') goto yy88;
					goto yy536;
				} else {
					if (yych <= 'E') goto yy538;
					if (yych <= 'H') goto yy536;
					goto yy539;
				}
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '^') {
					if (yych <= 'Z') goto yy536;
					goto yy88;
				} else {
					if (yych == '`') goto yy88;
					goto yy536;
				}
			} else {
				if (yych <= 'i') {
					if (yych <= 'e') goto yy538;
					if (yych <= 'h') goto yy536;
					goto yy539;
				} else {
					if (yych <= 'z') goto yy536;
					if (yych <= 0x7F) goto yy88;
					goto yy536;
				}
			}
		}
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy540;
		if (yych == 'd') goto yy540;
		goto yy46;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy463;
				if (yych <= '9') goto yy45;
				if (yych >= 'A') goto yy45;
			} else {
				if (yych <= 'L') goto yy541;
				if (yych <= 'Z') goto yy45;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy45;
				if (yych >= 'a') goto yy45;
			} else {
				if (yych <= 'l') goto yy541;
				if (yych <= 'z') goto yy45;
				if (yych >= 0x80) goto yy45;
			}
		}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy542;
		if (yych == 'c') goto yy542;
		goto yy46;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy543;
		if (yych == 'i') goto yy543;
		goto yy46;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy544;
		if (yych == 'l') goto yy544;
		goto yy46;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy546;
		if (yych == 'm') goto yy546;
		goto yy46;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy547;
		if (yych == 'd') goto yy547;
		goto yy46;
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy548;
		if (yych == 'n') goto yy548;
		goto yy46;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy549;
		if (yych == 'a') goto yy549;
		goto yy46;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy550;
		if (yych == 'f') goto yy550;
		goto yy46;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy551;
		if (yych == 'p') goto yy551;
		goto yy46;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy552;
		if (yych == 't') goto yy552;
		goto yy46;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy553;
		if (yych == 'c') goto yy553;
		goto yy46;
yy481:
		YYDEBUG(481, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy554;
		if (yych == 'c') goto yy554;
		goto yy46;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy556;
		if (yych == 'r') goto yy556;
		goto yy46;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy557;
		if (yych == 'n') goto yy557;
		goto yy46;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy559;
		if (yych == 'c') goto yy559;
		goto yy46;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy561;
		if (yych == 'h') goto yy561;
		goto yy46;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy488:
		YYDEBUG(488, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy495;
			if (yych <= '\n') goto yy563;
			if (yych >= '\r') goto yy563;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy563;
			} else {
				if (yych == '\\') goto yy154;
			}
		}
yy495:
		YYDEBUG(495, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy565;
		if (yych == 's') goto yy565;
		goto yy46;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy566;
		goto yy46;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy567;
		if (yych == 'e') goto yy567;
		goto yy46;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy568;
		if (yych == 'c') goto yy568;
		goto yy46;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy569;
		if (yych == 't') goto yy569;
		goto yy46;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy570;
		if (yych == 'e') goto yy570;
		goto yy46;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy571;
		if (yych == 'h') goto yy571;
		goto yy46;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy572;
		if (yych == 'e') goto yy572;
		goto yy46;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy573;
		if (yych == 'i') goto yy573;
		goto yy46;
yy505:
		YYDEBUG(505, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(506, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy505;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy505;
			if (yych == ')') goto yy574;
			goto yy88;
		}
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy576;
		if (yych == 'y') goto yy576;
		goto yy88;
yy508:
		YYDEBUG(508, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy509:
		YYDEBUG(509, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy508;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy508;
			if (yych != ')') goto yy88;
		}
		YYDEBUG(510, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(511, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy578;
		if (yych == 'a') goto yy578;
		goto yy88;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy514;
		if (yych != 'e') goto yy88;
yy514:
		YYDEBUG(514, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(515, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy514;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy514;
			if (yych == ')') goto yy579;
			goto yy88;
		}
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy581;
		if (yych == 'e') goto yy581;
		goto yy88;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy582;
		if (yych == 't') goto yy582;
		goto yy88;
yy518:
		YYDEBUG(518, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(519, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy576;
		if (yych == 'g') goto yy576;
		goto yy88;
yy521:
		YYDEBUG(521, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(522, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy521;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy521;
			if (yych == ')') goto yy584;
			goto yy88;
		}
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy430;
		if (yych == '\r') goto yy432;
		goto yy88;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy586;
		if (yych == 'c') goto yy586;
		goto yy46;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy587;
		if (yych == 'l') goto yy587;
		goto yy46;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy588;
		if (yych == 'u') goto yy588;
		goto yy46;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy589;
		if (yych == 'e') goto yy589;
		goto yy46;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy591;
		if (yych == 't') goto yy591;
		goto yy46;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy531:
		YYDEBUG(531, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy593;
		if (yych == 'l') goto yy593;
		goto yy46;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy533;
				if (yych <= '9') goto yy45;
				if (yych >= 'A') goto yy45;
			} else {
				if (yych <= 'E') goto yy594;
				if (yych <= 'Z') goto yy45;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy45;
				if (yych >= 'a') goto yy45;
			} else {
				if (yych <= 'e') goto yy594;
				if (yych <= 'z') goto yy45;
				if (yych >= 0x80) goto yy45;
			}
		}
yy533:
		YYDEBUG(533, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy534:
		YYDEBUG(534, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy595;
		if (yych == 't') goto yy595;
		goto yy46;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy596;
		if (yych == 'l') goto yy596;
		goto yy46;
yy536:
		YYDEBUG(536, *YYCURSOR);
		++YYCURSOR;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_IDENT(T_ENUM);
}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'X') goto yy597;
		if (yych == 'x') goto yy597;
		goto yy537;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy598;
		if (yych == 'm') goto yy598;
		goto yy537;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy599;
		if (yych == 's') goto yy599;
		goto yy46;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy601;
		if (yych == 'y') goto yy601;
		goto yy46;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy603;
		if (yych == 'h') goto yy603;
		goto yy46;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy605;
		if (yych == 'o') goto yy605;
		goto yy46;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy546:
		YYDEBUG(546, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy606;
		if (yych == 'e') goto yy606;
		goto yy46;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy607;
		if (yych == 'e') goto yy607;
		goto yy46;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy609;
		if (yych == 'c') goto yy609;
		goto yy46;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy610;
		if (yych == 'd') goto yy610;
		goto yy46;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy611;
		if (yych == 'a') goto yy611;
		goto yy46;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy612;
		if (yych == 'a') goto yy612;
		goto yy46;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy613;
		if (yych == 'e') goto yy613;
		goto yy46;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy615;
		if (yych == 't') goto yy615;
		goto yy46;
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy616;
		if (yych == 'e') goto yy616;
		goto yy46;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy561:
		YYDEBUG(561, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy562:
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy563:
		YYDEBUG(563, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(564, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy88;
				goto yy563;
			} else {
				if (yych == '\r') goto yy563;
				goto yy88;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy563;
				if (yych <= 'E') goto yy88;
				goto yy618;
			} else {
				if (yych == 'f') goto yy618;
				goto yy88;
			}
		}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy619;
		if (yych == 's') goto yy619;
		goto yy46;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy620;
		goto yy46;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy622;
		goto yy46;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy623;
		if (yych == 't') goto yy623;
		goto yy46;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy624;
		goto yy46;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy625;
		goto yy46;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy626;
		if (yych == 'o') goto yy626;
		goto yy46;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy627;
		if (yych == 's') goto yy627;
		goto yy46;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy628;
		if (yych == 't') goto yy628;
		goto yy46;
yy574:
		YYDEBUG(574, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(575, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(577, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy576;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy576;
			if (yych == ')') goto yy629;
			goto yy88;
		}
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy508;
		if (yych == 'n') goto yy508;
		goto yy88;
yy579:
		YYDEBUG(579, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(580, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy416;
		if (yych == 'r') goto yy416;
		goto yy88;
yy582:
		YYDEBUG(582, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(583, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy582;
			goto yy88;
		} else {
			if (yych <= ' ') goto yy582;
			if (yych == ')') goto yy631;
			goto yy88;
		}
yy584:
		YYDEBUG(584, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy586:
		YYDEBUG(586, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy633;
		if (yych == 't') goto yy633;
		goto yy46;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy635;
		if (yych == 'e') goto yy635;
		goto yy46;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy637;
		if (yych == 'e') goto yy637;
		goto yy46;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy591:
		YYDEBUG(591, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy639;
		if (yych == 'a') goto yy639;
		goto yy46;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy640;
		if (yych == 'a') goto yy640;
		goto yy46;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy641;
		if (yych == 'c') goto yy641;
		goto yy46;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy642;
		if (yych == 'e') goto yy642;
		goto yy46;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy644;
		if (yych == 't') goto yy644;
		goto yy88;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy645;
		if (yych == 'p') goto yy645;
		goto yy88;
yy599:
		YYDEBUG(599, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy605:
		YYDEBUG(605, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy646;
		if (yych == 'n') goto yy646;
		goto yy46;
yy606:
		YYDEBUG(606, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy648;
		if (yych == 'n') goto yy648;
		goto yy46;
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy608;
				if (yych <= '9') goto yy45;
			} else {
				if (yych <= 'Z') goto yy45;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy649;
			} else {
				if (yych <= 'z') goto yy45;
				if (yych >= 0x80) goto yy45;
			}
		}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy609:
		YYDEBUG(609, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy650;
		if (yych == 'e') goto yy650;
		goto yy46;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy651;
		if (yych == 'o') goto yy651;
		goto yy46;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy652;
		if (yych == 'c') goto yy652;
		goto yy46;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy653;
		if (yych == 'c') goto yy653;
		goto yy46;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy654;
		if (yych == 'e') goto yy654;
		goto yy46;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy617;
				if (yych <= '9') goto yy45;
			} else {
				if (yych <= 'Z') goto yy45;
				if (yych >= '\\') goto yy154;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy655;
			} else {
				if (yych <= 'z') goto yy45;
				if (yych >= 0x80) goto yy45;
			}
		}
yy617:
		YYDEBUG(617, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy656;
		if (yych == 'r') goto yy656;
		goto yy88;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy657;
		goto yy46;
yy620:
		YYDEBUG(620, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy622:
		YYDEBUG(622, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy658;
		goto yy46;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy660;
		if (yych == 'i') goto yy660;
		goto yy46;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy661;
		if (yych == 'c') goto yy661;
		goto yy46;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy662;
		goto yy46;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy664;
		if (yych == 'd') goto yy664;
		goto yy46;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy665;
		if (yych == 'p') goto yy665;
		goto yy46;
yy628:
		YYDEBUG(628, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy666;
		goto yy46;
yy629:
		YYDEBUG(629, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(630, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy631:
		YYDEBUG(631, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(632, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy639:
		YYDEBUG(639, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy667;
		if (yych == 'r') goto yy667;
		goto yy46;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy668;
		if (yych == 'c') goto yy668;
		goto yy46;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy669;
		if (yych == 'h') goto yy669;
		goto yy46;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy671;
		if (yych == 'e') goto yy671;
		goto yy88;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy672;
		if (yych == 'l') goto yy672;
		goto yy88;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy673;
		if (yych == 't') goto yy673;
		goto yy46;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy674;
		if (yych == 'o') goto yy674;
		goto yy46;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy675;
		if (yych == 'o') goto yy675;
		goto yy46;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy676;
		if (yych == 'f') goto yy676;
		goto yy46;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy678;
		if (yych == 'e') goto yy678;
		goto yy46;
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy680;
		if (yych == 'e') goto yy680;
		goto yy46;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy682;
		if (yych == 'd') goto yy682;
		goto yy46;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy684;
		if (yych == 'o') goto yy684;
		goto yy46;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy685;
		if (yych == 'o') goto yy685;
		goto yy88;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy686;
		goto yy46;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy688;
		if (yych == 'o') goto yy688;
		goto yy46;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy689;
		if (yych == 'o') goto yy689;
		goto yy46;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy664:
		YYDEBUG(664, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy690;
		goto yy46;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy691;
		if (yych == 'a') goto yy691;
		goto yy46;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy692;
		goto yy46;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy694;
		if (yych == 'e') goto yy694;
		goto yy46;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy696;
		if (yych == 'h') goto yy696;
		goto yy46;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy698;
		if (yych == 'n') goto yy698;
		goto yy88;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy699;
		if (yych == 'e') goto yy699;
		goto yy88;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy700;
		if (yych == 's') goto yy700;
		goto yy46;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy702;
		if (yych == 'n') goto yy702;
		goto yy46;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy703;
		if (yych == 'f') goto yy703;
		goto yy46;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy680:
		YYDEBUG(680, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy705;
yy681:
		YYDEBUG(681, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy682:
		YYDEBUG(682, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy706;
		if (yych == 'n') goto yy706;
		goto yy46;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy707;
		if (yych == 'm') goto yy707;
		goto yy88;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy708;
		if (yych == 'n') goto yy708;
		goto yy46;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy709;
		if (yych == 'm') goto yy709;
		goto yy46;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy710;
		goto yy46;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy712;
		if (yych == 'c') goto yy712;
		goto yy46;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy694:
		YYDEBUG(694, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy696:
		YYDEBUG(696, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy713;
		if (yych == 'd') goto yy713;
		goto yy88;
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy714;
		if (yych == 'm') goto yy714;
		goto yy88;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy715;
		if (yych == 'c') goto yy715;
		goto yy46;
yy703:
		YYDEBUG(703, *YYCURSOR);
		yyaccept = 83;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy705:
		YYDEBUG(705, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy88;
			if (yych <= 'Z') goto yy716;
			if (yych <= '^') goto yy88;
			goto yy716;
		} else {
			if (yych <= '`') goto yy88;
			if (yych <= 'z') goto yy716;
			if (yych <= 0x7F) goto yy88;
			goto yy716;
		}
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy719;
		if (yych == 'c') goto yy719;
		goto yy46;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy720;
				goto yy88;
			} else {
				if (yych <= '@') goto yy720;
				if (yych <= 'Z') goto yy88;
				goto yy720;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy88;
				goto yy720;
			} else {
				if (yych <= 'z') goto yy88;
				if (yych <= 0x7F) goto yy720;
				goto yy88;
			}
		}
yy708:
		YYDEBUG(708, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy722;
		goto yy46;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy723;
		if (yych == 'p') goto yy723;
		goto yy46;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy724;
		if (yych == 'e') goto yy724;
		goto yy46;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy725;
		if (yych == 's') goto yy725;
		goto yy88;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy727;
		if (yych == 'e') goto yy727;
		goto yy88;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy728;
		if (yych == 'e') goto yy728;
		goto yy46;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yyaccept = 85;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(717, *YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy718;
				if (yych <= '9') goto yy716;
			} else {
				if (yych <= 'Z') goto yy716;
				if (yych >= '\\') goto yy705;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy716;
			} else {
				if (yych <= 'z') goto yy716;
				if (yych >= 0x80) goto yy716;
			}
		}
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy730;
		if (yych == 'e') goto yy730;
		goto yy46;
yy720:
		YYDEBUG(720, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(721, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy732;
		goto yy46;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy734;
		if (yych == 'i') goto yy734;
		goto yy46;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy735;
		goto yy46;
yy725:
		YYDEBUG(725, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(726, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy736;
		if (yych == 'n') goto yy736;
		goto yy88;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yyaccept = 86;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy730:
		YYDEBUG(730, *YYCURSOR);
		yyaccept = 87;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yyaccept = 88;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy734:
		YYDEBUG(734, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy737;
		if (yych == 'l') goto yy737;
		goto yy46;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy738;
		goto yy46;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy713;
		if (yych == 't') goto yy713;
		goto yy88;
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy740;
		if (yych == 'e') goto yy740;
		goto yy46;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyaccept = 89;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy741;
		if (yych != 'r') goto yy46;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yyaccept = 90;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy45;
		}
		if (yych == '\\') goto yy154;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(743, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy747;
		}
		if (yych <= 'Z') {
			if (yych <= '>') {
				if (yych == '-') goto yy750;
			} else {
				if (yych <= '?') goto yy751;
				if (yych >= 'A') goto yy752;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy752;
			} else {
				if (yych <= 'z') goto yy752;
				if (yych >= 0x80) goto yy752;
			}
		}
		YYDEBUG(745, *YYCURSOR);
		++YYCURSOR;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(748, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy747;
		}
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy755;
		goto yy746;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy757;
		goto yy746;
yy752:
		YYDEBUG(752, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(753, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy752;
		}
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy755:
		YYDEBUG(755, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(756, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy759;
		YYDEBUG(758, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy746;
yy759:
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(760, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(761, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy765;
		} else {
			if (yych <= '`') goto yy766;
			if (yych == '{') goto yy768;
		}
		YYDEBUG(763, *YYCURSOR);
		++YYCURSOR;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy764;
			if (yych <= 'Z') goto yy769;
			if (yych <= '^') goto yy764;
			goto yy769;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy764;
				goto yy769;
			} else {
				if (yych <= '{') goto yy772;
				if (yych <= 0x7F) goto yy764;
				goto yy769;
			}
		}
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(767, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy774;
		goto yy764;
yy769:
		YYDEBUG(769, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(770, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy769;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy776;
		} else {
			if (yych <= '?') goto yy778;
			if (yych <= '@') goto yy771;
			if (yych <= '[') goto yy779;
		}
yy771:
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy774:
		YYDEBUG(774, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(775, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy781;
yy777:
		YYDEBUG(777, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy771;
yy778:
		YYDEBUG(778, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy782;
		goto yy777;
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(780, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy781:
		YYDEBUG(781, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy777;
			if (yych <= 'Z') goto yy783;
			if (yych <= '^') goto yy777;
			goto yy783;
		} else {
			if (yych <= '`') goto yy777;
			if (yych <= 'z') goto yy783;
			if (yych <= 0x7F) goto yy777;
			goto yy783;
		}
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy785;
		goto yy777;
yy783:
		YYDEBUG(783, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(784, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy785:
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy777;
			if (yych <= 'Z') goto yy786;
			if (yych <= '^') goto yy777;
		} else {
			if (yych <= '`') goto yy777;
			if (yych <= 'z') goto yy786;
			if (yych <= 0x7F) goto yy777;
		}
yy786:
		YYDEBUG(786, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(788, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy792;
		} else {
			if (yych <= '$') goto yy794;
			if (yych == '{') goto yy795;
		}
		YYDEBUG(790, *YYCURSOR);
		++YYCURSOR;
yy791:
		YYDEBUG(791, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy792:
		YYDEBUG(792, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy794:
		YYDEBUG(794, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy791;
			if (yych <= 'Z') goto yy796;
			if (yych <= '^') goto yy791;
			goto yy796;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy791;
				goto yy796;
			} else {
				if (yych <= '{') goto yy799;
				if (yych <= 0x7F) goto yy791;
				goto yy796;
			}
		}
yy795:
		YYDEBUG(795, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy801;
		goto yy791;
yy796:
		YYDEBUG(796, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(797, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy796;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy803;
		} else {
			if (yych <= '?') goto yy805;
			if (yych <= '@') goto yy798;
			if (yych <= '[') goto yy806;
		}
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(800, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy801:
		YYDEBUG(801, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(802, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy803:
		YYDEBUG(803, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy808;
yy804:
		YYDEBUG(804, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy798;
yy805:
		YYDEBUG(805, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy809;
		goto yy804;
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(807, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy808:
		YYDEBUG(808, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy810;
			if (yych <= '^') goto yy804;
			goto yy810;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy810;
			if (yych <= 0x7F) goto yy804;
			goto yy810;
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy812;
		goto yy804;
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(811, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy812:
		YYDEBUG(812, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy813;
			if (yych <= '^') goto yy804;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy813;
			if (yych <= 0x7F) goto yy804;
		}
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(815, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy819;
		if (yych == '{') goto yy820;
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
yy818:
		YYDEBUG(818, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy819:
		YYDEBUG(819, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy818;
			if (yych <= 'Z') goto yy821;
			if (yych <= '^') goto yy818;
			goto yy821;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy818;
				goto yy821;
			} else {
				if (yych <= '{') goto yy824;
				if (yych <= 0x7F) goto yy818;
				goto yy821;
			}
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy826;
		goto yy818;
yy821:
		YYDEBUG(821, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(822, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy821;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy828;
		} else {
			if (yych <= '?') goto yy830;
			if (yych <= '@') goto yy823;
			if (yych <= '[') goto yy831;
		}
yy823:
		YYDEBUG(823, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy824:
		YYDEBUG(824, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(825, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy826:
		YYDEBUG(826, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(827, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy828:
		YYDEBUG(828, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy833;
yy829:
		YYDEBUG(829, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy823;
yy830:
		YYDEBUG(830, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy834;
		goto yy829;
yy831:
		YYDEBUG(831, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(832, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy833:
		YYDEBUG(833, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy829;
			if (yych <= 'Z') goto yy835;
			if (yych <= '^') goto yy829;
			goto yy835;
		} else {
			if (yych <= '`') goto yy829;
			if (yych <= 'z') goto yy835;
			if (yych <= 0x7F) goto yy829;
			goto yy835;
		}
yy834:
		YYDEBUG(834, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy837;
		goto yy829;
yy835:
		YYDEBUG(835, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(836, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy837:
		YYDEBUG(837, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy829;
			if (yych <= 'Z') goto yy838;
			if (yych <= '^') goto yy829;
		} else {
			if (yych <= '`') goto yy829;
			if (yych <= 'z') goto yy838;
			if (yych <= 0x7F) goto yy829;
		}
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(839, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(840, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy842;
			if (yych <= 'Z') goto yy844;
			if (yych >= '_') goto yy844;
		} else {
			if (yych <= '`') goto yy842;
			if (yych <= 'z') goto yy844;
			if (yych >= 0x80) goto yy844;
		}
yy842:
		YYDEBUG(842, *YYCURSOR);
		++YYCURSOR;
yy843:
		YYDEBUG(843, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy844:
		YYDEBUG(844, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy843;
				if (yych <= '9') goto yy846;
				goto yy843;
			} else {
				if (yych <= '[') goto yy846;
				if (yych <= '^') goto yy843;
				goto yy846;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy843;
				if (yych <= 'z') goto yy846;
				goto yy843;
			} else {
				if (yych <= '}') goto yy846;
				if (yych <= 0x7F) goto yy843;
				goto yy846;
			}
		}
yy845:
		YYDEBUG(845, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy846:
		YYDEBUG(846, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy845;
		}
		if (yych <= '@') goto yy847;
		if (yych <= '[') goto yy848;
		if (yych == '}') goto yy848;
yy847:
		YYDEBUG(847, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy843;
yy848:
		YYDEBUG(848, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(849, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			248, 248, 216, 216, 216, 216, 216, 216, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(850, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy852;
					if (yych <= '\n') goto yy854;
				} else {
					if (yych <= '\r') goto yy854;
					if (yych >= ' ') goto yy854;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy856;
					if (yych <= '#') goto yy854;
					goto yy858;
				} else {
					if (yych == '\'') goto yy854;
					if (yych <= '/') goto yy856;
					goto yy859;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy861;
					if (yych <= '@') goto yy856;
					goto yy863;
				} else {
					if (yych <= '[') goto yy856;
					if (yych <= '\\') goto yy854;
					goto yy866;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy863;
					goto yy856;
				} else {
					if (yych <= 'z') goto yy863;
					if (yych <= '~') goto yy856;
					if (yych >= 0x80) goto yy863;
				}
			}
		}
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(853, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy854:
		YYDEBUG(854, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(855, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy856:
		YYDEBUG(856, *YYCURSOR);
		++YYCURSOR;
yy857:
		YYDEBUG(857, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy858:
		YYDEBUG(858, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy857;
			if (yych <= 'Z') goto yy868;
			if (yych <= '^') goto yy857;
			goto yy868;
		} else {
			if (yych <= '`') goto yy857;
			if (yych <= 'z') goto yy868;
			if (yych <= 0x7F) goto yy857;
			goto yy868;
		}
yy859:
		YYDEBUG(859, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'B') {
				if (yych <= '/') goto yy860;
				if (yych <= '9') goto yy871;
				if (yych >= 'B') goto yy874;
			} else {
				if (yych == 'O') goto yy876;
				if (yych >= 'X') goto yy877;
			}
		} else {
			if (yych <= 'b') {
				if (yych == '_') goto yy878;
				if (yych >= 'b') goto yy874;
			} else {
				if (yych <= 'o') {
					if (yych >= 'o') goto yy876;
				} else {
					if (yych == 'x') goto yy877;
				}
			}
		}
yy860:
		YYDEBUG(860, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy861:
		YYDEBUG(861, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(862, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy861;
		}
		if (yych == '_') goto yy878;
		goto yy860;
yy863:
		YYDEBUG(863, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(864, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy863;
		}
		YYDEBUG(865, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy866:
		YYDEBUG(866, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(867, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy868:
		YYDEBUG(868, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(869, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy868;
			} else {
				if (yych <= '@') goto yy870;
				if (yych <= 'Z') goto yy868;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy868;
			} else {
				if (yych <= 'z') goto yy868;
				if (yych >= 0x80) goto yy868;
			}
		}
yy870:
		YYDEBUG(870, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy871:
		YYDEBUG(871, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(872, *YYCURSOR);
		if (yych <= '/') goto yy873;
		if (yych <= '9') goto yy871;
		if (yych == '_') goto yy878;
yy873:
		YYDEBUG(873, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy874:
		YYDEBUG(874, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy879;
		}
yy875:
		YYDEBUG(875, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy860;
		} else {
			goto yy873;
		}
yy876:
		YYDEBUG(876, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy881;
		}
		goto yy875;
yy877:
		YYDEBUG(877, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy883;
		}
		goto yy875;
yy878:
		YYDEBUG(878, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy875;
		if (yych <= '9') goto yy871;
		goto yy875;
yy879:
		YYDEBUG(879, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(880, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy879;
		}
		if (yych == '_') goto yy874;
		goto yy873;
yy881:
		YYDEBUG(881, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(882, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy881;
		}
		if (yych == '_') goto yy876;
		goto yy873;
yy883:
		YYDEBUG(883, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(884, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy883;
		}
		if (yych == '_') goto yy877;
		goto yy873;
	}
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(885, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy889;
		YYDEBUG(887, *YYCURSOR);
		++YYCURSOR;
yy888:
		YYDEBUG(888, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy889:
		YYDEBUG(889, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy888;
yy890:
		YYDEBUG(890, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(891, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy890;
		}
		YYDEBUG(892, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(893, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(894, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy898;
	YYDEBUG(896, *YYCURSOR);
	++YYCURSOR;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy897;
	YYDEBUG(899, *YYCURSOR);
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy901;
	} else {
		if (yych <= 'P') goto yy903;
		if (yych == 'p') goto yy903;
	}
yy900:
	YYDEBUG(900, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy901:
	YYDEBUG(901, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(902, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy905;
	if (yych == 'h') goto yy905;
yy904:
	YYDEBUG(904, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy900;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy906;
	if (yych != 'p') goto yy904;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy907;
		if (yych <= '\n') goto yy908;
	} else {
		if (yych <= '\r') goto yy910;
		if (yych == ' ') goto yy908;
	}
yy907:
	YYDEBUG(907, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy908:
	YYDEBUG(908, *YYCURSOR);
	++YYCURSOR;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy908;
	goto yy909;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(911, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(913, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(914, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(915, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(917, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(918, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident = SCNG(yy_text);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
