/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2004 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3 of the PHP license,         |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/3.txt.                                    |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors:    Marco Tabini <marcot@tabini.ca>                          |
  |             Ilia Alshanetsky <ilia@php.net>                          |
  +----------------------------------------------------------------------+

  $Id: php_pop3.h,v 1.9 2004/02/10 02:27:42 iliaa Exp $ 
*/

#ifndef PHP_POP3_H
#define PHP_POP3_H

extern zend_module_entry pop3_module_entry;
#define phpext_pop3_ptr &pop3_module_entry

#ifdef PHP_WIN32
#define PHP_POP3_API __declspec(dllexport)
#else
#define PHP_POP3_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

#ifdef ZEND_ENGINE_2

static void pop3_objects_dtor(void *object, zend_object_handle handle TSRMLS_DC);

PHP_POP3_API zend_object_value pop3_objects_new(zend_class_entry * TSRMLS_DC);

zend_class_entry *pop3_class_entry;

typedef struct _pop3_object {
        zend_object zo;
        int *ptr;
} pop3_object; /* extends zend_object */

#endif /* ZEND_ENGINE_2 */

PHP_MINIT_FUNCTION(pop3);
PHP_MSHUTDOWN_FUNCTION(pop3);
PHP_RINIT_FUNCTION(pop3);
PHP_RSHUTDOWN_FUNCTION(pop3);
PHP_MINFO_FUNCTION(pop3);

PHP_FUNCTION(pop3_open);
PHP_FUNCTION(pop3_close);
PHP_FUNCTION(pop3_get_message_count);
PHP_FUNCTION(pop3_get_account_size);
PHP_FUNCTION(pop3_get_message_list);
PHP_FUNCTION(pop3_get_message_ids);
PHP_FUNCTION(pop3_get_message_sizes);
PHP_FUNCTION(pop3_get_message_header);
PHP_FUNCTION(pop3_get_message_size);
PHP_FUNCTION(pop3_get_message);
PHP_FUNCTION(pop3_delete_message);
PHP_FUNCTION(pop3_undelete);

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     

ZEND_BEGIN_MODULE_GLOBALS(pop3)
ZEND_END_MODULE_GLOBALS(pop3)
*/

/* In every utility function you add that needs to use variables 
   in php_pop3_globals, call TSRM_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as POP3_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define POP3_G(v) TSRMG(pop3_globals_id, zend_pop3_globals *, v)
#else
#define POP3_G(v) (pop3_globals.v)
#endif

#endif	/* PHP_POP3_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */
