/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 42 "parser.php5.lemon"

#include "parser.php5.inc.h"

#line 12 "parser.php5.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    phvolt_TOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is phvolt_TOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    phvolt_ARG_SDECL     A static variable declaration for the %extra_argument
**    phvolt_ARG_PDECL     A parameter declaration for the %extra_argument
**    phvolt_ARG_STORE     Code to store %extra_argument into yypParser
**    phvolt_ARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 131
#define YYACTIONTYPE unsigned short int
#define phvolt_TOKENTYPE phvolt_parser_token*
typedef union {
  phvolt_TOKENTYPE yy0;
  zval* yy228;
  int yy261;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define phvolt_ARG_SDECL phvolt_parser_status *status;
#define phvolt_ARG_PDECL ,phvolt_parser_status *status
#define phvolt_ARG_FETCH phvolt_parser_status *status = yypParser->status
#define phvolt_ARG_STORE yypParser->status = status
#define YYNSTATE 365
#define YYNRULE 158
#define YYERRORSYMBOL 89
#define YYERRSYMDT yy261
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */    85,   95,  292,   63,   55,   57,   69,   65,   67,   75,
 /*    10 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*    20 */    59,   92,   61,   87,   90,   91,   99,   83,  504,  245,
 /*    30 */    87,   90,   91,   99,   83,  300,   51,   49,   53,   46,
 /*    40 */    43,   59,   92,   61,   87,   90,   91,   99,   83,  276,
 /*    50 */   287,  299,  194,  215,  198,   85,   95,  196,   63,   55,
 /*    60 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*    70 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*    80 */    91,   99,   83,  144,  265,   85,   95,  195,   63,   55,
 /*    90 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*   100 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*   110 */    91,   99,   83,  331,  176,   92,   61,   87,   90,   91,
 /*   120 */    99,   83,  309,  327,  266,  197,  198,  281,   85,   95,
 /*   130 */   294,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   140 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   150 */    61,   87,   90,   91,   99,   83,  347,  342,   85,   95,
 /*   160 */   111,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   170 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   180 */    61,   87,   90,   91,   99,   83,  504,  274,   85,   95,
 /*   190 */   213,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   200 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   210 */    61,   87,   90,   91,   99,   83,  277,  271,   85,   95,
 /*   220 */   503,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   230 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   240 */    61,   87,   90,   91,   99,   83,  115,   42,   85,   95,
 /*   250 */   298,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   260 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   270 */    61,   87,   90,   91,   99,   83,  437,  268,   85,   95,
 /*   280 */    97,   63,   55,   57,   69,   65,   67,   75,   77,   79,
 /*   290 */    81,   71,   73,   51,   49,   53,   46,   43,   59,   92,
 /*   300 */    61,   87,   90,   91,   99,   83,   85,   95,  131,   63,
 /*   310 */    55,   57,   69,   65,   67,   75,   77,   79,   81,   71,
 /*   320 */    73,   51,   49,   53,   46,   43,   59,   92,   61,   87,
 /*   330 */    90,   91,   99,   83,   46,   43,   59,   92,   61,   87,
 /*   340 */    90,   91,   99,   83,  321,  322,  323,  324,  325,  326,
 /*   350 */   338,  174,  438,  139,  140,  105,  303,  305,  229,   85,
 /*   360 */    95,  306,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   370 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   380 */    92,   61,   87,   90,   91,   99,   83,  307,  190,   85,
 /*   390 */    95,  308,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   400 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   410 */    92,   61,   87,   90,   91,   99,   83,   88,  349,   85,
 /*   420 */    95,   37,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   430 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   440 */    92,   61,   87,   90,   91,   99,   83,  192,   29,   85,
 /*   450 */    95,  311,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   460 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   470 */    92,   61,   87,   90,   91,   99,   83,  107,  131,  107,
 /*   480 */   100,  359,  252,  332,  134,  100,  114,  129,  116,  120,
 /*   490 */   128,  120,  120,  137,  315,  120,   94,  120,  132,  259,
 /*   500 */    85,   95,  258,   63,   55,   57,   69,   65,   67,   75,
 /*   510 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*   520 */    59,   92,   61,   87,   90,   91,   99,   83,  130,  262,
 /*   530 */    85,   95,  257,   63,   55,   57,   69,   65,   67,   75,
 /*   540 */    77,   79,   81,   71,   73,   51,   49,   53,   46,   43,
 /*   550 */    59,   92,   61,   87,   90,   91,   99,   83,  100,  318,
 /*   560 */   317,  168,  256,  107,  142,  228,   82,  270,  319,  318,
 /*   570 */   120,  137,  109,  120,  116,  120,  145,  211,  120,  120,
 /*   580 */   141,   85,   95,  219,   63,   55,   57,   69,   65,   67,
 /*   590 */    75,   77,   79,   81,   71,   73,   51,   49,   53,   46,
 /*   600 */    43,   59,   92,   61,   87,   90,   91,   99,   83,   85,
 /*   610 */    95,  320,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   620 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   630 */    92,   61,   87,   90,   91,   99,   83,  251,  183,   85,
 /*   640 */    95,  254,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   650 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   660 */    92,   61,   87,   90,   91,   99,   83,  249,  333,   85,
 /*   670 */    95,  293,   63,   55,   57,   69,   65,   67,   75,   77,
 /*   680 */    79,   81,   71,   73,   51,   49,   53,   46,   43,   59,
 /*   690 */    92,   61,   87,   90,   91,   99,   83,   85,   95,  242,
 /*   700 */    63,   55,   57,   69,   65,   67,   75,   77,   79,   81,
 /*   710 */    71,   73,   51,   49,   53,   46,   43,   59,   92,   61,
 /*   720 */    87,   90,   91,  227,   83,   95,  237,   63,   55,   57,
 /*   730 */    69,   65,   67,   75,   77,   79,   81,   71,   73,   51,
 /*   740 */    49,   53,   46,   43,   59,   92,   61,   87,   90,   91,
 /*   750 */    99,   83,  524,    1,    2,  286,    4,    5,    6,    7,
 /*   760 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   770 */    18,   19,   20,   21,   22,   23,   24,   25,   63,   55,
 /*   780 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*   790 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*   800 */    91,   99,   83,  278,  286,    4,    5,    6,    7,    8,
 /*   810 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   820 */    19,   20,   21,   22,   23,   24,   25,  184,  286,    4,
 /*   830 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   840 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   850 */    25,  295,  286,    4,    5,    6,    7,    8,    9,   10,
 /*   860 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*   870 */    21,   22,   23,   24,   25,  343,  286,    4,    5,    6,
 /*   880 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   890 */    17,   18,   19,   20,   21,   22,   23,   24,   25,  350,
 /*   900 */   286,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*   910 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   920 */    23,   24,   25,  221,  286,    4,    5,    6,    7,    8,
 /*   930 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   940 */    19,   20,   21,   22,   23,   24,   25,  231,  286,    4,
 /*   950 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   960 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   970 */    25,   36,  286,    4,    5,    6,    7,    8,    9,   10,
 /*   980 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*   990 */    21,   22,   23,   24,   25,  334,  286,    4,    5,    6,
 /*  1000 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*  1010 */    17,   18,   19,   20,   21,   22,   23,   24,   25,   55,
 /*  1020 */    57,   69,   65,   67,   75,   77,   79,   81,   71,   73,
 /*  1030 */    51,   49,   53,   46,   43,   59,   92,   61,   87,   90,
 /*  1040 */    91,   99,   83,  312,  286,    4,    5,    6,    7,    8,
 /*  1050 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1060 */    19,   20,   21,   22,   23,   24,   25,  246,  286,    4,
 /*  1070 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1080 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*  1090 */    25,  289,  286,    4,    5,    6,    7,    8,    9,   10,
 /*  1100 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*  1110 */    21,   22,   23,   24,   25,   30,  286,    4,    5,    6,
 /*  1120 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*  1130 */    17,   18,   19,   20,   21,   22,   23,   24,   25,  177,
 /*  1140 */   286,    4,    5,    6,    7,    8,    9,   10,   11,   12,
 /*  1150 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  1160 */    23,   24,   25,  239,  286,    4,    5,    6,    7,    8,
 /*  1170 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1180 */    19,   20,   21,   22,   23,   24,   25,    3,    4,    5,
 /*  1190 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*  1200 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*  1210 */    27,  235,   32,   34,   40,  170,  172,   93,  171,  181,
 /*  1220 */    68,  188,  191,  193,  119,  226,  175,  143,  142,  120,
 /*  1230 */   216,  238,  120,  330,   72,  173,  120,  120,  120,  225,
 /*  1240 */   366,   26,   35,  236,  141,  243,  120,  250,  316,  260,
 /*  1250 */   263,  234,  269,  272,  275,  230,  282,  284,  255,    4,
 /*  1260 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*  1270 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*  1280 */    25,   27,  235,  358,  360,   40,  170,  172,  273,  365,
 /*  1290 */   181,  169,  188,  191,  193,  361,   86,   50,  310,   56,
 /*  1300 */   120,  216,  252,  120,  111,   45,  337,  339,  120,  120,
 /*  1310 */   225,  120,  118,  224,  236,  187,  243,  120,  250,  259,
 /*  1320 */   260,  263,  340,  269,  272,  275,   26,  282,  284,  220,
 /*  1330 */    69,   65,   67,   75,   77,   79,   81,   71,   73,   51,
 /*  1340 */    49,   53,   46,   43,   59,   92,   61,   87,   90,   91,
 /*  1350 */    99,   83,  110,   27,  235,   38,  363,   40,  170,  172,
 /*  1360 */   341,  222,  181,  232,  188,  191,  193,  189,  362,   48,
 /*  1370 */   218,  267,  120,  216,  217,  346,  180,  214,  364,  120,
 /*  1380 */   353,  120,  225,  120,   33,  147,  236,  252,  243,  301,
 /*  1390 */   250,  253,  260,  263,  240,  269,  272,  275,  354,  282,
 /*  1400 */   284,  285,  288,  120,  259,   27,  235,  209,  503,   40,
 /*  1410 */   170,  172,  356,  212,  181,  186,  188,  191,  193,  146,
 /*  1420 */   247,  204,  252,  283,  252,  216,   39,  290,  199,  201,
 /*  1430 */   203,  205,  207,  120,  225,  290,  290,  290,  236,  259,
 /*  1440 */   243,  259,  250,  290,  260,  263,  279,  269,  272,  275,
 /*  1450 */   252,  282,  284,  290,  290,  252,  290,   27,  235,  252,
 /*  1460 */   290,   40,  170,  172,  290,  352,  181,  259,  188,  191,
 /*  1470 */   193,  165,  259,  290,  290,   54,  259,  216,  290,   98,
 /*  1480 */   290,  252,  290,  120,  290,  290,  225,  120,  290,  290,
 /*  1490 */   236,  120,  243,  290,  250,  290,  260,  263,  259,  269,
 /*  1500 */   272,  275,  290,  282,  284,  290,  290,  252,  290,   27,
 /*  1510 */   235,   66,  290,   40,  170,  172,   70,  296,  181,  290,
 /*  1520 */   188,  191,  193,  120,  259,  290,  290,  348,  120,  216,
 /*  1530 */   290,   28,  290,  210,  290,  290,  290,  290,  225,  120,
 /*  1540 */   290,  290,  236,  120,  243,  120,  250,  104,  260,  263,
 /*  1550 */   357,  269,  272,  275,  291,  282,  284,  290,  290,  120,
 /*  1560 */   290,   27,  235,  252,  290,   40,  170,  172,  290,   31,
 /*  1570 */   181,  313,  188,  191,  193,  208,  335,  290,  252,  167,
 /*  1580 */   259,  216,  290,  290,  290,  290,  290,  120,  290,  290,
 /*  1590 */   225,  120,  290,  290,  236,  259,  243,  248,  250,  290,
 /*  1600 */   260,  263,  178,  269,  272,  275,  290,  282,  284,  290,
 /*  1610 */   290,  252,  290,   27,  235,   52,  290,   40,  170,  172,
 /*  1620 */   290,  344,  181,  351,  188,  191,  193,  120,  259,  290,
 /*  1630 */   252,  206,  252,  216,  290,  290,  290,  252,  290,  202,
 /*  1640 */   290,  290,  225,  120,  290,  290,  236,  259,  243,  259,
 /*  1650 */   250,  120,  260,  263,  259,  269,  272,  275,  280,  282,
 /*  1660 */   284,  290,  290,  252,  290,   27,  235,  355,  290,   40,
 /*  1670 */   170,  172,  290,  328,  181,  185,  188,  191,  193,  182,
 /*  1680 */   259,  290,  252,   64,  252,  216,  290,  290,  290,  290,
 /*  1690 */   290,  120,  290,  290,  225,  120,  290,  290,  236,  259,
 /*  1700 */   243,  259,  250,  290,  260,  263,  290,  269,  272,  275,
 /*  1710 */   290,  282,  284,  290,  290,  200,  290,   27,  235,   80,
 /*  1720 */    76,   40,  170,  172,  290,  179,  181,  120,  188,  191,
 /*  1730 */   193,  120,  120,  290,  252,  244,  252,  216,  290,  290,
 /*  1740 */   290,  290,  290,   62,  290,  290,  225,  120,  290,  290,
 /*  1750 */   236,  259,  243,  259,  250,  120,  260,  263,  290,  269,
 /*  1760 */   272,  275,  290,  282,  284,  264,  290,   84,  290,   27,
 /*  1770 */   235,  135,   60,   40,  170,  172,   78,  120,  181,  120,
 /*  1780 */   188,  191,  193,  120,  120,  290,  290,   96,  120,  216,
 /*  1790 */   290,  290,  290,  261,  290,   41,  290,  290,  225,  120,
 /*  1800 */   290,  290,  236,  302,  243,  120,  250,  120,  260,  263,
 /*  1810 */   290,  269,  272,  275,  290,  282,  284,   89,  290,  102,
 /*  1820 */   290,   27,  235,  290,   74,   40,  170,  172,   58,  120,
 /*  1830 */   181,  120,  188,  191,  193,  290,  120,  290,  290,  290,
 /*  1840 */   120,  216,  290,  314,  290,  290,  290,  290,  290,  290,
 /*  1850 */   225,  290,  290,  290,  236,  290,  243,  290,  250,  290,
 /*  1860 */   260,  263,  290,  269,  272,  275,  290,  282,  284,  290,
 /*  1870 */   290,  290,  290,   27,  235,  290,  290,   40,  170,  172,
 /*  1880 */   290,  290,  181,  290,  188,  191,  193,  290,  290,  290,
 /*  1890 */   290,  290,  290,  216,  290,  290,  290,  290,  290,  290,
 /*  1900 */   290,  290,  225,  233,  290,  290,  236,  290,  243,  290,
 /*  1910 */   250,  290,  260,  263,  290,  269,  272,  275,  290,  282,
 /*  1920 */   284,  290,  290,  290,  290,   27,  235,  290,  290,   40,
 /*  1930 */   170,  172,  290,  290,  181,  290,  188,  191,  193,  290,
 /*  1940 */   290,  290,  290,  290,  290,  216,  290,  290,  290,  290,
 /*  1950 */   290,  290,  290,  290,  225,  290,  290,  290,  236,  290,
 /*  1960 */   243,  297,  250,  290,  260,  263,  290,  269,  272,  275,
 /*  1970 */   290,  282,  284,  290,  290,  290,  290,   27,  235,  290,
 /*  1980 */   290,   40,  170,  172,  290,  290,  181,  290,  188,  191,
 /*  1990 */   193,  290,  290,  290,  290,  290,  290,  216,  290,  290,
 /*  2000 */   290,  290,  290,  290,  290,  290,  225,  290,  290,  290,
 /*  2010 */   236,  241,  243,  290,  250,  290,  260,  263,  290,  269,
 /*  2020 */   272,  275,  290,  282,  284,  290,  290,  290,  290,   27,
 /*  2030 */   235,  290,  290,   40,  170,  172,  290,  290,  181,  290,
 /*  2040 */   188,  191,  193,  290,  290,  290,  290,  290,  290,  216,
 /*  2050 */   290,  223,  290,  290,  290,  290,  290,  290,  225,  290,
 /*  2060 */   290,  290,  236,  290,  243,  290,  250,  290,  260,  263,
 /*  2070 */   290,  269,  272,  275,  290,  282,  284,  290,  290,  290,
 /*  2080 */   290,   27,  235,  290,  290,   40,  170,  172,  290,  290,
 /*  2090 */   181,  329,  188,  191,  193,  290,  290,  290,  290,  290,
 /*  2100 */   290,  216,  290,  290,  290,  290,  290,  290,  290,  290,
 /*  2110 */   225,  290,  290,  290,  236,  290,  243,  290,  250,  290,
 /*  2120 */   260,  263,  290,  269,  272,  275,  290,  282,  284,  290,
 /*  2130 */   290,  290,  290,   27,  235,  290,  290,   40,  170,  172,
 /*  2140 */   290,  345,  181,  290,  188,  191,  193,  290,  290,  290,
 /*  2150 */   290,  290,  290,  216,  290,  290,  290,  290,  290,  290,
 /*  2160 */   290,  290,  225,  290,  290,  290,  236,  290,  243,  290,
 /*  2170 */   250,  290,  260,  263,  290,  269,  272,  275,  290,  282,
 /*  2180 */   284,  290,  290,  290,  290,   27,  235,  290,  290,   40,
 /*  2190 */   170,  172,  290,  336,  181,  290,  188,  191,  193,  290,
 /*  2200 */   290,  290,  290,  290,  290,  216,  290,  290,  290,  290,
 /*  2210 */   290,  290,  290,  290,  225,  290,  290,  290,  236,  290,
 /*  2220 */   243,  290,  250,  290,  260,  263,  290,  269,  272,  275,
 /*  2230 */   290,  282,  284,  290,  290,  290,  290,   27,  235,  290,
 /*  2240 */   290,   40,  170,  172,  290,  290,  181,  290,  188,  191,
 /*  2250 */   193,  290,  290,  290,  290,  290,  290,  216,  290,  290,
 /*  2260 */   290,  290,  290,  290,  290,  290,  225,  290,  290,  290,
 /*  2270 */   236,  290,  243,  290,  250,  290,  260,  263,  290,  269,
 /*  2280 */   272,  275,  290,  282,  284,  290,  290,  290,   47,   44,
 /*  2290 */   290,  106,  290,  101,  290,  290,  103,  290,   47,   44,
 /*  2300 */   290,  106,  290,  101,  290,  121,  103,  290,  290,  290,
 /*  2310 */   290,  290,  290,  290,  290,  121,  290,  290,  290,  290,
 /*  2320 */   290,  122,  123,  124,  125,  126,  127,  290,  290,  290,
 /*  2330 */   290,  122,  123,  124,  125,  126,  127,  290,  290,  290,
 /*  2340 */   290,  290,  290,  290,  290,  290,  290,  150,  151,  152,
 /*  2350 */   153,  154,  155,  156,  112,  290,  290,  157,  158,  159,
 /*  2360 */   160,  161,  162,  163,  112,  290,  138,  290,  290,   47,
 /*  2370 */    44,  290,  106,  290,  101,  290,  290,  103,  290,  290,
 /*  2380 */   290,  290,   47,   44,  290,  106,  121,  101,  290,  290,
 /*  2390 */   103,  290,   47,   44,  290,  106,  290,  101,  290,  149,
 /*  2400 */   103,  290,  122,  117,  124,  125,  126,  127,  290,  121,
 /*  2410 */   290,  290,  290,  290,  290,  148,  123,  124,  125,  126,
 /*  2420 */   127,  290,  290,  304,  290,  122,  133,  124,  125,  126,
 /*  2430 */   127,  290,  290,  290,  290,  112,  113,  166,  290,   47,
 /*  2440 */    44,  290,  106,  290,  101,  290,  290,  103,  112,   47,
 /*  2450 */    44,  290,  106,  290,  101,  290,  121,  103,  112,  164,
 /*  2460 */   290,  290,   47,   44,  290,  106,  121,  101,  290,  290,
 /*  2470 */   103,  290,  122,  123,  124,  125,  126,  127,  108,  121,
 /*  2480 */   290,  290,  122,  117,  124,  125,  126,  127,  290,  290,
 /*  2490 */   290,  290,  290,  290,  290,  122,  123,  124,  125,  126,
 /*  2500 */   127,   47,   44,  290,  106,  112,  101,  290,  290,  103,
 /*  2510 */   290,  290,  290,  290,  290,  112,  290,  290,  121,  290,
 /*  2520 */   290,  290,  290,  290,  290,  290,  290,  290,  112,  290,
 /*  2530 */   290,  290,  136,  290,  122,  133,  124,  125,  126,  127,
 /*  2540 */    47,   44,  290,  106,  290,  101,  290,  290,  103,  290,
 /*  2550 */   290,  290,  290,  290,  290,  290,  290,  121,  290,  290,
 /*  2560 */   290,  290,  290,   47,   44,  290,  106,  112,  101,  290,
 /*  2570 */   290,  103,  290,  122,  123,  124,  125,  126,  127,  290,
 /*  2580 */   121,  290,  290,  290,  290,   47,   44,  290,  106,  290,
 /*  2590 */   101,  290,  290,  103,  290,  290,  122,  117,  124,  125,
 /*  2600 */   126,  127,  121,  290,  290,  290,  112,  290,  290,  290,
 /*  2610 */   290,  290,  290,  290,  290,  290,  290,  290,  122,  133,
 /*  2620 */   124,  125,  126,  127,  290,  290,  290,  290,  290,  112,
 /*  2630 */   290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
 /*  2640 */   290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
 /*  2650 */   290,  112,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */     3,    4,   32,    6,    7,    8,    9,   10,   11,   12,
 /*    10 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*    20 */    23,   24,   25,   26,   27,   28,   29,   30,    5,   32,
 /*    30 */    26,   27,   28,   29,   30,   38,   18,   19,   20,   21,
 /*    40 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   58,
 /*    50 */    59,   54,  117,  118,  119,    3,    4,    2,    6,    7,
 /*    60 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*    70 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*    80 */    28,   29,   30,    5,   32,    3,    4,   32,    6,    7,
 /*    90 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   100 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   110 */    28,   29,   30,   31,   32,   24,   25,   26,   27,   28,
 /*   120 */    29,   30,  120,  121,   72,  118,  119,   32,    3,    4,
 /*   130 */    32,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   140 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   150 */    25,   26,   27,   28,   29,   30,   31,   32,    3,    4,
 /*   160 */     2,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   170 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   180 */    25,   26,   27,   28,   29,   30,   50,   32,    3,    4,
 /*   190 */    38,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   200 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   210 */    25,   26,   27,   28,   29,   30,   32,   32,    3,    4,
 /*   220 */    50,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   230 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   240 */    25,   26,   27,   28,   29,   30,   88,   32,    3,    4,
 /*   250 */    32,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   260 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   270 */    25,   26,   27,   28,   29,   30,   32,   32,    3,    4,
 /*   280 */     5,    6,    7,    8,    9,   10,   11,   12,   13,   14,
 /*   290 */    15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
 /*   300 */    25,   26,   27,   28,   29,   30,    3,    4,    2,    6,
 /*   310 */     7,    8,    9,   10,   11,   12,   13,   14,   15,   16,
 /*   320 */    17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
 /*   330 */    27,   28,   29,   30,   21,   22,   23,   24,   25,   26,
 /*   340 */    27,   28,   29,   30,   54,   55,   56,   57,   58,   59,
 /*   350 */     2,    3,   32,  126,   50,   52,   32,   32,   52,    3,
 /*   360 */     4,    1,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   370 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   380 */    24,   25,   26,   27,   28,   29,   30,   61,   32,    3,
 /*   390 */     4,   32,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   400 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   410 */    24,   25,   26,   27,   28,   29,   30,    3,   32,    3,
 /*   420 */     4,    1,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   430 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   440 */    24,   25,   26,   27,   28,   29,   30,   32,   32,    3,
 /*   450 */     4,   32,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   460 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   470 */    24,   25,   26,   27,   28,   29,   30,  116,    2,  116,
 /*   480 */   116,   32,   62,  116,    5,  116,  125,  123,  127,  128,
 /*   490 */   127,  128,  128,  129,   32,  128,   50,  128,  129,   79,
 /*   500 */     3,    4,   32,    6,    7,    8,    9,   10,   11,   12,
 /*   510 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   520 */    23,   24,   25,   26,   27,   28,   29,   30,   52,   32,
 /*   530 */     3,    4,   69,    6,    7,    8,    9,   10,   11,   12,
 /*   540 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*   550 */    23,   24,   25,   26,   27,   28,   29,   30,  116,   38,
 /*   560 */   121,  116,    1,  116,   38,  123,  116,  116,   45,   38,
 /*   570 */   128,  129,  125,  128,  127,  128,   50,   50,  128,  128,
 /*   580 */    54,    3,    4,   52,    6,    7,    8,    9,   10,   11,
 /*   590 */    12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
 /*   600 */    22,   23,   24,   25,   26,   27,   28,   29,   30,    3,
 /*   610 */     4,  122,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   620 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   630 */    24,   25,   26,   27,   28,   29,   30,   32,   32,    3,
 /*   640 */     4,   63,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   650 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   660 */    24,   25,   26,   27,   28,   29,   30,   32,   32,    3,
 /*   670 */     4,  124,    6,    7,    8,    9,   10,   11,   12,   13,
 /*   680 */    14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
 /*   690 */    24,   25,   26,   27,   28,   29,   30,    3,    4,   32,
 /*   700 */     6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
 /*   710 */    16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
 /*   720 */    26,   27,   28,   29,   30,    4,   38,    6,    7,    8,
 /*   730 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*   740 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*   750 */    29,   30,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   760 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*   770 */   108,  109,  110,  111,  112,  113,  114,  115,    6,    7,
 /*   780 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*   790 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*   800 */    28,   29,   30,   92,   93,   94,   95,   96,   97,   98,
 /*   810 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   820 */   109,  110,  111,  112,  113,  114,  115,   92,   93,   94,
 /*   830 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   840 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*   850 */   115,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   860 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   870 */   111,  112,  113,  114,  115,   92,   93,   94,   95,   96,
 /*   880 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   890 */   107,  108,  109,  110,  111,  112,  113,  114,  115,   92,
 /*   900 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   910 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*   920 */   113,  114,  115,   92,   93,   94,   95,   96,   97,   98,
 /*   930 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   940 */   109,  110,  111,  112,  113,  114,  115,   92,   93,   94,
 /*   950 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   960 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*   970 */   115,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   980 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
 /*   990 */   111,  112,  113,  114,  115,   92,   93,   94,   95,   96,
 /*  1000 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1010 */   107,  108,  109,  110,  111,  112,  113,  114,  115,    7,
 /*  1020 */     8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
 /*  1030 */    18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
 /*  1040 */    28,   29,   30,   92,   93,   94,   95,   96,   97,   98,
 /*  1050 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  1060 */   109,  110,  111,  112,  113,  114,  115,   92,   93,   94,
 /*  1070 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1080 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  1090 */   115,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1100 */   101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
 /*  1110 */   111,  112,  113,  114,  115,   92,   93,   94,   95,   96,
 /*  1120 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1130 */   107,  108,  109,  110,  111,  112,  113,  114,  115,   92,
 /*  1140 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1150 */   103,  104,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1160 */   113,  114,  115,   92,   93,   94,   95,   96,   97,   98,
 /*  1170 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*  1180 */   109,  110,  111,  112,  113,  114,  115,   93,   94,   95,
 /*  1190 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1200 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  1210 */    31,   32,   33,   34,   35,   36,   37,  116,   32,   40,
 /*  1220 */   116,   42,   43,   44,  116,  116,  116,  126,   38,  128,
 /*  1230 */    51,   32,  128,   32,  116,   38,  128,  128,  128,   60,
 /*  1240 */     0,    1,   32,   64,   54,   66,  128,   68,    2,   70,
 /*  1250 */    71,   32,   73,   74,   75,   32,   77,   78,   93,   94,
 /*  1260 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1270 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  1280 */   115,   31,   32,   33,   34,   35,   36,   37,  116,    0,
 /*  1290 */    40,  116,   42,   43,   44,   32,  116,  116,   52,  116,
 /*  1300 */   128,   51,   62,  128,    2,  116,   32,   38,  128,  128,
 /*  1310 */    60,  128,    5,   32,   64,   32,   66,  128,   68,   79,
 /*  1320 */    70,   71,    3,   73,   74,   75,    1,   77,   78,   32,
 /*  1330 */     9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1340 */    19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
 /*  1350 */    29,   30,   50,   31,   32,   33,   33,   35,   36,   37,
 /*  1360 */   116,    1,   40,    1,   42,   43,   44,  116,    1,  116,
 /*  1370 */    29,  116,  128,   51,   38,   32,   32,  119,   32,  128,
 /*  1380 */    32,  128,   60,  128,   32,   50,   64,   62,   66,    1,
 /*  1390 */    68,  116,   70,   71,    1,   73,   74,   75,    1,   77,
 /*  1400 */    78,   32,   32,  128,   79,   31,   32,   24,    5,   35,
 /*  1410 */    36,   37,   32,   30,   40,   41,   42,   43,   44,  126,
 /*  1420 */     1,  116,   62,   32,   62,   51,   32,  130,   45,   46,
 /*  1430 */    47,   48,   49,  128,   60,  130,  130,  130,   64,   79,
 /*  1440 */    66,   79,   68,  130,   70,   71,    1,   73,   74,   75,
 /*  1450 */    62,   77,   78,  130,  130,   62,  130,   31,   32,   62,
 /*  1460 */   130,   35,   36,   37,  130,   39,   40,   79,   42,   43,
 /*  1470 */    44,  116,   79,  130,  130,  116,   79,   51,  130,  116,
 /*  1480 */   130,   62,  130,  128,  130,  130,   60,  128,  130,  130,
 /*  1490 */    64,  128,   66,  130,   68,  130,   70,   71,   79,   73,
 /*  1500 */    74,   75,    1,   77,   78,  130,  130,   62,  130,   31,
 /*  1510 */    32,  116,  130,   35,   36,   37,  116,    1,   40,  130,
 /*  1520 */    42,   43,   44,  128,   79,  130,  130,  116,  128,   51,
 /*  1530 */   130,  116,  130,  116,  130,  130,  130,  130,   60,  128,
 /*  1540 */   130,  130,   64,  128,   66,  128,   68,  116,   70,   71,
 /*  1550 */     1,   73,   74,   75,   76,   77,   78,  130,  130,  128,
 /*  1560 */   130,   31,   32,   62,  130,   35,   36,   37,  130,    1,
 /*  1570 */    40,    1,   42,   43,   44,  116,    1,  130,   62,  116,
 /*  1580 */    79,   51,  130,  130,  130,  130,  130,  128,  130,  130,
 /*  1590 */    60,  128,  130,  130,   64,   79,   66,   67,   68,  130,
 /*  1600 */    70,   71,    1,   73,   74,   75,  130,   77,   78,  130,
 /*  1610 */   130,   62,  130,   31,   32,  116,  130,   35,   36,   37,
 /*  1620 */   130,    1,   40,    1,   42,   43,   44,  128,   79,  130,
 /*  1630 */    62,  116,   62,   51,  130,  130,  130,   62,  130,  116,
 /*  1640 */   130,  130,   60,  128,  130,  130,   64,   79,   66,   79,
 /*  1650 */    68,  128,   70,   71,   79,   73,   74,   75,   76,   77,
 /*  1660 */    78,  130,  130,   62,  130,   31,   32,   33,  130,   35,
 /*  1670 */    36,   37,  130,    1,   40,    1,   42,   43,   44,  116,
 /*  1680 */    79,  130,   62,  116,   62,   51,  130,  130,  130,  130,
 /*  1690 */   130,  128,  130,  130,   60,  128,  130,  130,   64,   79,
 /*  1700 */    66,   79,   68,  130,   70,   71,  130,   73,   74,   75,
 /*  1710 */   130,   77,   78,  130,  130,  116,  130,   31,   32,  116,
 /*  1720 */   116,   35,   36,   37,  130,   39,   40,  128,   42,   43,
 /*  1730 */    44,  128,  128,  130,   62,  116,   62,   51,  130,  130,
 /*  1740 */   130,  130,  130,  116,  130,  130,   60,  128,  130,  130,
 /*  1750 */    64,   79,   66,   79,   68,  128,   70,   71,  130,   73,
 /*  1760 */    74,   75,  130,   77,   78,  116,  130,  116,  130,   31,
 /*  1770 */    32,  116,  116,   35,   36,   37,  116,  128,   40,  128,
 /*  1780 */    42,   43,   44,  128,  128,  130,  130,  116,  128,   51,
 /*  1790 */   130,  130,  130,  116,  130,  116,  130,  130,   60,  128,
 /*  1800 */   130,  130,   64,   65,   66,  128,   68,  128,   70,   71,
 /*  1810 */   130,   73,   74,   75,  130,   77,   78,  116,  130,  116,
 /*  1820 */   130,   31,   32,  130,  116,   35,   36,   37,  116,  128,
 /*  1830 */    40,  128,   42,   43,   44,  130,  128,  130,  130,  130,
 /*  1840 */   128,   51,  130,   53,  130,  130,  130,  130,  130,  130,
 /*  1850 */    60,  130,  130,  130,   64,  130,   66,  130,   68,  130,
 /*  1860 */    70,   71,  130,   73,   74,   75,  130,   77,   78,  130,
 /*  1870 */   130,  130,  130,   31,   32,  130,  130,   35,   36,   37,
 /*  1880 */   130,  130,   40,  130,   42,   43,   44,  130,  130,  130,
 /*  1890 */   130,  130,  130,   51,  130,  130,  130,  130,  130,  130,
 /*  1900 */   130,  130,   60,   61,  130,  130,   64,  130,   66,  130,
 /*  1910 */    68,  130,   70,   71,  130,   73,   74,   75,  130,   77,
 /*  1920 */    78,  130,  130,  130,  130,   31,   32,  130,  130,   35,
 /*  1930 */    36,   37,  130,  130,   40,  130,   42,   43,   44,  130,
 /*  1940 */   130,  130,  130,  130,  130,   51,  130,  130,  130,  130,
 /*  1950 */   130,  130,  130,  130,   60,  130,  130,  130,   64,  130,
 /*  1960 */    66,   67,   68,  130,   70,   71,  130,   73,   74,   75,
 /*  1970 */   130,   77,   78,  130,  130,  130,  130,   31,   32,  130,
 /*  1980 */   130,   35,   36,   37,  130,  130,   40,  130,   42,   43,
 /*  1990 */    44,  130,  130,  130,  130,  130,  130,   51,  130,  130,
 /*  2000 */   130,  130,  130,  130,  130,  130,   60,  130,  130,  130,
 /*  2010 */    64,   65,   66,  130,   68,  130,   70,   71,  130,   73,
 /*  2020 */    74,   75,  130,   77,   78,  130,  130,  130,  130,   31,
 /*  2030 */    32,  130,  130,   35,   36,   37,  130,  130,   40,  130,
 /*  2040 */    42,   43,   44,  130,  130,  130,  130,  130,  130,   51,
 /*  2050 */   130,   53,  130,  130,  130,  130,  130,  130,   60,  130,
 /*  2060 */   130,  130,   64,  130,   66,  130,   68,  130,   70,   71,
 /*  2070 */   130,   73,   74,   75,  130,   77,   78,  130,  130,  130,
 /*  2080 */   130,   31,   32,  130,  130,   35,   36,   37,  130,  130,
 /*  2090 */    40,   41,   42,   43,   44,  130,  130,  130,  130,  130,
 /*  2100 */   130,   51,  130,  130,  130,  130,  130,  130,  130,  130,
 /*  2110 */    60,  130,  130,  130,   64,  130,   66,  130,   68,  130,
 /*  2120 */    70,   71,  130,   73,   74,   75,  130,   77,   78,  130,
 /*  2130 */   130,  130,  130,   31,   32,  130,  130,   35,   36,   37,
 /*  2140 */   130,   39,   40,  130,   42,   43,   44,  130,  130,  130,
 /*  2150 */   130,  130,  130,   51,  130,  130,  130,  130,  130,  130,
 /*  2160 */   130,  130,   60,  130,  130,  130,   64,  130,   66,  130,
 /*  2170 */    68,  130,   70,   71,  130,   73,   74,   75,  130,   77,
 /*  2180 */    78,  130,  130,  130,  130,   31,   32,  130,  130,   35,
 /*  2190 */    36,   37,  130,   39,   40,  130,   42,   43,   44,  130,
 /*  2200 */   130,  130,  130,  130,  130,   51,  130,  130,  130,  130,
 /*  2210 */   130,  130,  130,  130,   60,  130,  130,  130,   64,  130,
 /*  2220 */    66,  130,   68,  130,   70,   71,  130,   73,   74,   75,
 /*  2230 */   130,   77,   78,  130,  130,  130,  130,   31,   32,  130,
 /*  2240 */   130,   35,   36,   37,  130,  130,   40,  130,   42,   43,
 /*  2250 */    44,  130,  130,  130,  130,  130,  130,   51,  130,  130,
 /*  2260 */   130,  130,  130,  130,  130,  130,   60,  130,  130,  130,
 /*  2270 */    64,  130,   66,  130,   68,  130,   70,   71,  130,   73,
 /*  2280 */    74,   75,  130,   77,   78,  130,  130,  130,   21,   22,
 /*  2290 */   130,   24,  130,   26,  130,  130,   29,  130,   21,   22,
 /*  2300 */   130,   24,  130,   26,  130,   38,   29,  130,  130,  130,
 /*  2310 */   130,  130,  130,  130,  130,   38,  130,  130,  130,  130,
 /*  2320 */   130,   54,   55,   56,   57,   58,   59,  130,  130,  130,
 /*  2330 */   130,   54,   55,   56,   57,   58,   59,  130,  130,  130,
 /*  2340 */   130,  130,  130,  130,  130,  130,  130,   80,   81,   82,
 /*  2350 */    83,   84,   85,   86,   87,  130,  130,   80,   81,   82,
 /*  2360 */    83,   84,   85,   86,   87,  130,    5,  130,  130,   21,
 /*  2370 */    22,  130,   24,  130,   26,  130,  130,   29,  130,  130,
 /*  2380 */   130,  130,   21,   22,  130,   24,   38,   26,  130,  130,
 /*  2390 */    29,  130,   21,   22,  130,   24,  130,   26,  130,   38,
 /*  2400 */    29,  130,   54,   55,   56,   57,   58,   59,  130,   38,
 /*  2410 */   130,  130,  130,  130,  130,   54,   55,   56,   57,   58,
 /*  2420 */    59,  130,  130,   52,  130,   54,   55,   56,   57,   58,
 /*  2430 */    59,  130,  130,  130,  130,   87,   88,   19,  130,   21,
 /*  2440 */    22,  130,   24,  130,   26,  130,  130,   29,   87,   21,
 /*  2450 */    22,  130,   24,  130,   26,  130,   38,   29,   87,   18,
 /*  2460 */   130,  130,   21,   22,  130,   24,   38,   26,  130,  130,
 /*  2470 */    29,  130,   54,   55,   56,   57,   58,   59,   50,   38,
 /*  2480 */   130,  130,   54,   55,   56,   57,   58,   59,  130,  130,
 /*  2490 */   130,  130,  130,  130,  130,   54,   55,   56,   57,   58,
 /*  2500 */    59,   21,   22,  130,   24,   87,   26,  130,  130,   29,
 /*  2510 */   130,  130,  130,  130,  130,   87,  130,  130,   38,  130,
 /*  2520 */   130,  130,  130,  130,  130,  130,  130,  130,   87,  130,
 /*  2530 */   130,  130,   52,  130,   54,   55,   56,   57,   58,   59,
 /*  2540 */    21,   22,  130,   24,  130,   26,  130,  130,   29,  130,
 /*  2550 */   130,  130,  130,  130,  130,  130,  130,   38,  130,  130,
 /*  2560 */   130,  130,  130,   21,   22,  130,   24,   87,   26,  130,
 /*  2570 */   130,   29,  130,   54,   55,   56,   57,   58,   59,  130,
 /*  2580 */    38,  130,  130,  130,  130,   21,   22,  130,   24,  130,
 /*  2590 */    26,  130,  130,   29,  130,  130,   54,   55,   56,   57,
 /*  2600 */    58,   59,   38,  130,  130,  130,   87,  130,  130,  130,
 /*  2610 */   130,  130,  130,  130,  130,  130,  130,  130,   54,   55,
 /*  2620 */    56,   57,   58,   59,  130,  130,  130,  130,  130,   87,
 /*  2630 */   130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
 /*  2640 */   130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
 /*  2650 */   130,   87,
};
#define YY_SHIFT_USE_DFLT (-31)
static short yy_shift_ofst[] = {
 /*     0 */  1325, 1289, 1240,  -31,  -31,  -31,  -31,  -31,  -31,  -31,
 /*    10 */   -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,
 /*    20 */   -31,  -31,  -31,  -31,  -31,  -31, 2206, 2519,  416, 1549,
 /*    30 */  1568, 1179, 1352,  -31, 1210, 1397,  420, 1322, 1394,  -31,
 /*    40 */  2519,  215,  -31, 2519, 2519,   91, 2519, 2519,   91, 2418,
 /*    50 */   313, 2441,  313, 2519,  313, 2519, 1321, 2519, 1321, 2519,
 /*    60 */    91, 2519,    4, 2519, 1012, 2519,   18, 2277,   18, 2267,
 /*    70 */    18, 2519,   18, 2519,   18, 2519,   18, 2519,   18, 2519,
 /*    80 */    18, 2519,   18, 2519,  -31, 2519,  721,  414, 2519,    4,
 /*    90 */   -31,  -31, 2361,  446,  -31, 2519,  275, 2519,  772, 2480,
 /*   100 */   666, 2519,    4, 2519,  303,  -31, 2428,  666,  -31, 1302,
 /*   110 */   -31, 2542, 2348,  -31,  158,  -31,  -31, 1307, 2519,  666,
 /*   120 */   -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  476,
 /*   130 */   -31, 2564,  -31,  479, 2519,  666,  -31,  -31, 1190,  304,
 /*   140 */   -31,  170,  136,   78,  526,  -31, 1335,  -31, 1403,   23,
 /*   150 */   -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31,
 /*   160 */   -31,  -31,  -31,  -31, 2519,  313, 2519,  313,   91,   91,
 /*   170 */  1186,  -31, 1197,  348, 2519,   82, 1325, 1601, 1686, 1344,
 /*   180 */   -31, 2519,  606, 1672, 1674, 1374, 1283,  -31, 2519,  356,
 /*   190 */   -31,  415,  -31,  152,   55,  -31,  152,  -31, 1383, 2519,
 /*   200 */   666, 2519,  666, 2519,  666, 2519,  666, 2519,  666, 2519,
 /*   210 */   527,  -31,  152,  -31,  -31,  -31, 1336, 1341,  531, 1297,
 /*   220 */  1325, 1360, 1998, 1281,  -31, 2519,  694, 2371,  306, 1223,
 /*   230 */  1325, 1362, 1842, 1219,  -31,  -31,  688, 1199, 1388, 1393,
 /*   240 */  1946,  667,  -31, 2519,   -3, 1325, 1419, 1530,  635,  -31,
 /*   250 */   605, 1325, 2519,  578,  -31,  561,  463,  470,  -31,  -31,
 /*   260 */  2519,  497,  -31, 2519,   52,  -31, 2519,  245,  -31, 2519,
 /*   270 */   185,  -31, 2519,  155,  -31,   -9,  184, 1325, 1445, 1582,
 /*   280 */    95,  -31, 1391,  -31, 1369,  -31,  -31, 1370, 1325, 1501,
 /*   290 */  1478,  -30,  -31,   98, 1325, 1516, 1894,  218,  -31,  244,
 /*   300 */   320, 1738,  324,  -31,  325,  360,  326,  359,  -31, 1246,
 /*   310 */   419, 1325, 1570, 1790,  462,  -31,  521,  -31,  523,  290,
 /*   320 */   -31,  -31,  -31,  -31,  -31,  -31,  -31,  -31, 2050, 1201,
 /*   330 */   -31, 2519,  636, 1325, 1575, 2154, 1274,  -31, 1269, 1319,
 /*   340 */  2519,  125, 1325, 1620, 2102, 1343,  -31, 2519,  386, 1325,
 /*   350 */  1622, 1426, 1348,  -31, 1634, 1380,  -31, 1250,  449,  -31,
 /*   360 */  1263, 1367, 1323, 1346,  -31,
};
#define YY_REDUCE_USE_DFLT (-66)
static short yy_reduce_ofst[] = {
 /*     0 */   662,  -66, 1094,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*    10 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*    20 */   -66,  -66,  -66,  -66,  -66,  -66,  -66, 1415,  -66, 1023,
 /*    30 */  1094,  -66,  -66,  -66,  -66,  879, 1094,  -66,  -66,  -66,
 /*    40 */  1679,  -66,  -66, 1175, 1189,  -66,  445, 1253,  -66, 1181,
 /*    50 */   -66, 1499,  -66, 1359,  -66, 1183,  -66, 1712,  -66, 1656,
 /*    60 */   -66, 1627,  -66, 1567,  -66, 1395,  -66, 1104,  -66, 1400,
 /*    70 */   -66, 1118,  -66, 1708,  -66, 1604,  -66, 1660,  -66, 1603,
 /*    80 */   -66,  450,  -66, 1651,  -66, 1180,  -66,  -66, 1701,  -66,
 /*    90 */   -66,  -66, 1101,  -66,  -66, 1671,  -66, 1363,  -66,  364,
 /*   100 */   -66, 1703,  -66, 1431,  -66,  -66,  447,  -66,  -66,  -66,
 /*   110 */   -66,  363,  361,  -66,  -66,  -66,  -66,  -66, 1108,  -66,
 /*   120 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   130 */   -66,  369,  -66,  -66, 1655,  -66,  -66,  -66,  227,  -66,
 /*   140 */   -66,  -66,  -66,  -66, 1293,  -66,  -66,  -66,  -66,  -66,
 /*   150 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   160 */   -66,  -66,  -66,  -66, 1355,  -66, 1463,  -66,  -66,  -66,
 /*   170 */   -66,  -66,  -66,  -66, 1110,  -66, 1047, 1094,  -66,  -66,
 /*   180 */   -66, 1563,  -66,  735, 1094,  -66,  -66,  -66, 1251,  -66,
 /*   190 */   -66,  -66,  -66,  -65,  -66,  -66,    7,  -66,  -66, 1599,
 /*   200 */   -66, 1523,  -66, 1305,  -66, 1515,  -66, 1459,  -66, 1417,
 /*   210 */   -66,  -66, 1258,  -66,  -66,  -66,  -66,  -66,    2,  -66,
 /*   220 */   831, 1094,  -66,  -66,  -66, 1109,  -66,  442,  -66,  -66,
 /*   230 */   855, 1094,  -66,  -66,  -66,  -66,  -66,  -66, 1071, 1094,
 /*   240 */   -66,  -66,  -66, 1619,  547,  975, 1094,  -66,  -66,  -66,
 /*   250 */   -66, 1165, 1275,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   260 */  1677,  -66,  -66, 1649,  -66,  -66, 1255,  -66,  -66,  451,
 /*   270 */   -66,  -66, 1172,  -66,  -66,  -66,  -66,  711, 1094,  -66,
 /*   280 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  999, 1094,
 /*   290 */   -66,  -66,  -66,  -66,  759, 1094,  -66,  -66,  -66,  -66,
 /*   300 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   310 */   -66,  951, 1094,  -66,  -66,  -66,  439,  -66,  -66,  489,
 /*   320 */   -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   330 */   -66,  367,  -66,  903, 1094,  -66,  -66,  -66,  -66,  -66,
 /*   340 */  1244,  -66,  783, 1094,  -66,  -66,  -66, 1411,  -66,  807,
 /*   350 */  1094,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,  -66,
 /*   360 */   -66,  -66,  -66,  -66,  -66,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   523,  523,  523,  367,  369,  370,  371,  372,  373,  374,
 /*    10 */   375,  376,  377,  378,  379,  380,  381,  382,  383,  384,
 /*    20 */   385,  386,  387,  388,  389,  390,  523,  523,  523,  523,
 /*    30 */   523,  523,  523,  391,  523,  523,  523,  523,  523,  393,
 /*    40 */   523,  523,  396,  523,  523,  450,  523,  523,  451,  523,
 /*    50 */   454,  523,  456,  523,  458,  523,  459,  523,  460,  523,
 /*    60 */   461,  523,  462,  523,  463,  523,  464,  523,  480,  523,
 /*    70 */   479,  523,  481,  523,  482,  523,  483,  523,  484,  523,
 /*    80 */   485,  523,  486,  523,  487,  523,  488,  523,  523,  489,
 /*    90 */   491,  492,  523,  523,  498,  523,  523,  523,  499,  523,
 /*   100 */   514,  523,  490,  523,  523,  493,  523,  508,  494,  523,
 /*   110 */   495,  523,  523,  496,  523,  497,  506,  518,  523,  507,
 /*   120 */   509,  516,  517,  518,  519,  520,  521,  522,  505,  523,
 /*   130 */   510,  523,  512,  518,  523,  515,  511,  513,  523,  523,
 /*   140 */   500,  523,  523,  523,  523,  501,  523,  502,  517,  516,
 /*   150 */   466,  468,  470,  472,  474,  476,  478,  465,  467,  469,
 /*   160 */   471,  473,  475,  477,  523,  457,  523,  455,  453,  452,
 /*   170 */   523,  397,  523,  523,  523,  523,  523,  523,  523,  523,
 /*   180 */   398,  523,  523,  523,  523,  523,  523,  402,  523,  523,
 /*   190 */   404,  523,  405,  523,  523,  406,  523,  407,  523,  523,
 /*   200 */   409,  523,  410,  523,  411,  523,  412,  523,  413,  523,
 /*   210 */   523,  415,  523,  414,  416,  408,  523,  523,  523,  523,
 /*   220 */   523,  523,  523,  523,  417,  523,  523,  523,  523,  510,
 /*   230 */   523,  523,  523,  523,  429,  431,  523,  523,  523,  523,
 /*   240 */   523,  523,  433,  523,  523,  523,  523,  523,  523,  435,
 /*   250 */   523,  523,  523,  523,  432,  523,  523,  523,  439,  449,
 /*   260 */   523,  523,  440,  523,  523,  441,  523,  523,  442,  523,
 /*   270 */   523,  443,  523,  523,  444,  523,  523,  523,  523,  523,
 /*   280 */   523,  445,  523,  447,  523,  448,  368,  523,  523,  523,
 /*   290 */   523,  523,  446,  523,  523,  523,  523,  523,  436,  523,
 /*   300 */   523,  523,  523,  434,  511,  523,  523,  523,  430,  523,
 /*   310 */   523,  523,  523,  523,  523,  418,  523,  419,  421,  523,
 /*   320 */   422,  423,  424,  425,  426,  427,  428,  420,  523,  523,
 /*   330 */   403,  523,  523,  523,  523,  523,  523,  399,  523,  523,
 /*   340 */   523,  523,  523,  523,  523,  523,  400,  523,  523,  523,
 /*   350 */   523,  523,  523,  401,  523,  523,  394,  523,  523,  392,
 /*   360 */   523,  523,  523,  523,  395,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  phvolt_ARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void phvolt_Trace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "OPEN_DELIMITER",  "COMMA",         "IN",          
  "QUESTION",      "COLON",         "RANGE",         "AND",         
  "OR",            "IS",            "EQUALS",        "NOTEQUALS",   
  "LESS",          "GREATER",       "GREATEREQUAL",  "LESSEQUAL",   
  "IDENTICAL",     "NOTIDENTICAL",  "DIVIDE",        "TIMES",       
  "MOD",           "PLUS",          "MINUS",         "CONCAT",      
  "SBRACKET_OPEN",  "PIPE",          "NOT",           "INCR",        
  "DECR",          "PARENTHESES_OPEN",  "DOT",           "IF",          
  "CLOSE_DELIMITER",  "ENDIF",         "ELSE",          "ELSEIF",      
  "ELSEFOR",       "FOR",           "IDENTIFIER",    "ENDFOR",      
  "SWITCH",        "ENDSWITCH",     "CASE",          "DEFAULT",     
  "SET",           "ASSIGN",        "ADD_ASSIGN",    "SUB_ASSIGN",  
  "MUL_ASSIGN",    "DIV_ASSIGN",    "SBRACKET_CLOSE",  "MACRO",       
  "PARENTHESES_CLOSE",  "ENDMACRO",      "INTEGER",       "STRING",      
  "DOUBLE",        "NULL",          "FALSE",         "TRUE",        
  "CALL",          "ENDCALL",       "OPEN_EDELIMITER",  "CLOSE_EDELIMITER",
  "BLOCK",         "ENDBLOCK",      "CACHE",         "ENDCACHE",    
  "RAW",           "ENDRAW",        "EXTENDS",       "INCLUDE",     
  "WITH",          "DO",            "RETURN",        "AUTOESCAPE",  
  "ENDAUTOESCAPE",  "BREAK",         "CONTINUE",      "RAW_FRAGMENT",
  "DEFINED",       "EMPTY",         "EVEN",          "ODD",         
  "NUMERIC",       "SCALAR",        "ITERABLE",      "CBRACKET_OPEN",
  "CBRACKET_CLOSE",  "error",         "program",       "volt_language",
  "statement_list",  "statement",     "raw_fragment",  "if_statement",
  "elseif_statement",  "elsefor_statement",  "for_statement",  "switch_statement",
  "case_clause",   "set_statement",  "echo_statement",  "block_statement",
  "cache_statement",  "extends_statement",  "include_statement",  "do_statement",
  "return_statement",  "autoescape_statement",  "raw_statement",  "break_statement",
  "continue_statement",  "macro_statement",  "empty_statement",  "macro_call_statement",
  "expr",          "set_assignments",  "set_assignment",  "assignable_expr",
  "macro_parameters",  "macro_parameter",  "macro_parameter_default",  "argument_list",
  "cache_lifetime",  "array_list",    "slice_offset",  "array_item",  
  "function_call",  "argument_item",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "program ::= volt_language",
 /*   1 */ "volt_language ::= statement_list",
 /*   2 */ "statement_list ::= statement_list statement",
 /*   3 */ "statement_list ::= statement",
 /*   4 */ "statement ::= raw_fragment",
 /*   5 */ "statement ::= if_statement",
 /*   6 */ "statement ::= elseif_statement",
 /*   7 */ "statement ::= elsefor_statement",
 /*   8 */ "statement ::= for_statement",
 /*   9 */ "statement ::= switch_statement",
 /*  10 */ "statement ::= case_clause",
 /*  11 */ "statement ::= set_statement",
 /*  12 */ "statement ::= echo_statement",
 /*  13 */ "statement ::= block_statement",
 /*  14 */ "statement ::= cache_statement",
 /*  15 */ "statement ::= extends_statement",
 /*  16 */ "statement ::= include_statement",
 /*  17 */ "statement ::= do_statement",
 /*  18 */ "statement ::= return_statement",
 /*  19 */ "statement ::= autoescape_statement",
 /*  20 */ "statement ::= raw_statement",
 /*  21 */ "statement ::= break_statement",
 /*  22 */ "statement ::= continue_statement",
 /*  23 */ "statement ::= macro_statement",
 /*  24 */ "statement ::= empty_statement",
 /*  25 */ "statement ::= macro_call_statement",
 /*  26 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  27 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  28 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ELSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  29 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ELSE CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  30 */ "if_statement ::= OPEN_DELIMITER IF expr CLOSE_DELIMITER OPEN_DELIMITER ELSE CLOSE_DELIMITER OPEN_DELIMITER ENDIF CLOSE_DELIMITER",
 /*  31 */ "elseif_statement ::= OPEN_DELIMITER ELSEIF expr CLOSE_DELIMITER",
 /*  32 */ "elsefor_statement ::= OPEN_DELIMITER ELSEFOR CLOSE_DELIMITER",
 /*  33 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER IN expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  34 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER IN expr IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  35 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER COMMA IDENTIFIER IN expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  36 */ "for_statement ::= OPEN_DELIMITER FOR IDENTIFIER COMMA IDENTIFIER IN expr IF expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDFOR CLOSE_DELIMITER",
 /*  37 */ "switch_statement ::= OPEN_DELIMITER SWITCH expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDSWITCH CLOSE_DELIMITER",
 /*  38 */ "switch_statement ::= OPEN_DELIMITER SWITCH expr CLOSE_DELIMITER OPEN_DELIMITER ENDSWITCH CLOSE_DELIMITER",
 /*  39 */ "case_clause ::= OPEN_DELIMITER CASE expr CLOSE_DELIMITER",
 /*  40 */ "case_clause ::= OPEN_DELIMITER DEFAULT CLOSE_DELIMITER",
 /*  41 */ "set_statement ::= OPEN_DELIMITER SET set_assignments CLOSE_DELIMITER",
 /*  42 */ "set_assignments ::= set_assignments COMMA set_assignment",
 /*  43 */ "set_assignments ::= set_assignment",
 /*  44 */ "set_assignment ::= assignable_expr ASSIGN expr",
 /*  45 */ "set_assignment ::= assignable_expr ADD_ASSIGN expr",
 /*  46 */ "set_assignment ::= assignable_expr SUB_ASSIGN expr",
 /*  47 */ "set_assignment ::= assignable_expr MUL_ASSIGN expr",
 /*  48 */ "set_assignment ::= assignable_expr DIV_ASSIGN expr",
 /*  49 */ "assignable_expr ::= IDENTIFIER",
 /*  50 */ "assignable_expr ::= assignable_expr SBRACKET_OPEN expr SBRACKET_CLOSE",
 /*  51 */ "assignable_expr ::= assignable_expr DOT assignable_expr",
 /*  52 */ "macro_statement ::= OPEN_DELIMITER MACRO IDENTIFIER PARENTHESES_OPEN PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDMACRO CLOSE_DELIMITER",
 /*  53 */ "macro_statement ::= OPEN_DELIMITER MACRO IDENTIFIER PARENTHESES_OPEN macro_parameters PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDMACRO CLOSE_DELIMITER",
 /*  54 */ "macro_parameters ::= macro_parameters COMMA macro_parameter",
 /*  55 */ "macro_parameters ::= macro_parameter",
 /*  56 */ "macro_parameter ::= IDENTIFIER",
 /*  57 */ "macro_parameter ::= IDENTIFIER ASSIGN macro_parameter_default",
 /*  58 */ "macro_parameter_default ::= INTEGER",
 /*  59 */ "macro_parameter_default ::= STRING",
 /*  60 */ "macro_parameter_default ::= DOUBLE",
 /*  61 */ "macro_parameter_default ::= NULL",
 /*  62 */ "macro_parameter_default ::= FALSE",
 /*  63 */ "macro_parameter_default ::= TRUE",
 /*  64 */ "macro_call_statement ::= OPEN_DELIMITER CALL expr PARENTHESES_OPEN argument_list PARENTHESES_CLOSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCALL CLOSE_DELIMITER",
 /*  65 */ "macro_call_statement ::= OPEN_DELIMITER CALL expr PARENTHESES_OPEN PARENTHESES_CLOSE CLOSE_DELIMITER OPEN_DELIMITER ENDCALL CLOSE_DELIMITER",
 /*  66 */ "empty_statement ::= OPEN_DELIMITER CLOSE_DELIMITER",
 /*  67 */ "echo_statement ::= OPEN_EDELIMITER expr CLOSE_EDELIMITER",
 /*  68 */ "block_statement ::= OPEN_DELIMITER BLOCK IDENTIFIER CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDBLOCK CLOSE_DELIMITER",
 /*  69 */ "block_statement ::= OPEN_DELIMITER BLOCK IDENTIFIER CLOSE_DELIMITER OPEN_DELIMITER ENDBLOCK CLOSE_DELIMITER",
 /*  70 */ "cache_statement ::= OPEN_DELIMITER CACHE expr CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCACHE CLOSE_DELIMITER",
 /*  71 */ "cache_statement ::= OPEN_DELIMITER CACHE expr cache_lifetime CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDCACHE CLOSE_DELIMITER",
 /*  72 */ "cache_lifetime ::= INTEGER",
 /*  73 */ "cache_lifetime ::= IDENTIFIER",
 /*  74 */ "raw_statement ::= OPEN_DELIMITER RAW CLOSE_DELIMITER statement OPEN_DELIMITER ENDRAW CLOSE_DELIMITER",
 /*  75 */ "extends_statement ::= OPEN_DELIMITER EXTENDS expr CLOSE_DELIMITER",
 /*  76 */ "include_statement ::= OPEN_DELIMITER INCLUDE expr CLOSE_DELIMITER",
 /*  77 */ "include_statement ::= OPEN_DELIMITER INCLUDE expr WITH expr CLOSE_DELIMITER",
 /*  78 */ "do_statement ::= OPEN_DELIMITER DO expr CLOSE_DELIMITER",
 /*  79 */ "return_statement ::= OPEN_DELIMITER RETURN expr CLOSE_DELIMITER",
 /*  80 */ "autoescape_statement ::= OPEN_DELIMITER AUTOESCAPE FALSE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDAUTOESCAPE CLOSE_DELIMITER",
 /*  81 */ "autoescape_statement ::= OPEN_DELIMITER AUTOESCAPE TRUE CLOSE_DELIMITER statement_list OPEN_DELIMITER ENDAUTOESCAPE CLOSE_DELIMITER",
 /*  82 */ "break_statement ::= OPEN_DELIMITER BREAK CLOSE_DELIMITER",
 /*  83 */ "continue_statement ::= OPEN_DELIMITER CONTINUE CLOSE_DELIMITER",
 /*  84 */ "raw_fragment ::= RAW_FRAGMENT",
 /*  85 */ "expr ::= MINUS expr",
 /*  86 */ "expr ::= PLUS expr",
 /*  87 */ "expr ::= expr MINUS expr",
 /*  88 */ "expr ::= expr PLUS expr",
 /*  89 */ "expr ::= expr TIMES expr",
 /*  90 */ "expr ::= expr TIMES TIMES expr",
 /*  91 */ "expr ::= expr DIVIDE expr",
 /*  92 */ "expr ::= expr DIVIDE DIVIDE expr",
 /*  93 */ "expr ::= expr MOD expr",
 /*  94 */ "expr ::= expr AND expr",
 /*  95 */ "expr ::= expr OR expr",
 /*  96 */ "expr ::= expr CONCAT expr",
 /*  97 */ "expr ::= expr PIPE expr",
 /*  98 */ "expr ::= expr RANGE expr",
 /*  99 */ "expr ::= expr EQUALS expr",
 /* 100 */ "expr ::= expr NOTEQUALS DEFINED",
 /* 101 */ "expr ::= expr IS DEFINED",
 /* 102 */ "expr ::= expr NOTEQUALS EMPTY",
 /* 103 */ "expr ::= expr IS EMPTY",
 /* 104 */ "expr ::= expr NOTEQUALS EVEN",
 /* 105 */ "expr ::= expr IS EVEN",
 /* 106 */ "expr ::= expr NOTEQUALS ODD",
 /* 107 */ "expr ::= expr IS ODD",
 /* 108 */ "expr ::= expr NOTEQUALS NUMERIC",
 /* 109 */ "expr ::= expr IS NUMERIC",
 /* 110 */ "expr ::= expr NOTEQUALS SCALAR",
 /* 111 */ "expr ::= expr IS SCALAR",
 /* 112 */ "expr ::= expr NOTEQUALS ITERABLE",
 /* 113 */ "expr ::= expr IS ITERABLE",
 /* 114 */ "expr ::= expr IS expr",
 /* 115 */ "expr ::= expr NOTEQUALS expr",
 /* 116 */ "expr ::= expr IDENTICAL expr",
 /* 117 */ "expr ::= expr NOTIDENTICAL expr",
 /* 118 */ "expr ::= expr LESS expr",
 /* 119 */ "expr ::= expr GREATER expr",
 /* 120 */ "expr ::= expr GREATEREQUAL expr",
 /* 121 */ "expr ::= expr LESSEQUAL expr",
 /* 122 */ "expr ::= expr DOT expr",
 /* 123 */ "expr ::= expr IN expr",
 /* 124 */ "expr ::= expr NOT IN expr",
 /* 125 */ "expr ::= NOT expr",
 /* 126 */ "expr ::= expr INCR",
 /* 127 */ "expr ::= expr DECR",
 /* 128 */ "expr ::= PARENTHESES_OPEN expr PARENTHESES_CLOSE",
 /* 129 */ "expr ::= SBRACKET_OPEN SBRACKET_CLOSE",
 /* 130 */ "expr ::= SBRACKET_OPEN array_list SBRACKET_CLOSE",
 /* 131 */ "expr ::= CBRACKET_OPEN CBRACKET_CLOSE",
 /* 132 */ "expr ::= CBRACKET_OPEN array_list CBRACKET_CLOSE",
 /* 133 */ "expr ::= expr SBRACKET_OPEN expr SBRACKET_CLOSE",
 /* 134 */ "expr ::= expr QUESTION expr COLON expr",
 /* 135 */ "expr ::= expr SBRACKET_OPEN COLON slice_offset SBRACKET_CLOSE",
 /* 136 */ "expr ::= expr SBRACKET_OPEN slice_offset COLON SBRACKET_CLOSE",
 /* 137 */ "expr ::= expr SBRACKET_OPEN slice_offset COLON slice_offset SBRACKET_CLOSE",
 /* 138 */ "slice_offset ::= INTEGER",
 /* 139 */ "slice_offset ::= IDENTIFIER",
 /* 140 */ "array_list ::= array_list COMMA array_item",
 /* 141 */ "array_list ::= array_item",
 /* 142 */ "array_item ::= STRING COLON expr",
 /* 143 */ "array_item ::= expr",
 /* 144 */ "expr ::= function_call",
 /* 145 */ "function_call ::= expr PARENTHESES_OPEN argument_list PARENTHESES_CLOSE",
 /* 146 */ "function_call ::= expr PARENTHESES_OPEN PARENTHESES_CLOSE",
 /* 147 */ "argument_list ::= argument_list COMMA argument_item",
 /* 148 */ "argument_list ::= argument_item",
 /* 149 */ "argument_item ::= expr",
 /* 150 */ "argument_item ::= STRING COLON expr",
 /* 151 */ "expr ::= IDENTIFIER",
 /* 152 */ "expr ::= INTEGER",
 /* 153 */ "expr ::= STRING",
 /* 154 */ "expr ::= DOUBLE",
 /* 155 */ "expr ::= NULL",
 /* 156 */ "expr ::= FALSE",
 /* 157 */ "expr ::= TRUE",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *phvolt_TokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to phvolt_ and phvolt_Free.
*/
void *phvolt_Alloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
#line 161 "parser.php5.lemon"
{
	if ((yypminor->yy0)) {
		if ((yypminor->yy0)->free_flag) {
			efree((yypminor->yy0)->token);
		}
		efree((yypminor->yy0));
	}
}
#line 1221 "parser.php5.c"
      break;
    case 92:
    case 93:
    case 94:
    case 95:
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
    case 112:
    case 113:
    case 114:
    case 115:
    case 116:
    case 117:
    case 118:
    case 120:
    case 121:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 129:
#line 178 "parser.php5.lemon"
{
#if PHP_VERSION_ID < 70000
	zval_ptr_dtor(&(yypminor->yy228));
#endif
}
#line 1265 "parser.php5.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from phvolt_Alloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void phvolt_Free(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     phvolt_ARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 90, 1 },
  { 91, 1 },
  { 92, 2 },
  { 92, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 93, 1 },
  { 95, 8 },
  { 95, 7 },
  { 95, 12 },
  { 95, 11 },
  { 95, 10 },
  { 96, 4 },
  { 97, 3 },
  { 98, 10 },
  { 98, 12 },
  { 98, 12 },
  { 98, 14 },
  { 99, 8 },
  { 99, 7 },
  { 100, 4 },
  { 100, 3 },
  { 101, 4 },
  { 117, 3 },
  { 117, 1 },
  { 118, 3 },
  { 118, 3 },
  { 118, 3 },
  { 118, 3 },
  { 118, 3 },
  { 119, 1 },
  { 119, 4 },
  { 119, 3 },
  { 113, 10 },
  { 113, 11 },
  { 120, 3 },
  { 120, 1 },
  { 121, 1 },
  { 121, 3 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 122, 1 },
  { 115, 11 },
  { 115, 9 },
  { 114, 2 },
  { 102, 3 },
  { 103, 8 },
  { 103, 7 },
  { 104, 8 },
  { 104, 9 },
  { 124, 1 },
  { 124, 1 },
  { 110, 7 },
  { 105, 4 },
  { 106, 4 },
  { 106, 6 },
  { 107, 4 },
  { 108, 4 },
  { 109, 8 },
  { 109, 8 },
  { 111, 3 },
  { 112, 3 },
  { 94, 1 },
  { 116, 2 },
  { 116, 2 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 4 },
  { 116, 3 },
  { 116, 4 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 3 },
  { 116, 4 },
  { 116, 2 },
  { 116, 2 },
  { 116, 2 },
  { 116, 3 },
  { 116, 2 },
  { 116, 3 },
  { 116, 2 },
  { 116, 3 },
  { 116, 4 },
  { 116, 5 },
  { 116, 5 },
  { 116, 5 },
  { 116, 6 },
  { 126, 1 },
  { 126, 1 },
  { 125, 3 },
  { 125, 1 },
  { 127, 3 },
  { 127, 1 },
  { 116, 1 },
  { 128, 4 },
  { 128, 3 },
  { 123, 3 },
  { 123, 1 },
  { 129, 1 },
  { 129, 3 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
  { 116, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  phvolt_ARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
#line 170 "parser.php5.lemon"
{
	status->ret = yymsp[0].minor.yy228;
}
#line 1640 "parser.php5.c"
        break;
      case 1:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 144:
#line 174 "parser.php5.lemon"
{
	yygotominor.yy228 = yymsp[0].minor.yy228;
}
#line 1670 "parser.php5.c"
        break;
      case 2:
#line 184 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_zval_list(yymsp[-1].minor.yy228, yymsp[0].minor.yy228);
}
#line 1677 "parser.php5.c"
        break;
      case 3:
      case 43:
      case 55:
      case 141:
      case 148:
#line 188 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_zval_list(NULL, yymsp[0].minor.yy228);
}
#line 1688 "parser.php5.c"
        break;
      case 26:
#line 293 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_if_statement(yymsp[-5].minor.yy228, yymsp[-3].minor.yy228, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1701 "parser.php5.c"
        break;
      case 27:
#line 298 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_if_statement(yymsp[-4].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(31,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1714 "parser.php5.c"
        break;
      case 28:
#line 303 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_if_statement(yymsp[-9].minor.yy228, yymsp[-7].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(31,&yymsp[-10].minor);
  yy_destructor(32,&yymsp[-8].minor);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(34,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1730 "parser.php5.c"
        break;
      case 29:
#line 308 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_if_statement(yymsp[-8].minor.yy228, yymsp[-6].minor.yy228, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(31,&yymsp[-9].minor);
  yy_destructor(32,&yymsp[-7].minor);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1746 "parser.php5.c"
        break;
      case 30:
#line 313 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_if_statement(yymsp[-7].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(31,&yymsp[-8].minor);
  yy_destructor(32,&yymsp[-6].minor);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(33,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1762 "parser.php5.c"
        break;
      case 31:
#line 323 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_elseif_statement(yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(35,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1772 "parser.php5.c"
        break;
      case 32:
#line 333 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_elsefor_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(36,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1782 "parser.php5.c"
        break;
      case 33:
#line 343 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_for_statement(yymsp[-7].minor.yy0, NULL, yymsp[-5].minor.yy228, NULL, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(37,&yymsp[-8].minor);
  yy_destructor(3,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1796 "parser.php5.c"
        break;
      case 34:
#line 347 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_for_statement(yymsp[-9].minor.yy0, NULL, yymsp[-7].minor.yy228, yymsp[-5].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(37,&yymsp[-10].minor);
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1811 "parser.php5.c"
        break;
      case 35:
#line 351 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_for_statement(yymsp[-7].minor.yy0, yymsp[-9].minor.yy0, yymsp[-5].minor.yy228, NULL, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-11].minor);
  yy_destructor(37,&yymsp[-10].minor);
  yy_destructor(2,&yymsp[-8].minor);
  yy_destructor(3,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1826 "parser.php5.c"
        break;
      case 36:
#line 355 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_for_statement(yymsp[-9].minor.yy0, yymsp[-11].minor.yy0, yymsp[-7].minor.yy228, yymsp[-5].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-13].minor);
  yy_destructor(37,&yymsp[-12].minor);
  yy_destructor(2,&yymsp[-10].minor);
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(31,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(39,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1842 "parser.php5.c"
        break;
      case 37:
#line 366 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_switch_statement(yymsp[-5].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(40,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(41,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1855 "parser.php5.c"
        break;
      case 38:
#line 371 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_switch_statement(yymsp[-4].minor.yy228, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(40,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(41,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1868 "parser.php5.c"
        break;
      case 39:
#line 382 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_case_clause(yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(42,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1878 "parser.php5.c"
        break;
      case 40:
#line 387 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_case_clause(NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(43,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1888 "parser.php5.c"
        break;
      case 41:
#line 397 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_set_statement(yymsp[-1].minor.yy228);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(44,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1898 "parser.php5.c"
        break;
      case 42:
      case 54:
      case 140:
      case 147:
#line 407 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_zval_list(yymsp[-2].minor.yy228, yymsp[0].minor.yy228);
  yy_destructor(2,&yymsp[-1].minor);
}
#line 1909 "parser.php5.c"
        break;
      case 44:
#line 421 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_set_assignment(yymsp[-2].minor.yy228, PHVOLT_T_ASSIGN, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(45,&yymsp[-1].minor);
}
#line 1917 "parser.php5.c"
        break;
      case 45:
#line 425 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_set_assignment(yymsp[-2].minor.yy228, PHVOLT_T_ADD_ASSIGN, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(46,&yymsp[-1].minor);
}
#line 1925 "parser.php5.c"
        break;
      case 46:
#line 429 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_set_assignment(yymsp[-2].minor.yy228, PHVOLT_T_SUB_ASSIGN, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(47,&yymsp[-1].minor);
}
#line 1933 "parser.php5.c"
        break;
      case 47:
#line 433 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_set_assignment(yymsp[-2].minor.yy228, PHVOLT_T_MUL_ASSIGN, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(48,&yymsp[-1].minor);
}
#line 1941 "parser.php5.c"
        break;
      case 48:
#line 437 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_set_assignment(yymsp[-2].minor.yy228, PHVOLT_T_DIV_ASSIGN, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(49,&yymsp[-1].minor);
}
#line 1949 "parser.php5.c"
        break;
      case 49:
      case 73:
      case 139:
      case 151:
#line 441 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_IDENTIFIER, yymsp[0].minor.yy0, status->scanner_state);
}
#line 1959 "parser.php5.c"
        break;
      case 50:
      case 133:
#line 445 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ARRAYACCESS, yymsp[-3].minor.yy228, yymsp[-1].minor.yy228, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 1969 "parser.php5.c"
        break;
      case 51:
      case 122:
#line 449 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_DOT, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(30,&yymsp[-1].minor);
}
#line 1978 "parser.php5.c"
        break;
      case 52:
#line 459 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_macro_statement(yymsp[-7].minor.yy0, NULL, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-9].minor);
  yy_destructor(51,&yymsp[-8].minor);
  yy_destructor(29,&yymsp[-6].minor);
  yy_destructor(52,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 1993 "parser.php5.c"
        break;
      case 53:
#line 463 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_macro_statement(yymsp[-8].minor.yy0, yymsp[-6].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(51,&yymsp[-9].minor);
  yy_destructor(29,&yymsp[-7].minor);
  yy_destructor(52,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2008 "parser.php5.c"
        break;
      case 56:
#line 487 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_macro_parameter(yymsp[0].minor.yy0, NULL, status->scanner_state);
}
#line 2015 "parser.php5.c"
        break;
      case 57:
#line 491 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_macro_parameter(yymsp[-2].minor.yy0, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(45,&yymsp[-1].minor);
}
#line 2023 "parser.php5.c"
        break;
      case 58:
      case 72:
      case 138:
      case 152:
#line 495 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_INTEGER, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2033 "parser.php5.c"
        break;
      case 59:
      case 153:
#line 499 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_STRING, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2041 "parser.php5.c"
        break;
      case 60:
      case 154:
#line 503 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_DOUBLE, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2049 "parser.php5.c"
        break;
      case 61:
      case 155:
#line 507 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_NULL, NULL, status->scanner_state);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2058 "parser.php5.c"
        break;
      case 62:
      case 156:
#line 511 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_FALSE, NULL, status->scanner_state);
  yy_destructor(58,&yymsp[0].minor);
}
#line 2067 "parser.php5.c"
        break;
      case 63:
      case 157:
#line 515 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_TRUE, NULL, status->scanner_state);
  yy_destructor(59,&yymsp[0].minor);
}
#line 2076 "parser.php5.c"
        break;
      case 64:
#line 525 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_macro_call_statement(yymsp[-8].minor.yy228, yymsp[-6].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-10].minor);
  yy_destructor(60,&yymsp[-9].minor);
  yy_destructor(29,&yymsp[-7].minor);
  yy_destructor(52,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2091 "parser.php5.c"
        break;
      case 65:
#line 529 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_macro_call_statement(yymsp[-6].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-8].minor);
  yy_destructor(60,&yymsp[-7].minor);
  yy_destructor(29,&yymsp[-5].minor);
  yy_destructor(52,&yymsp[-4].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2106 "parser.php5.c"
        break;
      case 66:
#line 539 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_empty_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2115 "parser.php5.c"
        break;
      case 67:
#line 549 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_echo_statement(yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(62,&yymsp[-2].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2124 "parser.php5.c"
        break;
      case 68:
#line 559 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_block_statement(yymsp[-5].minor.yy0, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(64,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2137 "parser.php5.c"
        break;
      case 69:
#line 563 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_block_statement(yymsp[-4].minor.yy0, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(64,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-3].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2150 "parser.php5.c"
        break;
      case 70:
#line 573 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_cache_statement(yymsp[-5].minor.yy228, NULL, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(66,&yymsp[-6].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(67,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2163 "parser.php5.c"
        break;
      case 71:
#line 577 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_cache_statement(yymsp[-6].minor.yy228, yymsp[-5].minor.yy228, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-8].minor);
  yy_destructor(66,&yymsp[-7].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(67,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2176 "parser.php5.c"
        break;
      case 74:
#line 601 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_raw_statement(yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-6].minor);
  yy_destructor(68,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(69,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2189 "parser.php5.c"
        break;
      case 75:
#line 611 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_extends_statement(yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(70,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2199 "parser.php5.c"
        break;
      case 76:
#line 621 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_include_statement(yymsp[-1].minor.yy228, NULL, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(71,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2209 "parser.php5.c"
        break;
      case 77:
#line 625 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_include_statement(yymsp[-3].minor.yy228, yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-5].minor);
  yy_destructor(71,&yymsp[-4].minor);
  yy_destructor(72,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2220 "parser.php5.c"
        break;
      case 78:
#line 635 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_do_statement(yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(73,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2230 "parser.php5.c"
        break;
      case 79:
#line 645 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_return_statement(yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-3].minor);
  yy_destructor(74,&yymsp[-2].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2240 "parser.php5.c"
        break;
      case 80:
#line 655 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_autoescape_statement(0, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(75,&yymsp[-6].minor);
  yy_destructor(58,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(76,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2254 "parser.php5.c"
        break;
      case 81:
#line 659 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_autoescape_statement(1, yymsp[-3].minor.yy228, status->scanner_state);
  yy_destructor(1,&yymsp[-7].minor);
  yy_destructor(75,&yymsp[-6].minor);
  yy_destructor(59,&yymsp[-5].minor);
  yy_destructor(32,&yymsp[-4].minor);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(76,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2268 "parser.php5.c"
        break;
      case 82:
#line 669 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_break_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(77,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2278 "parser.php5.c"
        break;
      case 83:
#line 679 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_continue_statement(status->scanner_state);
  yy_destructor(1,&yymsp[-2].minor);
  yy_destructor(78,&yymsp[-1].minor);
  yy_destructor(32,&yymsp[0].minor);
}
#line 2288 "parser.php5.c"
        break;
      case 84:
#line 689 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_literal_zval(PHVOLT_T_RAW_FRAGMENT, yymsp[0].minor.yy0, status->scanner_state);
}
#line 2295 "parser.php5.c"
        break;
      case 85:
#line 699 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_MINUS, NULL, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(22,&yymsp[-1].minor);
}
#line 2303 "parser.php5.c"
        break;
      case 86:
#line 703 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_PLUS, NULL, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(21,&yymsp[-1].minor);
}
#line 2311 "parser.php5.c"
        break;
      case 87:
#line 707 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_SUB, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(22,&yymsp[-1].minor);
}
#line 2319 "parser.php5.c"
        break;
      case 88:
#line 711 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ADD, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(21,&yymsp[-1].minor);
}
#line 2327 "parser.php5.c"
        break;
      case 89:
#line 715 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_MUL, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 2335 "parser.php5.c"
        break;
      case 90:
#line 719 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_POW, yymsp[-3].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(19,&yymsp[-2].minor);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 2344 "parser.php5.c"
        break;
      case 91:
#line 723 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_DIV, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 2352 "parser.php5.c"
        break;
      case 92:
#line 727 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_MOD, yymsp[-3].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(18,&yymsp[-2].minor);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 2361 "parser.php5.c"
        break;
      case 93:
#line 731 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_MOD, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(20,&yymsp[-1].minor);
}
#line 2369 "parser.php5.c"
        break;
      case 94:
#line 735 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_AND, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(7,&yymsp[-1].minor);
}
#line 2377 "parser.php5.c"
        break;
      case 95:
#line 739 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_OR, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(8,&yymsp[-1].minor);
}
#line 2385 "parser.php5.c"
        break;
      case 96:
#line 743 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_CONCAT, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(23,&yymsp[-1].minor);
}
#line 2393 "parser.php5.c"
        break;
      case 97:
#line 747 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_PIPE, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(25,&yymsp[-1].minor);
}
#line 2401 "parser.php5.c"
        break;
      case 98:
#line 751 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_RANGE, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(6,&yymsp[-1].minor);
}
#line 2409 "parser.php5.c"
        break;
      case 99:
#line 755 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_EQUALS, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(10,&yymsp[-1].minor);
}
#line 2417 "parser.php5.c"
        break;
      case 100:
#line 759 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISSET, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(80,&yymsp[0].minor);
}
#line 2426 "parser.php5.c"
        break;
      case 101:
#line 763 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISSET, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(80,&yymsp[0].minor);
}
#line 2435 "parser.php5.c"
        break;
      case 102:
#line 767 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISEMPTY, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(81,&yymsp[0].minor);
}
#line 2444 "parser.php5.c"
        break;
      case 103:
#line 771 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISEMPTY, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(81,&yymsp[0].minor);
}
#line 2453 "parser.php5.c"
        break;
      case 104:
#line 775 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISEVEN, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(82,&yymsp[0].minor);
}
#line 2462 "parser.php5.c"
        break;
      case 105:
#line 779 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISEVEN, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(82,&yymsp[0].minor);
}
#line 2471 "parser.php5.c"
        break;
      case 106:
#line 783 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISODD, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(83,&yymsp[0].minor);
}
#line 2480 "parser.php5.c"
        break;
      case 107:
#line 787 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISODD, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(83,&yymsp[0].minor);
}
#line 2489 "parser.php5.c"
        break;
      case 108:
#line 791 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISNUMERIC, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(84,&yymsp[0].minor);
}
#line 2498 "parser.php5.c"
        break;
      case 109:
#line 795 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISNUMERIC, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(84,&yymsp[0].minor);
}
#line 2507 "parser.php5.c"
        break;
      case 110:
#line 799 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISSCALAR, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(85,&yymsp[0].minor);
}
#line 2516 "parser.php5.c"
        break;
      case 111:
#line 803 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISSCALAR, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(85,&yymsp[0].minor);
}
#line 2525 "parser.php5.c"
        break;
      case 112:
#line 807 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_ISITERABLE, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
  yy_destructor(86,&yymsp[0].minor);
}
#line 2534 "parser.php5.c"
        break;
      case 113:
#line 811 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ISITERABLE, yymsp[-2].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
  yy_destructor(86,&yymsp[0].minor);
}
#line 2543 "parser.php5.c"
        break;
      case 114:
#line 815 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_IS, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(9,&yymsp[-1].minor);
}
#line 2551 "parser.php5.c"
        break;
      case 115:
#line 819 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOTEQUALS, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(11,&yymsp[-1].minor);
}
#line 2559 "parser.php5.c"
        break;
      case 116:
#line 823 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_IDENTICAL, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(16,&yymsp[-1].minor);
}
#line 2567 "parser.php5.c"
        break;
      case 117:
#line 827 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOTIDENTICAL, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(17,&yymsp[-1].minor);
}
#line 2575 "parser.php5.c"
        break;
      case 118:
#line 831 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_LESS, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(12,&yymsp[-1].minor);
}
#line 2583 "parser.php5.c"
        break;
      case 119:
#line 835 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_GREATER, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(13,&yymsp[-1].minor);
}
#line 2591 "parser.php5.c"
        break;
      case 120:
#line 839 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_GREATEREQUAL, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(14,&yymsp[-1].minor);
}
#line 2599 "parser.php5.c"
        break;
      case 121:
#line 843 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_LESSEQUAL, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(15,&yymsp[-1].minor);
}
#line 2607 "parser.php5.c"
        break;
      case 123:
#line 851 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_IN, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(3,&yymsp[-1].minor);
}
#line 2615 "parser.php5.c"
        break;
      case 124:
#line 855 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT_IN, yymsp[-3].minor.yy228, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(26,&yymsp[-2].minor);
  yy_destructor(3,&yymsp[-1].minor);
}
#line 2624 "parser.php5.c"
        break;
      case 125:
#line 859 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_NOT, NULL, yymsp[0].minor.yy228, NULL, status->scanner_state);
  yy_destructor(26,&yymsp[-1].minor);
}
#line 2632 "parser.php5.c"
        break;
      case 126:
#line 863 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_INCR, yymsp[-1].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(27,&yymsp[0].minor);
}
#line 2640 "parser.php5.c"
        break;
      case 127:
#line 867 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_DECR, yymsp[-1].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(28,&yymsp[0].minor);
}
#line 2648 "parser.php5.c"
        break;
      case 128:
#line 871 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ENCLOSED, yymsp[-1].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2657 "parser.php5.c"
        break;
      case 129:
#line 875 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ARRAY, NULL, NULL, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-1].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2666 "parser.php5.c"
        break;
      case 130:
#line 879 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ARRAY, yymsp[-1].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2675 "parser.php5.c"
        break;
      case 131:
#line 883 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ARRAY, NULL, NULL, NULL, status->scanner_state);
  yy_destructor(87,&yymsp[-1].minor);
  yy_destructor(88,&yymsp[0].minor);
}
#line 2684 "parser.php5.c"
        break;
      case 132:
#line 887 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_ARRAY, yymsp[-1].minor.yy228, NULL, NULL, status->scanner_state);
  yy_destructor(87,&yymsp[-2].minor);
  yy_destructor(88,&yymsp[0].minor);
}
#line 2693 "parser.php5.c"
        break;
      case 134:
#line 895 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_expr(PHVOLT_T_TERNARY, yymsp[-2].minor.yy228, yymsp[0].minor.yy228, yymsp[-4].minor.yy228, status->scanner_state);
  yy_destructor(4,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
}
#line 2702 "parser.php5.c"
        break;
      case 135:
#line 899 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_slice(yymsp[-4].minor.yy228, NULL, yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2712 "parser.php5.c"
        break;
      case 136:
#line 903 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_slice(yymsp[-4].minor.yy228, yymsp[-2].minor.yy228, NULL, status->scanner_state);
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2722 "parser.php5.c"
        break;
      case 137:
#line 907 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_slice(yymsp[-5].minor.yy228, yymsp[-3].minor.yy228, yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(24,&yymsp[-4].minor);
  yy_destructor(5,&yymsp[-2].minor);
  yy_destructor(50,&yymsp[0].minor);
}
#line 2732 "parser.php5.c"
        break;
      case 142:
      case 150:
#line 945 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_named_item(yymsp[-2].minor.yy0, yymsp[0].minor.yy228, status->scanner_state);
  yy_destructor(5,&yymsp[-1].minor);
}
#line 2741 "parser.php5.c"
        break;
      case 143:
      case 149:
#line 949 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_named_item(NULL, yymsp[0].minor.yy228, status->scanner_state);
}
#line 2749 "parser.php5.c"
        break;
      case 145:
#line 963 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_func_call(yymsp[-3].minor.yy228, yymsp[-1].minor.yy228, status->scanner_state);
  yy_destructor(29,&yymsp[-2].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2758 "parser.php5.c"
        break;
      case 146:
#line 967 "parser.php5.lemon"
{
	yygotominor.yy228 = phvolt_ret_func_call(yymsp[-2].minor.yy228, NULL, status->scanner_state);
  yy_destructor(29,&yymsp[-1].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2767 "parser.php5.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  phvolt_ARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  phvolt_ARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 46 "parser.php5.lemon"

	{

		smart_str error_str = {0};

		char *token_name = NULL;
		const phvolt_token_names *tokens = phvolt_tokens;
		int token_len = 0;
		int active_token = status->scanner_state->active_token;

		if (status->scanner_state->start_length) {

			if (active_token) {

				do {
					if (tokens->code == active_token) {
						token_name = tokens->name;
						token_len = tokens->len;
						break;
					}
					++tokens;
				} while (tokens[0].code != 0);

			}

			smart_str_appendl(&error_str, "Syntax error, unexpected token ", sizeof("Syntax error, unexpected token ") - 1);
			if (!token_name) {
				smart_str_appendl(&error_str, "UNKNOWN", sizeof("UNKNOWN") - 1);
			} else {
				smart_str_appendl(&error_str, token_name, token_len);
			}

			if (status->token->value) {
				smart_str_appendc(&error_str, '(');
				smart_str_appendl(&error_str, status->token->value, status->token->len);
				smart_str_appendc(&error_str, ')');
			}

			smart_str_appendl(&error_str, " in ", sizeof(" in ") - 1);
			smart_str_appendl(&error_str, Z_STRVAL_P(status->scanner_state->active_file), Z_STRLEN_P(status->scanner_state->active_file));
			smart_str_appendl(&error_str, " on line ", sizeof(" on line ") - 1);

			{
				char stmp[MAX_LENGTH_OF_LONG + 1];
				int str_len;
				str_len = slprintf(stmp, sizeof(stmp), "%ld", status->scanner_state->active_line);
				smart_str_appendl(&error_str, stmp, str_len);
			}

		} else {

			smart_str_appendl(&error_str, "Syntax error, unexpected EOF in ", sizeof("Syntax error, unexpected EOF in ") - 1);
			smart_str_appendl(&error_str, Z_STRVAL_P(status->scanner_state->active_file), Z_STRLEN_P(status->scanner_state->active_file));

			/* Report unclosed 'if' blocks */
			if ((status->scanner_state->if_level + status->scanner_state->old_if_level) > 0) {
				if ((status->scanner_state->if_level + status->scanner_state->old_if_level) == 1) {
					smart_str_appendl(&error_str, ", there is one 'if' block without close", sizeof(", there is one 'if' block without close") - 1);
				} else {
					smart_str_appendl(&error_str, ", there are ", sizeof(", there are ") - 1);
					{
						char stmp[MAX_LENGTH_OF_LONG + 1];
						int str_len;
						str_len = slprintf(stmp, sizeof(stmp), "%ld", status->scanner_state->if_level + status->scanner_state->old_if_level);
						smart_str_appendl(&error_str, stmp, str_len);
					}
					smart_str_appendl(&error_str, " 'if' blocks without close", sizeof(" 'if' blocks without close") - 1);
				}
			}

			/* Report unclosed 'for' blocks */
			if (status->scanner_state->for_level > 0) {
				if (status->scanner_state->for_level == 1) {
					smart_str_appendl(&error_str, ", there is one 'for' block without close", sizeof(", there is one 'for' block without close") - 1);
				} else {
					smart_str_appendl(&error_str, ", there are ", sizeof(", there are ") - 1);
					{
						char stmp[MAX_LENGTH_OF_LONG + 1];
						int str_len;
						str_len = slprintf(stmp, sizeof(stmp), "%ld", status->scanner_state->if_level);
						smart_str_appendl(&error_str, stmp, str_len);
					}
					smart_str_appendl(&error_str, " 'for' blocks without close", sizeof(" 'for' blocks without close") - 1);
				}
			}

			/* Report unclosed 'switch' blocks */
			if (status->scanner_state->switch_level > 0) {
				smart_str_appendl(&error_str, ", there is a 'switch' block without 'endswitch'", sizeof(", there is a 'switch' block without 'endswitch'") - 1);
			}

		}

		smart_str_0(&error_str);

#if PHP_VERSION_ID < 70000
		if (error_str.len) {
			status->syntax_error = error_str.c;
			status->syntax_error_len = error_str.len;
		} else {
			status->syntax_error = NULL;
		}
#else
		if (error_str.s) {
			status->syntax_error = estrndup(ZSTR_VAL(error_str.s), ZSTR_LEN(error_str.s));
			status->syntax_error_len = ZSTR_LEN(error_str.s);
		} else {
			status->syntax_error = NULL;
		}
#endif
	}

	status->status = PHVOLT_PARSING_FAILED;

#line 2924 "parser.php5.c"
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  phvolt_ARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  phvolt_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "phvolt_Alloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void phvolt_(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  phvolt_TOKENTYPE yyminor       /* The value for the token */
  phvolt_ARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  phvolt_ARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
