<?php

$filter = function (string $name): bool {
    $namespaces = ['MongoDB\BSON\\', 'MongoDB\Driver\\'];

    foreach ($namespaces as $namespace) {
        if (str_starts_with($name, $namespace)) {
            return true;
        }
    }

    return false;
};

$classes = array_filter(get_declared_classes(), $filter);
$interfaces = array_filter(get_declared_interfaces(), $filter);

$members = array_merge($classes, $interfaces);
sort($members);

$skippedMethods = ['__set_state', '__wakeup', '__serialize', '__unserialize'];

$callmap = [];

foreach ($members as $member) {
    $reflectionClass = new ReflectionClass($member);

    foreach ($reflectionClass->getMethods(ReflectionMethod::IS_PUBLIC) as $method) {
        if ($method->getDeclaringClass() != $reflectionClass && $method->getName() != '__toString') {
            continue;
        }

        if (in_array($method->getName(), $skippedMethods, true)) {
            continue;
        }

        $methodKey = $reflectionClass->getName() . '::' . $method->getName();

        $returnType = $method->hasReturnType()
            ? (string) $method->getReturnType()
            : $method->hasTentativeReturnType()
                ? (string) $method->getTentativeReturnType()
                : 'void';
        $callmapEntry = [$returnType];

        foreach ($method->getParameters() as $parameter) {
            $parameterKey = $parameter->getName();
            if ($parameter->isOptional()) {
                $parameterKey .= '=';
            }

            $callmapEntry[$parameterKey] = (string) $parameter->getType();
        }

        $callmap[$methodKey] = $callmapEntry;
    }
}

var_export($callmap);
