--TEST--
html_parser_parse() function
--SKIPIF--
<?php 

if(!extension_loaded('html_parse')) die('skip ');

 ?>
--FILE--
<?php
      function f_start($tag, $attr) {
        echo "Start: $tag";
        ksort($attr);
        foreach($attr as $key => $val) {
          echo ", $key -> '$val'";
        }
        echo "\n";
      }

      function f_end($tag) {
        echo "End: $tag\n";
      }

      function f_data($text) {
        echo "Data: '$text'\n";
      }

      function f_comment($text) {
        echo "Comment: '$text'\n";
      }


      $parser = html_parser_create();

      html_parser_starttag_handler($parser, "f_start");
      html_parser_endtag_handler($parser, "f_end");
      html_parser_data_handler($parser, "f_data");
      html_parser_comment_handler($parser, "f_comment");

      html_parser_parse($parser, "foo <x name='hello' id=23> <!-- <x></x> -->bar </x> baz");

      html_parser_free($parser);

?>
--EXPECT--
Data: 'foo '
Start: X, id -> '23', name -> 'hello'
Data: ' '
Comment: ' <x></x> '
Data: 'bar '
End: X
Data: ' baz'
