/*
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.0 of the PHP license,       |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_0.txt.                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Hartmut Holzgraefe <hartmut@php.net>                        |
   +----------------------------------------------------------------------+
*/

/* $ Id: $ */ 

#ifndef PHP_HTML_PARSE_H
#define PHP_HTML_PARSE_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <php.h>

#ifdef HAVE_HTML_PARSE

#include <php_ini.h>
#include <SAPI.h>
#include <ext/standard/info.h>
#include <Zend/zend_extensions.h>
#ifdef  __cplusplus
} // extern "C" 
#endif
#include <ekhtml.h>
#ifdef  __cplusplus
extern "C" {
#endif

extern zend_module_entry html_parse_module_entry;
#define phpext_html_parse_ptr &html_parse_module_entry

#ifdef PHP_WIN32
#define PHP_HTML_PARSE_API __declspec(dllexport)
#else
#define PHP_HTML_PARSE_API
#endif

PHP_MINIT_FUNCTION(html_parse);
PHP_MSHUTDOWN_FUNCTION(html_parse);
PHP_RINIT_FUNCTION(html_parse);
PHP_RSHUTDOWN_FUNCTION(html_parse);
PHP_MINFO_FUNCTION(html_parse);

#ifdef ZTS
#include "TSRM.h"
#endif

#define FREE_RESOURCE(resource) zend_list_delete(Z_LVAL_P(resource))

#define PROP_GET_LONG(name)    Z_LVAL_P(zend_read_property(_this_ce, _this_zval, #name, strlen(#name), 1 TSRMLS_CC))
#define PROP_SET_LONG(name, l) zend_update_property_long(_this_ce, _this_zval, #name, strlen(#name), l TSRMLS_CC)

#define PROP_GET_DOUBLE(name)    Z_DVAL_P(zend_read_property(_this_ce, _this_zval, #name, strlen(#name), 1 TSRMLS_CC))
#define PROP_SET_DOUBLE(name, d) zend_update_property_double(_this_ce, _this_zval, #name, strlen(#name), d TSRMLS_CC)

#define PROP_GET_STRING(name)    Z_STRVAL_P(zend_read_property(_this_ce, _this_zval, #name, strlen(#name), 1 TSRMLS_CC))
#define PROP_GET_STRLEN(name)    Z_STRLEN_P(zend_read_property(_this_ce, _this_zval, #name, strlen(#name), 1 TSRMLS_CC))
#define PROP_SET_STRING(name, s) zend_update_property_string(_this_ce, _this_zval, #name, strlen(#name), s TSRMLS_CC)
#define PROP_SET_STRINGL(name, s, l) zend_update_property_string(_this_ce, _this_zval, #name, strlen(#name), s, l TSRMLS_CC)


PHP_FUNCTION(html_parser_create);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_create_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 0)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_create_arg_info NULL
#endif

PHP_FUNCTION(html_parser_free);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_free_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 1)
  ZEND_ARG_INFO(0, parser)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_free_arg_info NULL
#endif

PHP_FUNCTION(html_parser_starttag_handler);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_starttag_handler_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 2)
  ZEND_ARG_INFO(0, parser)
  ZEND_ARG_INFO(0, handler)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_starttag_handler_arg_info NULL
#endif

PHP_FUNCTION(html_parser_endtag_handler);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_endtag_handler_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 2)
  ZEND_ARG_INFO(0, parser)
  ZEND_ARG_INFO(0, handler)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_endtag_handler_arg_info NULL
#endif

PHP_FUNCTION(html_parser_data_handler);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_data_handler_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 2)
  ZEND_ARG_INFO(0, parser)
  ZEND_ARG_INFO(0, handler)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_data_handler_arg_info NULL
#endif

PHP_FUNCTION(html_parser_comment_handler);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_comment_handler_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 2)
  ZEND_ARG_INFO(0, parser)
  ZEND_ARG_INFO(0, handler)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_comment_handler_arg_info NULL
#endif

PHP_FUNCTION(html_parser_parse);
#if (PHP_MAJOR_VERSION >= 5)
ZEND_BEGIN_ARG_INFO_EX(html_parser_parse_arg_info, ZEND_SEND_BY_VAL, ZEND_RETURN_VALUE, 2)
  ZEND_ARG_INFO(0, parser)
  ZEND_ARG_INFO(0, data)
  ZEND_ARG_INFO(0, finish)
ZEND_END_ARG_INFO()
#else /* PHP 4.x */
#define html_parser_parse_arg_info NULL
#endif

#ifdef  __cplusplus
} // extern "C" 
#endif

/* 'bottom' header snippets*/
/* resource payload for html_parse resources */
typedef struct {
  /* HTML parser */
	ekhtml_parser_t *parser;

  /* callback functions */
	zval *startElementHandler;
	zval *endElementHandler;
	zval *characterDataHandler;
	zval *commentHandler;
} php_html_parser;

static void _start_cb(void *data, ekhtml_string_t *tag, ekhtml_attr_t *attrs);
static void _end_cb(void *data, ekhtml_string_t *tag);
static void _comment_cb(void *data,  ekhtml_string_t *comment);
static void _data_cb(void *data,  ekhtml_string_t *characterData);

#endif /* PHP_HAVE_HTML_PARSE */

#endif /* PHP_HTML_PARSE_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
