dnl
dnl $ Id: $
dnl

PHP_ARG_ENABLE(html_parse, whether to enable html_parse functions,
[  --enable-html_parse         Enable html_parse support])

if test "$PHP_HTML_PARSE" != "no"; then

PHP_ARG_WITH(ekhtml, whether ekhtml is available,[  --with-ekhtml[=DIR]  With ekhtml support])



  if test -r "$PHP_EKHTML/include/ekhtml.h"; then
	PHP_EKHTML_DIR="$PHP_EKHTML"
  else
	AC_MSG_CHECKING(for ekhtml in default path)
	for i in /usr /usr/local; do
	  if test -r "$i/include/ekhtml.h"; then
		PHP_EKHTML_DIR=$i
		AC_MSG_RESULT(found in $i)
		break
	  fi
	done
	if test "x" = "x$PHP_EKHTML_DIR"; then
	  AC_MSG_ERROR(not found)
	fi
  fi

  PHP_ADD_INCLUDE($PHP_EKHTML_DIR/include)

  export OLD_CPPFLAGS="$CPPFLAGS"
  export CPPFLAGS="$CPPFLAGS $INCLUDES -DHAVE_EKHTML"
  AC_CHECK_HEADER([ekhtml.h], [], AC_MSG_ERROR('ekhtml.h' header not found))
  PHP_SUBST(HTML_PARSE_SHARED_LIBADD)


  PHP_CHECK_LIBRARY(ekhtml, ekhtml_parser_new,
  [
	PHP_ADD_LIBRARY_WITH_PATH(ekhtml, $PHP_EKHTML_DIR/lib, HTML_PARSE_SHARED_LIBADD)
  ],[
	AC_MSG_ERROR([wrong ekhtml lib version or lib not found])
  ],[
	-L$PHP_EKHTML_DIR/lib
  ])
  export CPPFLAGS="$OLD_CPPFLAGS"

  export OLD_CPPFLAGS="$CPPFLAGS"
  export CPPFLAGS="$CPPFLAGS $INCLUDES -DHAVE_HTML_PARSE"

  AC_MSG_CHECKING(PHP version)
  AC_TRY_COMPILE([#include <php_version.h>], [
#if PHP_VERSION_ID < 40000
#error  this extension requires at least PHP version 4.0.0
#endif
],
[AC_MSG_RESULT(ok)],
[AC_MSG_ERROR([need at least PHP 4.0.0])])

  export CPPFLAGS="$OLD_CPPFLAGS"


  PHP_SUBST(HTML_PARSE_SHARED_LIBADD)
  AC_DEFINE(HAVE_HTML_PARSE, 1, [ ])

  PHP_NEW_EXTENSION(html_parse, html_parse.c , $ext_shared)

fi

