/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2004 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/3_0.txt                                   |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Piotr Klaban <makler@php.net>                                |
  +----------------------------------------------------------------------+

  $Id: php_esmtp.h,v 1.1 2004/09/02 07:34:35 makler Exp $ 
*/

#ifndef PHP_ESMTP_H
#define PHP_ESMTP_H

#if HAVE_LIBESMTP

extern zend_module_entry esmtp_module_entry;
#define phpext_esmtp_ptr &esmtp_module_entry

#ifdef PHP_WIN32
#define PHP_ESMTP_API __declspec(dllexport)
#else
#define PHP_ESMTP_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(esmtp);
PHP_MSHUTDOWN_FUNCTION(esmtp);
PHP_RINIT_FUNCTION(esmtp);
PHP_RSHUTDOWN_FUNCTION(esmtp);
PHP_MINFO_FUNCTION(esmtp);

PHP_METHOD(esmtp_session, init);
PHP_METHOD(esmtp_session, add_message);
PHP_METHOD(esmtp_session, enumerate_messages);
PHP_METHOD(esmtp_session, set_hostname);
PHP_METHOD(esmtp_session, set_server);
PHP_METHOD(esmtp_session, set_timeout);
PHP_METHOD(esmtp_session, option_require_all_recipients);
PHP_METHOD(esmtp_session, set_eventcb);
PHP_METHOD(esmtp_session, set_monitorcb);
PHP_METHOD(esmtp_session, start_session);
PHP_METHOD(esmtp_session, etrn_add_node);
PHP_METHOD(esmtp_session, auth_set_context);
PHP_METHOD(esmtp_session, starttls_enable);
PHP_METHOD(esmtp_message, set_reverse_path);
PHP_METHOD(esmtp_message, add_recipient);
PHP_METHOD(esmtp_message, enumerate_recipients);
PHP_METHOD(esmtp_message, set_header);
PHP_METHOD(esmtp_message, set_header_option);
PHP_METHOD(esmtp_message, set_resent_headers);
PHP_METHOD(esmtp_message, set_messagecb);
PHP_METHOD(esmtp_message, set_message_fp);
PHP_METHOD(esmtp_message, set_message_str);
PHP_METHOD(esmtp_message, message_transfer_status);
PHP_METHOD(esmtp_message, reverse_path_status);
PHP_METHOD(esmtp_message, reset_status);
PHP_METHOD(esmtp_message, deliverby_set_mode);
PHP_METHOD(esmtp_message, dsn_set_ret);
PHP_METHOD(esmtp_message, dsn_set_envid);
PHP_METHOD(esmtp_message, size_set_estimate);
PHP_METHOD(esmtp_message, 8bitmime_set_body);
PHP_METHOD(esmtp_recipient, recipient_status);
PHP_METHOD(esmtp_recipient, recipient_check_complete);
PHP_METHOD(esmtp_recipient, reset_status);
PHP_METHOD(esmtp_recipient, dsn_set_notify);
PHP_METHOD(esmtp_recipient, dsn_set_orcpt);
PHP_METHOD(esmtp_session, etrn_enumerate_nodes);
PHP_METHOD(esmtp_etrnnode, status);
PHP_METHOD(esmtp_session, set_application_data);
PHP_METHOD(esmtp_session, get_application_data);
PHP_METHOD(esmtp_message, set_application_data);
PHP_METHOD(esmtp_message, get_application_data);
PHP_METHOD(esmtp_recipient, set_application_data);
PHP_METHOD(esmtp_recipient, get_application_data);
PHP_METHOD(esmtp_etrnnode, set_application_data);
PHP_METHOD(esmtp_etrnnode, get_application_data);
PHP_METHOD(esmtp_auth, init);
PHP_METHOD(esmtp_auth, set_mechanism_flags);
PHP_METHOD(esmtp_auth, set_mechanism_ssf);
PHP_METHOD(esmtp_auth, get_ssf);
PHP_METHOD(esmtp_auth, set_interact_cb);
PHP_METHOD(esmtp_auth, client_enabled);
PHP_METHOD(esmtp_auth, set_mechanism);
PHP_METHOD(esmtp_auth, mechanism_name);
PHP_METHOD(esmtp_auth, response);
PHP_METHOD(esmtp_auth, set_external_id);
PHP_FUNCTION(smtp_version);
PHP_FUNCTION(smtp_errno);
PHP_FUNCTION(smtp_strerror);
PHP_FUNCTION(smtp_starttls_set_password_cb);

ZEND_BEGIN_MODULE_GLOBALS(esmtp)
	zval *starttls_data;
	zval *eventcb_data;
	zval *messagecb_data;
	zval *authinteractcb_data;
ZEND_END_MODULE_GLOBALS(esmtp)
	
#ifdef ZTS
#define ESMTP_G(v) TSRMG(esmtp_globals_id, zend_esmtp_globals *, v)
#else
#define ESMTP_G(v) (esmtp_globals.v)
#endif

ZEND_DECLARE_MODULE_GLOBALS(esmtp)

#else
#define phpext_esmtp_ptr NULL
#endif /* HAVE_LIBESMTP */
#endif /* _PHP_ESMTP_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */

