/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2004 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/3_0.txt                                   |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Piotr Klaban <makler@php.net>                                |
  +----------------------------------------------------------------------+

  $Id: php_esmtp-php4.h,v 1.1 2004/09/02 07:34:35 makler Exp $ 
*/

#ifndef PHP_ESMTP_H
#define PHP_ESMTP_H

extern zend_module_entry esmtp_module_entry;
#define phpext_esmtp_ptr &esmtp_module_entry

#ifdef PHP_WIN32
#define PHP_ESMTP_API __declspec(dllexport)
#else
#define PHP_ESMTP_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(esmtp);
PHP_MSHUTDOWN_FUNCTION(esmtp);
PHP_RINIT_FUNCTION(esmtp);
PHP_RSHUTDOWN_FUNCTION(esmtp);
PHP_MINFO_FUNCTION(esmtp);

PHP_FUNCTION(smtp_version);
PHP_FUNCTION(smtp_errno);
PHP_FUNCTION(smtp_strerror);
PHP_FUNCTION(smtp_starttls_set_password_cb);
PHP_FUNCTION(smtp_create_session);
PHP_FUNCTION(smtp_add_message);
PHP_FUNCTION(smtp_enumerate_messages);
PHP_FUNCTION(smtp_set_hostname);
PHP_FUNCTION(smtp_set_server);
PHP_FUNCTION(smtp_set_timeout);
PHP_FUNCTION(smtp_option_require_all_recipients);
PHP_FUNCTION(smtp_set_eventcb);
PHP_FUNCTION(smtp_set_monitorcb);
PHP_FUNCTION(smtp_start_session);
PHP_FUNCTION(smtp_etrn_add_node);
PHP_FUNCTION(smtp_auth_set_context);
PHP_FUNCTION(smtp_starttls_enable);
PHP_FUNCTION(smtp_set_reverse_path);
PHP_FUNCTION(smtp_add_recipient);
PHP_FUNCTION(smtp_enumerate_recipients);
PHP_FUNCTION(smtp_set_header);
PHP_FUNCTION(smtp_set_header_option);
PHP_FUNCTION(smtp_set_resent_headers);
PHP_FUNCTION(smtp_set_messagecb);
PHP_FUNCTION(smtp_set_message_fp);
PHP_FUNCTION(smtp_set_message_str);
PHP_FUNCTION(smtp_message_transfer_status);
PHP_FUNCTION(smtp_reverse_path_status);
PHP_FUNCTION(smtp_message_reset_status);
PHP_FUNCTION(smtp_deliverby_set_mode);
PHP_FUNCTION(smtp_dsn_set_ret);
PHP_FUNCTION(smtp_dsn_set_envid);
PHP_FUNCTION(smtp_size_set_estimate);
PHP_FUNCTION(smtp_8bitmime_set_body);
PHP_FUNCTION(smtp_recipient_status);
PHP_FUNCTION(smtp_recipient_check_complete);
PHP_FUNCTION(smtp_recipient_reset_status);
PHP_FUNCTION(smtp_dsn_set_notify);
PHP_FUNCTION(smtp_dsn_set_orcpt);
PHP_FUNCTION(smtp_etrn_enumerate_nodes);
PHP_FUNCTION(smtp_etrn_node_status);
PHP_FUNCTION(smtp_set_application_data);
PHP_FUNCTION(smtp_get_application_data);
PHP_FUNCTION(smtp_message_set_application_data);
PHP_FUNCTION(smtp_message_get_application_data);
PHP_FUNCTION(smtp_recipient_set_application_data);
PHP_FUNCTION(smtp_recipient_get_application_data);
PHP_FUNCTION(smtp_etrn_set_application_data);
PHP_FUNCTION(smtp_etrn_get_application_data);
PHP_FUNCTION(auth_create_context);
PHP_FUNCTION(auth_set_mechanism_flags);
PHP_FUNCTION(auth_set_mechanism_ssf);
PHP_FUNCTION(auth_get_ssf);
PHP_FUNCTION(auth_set_interact_cb);
PHP_FUNCTION(auth_client_enabled);
PHP_FUNCTION(auth_set_mechanism);
PHP_FUNCTION(auth_mechanism_name);
PHP_FUNCTION(auth_response);
PHP_FUNCTION(auth_encode);
PHP_FUNCTION(auth_decode);
PHP_FUNCTION(auth_set_external_id);

ZEND_BEGIN_MODULE_GLOBALS(esmtp)
	zval *starttls_data;
	zval *eventcb_data;
	zval *messagecb_data;
	zval *authinteractcb_data;
ZEND_END_MODULE_GLOBALS(esmtp)
	
#ifdef ZTS
#define ESMTP_G(v) TSRMG(esmtp_globals_id, zend_esmtp_globals *, v)
#else
#define ESMTP_G(v) (esmtp_globals.v)
#endif

ZEND_DECLARE_MODULE_GLOBALS(esmtp)

#endif


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: t
 * End:
 */
