/* $Id: php_colorer.h 8 2005-08-05 10:04:20Z andrey $ */
#ifndef PHP_COLORER_H
#define PHP_COLORER_H

extern zend_module_entry colorer_module_entry;
#define phpext_colorer_ptr &colorer_module_entry

#ifdef PHP_WIN32
#define PHP_COLORER_API __declspec(dllexport)
#else
#define PHP_COLORER_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(colorer);
PHP_MSHUTDOWN_FUNCTION(colorer);
PHP_RINIT_FUNCTION(colorer);
PHP_RSHUTDOWN_FUNCTION(colorer);
PHP_MINFO_FUNCTION(colorer);

PHP_FUNCTION(colorer_list_types);
PHP_FUNCTION(colorer_highlight_string);
PHP_FUNCTION(colorer_highlight_file);
PHP_FUNCTION(colorer_highlight_string_cb);
PHP_FUNCTION(colorer_highlight_file_cb);
PHP_FUNCTION(colorer_open);
PHP_FUNCTION(colorer_type);
PHP_FUNCTION(colorer_hrd_name);
PHP_FUNCTION(colorer_direct_markup);
PHP_FUNCTION(colorer_version);
PHP_FUNCTION(colorer_set_input_encoding);
PHP_FUNCTION(colorer_set_output_encoding);

#ifdef __cplusplus // fix static extension build

#include<colorer/ParserFactory.h>

typedef struct colorer {
	ParserFactory *pf;
	HRCParser *hrc;
    char *typeDescription;
    char *hrdName;
    int inputEncodingIndex;
    int outputEncodingIndex;
	int directMarkup;
	int noEscaping;
	int id;
} colorer_t;

#endif

#ifdef ZTS
#define COLORER_G(v) TSRMG(colorer_globals_id, zend_colorer_globals *, v)
#else
#define COLORER_G(v) (colorer_globals.v)
#endif

#define colorer_pf ((ParserFactory*)COLORER_G(pf))
#define colorer_hrc ((HRCParser*) COLORER_G(hrcParser))

/*
ZEND_BEGIN_MODULE_GLOBALS(colorer)
	void *pf;
	void *hrcParser;
ZEND_END_MODULE_GLOBALS(colorer)
*/


#endif	/* PHP_COLORER_H */


/*
 *  * Local variables:
 *  * tab-width: 4
 *  * c-basic-offset: 4
 *  * indent-tabs-mode: t
 *  * End:
 *  * vim600: noet sw=4 ts=4 fdm=marker
 *  * vim<600: noet sw=4 ts=4
  */

