dnl $Id: config.m4 6 2005-05-02 11:01:40Z andrey $

PHP_ARG_WITH(colorer, for colorer support,
[  --with-colorer[=DIR]             Include colorer support])

if test "$PHP_COLORER" != "no"; then
  SEARCH_PATH="/usr/local /usr"
  SEARCH_FOR="include/colorer/colorer/ParserFactory.h"
  if test -r $PHP_COLORER/$SEARCH_FOR ; then
    AC_MSG_CHECKING([for colorer files in $PHP_COLORER])
    AC_MSG_RESULT(found)
    COLORER_DIR=$PHP_COLORER
  else
    AC_MSG_CHECKING([for colorer files in default path])
    for i in $SEARCH_PATH ; do
      if test -r $i/$SEARCH_FOR; then
        COLORER_DIR=$i
        AC_MSG_RESULT(found in $i)
      fi
    done
  fi

  if test -z "$COLORER_DIR"; then
    AC_MSG_RESULT([not found])
    AC_MSG_ERROR([Please reinstall the colorer distribution!])
  fi

  # --with-colorer -> add include path
  PHP_ADD_INCLUDE($COLORER_DIR/include/colorer)
AC_LANG_CPLUSPLUS
CPPFLAGS="$CPPFLAGS -I$COLORER_DIR/include/colorer"
    AC_TRY_COMPILE([
#include<colorer/editor/BaseEditor.h>
        ],
        [
BaseEditor e(0,0);
e.validate(-1,false);
],
        [
          AC_DEFINE(VALIDATE_ACCEPTS_2, 1, [ ])
        ],[
          AC_DEFINE(VALIDATE_ACCEPTS_2, 0, [ ])
        ]
)
AC_LANG_C

  PHP_ADD_LIBRARY_WITH_PATH(colorer, $COLORER_DIR/lib, COLORER_SHARED_LIBADD)
  PHP_ADD_LIBRARY(stdc++, , COLORER_SHARED_LIBADD)
  AC_DEFINE(HAVE_COLORERLIB,1,[ ])
  PHP_SUBST(COLORER_SHARED_LIBADD)
  LDFLAGS="$LDFLAGS $ld_runpath_switch$COLORER_DIR/lib -L$COLORER_DIR/lib"
  
  PHP_REQUIRE_CXX
  PHP_NEW_EXTENSION(colorer, colorer.cpp, $ext_shared)

fi
