/*
   +----------------------------------------------------------------------+
   | PHP Versions 4 and 5                                                 |
   +----------------------------------------------------------------------+
   | Copyright (c) 2004-2005 Andrey Demenev                               |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3 of the PHP license,         |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/3_0.txt.                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Andrey Demenev <demenev@gmail.com>                           |
   +----------------------------------------------------------------------+
 */

/* $Id: colorer.cpp 9 2005-08-05 10:13:32Z andrey $ */

/* {{{ includes */
#include<colorer/ParserFactory.h>
#include<colorer/editor/BaseEditor.h>
#include<common/io/FileWriter.h>
#include<colorer/viewer/ParsedLineWriter.h>
#include "colorer.h"
#include "linewriter.h"

extern "C" {
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "php_colorer.h"
}
				   /* }}} */// ZEND_DECLARE_MODULE_GLOBALS(colorer)/*             Internal function protos             *//* internal function protos {{{ */
	static void _colorer_list_dtor(zend_rsrc_list_entry * rsrc TSRMLS_DC);
static char *colorer_get_version();
static int colorer_do_highlight(INTERNAL_FUNCTION_PARAMETERS,
								colorer_t * colorer, LineStore * source,
								String * fileName, String * outFile,
								char *ftype, zval * callback);
//static PHP_INI_MH(OnPreloadUpdate);
/* }}} */

/*   Standard module declarations          */

/* True global resources - no need for thread safety here *//* {{{ */
static int le_colorer;
static zend_class_entry *colorer_class_entry_ptr;
/* }}} */

zend_function_entry colorer_functions[] = {	/* {{{ */
	PHP_FE(colorer_set_input_encoding, NULL)
		PHP_FE(colorer_set_output_encoding, NULL)
		PHP_FE(colorer_list_types, NULL)
		PHP_FE(colorer_highlight_string, NULL)
		PHP_FE(colorer_highlight_file, NULL)
		PHP_FE(colorer_highlight_string_cb, NULL)
		PHP_FE(colorer_highlight_file_cb, NULL)
		PHP_FE(colorer_open, NULL)
		PHP_FE(colorer_type, NULL)
		PHP_FE(colorer_hrd_name, NULL)
		PHP_FE(colorer_direct_markup, NULL)
		PHP_FE(colorer_version, NULL) {NULL, NULL, NULL}
};

/* }}} */

static zend_function_entry colorer_class_functions[] =	/* {{{ */
{
	PHP_FALIAS(setinputencoding, colorer_set_input_encoding, NULL)
	PHP_FALIAS(setoutputencoding, colorer_set_output_encoding, NULL)
	PHP_FALIAS(listtypes, colorer_list_types, NULL)
	PHP_FALIAS(highlightstring, colorer_highlight_string, NULL)
	PHP_FALIAS(highlightfile, colorer_highlight_file, NULL)
	PHP_FALIAS(highlightstringcb, colorer_highlight_string_cb, NULL)
	PHP_FALIAS(highlightfilecb, colorer_highlight_file_cb, NULL)
	PHP_FALIAS(open, colorer_open, NULL)
	PHP_FALIAS(type, colorer_type, NULL)
	PHP_FALIAS(hrdname, colorer_hrd_name, NULL)
	PHP_FALIAS(directmarkup, colorer_direct_markup, NULL)
	PHP_FALIAS(version, colorer_version, NULL) {NULL, NULL, NULL}
};

/* }}} */

zend_module_entry colorer_module_entry =	/* {{{ */
{
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"colorer",
	colorer_functions,
	PHP_MINIT(colorer),
	PHP_MSHUTDOWN(colorer),
	PHP_RINIT(colorer),			/* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(colorer),		/* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(colorer),
#if ZEND_MODULE_API_NO >= 20010901
	"0.1",						/* Replace with version number for your extension */
#endif
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_COLORER
extern "C" {
	ZEND_GET_MODULE(colorer)
}
#endif
/* }}} */

/* Standard module functions */

/* {{{ PHP_MINIT_FUNCTION */ 
PHP_MINIT_FUNCTION(colorer)
{
	zend_class_entry colorer_class_entry;
	/*
	   ZEND_INIT_MODULE_GLOBALS(colorer, php_colorer_init_globals, NULL);
	   REGISTER_INI_ENTRIES();
	 */
	INIT_CLASS_ENTRY(colorer_class_entry, "colorer",
					 colorer_class_functions);
	colorer_class_entry_ptr =
		zend_register_internal_class(&colorer_class_entry TSRMLS_CC);
	le_colorer =
		zend_register_list_destructors_ex(_colorer_list_dtor, NULL,
										  "colorer resource",
										  module_number);
}

/* }}} */

/* {{{ PHP_MSHUTDOWN_FUNCTION */
PHP_MSHUTDOWN_FUNCTION(colorer)
{
	/* uncomment this line if you have INI entries
	   UNREGISTER_INI_ENTRIES();
	 */
	return SUCCESS;
}

/* }}} */

/* {{{ PHP_RINIT_FUNCTION */
PHP_RINIT_FUNCTION(colorer)
{
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_RSHUTDOWN_FUNCTION */
PHP_RSHUTDOWN_FUNCTION(colorer)
{
	return SUCCESS;
}

/* }}} */

/* {{{ PHP_MINFO_FUNCTION */
PHP_MINFO_FUNCTION(colorer)
{
	php_info_print_table_start();
	php_info_print_table_row(2, "colorer support", "enabled");
	php_info_print_table_row(2, "colorer version", colorer_get_version());
	php_info_print_table_row(2, "colorer extension version",
							 "$Id: colorer.cpp 9 2005-08-05 10:13:32Z andrey $");
	php_info_print_table_end();

}

/* }}} */

/* Helper classes */

/* {{{ LineStore */
void LineStore::replaceTabs(int lno)
{
	String *od =
		lines.elementAt(lno)->replace(DString("\t"), DString("    "));
	delete lines.elementAt(lno);
	lines.setElementAt(od, lno);
}

LineStore::LineStore()
{
	fileName = null;
}

LineStore::~LineStore()
{
	freeFile();
}

void LineStore::freeFile()
{
	delete fileName;
	fileName = null;
	for (int i = 0; i < lines.size(); i++) {
		delete lines.elementAt(i);
	}
	lines.setSize(0);
}

void LineStore::loadFile(const String * fileName, int ei, bool tab2spaces)
{
	if (this->fileName != null) {
		freeFile();
	}
	if (fileName == null) {
		throw Exception(StringBuffer("can't find 'null' file"));
	}
	this->fileName = new SString(fileName);
	InputSource *is = InputSource::newInstance(fileName);

	const byte *data;
	try {
		data = is->openStream();
	} catch(InputSourceException & e) {
		delete is;
		throw e;
	}

	int len = is->length();

	if (ei == -1)
		ei = Encodings::getDefaultEncodingIndex();
	DString file(data, len, ei);
	int length = file.length();
	lines.ensureCapacity(length / 30);

	int i = 0;
	int filepos = 0;
	int prevpos = 0;
	if (length && file[0] == 0xFEFF) {
		filepos = prevpos = 1;
	}
	while (filepos < length + 1) {
		if (filepos == length || file[filepos] == '\r'
			|| file[filepos] == '\n') {
			lines.
				addElement(new SString(&file, prevpos, filepos - prevpos));
			if (tab2spaces) {
				replaceTabs(lines.size() - 1);
			}
			if (filepos + 1 < length && file[filepos] == '\r'
				&& file[filepos + 1] == '\n') {
				filepos++;
			} else if (filepos + 1 < length && file[filepos] == '\n'
					   && file[filepos + 1] == '\r') {
				filepos++;
			}
			prevpos = filepos + 1;
			i++;
		}
		filepos++;
	}
	delete is;
}

const String *LineStore::getFileName()
{
	return fileName;
}

String *LineStore::getLine(int lno)
{
	if (lines.size() <= lno) {
		return null;
	}
	return lines.elementAt(lno);
}

int LineStore::getLineCount()
{
	return lines.size();
}


void LineStore::loadString(const String * str, bool tab2spaces)
{
	freeFile();
	int length = str->length();
	lines.ensureCapacity(length / 30);

	int i = 0;
	int strpos = 0;
	int prevpos = 0;
	if (length && (*str)[0] == 0xFEFF) {
		strpos = prevpos = 1;
	}
	while (strpos < length + 1) {
		if (strpos == length || (*str)[strpos] == '\r'
			|| (*str)[strpos] == '\n') {
			lines.addElement(new SString(str, prevpos, strpos - prevpos));
			if (tab2spaces) {
				replaceTabs(lines.size() - 1);
			}
			if (strpos + 1 < length && (*str)[strpos] == '\r'
				&& (*str)[strpos + 1] == '\n') {
				strpos++;
			} else if (strpos + 1 < length && (*str)[strpos] == '\n'
					   && (*str)[strpos + 1] == '\r') {
				strpos++;
			}
			prevpos = strpos + 1;
			i++;
		}
		strpos++;
	}
}

/* }}} */

/* {{{ ColorerWriter */
ColorerWriter::ColorerWriter(int encoding)
{
	if (encoding == -1)
		encoding = Encodings::getDefaultEncodingIndex();
	encodingIndex = encoding;
};
void ColorerWriter::write(wchar c)
{
	char buf[8];
	int bufLen = Encodings::toBytes(encodingIndex, c, (byte *) buf);
	for (int pos = 0; pos < bufLen; pos++)
		PUTC(buf[pos]);
};

/* }}} */

/* HtmlEscapedWriter {{{ */
HtmlEscapedWriter::HtmlEscapedWriter(Writer * writer)
{
	this->writer = writer;
}

void HtmlEscapedWriter::write(wchar c)
{
	if (c == '&') {
		writer->write(DString("&amp;"));
	} else if (c == '<') {
		writer->write(DString("&lt;"));
	} else if (c == '>') {
		writer->write(DString("&gt;"));
	} else {
		writer->write(c);
	}
}

/* }}} */

/* Internal functions */

static void _colorer_list_dtor(zend_rsrc_list_entry * rsrc TSRMLS_DC) /* {{{ */
{
	colorer_t *colorer = (colorer_t *) rsrc->ptr;
	if (colorer->typeDescription != NULL) {
		efree(colorer->typeDescription);
	}
	if (colorer->hrdName != NULL) {
		efree(colorer->hrdName);
	}
	if (colorer->pf) {
		delete colorer->pf;
	}
	efree(colorer);
}

/* }}} */

static int colorer_get_resource(zval * obj, colorer_t ** colorer TSRMLS_DC) /* {{{ */
{
	zval **id;
	int resource_type;

	if (Z_TYPE_P(obj) != IS_OBJECT
		|| zend_hash_find(Z_OBJPROP_P(obj), "id", sizeof("id"),
						  (void **) & id) == FAILURE) {
		php_error(E_WARNING, "cannot find colorer resource id");
		return 0;
	}
	*colorer = (colorer_t *) zend_list_find(Z_LVAL_PP(id), &resource_type);
	if (!*colorer || (resource_type != le_colorer)) {
		php_error(E_WARNING, "colorer id not found");
		return 0;
	}
	return Z_LVAL_PP(id);
}

/* }}} */

FileType *detectType(HRCParser * hrcParser, String * fileName,	/* ... {{{ */
					 String * fline)
{
	FileType *type;
	type = hrcParser->chooseFileType(fileName, fline, 0);
	return type;
}

/* }}} */

static void colorer_highligh_file_or_string(INTERNAL_FUNCTION_PARAMETERS,	/* ... {{{ */
											int is_file, int use_callback)
{
	char *file_or_str = null, *type = null;
	zval *callback = null, *myself = getThis();
	zend_bool ret = false;
	colorer_t *colorer;
	char *real_type = null;
	int cl_result;
	String *fileName = null;
	char *callback_name;
	int dummy = 0;

	int na = ZEND_NUM_ARGS();

	if (myself != NULL) {
		if (use_callback) {
			if (zend_parse_parameters
				(na TSRMLS_CC, "sz|s", &file_or_str, &dummy, &callback,
				 &type, &dummy) == FAILURE) {
				RETURN_FALSE;
			}
		} else {
			if (zend_parse_parameters
				(na TSRMLS_CC, "s|sb", &file_or_str, &dummy, &type, &dummy,
				 &ret) == FAILURE) {
				RETURN_FALSE;
			}
		}
	} else {
		if (use_callback) {
			if (zend_parse_parameters
				(na TSRMLS_CC, "Osz|s", &myself, colorer_class_entry_ptr,
				 &file_or_str, &dummy, &callback, &type,
				 &dummy) == FAILURE) {
				RETURN_FALSE;
			}
		} else {
			if (zend_parse_parameters
				(na TSRMLS_CC, "Os|sb", &myself, colorer_class_entry_ptr,
				 &file_or_str, &dummy, &type, &dummy, &ret) == FAILURE) {
				RETURN_FALSE;
			}
		}
	}
	if (!colorer_get_resource(myself, &colorer TSRMLS_CC)) {
		RETURN_FALSE;
	}

	if (use_callback) {
		if (!zend_is_callable(callback, 0, &callback_name)) {
			php_error(E_WARNING,
					  "%s argument is expected to be a valid callback : %s",
					  myself ? "First" : "Second", callback_name);
			efree(callback_name);
			RETURN_FALSE;
		}
	}



	if (type != null) {
		if (strlen(type)) {
			real_type = type;
		}
	}
	String *file_or_string = new SString(file_or_str);
	LineStore *source = new LineStore;
	if (is_file) {
		if (PG(safe_mode)
			&& !php_checkuid(file_or_str, NULL,
							 CHECKUID_CHECK_FILE_AND_DIR)) {
			delete source;
			delete file_or_string;
			RETURN_FALSE;
		}

		if (php_check_open_basedir(file_or_str TSRMLS_CC)) {
			delete source;
			delete file_or_string;
			RETURN_FALSE;
		}

		try {
			source->loadFile(file_or_string, colorer->inputEncodingIndex,
							 1);
		}
		catch(InputSourceException & e) {
			delete source;
			delete file_or_string;
			php_error(E_WARNING, "%s", e.getMessage()->getChars());
			RETURN_FALSE;
		}

	} else {
		source->loadString(file_or_string, 1);
	}

	if (is_file) {
		fileName = new SString(file_or_string);
	}

	if (ret) {
		php_start_ob_buffer(NULL, 0, 1 TSRMLS_CC);
	}
	cl_result =
		colorer_do_highlight(INTERNAL_FUNCTION_PARAM_PASSTHRU, colorer,
							 source, fileName, null, real_type, callback);
	delete source;
	delete file_or_string;
	if (ret) {
		if (cl_result == SUCCESS) {
			php_ob_get_buffer(return_value TSRMLS_CC);
		} else {
			php_end_ob_buffer(0, 0 TSRMLS_CC);
			RETURN_FALSE;
		}
		php_end_ob_buffer(0, 0 TSRMLS_CC);
		return;
	} else {
		if (cl_result == SUCCESS) {
			RETURN_TRUE;
		}
	}
	RETURN_FALSE;
}

/* }}} */

static int colorer_do_highlight(INTERNAL_FUNCTION_PARAMETERS,  /* ... {{{ */
								colorer_t * colorer, LineStore * source,
								String * fileName, String * outFile,
								char *ftype, zval * callback)
{
	int retval = SUCCESS;
	try {
		String *hrdName = null, *typeDescription = null;
		FileType *type = null;
		if (colorer->hrdName == null) {
			hrdName = new DString("default");
		} else {
			hrdName = new DString(colorer->hrdName);
		}

		bool useMarkup = false;
		RegionMapper *mapper = null;
		if (colorer->hrdName == null) {
			hrdName = new DString("default");
		} else {
			hrdName = new DString(colorer->hrdName);
		}
		if (colorer->directMarkup) {
			try {
				String *classId = new DString("rgb");
				mapper = colorer->pf->createStyledMapper(classId, hrdName);
				delete classId;
			}
			catch(ParserFactoryException & e) {
				try {
					mapper = colorer->pf->createTextMapper(hrdName);
					useMarkup = true;
				}
				catch(Exception & e) {
					php_error(E_WARNING, "%s", e.getMessage()->getChars());
				}
			};
		};
		BaseEditor baseEditor(colorer->pf, source);
		baseEditor.setRegionCompact(true);
		baseEditor.setRegionMapper(mapper);
		baseEditor.lineCountEvent(source->getLineCount());

		if (ftype) {
			typeDescription = new SString(ftype);
			type = colorer->hrc->getFileType(typeDescription);
			delete typeDescription;
		} else if (colorer->typeDescription) {
			typeDescription = new SString(colorer->typeDescription);
			type = colorer->hrc->getFileType(typeDescription);
			delete typeDescription;
		}
		if (type == null) {
			if (colorer->typeDescription) {
				php_error(E_WARNING,
						  "Unknown file type \"%s\" - autodetection performed",
						  colorer->typeDescription);
			}
			type = detectType(colorer->hrc, fileName, source->getLine(0));
		}

		baseEditor.setFileType(type);
#if VALIDATE_ACCEPTS_2
		baseEditor.validate(-1, false);
#else
		baseEditor.validate(-1);
#endif

		const RegionDefine *rd = null;
		if (mapper != null)
			rd = baseEditor.rd_def_Text;

		Writer *escapedWriter = null;
		Writer *commonWriter = null;
		if (callback == null) {
			try {
				if (outFile == null) {
					commonWriter =
						new ColorerWriter(colorer->outputEncodingIndex);
				} else {
					commonWriter =
						new FileWriter(outFile,
									   colorer->outputEncodingIndex, 0);
				}
				if (!colorer->noEscaping)
					escapedWriter = new HtmlEscapedWriter(commonWriter);
				else
					escapedWriter = commonWriter;
			}
			catch(Exception & e) {
				php_error(E_WARNING, "can't open file '%s' for writing:\n",
						  outFile->getChars());
				php_error(E_WARNING, e.getMessage()->getChars());
				return FAILURE;
			}
		}

		Hashtable < String * >*docLinkHash = new Hashtable < String * >;
		for (int i = 0; i < source->getLineCount(); i++) {
			if (callback == null) {
				if (!colorer->directMarkup) {
					LineWriter::tokenWrite(commonWriter, escapedWriter,
										   docLinkHash, source->getLine(i),
										   baseEditor.getLineRegions(i));
				} else if (useMarkup) {
					LineWriter::markupWrite(commonWriter, escapedWriter,
											docLinkHash,
											source->getLine(i),
											baseEditor.getLineRegions(i));
				} else {
					LineWriter::htmlRGBWrite(commonWriter, escapedWriter,
											 docLinkHash,
											 source->getLine(i),
											 baseEditor.getLineRegions(i));
				};
				commonWriter->write(DString("\n"));
			} else {
				int pos = 0;
				pval param1, param2;
				pval *params[2];
				pval ret_val;
				int status;

				params[0] = &param1;
				params[1] = &param2;

				byte *text;
				StringBuffer *line = new StringBuffer(source->getLine(i));
				int substrlen;
				*line += PHP_EOL;
				for (LineRegion * l1 = baseEditor.getLineRegions(i); l1;
					 l1 = l1->next) {
					if (l1->special || l1->region == null)
						continue;
					if (l1->start == l1->end)
						continue;
					int end = l1->end;
					if (end == -1)
						end = line->length();
					if (l1->start > pos) {
						ZVAL_EMPTY_STRING(&param1);
						SString substr(line, pos, l1->start - pos);
						substrlen =
							substr.getBytes(&text,
											colorer->outputEncodingIndex);
						ZVAL_STRINGL(&param2, (char *) text, substrlen, 0);
						if (call_user_function
							(EG(function_table), NULL, callback, &ret_val,
							 2, params TSRMLS_CC) != SUCCESS) {
							retval = FAILURE;
							break;
						}
						pos = l1->start;
					}
					String *Token =
						l1->region->getName()->replace(DString(":"),
													   DString("_"));
					SString substr(line, pos, end - l1->start);
					substrlen =
						substr.getBytes(&text,
										colorer->outputEncodingIndex);
					ZVAL_STRINGL(&param2, (char *) text, substrlen, 0);
					ZVAL_STRINGL(&param1, (char *) Token->getChars(),
								 Token->length(), 0);
					if (call_user_function
						(EG(function_table), NULL, callback, &ret_val, 2,
						 params TSRMLS_CC) != SUCCESS) {
						delete Token;
						retval = FAILURE;
						break;
					}
					delete Token;
					pos += end - l1->start;
				}
				if (retval == FAILURE) {
					break;
				}
			}
		}
		delete docLinkHash;
		if (!colorer->noEscaping) {
			delete escapedWriter;
		}
		delete commonWriter;
		delete hrdName;
	}
	catch(Exception & e) {
		php_error(E_WARNING, "%s", e.getMessage()->getChars());
		return FAILURE;
	}
	catch(...) {
		php_error(E_WARNING, "unknown exception ...");
		return FAILURE;
	}
	return retval;
}

/* }}} */

static char *colorer_get_version() /* {{{ */
{
	char *ret;
	ParserFactory *pf;

	pf = new ParserFactory;
	try {
		ret = (char *) pf->getVersion();
		delete pf;
		return ret;
	}
	catch(Exception & e) {
		delete pf;
		php_error(E_WARNING, "%s", e.getMessage()->getChars());
		return "";
	}
}

/* }}} */

/*  Module functions */

/* {{{ proto object colorer_open()
 * Creates a colorer object  */
PHP_FUNCTION(colorer_open)
{
	zval *myself = getThis();
	colorer_t *colorer = NULL;


	colorer = (colorer_t *) emalloc(sizeof(colorer_t));
	memset(colorer, 0, sizeof(colorer_t));
	colorer->id = zend_list_insert(colorer, le_colorer);
	colorer->pf = new ParserFactory;
	colorer->hrc = (colorer->pf)->getHRCParser();
	colorer->inputEncodingIndex = -1;
	colorer->outputEncodingIndex = -1;

	if (myself == NULL) {
		object_init_ex(return_value, colorer_class_entry_ptr);
		add_property_resource(return_value, "id", colorer->id);
	} else {
		zval_dtor(myself);
		object_init_ex(myself, colorer_class_entry_ptr);
		add_property_resource(myself, "id", colorer->id);
		RETURN_TRUE;
	}
}

/* }}} */

/* {{{ proto string colorer_highlight_string(string str [, string type='' [, bool ret=false]]) 
 *  * Highlights code and prints or returns output */
PHP_FUNCTION(colorer_highlight_string)
{
	colorer_highligh_file_or_string(INTERNAL_FUNCTION_PARAM_PASSTHRU, 0,
									0);
}

/* }}} */

/* {{{ proto string colorer_highlight_string_cb (string str, callback cb [, string type = '']) 
 *  * Parses string and calls a UDF for each token */
PHP_FUNCTION(colorer_highlight_string_cb)
{
	colorer_highligh_file_or_string(INTERNAL_FUNCTION_PARAM_PASSTHRU, 0,
									1);
}

/* }}} */

/* {{{ proto string colorer_highlight_file_cb (string filename, callback cb [, string type = ''])
 *  * Parses file contents and calls a UDF for each token */
PHP_FUNCTION(colorer_highlight_file_cb)
{
	colorer_highligh_file_or_string(INTERNAL_FUNCTION_PARAM_PASSTHRU, 1,
									1);
}

/* }}} */

/* {{{ proto string colorer_highlight_file(string filename [, string type='' [, bool ret=false]])
 *  * Highlights contents of a file and prints or returns output */
PHP_FUNCTION(colorer_highlight_file)
{
	colorer_highligh_file_or_string(INTERNAL_FUNCTION_PARAM_PASSTHRU, 1,
									0);
}

/* }}} */

/* {{{ proto string colorer_version (void)
 *  *    Returns colorer library version */
PHP_FUNCTION(colorer_version)
{
	RETURN_STRING(colorer_get_version(), 1);
}

/* }}} */

/* {{{ proto bool colorer_direct_markup([bool value])
 *  * Returns current value of direct markup flag and optionally sets new value */
PHP_FUNCTION(colorer_direct_markup)
{
	zval *myself = getThis();
	zend_bool value = false, abool = false;
	colorer_t *colorer;

	int na = ZEND_NUM_ARGS();

	if (myself != NULL) {
		if (zend_parse_parameters(na TSRMLS_CC, "|b", &value) == FAILURE) {
			RETURN_FALSE;
		}
		if (na > 0)
			abool = true;
	} else {
		if (zend_parse_parameters
			(na TSRMLS_CC, "O|b", &myself, colorer_class_entry_ptr,
			 &value) == FAILURE) {
			RETURN_FALSE;
		}
		if (na > 1)
			abool = true;
	}
	if (!colorer_get_resource(myself, &colorer TSRMLS_CC)) {
		RETURN_FALSE;
	}
	if (!abool) {
		RETURN_BOOL(colorer->directMarkup);
	}
	abool = colorer->directMarkup;
	colorer->directMarkup = value;
	RETURN_BOOL(abool);
}

/* }}} */

/* {{{ proto string colorer_hrd_name([string hrd_name])
 *  * Returns current HRD setting and optionally sets a new value */
PHP_FUNCTION(colorer_hrd_name)
{
	zval *myself = getThis();
	char *hrd_name = null;
	int dummy = 0;
	colorer_t *colorer;

	int na = ZEND_NUM_ARGS();

	if (myself != NULL) {
		if (zend_parse_parameters(na TSRMLS_CC, "|s", &hrd_name, &dummy) ==
			FAILURE) {
			RETURN_FALSE;
		}
	} else {
		if (zend_parse_parameters
			(na TSRMLS_CC, "O|s", &myself, &colorer_class_entry_ptr,
			 &hrd_name, &dummy) == FAILURE) {
			RETURN_FALSE;
		}
	}
	if (!colorer_get_resource(myself, &colorer TSRMLS_CC)) {
		RETURN_FALSE;
	}
	if (hrd_name == NULL) {
		RETURN_STRING(colorer->hrdName, 1);
	}
	if (colorer->hrdName) {
		RETVAL_STRING(colorer->hrdName, 1);
	} else {
		RETVAL_STRING("", 1);
	}
	if (colorer->hrdName != NULL) {
		efree(colorer->hrdName);
	}
	if (dummy) {
		colorer->hrdName = estrndup(hrd_name, dummy);
	} else {
		colorer->hrdName = NULL;
	}
}

/* }}} */

/* {{{ proto string colorer_type([string type]) 
 *  * Returns current file type and optionally sets new value */
PHP_FUNCTION(colorer_type)
{
	zval *myself = getThis();
	char *type = null;
	int dummy = 0;
	colorer_t *colorer;

	int na = ZEND_NUM_ARGS();

	if (myself != NULL) {
		if (zend_parse_parameters(na TSRMLS_CC, "|s", &type, &dummy) ==
			FAILURE) {
			RETURN_FALSE;
		}
	} else {
		if (zend_parse_parameters
			(na TSRMLS_CC, "O|s", &myself, &colorer_class_entry_ptr, &type,
			 &dummy) == FAILURE) {
			RETURN_FALSE;
		}
	}
	if (!colorer_get_resource(myself, &colorer TSRMLS_CC)) {
		RETURN_FALSE;
	}
	if (type == NULL) {
		RETURN_STRING(colorer->typeDescription, 1);
	}
	if (colorer->typeDescription) {
		RETVAL_STRING(colorer->typeDescription, 1);
	} else {
		RETVAL_STRING("", 1);
	}
	if (colorer->typeDescription != NULL) {
		efree(colorer->typeDescription);
	}
	if (dummy) {
		colorer->typeDescription = estrndup(type, dummy);
	} else {
		colorer->typeDescription = NULL;
	}
}

/* }}} */

/* {{{ proto array colorer_list_types(void)
 *    Return list of suppported syntaxes */
PHP_FUNCTION(colorer_list_types)
{
	char *str;
	zval *element;
	int idx, len;
	ParserFactory *pf;
	HRCParser *hrc;

	pf = new ParserFactory;
	hrc = pf->getHRCParser();
	try {
		if (array_init(return_value) == FAILURE) {
			delete pf;
			RETURN_FALSE;
		}
		for (idx = 0;; idx++) {
			FileType *type = hrc->enumerateFileTypes(idx);
			if (type == null)
				break;
			ALLOC_ZVAL(element);
			array_init(element);
			len = type->getName()->length();
			add_index_stringl(element, 0,
							  (char *) type->getName()->getChars(), len,
							  1);
			len = type->getGroup()->length();
			add_index_stringl(element, 1,
							  (char *) type->getGroup()->getChars(), len,
							  1);
			len = type->getDescription()->length();
			add_index_stringl(element, 2,
							  (char *) type->getDescription()->getChars(),
							  len, 1);
			add_index_zval(return_value, idx, element);
		}
		delete pf;
	} catch(Exception & e) {
		php_error(E_WARNING, "%s", e.getMessage()->getChars());
		RETURN_FALSE;
	};
}

/* }}} */

/* {{{ proto bool colorer_set_input_encoding(string encoding)
 * Set incoding of source text */
PHP_FUNCTION(colorer_set_input_encoding)
{

	zval *myself = getThis();
	colorer_t *colorer;
	char *str;
	int str_len;
	String *inputEncoding;
	int inputEncodingIndex;

	int na = ZEND_NUM_ARGS();

	if (myself != NULL) {
		if (zend_parse_parameters(na TSRMLS_CC, "s", &str, &str_len) ==
			FAILURE) {
			RETURN_FALSE;
		}
	} else {
		if (zend_parse_parameters
			(na TSRMLS_CC, "Os", &myself, &colorer_class_entry_ptr, &str,
			 &str_len) == FAILURE) {
			RETURN_FALSE;
		}
	}
	if (!colorer_get_resource(myself, &colorer TSRMLS_CC)) {
		RETURN_FALSE;
	}

	inputEncoding = new SString(DString(str));
	inputEncodingIndex =
		Encodings::getEncodingIndex(inputEncoding->getChars());
	delete inputEncoding;
	if (inputEncodingIndex == -1) {
		RETURN_FALSE;			// unknown input encoding
	}
	colorer->inputEncodingIndex = inputEncodingIndex;
	if (colorer->outputEncodingIndex == -1)
		colorer->outputEncodingIndex = inputEncodingIndex;
	RETURN_TRUE;
}

/* }}} */

/* {{{ proto bool colorer_set_output_encoding(string encoding)
 * Set output incoding */
PHP_FUNCTION(colorer_set_output_encoding)
{

	zval *myself = getThis();
	colorer_t *colorer;
	char *str;
	int str_len;
	String *Encoding;
	int EncodingIndex;

	int na = ZEND_NUM_ARGS();

	if (myself != NULL) {
		if (zend_parse_parameters(na TSRMLS_CC, "s", &str, &str_len) ==
			FAILURE) {
			RETURN_FALSE;
		}
	} else {
		if (zend_parse_parameters
			(na TSRMLS_CC, "Os", &myself, &colorer_class_entry_ptr, &str,
			 &str_len) == FAILURE) {
			RETURN_FALSE;
		}
	}
	if (!colorer_get_resource(myself, &colorer TSRMLS_CC)) {
		RETURN_FALSE;
	}

	Encoding = new SString(DString(str));
	EncodingIndex = Encodings::getEncodingIndex(Encoding->getChars());
	delete Encoding;
	if (EncodingIndex == -1) {
		RETURN_FALSE;			// unknown input encoding
	}
	colorer->outputEncodingIndex = EncodingIndex;
	RETURN_TRUE;
}

/* }}} */

/*
 *  * Local variables:
 *  * tab-width: 4
 *  * c-basic-offset: 4
 *  * End:
 *  * vim600: noet sw=4 ts=4 fdm=marker
 *  * vim<600: noet sw=4 ts=4
 *  */
