<?php

/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Phalcon\Test\Unit\Crypt;

use Phalcon\Crypt;
use UnitTester;

class GetSetAuthTagCest
{
    /**
     * Unit Tests Phalcon\Crypt :: getAuthTag()/setAuthTag()
     *
     * @author Phalcon Team <team@phalcon.io>
     * @since  2020-02-16
     */
    public function cryptGetSetAuthTag(UnitTester $I)
    {
        $I->wantToTest('Crypt - getAuthTag()/setAuthTag()');

        $crypt = new Crypt();

        $crypt->setAuthTag('test-tag');

        $I->assertEquals(
            'test-tag',
            $crypt->getAuthTag()
        );
    }
}
