<?php
declare(strict_types=1);

/**
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalconphp.com>
 *
 * For the full copyright and license information, please view the LICENSE.txt
 * file that was distributed with this source code.
 */

namespace Phalcon\Test\Unit\Image\Adapter\Gd;

use Phalcon\Image\Adapter\Gd;
use Phalcon\Test\Fixtures\Traits\GdTrait;
use UnitTester;

class RenderCest
{
    use GdTrait;

    /**
     * Tests Phalcon\Image\Adapter\Gd :: render()
     *
     * @author Phalcon Team <team@phalconphp.com>
     * @since  2018-11-13
     */
    public function imageAdapterGdRender(UnitTester $I)
    {
        $I->wantToTest('Image\Adapter\Gd - render()');

        $params = [
            'jpg' => [130699, 'fbf9f3e3c3c18183'],
            'png' => [8802, '30787c3c1e181818'],
        ];

        foreach ($this->getImages() as $type => $imagePath) {
            $image = new Gd(
                $imagePath
            );

            list($lenght, $hash) = $params[$type];

            $I->assertSame($lenght, mb_strlen($image->render()));

            $I->assertTrue(
                $this->checkImageHash($imagePath, $hash)
            );
        }
    }
}
