/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using PostgreSql.Data.NPgClient;
using PostgreSql.Data.PgSqlClient.DbSchema;

namespace PostgreSql.Data.PgSqlClient
{
	public delegate void PgInfoMessageEventHandler(object sender, PgInfoMessageEventArgs e);

	public sealed class PgInfoMessageEventArgs : EventArgs
	{
		private PgErrorCollection errors	= new PgErrorCollection();
		private string			  message	= String.Empty;

		public PgErrorCollection Errors
		{
			get { return errors; }
		}

		public string Message
		{
			get { return message; }
		}

		internal PgInfoMessageEventArgs(PgClientException ex)
		{
			this.message = ex.Message;
			
			foreach (PgClientError error in ex.Errors)
			{
				PgError newError = new PgError();

				newError.Severity	= error.Severity;
				newError.Code		= error.Code;
				newError.Message	= error.Message;
				newError.Detail		= error.Detail;
				newError.Hint		= error.Hint;
				newError.Line		= error.Line;
				newError.Where		= error.Where;
				newError.Position	= error.Position;
				newError.Routine	= error.Routine;

				errors.Add(newError);
			}
		}
	}
}