C*GRGETC -- read a single character from keyboard (VMS)
C+
      INTEGER FUNCTION GRGETC (CHAN)
C
C Read a single character from the controlling keyboard, no echo.
C Normal ASCII characters are returned as the corresponding integer
C codes. Escape sequences generated by the VT100 are recognised and
C returned as negative integer codes.  Some characters (eg control-U,
C control-R, delete, control-C, control-Y) are normally intercepted
C by the operating system and cannot be read with GRGETC.
C
C Argument:
C
C CHAN (input, integer): the channel number assigned to the terminal;
C      this must have been previously assigned by SYS$ASSIGN.
C
C Returns:
C
C GRGETC (integer): either a positive number (0-127) equal to
C      the ASCII code of the character read, or a negative number, as
C      follows, if one of the VT100 escape sequences has been read:
C       UP ARROW, DOWN ARROW, RIGHT ARROW, LEFT ARROW: -1,-2,-3,-4;
C       PF1, PF2, PF3, PF4: -11,-12,-13,-14.
C      If the terminal is in "alternate keypad mode", the following
C      codes are generated by typing the keypad keys:
C       Keypad digits 0 through 9: -20 through -29;
C       Keypad ENTER: -8;
C       Keypad comma, minus, period: -16,-17,-18.
C      If an unrecognized escape sequence is received, GRGETC is set
C       to zero.
C--
C (7-Feb-1983)
C-----------------------------------------------------------------------
      INCLUDE '($IODEF)'
      INCLUDE '($SSDEF)'
      INTEGER   IOFUNC
      PARAMETER (IOFUNC=IO$_READVBLK.OR.IO$M_NOECHO.OR.IO$M_ESCAPE)
      INTEGER   CHAN, IER, SYS$QIOW, TERMSK(2), J
      INTEGER*2 IOSB(4), CODE_TABLE(22)
      BYTE      TERMCH(32),BUFFER(20), VALID_TABLE(22)
      DATA      TERMCH/32*'FF'X/
      DATA      TERMSK(1) / 32 /
C
C               Valid escape sequences are <esc> O or <esc> [
C               followed by one of the characters in VALID_TABLE;
C               CODE_TABLE contains the corresponding integer codes
C               returned by GRGETC.
C
      DATA VALID_TABLE/ 'A','B','C','D',  'P','Q','R','S',
     1          'p','q','r','s','t','u','v','w','x','y',
     2          'm','l','n', 'M'/
      DATA CODE_TABLE/ -1,-2,-3,-4, -11,-12,-13,-14,
     1          -20,-21,-22,-23,-24,-25,-26,-27,-28,-29,
     2          -17,-16,-18, -8/
C
C               Read a single character; all characters are
C               terminators, and escape sequences are recognised.
C
      TERMSK(2) = %LOC(TERMCH)
      IER = SYS$QIOW(, %VAL(CHAN), %VAL(IOFUNC), IOSB, , ,
     1                BUFFER,   ! P1 (buffer address)
     2                %VAL(20), ! P2 (buffer size)
     3                ,         ! P3 (timeout count)
     4                TERMSK,   ! P4 (read terminator descr.block)
     5                ,         ! P5 (prompt buffer address)
     6                )         ! P6 (prompt buffer size)
      IF (IER.NE.1) THEN
          CALL GRGMSG(IER)
          CALL GRQUIT('Fatal error in PGPLOT routine GRGETC')
      END IF
C
C               If terminator is a single character, return it.
C
      IF (IOSB(4).EQ.1) THEN
          GRGETC = BUFFER(1)
          RETURN
C
C               If terminator is an escape sequence, interpret it.
C
      ELSE IF ((BUFFER(1).EQ.27) .AND.
     1         (BUFFER(2).EQ.79 .OR. BUFFER(2).EQ.91)) THEN
          DO J=1,22
              IF (BUFFER(3).EQ.VALID_TABLE(J)) THEN
                  GRGETC = CODE_TABLE(J)
                  RETURN
              END IF
          END DO
      END IF
C
C               Otherwise, return zero.
C
      GRGETC = 0
      RETURN
      END
