/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#include <unistd.h>
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

#include "tab_list.h"

struct tab_list_s {
    size_t len;
    tab_item_t first, last;
};

struct tab_item_s {
    char *match;
    size_t match_len;
    tab_item_t next;
};

tab_item_t get_first(tab_list_t list)
{
    return list->first;
}

tab_item_t get_nextitem(tab_item_t item)
{
    return item->next;
}

void add_item(tab_list_t list, const char *match, size_t match_len)
{
    list->len++;
    if (list->last) {
	list->last->next = malloc(sizeof(struct tab_item_s));    
	list->last = list->last->next;
    } else {
	list->first = list->last = malloc(sizeof(struct tab_item_s));
    }
    
    memset(list->last, 0, sizeof(struct tab_item_s));
    list->last->match_len = match_len;
    list->last->match = malloc(match_len + 1);
    memcpy(list->last->match, match, match_len);
    list->last->match[match_len] = '\0';
}

void add_item2(tab_list_t list, tab_item_t item)
{
    add_item(list, get_match(item), get_matchlen(item));
}

void free_item(tab_item_t item)
{
    free(item->match);
}

void remove_listitem(tab_list_t list, tab_item_t *item)
{
    tab_item_t free_me;
    
    free_item((*item));
    
    list->len--;
    
    if ((*item)->next) {
	free_me = (*item)->next;
	(*item)->match = free_me->match;
	(*item)->match_len = free_me->match_len;   
	(*item)->next = free_me->next;
	
	if (!(*item)->next)
	    list->last = (*item);
    } else {
	if (list->first == (*item)) {
	    list->first = list->last = NULL;
	    free_me = (*item);
	    (*item) = NULL;
	} else {
	    free_me = list->first;
	    while (free_me->next != (*item))
		free_me = free_me->next;
	    
	    list->last = free_me;
	    free_me = (*item);
	    (*item) = NULL;
	    list->last->next = NULL;      
	}
    }
    
    free(free_me);
}

tab_list_t init_list(void)
{
    tab_list_t ret = malloc(sizeof(struct tab_list_s));
    memset(ret, 0, sizeof(struct tab_list_s));
    return ret;
}

void free_list(tab_list_t list)
{
    tab_item_t free_me;
    while (list->first) {
	free_me = list->first;
	list->first = free_me->next;
	free_item(free_me);
	free(free_me);
    }
    
    free(list);
}

size_t len_list(tab_list_t list)
{
    return list->len;
}

void move_list(tab_list_t *dest, tab_list_t src)
{
    (*dest) = init_list();
    memcpy((*dest), src, sizeof(struct tab_list_s));
    free(src);
}

const char *get_match(tab_item_t item)
{
    return item->match;
}

size_t get_matchlen(tab_item_t item)
{
    return item->match_len;
}

void get_matchdata(tab_item_t item, char **match, size_t *len)
{
    (*len) = item->match_len;
    (*match) = realloc((*match), (*len) + 1);
    memcpy((*match), item->match, (*len) + 1);
}
