#! /usr/bin/perl -w

use iPE;
use iPE::Globals;
use iPE::gHMM;
use iPE::FeatureMap;
use File::Basename;
use Getopt::Long;
use strict;

my $usage = fileparse($0)." [ options ] gHMM-file [ gHMM-file ... ]

Check validity of a gHMM file.

Options:
  -h      display this help message and exit
  -f file check validity of this feature map along with this gHMM.

";

my ($helpme, $feature_map);
GetOptions("helpme" => \$helpme, 
  "feature-map=s" => \$feature_map) or die($usage);
$helpme and die($usage);
@ARGV > 0 or die($usage);

while(my $file = shift(@ARGV)) {
  print("Checking $file ...\n");
  my $g = new iPE::Globals();
  $g->options->verbose(1);
  $g->init_fhs();
  my $gHMM=new iPE::gHMM();
  $gHMM->parse_file($file, "gHMM");
  if(defined($feature_map)) {
    $g->gHMM($gHMM);
    my $fm = new iPE::FeatureMap();
    $fm->parse_file($feature_map, "feature_map");
  }
  print("OK.\n");
}
