#ifndef NODE_C
#define NODE_C

#include "node.h"
#include <stdio.h>

Node* NewNode(int id) {
  Node* node = (Node *)malloc(sizeof(Node));
  node->id = id;
  node->children = (Node **)malloc(2 * sizeof(Node *));
  node->num_children = 0;
  node->P = NULL;
  node->E = NULL;
  node->W = NULL;
  node->pL_exact = NULL;
  node->pL_partial = NULL;
  node->pL_exact_cache = NULL;
  node->pL_partial_cache = NULL;
  node->descendants = NULL;
  strcpy (node->name, "");
  strcpy (node->seq, "");

  return node;
}

void DeleteNode(Node *n, int num_states) {
  int i;
  for(i = 0; i < n->num_children; i++) {
    DeleteNode(n->children[i], num_states);
  }
  free(n->children);

  if(n->descendants)
    free(n->descendants);
  if(n->P) {
    for (i=0; i<num_states; i++)
      free(n->P[i]);
    free(n->P);
  }

  if(n->E) {
    for (i=0; i<num_states; i++)
      free(n->E[i]);
    free(n->E);
  }

  if(n->W) {
    for (i=0; i<num_states; i++)
      free(n->W[i]);
    free(n->W);
  }

  if(n->pL_exact)
    free(n->pL_exact);

  if(n->pL_partial)
    free(n->pL_partial);

  if(n->pL_exact_cache)
    cache_free(n->pL_exact_cache);

  if(n->pL_partial_cache)
    cache_free(n->pL_partial_cache);

  free(n);
}

#endif
