=head1 NAME

iPE::Model::Emission::MARG_WAM - A marginalized version of the Weight Array Model.

=head1 DESCRIPTION

This is a model identical to the Weight Array Model which simply prints out more parameters than there are in the model.  It allows you to specify an order higher than the actual order.

=head1 FUNCTIONS

=cut

package iPE::Model::Emission::MARG_WAM;
use base("iPE::Model::Emission::WAM");
use strict;

sub init {
    my $this = shift;
    $this->SUPER::init(@_);
    
    unless($this->hasSettings) {
        #XXX deprecated.  remove when moving to settings format
        my @data = split(' ', $this->{data_});
        $this->settings->{printedOrder} = $data[1];
    }

    die("MARG_WAM requires a printedOrder setting as well as an order" .
        " setting.\nFound in ".$this->name."\n")
        if(!defined $this->printedOrder);

    die "MARG_WAM printed order must be greater than the estimated order.\n"
        if($this->order >= $this->printedOrder);
}

sub printedOrder { shift->settings->{printedOrder} }

sub outputPrepare {
    my ($this, $out, $mode) = @_;

    my $pstring = "";
    my $est_order = $this->order;
    my $nonest_order = $this->printedOrder-$this->order;
    my @nonest_nmers = 
        $this->seqClass->getAllSequences($nonest_order,$this->ambiguate);
    my @est_nmers = 
        $this->seqClass->getAllSequences($est_order,$this->ambiguate);
    my @alphabet = @{$this->seqClass->getAlphabet};
    push @alphabet, $this->seqClass->getWildCard if($this->ambiguate);
    for my $pos (0 .. $this->length-1) {
        for my $nmer1 (@nonest_nmers) {
            for my $nmer2 (@est_nmers) {
                $pstring .= $nmer1.$nmer2.$out->tab if($mode ne "score");
                for my $l (@alphabet) {
                    if($mode eq "count" || $mode eq "prob") {
                        $pstring .= 
                            $out->floatf($this->posCounts->[$pos]->{$nmer2.$l}).
                            " | ".
                            $out->floatf($this->nullCounts->[$pos]->{$nmer2.$l}).
                            $out->tab;
                    }
                    elsif($mode eq "score") {
                        $pstring .= 
                            $out->intf($this->scores->[$pos]->{$nmer2.$l}).
                            $out->tab;
                    }
                }
                $pstring .= "\n";
            }
        }
    }

    $this->setParamString($pstring);
}

sub getZoeHeaderEnd { shift->printedOrder }

=head1 SEE ALSO

L<iPE::Model::Emission::WAM> L<iPE::Model::Emission> 

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;
