=head1 NAME

iPE::Model::Emission::BNTREE_CDS - Coding Sequence model for N-SCAN phylogenetic parameters.

=head1 DESCRIPTION

=head1 FUNCTIONS

=cut

package iPE::Model::Emission::BNTREE_CDS;
use iPE;
use iPE::Globals;
use iPE::Model;
use base ("iPE::Model::Emission::CDS");
use strict;

sub getZoeHeader { $_[0]->name."\tBNTREE_CDS\t".$_[0]->zLength."\n"; }

sub normalize {
    my ($this) = @_;

    my $g = new iPE::Globals();

    my $order = $this->order > $this->targetOrder ? 
        $this->order : $this->targetOrder;

    my @phylo_text;
    my $num = 0;
    for my $cpos (1,2,0) { # this is how it works with N-SCAN...
        push(@phylo_text, $g->bntree->optimizeTuples(
            $this, $this->posCounts->[$cpos], $order, $this->name."_$num"));
        $num++;
    }

    $this->setParamString(join("", @phylo_text));
}

sub outputPrepare { } # handled in normalize, no counts or prob output

# this is re-overridden since CDS is a special case.
sub outputZoe {
    my ($this, $out, $mode) = @_;
    $out->print($out->indent.$this->getZoeHeader); # this is for diff compatibility
    $out->increaseIndent();
    $out->printPCData($this->getParamString());
    $out->decreaseIndent();
}

=back

=head1 SEE ALSO

L<iPE::Model::Emission>

=head1 AUTHOR

Bob Zimmermann (rpz@cse.wustl.edu)

=cut

1;



