=head1 NAME

iPE::Model::Emission::ASM - Augustus Signal Model

Same as an LUT except normalizing over all n-mers.

=head1 DESCRIPTION

=head1 FUNCTIONS

=cut

package iPE::Model::Emission::ASM;
use iPE;
#use iPE::Model;
#use iPE::Model::Emission;
#use iPE::Model::Emission::SDT;
use base("iPE::Model::Emission::LUT");
use strict;


sub normalize {
    my ($this) = @_;
#<AAA akshat
	print "\n Entering ASM!";
#akshat>
    
    my @nmers = $this->seqClass->getAllSequences($this->order,$this->ambiguate);
    #whether or not we have a null model.
	print "\n NUll model check !";
    my $nullModel = $this->nullModel;
    my $wildCard = $this->seqClass->getWildCard();
    my @alphabet = @{$this->seqClass->getAlphabet};
    push @alphabet, $this->seqClass->getWildCard 
        if($this->ambiguate && $this->wildcard == iPE::Model::Emission::LITERAL());
	print "\n Null model check end ! & for loop starts";

    for my $nmer (@nmers) {
        my $totCounts = 0;
        my $totNullCounts = 0;
        for my $l (@alphabet) {
	    print "\n for nmer: ".$nmer.$l." & the posCounts are: ".$this->posCounts->{$nmer.$l}." & the nullCounts are: ".$this->nullCounts->{$nmer.$l} 
		if($this->posCounts->{$nmer.$l} || $this->nullCounts->{$nmer.$l});	
            $totCounts += $this->posCounts->{$nmer.$l};
            $totNullCounts += $this->nullCounts->{$nmer.$l} if($nullModel);
        }
        for my $l (@alphabet) {
            $this->posCounts->{$nmer.$l} /= $totCounts

                if($totCounts);
            $this->nullCounts->{$nmer.$l} /= $totNullCounts 
                if($totNullCounts && $nullModel);
        }
        if($this->ambiguate && 
                    $this->wildcard == iPE::Model::Emission::LEXICAL()) { 
            $this->posCounts->{$nmer.$wildCard} = 1;
            $this->nullCounts->{$nmer.$wildCard} = 1;
        }
    }
	print "\n Test!!";
	print "order :  ".$this->order;


	print "\n for endsz!";
#<AAA akshat
	print "\n Leaving ASM";
#akshat>
    
}

sub setNullProb {
#	print "\nThe array: @_";
	my ($this, $l, $level) = (@_);
	
#	print "\n This is the test null!!";
#	print "\nthis =$this & l = $l & level = $level";
	print "\ntest:: ".keys(%$this);
	for my $test (keys %$this){
		print "\n\ttry : $test";
	}
	print"\nthe bloody model:$this->{model_}";
	for my $test (keys %{$this->{scores_}}){
		print "\n\t model : $test";

	}
	print"\nthe null models: $this->{nullModel_}";
}

sub adjustPosProb {
	my($this, $pos, $letter, $prior, $null) = (@_);
#	print "\n This test adjust !";
#	print " Pos = $pos & l= $letter & pri = $prior & null = $null";

}
=head1 SEE ALSO

L<iPE::Model::Emission>

=head1 AUTHOR

Akshat Shrivastava (ars6@cec.wustl.edu)

=cut

1;
