#include "EXTERN.h" 
#include "perl.h" 
#include "XSUB.h" 
#include "bntree.h"

MODULE = iPE PACKAGE = iPE

void
_levels(levels_hash, str, len)
    HV* levels_hash
    char* str
    long len
CODE:
    {
        double levels[4];
        long i, total;
        //char errmsg[50];

        for(i = 0; i < 4; i++) {
            levels[i] = 0.;
        }
        for(i = 0; i < len; i++) {
            if(str[i] == 'A')       { levels[0]++; }
            else if(str[i] == 'C')  { levels[1]++; }
            else if(str[i] == 'G')  { levels[2]++; }
            else if(str[i] == 'T')  { levels[3]++; }
        }
        total = levels[0]+levels[1]+levels[2]+levels[3];
        if(total) {
            for(i = 0; i < 4; i++) { 
                levels[i] /= total; 
            }
        }
        else {
            for(i = 0; i < 4; i++) { 
                levels[i] = 0;
            }
        }

        hv_store(levels_hash, "A", 1, newSVnv(levels[0]), 0);
        hv_store(levels_hash, "C", 1, newSVnv(levels[1]), 0);
        hv_store(levels_hash, "G", 1, newSVnv(levels[2]), 0);
        hv_store(levels_hash, "T", 1, newSVnv(levels[3]), 0);
    }

void
fast_uc(sv_ref,length)
        SV * sv_ref
        int length
    PPCODE: 
    {
    /* Let xsubpp know that we're in control of the argument stack */
    /* and return values with PPCODE.  Don't know why.  */
        int i;
        SV * sv = SvRV(sv_ref);
        char * str = SvPV(sv, length);
        for (i = 0; i < length; i++) {
            if(str[i] >= 'a' && str[i] <= 'z') {
                str[i] -= 32;
            }
        }
        EXTEND(sp, 1);
        PUSHs(sv_ref);
    }

MODULE = iPE PACKAGE = iPE::Model::BNTree

SV *
_optimizeSSFileForTreeAndModel(this, model_name, ss_filename, tree, nscan_model, seed)
  SV * this
  char * model_name
  char * ss_filename
  char * tree
  char * nscan_model
  int seed

  CODE:
  {
    char *bntree_filename;
    BNTree *t;

    srand(seed);

    /* construct the bntree filename */
#define BNTREE_SFX ".bntree"
    bntree_filename = malloc((strlen(ss_filename) + strlen(BNTREE_SFX) + 1) *
      sizeof(char));
    strcpy(bntree_filename, ss_filename);
    strcat(bntree_filename, BNTREE_SFX);

    /* make the appropriate call to optimize */
    /*fprintf(stderr, "train_bntree %s %s %s %s %s\n", tree, nscan_model, ss_filename, model_name, bntree_filename);*/
    t = train_bntree(tree,nscan_model,ss_filename,model_name,bntree_filename);
    DeleteBNTree(t);

    RETVAL = newSVpv(bntree_filename, strlen(bntree_filename));
  }
  OUTPUT:
    RETVAL
