#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoR6m2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::AudioKeys',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::QuickTime::VideoKeys',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GContainer',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::HDRGainMap',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apdi',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 115 => 0x69 },
	'about' => { 546 => 'about' },
	'aboutcvterm' => { 537 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 537 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 537 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 537 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 537 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 122 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 552 => 'absPeakAudioFilePath' },
	'academicfield' => { 542 => 'academicField' },
	'acceleration' => { 125 => 0x9404, 530 => 'Acceleration' },
	'accelerationtracking' => { 90 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 427 => 0x3 },
	'accelerometerdata' => { 416 => 'vrot' },
	'accelerometerx' => { 354 => 0x8d },
	'accelerometery' => { 354 => 0x8e },
	'accelerometerz' => { 354 => 0x8c },
	'accessoryserialnumber' => { 354 => 0x54 },
	'accessorytype' => { 354 => 0x53 },
	'acdseeregion' => { 496 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 496 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 496 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 496 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 496 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 496 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 496 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 496 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 496 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 496 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 496 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 496 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 496 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 496 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 496 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 496 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 496 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 496 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 138 => 0x2a },
	'activearea' => { 125 => 0xc68d },
	'actived-lighting' => { 243 => 0x22, 300 => 0x24 },
	'actived-lightingmode' => { 300 => 0x25 },
	'adaptervoltage' => { 145 => 0x407 },
	'addaspectratioinfo' => { 90 => 0x80e },
	'addiptcinformation' => { 90 => 0x815 },
	'additionalmodelinformation' => { 537 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 90 => 0x80f, 91 => 0x11, 92 => 0x13, 95 => 0x14 },
	'address' => { 168 => 'Address' },
	'adjustmentmode' => { 434 => 0x15 },
	'adlbracketingstep' => { 205 => 0x17 },
	'adlbracketingtype' => { 205 => 0x18 },
	'adobe' => { 126 => 'Adobe' },
	'adultcontentwarning' => { 340 => 'AdultContentWarning', 545 => 'adultContentWarning' },
	'advancedfilter' => { 133 => 0x1201 },
	'advancedraw' => { 302 => 0x76a43203 },
	'advancedscenetype' => { 354 => 0x3d },
	'advisory' => { 550 => 'Advisory' },
	'ae_iso' => { 362 => 0x2, 363 => 0x4, 364 => 0x12 },
	'aeaperture' => { 362 => 0x1, 363 => 0x3, 364 => 0x11 },
	'aeaperturesteps' => { 362 => 0x8, 363 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 90 => 0x104 },
	'aebbracketvalue' => { 82 => 0x11 },
	'aebracketingsteps' => { 205 => 0xf, 206 => 0xf, 282 => 0x174c },
	'aebsequence' => { 90 => 0x105 },
	'aebsequenceautocancel' => { 88 => 0x9, 89 => 0x9, 91 => 0x8, 92 => 0x9, 95 => 0x9, 96 => 0x7 },
	'aebshotcount' => { 90 => 0x106 },
	'aebxv' => { 362 => 0x4, 363 => 0x6 },
	'aeerror' => { 363 => 0x8 },
	'aeexposuretime' => { 362 => 0x0, 363 => 0x2, 364 => 0x10 },
	'aelbutton' => { 191 => 0x45 },
	'aelexposureindicator' => { 191 => 0x51 },
	'aelock' => { 191 => 0x5b, 311 => '4.2', 320 => '4.2', 330 => 0x201, 390 => 0x48, 444 => 0x40, 445 => 0x40, 446 => [0x86,0x286] },
	'aelockbutton' => { 309 => '16.1', 311 => '4.1', 314 => '15.1', 315 => '16.1', 316 => '16.1', 318 => '30.1', 319 => '16.1', 320 => '4.1', 322 => '17.1', 324 => '17.1' },
	'aelockbuttonplusdials' => { 309 => '16.2', 318 => '32.1', 322 => '44.1' },
	'aelockformb-d80' => { 324 => '3.1' },
	'aelockmetermodeafterfocus' => { 90 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 362 => 0x9, 363 => 0x10, 364 => 0x1c },
	'aemaxaperture2' => { 362 => 0xa, 363 => 0x11, 364 => 0x1d },
	'aemeteringmode' => { 362 => 0xc },
	'aemeteringmode2' => { 362 => '13.1' },
	'aemeteringsegments' => { 194 => 0x628, 390 => 0x209 },
	'aemicroadjustment' => { 90 => 0x110 },
	'aeminaperture' => { 362 => 0xb, 363 => 0x12, 364 => 0x1e },
	'aeminexposuretime' => { 362 => 0x5, 363 => 0x13, 364 => 0x1f },
	'aeprogrammode' => { 362 => 0x6 },
	'aeprojectlink' => { 524 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 524 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 524 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 524 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 524 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 524 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 37 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 343 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 362 => 0xd },
	'aexv' => { 362 => 0x3, 363 => 0x5 },
	'af-assistilluminator' => { 325 => 0x1a, 326 => 0x19, 327 => 0x19, 328 => 0x19 },
	'af-cfocusdisplay' => { 326 => 0x234, 327 => 0x234, 328 => 0x24c },
	'af-cpriority' => { 134 => '0.2' },
	'af-cpriorityselection' => { 309 => '1.1', 310 => '1.1', 312 => '1.1', 313 => '1.1', 315 => '0.1', 316 => '0.1', 317 => '0.1', 318 => '1.1', 319 => '0.1', 322 => '1.1', 323 => '1.1', 325 => 0x3, 326 => 0x3, 327 => 0x3, 328 => 0x3 },
	'af-csetting' => { 130 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 130 => '0.2' },
	'af-ctrackingsensitivity' => { 130 => '0.1' },
	'af-czoneareaswitching' => { 130 => '0.3' },
	'af-onbutton' => { 312 => '70.1', 313 => '70.1', 323 => '70.1' },
	'af-onformb-d10' => { 309 => '3.3', 318 => '3.2' },
	'af-onformb-d11' => { 319 => '2.2' },
	'af-onformb-d12' => { 322 => '50.1' },
	'af-onoutoffocusrelease' => { 325 => 0x10, 326 => 0x10, 327 => 0x10, 328 => 0x10 },
	'af-spriority' => { 134 => '0.1' },
	'af-spriorityselection' => { 309 => '1.2', 310 => '1.2', 312 => '1.2', 313 => '1.2', 317 => '0.2', 318 => '1.2', 319 => '0.2', 322 => '1.2', 323 => '1.2', 325 => 0x5, 326 => 0x5, 327 => 0x5, 328 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 309 => '2.1', 310 => '2.1', 312 => '78.3', 313 => '78.3', 318 => '2.1', 322 => '2.1', 323 => '78.3', 325 => 0xf, 326 => 0xf, 327 => 0xf, 328 => 0xf },
	'afadjustment' => { 390 => 0x72, 399 => 0x267 },
	'afandmeteringbuttons' => { 90 => 0x701 },
	'afaperture' => { 236 => 0x5, 237 => 0x5, 241 => 0x5 },
	'afareaheight' => { 200 => [0x1a,0x34,0x50], 201 => 0x48 },
	'afareaillumination' => { 191 => 0x4b, 320 => '15.3' },
	'afareainitialheight' => { 257 => 0xbeb },
	'afareainitialwidth' => { 257 => 0xbea },
	'afareainitialxposition' => { 257 => 0xbe8 },
	'afareainitialyposition' => { 257 => 0xbe9 },
	'afareamode' => { 132 => '0.3', 187 => 0x33, 191 => 0xe, 199 => 0x0, 200 => 0x5, 201 => 0x5, 247 => 0x340, 249 => 0x224, 250 => 0x224, 251 => 0x210, 252 => 0x224, 253 => 0x224, 354 => 0xf, 424 => 0x1205, 437 => [0xa,0x3a], 444 => 0x11, 445 => 0x10, 446 => 0x24, 458 => 0xb043, 484 => 0x17 },
	'afareamodesetting' => { 311 => '11.1', 314 => '0.1', 320 => '16.1', 324 => '2.1', 458 => 0x201c },
	'afareapointsize' => { 132 => '0.4' },
	'afareas' => { 330 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 90 => 0x51b },
	'afareawidth' => { 200 => [0x18,0x32,0x4e], 201 => 0x46 },
	'afareaxposition' => { 200 => [0x14,0x2e,0x4a], 201 => 0x42, 424 => 0x1203 },
	'afareaxposition1' => { 424 => 0x1201 },
	'afareayposition' => { 200 => [0x16,0x30,0x4c], 201 => 0x44, 424 => 0x1204 },
	'afareayposition1' => { 424 => 0x1202 },
	'afareazonesize' => { 132 => '0.5' },
	'afassist' => { 88 => 0x5, 96 => 0x5, 191 => 0x48, 309 => '2.5', 311 => '0.2', 314 => '0.2', 315 => '1.1', 316 => '1.1', 317 => '1.3', 318 => '2.4', 319 => '1.3', 320 => '0.2', 322 => '2.4', 324 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 90 => 0x50e, 91 => 0x4, 92 => 0x5, 93 => 0x4, 94 => 0x4, 95 => 0x5 },
	'afassistlamp' => { 354 => 0x31 },
	'afbuttonpressed' => { 446 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 365 => 0x6 },
	'afduringliveview' => { 90 => 0x511 },
	'affinea' => { 516 => 'AffineA' },
	'affineb' => { 516 => 'AffineB' },
	'affinec' => { 516 => 'AffineC' },
	'affined' => { 516 => 'AffineD' },
	'affinetune' => { 202 => 0x0, 249 => 0x6b0, 250 => 0x6c0, 251 => 0x5b0, 252 => 0x5e0, 253 => 0x5f8, 330 => 0x306 },
	'affinetuneadj' => { 202 => 0x2, 275 => 0x2d1, 276 => 0x2dc, 330 => 0x307 },
	'affinetuneadjtele' => { 202 => 0x3 },
	'affinetuneindex' => { 202 => 0x1 },
	'affinex' => { 516 => 'AffineX' },
	'affiney' => { 516 => 'AffineY' },
	'afhold' => { 365 => 0x1fd },
	'afilluminator' => { 444 => 0x29, 458 => 0xb044 },
	'afimageheight' => { 200 => [0x12,0x2c,0x48], 201 => 0x40 },
	'afimagewidth' => { 200 => [0x10,0x2a,0x46], 201 => 0x3e },
	'afintegrationtime' => { 365 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 437 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 441 => 0x131 },
	'afmicroadjregisteredlenses' => { 441 => '305.1' },
	'afmicroadjustment' => { 90 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 441 => 0x130 },
	'afmode' => { 119 => 0x3009, 133 => 0x1022, 187 => 0x16, 434 => 0x5 },
	'afmoderestrictions' => { 310 => '50.3', 312 => '48.3', 313 => '48.3', 322 => '48.3', 323 => '48.3' },
	'afonaelockbuttonswitch' => { 90 => 0x702 },
	'afonbutton' => { 309 => '3.1', 310 => '47.1', 325 => 0x87, 326 => 0x83, 327 => 0x83, 328 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 37 => 0x13, 118 => 0x18, 187 => 0x15, 199 => 0x1, 333 => 0x308, 434 => 0x1f, 437 => [0x37,0x7], 441 => 0x19, 442 => 0x18, 443 => [0x18,0x20] },
	'afpointactivationarea' => { 89 => 0x11, 95 => 0x11 },
	'afpointareaexpansion' => { 90 => 0x508 },
	'afpointatshutterrelease' => { 437 => [0x39,0x9] },
	'afpointautoselection' => { 90 => 0x50b },
	'afpointbrightness' => { 90 => 0x50d, 309 => '2.4', 310 => '46.5', 312 => '2.2', 313 => '2.2', 322 => '2.3', 323 => '2.2' },
	'afpointdetails' => { 333 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 90 => 0x50c },
	'afpointillumination' => { 89 => 0xa, 309 => '2.3', 310 => '46.2', 312 => '47.2', 313 => '47.2', 317 => '1.2', 318 => '2.3', 319 => '1.2', 322 => '47.2', 323 => '47.2', 324 => '2.4' },
	'afpointinfocus' => { 437 => [0x38,0x8] },
	'afpointmode' => { 370 => 0x3 },
	'afpointposition' => { 119 => 0x2021, 354 => 0x4d },
	'afpointregistration' => { 88 => 0x7 },
	'afpoints' => { 190 => 0x10 },
	'afpointsel' => { 325 => 0xb, 326 => 0xb, 327 => 0xb, 328 => 0xb },
	'afpointselected' => { 191 => 0xd, 330 => 0x305, 390 => 0xe, 441 => 0x15, 442 => 0x14, 443 => [0x14,0x1c], 458 => 0x201e },
	'afpointselected2' => { 370 => 0x4 },
	'afpointselection' => { 89 => 0xb, 309 => '1.3', 310 => '1.3', 318 => '1.3', 322 => '1.3', 323 => '1.3' },
	'afpointselectionmethod' => { 90 => 0x50f, 91 => 0xc, 92 => 0xd, 95 => 0xd },
	'afpointsetting' => { 444 => 0x12, 445 => 0x11 },
	'afpointsinfocus' => { 82 => 0xe, 199 => 0x2, 200 => 0x30, 365 => 0xb, 366 => 0x4, 390 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 89 => 0xd },
	'afpointsselected' => { 200 => 0x1c, 366 => '4.1', 493 => 0x4 },
	'afpointsspecial' => { 366 => '4.2' },
	'afpointsunknown1' => { 365 => 0x0 },
	'afpointsunknown2' => { 365 => 0x2 },
	'afpointsused' => { 200 => [0xa,0x8], 201 => 0xa, 437 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 365 => 0x4 },
	'afresponse' => { 243 => 0xad },
	'afresult' => { 335 => 0x1038 },
	'afsearch' => { 330 => 0x303 },
	'afsensoractive' => { 187 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 424 => 0x1200 },
	'afstatus_00_b4' => { 440 => 0x0 },
	'afstatus_01_c4' => { 440 => 0x2 },
	'afstatus_02_d4' => { 440 => 0x4 },
	'afstatus_03_e4' => { 440 => 0x6 },
	'afstatus_04_f4' => { 440 => 0x8 },
	'afstatus_05_g4' => { 440 => 0xa },
	'afstatus_06_h4' => { 440 => 0xc },
	'afstatus_07_b3' => { 440 => 0xe },
	'afstatus_08_c3' => { 440 => 0x10 },
	'afstatus_09_d3' => { 440 => 0x12 },
	'afstatus_10_e3' => { 440 => 0x14 },
	'afstatus_11_f3' => { 440 => 0x16 },
	'afstatus_12_g3' => { 440 => 0x18 },
	'afstatus_13_h3' => { 440 => 0x1a },
	'afstatus_14_b2' => { 440 => 0x1c },
	'afstatus_15_c2' => { 440 => 0x1e },
	'afstatus_16_d2' => { 440 => 0x20 },
	'afstatus_17_e2' => { 440 => 0x22 },
	'afstatus_18_f2' => { 440 => 0x24 },
	'afstatus_19_g2' => { 440 => 0x26 },
	'afstatus_20_h2' => { 440 => 0x28 },
	'afstatus_21_c1' => { 440 => 0x2a },
	'afstatus_22_d1' => { 440 => 0x2c },
	'afstatus_23_e1' => { 440 => 0x2e },
	'afstatus_24_f1' => { 440 => 0x30 },
	'afstatus_25_g1' => { 440 => 0x32 },
	'afstatus_26_a7_vertical' => { 440 => 0x34 },
	'afstatus_27_a6_vertical' => { 440 => 0x36 },
	'afstatus_28_a5_vertical' => { 440 => 0x38 },
	'afstatus_29_c7_vertical' => { 440 => 0x3a },
	'afstatus_30_c6_vertical' => { 440 => 0x3c },
	'afstatus_31_c5_vertical' => { 440 => 0x3e },
	'afstatus_32_e7_vertical' => { 440 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 440 => 0x42 },
	'afstatus_34_e5_vertical' => { 440 => 0x44 },
	'afstatus_35_g7_vertical' => { 440 => 0x46 },
	'afstatus_36_g6_vertical' => { 440 => 0x48 },
	'afstatus_37_g5_vertical' => { 440 => 0x4a },
	'afstatus_38_i7_vertical' => { 440 => 0x4c },
	'afstatus_39_i6_vertical' => { 440 => 0x4e },
	'afstatus_40_i5_vertical' => { 440 => 0x50 },
	'afstatus_41_a7' => { 440 => 0x52 },
	'afstatus_42_b7' => { 440 => 0x54 },
	'afstatus_43_c7' => { 440 => 0x56 },
	'afstatus_44_d7' => { 440 => 0x58 },
	'afstatus_45_e7' => { 440 => 0x5a },
	'afstatus_46_f7' => { 440 => 0x5c },
	'afstatus_47_g7' => { 440 => 0x5e },
	'afstatus_48_h7' => { 440 => 0x60 },
	'afstatus_49_i7' => { 440 => 0x62 },
	'afstatus_50_a6' => { 440 => 0x64 },
	'afstatus_51_b6' => { 440 => 0x66 },
	'afstatus_52_c6' => { 440 => 0x68 },
	'afstatus_53_d6' => { 440 => 0x6a },
	'afstatus_54_e6_center' => { 440 => 0x6c },
	'afstatus_55_f6' => { 440 => 0x6e },
	'afstatus_56_g6' => { 440 => 0x70 },
	'afstatus_57_h6' => { 440 => 0x72 },
	'afstatus_58_i6' => { 440 => 0x74 },
	'afstatus_59_a5' => { 440 => 0x76 },
	'afstatus_60_b5' => { 440 => 0x78 },
	'afstatus_61_c5' => { 440 => 0x7a },
	'afstatus_62_d5' => { 440 => 0x7c },
	'afstatus_63_e5' => { 440 => 0x7e },
	'afstatus_64_f5' => { 440 => 0x80 },
	'afstatus_65_g5' => { 440 => 0x82 },
	'afstatus_66_h5' => { 440 => 0x84 },
	'afstatus_67_i5' => { 440 => 0x86 },
	'afstatus_68_c11' => { 440 => 0x88 },
	'afstatus_69_d11' => { 440 => 0x8a },
	'afstatus_70_e11' => { 440 => 0x8c },
	'afstatus_71_f11' => { 440 => 0x8e },
	'afstatus_72_g11' => { 440 => 0x90 },
	'afstatus_73_b10' => { 440 => 0x92 },
	'afstatus_74_c10' => { 440 => 0x94 },
	'afstatus_75_d10' => { 440 => 0x96 },
	'afstatus_76_e10' => { 440 => 0x98 },
	'afstatus_77_f10' => { 440 => 0x9a },
	'afstatus_78_g10' => { 440 => 0x9c },
	'afstatus_79_h10' => { 440 => 0x9e },
	'afstatus_80_b9' => { 440 => 0xa0 },
	'afstatus_81_c9' => { 440 => 0xa2 },
	'afstatus_82_d9' => { 440 => 0xa4 },
	'afstatus_83_e9' => { 440 => 0xa6 },
	'afstatus_84_f9' => { 440 => 0xa8 },
	'afstatus_85_g9' => { 440 => 0xaa },
	'afstatus_86_h9' => { 440 => 0xac },
	'afstatus_87_b8' => { 440 => 0xae },
	'afstatus_88_c8' => { 440 => 0xb0 },
	'afstatus_89_d8' => { 440 => 0xb2 },
	'afstatus_90_e8' => { 440 => 0xb4 },
	'afstatus_91_f8' => { 440 => 0xb6 },
	'afstatus_92_g8' => { 440 => 0xb8 },
	'afstatus_93_h8' => { 440 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 440 => 0xbc },
	'afstatusactivesensor' => { 187 => 0x2, 437 => [0x4,0x3b], 441 => 0x1e, 442 => 0x1b, 443 => [0x1b,0x21] },
	'afstatusbottom' => { 187 => 0x8, 441 => 0x2a, 442 => 0x21, 443 => 0x21 },
	'afstatusbottom-left' => { 187 => 0x12, 442 => 0x2b, 443 => 0x2b },
	'afstatusbottom-right' => { 187 => 0x6, 442 => 0x1f, 443 => 0x1f },
	'afstatusbottomassist-left' => { 441 => 0x28 },
	'afstatusbottomassist-right' => { 441 => 0x2c },
	'afstatusbottomhorizontal' => { 438 => 0x10, 439 => 0x1c },
	'afstatusbottomvertical' => { 438 => 0x16, 439 => 0x26 },
	'afstatuscenter-10' => { 441 => 0x34 },
	'afstatuscenter-11' => { 441 => 0x36 },
	'afstatuscenter-12' => { 441 => 0x38 },
	'afstatuscenter-14' => { 441 => 0x3c },
	'afstatuscenter-7' => { 441 => 0x2e },
	'afstatuscenter-9' => { 441 => 0x32 },
	'afstatuscenter-horizontal' => { 441 => 0x30 },
	'afstatuscenter-vertical' => { 441 => 0x3a },
	'afstatuscenterf2-8' => { 441 => 0x4c },
	'afstatuscenterhorizontal' => { 187 => 0x2f, 438 => 0xc, 439 => 0x18, 442 => 0x2f, 443 => 0x2f },
	'afstatuscentervertical' => { 187 => 0xc, 438 => 0x14, 439 => 0x22, 442 => 0x25, 443 => 0x25 },
	'afstatusfarleft' => { 438 => 0x6, 441 => 0x26 },
	'afstatusfarlefthorizontal' => { 439 => 0x4 },
	'afstatusfarleftvertical' => { 439 => 0x12 },
	'afstatusfarright' => { 438 => 0x18, 441 => 0x44 },
	'afstatusfarrighthorizontal' => { 439 => 0x2c },
	'afstatusfarrightvertical' => { 439 => 0x34 },
	'afstatusleft' => { 187 => 0x2d, 438 => 0x2, 441 => 0x22, 442 => 0x2d, 443 => 0x2d },
	'afstatuslefthorizontal' => { 439 => 0x6 },
	'afstatusleftvertical' => { 439 => 0xe },
	'afstatuslower-left' => { 438 => 0x4, 441 => 0x24 },
	'afstatuslower-lefthorizontal' => { 439 => 0xa },
	'afstatuslower-leftvertical' => { 439 => 0x10 },
	'afstatuslower-middle' => { 438 => 0x22, 439 => 0x24 },
	'afstatuslower-right' => { 438 => 0x1e, 441 => 0x4a },
	'afstatuslower-righthorizontal' => { 439 => 0x32 },
	'afstatuslower-rightvertical' => { 439 => 0x3a },
	'afstatuslowerfarleft' => { 439 => 0x8 },
	'afstatuslowerfarright' => { 439 => 0x30 },
	'afstatusmiddlehorizontal' => { 187 => 0xa, 442 => 0x23, 443 => 0x23 },
	'afstatusnearleft' => { 438 => 0xe, 439 => 0x1a },
	'afstatusnearright' => { 438 => 0xa, 439 => 0x16 },
	'afstatusright' => { 187 => 0x31, 438 => 0x1c, 441 => 0x48, 442 => 0x31, 443 => 0x31 },
	'afstatusrighthorizontal' => { 439 => 0x2e },
	'afstatusrightvertical' => { 439 => 0x38 },
	'afstatustop' => { 187 => 0xe, 441 => 0x40, 442 => 0x27, 443 => 0x27 },
	'afstatustop-left' => { 187 => 0x10, 442 => 0x29, 443 => 0x29 },
	'afstatustop-right' => { 187 => 0x4, 442 => 0x1d, 443 => 0x1d },
	'afstatustopassist-left' => { 441 => 0x3e },
	'afstatustopassist-right' => { 441 => 0x42 },
	'afstatustophorizontal' => { 438 => 0x8, 439 => 0x14 },
	'afstatustopvertical' => { 438 => 0x12, 439 => 0x1e },
	'afstatusupper-left' => { 438 => 0x0, 441 => 0x20 },
	'afstatusupper-lefthorizontal' => { 439 => 0x2 },
	'afstatusupper-leftvertical' => { 439 => 0xc },
	'afstatusupper-middle' => { 438 => 0x20, 439 => 0x20 },
	'afstatusupper-right' => { 438 => 0x1a, 441 => 0x46 },
	'afstatusupper-righthorizontal' => { 439 => 0x2a },
	'afstatusupper-rightvertical' => { 439 => 0x36 },
	'afstatusupperfarleft' => { 439 => 0x0 },
	'afstatusupperfarright' => { 439 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'afsubjectdetection' => { 354 => 0xe9 },
	'aftracking' => { 458 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 437 => 0x2 },
	'afwithshutter' => { 444 => 0x2a },
	'aggregateissuenumber' => { 542 => 'aggregateIssueNumber' },
	'aggregationtype' => { 542 => 'aggregationType' },
	'agreement' => { 545 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 145 => 0xe4e },
	'airplanemode' => { 247 => 0x9c0, 249 => 0x722, 250 => 0x732, 251 => 0x624, 252 => 0x654, 253 => 0x6bc },
	'aiservocontinuousshooting' => { 89 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 90 => 0x519 },
	'aiservoimagepriority' => { 90 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 90 => 0x51a },
	'aiservotrackingmethod' => { 90 => 0x504 },
	'aiservotrackingsensitivity' => { 89 => 0x14, 90 => 0x502 },
	'aisubjecttrackingmode' => { 330 => 0x309 },
	'album' => { 408 => ['albm',"\xa9alb"], 410 => 'album', 416 => ['albm',"\xa9alb"], 552 => 'album' },
	'albumartist' => { 186 => 'WM/AlbumArtist', 408 => 'aART', 416 => 'albr' },
	'albumcoverurl' => { 186 => 'WM/AlbumCoverURL' },
	'albumid' => { 408 => 'plID' },
	'albumtitle' => { 186 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 523 => 'AlreadyApplied', 525 => 'AlreadyApplied' },
	'alternatetitle' => { 542 => 'alternateTitle' },
	'alternatetitlea-lang' => { 542 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 542 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 542 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 204 => 0x6 },
	'alttapename' => { 552 => 'altTapeName' },
	'alttextaccessibility' => { 536 => 'AltTextAccessibility' },
	'alttimecode' => { 552 => 'altTimecode' },
	'alttimecodetimeformat' => { 552 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 552 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 552 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 420 => 0x5c },
	'ambientlight' => { 420 => 0x5e },
	'ambienttemperature' => { 125 => 0x9400, 418 => 0x14, 419 => 0x46, 420 => 0x50, 484 => 0x4, 530 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 418 => 0x13, 419 => 0x44, 420 => 0x4e },
	'analogbalance' => { 125 => 0xc627 },
	'analogcaptureiso' => { 145 => 0x89e },
	'analogisotable' => { 145 => 0x89d },
	'androidcapturefps' => { 410 => 'com.android.capture.fps' },
	'androidmake' => { 410 => 'com.android.manufacturer' },
	'androidmodel' => { 410 => 'com.android.model' },
	'androidversion' => { 410 => 'com.android.version' },
	'angleadj' => { 109 => 0x10003, 115 => 0x8b },
	'angleinforoll' => { 519 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 519 => 'AngleInfoYaw' },
	'anti-blur' => { 458 => 0xb04b },
	'antialiasstrength' => { 125 => 0xc632 },
	'antiflicker' => { 61 => 0x20 },
	'aperturelock' => { 310 => '38.2', 312 => '38.2', 313 => '38.2', 322 => '38.2', 323 => '38.2', 325 => 0xbc, 326 => 0xb8, 327 => 0xb8, 328 => 0xb8 },
	'aperturemode' => { 416 => 'apmd' },
	'aperturerange' => { 90 => 0x10d },
	'apertureringuse' => { 370 => '1.4' },
	'aperturesetting' => { 191 => 0x7, 444 => 0x30, 445 => 0x29, 446 => 0x1 },
	'aperturevalue' => { 99 => 0x2, 125 => 0x9202, 335 => 0x1002, 399 => 0x401, 529 => 'ApertureValue' },
	'appinfo' => { 499 => 'AppInfo' },
	'appinfoapplication' => { 499 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 499 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 499 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'applekeywords' => { 339 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 410 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 408 => 'apID' },
	'applestoreaccounttype' => { 408 => 'akID' },
	'applestorecatalogid' => { 408 => 'cnID' },
	'applestorecountry' => { 408 => 'sfID' },
	'applicationkeystring' => { 145 => 0x400 },
	'applicationnotes' => { 125 => 0x2bc, 359 => 0x2bc },
	'applicationrecordversion' => { 138 => 0x0 },
	'applyautomatically' => { 344 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 90 => 0x10e },
	'approved' => { 531 => 'Approved' },
	'approvedby' => { 531 => 'ApprovedBy' },
	'approximatefnumber' => { 349 => 0x313, 356 => 0x3406 },
	'approximatefocusdistance' => { 520 => 'ApproximateFocusDistance' },
	'appversion' => { 535 => 'AppVersion' },
	'aps-csizecapture' => { 477 => 0x114, 478 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 109 => 0x20914 },
	'armidentifier' => { 139 => 0x78 },
	'armversion' => { 139 => 0x7a },
	'arranger' => { 408 => "\xa9arg", 416 => "\xa9arg" },
	'arrangerkeywords' => { 416 => "\xa9ark" },
	'artdirector' => { 408 => "\xa9ard" },
	'artfilter' => { 330 => 0x529 },
	'artfiltereffect' => { 330 => 0x52f },
	'artist' => { 125 => 0x13b, 343 => 'Artist', 359 => 0x13b, 390 => 0x22e, 408 => "\xa9ART", 410 => 'artist', 416 => "\xa9ART", 548 => 'Artist', 552 => 'artist' },
	'artistid' => { 408 => 'atID' },
	'artmode' => { 119 => 0x301b },
	'artmodeparameters' => { 119 => 0x310b },
	'artwork' => { 410 => 'artwork' },
	'artworkcircadatecreated' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 537 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 537 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 334 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 334 => 0x1112, 390 => 0x80, 444 => 0x55, 445 => 0x55, 446 => 0xa, 471 => [0x192c,0x1a88], 472 => 0x192c, 473 => 0x1958, 474 => 0x192c, 475 => 0x188c },
	'assetid' => { 511 => 'AssetID' },
	'asshoticcprofile' => { 125 => 0xc68f },
	'asshotneutral' => { 125 => 0xc628 },
	'asshotpreprofilematrix' => { 125 => 0xc690 },
	'asshotprofilename' => { 125 => 0xc6f6 },
	'asshotwhitexy' => { 125 => 0xc629 },
	'assignbktbutton' => { 309 => '4.2', 310 => '16.1', 312 => '16.1', 313 => '16.1', 322 => '16.1', 323 => '16.1' },
	'assignfuncbutton' => { 90 => 0x70b },
	'assignmb-d17af-onbutton' => { 313 => '79.1' },
	'assignmb-d17funcbutton' => { 313 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 313 => '68.1' },
	'assignmb-d18af-onbutton' => { 323 => '79.1' },
	'assignmb-d18funcbutton' => { 323 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 323 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 312 => '75.1', 313 => '75.1', 323 => '75.1' },
	'assignmoviefunc2button' => { 312 => '82.1', 313 => '82.1', 323 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 312 => '75.2', 313 => '75.2', 323 => '75.2' },
	'assignmovierecordbutton' => { 310 => '43.2', 322 => '45.1', 325 => 0x9f, 326 => 0x9b, 327 => 0x9b, 328 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 312 => '45.1', 313 => '45.1', 323 => '45.1' },
	'assignmoviesubselector' => { 312 => '74.1', 313 => '74.1', 323 => '74.1' },
	'assignmoviesubselectorplusdials' => { 312 => '76.1', 313 => '76.1', 323 => '76.1' },
	'assignremotefnbutton' => { 310 => '54.1', 322 => '51.1' },
	'assistbuttonfunction' => { 88 => 0xd },
	'atcaptureusercrop' => { 145 => 0x943 },
	'attributionname' => { 521 => 'attributionName' },
	'attributionurl' => { 521 => 'attributionURL' },
	'audio' => { 354 => 0x20 },
	'audiobitrate' => { 72 => 0x6c, 537 => 'audioBitRate' },
	'audiobitratemode' => { 537 => 'audioBitRateMode' },
	'audiobitspersample' => { 537 => 'audioBitsPerSample' },
	'audiobutton' => { 327 => 0x17b, 328 => 0x193 },
	'audiobuttonplaybackmode' => { 327 => 0x1b9, 328 => 0x1d1 },
	'audiochannelcount' => { 537 => 'audioChannelCount' },
	'audiochannels' => { 72 => 0x70 },
	'audiochanneltype' => { 552 => 'audioChannelType' },
	'audiocompression' => { 90 => 0x816, 162 => 'Compression' },
	'audiocompressor' => { 552 => 'audioCompressor' },
	'audiodata' => { 502 => 'Data' },
	'audioduration' => { 138 => 0x99 },
	'audiogain' => { 407 => 'player.movie.audio.gain', 410 => 'player.movie.audio.gain' },
	'audiomimetype' => { 502 => 'Mime' },
	'audiomoddate' => { 552 => 'audioModDate' },
	'audiooutcue' => { 138 => 0x9a },
	'audiosamplerate' => { 72 => 0x6e, 552 => 'audioSampleRate' },
	'audiosampletype' => { 552 => 'audioSampleType' },
	'audiosamplingrate' => { 138 => 0x97 },
	'audiosamplingresolution' => { 138 => 0x98 },
	'audiotype' => { 138 => 0x96 },
	'author' => { 164 => 'Author', 339 => 'Author', 343 => 'Author', 406 => 'Author', 408 => ['auth',"\xa9aut"], 410 => 'author', 416 => 'auth', 517 => 'author', 539 => 'Author', 550 => 'Author' },
	'authorsposition' => { 540 => 'AuthorsPosition' },
	'authorurl' => { 186 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 90 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 380 => '0.1' },
	'autobracket' => { 434 => 0x19 },
	'autobracketing' => { 133 => 0x1100, 390 => 0x18, 424 => 0x1007 },
	'autobracketingmode' => { 321 => '12.3' },
	'autobracketingset' => { 321 => '12.1' },
	'autobracketmodem' => { 309 => '21.2', 310 => '13.3', 312 => '13.2', 313 => '13.2', 318 => '26.2', 322 => '13.3', 323 => '13.2', 325 => 0x63, 326 => 0x5f, 327 => 0x5f, 328 => 0x5f },
	'autobracketorder' => { 191 => 0x43, 309 => '21.3', 310 => '13.2', 312 => '13.1', 313 => '13.1', 318 => '26.3', 319 => '12.2', 320 => '2.2', 321 => '12.2', 322 => '13.2', 323 => '13.1', 324 => '13.2', 325 => 0x65, 326 => 0x61, 327 => 0x61, 328 => 0x61 },
	'autobracketset' => { 309 => '21.1', 310 => '13.1', 314 => '11.1', 315 => '12.1', 316 => '12.1', 318 => '26.1', 319 => '12.1', 320 => '2.1', 322 => '13.1', 324 => '13.1' },
	'autobrightness' => { 523 => 'AutoBrightness', 525 => 'AutoBrightness' },
	'autocapturecriteria' => { 203 => 0x1 },
	'autocapturecriteriamotiondirection' => { 203 => 0x5f },
	'autocapturecriteriamotionsize' => { 203 => 0x64 },
	'autocapturecriteriamotionspeed' => { 203 => 0x63 },
	'autocapturecriteriasubjectsize' => { 203 => 0x69 },
	'autocapturecriteriasubjecttype' => { 203 => 0x6a },
	'autocapturedframe' => { 203 => 0x0 },
	'autocapturedistancefar' => { 203 => 0x4a },
	'autocapturedistancenear' => { 203 => 0x4e },
	'autocapturepreset' => { 253 => 0x746 },
	'autocapturerecordingtime' => { 203 => 0x37 },
	'autocapturewaittime' => { 203 => 0x38 },
	'autocontrast' => { 523 => 'AutoContrast', 525 => 'AutoContrast' },
	'autodistortioncontrol' => { 217 => 0x4, 247 => 0x2cf, 248 => 0x143 },
	'autodynamicrange' => { 133 => 0x140b },
	'autoexposure' => { 523 => 'AutoExposure', 525 => 'AutoExposure' },
	'autoexposurebracketing' => { 82 => 0x10 },
	'autoflashisosensitivity' => { 312 => '38.5', 313 => '38.5', 323 => '38.5', 325 => 0x5f, 326 => 0x5b, 327 => 0x5b, 328 => 0x5b },
	'autofocus' => { 333 => 0x209 },
	'autofocusmoderestrictions' => { 326 => 0x107, 327 => 0x107, 328 => 0x11d },
	'autofp' => { 320 => '7.3', 324 => '31.4' },
	'autoiso' => { 82 => 0x1, 119 => 0x3008, 247 => 0x288, 249 => 0x152, 250 => 0x152, 251 => 0x142, 252 => 0x156, 253 => 0x156, 311 => '1.1', 320 => '1.1' },
	'autoisomax' => { 311 => '1.2', 320 => '1.2' },
	'autoisominshutterspeed' => { 311 => '1.3', 320 => '1.3' },
	'autolateralca' => { 523 => 'AutoLateralCA', 525 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 67 => 0x2, 90 => 0x204, 109 => 0x20500, 115 => 0x6f },
	'autolightingoptimizeron' => { 109 => '0x20500.0', 115 => 0x6e },
	'autoportraitframed' => { 458 => 0x2016 },
	'autoredeye' => { 302 => 0xfe28a44f },
	'autorotate' => { 82 => 0x1b },
	'autoshadows' => { 523 => 'AutoShadows', 525 => 'AutoShadows' },
	'autotone' => { 523 => 'AutoTone', 525 => 'AutoTone' },
	'autotonedigest' => { 523 => 'AutoToneDigest', 525 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 523 => 'AutoToneDigestNoSat', 525 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 523 => 'AutoWhiteVersion', 525 => 'AutoWhiteVersion' },
	'auxiliaryimagetype' => { 518 => 'AuxiliaryImageType' },
	'auxiliarylens' => { 243 => 0x82 },
	'avaperturesetting' => { 370 => 0x13 },
	'averageblacklevel' => { 49 => 0xe7, 51 => 0xfb, 52 => 0x114, 53 => 0x146 },
	'averagelv' => { 194 => 0x38 },
	'avsettingwithoutlens' => { 90 => 0x707 },
	'azimuth' => { 172 => 'Azimuth' },
	'babyage' => { 354 => [0x8010,0x33] },
	'babyname' => { 354 => 0x66 },
	'backgroundalpha' => { 547 => 'bgalpha' },
	'balance' => { 407 => 'player.movie.audio.balance', 410 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 370 => 0x15 },
	'baseiso' => { 82 => 0x2, 103 => 0x101c, 145 => 0x903, 356 => 0x312a, 490 => 0x6 },
	'baseisodaylight' => { 145 => 0x910 },
	'baseisoflash' => { 145 => 0x913 },
	'baseisofluorescent' => { 145 => 0x912 },
	'baseisotungsten' => { 145 => 0x911 },
	'baselineexposure' => { 125 => 0xc62a },
	'baselineexposureoffset' => { 125 => 0xc7a5 },
	'baselinenoise' => { 125 => 0xc62b },
	'baselinesharpness' => { 125 => 0xc62c },
	'baserenditionishdr' => { 534 => 'BaseRenditionIsHDR' },
	'baseurl' => { 550 => 'BaseURL' },
	'bass' => { 407 => 'player.movie.audio.bass', 410 => 'player.movie.audio.bass' },
	'batterylevel' => { 354 => 0x38, 444 => 0x51, 448 => 0xc, 449 => 0x4, 450 => 0x4, 491 => 0x7, 492 => 0x5 },
	'batterylevel2' => { 492 => 0x7 },
	'batterylevelgrip1' => { 491 => 0x6 },
	'batterylevelgrip2' => { 491 => 0x8 },
	'batteryorder' => { 309 => '12.5', 318 => '13.2', 319 => '2.1', 322 => '3.1' },
	'batterystate' => { 191 => 0x60, 444 => 0x50, 450 => 0x14 },
	'batterytemperature' => { 448 => 0x1, 450 => 0x2, 491 => 0x5 },
	'batterytype' => { 69 => 0x38, 420 => 0x66 },
	'batteryunknown' => { 448 => 0x2, 450 => 0x0 },
	'batteryvoltage' => { 145 => 0x408, 418 => 0x2a, 419 => 0x49, 420 => 0x62, 448 => 0x8 },
	'batteryvoltage1' => { 450 => 0x6 },
	'batteryvoltage2' => { 450 => 0x8 },
	'batteryvoltageavg' => { 420 => 0x64 },
	'bayergreensplit' => { 125 => 0xc62d },
	'bayerpattern' => { 144 => 0xf902, 195 => 0x17 },
	'beatsperminute' => { 408 => 'tmpo' },
	'beatspliceparams' => { 552 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 552 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 552 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 552 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 552 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 552 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 309 => '13.1', 310 => '5.4', 311 => '0.1', 314 => '2.1', 315 => '3.1', 316 => '3.1', 318 => '10.1', 320 => '0.1', 322 => '5.5', 324 => '4.1' },
	'beeppitch' => { 319 => '3.1' },
	'beepvolume' => { 319 => '4.5' },
	'bestqualityscale' => { 125 => 0xc65c },
	'bestshotmode' => { 119 => 0x3007 },
	'bitdepth' => { 169 => 'BitDepth', 195 => 0x11, 268 => 0x41 },
	'bitspercomponent' => { 140 => 0x87 },
	'bitspersample' => { 125 => 0x102, 359 => 0xa, 548 => 'BitsPerSample' },
	'blackacquirerows' => { 145 => 0x18ba },
	'blacklevel' => { 125 => [0x7310,0xc61a], 214 => 0x20, 243 => 0x3d, 335 => [0x401,0x1012], 399 => 0x21d, 465 => [0x7300,0x7310] },
	'blacklevel2' => { 334 => 0x600, 338 => 0x600 },
	'blacklevelblue' => { 359 => 0x1e },
	'blacklevelbottom' => { 145 => 0x3f0 },
	'blackleveldata' => { 399 => 0x223 },
	'blackleveldeltah' => { 125 => 0xc61b },
	'blackleveldeltav' => { 125 => 0xc61c },
	'blacklevelgreen' => { 359 => 0x1d },
	'blacklevelred' => { 359 => 0x1c },
	'blacklevelrepeatdim' => { 125 => 0xc619 },
	'blacklevelrough' => { 145 => 0x40e },
	'blacklevelroughafter' => { 145 => 0x416 },
	'blacklevels' => { 38 => 0x1d },
	'blackleveltop' => { 145 => 0x3ef },
	'blackpoint' => { 390 => 0x200 },
	'blacks2012' => { 523 => 'Blacks2012', 525 => 'Blacks2012' },
	'blacksadj' => { 495 => 0x9018 },
	'bleachbypasstoning' => { 390 => 0x7f },
	'blockshotafresponse' => { 312 => '1.5', 313 => '1.5', 323 => '1.5', 325 => 0x7, 326 => 0x7, 327 => 0x7, 328 => 0x7 },
	'blogtitle' => { 542 => 'blogTitle' },
	'blogurl' => { 542 => 'blogURL' },
	'bluebalance' => { 335 => 0x1018, 359 => 0x12, 390 => 0x1b },
	'bluecurvelimits' => { 114 => 0x1fe },
	'bluecurvepoints' => { 113 => 0x79, 114 => 0x1d4 },
	'bluehsl' => { 109 => 0x20915 },
	'bluehue' => { 523 => 'BlueHue', 525 => 'BlueHue' },
	'bluesaturation' => { 523 => 'BlueSaturation', 525 => 'BlueSaturation' },
	'bluratinfinity' => { 507 => 'BlurAtInfinity' },
	'blurcontrol' => { 390 => 0x82 },
	'blurwarning' => { 133 => 0x1300 },
	'bodybatteryadload' => { 368 => 0x3 },
	'bodybatteryadnoload' => { 368 => 0x2 },
	'bodybatterypercent' => { 368 => 0x3 },
	'bodybatterystate' => { 368 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 368 => 0x4 },
	'bodybatteryvoltage1' => { 368 => 0x2 },
	'bodybatteryvoltage2' => { 368 => 0x4 },
	'bodybatteryvoltage3' => { 368 => 0x6 },
	'bodybatteryvoltage4' => { 368 => 0x8 },
	'bodyfirmware' => { 425 => 0x0 },
	'bodyfirmwareversion' => { 331 => 0x104, 332 => 0x100, 335 => 0x104 },
	'bodyserialnumber' => { 425 => 0x10 },
	'bookedition' => { 542 => 'bookEdition' },
	'bootloaderversion' => { 419 => 0x26 },
	'bracketbutton' => { 250 => 0x808, 253 => 0x80c },
	'bracketbuttonplaybackmode' => { 250 => 0x810, 253 => 0x816 },
	'bracketincrement' => { 247 => 0x34a, 249 => 0x22e, 250 => 0x22e, 251 => 0x21a, 252 => 0x22e, 253 => 0x22e },
	'bracketmode' => { 61 => 0x3 },
	'bracketprogram' => { 247 => 0x348, 249 => 0x22c, 250 => 0x22c, 251 => 0x218, 252 => 0x22c, 253 => 0x22c },
	'bracketsequence' => { 119 => 0x301d },
	'bracketset' => { 247 => 0x346, 249 => 0x22a, 250 => 0x22a, 251 => 0x216, 252 => 0x22a, 253 => 0x22a },
	'bracketsettings' => { 354 => 0x45 },
	'bracketshotnumber' => { 61 => 0x5, 370 => 0x9, 455 => 0x2b },
	'bracketshotnumber2' => { 455 => 0x2d },
	'bracketstep' => { 188 => 0xe },
	'bracketvalue' => { 61 => 0x4 },
	'brightness' => { 125 => 0xfe53, 163 => 'Brightness', 183 => 'Brightness', 188 => 0x2c, 260 => 0x34, 261 => 0x39, 262 => 0x41, 410 => 'player.movie.visual.brightness', 418 => 0x25, 420 => 0x54, 444 => 0x22, 458 => 0x2007, 523 => 'Brightness', 525 => 'Brightness' },
	'brightnessadj' => { 114 => 0x114, 295 => 0x0, 305 => 0x2d, 495 => 0x8018 },
	'brightnessvalue' => { 125 => 0x9203, 194 => [0x691,0x49c3], 335 => 0x1003, 463 => 0x1e, 467 => 0x1140, 468 => 0x1140, 469 => 0x111c, 470 => 0x1198, 471 => 0x1174, 472 => 0x102c, 473 => 0x224, 474 => 0x224, 475 => 0x219, 529 => 'BrightnessValue' },
	'buildnumber' => { 198 => 0x5500 },
	'bulbduration' => { 82 => 0x18 },
	'burstcount' => { 145 => 0x40d },
	'burstgroupid' => { 245 => 0x4 },
	'burstid' => { 503 => 'BurstID' },
	'burstmode' => { 147 => 0xa, 354 => 0x2a },
	'burstmode2' => { 147 => 0x18 },
	'burstprimary' => { 503 => 'BurstPrimary' },
	'burstshot' => { 434 => 0x34 },
	'burstspeed' => { 354 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 90 => 0x70a },
	'bwadjustment' => { 133 => 0x1049 },
	'bwfilter' => { 188 => 0x2a, 196 => 0x39 },
	'bwmagentagreen' => { 133 => 0x104b },
	'bwmode' => { 335 => 0x203 },
	'by-line' => { 138 => 0x50 },
	'by-linetitle' => { 138 => 0x55 },
	'bytecount' => { 542 => 'byteCount' },
	'c14configuration' => { 145 => 0x1964 },
	'cacheversion' => { 125 => 0xc7aa },
	'calibratedfocallength' => { 122 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 122 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 122 => 'CalibratedOpticalCenterY' },
	'calibration' => { 434 => [0x24,0x30] },
	'calibrationhistory' => { 145 => 0x9c9 },
	'calibrationilluminant1' => { 125 => 0xc65a },
	'calibrationilluminant2' => { 125 => 0xc65b },
	'calibrationilluminant3' => { 125 => 0xcd31 },
	'calibrationversion' => { 145 => 0x9c6 },
	'callforimage' => { 511 => 'CallForImage' },
	'camera' => { 499 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 416 => 'angl', 552 => 'cameraAngle' },
	'cameraappinfo' => { 499 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 499 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 499 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 499 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 505 => 'CameraBurstID' },
	'cameracalibration' => { 434 => 0x11f },
	'cameracalibration1' => { 125 => 0xc623 },
	'cameracalibration2' => { 125 => 0xc624 },
	'cameracalibration3' => { 125 => 0xcd32 },
	'cameracalibrationsig' => { 125 => 0xc6f3 },
	'cameracolorcalibration01' => { 39 => 0x0, 40 => 0x0 },
	'cameracolorcalibration02' => { 39 => 0x4, 40 => 0x5 },
	'cameracolorcalibration03' => { 39 => 0x8, 40 => 0xa },
	'cameracolorcalibration04' => { 39 => 0xc, 40 => 0xf },
	'cameracolorcalibration05' => { 39 => 0x10, 40 => 0x14 },
	'cameracolorcalibration06' => { 39 => 0x14, 40 => 0x19 },
	'cameracolorcalibration07' => { 39 => 0x18, 40 => 0x1e },
	'cameracolorcalibration08' => { 39 => 0x1c, 40 => 0x23 },
	'cameracolorcalibration09' => { 39 => 0x20, 40 => 0x28 },
	'cameracolorcalibration10' => { 39 => 0x24, 40 => 0x2d },
	'cameracolorcalibration11' => { 39 => 0x28, 40 => 0x32 },
	'cameracolorcalibration12' => { 39 => 0x2c, 40 => 0x37 },
	'cameracolorcalibration13' => { 39 => 0x30, 40 => 0x3c },
	'cameracolorcalibration14' => { 39 => 0x34, 40 => 0x41 },
	'cameracolorcalibration15' => { 39 => 0x38, 40 => 0x46 },
	'cameradepthmap' => { 499 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 499 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 499 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 499 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 499 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 499 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 499 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 499 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 499 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 499 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 499 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 499 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 410 => 'direction.facing' },
	'camerae-mountversion' => { 494 => 0xb },
	'cameraelevationangle' => { 125 => 0x9405, 530 => 'CameraElevationAngle' },
	'camerafilename' => { 511 => 'CameraFilename' },
	'camerafirmware' => { 125 => 0xa439, 530 => 'CameraFirmware' },
	'cameraid' => { 335 => 0x209, 416 => 'cmid', 433 => 0x209 },
	'cameraidentifier' => { 417 => 'camera.identifier' },
	'cameraimage' => { 499 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 499 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 499 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 499 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 499 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 499 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 499 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 499 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 499 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 499 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 499 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 499 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 499 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 499 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 37 => 0x10 },
	'cameralabel' => { 125 => 0xc7a1, 552 => 'cameraLabel' },
	'cameralightestimate' => { 499 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 499 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 499 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 499 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 499 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 511 => 'CameraMakeModel' },
	'cameramodel' => { 399 => 0x410, 552 => 'cameraModel' },
	'cameramodelid' => { 183 => 'CameraModelID' },
	'cameramodelrestriction' => { 523 => 'CameraModelRestriction', 525 => 'CameraModelRestriction' },
	'cameramotion' => { 410 => 'direction.motion' },
	'cameramove' => { 552 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 354 => 0x8f, 389 => 0x1, 394 => 0x1, 399 => 0x100, 450 => [0x16,0x18], 481 => 0x28, 482 => 0x24, 483 => 0x29 },
	'cameraowner' => { 148 => 0xc353 },
	'cameraparameters' => { 335 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 121 => 0x9, 416 => "\xa9gpt" },
	'camerapointcloud' => { 499 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 499 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 499 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 499 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 499 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 499 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 499 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 499 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 499 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 499 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 499 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 499 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 499 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 523 => 'CameraProfile', 525 => 'CameraProfile' },
	'cameraprofiledigest' => { 523 => 'CameraProfileDigest', 525 => 'CameraProfileDigest' },
	'cameraprofiles' => { 540 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 540 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 540 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 540 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 540 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 540 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 540 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 540 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 540 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 540 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 540 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 540 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 540 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 540 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 540 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 540 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 115 => 0xe1 },
	'camerarawcontrast' => { 115 => 0xe3 },
	'camerarawhighlightpoint' => { 115 => 0xe6 },
	'camerarawlinear' => { 115 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 115 => 0xe8 },
	'camerarawoutputshadowpoint' => { 115 => 0xe9 },
	'camerarawsaturation' => { 115 => 0xe2 },
	'camerarawshadowpoint' => { 115 => 0xe7 },
	'camerarawsharpness' => { 115 => 0xe5 },
	'cameraroll' => { 121 => 0xb, 416 => "\xa9grl" },
	'cameras' => { 499 => 'Cameras' },
	'cameraserialnumber' => { 125 => 0xc62f, 185 => 'CameraSerialNumber', 511 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 330 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 36 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 82 => 0xc, 145 => 0x406, 334 => 0x1306, 349 => 0x320, 356 => 0x3402, 390 => 0x47, 431 => 0x43, 485 => 0x5 },
	'cameratemperature4' => { 395 => 0x14 },
	'cameratemperature5' => { 395 => 0x16 },
	'cameratemperaturerangemax' => { 127 => 0x5 },
	'cameratemperaturerangemin' => { 127 => 0x6 },
	'cameratrait' => { 499 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 82 => 0x1a, 335 => 0x207 },
	'cameratype2' => { 331 => 0x100 },
	'cameravendorinfo' => { 499 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 499 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 499 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 499 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 121 => 0xa, 416 => "\xa9gyw" },
	'camreverse' => { 122 => 'CamReverse' },
	'canondr4' => { 126 => 'CanonDR4' },
	'canonexposuremode' => { 37 => 0x14 },
	'canonfiledescription' => { 103 => 0x805 },
	'canonfilelength' => { 69 => 0xe },
	'canonfirmwareversion' => { 69 => 0x7, 103 => 0x80b },
	'canonflashinfo' => { 103 => 0x1028 },
	'canonflashmode' => { 37 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 37 => 0xa },
	'canonimagetype' => { 69 => 0x6, 103 => 0x815 },
	'canonlogversion' => { 68 => 0xb },
	'canonmodelid' => { 69 => 0x10, 103 => 0x1834 },
	'canonvrd' => { 126 => 'CanonVRD' },
	'caption' => { 517 => 'caption' },
	'caption-abstract' => { 138 => 0x78 },
	'captionsauthornames' => { 528 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 528 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 540 => 'CaptionWriter' },
	'captureframerate' => { 119 => 0x4001 },
	'captureheightnormal' => { 145 => 0x1839 },
	'capturelook' => { 145 => 0xc48 },
	'capturemode' => { 417 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 509 => 'CaptureSoftware' },
	'capturewidthnormal' => { 145 => 0x1838 },
	'capturewidthtest' => { 145 => 0x1842 },
	'cardshutterlock' => { 191 => 0x49 },
	'casioimagesize' => { 119 => 0x9 },
	'catalogsets' => { 138 => 0xff, 501 => 'CatalogSets', 515 => 'CatalogSets' },
	'categories' => { 69 => 0x23, 517 => 'categories' },
	'category' => { 138 => 0xf, 186 => 'WM/Category', 329 => 0x30, 408 => 'catg', 540 => 'Category' },
	'cbcrgain' => { 431 => 0xa036 },
	'cbcrgaindefault' => { 431 => 0xa035 },
	'cbcrmatrix' => { 431 => 0xa034 },
	'cbcrmatrixdefault' => { 431 => 0xa033 },
	'ccdboardversion' => { 349 => 0x331 },
	'ccdscanmode' => { 335 => 0x1039 },
	'ccdsensitivity' => { 291 => 0x6 },
	'ccdversion' => { 349 => 0x330 },
	'ccvavgluminancenits' => { 533 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 533 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 533 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 533 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 533 => 'ccv_white_xy' },
	'cellglobalid' => { 522 => 'cgi' },
	'celllength' => { 125 => 0x109 },
	'cellr' => { 522 => 'r' },
	'celltowerid' => { 522 => 'cellid' },
	'cellwidth' => { 125 => 0x108 },
	'centerafarea' => { 320 => '15.1' },
	'centerfocuspoint' => { 324 => '2.2' },
	'centerpixel' => { 145 => 0x40c },
	'centerweightedareasize' => { 309 => '7.1', 310 => '8.1', 312 => '8.1', 313 => '8.1', 317 => '7.1', 318 => '5.1', 319 => '7.1', 320 => '6.3', 322 => '8.1', 323 => '8.1', 324 => '8.1', 325 => 0x21, 326 => 0x1f, 327 => 0x1f, 328 => 0x1f },
	'certificate' => { 556 => 'Certificate' },
	'cfainterpolationalgorithm' => { 145 => 0xe60 },
	'cfainterpolationmetric' => { 145 => 0xe61 },
	'cfaoffsetcols' => { 145 => 0xc71 },
	'cfaoffsetrows' => { 145 => 0xc6f },
	'cfapattern' => { 125 => 0xa302, 359 => 0x9, 529 => 'CFAPattern' },
	'cfapattern2' => { 125 => 0x828e },
	'cfapatterncolumns' => { 529 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 529 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 529 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 125 => 0x828d },
	'cfazipperfixthreshold' => { 145 => 0xe62 },
	'channel' => { 542 => 'channel' },
	'channela-lang' => { 542 => [\'channel','channelA-lang'] },
	'channelchannel' => { 542 => [\'channel','channelChannel'] },
	'channels' => { 162 => 'Channels' },
	'channelsubchannel1' => { 542 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 542 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 542 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 542 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 416 => 'chpl' },
	'checkmark' => { 109 => 0x10101, 114 => 0x26a },
	'checkmark2' => { 115 => 0x8e },
	'childfontfiles' => { 557 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 309 => '10.3', 310 => '11.2', 326 => 0x10b, 327 => 0x10b, 328 => 0x121 },
	'chromablurradius' => { 125 => 0xc631 },
	'chromanoisecolorspace' => { 145 => 0xe6d },
	'chromanoiseedgemapthresh' => { 145 => 0xe6c },
	'chromanoisehighfthresh' => { 145 => 0xe6a },
	'chromanoiselowfthresh' => { 145 => 0xe6b },
	'chromaticaberration' => { 109 => 0x20703, 115 => 0x66, 431 => 0xa051 },
	'chromaticaberrationb' => { 523 => 'ChromaticAberrationB', 525 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 109 => 0x20708, 115 => 0x6b },
	'chromaticaberrationcorr' => { 84 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 125 => 0x7034, 379 => 0x1, 495 => 0x900d },
	'chromaticaberrationcorrparams' => { 125 => 0x7035, 489 => 0x66a, 490 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 109 => '0x20703.0', 115 => 0x62 },
	'chromaticaberrationr' => { 523 => 'ChromaticAberrationR', 525 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 109 => 0x20707, 115 => 0x6a },
	'chromaticaberrationsetting' => { 85 => 0x6 },
	'chrominancenoisereduction' => { 109 => 0x20601, 115 => 0x5e, 434 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 115 => 0x60 },
	'circadatecreated' => { 537 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 523 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 525 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 523 => 'CircularGradientBasedCorrections', 525 => 'CircularGradientBasedCorrections' },
	'city' => { 138 => 0x5a, 168 => 'City', 354 => 0x6d, 540 => 'City' },
	'city2' => { 354 => 0x80 },
	'clarity' => { 37 => 0x33, 133 => 0x100f, 261 => 0x35, 262 => 0x3d, 458 => 0x2036, 523 => 'Clarity', 525 => 'Clarity' },
	'clarity2012' => { 523 => 'Clarity2012', 525 => 'Clarity2012' },
	'claritycontrol' => { 390 => 0x96 },
	'classification' => { 416 => 'clsf' },
	'classifystate' => { 138 => 0xe1 },
	'clearretouch' => { 354 => 0x7c },
	'clearretouchvalue' => { 354 => 0xa3 },
	'client' => { 552 => 'client' },
	'clientname' => { 531 => 'ClientName' },
	'clipboardaspectratio' => { 523 => 'ClipboardAspectRatio', 525 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 523 => 'ClipboardOrientation', 525 => 'ClipboardOrientation' },
	'clipfilename' => { 416 => 'clfn' },
	'clipid' => { 416 => 'clid' },
	'clmodeshootingspeed' => { 309 => '10.2', 310 => '11.3', 312 => '11.2', 313 => '11.2', 318 => '11.2', 319 => '10.2', 322 => '11.2', 323 => '11.2', 324 => '11.1', 325 => 0x3f, 326 => 0x3b, 327 => 0x3b, 328 => 0x3b },
	'cluster' => { 523 => 'Cluster', 525 => 'Cluster' },
	'cmcontrast' => { 338 => 0x2022 },
	'cmddialsreverserotation' => { 325 => 0xbe, 326 => 0xba, 327 => 0xba, 328 => 0xba },
	'cmexposurecompensation' => { 338 => 0x2000 },
	'cmhue' => { 338 => 0x2021 },
	'cmsaturation' => { 338 => 0x2020 },
	'cmsharpness' => { 338 => 0x2023 },
	'cmwhitebalance' => { 338 => 0x2001 },
	'cmwhitebalancecomp' => { 338 => 0x2002 },
	'cmwhitebalancegraypoint' => { 338 => 0x2010 },
	'codec' => { 176 => 'Codec' },
	'codedcharacterset' => { 139 => 0x5a },
	'codeversion' => { 416 => 'cver' },
	'collection' => { 343 => 'Collection' },
	'collectionname' => { 177 => [\'Collections','CollectionsCollectionName'], 416 => 'coll' },
	'collections' => { 177 => 'Collections', 517 => 'collections' },
	'collectionuri' => { 177 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 410 => 'player.movie.visual.color', 541 => 'color' },
	'coloraberrationcontrol' => { 302 => 0xc89224b },
	'coloradjustment' => { 434 => 0x14 },
	'coloradjustmentmode' => { 433 => 0x210 },
	'coloranta' => { 557 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 557 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 557 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 557 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 557 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 557 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 557 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 557 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 557 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 557 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 557 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 557 => 'Colorants' },
	'colorantswatchname' => { 557 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 557 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 557 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 557 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 163 => 'ColorBalance' },
	'colorbalanceadj' => { 302 => 0x76a43202 },
	'colorbalanceblue' => { 188 => 0x1e },
	'colorbalancegreen' => { 188 => 0x1d },
	'colorbalancered' => { 188 => 0x1c },
	'colorbalanceversion' => { 213 => 0x4, 214 => 0x4, 215 => 0x0, 216 => 0x0 },
	'colorblur' => { 115 => 0x65 },
	'colorbluron' => { 109 => 0x20704 },
	'colorbooster' => { 302 => 0x5f0e7d23 },
	'colorboostlevel' => { 296 => 0x1 },
	'colorboosttype' => { 296 => 0x0 },
	'colorchromeeffect' => { 133 => 0x1048 },
	'colorchromefxblue' => { 133 => 0x104e },
	'colorclass' => { 401 => 0xde, 402 => 'ColorClass' },
	'colorcompensationfilter' => { 191 => [0x3a,0x5f], 193 => 0x111, 458 => 0xb022 },
	'colorcompensationfiltercustom' => { 444 => 0xd, 445 => 0xc },
	'colorcompensationfilterset' => { 444 => 0x8, 445 => 0x7, 446 => 0x18, 463 => 0xf },
	'colorcontrol' => { 335 => 0x102b },
	'colorcorrection' => { 495 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 330 => 0x532 },
	'colordataversion' => { 44 => 0x0, 45 => 0x0, 46 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0, 54 => 0x0 },
	'coloreffect' => { 354 => 0x28 },
	'colorfilter' => { 118 => 0x17, 119 => 0x3017, 188 => 0x29, 196 => [0x38,0x4d,0x4f], 397 => 0x17 },
	'colorgain' => { 268 => 0x51 },
	'colorgradeblending' => { 523 => 'ColorGradeBlending', 525 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 523 => 'ColorGradeGlobalHue', 525 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 523 => 'ColorGradeGlobalLum', 525 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 523 => 'ColorGradeGlobalSat', 525 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 523 => 'ColorGradeHighlightLum', 525 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 523 => 'ColorGradeMidtoneHue', 525 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 523 => 'ColorGradeMidtoneLum', 525 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 523 => 'ColorGradeMidtoneSat', 525 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 523 => 'ColorGradeShadowLum', 525 => 'ColorGradeShadowLum' },
	'colorhue' => { 109 => 0x20900, 243 => 0x8d },
	'colorimetricreference' => { 125 => 0xc6bf },
	'colorlabel' => { 528 => 'ColorLabel' },
	'colormatrix' => { 68 => 0xa, 334 => 0x200, 335 => 0x1011, 431 => 0xa030 },
	'colormatrix1' => { 125 => 0xc621, 399 => 0x106 },
	'colormatrix2' => { 125 => 0xc622, 338 => 0x200, 399 => 0x226 },
	'colormatrix3' => { 125 => 0xcd33 },
	'colormatrixa' => { 390 => 0x203 },
	'colormatrixa2' => { 390 => 0x21c },
	'colormatrixadobergb' => { 431 => 0xa032 },
	'colormatrixb' => { 390 => 0x204 },
	'colormatrixb2' => { 390 => 0x21d },
	'colormatrixnumber' => { 335 => 0x1019 },
	'colormatrixsrgb' => { 431 => 0xa031 },
	'colormode' => { 119 => 0x3015, 133 => 0x1210, 147 => 0x66, 188 => 0x28, 191 => 0x16, 193 => 0x101, 194 => 0x36, 196 => 0x7, 243 => 0x3, 291 => 0x4, 354 => 0x32, 434 => 0x2c, 458 => 0xb029, 540 => 'ColorMode' },
	'colormoirereduction' => { 109 => 0x20670, 303 => 0x15 },
	'colormoirereductionmode' => { 303 => 0x5 },
	'colormoirereductionon' => { 109 => '0x20670.0' },
	'colornoisereduction' => { 495 => 0x8029, 523 => 'ColorNoiseReduction', 525 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 523 => 'ColorNoiseReductionDetail', 525 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 303 => 0x18 },
	'colornoisereductionsharpness' => { 303 => 0x1c },
	'colornoisereductionsmoothness' => { 523 => 'ColorNoiseReductionSmoothness', 525 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 129 => 0x2 },
	'colorprofile' => { 188 => 0x33 },
	'colorprofilesettings' => { 330 => 0x539 },
	'colorrepresentation' => { 140 => 0x3c },
	'colorsaturationadj' => { 109 => 0x20305 },
	'colorsequence' => { 140 => 0x41 },
	'colorspace' => { 55 => 0x3, 69 => 0xb4, 103 => 0x10b4, 125 => 0xa001, 142 => 0x3, 169 => 'ColorSpace', 189 => 0x2f, 190 => 0x25, 191 => 0x17, 243 => 0x1e, 330 => 0x507, 390 => 0x37, 431 => 0xa011, 434 => 0xb, 444 => 0x1b, 445 => 0x83, 446 => 0xe, 463 => 0x6, 529 => 'ColorSpace' },
	'colorspace2' => { 68 => 0x9 },
	'colorspecapproximation' => { 142 => 0x2 },
	'colorspecdata' => { 142 => 0x3 },
	'colorspecmethod' => { 142 => 0x0 },
	'colorspecprecedence' => { 142 => 0x1 },
	'colortempasshot' => { 41 => 0x4, 42 => 0x7, 43 => 0x1d, 44 => 0x59, 45 => 0x6d, 46 => 0x6d, 47 => 0x26, 48 => 0x43, 51 => 0x43, 52 => 0x43, 53 => 0x43, 54 => 0x4b },
	'colortempauto' => { 41 => 0x9, 42 => 0xf, 43 => 0x22, 44 => 0x5e, 45 => 0x72, 47 => 0x1c, 48 => 0x48, 51 => 0x48, 52 => 0x48, 53 => 0x48, 54 => 0x50 },
	'colortempcloudy' => { 41 => 0x22, 42 => 0x37, 43 => 0x31, 44 => 0xa4, 45 => 0xdb, 46 => 0x7c, 47 => 0x35, 48 => 0x5c, 51 => 0x75, 52 => 0x8e, 53 => 0x93, 54 => 0x96, 390 => 0x55 },
	'colortempcustom' => { 48 => 0x84 },
	'colortempcustom1' => { 43 => 0x45 },
	'colortempcustom2' => { 43 => 0x4a },
	'colortempdaylight' => { 41 => 0x18, 42 => 0x27, 43 => 0x27, 44 => 0x9a, 45 => 0xd1, 46 => 0x72, 47 => 0x2b, 48 => 0x52, 51 => 0x6b, 52 => 0x84, 53 => 0x89, 54 => 0x8c, 390 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 69 => 0xae, 79 => 0x9, 103 => 0x10ae, 133 => 0x1005, 145 => 0x846, 163 => 'ColorTemperature', 189 => [0x6e,0x49], 190 => 0x3f, 191 => [0x39,0x5e], 193 => 0x10b, 196 => [0x3c,0x4c,0x4e], 349 => 0x321, 390 => 0x50, 424 => 0x1308, 458 => 0xb021, 523 => 'Temperature', 525 => 'Temperature' },
	'colortemperatureadj' => { 495 => 0x8013 },
	'colortemperatureauto' => { 243 => 0x4f },
	'colortemperaturebg' => { 335 => 0x1013 },
	'colortemperaturecustom' => { 444 => 0xc, 445 => 0xb },
	'colortemperaturerg' => { 335 => 0x1014 },
	'colortemperatureset' => { 444 => 0x7, 445 => 0x6 },
	'colortemperaturesetting' => { 191 => 0x25, 446 => 0x17, 463 => 0xe },
	'colortempflash' => { 41 => 0x36, 42 => 0x57, 43 => 0x40, 44 => 0xb8, 45 => 0xef, 46 => 0x8b, 47 => 0x49, 48 => 0x70, 51 => 0x89, 52 => 0xa2, 53 => 0xa7, 54 => 0xaa, 390 => 0x5a },
	'colortempflashdata' => { 48 => 0x24a },
	'colortempfluorescent' => { 41 => 0x2c, 42 => 0x47, 43 => 0x3b, 44 => 0xae, 45 => 0xe5, 46 => 0x86, 47 => 0x3f, 48 => 0x66, 51 => 0x7f, 52 => 0x98, 53 => 0x9d, 54 => 0xa0 },
	'colortempfluorescentd' => { 390 => 0x57 },
	'colortempfluorescentn' => { 390 => 0x58 },
	'colortempfluorescentw' => { 390 => 0x59 },
	'colortempkelvin' => { 41 => 0x31, 42 => 0x4f, 44 => 0xb3, 45 => 0xea, 47 => 0x44, 48 => 0x6b, 51 => 0x84, 52 => 0x9d, 53 => 0xa2, 54 => 0xa5, 354 => 0x44, 424 => 0x1307 },
	'colortempmeasured' => { 41 => 0xe, 42 => 0x17, 44 => 0x63, 45 => 0x77, 48 => 0x4d, 51 => 0x4d, 52 => 0x4d, 53 => 0x4d, 54 => 0x55 },
	'colortemppc1' => { 47 => 0x94, 48 => 0x75 },
	'colortemppc2' => { 47 => 0x99, 48 => 0x7a },
	'colortemppc3' => { 47 => 0x9e, 48 => 0x7f },
	'colortempshade' => { 41 => 0x1d, 42 => 0x2f, 43 => 0x2c, 44 => 0x9f, 45 => 0xd6, 46 => 0x77, 47 => 0x30, 48 => 0x57, 51 => 0x70, 52 => 0x89, 53 => 0x8e, 54 => 0x91, 390 => 0x54 },
	'colortemptungsten' => { 41 => 0x27, 42 => 0x3f, 43 => 0x36, 44 => 0xa9, 45 => 0xe0, 46 => 0x81, 47 => 0x3a, 48 => 0x61, 51 => 0x7a, 52 => 0x93, 53 => 0x98, 54 => 0x9b, 390 => 0x56 },
	'colortempunknown' => { 41 => 0x13, 42 => 0x1f, 44 => 0x68, 45 => 0x7c, 47 => 0x21, 51 => 0x52, 52 => 0x52, 53 => 0x52, 54 => 0x5a },
	'colortempunknown10' => { 41 => 0x63, 42 => 0x9f, 44 => 0x95, 45 => 0xa9, 46 => 0xb8, 47 => 0x76, 51 => 0xa2, 52 => 0x7f, 53 => 0x7f, 54 => 0x87 },
	'colortempunknown11' => { 41 => 0x68, 42 => 0xa7, 44 => 0xbd, 45 => [0xae,0xb3], 46 => 0xbd, 47 => 0x7b, 51 => 0xa7, 52 => 0xa7, 53 => 0x84, 54 => 0xaf },
	'colortempunknown12' => { 41 => 0x6d, 42 => 0xaf, 44 => 0xc2, 45 => 0xb8, 46 => 0xc2, 47 => 0x80, 51 => 0xac, 52 => 0xac, 53 => 0xac, 54 => 0xb4 },
	'colortempunknown13' => { 41 => 0x72, 42 => 0xb7, 44 => 0xc7, 45 => 0xbd, 46 => 0xc7, 47 => 0x85, 51 => 0xb1, 52 => 0xb1, 53 => 0xb1, 54 => 0xb9 },
	'colortempunknown14' => { 44 => 0xcc, 45 => 0xc2, 46 => 0xcc, 47 => 0x8a, 51 => 0xb6, 52 => 0xb6, 53 => 0xb6, 54 => 0xbe },
	'colortempunknown15' => { 44 => 0xd1, 45 => 0xc7, 46 => 0xd1, 47 => 0x8f, 51 => 0xbb, 52 => 0xbb, 53 => 0xbb, 54 => 0xc3 },
	'colortempunknown16' => { 44 => 0xd6, 45 => 0xcc, 46 => 0xd6, 47 => 0xa3, 52 => 0xc0, 53 => 0xc0, 54 => 0xc8 },
	'colortempunknown17' => { 44 => 0xdb, 45 => 0xf4, 46 => 0xdb, 52 => 0xc5, 53 => 0xc5, 54 => 0xcd },
	'colortempunknown18' => { 44 => 0xe0, 45 => 0xf9, 46 => 0xe0, 52 => 0xca, 53 => 0xca, 54 => 0xd2 },
	'colortempunknown19' => { 44 => 0xe5, 45 => 0xfe, 46 => 0xe5, 52 => 0xcf, 53 => 0xcf, 54 => 0xd7 },
	'colortempunknown2' => { 41 => 0x3b, 42 => 0x5f, 44 => 0x6d, 45 => 0x81, 46 => 0x90, 47 => 0x4e, 51 => 0x57, 52 => 0x57, 53 => 0x57, 54 => 0x5f },
	'colortempunknown20' => { 44 => 0xea, 45 => 0x103, 46 => 0xea, 52 => 0xd4, 53 => 0xd4, 54 => 0xdc },
	'colortempunknown21' => { 44 => 0xef, 45 => 0x108, 46 => 0xef, 53 => 0xd9, 54 => 0xe1 },
	'colortempunknown22' => { 44 => 0xf4, 45 => 0x10d, 46 => 0xf4, 53 => 0xde, 54 => 0xe6 },
	'colortempunknown23' => { 44 => 0xf9, 45 => 0x112, 46 => 0xf9, 53 => 0xe3, 54 => 0xeb },
	'colortempunknown24' => { 44 => 0xfe, 45 => 0x117, 46 => 0xfe, 53 => 0xe8, 54 => 0xf0 },
	'colortempunknown25' => { 44 => 0x103, 45 => 0x11c, 46 => 0x103, 53 => 0xed, 54 => 0xf5 },
	'colortempunknown26' => { 44 => 0x108, 45 => 0x121, 46 => 0x108, 53 => 0xf2, 54 => 0xfa },
	'colortempunknown27' => { 44 => 0x10d, 45 => 0x126, 46 => 0x10d, 53 => 0xf7, 54 => 0xff },
	'colortempunknown28' => { 44 => 0x112, 46 => 0x112, 53 => 0xfc, 54 => 0x104 },
	'colortempunknown29' => { 44 => 0x117, 46 => 0x117, 53 => 0x101, 54 => 0x109 },
	'colortempunknown3' => { 41 => 0x40, 42 => 0x67, 44 => 0x72, 45 => 0x86, 46 => 0x95, 47 => 0x53, 51 => 0x5c, 52 => 0x5c, 53 => 0x5c, 54 => 0x64 },
	'colortempunknown30' => { 46 => 0x11c, 53 => 0x106 },
	'colortempunknown31' => { 46 => 0x121 },
	'colortempunknown32' => { 46 => 0x126 },
	'colortempunknown33' => { 46 => 0x12b },
	'colortempunknown4' => { 41 => 0x45, 42 => 0x6f, 44 => 0x77, 45 => 0x8b, 46 => 0x9a, 47 => 0x58, 51 => 0x61, 52 => 0x61, 53 => 0x61, 54 => 0x69 },
	'colortempunknown5' => { 41 => 0x4a, 42 => 0x77, 44 => 0x7c, 45 => 0x90, 46 => 0x9f, 47 => 0x5d, 51 => 0x66, 52 => 0x66, 53 => 0x66, 54 => 0x6e },
	'colortempunknown6' => { 41 => 0x4f, 42 => 0x7f, 44 => 0x81, 45 => 0x95, 46 => 0xa4, 47 => 0x62, 51 => 0x8e, 52 => 0x6b, 53 => 0x6b, 54 => 0x73 },
	'colortempunknown7' => { 41 => 0x54, 42 => 0x87, 44 => 0x86, 45 => 0x9a, 46 => 0xa9, 47 => 0x67, 51 => 0x93, 52 => 0x70, 53 => 0x70, 54 => 0x78 },
	'colortempunknown8' => { 41 => 0x59, 42 => 0x8f, 44 => 0x8b, 45 => 0x9f, 46 => 0xae, 47 => 0x6c, 51 => 0x98, 52 => 0x75, 53 => 0x75, 54 => 0x7d },
	'colortempunknown9' => { 41 => 0x5e, 42 => 0x97, 44 => 0x90, 45 => 0xa4, 46 => 0xb3, 47 => 0x71, 51 => 0x9d, 52 => 0x7a, 53 => 0x7a, 54 => 0x82 },
	'colortint' => { 353 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 37 => 0x2a, 55 => 0x2, 68 => 0x8 },
	'colortoneadj' => { 109 => 0x20304, 114 => 0x11e },
	'colortoneauto' => { 76 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 75 => 0x6c, 76 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 75 => 0x3c, 76 => 0x3c },
	'colortonemonochrome' => { 75 => 0x84, 76 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 75 => 0x54, 76 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 75 => 0x24, 76 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 75 => 0xc, 76 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 75 => 0x9c, 76 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 75 => 0xb4, 76 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 75 => 0xcc, 76 => 0xe4 },
	'columninterleavefactor' => { 125 => 0xcd43 },
	'comlenblksize' => { 145 => 0xfde8 },
	'commanddialframeadvancezoom' => { 253 => 0x804 },
	'commanddialplaybackmode' => { 326 => 0x1cb, 327 => 0x1cb, 328 => 0x1e3 },
	'commanddials' => { 320 => '5.1' },
	'commanddialsaperturesetting' => { 309 => '17.3', 310 => '18.3', 312 => '18.3', 313 => '18.3', 318 => '33.3', 319 => '17.3', 322 => '18.3', 323 => '18.3' },
	'commanddialschangemainsub' => { 309 => '17.2', 310 => '18.1', 312 => '18.1', 313 => '18.1', 318 => '33.2', 319 => '17.2', 322 => '18.1', 323 => '18.1' },
	'commanddialsmenuandplayback' => { 309 => '17.4', 310 => '18.2', 312 => '18.2', 313 => '18.2', 318 => '33.4', 319 => '17.4', 322 => '18.2', 323 => '18.2' },
	'commanddialsreverserotation' => { 309 => '17.1', 310 => '6.4', 312 => '6.2', 313 => '6.2', 314 => '16.2', 315 => '17.2', 318 => '33.1', 319 => '17.1', 322 => '6.2', 323 => '6.2', 324 => '18.1' },
	'commanddialvideoplaybackmode' => { 326 => 0x1cd, 328 => 0x1e5 },
	'commanderchannel' => { 320 => '10.2', 321 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 320 => '13.1', 321 => '31.1' },
	'commandergroupa_ttlcomp' => { 324 => '32.1' },
	'commandergroupamanualoutput' => { 320 => '13.2', 321 => '28.2' },
	'commandergroupamode' => { 320 => '11.2', 321 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 320 => '14.1', 321 => '32.1' },
	'commandergroupb_ttlcomp' => { 324 => '33.1' },
	'commandergroupbmanualoutput' => { 320 => '14.2', 321 => '29.2' },
	'commandergroupbmode' => { 320 => '11.3', 321 => '29.1' },
	'commanderinternalflash' => { 320 => '11.1', 321 => '27.1' },
	'commanderinternalmanualoutput' => { 320 => '12.2', 321 => '27.2' },
	'commanderinternalttlchannel' => { 318 => '18.2' },
	'commanderinternalttlcomp' => { 320 => '12.1', 321 => '30.2', 324 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 318 => '20.1', 319 => '26.1' },
	'commanderinternalttlcompgroupa' => { 318 => '21.1', 319 => '27.1' },
	'commanderinternalttlcompgroupb' => { 318 => '22.1', 319 => '28.1' },
	'comment' => { 0 => 0x2, 126 => 'Comment', 164 => 'Comment', 343 => 'Comment', 408 => "\xa9cmt", 410 => 'comment', 416 => "\xa9cmt" },
	'compass' => { 427 => 0x4 },
	'compatiblebrands' => { 410 => 'compatible_brands' },
	'compatibleversion' => { 523 => 'CompatibleVersion', 525 => 'CompatibleVersion' },
	'compilation' => { 408 => 'cpil' },
	'compimageimagespersequence' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 530 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 542 => 'complianceProfile' },
	'componentsconfiguration' => { 125 => 0x9101, 169 => 'Components', 529 => 'ComponentsConfiguration' },
	'componentversion' => { 103 => 0x80c },
	'composer' => { 186 => 'WM/Composer', 408 => ["\xa9com","\xa9wrt"], 416 => ["\xa9com","\xa9wrt"], 552 => 'composer' },
	'composerid' => { 408 => 'cmID' },
	'composerkeywords' => { 416 => "\xa9cok" },
	'compositeimage' => { 125 => 0xa460, 530 => 'CompositeImage' },
	'compositeimagecount' => { 125 => 0xa461, 530 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 125 => 0xa462, 530 => 'CompositeImageExposureTimes' },
	'composition' => { 511 => 'Composition' },
	'compositionadjust' => { 388 => '0.1' },
	'compositionadjustrotation' => { 388 => 0x7 },
	'compositionadjustx' => { 388 => 0x5 },
	'compositionadjusty' => { 388 => 0x6 },
	'compressedbitsperpixel' => { 125 => 0x9102, 529 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 193 => 0x40, 335 => 0x40 },
	'compression' => { 125 => 0x103, 359 => 0xb, 548 => 'Compression' },
	'compressionfactor' => { 330 => 0x50d },
	'compressionformat' => { 68 => 0x4 },
	'compressionratio' => { 169 => 'Compression', 335 => 0x1034 },
	'compressorversion' => { 416 => 'CNCV' },
	'condadobvfactor' => { 145 => 0xf3e },
	'condadodaybvthresh' => { 145 => 0xf3c },
	'condadodayoffsets' => { 145 => 0xf42 },
	'condadofluoffsets' => { 145 => 0xf44 },
	'condadofluthresh' => { 145 => 0xf41 },
	'condadoillfactor' => { 145 => 0xf3f },
	'condadoneurange' => { 145 => 0xf3d },
	'condadotunoffsets' => { 145 => 0xf43 },
	'condadotunthresh' => { 145 => 0xf40 },
	'conductor' => { 186 => 'WM/Conductor', 408 => "\xa9con" },
	'confidence' => { 506 => 'Confidence' },
	'confidencelevel' => { 519 => 'ConfidenceLevel' },
	'confidencemime' => { 506 => 'ConfidenceMime' },
	'constrainedcropheight' => { 114 => 0x266, 401 => 0xd6 },
	'constrainedcropwidth' => { 114 => 0x262, 401 => 0xd5 },
	'contact' => { 138 => 0x76 },
	'contactinfo' => { 523 => 'ContactInfo', 525 => 'ContactInfo', 541 => 'contactInfo' },
	'container' => { 499 => 'Container' },
	'containerdirectory' => { 499 => [\'Container','ContainerDirectory'], 504 => 'Directory' },
	'containerdirectoryitem' => { 499 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 499 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 499 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 499 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 499 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 537 => 'ContainerFormat' },
	'containerformatidentifier' => { 537 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 537 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 408 => "\xa9day", 416 => ['@day',"\xa9day"] },
	'contentdistributor' => { 186 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 416 => 'cdis' },
	'contentid' => { 416 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 410 => 'content.identifier' },
	'contentlocationcode' => { 138 => 0x1a },
	'contentlocationname' => { 138 => 0x1b },
	'contenttype' => { 542 => 'contentType' },
	'continuousbracketing' => { 191 => 0x20 },
	'continuousdrive' => { 37 => 0x5 },
	'continuousmodedisplay' => { 325 => 0x55, 326 => 0x51, 327 => 0x51, 328 => 0x51 },
	'continuousmodeliveview' => { 323 => '77.2' },
	'continuousshootingspeed' => { 90 => 0x610 },
	'continuousshotlimit' => { 90 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 37 => 0xd, 118 => 0xc, 119 => [0x3012,0x20], 125 => [0xa408,0xfe54], 133 => [0x1004,0x1006], 163 => 'Contrast', 183 => 'Contrast', 188 => 0x20, 189 => 0x31, 190 => 0x27, 191 => 0x19, 196 => 0x2, 260 => 0x33, 261 => 0x37, 262 => 0x3f, 335 => 0x1029, 354 => 0x39, 356 => 0x300a, 390 => 0x20, 397 => 0xc, 410 => 'player.movie.visual.contrast', 418 => 0x24, 420 => 0x52, 424 => 0x1012, 434 => 0xd, 444 => 0x1d, 445 => 0x1a, 458 => 0x2004, 523 => 'Contrast', 525 => 'Contrast', 529 => 'Contrast' },
	'contrast2012' => { 523 => 'Contrast2012', 525 => 'Contrast2012' },
	'contrastadj' => { 109 => 0x20303, 114 => 0x115, 305 => 0x2c, 495 => 0x8017 },
	'contrastauto' => { 76 => 0x90 },
	'contrastcurve' => { 243 => 0x8c },
	'contrastdetectaf' => { 200 => 0x4 },
	'contrastdetectafarea' => { 390 => 0x231 },
	'contrastdetectafinfocus' => { 200 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 75 => 0x60, 76 => 0x60 },
	'contrasthighlight' => { 390 => 0x6d },
	'contrasthighlightshadowadj' => { 390 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 75 => 0x30, 76 => 0x30 },
	'contrastmode' => { 354 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 75 => 0x78, 76 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 75 => 0x48, 76 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 75 => 0x18, 76 => 0x18 },
	'contrastsetting' => { 330 => 0x505, 338 => 0x1012, 446 => 0x10, 463 => 0x8 },
	'contrastshadow' => { 390 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 75 => 0x0, 76 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 75 => 0x90, 76 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 75 => 0xa8, 76 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 75 => 0xc0, 76 => 0xd8 },
	'contributedmedia' => { 552 => 'contributedMedia' },
	'contributedmediaduration' => { 552 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 552 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 552 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 552 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 552 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 552 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 552 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 552 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 552 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 552 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 526 => 'contributor', 537 => 'Contributor' },
	'contributoridentifier' => { 537 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 537 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 537 => [\'Contributor','ContributorRole'] },
	'contributors' => { 164 => 'Contributors' },
	'controldialset' => { 191 => 0x46 },
	'controlledvocabularyterm' => { 537 => 'CVterm' },
	'controllerboardversion' => { 349 => 0x332 },
	'controlmode' => { 82 => 0x12 },
	'controlringresponse' => { 325 => 0x1cf, 326 => 0x1d5, 327 => 0x1d5, 328 => 0x1ed },
	'controlringrotation' => { 90 => 0x712 },
	'conversionlens' => { 331 => 0x403, 354 => 0x35 },
	'converter' => { 125 => 0xfe4d, 291 => 0xb, 523 => 'Converter', 525 => 'Converter' },
	'converttograyscale' => { 523 => 'ConvertToGrayscale', 525 => 'ConvertToGrayscale' },
	'cookingequipment' => { 544 => 'cookingEquipment' },
	'cookingmethod' => { 544 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 125 => 0x8298, 164 => 'Copyright', 343 => 'Copyright', 359 => 0x8298, 390 => 0x22f, 406 => 'Copyright', 408 => ['cprt',"\xa9cpy"], 410 => 'copyright', 416 => ['cprt',"\xa9cpy"], 523 => 'Copyright', 525 => 'Copyright', 539 => 'Copyright', 545 => 'copyright', 548 => 'Copyright', 552 => 'copyright' },
	'copyrightflag' => { 404 => 0x40a },
	'copyrightnotice' => { 138 => 0x74 },
	'copyrightowner' => { 340 => 'CopyrightOwner' },
	'copyrightownerid' => { 340 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 340 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 340 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 340 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 340 => 'CopyrightStatus' },
	'copyrightyear' => { 537 => 'CopyrightYear', 542 => 'copyrightYear' },
	'coringfilter' => { 334 => 0x310, 335 => 0x102d, 338 => 0x310 },
	'coringvalues' => { 334 => 0x311, 338 => 0x311 },
	'corporateentity' => { 542 => 'corporateEntity' },
	'correctionalreadyapplied' => { 344 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 353 => 0x35b },
	'country' => { 168 => 'Country', 354 => 0x69, 540 => 'Country' },
	'country-primarylocationcode' => { 138 => 0x64 },
	'country-primarylocationname' => { 138 => 0x65 },
	'countrycode' => { 242 => 0x5, 402 => 'CountryCode', 536 => 'CountryCode' },
	'course' => { 544 => 'course' },
	'coverage' => { 526 => 'coverage' },
	'coverart' => { 408 => 'covr' },
	'coverdate' => { 542 => 'coverDate' },
	'coverdisplaydate' => { 542 => 'coverDisplayDate' },
	'coveruri' => { 416 => 'cvru' },
	'cpufirmwareversion' => { 390 => 0x28 },
	'crc32' => { 527 => 'crc32' },
	'createdate' => { 125 => 0x9004, 164 => 'CreateDate', 339 => 'CreationDate', 343 => 'create-date', 406 => 'CreationDate', 413 => 0x1, 550 => 'CreateDate' },
	'creationdate' => { 410 => 'creationdate', 539 => 'CreationDate', 542 => 'creationDate' },
	'creationtime' => { 343 => 'Creation Time', 410 => 'creation_time' },
	'creativestyle' => { 444 => 0x1a, 445 => 0x18, 455 => 0x41, 458 => 0xb020, 490 => 0x4a },
	'creativestylesetting' => { 446 => 0xf, 463 => 0x7 },
	'creativestylewaschanged' => { 495 => 0x8001 },
	'creator' => { 339 => 'Creator', 406 => 'Creator', 526 => 'creator', 537 => 'Creator', 539 => 'Creator' },
	'creatoraddress' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 185 => 'CreatorAppId' },
	'creatorcity' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 536 => 'CreatorContactInfo' },
	'creatorcountry' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 537 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 402 => 'CreatorIdentity' },
	'creatorname' => { 537 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 185 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 537 => [\'Creator','CreatorRole'] },
	'creatortool' => { 550 => 'CreatorTool' },
	'creatorworkemail' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 536 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 138 => 0x6e, 540 => 'Credit' },
	'creditline' => { 545 => 'creditLine' },
	'creditlinereq' => { 555 => 'CreditLineReq' },
	'creditlinerequired' => { 340 => 'CreditLineRequired' },
	'cropactive' => { 107 => 0x0, 114 => 0x244 },
	'cropangle' => { 107 => 0x8, 523 => 'CropAngle', 525 => 'CropAngle' },
	'croparea' => { 243 => 0x45, 495 => 0x9011 },
	'cropaspectratio' => { 109 => 0x30101, 114 => 0x260 },
	'cropaspectratiocustom' => { 109 => 0x30102 },
	'cropbottom' => { 129 => 0x9, 297 => 0x36, 359 => 0x31, 401 => 0xdc, 523 => 'CropBottom', 525 => 'CropBottom' },
	'cropbottommargin' => { 57 => 0x3 },
	'cropcircleactive' => { 115 => 0xd6 },
	'cropcircleradius' => { 115 => 0xd9 },
	'cropcirclex' => { 115 => 0xd7 },
	'cropcircley' => { 115 => 0xd8 },
	'cropconstraintowarp' => { 523 => 'CropConstrainToWarp', 525 => 'CropConstrainToWarp' },
	'cropflag' => { 133 => 0x1051 },
	'croph' => { 516 => 'CropH' },
	'cropheight' => { 107 => 0x6, 114 => 0x24c, 334 => 0x615, 338 => 0x615, 523 => 'CropHeight', 525 => 'CropHeight' },
	'crophispeed' => { 243 => 0x1b },
	'cropleft' => { 114 => 0x246, 129 => 0x6, 297 => 0x1e, 334 => 0x612, 338 => 0x612, 359 => 0x30, 401 => 0xd9, 523 => 'CropLeft', 525 => 'CropLeft' },
	'cropleftmargin' => { 57 => 0x0 },
	'cropmode' => { 133 => 0x104d, 424 => 0x1018 },
	'croporiginalheight' => { 107 => 0xb },
	'croporiginalwidth' => { 107 => 0xa },
	'cropoutputheight' => { 297 => 0xce },
	'cropoutputheightinches' => { 297 => 0x96 },
	'cropoutputpixels' => { 297 => 0xd6 },
	'cropoutputresolution' => { 297 => 0xb6 },
	'cropoutputscale' => { 297 => 0xbe },
	'cropoutputwidth' => { 297 => 0xc6 },
	'cropoutputwidthinches' => { 297 => 0x8e },
	'croppedareaimageheightpixels' => { 509 => 'CroppedAreaImageHeightPixels', 510 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 509 => 'CroppedAreaImageWidthPixels', 510 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 509 => 'CroppedAreaLeftPixels', 510 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 509 => 'CroppedAreaTopPixels', 510 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 424 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 424 => 0x1603 },
	'cropping' => { 495 => 0x9010 },
	'cropright' => { 129 => 0x8, 297 => 0x2e, 359 => 0x32, 401 => 0xdb, 523 => 'CropRight', 525 => 'CropRight' },
	'croprightmargin' => { 57 => 0x1 },
	'croprotatedoriginalheight' => { 107 => 0x2 },
	'croprotatedoriginalwidth' => { 107 => 0x1 },
	'croprotation' => { 107 => 0x7, 129 => 0xb },
	'cropscaledresolution' => { 297 => 0x9e },
	'cropsize' => { 133 => 0x1053 },
	'cropsourceresolution' => { 297 => 0xae },
	'croptop' => { 114 => 0x248, 129 => 0x7, 297 => 0x26, 334 => 0x613, 338 => 0x613, 359 => 0x2f, 401 => 0xda, 523 => 'CropTop', 525 => 'CropTop' },
	'croptopleft' => { 133 => 0x1052 },
	'croptopmargin' => { 57 => 0x2 },
	'cropunit' => { 523 => 'CropUnit', 525 => 'CropUnit' },
	'cropunits' => { 523 => 'CropUnits', 525 => 'CropUnits' },
	'cropw' => { 516 => 'CropW' },
	'cropwidth' => { 107 => 0x5, 114 => 0x24a, 334 => 0x614, 338 => 0x614, 523 => 'CropWidth', 525 => 'CropWidth' },
	'cropx' => { 107 => 0x3, 516 => 'CropX' },
	'cropy' => { 107 => 0x4, 516 => 'CropY' },
	'crossprocess' => { 390 => 0x7b },
	'crossprocessparams' => { 390 => 0x235 },
	'cuisine' => { 544 => 'cuisine' },
	'currenticcprofile' => { 125 => 0xc691 },
	'currentpreprofilematrix' => { 125 => 0xc692 },
	'currentversion' => { 495 => 0xd000 },
	'curve0x' => { 516 => 'Curve0x' },
	'curve0y' => { 516 => 'Curve0y' },
	'curve1x' => { 516 => 'Curve1x' },
	'curve1y' => { 516 => 'Curve1y' },
	'curve2x' => { 516 => 'Curve2x' },
	'curve2y' => { 516 => 'Curve2y' },
	'curve3x' => { 516 => 'Curve3x' },
	'curve3y' => { 516 => 'Curve3y' },
	'curve4x' => { 516 => 'Curve4x' },
	'curve4y' => { 516 => 'Curve4y' },
	'curves' => { 302 => 0x76a43201 },
	'custom1' => { 340 => 'Custom1' },
	'custom10' => { 340 => 'Custom10' },
	'custom2' => { 340 => 'Custom2' },
	'custom3' => { 340 => 'Custom3' },
	'custom4' => { 340 => 'Custom4' },
	'custom5' => { 340 => 'Custom5' },
	'custom6' => { 340 => 'Custom6' },
	'custom7' => { 340 => 'Custom7' },
	'custom8' => { 340 => 'Custom8' },
	'custom9' => { 340 => 'Custom9' },
	'customcolortone' => { 115 => 0x4c },
	'customcontrast' => { 115 => 0x4e },
	'customcontrols' => { 90 => 0x70c },
	'customdefaultunsharpfineness' => { 115 => 0xbe },
	'customdefaultunsharpstrength' => { 115 => 0xbc },
	'customdefaultunsharpthreshold' => { 115 => 0xc0 },
	'customilluminant' => { 145 => 0x405 },
	'customizedials' => { 90 => 0x715 },
	'customlinear' => { 115 => 0x4f },
	'customoutputhighlightpoint' => { 115 => 0x53 },
	'customoutputshadowpoint' => { 115 => 0x54 },
	'custompicturestyle' => { 109 => 0x10021 },
	'custompicturestyledata' => { 109 => 0xf0500 },
	'custompicturestylefilename' => { 69 => 0x4010 },
	'customrawhighlight' => { 115 => 0x7c },
	'customrawhighlightpoint' => { 115 => 0x51 },
	'customrawshadow' => { 115 => 0x85 },
	'customrawshadowpoint' => { 115 => 0x52 },
	'customrendered' => { 125 => 0xa401, 198 => 0x6420, 529 => 'CustomRendered' },
	'customsaturation' => { 115 => 0x4d, 330 => 0x503 },
	'customsettingsalldefault' => { 309 => '0.2', 318 => '0.2' },
	'customsettingsbank' => { 309 => '0.1', 310 => '0.1', 312 => '0.1', 313 => '0.1', 318 => '0.1', 322 => '0.2', 323 => '0.2', 326 => 0x1, 327 => 0x1, 328 => 0x1 },
	'customsharpness' => { 115 => 0x50 },
	'customunsharpmaskfineness' => { 115 => 0xb8 },
	'customunsharpmaskstrength' => { 115 => 0xb6 },
	'customunsharpmaskthreshold' => { 115 => 0xba },
	'customwb_rblevels' => { 463 => 0x1a },
	'customwb_rgblevels' => { 445 => 0x8, 446 => 0x19 },
	'customwbbluelevel' => { 191 => 0x36 },
	'customwberror' => { 191 => 0x37 },
	'customwbgreenlevel' => { 191 => 0x35 },
	'customwbredlevel' => { 191 => 0x34 },
	'customwbsetting' => { 191 => 0x26 },
	'cx' => { 416 => '_cx_' },
	'cy' => { 416 => '_cy_' },
	'd-lightinghq' => { 302 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 298 => 0x2 },
	'd-lightinghqhighlight' => { 298 => 0x1 },
	'd-lightinghqselected' => { 302 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 298 => 0x0 },
	'd-lightinghs' => { 302 => 0xce5554aa },
	'd-lightinghsadjustment' => { 299 => 0x0 },
	'd-lightinghscolorboost' => { 299 => 0x1 },
	'd-rangeoptimizerhighlight' => { 495 => 0x8024 },
	'd-rangeoptimizermode' => { 495 => 0x8022 },
	'd-rangeoptimizershadow' => { 495 => 0x802d },
	'd-rangeoptimizervalue' => { 495 => 0x8023 },
	'darkblacksegrows' => { 145 => 0x18d8 },
	'darkfocusenvironment' => { 354 => 0x8003 },
	'darkframecountfactor' => { 145 => 0xc85 },
	'darkframelongexposure' => { 145 => 0xc84 },
	'darkframeshortexposure' => { 145 => 0xc83 },
	'darkpedestal' => { 145 => 0xc7f },
	'datacompressionmethod' => { 140 => 0x6e },
	'dataimprint' => { 188 => 0x34 },
	'datamining' => { 340 => 'DataMining' },
	'dataonscreen' => { 537 => 'DataOnScreen' },
	'dataonscreenregion' => { 537 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 537 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 537 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 537 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 537 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 537 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 537 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 537 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 390 => 0x3d },
	'date' => { 390 => 0x6, 526 => 'date' },
	'dateacquired' => { 185 => 'DateAcquired', 186 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 138 => 0x37, 540 => 'DateCreated' },
	'datedisplayformat' => { 294 => 0x3 },
	'dateidentified' => { 124 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 314 => '4.2' },
	'daterecieved' => { 542 => 'dateRecieved' },
	'datesent' => { 139 => 0x46 },
	'datestampmode' => { 69 => 0x1c, 243 => 0x9d },
	'datetime' => { 517 => 'datetime', 548 => 'DateTime' },
	'datetimedigitized' => { 529 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 106 => 0x0, 125 => 0x9003, 161 => 0x14, 164 => 'OriginalDate', 411 => 'IDIT', 416 => 'date', 418 => 0xb, 419 => 0x3b, 420 => 0x3e, 529 => 'DateTimeOriginal' },
	'datetimestamp' => { 147 => 0x64 },
	'datetimeutc' => { 330 => 0x908 },
	'daylightsavings' => { 83 => 0x3, 294 => 0x2 },
	'dayofweek' => { 419 => 0x42, 420 => 0x4a },
	'dccontinent' => { 124 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 124 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 124 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 124 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 124 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 124 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 124 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 124 => 'Event' },
	'dcfootprintspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 124 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 124 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 124 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 124 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 124 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 124 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 124 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 124 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 124 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 124 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 124 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 124 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 124 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 124 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 124 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 124 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 124 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 124 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 124 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 172 => 'Declination' },
	'decposition' => { 188 => 0x32 },
	'defaultautogray' => { 523 => 'DefaultAutoGray', 525 => 'DefaultAutoGray' },
	'defaultautotone' => { 523 => 'DefaultAutoTone', 525 => 'DefaultAutoTone' },
	'defaultblackrender' => { 125 => 0xc7a6 },
	'defaultcroporigin' => { 125 => 0xc61f },
	'defaultcropsize' => { 125 => 0xc620 },
	'defaulteraseoption' => { 90 => 0x813 },
	'defaultscale' => { 125 => 0xc61e },
	'defaultsspecifictoiso' => { 523 => 'DefaultsSpecificToISO', 525 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 523 => 'DefaultsSpecificToSerial', 525 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 125 => 0xc7b5 },
	'defectisocode' => { 145 => 0x90f },
	'defringe' => { 523 => 'Defringe', 525 => 'Defringe' },
	'defringegreenamount' => { 523 => 'DefringeGreenAmount', 525 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 523 => 'DefringeGreenHueHi', 525 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 523 => 'DefringeGreenHueLo', 525 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 523 => 'DefringePurpleAmount', 525 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 523 => 'DefringePurpleHueHi', 525 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 523 => 'DefringePurpleHueLo', 525 => 'DefringePurpleHueLo' },
	'dehaze' => { 523 => 'Dehaze', 525 => 'Dehaze' },
	'deletedimagecount' => { 243 => 0xa6, 273 => 0x6e },
	'deprecatedon' => { 521 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 523 => 'DepthBasedCorrections', 525 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 523 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 525 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 125 => 0xc7eb },
	'depthformat' => { 125 => 0xc7e9 },
	'depthimage' => { 506 => 'Data' },
	'depthmapinfo' => { 523 => 'DepthMapInfo', 525 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 525 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 525 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 525 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 525 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 525 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 525 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 525 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 525 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 523 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 525 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 523 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 525 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 125 => 0xc7ed },
	'depthnear' => { 125 => 0xc7ea },
	'depthunits' => { 125 => 0xc7ec },
	'derivedfrom' => { 553 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 553 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 553 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 553 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 553 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 553 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 553 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 553 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 553 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 553 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 553 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 553 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 553 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 553 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 553 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 553 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 553 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 553 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 553 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 553 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 553 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 553 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 553 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 553 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 186 => 'Description', 343 => 'Description', 408 => ['desc','dscp',"\xa9des"], 410 => 'description', 416 => 'dscp', 523 => 'Description', 525 => 'Description', 526 => 'description', 550 => 'Description' },
	'destination' => { 139 => 0x5 },
	'destinationcity' => { 390 => 0x24, 396 => 0x3 },
	'destinationcitycode' => { 397 => 0x1001 },
	'destinationdst' => { 390 => 0x26, 396 => '0.3' },
	'developmentdynamicrange' => { 133 => 0x1403 },
	'deviantmatrixcustom' => { 145 => 0x7de },
	'deviantmatrixdaylight' => { 145 => 0x7da },
	'deviantmatrixflash' => { 145 => 0x7dd },
	'deviantmatrixfluorescent' => { 145 => 0x7dc },
	'deviantmatrixtungsten' => { 145 => 0x7db },
	'deviantwhitecustom' => { 145 => 0x842 },
	'deviantwhitedaylight' => { 145 => 0x83e },
	'deviantwhiteflash' => { 145 => 0x841 },
	'deviantwhitefluorescent' => { 145 => 0x840 },
	'deviantwhitetungsten' => { 145 => 0x83f },
	'device' => { 542 => 'device' },
	'devicesettingdescription' => { 529 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 529 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 529 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 529 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 431 => 0x2 },
	'dewarpdata' => { 122 => 'DewarpData' },
	'dewarpflag' => { 122 => 'DewarpFlag' },
	'dialdirectiontvav' => { 90 => 0x706 },
	'dietaryneeds' => { 544 => 'dietaryNeeds' },
	'diffractioncompensation' => { 232 => 0x20e, 247 => 0x2ce, 248 => 0x142, 249 => 0x1b2, 250 => 0x1b2, 251 => 0x1a2, 252 => 0x1b6, 253 => 0x1b6 },
	'diffractioncorrection' => { 354 => 0xbc, 379 => 0x3 },
	'diffractioncorrectionon' => { 109 => 0x2070b },
	'digitalcreationdate' => { 138 => 0x3e },
	'digitalcreationtime' => { 138 => 0x3f },
	'digitaldeehighlightadj' => { 268 => 0x202 },
	'digitaldeeshadowadj' => { 268 => 0x200 },
	'digitaldeethreshold' => { 268 => 0x201 },
	'digitalfilter' => { 434 => 0x59 },
	'digitalfilter01' => { 376 => 0x5 },
	'digitalfilter02' => { 376 => 0x16 },
	'digitalfilter03' => { 376 => 0x27 },
	'digitalfilter04' => { 376 => 0x38 },
	'digitalfilter05' => { 376 => 0x49 },
	'digitalfilter06' => { 376 => 0x5a },
	'digitalfilter07' => { 376 => 0x6b },
	'digitalfilter08' => { 376 => 0x7c },
	'digitalfilter09' => { 376 => 0x8d },
	'digitalfilter10' => { 376 => 0x9e },
	'digitalfilter11' => { 376 => 0xaf },
	'digitalfilter12' => { 376 => 0xc0 },
	'digitalfilter13' => { 376 => 0xd1 },
	'digitalfilter14' => { 376 => 0xe2 },
	'digitalfilter15' => { 376 => 0xf3 },
	'digitalfilter16' => { 376 => 0x104 },
	'digitalfilter17' => { 376 => 0x115 },
	'digitalfilter18' => { 376 => 0x126 },
	'digitalfilter19' => { 376 => 0x137 },
	'digitalfilter20' => { 376 => 0x148 },
	'digitalgain' => { 79 => 0xb },
	'digitalgem' => { 227 => 0x0 },
	'digitalice' => { 268 => 0x100 },
	'digitalimageguid' => { 537 => 'DigImageGUID' },
	'digitallensoptimizer' => { 67 => 0xa },
	'digitallensoptimizersetting' => { 85 => 0x9 },
	'digitalroc' => { 265 => 0x0 },
	'digitalsourcefiletype' => { 537 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 537 => 'DigitalSourceType' },
	'digitalzoom' => { 37 => 0xc, 118 => 0xa, 133 => 0x1044, 147 => 0x68, 158 => 0x22, 159 => 0x1e, 163 => 'DigitalZoom', 188 => 0xc, 243 => 0x86, 291 => 0xa, 335 => 0x204, 390 => 0x1e, 397 => 0xa, 433 => 0x204, 481 => 0x12, 482 => 0x12 },
	'digitalzoomon' => { 433 => 0x21b },
	'digitalzoomratio' => { 125 => 0xa404, 469 => 0x200, 471 => 0x21c, 529 => 'DigitalZoomRatio' },
	'director' => { 186 => 'WM/Director', 408 => "\xa9dir", 410 => 'director', 416 => "\xa9dir", 552 => 'director' },
	'directorphotography' => { 552 => 'directorPhotography' },
	'directory' => { 126 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 504 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 504 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 504 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 504 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 504 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 504 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 504 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 220 => 0x3, 420 => 0x12 },
	'disableautocreation' => { 503 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 503 => 'DisableSuggestedAction' },
	'disclaimer' => { 343 => 'Disclaimer' },
	'discnumber' => { 552 => 'discNumber' },
	'dishtype' => { 544 => 'dishType' },
	'disknumber' => { 408 => 'disk' },
	'dispbutton' => { 253 => 0x7d4, 326 => 0x2ab },
	'displayallafpoints' => { 90 => 0x514 },
	'displayaperture' => { 37 => 0x23 },
	'displayedunitsx' => { 405 => 0x2 },
	'displayedunitsy' => { 405 => 0x6 },
	'displayname' => { 410 => 'displayname', 541 => 'displayName' },
	'distance1' => { 147 => 0x28 },
	'distance2' => { 147 => 0x2c },
	'distance3' => { 147 => 0x30 },
	'distance4' => { 147 => 0x34 },
	'distortion' => { 431 => 0xa050 },
	'distortioncompensation' => { 495 => 0x8040 },
	'distortioncontrol' => { 273 => 0x10 },
	'distortioncorrection' => { 84 => 0x3, 109 => 0x20705, 115 => 0x67, 125 => 0x7036, 218 => 0x4, 330 => 0x50b, 358 => '7.1', 379 => 0x0, 489 => 0x601, 490 => 0x5b },
	'distortioncorrection2' => { 334 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 520 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 109 => '0x20705.0', 115 => 0x63 },
	'distortioncorrectionsetting' => { 85 => 0x7, 458 => 0x2013 },
	'distortioncorrectionvalue' => { 84 => 0x9 },
	'distortioncorrectionversion' => { 218 => 0x0 },
	'distortioncorrparams' => { 125 => 0x7037, 468 => 0x1a23, 471 => 0x1870, 473 => 0x189c, 474 => 0x18cc, 475 => 0x17d0, 489 => 0x6ca, 490 => 0x64 },
	'distortioncorrparamsnumber' => { 471 => 0x1899, 473 => 0x18c5, 474 => 0x18f5, 475 => 0x17f9 },
	'distortioncorrparamspresent' => { 471 => 0x1898, 473 => 0x18c4, 474 => 0x18f4, 475 => 0x17f8, 477 => 0x10b, 478 => 0x10b, 489 => 0x600, 490 => 0x5a },
	'distortioneffect' => { 109 => 0x20709 },
	'distortionn' => { 358 => 0xc },
	'distortionparam02' => { 358 => 0x2 },
	'distortionparam04' => { 358 => 0x4 },
	'distortionparam08' => { 358 => 0x8 },
	'distortionparam09' => { 358 => 0x9 },
	'distortionparam11' => { 358 => 0xb },
	'distortionscale' => { 358 => 0x5 },
	'distributor' => { 542 => 'distributor' },
	'distributorproductid' => { 541 => 'distributorProductID' },
	'dloon' => { 109 => '0x20706.0', 115 => 0xdc },
	'dlosetting' => { 109 => 0x20706, 115 => 0xdd },
	'dlosettingapplied' => { 108 => 0x4 },
	'dloshootingdistance' => { 115 => 0xde },
	'dloversion' => { 108 => 0x5 },
	'dmcomment' => { 552 => 'comment' },
	'dmdithermatrix' => { 145 => 0xc7a },
	'dmdithermatrixheight' => { 145 => 0xc7c },
	'dmdithermatrixwidth' => { 145 => 0xc7b },
	'dngadobedata' => { 125 => 0xc634 },
	'dngbackwardversion' => { 125 => 0xc613 },
	'dngignoresidecars' => { 523 => 'DNGIgnoreSidecars', 525 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 125 => 0xc630 },
	'dngprivatedata' => { 125 => 0xc634 },
	'dngversion' => { 125 => 0xc612 },
	'document' => { 343 => 'Document' },
	'documentancestors' => { 540 => 'DocumentAncestors' },
	'documenthistory' => { 138 => 0xe7 },
	'documentid' => { 553 => 'DocumentID' },
	'documentname' => { 125 => 0x10d },
	'documentnotes' => { 138 => 0xe6 },
	'doi' => { 542 => 'doi' },
	'dopesheet' => { 537 => 'Dopesheet' },
	'dopesheetlink' => { 537 => 'DopesheetLink' },
	'dopesheetlinklink' => { 537 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 537 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 145 => 0xc82 },
	'dpp' => { 517 => 'dpp' },
	'dprawbokehshift' => { 109 => 0x20b20 },
	'dprawbokehshiftarea' => { 109 => 0x20b21 },
	'dprawghostingreductionarea' => { 109 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 109 => 0x20b10 },
	'dprawmicroadjuststrength' => { 109 => 0x20b12 },
	'dr4cameramodel' => { 110 => 0x3 },
	'drangepriority' => { 133 => 0x1443 },
	'drangepriorityauto' => { 133 => 0x1444 },
	'drangepriorityfixed' => { 133 => 0x1445 },
	'drivemode' => { 119 => 0x3103, 131 => '0.1', 188 => 0x6, 191 => 0x1e, 194 => 0xe, 198 => 0x64d0, 330 => 0x600, 390 => 0x34, 424 => 0x1002, 434 => 0x3, 444 => 0x4, 445 => 0x7e, 446 => 0x34 },
	'drivemode2' => { 191 => 0xa, 370 => 0x7, 455 => 0xe, 463 => 0x1 },
	'drivemodesetting' => { 446 => 0x4 },
	'drivespeed' => { 131 => '0.2' },
	'dspfirmwareversion' => { 390 => 0x27 },
	'dualpixelraw' => { 67 => 0xb },
	'duration' => { 72 => 0x6a, 162 => 'Duration', 176 => 'Duration', 544 => 'duration', 552 => 'duration' },
	'durationscale' => { 552 => [\'duration','durationScale'] },
	'durationvalue' => { 552 => [\'duration','durationValue'] },
	'dustremovaldata' => { 69 => 0x97 },
	'dxcropalert' => { 249 => 0x250, 250 => 0x250, 251 => 0x23c, 252 => 0x250, 253 => 0x250 },
	'dynamicafarea' => { 309 => '1.4', 318 => '1.4' },
	'dynamicafareasize' => { 247 => 0x370, 249 => 0x254, 250 => 0x254, 251 => 0x240, 252 => 0x254, 253 => 0x254 },
	'dynamicareaafassist' => { 325 => 0x18, 326 => 0x18, 327 => 0x18, 328 => 0x18 },
	'dynamicareaafdisplay' => { 310 => '46.1', 312 => '47.1', 313 => '47.1', 322 => '47.1', 323 => '47.1' },
	'dynamicrange' => { 133 => 0x1400 },
	'dynamicrangeboost' => { 354 => 0xee },
	'dynamicrangeexpansion' => { 390 => 0x69, 424 => 0x100e },
	'dynamicrangemax' => { 114 => 0x7c },
	'dynamicrangemin' => { 114 => 0x7a },
	'dynamicrangeoptimizer' => { 191 => 0x15, 458 => [0xb025,0xb04f], 467 => 0x1144, 468 => [0x1144,0x324], 469 => [0x1120,0x300], 470 => [0x119c,0x37c], 471 => [0x1178,0x328], 472 => [0x1030,0x50], 473 => [0x228,0x50], 474 => [0x228,0x50], 475 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 455 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 444 => 0x19, 445 => 0x17, 446 => 0xd, 455 => 0x79, 463 => 0x5 },
	'dynamicrangeoptimizermode' => { 194 => 0x15, 444 => 0x18, 445 => 0x16, 455 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 191 => 0x27, 446 => 0xc, 463 => 0x4 },
	'dynamicrangesetting' => { 133 => 0x1402 },
	'e-dialinprogram' => { 370 => '1.3' },
	'earliestageorloweststage' => { 124 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 124 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 499 => 'EarthPos' },
	'earthposaltitude' => { 499 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 499 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 499 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 499 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 499 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 499 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 499 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 499 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 324 => '6.1' },
	'easyexposurecompensation' => { 309 => '6.4', 310 => '6.5', 312 => '6.3', 313 => '6.3', 317 => '5.1', 318 => '4.4', 319 => '5.2', 322 => '6.3', 323 => '6.3', 325 => 0x1f, 326 => 0x1d, 327 => 0x1d, 328 => 0x1d },
	'easymode' => { 37 => 0xb },
	'edgemapslope' => { 145 => 0x930 },
	'edgemapx1' => { 145 => 0x931 },
	'edgemapx2' => { 145 => 0x932 },
	'edgemapx3' => { 145 => 0x934 },
	'edgemapx4' => { 145 => 0x935 },
	'edgenoisereduction' => { 303 => 0x4, 495 => 0x8028 },
	'edit1' => { 416 => "\xa9ed1" },
	'edit2' => { 416 => "\xa9ed2" },
	'edit3' => { 416 => "\xa9ed3" },
	'edit4' => { 416 => "\xa9ed4" },
	'edit5' => { 416 => "\xa9ed5" },
	'edit6' => { 416 => "\xa9ed6" },
	'edit7' => { 416 => "\xa9ed7" },
	'edit8' => { 416 => "\xa9ed8" },
	'edit9' => { 416 => "\xa9ed9" },
	'edition' => { 542 => 'edition' },
	'editorialupdate' => { 138 => 0x8 },
	'editstatus' => { 138 => 0x7, 402 => 'EditStatus', 517 => 'EditStatus' },
	'editversionname' => { 302 => 0x3d136244 },
	'effectivelv' => { 390 => 0x2d },
	'effectivemaxaperture' => { 236 => 0x12, 237 => 0x13, 241 => 0x14 },
	'eissn' => { 542 => 'eIssn' },
	'electricalblackcolumns' => { 145 => 0x1810 },
	'electronicfront-curtainshutter' => { 312 => '5.2', 313 => '5.2', 322 => '5.3', 323 => '5.2' },
	'electronicfrontcurtainshutter' => { 458 => 0x201a },
	'elevation' => { 172 => 'Elevation' },
	'email' => { 164 => 'EMail' },
	'embargodate' => { 545 => 'embargoDate' },
	'embdencrightsexpr' => { 537 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 537 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 537 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 537 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 540 => 'EmbeddedXMPDigest' },
	'emissivity' => { 127 => 0x3 },
	'emptyslotrelease' => { 247 => 0x98c, 249 => 0x723, 250 => 0x733, 251 => 0x625, 252 => 0x655, 253 => 0x6bd },
	'enablechromanoisereduction' => { 145 => 0xe6e },
	'enablesharpening' => { 145 => 0x92e },
	'encodedby' => { 186 => 'WM/EncodedBy', 408 => "\xa9enc" },
	'encodedwith' => { 410 => 'Encoded_With' },
	'encoder' => { 408 => "\xa9too", 410 => 'encoder', 416 => "\xa9too" },
	'encoderid' => { 416 => "\xa9enc" },
	'encodingtime' => { 186 => 'WM/EncodingTime' },
	'encryptionkey' => { 431 => 0xa020 },
	'endingpage' => { 542 => 'endingPage' },
	'enduser' => { 340 => 'EndUser' },
	'enduserid' => { 340 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 340 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 247 => 0x992, 249 => 0x746, 250 => 0x756, 251 => 0x648, 252 => 0x678, 253 => 0x6e0 },
	'engineer' => { 552 => 'engineer' },
	'enhancedarktones' => { 295 => 0x8 },
	'enhancedenoisealreadyapplied' => { 520 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 520 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 520 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 520 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 520 => 'EnhanceDetailsVersion' },
	'enhancement' => { 118 => 0x16, 119 => 0x3016 },
	'enhanceparams' => { 125 => 0xc7ee },
	'enhancer' => { 334 => 0x300 },
	'enhancervalues' => { 334 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 520 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 520 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 520 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 139 => 0x28 },
	'envelopepriority' => { 139 => 0x3c },
	'enveloperecordversion' => { 139 => 0x0 },
	'episode' => { 537 => 'Episode' },
	'episodeglobaluniqueid' => { 408 => 'egid' },
	'episodeidentifier' => { 537 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 537 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 537 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 335 => 0x20c },
	'epsonimagewidth' => { 335 => 0x20b },
	'epsonsoftware' => { 335 => 0x20d },
	'equipmentinstitution' => { 498 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 498 => 'EquipmentManufacturer' },
	'equipmentversion' => { 331 => 0x0 },
	'ettlii' => { 90 => 0x304, 91 => 0xd, 92 => 0xe, 93 => 0x7, 94 => 0x7, 95 => 0xe },
	'event' => { 501 => 'Event', 515 => 'Event', 537 => 'Event', 542 => 'event' },
	'eventalias' => { 541 => 'eventAlias' },
	'eventdate' => { 124 => [\'Event','EventEventDate'] },
	'eventday' => { 124 => [\'Event','EventDay'] },
	'eventearliestdate' => { 124 => [\'Event','EventEarliestDate'] },
	'eventend' => { 541 => 'eventEnd' },
	'eventenddayofyear' => { 124 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 124 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 124 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 124 => [\'Event','EventHabitat'] },
	'eventid' => { 124 => [\'Event','EventEventID'], 537 => 'EventId' },
	'eventlatestdate' => { 124 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 124 => [\'Event','EventMonth'] },
	'eventnumber' => { 418 => 0x9, 419 => 0x37, 420 => 0x3a },
	'eventparenteventid' => { 124 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 124 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 124 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 124 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 124 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 124 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 541 => 'eventStart' },
	'eventstartdayofyear' => { 124 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 541 => 'eventSubtype' },
	'eventtime' => { 124 => [\'Event','EventEventTime'] },
	'eventtype' => { 541 => 'eventType' },
	'eventverbatimeventdate' => { 124 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 124 => [\'Event','EventYear'] },
	'evfgrid' => { 325 => 0x15f, 326 => 0x165, 327 => 0x165, 328 => 0x17d },
	'evfimageframe' => { 325 => 0x15e, 326 => 0x164, 327 => 0x164, 328 => 0x17c },
	'evfreleaseindicator' => { 326 => 0x24f, 327 => 0x24f, 328 => 0x267 },
	'evfwarmdisplaybrightness' => { 326 => 0x24d, 327 => 0x24d, 328 => 0x265 },
	'evfwarmdisplaymode' => { 326 => 0x24b, 327 => 0x24b, 328 => 0x263 },
	'evsteps' => { 370 => '1.2', 372 => 0x0 },
	'evstepsize' => { 314 => '5.1', 315 => '6.1', 316 => '6.1', 320 => '0.7' },
	'exclusivecoverage' => { 511 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 545 => 'exclusivityEndDate' },
	'excursiontolerance' => { 140 => 0x82 },
	'executiveproducer' => { 408 => "\xa9xpd" },
	'exif' => { 126 => 'EXIF' },
	'exifbyteorder' => { 126 => 'ExifByteOrder' },
	'exifcamerainfo' => { 138 => 0xe8 },
	'exifimageheight' => { 125 => 0xa003, 529 => 'PixelYDimension' },
	'exifimagewidth' => { 125 => 0xa002, 529 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 126 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 125 => 0x9000, 529 => 'ExifVersion' },
	'exitpupilposition' => { 236 => 0x4, 237 => 0x4, 241 => 0x4 },
	'expirationdate' => { 138 => 0x25, 545 => 'expirationDate' },
	'expirationtime' => { 138 => 0x26 },
	'exposure' => { 125 => 0xfe51, 523 => 'Exposure', 525 => 'Exposure' },
	'exposure2012' => { 523 => 'Exposure2012', 525 => 'Exposure2012' },
	'exposureadj' => { 300 => 0x0 },
	'exposureadj2' => { 300 => 0x12 },
	'exposureadjust' => { 434 => 0xc },
	'exposurebracketingindicatorlast' => { 191 => 0x52 },
	'exposurebracketshotnumber' => { 194 => 0x2d, 455 => 0x2f },
	'exposurebracketstepsize' => { 370 => 0x8 },
	'exposurebracketvalue' => { 243 => 0x19 },
	'exposurecompautocancel' => { 90 => 0x113 },
	'exposurecompensation' => { 82 => 0x6, 99 => 0x0, 125 => 0x9204, 147 => 0x24, 163 => 'ExposureComp', 183 => 'ExposureCompensation', 188 => 0xd, 189 => 0x53, 190 => 0x1e, 194 => 0x49c0, 335 => 0x1006, 390 => 0x16, 399 => 0x402, 431 => 0xa013, 434 => [0xc,0x35,0x4d], 467 => 0x114c, 468 => 0x114c, 469 => 0x1128, 471 => 0x1180, 472 => 0x1038, 473 => 0x230, 474 => 0x230, 475 => 0x223, 529 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 463 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 253 => 0x794 },
	'exposurecompensationmode' => { 191 => 0x47, 194 => 0x2a },
	'exposurecompensationset' => { 444 => 0x3, 445 => 0x3, 446 => 0x3, 463 => 0x1e },
	'exposurecompensationsetting' => { 191 => 0x1 },
	'exposurecompstepsize' => { 309 => '6.3', 310 => '7.3', 312 => '7.3', 313 => '7.3', 318 => '4.3', 322 => '7.3', 323 => '7.3' },
	'exposurecontrolstep' => { 317 => '6.1', 319 => '6.1' },
	'exposurecontrolstepsize' => { 309 => '6.2', 310 => '7.1', 312 => '7.1', 313 => '7.1', 318 => '4.2', 322 => '7.1', 323 => '7.1', 324 => '7.1', 325 => 0x1d, 326 => 0x1b, 327 => 0x1b, 328 => 0x1b },
	'exposurecount' => { 133 => 0x1032 },
	'exposuredelay' => { 253 => 0x800, 326 => 0x2f1 },
	'exposuredelaymode' => { 309 => '10.1', 310 => '11.1', 312 => '11.1', 313 => '11.1', 314 => '9.1', 315 => '10.1', 316 => '10.1', 318 => '10.4', 319 => '10.1', 320 => '6.4', 322 => '11.1', 323 => '11.1', 324 => '11.2' },
	'exposuredifference' => { 243 => 0xe },
	'exposuregaincustom' => { 145 => 0x89c },
	'exposuregaindaylight' => { 145 => 0x898 },
	'exposuregainflash' => { 145 => 0x89b },
	'exposuregainfluorescent' => { 145 => 0x89a },
	'exposuregaintungsten' => { 145 => 0x899 },
	'exposureindex' => { 125 => 0xa215, 529 => 'ExposureIndex' },
	'exposureindicator' => { 191 => 0x50 },
	'exposurelevelincrements' => { 88 => 0x6, 89 => 0x6, 90 => 0x101, 91 => 0x5, 92 => 0x6, 93 => 0x5, 94 => 0x5, 95 => 0x6, 96 => 0x4, 444 => 0x58, 445 => 0x58 },
	'exposurelockused' => { 509 => 'ExposureLockUsed' },
	'exposuremode' => { 125 => 0xa402, 163 => 'ExposureMode', 188 => 0x1, 189 => 0xa, 190 => 0x0, 191 => 0x0, 194 => 0x34, 330 => 0x200, 351 => 0x40d, 434 => 0x8, 458 => 0xb041, 529 => 'ExposureMode' },
	'exposuremodeinmanual' => { 90 => 0x10b },
	'exposureprogram' => { 125 => 0x8822, 424 => 0x1001, 437 => [0x17e,0x43], 444 => 0x3c, 445 => 0x3c, 446 => 0x5, 450 => 0x14, 455 => 0x3f, 463 => 0x2, 467 => 0x1175, 468 => 0x1179, 469 => 0x1155, 470 => 0x11d1, 471 => 0x11ad, 472 => 0x1065, 473 => 0x25d, 474 => 0x25d, 475 => 0x24c, 486 => 0xb, 487 => 0xc, 488 => 0xb, 490 => 0x48, 529 => 'ExposureProgram' },
	'exposureshift' => { 330 => 0x203 },
	'exposurestandardadjustment' => { 458 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 82 => 0x16, 125 => 0x829a, 144 => 0xfd05, 147 => 0x20, 149 => 0xfa24, 151 => 0xf104, 154 => 0x12, 156 => 0x38, 158 => 0x14, 159 => 0x10, 161 => 0x10, 163 => 'ExposureTime', 188 => 0x9, 189 => 0x35, 190 => 0x48, 191 => 0x8, 194 => 0x49b8, 390 => 0x12, 431 => 0xa018, 434 => [0x32,0x4a], 444 => 0x0, 445 => 0x0, 463 => [0x21,0x23,0x27], 490 => 0x10, 529 => 'ExposureTime' },
	'exposuretime2' => { 434 => [0x33,0x4b] },
	'exposuretuning' => { 243 => 0x1c },
	'exposurevalue' => { 145 => 0x3 },
	'exposurewarning' => { 133 => 0x1302 },
	'exrauto' => { 133 => 0x1033 },
	'exrmode' => { 133 => 0x1034 },
	'extdescraccessibility' => { 536 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 249 => 0x120, 250 => 0x120, 251 => 0x114, 252 => 0x124, 253 => 0x124 },
	'extendedshutterspeeds' => { 325 => 0xf2, 326 => 0x102, 327 => 0x102, 328 => 0x118 },
	'extendedwbdetect' => { 330 => 0x902 },
	'extender' => { 331 => 0x301 },
	'extenderfirmwareversion' => { 331 => 0x304 },
	'extendermagnification' => { 165 => 'Magnification' },
	'extendermake' => { 165 => 'Make' },
	'extendermodel' => { 165 => 'Model', 331 => 0x303 },
	'extenderserialnumber' => { 165 => 'SerialNumber', 331 => 0x302 },
	'extenderstatus' => { 387 => 0x3 },
	'externalflash' => { 333 => 0x1201 },
	'externalflashae1' => { 335 => 0x101f },
	'externalflashae1_0' => { 335 => 0x101b },
	'externalflashae2' => { 335 => 0x1020 },
	'externalflashae2_0' => { 335 => 0x101c },
	'externalflashbounce' => { 333 => 0x1204, 335 => 0x1026, 377 => 0x1a },
	'externalflashcompensation' => { 223 => 0x1b },
	'externalflashexposurecomp' => { 243 => 0x17, 377 => 0x19 },
	'externalflashfirmware' => { 221 => 0x6, 222 => 0x6, 223 => 0x6, 224 => 0x6, 225 => 0x6, 226 => 0x6 },
	'externalflashflags' => { 221 => 0x8, 222 => 0x8, 223 => 0x8, 224 => 0x8, 226 => 0x8 },
	'externalflashguidenumber' => { 333 => 0x1203, 377 => '24.1' },
	'externalflashgvalue' => { 335 => 0x1025 },
	'externalflashmode' => { 335 => 0x1028, 377 => 0x2 },
	'externalflashreadystate' => { 225 => '9.1' },
	'externalflashstatus' => { 225 => '8.2' },
	'externalflashzoom' => { 333 => 0x1205, 335 => 0x1027 },
	'externalflashzoomoverride' => { 225 => '8.1' },
	'externalmetadatalink' => { 537 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 349 => 0x311, 352 => 0x311, 353 => 0x311, 356 => 0x3408 },
	'extrainfoversion' => { 448 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 191 => 0x40 },
	'fac100per' => { 145 => 0xe94 },
	'fac170per' => { 145 => 0xe93 },
	'fac18per' => { 145 => 0xe92 },
	'face10position' => { 116 => 0x3f4, 117 => 0x1ec, 219 => 0x28, 374 => 0x12 },
	'face10size' => { 375 => 0x12 },
	'face11position' => { 219 => 0x2c, 374 => 0x14 },
	'face11size' => { 375 => 0x14 },
	'face12position' => { 219 => 0x30, 374 => 0x16 },
	'face12size' => { 375 => 0x16 },
	'face13position' => { 374 => 0x18 },
	'face13size' => { 375 => 0x18 },
	'face14position' => { 374 => 0x1a },
	'face14size' => { 375 => 0x1a },
	'face15position' => { 374 => 0x1c },
	'face15size' => { 375 => 0x1c },
	'face16position' => { 374 => 0x1e },
	'face16size' => { 375 => 0x1e },
	'face17position' => { 374 => 0x20 },
	'face17size' => { 375 => 0x20 },
	'face18position' => { 374 => 0x22 },
	'face18size' => { 375 => 0x22 },
	'face19position' => { 374 => 0x24 },
	'face19size' => { 375 => 0x24 },
	'face1position' => { 58 => 0x8, 116 => 0xd, 117 => 0x18, 219 => 0x4, 346 => 0x1, 374 => 0x0, 421 => 0xbc, 451 => 0x1, 452 => 0x0, 453 => 0x0, 454 => 0x5b },
	'face1size' => { 375 => 0x0 },
	'face20position' => { 374 => 0x26 },
	'face20size' => { 375 => 0x26 },
	'face21position' => { 374 => 0x28 },
	'face21size' => { 375 => 0x28 },
	'face22position' => { 374 => 0x2a },
	'face22size' => { 375 => 0x2a },
	'face23position' => { 374 => 0x2c },
	'face23size' => { 375 => 0x2c },
	'face24position' => { 374 => 0x2e },
	'face24size' => { 375 => 0x2e },
	'face25position' => { 374 => 0x30 },
	'face25size' => { 375 => 0x30 },
	'face26position' => { 374 => 0x32 },
	'face26size' => { 375 => 0x32 },
	'face27position' => { 374 => 0x34 },
	'face27size' => { 375 => 0x34 },
	'face28position' => { 374 => 0x36 },
	'face28size' => { 375 => 0x36 },
	'face29position' => { 374 => 0x38 },
	'face29size' => { 375 => 0x38 },
	'face2position' => { 58 => 0xa, 116 => 0x7c, 117 => 0x4c, 219 => 0x8, 346 => 0x5, 374 => 0x2, 421 => 0xc8, 451 => 0x6, 452 => 0x20, 453 => 0x25, 454 => 0x65 },
	'face2size' => { 375 => 0x2 },
	'face30position' => { 374 => 0x3a },
	'face30size' => { 375 => 0x3a },
	'face31position' => { 374 => 0x3c },
	'face31size' => { 375 => 0x3c },
	'face32position' => { 374 => 0x3e },
	'face32size' => { 375 => 0x3e },
	'face3position' => { 58 => 0xc, 116 => 0xeb, 117 => 0x80, 219 => 0xc, 346 => 0x9, 374 => 0x4, 421 => 0xd4, 451 => 0xb, 452 => 0x40, 453 => 0x4a, 454 => 0x6f },
	'face3size' => { 375 => 0x4 },
	'face4position' => { 58 => 0xe, 116 => 0x15a, 117 => 0xb4, 219 => 0x10, 346 => 0xd, 374 => 0x6, 421 => 0xe0, 451 => 0x10, 452 => 0x60, 453 => 0x6f, 454 => 0x79 },
	'face4size' => { 375 => 0x6 },
	'face5position' => { 58 => 0x10, 116 => 0x1c9, 117 => 0xe8, 219 => 0x14, 346 => 0x11, 374 => 0x8, 421 => 0xec, 451 => 0x15, 452 => 0x80, 453 => 0x94 },
	'face5size' => { 375 => 0x8 },
	'face6position' => { 58 => 0x12, 116 => 0x238, 117 => 0x11c, 219 => 0x18, 374 => 0xa, 421 => 0xf8, 451 => 0x1a, 452 => 0xa0, 453 => 0xb9 },
	'face6size' => { 375 => 0xa },
	'face7position' => { 58 => 0x14, 116 => 0x2a7, 117 => 0x150, 219 => 0x1c, 374 => 0xc, 421 => 0x104, 451 => 0x1f, 452 => 0xc0, 453 => 0xde },
	'face7size' => { 375 => 0xc },
	'face8position' => { 58 => 0x16, 116 => 0x316, 117 => 0x184, 219 => 0x20, 374 => 0xe, 421 => 0x110, 451 => 0x24, 452 => 0xe0, 453 => 0x103 },
	'face8size' => { 375 => 0xe },
	'face9position' => { 58 => 0x18, 116 => 0x385, 117 => 0x1b8, 219 => 0x24, 374 => 0x10 },
	'face9size' => { 375 => 0x10 },
	'facebalanceorigi' => { 516 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 516 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 516 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 516 => 'FaceBalanceWarmth' },
	'facedetect' => { 390 => 0x76, 431 => 0x100 },
	'facedetectarea' => { 334 => 0x1201 },
	'facedetectframecrop' => { 334 => 0x1207 },
	'facedetectframesize' => { 58 => 0x3, 116 => 0x1, 117 => 0x4, 219 => 0x1, 334 => 0x1203, 390 => 0x77, 421 => 0xb6 },
	'facedetection' => { 446 => 0x30, 463 => 0x19 },
	'faceelementpositions' => { 133 => 0x4203 },
	'faceelementselected' => { 133 => 0x4005 },
	'faceelementtypes' => { 133 => 0x4201 },
	'faceid' => { 519 => 'FaceID' },
	'faceinfounknown' => { 119 => 0x2089 },
	'facename' => { 431 => 0x123 },
	'faceorientation' => { 117 => 0x8 },
	'faceposition' => { 373 => 0x2, 432 => 0x4 },
	'facepositions' => { 133 => 0x4103 },
	'facerecognition' => { 431 => 0x120 },
	'facesdetected' => { 58 => 0x2, 59 => 0x2, 60 => 0x3, 116 => 0x0, 117 => 0x2, 119 => 0x211c, 133 => 0x4100, 219 => 0x3, 334 => 0x1200, 354 => 0x3f, 373 => 0x0, 421 => 0xb5, 432 => 0x0, 451 => 0x0, 454 => 0x3, 466 => 0x30 },
	'facesrecognized' => { 347 => 0x0 },
	'facewidth' => { 59 => 0x1 },
	'fade' => { 458 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 115 => 0x38 },
	'faithfuloutputshadowpoint' => { 115 => 0x39 },
	'faithfulrawcolortone' => { 115 => 0x31 },
	'faithfulrawcontrast' => { 115 => 0x33 },
	'faithfulrawhighlight' => { 115 => 0x79 },
	'faithfulrawhighlightpoint' => { 115 => 0x36 },
	'faithfulrawlinear' => { 115 => 0x34 },
	'faithfulrawsaturation' => { 115 => 0x32 },
	'faithfulrawshadow' => { 115 => 0x82 },
	'faithfulrawshadowpoint' => { 115 => 0x37 },
	'faithfulrawsharpness' => { 115 => 0x35 },
	'faithfulunsharpmaskfineness' => { 115 => 0xac },
	'faithfulunsharpmaskstrength' => { 115 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 115 => 0xae },
	'far' => { 506 => 'Far' },
	'fastresetlinetime' => { 145 => 0x1860 },
	'feedidentifier' => { 537 => 'FeedIdentifier' },
	'femicroadjustment' => { 90 => 0x111 },
	'ffid' => { 527 => 'ffid' },
	'field' => { 541 => 'field' },
	'fieldcount' => { 335 => 0x103f },
	'fieldofview' => { 416 => "FOV\x00" },
	'fifoenonepixeldelay' => { 145 => 0x1901 },
	'filecreatedate' => { 126 => 'FileCreateDate' },
	'filedatarate' => { 552 => 'fileDataRate' },
	'fileformat' => { 101 => 0x0, 139 => 0x14, 434 => [0x22,0x26], 458 => 0xb000 },
	'filegroupid' => { 126 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 355 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 126 => 'FileModifyDate' },
	'filename' => { 126 => 'FileName' },
	'filenameasdelivered' => { 340 => 'FileNameAsDelivered' },
	'filenumber' => { 61 => 0x1, 69 => 0x8, 103 => 0x1817, 120 => 'Canon-FileNumber', 220 => 0x4, 420 => 0x10 },
	'filenumbermemory' => { 188 => 0x1a },
	'filenumbersequence' => { 309 => '12.2', 314 => '3.1', 315 => '4.1', 316 => '4.1', 318 => '11.1', 319 => '4.3', 324 => '5.2', 325 => 0x4e, 326 => 0x48, 327 => 0x48, 328 => 0x48 },
	'filepermissions' => { 126 => 'FilePermissions' },
	'filesource' => { 125 => 0xa300, 133 => 0x8000, 529 => 'FileSource' },
	'fileuserid' => { 126 => 'FileUserID' },
	'fileversion' => { 139 => 0x16 },
	'fillflashautoreduction' => { 88 => 0xe, 89 => 0xe, 96 => 0xa },
	'filllight' => { 523 => 'FillLight', 525 => 'FillLight' },
	'fillorder' => { 125 => 0x10a },
	'filmgraineffect' => { 330 => 0x538 },
	'filmmode' => { 133 => 0x1401, 351 => 0x412, 354 => 0x42 },
	'filmtype' => { 268 => 0x2 },
	'filtereffect' => { 61 => 0xe, 260 => 0x37, 261 => 0x3f, 262 => 0x47, 354 => 0xa1 },
	'filtereffectauto' => { 76 => 0xa0 },
	'filtereffectfaithful' => { 75 => 0x70, 76 => 0x70 },
	'filtereffectlandscape' => { 75 => 0x40, 76 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 75 => 0x88, 76 => 0x88 },
	'filtereffectneutral' => { 75 => 0x58, 76 => 0x58 },
	'filtereffectportrait' => { 75 => 0x28, 76 => 0x28 },
	'filtereffectstandard' => { 75 => 0x10, 76 => 0x10 },
	'filtereffectuserdef1' => { 75 => 0xa0, 76 => 0xb8 },
	'filtereffectuserdef2' => { 75 => 0xb8, 76 => 0xd0 },
	'filtereffectuserdef3' => { 75 => 0xd0, 76 => 0xe8 },
	'finderdisplayduringexposure' => { 89 => 0x1 },
	'finesharpness' => { 390 => 0x70 },
	'finetuneoptcenterweighted' => { 309 => '7.2', 310 => '9.1', 312 => '9.1', 313 => '9.1', 317 => '8.1', 322 => '9.1', 323 => '9.1', 324 => '9.1', 325 => 0x25, 326 => 0x23, 327 => 0x23, 328 => 0x23 },
	'finetuneopthighlightweighted' => { 312 => '46.1', 313 => '46.1', 322 => '46.1', 323 => '46.1', 325 => 0x29, 326 => 0x27, 327 => 0x27, 328 => 0x27 },
	'finetuneoptmatrixmetering' => { 309 => '8.1', 310 => '8.2', 312 => '8.2', 313 => '8.2', 317 => '7.2', 318 => '6.1', 322 => '8.2', 323 => '8.2', 324 => '8.2', 325 => 0x23, 326 => 0x21, 327 => 0x21, 328 => 0x21 },
	'finetuneoptspotmetering' => { 309 => '8.2', 310 => '9.2', 312 => '9.2', 313 => '9.2', 317 => '8.2', 318 => '6.2', 322 => '9.2', 323 => '9.2', 324 => '9.2', 325 => 0x27, 326 => 0x25, 327 => 0x25, 328 => 0x25 },
	'finishexposure' => { 145 => 0xdbd },
	'finishfiletype' => { 145 => 0xdb8 },
	'finishlook' => { 145 => 0xdbc },
	'finishnoise' => { 145 => 0xdba },
	'finishresolution' => { 145 => 0xdb9 },
	'finishsharpening' => { 145 => 0xdbb },
	'firmware' => { 335 => 0x405, 434 => [0x8c,0x17,0x3b], 520 => 'Firmware' },
	'firmware2' => { 434 => 0x57 },
	'firmwaredate' => { 118 => 0x15, 119 => 0x2001, 418 => 0x4, 420 => 0x30 },
	'firmwareid' => { 195 => 0x0 },
	'firmwarename' => { 431 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 69 => 0x1e, 422 => 0x0 },
	'firmwarerevision2' => { 422 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 145 => [0x415,0xce5], 161 => 0x57, 163 => 'FirmwareVersion', 352 => 0x320, 354 => 0x2, 356 => 0x3109, 390 => 0x230, 416 => ['CNFV','FIRM','info'], 419 => 0x18, 420 => 0x2a, 424 => 0x2 },
	'firmwareversions' => { 399 => 0x301 },
	'firstphotodate' => { 509 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 340 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 138 => 0x16, 517 => 'FixtureIdentifier' },
	'flash' => { 120 => 'XMP-Flash', 125 => 0x9209, 159 => 0x22, 189 => 0x1f, 190 => 0x15, 420 => 0x5a, 529 => 'Flash' },
	'flashaction' => { 444 => 0x3e, 445 => 0x3e, 458 => 0x2017, 463 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 444 => 0x4c, 445 => 0x4c, 463 => 0x77 },
	'flashactionexternal' => { 463 => [0x78,0x7c] },
	'flashactivity' => { 37 => 0x1c },
	'flashbatterylevel' => { 48 => 0x249 },
	'flashbias' => { 354 => 0x24 },
	'flashbits' => { 37 => 0x1d },
	'flashburstpriority' => { 325 => 0x101, 326 => 0x111, 327 => 0x111, 328 => 0x129 },
	'flashbuttonfunction' => { 90 => 0x70e },
	'flashchargelevel' => { 335 => 0x1010 },
	'flashcolorfilter' => { 223 => 0x10, 224 => 0x10, 226 => 0x10 },
	'flashcommandermode' => { 221 => '9.1', 222 => '9.1', 223 => '9.1', 224 => '9.1', 226 => '9.1' },
	'flashcompensation' => { 145 => 0x3f3, 221 => 0xa, 222 => 0xa, 223 => 0xa, 224 => 0x27, 225 => 0xa, 226 => 0xa, 520 => 'FlashCompensation' },
	'flashcontrol' => { 444 => 0x23, 445 => 0x1f, 446 => 0x21 },
	'flashcontrolbuilt-in' => { 318 => '16.1', 319 => '23.1', 321 => '23.1', 322 => '24.1' },
	'flashcontrolmode' => { 221 => '9.2', 222 => '9.2', 223 => '9.2', 224 => '9.2', 226 => '9.2', 232 => 0x214, 247 => 0x2d4, 248 => 0x148, 249 => 0x1b8, 250 => 0x1b8, 251 => 0x1a8, 252 => 0x1bc, 253 => 0x1bc, 330 => 0x404 },
	'flashcurtain' => { 354 => 0x48 },
	'flashdefault' => { 191 => 0x42 },
	'flashdevice' => { 335 => 0x1005 },
	'flashdistance' => { 119 => 0x2034 },
	'flashenergy' => { 125 => 0xa20b, 529 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 243 => 0x18 },
	'flashexposurecomp' => { 82 => 0xf, 133 => 0x1011, 166 => 'ExposureComp', 188 => 0x23, 193 => 0x104, 194 => 0x49c1, 243 => 0x12, 330 => 0x401, 335 => 0x1023, 390 => 0x4d, 424 => 0x100b, 434 => [0x3a,0x56], 458 => 0x104 },
	'flashexposurecomp2' => { 289 => 0x4d2 },
	'flashexposurecomp3' => { 223 => 0x1d },
	'flashexposurecomp4' => { 223 => 0x27 },
	'flashexposurecomparea' => { 310 => '38.4', 312 => '38.4', 313 => '38.4', 322 => '38.4', 323 => '38.4', 325 => 0x5d, 326 => 0x59, 327 => 0x59, 328 => 0x59 },
	'flashexposurecompset' => { 191 => 0x10, 362 => 0xe, 444 => 0x14, 445 => 0x12, 446 => 0x23, 463 => 0x1f },
	'flashexposurecompset2' => { 463 => [0x26,0x2c] },
	'flashexposureindicator' => { 191 => 0x54 },
	'flashexposureindicatorlast' => { 191 => 0x56 },
	'flashexposureindicatornext' => { 191 => 0x55 },
	'flashexposurelock' => { 61 => 0x19 },
	'flashfired' => { 147 => 0x5d, 166 => 'Fired', 188 => 0x14, 288 => '590.3', 529 => [\'Flash','FlashFired'] },
	'flashfiring' => { 90 => 0x306, 91 => 0x6, 92 => 0x7, 95 => 0x7 },
	'flashfirmwareversion' => { 331 => 0x1002 },
	'flashfocallength' => { 221 => 0xb, 222 => 0xc, 223 => 0xc, 224 => 0xc, 225 => 0xc, 226 => 0x26 },
	'flashfunction' => { 194 => 0x31, 529 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 221 => 0xe, 222 => 0xf, 223 => 0xf, 224 => 0xf, 225 => 0xf, 226 => 0xf, 232 => 0x21a, 247 => 0x2da, 248 => 0x14e, 251 => 0x1ae, 252 => 0x1c2, 253 => 0x1c2 },
	'flashgroupacompensation' => { 221 => 0x11, 222 => 0x12, 223 => 0x13, 224 => 0x28, 225 => 0x28, 226 => 0x28 },
	'flashgroupacontrolmode' => { 221 => 0xf, 222 => '16.1', 223 => '17.1', 224 => '17.1', 225 => '17.1', 226 => '17.1' },
	'flashgroupaoutput' => { 221 => 0x11, 222 => 0x12, 223 => 0x13, 224 => 0x28, 225 => 0x28, 226 => 0x28 },
	'flashgroupbcompensation' => { 221 => 0x12, 222 => 0x13, 223 => 0x14, 224 => 0x29, 225 => 0x29, 226 => 0x29 },
	'flashgroupbcontrolmode' => { 221 => 0x10, 222 => '17.1', 223 => '18.1', 224 => '18.1', 225 => '18.1', 226 => '18.1' },
	'flashgroupboutput' => { 221 => 0x12, 222 => 0x13, 223 => 0x14, 224 => 0x29, 225 => 0x29, 226 => 0x29 },
	'flashgroupccompensation' => { 222 => 0x14, 223 => 0x15, 224 => 0x2a, 225 => 0x2a, 226 => 0x2a },
	'flashgroupccontrolmode' => { 222 => '17.2', 223 => '18.2', 224 => '18.2', 225 => '18.2', 226 => '18.2' },
	'flashgroupcoutput' => { 222 => 0x14, 223 => 0x15, 224 => 0x2a, 225 => 0x2a, 226 => 0x2a },
	'flashguidenumber' => { 82 => 0xd, 100 => 0x0, 166 => 'GuideNumber' },
	'flashilluminationpattern' => { 226 => 0x25 },
	'flashintensity' => { 118 => [0x19,0x5], 330 => 0x405 },
	'flashlevel' => { 311 => 0x9, 458 => 0xb048 },
	'flashmake' => { 166 => 'Make' },
	'flashmanufacturer' => { 185 => 'FlashManufacturer' },
	'flashmastercompensation' => { 232 => 0x22e, 247 => 0x2ee, 248 => 0x162, 251 => 0x1aa, 252 => 0x1be, 253 => 0x1be },
	'flashmastercontrolmode' => { 232 => 0x22c, 247 => 0x2ec, 248 => 0x160 },
	'flashmasteroutput' => { 232 => 0x232, 247 => 0x2f2, 248 => 0x166 },
	'flashmetering' => { 188 => 0x3f, 191 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 390 => 0x20a },
	'flashmode' => { 118 => 0x4, 145 => 0x3f2, 147 => 0x5c, 158 => 0x27, 166 => 'Mode', 188 => 0x2, 189 => 0x20, 190 => 0x16, 191 => 0xf, 243 => 0x87, 330 => 0x400, 335 => 0x1004, 390 => 0xc, 397 => 0x4, 423 => 0x20, 424 => 0x100a, 433 => 0x225, 444 => 0x13, 445 => 0x7f, 446 => 0x20, 463 => 0x10, 467 => 0x1138, 468 => 0x1138, 469 => 0x1114, 470 => 0x1190, 471 => 0x116c, 472 => 0x1024, 473 => 0x21c, 474 => 0x21c, 475 => 0x211, 529 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 253 => 0x80e },
	'flashmodebuttonplaybackmode' => { 253 => 0x818 },
	'flashmodel' => { 166 => 'Model', 185 => 'FlashModel', 331 => 0x1001 },
	'flashoptions' => { 370 => 0x2 },
	'flashoptions2' => { 370 => 0x10 },
	'flashoutput' => { 48 => 0x248, 82 => 0x21, 221 => 0xa, 222 => 0xa, 223 => 0xa, 224 => 0x27, 226 => 0x21, 232 => 0x21e, 247 => 0x2de, 248 => 0x152, 251 => 0x1b2, 252 => 0x1c6, 253 => 0x1c6 },
	'flashpixversion' => { 125 => 0xa000, 529 => 'FlashpixVersion' },
	'flashredeyemode' => { 529 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 232 => 0x228, 247 => 0x2e8, 248 => 0x15c, 251 => 0x1bc, 330 => 0x403 },
	'flashreturn' => { 529 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 166 => 'SerialNumber', 331 => 0x1003 },
	'flashsetting' => { 243 => 0x8 },
	'flashshutterspeed' => { 309 => '20.2', 310 => '23.2', 312 => '23.2', 313 => '23.2', 318 => '15.2', 319 => '22.2', 320 => '7.2', 321 => '22.2', 322 => '23.2', 323 => '23.2', 324 => '23.1', 325 => 0x5b, 326 => 0x57, 327 => 0x57, 328 => 0x57 },
	'flashsource' => { 221 => 0x4, 222 => 0x4, 223 => 0x4, 224 => 0x4, 225 => 0x4, 226 => 0x4 },
	'flashstatus' => { 377 => 0x0, 463 => [0x82,0x86], 477 => 0x31, 478 => 0x39, 479 => 0x39 },
	'flashstatusbuilt-in' => { 446 => [0x87,0x287] },
	'flashstatusexternal' => { 446 => [0x88,0x288] },
	'flashsyncspeed' => { 309 => '20.1', 310 => '23.1', 312 => '23.1', 313 => '23.1', 318 => '15.1', 319 => '22.1', 321 => '22.1', 322 => '23.1', 323 => '23.1', 325 => 0x57, 326 => 0x53, 327 => 0x53, 328 => 0x53 },
	'flashsyncspeedav' => { 88 => 0x3, 90 => 0x10f, 91 => 0x2, 92 => 0x3, 93 => 0x2, 94 => 0x2, 95 => 0x3, 96 => 0x6 },
	'flashthreshold' => { 100 => 0x1 },
	'flashtype' => { 166 => 'Type', 191 => 0x59, 243 => 0x9, 331 => 0x1000 },
	'flashwarning' => { 319 => '30.1', 320 => '7.1', 324 => '31.1', 354 => 0x62 },
	'flashwirelessoption' => { 232 => 0x234, 247 => 0x2e6, 248 => 0x15a, 251 => 0x1c8 },
	'flexiblespotposition' => { 458 => 0x201d },
	'flickadvancedirection' => { 326 => 0x25f, 327 => 0x25f, 328 => 0x277 },
	'flickerreduce' => { 433 => 0x218 },
	'flickerreduction' => { 133 => 0x1446, 272 => 0x7 },
	'flickerreductionindicator' => { 267 => 0x532 },
	'flickerreductionshooting' => { 247 => 0x2d0, 249 => 0x1b4, 250 => 0x1b4, 251 => 0x1a4, 252 => 0x1b8, 253 => 0x1b8 },
	'flightpitchdegree' => { 122 => 'FlightPitchDegree' },
	'flightrolldegree' => { 122 => 'FlightRollDegree' },
	'flightxspeed' => { 122 => 'FlightXSpeed' },
	'flightyawdegree' => { 122 => 'FlightYawDegree' },
	'flightyspeed' => { 122 => 'FlightYSpeed' },
	'flightzspeed' => { 122 => 'FlightZSpeed' },
	'fliphorizontal' => { 302 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 82 => 0x15, 125 => 0x829d, 144 => 0xfd04, 147 => 0x1e, 149 => 0xfa23, 151 => 0xf103, 154 => 0x13, 156 => 0x3c, 158 => 0x1c, 159 => 0x18, 161 => 0xc, 170 => 'FNumber', 188 => 0xa, 189 => 0x36, 190 => 0x47, 191 => 0x9, 194 => 0x49c7, 241 => 0x38, 353 => 0x35a, 390 => 0x13, 431 => 0xa019, 434 => [0x31,0x49], 444 => 0x1, 445 => 0x1, 463 => [0x20,0x22,0x26], 529 => 'FNumber' },
	'focaldistance' => { 507 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 63 => 0x1, 66 => 0x7, 119 => 0x1d, 125 => 0x920a, 154 => 0x1d, 170 => 'FocalLength', 188 => 0x12, 236 => 0xa, 237 => 0xb, 241 => [0xc,0x3c], 348 => 0x1, 390 => 0x1d, 399 => 0x403, 424 => 0x1500, 443 => 0xe, 471 => 0x1278, 472 => 0x1134, 473 => 0x32c, 474 => 0x32c, 475 => 0x30a, 529 => 'FocalLength' },
	'focallength2' => { 463 => [0x23,0x25,0x29] },
	'focallength35mm' => { 344 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 125 => 0xa405, 417 => 'camera.focal_length.35mm_equivalent', 431 => 0xa01a, 529 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 443 => 0x10 },
	'focalplaneafpointarea' => { 476 => 0x2 },
	'focalplaneafpointlocation1' => { 476 => 0x6 },
	'focalplaneafpointlocation10' => { 476 => 0x2a },
	'focalplaneafpointlocation11' => { 476 => 0x2e },
	'focalplaneafpointlocation12' => { 476 => 0x32 },
	'focalplaneafpointlocation13' => { 476 => 0x36 },
	'focalplaneafpointlocation14' => { 476 => 0x3a },
	'focalplaneafpointlocation15' => { 476 => 0x3e },
	'focalplaneafpointlocation2' => { 476 => 0xa },
	'focalplaneafpointlocation3' => { 476 => 0xe },
	'focalplaneafpointlocation4' => { 476 => 0x12 },
	'focalplaneafpointlocation5' => { 476 => 0x16 },
	'focalplaneafpointlocation6' => { 476 => 0x1a },
	'focalplaneafpointlocation7' => { 476 => 0x1e },
	'focalplaneafpointlocation8' => { 476 => 0x22 },
	'focalplaneafpointlocation9' => { 476 => 0x26 },
	'focalplaneafpointsused' => { 476 => 0x1 },
	'focalplanediagonal' => { 331 => 0x103, 335 => 0x205 },
	'focalplaneresolutionunit' => { 125 => 0xa210, 529 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 125 => 0xa20e, 529 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 63 => 0x2 },
	'focalplanexunknown' => { 63 => 0x2 },
	'focalplaneyresolution' => { 125 => 0xa20f, 529 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 63 => 0x3 },
	'focalplaneyunknown' => { 63 => 0x3 },
	'focalpointx' => { 507 => 'FocalPointX' },
	'focalpointy' => { 507 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 63 => 0x0 },
	'focalunits' => { 37 => 0x19 },
	'focus' => { 291 => 0x8 },
	'focusarea' => { 188 => 0x31 },
	'focusareaselection' => { 320 => '15.2' },
	'focusbracket' => { 354 => 0xbd },
	'focusbracketstepsize' => { 330 => 0x308 },
	'focuscontinuous' => { 37 => 0x20 },
	'focusdisplayaiservoandmf' => { 90 => 0x515 },
	'focusdistance' => { 170 => 'FocusDistance', 188 => 0x13, 194 => 0x49bb, 236 => 0x9, 237 => 0xa, 241 => [0xb,0x4e], 333 => 0x305, 348 => 0x0, 352 => 0x304, 353 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 61 => 0x15, 82 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 241 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 61 => 0x14, 82 => 0x13 },
	'focusholdbutton' => { 191 => 0x44 },
	'focusinfoversion' => { 333 => 0x0 },
	'focusingscreen' => { 89 => 0x0, 90 => 0x80b, 95 => 0x0 },
	'focuslocation' => { 458 => 0x2027 },
	'focuslocation2' => { 458 => 0x204a },
	'focuslocked' => { 187 => 0x14 },
	'focusmode' => { 37 => 0x7, 118 => 0x3, 119 => [0x3003,0xd], 133 => 0x1021, 145 => 0x3f5, 147 => 0x38, 163 => 'FocusMode', 188 => 0x30, 190 => 0xe, 191 => 0xc, 243 => 0x7, 330 => 0x301, 335 => 0x100b, 354 => 0x7, 390 => 0xd, 397 => 0x3, 424 => 0x1006, 437 => [0xb,0x5], 443 => [0x15,0x1d], 444 => 0x4d, 445 => 0x4d, 458 => [0xb042,0xb04e,0x201b], 463 => 0x13, 484 => 0x16 },
	'focusmode2' => { 132 => '0.1', 370 => '3.1', 463 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 311 => '10.1', 441 => 0x14, 442 => 0x15, 444 => 0x10, 445 => 0xf, 446 => 0x6 },
	'focusmodeswitch' => { 191 => 0x58, 444 => 0x2e },
	'focuspeakingdisplay' => { 325 => 0x22f, 326 => 0x235, 327 => 0x235, 328 => 0x24d },
	'focuspeakinghighlightcolor' => { 325 => 0x53, 326 => 0x4b, 327 => 0x4b, 328 => 0x4b },
	'focuspeakinglevel' => { 325 => 0x51, 326 => 0x49, 327 => 0x49, 328 => 0x49 },
	'focuspixel' => { 133 => 0x1023 },
	'focuspointlock' => { 326 => 0x1d3, 327 => 0x1d3, 328 => 0x1eb },
	'focuspointpersistence' => { 325 => 0xf5, 326 => 0x105, 327 => 0x105, 328 => 0x11b },
	'focuspointwrap' => { 309 => '2.2', 310 => '2.2', 312 => '2.1', 313 => '2.1', 317 => '1.1', 318 => '2.2', 319 => '1.1', 322 => '2.2', 323 => '2.1', 324 => '2.5', 325 => 0x16, 326 => 0x16, 327 => 0x16, 328 => 0x16 },
	'focusposition' => { 1 => 0x2f, 236 => 0x8, 237 => 0x8, 390 => 0x10, 455 => 0x9bb },
	'focusposition2' => { 463 => [0x29,0x2b,0x2f], 484 => 0x2d, 487 => 0x20 },
	'focuspositionhorizontal' => { 200 => 0x2f },
	'focuspositionvertical' => { 200 => 0x31 },
	'focusprocess' => { 330 => 0x302 },
	'focusrange' => { 37 => 0x12, 335 => 0x100a },
	'focusrangeindex' => { 380 => '3.1' },
	'focusresult' => { 201 => 0x4a },
	'focusringrotation' => { 90 => 0x713 },
	'focussetting' => { 434 => 0x6 },
	'focusshiftautoreset' => { 252 => 0x6da, 253 => 0x748 },
	'focusshiftexposurelock' => { 232 => 0x1b4, 247 => 0x224, 248 => 0xe8, 249 => 0x100, 250 => 0x100, 251 => 0xf4, 252 => 0x104, 253 => 0x104 },
	'focusshiftinterval' => { 232 => 0x1b0, 247 => 0x220, 248 => 0xe4, 249 => 0xfc, 250 => 0xfc, 251 => 0xf0, 252 => 0x100, 253 => 0x100 },
	'focusshiftnumbershots' => { 232 => 0x1a8, 247 => 0x218, 248 => 0xdc, 249 => 0xf4, 250 => 0xf4, 251 => 0xe8, 252 => 0xf8, 253 => 0xf8 },
	'focusshiftshooting' => { 270 => 0x20 },
	'focusshiftstepwidth' => { 232 => 0x1ac, 247 => 0x21c, 248 => 0xe0, 249 => 0xf8, 250 => 0xf8, 251 => 0xec, 252 => 0xfc, 253 => 0xfc },
	'focusstatus' => { 443 => 0x19, 444 => 0x53, 445 => 0x53 },
	'focusstepcount' => { 333 => 0x301, 335 => 0x100e },
	'focusstepinfinity' => { 333 => 0x303, 335 => 0x103b },
	'focusstepnear' => { 333 => 0x304, 335 => 0x103c },
	'focusstepsfrominfinity' => { 241 => 0x58 },
	'focustrackinglockon' => { 309 => ['1.5','4.1'], 310 => '1.4', 317 => '0.4', 318 => '3.1', 319 => '0.4', 322 => '1.4' },
	'focuswarning' => { 133 => 0x1301 },
	'foldername' => { 188 => 0x27 },
	'foldernumber' => { 444 => 0x9a, 446 => [0x402,0x114,0x316] },
	'fontcomposite' => { 557 => [\'Fonts','FontsComposite'] },
	'fontface' => { 557 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 557 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 557 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 557 => [\'Fonts','FontsFontName'] },
	'fonts' => { 557 => 'Fonts' },
	'fonttype' => { 557 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 557 => [\'Fonts','FontsVersionString'] },
	'for' => { 406 => 'For' },
	'forcewrite' => { 126 => 'ForceWrite' },
	'format' => { 416 => "\xa9fmt", 506 => 'Format', 526 => 'format', 550 => 'Format' },
	'forwardlock' => { 547 => 'forwardlock' },
	'forwardmatrix1' => { 125 => 0xc714 },
	'forwardmatrix2' => { 125 => 0xc715 },
	'forwardmatrix3' => { 125 => 0xcd34 },
	'fossilspecimen' => { 124 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 124 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 72 => [0x2,0x4] },
	'frameheight' => { 133 => 0x3822 },
	'framenum' => { 401 => 0xd7 },
	'framenumber' => { 133 => 0x8003, 194 => 0x3c, 390 => 0x29 },
	'framerate' => { 72 => [0x1,0x6], 125 => 0xc764, 133 => 0x3820 },
	'framereadouttime' => { 417 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 133 => 0x3821 },
	'framing' => { 541 => 'framing' },
	'freebytes' => { 103 => 0x1 },
	'freememorycardimages' => { 189 => [0x37,0x54], 190 => [0x2d,0x4a], 191 => 0x32 },
	'fujiflashmode' => { 133 => 0x1010 },
	'fujimodel' => { 133 => 0x1447 },
	'fujimodel2' => { 133 => 0x1448 },
	'fullframerateplaybackintent' => { 410 => 'full-frame-rate-playback-intent' },
	'fullhdhighspeedrec' => { 133 => 0x3824 },
	'fullimagesize' => { 458 => 0xb02b },
	'fullpanoheightpixels' => { 509 => 'FullPanoHeightPixels', 510 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 509 => 'FullPanoWidthPixels', 510 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 424 => 0x100d },
	'fullsizeimage' => { 169 => 'data' },
	'fullsizeimagename' => { 169 => '1Name' },
	'fullsizeimagetype' => { 169 => '0Type' },
	'func1button' => { 312 => '14.1', 313 => '14.1', 323 => '14.1', 325 => 0x67, 326 => 0x63, 327 => 0x63, 328 => 0x63 },
	'func1buttonplaybackmode' => { 325 => 0x19f, 326 => 0x1a5, 327 => 0x1a5, 328 => 0x1bd },
	'func1buttonplusdials' => { 312 => '42.1', 313 => '42.1', 323 => '42.1' },
	'func2button' => { 312 => '80.1', 313 => '80.1', 323 => '80.1', 325 => 0x77, 326 => 0x73, 327 => 0x73, 328 => 0x73 },
	'func2buttonplaybackmode' => { 325 => 0x1a1, 326 => 0x1a7, 327 => 0x1a7, 328 => 0x1bf },
	'func2buttonplusdials' => { 312 => '81.1' },
	'func3button' => { 312 => '83.1', 327 => 0x119, 328 => 0x131 },
	'func3buttonplaybackmode' => { 327 => 0x1a9, 328 => 0x1c1 },
	'func4button' => { 327 => 0x175, 328 => 0x18d },
	'func4buttonplaybackmode' => { 327 => 0x1af, 328 => 0x1c7 },
	'funcbutton' => { 309 => ['14.1','15.1'], 310 => '14.1', 318 => '28.1', 319 => '13.1', 322 => '14.1', 324 => '14.1' },
	'funcbuttonplusdials' => { 309 => ['14.2','15.2'], 310 => '14.2', 318 => '31.1', 322 => '42.1' },
	'functionbutton' => { 316 => '13.1', 320 => '5.2' },
	'gainbase' => { 334 => 0x610 },
	'gaincontrol' => { 125 => 0xa407, 529 => 'GainControl' },
	'gainmapmax' => { 534 => 'GainMapMax' },
	'gainmapmin' => { 534 => 'GainMapMin' },
	'gamma' => { 125 => 0xa500, 145 => 0x8fe, 341 => 'gAMA', 359 => 0x11c, 530 => 'Gamma', 534 => 'Gamma' },
	'gammablackpoint' => { 111 => 0xc },
	'gammacolortone' => { 111 => 0x3 },
	'gammacompensatedvalue' => { 140 => 0x91 },
	'gammacontrast' => { 111 => 0x2 },
	'gammacurveoutputrange' => { 111 => 0xf },
	'gammahighlight' => { 111 => 0xa },
	'gammalinear' => { 109 => 0x20200 },
	'gammamidpoint' => { 111 => 0xe },
	'gammasaturation' => { 111 => 0x4 },
	'gammashadow' => { 111 => 0x9 },
	'gammasharpnessstrength' => { 111 => 0x8 },
	'gammaunsharpmaskfineness' => { 111 => 0x6 },
	'gammaunsharpmaskstrength' => { 111 => 0x5 },
	'gammaunsharpmaskthreshold' => { 111 => 0x7 },
	'gammawhitepoint' => { 111 => 0xd },
	'garminsettings' => { 416 => 'pmcc' },
	'garminsoftware' => { 416 => 'uuid' },
	'gdalmetadata' => { 125 => 0xa480 },
	'gdalnodata' => { 125 => 0xa481 },
	'geimagesize' => { 133 => 0x1304 },
	'gemake' => { 135 => 0x300 },
	'gemodel' => { 135 => 0x207 },
	'genre' => { 408 => ['gnre',"\xa9gen"], 410 => 'genre', 416 => ['gnre',"\xa9gen"], 537 => 'Genre', 542 => 'genre', 552 => 'genre' },
	'genrecvid' => { 537 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 537 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 537 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 537 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 408 => 'geID' },
	'geography' => { 543 => 'geography' },
	'geolocate' => { 126 => 'Geolocate' },
	'geologicalcontext' => { 124 => 'GeologicalContext' },
	'geologicalcontextbed' => { 124 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 124 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 124 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 124 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 124 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 126 => 'Geosync' },
	'geotag' => { 126 => 'Geotag' },
	'geotiffasciiparams' => { 125 => 0x87b1 },
	'geotiffdirectory' => { 125 => 0x87af },
	'geotiffdoubleparams' => { 125 => 0x87b0 },
	'geotime' => { 126 => 'Geotime' },
	'giftftppriority' => { 511 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 122 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 122 => 'GimbalReverse' },
	'gimbalrolldegree' => { 122 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 122 => 'GimbalYawDegree' },
	'globalaltitude' => { 404 => 0x419 },
	'globalangle' => { 404 => 0x40d },
	'good' => { 552 => 'good' },
	'googlehostheader' => { 408 => 'gshh' },
	'googlepingmessage' => { 408 => 'gspm' },
	'googlepingurl' => { 408 => 'gspu' },
	'googleplusuploadcode' => { 125 => 0x9009 },
	'googlesourcedata' => { 408 => 'gssd' },
	'googlestarttime' => { 408 => 'gsst' },
	'googletrackduration' => { 408 => 'gstd' },
	'goprotype' => { 416 => 'GoPr' },
	'gpsaltitude' => { 137 => 0x6, 167 => 'Altitude', 529 => 'GPSAltitude' },
	'gpsaltituderef' => { 137 => 0x5, 529 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 137 => 0x1c, 529 => 'GPSAreaInformation' },
	'gpscoordinates' => { 408 => "\xa9xyz", 410 => 'location.ISO6709', 416 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 137 => 0x1d },
	'gpsdatetime' => { 167 => 'DateTime', 529 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 137 => 0x18, 167 => 'Bearing', 529 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 137 => 0x17, 529 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 137 => 0x1a, 167 => 'Distance', 529 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 137 => 0x19, 529 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 137 => 0x14, 529 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 137 => 0x13 },
	'gpsdestlongitude' => { 137 => 0x16, 529 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 137 => 0x15 },
	'gpsdifferential' => { 137 => 0x1e, 167 => 'Differential', 529 => 'GPSDifferential' },
	'gpsdop' => { 137 => 0xb, 529 => 'GPSDOP' },
	'gpshpositioningerror' => { 137 => 0x1f, 529 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 137 => 0x11, 529 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 137 => 0x10, 529 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 120 => 'GPS-GPSLatitude', 122 => 'GpsLatitude', 137 => 0x2, 167 => 'Latitude', 529 => 'GPSLatitude' },
	'gpslatituderef' => { 137 => 0x1 },
	'gpslongitude' => { 120 => 'GPS-GPSLongitude', 122 => 'GpsLongitude', 137 => 0x4, 167 => 'Longitude', 529 => 'GPSLongitude' },
	'gpslongituderef' => { 137 => 0x3 },
	'gpslongtitude' => { 122 => 'GpsLongtitude' },
	'gpsmapdatum' => { 137 => 0x12, 167 => 'Datum', 529 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 137 => 0xa, 167 => 'MeasureMode', 529 => 'GPSMeasureMode' },
	'gpsposition' => { 120 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 137 => 0x1b, 529 => 'GPSProcessingMethod' },
	'gpssatellites' => { 137 => 0x8, 167 => 'Satellites', 529 => 'GPSSatellites' },
	'gpsspeed' => { 137 => 0xd, 167 => 'Speed', 529 => 'GPSSpeed' },
	'gpsspeedref' => { 137 => 0xc, 529 => 'GPSSpeedRef' },
	'gpsstatus' => { 137 => 0x9, 529 => 'GPSStatus' },
	'gpsstring' => { 145 => 0x402 },
	'gpstimestamp' => { 137 => 0x7 },
	'gpstrack' => { 137 => 0xf, 167 => 'Heading', 529 => 'GPSTrack' },
	'gpstrackref' => { 137 => 0xe, 529 => 'GPSTrackRef' },
	'gpsversionid' => { 137 => 0x0, 529 => 'GPSVersionID' },
	'gradation' => { 330 => 0x50f },
	'gradientbasedcorractive' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 523 => 'GradientBasedCorrections', 525 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 523 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 525 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 523 => 'GrainAmount', 525 => 'GrainAmount' },
	'graineffectroughness' => { 133 => 0x1047 },
	'graineffectsize' => { 133 => 0x104c },
	'grainfrequency' => { 523 => 'GrainFrequency', 525 => 'GrainFrequency' },
	'grainseed' => { 523 => 'GrainSeed', 525 => 'GrainSeed' },
	'grainsize' => { 523 => 'GrainSize', 525 => 'GrainSize' },
	'graymixeraqua' => { 523 => 'GrayMixerAqua', 525 => 'GrayMixerAqua' },
	'graymixerblue' => { 523 => 'GrayMixerBlue', 525 => 'GrayMixerBlue' },
	'graymixergreen' => { 523 => 'GrayMixerGreen', 525 => 'GrayMixerGreen' },
	'graymixermagenta' => { 523 => 'GrayMixerMagenta', 525 => 'GrayMixerMagenta' },
	'graymixerorange' => { 523 => 'GrayMixerOrange', 525 => 'GrayMixerOrange' },
	'graymixerpurple' => { 523 => 'GrayMixerPurple', 525 => 'GrayMixerPurple' },
	'graymixerred' => { 523 => 'GrayMixerRed', 525 => 'GrayMixerRed' },
	'graymixeryellow' => { 523 => 'GrayMixerYellow', 525 => 'GrayMixerYellow' },
	'graypoint' => { 495 => 0x8021 },
	'grayresponseunit' => { 125 => 0x122 },
	'greencurvelimits' => { 114 => 0x1c4 },
	'greencurvepoints' => { 113 => 0x53, 114 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 109 => 0x20913 },
	'greenhue' => { 523 => 'GreenHue', 525 => 'GreenHue' },
	'greensaturation' => { 523 => 'GreenSaturation', 525 => 'GreenSaturation' },
	'griddisplay' => { 309 => '13.3', 310 => '4.3', 312 => '4.2', 313 => '4.2', 314 => '2.2', 318 => '10.5', 319 => '3.4', 320 => '6.1', 322 => '4.4', 323 => '4.2', 324 => '4.2' },
	'gripbatteryadload' => { 368 => 0x5 },
	'gripbatteryadnoload' => { 368 => 0x4 },
	'gripbatterypercent' => { 368 => 0x11 },
	'gripbatterystate' => { 368 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 368 => 0x12 },
	'group' => { 523 => 'Group', 525 => 'Group' },
	'groupareaafillumination' => { 310 => '46.4', 313 => '47.4', 322 => '47.4' },
	'grouping' => { 408 => ['grup',"\xa9grp"], 416 => "\xa9grp" },
	'guid' => { 408 => 'GUID' },
	'h2resetblackpixels' => { 145 => 0x18a6 },
	'h3resetblackcolumns' => { 145 => 0x18ce },
	'h3resetblackpixels' => { 145 => 0x18b0 },
	'halftonehints' => { 125 => 0x141 },
	'hardlink' => { 126 => 'HardLink' },
	'hasalternative' => { 542 => 'hasAlternative' },
	'hascorrection' => { 542 => 'hasCorrection' },
	'hascorrectiona-lang' => { 542 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 542 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 542 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 523 => 'HasCrop', 525 => 'HasCrop' },
	'hasextendedxmp' => { 554 => 'HasExtendedXMP' },
	'hassettings' => { 523 => 'HasSettings', 525 => 'HasSettings' },
	'hastranslation' => { 542 => 'hasTranslation' },
	'hasvisibleoverprint' => { 557 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 557 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 248 => 0x35a },
	'hdmioutputresolution' => { 249 => 0x710, 250 => 0x720, 251 => 0x610, 252 => 0x640, 253 => 0x6a8 },
	'hdmiviewassist' => { 327 => 0x20f, 328 => 0x227 },
	'hdr' => { 64 => 0x1, 228 => 0x4, 229 => 0x4, 247 => 0x354, 249 => 0x23a, 250 => 0x23a, 253 => 0x23a, 354 => 0x9e, 390 => 0x85, 458 => 0x200a },
	'hdrcapacitymax' => { 534 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 534 => 'HDRCapacityMin' },
	'hdreditmode' => { 523 => 'HDREditMode', 525 => 'HDREditMode' },
	'hdreffect' => { 64 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrgainmapversion' => { 512 => 'HDRGainMapVersion' },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 228 => 0x5, 229 => 0x5, 247 => 0x360, 249 => 0x246, 250 => 0x246, 253 => 0x246, 446 => 0x2e, 463 => 0x17 },
	'hdrlevel2' => { 228 => 0x7 },
	'hdrplusmakernote' => { 503 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 503 => 'hdrp_makernote' },
	'hdrsetting' => { 446 => 0x2d, 463 => 0x16, 467 => 0x1148, 468 => 0x1148, 469 => 0x1124, 470 => 0x11a0, 471 => 0x117c, 472 => 0x1034, 473 => 0x22c, 474 => 0x22c, 475 => 0x21f },
	'hdrsmoothing' => { 228 => 0x6 },
	'hdvideo' => { 408 => 'hdvd' },
	'headline' => { 138 => 0x69, 537 => 'Headline', 540 => 'Headline' },
	'hiddendatalength' => { 456 => 0x1 },
	'hiddendataoffset' => { 456 => 0x0 },
	'hierarchicalkeywords' => { 178 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 178 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 178 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 178 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 178 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 178 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 514 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 247 => 0x16c, 249 => 0x48, 250 => 0x48, 252 => 0x48, 253 => 0x48 },
	'highfrequencyflickerreduction' => { 247 => 0x386, 249 => 0x27c, 250 => 0x27c, 252 => 0x27c, 253 => 0x27c },
	'highisomultiplierblue' => { 359 => 0x1a },
	'highisomultipliergreen' => { 359 => 0x19 },
	'highisomultiplierred' => { 359 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 67 => 0x5, 90 => 0x202, 243 => 0xb1, 390 => 0x71, 444 => 0x2c, 445 => 0x26, 446 => 0x26, 458 => 0x2009, 463 => 0x12, 490 => 0x42 },
	'highisonoisereduction2' => { 458 => 0xb050 },
	'highlight' => { 434 => 0xf },
	'highlight2012' => { 523 => 'Highlight2012', 525 => 'Highlight2012' },
	'highlightadj' => { 109 => 0x2030c },
	'highlightcolordistortreduct' => { 495 => 0x8026 },
	'highlightlinearitylimit' => { 431 => 0xa025 },
	'highlightprotection' => { 301 => 0x6 },
	'highlightrecovery' => { 523 => 'HighlightRecovery', 525 => 'HighlightRecovery' },
	'highlights' => { 458 => 0x2033, 516 => 'Highlights' },
	'highlights2012' => { 523 => 'Highlights2012', 525 => 'Highlights2012' },
	'highlightsadj' => { 495 => 0x9019 },
	'highlightshadow' => { 354 => 0xad },
	'highlighttone' => { 133 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 67 => 0x3, 90 => 0x203 },
	'highlightwarning' => { 354 => 0x8002 },
	'highlowkeyadj' => { 390 => 0x6c },
	'highspeedsync' => { 191 => 0x5, 325 => 0x59, 326 => 0x55, 327 => 0x55, 328 => 0x55, 444 => 0x2, 445 => 0x2 },
	'hintversion' => { 416 => 'hinv' },
	'histogramxml' => { 302 => 0x83a1a25 },
	'history' => { 540 => 'History', 553 => 'History' },
	'historyaction' => { 553 => [\'History','HistoryAction'] },
	'historychanged' => { 553 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 553 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 553 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 553 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 553 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 145 => 0xc88 },
	'holefilldeltathreshold' => { 145 => 0xc7e },
	'hometowncity' => { 119 => 0x3006, 390 => 0x23, 396 => 0x2 },
	'hometowncitycode' => { 397 => 0x1000 },
	'hometowndst' => { 390 => 0x25, 396 => '0.2' },
	'hostcomputer' => { 125 => 0x13c },
	'hostsoftwarerendering' => { 145 => 0xce7 },
	'hue' => { 196 => 0x3b, 261 => 0x3d, 262 => 0x45, 390 => 0x67 },
	'hueadj' => { 305 => 0x2f, 495 => 0x8019 },
	'hueadjust' => { 424 => 0x1016 },
	'hueadjustment' => { 189 => 0x4a, 190 => 0x40, 243 => 0x92, 260 => 0x36 },
	'hueadjustmentaqua' => { 523 => 'HueAdjustmentAqua', 525 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 523 => 'HueAdjustmentBlue', 525 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 523 => 'HueAdjustmentGreen', 525 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 523 => 'HueAdjustmentMagenta', 525 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 523 => 'HueAdjustmentOrange', 525 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 523 => 'HueAdjustmentPurple', 525 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 523 => 'HueAdjustmentRed', 525 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 523 => 'HueAdjustmentYellow', 525 => 'HueAdjustmentYellow' },
	'huesetting' => { 338 => 0x1011 },
	'humanobservation' => { 124 => 'HumanObservation' },
	'humanobservationday' => { 124 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 124 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 124 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 124 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 124 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 124 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 124 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 124 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 124 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 124 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 124 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 124 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 124 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 124 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 124 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 124 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 124 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 124 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 124 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 124 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 125 => 0x9401, 530 => 'Humidity' },
	'icc_profile' => { 126 => 'ICC_Profile', 136 => 'ICCRGBG1/012' },
	'iccprofilename' => { 540 => 'ICCProfile' },
	'iconuri' => { 416 => 'icnu' },
	'idccreativestyle' => { 495 => 0x8000 },
	'idcpreviewlength' => { 495 => 0x202 },
	'idcpreviewstart' => { 495 => 0x201 },
	'identification' => { 124 => 'Identification' },
	'identificationid' => { 124 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 124 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 124 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 124 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 124 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 124 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 124 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 526 => 'identifier', 550 => 'Identifier' },
	'ifcameramodel' => { 145 => 0x9c8 },
	'illuminantdata1' => { 125 => 0xcd35 },
	'illuminantdata2' => { 125 => 0xcd36 },
	'illuminantdata3' => { 125 => 0xcd37 },
	'illumination' => { 320 => '0.5', 419 => 0x48 },
	'imageabsolutex' => { 145 => 0x3fe },
	'imageabsolutey' => { 145 => 0x3ff },
	'imageadjustment' => { 243 => 0x80, 291 => 0x5 },
	'imagealterationconstraints' => { 340 => 'ImageAlterationConstraints' },
	'imagearea' => { 233 => 0x2b, 269 => 0x2b, 277 => 0x10, 280 => 0x10 },
	'imageareaoffset' => { 390 => 0x38 },
	'imageauthentication' => { 243 => 0x20 },
	'imageboundary' => { 243 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 133 => 0x1438, 243 => 0xa5, 461 => 0x11b },
	'imagecreator' => { 340 => 'ImageCreator' },
	'imagecreatorid' => { 340 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 340 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 340 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 145 => 0x41f },
	'imagecropy' => { 145 => 0x420 },
	'imagedata' => { 508 => 'Data' },
	'imagedatasize' => { 243 => 0xa2 },
	'imagedescription' => { 125 => 0x10e, 548 => 'ImageDescription' },
	'imageduplicationconstraints' => { 340 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 302 => 0xfe443a45 },
	'imageeditcount' => { 390 => 0x41 },
	'imageediting' => { 390 => 0x32 },
	'imageeditingsoftware' => { 125 => 0xa43b, 530 => 'ImageEditingSoftware' },
	'imageeditor' => { 125 => 0xa438, 530 => 'ImageEditor' },
	'imageeffects' => { 424 => 0x1010 },
	'imagefileconstraints' => { 340 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 340 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 340 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 133 => 0x1436 },
	'imageheight' => { 125 => 0x101, 195 => 0xc, 399 => 0x10d, 506 => 'ImageHeight', 548 => 'ImageLength' },
	'imagehistory' => { 125 => 0x9213, 528 => 'ImageHistory' },
	'imageidnumber' => { 349 => 0x340 },
	'imagemimetype' => { 508 => 'Mime' },
	'imagenumber' => { 125 => 0x9211, 163 => 'ImageNumber', 189 => 0xae, 190 => 0x5e, 399 => 0x113, 444 => 0x9b, 446 => [0x400,'276.1',0x314], 520 => 'ImageNumber' },
	'imagenumber2' => { 190 => 0x62 },
	'imageoptimization' => { 243 => 0xa9 },
	'imageorientation' => { 138 => 0x83 },
	'imageprocessing' => { 243 => 0x1a },
	'imageprocessingfiledatecreated' => { 145 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 145 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 334 => 0x0 },
	'imagequality' => { 163 => 'ImageQuality', 279 => '723.2', 280 => '732.2', 288 => '708.1', 354 => 0x1 },
	'imagequality2' => { 330 => 0x603 },
	'imagerank' => { 511 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 145 => 0x600 },
	'imagerboardversion' => { 145 => 0x439 },
	'imagercols' => { 145 => 0x17d4 },
	'imageref' => { 535 => 'ImageRef' },
	'imageregion' => { 537 => 'ImageRegion' },
	'imageregionboundary' => { 537 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 537 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 537 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 537 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 537 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 537 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 537 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 537 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 537 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 537 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 145 => 0x944 },
	'imageresolutionjpg' => { 145 => 0x945 },
	'imagereview' => { 311 => '0.4', 320 => '0.4' },
	'imagereviewmonitorofftime' => { 310 => '21.1', 312 => '21.1', 313 => '21.1', 317 => '20.1', 322 => '21.1', 323 => '21.1', 325 => 0x3b, 326 => 0x39, 327 => 0x39, 328 => 0x39 },
	'imagereviewtime' => { 309 => '25.1', 311 => '2.1', 314 => '19.1', 315 => '20.1', 316 => '20.1', 318 => '9.2', 319 => '20.1', 324 => '21.2' },
	'imagerfiledatecreated' => { 145 => 0x9c5 },
	'imagerfileproductionlevel' => { 145 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 145 => 0x9c7 },
	'imagerotated' => { 158 => 0x2a },
	'imagerpowerondelaymsec' => { 145 => 0x5fd },
	'imagerrows' => { 145 => 0x17de },
	'imagesegmentlines' => { 145 => 0x184d },
	'imagesegmentstartline' => { 145 => 0x184c },
	'imagesequenceinfo' => { 125 => 0xcd44 },
	'imagesize' => { 169 => 'ImageSize' },
	'imagesizeraw' => { 243 => 0x3e },
	'imagesizerestriction' => { 545 => 'imageSizeRestriction' },
	'imagesourcedata' => { 125 => 0x935c },
	'imagespace' => { 145 => 0x909 },
	'imagestabilization' => { 37 => 0x22, 119 => 0x3020, 133 => 0x1422, 163 => 'ImageStabilization', 189 => 0xbd, 190 => 0x71, 191 => 0x57, 192 => 0x0, 193 => [0x18,0x107,0x113], 194 => 0x49c2, 243 => 0xac, 330 => 0x604, 333 => 0x1600, 354 => 0x1a, 449 => 0x12, 450 => 0x11, 458 => 0xb026 },
	'imagestabilization2' => { 448 => 0xa },
	'imagestabilizationsetting' => { 194 => 0x14, 444 => 0x3d, 445 => 0x3d, 455 => 0x14 },
	'imagestats' => { 125 => 0xcd46 },
	'imagestyle' => { 444 => 0x2d, 445 => 0x27 },
	'imagesupplier' => { 340 => 'ImageSupplier' },
	'imagesupplierid' => { 340 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 340 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 340 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 127 => 0x1 },
	'imagetemperaturemin' => { 127 => 0x2 },
	'imagetitle' => { 125 => 0xa436, 530 => 'ImageTitle' },
	'imagetone' => { 390 => 0x4f },
	'imagetype' => { 138 => 0x82, 340 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 69 => 0x28, 125 => 0xa420, 528 => 'ImageUniqueID', 529 => 'ImageUniqueID', 530 => 'ImageUniqueID' },
	'imagewidth' => { 125 => 0x100, 195 => 0xe, 399 => 0x10c, 506 => 'ImageWidth', 548 => 'ImageWidth' },
	'inclinationangle' => { 495 => 0x900f },
	'inclinationcorrection' => { 495 => 0x900e },
	'incrementaltemperature' => { 523 => 'IncrementalTemperature', 525 => 'IncrementalTemperature' },
	'incrementaltint' => { 523 => 'IncrementalTint', 525 => 'IncrementalTint' },
	'industry' => { 542 => 'industry', 543 => 'industry' },
	'infobuttonwhenshooting' => { 90 => 0x409 },
	'information' => { 410 => 'information', 416 => "\xa9inf" },
	'infourl' => { 416 => 'infu' },
	'infraredilluminator' => { 418 => 0x28 },
	'ingredientexclusion' => { 544 => 'ingredientExclusion' },
	'ingredients' => { 553 => 'Ingredients' },
	'ingredientsalternatepaths' => { 553 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 553 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 553 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 553 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 553 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 553 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 553 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 553 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 553 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 553 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 553 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 553 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 553 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 553 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 553 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 553 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 553 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 553 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 553 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 553 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 553 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 553 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 553 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 90 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 509 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 509 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 186 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 509 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 509 => 'InitialViewHeadingDegrees', 510 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 509 => 'InitialViewPitchDegrees', 510 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 509 => 'InitialViewRollDegrees', 510 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 309 => '4.4' },
	'initialzoomsetting' => { 309 => '9.3', 318 => '27.3' },
	'inkset' => { 125 => 0x14c },
	'inputprofile' => { 145 => 0x1389 },
	'instanceid' => { 553 => 'InstanceID' },
	'instantplaybacksetup' => { 191 => 0x3e },
	'instantplaybacktime' => { 191 => 0x3d },
	'instructions' => { 540 => 'Instructions' },
	'instrument' => { 552 => 'instrument' },
	'integrationtime' => { 145 => 0x423 },
	'intellectualgenre' => { 536 => 'IntellectualGenre' },
	'intelligentauto' => { 458 => 0xb052, 486 => 0xd, 487 => 0xe, 488 => 0xd },
	'intelligentcontrast' => { 56 => 0x4 },
	'intelligentd-range' => { 354 => 0x79 },
	'intelligentexposure' => { 354 => 0x5d },
	'intelligentresolution' => { 354 => 0x70 },
	'interchangecolorspace' => { 140 => 0x40 },
	'intergraphmatrix' => { 125 => 0x8480 },
	'internalflash' => { 188 => 0x2b, 309 => '23.1', 311 => '8.1', 314 => '22.1', 316 => '23.1', 320 => '8.1', 324 => '24.1', 333 => 0x1208 },
	'internalflashae1' => { 335 => 0x1021 },
	'internalflashae1_0' => { 335 => 0x101d },
	'internalflashae2' => { 335 => 0x1022 },
	'internalflashae2_0' => { 335 => 0x101e },
	'internalflashmode' => { 377 => 0x1 },
	'internalflashstrength' => { 377 => 0x3 },
	'internalflashtable' => { 335 => 0x1024 },
	'internallensserialnumber' => { 431 => 0xa005 },
	'internalndfilter' => { 354 => 0x9d },
	'internalserialnumber' => { 69 => 0x96, 81 => 0x9, 133 => 0x10, 194 => 0x49dc, 329 => 0x18, 331 => 0x102, 351 => 0x500, 354 => 0x25, 369 => 0x4, 424 => 0x5, 477 => [0x7c,0xf0], 478 => 0x88, 479 => [0x88,0x8a], 480 => 0x38 },
	'interopindex' => { 125 => 0x1, 530 => 'InteroperabilityIndex' },
	'interopversion' => { 125 => 0x2 },
	'interval' => { 267 => 0x20 },
	'intervaldurationhours' => { 247 => 0x1dc, 248 => 0xa0, 249 => 0xb8, 250 => 0xb8 },
	'intervaldurationminutes' => { 247 => 0x1e0, 248 => 0xa4, 249 => 0xbc, 250 => 0xbc },
	'intervaldurationseconds' => { 247 => 0x1e4, 248 => 0xa8, 249 => 0xc0, 250 => 0xc0 },
	'intervalexposuresmoothing' => { 232 => 0x184, 247 => 0x1f4, 248 => 0xb8, 249 => 0xd0, 250 => 0xd0 },
	'intervalframe' => { 267 => 0x24 },
	'intervallength' => { 188 => 0x10 },
	'intervalmode' => { 188 => 0x26 },
	'intervalnumber' => { 188 => 0x11 },
	'intervalpriority' => { 232 => 0x186, 247 => 0x1f6, 248 => 0xba, 249 => 0xd2, 250 => 0xd2 },
	'intervals' => { 232 => 0x17c, 247 => 0x1ec, 248 => 0xb0, 249 => 0xc8, 250 => 0xc8, 251 => 0xbc, 252 => 0xcc, 253 => 0xcc },
	'intervalshooting' => { 233 => 0x24, 269 => 0x24, 270 => 0x28, 390 => 0x92 },
	'introtime' => { 552 => 'introTime' },
	'introtimescale' => { 552 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 552 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 145 => 0xdae },
	'ipfcameramodel' => { 145 => 0xe4d },
	'iptc' => { 126 => 'IPTC' },
	'iptc-naa' => { 125 => 0x83bb, 359 => 0x83bb },
	'iptcbitspersample' => { 140 => 0x56 },
	'iptcdigest' => { 404 => 0x425 },
	'iptcimageheight' => { 140 => 0x1e },
	'iptcimagerotation' => { 140 => 0x66 },
	'iptcimagewidth' => { 140 => 0x14 },
	'iptclastedited' => { 537 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 140 => 0xa },
	'iptcpixelheight' => { 140 => 0x32 },
	'iptcpixelwidth' => { 140 => 0x28 },
	'isalternativeof' => { 542 => 'isAlternativeOf' },
	'isbn' => { 542 => 'isbn' },
	'iscorrectionof' => { 542 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 115 => 0x3 },
	'ismergedhdr' => { 520 => 'IsMergedHDR' },
	'ismergedpanorama' => { 520 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 118 => 0x14, 119 => [0x3014,0x14], 125 => 0x8827, 144 => 0xfd06, 145 => 0x1784, 147 => 0x60, 149 => [0xfa2e,0xfa46], 150 => [0x27,0x28], 151 => 0xf105, 154 => 0x14, 156 => 0x4e, 158 => 0x1e, 159 => 0x1a, 161 => 0x34, 163 => 'ISO', 188 => 0x8, 194 => 0x49ba, 231 => 0x0, 243 => 0x2, 354 => 0xd1, 359 => [0x17,0x37], 390 => [0x8b,0x14], 397 => 0x14, 399 => 0x105, 431 => 0xa014, 434 => 0x86, 455 => 0x6f, 463 => [0x1f,0x21,0x25], 529 => 'ISOSpeedRatings' },
	'iso2' => { 231 => 0x6, 274 => 0x265, 275 => 0x25c, 276 => 0x265, 277 => 0x221, 278 => 0x25d, 279 => 0x256, 280 => 0x25d, 283 => 0x2b5, 286 => 0x265, 290 => 0x2b5 },
	'isoauto' => { 370 => '14.4' },
	'isoautoflashlimit' => { 249 => 0x156, 250 => 0x156, 251 => 0x146, 252 => 0x15a, 253 => 0x15a },
	'isoautohilimit' => { 230 => 0x5, 247 => 0x28a, 249 => 0x154, 250 => 0x154, 251 => 0x144, 252 => 0x158, 253 => 0x158, 272 => 0x5, 282 => 0x18eb },
	'isoautomax' => { 457 => 0x4 },
	'isoautomin' => { 457 => 0x2 },
	'isoautominspeed' => { 390 => 0x7a },
	'isoautoshuttertime' => { 230 => 0x4, 249 => 0x15e, 250 => 0x15e, 251 => 0x14e, 252 => 0x162, 253 => 0x162, 272 => 0x4, 282 => 0x18ea },
	'isobutton' => { 253 => 0x796 },
	'isocalibrationgain' => { 145 => 0x89f },
	'isodisplay' => { 312 => '4.1', 313 => '4.1', 314 => '2.3', 315 => '3.3', 316 => '3.3', 319 => '3.3', 322 => '4.3', 323 => '4.1', 324 => '4.3' },
	'isoexpansion' => { 90 => 0x103, 91 => 0x7, 92 => 0x8, 95 => 0x8, 231 => 0x4 },
	'isoexpansion2' => { 231 => 0xa },
	'isofloor' => { 370 => 0x6 },
	'isoselected' => { 353 => 0x359 },
	'isoselection' => { 243 => 0xf },
	'isosensitivitystep' => { 317 => '6.2', 319 => '6.2' },
	'isosetting' => { 147 => 0x5e, 159 => 0x14, 163 => 'ISOSetting', 188 => 0x24, 189 => 0x26, 190 => 0x1c, 191 => 0x13, 196 => 0x6, 243 => 0x13, 370 => '17.3', 423 => 0x27, 444 => 0x16, 445 => 0x14, 446 => 0x2, 455 => 0x6d, 457 => 0x0 },
	'isospeed' => { 125 => 0x8833, 530 => 'ISOSpeed' },
	'isospeedexpansion' => { 89 => 0x3 },
	'isospeedincrements' => { 90 => 0x102 },
	'isospeedlatitudeyyy' => { 125 => 0x8834, 530 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 125 => 0x8835, 530 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 90 => 0x103 },
	'isostepsize' => { 309 => '6.1', 310 => '7.2', 312 => '7.2', 313 => '7.2', 318 => '4.1', 322 => '7.2', 323 => '7.2', 325 => 0x14d, 326 => 0x15d, 327 => 0x15d, 328 => 0x175 },
	'isovalue' => { 335 => 0x1001 },
	'isrc' => { 408 => 'xid ' },
	'isrccode' => { 416 => "\xa9isr" },
	'issn' => { 542 => 'issn' },
	'issueidentifier' => { 542 => 'issueIdentifier' },
	'issuename' => { 542 => 'issueName' },
	'issueteaser' => { 542 => 'issueTeaser' },
	'issuetype' => { 542 => 'issueType' },
	'istranslationof' => { 542 => 'isTranslationOf' },
	'itemsubtype' => { 185 => 'ItemSubType' },
	'itunesu' => { 408 => 'itnu' },
	'jobid' => { 138 => 0xb8 },
	'jobname' => { 531 => 'JobName' },
	'jobref' => { 551 => 'JobRef' },
	'jobrefid' => { 551 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 551 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 551 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 531 => 'JobStatus' },
	'jpeg-heifswitch' => { 458 => 0x2039 },
	'jpeghandling' => { 523 => 'JPEGHandling', 525 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 354 => 0x43, 356 => 0x3034, 458 => 0xb047 },
	'jpegsize' => { 356 => 0x303a },
	'jpgcompression' => { 234 => 0x24, 243 => 0x44, 277 => '671.1' },
	'jpgfromraw' => { 103 => 0x2007, 120 => 'Exif-JpgFromRaw', 359 => 0x2e },
	'jpgfromrawlength' => { 125 => [0x117,0x202] },
	'jpgfromrawstart' => { 125 => [0x111,0x201] },
	'jpgrecordedpixels' => { 370 => '14.1' },
	'jurisdiction' => { 521 => 'jurisdiction' },
	'jxldecodespeed' => { 125 => 0xcd4b },
	'jxldistance' => { 125 => 0xcd49 },
	'jxleffort' => { 125 => 0xcd4a },
	'keepexposure' => { 326 => 0x237, 327 => 0x237, 328 => 0x24f },
	'kelvinwb_01' => { 378 => 0x5 },
	'kelvinwb_02' => { 378 => 0x9 },
	'kelvinwb_03' => { 378 => 0xd },
	'kelvinwb_04' => { 378 => 0x11 },
	'kelvinwb_05' => { 378 => 0x15 },
	'kelvinwb_06' => { 378 => 0x19 },
	'kelvinwb_07' => { 378 => 0x1d },
	'kelvinwb_08' => { 378 => 0x21 },
	'kelvinwb_09' => { 378 => 0x25 },
	'kelvinwb_10' => { 378 => 0x29 },
	'kelvinwb_11' => { 378 => 0x2d },
	'kelvinwb_12' => { 378 => 0x31 },
	'kelvinwb_13' => { 378 => 0x35 },
	'kelvinwb_14' => { 378 => 0x39 },
	'kelvinwb_15' => { 378 => 0x3d },
	'kelvinwb_16' => { 378 => 0x41 },
	'kelvinwb_daylight' => { 378 => 0x1 },
	'kerneldenominators' => { 145 => 0x933 },
	'key' => { 552 => 'key' },
	'keystonecompensation' => { 334 => 0x1900 },
	'keystonedirection' => { 334 => 0x1901 },
	'keystonevalue' => { 334 => 0x1906 },
	'keyword' => { 408 => 'keyw', 542 => 'keyword' },
	'keywordinfo' => { 178 => 'Keywords' },
	'keywords' => { 138 => 0x19, 164 => 'Keywords', 339 => 'Keywords', 406 => 'Keywords', 410 => 'keywords', 517 => 'keywords', 539 => 'Keywords', 550 => 'Keywords' },
	'killdate' => { 542 => 'killDate' },
	'killdatea-platform' => { 542 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 542 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 144 => 0xf908, 147 => 0xe, 149 => [0xfa1e,0xfa52], 155 => 0x70 },
	'kodakimagewidth' => { 144 => 0xf907, 147 => 0xc, 149 => [0xfa1d,0xfa51], 155 => 0x6c },
	'kodakinfotype' => { 144 => 0xfa00 },
	'kodaklook' => { 145 => 0xe4c },
	'kodaklookprofile' => { 145 => 0x138a },
	'kodakmaker' => { 155 => 0x8 },
	'kodakmodel' => { 147 => 0x0, 155 => 0x28 },
	'kodaktag' => { 145 => 0x3ea },
	'kodakversion' => { 145 => 0x0 },
	'label' => { 343 => 'Label', 550 => 'Label' },
	'labelname1' => { 535 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 535 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 354 => 0x6f },
	'landscapeoutputhighlightpoint' => { 115 => 0x26 },
	'landscapeoutputshadowpoint' => { 115 => 0x27 },
	'landscaperawcolortone' => { 115 => 0x1f },
	'landscaperawcontrast' => { 115 => 0x21 },
	'landscaperawhighlight' => { 115 => 0x77 },
	'landscaperawhighlightpoint' => { 115 => 0x24 },
	'landscaperawlinear' => { 115 => 0x22 },
	'landscaperawsaturation' => { 115 => 0x20 },
	'landscaperawshadow' => { 115 => 0x80 },
	'landscaperawshadowpoint' => { 115 => 0x25 },
	'landscaperawsharpness' => { 115 => 0x23 },
	'landscapeunsharpmaskfineness' => { 115 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 115 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 115 => 0xa2 },
	'language' => { 247 => 0x8fc, 249 => 0x6a2, 250 => 0x6a2, 251 => 0x592, 252 => 0x5c2, 253 => 0x5da, 526 => 'language' },
	'languageidentifier' => { 138 => 0x87 },
	'largestvalidinteriorrectheight' => { 509 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 509 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 509 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 509 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 188 => 0x1b },
	'lastkeywordiptc' => { 185 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 185 => 'LastKeywordXMP' },
	'lastphotodate' => { 509 => 'LastPhotoDate' },
	'lasturl' => { 553 => 'LastURL' },
	'lateralchromaticaberration' => { 458 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 520 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 124 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 124 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 124 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 124 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 122 => 'Latitude' },
	'lc1' => { 380 => 0x2 },
	'lc10' => { 380 => 0xb },
	'lc11' => { 380 => 0xc },
	'lc12' => { 380 => 0xd },
	'lc14' => { 380 => 0xf },
	'lc15' => { 380 => 0x10 },
	'lc3' => { 380 => 0x4 },
	'lc4' => { 380 => 0x5 },
	'lc5' => { 380 => 0x6 },
	'lc6' => { 380 => 0x7 },
	'lc7' => { 380 => 0x8 },
	'lc8' => { 380 => 0x9 },
	'lcddisplayatpoweron' => { 90 => 0x811, 94 => 0xa },
	'lcddisplayreturntoshoot' => { 95 => 0x12 },
	'lcdillumination' => { 309 => '17.5', 310 => '5.2', 312 => '5.1', 313 => '5.1', 318 => '10.3', 319 => '4.2', 322 => '5.2', 323 => '5.1', 324 => '5.4', 325 => 0xf1, 326 => 0x101, 327 => 0x101, 328 => 0x117 },
	'lcdilluminationduringbulb' => { 90 => 0x408 },
	'lcdmatrix' => { 145 => 0xe74 },
	'lcdmatrixchickfix' => { 145 => 0xe75 },
	'lcdmatrixmarvin' => { 145 => 0xe76 },
	'lcdpanels' => { 89 => 0x8 },
	'lcheditor' => { 302 => 0x8ae85e },
	'legacyiptcdigest' => { 540 => 'LegacyIPTCDigest' },
	'legalcode' => { 521 => 'legalcode' },
	'lens' => { 125 => 0xfdea, 243 => 0x84, 520 => 'Lens' },
	'lensafstopbutton' => { 88 => 0x11, 89 => 0x13, 90 => 0x506, 91 => 0x10, 92 => 0x12, 95 => 0x13, 96 => 0x9 },
	'lensaperturerange' => { 434 => [0x30,0x48] },
	'lensblur' => { 523 => 'LensBlur', 525 => 'LensBlur' },
	'lensbluractive' => { 523 => [\'LensBlur','LensBlurActive'], 525 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 523 => [\'LensBlur','LensBlurBlurAmount'], 525 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 523 => [\'LensBlur','LensBlurBokehAspect'], 525 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 523 => [\'LensBlur','LensBlurBokehRotation'], 525 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 523 => [\'LensBlur','LensBlurBokehShape'], 525 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 523 => [\'LensBlur','LensBlurBokehShapeDetail'], 525 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 523 => [\'LensBlur','LensBlurCatEyeAmount'], 525 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 523 => [\'LensBlur','LensBlurCatEyeScale'], 525 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 523 => [\'LensBlur','LensBlurFocalRange'], 525 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 523 => [\'LensBlur','LensBlurFocalRangeSource'], 525 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 523 => [\'LensBlur','LensBlurHighlightsBoost'], 525 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 523 => [\'LensBlur','LensBlurHighlightsThreshold'], 525 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 523 => [\'LensBlur','LensBlurSampledArea'], 525 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 523 => [\'LensBlur','LensBlurSampledRange'], 525 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 523 => [\'LensBlur','LensBlurSphericalAberration'], 525 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 523 => [\'LensBlur','LensBlurSubjectRange'], 525 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 523 => [\'LensBlur','LensBlurVersion'], 525 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 325 => 0xb1, 326 => 0xad, 327 => 0xad, 328 => 0xad },
	'lenscorrectionsettings' => { 528 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 520 => 'LensDistortInfo' },
	'lensdistortionparams' => { 335 => 0x206 },
	'lensdriveend' => { 241 => 0x56 },
	'lensdrivenoaf' => { 90 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 446 => 0x3f0, 494 => 0xd },
	'lensfirmware' => { 425 => 0x20, 431 => 0xa004 },
	'lensfirmwareversion' => { 241 => 0x34, 331 => 0x204, 354 => 0x60, 446 => 0x3f3, 494 => 0x14 },
	'lensfocallength' => { 109 => 0xf0512, 380 => 0x9 },
	'lensfocalrange' => { 434 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 310 => '55.1', 312 => '52.1', 313 => '52.1', 322 => '52.1', 323 => '52.1' },
	'lensformat' => { 471 => 0x1891, 473 => 0x18bd, 474 => 0x18ed, 475 => 0x17f1, 477 => 0x106, 478 => 0x106, 489 => 0x603, 490 => 0x5d },
	'lensfstops' => { 235 => 0x7, 236 => 0xc, 237 => 0xd, 241 => 0xe, 243 => 0x8b, 380 => '0.3' },
	'lensfunc1button' => { 325 => 0xa3, 326 => 0x9f, 327 => 0x9f, 328 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 250 => 0x80a, 253 => 0x810 },
	'lensfunc2button' => { 325 => 0xab, 326 => 0xa7, 327 => 0xa7, 328 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 250 => 0x80c, 253 => 0x812 },
	'lensid' => { 241 => 0x30, 520 => 'LensID' },
	'lensidnumber' => { 235 => 0x6, 236 => 0xb, 237 => 0xc, 241 => 0xd },
	'lensinfo' => { 125 => 0xa432, 386 => 0x2a, 520 => 'LensInfo', 530 => 'LensSpecification' },
	'lenskind' => { 380 => 0x1 },
	'lensmake' => { 125 => 0xa433, 170 => 'Make', 530 => 'LensMake' },
	'lensmanualdistortionamount' => { 523 => 'LensManualDistortionAmount', 525 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 185 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 434 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 69 => 0x95, 125 => 0xa434, 170 => 'Model', 185 => 'LensModel', 238 => 0x18a, 239 => 0x18b, 240 => 0x2ac, 331 => 0x203, 386 => 0xc, 399 => 0x412, 417 => 'camera.lens_model', 530 => 'LensModel' },
	'lensmodulationoptimizer' => { 133 => 0x1045 },
	'lensmount' => { 446 => 0x99, 471 => 0x1892, 473 => 0x18be, 474 => 0x18ee, 475 => 0x17f2, 477 => 0x105, 478 => 0x105, 489 => 0x604, 490 => 0x5e },
	'lensmount2' => { 494 => 0x8 },
	'lensmounttype' => { 241 => 0x5f },
	'lenspositionabsolute' => { 241 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 523 => 'LensProfileChromaticAberrationScale', 525 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 523 => 'LensProfileDigest', 525 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 523 => 'LensProfileDistortionScale', 525 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 523 => 'LensProfileEnable', 525 => 'LensProfileEnable' },
	'lensprofilefilename' => { 523 => 'LensProfileFilename', 525 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 523 => 'LensProfileIsEmbedded', 525 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 523 => 'LensProfileMatchKeyCameraModelName', 525 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 523 => 'LensProfileMatchKeyExifMake', 525 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 523 => 'LensProfileMatchKeyExifModel', 525 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 523 => 'LensProfileMatchKeyIsRaw', 525 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 523 => 'LensProfileMatchKeyLensID', 525 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 523 => 'LensProfileMatchKeyLensInfo', 525 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 523 => 'LensProfileMatchKeyLensName', 525 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 523 => 'LensProfileMatchKeySensorFormatFactor', 525 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 353 => 0x370, 523 => 'LensProfileName', 525 => 'LensProfileName' },
	'lensprofilesetup' => { 523 => 'LensProfileSetup', 525 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 523 => 'LensProfileVignettingScale', 525 => 'LensProfileVignettingScale' },
	'lensproperties' => { 331 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 35 => 0x16b, 65 => 0x0, 125 => 0xa435, 170 => 'SerialNumber', 331 => 0x202, 352 => 0x321, 354 => 0x52, 416 => 'LENS', 425 => 0x30, 520 => 'LensSerialNumber', 530 => 'LensSerialNumber' },
	'lensshutterlock' => { 191 => 0x4a },
	'lensspec' => { 441 => 0x0, 442 => 0x0, 443 => 0x0, 458 => 0xb02a },
	'lensspecfeatures' => { 477 => [0x115,0x116], 478 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 335 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 37 => 0x16, 193 => 0x10c, 194 => 0x49bd, 243 => 0x83, 331 => 0x201, 345 => 0x16, 349 => 0x310, 351 => 0x303, 352 => 0x303, 354 => 0x51, 356 => 0x3405, 381 => 0x0, 382 => 0x0, 383 => 0x1, 384 => 0x1, 385 => 0x1, 387 => 0x0, 431 => 0xa003, 434 => 0x27, 458 => 0xb027, 471 => 0x1896, 473 => 0x18c2, 474 => 0x18f2, 475 => 0x17f6, 477 => 0x109, 478 => 0x109, 489 => 0x608, 490 => 0x62 },
	'lenstype2' => { 446 => 0x3f7, 471 => 0x1893, 473 => 0x18bf, 474 => 0x18ef, 475 => 0x17f3, 477 => 0x107, 478 => 0x107, 489 => 0x605, 490 => 0x60 },
	'lenstype3' => { 494 => 0x9 },
	'lenstypemake' => { 354 => 0xc4 },
	'lenstypemodel' => { 354 => [0xc5,0xe4] },
	'lenszoomposition' => { 486 => 0x19, 487 => 0x1e, 490 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 362 => 0x15 },
	'levelmeter' => { 416 => ['Lvlm','lvlm'] },
	'levelorientation' => { 388 => 0x0 },
	'license' => { 521 => 'license' },
	'licensee' => { 340 => 'Licensee' },
	'licenseeid' => { 340 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 340 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 340 => 'LicenseeImageNotes' },
	'licenseename' => { 340 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 340 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 340 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 340 => 'LicenseeTransactionID' },
	'licenseid' => { 340 => 'LicenseID' },
	'licensestartdate' => { 340 => 'LicenseStartDate' },
	'licensetransactiondate' => { 340 => 'LicenseTransactionDate' },
	'licensetype' => { 527 => 'licensetype' },
	'licensor' => { 340 => 'Licensor' },
	'licensorcity' => { 340 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 340 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 340 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 340 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 340 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 340 => 'LicensorImageID' },
	'licensorname' => { 340 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 340 => 'LicensorNotes' },
	'licensorpostalcode' => { 340 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 340 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 340 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 340 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 340 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 340 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 340 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 340 => 'LicensorTransactionID' },
	'licensorurl' => { 340 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 335 => 0x1009 },
	'lightingmode' => { 119 => 0x302a },
	'lightreading' => { 390 => 0x15 },
	'lightsource' => { 125 => 0x9208, 243 => 0x90, 338 => 0x1000, 529 => 'LightSource' },
	'lightsourcespecial' => { 433 => 0x21d },
	'lightswitch' => { 322 => '0.1', 324 => '0.1' },
	'lightvaluecenter' => { 335 => 0x103d },
	'lightvalueperiphery' => { 335 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 325 => 0x143, 326 => 0x153, 327 => 0x153, 328 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 325 => 0x141, 326 => 0x151, 327 => 0x151, 328 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 325 => 0x140, 326 => 0x150, 327 => 0x150, 328 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 325 => 0x13f, 326 => 0x14f, 327 => 0x14f, 328 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 325 => 0x11, 326 => 0x11, 327 => 0x11, 328 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 325 => 0x14, 326 => 0x14, 327 => 0x14, 328 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 325 => 0x13, 326 => 0x13, 327 => 0x13, 328 => 0x13 },
	'limitafareamodeselauto' => { 325 => 0x15, 326 => 0x15, 327 => 0x15, 328 => 0x15 },
	'limitafareamodeselection' => { 310 => '51.1', 312 => '49.1', 313 => '49.1', 322 => '49.1', 323 => '49.1' },
	'limitreleasemodeselc120' => { 327 => '269.4', 328 => '293.4' },
	'limitreleasemodeselc30' => { 327 => '269.3', 328 => '293.3' },
	'limitreleasemodeselch' => { 327 => '269.2', 328 => '293.2' },
	'limitreleasemodeselcl' => { 327 => '269.1', 328 => '293.1' },
	'limitreleasemodeselself' => { 327 => '269.5', 328 => '293.5' },
	'limitselectableimagearea16to9' => { 325 => 0x4d, 326 => 0x47, 327 => 0x47, 328 => 0x47 },
	'limitselectableimagearea1to1' => { 325 => 0x4c, 326 => 0x46, 327 => 0x46, 328 => 0x46 },
	'limitselectableimageareadx' => { 325 => 0x4b, 326 => 0x45, 327 => 0x45, 328 => 0x45 },
	'linearitylimitblue' => { 359 => 0x10 },
	'linearitylimitgreen' => { 359 => 0xf },
	'linearitylimitred' => { 359 => 0xe },
	'linearityuppermargin' => { 44 => 0x32c, 45 => 0x282, 46 => 0x296, 49 => [0x2ba,0x2d1,0x2d5], 51 => 0x1e5, 52 => [0x1fe,0x2de], 53 => [0x232,0x310], 54 => 0x31e },
	'linearizationtable' => { 125 => 0xc618 },
	'linearresponselimit' => { 125 => 0xc62e },
	'link' => { 542 => 'link' },
	'linkaetoafpoint' => { 370 => '14.2' },
	'linkedencodedrightsexpr' => { 537 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 537 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 537 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 537 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 247 => 0x3ec },
	'linlogcoring' => { 145 => 0x904 },
	'lithostratigraphicterms' => { 124 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 410 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 410 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 410 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 365 => 0x1fa, 372 => 0x3 },
	'liveviewaf' => { 314 => '32.1', 324 => '34.1' },
	'liveviewafareamode' => { 319 => '34.1' },
	'liveviewafmethod' => { 463 => 0x20 },
	'liveviewafmode' => { 319 => '34.2' },
	'liveviewafsetting' => { 446 => 0x36 },
	'liveviewbuttonoptions' => { 310 => '50.2', 312 => '48.2', 313 => '48.2', 322 => '48.2', 323 => '48.2' },
	'liveviewexposuresimulation' => { 90 => 0x810 },
	'liveviewfocusmode' => { 446 => [0x8b,0x28b] },
	'liveviewmetering' => { 446 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 310 => '21.2', 312 => '21.2', 313 => '21.2', 315 => '20.2', 316 => '20.2', 317 => '20.2', 319 => '20.2', 322 => '21.2', 323 => '21.2' },
	'liveviewshooting' => { 61 => 0x13 },
	'livingspecimen' => { 124 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 124 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 138 => 0x79 },
	'localizedcameramodel' => { 125 => 0xc615 },
	'locallocationname' => { 431 => 0x30 },
	'location' => { 242 => 0x9, 354 => 0x67, 515 => 'Location', 536 => 'Location', 541 => 'location', 542 => 'location' },
	'locationaccuracyhorizontal' => { 410 => 'location.accuracy.horizontal' },
	'locationareacode' => { 522 => 'lac' },
	'locationbody' => { 410 => 'location.body' },
	'locationcreated' => { 537 => 'LocationCreated' },
	'locationcreatedcity' => { 537 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 537 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 537 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 537 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 537 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 537 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 537 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 537 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 537 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 537 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 537 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 537 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 537 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 410 => 'location.date' },
	'locationinformation' => { 416 => 'loci' },
	'locationinfoversion' => { 242 => 0x0 },
	'locationname' => { 410 => 'location.name', 431 => 0x31 },
	'locationnote' => { 410 => 'location.note' },
	'locationrole' => { 410 => 'location.role' },
	'locationshown' => { 537 => 'LocationShown' },
	'locationshowncity' => { 537 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 537 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 537 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 537 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 537 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 537 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 537 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 537 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 537 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 537 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 537 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 537 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 537 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 90 => 0x709 },
	'logcomment' => { 552 => 'logComment' },
	'logscale' => { 145 => 0x902 },
	'longdescription' => { 408 => 'ldes' },
	'longexposurenoisereduction' => { 67 => 0x4, 90 => 0x201, 91 => 0x1, 92 => 0x2, 93 => 0x1, 94 => 0x1, 95 => 0x2, 96 => 0x1, 354 => 0x49, 444 => 0x2b, 445 => 0x25, 446 => 0x25, 458 => 0x2008, 463 => 0x11, 490 => 0x44 },
	'longexposurenoisereduction2' => { 61 => 0x8 },
	'longexposurenrused' => { 354 => 0xbe },
	'longitude' => { 122 => 'Longitude' },
	'look' => { 523 => 'Look', 525 => 'Look' },
	'lookamount' => { 523 => [\'Look','LookAmount'], 525 => [\'Look','LookAmount'] },
	'lookcluster' => { 523 => [\'Look','LookCluster'], 525 => [\'Look','LookCluster'] },
	'lookcopyright' => { 523 => [\'Look','LookCopyright'], 525 => [\'Look','LookCopyright'] },
	'lookgroup' => { 523 => [\'Look','LookGroup'], 525 => [\'Look','LookGroup'] },
	'lookname' => { 523 => 'LookName', 525 => 'LookName' },
	'lookparameters' => { 523 => [\'Look','LookParameters'], 525 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 523 => [\'Look','LookParametersCameraProfile'], 525 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 523 => [\'Look','LookParametersClarity2012'], 525 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 523 => [\'Look','LookParametersConvertToGrayscale'], 525 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 523 => [\'Look','LookParametersHighlights2012'], 525 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 523 => [\'Look','LookParametersLookTable'], 525 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 523 => [\'Look','LookParametersProcessVersion'], 525 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 523 => [\'Look','LookParametersShadows2012'], 525 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 523 => [\'Look','LookParametersToneCurvePV2012'], 525 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 523 => [\'Look','LookParametersToneCurvePV2012Blue'], 525 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 523 => [\'Look','LookParametersToneCurvePV2012Green'], 525 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 523 => [\'Look','LookParametersToneCurvePV2012Red'], 525 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 523 => [\'Look','LookParametersVersion'], 525 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 523 => [\'Look','LookSupportsAmount'], 525 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 523 => [\'Look','LookSupportsMonochrome'], 525 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 523 => [\'Look','LookSupportsOutputReferred'], 525 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 523 => [\'Look','LookUUID'], 525 => [\'Look','LookUUID'] },
	'loop' => { 552 => 'loop' },
	'loopstyle' => { 416 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 124 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 523 => 'LuminanceAdjustmentAqua', 525 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 523 => 'LuminanceAdjustmentBlue', 525 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 523 => 'LuminanceAdjustmentGreen', 525 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 523 => 'LuminanceAdjustmentMagenta', 525 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 523 => 'LuminanceAdjustmentOrange', 525 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 523 => 'LuminanceAdjustmentPurple', 525 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 523 => 'LuminanceAdjustmentRed', 525 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 523 => 'LuminanceAdjustmentYellow', 525 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 114 => 0x150 },
	'luminancecurvepoints' => { 114 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 109 => 0x20600, 115 => 0x5f, 434 => 0x1b },
	'luminancenoisereductioncontrast' => { 523 => 'LuminanceNoiseReductionContrast', 525 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 523 => 'LuminanceNoiseReductionDetail', 525 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 115 => 0x6d },
	'luminancesmoothing' => { 523 => 'LuminanceSmoothing', 525 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 90 => [0x40b,0x40c] },
	'lyrics' => { 408 => "\xa9lyr", 416 => "\xa9lyr", 552 => 'lyrics' },
	'lyricsuri' => { 416 => 'lrcu' },
	'm16cversion' => { 349 => 0x333 },
	'macatom' => { 524 => 'macAtom' },
	'macatomapplicationcode' => { 524 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 524 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 524 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 124 => 'MachineObservation' },
	'machineobservationday' => { 124 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 124 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 124 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 124 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 124 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 124 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 124 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 124 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 124 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 124 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 124 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 124 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 124 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 124 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 124 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 124 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 124 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 124 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 124 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 124 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 133 => 0x1020, 135 => 0x202, 158 => 0x2b, 335 => 0x202, 423 => 0x21, 433 => 0x202, 458 => 0xb040 },
	'macroled' => { 333 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 61 => 0x10 },
	'macromode' => { 37 => 0x1, 188 => 0xb, 330 => 0x300, 354 => 0x1c, 424 => 0x1009 },
	'magentahsl' => { 109 => 0x20917 },
	'magicfilter' => { 330 => 0x52c },
	'magnifiedview' => { 92 => 0x11, 94 => 0x9 },
	'mainboardversion' => { 145 => 0x438 },
	'maindialexposurecomp' => { 320 => '0.6' },
	'mainingredient' => { 544 => 'mainIngredient' },
	'majorbrand' => { 410 => 'major_brand' },
	'majorversion' => { 513 => 'MajorVersion' },
	'make' => { 104 => 0x0, 121 => 0x1, 125 => 0x10f, 163 => 'Make', 343 => 'Make', 359 => 0x10f, 410 => 'make', 416 => ['@mak',"\xa9mak"], 541 => 'make', 548 => 'Make' },
	'makernote' => { 529 => 'MakerNote' },
	'makernoteapple' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecanon' => { 87 => 'CMT3', 123 => 'MakN', 125 => 0x927c },
	'makernotecasio' => { 123 => 'MakN', 125 => 0x927c },
	'makernotecasio2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedji' => { 123 => 'MakN', 125 => 0x927c },
	'makernotedjiinfo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteflir' => { 123 => 'MakN', 125 => 0x927c },
	'makernotefujifilm' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege' => { 123 => 'MakN', 125 => 0x927c },
	'makernotege2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehasselblad' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotehp6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteisl' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvc' => { 123 => 'MakN', 125 => 0x927c },
	'makernotejvctext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak10' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak11' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak12' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak6b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak7' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak8c' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodak9' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekodakunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernotekyocera' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica10' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica3' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica4' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica5' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica6' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica7' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica8' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteleica9' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteminolta3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotemotorola' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenikon3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotenintendo' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteoffset' => { 433 => 0xff },
	'makernoteolympus' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus2' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteolympus3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepanasonic3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentax6' => { 123 => 'MakN', 125 => 0x927c },
	'makernotepentaxunknown' => { 416 => 'PXMN' },
	'makernotephaseone' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotereconyx3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericoh2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohpentax' => { 123 => 'MakN', 125 => 0x927c },
	'makernotericohtext' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesafety' => { 125 => 0xc635 },
	'makernotesamsung1a' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung1b' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesamsung2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyo' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyoc4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesanyopatch' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesigma' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony2' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony3' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony4' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesony5' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonyericsson' => { 123 => 'MakN', 125 => 0x927c },
	'makernotesonysrf' => { 123 => 'MakN', 125 => 0x927c },
	'makernotetype' => { 424 => 0x1 },
	'makernoteunknown' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknownbinary' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteunknowntext' => { 123 => 'MakN', 125 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 193 => 0x0, 243 => 0x1, 335 => 0x0, 354 => 0x8000, 428 => 0x0, 431 => 0x1, 434 => [0x1d,0x1f], 447 => 0x2000 },
	'makerurl' => { 416 => "\xa9mal" },
	'managedfrom' => { 553 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 553 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 553 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 553 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 553 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 553 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 553 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 553 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 553 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 553 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 553 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 553 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 553 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 553 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 553 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 553 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 553 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 553 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 553 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 553 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 553 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 553 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 553 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 553 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 553 => 'Manager' },
	'managervariant' => { 553 => 'ManagerVariant' },
	'manageto' => { 553 => 'ManageTo' },
	'manageui' => { 553 => 'ManageUI' },
	'manifest' => { 553 => 'Manifest' },
	'manifestlinkform' => { 553 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 553 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 553 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 553 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 553 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 553 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 553 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 553 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 553 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 553 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 553 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 553 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 553 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 553 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 553 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 553 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 553 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 553 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 553 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 553 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 553 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 553 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 553 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 553 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 553 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 553 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 553 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 553 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 330 => 0x900, 354 => 0x86 },
	'manometerreading' => { 330 => 0x901 },
	'manualafpointselectpattern' => { 90 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 333 => 0x1209 },
	'manualflashoutput' => { 37 => 0x29, 311 => '8.2', 314 => '22.2', 315 => '23.1', 316 => '23.2', 318 => '16.2', 319 => '23.2', 320 => '8.2', 321 => '23.2', 324 => '24.2', 424 => 0x100c },
	'manualflashstrength' => { 330 => 0x406 },
	'manualfocusdistance' => { 243 => 0x85, 335 => 0x100c, 433 => 0x223 },
	'manualfocuspointillumination' => { 325 => 0x17, 326 => 0x17, 327 => 0x17, 328 => 0x17 },
	'manualfocusringinafmode' => { 325 => 0x1b, 326 => 0x1a, 327 => 0x1a, 328 => 0x1a },
	'manualtv' => { 89 => 0x5, 90 => 0x705 },
	'manufacturedate' => { 198 => 0x6705, 369 => 0x1 },
	'manufacturedate1' => { 426 => 0x4 },
	'manufacturedate2' => { 426 => 0x5 },
	'manufacturer' => { 506 => 'Manufacturer', 541 => 'manufacturer' },
	'mariahchromablursize' => { 145 => 0xf0d },
	'mariahmaphithreshold' => { 145 => 0xf0c },
	'mariahmaplothreshold' => { 145 => 0xf0b },
	'mariahsigmathreshold' => { 145 => 0xf0e },
	'mariahtexturethreshold' => { 145 => 0xf0a },
	'marked' => { 539 => 'Marked', 556 => 'Marked' },
	'markers' => { 552 => 'markers' },
	'markerscomment' => { 552 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 552 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 552 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 552 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 552 => [\'markers','markersCuePointType'] },
	'markersduration' => { 552 => [\'markers','markersDuration'] },
	'markerslocation' => { 552 => [\'markers','markersLocation'] },
	'markersname' => { 552 => [\'markers','markersName'] },
	'markersprobability' => { 552 => [\'markers','markersProbability'] },
	'markersspeaker' => { 552 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 552 => [\'markers','markersStartTime'] },
	'markerstarget' => { 552 => [\'markers','markersTarget'] },
	'markerstype' => { 552 => [\'markers','markersType'] },
	'maskedareas' => { 125 => 0xc68e },
	'maskgroupbasedcorractive' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 523 => 'MaskGroupBasedCorrections', 525 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 523 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 525 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 138 => 0xb9 },
	'mastergain' => { 268 => 0x50 },
	'materialsample' => { 124 => 'MaterialSample' },
	'materialsampleid' => { 124 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 310 => '50.1', 312 => '48.1', 313 => '48.1', 322 => '48.1', 323 => '48.1', 326 => 0x233, 327 => 0x233, 328 => 0x24b },
	'matrixselectk' => { 145 => 0x91b },
	'matrixselectthreshold' => { 145 => 0x91a },
	'matrixselectthreshold1' => { 145 => 0x91e },
	'matrixselectthreshold2' => { 145 => 0x91f },
	'matrixstructure' => { 415 => 0xa },
	'maxaperture' => { 37 => 0x1a, 145 => 0x3f9, 151 => 0x6103, 170 => 'MaxAperture', 188 => 0x17, 194 => 0x49c5, 241 => 0x36, 331 => 0x20a, 380 => '14.1' },
	'maxapertureatmaxfocal' => { 133 => 0x1407, 170 => 'MaxApertureAtMaxFocal', 235 => 0xb, 236 => 0x10, 237 => 0x11, 241 => 0x12, 331 => 0x206 },
	'maxapertureatminfocal' => { 133 => 0x1406, 235 => 0xa, 236 => 0xf, 237 => 0x10, 241 => 0x11, 331 => 0x205 },
	'maxaperturevalue' => { 125 => 0x9205, 399 => 0x414, 529 => 'MaxApertureValue' },
	'maxavailheight' => { 537 => 'MaxAvailHeight' },
	'maxavailwidth' => { 537 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 309 => 0xb, 310 => 0xc, 312 => '12.1', 313 => '12.1', 318 => 0xc, 319 => 0xb, 322 => '12.1', 323 => '12.1', 325 => 0x41, 326 => 0x3d, 327 => 0x3d, 328 => 0x3d },
	'maxfaces' => { 334 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 37 => 0x17, 133 => 0x1405, 170 => 'MaxFocalLength', 235 => 0x9, 236 => 0xe, 237 => 0xf, 241 => 0x10, 331 => 0x208, 471 => 0x127c, 472 => 0x1138, 473 => 0x330, 474 => 0x330, 475 => 0x30e },
	'maxfocallength2' => { 66 => 0x9 },
	'maximumdensityrange' => { 140 => 0x8c },
	'maxpagesize' => { 557 => 'MaxPageSize' },
	'maxpagesizeh' => { 557 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 557 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 557 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 145 => 0xc7d },
	'maxsamplevalue' => { 125 => 0x119 },
	'maxstorage' => { 547 => 'maxstorage' },
	'mb-d10batteries' => { 309 => '12.6' },
	'mb-d10batterytype' => { 318 => '13.3' },
	'mb-d11batterytype' => { 319 => '2.3' },
	'mb-d12batterytype' => { 322 => '3.2' },
	'mb-d80batteries' => { 320 => '6.5' },
	'mb-d80batterytype' => { 324 => '3.2' },
	'mcuversion' => { 235 => 0xc, 236 => 0x11, 237 => 0x12, 241 => 0x13 },
	'md5digest' => { 171 => 'zmd5' },
	'mditemfindercomment' => { 180 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 180 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 180 => 'MDItemFSLabel' },
	'mditemusertags' => { 180 => 'MDItemUserTags' },
	'meal' => { 544 => 'meal' },
	'measuredev' => { 28 => 0x9, 82 => 0x3, 103 => 0x1814, 163 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 82 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 194 => 0x690, 349 => 0x312, 352 => 0x312, 353 => 0x312, 356 => 0x3407 },
	'measuredrggb' => { 70 => 0x1 },
	'measuredrggbdata' => { 48 => 0x287 },
	'measurementaccuracy' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 124 => 'MeasurementOrFact' },
	'measurementremarks' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 124 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 506 => 'MeasureType' },
	'mechanicalshuttercount' => { 243 => 0x37 },
	'mediaclassprimaryid' => { 186 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 186 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 340 => 'MediaConstraints' },
	'mediacreatedate' => { 412 => 0x1 },
	'mediaeventiddate' => { 511 => 'MediaEventIdDate' },
	'mediamodifydate' => { 412 => 0x2 },
	'mediasummarycode' => { 340 => 'MediaSummaryCode' },
	'mediatype' => { 408 => 'stik' },
	'memoaudioquality' => { 90 => 0x812 },
	'memorycardconfiguration' => { 450 => 0x16 },
	'memorycardnumber' => { 220 => 0x2 },
	'menubuttondisplayposition' => { 88 => 0xb, 91 => 0xa, 92 => 0xb, 95 => 0xb },
	'menubuttonreturn' => { 96 => 0xb },
	'menumonitorofftime' => { 309 => '26.1', 310 => '22.1', 312 => '22.1', 313 => '22.1', 317 => '21.1', 318 => '8.2', 319 => '21.1', 322 => '22.1', 323 => '22.1', 324 => '22.1', 325 => 0x39, 326 => 0x35, 327 => 0x35, 328 => 0x35 },
	'mergedimages' => { 354 => 0x76 },
	'metadataauthority' => { 537 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 537 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 537 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 550 => 'MetadataDate' },
	'metadataeditingsoftware' => { 125 => 0xa43c, 530 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 537 => 'metadataLastEdited' },
	'metadatalasteditor' => { 537 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 537 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 537 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 552 => 'metadataModDate' },
	'metaversion' => { 466 => 0x34 },
	'meterinfo1row1' => { 459 => 0x0, 460 => 0x0 },
	'meterinfo1row2' => { 459 => 0x6c, 460 => 0x5a },
	'meterinfo1row3' => { 459 => 0xd8, 460 => 0xb4 },
	'meterinfo1row4' => { 459 => 0x144, 460 => 0x10e },
	'meterinfo1row5' => { 459 => 0x1b0, 460 => 0x168 },
	'meterinfo1row6' => { 459 => 0x21c, 460 => 0x1c2 },
	'meterinfo1row7' => { 459 => 0x288, 460 => 0x21c },
	'meterinfo2row1' => { 459 => 0x2f4, 460 => 0x276 },
	'meterinfo2row2' => { 459 => 0x378, 460 => 0x2e4 },
	'meterinfo2row3' => { 459 => 0x3fc, 460 => 0x352 },
	'meterinfo2row4' => { 459 => 0x480, 460 => 0x3c0 },
	'meterinfo2row5' => { 459 => 0x504, 460 => 0x42e },
	'meterinfo2row6' => { 459 => 0x588, 460 => 0x49c },
	'meterinfo2row7' => { 459 => 0x60c, 460 => 0x50a },
	'meterinfo2row8' => { 459 => 0x690, 460 => 0x578 },
	'meterinfo2row9' => { 459 => 0x714, 460 => 0x5e6 },
	'metering' => { 311 => '6.1' },
	'meteringmode' => { 37 => 0x11, 125 => 0x9207, 147 => 0x1c, 188 => 0x7, 189 => 0x25, 191 => 0x12, 330 => 0x202, 390 => 0x17, 434 => 0x9, 444 => 0x15, 445 => 0x13, 446 => 0x7, 463 => 0x3, 467 => 0x1174, 468 => 0x1178, 469 => 0x1154, 470 => 0x11d0, 471 => 0x11ac, 472 => 0x1064, 473 => 0x25c, 474 => 0x25c, 475 => 0x24b, 529 => 'MeteringMode' },
	'meteringmode2' => { 370 => '2.1', 458 => 0x202c },
	'meteringmode3' => { 370 => '16.1' },
	'meteringoffscaleindicator' => { 191 => 0x53 },
	'meteringtime' => { 309 => '22.2', 311 => '3.2', 314 => '17.1', 315 => '18.1', 318 => '7.3', 319 => '18.1', 320 => '3.2', 324 => '19.1' },
	'micro1version' => { 419 => 0x1f },
	'micro2version' => { 419 => 0x2d },
	'microphoneattenuator' => { 249 => 0x34e, 250 => 0x34e, 251 => 0x2d2, 252 => 0x2fa, 253 => 0x2fa },
	'microphonefrequencyresponse' => { 249 => 0x350, 250 => 0x350, 251 => 0x2d4, 252 => 0x2fc, 253 => 0x2fc },
	'microphonejackpower' => { 249 => 0x376, 250 => 0x376, 251 => 0x2fa, 252 => 0x322, 253 => 0x322 },
	'microphonesensitivity' => { 249 => 0x34c, 250 => 0x34c, 251 => 0x2d0, 252 => 0x2f8, 253 => 0x2f8 },
	'microvideo' => { 503 => 'MicroVideo' },
	'microvideooffset' => { 503 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 503 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 503 => 'MicroVideoVersion' },
	'midrangesharpness' => { 262 => 0x3b },
	'mieversion' => { 171 => '0Vers' },
	'mime' => { 506 => 'Mime' },
	'minaperture' => { 37 => 0x1b, 145 => 0x3f8, 170 => 'MinAperture', 380 => '0.2' },
	'minaperturevalue' => { 399 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 37 => 0x18, 133 => 0x1404, 170 => 'MinFocalLength', 235 => 0x8, 236 => 0xd, 237 => 0xe, 241 => 0xf, 331 => 0x207, 471 => 0x127a, 472 => 0x1136, 473 => 0x32e, 474 => 0x32e, 475 => 0x30c },
	'minfocallength2' => { 66 => 0x8 },
	'minfocusdistance' => { 380 => 0x3 },
	'minimumiso' => { 354 => 0xe8 },
	'minintegrationrows' => { 145 => 0x1874 },
	'minoltadate' => { 188 => 0x15 },
	'minoltaimagesize' => { 188 => 0x4, 189 => 0xc, 190 => 0x2, 193 => 0x103 },
	'minoltamodelid' => { 188 => 0x25 },
	'minoltaquality' => { 188 => 0x5, 189 => 0xd, 190 => 0x3, 193 => [0x102,0x103] },
	'minoltatime' => { 188 => 0x16 },
	'minormodelagedisclosure' => { 340 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 410 => 'minor_version', 513 => 'MinorVersion' },
	'minsamplevalue' => { 125 => 0x118 },
	'mirrorlockup' => { 88 => 0xc, 89 => 0xc, 90 => 0x60f, 91 => 0xb, 92 => 0xc, 93 => 0x6, 94 => 0x6, 95 => 0xc, 96 => 0x3 },
	'mobilecountrycode' => { 522 => 'mcc' },
	'mobilenetworkcode' => { 522 => 'mnc' },
	'moddate' => { 343 => 'modify-date', 539 => 'ModDate' },
	'modedialposition' => { 450 => 0x14 },
	'model' => { 104 => 0x6, 125 => 0x110, 163 => 'Model', 343 => 'Model', 359 => 0x110, 390 => 0x23f, 410 => 'model', 416 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 434 => 0x84, 506 => 'Model', 541 => 'model', 548 => 'Model' },
	'modelage' => { 537 => 'ModelAge' },
	'modelid' => { 329 => 0x0 },
	'modelingflash' => { 309 => '21.4', 310 => '31.1', 312 => '31.1', 313 => '31.1', 318 => '26.4', 319 => '30.2', 320 => '7.4', 321 => '30.1', 322 => '31.1', 323 => '31.1', 324 => '31.3', 325 => 0x61, 326 => 0x5d, 327 => 0x5d, 328 => 0x5d },
	'modelreleaseid' => { 340 => 'ModelReleaseID' },
	'modelreleasestatus' => { 340 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 481 => 0x52, 482 => 0x46, 483 => 0x53 },
	'modeltiepoint' => { 125 => 0x8482 },
	'modeltransform' => { 125 => 0x85d8 },
	'modelyear' => { 541 => 'modelYear' },
	'modificationdate' => { 542 => 'modificationDate' },
	'modifiedcolortemp' => { 71 => 0x9 },
	'modifieddigitalgain' => { 71 => 0xb },
	'modifiedparamflag' => { 62 => 0x1 },
	'modifiedpicturestyle' => { 71 => 0xa },
	'modifiedsaturation' => { 330 => 0x504 },
	'modifiedsensorbluelevel' => { 71 => 0x5 },
	'modifiedsensorredlevel' => { 71 => 0x4 },
	'modifiedsharpness' => { 71 => 0x2 },
	'modifiedsharpnessfreq' => { 71 => 0x3 },
	'modifiedtonecurve' => { 71 => 0x1 },
	'modifiedwhitebalance' => { 71 => 0x8 },
	'modifiedwhitebalanceblue' => { 71 => 0x7 },
	'modifiedwhitebalancered' => { 71 => 0x6 },
	'modifydate' => { 125 => 0x132, 164 => 'ModifyDate', 339 => 'ModDate', 341 => 'tIME', 406 => 'ModDate', 413 => 0x2, 550 => 'ModifyDate' },
	'moirefilter' => { 125 => 0xfe58, 523 => 'MoireFilter', 525 => 'MoireFilter' },
	'monitorbrightness' => { 247 => 0x904, 249 => 0x69a, 250 => 0x6aa, 251 => 0x59a, 252 => 0x5ca, 253 => 0x5e2 },
	'monitordisplayoff' => { 191 => 0x4c },
	'monitormatrix' => { 145 => 0x8fc },
	'monitorofftime' => { 309 => '18.2', 311 => '3.1', 320 => '3.1' },
	'monochromecolor' => { 330 => 0x53b },
	'monochromecontrast' => { 115 => 0x3c },
	'monochromefiltereffect' => { 109 => 0x20307, 115 => 0x3a, 354 => 0xac, 390 => 0x73 },
	'monochromegraineffect' => { 354 => 0xd2 },
	'monochromelinear' => { 115 => 0x3d },
	'monochromeoutputhighlightpoint' => { 115 => 0x41 },
	'monochromeoutputshadowpoint' => { 115 => 0x42 },
	'monochromeprofilesettings' => { 330 => 0x537 },
	'monochromerawhighlight' => { 115 => 0x7a },
	'monochromerawhighlightpoint' => { 115 => 0x3f },
	'monochromerawshadow' => { 115 => 0x83 },
	'monochromerawshadowpoint' => { 115 => 0x40 },
	'monochromesharpness' => { 115 => 0x3e },
	'monochrometoning' => { 390 => 0x74 },
	'monochrometoningeffect' => { 109 => 0x20306, 115 => 0x3b },
	'monochromeunsharpmaskfineness' => { 115 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 115 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 115 => 0xb4 },
	'monochromevignetting' => { 330 => 0x53a },
	'monthdaycreated' => { 147 => 0x12, 156 => 0xe },
	'mood' => { 186 => 'WM/Mood' },
	'moonphase' => { 418 => 0x12, 419 => 0x43, 420 => 0x4c },
	'morepermissions' => { 521 => 'morePermissions' },
	'motionphoto' => { 503 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 503 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 503 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 411 => 'mpvd' },
	'motionsensitivity' => { 418 => 0x29, 420 => 0x60 },
	'movementcount' => { 408 => "\xa9mvc" },
	'movementname' => { 408 => "\xa9mvn" },
	'movementnumber' => { 408 => "\xa9mvi" },
	'movieactived-lighting' => { 248 => 0x238, 249 => 0x334, 250 => 0x334, 251 => 0x2b8, 252 => 0x2e0, 253 => 0x2e0 },
	'movieaelockbuttonassignment' => { 322 => '40.1' },
	'movieaf-onbutton' => { 325 => 0xd3, 326 => 0xcb, 327 => 0xcb, 328 => 0xcb },
	'movieafareamode' => { 249 => 0x342, 250 => 0x342, 251 => 0x2c6, 252 => 0x2ee, 253 => 0x2ee, 326 => 0x203, 327 => 0x203, 328 => 0x21b },
	'movieafspeed' => { 325 => 0xe5, 326 => 0xdd, 327 => 0xdd, 328 => 0xdd },
	'movieafspeedapply' => { 325 => 0xe7, 326 => 0xdf, 327 => 0xdf, 328 => 0xdf },
	'movieaftrackingsensitivity' => { 325 => 0xe9, 326 => 0xe1, 327 => 0xe1, 328 => 0xe1 },
	'movieaperturelock' => { 326 => 0x259, 327 => 0x259, 328 => 0x271 },
	'movieautodistortioncontrol' => { 248 => 0x242 },
	'moviediffractioncompensation' => { 248 => 0x241 },
	'moviedxcropalert' => { 249 => 0x377, 250 => 0x377, 251 => 0x2fb, 252 => 0x323, 253 => 0x323 },
	'movieelectronicvr' => { 249 => 0x348, 250 => 0x348, 251 => 0x2cc, 252 => 0x2f4, 253 => 0x2f4 },
	'movieevfgrid' => { 326 => 0x21d, 327 => 0x21d, 328 => 0x235 },
	'movieflickerreduction' => { 249 => 0x33c, 250 => 0x33c, 251 => 0x2c0, 252 => 0x2e8, 253 => 0x2e8 },
	'moviefocusmode' => { 248 => 0x248, 249 => 0x340, 250 => 0x340, 251 => 0x2c4, 252 => 0x2ec, 253 => 0x2ec },
	'moviefocuspointlock' => { 326 => 0x226, 327 => 0x226, 328 => 0x23e },
	'movieframerate' => { 247 => 0x48c, 248 => 0x1f8, 249 => 0x374, 250 => 0x370, 251 => 0x2f4, 252 => 0x31c, 253 => 0x31c },
	'movieframesize' => { 247 => 0x48a, 248 => 0x1f6, 249 => 0x372, 250 => 0x36e, 251 => 0x2f2, 252 => 0x31a, 253 => 0x31a },
	'moviefunc1button' => { 312 => '41.1', 313 => '41.1', 323 => '41.1', 325 => 0xc7, 326 => 0xc3, 327 => 0xc3, 328 => 0xc3 },
	'moviefunc2button' => { 325 => 0xcd, 326 => 0xc7, 327 => 0xc7, 328 => 0xc7 },
	'moviefunc3button' => { 327 => 0x127, 328 => 0x13f },
	'moviefunctionbutton' => { 310 => '41.1', 322 => '41.1' },
	'moviefunctionbuttonplusdials' => { 310 => '52.1' },
	'moviehighisonoisereduction' => { 248 => 0x23c, 249 => 0x336, 250 => 0x336, 251 => 0x2ba, 252 => 0x2e2, 253 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 326 => 0x215, 327 => 0x215, 328 => 0x22d },
	'moviehighreszoom' => { 249 => 0x380, 250 => 0x380, 252 => 0x32c, 253 => 0x32c },
	'movieimagearea' => { 249 => 0x2da, 250 => 0x2da, 251 => 0x25c, 252 => 0x286, 253 => 0x286 },
	'movieisoautocontrolmanualmode' => { 249 => 0x2e8, 250 => 0x2e8, 251 => 0x26a, 252 => 0x294, 253 => 0x294 },
	'movieisoautohilimit' => { 249 => 0x2e6, 250 => 0x2e6, 251 => 0x268, 252 => 0x292, 253 => 0x292 },
	'movieisoautomanualmode' => { 248 => 0x204, 249 => 0x2ea, 250 => 0x2ea, 251 => 0x26c, 252 => 0x296, 253 => 0x296 },
	'movielenscontrolring' => { 325 => 0xdf, 326 => 0xd7, 327 => 0xd7, 328 => 0xd7 },
	'moviemeteringmode' => { 249 => 0x33e, 250 => 0x33e, 251 => 0x2c2, 252 => 0x2ea, 253 => 0x2ea },
	'moviemidtonedisplayrange' => { 326 => 0x219, 327 => 0x219, 328 => 0x231 },
	'moviemidtonedisplayvalue' => { 326 => 0x217, 327 => 0x217, 328 => 0x22f },
	'moviemultiselector' => { 325 => 0xe1, 326 => 0xd9, 327 => 0xcf, 328 => 0xcf },
	'moviepreviewbutton' => { 310 => '41.2', 312 => '41.2', 313 => '41.2', 322 => '41.2', 323 => '41.2' },
	'moviepreviewbuttonplusdials' => { 310 => '52.2' },
	'movierecordbuttonplaybackmode' => { 325 => 0x1af, 326 => 0x1b5, 327 => 0x1b5, 328 => 0x1cd },
	'movieshutterbutton' => { 310 => '38.3', 312 => '38.3', 313 => '38.3', 322 => '38.3', 323 => '38.3' },
	'movieshutterspeedlock' => { 326 => 0x225, 327 => 0x225, 328 => 0x23d },
	'movieslowmotion' => { 247 => 0x416, 248 => 0x1fa },
	'moviesoundrecording' => { 249 => 0x34a, 250 => 0x34a, 251 => 0x2ce, 252 => 0x2f6, 253 => 0x2f6 },
	'moviesubjectdetection' => { 249 => 0x378, 250 => 0x378, 251 => 0x2fc, 252 => 0x324, 253 => 0x324 },
	'moviesubselectorassignment' => { 310 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 310 => '53.1' },
	'movietonemap' => { 251 => 0x2ec, 252 => 0x314, 253 => 0x314 },
	'movietype' => { 232 => 0x2ca, 247 => 0x41a, 248 => 0x1fe, 249 => 0x2e4, 250 => 0x2e4, 251 => 0x266, 252 => 0x290, 253 => 0x290 },
	'movievibrationreduction' => { 248 => 0x24e },
	'movievibrationreductionsameasphoto' => { 248 => 0x24f },
	'movievignettecontrol' => { 248 => 0x23e, 249 => 0x1b0, 250 => 0x1b0, 251 => 0x1a0, 252 => 0x1b4, 253 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 248 => 0x240 },
	'movievrmode' => { 249 => 0x344, 250 => 0x344, 251 => 0x2c8, 252 => 0x2f0, 253 => 0x2f0 },
	'moviezebrapattern' => { 326 => 0x213, 327 => 0x213, 328 => 0x22b },
	'multiburstimageheight' => { 458 => 0x1002 },
	'multiburstimagewidth' => { 458 => 0x1001 },
	'multiburstmode' => { 458 => 0x1000 },
	'multicontrollerwhilemetering' => { 90 => 0x517 },
	'multiexposure' => { 73 => 0x1, 354 => 0xb4 },
	'multiexposureautogain' => { 255 => 0x3 },
	'multiexposurecontrol' => { 73 => 0x2 },
	'multiexposuremode' => { 255 => 0x1, 256 => 0x1 },
	'multiexposureoverlaymode' => { 256 => 0x3 },
	'multiexposureshots' => { 73 => 0x3, 247 => 0x1be, 249 => 0x9a, 250 => 0x9a, 251 => 0x8e, 252 => 0x9c, 253 => 0x9c, 255 => 0x2, 256 => 0x2 },
	'multiframenoisereduction' => { 446 => 0x35, 458 => 0x200b, 463 => 0x15 },
	'multiframenreffect' => { 458 => 0x2023 },
	'multifunctionlock' => { 90 => 0x70f },
	'multipleexposuremode' => { 247 => 0x1bc, 249 => 0x98, 250 => 0x98, 251 => 0x8c, 252 => 0x9a, 253 => 0x9a, 334 => 0x101c },
	'multipleexposureset' => { 370 => '10.1' },
	'multisample' => { 268 => 0x40 },
	'multiselector' => { 309 => '9.4', 310 => '10.3', 312 => '10.3', 313 => '10.3', 318 => '27.4', 322 => '10.3', 323 => '10.3' },
	'multiselectorliveview' => { 309 => '4.3', 312 => '37.1', 313 => '37.1', 322 => '37.1', 323 => '37.1' },
	'multiselectorliveviewmode' => { 282 => 0x18c2 },
	'multiselectorplaybackmode' => { 309 => ['13.5','9.2'], 310 => '10.2', 313 => '10.2', 318 => '27.2', 322 => '10.2', 323 => '10.2', 325 => 0xb7, 326 => 0xb3, 327 => 0xb3, 328 => 0xb3 },
	'multiselectorshootmode' => { 309 => '9.1', 310 => '10.1', 312 => '10.1', 313 => '10.1', 318 => '27.1', 322 => '10.1', 323 => '10.1', 325 => 0xb3, 326 => 0xaf, 327 => 0xaf, 328 => 0xaf },
	'multishot' => { 359 => 0x121 },
	'mute' => { 407 => 'player.movie.audio.mute', 410 => 'player.movie.audio.mute' },
	'mycolormode' => { 74 => 0x2 },
	'name' => { 416 => 'name', 523 => 'Name', 525 => 'Name' },
	'narrator' => { 408 => "\xa9nrt" },
	'nationalcatalognumber' => { 542 => 'nationalCatalogNumber' },
	'nativedigest' => { 529 => 'NativeDigest', 548 => 'NativeDigest' },
	'nativeformat' => { 518 => 'NativeFormat' },
	'ndfilter' => { 82 => 0x1c, 330 => 0x204, 424 => 0x1019 },
	'near' => { 506 => 'Near' },
	'nefbitdepth' => { 243 => 0xe22 },
	'nefcompression' => { 243 => 0x93, 244 => 0xa },
	'neflinearizationtable' => { 243 => 0x96 },
	'negativecachelargepreviewsize' => { 523 => 'NegativeCacheLargePreviewSize', 525 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 523 => 'NegativeCacheMaximumSize', 525 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 523 => 'NegativeCachePath', 525 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 520 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 390 => 0x88 },
	'neutraloutputhighlightpoint' => { 115 => 0x2f },
	'neutraloutputshadowpoint' => { 115 => 0x30 },
	'neutralrawcolortone' => { 115 => 0x28 },
	'neutralrawcontrast' => { 115 => 0x2a },
	'neutralrawhighlight' => { 115 => 0x78 },
	'neutralrawhighlightpoint' => { 115 => 0x2d },
	'neutralrawlinear' => { 115 => 0x2b },
	'neutralrawsaturation' => { 115 => 0x29 },
	'neutralrawshadow' => { 115 => 0x81 },
	'neutralrawshadowpoint' => { 115 => 0x2e },
	'neutralrawsharpness' => { 115 => 0x2c },
	'neutralunsharpmaskfineness' => { 115 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 115 => 0xa8 },
	'neutraunsharpmaskstrength' => { 115 => 0xa4 },
	'newlensdata' => { 241 => 0x2f },
	'newrawimagedigest' => { 125 => 0xc7a7 },
	'newsphotoversion' => { 140 => 0x0 },
	'nickname' => { 550 => 'Nickname' },
	'nikoncapturedata' => { 243 => 0xe01 },
	'nikoncaptureeditversions' => { 243 => 0xe13 },
	'nikoncaptureoffsets' => { 243 => 0xe0e },
	'nikoncaptureoutput' => { 243 => 0xe1e },
	'nikoncaptureversion' => { 243 => 0xe09 },
	'nikoniccprofile' => { 243 => 0xe1d },
	'nikonimagesize' => { 279 => '723.1', 280 => '732.1', 288 => 0x2c4 },
	'nikonmeteringmode' => { 206 => 0x17, 247 => 0x2d2, 248 => 0x146, 259 => 0x214 },
	'nikonsettings' => { 243 => 0x4e },
	'noisefilter' => { 330 => 0x527 },
	'noiseprofile' => { 125 => 0xc761 },
	'noisereduction' => { 133 => [0x100b,0x100e], 189 => 0xb0, 190 => 0x60, 191 => 0x3f, 243 => 0x95, 302 => 0x753dcbc0, 303 => 0x17, 330 => 0x50a, 335 => 0x103a, 354 => 0x2d, 390 => 0x49, 424 => 0x100f, 426 => 0x2a },
	'noisereduction2' => { 334 => 0x1010 },
	'noisereductionapplied' => { 125 => 0xc6f7 },
	'noisereductionintensity' => { 303 => 0x9 },
	'noisereductionmethod' => { 303 => 0x11 },
	'noisereductionmode' => { 495 => 0x801e },
	'noisereductionparametersatcapture' => { 145 => 0xe73 },
	'noisereductionparameterscamera' => { 145 => 0xe72 },
	'noisereductionparametershost3mp' => { 145 => 0xe71 },
	'noisereductionparametershost6mp' => { 145 => 0xe70 },
	'noisereductionparametershostrgb' => { 145 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 145 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 145 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 145 => 0xe63 },
	'noisereductionparams' => { 359 => 0x1b },
	'noisereductionsharpness' => { 303 => 0xd },
	'noisereductionstrength' => { 354 => 0xd6 },
	'noisereductionvalue' => { 495 => 0x8027 },
	'nomemorycard' => { 309 => '22.1', 310 => '4.2', 311 => '0.3', 314 => '2.4', 315 => '3.2', 316 => '3.2', 318 => '33.7', 319 => '3.2', 320 => '0.3', 322 => '4.2', 324 => '4.5' },
	'nominalmaxaperture' => { 380 => 0xa },
	'nominalminaperture' => { 380 => '10.1' },
	'noncpulens10focallength' => { 249 => 0x6c6, 250 => 0x6d6, 253 => 0x620 },
	'noncpulens10maxaperture' => { 249 => 0x6ee, 250 => 0x738, 253 => 0x670 },
	'noncpulens11focallength' => { 249 => 0x6c8, 250 => 0x6d8, 253 => 0x624 },
	'noncpulens11maxaperture' => { 249 => 0x6f0, 250 => 0x73c, 253 => 0x674 },
	'noncpulens12focallength' => { 249 => 0x6ca, 250 => 0x6da, 253 => 0x628 },
	'noncpulens12maxaperture' => { 249 => 0x6f2, 250 => 0x740, 253 => 0x678 },
	'noncpulens13focallength' => { 249 => 0x6cc, 250 => 0x6dc, 253 => 0x62c },
	'noncpulens13maxaperture' => { 249 => 0x6f4, 250 => 0x744, 253 => 0x67c },
	'noncpulens14focallength' => { 249 => 0x6ce, 250 => 0x6de, 253 => 0x630 },
	'noncpulens14maxaperture' => { 249 => 0x6f6, 250 => 0x748, 253 => 0x680 },
	'noncpulens15focallength' => { 249 => 0x6d0, 250 => 0x6e0, 253 => 0x634 },
	'noncpulens15maxaperture' => { 249 => 0x6f8, 250 => 0x74c, 253 => 0x684 },
	'noncpulens16focallength' => { 249 => 0x6d2, 250 => 0x6e2, 253 => 0x638 },
	'noncpulens16maxaperture' => { 249 => 0x6fa, 250 => 0x750, 253 => 0x688 },
	'noncpulens17focallength' => { 249 => 0x6d4, 250 => 0x6e4, 253 => 0x63c },
	'noncpulens17maxaperture' => { 249 => 0x6fc, 250 => 0x754, 253 => 0x68c },
	'noncpulens18focallength' => { 249 => 0x6d6, 250 => 0x6e6, 253 => 0x640 },
	'noncpulens18maxaperture' => { 249 => 0x6fe, 250 => 0x758, 253 => 0x690 },
	'noncpulens19focallength' => { 249 => 0x6d8, 250 => 0x6e8, 253 => 0x644 },
	'noncpulens19maxaperture' => { 249 => 0x700, 250 => 0x75c, 253 => 0x694 },
	'noncpulens1focallength' => { 249 => 0x6b4, 250 => 0x6c4, 253 => 0x5fc },
	'noncpulens1maxaperture' => { 249 => 0x6dc, 250 => 0x714, 253 => 0x64c },
	'noncpulens20focallength' => { 249 => 0x6da, 250 => 0x6ea, 253 => 0x648 },
	'noncpulens20maxaperture' => { 249 => 0x702, 250 => 0x760, 253 => 0x698 },
	'noncpulens2focallength' => { 249 => 0x6b6, 250 => 0x6c6, 253 => 0x600 },
	'noncpulens2maxaperture' => { 249 => 0x6de, 250 => 0x718, 253 => 0x650 },
	'noncpulens3focallength' => { 249 => 0x6b8, 250 => 0x6c8, 253 => 0x604 },
	'noncpulens3maxaperture' => { 249 => 0x6e0, 250 => 0x71c, 253 => 0x654 },
	'noncpulens4focallength' => { 249 => 0x6ba, 250 => 0x6ca, 253 => 0x608 },
	'noncpulens4maxaperture' => { 249 => 0x6e2, 253 => 0x658 },
	'noncpulens5focallength' => { 249 => 0x6bc, 250 => 0x6cc, 253 => 0x60c },
	'noncpulens5maxaperture' => { 249 => 0x6e4, 250 => 0x724, 253 => 0x65c },
	'noncpulens6focallength' => { 249 => 0x6be, 250 => 0x6ce, 253 => 0x610 },
	'noncpulens6maxaperture' => { 249 => 0x6e6, 250 => 0x728, 253 => 0x660 },
	'noncpulens7focallength' => { 249 => 0x6c0, 250 => 0x6d0, 253 => 0x614 },
	'noncpulens7maxaperture' => { 249 => 0x6e8, 250 => 0x72c, 253 => 0x664 },
	'noncpulens8focallength' => { 249 => 0x6c2, 250 => 0x6d2, 253 => 0x618 },
	'noncpulens8maxaperture' => { 249 => 0x6ea, 250 => 0x730, 253 => 0x668 },
	'noncpulens9focallength' => { 249 => 0x6c4, 250 => 0x6d4, 253 => 0x61c },
	'noncpulens9maxaperture' => { 249 => 0x6ec, 250 => 0x734, 253 => 0x66c },
	'normalizedcropcorners' => { 344 => 'NormalizedCropCorners' },
	'normallinetime' => { 145 => 0x186a },
	'normalwhitelevel' => { 44 => 0x32a, 45 => 0x280, 46 => 0x294, 49 => [0x2b8,0x2cf,0x2d3], 50 => 0x569, 51 => 0x1e3, 52 => [0x1fc,0x2dc], 53 => [0x230,0x30e], 54 => 0x31c },
	'notes' => { 497 => 'Notes', 517 => 'notes' },
	'npages' => { 557 => 'NPages' },
	'nullrecord' => { 103 => 0x0 },
	'numafpoints' => { 366 => 0x2 },
	'number' => { 542 => 'number' },
	'numberofbeats' => { 552 => 'numberOfBeats' },
	'numberoffocuspoints' => { 312 => '1.3', 313 => '1.3', 316 => '0.2', 317 => '0.3', 319 => '0.3' },
	'numfaceelements' => { 133 => 0x4200 },
	'numfacepositions' => { 346 => 0x0 },
	'numindexentries' => { 140 => 0x54 },
	'numwbentries' => { 360 => 0x0, 361 => 0x0 },
	'object' => { 542 => 'object' },
	'objectattributereference' => { 138 => 0x4 },
	'objectcycle' => { 138 => 0x4b, 517 => 'ObjectCycle' },
	'objectdescription' => { 541 => 'objectDescription' },
	'objectdistance' => { 118 => 0x6, 119 => 0x2022 },
	'objectname' => { 138 => 0x5 },
	'objectpreviewdata' => { 138 => 0xca },
	'objectpreviewfileformat' => { 138 => 0xc8 },
	'objectpreviewfileversion' => { 138 => 0xc9 },
	'objectsubtype' => { 541 => 'objectSubtype' },
	'objecttype' => { 541 => 'objectType' },
	'objecttypereference' => { 138 => 0x3 },
	'occurrence' => { 124 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 124 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 124 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 124 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 124 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 124 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 124 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 124 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 124 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 124 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 124 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 124 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 124 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 124 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 124 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 124 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 124 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 124 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 124 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 124 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 124 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 124 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 124 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 124 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 124 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 124 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 124 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 124 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 124 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 124 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 529 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 529 => [\'OECF','OECFNames'] },
	'oecfrows' => { 529 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 529 => [\'OECF','OECFValues'] },
	'offsaledate' => { 542 => 'offSaleDate' },
	'offsaledatea-platform' => { 542 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 542 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 145 => 0x190a },
	'offsethdr' => { 534 => 'OffsetHDR' },
	'offsetschema' => { 125 => 0xea1d },
	'offsetsdr' => { 534 => 'OffsetSDR' },
	'offsettime' => { 125 => 0x9010 },
	'offsettimedigitized' => { 125 => 0x9012 },
	'offsettimeoriginal' => { 125 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 319 => '15.1', 324 => '16.1' },
	'oldsubfiletype' => { 125 => 0xff },
	'olympusimageheight' => { 335 => 0x102f },
	'olympusimagewidth' => { 335 => 0x102e },
	'omenatcapturestrength' => { 145 => 0xa60 },
	'omenautostrength' => { 145 => 0xa5f },
	'omenearlystrength' => { 145 => 0xa5e },
	'omenfocallengthlimit' => { 145 => 0xa62 },
	'omeninitialipfstrength' => { 145 => 0xa5d },
	'omensurfaceindex' => { 145 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 335 => 0x302 },
	'onsaledate' => { 542 => 'onSaleDate' },
	'onsaledatea-platform' => { 542 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 542 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 542 => 'onSaleDay' },
	'onsaledaya-platform' => { 542 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 542 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 125 => 0xc740 },
	'opcodelist2' => { 125 => 0xc741 },
	'opcodelist3' => { 125 => 0xc74e },
	'opticalzoom' => { 149 => 0xfa3d, 151 => [0x6006,0xf006], 152 => 0x1000, 153 => 0xf, 156 => 0x1e, 158 => 0x20, 159 => 0x1c, 170 => 'OpticalZoom' },
	'opticalzoomcode' => { 82 => 0xa },
	'opticalzoommode' => { 354 => 0x34 },
	'opticalzoomon' => { 433 => 0x219 },
	'optionenddate' => { 545 => 'optionEndDate' },
	'opto-electricconvfactor' => { 529 => 'OECF' },
	'orangehsl' => { 109 => 0x20911 },
	'ordernumber' => { 133 => 0x8002 },
	'organisationinimagecode' => { 537 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 537 => 'OrganisationInImageName' },
	'organism' => { 124 => 'Organism' },
	'organismassociatedoccurrences' => { 124 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 124 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 124 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 124 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 124 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 124 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 124 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 542 => 'organization' },
	'orientation' => { 125 => 0x112, 359 => 0x112, 541 => 'orientation', 548 => 'Orientation' },
	'orientation2' => { 463 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 90 => 0x516 },
	'originalalbumtitle' => { 186 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 186 => 'WM/OriginalArtist', 408 => "\xa9ope" },
	'originalbestqualitysize' => { 125 => 0xc792 },
	'originalcreatedatetime' => { 511 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 120 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 69 => 0x83 },
	'originaldefaultcropsize' => { 125 => 0xc793 },
	'originaldefaultfinalsize' => { 125 => 0xc791 },
	'originaldirectory' => { 351 => 0x408 },
	'originaldocumentid' => { 553 => 'OriginalDocumentID' },
	'originalfilename' => { 103 => 0x816, 145 => 0x3e9, 157 => 0x20, 351 => 0x407, 511 => 'OriginalFilename' },
	'originalimagehash' => { 500 => 'OriginalImageHash' },
	'originalimagehashtype' => { 500 => 'OriginalImageHashType' },
	'originalimageheight' => { 84 => 0xc, 129 => 0x1 },
	'originalimagemd5' => { 500 => 'OriginalImageMD5' },
	'originalimagesize' => { 169 => 'OriginalImageSize' },
	'originalimagewidth' => { 84 => 0xb, 129 => 0x0 },
	'originallyricist' => { 186 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 125 => 0xc68c },
	'originalrawfiledigest' => { 125 => 0xc71d },
	'originalrawfilename' => { 125 => 0xc68b },
	'originaltransmissionreference' => { 138 => 0x67 },
	'originatingprogram' => { 138 => 0x41, 517 => 'OriginatingProgram' },
	'originplatform' => { 542 => 'originPlatform' },
	'os' => { 527 => 'os' },
	'otherconditions' => { 340 => 'OtherConditions' },
	'otherconstraints' => { 340 => 'OtherConstraints' },
	'otherimage' => { 120 => 'Exif-OtherImage' },
	'otherimageinfo' => { 340 => 'OtherImageInfo' },
	'otherimagelength' => { 125 => 0x202 },
	'otherimagestart' => { 125 => 0x201 },
	'otherlicensedocuments' => { 340 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 340 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 340 => 'OtherLicenseRequirements' },
	'outcue' => { 552 => 'outCue' },
	'outcuescale' => { 552 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 552 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 207 => 0x3 },
	'outputimagewidth' => { 207 => 0x2 },
	'outputlut' => { 354 => 0xa7 },
	'outputprofile' => { 145 => 0x138b },
	'outputresolution' => { 207 => 0x4 },
	'overclockcols' => { 145 => 0x189c },
	'overclockrows' => { 145 => 0x18c4 },
	'overridelookvignette' => { 523 => 'OverrideLookVignette', 525 => 'OverrideLookVignette' },
	'owner' => { 408 => 'ownr', 556 => 'Owner' },
	'ownerid' => { 138 => 0xbc },
	'ownername' => { 15 => 0x10f, 69 => 0x9, 103 => 0x810, 125 => [0xa430,0xfde8], 163 => 'OwnerName', 520 => 'OwnerName', 530 => 'CameraOwnerName' },
	'padding' => { 125 => 0xea1c },
	'pagecount' => { 542 => 'pageCount' },
	'pageimage' => { 550 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 550 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 550 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 550 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 550 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 550 => 'PageInfo' },
	'pagename' => { 125 => 0x11d },
	'pagenumber' => { 125 => 0x129 },
	'pageprogressiondirection' => { 542 => 'pageProgressionDirection' },
	'pagerange' => { 542 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 523 => 'PaintBasedCorrections', 525 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 523 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 525 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 357 => 0x0 },
	'panasonicexifversion' => { 354 => 0x26 },
	'panasonicimageheight' => { 354 => 0x4c },
	'panasonicimagewidth' => { 354 => 0x4b },
	'panasonicrawversion' => { 359 => 0x1 },
	'panasonictitle' => { 125 => 0xc6d2 },
	'panasonictitle2' => { 125 => 0xc6d3 },
	'panoramaangle' => { 133 => 0x1153 },
	'panoramacropbottom' => { 464 => 0x7 },
	'panoramacropleft' => { 464 => 0x4 },
	'panoramacropright' => { 464 => 0x6 },
	'panoramacroptop' => { 464 => 0x5 },
	'panoramadirection' => { 77 => 0x5, 133 => 0x1154, 464 => 0x3 },
	'panoramaframeheight' => { 464 => 0x9 },
	'panoramaframenumber' => { 77 => 0x2 },
	'panoramaframewidth' => { 464 => 0x8 },
	'panoramafullheight' => { 464 => 0x2 },
	'panoramafullwidth' => { 464 => 0x1 },
	'panoramamode' => { 147 => 0x3c, 330 => 0x601 },
	'panoramasize3d' => { 446 => 0x38 },
	'panoramasourceheight' => { 464 => 0xb },
	'panoramasourcewidth' => { 464 => 0xa },
	'panoramicstitchcameramotion' => { 183 => 'PanoramicStitchCameraMotion', 184 => 0x1 },
	'panoramicstitchmaptype' => { 183 => 'PanoramicStitchMapType', 184 => 0x2 },
	'panoramicstitchphi0' => { 183 => 'PanoramicStitchPhi0', 184 => 0x5 },
	'panoramicstitchphi1' => { 183 => 'PanoramicStitchPhi1', 184 => 0x6 },
	'panoramicstitchtheta0' => { 183 => 'PanoramicStitchTheta0', 184 => 0x3 },
	'panoramicstitchtheta1' => { 183 => 'PanoramicStitchTheta1', 184 => 0x4 },
	'panoramicstitchversion' => { 184 => 0x0 },
	'pantry' => { 553 => 'Pantry' },
	'pantryinstanceid' => { 553 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 133 => 0xb211, 329 => 0x28 },
	'parameters' => { 343 => 'parameters' },
	'parametricdarks' => { 523 => 'ParametricDarks', 525 => 'ParametricDarks' },
	'parametrichighlights' => { 523 => 'ParametricHighlights', 525 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 523 => 'ParametricHighlightSplit', 525 => 'ParametricHighlightSplit' },
	'parametriclights' => { 523 => 'ParametricLights', 525 => 'ParametricLights' },
	'parametricmidtonesplit' => { 523 => 'ParametricMidtoneSplit', 525 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 523 => 'ParametricShadows', 525 => 'ParametricShadows' },
	'parametricshadowsplit' => { 523 => 'ParametricShadowSplit', 525 => 'ParametricShadowSplit' },
	'parentalrating' => { 186 => 'WM/ParentalRating' },
	'parentid' => { 537 => 'parentId' },
	'parentmediaeventid' => { 511 => 'ParentMediaEventID' },
	'parentmeid' => { 511 => 'ParentMEID' },
	'parentproductid' => { 408 => '@ppi' },
	'parentreference1' => { 535 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 535 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 408 => '@PST' },
	'parenttitle' => { 408 => '@pti' },
	'partialactivecols1' => { 145 => 0x17e8 },
	'partialactivecols2' => { 145 => 0x17f2 },
	'partialactiverows1' => { 145 => 0x17fc },
	'partialactiverows2' => { 145 => 0x1806 },
	'partofcompilation' => { 552 => 'partOfCompilation' },
	'patientbirthdate' => { 498 => 'PatientDOB' },
	'patientid' => { 498 => 'PatientID' },
	'patientname' => { 498 => 'PatientName' },
	'patientsex' => { 498 => 'PatientSex' },
	'patternareaheight' => { 145 => 0x963 },
	'patternareawidth' => { 145 => 0x962 },
	'patterncorrectionfactorscale' => { 145 => 0x969 },
	'patterncropcols1' => { 145 => 0x96c },
	'patterncropcols2' => { 145 => 0x96d },
	'patterncroprows1' => { 145 => 0x96a },
	'patterncroprows2' => { 145 => 0x96b },
	'patternimagerheight' => { 145 => 0x961 },
	'patternimagerwidth' => { 145 => 0x960 },
	'patternx' => { 145 => 0x966 },
	'patterny' => { 145 => 0x967 },
	'pdfversion' => { 539 => 'PDFVersion' },
	'pentaximagesize' => { 390 => 0x9 },
	'pentaxmodelid' => { 369 => 0x0, 390 => 0x5 },
	'pentaxmodeltype' => { 390 => 0x1 },
	'pentaxversion' => { 390 => 0x0 },
	'people' => { 501 => 'People', 515 => 'People' },
	'perchannelblacklevel' => { 44 => 0x157, 45 => 0x16b, 46 => 0x17f, 48 => 0xc4, 49 => [0x2b4,0x2cb,0x2cf], 50 => [0x108,0x14d], 51 => 0x1df, 52 => [0x1f8,0x2d8], 53 => [0x22c,0x30a], 54 => 0x149 },
	'performer' => { 408 => 'perf', 416 => 'perf' },
	'performerkeywords' => { 416 => "\xa9prk" },
	'performers' => { 416 => "\xa9prf" },
	'performerurl' => { 416 => "\xa9prl" },
	'period' => { 186 => 'WM/Period' },
	'peripheralillumcentralradius' => { 495 => 0x8030 },
	'peripheralillumcentralvalue' => { 495 => 0x8031 },
	'peripheralillumination' => { 109 => 0x20702, 115 => 0x68 },
	'peripheralilluminationcorr' => { 67 => 0x1, 379 => 0x2 },
	'peripheralilluminationon' => { 109 => '0x20702.0', 115 => 0x64 },
	'peripheralillumperiphvalue' => { 495 => 0x8032 },
	'peripherallighting' => { 84 => 0x2, 133 => 0x3804 },
	'peripherallightingsetting' => { 85 => 0x5 },
	'peripherallightingvalue' => { 84 => 0x6 },
	'permissions' => { 545 => 'permissions' },
	'permits' => { 521 => 'permits' },
	'person' => { 542 => 'person' },
	'personality' => { 511 => 'Personality' },
	'personheard' => { 537 => 'PersonHeard' },
	'personheardidentifier' => { 537 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 537 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 537 => 'PersonInImage' },
	'personinimagecharacteristic' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 537 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 537 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 523 => 'PerspectiveAspect', 525 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 523 => 'PerspectiveHorizontal', 525 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 523 => 'PerspectiveRotate', 525 => 'PerspectiveRotate' },
	'perspectivescale' => { 523 => 'PerspectiveScale', 525 => 'PerspectiveScale' },
	'perspectiveupright' => { 523 => 'PerspectiveUpright', 525 => 'PerspectiveUpright' },
	'perspectivevertical' => { 523 => 'PerspectiveVertical', 525 => 'PerspectiveVertical' },
	'perspectivex' => { 523 => 'PerspectiveX', 525 => 'PerspectiveX' },
	'perspectivey' => { 523 => 'PerspectiveY', 525 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 98 => 0x1 },
	'pf10retainprogramshift' => { 98 => 0xb },
	'pf13drivepriority' => { 98 => 0xe },
	'pf14disablefocussearch' => { 98 => 0xf },
	'pf15disableafassistbeam' => { 98 => 0x10 },
	'pf16autofocuspointshoot' => { 98 => 0x11 },
	'pf17disableafpointsel' => { 98 => 0x12 },
	'pf18enableautoafpointsel' => { 98 => 0x13 },
	'pf19continuousshootspeed' => { 98 => 0x14 },
	'pf19shootingspeedhigh' => { 97 => 0xa },
	'pf19shootingspeedlow' => { 97 => 0x9 },
	'pf1disableshootingmodes' => { 98 => 0x2 },
	'pf1value' => { 97 => 0x1 },
	'pf20limitcontinousshots' => { 98 => 0x15 },
	'pf20maxcontinousshots' => { 97 => 0xb },
	'pf21enablequietoperation' => { 98 => 0x16 },
	'pf23felocktime' => { 97 => 0xd },
	'pf23postreleasetime' => { 97 => 0xe },
	'pf23settimerlengths' => { 98 => 0x18 },
	'pf23shutterbuttontime' => { 97 => 0xc },
	'pf24lightlcdduringbulb' => { 98 => 0x19 },
	'pf25aemode' => { 97 => 0xf },
	'pf25afmode' => { 97 => 0x12 },
	'pf25afpointsel' => { 97 => 0x13 },
	'pf25colormatrix' => { 97 => 0x17 },
	'pf25defaultclearsettings' => { 98 => 0x1a },
	'pf25drivemode' => { 97 => 0x11 },
	'pf25imagesize' => { 97 => 0x14 },
	'pf25meteringmode' => { 97 => 0x10 },
	'pf25parameters' => { 97 => 0x16 },
	'pf25wbmode' => { 97 => 0x15 },
	'pf26shortenreleaselag' => { 98 => 0x1b },
	'pf27reversedialrotation' => { 98 => 0x1c },
	'pf27value' => { 97 => 0x18 },
	'pf28noquickdialexpcomp' => { 98 => 0x1d },
	'pf29quickdialswitchoff' => { 98 => 0x1e },
	'pf2disablemeteringmodes' => { 98 => 0x3 },
	'pf2value' => { 97 => 0x2 },
	'pf30enlargementmode' => { 98 => 0x1f },
	'pf31originaldecisiondata' => { 98 => 0x20 },
	'pf3manualexposuremetering' => { 98 => 0x4 },
	'pf3value' => { 97 => 0x3 },
	'pf4exposuretimelimits' => { 98 => 0x5 },
	'pf4exposuretimemax' => { 97 => 0x5 },
	'pf4exposuretimemin' => { 97 => 0x4 },
	'pf5aperturelimits' => { 98 => 0x6 },
	'pf5aperturemax' => { 97 => 0x7 },
	'pf5aperturemin' => { 97 => 0x6 },
	'pf6presetshootingmodes' => { 98 => 0x7 },
	'pf7bracketcontinuousshoot' => { 98 => 0x8 },
	'pf8bracketshots' => { 97 => 0x8 },
	'pf8setbracketshots' => { 98 => 0x9 },
	'pf9changebracketsequence' => { 98 => 0xa },
	'phasedetectaf' => { 200 => 0x6 },
	'phonenumber' => { 164 => 'Phone' },
	'photoeffect' => { 37 => 0x28 },
	'photoeffecthistoryxml' => { 302 => 0xe9651831 },
	'photoeffects' => { 302 => 0xab5eca5e },
	'photoeffectsblue' => { 304 => 0x8 },
	'photoeffectsgreen' => { 304 => 0x6 },
	'photoeffectsred' => { 304 => 0x4 },
	'photoeffectstype' => { 304 => 0x0 },
	'photographer' => { 125 => 0xa437, 530 => 'Photographer' },
	'photographicsensitivity' => { 530 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 309 => '17.6', 318 => '33.6' },
	'photometricinterpretation' => { 125 => 0x106, 548 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 249 => 0x11e, 250 => 0x11e, 251 => 0x112, 252 => 0x122, 253 => 0x122, 254 => 0x24, 272 => 0x0 },
	'photoshootingmenubankimagearea' => { 246 => 0x6dd, 249 => 0x144, 250 => 0x144, 251 => 0x134, 252 => 0x148, 253 => 0x148, 272 => '7.1' },
	'photoshopbgrthumbnail' => { 404 => 0x409 },
	'photoshopquality' => { 403 => 0x0 },
	'photoshopthumbnail' => { 404 => 0x40c },
	'photostyle' => { 354 => 0x89 },
	'picasawebgphotoid' => { 528 => 'picasawebGPhotoId' },
	'pick' => { 552 => 'pick' },
	'picklabel' => { 528 => 'PickLabel' },
	'pictinfo' => { 433 => 0x208 },
	'picturecontrol' => { 302 => 0xe2173c47 },
	'picturecontrolactive' => { 305 => 0x0 },
	'picturecontroladjust' => { 260 => 0x30, 261 => 0x30, 262 => 0x36 },
	'picturecontrolbase' => { 260 => 0x18, 261 => 0x18, 262 => 0x1c },
	'picturecontroldata' => { 243 => [0xbd,0x23] },
	'picturecontrolmode' => { 305 => 0x13 },
	'picturecontrolname' => { 260 => 0x4, 261 => 0x4, 262 => 0x8 },
	'picturecontrolquickadjust' => { 260 => 0x31, 261 => 0x31, 262 => 0x37 },
	'pictureeffect' => { 458 => 0x200e },
	'pictureeffect2' => { 467 => 0x1163, 468 => 0x1167, 469 => 0x1143, 470 => 0x11bf, 471 => 0x119b, 472 => 0x1053, 473 => 0x24b, 474 => 0x24b, 475 => 0x23c, 490 => 0x46 },
	'picturefinish' => { 189 => 0x71 },
	'picturemode' => { 133 => 0x1031, 330 => 0x520, 390 => [0xb,0x33], 434 => 0x3d },
	'picturemode2' => { 370 => 0x0 },
	'picturemodebwfilter' => { 330 => 0x525 },
	'picturemodecontrast' => { 330 => 0x523 },
	'picturemodeeffect' => { 330 => 0x52d },
	'picturemodehue' => { 330 => 0x522 },
	'picturemodesaturation' => { 330 => 0x521 },
	'picturemodesharpness' => { 330 => 0x524 },
	'picturemodetone' => { 330 => 0x526 },
	'pictureprofile' => { 467 => [0x115e,0x115f], 468 => [0x1162,0x1163], 469 => [0x113e,0x113f], 470 => [0x11ba,0x11bb], 471 => [0x1196,0x1197], 472 => [0x104e,0x104f], 473 => [0x246,0x247], 474 => [0x246,0x247], 475 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 79 => 0xa, 109 => 0x20301, 115 => 0x2 },
	'picturestylepc' => { 69 => 0x4009 },
	'picturestyleuserdef' => { 69 => 0x4008 },
	'picturewizard' => { 431 => 0x21 },
	'picturewizardcolor' => { 430 => 0x1 },
	'picturewizardcontrast' => { 430 => 0x4 },
	'picturewizardmode' => { 430 => 0x0 },
	'picturewizardsaturation' => { 430 => 0x2 },
	'picturewizardsharpness' => { 430 => 0x3 },
	'pipelineversion' => { 183 => 'PipelineVersion' },
	'pitch' => { 121 => 0x6, 310 => '4.1', 322 => '4.1', 416 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 66 => 0x5, 258 => 0x4, 330 => 0x904, 344 => 'PitchAngle', 354 => 0x91, 388 => 0x2, 389 => 0x5, 429 => 0x1 },
	'pitchshift' => { 407 => 'player.movie.audio.pitchshift', 410 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 409 => 'pasp' },
	'pixelclockfrequency' => { 145 => 0x40b },
	'pixelcorrectionoffset' => { 145 => 0x972 },
	'pixelcorrectionscale' => { 145 => 0x971 },
	'pixelscale' => { 125 => 0x830e },
	'pixelshiftdelay' => { 247 => 0x38c, 250 => 0x802 },
	'pixelshiftinfo' => { 458 => 0x202f },
	'pixelshiftinterval' => { 247 => 0x38e },
	'pixelshiftnumbershots' => { 247 => 0x38a, 250 => 0x800 },
	'pixelshiftoffset' => { 133 => 0x1106 },
	'pixelshiftresolution' => { 391 => 0x0 },
	'pixelshiftshooting' => { 247 => 0x388, 250 => 0x7fe },
	'pixelshiftshots' => { 133 => 0x1105 },
	'pixelsperunitx' => { 342 => 0x0 },
	'pixelsperunity' => { 342 => 0x4 },
	'pixelunits' => { 342 => 0x8 },
	'planarconfiguration' => { 125 => 0x11c, 548 => 'PlanarConfiguration' },
	'plane' => { 499 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 499 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 499 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 499 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 499 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 499 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 499 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 499 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 499 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 499 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 499 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 499 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 499 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 499 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 499 => 'Planes' },
	'planningref' => { 537 => 'PlanningRef' },
	'planningrefidentifier' => { 537 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 537 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 537 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 557 => 'PlateNames' },
	'platform' => { 542 => 'platform' },
	'playallframes' => { 416 => 'AllF' },
	'playbackbutton' => { 250 => 0x804, 253 => 0x808 },
	'playbackbuttonplaybackmode' => { 250 => 0x80e, 253 => 0x814 },
	'playbackflickdown' => { 325 => 0x149, 326 => 0x159, 327 => 0x159, 328 => 0x171 },
	'playbackflickup' => { 325 => 0x145, 326 => 0x155, 327 => 0x155, 328 => 0x16d },
	'playbackmenustime' => { 314 => '20.1', 315 => '21.1', 316 => '21.1' },
	'playbackmonitorofftime' => { 309 => '25.2', 310 => '36.1', 312 => '36.1', 313 => '36.1', 317 => '35.1', 318 => '8.1', 319 => '35.1', 322 => '36.1', 323 => '36.1', 324 => '21.1', 325 => 0x37, 326 => 0x33, 327 => 0x33, 328 => 0x33 },
	'playbackzoom' => { 310 => '37.1' },
	'playdisplay' => { 191 => 0x4e },
	'playerversion' => { 410 => 'player.version' },
	'playgap' => { 408 => 'pgap' },
	'playmode' => { 416 => 'SDLN' },
	'playselection' => { 416 => 'SelO' },
	'plusversion' => { 340 => 'Version' },
	'pmversion' => { 402 => 'PMVersion' },
	'pngwarning' => { 343 => 'Warning' },
	'podcast' => { 408 => 'pcst' },
	'podcasturl' => { 408 => 'purl' },
	'poilevel' => { 242 => 0x8 },
	'portraitimpressionbalance' => { 247 => 0x378, 249 => 0x26e, 250 => 0x26e, 263 => 0xa0 },
	'portraitnote' => { 503 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 115 => 0x1d },
	'portraitoutputshadowpoint' => { 115 => 0x1e },
	'portraitrawcolortone' => { 115 => 0x16 },
	'portraitrawcontrast' => { 115 => 0x18 },
	'portraitrawhighlight' => { 115 => 0x76 },
	'portraitrawhighlightpoint' => { 115 => 0x1b },
	'portraitrawlinear' => { 115 => 0x19 },
	'portraitrawsaturation' => { 115 => 0x17 },
	'portraitrawshadow' => { 115 => 0x7f },
	'portraitrawshadowpoint' => { 115 => 0x1c },
	'portraitrawsharpness' => { 115 => 0x1a },
	'portraitrefiner' => { 119 => 0x302b },
	'portraitrequest' => { 503 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 115 => 0x9a },
	'portraitunsharpmaskstrength' => { 115 => 0x98 },
	'portraitunsharpmaskthreshold' => { 115 => 0x9c },
	'portraitversion' => { 503 => 'PortraitVersion' },
	'pose' => { 499 => 'Pose' },
	'poseheadingdegrees' => { 509 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 509 => 'PosePitchDegrees' },
	'posepositionx' => { 499 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 499 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 499 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 509 => 'PoseRollDegrees' },
	'poserotationw' => { 499 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 499 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 499 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 499 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 499 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 541 => 'positionDescriptor' },
	'postalcode' => { 168 => 'PostalCode' },
	'postcropvignetteamount' => { 523 => 'PostCropVignetteAmount', 525 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 523 => 'PostCropVignetteFeather', 525 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 523 => 'PostCropVignetteHighlightContrast', 525 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 523 => 'PostCropVignetteMidpoint', 525 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 523 => 'PostCropVignetteRoundness', 525 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 523 => 'PostCropVignetteStyle', 525 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 354 => 0xbf },
	'postreleaseburstlength' => { 252 => 0x714, 253 => 0x784, 326 => 0x289 },
	'potentialface1position' => { 454 => 0xb },
	'potentialface2position' => { 454 => 0x15 },
	'potentialface3position' => { 454 => 0x1f },
	'potentialface4position' => { 454 => 0x29 },
	'potentialface5position' => { 454 => 0x33 },
	'potentialface6position' => { 454 => 0x3d },
	'potentialface7position' => { 454 => 0x47 },
	'potentialface8position' => { 454 => 0x51 },
	'poweravailable' => { 368 => '0.2' },
	'powersource' => { 368 => '0.1' },
	'poweruptime' => { 243 => 0xb6 },
	'preaf' => { 132 => '0.2' },
	'precaptureframes' => { 335 => 0x300 },
	'predictor' => { 125 => 0x13d },
	'preflashreturnstrength' => { 280 => 0x28a },
	'prefs' => { 138 => 0xdd, 402 => 'Prefs' },
	'prereadfastresetcount' => { 145 => 0x187e },
	'prereleaseburstlength' => { 252 => 0x712, 253 => 0x782, 326 => 0x287 },
	'preservedfilename' => { 553 => 'PreservedFileName' },
	'preservedspecimen' => { 124 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 124 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 523 => 'PresetType', 525 => 'PresetType' },
	'presetwhitebalance' => { 191 => 0x24, 495 => 0x8002 },
	'presetwhitebalanceadj' => { 495 => 0x8014 },
	'pressure' => { 125 => 0x9402, 530 => 'Pressure' },
	'previewapplicationname' => { 125 => 0xc716 },
	'previewapplicationversion' => { 125 => 0xc717 },
	'previewbutton' => { 309 => ['14.1','15.1'], 310 => '15.1', 312 => '15.1', 313 => '15.1', 318 => '29.1', 319 => '14.1', 322 => '15.1', 323 => '15.1' },
	'previewbuttonplusdials' => { 309 => ['14.2','15.2'], 310 => '15.2', 312 => '43.1', 313 => '43.1', 318 => '31.2', 322 => '43.1', 323 => '43.1' },
	'previewcolorspace' => { 125 => 0xc71a },
	'previewcropbottom' => { 401 => 0xef },
	'previewcropleft' => { 401 => 0xec },
	'previewcropright' => { 401 => 0xee },
	'previewcroptop' => { 401 => 0xed },
	'previewdate' => { 414 => 0x0 },
	'previewdatetime' => { 125 => 0xc71b },
	'previewimage' => { 119 => 0x2000, 120 => 'Exif-PreviewImage', 126 => 'PreviewImage', 128 => 0x4, 173 => 'data', 193 => 0x81, 335 => 0x280, 352 => 0x300, 408 => 'snal', 416 => 'mcvr', 458 => 0x2001 },
	'previewimageborders' => { 390 => 0x3e },
	'previewimageheight' => { 78 => 0x4, 149 => 0xfa58 },
	'previewimagelength' => { 78 => 0x2, 119 => 0x3, 125 => [0x117,0x202], 193 => 0x89, 264 => 0x202, 330 => 0x102, 335 => 0x1037, 390 => 0x3, 423 => 0x1e, 428 => 0x3, 434 => [0x1b,0x1d], 447 => 0x202 },
	'previewimagename' => { 173 => '1Name' },
	'previewimagesize' => { 119 => 0x2, 154 => 0x2, 173 => 'ImageSize', 390 => 0x2, 434 => [0x1c,0x1e], 458 => 0xb02c, 495 => 0x9012 },
	'previewimagestart' => { 78 => 0x5, 119 => 0x4, 125 => [0x111,0x201], 193 => 0x88, 264 => 0x201, 330 => 0x101, 335 => 0x1036, 390 => 0x4, 423 => 0x1c, 428 => 0x2, 434 => [0x1a,0x1c], 447 => 0x201 },
	'previewimagetype' => { 173 => '0Type' },
	'previewimagevalid' => { 330 => 0x100, 335 => 0x1035 },
	'previewimagewidth' => { 78 => 0x3, 149 => 0xfa57 },
	'previewquality' => { 78 => 0x1 },
	'previewsettingsdigest' => { 125 => 0xc719 },
	'previewsettingsname' => { 125 => 0xc718 },
	'primaryafpoint' => { 200 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 125 => 0x13f, 548 => 'PrimaryChromaticities' },
	'primaryftp' => { 511 => 'PrimaryFTP' },
	'primaryslot' => { 254 => 0x25, 272 => 0x2 },
	'printim' => { 125 => 0xc4a5 },
	'prioritysetinawb' => { 458 => 0x202b },
	'prioritysetupshutterrelease' => { 191 => 0x1d, 444 => 0x28 },
	'privatertkinfo' => { 514 => 'privateRTKInfo' },
	'processbordercolsleft' => { 145 => 0xc61 },
	'processbordercolsright' => { 145 => 0xc62 },
	'processborderrowsbottom' => { 145 => 0xc64 },
	'processborderrowstop' => { 145 => 0xc63 },
	'processingsoftware' => { 125 => 0xb },
	'processversion' => { 523 => 'ProcessVersion', 525 => 'ProcessVersion' },
	'producer' => { 186 => 'WM/Producer', 339 => 'Producer', 408 => "\xa9prd", 410 => 'producer', 416 => "\xa9prd", 539 => 'Producer' },
	'producerkeywords' => { 416 => "\xa9pdk" },
	'productcode' => { 542 => 'productCode' },
	'productid' => { 139 => 0x32, 408 => 'prID', 541 => 'productID' },
	'productidtype' => { 541 => 'productIDType' },
	'productinimage' => { 537 => 'ProductInImage' },
	'productinimagedescription' => { 537 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 537 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 537 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 537 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 369 => 0x2 },
	'productorserviceconstraints' => { 340 => 'ProductOrServiceConstraints' },
	'productversion' => { 408 => 'VERS' },
	'profession' => { 542 => 'profession' },
	'profile' => { 499 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 125 => 0xc6f4 },
	'profilecameraindices' => { 499 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 125 => 0xc6fe },
	'profiledynamicrange' => { 125 => 0xcd47 },
	'profileembedpolicy' => { 125 => 0xc6fd },
	'profilegaintablemap' => { 125 => 0xcd2d },
	'profilegaintablemap2' => { 125 => 0xcd40 },
	'profilegroupname' => { 125 => 0xcd48 },
	'profilehuesatmapdata1' => { 125 => 0xc6fa },
	'profilehuesatmapdata2' => { 125 => 0xc6fb },
	'profilehuesatmapdata3' => { 125 => 0xcd39 },
	'profilehuesatmapdims' => { 125 => 0xc6f9 },
	'profilehuesatmapencoding' => { 125 => 0xc7a3 },
	'profilelooktabledata' => { 125 => 0xc726 },
	'profilelooktabledims' => { 125 => 0xc725 },
	'profilelooktableencoding' => { 125 => 0xc7a4 },
	'profilename' => { 125 => 0xc6f8, 341 => 'iCCP-name' },
	'profiles' => { 499 => 'Profiles' },
	'profiletonecurve' => { 125 => 0xc6fc },
	'profiletype' => { 499 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 354 => 0x3c },
	'programline' => { 370 => '1.1' },
	'programmode' => { 196 => 0x5 },
	'programshift' => { 243 => 0xd },
	'programversion' => { 138 => 0x46 },
	'prohibits' => { 521 => 'prohibits' },
	'projectiontype' => { 509 => 'ProjectionType', 510 => 'ProjectionType' },
	'projectname' => { 552 => 'projectName' },
	'projectref' => { 552 => 'projectRef' },
	'projectrefpath' => { 552 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 552 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 186 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 340 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 340 => 'PropertyReleaseStatus' },
	'provider' => { 186 => 'WM/Provider' },
	'province-state' => { 138 => 0x5f },
	'publicationdate' => { 542 => 'publicationDate' },
	'publicationdatea-platform' => { 542 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 542 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 542 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 542 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 542 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 537 => 'PublicationEvent' },
	'publicationeventdate' => { 537 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 537 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 537 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 542 => 'publicationName' },
	'publisher' => { 186 => 'WM/Publisher', 408 => "\xa9pub", 410 => 'publisher', 526 => 'publisher' },
	'publishingfrequency' => { 542 => 'publishingFrequency' },
	'pulldown' => { 552 => 'pullDown' },
	'purchasedate' => { 408 => 'purd' },
	'purplehsl' => { 109 => 0x20916 },
	'pxshiftperiphedgenr' => { 495 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 495 => 0x9014 },
	'quality' => { 0 => 0x1, 37 => 0x3, 118 => 0x2, 119 => 0x3002, 133 => 0x1000, 147 => 0x9, 243 => 0x4, 291 => 0x3, 335 => 0x201, 349 => 0x300, 390 => 0x8, 397 => 0x2, 434 => 0x16, 444 => 0x56, 445 => 0x56, 446 => 0xb, 458 => [0x102,0x202e] },
	'quality2' => { 467 => 0x1170, 468 => 0x1174, 469 => 0x1150, 471 => 0x11a8, 472 => 0x1060, 473 => 0x258, 474 => 0x258, 475 => 0x247, 481 => 0x29, 482 => 0x25, 483 => 0x2a },
	'qualitybutton' => { 327 => 0x17d, 328 => 0x195 },
	'qualitybuttonplaybackmode' => { 327 => 0x1bf, 328 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 119 => 0x8 },
	'quantizationmethod' => { 140 => 0x78 },
	'quickadjust' => { 305 => 0x2a },
	'quickcontroldialinmeter' => { 90 => 0x703 },
	'quickfix' => { 302 => 0x416391c6 },
	'quickshot' => { 433 => 0x213 },
	'quiettime' => { 145 => 0x188a },
	'radialdistortioncoefficient1' => { 218 => 0x14 },
	'radialdistortioncoefficient2' => { 218 => 0x1c },
	'radialdistortioncoefficient3' => { 218 => 0x24 },
	'rads' => { 416 => 'rads' },
	'rangefinder' => { 314 => '4.1', 315 => '5.1', 316 => '5.1' },
	'rangemask' => { 523 => 'RangeMaskMapInfo', 525 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 523 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 525 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 523 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 525 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 523 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 525 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 523 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 525 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 523 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 525 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 523 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 525 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 138 => 0x7d },
	'rating' => { 109 => 0x10100, 125 => 0x4746, 133 => 0x1431, 401 => 0xdf, 408 => 'rtng', 416 => 'rtng', 458 => 0x2002, 517 => 'rating', 527 => 'rating', 537 => 'Rating', 542 => 'rating', 550 => 'Rating' },
	'ratingpercent' => { 125 => 0x4749, 185 => 'Rating', 408 => 'rate', 550 => 'RatingPercent' },
	'ratingregion' => { 537 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 537 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 537 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 537 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 537 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 537 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 537 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 537 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 537 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 537 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 537 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 537 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 537 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 537 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 537 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 537 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 537 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 537 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 537 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 88 => 0x8, 193 => 0x109, 370 => 0xd },
	'rawbrightnessadj' => { 109 => 0x20001, 114 => 0x38 },
	'rawburstimagecount' => { 80 => 0x2 },
	'rawburstimagenum' => { 80 => 0x1 },
	'rawcoloradj' => { 114 => 0x2e },
	'rawcropbottom' => { 401 => 0xd4 },
	'rawcropleft' => { 401 => 0xd1 },
	'rawcropright' => { 401 => 0xd3 },
	'rawcroptop' => { 401 => 0xd2 },
	'rawcustomsaturation' => { 114 => 0x30 },
	'rawcustomtone' => { 114 => 0x34 },
	'rawdata' => { 431 => 0xa048 },
	'rawdatabyteorder' => { 431 => 0x40 },
	'rawdatacfapattern' => { 431 => 0x50 },
	'rawdatauniqueid' => { 125 => 0xc65d },
	'rawdepth' => { 195 => 0x10 },
	'rawdevartfilter' => { 337 => 0x121 },
	'rawdevautogradation' => { 337 => 0x119 },
	'rawdevcolorspace' => { 336 => 0x108, 337 => 0x109 },
	'rawdevcontrastvalue' => { 336 => 0x106, 337 => 0x105 },
	'rawdeveditstatus' => { 336 => 0x10b },
	'rawdevelopingsoftware' => { 125 => 0xa43a, 530 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 390 => 0x62 },
	'rawdevengine' => { 336 => 0x109, 337 => 0x10b },
	'rawdevexposurebiasvalue' => { 336 => 0x100, 337 => 0x100 },
	'rawdevgradation' => { 337 => 0x112 },
	'rawdevgraypoint' => { 336 => 0x103, 337 => 0x104 },
	'rawdevmemorycoloremphasis' => { 336 => 0x105, 337 => 0x108 },
	'rawdevnoisereduction' => { 336 => 0x10a, 337 => 0x10a },
	'rawdevpicturemode' => { 337 => 0x10c },
	'rawdevpm_bwfilter' => { 337 => 0x110 },
	'rawdevpmcontrast' => { 337 => 0x10e },
	'rawdevpmnoisefilter' => { 337 => 0x120 },
	'rawdevpmpicturetone' => { 337 => 0x111 },
	'rawdevpmsaturation' => { 337 => 0x10d },
	'rawdevpmsharpness' => { 337 => 0x10f },
	'rawdevsaturation3' => { 337 => 0x113 },
	'rawdevsaturationemphasis' => { 336 => 0x104, 337 => 0x107 },
	'rawdevsettings' => { 336 => 0x10c },
	'rawdevsharpnessvalue' => { 336 => 0x107, 337 => 0x106 },
	'rawdevversion' => { 336 => 0x0, 337 => 0x0 },
	'rawdevwbfineadjustment' => { 336 => 0x102, 337 => 0x103 },
	'rawdevwhitebalance' => { 337 => 0x101 },
	'rawdevwhitebalancevalue' => { 336 => 0x101, 337 => 0x102 },
	'rawfile' => { 125 => 0xfe4c },
	'rawfilename' => { 523 => 'RawFileName', 525 => 'RawFileName' },
	'rawfiletype' => { 458 => 0x2029 },
	'rawformat' => { 359 => 0x2d, 399 => 0x10e },
	'rawimagecenter' => { 243 => 0x99 },
	'rawimagedigest' => { 125 => 0xc71c },
	'rawimagesize' => { 390 => 0x39 },
	'rawinfoversion' => { 338 => 0x0 },
	'rawjpgheight' => { 105 => 0x4 },
	'rawjpgquality' => { 61 => 0x6, 105 => 0x1 },
	'rawjpgsize' => { 61 => 0x7, 105 => 0x2 },
	'rawjpgwidth' => { 105 => 0x3 },
	'rawmeasuredrggb' => { 47 => 0x26a, 49 => 0x280, 51 => 0x194, 52 => [0x1ad,0x26b] },
	'rawrppused' => { 517 => 'rawrppused' },
	'rawtopreviewgain' => { 125 => 0xc7a8 },
	'readouttypeactual' => { 145 => 0x1903 },
	'readouttyperequested' => { 145 => 0x1902 },
	'reardisplay' => { 309 => '12.3', 310 => '6.2' },
	'recdevice' => { 537 => 'RecDevice' },
	'recdeviceattlensdescription' => { 537 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 537 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 537 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 537 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 537 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 544 => 'recipeEndingPage' },
	'recipepagerange' => { 544 => 'recipePageRange' },
	'recipesource' => { 544 => 'recipeSource' },
	'recipestartingpage' => { 544 => 'recipeStartingPage' },
	'recipetitle' => { 544 => 'recipeTitle' },
	'recognizedface1age' => { 347 => 0x20 },
	'recognizedface1name' => { 347 => 0x4 },
	'recognizedface1position' => { 347 => 0x18 },
	'recognizedface2age' => { 347 => 0x50 },
	'recognizedface2name' => { 347 => 0x34 },
	'recognizedface2position' => { 347 => 0x48 },
	'recognizedface3age' => { 347 => 0x80 },
	'recognizedface3name' => { 347 => 0x64 },
	'recognizedface3position' => { 347 => 0x78 },
	'recognizedfaceflags' => { 354 => 0x63 },
	'recommendedexposureindex' => { 125 => 0x8832, 530 => 'RecommendedExposureIndex' },
	'record' => { 124 => 'Record' },
	'recordbasisofrecord' => { 124 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 124 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 124 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 124 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 124 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 124 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 191 => 0x4d },
	'recorddynamicproperties' => { 124 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 103 => 0x1804 },
	'recordinformationwithheld' => { 124 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 416 => "\xa9phg" },
	'recordingformat' => { 424 => 0x1000 },
	'recordingmode' => { 118 => 0x1, 397 => 0x1 },
	'recordinstitutioncode' => { 124 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 124 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 416 => "\xa9lab" },
	'recordlabelurl' => { 416 => "\xa9lal" },
	'recordlocationdata' => { 251 => 0x660, 252 => 0x690, 253 => 0x6f8 },
	'recordmode' => { 37 => 0x9, 119 => 0x3000 },
	'recordownerinstitutioncode' => { 124 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 433 => 0x217 },
	'redbalance' => { 335 => 0x1017, 359 => 0x11, 390 => 0x1c },
	'redcurvelimits' => { 114 => 0x18a },
	'redcurvepoints' => { 113 => 0x2d, 114 => 0x160 },
	'redeyecorrection' => { 306 => 0x0 },
	'redeyeinfo' => { 523 => 'RedEyeInfo', 525 => 'RedEyeInfo' },
	'redeyereduction' => { 191 => 0x41, 444 => 0x6a, 446 => 0x28 },
	'redeyeremoval' => { 354 => 0xb9 },
	'redhsl' => { 109 => 0x20910 },
	'redhue' => { 523 => 'RedHue', 525 => 'RedHue' },
	'redsaturation' => { 523 => 'RedSaturation', 525 => 'RedSaturation' },
	'reductionmatrix1' => { 125 => 0xc625 },
	'reductionmatrix2' => { 125 => 0xc626 },
	'reductionmatrix3' => { 125 => 0xcd3a },
	'reelname' => { 125 => 0xc789, 416 => 'reel' },
	'reference1' => { 535 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 535 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 125 => 0x214, 548 => 'ReferenceBlackWhite' },
	'referencedate' => { 138 => 0x2f },
	'referencenumber' => { 138 => 0x32 },
	'references' => { 164 => 'References' },
	'referenceservice' => { 138 => 0x2d },
	'regionappliedtodimensions' => { 179 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 179 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 179 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 179 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 179 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 179 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 179 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 179 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 179 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 179 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 179 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 179 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 340 => 'RegionConstraints' },
	'regiondescription' => { 179 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 179 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 179 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 179 => 'Regions' },
	'regioninfoacdsee' => { 496 => 'Regions' },
	'regioninfodateregionsvalid' => { 182 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 182 => 'RegionInfo' },
	'regioninforegions' => { 182 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 179 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 179 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 182 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 182 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 179 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 179 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 179 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 537 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 537 => 'RegistryId' },
	'registryitemid' => { 537 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 537 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 162 => 'data' },
	'relatedaudiofilename' => { 162 => '1Name' },
	'relatedaudiofiletype' => { 162 => '0Type' },
	'relatedimagefileformat' => { 125 => 0x1000 },
	'relatedimageheight' => { 125 => 0x1002 },
	'relatedimagewidth' => { 125 => 0x1001 },
	'relatedresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 125 => 0xa004, 529 => 'RelatedSoundFile' },
	'relatedvideofile' => { 176 => 'data' },
	'relatedvideofilename' => { 176 => '1Name' },
	'relatedvideofiletype' => { 176 => '0Type' },
	'relation' => { 526 => 'relation' },
	'relationshipaccordingto' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 124 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 122 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 552 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 552 => 'relativeTimestamp' },
	'relativetimestampscale' => { 552 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 552 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 309 => '17.8', 310 => '18.5', 312 => '18.4', 313 => '18.4', 318 => '33.8', 319 => '17.6', 322 => '18.5', 323 => '18.4' },
	'releasedate' => { 138 => 0x1e, 408 => 'rldt', 517 => 'ReleaseDate', 552 => 'releaseDate' },
	'releasemode' => { 119 => 0x3001, 248 => 0x5c, 282 => 0x184d, 458 => 0xb049 },
	'releasemode2' => { 467 => 0x112c, 468 => [0x112c,0x8], 469 => [0x1108,0x8], 470 => [0x1184,0x8], 471 => [0x1160,0x8], 472 => [0x4,0x1018], 473 => [0x4,0x210], 474 => [0x4,0x210], 475 => [0x4,0x208], 477 => [0x67,0x3f], 478 => [0x6b,0x6d,0x73,0x4b], 479 => [0x6b,0x4b], 480 => 0x1f, 481 => 0x10, 482 => 0x10, 483 => 0x9, 490 => 0x34 },
	'releasemode3' => { 467 => 0x1128, 468 => 0x1128, 469 => 0x1104, 470 => 0x1180, 471 => 0x115c, 472 => 0x1014, 473 => 0x20c, 474 => 0x20c, 475 => 0x204 },
	'releaseready' => { 537 => 'ReleaseReady' },
	'releasesetting' => { 103 => 0x1016 },
	'releasetime' => { 138 => 0x23, 517 => 'ReleaseTime' },
	'remoteonduration' => { 311 => '3.4', 314 => '17.2', 315 => '18.2', 316 => '18.2', 317 => '18.2', 319 => '18.2', 320 => '4.3', 324 => '19.2' },
	'renditionclass' => { 553 => 'RenditionClass' },
	'renditionof' => { 553 => 'RenditionOf' },
	'renditionofalternatepaths' => { 553 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 553 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 553 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 553 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 553 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 553 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 553 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 553 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 553 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 553 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 553 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 553 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 553 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 553 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 553 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 553 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 553 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 553 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 553 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 553 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 553 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 553 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 553 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 553 => 'RenditionParams' },
	'repeatingflashcount' => { 221 => 0xd, 222 => 0xe, 223 => 0xe, 224 => 0xe, 225 => 0xe, 226 => 0xe, 318 => '17.2', 319 => '24.2', 320 => '9.2', 321 => '24.2', 324 => '25.2' },
	'repeatingflashcountbuilt-in' => { 289 => 0x4db },
	'repeatingflashcountexternal' => { 289 => 0x4c3 },
	'repeatingflashoutput' => { 318 => '17.1', 319 => '24.1', 320 => '9.1', 321 => '24.1', 324 => '25.1' },
	'repeatingflashoutputexternal' => { 289 => 0x4c0 },
	'repeatingflashrate' => { 221 => 0xc, 222 => 0xd, 223 => 0xd, 224 => 0xd, 225 => 0xd, 226 => 0xd, 318 => '18.1', 319 => '25.1', 320 => '10.1', 321 => '25.1', 324 => '26.1' },
	'repeatingflashratebuilt-in' => { 289 => 0x4da },
	'repeatingflashrateexternal' => { 289 => 0x4c2 },
	'requirements' => { 416 => "\xa9req" },
	'requires' => { 521 => 'requires' },
	'resampleparams' => { 552 => 'resampleParams' },
	'resampleparamsquality' => { 552 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 145 => 0xe50 },
	'resamplingkerneldenominators067' => { 145 => 0xe4f },
	'resamplingkerneldenominators100' => { 145 => 0xe51 },
	'resaved' => { 433 => 0x21e },
	'resetblacksegrows' => { 145 => 0x181a },
	'resolution' => { 169 => 'Resolution' },
	'resolutionmode' => { 434 => [0x87,0x4] },
	'resolutionunit' => { 125 => 0x128, 141 => 0x2, 548 => 'ResolutionUnit' },
	'resourceid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 124 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 124 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 90 => 0x612 },
	'restrictions' => { 545 => 'restrictions' },
	'retouchareafeather' => { 523 => [\'RetouchAreas','RetouchAreasFeather'], 525 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 523 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 525 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 523 => [\'RetouchAreas','RetouchAreasMasksAngle'], 525 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 523 => [\'RetouchAreas','RetouchAreasMasksBottom'], 525 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 523 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 525 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 523 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 525 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 523 => [\'RetouchAreas','RetouchAreasMasksDabs'], 525 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 523 => [\'RetouchAreas','RetouchAreasMasksFeather'], 525 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 523 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 525 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 523 => [\'RetouchAreas','RetouchAreasMasksFlow'], 525 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 523 => [\'RetouchAreas','RetouchAreasMasksFullX'], 525 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 523 => [\'RetouchAreas','RetouchAreasMasksFullY'], 525 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 523 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 525 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 523 => [\'RetouchAreas','RetouchAreasMasksLeft'], 525 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasks'], 525 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 523 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 525 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 523 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 525 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 523 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 525 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 523 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 525 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 523 => [\'RetouchAreas','RetouchAreasMasksRadius'], 525 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 523 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 525 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 523 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 525 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 523 => [\'RetouchAreas','RetouchAreasMasksRight'], 525 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 523 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 525 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 523 => [\'RetouchAreas','RetouchAreasMasks'], 525 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 523 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 525 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 523 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 525 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 523 => [\'RetouchAreas','RetouchAreasMasksTop'], 525 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 523 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 525 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 523 => [\'RetouchAreas','RetouchAreasMasksVersion'], 525 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 523 => [\'RetouchAreas','RetouchAreasMasksWhat'], 525 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 523 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 525 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 523 => [\'RetouchAreas','RetouchAreasMasksX'], 525 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 523 => [\'RetouchAreas','RetouchAreasMasksY'], 525 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 523 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 525 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 523 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 525 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 523 => [\'RetouchAreas','RetouchAreasMethod'], 525 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 523 => [\'RetouchAreas','RetouchAreasOffsetY'], 525 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 523 => [\'RetouchAreas','RetouchAreasOpacity'], 525 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 523 => 'RetouchAreas', 525 => 'RetouchAreas' },
	'retouchareaseed' => { 523 => [\'RetouchAreas','RetouchAreasSeed'], 525 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 523 => [\'RetouchAreas','RetouchAreasSourceState'], 525 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 523 => [\'RetouchAreas','RetouchAreasSourceX'], 525 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 523 => [\'RetouchAreas','RetouchAreasSpotType'], 525 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 243 => 0x9e },
	'retouchinfo' => { 523 => 'RetouchInfo', 525 => 'RetouchInfo' },
	'retouchnefprocessing' => { 266 => 0x5 },
	'retractlensonpoweroff' => { 90 => 0x814 },
	'reuse' => { 340 => 'Reuse' },
	'reuseallowed' => { 555 => 'ReuseAllowed' },
	'reuseprohibited' => { 545 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 316 => '5.2' },
	'reversefocusring' => { 326 => 0x163, 327 => 0x163, 328 => 0x17b },
	'reverseindicators' => { 309 => '12.1', 310 => '6.1', 312 => '6.1', 313 => '6.1', 314 => '4.3', 315 => '5.2', 316 => '5.4', 318 => '33.5', 319 => '5.1', 322 => '6.1', 323 => '6.1', 324 => '6.2', 325 => 0xc5, 326 => 0xc1, 327 => 0xc1, 328 => 0xc1 },
	'reverseshutterspeedaperture' => { 316 => '5.3' },
	'revision' => { 527 => 'revision' },
	'rflensmffocusringsensitivity' => { 90 => 0x714 },
	'rflenstype' => { 61 => 0x3d },
	'rgbcurvelimits' => { 114 => 0x238 },
	'rgbcurvepoints' => { 113 => 0x7, 114 => 0x20e },
	'rgbtables' => { 125 => 0xcd3f },
	'richtextcomment' => { 532 => 'RichTextComment' },
	'ricohdate' => { 423 => 0x6 },
	'ricohimageheight' => { 423 => 0x2 },
	'ricohimagewidth' => { 423 => 0x0 },
	'rightalbedo' => { 513 => 'RightAlbedo' },
	'rightascension' => { 172 => 'RightAscension' },
	'rights' => { 526 => 'rights' },
	'rightsagent' => { 545 => 'rightsAgent' },
	'rightsowner' => { 545 => 'rightsOwner' },
	'roll' => { 121 => 0x8, 416 => ['roll',"\xa9frl"] },
	'rollangle' => { 66 => 0x4, 133 => 0x144d, 258 => 0x0, 330 => 0x903, 344 => 'RollAngle', 354 => 0x90, 388 => 0x1, 389 => 0x3, 429 => 0x2 },
	'romoperationmode' => { 103 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 102 => 0x3, 109 => 0x10002, 114 => 0x26e, 120 => 'QuickTime-Rotation', 129 => 0x4, 172 => 'Rotation', 189 => [0x65,0x50], 190 => 0x46, 191 => 0x5a, 194 => 0x10, 267 => 0x1a, 282 => 0x3693, 288 => '590.1', 302 => 0x76a43207, 354 => 0x30, 370 => '17.2', 401 => 0xd8, 409 => 'irot', 444 => 0x3f, 445 => 0x3f, 455 => 0x10 },
	'routedto' => { 531 => 'RoutedTo' },
	'routing' => { 406 => 'Routing' },
	'routingdestinations' => { 511 => 'RoutingDestinations' },
	'routingexclusions' => { 511 => 'RoutingExclusions' },
	'routingnotes' => { 531 => 'RoutingNotes' },
	'rowsperstrip' => { 125 => 0x116 },
	'rpp' => { 517 => 'rpp' },
	'rtkflag' => { 122 => 'RtkFlag' },
	'rtkstdhgt' => { 122 => 'RtkStdHgt' },
	'rtkstdlat' => { 122 => 'RtkStdLat' },
	'rtkstdlon' => { 122 => 'RtkStdLon' },
	'safetyshift' => { 90 => 0x108 },
	'safetyshiftinavortv' => { 88 => 0x10, 89 => 0x10, 91 => 0xf, 92 => 0x10, 95 => 0x10 },
	'sameexposurefornewaperture' => { 90 => 0x112 },
	'samplebits' => { 162 => 'SampleBits' },
	'samplepagerange' => { 542 => 'samplePageRange' },
	'samplerate' => { 162 => 'SampleRate' },
	'samplesperpixel' => { 125 => 0x115, 359 => 0x8, 548 => 'SamplesPerPixel' },
	'samplestructure' => { 140 => 0x5a },
	'samsungmodelid' => { 431 => 0x3 },
	'sanyoquality' => { 433 => 0x201 },
	'sanyothumbnail' => { 433 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 37 => 0xe, 55 => 0x1, 68 => 0x7, 118 => 0xd, 119 => [0x3013,0x1f], 125 => [0xa409,0xfe55], 133 => 0x1003, 163 => 'Saturation', 188 => 0x1f, 189 => 0x32, 190 => 0x28, 191 => 0x1a, 196 => 0x1, 243 => 0xaa, 260 => 0x35, 261 => 0x3b, 262 => 0x43, 354 => 0x40, 356 => 0x300d, 390 => 0x1f, 397 => 0xd, 418 => 0x27, 420 => 0x58, 423 => 0x28, 424 => 0x1013, 434 => 0x10, 444 => 0x1e, 445 => 0x1b, 458 => 0x2005, 523 => 'Saturation', 525 => 'Saturation', 529 => 'Saturation' },
	'saturationadj' => { 109 => 0x20901, 114 => 0x116, 243 => 0x94, 301 => 0x1, 305 => 0x2e, 495 => 0x8016 },
	'saturationadjustmentaqua' => { 523 => 'SaturationAdjustmentAqua', 525 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 523 => 'SaturationAdjustmentBlue', 525 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 523 => 'SaturationAdjustmentGreen', 525 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 523 => 'SaturationAdjustmentMagenta', 525 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 523 => 'SaturationAdjustmentOrange', 525 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 523 => 'SaturationAdjustmentPurple', 525 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 523 => 'SaturationAdjustmentRed', 525 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 523 => 'SaturationAdjustmentYellow', 525 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 76 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 75 => 0x68, 76 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 75 => 0x38, 76 => 0x38 },
	'saturationmonochrome' => { 75 => 0x80, 76 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 75 => 0x50, 76 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 75 => 0x20, 76 => 0x20 },
	'saturationsetting' => { 338 => 0x1010, 446 => 0x11, 463 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 75 => 0x8, 76 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 75 => 0x98, 76 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 75 => 0xb0, 76 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 75 => 0xc8, 76 => 0xe0 },
	'savefocusposition' => { 247 => 0x9b0 },
	'saveid' => { 553 => 'SaveID' },
	'sbaanalysiscomplete' => { 145 => 0xc35 },
	'sbablack' => { 145 => 0xc25 },
	'sbagmoffset' => { 145 => 0xc4a },
	'sbagray' => { 145 => 0xc26 },
	'sbagreenmagentabal' => { 145 => 0xc33 },
	'sbahighgray' => { 145 => 0xc46 },
	'sbailloffset' => { 145 => 0xc49 },
	'sbailluminantbal' => { 145 => 0xc34 },
	'sbalowgray' => { 145 => 0xc47 },
	'sbaneutralbal' => { 145 => 0xc32 },
	'sbawhite' => { 145 => 0xc27 },
	'scaletype' => { 552 => 'scaleType' },
	'scalingfactorheight' => { 344 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 268 => 0x60 },
	'scanningdirection' => { 140 => 0x64 },
	'scene' => { 416 => 'scen', 536 => 'Scene', 552 => 'scene' },
	'scenearea' => { 333 => 0x211, 335 => 0x1031 },
	'sceneassist' => { 243 => 0x9c },
	'scenecapturetype' => { 125 => 0xa406, 529 => 'SceneCaptureType' },
	'scenedetect' => { 333 => 0x210, 335 => 0x1030 },
	'scenedetectdata' => { 333 => 0x212, 335 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 149 => 0xfa02, 193 => 0x100, 243 => 0x8f, 330 => 0x509, 335 => 0x403, 354 => 0x8001, 363 => 0xf, 458 => 0xb023 },
	'scenemodeused' => { 151 => [0x6002,0xf002] },
	'scenerecognition' => { 133 => 0x1425 },
	'scenereferred' => { 533 => 'scene_referred' },
	'sceneselect' => { 433 => 0x21f },
	'scenetype' => { 125 => 0xa301, 529 => 'SceneType' },
	'screentips' => { 309 => '12.7', 310 => '5.3', 318 => '13.1', 319 => '4.4', 322 => '5.4', 324 => '5.1' },
	'scriptversion' => { 145 => 0x1770 },
	'sdrblend' => { 523 => 'SDRBlend', 525 => 'SDRBlend' },
	'sdrbrightness' => { 523 => 'SDRBrightness', 525 => 'SDRBrightness' },
	'sdrcontrast' => { 523 => 'SDRContrast', 525 => 'SDRContrast' },
	'sdrhighlights' => { 523 => 'SDRHighlights', 525 => 'SDRHighlights' },
	'sdrshadows' => { 523 => 'SDRShadows', 525 => 'SDRShadows' },
	'sdrwhites' => { 523 => 'SDRWhites', 525 => 'SDRWhites' },
	'seal' => { 125 => 0xcea1 },
	'season' => { 537 => 'Season', 541 => 'season' },
	'seasonidentifier' => { 537 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 537 => [\'Season','SeasonName'] },
	'seasonnumber' => { 537 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 511 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 247 => 0x35a, 249 => 0x240, 250 => 0x240, 251 => 0x22c, 252 => 0x240, 253 => 0x240, 271 => 0x13c, 282 => 0x1d0 },
	'section' => { 542 => 'section' },
	'securityclassification' => { 125 => 0x9212 },
	'selectableafpoint' => { 90 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 90 => 0x512 },
	'selfdata' => { 122 => 'SelfData' },
	'selftimer' => { 37 => 0x2, 354 => 0x2e, 433 => 0x214, 467 => 0x1134, 468 => 0x1134, 469 => 0x1110, 470 => 0x118c, 471 => 0x1168, 472 => 0x1020, 473 => 0x218, 474 => 0x218, 475 => 0x210 },
	'selftimer2' => { 82 => 0x1d },
	'selftimerinterval' => { 319 => '19.2' },
	'selftimermode' => { 125 => 0x882b },
	'selftimershotcount' => { 310 => '20.2', 312 => '20.3', 313 => '20.3', 314 => '18.2', 315 => '19.2', 316 => '19.2', 317 => '19.3', 319 => '19.3', 322 => '20.3', 323 => '20.3', 324 => '20.2', 325 => 0x31, 326 => 0x2d, 327 => 0x2d, 328 => 0x2d },
	'selftimershotinterval' => { 310 => '20.3', 312 => '20.2', 313 => '20.2', 317 => '19.2', 322 => '20.2', 323 => '20.2', 325 => 0x35, 326 => 0x31, 327 => 0x31, 328 => 0x31 },
	'selftimertime' => { 103 => 0x1806, 191 => 0x1f, 309 => '18.1', 310 => '20.1', 311 => '3.3', 312 => '20.1', 313 => '20.1', 314 => '18.1', 315 => '19.1', 316 => '19.1', 317 => '19.1', 318 => '7.2', 319 => '19.1', 320 => '3.3', 322 => '20.1', 323 => '20.1', 324 => '20.1', 325 => 0x2d, 326 => 0x2b, 327 => 0x2b, 328 => 0x2b },
	'sellingagency' => { 542 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 125 => 0x8546 },
	'sensingmethod' => { 125 => 0xa217, 529 => 'SensingMethod' },
	'sensitivityadjust' => { 390 => 0x40 },
	'sensitivitysteps' => { 370 => ['14.3','17.4'], 372 => 0x1 },
	'sensitivitytype' => { 125 => 0x8830, 530 => 'SensitivityType' },
	'sensor' => { 198 => 0x665e },
	'sensorarea' => { 335 => 0x400 },
	'sensorareas' => { 431 => 0xa010 },
	'sensorbitdepth' => { 356 => 0x312d },
	'sensorbluelevel' => { 79 => 0x5 },
	'sensorcalibration' => { 334 => 0x805 },
	'sensorcleaning' => { 96 => 0xd },
	'sensorfullheight' => { 144 => 0xf904 },
	'sensorfullwidth' => { 144 => 0xf903 },
	'sensorheight' => { 144 => 0xf901, 149 => 0xfa21, 195 => 0x8, 356 => 0x312c, 399 => 0x109, 424 => 0x1602 },
	'sensorimageheight' => { 145 => 0x3ee },
	'sensorimagewidth' => { 145 => 0x3ed },
	'sensorleftborder' => { 145 => 0x3eb },
	'sensorleftmargin' => { 399 => 0x10a },
	'sensorpixelsize' => { 243 => 0x9a },
	'sensorredlevel' => { 79 => 0x4 },
	'sensorserialnumber' => { 145 => 0x9ce },
	'sensorshield' => { 249 => 0x76b, 250 => 0x77b, 251 => 0x66d, 252 => 0x69d, 253 => 0x705 },
	'sensorsize' => { 163 => 'SensorSize', 390 => 0x35 },
	'sensortemperature' => { 333 => 0x1500, 335 => 0x1007, 395 => 0xc, 399 => 0x210, 434 => [0x39,0x55] },
	'sensortemperature2' => { 395 => 0xe, 399 => 0x211 },
	'sensortopborder' => { 145 => 0x3ec },
	'sensortopmargin' => { 399 => 0x10b },
	'sensortype' => { 354 => 0xca },
	'sensorwidth' => { 144 => 0xf900, 149 => 0xfa20, 195 => 0xa, 356 => 0x312b, 399 => 0x108, 424 => 0x1601 },
	'sequence' => { 418 => 0x7, 419 => 0x35, 420 => 0x36 },
	'sequencefilenumber' => { 468 => 0x4, 469 => 0x4, 470 => 0x4, 471 => 0x4, 481 => 0xc, 482 => 0xc, 483 => 0x1a },
	'sequenceimagenumber' => { 468 => 0x0, 469 => 0x0, 470 => 0x0, 471 => 0x0, 481 => 0x8, 482 => 0x8, 483 => 0x12, 490 => 0x24 },
	'sequencelength' => { 481 => 0x22, 482 => 0x1e, 483 => [0x16,0x1e] },
	'sequencename' => { 541 => 'sequenceName' },
	'sequencenumber' => { 82 => 0x9, 119 => 0x301c, 133 => 0x1101, 147 => 0x1d, 289 => 0x51c, 354 => 0x2b, 446 => [0x10c,0x30c], 458 => 0xb04a, 541 => 'sequenceNumber' },
	'sequenceshotinterval' => { 433 => 0x224 },
	'sequencetotalnumber' => { 541 => 'sequenceTotalNumber' },
	'sequentialshot' => { 433 => 0x20e },
	'serialnumber' => { 69 => 0xc, 103 => 0x180b, 125 => [0xa431,0xfde9], 144 => 0xfa04, 146 => 0xfa00, 148 => 0xc354, 149 => 0xfa19, 160 => 0x0, 163 => 'SerialNumber', 198 => 0x5501, 243 => [0xa0,0x1d], 331 => 0x101, 335 => [0x404,0x101a], 349 => 0x303, 351 => 0x305, 356 => 0x3103, 390 => 0x229, 399 => 0x102, 400 => 0x407, 416 => ['SNum','slno'], 418 => 0x15, 419 => 0x4b, 420 => 0x7e, 424 => 0x5, 431 => 0xa002, 434 => 0x2, 458 => 0x2031, 520 => 'SerialNumber', 530 => 'BodySerialNumber' },
	'serialnumberformat' => { 69 => 0x15, 103 => 0x183b },
	'serialnumberhash' => { 416 => 'CAME' },
	'series' => { 537 => 'Series' },
	'seriesdatetime' => { 498 => 'SeriesDateTime' },
	'seriesdescription' => { 498 => 'SeriesDescription' },
	'seriesidentifier' => { 537 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 498 => 'SeriesModality' },
	'seriesname' => { 537 => [\'Series','SeriesName'] },
	'seriesnumber' => { 498 => 'SeriesNumber', 542 => 'seriesNumber' },
	'seriestitle' => { 542 => 'seriesTitle' },
	'serviceidentifier' => { 139 => 0x1e },
	'servingsize' => { 544 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 93 => 0x0, 94 => 0x0 },
	'setbuttonwhenshooting' => { 88 => 0x1, 90 => 0x704, 96 => 0xc },
	'setclockfromlocationdata' => { 251 => 0x61d, 252 => 0x64d, 253 => 0x6b5 },
	'setfunctionwhenshooting' => { 91 => 0x0, 92 => 0x1, 95 => 0x1 },
	'setting' => { 541 => 'setting' },
	'shadingcompensation' => { 330 => 0x50c, 354 => 0x8a },
	'shadingcompensation2' => { 334 => 0x1012 },
	'shadow' => { 434 => 0xe },
	'shadowadj' => { 109 => 0x2030b },
	'shadowcorrection' => { 390 => 0x79 },
	'shadowprotection' => { 301 => 0x0 },
	'shadows' => { 125 => 0xfe52, 458 => 0x2032, 516 => 'Shadows', 523 => 'Shadows', 525 => 'Shadows' },
	'shadows2012' => { 523 => 'Shadows2012', 525 => 'Shadows2012' },
	'shadowsadj' => { 495 => 0x901a },
	'shadowscale' => { 125 => 0xc633 },
	'shadowtint' => { 523 => 'ShadowTint', 525 => 'ShadowTint' },
	'shadowtone' => { 133 => 0x1040 },
	'shakereduction' => { 392 => 0x1, 393 => 0x1 },
	'shareduserrating' => { 186 => 'WM/SharedUserRating' },
	'sharpendetail' => { 523 => 'SharpenDetail', 525 => 'SharpenDetail' },
	'sharpenedgemasking' => { 523 => 'SharpenEdgeMasking', 525 => 'SharpenEdgeMasking' },
	'sharpening' => { 356 => 0x300b },
	'sharpeningadj' => { 305 => 0x2b },
	'sharpeningkernel' => { 145 => 0x92f },
	'sharpenradius' => { 523 => 'SharpenRadius', 525 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 37 => 0xf, 68 => 0x6, 79 => 0x2, 118 => 0xb, 119 => [0x3011,0x21], 125 => [0xa40a,0xfe56], 133 => 0x1001, 147 => 0x6b, 156 => 0x37, 163 => 'Sharpness', 188 => 0x21, 189 => 0x30, 190 => 0x26, 191 => 0x18, 196 => 0x3, 243 => 0x6, 260 => 0x32, 261 => 0x33, 262 => 0x39, 335 => 0x100f, 354 => 0x41, 390 => 0x21, 397 => 0xb, 418 => 0x26, 420 => 0x56, 423 => 0x22, 424 => [0x1003,0x1014], 434 => 0x11, 444 => 0x1c, 445 => 0x19, 458 => 0x2006, 490 => 0x52, 523 => 'Sharpness', 525 => 'Sharpness', 529 => 'Sharpness' },
	'sharpnessadj' => { 109 => 0x20310, 114 => 0x25a, 495 => 0x801a },
	'sharpnessadjon' => { 109 => '0x20310.0' },
	'sharpnessauto' => { 76 => 0x94 },
	'sharpnessfactor' => { 335 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 75 => 0x64, 76 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 79 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 75 => 0x34, 76 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 75 => 0x7c, 76 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 75 => 0x4c, 76 => 0x4c },
	'sharpnessovershoot' => { 495 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 75 => 0x1c, 76 => 0x1c },
	'sharpnessrange' => { 458 => 0x2035 },
	'sharpnesssetting' => { 330 => 0x506, 338 => 0x1013, 446 => 0x12, 463 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 75 => 0x4, 76 => 0x4 },
	'sharpnessstrength' => { 109 => 0x20311 },
	'sharpnessthreshold' => { 495 => 0x801d },
	'sharpnessundershoot' => { 495 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 75 => 0x94, 76 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 75 => 0xac, 76 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 75 => 0xc4, 76 => 0xdc },
	'shiftcols' => { 145 => 0xc70 },
	'shootid' => { 541 => 'shootID' },
	'shootingdistance' => { 109 => 0x20701 },
	'shootinginfodisplay' => { 309 => '13.2', 310 => '5.1', 318 => '10.2', 319 => '4.1', 322 => '5.1', 324 => '5.3' },
	'shootinginfomonitorofftime' => { 309 => '26.2', 310 => '22.2', 312 => '22.2', 313 => '22.2', 317 => '21.2', 318 => '9.1', 319 => '21.2', 322 => '22.2', 323 => '22.2', 324 => '22.2', 325 => 0x3d, 326 => 0x37, 327 => 0x37, 328 => 0x37 },
	'shootingmode' => { 163 => 'ShootingMode', 243 => 0x89, 354 => 0x1f },
	'shootingmodesetting' => { 311 => '5.1' },
	'shortdescription' => { 527 => 'shortdescription' },
	'shortdocumentid' => { 138 => 0xba },
	'shortname' => { 523 => 'ShortName', 525 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 90 => 0x80d },
	'shorttitle' => { 408 => '@sti' },
	'shotdate' => { 552 => 'shotDate' },
	'shotday' => { 552 => 'shotDay' },
	'shotlocation' => { 552 => 'shotLocation' },
	'shotlogdata' => { 503 => 'shot_log_data' },
	'shotname' => { 416 => 'shot', 552 => 'shotName' },
	'shotnumber' => { 552 => 'shotNumber' },
	'shotnumbersincepowerup' => { 462 => 0x44e, 481 => 0x1a, 482 => 0x16, 483 => 0xa },
	'shotnumbersincepowerup2' => { 446 => 0x200 },
	'shotsize' => { 552 => 'shotSize' },
	'shotsperinterval' => { 232 => 0x180, 247 => 0x1f0, 248 => 0xb4, 249 => 0xcc, 250 => 0xcc, 251 => 0xc0, 252 => 0xd0, 253 => 0xd0 },
	'showmovement' => { 408 => 'shwm' },
	'shownevent' => { 537 => 'EventExt' },
	'showneventidentifier' => { 537 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 537 => [\'EventExt','EventExtName'] },
	'shutter' => { 477 => 0x20, 478 => 0x26, 479 => 0x26 },
	'shutter-aelock' => { 88 => 0x4, 90 => 0x701, 91 => 0x3, 92 => 0x4, 93 => 0x3, 94 => 0x3, 95 => 0x4, 96 => 0x2 },
	'shutteraelbutton' => { 89 => 0x4 },
	'shutterbuttonafonbutton' => { 90 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 34 => 0xd29, 61 => 0x1, 243 => 0xa7, 273 => [0x6a,0x157,0x24d], 274 => 0x286, 275 => 0x279, 276 => 0x284, 277 => 0x242, 278 => 0x280, 279 => 0x276, 280 => [0x27d,0x27f], 281 => 0x246, 283 => 0x2d6, 284 => 0x321, 285 => 0xbd8, 286 => 0x287, 287 => 0x320, 288 => 0x24a, 289 => 0x5fb, 290 => 0x2d5, 390 => 0x5d, 455 => 0x846, 461 => [0x125,0x14a], 477 => 0x32, 478 => 0x3a, 479 => 0x3a, 480 => 0xa },
	'shuttercount2' => { 477 => 0x4c, 478 => [0x50,0x52,0x58], 479 => 0x50 },
	'shuttercount3' => { 477 => [0x1a0,0x1aa,0x1bd], 478 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 88 => 0xf, 89 => 0xf, 90 => 0x305, 91 => 0xe, 92 => 0xf, 93 => 0x8, 94 => 0x8, 95 => 0xf, 96 => 0x8 },
	'shuttermode' => { 61 => 0x17, 147 => 0x1b, 243 => 0x34 },
	'shutterreleasebuttonae-l' => { 309 => '17.7', 310 => '18.4', 312 => '78.4', 313 => '78.4', 314 => '16.1', 315 => '17.1', 316 => '17.1', 317 => '17.1', 318 => '7.1', 319 => '17.5', 322 => '18.4', 323 => '78.4', 324 => '18.2', 325 => 0x2b, 326 => 0x29, 327 => 0x29, 328 => 0x29 },
	'shutterreleasemethod' => { 103 => 0x1010 },
	'shutterreleasenocfcard' => { 88 => 0x2, 89 => 0x2, 96 => 0xf },
	'shutterreleasetiming' => { 103 => 0x1011 },
	'shutterreleasewithoutlens' => { 90 => 0x711 },
	'shutterspeedlock' => { 310 => '38.1', 312 => '38.1', 313 => '38.1', 322 => '38.1', 323 => '38.1', 325 => 0xbb, 326 => 0xb7, 327 => 0xb7, 328 => 0xb7 },
	'shutterspeedrange' => { 90 => 0x10c },
	'shutterspeedsetting' => { 191 => 0x6, 444 => 0x2f, 445 => 0x28, 446 => 0x0 },
	'shutterspeedvalue' => { 99 => 0x1, 125 => 0x9201, 335 => 0x1000, 399 => 0x400, 529 => 'ShutterSpeedValue' },
	'shuttertype' => { 133 => 0x1050, 354 => 0x9f, 390 => 0x87, 483 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 540 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 145 => 0xe0d },
	'sigmascalingfactorcamera' => { 145 => 0xe0c },
	'sigmascalingfactorlowres' => { 145 => 0xe0b },
	'sigmasizetable' => { 145 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 243 => 0xbf, 247 => 0x9b7 },
	'similarityindex' => { 138 => 0xe4 },
	'singleframebracketing' => { 191 => 0x21 },
	'skilllevel' => { 544 => 'skillLevel' },
	'skintonecorrection' => { 390 => 0x95 },
	'skiplinetime' => { 145 => 0x184e },
	'slaveflashmeteringsegments' => { 390 => 0x20b },
	'slideshowname' => { 541 => 'slideshowName' },
	'slideshownumber' => { 541 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 541 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 247 => 0x364, 249 => 0x24a, 250 => 0x24a, 253 => 0x24a },
	'slowshutter' => { 82 => 0x8 },
	'slowsync' => { 133 => 0x1030 },
	'smartalbumcolor' => { 431 => 0x20 },
	'smartrange' => { 431 => 0xa012 },
	'smileshutter' => { 446 => 0x31 },
	'smileshuttermode' => { 446 => 0x27 },
	'smoothness' => { 125 => 0xfe57, 523 => 'Smoothness', 525 => 'Smoothness' },
	'snapshot' => { 537 => 'SnapshotLink' },
	'snapshotformat' => { 537 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 537 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 537 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 537 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 537 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 517 => 'Snapshots' },
	'snapshotusedvideoframe' => { 537 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 537 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 537 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 537 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 537 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 458 => 0x200f },
	'software' => { 125 => 0x131, 164 => 'Software', 343 => 'Software', 399 => 0x203, 410 => 'software', 434 => 0x18, 506 => 'Software', 548 => 'Software' },
	'softwareversion' => { 416 => ['@swr',"\xa9swr"], 433 => 0x207 },
	'soloist' => { 408 => "\xa9sol" },
	'songwriter' => { 416 => "\xa9swf" },
	'songwriterkeywords' => { 416 => "\xa9swk" },
	'sonycropsize' => { 125 => 0x74c8 },
	'sonycroptopleft' => { 125 => 0x74c7 },
	'sonydatetime' => { 466 => 0x6, 468 => 0x1b6, 469 => 0x210, 470 => 0x1fe, 471 => 0x22c },
	'sonydatetime2' => { 477 => 0x51 },
	'sonyexposuretime' => { 477 => 0x3a, 478 => 0x46, 479 => [0x66,0x46], 480 => 0x1a },
	'sonyexposuretime2' => { 490 => 0xe },
	'sonyfnumber' => { 477 => 0x3c, 478 => 0x48, 479 => [0x68,0x48], 480 => 0x1c, 490 => 0x14 },
	'sonyimageheight' => { 466 => 0x1a, 481 => 0x44, 482 => 0x3f },
	'sonyimageheightmax' => { 490 => 0x40 },
	'sonyimagesize' => { 191 => 0x3b, 444 => 0x54, 445 => 0x54, 446 => 0x9 },
	'sonyimagewidth' => { 466 => 0x1c },
	'sonyimagewidthmax' => { 490 => 0x3e },
	'sonyiso' => { 468 => 0x1218, 469 => 0x11f4, 470 => 0x1270, 471 => [0x1254,0x1258,0x1280], 472 => 0x113c, 473 => 0x344, 474 => 0x346, 475 => 0x320, 490 => 0x4 },
	'sonymaxaperture' => { 477 => 0x0, 478 => 0x0 },
	'sonymaxaperturevalue' => { 490 => 0x16 },
	'sonyminaperture' => { 477 => 0x1, 478 => 0x1 },
	'sonymodelid' => { 458 => 0xb001 },
	'sonyquality' => { 191 => 0x3c },
	'sonyrawimagesize' => { 125 => 0x7038 },
	'sonytimeminsec' => { 478 => 0x61 },
	'sortalbum' => { 408 => 'soal' },
	'sortalbumartist' => { 408 => 'soaa' },
	'sortartist' => { 408 => 'soar' },
	'sortcomposer' => { 408 => 'soco' },
	'sortname' => { 408 => 'sonm', 523 => 'SortName', 525 => 'SortName' },
	'sortshow' => { 408 => 'sosn' },
	'soundengineer' => { 408 => "\xa9sne" },
	'source' => { 138 => 0x73, 343 => 'Source', 526 => 'source', 527 => 'source', 540 => 'Source' },
	'sourcecount' => { 510 => 'SourceCount' },
	'sourcecredits' => { 416 => "\xa9src" },
	'sourcedirectoryindex' => { 376 => 0x0 },
	'sourcefileindex' => { 376 => 0x2 },
	'sourcephotoscount' => { 509 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 145 => 0x1390 },
	'spatialfrequencyresponse' => { 529 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 529 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 529 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 529 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 529 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 552 => 'speakerPlacement' },
	'specialeffectlevel' => { 119 => 0x3030 },
	'specialeffectmode' => { 119 => 0x2076 },
	'specialeffectsetting' => { 119 => 0x3031 },
	'specialinstructions' => { 138 => 0x28 },
	'specialmode' => { 335 => 0x200, 433 => 0x200 },
	'specialoccasion' => { 544 => 'specialOccasion' },
	'specialtypeid' => { 503 => 'SpecialTypeID' },
	'spectralsensitivity' => { 125 => 0x8824, 529 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 44 => 0x32b, 45 => 0x281, 46 => 0x295, 49 => [0x2b9,0x2d0,0x2d4], 50 => [0x56a,0x296], 51 => 0x1e4, 52 => [0x1fd,0x2dd], 53 => [0x231,0x30f], 54 => 0x31d },
	'speedx' => { 121 => 0x3, 416 => "\xa9xsp" },
	'speedy' => { 121 => 0x4, 416 => "\xa9ysp" },
	'speedz' => { 121 => 0x5, 416 => "\xa9zsp" },
	'spherical' => { 510 => 'Spherical' },
	'sphericalvideoxml' => { 126 => 'SphericalVideoXML' },
	'splitcolumn' => { 399 => 0x222 },
	'splittoningbalance' => { 523 => 'SplitToningBalance', 525 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 523 => 'SplitToningHighlightHue', 525 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 523 => 'SplitToningHighlightSaturation', 525 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 523 => 'SplitToningShadowHue', 525 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 523 => 'SplitToningShadowSaturation', 525 => 'SplitToningShadowSaturation' },
	'sport' => { 542 => 'sport' },
	'spotfocuspointx' => { 188 => 0x2d },
	'spotfocuspointy' => { 188 => 0x2e },
	'spotmeteringmode' => { 37 => 0x27 },
	'spotmeterlinktoafpoint' => { 90 => 0x107 },
	'sractive' => { 370 => '17.1' },
	'srawquality' => { 37 => 0x2e },
	'srfocallength' => { 392 => 0x3 },
	'srgbrendering' => { 341 => 'sRGB' },
	'srhalfpresstime' => { 392 => 0x2 },
	'srresult' => { 392 => 0x0, 393 => 0x0 },
	'stackedimage' => { 330 => 0x804 },
	'standardmatrixcustom' => { 145 => 0x7d4 },
	'standardmatrixdaylight' => { 145 => 0x7d0 },
	'standardmatrixflash' => { 145 => 0x7d3 },
	'standardmatrixfluorescent' => { 145 => 0x7d2 },
	'standardmatrixtungsten' => { 145 => 0x7d1 },
	'standardoutputhighlightpoint' => { 115 => 0x14 },
	'standardoutputsensitivity' => { 125 => 0x8831, 530 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 115 => 0x15 },
	'standardrawcolortone' => { 115 => 0xd },
	'standardrawcontrast' => { 115 => 0xf },
	'standardrawhighlight' => { 115 => 0x75 },
	'standardrawhighlightpoint' => { 115 => 0x12 },
	'standardrawlinear' => { 115 => 0x10 },
	'standardrawsaturation' => { 115 => 0xe },
	'standardrawshadow' => { 115 => 0x7e },
	'standardrawshadowpoint' => { 115 => 0x13 },
	'standardrawsharpness' => { 115 => 0x11 },
	'standardunsharpmaskfineness' => { 115 => 0x94 },
	'standardunsharpmaskstrength' => { 115 => 0x92 },
	'standardunsharpmaskthreshold' => { 115 => 0x96 },
	'standardwhitecustom' => { 145 => 0x838 },
	'standardwhitedaylight' => { 145 => 0x834 },
	'standardwhiteflash' => { 145 => 0x837 },
	'standardwhitefluorescent' => { 145 => 0x836 },
	'standardwhitetungsten' => { 145 => 0x835 },
	'standbytimer' => { 310 => '19.1', 312 => '19.1', 313 => '19.1', 316 => '18.1', 317 => '18.1', 322 => '19.1', 323 => '19.1' },
	'starlightview' => { 326 => 0x249, 327 => 0x249, 328 => 0x261 },
	'startingpage' => { 542 => 'startingPage' },
	'startmovieshooting' => { 90 => 0x70d },
	'starttimecode' => { 416 => "\xa9TIM", 552 => 'startTimecode' },
	'starttimecodetimeformat' => { 552 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 552 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 552 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 416 => "\xa9TSZ", 552 => 'startTimeSampleSize' },
	'starttimescale' => { 416 => "\xa9TSC", 552 => 'startTimeScale' },
	'state' => { 168 => 'State', 354 => 0x6b, 540 => 'State' },
	'status' => { 501 => 'Status', 515 => 'Status' },
	'stereomode' => { 510 => 'StereoMode' },
	'stitched' => { 510 => 'Stitched' },
	'stitchingsoftware' => { 509 => 'StitchingSoftware', 510 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 467 => 0x113e, 468 => 0x113e, 469 => 0x111a, 470 => 0x1196, 471 => 0x1172, 472 => 0x102a, 473 => 0x222, 474 => 0x222, 475 => 0x217, 490 => 0xa },
	'storagemethod' => { 195 => 0x12 },
	'storebyorientation' => { 310 => '46.3', 312 => '47.3', 313 => '47.3', 322 => '47.3', 323 => '47.3', 325 => 0xd, 326 => 0xd, 327 => 0xd, 328 => 0xd },
	'storedescription' => { 408 => 'sdes' },
	'storedformat' => { 518 => 'StoredFormat' },
	'storylineidentifier' => { 537 => 'StorylineIdentifier' },
	'straightenangle' => { 302 => 0x2fc08431 },
	'streamready' => { 537 => 'StreamReady' },
	'streamtype' => { 183 => 'StreamType' },
	'stretchmode' => { 552 => 'stretchMode' },
	'studydatetime' => { 498 => 'StudyDateTime' },
	'studydescription' => { 498 => 'StudyDescription' },
	'studyid' => { 498 => 'StudyID' },
	'studyphysician' => { 498 => 'StudyPhysician' },
	'styleperiod' => { 537 => 'StylePeriod' },
	'sub-location' => { 138 => 0x5c },
	'subcommanddialframeadvancezoom' => { 253 => 0x806 },
	'subcommanddialplaybackmode' => { 326 => 0x1cf, 327 => 0x1cf, 328 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 326 => 0x1d1, 328 => 0x1e9 },
	'subfiledata' => { 171 => 'data' },
	'subfiledirectory' => { 171 => '1Directory' },
	'subfilemimetype' => { 171 => '2MIME' },
	'subfilename' => { 171 => '1Name' },
	'subfileresource' => { 171 => 'rsrc' },
	'subfiletype' => { 125 => 0xfe, 171 => '0Type' },
	'subject' => { 339 => 'Subject', 406 => 'Subject', 526 => 'subject', 539 => 'Subject', 553 => 'subject' },
	'subjectarea' => { 125 => 0x9214, 529 => 'SubjectArea' },
	'subjectcode' => { 536 => 'SubjectCode' },
	'subjectdetection' => { 247 => 0x36e, 249 => 0x252, 250 => 0x252, 251 => 0x23e, 252 => 0x252, 253 => 0x252 },
	'subjectdetectionareamf' => { 247 => 0x3ea },
	'subjectdistance' => { 125 => 0x9206, 147 => 0x3e, 529 => 'SubjectDistance' },
	'subjectdistancerange' => { 125 => 0xa40c, 529 => 'SubjectDistanceRange' },
	'subjectlocation' => { 125 => 0xa214, 529 => 'SubjectLocation' },
	'subjectmotion' => { 312 => '78.2', 313 => '78.2', 323 => '78.2', 326 => 0x103, 327 => 0x103, 328 => 0x119 },
	'subjectprogram' => { 188 => 0x22 },
	'subjectreference' => { 138 => 0xc },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 535 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 535 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 120 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 120 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 120 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 125 => 0x9290 },
	'subsectimedigitized' => { 125 => 0x9292 },
	'subsectimeoriginal' => { 125 => 0x9291 },
	'subsection1' => { 542 => 'subsection1' },
	'subsection2' => { 542 => 'subsection2' },
	'subsection3' => { 542 => 'subsection3' },
	'subsection4' => { 542 => 'subsection4' },
	'subselector' => { 310 => '49.1', 312 => '71.1', 313 => '71.1', 323 => '71.1', 325 => 0x93, 326 => 0x8f, 327 => 0x8f, 328 => 0x8f },
	'subselectorassignment' => { 310 => '48.1' },
	'subselectorcenter' => { 312 => '72.1', 313 => '72.1', 323 => '72.1' },
	'subselectorplusdials' => { 310 => '49.2', 312 => '73.1', 313 => '73.1', 323 => '73.1' },
	'subtitle' => { 186 => 'WM/SubTitle', 408 => "\xa9st3", 416 => "\xa9snm", 542 => 'subtitle' },
	'subtitlekeywords' => { 416 => "\xa9snk" },
	'subversionfilename' => { 535 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 535 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 535 => 'SubVersions' },
	'superimposeddisplay' => { 88 => 0xa, 90 => 0x510, 91 => 0x9, 92 => 0xa, 95 => 0xa, 96 => 0xe },
	'supermacro' => { 69 => 0x1a },
	'supplementalcategories' => { 138 => 0x14, 540 => 'SupplementalCategories' },
	'supplementaltype' => { 140 => 0x37 },
	'supplementdisplayid' => { 542 => 'supplementDisplayID' },
	'supplementstartingpage' => { 542 => 'supplementStartingPage' },
	'supplementtitle' => { 542 => 'supplementTitle' },
	'supplychainsource' => { 537 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 537 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 537 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 523 => 'SupportsAmount', 525 => 'SupportsAmount' },
	'supportscolor' => { 523 => 'SupportsColor', 525 => 'SupportsColor' },
	'supportshighdynamicrange' => { 523 => 'SupportsHighDynamicRange', 525 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 523 => 'SupportsMonochrome', 525 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 523 => 'SupportsNormalDynamicRange', 525 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 523 => 'SupportsOutputReferred', 525 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 523 => 'SupportsSceneReferred', 525 => 'SupportsSceneReferred' },
	'svisosetting' => { 370 => 0x14 },
	'swatchcoloranta' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 557 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 557 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 557 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 557 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 557 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 354 => 0x93, 446 => 0x33 },
	'sweeppanoramafieldofview' => { 354 => 0x94 },
	'sweeppanoramasize' => { 446 => 0x32 },
	'switchtoregisteredafpoint' => { 89 => 0x12, 90 => 0x50a },
	'symlink' => { 126 => 'SymLink' },
	'syncreleasemode' => { 312 => '77.1', 313 => '77.1', 323 => '77.1', 325 => 0x45, 326 => 0x41, 327 => 0x41, 328 => 0x41 },
	'system' => { 399 => 0x204 },
	'tagged' => { 401 => 0xdd, 402 => 'Tagged', 517 => 'tagged' },
	'tagslist' => { 528 => 'TagsList' },
	'tagstructure' => { 535 => 'TagStructure' },
	'takenumber' => { 552 => 'takeNumber' },
	'tapename' => { 552 => 'tapeName' },
	'targetaperture' => { 82 => 0x4 },
	'targetaspectratio' => { 344 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 101 => 0x1 },
	'targetdistancesetting' => { 103 => 0x1807 },
	'targetexposuretime' => { 82 => 0x5 },
	'targetimagetype' => { 103 => 0x100a },
	'targetprinter' => { 125 => 0x151 },
	'taxon' => { 124 => 'Taxon' },
	'taxonacceptednameusage' => { 124 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 124 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 124 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 124 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 124 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 124 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 124 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 124 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 124 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 124 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 124 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 124 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 124 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 124 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 124 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 124 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 124 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 124 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 124 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 124 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 124 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 124 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 124 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 124 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 124 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 124 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 124 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 124 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 124 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 124 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 124 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 124 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 124 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 124 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 145 => 0x196f },
	'tda1edgepolarity' => { 145 => 0x1971 },
	'tda1gain' => { 145 => 0x1970 },
	'tda1offset' => { 145 => 0x196e },
	'tda2bandwidth' => { 145 => 0x1979 },
	'tda2edgepolarity' => { 145 => 0x197b },
	'tda2gain' => { 145 => 0x197a },
	'tda2offset' => { 145 => 0x1978 },
	'tda3bandwidth' => { 145 => 0x1983 },
	'tda3edgepolarity' => { 145 => 0x1985 },
	'tda3gain' => { 145 => 0x1984 },
	'tda3offset' => { 145 => 0x1982 },
	'tda4bandwidth' => { 145 => 0x198d },
	'tda4edgepolarity' => { 145 => 0x198f },
	'tda4gain' => { 145 => 0x198e },
	'tda4offset' => { 145 => 0x198c },
	'teaser' => { 542 => 'teaser' },
	'teleconverter' => { 193 => 0x105, 458 => 0x105 },
	'tempampgainx100' => { 145 => 0x1914 },
	'tempo' => { 552 => 'tempo' },
	'temporalcoverage' => { 537 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 537 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 537 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 340 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 340 => 'TermsAndConditionsURL' },
	'testname' => { 126 => 'TestName' },
	'textencoding' => { 242 => 0x4 },
	'textlayername' => { 540 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 540 => 'TextLayers' },
	'textlayertext' => { 540 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 354 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 523 => 'Texture', 525 => 'Texture' },
	'three-dtrackingfacedetection' => { 312 => '1.4', 313 => '1.4', 323 => '1.4' },
	'three-dtrackingwatcharea' => { 312 => '78.1', 313 => '78.1', 323 => '78.1' },
	'thresholding' => { 125 => 0x107 },
	'thumbnailfilename' => { 103 => 0x817 },
	'thumbnailformat' => { 550 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 149 => 0xfa55, 550 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 103 => 0x2008, 120 => 'Exif-ThumbnailImage', 128 => 0x3, 174 => 'data', 335 => 0x100, 408 => 'tnal', 416 => 'thmb', 550 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 174 => '1Name' },
	'thumbnailimagesize' => { 174 => 'ImageSize' },
	'thumbnailimagetype' => { 174 => '0Type' },
	'thumbnailimagevalidarea' => { 69 => 0x13 },
	'thumbnaillength' => { 125 => 0x202 },
	'thumbnailoffset' => { 125 => 0x201 },
	'thumbnailpng' => { 416 => 'thmb' },
	'thumbnails' => { 550 => 'Thumbnails' },
	'thumbnailwidth' => { 149 => 0xfa54, 550 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 542 => 'ticker' },
	'tiffhandling' => { 523 => 'TIFFHandling', 525 => 'TIFFHandling' },
	'tiffmeteringimage' => { 194 => 0x104c, 455 => 0x1110 },
	'tilelength' => { 125 => 0x143 },
	'tilewidth' => { 125 => 0x142 },
	'time' => { 145 => 0x401, 390 => 0x7 },
	'timecodes' => { 125 => 0xc763 },
	'timecreated' => { 138 => 0x3c, 147 => 0x14, 156 => 0x10, 402 => 'TimeCreated' },
	'timelapseshotnumber' => { 357 => 0x10 },
	'timeperiod' => { 542 => 'timePeriod' },
	'timerfunctionbutton' => { 311 => '5.2', 314 => '12.1', 315 => '13.1' },
	'timerlength' => { 90 => 0x80c },
	'timerrecording' => { 354 => 0x96 },
	'timescaleparams' => { 552 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 552 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 552 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 552 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 139 => 0x50 },
	'timeshot' => { 511 => 'TimeShot' },
	'timesignature' => { 552 => 'timeSignature' },
	'timesincepoweron' => { 354 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 329 => 0x8, 343 => 'TimeStamp', 354 => 0xaf, 510 => 'Timestamp', 519 => 'Timestamp', 535 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 83 => 0x1, 247 => 0x8fe, 249 => 0x694, 250 => 0x6a4, 251 => 0x594, 252 => 0x5c4, 253 => 0x5dc, 294 => 0x0, 427 => 0xa },
	'timezonecity' => { 83 => 0x2 },
	'timezonecode' => { 106 => 0x1 },
	'timezoneinfo' => { 106 => 0x2 },
	'timezoneoffset' => { 125 => 0x882a },
	'tint' => { 410 => 'player.movie.visual.tint', 523 => 'Tint', 525 => 'Tint' },
	'title' => { 164 => 'Title', 339 => 'Title', 343 => 'Title', 354 => 0x65, 406 => 'Title', 408 => ['titl',"\xa9nam"], 410 => 'title', 416 => ['titl',"\xa9nam"], 526 => 'title', 539 => 'Title', 550 => 'Title' },
	'togglestyleamount' => { 523 => 'ToggleStyleAmount', 525 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 523 => 'ToggleStyleDigest', 525 => 'ToggleStyleDigest' },
	'tonecomp' => { 243 => 0x81 },
	'tonecurve' => { 79 => 0x1, 390 => 0x402, 523 => 'ToneCurve', 525 => 'ToneCurve' },
	'tonecurveactive' => { 114 => 0x110 },
	'tonecurveadobergb' => { 431 => 0xa043 },
	'tonecurveadobergbdefault' => { 431 => 0xa041 },
	'tonecurveblue' => { 523 => 'ToneCurveBlue', 525 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 495 => 0x9003 },
	'tonecurvebluey' => { 495 => 0x9007 },
	'tonecurvebrightness' => { 109 => 0x20410 },
	'tonecurvebrightnessx' => { 495 => 0x9000 },
	'tonecurvebrightnessy' => { 495 => 0x9004 },
	'tonecurvecolorspace' => { 113 => 0x0 },
	'tonecurvecontrast' => { 109 => 0x20411 },
	'tonecurvegreen' => { 523 => 'ToneCurveGreen', 525 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 495 => 0x9002 },
	'tonecurvegreeny' => { 495 => 0x9006 },
	'tonecurveinputrange' => { 113 => 0x3 },
	'tonecurveinterpolation' => { 114 => 0x159 },
	'tonecurvemode' => { 114 => 0x113 },
	'tonecurvename' => { 523 => 'ToneCurveName', 525 => 'ToneCurveName' },
	'tonecurvename2012' => { 523 => 'ToneCurveName2012', 525 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 109 => '0x20400.1' },
	'tonecurveoutputrange' => { 113 => 0x5 },
	'tonecurveprofilename' => { 145 => 0x1391 },
	'tonecurveproperty' => { 114 => 0x3c },
	'tonecurvepv2012' => { 523 => 'ToneCurvePV2012', 525 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 523 => 'ToneCurvePV2012Blue', 525 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 523 => 'ToneCurvePV2012Green', 525 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 523 => 'ToneCurvePV2012Red', 525 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 523 => 'ToneCurveRed', 525 => 'ToneCurveRed' },
	'tonecurveredx' => { 495 => 0x9001 },
	'tonecurveredy' => { 495 => 0x9005 },
	'tonecurves' => { 390 => 0x403 },
	'tonecurveshape' => { 113 => 0x1 },
	'tonecurvesrgb' => { 431 => 0xa042 },
	'tonecurvesrgbdefault' => { 431 => 0xa040 },
	'tonecurvex' => { 113 => 0xa },
	'tonecurvey' => { 113 => 0xb },
	'tonelevel' => { 330 => 0x52e },
	'tonemap' => { 247 => 0x374, 249 => 0x26a, 250 => 0x26a },
	'tonemapstrength' => { 523 => 'ToneMapStrength', 525 => 'ToneMapStrength' },
	'toningeffect' => { 61 => 0xf, 243 => 0xb3, 260 => 0x38, 261 => 0x40, 262 => 0x48, 424 => 0x1015 },
	'toningeffectauto' => { 76 => 0xa4 },
	'toningeffectfaithful' => { 75 => 0x74, 76 => 0x74 },
	'toningeffectlandscape' => { 75 => 0x44, 76 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 75 => 0x8c, 76 => 0x8c },
	'toningeffectneutral' => { 75 => 0x5c, 76 => 0x5c },
	'toningeffectportrait' => { 75 => 0x2c, 76 => 0x2c },
	'toningeffectstandard' => { 75 => 0x14, 76 => 0x14 },
	'toningeffectuserdef1' => { 75 => 0xa4, 76 => 0xbc },
	'toningeffectuserdef2' => { 75 => 0xbc, 76 => 0xd4 },
	'toningeffectuserdef3' => { 75 => 0xd4, 76 => 0xec },
	'toningsaturation' => { 260 => 0x39, 261 => 0x41, 262 => 0x49 },
	'totalzoom' => { 147 => 0x62 },
	'touchae' => { 354 => 0xab },
	'touchfn' => { 325 => 0x154 },
	'touchfnareatall' => { 325 => 0x15b },
	'touchfnareawide' => { 325 => 0x159 },
	'touchfnrole' => { 325 => 0x155 },
	'track' => { 408 => "\xa9trk", 416 => "\xa9trk" },
	'trackcreatedate' => { 415 => 0x1 },
	'trackmodifydate' => { 415 => 0x2 },
	'tracknumber' => { 408 => 'trkn', 552 => 'trackNumber' },
	'tracks' => { 552 => 'Tracks' },
	'tracksframerate' => { 552 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 552 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 552 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 552 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 552 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 552 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 552 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 552 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 552 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 552 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 552 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 552 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 552 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 552 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 552 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 552 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 552 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 416 => 'kgtt' },
	'trailer' => { 126 => 'Trailer' },
	'trailersignature' => { 171 => 'zmie' },
	'transcript' => { 537 => 'Transcript' },
	'transcriptlink' => { 537 => 'TranscriptLink' },
	'transcriptlinklink' => { 537 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 537 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 125 => 0x12d, 548 => 'TransferFunction' },
	'transfertimenormal' => { 145 => 0x1888 },
	'transfertimetest' => { 145 => 0x1889 },
	'transform' => { 354 => [0x8012,0x59] },
	'transformation' => { 538 => 'Transformation' },
	'transmissionreference' => { 540 => 'TransmissionReference' },
	'trapped' => { 339 => 'Trapped', 539 => 'Trapped' },
	'trashbuttonfunction' => { 90 => 0x710 },
	'travelday' => { 354 => 0x36 },
	'treble' => { 407 => 'player.movie.audio.treble', 410 => 'player.movie.audio.treble' },
	'triggermode' => { 418 => 0x6, 419 => 0x34, 420 => 0x34 },
	'tstop' => { 125 => 0xc772 },
	'ttl_da_adown' => { 377 => 0x5 },
	'ttl_da_aup' => { 377 => 0x4 },
	'ttl_da_bdown' => { 377 => 0x7 },
	'ttl_da_bup' => { 377 => 0x6 },
	'tungstenawb' => { 367 => 0x1 },
	'tvepisode' => { 408 => 'tves' },
	'tvepisodeid' => { 408 => 'tven' },
	'tvexposuretimesetting' => { 370 => 0x12 },
	'tvnetworkname' => { 408 => 'tvnn' },
	'tvseason' => { 408 => 'tvsn' },
	'tvshow' => { 408 => 'tvsh' },
	'type' => { 505 => 'Type', 526 => 'type', 547 => 'type' },
	'typestatus' => { 124 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 125 => 0xc614 },
	'uniquedocumentid' => { 138 => 0xbb },
	'uniquematrixauto' => { 145 => 0x7e9 },
	'uniquematrixcustom' => { 145 => 0x7e8 },
	'uniquematrixdaylight' => { 145 => 0x7e4 },
	'uniquematrixflash' => { 145 => 0x7e7 },
	'uniquematrixfluorescent' => { 145 => 0x7e6 },
	'uniquematrixtungsten' => { 145 => 0x7e5 },
	'uniqueobjectname' => { 139 => 0x64 },
	'units' => { 506 => 'Units' },
	'unknown_aacr' => { 408 => 'AACR' },
	'unknown_cdek' => { 408 => 'CDEK' },
	'unknown_cdet' => { 408 => 'CDET' },
	'unknownblock' => { 390 => 0x405 },
	'unknownblock1' => { 334 => 0x635 },
	'unknownblock2' => { 334 => 0x636 },
	'unknownblock3' => { 334 => 0x1103 },
	'unknownblock4' => { 334 => 0x1104 },
	'unknowncontrast' => { 115 => 0x45 },
	'unknowndate' => { 399 => 0x212 },
	'unknownev' => { 145 => 0x1 },
	'unknownlinear' => { 115 => 0x46 },
	'unknownnumber' => { 103 => 0x180b },
	'unknownoutputhighlightpoint' => { 115 => 0x4a },
	'unknownoutputshadowpoint' => { 115 => 0x4b },
	'unknownrawhighlight' => { 115 => 0x7b },
	'unknownrawhighlightpoint' => { 115 => 0x48 },
	'unknownrawshadow' => { 115 => 0x84 },
	'unknownrawshadowpoint' => { 115 => 0x49 },
	'unknownsharpness' => { 115 => 0x47 },
	'unknowntags' => { 416 => 'TAGS' },
	'unknowntemperature' => { 127 => 0x4 },
	'unknownthumbnail' => { 416 => 'thmb' },
	'unsharp1color' => { 307 => 0x13 },
	'unsharp1halowidth' => { 307 => 0x19 },
	'unsharp1intensity' => { 307 => 0x17 },
	'unsharp1threshold' => { 307 => 0x1b },
	'unsharp2color' => { 307 => 0x2e },
	'unsharp2halowidth' => { 307 => 0x34 },
	'unsharp2intensity' => { 307 => 0x32 },
	'unsharp2threshold' => { 307 => 0x36 },
	'unsharp3color' => { 307 => 0x49 },
	'unsharp3halowidth' => { 307 => 0x4f },
	'unsharp3intensity' => { 307 => 0x4d },
	'unsharp3threshold' => { 307 => 0x51 },
	'unsharp4color' => { 307 => 0x64 },
	'unsharp4halowidth' => { 307 => 0x6a },
	'unsharp4intensity' => { 307 => 0x68 },
	'unsharp4threshold' => { 307 => 0x6c },
	'unsharpcount' => { 307 => 0x0 },
	'unsharpmask' => { 115 => 0x90, 302 => 0x76a43200 },
	'unsharpmaskfineness' => { 79 => 0xe, 109 => 0x20309 },
	'unsharpmaskstrength' => { 109 => 0x20308 },
	'unsharpmaskthreshold' => { 79 => 0xf, 109 => 0x2030a },
	'uprightcentermode' => { 523 => 'UprightCenterMode', 525 => 'UprightCenterMode' },
	'uprightcenternormx' => { 523 => 'UprightCenterNormX', 525 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 523 => 'UprightCenterNormY', 525 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 523 => 'UprightDependentDigest', 525 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 523 => 'UprightFocalLength35mm', 525 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 523 => 'UprightFocalMode', 525 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 523 => 'UprightFourSegments_0', 525 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 523 => 'UprightFourSegments_1', 525 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 523 => 'UprightFourSegments_2', 525 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 523 => 'UprightFourSegments_3', 525 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 523 => 'UprightFourSegmentsCount', 525 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 523 => 'UprightGuidedDependentDigest', 525 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 523 => 'UprightPreview', 525 => 'UprightPreview' },
	'uprighttransform_0' => { 523 => 'UprightTransform_0', 525 => 'UprightTransform_0' },
	'uprighttransform_1' => { 523 => 'UprightTransform_1', 525 => 'UprightTransform_1' },
	'uprighttransform_2' => { 523 => 'UprightTransform_2', 525 => 'UprightTransform_2' },
	'uprighttransform_3' => { 523 => 'UprightTransform_3', 525 => 'UprightTransform_3' },
	'uprighttransform_4' => { 523 => 'UprightTransform_4', 525 => 'UprightTransform_4' },
	'uprighttransform_5' => { 523 => 'UprightTransform_5', 525 => 'UprightTransform_5' },
	'uprighttransformcount' => { 523 => 'UprightTransformCount', 525 => 'UprightTransformCount' },
	'uprightversion' => { 523 => 'UprightVersion', 525 => 'UprightVersion' },
	'urgency' => { 138 => 0xa, 540 => 'Urgency' },
	'url' => { 164 => 'URL', 343 => 'URL', 404 => 0x40b, 542 => 'url' },
	'url_list' => { 404 => 0x41e },
	'urla-platform' => { 542 => [\'url','urlA-platform'] },
	'urlurl' => { 542 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 90 => 0x10a },
	'usableshootingmodes' => { 90 => 0x109 },
	'usage' => { 543 => 'usage' },
	'usageterms' => { 556 => 'UsageTerms' },
	'usbpowerdelivery' => { 247 => 0x9ac, 249 => 0x762, 250 => 0x772, 251 => 0x664, 252 => 0x694, 253 => 0x6fc },
	'usedialwithouthold' => { 325 => 0xc3, 326 => 0xbf, 327 => 0xbf, 328 => 0xbf },
	'useguidelines' => { 521 => 'useGuidelines' },
	'usepanoramaviewer' => { 509 => 'UsePanoramaViewer' },
	'usercollection' => { 410 => 'collection.user' },
	'usercomment' => { 103 => 0x805, 125 => 0x9286, 529 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 75 => 0xd8, 76 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 75 => 0xda, 76 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 75 => 0xdc, 76 => 0xf4 },
	'userfields' => { 515 => 'UserFields' },
	'userlabel' => { 418 => 0x2b, 419 => 0x5a, 420 => 0x68 },
	'userprofile' => { 349 => 0x302, 353 => 0x34c, 356 => 0x3038 },
	'userrating' => { 410 => 'rating.user', 416 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 89 => 0x7, 90 => 0x501 },
	'uspsnumber' => { 542 => 'uspsNumber' },
	'utmeasting' => { 175 => 'Easting' },
	'utmmapdatum' => { 175 => 'Datum' },
	'utmnorthing' => { 175 => 'Northing' },
	'utmzone' => { 175 => 'Zone' },
	'uuid' => { 523 => 'UUID', 525 => 'UUID' },
	'uv-irfiltercorrection' => { 349 => 0x325 },
	'validbits' => { 334 => 0x611, 335 => 0x102c },
	'validcropcorners' => { 344 => 'ValidCropCorners' },
	'validpixeldepth' => { 338 => 0x611 },
	'variablelowpassfilter' => { 458 => 0x2028 },
	'variousmodes' => { 147 => 0x26 },
	'variousmodes2' => { 147 => 0x3a },
	'variprogram' => { 243 => 0xab },
	'varraydacnominalvalues' => { 145 => 0x191e },
	'vendor' => { 416 => 'vndr' },
	'vendorinfo' => { 499 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 499 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 499 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 499 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 124 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 133 => 0x0, 344 => 'Version', 406 => 'Version', 410 => 'version', 523 => 'Version', 525 => 'Version', 534 => 'Version' },
	'versioncreatedate' => { 495 => 0xd100 },
	'versionid' => { 553 => 'VersionID' },
	'versionidentifier' => { 542 => 'versionIdentifier' },
	'versionmodifydate' => { 495 => 0xd101 },
	'versions' => { 553 => 'Versions' },
	'versionscomments' => { 553 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 553 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 553 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 553 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 553 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 553 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 553 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 553 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 553 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 553 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 553 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 309 => '3.2', 310 => '47.2', 312 => '79.1', 327 => 0x11d, 328 => 0x135 },
	'verticalclockoverlaps' => { 145 => 0x412 },
	'verticalfuncbutton' => { 310 => '42.2', 312 => '67.1', 327 => 0x115, 328 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 327 => 0x1b7, 328 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 310 => '43.1' },
	'verticalfuncplusdials' => { 312 => '68.1' },
	'verticalisobutton' => { 253 => 0x792 },
	'verticalmovieafonbutton' => { 327 => 0x1f9, 328 => 0x211 },
	'verticalmoviefuncbutton' => { 327 => 0x1e1, 328 => 0x1f9 },
	'verticalmultiselector' => { 310 => '42.1', 312 => '66.1', 313 => '66.1', 323 => '66.1', 327 => 0x18f, 328 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 327 => 0x125, 328 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 90 => [0x510,0x51d] },
	'vibrance' => { 516 => 'Vibrance', 523 => 'Vibrance', 525 => 'Vibrance' },
	'vibrationreduction' => { 273 => [0x75,0x82,0x1ae], 281 => '586.1', 288 => '590.2', 292 => 0x4 },
	'videoalphamode' => { 552 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 552 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 552 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 552 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 537 => 'videoBitRate' },
	'videobitratemode' => { 537 => 'videoBitRateMode' },
	'videoburstmode' => { 354 => 0xbb },
	'videoburstresolution' => { 354 => 0xb3 },
	'videocodec' => { 72 => 0x74 },
	'videocolorspace' => { 552 => 'videoColorSpace' },
	'videocompression' => { 133 => 0x3806 },
	'videocompressor' => { 552 => 'videoCompressor' },
	'videodisplayaspectratio' => { 537 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 537 => 'videoEncodingProfile' },
	'videofieldorder' => { 552 => 'videoFieldOrder' },
	'videoframerate' => { 354 => 0x27, 552 => 'videoFrameRate' },
	'videoframesize' => { 552 => 'videoFrameSize' },
	'videoframesizeh' => { 552 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 552 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 552 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 552 => 'videoModDate' },
	'videopixelaspectratio' => { 552 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 552 => 'videoPixelDepth' },
	'videopreburst' => { 354 => 0xc1 },
	'videoquality' => { 119 => 0x4003 },
	'videorecordingmode' => { 133 => 0x3803 },
	'videoshottype' => { 537 => 'VideoShotType' },
	'videoshottypeidentifier' => { 537 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 537 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 537 => 'videoStreamsCount' },
	'viewfinder' => { 399 => 0x455 },
	'viewfinderdisplay' => { 309 => '12.4', 310 => '6.3' },
	'viewfinderwarning' => { 309 => '13.4', 319 => '3.5', 320 => '6.2', 324 => '4.4' },
	'viewfinderwarnings' => { 90 => 0x40a },
	'viewinfoduringexposure' => { 90 => 0x407 },
	'viewingmode' => { 446 => 0x2f, 463 => 0x18 },
	'viewingmode2' => { 446 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 253 => 0x7d2, 326 => 0x2a9 },
	'viewpoint' => { 541 => 'viewpoint' },
	'vignetteamount' => { 523 => 'VignetteAmount', 525 => 'VignetteAmount' },
	'vignettecoefficient1' => { 293 => 0x24 },
	'vignettecoefficient2' => { 293 => 0x34 },
	'vignettecoefficient3' => { 293 => 0x44 },
	'vignettecontrol' => { 243 => 0x2a, 302 => 0x76a43205 },
	'vignettecontrolintensity' => { 302 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 520 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 293 => 0x0 },
	'vignettemidpoint' => { 523 => 'VignetteMidpoint', 525 => 'VignetteMidpoint' },
	'vignetting' => { 424 => 0x1011, 431 => 0xa052 },
	'vignettingcorrection' => { 125 => 0x7031, 431 => 0xa053, 458 => 0x2011 },
	'vignettingcorrparams' => { 125 => 0x7032, 489 => 0x64a, 490 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 431 => 0xa054 },
	'virtualfocallength' => { 538 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 325 => 0x161, 326 => 0x167, 327 => 0x167, 328 => 0x17f },
	'virtualimagexcenter' => { 538 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 538 => 'VirtualImageYCenter' },
	'visualcolor' => { 537 => 'VisualColour' },
	'visualtechnique' => { 541 => 'visualTechnique' },
	'voicememo' => { 433 => 0x216 },
	'volume' => { 542 => 'volume' },
	'vr_0x66' => { 273 => 0x66 },
	'vrdoffset' => { 69 => 0xd0 },
	'vrmode' => { 247 => 0x342, 249 => 0x226, 250 => 0x226, 251 => 0x212, 252 => 0x226, 253 => 0x226, 292 => 0x6 },
	'vrtype' => { 292 => 0x8 },
	'waterdepth' => { 125 => 0x9403, 530 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 194 => 0x19a },
	'wb_bluelevel6500k' => { 194 => 0x18a },
	'wb_bluelevelcustom' => { 194 => 0x18e },
	'wb_bluelevelscloudy' => { 194 => 0x106 },
	'wb_bluelevelsdaylight' => { 194 => 0xea },
	'wb_bluelevelsflash' => { 194 => 0x122 },
	'wb_bluelevelsfluorescent' => { 194 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 194 => 0x254 },
	'wb_bluelevelsshade' => { 194 => 0x176 },
	'wb_bluelevelstungsten' => { 194 => 0xce },
	'wb_gbrglevels' => { 194 => 0xae, 197 => 0x4 },
	'wb_glevel' => { 334 => 0x11f },
	'wb_glevel3000k' => { 334 => 0x113 },
	'wb_glevel3300k' => { 334 => 0x114 },
	'wb_glevel3600k' => { 334 => 0x115 },
	'wb_glevel3900k' => { 334 => 0x116 },
	'wb_glevel4000k' => { 334 => 0x117 },
	'wb_glevel4300k' => { 334 => 0x118 },
	'wb_glevel4500k' => { 334 => 0x119 },
	'wb_glevel4800k' => { 334 => 0x11a },
	'wb_glevel5300k' => { 334 => 0x11b },
	'wb_glevel6000k' => { 334 => 0x11c },
	'wb_glevel6600k' => { 334 => 0x11d },
	'wb_glevel7500k' => { 334 => 0x11e },
	'wb_grbglevels' => { 211 => 0x0, 465 => 0x7303 },
	'wb_grbglevelsauto' => { 86 => 0x2, 465 => 0x7302 },
	'wb_grbglevelscloudy' => { 86 => 0x12 },
	'wb_grbglevelscustom1' => { 86 => 0x42 },
	'wb_grbglevelscustom2' => { 86 => 0x4a },
	'wb_grbglevelsdaylight' => { 86 => 0xa },
	'wb_grbglevelsflash' => { 86 => 0x32 },
	'wb_grbglevelsfluorescent' => { 86 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 86 => 0x2a },
	'wb_grbglevelstungsten' => { 86 => 0x1a },
	'wb_grbglevelsunderwater' => { 86 => 0x3a },
	'wb_rbgglevels' => { 208 => 0x0 },
	'wb_rblevels' => { 212 => 0x270, 243 => 0xc, 334 => 0x100 },
	'wb_rblevels1' => { 360 => 0x2 },
	'wb_rblevels2' => { 360 => 0x5 },
	'wb_rblevels3' => { 360 => 0x8 },
	'wb_rblevels3000k' => { 334 => 0x102 },
	'wb_rblevels3300k' => { 334 => 0x103 },
	'wb_rblevels3500k' => { 194 => 0x430 },
	'wb_rblevels3600k' => { 334 => 0x104 },
	'wb_rblevels3900k' => { 334 => 0x105 },
	'wb_rblevels4' => { 360 => 0xb },
	'wb_rblevels4000k' => { 334 => 0x106 },
	'wb_rblevels4300k' => { 334 => 0x107 },
	'wb_rblevels4500k' => { 334 => 0x108 },
	'wb_rblevels4800k' => { 334 => 0x109 },
	'wb_rblevels5' => { 360 => 0xe },
	'wb_rblevels5300k' => { 334 => 0x10a },
	'wb_rblevels6' => { 360 => 0x11 },
	'wb_rblevels6000k' => { 334 => 0x10b },
	'wb_rblevels6500k' => { 194 => 0x420 },
	'wb_rblevels6600k' => { 334 => 0x10c },
	'wb_rblevels7' => { 360 => 0x14 },
	'wb_rblevels7500k' => { 334 => 0x10d },
	'wb_rblevelsauto' => { 212 => 0x272, 338 => 0x110 },
	'wb_rblevelscloudy' => { 194 => 0x3f0, 196 => 0x10, 212 => 0x296, 338 => 0x121 },
	'wb_rblevelscoolwhitef' => { 194 => 0x308, 196 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 338 => 0x132 },
	'wb_rblevelscustom' => { 194 => 0x424, 196 => 0x1c },
	'wb_rblevelscwb1' => { 334 => 0x10e },
	'wb_rblevelscwb2' => { 334 => 0x10f },
	'wb_rblevelscwb3' => { 334 => 0x110 },
	'wb_rblevelscwb4' => { 334 => 0x111 },
	'wb_rblevelsdaylight' => { 194 => [0x3ec,0x528], 196 => 0xc, 212 => 0x274 },
	'wb_rblevelsdaylightf' => { 196 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 338 => 0x130 },
	'wb_rblevelsdaywhitef' => { 196 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 338 => 0x131 },
	'wb_rblevelseveningsunlight' => { 338 => 0x124 },
	'wb_rblevelsfineweather' => { 338 => 0x122 },
	'wb_rblevelsflash' => { 194 => [0x3f4,0x304], 196 => 0x18, 212 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 212 => 0x290 },
	'wb_rblevelsincandescent' => { 212 => 0x282 },
	'wb_rblevelsshade' => { 194 => 0x418, 196 => 0x20, 212 => 0x2b2, 338 => 0x120 },
	'wb_rblevelstungsten' => { 194 => 0x3e8, 196 => 0x8, 338 => 0x123 },
	'wb_rblevelsused' => { 338 => 0x100 },
	'wb_rblevelswhitef' => { 196 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 338 => 0x133 },
	'wb_redlevel3500k' => { 194 => 0x198 },
	'wb_redlevel6500k' => { 194 => 0x188 },
	'wb_redlevelcustom' => { 194 => 0x18c },
	'wb_redlevelscloudy' => { 194 => 0xf8 },
	'wb_redlevelsdaylight' => { 194 => 0xdc },
	'wb_redlevelsflash' => { 194 => 0x114 },
	'wb_redlevelsfluorescent' => { 194 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 194 => 0x1be },
	'wb_redlevelsshade' => { 194 => 0x168 },
	'wb_redlevelstungsten' => { 194 => 0xc0 },
	'wb_rgbglevels' => { 210 => 0x0 },
	'wb_rgblevels' => { 194 => [0x546,0x96], 350 => 0xd, 351 => 0x413, 356 => 0x3036, 399 => 0x107, 467 => 0x117c, 468 => 0x1180, 469 => 0x115c, 470 => 0x11d8, 471 => 0x11b4, 472 => 0x106c, 473 => 0x264, 474 => 0x264, 475 => 0x252 },
	'wb_rgblevels1' => { 361 => 0x2 },
	'wb_rgblevels2' => { 361 => 0x6 },
	'wb_rgblevels2500k' => { 465 => 0x782d },
	'wb_rgblevels3' => { 361 => 0xa },
	'wb_rgblevels3200k' => { 465 => 0x782c },
	'wb_rgblevels4' => { 361 => 0xe },
	'wb_rgblevels4500k' => { 465 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 361 => 0x12 },
	'wb_rgblevels6' => { 361 => 0x16 },
	'wb_rgblevels6000k' => { 465 => 0x782b },
	'wb_rgblevels7' => { 361 => 0x1a },
	'wb_rgblevels8500k' => { 465 => 0x782a },
	'wb_rgblevelsauto' => { 435 => 0x0 },
	'wb_rgblevelscloudy' => { 465 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 435 => 0x15 },
	'wb_rgblevelscustom2' => { 435 => 0x18 },
	'wb_rgblevelscustom3' => { 435 => 0x1b },
	'wb_rgblevelsdaylight' => { 435 => 0x3, 465 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 435 => 0x12, 465 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 435 => 0xf, 465 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 465 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 465 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 465 => 0x7828 },
	'wb_rgblevelsincandescent' => { 435 => 0xc },
	'wb_rgblevelsovercast' => { 435 => 0x9 },
	'wb_rgblevelsshade' => { 435 => 0x6, 465 => 0x7825 },
	'wb_rgblevelstungsten' => { 465 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 436 => 0x0 },
	'wb_rgblevelsunknown1' => { 436 => 0x3 },
	'wb_rgblevelsunknown2' => { 436 => 0x6 },
	'wb_rgblevelsunknown3' => { 436 => 0x9 },
	'wb_rgblevelsunknown4' => { 436 => 0xc },
	'wb_rgblevelsunknown5' => { 436 => 0xf },
	'wb_rgblevelsunknown6' => { 436 => 0x12 },
	'wb_rgblevelsunknown7' => { 436 => 0x15 },
	'wb_rgblevelsunknown8' => { 436 => 0x18 },
	'wb_rgblevelsunknown9' => { 436 => 0x1b },
	'wb_rgbmuldaylight' => { 145 => 0x852 },
	'wb_rgbmulflash' => { 145 => 0x855 },
	'wb_rgbmulfluorescent' => { 145 => 0x854 },
	'wb_rgbmultungsten' => { 145 => 0x853 },
	'wb_rggbblacklevels' => { 38 => 0x25 },
	'wb_rggblevels' => { 125 => 0x7313, 197 => 0x4, 209 => 0x0, 213 => 0x13e8, 214 => 0x38, 465 => 0x7313 },
	'wb_rggblevelsasshot' => { 41 => 0x0, 42 => 0x0, 43 => 0x19, 44 => 0x55, 45 => 0x69, 46 => 0x69, 47 => 0x22, 48 => 0x3f, 51 => 0x3f, 52 => 0x3f, 53 => 0x3f, 54 => 0x47 },
	'wb_rggblevelsauto' => { 38 => 0x1, 41 => 0x5, 42 => 0x8, 43 => 0x1e, 44 => 0x5a, 45 => 0x6e, 47 => 0x18, 48 => 0x44, 51 => 0x44, 52 => 0x44, 53 => 0x44, 54 => 0x4c, 213 => 0x1478, 214 => 0x114, 431 => 0xa022, 465 => 0x7312 },
	'wb_rggblevelsblack' => { 431 => 0xa028 },
	'wb_rggblevelscloudy' => { 38 => 0xd, 41 => 0x1e, 42 => 0x30, 43 => 0x2d, 44 => 0xa0, 45 => 0xd7, 46 => 0x78, 47 => 0x31, 48 => 0x58, 51 => 0x71, 52 => 0x8a, 53 => 0x8f, 54 => 0x92, 213 => 0x1408, 214 => 0x60, 390 => 0x20f, 398 => 0x14 },
	'wb_rggblevelscustom' => { 38 => 0x1d, 48 => 0x80, 213 => 0x1468, 214 => 0x100 },
	'wb_rggblevelscustom1' => { 43 => 0x41 },
	'wb_rggblevelscustom2' => { 43 => 0x46 },
	'wb_rggblevelsdaylight' => { 38 => 0x5, 41 => 0x14, 42 => 0x20, 43 => 0x23, 44 => 0x96, 45 => 0xcd, 46 => 0x6e, 47 => 0x27, 48 => 0x4e, 51 => 0x67, 52 => 0x80, 53 => 0x85, 54 => 0x88, 213 => 0x13f8, 214 => 0x4c, 390 => 0x20d, 398 => 0x2 },
	'wb_rggblevelsflash' => { 38 => 0x19, 41 => 0x32, 42 => 0x50, 43 => 0x3c, 44 => 0xb4, 45 => 0xeb, 46 => 0x87, 47 => 0x45, 48 => 0x6c, 51 => 0x85, 52 => 0x9e, 53 => 0xa3, 54 => 0xa6, 213 => 0x1448, 390 => 0x214, 398 => 0x41 },
	'wb_rggblevelsfluorescent' => { 38 => 0x15, 41 => 0x28, 42 => 0x40, 43 => 0x37, 44 => 0xaa, 45 => 0xe1, 46 => 0x82, 47 => 0x3b, 48 => 0x62, 51 => 0x7b, 52 => 0x94, 53 => 0x99, 54 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 214 => 0xc4, 390 => 0x211, 398 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 398 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 214 => 0xb0, 390 => 0x212, 398 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 213 => 0x1438, 214 => 0x9c, 390 => 0x213, 398 => 0x38 },
	'wb_rggblevelshtmercury' => { 214 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 431 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 431 => 0xa024 },
	'wb_rggblevelskelvin' => { 38 => 0x21, 41 => 0x2d, 42 => 0x48, 44 => 0xaf, 45 => 0xe6, 47 => 0x40, 48 => 0x67, 51 => 0x80, 52 => 0x99, 53 => 0x9e, 54 => 0xa1 },
	'wb_rggblevelsmeasured' => { 41 => 0xa, 42 => 0x10, 44 => 0x5f, 45 => 0x73, 48 => 0x49, 51 => 0x49, 52 => 0x49, 53 => 0x49, 54 => 0x51 },
	'wb_rggblevelspc1' => { 47 => 0x90, 48 => 0x71 },
	'wb_rggblevelspc2' => { 47 => 0x95, 48 => 0x76 },
	'wb_rggblevelspc3' => { 47 => 0x9a, 48 => 0x7b },
	'wb_rggblevelsshade' => { 38 => 0x9, 41 => 0x19, 42 => 0x28, 43 => 0x28, 44 => 0x9b, 45 => 0xd2, 46 => 0x73, 47 => 0x2c, 48 => 0x53, 51 => 0x6c, 52 => 0x85, 53 => 0x8a, 54 => 0x8d, 214 => 0x74, 390 => 0x20e, 398 => 0xb },
	'wb_rggblevelstungsten' => { 38 => 0x11, 41 => 0x23, 42 => 0x38, 43 => 0x32, 44 => 0xa5, 45 => 0xdc, 46 => 0x7d, 47 => 0x36, 48 => 0x5d, 51 => 0x76, 52 => 0x8f, 53 => 0x94, 54 => 0x97, 213 => 0x1428, 214 => 0x88, 390 => 0x210, 398 => 0x1d },
	'wb_rggblevelsuncorrected' => { 431 => 0xa021 },
	'wb_rggblevelsunknown' => { 41 => 0xf, 42 => 0x18, 44 => 0x64, 45 => 0x78, 47 => 0x1d, 51 => 0x4e, 52 => 0x4e, 53 => 0x4e, 54 => 0x56, 398 => 0x53 },
	'wb_rggblevelsunknown10' => { 41 => 0x5f, 42 => 0x98, 44 => 0x91, 45 => 0xa5, 46 => 0xb4, 47 => 0x72, 51 => 0x9e, 52 => 0x7b, 53 => 0x7b, 54 => 0x83 },
	'wb_rggblevelsunknown11' => { 41 => 0x64, 42 => 0xa0, 44 => 0xb9, 45 => [0xaa,0xaf], 46 => 0xb9, 47 => 0x77, 51 => 0xa3, 52 => 0xa3, 53 => 0x80, 54 => 0xab },
	'wb_rggblevelsunknown12' => { 41 => 0x69, 42 => 0xa8, 44 => 0xbe, 45 => 0xb4, 46 => 0xbe, 47 => 0x7c, 51 => 0xa8, 52 => 0xa8, 53 => 0xa8, 54 => 0xb0 },
	'wb_rggblevelsunknown13' => { 41 => 0x6e, 42 => 0xb0, 44 => 0xc3, 45 => 0xb9, 46 => 0xc3, 47 => 0x81, 51 => 0xad, 52 => 0xad, 53 => 0xad, 54 => 0xb5 },
	'wb_rggblevelsunknown14' => { 44 => 0xc8, 45 => 0xbe, 46 => 0xc8, 47 => 0x86, 51 => 0xb2, 52 => 0xb2, 53 => 0xb2, 54 => 0xba },
	'wb_rggblevelsunknown15' => { 44 => 0xcd, 45 => 0xc3, 46 => 0xcd, 47 => 0x8b, 51 => 0xb7, 52 => 0xb7, 53 => 0xb7, 54 => 0xbf },
	'wb_rggblevelsunknown16' => { 44 => 0xd2, 45 => 0xc8, 46 => 0xd2, 47 => 0x9f, 52 => 0xbc, 53 => 0xbc, 54 => 0xc4 },
	'wb_rggblevelsunknown17' => { 44 => 0xd7, 45 => 0xf0, 46 => 0xd7, 52 => 0xc1, 53 => 0xc1, 54 => 0xc9 },
	'wb_rggblevelsunknown18' => { 44 => 0xdc, 45 => 0xf5, 46 => 0xdc, 52 => 0xc6, 53 => 0xc6, 54 => 0xce },
	'wb_rggblevelsunknown19' => { 44 => 0xe1, 45 => 0xfa, 46 => 0xe1, 52 => 0xcb, 53 => 0xcb, 54 => 0xd3 },
	'wb_rggblevelsunknown2' => { 41 => 0x37, 42 => 0x58, 44 => 0x69, 45 => 0x7d, 46 => 0x8c, 47 => 0x4a, 51 => 0x53, 52 => 0x53, 53 => 0x53, 54 => 0x5b },
	'wb_rggblevelsunknown20' => { 44 => 0xe6, 45 => 0xff, 46 => 0xe6, 52 => 0xd0, 53 => 0xd0, 54 => 0xd8 },
	'wb_rggblevelsunknown21' => { 44 => 0xeb, 45 => 0x104, 46 => 0xeb, 53 => 0xd5, 54 => 0xdd },
	'wb_rggblevelsunknown22' => { 44 => 0xf0, 45 => 0x109, 46 => 0xf0, 53 => 0xda, 54 => 0xe2 },
	'wb_rggblevelsunknown23' => { 44 => 0xf5, 45 => 0x10e, 46 => 0xf5, 53 => 0xdf, 54 => 0xe7 },
	'wb_rggblevelsunknown24' => { 44 => 0xfa, 45 => 0x113, 46 => 0xfa, 53 => 0xe4, 54 => 0xec },
	'wb_rggblevelsunknown25' => { 44 => 0xff, 45 => 0x118, 46 => 0xff, 53 => 0xe9, 54 => 0xf1 },
	'wb_rggblevelsunknown26' => { 44 => 0x104, 45 => 0x11d, 46 => 0x104, 53 => 0xee, 54 => 0xf6 },
	'wb_rggblevelsunknown27' => { 44 => 0x109, 45 => 0x122, 46 => 0x109, 53 => 0xf3, 54 => 0xfb },
	'wb_rggblevelsunknown28' => { 44 => 0x10e, 46 => 0x10e, 53 => 0xf8, 54 => 0x100 },
	'wb_rggblevelsunknown29' => { 44 => 0x113, 46 => 0x113, 53 => 0xfd, 54 => 0x105 },
	'wb_rggblevelsunknown3' => { 41 => 0x3c, 42 => 0x60, 44 => 0x6e, 45 => 0x82, 46 => 0x91, 47 => 0x4f, 51 => 0x58, 52 => 0x58, 53 => 0x58, 54 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x118, 53 => 0x102 },
	'wb_rggblevelsunknown31' => { 46 => 0x11d },
	'wb_rggblevelsunknown32' => { 46 => 0x122 },
	'wb_rggblevelsunknown33' => { 46 => 0x127 },
	'wb_rggblevelsunknown4' => { 41 => 0x41, 42 => 0x68, 44 => 0x73, 45 => 0x87, 46 => 0x96, 47 => 0x54, 51 => 0x5d, 52 => 0x5d, 53 => 0x5d, 54 => 0x65 },
	'wb_rggblevelsunknown5' => { 41 => 0x46, 42 => 0x70, 44 => 0x78, 45 => 0x8c, 46 => 0x9b, 47 => 0x59, 51 => 0x62, 52 => 0x62, 53 => 0x62, 54 => 0x6a },
	'wb_rggblevelsunknown6' => { 41 => 0x4b, 42 => 0x78, 44 => 0x7d, 45 => 0x91, 46 => 0xa0, 47 => 0x5e, 51 => 0x8a, 52 => 0x67, 53 => 0x67, 54 => 0x6f },
	'wb_rggblevelsunknown7' => { 41 => 0x50, 42 => 0x80, 44 => 0x82, 45 => 0x96, 46 => 0xa5, 47 => 0x63, 51 => 0x8f, 52 => 0x6c, 53 => 0x6c, 54 => 0x74 },
	'wb_rggblevelsunknown8' => { 41 => 0x55, 42 => 0x88, 44 => 0x87, 45 => 0x9b, 46 => 0xaa, 47 => 0x68, 51 => 0x94, 52 => 0x71, 53 => 0x71, 54 => 0x79 },
	'wb_rggblevelsunknown9' => { 41 => 0x5a, 42 => 0x90, 44 => 0x8c, 45 => 0xa0, 46 => 0xaf, 47 => 0x6d, 51 => 0x99, 52 => 0x76, 53 => 0x76, 54 => 0x7e },
	'wb_rggblevelsuserselected' => { 398 => 0x5c },
	'wbadjblueamber' => { 109 => 0x20106 },
	'wbadjbluebalance' => { 308 => 0x8 },
	'wbadjcolortemp' => { 109 => 0x20102, 114 => 0x1a },
	'wbadjlighting' => { 308 => 0x14 },
	'wbadjmagentagreen' => { 109 => 0x20105 },
	'wbadjmode' => { 308 => 0x10 },
	'wbadjredbalance' => { 308 => 0x0 },
	'wbadjrggblevels' => { 109 => 0x20125, 114 => 0x6 },
	'wbadjtemperature' => { 308 => 0x18 },
	'wbadjtint' => { 308 => 0x25 },
	'wbbluelevel' => { 349 => 0x324, 354 => 0x8006, 359 => 0x26 },
	'wbbracketingsteps' => { 205 => 0x10, 206 => 0x10, 282 => 0x174d },
	'wbbracketmode' => { 61 => 0x9 },
	'wbbracketshotnumber' => { 194 => 0x2b, 424 => 0x101a },
	'wbbracketvalueab' => { 61 => 0xc },
	'wbbracketvaluegm' => { 61 => 0xd },
	'wbbutton' => { 250 => 0x806, 253 => 0x80a },
	'wbbuttonplaybackmode' => { 326 => 0x1c5 },
	'wbfinetuneactive' => { 114 => 0x24 },
	'wbfinetunesaturation' => { 114 => 0x28 },
	'wbfinetunetone' => { 114 => 0x2c },
	'wbgreenlevel' => { 349 => 0x323, 354 => 0x8005, 359 => 0x25 },
	'wbmediaimagesizesetting' => { 90 => 0x708 },
	'wbmode' => { 196 => 0x4, 335 => 0x1015 },
	'wbredlevel' => { 349 => 0x322, 354 => 0x8004, 359 => 0x24 },
	'wbscale' => { 197 => 0x0 },
	'wbshiftab' => { 79 => 0xc, 354 => 0x46, 371 => 0x10 },
	'wbshiftab_gm' => { 458 => 0x2014 },
	'wbshiftab_gm_precise' => { 458 => 0x2026 },
	'wbshiftcreativecontrol' => { 354 => 0x92 },
	'wbshiftgm' => { 79 => 0xd, 354 => 0x47, 371 => 0x11 },
	'wbshiftintelligentauto' => { 354 => 0x8b },
	'wbtype1' => { 360 => 0x1, 361 => 0x1 },
	'wbtype2' => { 360 => 0x4, 361 => 0x5 },
	'wbtype3' => { 360 => 0x7, 361 => 0x9 },
	'wbtype4' => { 360 => 0xa, 361 => 0xd },
	'wbtype5' => { 360 => 0xd, 361 => 0x11 },
	'wbtype6' => { 360 => 0x10, 361 => 0x15 },
	'wbtype7' => { 360 => 0x13, 361 => 0x19 },
	'webstatement' => { 556 => 'WebStatement' },
	'weightedflatsubject' => { 514 => 'weightedFlatSubject' },
	'what' => { 523 => 'What', 525 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 79 => 0x8, 82 => 0x7, 118 => 0x7, 119 => [0x19,0x2012], 125 => [0xa403,0xfe4e], 133 => 0x1002, 145 => 0x3fc, 146 => 0xfa0d, 147 => 0x40, 158 => 0x1a, 188 => 0x3, 189 => 0xe, 190 => 0x4, 191 => 0xb, 193 => 0x115, 243 => 0x5, 291 => 0x7, 349 => 0x304, 354 => 0x3, 356 => 0x3033, 390 => 0x19, 397 => 0x7, 423 => 0x26, 424 => 0x1003, 434 => [0x88,0x3c,0x7,0x58], 444 => 0xf, 445 => 0xe, 458 => [0x115,0xb054], 523 => 'WhiteBalance', 525 => 'WhiteBalance', 529 => 'WhiteBalance' },
	'whitebalance0' => { 183 => 'WhiteBalance0' },
	'whitebalance1' => { 183 => 'WhiteBalance1' },
	'whitebalance2' => { 183 => 'WhiteBalance2', 330 => 0x500 },
	'whitebalanceadj' => { 109 => 0x20101, 114 => 0x18, 302 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 367 => 0x0 },
	'whitebalancebias' => { 119 => 0x2011, 335 => 0x304, 354 => 0x23 },
	'whitebalanceblue' => { 79 => 0x7 },
	'whitebalancebracket' => { 330 => 0x502, 335 => 0x303 },
	'whitebalancebracketing' => { 191 => 0x22, 194 => 0x2c, 455 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 327 => 0x1c5, 328 => 0x1dd },
	'whitebalancecomp' => { 338 => 0x1001 },
	'whitebalancedetected' => { 145 => 0x3fb },
	'whitebalancefinetune' => { 133 => 0x100a, 191 => 0x38, 193 => 0x112, 243 => [0xb,0x3f], 424 => 0x1004, 444 => 0x6, 445 => 0x5, 458 => 0x112 },
	'whitebalancemode' => { 145 => 0x3fa, 390 => 0x1a },
	'whitebalancered' => { 79 => 0x6 },
	'whitebalanceset' => { 370 => 0xa },
	'whitebalancesetting' => { 191 => 0x23, 444 => 0x5, 445 => 0x4, 446 => 0x16, 463 => 0xd },
	'whitebalancesetup' => { 431 => 0x41 },
	'whitebalancetemperature' => { 330 => 0x501 },
	'whiteboard' => { 335 => 0x301 },
	'whitelevel' => { 125 => 0xc61d, 390 => 0x7e, 465 => 0x787f },
	'whitepoint' => { 125 => 0x13e, 353 => 0x35d, 390 => 0x201, 548 => 'WhitePoint' },
	'whites2012' => { 523 => 'Whites2012', 525 => 'Whites2012' },
	'whitesadj' => { 495 => 0x9017 },
	'wideadapter' => { 424 => 0x1017 },
	'widefocuszone' => { 188 => 0x2f },
	'widerange' => { 433 => 0x20f },
	'windmode' => { 145 => 0x3f4 },
	'windnoisereduction' => { 249 => 0x352, 250 => 0x352, 251 => 0x2d6, 252 => 0x2fe, 253 => 0x2fe },
	'windowlocation' => { 416 => 'WLOC' },
	'windowsatom' => { 524 => 'windowsAtom' },
	'windowsatomextension' => { 524 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 524 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 524 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 542 => 'wordCount' },
	'work' => { 408 => "\xa9wrk" },
	'workcolorspace' => { 109 => 0x10200, 114 => 0x270 },
	'workflowtag' => { 537 => 'WorkflowTag' },
	'workflowtagcvid' => { 537 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 537 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 537 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 537 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 531 => 'WorkToDo' },
	'worldtimelocation' => { 354 => 0x3a, 390 => 0x22, 396 => '0.1' },
	'writer' => { 186 => 'WM/Writer' },
	'writer-editor' => { 138 => 0x7a },
	'x3filllight' => { 434 => 0x12 },
	'xattrmditemwherefroms' => { 181 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 181 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 410 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 410 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 125 => 0x9a00 },
	'xiaomipreviewvideocover' => { 410 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 125 => 0x9999 },
	'xilinxversion' => { 145 => 0x414 },
	'xml' => { 143 => 'xml ' },
	'xmp' => { 112 => 0xffff00f6, 126 => 'XMP', 136 => 'XMP Data/XMP' },
	'xmptoolkit' => { 549 => 'xmptk' },
	'xpauthor' => { 125 => 0x9c9d },
	'xpcomment' => { 125 => 0x9c9c },
	'xpkeywords' => { 125 => 0x9c9e },
	'xposition' => { 125 => 0x11e },
	'xpsubject' => { 125 => 0x9c9f },
	'xptitle' => { 125 => 0x9c9b },
	'xresolution' => { 125 => 0x11a, 141 => 0x3, 405 => 0x0, 548 => 'XResolution' },
	'xyresolution' => { 129 => 0x3 },
	'yaw' => { 121 => 0x7, 416 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 258 => 0x8, 429 => 0x0 },
	'ycbcrcoefficients' => { 125 => 0x211, 548 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 125 => 0x213, 548 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 125 => 0x212, 548 => 'YCbCrSubSampling' },
	'year' => { 408 => 'yrrc', 410 => 'year', 416 => 'yrrc' },
	'yearcreated' => { 147 => 0x10, 156 => 0xc },
	'yellowhsl' => { 109 => 0x20912 },
	'yield' => { 544 => 'yield' },
	'yposition' => { 125 => 0x11f },
	'yresolution' => { 125 => 0x11b, 141 => 0x5, 405 => 0x4, 548 => 'YResolution' },
	'zebrapatterntonerange' => { 326 => 0x211, 327 => 0x211, 328 => 0x229 },
	'zoneidentifier' => { 126 => 'ZoneIdentifier' },
	'zonematching' => { 193 => 0x10a, 196 => [0x3a,0x4a], 458 => 0xb024 },
	'zonematchingmode' => { 191 => 0x14 },
	'zonematchingon' => { 190 => 0x75 },
	'zonematchingvalue' => { 444 => 0x1f },
	'zoomedpreviewlength' => { 335 => 0xf05 },
	'zoomedpreviewsize' => { 335 => 0xf06 },
	'zoomedpreviewstart' => { 335 => 0xf04 },
	'zoomsourcewidth' => { 37 => 0x24 },
	'zoomstepcount' => { 333 => 0x300, 335 => 0x100d },
	'zoomtargetwidth' => { 37 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaisused' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'apdi' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiokeys' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfor6m2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelcolordata' => 1,
	'channelcolorindicates' => 1,
	'channelcolorspace' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelopacity' => 1,
	'channeloptions' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coordinateunits' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djidebug' => 1,
	'djimetadata' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exefilename' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpsinfo9' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdgainmapinfo' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgaincurve' => 1,
	'hdrgainmap' => 1,
	'hdrgm' => 1,
	'hdrimage' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsoninfo' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligogpsinfo' => 1,
	'ligojson' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magneticvariation' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdbage' => 1,
	'pdbcreatedate' => 1,
	'pdbfilename' => 1,
	'pdbmodifydate' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'prediminanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protocol' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'serialnumber2' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signaturelength' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uniformresourcename' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'uniqueidentifier' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_grpl' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videokeys' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vivo' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2025, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
