#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 112 => 0x69 },
	'about' => { 530 => 'about' },
	'aboutcvterm' => { 521 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 521 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 521 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 521 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 521 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 119 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 536 => 'absPeakAudioFilePath' },
	'academicfield' => { 526 => 'academicField' },
	'acceleration' => { 122 => 0x9404, 514 => 'Acceleration' },
	'accelerationtracking' => { 87 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 416 => 0x3 },
	'accelerometerdata' => { 406 => 'vrot' },
	'accelerometerx' => { 346 => 0x8d },
	'accelerometery' => { 346 => 0x8e },
	'accelerometerz' => { 346 => 0x8c },
	'accessoryserialnumber' => { 346 => 0x54 },
	'accessorytype' => { 346 => 0x53 },
	'actionadvised' => { 134 => 0x2a },
	'activearea' => { 122 => 0xc68d },
	'actived-lighting' => { 239 => 0x22, 294 => 0x24 },
	'actived-lightingmode' => { 294 => 0x25 },
	'adaptervoltage' => { 141 => 0x407 },
	'addaspectratioinfo' => { 87 => 0x80e },
	'addiptcinformation' => { 87 => 0x815 },
	'additionalmodelinformation' => { 521 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 87 => 0x80f, 88 => 0x11, 89 => 0x13, 92 => 0x14 },
	'address' => { 164 => 'Address' },
	'adjustmentmode' => { 423 => 0x15 },
	'adlbracketingstep' => { 201 => 0x17 },
	'adlbracketingtype' => { 201 => 0x18 },
	'adobe' => { 123 => 'Adobe' },
	'adultcontentwarning' => { 333 => 'AdultContentWarning', 529 => 'adultContentWarning' },
	'advancedfilter' => { 130 => 0x1201 },
	'advancedraw' => { 296 => 0x76a43203 },
	'advancedscenetype' => { 346 => 0x3d },
	'advisory' => { 534 => 'Advisory' },
	'ae_iso' => { 354 => 0x2, 355 => 0x4, 356 => 0x12 },
	'aeaperture' => { 354 => 0x1, 355 => 0x3, 356 => 0x11 },
	'aeaperturesteps' => { 354 => 0x8, 355 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 87 => 0x104 },
	'aebbracketvalue' => { 79 => 0x11 },
	'aebracketingsteps' => { 201 => 0xf, 202 => 0xf, 276 => 0x174c },
	'aebsequence' => { 87 => 0x105 },
	'aebsequenceautocancel' => { 85 => 0x9, 86 => 0x9, 88 => 0x8, 89 => 0x9, 92 => 0x9, 93 => 0x7 },
	'aebshotcount' => { 87 => 0x106 },
	'aebxv' => { 354 => 0x4, 355 => 0x6 },
	'aeerror' => { 355 => 0x8 },
	'aeexposuretime' => { 354 => 0x0, 355 => 0x2, 356 => 0x10 },
	'aelbutton' => { 187 => 0x45 },
	'aelexposureindicator' => { 187 => 0x51 },
	'aelock' => { 187 => 0x5b, 305 => '4.2', 314 => '4.2', 323 => 0x201, 381 => 0x48, 433 => 0x40, 434 => 0x40, 435 => [0x86,0x286] },
	'aelockbutton' => { 303 => '16.1', 305 => '4.1', 308 => '15.1', 309 => '16.1', 310 => '16.1', 312 => '30.1', 313 => '16.1', 314 => '4.1', 316 => '17.1', 318 => '17.1' },
	'aelockbuttonplusdials' => { 303 => '16.2', 312 => '32.1', 316 => '44.1' },
	'aelockformb-d80' => { 318 => '3.1' },
	'aelockmetermodeafterfocus' => { 87 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 354 => 0x9, 355 => 0x10, 356 => 0x1c },
	'aemaxaperture2' => { 354 => 0xa, 355 => 0x11, 356 => 0x1d },
	'aemeteringmode' => { 354 => 0xc },
	'aemeteringmode2' => { 354 => '13.1' },
	'aemeteringsegments' => { 190 => 0x628, 381 => 0x209 },
	'aemicroadjustment' => { 87 => 0x110 },
	'aeminaperture' => { 354 => 0xb, 355 => 0x12, 356 => 0x1e },
	'aeminexposuretime' => { 354 => 0x5, 355 => 0x13, 356 => 0x1f },
	'aeprogrammode' => { 354 => 0x6 },
	'aeprojectlink' => { 508 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 508 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 508 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 508 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 508 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 508 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 36 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 354 => 0xd },
	'aexv' => { 354 => 0x3, 355 => 0x5 },
	'af-assistilluminator' => { 319 => 0x19, 320 => 0x19, 321 => 0x19 },
	'af-cfocusdisplay' => { 319 => 0x234, 320 => 0x234, 321 => 0x24c },
	'af-cpriority' => { 131 => '0.2' },
	'af-cpriorityselection' => { 303 => '1.1', 304 => '1.1', 306 => '1.1', 307 => '1.1', 309 => '0.1', 310 => '0.1', 311 => '0.1', 312 => '1.1', 313 => '0.1', 316 => '1.1', 317 => '1.1', 319 => 0x3, 320 => 0x3, 321 => 0x3 },
	'af-csetting' => { 127 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 127 => '0.2' },
	'af-ctrackingsensitivity' => { 127 => '0.1' },
	'af-czoneareaswitching' => { 127 => '0.3' },
	'af-onbutton' => { 306 => '70.1', 307 => '70.1', 317 => '70.1' },
	'af-onformb-d10' => { 303 => '3.3', 312 => '3.2' },
	'af-onformb-d11' => { 313 => '2.2' },
	'af-onformb-d12' => { 316 => '50.1' },
	'af-onoutoffocusrelease' => { 319 => 0x10, 320 => 0x10, 321 => 0x10 },
	'af-spriority' => { 131 => '0.1' },
	'af-spriorityselection' => { 303 => '1.2', 304 => '1.2', 306 => '1.2', 307 => '1.2', 311 => '0.2', 312 => '1.2', 313 => '0.2', 316 => '1.2', 317 => '1.2', 319 => 0x5, 320 => 0x5, 321 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 303 => '2.1', 304 => '2.1', 306 => '78.3', 307 => '78.3', 312 => '2.1', 316 => '2.1', 317 => '78.3', 319 => 0xf, 320 => 0xf, 321 => 0xf },
	'afadjustment' => { 381 => 0x72, 390 => 0x267 },
	'afandmeteringbuttons' => { 87 => 0x701 },
	'afaperture' => { 232 => 0x5, 233 => 0x5, 237 => 0x5 },
	'afareaheight' => { 196 => [0x1a,0x34,0x50], 197 => 0x48 },
	'afareaillumination' => { 187 => 0x4b, 314 => '15.3' },
	'afareainitialheight' => { 251 => 0xbeb },
	'afareainitialwidth' => { 251 => 0xbea },
	'afareainitialxposition' => { 251 => 0xbe8 },
	'afareainitialyposition' => { 251 => 0xbe9 },
	'afareamode' => { 129 => '0.3', 183 => 0x33, 187 => 0xe, 195 => 0x0, 196 => 0x5, 197 => 0x5, 244 => 0x224, 245 => 0x210, 246 => 0x224, 247 => 0x224, 346 => 0xf, 413 => 0x1205, 426 => [0xa,0x3a], 433 => 0x11, 434 => 0x10, 435 => 0x24, 446 => 0xb043, 472 => 0x17 },
	'afareamodesetting' => { 305 => '11.1', 308 => '0.1', 314 => '16.1', 318 => '2.1', 446 => 0x201c },
	'afareapointsize' => { 129 => '0.4' },
	'afareas' => { 323 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 87 => 0x51b },
	'afareawidth' => { 196 => [0x18,0x32,0x4e], 197 => 0x46 },
	'afareaxposition' => { 196 => [0x14,0x2e,0x4a], 197 => 0x42, 413 => 0x1203 },
	'afareaxposition1' => { 413 => 0x1201 },
	'afareayposition' => { 196 => [0x16,0x30,0x4c], 197 => 0x44, 413 => 0x1204 },
	'afareayposition1' => { 413 => 0x1202 },
	'afareazonesize' => { 129 => '0.5' },
	'afassist' => { 85 => 0x5, 93 => 0x5, 187 => 0x48, 303 => '2.5', 305 => '0.2', 308 => '0.2', 309 => '1.1', 310 => '1.1', 311 => '1.3', 312 => '2.4', 313 => '1.3', 314 => '0.2', 316 => '2.4', 318 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 87 => 0x50e, 88 => 0x4, 89 => 0x5, 90 => 0x4, 91 => 0x4, 92 => 0x5 },
	'afassistlamp' => { 346 => 0x31 },
	'afbuttonpressed' => { 435 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 357 => 0x6 },
	'afduringliveview' => { 87 => 0x511 },
	'affinea' => { 501 => 'AffineA' },
	'affineb' => { 501 => 'AffineB' },
	'affinec' => { 501 => 'AffineC' },
	'affined' => { 501 => 'AffineD' },
	'affinetune' => { 198 => 0x0, 244 => 0x6b0, 245 => 0x5b0, 246 => 0x5e0, 247 => 0x5f8, 323 => 0x306 },
	'affinetuneadj' => { 198 => 0x2, 269 => 0x2d1, 270 => 0x2dc, 323 => 0x307 },
	'affinetuneadjtele' => { 198 => 0x3 },
	'affinetuneindex' => { 198 => 0x1 },
	'affinex' => { 501 => 'AffineX' },
	'affiney' => { 501 => 'AffineY' },
	'afhold' => { 357 => 0x1fd },
	'afilluminator' => { 433 => 0x29, 446 => 0xb044 },
	'afimageheight' => { 196 => [0x12,0x2c,0x48], 197 => 0x40 },
	'afimagewidth' => { 196 => [0x10,0x2a,0x46], 197 => 0x3e },
	'afintegrationtime' => { 357 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 426 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 430 => 0x131 },
	'afmicroadjregisteredlenses' => { 430 => '305.1' },
	'afmicroadjustment' => { 87 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 430 => 0x130 },
	'afmode' => { 116 => 0x3009, 130 => 0x1022, 183 => 0x16, 423 => 0x5 },
	'afmoderestrictions' => { 304 => '50.3', 306 => '48.3', 307 => '48.3', 316 => '48.3', 317 => '48.3' },
	'afonaelockbuttonswitch' => { 87 => 0x702 },
	'afonbutton' => { 303 => '3.1', 304 => '47.1', 319 => 0x83, 320 => 0x83, 321 => 0x83 },
	'afpoint' => { 36 => 0x13, 115 => 0x18, 183 => 0x15, 195 => 0x1, 326 => 0x308, 423 => 0x1f, 426 => [0x37,0x7], 430 => 0x19, 431 => 0x18, 432 => [0x18,0x20] },
	'afpointactivationarea' => { 86 => 0x11, 92 => 0x11 },
	'afpointareaexpansion' => { 87 => 0x508 },
	'afpointatshutterrelease' => { 426 => [0x39,0x9] },
	'afpointautoselection' => { 87 => 0x50b },
	'afpointbrightness' => { 87 => 0x50d, 303 => '2.4', 304 => '46.5', 306 => '2.2', 307 => '2.2', 316 => '2.3', 317 => '2.2' },
	'afpointdetails' => { 326 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 87 => 0x50c },
	'afpointillumination' => { 86 => 0xa, 303 => '2.3', 304 => '46.2', 306 => '47.2', 307 => '47.2', 311 => '1.2', 312 => '2.3', 313 => '1.2', 316 => '47.2', 317 => '47.2', 318 => '2.4' },
	'afpointinfocus' => { 426 => [0x38,0x8] },
	'afpointmode' => { 362 => 0x3 },
	'afpointposition' => { 116 => 0x2021, 346 => 0x4d },
	'afpointregistration' => { 85 => 0x7 },
	'afpoints' => { 186 => 0x10 },
	'afpointsel' => { 319 => 0xb, 320 => 0xb, 321 => 0xb },
	'afpointselected' => { 187 => 0xd, 323 => 0x305, 381 => 0xe, 430 => 0x15, 431 => 0x14, 432 => [0x14,0x1c], 446 => 0x201e },
	'afpointselected2' => { 362 => 0x4 },
	'afpointselection' => { 86 => 0xb, 303 => '1.3', 304 => '1.3', 312 => '1.3', 316 => '1.3', 317 => '1.3' },
	'afpointselectionmethod' => { 87 => 0x50f, 88 => 0xc, 89 => 0xd, 92 => 0xd },
	'afpointsetting' => { 433 => 0x12, 434 => 0x11 },
	'afpointsinfocus' => { 79 => 0xe, 195 => 0x2, 196 => 0x30, 357 => 0xb, 358 => 0x4, 381 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 86 => 0xd },
	'afpointsselected' => { 196 => 0x1c, 358 => '4.1', 481 => 0x4 },
	'afpointsspecial' => { 358 => '4.2' },
	'afpointsunknown1' => { 357 => 0x0 },
	'afpointsunknown2' => { 357 => 0x2 },
	'afpointsused' => { 196 => [0xa,0x8], 197 => 0xa, 426 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 357 => 0x4 },
	'afresponse' => { 239 => 0xad },
	'afresult' => { 328 => 0x1038 },
	'afsearch' => { 323 => 0x303 },
	'afsensoractive' => { 183 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 413 => 0x1200 },
	'afstatus_00_b4' => { 429 => 0x0 },
	'afstatus_01_c4' => { 429 => 0x2 },
	'afstatus_02_d4' => { 429 => 0x4 },
	'afstatus_03_e4' => { 429 => 0x6 },
	'afstatus_04_f4' => { 429 => 0x8 },
	'afstatus_05_g4' => { 429 => 0xa },
	'afstatus_06_h4' => { 429 => 0xc },
	'afstatus_07_b3' => { 429 => 0xe },
	'afstatus_08_c3' => { 429 => 0x10 },
	'afstatus_09_d3' => { 429 => 0x12 },
	'afstatus_10_e3' => { 429 => 0x14 },
	'afstatus_11_f3' => { 429 => 0x16 },
	'afstatus_12_g3' => { 429 => 0x18 },
	'afstatus_13_h3' => { 429 => 0x1a },
	'afstatus_14_b2' => { 429 => 0x1c },
	'afstatus_15_c2' => { 429 => 0x1e },
	'afstatus_16_d2' => { 429 => 0x20 },
	'afstatus_17_e2' => { 429 => 0x22 },
	'afstatus_18_f2' => { 429 => 0x24 },
	'afstatus_19_g2' => { 429 => 0x26 },
	'afstatus_20_h2' => { 429 => 0x28 },
	'afstatus_21_c1' => { 429 => 0x2a },
	'afstatus_22_d1' => { 429 => 0x2c },
	'afstatus_23_e1' => { 429 => 0x2e },
	'afstatus_24_f1' => { 429 => 0x30 },
	'afstatus_25_g1' => { 429 => 0x32 },
	'afstatus_26_a7_vertical' => { 429 => 0x34 },
	'afstatus_27_a6_vertical' => { 429 => 0x36 },
	'afstatus_28_a5_vertical' => { 429 => 0x38 },
	'afstatus_29_c7_vertical' => { 429 => 0x3a },
	'afstatus_30_c6_vertical' => { 429 => 0x3c },
	'afstatus_31_c5_vertical' => { 429 => 0x3e },
	'afstatus_32_e7_vertical' => { 429 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 429 => 0x42 },
	'afstatus_34_e5_vertical' => { 429 => 0x44 },
	'afstatus_35_g7_vertical' => { 429 => 0x46 },
	'afstatus_36_g6_vertical' => { 429 => 0x48 },
	'afstatus_37_g5_vertical' => { 429 => 0x4a },
	'afstatus_38_i7_vertical' => { 429 => 0x4c },
	'afstatus_39_i6_vertical' => { 429 => 0x4e },
	'afstatus_40_i5_vertical' => { 429 => 0x50 },
	'afstatus_41_a7' => { 429 => 0x52 },
	'afstatus_42_b7' => { 429 => 0x54 },
	'afstatus_43_c7' => { 429 => 0x56 },
	'afstatus_44_d7' => { 429 => 0x58 },
	'afstatus_45_e7' => { 429 => 0x5a },
	'afstatus_46_f7' => { 429 => 0x5c },
	'afstatus_47_g7' => { 429 => 0x5e },
	'afstatus_48_h7' => { 429 => 0x60 },
	'afstatus_49_i7' => { 429 => 0x62 },
	'afstatus_50_a6' => { 429 => 0x64 },
	'afstatus_51_b6' => { 429 => 0x66 },
	'afstatus_52_c6' => { 429 => 0x68 },
	'afstatus_53_d6' => { 429 => 0x6a },
	'afstatus_54_e6_center' => { 429 => 0x6c },
	'afstatus_55_f6' => { 429 => 0x6e },
	'afstatus_56_g6' => { 429 => 0x70 },
	'afstatus_57_h6' => { 429 => 0x72 },
	'afstatus_58_i6' => { 429 => 0x74 },
	'afstatus_59_a5' => { 429 => 0x76 },
	'afstatus_60_b5' => { 429 => 0x78 },
	'afstatus_61_c5' => { 429 => 0x7a },
	'afstatus_62_d5' => { 429 => 0x7c },
	'afstatus_63_e5' => { 429 => 0x7e },
	'afstatus_64_f5' => { 429 => 0x80 },
	'afstatus_65_g5' => { 429 => 0x82 },
	'afstatus_66_h5' => { 429 => 0x84 },
	'afstatus_67_i5' => { 429 => 0x86 },
	'afstatus_68_c11' => { 429 => 0x88 },
	'afstatus_69_d11' => { 429 => 0x8a },
	'afstatus_70_e11' => { 429 => 0x8c },
	'afstatus_71_f11' => { 429 => 0x8e },
	'afstatus_72_g11' => { 429 => 0x90 },
	'afstatus_73_b10' => { 429 => 0x92 },
	'afstatus_74_c10' => { 429 => 0x94 },
	'afstatus_75_d10' => { 429 => 0x96 },
	'afstatus_76_e10' => { 429 => 0x98 },
	'afstatus_77_f10' => { 429 => 0x9a },
	'afstatus_78_g10' => { 429 => 0x9c },
	'afstatus_79_h10' => { 429 => 0x9e },
	'afstatus_80_b9' => { 429 => 0xa0 },
	'afstatus_81_c9' => { 429 => 0xa2 },
	'afstatus_82_d9' => { 429 => 0xa4 },
	'afstatus_83_e9' => { 429 => 0xa6 },
	'afstatus_84_f9' => { 429 => 0xa8 },
	'afstatus_85_g9' => { 429 => 0xaa },
	'afstatus_86_h9' => { 429 => 0xac },
	'afstatus_87_b8' => { 429 => 0xae },
	'afstatus_88_c8' => { 429 => 0xb0 },
	'afstatus_89_d8' => { 429 => 0xb2 },
	'afstatus_90_e8' => { 429 => 0xb4 },
	'afstatus_91_f8' => { 429 => 0xb6 },
	'afstatus_92_g8' => { 429 => 0xb8 },
	'afstatus_93_h8' => { 429 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 429 => 0xbc },
	'afstatusactivesensor' => { 183 => 0x2, 426 => [0x4,0x3b], 430 => 0x1e, 431 => 0x1b, 432 => [0x1b,0x21] },
	'afstatusbottom' => { 183 => 0x8, 430 => 0x2a, 431 => 0x21, 432 => 0x21 },
	'afstatusbottom-left' => { 183 => 0x12, 431 => 0x2b, 432 => 0x2b },
	'afstatusbottom-right' => { 183 => 0x6, 431 => 0x1f, 432 => 0x1f },
	'afstatusbottomassist-left' => { 430 => 0x28 },
	'afstatusbottomassist-right' => { 430 => 0x2c },
	'afstatusbottomhorizontal' => { 427 => 0x10, 428 => 0x1c },
	'afstatusbottomvertical' => { 427 => 0x16, 428 => 0x26 },
	'afstatuscenter-10' => { 430 => 0x34 },
	'afstatuscenter-11' => { 430 => 0x36 },
	'afstatuscenter-12' => { 430 => 0x38 },
	'afstatuscenter-14' => { 430 => 0x3c },
	'afstatuscenter-7' => { 430 => 0x2e },
	'afstatuscenter-9' => { 430 => 0x32 },
	'afstatuscenter-horizontal' => { 430 => 0x30 },
	'afstatuscenter-vertical' => { 430 => 0x3a },
	'afstatuscenterf2-8' => { 430 => 0x4c },
	'afstatuscenterhorizontal' => { 183 => 0x2f, 427 => 0xc, 428 => 0x18, 431 => 0x2f, 432 => 0x2f },
	'afstatuscentervertical' => { 183 => 0xc, 427 => 0x14, 428 => 0x22, 431 => 0x25, 432 => 0x25 },
	'afstatusfarleft' => { 427 => 0x6, 430 => 0x26 },
	'afstatusfarlefthorizontal' => { 428 => 0x4 },
	'afstatusfarleftvertical' => { 428 => 0x12 },
	'afstatusfarright' => { 427 => 0x18, 430 => 0x44 },
	'afstatusfarrighthorizontal' => { 428 => 0x2c },
	'afstatusfarrightvertical' => { 428 => 0x34 },
	'afstatusleft' => { 183 => 0x2d, 427 => 0x2, 430 => 0x22, 431 => 0x2d, 432 => 0x2d },
	'afstatuslefthorizontal' => { 428 => 0x6 },
	'afstatusleftvertical' => { 428 => 0xe },
	'afstatuslower-left' => { 427 => 0x4, 430 => 0x24 },
	'afstatuslower-lefthorizontal' => { 428 => 0xa },
	'afstatuslower-leftvertical' => { 428 => 0x10 },
	'afstatuslower-middle' => { 427 => 0x22, 428 => 0x24 },
	'afstatuslower-right' => { 427 => 0x1e, 430 => 0x4a },
	'afstatuslower-righthorizontal' => { 428 => 0x32 },
	'afstatuslower-rightvertical' => { 428 => 0x3a },
	'afstatuslowerfarleft' => { 428 => 0x8 },
	'afstatuslowerfarright' => { 428 => 0x30 },
	'afstatusmiddlehorizontal' => { 183 => 0xa, 431 => 0x23, 432 => 0x23 },
	'afstatusnearleft' => { 427 => 0xe, 428 => 0x1a },
	'afstatusnearright' => { 427 => 0xa, 428 => 0x16 },
	'afstatusright' => { 183 => 0x31, 427 => 0x1c, 430 => 0x48, 431 => 0x31, 432 => 0x31 },
	'afstatusrighthorizontal' => { 428 => 0x2e },
	'afstatusrightvertical' => { 428 => 0x38 },
	'afstatustop' => { 183 => 0xe, 430 => 0x40, 431 => 0x27, 432 => 0x27 },
	'afstatustop-left' => { 183 => 0x10, 431 => 0x29, 432 => 0x29 },
	'afstatustop-right' => { 183 => 0x4, 431 => 0x1d, 432 => 0x1d },
	'afstatustopassist-left' => { 430 => 0x3e },
	'afstatustopassist-right' => { 430 => 0x42 },
	'afstatustophorizontal' => { 427 => 0x8, 428 => 0x14 },
	'afstatustopvertical' => { 427 => 0x12, 428 => 0x1e },
	'afstatusupper-left' => { 427 => 0x0, 430 => 0x20 },
	'afstatusupper-lefthorizontal' => { 428 => 0x2 },
	'afstatusupper-leftvertical' => { 428 => 0xc },
	'afstatusupper-middle' => { 427 => 0x20, 428 => 0x20 },
	'afstatusupper-right' => { 427 => 0x1a, 430 => 0x46 },
	'afstatusupper-righthorizontal' => { 428 => 0x2a },
	'afstatusupper-rightvertical' => { 428 => 0x36 },
	'afstatusupperfarleft' => { 428 => 0x0 },
	'afstatusupperfarright' => { 428 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 446 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 426 => 0x2 },
	'afwithshutter' => { 433 => 0x2a },
	'aggregateissuenumber' => { 526 => 'aggregateIssueNumber' },
	'aggregationtype' => { 526 => 'aggregationType' },
	'agreement' => { 529 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 141 => 0xe4e },
	'airplanemode' => { 244 => 0x722, 245 => 0x624, 246 => 0x654, 247 => 0x6bc },
	'aiservocontinuousshooting' => { 86 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 87 => 0x519 },
	'aiservoimagepriority' => { 87 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 87 => 0x51a },
	'aiservotrackingmethod' => { 87 => 0x504 },
	'aiservotrackingsensitivity' => { 86 => 0x14, 87 => 0x502 },
	'aisubjecttrackingmode' => { 323 => 0x309 },
	'album' => { 398 => ['albm',"\xa9alb"], 400 => 'album', 406 => ['albm',"\xa9alb"], 536 => 'album' },
	'albumartist' => { 182 => 'WM/AlbumArtist', 398 => 'aART', 406 => 'albr' },
	'albumcoverurl' => { 182 => 'WM/AlbumCoverURL' },
	'albumid' => { 398 => 'plID' },
	'albumtitle' => { 182 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 507 => 'AlreadyApplied', 509 => 'AlreadyApplied' },
	'alternatetitle' => { 526 => 'alternateTitle' },
	'alternatetitlea-lang' => { 526 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 526 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 526 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 200 => 0x6 },
	'alttapename' => { 536 => 'altTapeName' },
	'alttextaccessibility' => { 520 => 'AltTextAccessibility' },
	'alttimecode' => { 536 => 'altTimecode' },
	'alttimecodetimeformat' => { 536 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 536 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 536 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 409 => 0x5c },
	'ambientlight' => { 409 => 0x5e },
	'ambienttemperature' => { 122 => 0x9400, 407 => 0x14, 408 => 0x46, 409 => 0x50, 472 => 0x4, 514 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 407 => 0x13, 408 => 0x44, 409 => 0x4e },
	'analogbalance' => { 122 => 0xc627 },
	'analogcaptureiso' => { 141 => 0x89e },
	'analogisotable' => { 141 => 0x89d },
	'androidversion' => { 400 => 'com.android.version' },
	'angleadj' => { 106 => 0x10003, 112 => 0x8b },
	'angleinforoll' => { 503 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 503 => 'AngleInfoYaw' },
	'anti-blur' => { 446 => 0xb04b },
	'antialiasstrength' => { 122 => 0xc632 },
	'aperturelock' => { 304 => '38.2', 306 => '38.2', 307 => '38.2', 316 => '38.2', 317 => '38.2', 319 => 0xb8, 320 => 0xb8, 321 => 0xb8 },
	'aperturemode' => { 406 => 'apmd' },
	'aperturerange' => { 87 => 0x10d },
	'apertureringuse' => { 362 => '1.4' },
	'aperturesetting' => { 187 => 0x7, 433 => 0x30, 434 => 0x29, 435 => 0x1 },
	'aperturevalue' => { 96 => 0x2, 122 => 0x9202, 328 => 0x1002, 390 => 0x401, 513 => 'ApertureValue' },
	'appinfo' => { 486 => 'AppInfo' },
	'appinfoapplication' => { 486 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 486 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 486 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 332 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 400 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 398 => 'apID' },
	'applestoreaccounttype' => { 398 => 'akID' },
	'applestorecatalogid' => { 398 => 'cnID' },
	'applestorecountry' => { 398 => 'sfID' },
	'applicationkeystring' => { 141 => 0x400 },
	'applicationnotes' => { 122 => 0x2bc, 351 => 0x2bc },
	'applicationrecordversion' => { 134 => 0x0 },
	'applyshootingmeteringmode' => { 87 => 0x10e },
	'approved' => { 515 => 'Approved' },
	'approvedby' => { 515 => 'ApprovedBy' },
	'approximatefnumber' => { 341 => 0x313, 348 => 0x3406 },
	'approximatefocusdistance' => { 504 => 'ApproximateFocusDistance' },
	'appversion' => { 519 => 'AppVersion' },
	'aps-csizecapture' => { 465 => 0x114, 466 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 106 => 0x20914 },
	'armidentifier' => { 135 => 0x78 },
	'armversion' => { 135 => 0x7a },
	'arranger' => { 398 => "\xa9arg", 406 => "\xa9arg" },
	'arrangerkeywords' => { 406 => "\xa9ark" },
	'artdirector' => { 398 => "\xa9ard" },
	'artfilter' => { 323 => 0x529 },
	'artfiltereffect' => { 323 => 0x52f },
	'artist' => { 122 => 0x13b, 336 => 'Artist', 351 => 0x13b, 381 => 0x22e, 398 => "\xa9ART", 400 => 'artist', 406 => "\xa9ART", 532 => 'Artist', 536 => 'artist' },
	'artistid' => { 398 => 'atID' },
	'artmode' => { 116 => 0x301b },
	'artmodeparameters' => { 116 => 0x310b },
	'artwork' => { 400 => 'artwork' },
	'artworkcircadatecreated' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 521 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 521 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 327 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 327 => 0x1112, 381 => 0x80, 433 => 0x55, 434 => 0x55, 435 => 0xa, 459 => [0x192c,0x1a88], 460 => 0x192c, 461 => 0x1958, 462 => 0x192c, 463 => 0x188c },
	'assetid' => { 497 => 'AssetID' },
	'asshoticcprofile' => { 122 => 0xc68f },
	'asshotneutral' => { 122 => 0xc628 },
	'asshotpreprofilematrix' => { 122 => 0xc690 },
	'asshotprofilename' => { 122 => 0xc6f6 },
	'asshotwhitexy' => { 122 => 0xc629 },
	'assignbktbutton' => { 303 => '4.2', 304 => '16.1', 306 => '16.1', 307 => '16.1', 316 => '16.1', 317 => '16.1' },
	'assignfuncbutton' => { 87 => 0x70b },
	'assignmb-d17af-onbutton' => { 307 => '79.1' },
	'assignmb-d17funcbutton' => { 307 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 307 => '68.1' },
	'assignmb-d18af-onbutton' => { 317 => '79.1' },
	'assignmb-d18funcbutton' => { 317 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 317 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 306 => '75.1', 307 => '75.1', 317 => '75.1' },
	'assignmoviefunc2button' => { 306 => '82.1', 307 => '82.1', 317 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 306 => '75.2', 307 => '75.2', 317 => '75.2' },
	'assignmovierecordbutton' => { 304 => '43.2', 316 => '45.1', 319 => 0x9b, 320 => 0x9b, 321 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 306 => '45.1', 307 => '45.1', 317 => '45.1' },
	'assignmoviesubselector' => { 306 => '74.1', 307 => '74.1', 317 => '74.1' },
	'assignmoviesubselectorplusdials' => { 306 => '76.1', 307 => '76.1', 317 => '76.1' },
	'assignremotefnbutton' => { 304 => '54.1', 316 => '51.1' },
	'assistbuttonfunction' => { 85 => 0xd },
	'atcaptureusercrop' => { 141 => 0x943 },
	'attributionname' => { 505 => 'attributionName' },
	'attributionurl' => { 505 => 'attributionURL' },
	'audio' => { 346 => 0x20 },
	'audiobitrate' => { 69 => 0x6c, 521 => 'audioBitRate' },
	'audiobitratemode' => { 521 => 'audioBitRateMode' },
	'audiobitspersample' => { 521 => 'audioBitsPerSample' },
	'audiobutton' => { 320 => 0x17b, 321 => 0x193 },
	'audiobuttonplaybackmode' => { 320 => 0x1b9, 321 => 0x1d1 },
	'audiochannelcount' => { 521 => 'audioChannelCount' },
	'audiochannels' => { 69 => 0x70 },
	'audiochanneltype' => { 536 => 'audioChannelType' },
	'audiocompression' => { 87 => 0x816, 158 => 'Compression' },
	'audiocompressor' => { 536 => 'audioCompressor' },
	'audiodata' => { 489 => 'Data' },
	'audioduration' => { 134 => 0x99 },
	'audiogain' => { 400 => 'player.movie.audio.gain' },
	'audiomimetype' => { 489 => 'Mime' },
	'audiomoddate' => { 536 => 'audioModDate' },
	'audiooutcue' => { 134 => 0x9a },
	'audiosamplerate' => { 69 => 0x6e, 536 => 'audioSampleRate' },
	'audiosampletype' => { 536 => 'audioSampleType' },
	'audiosamplingrate' => { 134 => 0x97 },
	'audiosamplingresolution' => { 134 => 0x98 },
	'audiotype' => { 134 => 0x96 },
	'author' => { 160 => 'Author', 332 => 'Author', 336 => 'Author', 397 => 'Author', 398 => ['auth',"\xa9aut"], 400 => 'author', 406 => 'auth', 502 => 'author', 523 => 'Author', 534 => 'Author' },
	'authorsposition' => { 524 => 'AuthorsPosition' },
	'authorurl' => { 182 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 87 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 372 => '0.1' },
	'autobracket' => { 423 => 0x19 },
	'autobracketing' => { 130 => 0x1100, 381 => 0x18, 413 => 0x1007 },
	'autobracketingmode' => { 315 => '12.3' },
	'autobracketingset' => { 315 => '12.1' },
	'autobracketmodem' => { 303 => '21.2', 304 => '13.3', 306 => '13.2', 307 => '13.2', 312 => '26.2', 316 => '13.3', 317 => '13.2', 319 => 0x5f, 320 => 0x5f, 321 => 0x5f },
	'autobracketorder' => { 187 => 0x43, 303 => '21.3', 304 => '13.2', 306 => '13.1', 307 => '13.1', 312 => '26.3', 313 => '12.2', 314 => '2.2', 315 => '12.2', 316 => '13.2', 317 => '13.1', 318 => '13.2', 319 => 0x61, 320 => 0x61, 321 => 0x61 },
	'autobracketset' => { 303 => '21.1', 304 => '13.1', 308 => '11.1', 309 => '12.1', 310 => '12.1', 312 => '26.1', 313 => '12.1', 314 => '2.1', 316 => '13.1', 318 => '13.1' },
	'autobrightness' => { 507 => 'AutoBrightness', 509 => 'AutoBrightness' },
	'autocapturecriteria' => { 199 => 0x1 },
	'autocapturecriteriamotiondirection' => { 199 => 0x5f },
	'autocapturecriteriamotionsize' => { 199 => 0x64 },
	'autocapturecriteriamotionspeed' => { 199 => 0x63 },
	'autocapturecriteriasubjectsize' => { 199 => 0x69 },
	'autocapturecriteriasubjecttype' => { 199 => 0x6a },
	'autocapturedframe' => { 199 => 0x0 },
	'autocapturedistancefar' => { 199 => 0x4a },
	'autocapturedistancenear' => { 199 => 0x4e },
	'autocapturepreset' => { 247 => 0x746 },
	'autocapturerecordingtime' => { 199 => 0x37 },
	'autocapturewaittime' => { 199 => 0x38 },
	'autocontrast' => { 507 => 'AutoContrast', 509 => 'AutoContrast' },
	'autodistortioncontrol' => { 213 => 0x4, 243 => 0x143 },
	'autodynamicrange' => { 130 => 0x140b },
	'autoexposure' => { 507 => 'AutoExposure', 509 => 'AutoExposure' },
	'autoexposurebracketing' => { 79 => 0x10 },
	'autoflashisosensitivity' => { 306 => '38.5', 307 => '38.5', 317 => '38.5', 319 => 0x5b, 320 => 0x5b, 321 => 0x5b },
	'autofocus' => { 326 => 0x209 },
	'autofocusmoderestrictions' => { 319 => 0x107, 320 => 0x107, 321 => 0x11d },
	'autofp' => { 314 => '7.3', 318 => '31.4' },
	'autoiso' => { 79 => 0x1, 116 => 0x3008, 244 => 0x152, 245 => 0x142, 246 => 0x156, 247 => 0x156, 305 => '1.1', 314 => '1.1' },
	'autoisomax' => { 305 => '1.2', 314 => '1.2' },
	'autoisominshutterspeed' => { 305 => '1.3', 314 => '1.3' },
	'autolateralca' => { 507 => 'AutoLateralCA', 509 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 64 => 0x2, 87 => 0x204, 106 => 0x20500, 112 => 0x6f },
	'autolightingoptimizeron' => { 106 => '0x20500.0', 112 => 0x6e },
	'autoportraitframed' => { 446 => 0x2016 },
	'autoredeye' => { 296 => 0xfe28a44f },
	'autorotate' => { 79 => 0x1b },
	'autoshadows' => { 507 => 'AutoShadows', 509 => 'AutoShadows' },
	'autotone' => { 507 => 'AutoTone', 509 => 'AutoTone' },
	'autotonedigest' => { 507 => 'AutoToneDigest', 509 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 507 => 'AutoToneDigestNoSat', 509 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 507 => 'AutoWhiteVersion', 509 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 239 => 0x82 },
	'avaperturesetting' => { 362 => 0x13 },
	'averageblacklevel' => { 47 => 0xe7, 49 => 0xfb, 50 => 0x114, 51 => 0x146 },
	'averagelv' => { 190 => 0x38 },
	'avsettingwithoutlens' => { 87 => 0x707 },
	'azimuth' => { 168 => 'Azimuth' },
	'babyage' => { 346 => [0x8010,0x33] },
	'babyname' => { 346 => 0x66 },
	'backgroundalpha' => { 531 => 'bgalpha' },
	'balance' => { 400 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 362 => 0x15 },
	'baseiso' => { 79 => 0x2, 100 => 0x101c, 141 => 0x903, 348 => 0x312a, 478 => 0x6 },
	'baseisodaylight' => { 141 => 0x910 },
	'baseisoflash' => { 141 => 0x913 },
	'baseisofluorescent' => { 141 => 0x912 },
	'baseisotungsten' => { 141 => 0x911 },
	'baselineexposure' => { 122 => 0xc62a },
	'baselineexposureoffset' => { 122 => 0xc7a5 },
	'baselinenoise' => { 122 => 0xc62b },
	'baselinesharpness' => { 122 => 0xc62c },
	'baserenditionishdr' => { 518 => 'BaseRenditionIsHDR' },
	'baseurl' => { 534 => 'BaseURL' },
	'bass' => { 400 => 'player.movie.audio.bass' },
	'batterylevel' => { 346 => 0x38, 433 => 0x51, 437 => 0xc, 438 => 0x4, 439 => 0x4, 479 => 0x7, 480 => 0x5 },
	'batterylevel2' => { 480 => 0x7 },
	'batterylevelgrip1' => { 479 => 0x6 },
	'batterylevelgrip2' => { 479 => 0x8 },
	'batteryorder' => { 303 => '12.5', 312 => '13.2', 313 => '2.1', 316 => '3.1' },
	'batterystate' => { 187 => 0x60, 433 => 0x50, 439 => 0x14 },
	'batterytemperature' => { 437 => 0x1, 439 => 0x2, 479 => 0x5 },
	'batterytype' => { 66 => 0x38, 409 => 0x66 },
	'batteryunknown' => { 437 => 0x2, 439 => 0x0 },
	'batteryvoltage' => { 141 => 0x408, 407 => 0x2a, 408 => 0x49, 409 => 0x62, 437 => 0x8 },
	'batteryvoltage1' => { 439 => 0x6 },
	'batteryvoltage2' => { 439 => 0x8 },
	'batteryvoltageavg' => { 409 => 0x64 },
	'bayergreensplit' => { 122 => 0xc62d },
	'bayerpattern' => { 140 => 0xf902, 191 => 0x17 },
	'beatsperminute' => { 398 => 'tmpo' },
	'beatspliceparams' => { 536 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 536 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 536 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 536 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 536 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 536 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 303 => '13.1', 304 => '5.4', 305 => '0.1', 308 => '2.1', 309 => '3.1', 310 => '3.1', 312 => '10.1', 314 => '0.1', 316 => '5.5', 318 => '4.1' },
	'beeppitch' => { 313 => '3.1' },
	'beepvolume' => { 313 => '4.5' },
	'bestqualityscale' => { 122 => 0xc65c },
	'bestshotmode' => { 116 => 0x3007 },
	'bitdepth' => { 165 => 'BitDepth', 191 => 0x11, 262 => 0x41 },
	'bitspercomponent' => { 136 => 0x87 },
	'bitspersample' => { 122 => 0x102, 351 => 0xa, 532 => 'BitsPerSample' },
	'blackacquirerows' => { 141 => 0x18ba },
	'blacklevel' => { 122 => [0x7310,0xc61a], 210 => 0x20, 239 => 0x3d, 328 => [0x401,0x1012], 390 => 0x21d, 453 => [0x7300,0x7310] },
	'blacklevel2' => { 327 => 0x600, 331 => 0x600 },
	'blacklevelblue' => { 351 => 0x1e },
	'blacklevelbottom' => { 141 => 0x3f0 },
	'blackleveldata' => { 390 => 0x223 },
	'blackleveldeltah' => { 122 => 0xc61b },
	'blackleveldeltav' => { 122 => 0xc61c },
	'blacklevelgreen' => { 351 => 0x1d },
	'blacklevelred' => { 351 => 0x1c },
	'blacklevelrepeatdim' => { 122 => 0xc619 },
	'blacklevelrough' => { 141 => 0x40e },
	'blacklevelroughafter' => { 141 => 0x416 },
	'blacklevels' => { 37 => 0x1d },
	'blackleveltop' => { 141 => 0x3ef },
	'blackpoint' => { 381 => 0x200 },
	'blacks2012' => { 507 => 'Blacks2012', 509 => 'Blacks2012' },
	'blacksadj' => { 483 => 0x9018 },
	'bleachbypasstoning' => { 381 => 0x7f },
	'blockshotafresponse' => { 306 => '1.5', 307 => '1.5', 317 => '1.5', 319 => 0x7, 320 => 0x7, 321 => 0x7 },
	'blogtitle' => { 526 => 'blogTitle' },
	'blogurl' => { 526 => 'blogURL' },
	'bluebalance' => { 328 => 0x1018, 351 => 0x12, 381 => 0x1b },
	'bluecurvelimits' => { 111 => 0x1fe },
	'bluecurvepoints' => { 110 => 0x79, 111 => 0x1d4 },
	'bluehsl' => { 106 => 0x20915 },
	'bluehue' => { 507 => 'BlueHue', 509 => 'BlueHue' },
	'bluesaturation' => { 507 => 'BlueSaturation', 509 => 'BlueSaturation' },
	'bluratinfinity' => { 493 => 'BlurAtInfinity' },
	'blurcontrol' => { 381 => 0x82 },
	'blurwarning' => { 130 => 0x1300 },
	'bodybatteryadload' => { 360 => 0x3 },
	'bodybatteryadnoload' => { 360 => 0x2 },
	'bodybatterystate' => { 360 => '1.1' },
	'bodybatteryvoltage1' => { 360 => 0x2 },
	'bodybatteryvoltage2' => { 360 => 0x4 },
	'bodybatteryvoltage3' => { 360 => 0x6 },
	'bodybatteryvoltage4' => { 360 => 0x8 },
	'bodyfirmware' => { 414 => 0x0 },
	'bodyfirmwareversion' => { 324 => 0x104, 325 => 0x100, 328 => 0x104 },
	'bodyserialnumber' => { 414 => 0x10 },
	'bookedition' => { 526 => 'bookEdition' },
	'bootloaderversion' => { 408 => 0x26 },
	'bracketbutton' => { 247 => 0x80c },
	'bracketbuttonplaybackmode' => { 247 => 0x816 },
	'bracketincrement' => { 244 => 0x22e, 245 => 0x21a, 246 => 0x22e, 247 => 0x22e },
	'bracketmode' => { 59 => 0x3 },
	'bracketprogram' => { 244 => 0x22c, 245 => 0x218, 246 => 0x22c, 247 => 0x22c },
	'bracketsequence' => { 116 => 0x301d },
	'bracketset' => { 244 => 0x22a, 245 => 0x216, 246 => 0x22a, 247 => 0x22a },
	'bracketsettings' => { 346 => 0x45 },
	'bracketshotnumber' => { 59 => 0x5, 362 => 0x9, 444 => 0x2b },
	'bracketshotnumber2' => { 444 => 0x2d },
	'bracketstep' => { 184 => 0xe },
	'bracketvalue' => { 59 => 0x4 },
	'brightness' => { 122 => 0xfe53, 159 => 'Brightness', 179 => 'Brightness', 184 => 0x2c, 254 => 0x34, 255 => 0x39, 256 => 0x41, 400 => 'player.movie.visual.brightness', 407 => 0x25, 409 => 0x54, 433 => 0x22, 446 => 0x2007, 507 => 'Brightness', 509 => 'Brightness' },
	'brightnessadj' => { 111 => 0x114, 289 => 0x0, 299 => 0x2d, 483 => 0x8018 },
	'brightnessvalue' => { 122 => 0x9203, 190 => [0x691,0x49c3], 328 => 0x1003, 451 => 0x1e, 455 => 0x1140, 456 => 0x1140, 457 => 0x111c, 458 => 0x1198, 459 => 0x1174, 460 => 0x102c, 461 => 0x224, 462 => 0x224, 463 => 0x219, 513 => 'BrightnessValue' },
	'buildnumber' => { 194 => 0x5500 },
	'bulbduration' => { 79 => 0x18 },
	'burstcount' => { 141 => 0x40d },
	'burstgroupid' => { 241 => 0x4 },
	'burstid' => { 490 => 'BurstID' },
	'burstmode' => { 143 => 0xa, 346 => 0x2a },
	'burstmode2' => { 143 => 0x18 },
	'burstprimary' => { 490 => 'BurstPrimary' },
	'burstshot' => { 423 => 0x34 },
	'burstspeed' => { 346 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 87 => 0x70a },
	'bwadjustment' => { 130 => 0x1049 },
	'bwfilter' => { 184 => 0x2a, 192 => 0x39 },
	'bwmagentagreen' => { 130 => 0x104b },
	'bwmode' => { 328 => 0x203 },
	'by-line' => { 134 => 0x50 },
	'by-linetitle' => { 134 => 0x55 },
	'bytecount' => { 526 => 'byteCount' },
	'c14configuration' => { 141 => 0x1964 },
	'cacheversion' => { 122 => 0xc7aa },
	'calibratedfocallength' => { 119 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 119 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 119 => 'CalibratedOpticalCenterY' },
	'calibration' => { 423 => [0x24,0x30] },
	'calibrationhistory' => { 141 => 0x9c9 },
	'calibrationilluminant1' => { 122 => 0xc65a },
	'calibrationilluminant2' => { 122 => 0xc65b },
	'calibrationilluminant3' => { 122 => 0xcd31 },
	'calibrationversion' => { 141 => 0x9c6 },
	'callforimage' => { 497 => 'CallForImage' },
	'camera' => { 486 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 406 => 'angl', 536 => 'cameraAngle' },
	'cameraappinfo' => { 486 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 486 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 486 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 486 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 491 => 'CameraBurstID' },
	'cameracalibration' => { 423 => 0x11f },
	'cameracalibration1' => { 122 => 0xc623 },
	'cameracalibration2' => { 122 => 0xc624 },
	'cameracalibration3' => { 122 => 0xcd32 },
	'cameracalibrationsig' => { 122 => 0xc6f3 },
	'cameracolorcalibration01' => { 38 => 0x0, 39 => 0x0 },
	'cameracolorcalibration02' => { 38 => 0x4, 39 => 0x5 },
	'cameracolorcalibration03' => { 38 => 0x8, 39 => 0xa },
	'cameracolorcalibration04' => { 38 => 0xc, 39 => 0xf },
	'cameracolorcalibration05' => { 38 => 0x10, 39 => 0x14 },
	'cameracolorcalibration06' => { 38 => 0x14, 39 => 0x19 },
	'cameracolorcalibration07' => { 38 => 0x18, 39 => 0x1e },
	'cameracolorcalibration08' => { 38 => 0x1c, 39 => 0x23 },
	'cameracolorcalibration09' => { 38 => 0x20, 39 => 0x28 },
	'cameracolorcalibration10' => { 38 => 0x24, 39 => 0x2d },
	'cameracolorcalibration11' => { 38 => 0x28, 39 => 0x32 },
	'cameracolorcalibration12' => { 38 => 0x2c, 39 => 0x37 },
	'cameracolorcalibration13' => { 38 => 0x30, 39 => 0x3c },
	'cameracolorcalibration14' => { 38 => 0x34, 39 => 0x41 },
	'cameracolorcalibration15' => { 38 => 0x38, 39 => 0x46 },
	'cameradepthmap' => { 486 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 486 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 486 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 486 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 486 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 486 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 486 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 486 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 486 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 486 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 486 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 486 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 400 => 'direction.facing' },
	'camerae-mountversion' => { 482 => 0xb },
	'cameraelevationangle' => { 122 => 0x9405, 514 => 'CameraElevationAngle' },
	'camerafilename' => { 497 => 'CameraFilename' },
	'camerafirmware' => { 122 => 0xa439 },
	'cameraid' => { 328 => 0x209, 406 => 'cmid', 422 => 0x209 },
	'cameraidentifier' => { 400 => 'camera.identifier' },
	'cameraimage' => { 486 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 486 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 486 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 486 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 486 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 486 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 486 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 486 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 486 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 486 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 486 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 486 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 486 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 486 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 36 => 0x10 },
	'cameralabel' => { 122 => 0xc7a1, 536 => 'cameraLabel' },
	'cameralightestimate' => { 486 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 486 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 486 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 486 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 486 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 497 => 'CameraMakeModel' },
	'cameramodel' => { 390 => 0x410, 536 => 'cameraModel' },
	'cameramodelid' => { 179 => 'CameraModelID' },
	'cameramodelrestriction' => { 507 => 'CameraModelRestriction', 509 => 'CameraModelRestriction' },
	'cameramotion' => { 400 => 'direction.motion' },
	'cameramove' => { 536 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 346 => 0x8f, 385 => 0x1, 390 => 0x100, 439 => [0x16,0x18], 469 => 0x28, 470 => 0x24, 471 => 0x29 },
	'cameraowner' => { 144 => 0xc353 },
	'cameraparameters' => { 328 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 118 => 0x9, 406 => "\xa9gpt" },
	'camerapointcloud' => { 486 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 486 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 486 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 486 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 486 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 486 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 486 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 486 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 486 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 486 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 486 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 486 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 486 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 507 => 'CameraProfile', 509 => 'CameraProfile' },
	'cameraprofiledigest' => { 507 => 'CameraProfileDigest', 509 => 'CameraProfileDigest' },
	'cameraprofiles' => { 524 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 524 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 524 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 524 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 524 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 524 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 524 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 524 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 524 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 524 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 524 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 524 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 524 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 524 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 524 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 524 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 112 => 0xe1 },
	'camerarawcontrast' => { 112 => 0xe3 },
	'camerarawhighlightpoint' => { 112 => 0xe6 },
	'camerarawlinear' => { 112 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 112 => 0xe8 },
	'camerarawoutputshadowpoint' => { 112 => 0xe9 },
	'camerarawsaturation' => { 112 => 0xe2 },
	'camerarawshadowpoint' => { 112 => 0xe7 },
	'camerarawsharpness' => { 112 => 0xe5 },
	'cameraroll' => { 118 => 0xb, 406 => "\xa9grl" },
	'cameras' => { 486 => 'Cameras' },
	'cameraserialnumber' => { 122 => 0xc62f, 181 => 'CameraSerialNumber', 497 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 323 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 35 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 79 => 0xc, 141 => 0x406, 327 => 0x1306, 341 => 0x320, 348 => 0x3402, 381 => 0x47, 420 => 0x43, 473 => 0x5 },
	'cameratemperature4' => { 386 => 0x14 },
	'cameratemperature5' => { 386 => 0x16 },
	'cameratemperaturerangemax' => { 124 => 0x5 },
	'cameratemperaturerangemin' => { 124 => 0x6 },
	'cameratrait' => { 486 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 79 => 0x1a, 328 => 0x207 },
	'cameratype2' => { 324 => 0x100 },
	'cameravendorinfo' => { 486 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 486 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 486 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 486 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 118 => 0xa, 406 => "\xa9gyw" },
	'camreverse' => { 119 => 'CamReverse' },
	'canondr4' => { 123 => 'CanonDR4' },
	'canonexposuremode' => { 36 => 0x14 },
	'canonfiledescription' => { 100 => 0x805 },
	'canonfilelength' => { 66 => 0xe },
	'canonfirmwareversion' => { 66 => 0x7, 100 => 0x80b },
	'canonflashinfo' => { 100 => 0x1028 },
	'canonflashmode' => { 36 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 36 => 0xa },
	'canonimagetype' => { 66 => 0x6, 100 => 0x815 },
	'canonlogversion' => { 65 => 0xb },
	'canonmodelid' => { 66 => 0x10, 100 => 0x1834 },
	'canonvrd' => { 123 => 'CanonVRD' },
	'caption' => { 502 => 'caption' },
	'caption-abstract' => { 134 => 0x78 },
	'captionsauthornames' => { 512 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 512 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 524 => 'CaptionWriter' },
	'captureframerate' => { 116 => 0x4001 },
	'captureheightnormal' => { 141 => 0x1839 },
	'capturelook' => { 141 => 0xc48 },
	'capturemode' => { 400 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 495 => 'CaptureSoftware' },
	'capturewidthnormal' => { 141 => 0x1838 },
	'capturewidthtest' => { 141 => 0x1842 },
	'cardshutterlock' => { 187 => 0x49 },
	'casioimagesize' => { 116 => 0x9 },
	'catalogsets' => { 134 => 0xff, 488 => 'CatalogSets', 500 => 'CatalogSets' },
	'categories' => { 66 => 0x23, 502 => 'categories' },
	'category' => { 134 => 0xf, 182 => 'WM/Category', 322 => 0x30, 398 => 'catg', 524 => 'Category' },
	'cbcrgain' => { 420 => 0xa036 },
	'cbcrgaindefault' => { 420 => 0xa035 },
	'cbcrmatrix' => { 420 => 0xa034 },
	'cbcrmatrixdefault' => { 420 => 0xa033 },
	'ccdboardversion' => { 341 => 0x331 },
	'ccdscanmode' => { 328 => 0x1039 },
	'ccdsensitivity' => { 285 => 0x6 },
	'ccdversion' => { 341 => 0x330 },
	'ccvavgluminancenits' => { 517 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 517 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 517 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 517 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 517 => 'ccv_white_xy' },
	'cellglobalid' => { 506 => 'cgi' },
	'celllength' => { 122 => 0x109 },
	'cellr' => { 506 => 'r' },
	'celltowerid' => { 506 => 'cellid' },
	'cellwidth' => { 122 => 0x108 },
	'centerafarea' => { 314 => '15.1' },
	'centerfocuspoint' => { 318 => '2.2' },
	'centerpixel' => { 141 => 0x40c },
	'centerweightedareasize' => { 303 => '7.1', 304 => '8.1', 306 => '8.1', 307 => '8.1', 311 => '7.1', 312 => '5.1', 313 => '7.1', 314 => '6.3', 316 => '8.1', 317 => '8.1', 318 => '8.1', 319 => 0x1f, 320 => 0x1f, 321 => 0x1f },
	'certificate' => { 540 => 'Certificate' },
	'cfainterpolationalgorithm' => { 141 => 0xe60 },
	'cfainterpolationmetric' => { 141 => 0xe61 },
	'cfaoffsetcols' => { 141 => 0xc71 },
	'cfaoffsetrows' => { 141 => 0xc6f },
	'cfapattern' => { 122 => 0xa302, 351 => 0x9, 513 => 'CFAPattern' },
	'cfapattern2' => { 122 => 0x828e },
	'cfapatterncolumns' => { 513 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 513 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 513 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 122 => 0x828d },
	'cfazipperfixthreshold' => { 141 => 0xe62 },
	'channel' => { 526 => 'channel' },
	'channela-lang' => { 526 => [\'channel','channelA-lang'] },
	'channelchannel' => { 526 => [\'channel','channelChannel'] },
	'channels' => { 158 => 'Channels' },
	'channelsubchannel1' => { 526 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 526 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 526 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 526 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 406 => 'chpl' },
	'checkmark' => { 106 => 0x10101, 111 => 0x26a },
	'checkmark2' => { 112 => 0x8e },
	'childfontfiles' => { 541 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 303 => '10.3', 304 => '11.2', 319 => 0x10b, 320 => 0x10b, 321 => 0x121 },
	'chromablurradius' => { 122 => 0xc631 },
	'chromanoisecolorspace' => { 141 => 0xe6d },
	'chromanoiseedgemapthresh' => { 141 => 0xe6c },
	'chromanoisehighfthresh' => { 141 => 0xe6a },
	'chromanoiselowfthresh' => { 141 => 0xe6b },
	'chromaticaberration' => { 106 => 0x20703, 112 => 0x66, 420 => 0xa051 },
	'chromaticaberrationb' => { 507 => 'ChromaticAberrationB', 509 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 106 => 0x20708, 112 => 0x6b },
	'chromaticaberrationcorr' => { 81 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 122 => 0x7034, 371 => 0x1, 483 => 0x900d },
	'chromaticaberrationcorrparams' => { 122 => 0x7035, 477 => 0x66a, 478 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 106 => '0x20703.0', 112 => 0x62 },
	'chromaticaberrationr' => { 507 => 'ChromaticAberrationR', 509 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 106 => 0x20707, 112 => 0x6a },
	'chromaticaberrationsetting' => { 82 => 0x6 },
	'chrominancenoisereduction' => { 106 => 0x20601, 112 => 0x5e, 423 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 112 => 0x60 },
	'circadatecreated' => { 521 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 509 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 507 => 'CircularGradientBasedCorrections', 509 => 'CircularGradientBasedCorrections' },
	'city' => { 134 => 0x5a, 164 => 'City', 346 => 0x6d, 524 => 'City' },
	'city2' => { 346 => 0x80 },
	'clarity' => { 130 => 0x100f, 255 => 0x35, 256 => 0x3d, 446 => 0x2036, 507 => 'Clarity', 509 => 'Clarity' },
	'clarity2012' => { 507 => 'Clarity2012', 509 => 'Clarity2012' },
	'claritycontrol' => { 381 => 0x96 },
	'classification' => { 406 => 'clsf' },
	'classifystate' => { 134 => 0xe1 },
	'clearretouch' => { 346 => 0x7c },
	'clearretouchvalue' => { 346 => 0xa3 },
	'client' => { 536 => 'client' },
	'clientname' => { 515 => 'ClientName' },
	'clipboardaspectratio' => { 507 => 'ClipboardAspectRatio', 509 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 507 => 'ClipboardOrientation', 509 => 'ClipboardOrientation' },
	'clipfilename' => { 406 => 'clfn' },
	'clipid' => { 406 => 'clid' },
	'clmodeshootingspeed' => { 303 => '10.2', 304 => '11.3', 306 => '11.2', 307 => '11.2', 312 => '11.2', 313 => '10.2', 316 => '11.2', 317 => '11.2', 318 => '11.1', 319 => 0x3b, 320 => 0x3b, 321 => 0x3b },
	'cluster' => { 507 => 'Cluster', 509 => 'Cluster' },
	'cmcontrast' => { 331 => 0x2022 },
	'cmddialsreverserotation' => { 319 => 0xba, 320 => 0xba, 321 => 0xba },
	'cmexposurecompensation' => { 331 => 0x2000 },
	'cmhue' => { 331 => 0x2021 },
	'cmsaturation' => { 331 => 0x2020 },
	'cmsharpness' => { 331 => 0x2023 },
	'cmwhitebalance' => { 331 => 0x2001 },
	'cmwhitebalancecomp' => { 331 => 0x2002 },
	'cmwhitebalancegraypoint' => { 331 => 0x2010 },
	'codec' => { 172 => 'Codec' },
	'codedcharacterset' => { 135 => 0x5a },
	'codeversion' => { 406 => 'cver' },
	'collection' => { 336 => 'Collection' },
	'collectionname' => { 173 => [\'Collections','CollectionsCollectionName'], 406 => 'coll' },
	'collections' => { 173 => 'Collections', 502 => 'collections' },
	'collectionuri' => { 173 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 400 => 'player.movie.visual.color', 525 => 'color' },
	'coloraberrationcontrol' => { 296 => 0xc89224b },
	'coloradjustment' => { 423 => 0x14 },
	'coloradjustmentmode' => { 422 => 0x210 },
	'coloranta' => { 541 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 541 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 541 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 541 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 541 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 541 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 541 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 541 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 541 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 541 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 541 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 541 => 'Colorants' },
	'colorantswatchname' => { 541 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 541 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 541 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 541 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 159 => 'ColorBalance' },
	'colorbalanceadj' => { 296 => 0x76a43202 },
	'colorbalanceblue' => { 184 => 0x1e },
	'colorbalancegreen' => { 184 => 0x1d },
	'colorbalancered' => { 184 => 0x1c },
	'colorbalanceversion' => { 209 => 0x4, 210 => 0x4, 211 => 0x0, 212 => 0x0 },
	'colorblur' => { 112 => 0x65 },
	'colorbluron' => { 106 => 0x20704 },
	'colorbooster' => { 296 => 0x5f0e7d23 },
	'colorboostlevel' => { 290 => 0x1 },
	'colorboosttype' => { 290 => 0x0 },
	'colorchromeeffect' => { 130 => 0x1048 },
	'colorchromefxblue' => { 130 => 0x104e },
	'colorclass' => { 392 => 0xde, 393 => 'ColorClass' },
	'colorcompensationfilter' => { 187 => [0x3a,0x5f], 189 => 0x111, 446 => 0xb022 },
	'colorcompensationfiltercustom' => { 433 => 0xd, 434 => 0xc },
	'colorcompensationfilterset' => { 433 => 0x8, 434 => 0x7, 435 => 0x18, 451 => 0xf },
	'colorcontrol' => { 328 => 0x102b },
	'colorcorrection' => { 483 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 323 => 0x532 },
	'colordataversion' => { 43 => 0x0, 44 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0 },
	'coloreffect' => { 346 => 0x28 },
	'colorfilter' => { 115 => 0x17, 116 => 0x3017, 184 => 0x29, 192 => [0x38,0x4d,0x4f], 388 => 0x17 },
	'colorgain' => { 262 => 0x51 },
	'colorgradeblending' => { 507 => 'ColorGradeBlending', 509 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 507 => 'ColorGradeGlobalHue', 509 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 507 => 'ColorGradeGlobalLum', 509 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 507 => 'ColorGradeGlobalSat', 509 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 507 => 'ColorGradeHighlightLum', 509 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 507 => 'ColorGradeMidtoneHue', 509 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 507 => 'ColorGradeMidtoneLum', 509 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 507 => 'ColorGradeMidtoneSat', 509 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 507 => 'ColorGradeShadowLum', 509 => 'ColorGradeShadowLum' },
	'colorhue' => { 106 => 0x20900, 239 => 0x8d },
	'colorimetricreference' => { 122 => 0xc6bf },
	'colorlabel' => { 512 => 'ColorLabel' },
	'colormatrix' => { 65 => 0xa, 327 => 0x200, 328 => 0x1011, 420 => 0xa030 },
	'colormatrix1' => { 122 => 0xc621, 390 => 0x106 },
	'colormatrix2' => { 122 => 0xc622, 331 => 0x200, 390 => 0x226 },
	'colormatrix3' => { 122 => 0xcd33 },
	'colormatrixa' => { 381 => 0x203 },
	'colormatrixa2' => { 381 => 0x21c },
	'colormatrixadobergb' => { 420 => 0xa032 },
	'colormatrixb' => { 381 => 0x204 },
	'colormatrixb2' => { 381 => 0x21d },
	'colormatrixnumber' => { 328 => 0x1019 },
	'colormatrixsrgb' => { 420 => 0xa031 },
	'colormode' => { 116 => 0x3015, 130 => 0x1210, 143 => 0x66, 184 => 0x28, 187 => 0x16, 189 => 0x101, 190 => 0x36, 192 => 0x7, 239 => 0x3, 285 => 0x4, 346 => 0x32, 423 => 0x2c, 446 => 0xb029, 524 => 'ColorMode' },
	'colormoirereduction' => { 106 => 0x20670, 297 => 0x15 },
	'colormoirereductionmode' => { 297 => 0x5 },
	'colormoirereductionon' => { 106 => '0x20670.0' },
	'colornoisereduction' => { 483 => 0x8029, 507 => 'ColorNoiseReduction', 509 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 507 => 'ColorNoiseReductionDetail', 509 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 297 => 0x18 },
	'colornoisereductionsharpness' => { 297 => 0x1c },
	'colornoisereductionsmoothness' => { 507 => 'ColorNoiseReductionSmoothness', 509 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 126 => 0x2 },
	'colorprofile' => { 184 => 0x33 },
	'colorprofilesettings' => { 323 => 0x539 },
	'colorrepresentation' => { 136 => 0x3c },
	'colorsaturationadj' => { 106 => 0x20305 },
	'colorsequence' => { 136 => 0x41 },
	'colorspace' => { 53 => 0x3, 66 => 0xb4, 100 => 0x10b4, 122 => 0xa001, 138 => 0x3, 165 => 'ColorSpace', 185 => 0x2f, 186 => 0x25, 187 => 0x17, 239 => 0x1e, 323 => 0x507, 381 => 0x37, 420 => 0xa011, 423 => 0xb, 433 => 0x1b, 434 => 0x83, 435 => 0xe, 451 => 0x6, 513 => 'ColorSpace' },
	'colorspace2' => { 65 => 0x9 },
	'colorspecapproximation' => { 138 => 0x2 },
	'colorspecdata' => { 138 => 0x3 },
	'colorspecmethod' => { 138 => 0x0 },
	'colorspecprecedence' => { 138 => 0x1 },
	'colortempasshot' => { 40 => 0x4, 41 => 0x7, 42 => 0x1d, 43 => 0x59, 44 => 0x6d, 45 => 0x26, 46 => 0x43, 49 => 0x43, 50 => 0x43, 51 => 0x43, 52 => 0x4b },
	'colortempauto' => { 40 => 0x9, 41 => 0xf, 42 => 0x22, 43 => 0x5e, 44 => 0x72, 45 => 0x1c, 46 => 0x48, 49 => 0x48, 50 => 0x48, 51 => 0x48, 52 => 0x50 },
	'colortempcloudy' => { 40 => 0x22, 41 => 0x37, 42 => 0x31, 43 => 0xa4, 44 => 0xdb, 45 => 0x35, 46 => 0x5c, 49 => 0x75, 50 => 0x8e, 51 => 0x93, 52 => 0x96, 381 => 0x55 },
	'colortempcustom' => { 46 => 0x84 },
	'colortempcustom1' => { 42 => 0x45 },
	'colortempcustom2' => { 42 => 0x4a },
	'colortempdaylight' => { 40 => 0x18, 41 => 0x27, 42 => 0x27, 43 => 0x9a, 44 => 0xd1, 45 => 0x2b, 46 => 0x52, 49 => 0x6b, 50 => 0x84, 51 => 0x89, 52 => 0x8c, 381 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 66 => 0xae, 76 => 0x9, 100 => 0x10ae, 130 => 0x1005, 141 => 0x846, 159 => 'ColorTemperature', 185 => [0x6e,0x49], 186 => 0x3f, 187 => [0x39,0x5e], 189 => 0x10b, 192 => [0x3c,0x4c,0x4e], 341 => 0x321, 381 => 0x50, 413 => 0x1308, 446 => 0xb021, 507 => 'Temperature', 509 => 'Temperature' },
	'colortemperatureadj' => { 483 => 0x8013 },
	'colortemperatureauto' => { 239 => 0x4f },
	'colortemperaturebg' => { 328 => 0x1013 },
	'colortemperaturecustom' => { 433 => 0xc, 434 => 0xb },
	'colortemperaturerg' => { 328 => 0x1014 },
	'colortemperatureset' => { 433 => 0x7, 434 => 0x6 },
	'colortemperaturesetting' => { 187 => 0x25, 435 => 0x17, 451 => 0xe },
	'colortempflash' => { 40 => 0x36, 41 => 0x57, 42 => 0x40, 43 => 0xb8, 44 => 0xef, 45 => 0x49, 46 => 0x70, 49 => 0x89, 50 => 0xa2, 51 => 0xa7, 52 => 0xaa, 381 => 0x5a },
	'colortempflashdata' => { 46 => 0x24a },
	'colortempfluorescent' => { 40 => 0x2c, 41 => 0x47, 42 => 0x3b, 43 => 0xae, 44 => 0xe5, 45 => 0x3f, 46 => 0x66, 49 => 0x7f, 50 => 0x98, 51 => 0x9d, 52 => 0xa0 },
	'colortempfluorescentd' => { 381 => 0x57 },
	'colortempfluorescentn' => { 381 => 0x58 },
	'colortempfluorescentw' => { 381 => 0x59 },
	'colortempkelvin' => { 40 => 0x31, 41 => 0x4f, 43 => 0xb3, 44 => 0xea, 45 => 0x44, 46 => 0x6b, 49 => 0x84, 50 => 0x9d, 51 => 0xa2, 52 => 0xa5, 346 => 0x44, 413 => 0x1307 },
	'colortempmeasured' => { 40 => 0xe, 41 => 0x17, 43 => 0x63, 44 => 0x77, 46 => 0x4d, 49 => 0x4d, 50 => 0x4d, 51 => 0x4d, 52 => 0x55 },
	'colortemppc1' => { 45 => 0x94, 46 => 0x75 },
	'colortemppc2' => { 45 => 0x99, 46 => 0x7a },
	'colortemppc3' => { 45 => 0x9e, 46 => 0x7f },
	'colortempshade' => { 40 => 0x1d, 41 => 0x2f, 42 => 0x2c, 43 => 0x9f, 44 => 0xd6, 45 => 0x30, 46 => 0x57, 49 => 0x70, 50 => 0x89, 51 => 0x8e, 52 => 0x91, 381 => 0x54 },
	'colortemptungsten' => { 40 => 0x27, 41 => 0x3f, 42 => 0x36, 43 => 0xa9, 44 => 0xe0, 45 => 0x3a, 46 => 0x61, 49 => 0x7a, 50 => 0x93, 51 => 0x98, 52 => 0x9b, 381 => 0x56 },
	'colortempunknown' => { 40 => 0x13, 41 => 0x1f, 43 => 0x68, 44 => 0x7c, 45 => 0x21, 49 => 0x52, 50 => 0x52, 51 => 0x52, 52 => 0x5a },
	'colortempunknown10' => { 40 => 0x63, 41 => 0x9f, 43 => 0x95, 44 => 0xa9, 45 => 0x76, 49 => 0xa2, 50 => 0x7f, 51 => 0x7f, 52 => 0x87 },
	'colortempunknown11' => { 40 => 0x68, 41 => 0xa7, 43 => 0xbd, 44 => [0xae,0xb3], 45 => 0x7b, 49 => 0xa7, 50 => 0xa7, 51 => 0x84, 52 => 0xaf },
	'colortempunknown12' => { 40 => 0x6d, 41 => 0xaf, 43 => 0xc2, 44 => 0xb8, 45 => 0x80, 49 => 0xac, 50 => 0xac, 51 => 0xac, 52 => 0xb4 },
	'colortempunknown13' => { 40 => 0x72, 41 => 0xb7, 43 => 0xc7, 44 => 0xbd, 45 => 0x85, 49 => 0xb1, 50 => 0xb1, 51 => 0xb1, 52 => 0xb9 },
	'colortempunknown14' => { 43 => 0xcc, 44 => 0xc2, 45 => 0x8a, 49 => 0xb6, 50 => 0xb6, 51 => 0xb6, 52 => 0xbe },
	'colortempunknown15' => { 43 => 0xd1, 44 => 0xc7, 45 => 0x8f, 49 => 0xbb, 50 => 0xbb, 51 => 0xbb, 52 => 0xc3 },
	'colortempunknown16' => { 43 => 0xd6, 44 => 0xcc, 45 => 0xa3, 50 => 0xc0, 51 => 0xc0, 52 => 0xc8 },
	'colortempunknown17' => { 43 => 0xdb, 44 => 0xf4, 50 => 0xc5, 51 => 0xc5, 52 => 0xcd },
	'colortempunknown18' => { 43 => 0xe0, 44 => 0xf9, 50 => 0xca, 51 => 0xca, 52 => 0xd2 },
	'colortempunknown19' => { 43 => 0xe5, 44 => 0xfe, 50 => 0xcf, 51 => 0xcf, 52 => 0xd7 },
	'colortempunknown2' => { 40 => 0x3b, 41 => 0x5f, 43 => 0x6d, 44 => 0x81, 45 => 0x4e, 49 => 0x57, 50 => 0x57, 51 => 0x57, 52 => 0x5f },
	'colortempunknown20' => { 43 => 0xea, 44 => 0x103, 50 => 0xd4, 51 => 0xd4, 52 => 0xdc },
	'colortempunknown21' => { 43 => 0xef, 44 => 0x108, 51 => 0xd9, 52 => 0xe1 },
	'colortempunknown22' => { 43 => 0xf4, 44 => 0x10d, 51 => 0xde, 52 => 0xe6 },
	'colortempunknown23' => { 43 => 0xf9, 44 => 0x112, 51 => 0xe3, 52 => 0xeb },
	'colortempunknown24' => { 43 => 0xfe, 44 => 0x117, 51 => 0xe8, 52 => 0xf0 },
	'colortempunknown25' => { 43 => 0x103, 44 => 0x11c, 51 => 0xed, 52 => 0xf5 },
	'colortempunknown26' => { 43 => 0x108, 44 => 0x121, 51 => 0xf2, 52 => 0xfa },
	'colortempunknown27' => { 43 => 0x10d, 44 => 0x126, 51 => 0xf7, 52 => 0xff },
	'colortempunknown28' => { 43 => 0x112, 51 => 0xfc, 52 => 0x104 },
	'colortempunknown29' => { 43 => 0x117, 51 => 0x101, 52 => 0x109 },
	'colortempunknown3' => { 40 => 0x40, 41 => 0x67, 43 => 0x72, 44 => 0x86, 45 => 0x53, 49 => 0x5c, 50 => 0x5c, 51 => 0x5c, 52 => 0x64 },
	'colortempunknown30' => { 51 => 0x106 },
	'colortempunknown4' => { 40 => 0x45, 41 => 0x6f, 43 => 0x77, 44 => 0x8b, 45 => 0x58, 49 => 0x61, 50 => 0x61, 51 => 0x61, 52 => 0x69 },
	'colortempunknown5' => { 40 => 0x4a, 41 => 0x77, 43 => 0x7c, 44 => 0x90, 45 => 0x5d, 49 => 0x66, 50 => 0x66, 51 => 0x66, 52 => 0x6e },
	'colortempunknown6' => { 40 => 0x4f, 41 => 0x7f, 43 => 0x81, 44 => 0x95, 45 => 0x62, 49 => 0x8e, 50 => 0x6b, 51 => 0x6b, 52 => 0x73 },
	'colortempunknown7' => { 40 => 0x54, 41 => 0x87, 43 => 0x86, 44 => 0x9a, 45 => 0x67, 49 => 0x93, 50 => 0x70, 51 => 0x70, 52 => 0x78 },
	'colortempunknown8' => { 40 => 0x59, 41 => 0x8f, 43 => 0x8b, 44 => 0x9f, 45 => 0x6c, 49 => 0x98, 50 => 0x75, 51 => 0x75, 52 => 0x7d },
	'colortempunknown9' => { 40 => 0x5e, 41 => 0x97, 43 => 0x90, 44 => 0xa4, 45 => 0x71, 49 => 0x9d, 50 => 0x7a, 51 => 0x7a, 52 => 0x82 },
	'colortint' => { 345 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 36 => 0x2a, 53 => 0x2, 65 => 0x8 },
	'colortoneadj' => { 106 => 0x20304, 111 => 0x11e },
	'colortoneauto' => { 73 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 72 => 0x6c, 73 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 72 => 0x3c, 73 => 0x3c },
	'colortonemonochrome' => { 72 => 0x84, 73 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 72 => 0x54, 73 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 72 => 0x24, 73 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 72 => 0xc, 73 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 72 => 0x9c, 73 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 72 => 0xb4, 73 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 72 => 0xcc, 73 => 0xe4 },
	'columninterleavefactor' => { 122 => 0xcd43 },
	'comlenblksize' => { 141 => 0xfde8 },
	'commanddialplaybackmode' => { 319 => 0x1cb, 320 => 0x1cb, 321 => 0x1e3 },
	'commanddials' => { 314 => '5.1' },
	'commanddialsaperturesetting' => { 303 => '17.3', 304 => '18.3', 306 => '18.3', 307 => '18.3', 312 => '33.3', 313 => '17.3', 316 => '18.3', 317 => '18.3' },
	'commanddialschangemainsub' => { 303 => '17.2', 304 => '18.1', 306 => '18.1', 307 => '18.1', 312 => '33.2', 313 => '17.2', 316 => '18.1', 317 => '18.1' },
	'commanddialsmenuandplayback' => { 303 => '17.4', 304 => '18.2', 306 => '18.2', 307 => '18.2', 312 => '33.4', 313 => '17.4', 316 => '18.2', 317 => '18.2' },
	'commanddialsreverserotation' => { 303 => '17.1', 304 => '6.4', 306 => '6.2', 307 => '6.2', 308 => '16.2', 309 => '17.2', 312 => '33.1', 313 => '17.1', 316 => '6.2', 317 => '6.2', 318 => '18.1' },
	'commanderchannel' => { 314 => '10.2', 315 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 314 => '13.1', 315 => '31.1' },
	'commandergroupa_ttlcomp' => { 318 => '32.1' },
	'commandergroupamanualoutput' => { 314 => '13.2', 315 => '28.2' },
	'commandergroupamode' => { 314 => '11.2', 315 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 314 => '14.1', 315 => '32.1' },
	'commandergroupb_ttlcomp' => { 318 => '33.1' },
	'commandergroupbmanualoutput' => { 314 => '14.2', 315 => '29.2' },
	'commandergroupbmode' => { 314 => '11.3', 315 => '29.1' },
	'commanderinternalflash' => { 314 => '11.1', 315 => '27.1' },
	'commanderinternalmanualoutput' => { 314 => '12.2', 315 => '27.2' },
	'commanderinternalttlchannel' => { 312 => '18.2' },
	'commanderinternalttlcomp' => { 314 => '12.1', 315 => '30.2', 318 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 312 => '20.1', 313 => '26.1' },
	'commanderinternalttlcompgroupa' => { 312 => '21.1', 313 => '27.1' },
	'commanderinternalttlcompgroupb' => { 312 => '22.1', 313 => '28.1' },
	'comment' => { 0 => 0x2, 123 => 'Comment', 160 => 'Comment', 336 => 'Comment', 398 => "\xa9cmt", 400 => 'comment', 406 => "\xa9cmt" },
	'compass' => { 416 => 0x4 },
	'compatibleversion' => { 507 => 'CompatibleVersion', 509 => 'CompatibleVersion' },
	'compilation' => { 398 => 'cpil' },
	'compimageimagespersequence' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 514 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 526 => 'complianceProfile' },
	'componentsconfiguration' => { 122 => 0x9101, 165 => 'Components', 513 => 'ComponentsConfiguration' },
	'componentversion' => { 100 => 0x80c },
	'composer' => { 182 => 'WM/Composer', 398 => ["\xa9com","\xa9wrt"], 406 => ["\xa9com","\xa9wrt"], 536 => 'composer' },
	'composerid' => { 398 => 'cmID' },
	'composerkeywords' => { 406 => "\xa9cok" },
	'compositeimage' => { 122 => 0xa460, 514 => 'CompositeImage' },
	'compositeimagecount' => { 122 => 0xa461, 514 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 122 => 0xa462, 514 => 'CompositeImageExposureTimes' },
	'composition' => { 497 => 'Composition' },
	'compositionadjust' => { 380 => '0.1' },
	'compositionadjustrotation' => { 380 => 0x7 },
	'compositionadjustx' => { 380 => 0x5 },
	'compositionadjusty' => { 380 => 0x6 },
	'compressedbitsperpixel' => { 122 => 0x9102, 513 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 189 => 0x40, 328 => 0x40 },
	'compression' => { 122 => 0x103, 351 => 0xb, 532 => 'Compression' },
	'compressionfactor' => { 323 => 0x50d },
	'compressionformat' => { 65 => 0x4 },
	'compressionratio' => { 165 => 'Compression', 328 => 0x1034 },
	'compressorversion' => { 406 => 'CNCV' },
	'condadobvfactor' => { 141 => 0xf3e },
	'condadodaybvthresh' => { 141 => 0xf3c },
	'condadodayoffsets' => { 141 => 0xf42 },
	'condadofluoffsets' => { 141 => 0xf44 },
	'condadofluthresh' => { 141 => 0xf41 },
	'condadoillfactor' => { 141 => 0xf3f },
	'condadoneurange' => { 141 => 0xf3d },
	'condadotunoffsets' => { 141 => 0xf43 },
	'condadotunthresh' => { 141 => 0xf40 },
	'conductor' => { 182 => 'WM/Conductor', 398 => "\xa9con" },
	'confidence' => { 492 => 'Confidence' },
	'confidencelevel' => { 503 => 'ConfidenceLevel' },
	'confidencemime' => { 492 => 'ConfidenceMime' },
	'constrainedcropheight' => { 111 => 0x266, 392 => 0xd6 },
	'constrainedcropwidth' => { 111 => 0x262, 392 => 0xd5 },
	'contact' => { 134 => 0x76 },
	'contactinfo' => { 507 => 'ContactInfo', 509 => 'ContactInfo', 525 => 'contactInfo' },
	'container' => { 486 => 'Container' },
	'containerdirectory' => { 486 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 486 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 486 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 486 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 486 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 486 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 521 => 'ContainerFormat' },
	'containerformatidentifier' => { 521 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 521 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 398 => "\xa9day", 406 => ['@day',"\xa9day"] },
	'contentdistributor' => { 182 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 406 => 'cdis' },
	'contentid' => { 406 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 400 => 'content.identifier' },
	'contentlocationcode' => { 134 => 0x1a },
	'contentlocationname' => { 134 => 0x1b },
	'contenttype' => { 526 => 'contentType' },
	'continuousbracketing' => { 187 => 0x20 },
	'continuousdrive' => { 36 => 0x5 },
	'continuousmodedisplay' => { 319 => 0x51, 320 => 0x51, 321 => 0x51 },
	'continuousmodeliveview' => { 317 => '77.2' },
	'continuousshootingspeed' => { 87 => 0x610 },
	'continuousshotlimit' => { 87 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 36 => 0xd, 115 => 0xc, 116 => [0x3012,0x20], 122 => [0xa408,0xfe54], 130 => [0x1004,0x1006], 159 => 'Contrast', 179 => 'Contrast', 184 => 0x20, 185 => 0x31, 186 => 0x27, 187 => 0x19, 192 => 0x2, 254 => 0x33, 255 => 0x37, 256 => 0x3f, 328 => 0x1029, 346 => 0x39, 348 => 0x300a, 381 => 0x20, 388 => 0xc, 400 => 'player.movie.visual.contrast', 407 => 0x24, 409 => 0x52, 413 => 0x1012, 423 => 0xd, 433 => 0x1d, 434 => 0x1a, 446 => 0x2004, 507 => 'Contrast', 509 => 'Contrast', 513 => 'Contrast' },
	'contrast2012' => { 507 => 'Contrast2012', 509 => 'Contrast2012' },
	'contrastadj' => { 106 => 0x20303, 111 => 0x115, 299 => 0x2c, 483 => 0x8017 },
	'contrastauto' => { 73 => 0x90 },
	'contrastcurve' => { 239 => 0x8c },
	'contrastdetectaf' => { 196 => 0x4 },
	'contrastdetectafarea' => { 381 => 0x231 },
	'contrastdetectafinfocus' => { 196 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 72 => 0x60, 73 => 0x60 },
	'contrasthighlight' => { 381 => 0x6d },
	'contrasthighlightshadowadj' => { 381 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 72 => 0x30, 73 => 0x30 },
	'contrastmode' => { 346 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 72 => 0x78, 73 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 72 => 0x48, 73 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 72 => 0x18, 73 => 0x18 },
	'contrastsetting' => { 323 => 0x505, 331 => 0x1012, 435 => 0x10, 451 => 0x8 },
	'contrastshadow' => { 381 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 72 => 0x0, 73 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 72 => 0x90, 73 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 72 => 0xa8, 73 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 72 => 0xc0, 73 => 0xd8 },
	'contributedmedia' => { 536 => 'contributedMedia' },
	'contributedmediaduration' => { 536 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 536 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 536 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 536 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 536 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 536 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 536 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 536 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 536 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 536 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 510 => 'contributor', 521 => 'Contributor' },
	'contributoridentifier' => { 521 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 521 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 521 => [\'Contributor','ContributorRole'] },
	'contributors' => { 160 => 'Contributors' },
	'controldialset' => { 187 => 0x46 },
	'controlledvocabularyterm' => { 521 => 'CVterm' },
	'controllerboardversion' => { 341 => 0x332 },
	'controlmode' => { 79 => 0x12 },
	'controlringresponse' => { 319 => 0x1d5, 320 => 0x1d5, 321 => 0x1ed },
	'controlringrotation' => { 87 => 0x712 },
	'conversionlens' => { 324 => 0x403, 346 => 0x35 },
	'converter' => { 122 => 0xfe4d, 285 => 0xb, 507 => 'Converter', 509 => 'Converter' },
	'converttograyscale' => { 507 => 'ConvertToGrayscale', 509 => 'ConvertToGrayscale' },
	'cookingequipment' => { 528 => 'cookingEquipment' },
	'cookingmethod' => { 528 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 122 => 0x8298, 160 => 'Copyright', 336 => 'Copyright', 351 => 0x8298, 381 => 0x22f, 397 => 'Copyright', 398 => ['cprt',"\xa9cpy"], 400 => 'copyright', 406 => ['cprt',"\xa9cpy"], 507 => 'Copyright', 509 => 'Copyright', 523 => 'Copyright', 529 => 'copyright', 532 => 'Copyright', 536 => 'copyright' },
	'copyrightflag' => { 395 => 0x40a },
	'copyrightnotice' => { 134 => 0x74 },
	'copyrightowner' => { 333 => 'CopyrightOwner' },
	'copyrightownerid' => { 333 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 333 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 333 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 333 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 333 => 'CopyrightStatus' },
	'copyrightyear' => { 521 => 'CopyrightYear', 526 => 'copyrightYear' },
	'coringfilter' => { 327 => 0x310, 328 => 0x102d, 331 => 0x310 },
	'coringvalues' => { 327 => 0x311, 331 => 0x311 },
	'corporateentity' => { 526 => 'corporateEntity' },
	'correlatedcolortemp' => { 345 => 0x35b },
	'country' => { 164 => 'Country', 346 => 0x69, 524 => 'Country' },
	'country-primarylocationcode' => { 134 => 0x64 },
	'country-primarylocationname' => { 134 => 0x65 },
	'countrycode' => { 238 => 0x5, 393 => 'CountryCode', 520 => 'CountryCode' },
	'course' => { 528 => 'course' },
	'coverage' => { 510 => 'coverage' },
	'coverart' => { 398 => 'covr' },
	'coverdate' => { 526 => 'coverDate' },
	'coverdisplaydate' => { 526 => 'coverDisplayDate' },
	'coveruri' => { 406 => 'cvru' },
	'cpufirmwareversion' => { 381 => 0x28 },
	'crc32' => { 511 => 'crc32' },
	'createdate' => { 122 => 0x9004, 160 => 'CreateDate', 332 => 'CreationDate', 336 => 'create-date', 397 => 'CreationDate', 403 => 0x1, 534 => 'CreateDate' },
	'creationdate' => { 400 => 'creationdate', 523 => 'CreationDate', 526 => 'creationDate' },
	'creationtime' => { 336 => 'Creation Time' },
	'creativestyle' => { 433 => 0x1a, 434 => 0x18, 444 => 0x41, 446 => 0xb020, 478 => 0x4a },
	'creativestylesetting' => { 435 => 0xf, 451 => 0x7 },
	'creativestylewaschanged' => { 483 => 0x8001 },
	'creator' => { 332 => 'Creator', 397 => 'Creator', 510 => 'creator', 521 => 'Creator', 523 => 'Creator' },
	'creatoraddress' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 181 => 'CreatorAppId' },
	'creatorcity' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 520 => 'CreatorContactInfo' },
	'creatorcountry' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 521 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 393 => 'CreatorIdentity' },
	'creatorname' => { 521 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 181 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 521 => [\'Creator','CreatorRole'] },
	'creatortool' => { 534 => 'CreatorTool' },
	'creatorworkemail' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 520 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 134 => 0x6e, 524 => 'Credit' },
	'creditline' => { 529 => 'creditLine' },
	'creditlinereq' => { 539 => 'CreditLineReq' },
	'creditlinerequired' => { 333 => 'CreditLineRequired' },
	'cropactive' => { 104 => 0x0, 111 => 0x244 },
	'cropangle' => { 507 => 'CropAngle', 509 => 'CropAngle' },
	'croparea' => { 239 => 0x45, 483 => 0x9011 },
	'cropaspectratio' => { 106 => 0x30101, 111 => 0x260 },
	'cropaspectratiocustom' => { 106 => 0x30102 },
	'cropbottom' => { 126 => 0x9, 291 => 0x36, 351 => 0x31, 392 => 0xdc, 507 => 'CropBottom', 509 => 'CropBottom' },
	'cropbottommargin' => { 55 => 0x3 },
	'cropcircleactive' => { 112 => 0xd6 },
	'cropcircleradius' => { 112 => 0xd9 },
	'cropcirclex' => { 112 => 0xd7 },
	'cropcircley' => { 112 => 0xd8 },
	'cropconstraintowarp' => { 507 => 'CropConstrainToWarp', 509 => 'CropConstrainToWarp' },
	'croph' => { 501 => 'CropH' },
	'cropheight' => { 104 => 0x6, 111 => 0x24c, 327 => 0x615, 331 => 0x615, 507 => 'CropHeight', 509 => 'CropHeight' },
	'crophispeed' => { 239 => 0x1b },
	'cropleft' => { 111 => 0x246, 126 => 0x6, 291 => 0x1e, 327 => 0x612, 331 => 0x612, 351 => 0x30, 392 => 0xd9, 507 => 'CropLeft', 509 => 'CropLeft' },
	'cropleftmargin' => { 55 => 0x0 },
	'cropmode' => { 130 => 0x104d, 413 => 0x1018 },
	'croporiginalheight' => { 104 => 0xb },
	'croporiginalwidth' => { 104 => 0xa },
	'cropoutputheight' => { 291 => 0xce },
	'cropoutputheightinches' => { 291 => 0x96 },
	'cropoutputpixels' => { 291 => 0xd6 },
	'cropoutputresolution' => { 291 => 0xb6 },
	'cropoutputscale' => { 291 => 0xbe },
	'cropoutputwidth' => { 291 => 0xc6 },
	'cropoutputwidthinches' => { 291 => 0x8e },
	'croppedareaimageheightpixels' => { 495 => 'CroppedAreaImageHeightPixels', 496 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 495 => 'CroppedAreaImageWidthPixels', 496 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 495 => 'CroppedAreaLeftPixels', 496 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 495 => 'CroppedAreaTopPixels', 496 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 413 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 413 => 0x1603 },
	'cropping' => { 483 => 0x9010 },
	'cropright' => { 126 => 0x8, 291 => 0x2e, 351 => 0x32, 392 => 0xdb, 507 => 'CropRight', 509 => 'CropRight' },
	'croprightmargin' => { 55 => 0x1 },
	'croprotatedoriginalheight' => { 104 => 0x2 },
	'croprotatedoriginalwidth' => { 104 => 0x1 },
	'croprotation' => { 104 => 0x8, 126 => 0xb },
	'cropscaledresolution' => { 291 => 0x9e },
	'cropsourceresolution' => { 291 => 0xae },
	'croptop' => { 111 => 0x248, 126 => 0x7, 291 => 0x26, 327 => 0x613, 331 => 0x613, 351 => 0x2f, 392 => 0xda, 507 => 'CropTop', 509 => 'CropTop' },
	'croptopmargin' => { 55 => 0x2 },
	'cropunit' => { 507 => 'CropUnit', 509 => 'CropUnit' },
	'cropunits' => { 507 => 'CropUnits', 509 => 'CropUnits' },
	'cropw' => { 501 => 'CropW' },
	'cropwidth' => { 104 => 0x5, 111 => 0x24a, 327 => 0x614, 331 => 0x614, 507 => 'CropWidth', 509 => 'CropWidth' },
	'cropx' => { 104 => 0x3, 501 => 'CropX' },
	'cropy' => { 104 => 0x4, 501 => 'CropY' },
	'crossprocess' => { 381 => 0x7b },
	'crossprocessparams' => { 381 => 0x235 },
	'cuisine' => { 528 => 'cuisine' },
	'currenticcprofile' => { 122 => 0xc691 },
	'currentpreprofilematrix' => { 122 => 0xc692 },
	'currentversion' => { 483 => 0xd000 },
	'curve0x' => { 501 => 'Curve0x' },
	'curve0y' => { 501 => 'Curve0y' },
	'curve1x' => { 501 => 'Curve1x' },
	'curve1y' => { 501 => 'Curve1y' },
	'curve2x' => { 501 => 'Curve2x' },
	'curve2y' => { 501 => 'Curve2y' },
	'curve3x' => { 501 => 'Curve3x' },
	'curve3y' => { 501 => 'Curve3y' },
	'curve4x' => { 501 => 'Curve4x' },
	'curve4y' => { 501 => 'Curve4y' },
	'curves' => { 296 => 0x76a43201 },
	'custom1' => { 333 => 'Custom1' },
	'custom10' => { 333 => 'Custom10' },
	'custom2' => { 333 => 'Custom2' },
	'custom3' => { 333 => 'Custom3' },
	'custom4' => { 333 => 'Custom4' },
	'custom5' => { 333 => 'Custom5' },
	'custom6' => { 333 => 'Custom6' },
	'custom7' => { 333 => 'Custom7' },
	'custom8' => { 333 => 'Custom8' },
	'custom9' => { 333 => 'Custom9' },
	'customcolortone' => { 112 => 0x4c },
	'customcontrast' => { 112 => 0x4e },
	'customcontrols' => { 87 => 0x70c },
	'customdefaultunsharpfineness' => { 112 => 0xbe },
	'customdefaultunsharpstrength' => { 112 => 0xbc },
	'customdefaultunsharpthreshold' => { 112 => 0xc0 },
	'customilluminant' => { 141 => 0x405 },
	'customizedials' => { 87 => 0x715 },
	'customlinear' => { 112 => 0x4f },
	'customoutputhighlightpoint' => { 112 => 0x53 },
	'customoutputshadowpoint' => { 112 => 0x54 },
	'custompicturestyle' => { 106 => 0x10021 },
	'custompicturestyledata' => { 106 => 0xf0500 },
	'custompicturestylefilename' => { 66 => 0x4010 },
	'customrawhighlight' => { 112 => 0x7c },
	'customrawhighlightpoint' => { 112 => 0x51 },
	'customrawshadow' => { 112 => 0x85 },
	'customrawshadowpoint' => { 112 => 0x52 },
	'customrendered' => { 122 => 0xa401, 194 => 0x6420, 513 => 'CustomRendered' },
	'customsaturation' => { 112 => 0x4d, 323 => 0x503 },
	'customsettingsalldefault' => { 303 => '0.2', 312 => '0.2' },
	'customsettingsbank' => { 303 => '0.1', 304 => '0.1', 306 => '0.1', 307 => '0.1', 312 => '0.1', 316 => '0.2', 317 => '0.2', 319 => 0x1, 320 => 0x1, 321 => 0x1 },
	'customsharpness' => { 112 => 0x50 },
	'customunsharpmaskfineness' => { 112 => 0xb8 },
	'customunsharpmaskstrength' => { 112 => 0xb6 },
	'customunsharpmaskthreshold' => { 112 => 0xba },
	'customwb_rblevels' => { 451 => 0x1a },
	'customwb_rgblevels' => { 434 => 0x8, 435 => 0x19 },
	'customwbbluelevel' => { 187 => 0x36 },
	'customwberror' => { 187 => 0x37 },
	'customwbgreenlevel' => { 187 => 0x35 },
	'customwbredlevel' => { 187 => 0x34 },
	'customwbsetting' => { 187 => 0x26 },
	'cx' => { 406 => '_cx_' },
	'cy' => { 406 => '_cy_' },
	'd-lightinghq' => { 296 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 292 => 0x2 },
	'd-lightinghqhighlight' => { 292 => 0x1 },
	'd-lightinghqselected' => { 296 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 292 => 0x0 },
	'd-lightinghs' => { 296 => 0xce5554aa },
	'd-lightinghsadjustment' => { 293 => 0x0 },
	'd-lightinghscolorboost' => { 293 => 0x1 },
	'd-rangeoptimizerhighlight' => { 483 => 0x8024 },
	'd-rangeoptimizermode' => { 483 => 0x8022 },
	'd-rangeoptimizershadow' => { 483 => 0x802d },
	'd-rangeoptimizervalue' => { 483 => 0x8023 },
	'darkblacksegrows' => { 141 => 0x18d8 },
	'darkfocusenvironment' => { 346 => 0x8003 },
	'darkframecountfactor' => { 141 => 0xc85 },
	'darkframelongexposure' => { 141 => 0xc84 },
	'darkframeshortexposure' => { 141 => 0xc83 },
	'darkpedestal' => { 141 => 0xc7f },
	'datacompressionmethod' => { 136 => 0x6e },
	'dataimprint' => { 184 => 0x34 },
	'datamining' => { 333 => 'DataMining' },
	'dataonscreen' => { 521 => 'DataOnScreen' },
	'dataonscreenregion' => { 521 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 521 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 521 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 521 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 521 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 521 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 521 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 521 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 381 => 0x3d },
	'date' => { 381 => 0x6, 510 => 'date' },
	'dateacquired' => { 181 => 'DateAcquired', 182 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 134 => 0x37, 524 => 'DateCreated' },
	'datedisplayformat' => { 288 => 0x3 },
	'dateidentified' => { 121 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 308 => '4.2' },
	'daterecieved' => { 526 => 'dateRecieved' },
	'datesent' => { 135 => 0x46 },
	'datestampmode' => { 66 => 0x1c, 239 => 0x9d },
	'datetime' => { 502 => 'datetime', 532 => 'DateTime' },
	'datetimedigitized' => { 513 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 103 => 0x0, 122 => 0x9003, 157 => 0x14, 160 => 'OriginalDate', 401 => 'IDIT', 406 => 'date', 407 => 0xb, 408 => 0x3b, 409 => 0x3e, 513 => 'DateTimeOriginal' },
	'datetimestamp' => { 143 => 0x64 },
	'datetimeutc' => { 323 => 0x908 },
	'daylightsavings' => { 80 => 0x3, 288 => 0x2 },
	'dayofweek' => { 408 => 0x42, 409 => 0x4a },
	'dccontinent' => { 121 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 121 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 121 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 121 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 121 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 121 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 121 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 121 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 121 => 'Event' },
	'dcfootprintspatialfit' => { 121 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 121 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 121 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 121 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 121 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 121 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 121 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 121 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 121 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 121 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 121 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 121 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 121 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 121 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 121 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 121 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 121 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 121 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 168 => 'Declination' },
	'decposition' => { 184 => 0x32 },
	'defaultautogray' => { 507 => 'DefaultAutoGray', 509 => 'DefaultAutoGray' },
	'defaultautotone' => { 507 => 'DefaultAutoTone', 509 => 'DefaultAutoTone' },
	'defaultblackrender' => { 122 => 0xc7a6 },
	'defaultcroporigin' => { 122 => 0xc61f },
	'defaultcropsize' => { 122 => 0xc620 },
	'defaulteraseoption' => { 87 => 0x813 },
	'defaultscale' => { 122 => 0xc61e },
	'defaultsspecifictoiso' => { 507 => 'DefaultsSpecificToISO', 509 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 507 => 'DefaultsSpecificToSerial', 509 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 122 => 0xc7b5 },
	'defectisocode' => { 141 => 0x90f },
	'defringe' => { 507 => 'Defringe', 509 => 'Defringe' },
	'defringegreenamount' => { 507 => 'DefringeGreenAmount', 509 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 507 => 'DefringeGreenHueHi', 509 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 507 => 'DefringeGreenHueLo', 509 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 507 => 'DefringePurpleAmount', 509 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 507 => 'DefringePurpleHueHi', 509 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 507 => 'DefringePurpleHueLo', 509 => 'DefringePurpleHueLo' },
	'dehaze' => { 507 => 'Dehaze', 509 => 'Dehaze' },
	'deletedimagecount' => { 239 => 0xa6, 267 => 0x6e },
	'deprecatedon' => { 505 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 507 => 'DepthBasedCorrections', 509 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 509 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 122 => 0xc7eb },
	'depthformat' => { 122 => 0xc7e9 },
	'depthimage' => { 492 => 'Data' },
	'depthmapinfo' => { 507 => 'DepthMapInfo', 509 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 509 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 509 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 509 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 509 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 509 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 509 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 509 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 509 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 507 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 509 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 507 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 509 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 122 => 0xc7ed },
	'depthnear' => { 122 => 0xc7ea },
	'depthunits' => { 122 => 0xc7ec },
	'derivedfrom' => { 537 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 537 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 537 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 537 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 537 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 537 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 537 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 537 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 537 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 537 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 537 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 537 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 537 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 537 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 537 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 537 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 537 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 537 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 537 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 537 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 537 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 537 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 537 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 537 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 336 => 'Description', 398 => ['desc','dscp',"\xa9des"], 400 => 'description', 406 => 'dscp', 507 => 'Description', 509 => 'Description', 510 => 'description', 534 => 'Description' },
	'destination' => { 135 => 0x5 },
	'destinationcity' => { 381 => 0x24, 387 => 0x3 },
	'destinationcitycode' => { 388 => 0x1001 },
	'destinationdst' => { 381 => 0x26, 387 => '0.3' },
	'developmentdynamicrange' => { 130 => 0x1403 },
	'deviantmatrixcustom' => { 141 => 0x7de },
	'deviantmatrixdaylight' => { 141 => 0x7da },
	'deviantmatrixflash' => { 141 => 0x7dd },
	'deviantmatrixfluorescent' => { 141 => 0x7dc },
	'deviantmatrixtungsten' => { 141 => 0x7db },
	'deviantwhitecustom' => { 141 => 0x842 },
	'deviantwhitedaylight' => { 141 => 0x83e },
	'deviantwhiteflash' => { 141 => 0x841 },
	'deviantwhitefluorescent' => { 141 => 0x840 },
	'deviantwhitetungsten' => { 141 => 0x83f },
	'device' => { 526 => 'device' },
	'devicesettingdescription' => { 513 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 513 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 513 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 513 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 420 => 0x2 },
	'dewarpdata' => { 119 => 'DewarpData' },
	'dewarpflag' => { 119 => 'DewarpFlag' },
	'dialdirectiontvav' => { 87 => 0x706 },
	'dietaryneeds' => { 528 => 'dietaryNeeds' },
	'diffractioncompensation' => { 228 => 0x20e, 243 => 0x142, 244 => 0x1b2, 245 => 0x1a2, 246 => 0x1b6, 247 => 0x1b6 },
	'diffractioncorrection' => { 346 => 0xbc, 371 => 0x3 },
	'diffractioncorrectionon' => { 106 => 0x2070b },
	'digitalcreationdate' => { 134 => 0x3e },
	'digitalcreationtime' => { 134 => 0x3f },
	'digitaldeehighlightadj' => { 262 => 0x202 },
	'digitaldeeshadowadj' => { 262 => 0x200 },
	'digitaldeethreshold' => { 262 => 0x201 },
	'digitalfilter' => { 423 => 0x59 },
	'digitalfilter01' => { 368 => 0x5 },
	'digitalfilter02' => { 368 => 0x16 },
	'digitalfilter03' => { 368 => 0x27 },
	'digitalfilter04' => { 368 => 0x38 },
	'digitalfilter05' => { 368 => 0x49 },
	'digitalfilter06' => { 368 => 0x5a },
	'digitalfilter07' => { 368 => 0x6b },
	'digitalfilter08' => { 368 => 0x7c },
	'digitalfilter09' => { 368 => 0x8d },
	'digitalfilter10' => { 368 => 0x9e },
	'digitalfilter11' => { 368 => 0xaf },
	'digitalfilter12' => { 368 => 0xc0 },
	'digitalfilter13' => { 368 => 0xd1 },
	'digitalfilter14' => { 368 => 0xe2 },
	'digitalfilter15' => { 368 => 0xf3 },
	'digitalfilter16' => { 368 => 0x104 },
	'digitalfilter17' => { 368 => 0x115 },
	'digitalfilter18' => { 368 => 0x126 },
	'digitalfilter19' => { 368 => 0x137 },
	'digitalfilter20' => { 368 => 0x148 },
	'digitalgain' => { 76 => 0xb },
	'digitalgem' => { 223 => 0x0 },
	'digitalice' => { 262 => 0x100 },
	'digitalimageguid' => { 521 => 'DigImageGUID' },
	'digitallensoptimizer' => { 64 => 0xa },
	'digitallensoptimizersetting' => { 82 => 0x9 },
	'digitalroc' => { 259 => 0x0 },
	'digitalsourcefiletype' => { 521 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 521 => 'DigitalSourceType' },
	'digitalzoom' => { 36 => 0xc, 115 => 0xa, 130 => 0x1044, 143 => 0x68, 154 => 0x22, 155 => 0x1e, 159 => 'DigitalZoom', 184 => 0xc, 239 => 0x86, 285 => 0xa, 328 => 0x204, 381 => 0x1e, 388 => 0xa, 422 => 0x204, 469 => 0x12, 470 => 0x12 },
	'digitalzoomon' => { 422 => 0x21b },
	'digitalzoomratio' => { 122 => 0xa404, 457 => 0x200, 459 => 0x21c, 513 => 'DigitalZoomRatio' },
	'director' => { 182 => 'WM/Director', 398 => "\xa9dir", 400 => 'director', 406 => "\xa9dir", 536 => 'director' },
	'directorphotography' => { 536 => 'directorPhotography' },
	'directory' => { 123 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 216 => 0x3, 409 => 0x12 },
	'disableautocreation' => { 490 => 'DisableAutoCreation' },
	'disclaimer' => { 336 => 'Disclaimer' },
	'discnumber' => { 536 => 'discNumber' },
	'dishtype' => { 528 => 'dishType' },
	'disknumber' => { 398 => 'disk' },
	'dispbutton' => { 247 => 0x7d4, 319 => 0x2ab },
	'displayallafpoints' => { 87 => 0x514 },
	'displayaperture' => { 36 => 0x23 },
	'displayedunitsx' => { 396 => 0x2 },
	'displayedunitsy' => { 396 => 0x6 },
	'displayname' => { 400 => 'displayname', 525 => 'displayName' },
	'distance1' => { 143 => 0x28 },
	'distance2' => { 143 => 0x2c },
	'distance3' => { 143 => 0x30 },
	'distance4' => { 143 => 0x34 },
	'distortion' => { 420 => 0xa050 },
	'distortioncompensation' => { 483 => 0x8040 },
	'distortioncontrol' => { 267 => 0x10 },
	'distortioncorrection' => { 81 => 0x3, 106 => 0x20705, 112 => 0x67, 122 => 0x7036, 214 => 0x4, 323 => 0x50b, 350 => '7.1', 371 => 0x0, 477 => 0x601, 478 => 0x5b },
	'distortioncorrection2' => { 327 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 504 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 106 => '0x20705.0', 112 => 0x63 },
	'distortioncorrectionsetting' => { 82 => 0x7, 446 => 0x2013 },
	'distortioncorrectionvalue' => { 81 => 0x9 },
	'distortioncorrectionversion' => { 214 => 0x0 },
	'distortioncorrparams' => { 122 => 0x7037, 456 => 0x1a23, 459 => 0x1870, 461 => 0x189c, 462 => 0x18cc, 463 => 0x17d0, 477 => 0x6ca, 478 => 0x64 },
	'distortioncorrparamsnumber' => { 459 => 0x1899, 461 => 0x18c5, 462 => 0x18f5, 463 => 0x17f9 },
	'distortioncorrparamspresent' => { 459 => 0x1898, 461 => 0x18c4, 462 => 0x18f4, 463 => 0x17f8, 465 => 0x10b, 466 => 0x10b, 477 => 0x600, 478 => 0x5a },
	'distortioneffect' => { 106 => 0x20709 },
	'distortionn' => { 350 => 0xc },
	'distortionparam02' => { 350 => 0x2 },
	'distortionparam04' => { 350 => 0x4 },
	'distortionparam08' => { 350 => 0x8 },
	'distortionparam09' => { 350 => 0x9 },
	'distortionparam11' => { 350 => 0xb },
	'distortionscale' => { 350 => 0x5 },
	'distributor' => { 526 => 'distributor' },
	'distributorproductid' => { 525 => 'distributorProductID' },
	'dloon' => { 106 => '0x20706.0', 112 => 0xdc },
	'dlosetting' => { 106 => 0x20706, 112 => 0xdd },
	'dlosettingapplied' => { 105 => 0x4 },
	'dloshootingdistance' => { 112 => 0xde },
	'dloversion' => { 105 => 0x5 },
	'dmcomment' => { 536 => 'comment' },
	'dmdithermatrix' => { 141 => 0xc7a },
	'dmdithermatrixheight' => { 141 => 0xc7c },
	'dmdithermatrixwidth' => { 141 => 0xc7b },
	'dngadobedata' => { 122 => 0xc634 },
	'dngbackwardversion' => { 122 => 0xc613 },
	'dngignoresidecars' => { 507 => 'DNGIgnoreSidecars', 509 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 122 => 0xc630 },
	'dngprivatedata' => { 122 => 0xc634 },
	'dngversion' => { 122 => 0xc612 },
	'document' => { 336 => 'Document' },
	'documentancestors' => { 524 => 'DocumentAncestors' },
	'documenthistory' => { 134 => 0xe7 },
	'documentid' => { 537 => 'DocumentID' },
	'documentname' => { 122 => 0x10d },
	'documentnotes' => { 134 => 0xe6 },
	'doi' => { 526 => 'doi' },
	'dopesheet' => { 521 => 'Dopesheet' },
	'dopesheetlink' => { 521 => 'DopesheetLink' },
	'dopesheetlinklink' => { 521 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 521 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 141 => 0xc82 },
	'dpp' => { 502 => 'dpp' },
	'dr4cameramodel' => { 107 => 0x3 },
	'drangepriority' => { 130 => 0x1443 },
	'drangepriorityauto' => { 130 => 0x1444 },
	'drangepriorityfixed' => { 130 => 0x1445 },
	'drivemode' => { 116 => 0x3103, 128 => '0.1', 184 => 0x6, 187 => 0x1e, 190 => 0xe, 194 => 0x64d0, 323 => 0x600, 381 => 0x34, 413 => 0x1002, 423 => 0x3, 433 => 0x4, 434 => 0x7e, 435 => 0x34 },
	'drivemode2' => { 187 => 0xa, 362 => 0x7, 444 => 0xe, 451 => 0x1 },
	'drivemodesetting' => { 435 => 0x4 },
	'drivespeed' => { 128 => '0.2' },
	'dspfirmwareversion' => { 381 => 0x27 },
	'dualpixelraw' => { 64 => 0xb },
	'duration' => { 69 => 0x6a, 158 => 'Duration', 172 => 'Duration', 528 => 'duration', 536 => 'duration' },
	'durationscale' => { 536 => [\'duration','durationScale'] },
	'durationvalue' => { 536 => [\'duration','durationValue'] },
	'dustremovaldata' => { 66 => 0x97 },
	'dxcropalert' => { 244 => 0x250, 245 => 0x23c, 246 => 0x250, 247 => 0x250 },
	'dynamicafarea' => { 303 => '1.4', 312 => '1.4' },
	'dynamicafareasize' => { 244 => 0x254, 245 => 0x240, 246 => 0x254, 247 => 0x254 },
	'dynamicareaafassist' => { 319 => 0x18, 320 => 0x18, 321 => 0x18 },
	'dynamicareaafdisplay' => { 304 => '46.1', 306 => '47.1', 307 => '47.1', 316 => '47.1', 317 => '47.1' },
	'dynamicrange' => { 130 => 0x1400 },
	'dynamicrangeboost' => { 346 => 0xee },
	'dynamicrangeexpansion' => { 381 => 0x69, 413 => 0x100e },
	'dynamicrangemax' => { 111 => 0x7c },
	'dynamicrangemin' => { 111 => 0x7a },
	'dynamicrangeoptimizer' => { 187 => 0x15, 446 => [0xb025,0xb04f], 455 => 0x1144, 456 => [0x1144,0x324], 457 => [0x1120,0x300], 458 => [0x119c,0x37c], 459 => [0x1178,0x328], 460 => [0x1030,0x50], 461 => [0x228,0x50], 462 => [0x228,0x50], 463 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 444 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 433 => 0x19, 434 => 0x17, 435 => 0xd, 444 => 0x79, 451 => 0x5 },
	'dynamicrangeoptimizermode' => { 190 => 0x15, 433 => 0x18, 434 => 0x16, 444 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 187 => 0x27, 435 => 0xc, 451 => 0x4 },
	'dynamicrangesetting' => { 130 => 0x1402 },
	'e-dialinprogram' => { 362 => '1.3' },
	'earliestageorloweststage' => { 121 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 486 => 'EarthPos' },
	'earthposaltitude' => { 486 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 486 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 486 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 486 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 486 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 486 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 486 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 486 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 318 => '6.1' },
	'easyexposurecompensation' => { 303 => '6.4', 304 => '6.5', 306 => '6.3', 307 => '6.3', 311 => '5.1', 312 => '4.4', 313 => '5.2', 316 => '6.3', 317 => '6.3', 319 => 0x1d, 320 => 0x1d, 321 => 0x1d },
	'easymode' => { 36 => 0xb },
	'edgemapslope' => { 141 => 0x930 },
	'edgemapx1' => { 141 => 0x931 },
	'edgemapx2' => { 141 => 0x932 },
	'edgemapx3' => { 141 => 0x934 },
	'edgemapx4' => { 141 => 0x935 },
	'edgenoisereduction' => { 297 => 0x4, 483 => 0x8028 },
	'edit1' => { 406 => "\xa9ed1" },
	'edit2' => { 406 => "\xa9ed2" },
	'edit3' => { 406 => "\xa9ed3" },
	'edit4' => { 406 => "\xa9ed4" },
	'edit5' => { 406 => "\xa9ed5" },
	'edit6' => { 406 => "\xa9ed6" },
	'edit7' => { 406 => "\xa9ed7" },
	'edit8' => { 406 => "\xa9ed8" },
	'edit9' => { 406 => "\xa9ed9" },
	'edition' => { 526 => 'edition' },
	'editorialupdate' => { 134 => 0x8 },
	'editstatus' => { 134 => 0x7, 393 => 'EditStatus', 502 => 'EditStatus' },
	'editversionname' => { 296 => 0x3d136244 },
	'effectivelv' => { 381 => 0x2d },
	'effectivemaxaperture' => { 232 => 0x12, 233 => 0x13, 237 => 0x14 },
	'eissn' => { 526 => 'eIssn' },
	'electricalblackcolumns' => { 141 => 0x1810 },
	'electronicfront-curtainshutter' => { 306 => '5.2', 307 => '5.2', 316 => '5.3', 317 => '5.2' },
	'electronicfrontcurtainshutter' => { 446 => 0x201a },
	'elevation' => { 168 => 'Elevation' },
	'email' => { 160 => 'EMail' },
	'embargodate' => { 529 => 'embargoDate' },
	'embdencrightsexpr' => { 521 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 521 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 521 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 521 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 524 => 'EmbeddedXMPDigest' },
	'emissivity' => { 124 => 0x3 },
	'emptyslotrelease' => { 244 => 0x723, 245 => 0x625, 246 => 0x655, 247 => 0x6bd },
	'enablechromanoisereduction' => { 141 => 0xe6e },
	'enablesharpening' => { 141 => 0x92e },
	'encodedby' => { 182 => 'WM/EncodedBy', 398 => "\xa9enc" },
	'encodedwith' => { 400 => 'Encoded_With' },
	'encoder' => { 398 => "\xa9too", 400 => 'encoder', 406 => "\xa9too" },
	'encoderid' => { 406 => "\xa9enc" },
	'encodingtime' => { 182 => 'WM/EncodingTime' },
	'encryptionkey' => { 420 => 0xa020 },
	'endingpage' => { 526 => 'endingPage' },
	'enduser' => { 333 => 'EndUser' },
	'enduserid' => { 333 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 333 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 244 => 0x746, 245 => 0x648, 246 => 0x678, 247 => 0x6e0 },
	'engineer' => { 536 => 'engineer' },
	'enhancedarktones' => { 289 => 0x8 },
	'enhancedenoisealreadyapplied' => { 504 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 504 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 504 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 504 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 504 => 'EnhanceDetailsVersion' },
	'enhancement' => { 115 => 0x16, 116 => 0x3016 },
	'enhanceparams' => { 122 => 0xc7ee },
	'enhancer' => { 327 => 0x300 },
	'enhancervalues' => { 327 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 504 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 504 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 504 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 135 => 0x28 },
	'envelopepriority' => { 135 => 0x3c },
	'enveloperecordversion' => { 135 => 0x0 },
	'episode' => { 521 => 'Episode' },
	'episodeglobaluniqueid' => { 398 => 'egid' },
	'episodeidentifier' => { 521 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 521 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 521 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 328 => 0x20c },
	'epsonimagewidth' => { 328 => 0x20b },
	'epsonsoftware' => { 328 => 0x20d },
	'equipmentinstitution' => { 485 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 485 => 'EquipmentManufacturer' },
	'equipmentversion' => { 324 => 0x0 },
	'ettlii' => { 87 => 0x304, 88 => 0xd, 89 => 0xe, 90 => 0x7, 91 => 0x7, 92 => 0xe },
	'event' => { 488 => 'Event', 500 => 'Event', 521 => 'Event', 526 => 'event' },
	'eventalias' => { 525 => 'eventAlias' },
	'eventdate' => { 121 => [\'Event','EventEventDate'] },
	'eventday' => { 121 => [\'Event','EventDay'] },
	'eventearliestdate' => { 121 => [\'Event','EventEarliestDate'] },
	'eventend' => { 525 => 'eventEnd' },
	'eventenddayofyear' => { 121 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 121 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 121 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 121 => [\'Event','EventHabitat'] },
	'eventid' => { 121 => [\'Event','EventEventID'], 521 => 'EventId' },
	'eventlatestdate' => { 121 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 121 => [\'Event','EventMonth'] },
	'eventnumber' => { 407 => 0x9, 408 => 0x37, 409 => 0x3a },
	'eventparenteventid' => { 121 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 121 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 121 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 121 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 121 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 121 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 525 => 'eventStart' },
	'eventstartdayofyear' => { 121 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 525 => 'eventSubtype' },
	'eventtime' => { 121 => [\'Event','EventEventTime'] },
	'eventtype' => { 525 => 'eventType' },
	'eventverbatimeventdate' => { 121 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 121 => [\'Event','EventYear'] },
	'evfgrid' => { 319 => 0x165, 320 => 0x165, 321 => 0x17d },
	'evfimageframe' => { 319 => 0x164, 320 => 0x164, 321 => 0x17c },
	'evfreleaseindicator' => { 319 => 0x24f, 320 => 0x24f, 321 => 0x267 },
	'evfwarmdisplaybrightness' => { 319 => 0x24d, 320 => 0x24d, 321 => 0x265 },
	'evfwarmdisplaymode' => { 319 => 0x24b, 320 => 0x24b, 321 => 0x263 },
	'evsteps' => { 362 => '1.2', 364 => 0x0 },
	'evstepsize' => { 308 => '5.1', 309 => '6.1', 310 => '6.1', 314 => '0.7' },
	'exclusivecoverage' => { 497 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 529 => 'exclusivityEndDate' },
	'excursiontolerance' => { 136 => 0x82 },
	'executiveproducer' => { 398 => "\xa9xpd" },
	'exif' => { 123 => 'EXIF' },
	'exifbyteorder' => { 123 => 'ExifByteOrder' },
	'exifcamerainfo' => { 134 => 0xe8 },
	'exifimageheight' => { 122 => 0xa003, 513 => 'PixelYDimension' },
	'exifimagewidth' => { 122 => 0xa002, 513 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 123 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 122 => 0x9000, 513 => 'ExifVersion' },
	'exitpupilposition' => { 232 => 0x4, 233 => 0x4, 237 => 0x4 },
	'expirationdate' => { 134 => 0x25, 529 => 'expirationDate' },
	'expirationtime' => { 134 => 0x26 },
	'exposure' => { 122 => 0xfe51, 507 => 'Exposure', 509 => 'Exposure' },
	'exposure2012' => { 507 => 'Exposure2012', 509 => 'Exposure2012' },
	'exposureadj' => { 294 => 0x0 },
	'exposureadj2' => { 294 => 0x12 },
	'exposureadjust' => { 423 => 0xc },
	'exposurebracketingindicatorlast' => { 187 => 0x52 },
	'exposurebracketshotnumber' => { 190 => 0x2d, 444 => 0x2f },
	'exposurebracketstepsize' => { 362 => 0x8 },
	'exposurebracketvalue' => { 239 => 0x19 },
	'exposurecompautocancel' => { 87 => 0x113 },
	'exposurecompensation' => { 79 => 0x6, 96 => 0x0, 122 => 0x9204, 143 => 0x24, 159 => 'ExposureComp', 179 => 'ExposureCompensation', 184 => 0xd, 185 => 0x53, 186 => 0x1e, 190 => 0x49c0, 328 => 0x1006, 381 => 0x16, 390 => 0x402, 420 => 0xa013, 423 => [0xc,0x35,0x4d], 455 => 0x114c, 456 => 0x114c, 457 => 0x1128, 459 => 0x1180, 460 => 0x1038, 461 => 0x230, 462 => 0x230, 463 => 0x223, 513 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 451 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 247 => 0x794 },
	'exposurecompensationmode' => { 187 => 0x47, 190 => 0x2a },
	'exposurecompensationset' => { 433 => 0x3, 434 => 0x3, 435 => 0x3, 451 => 0x1e },
	'exposurecompensationsetting' => { 187 => 0x1 },
	'exposurecompstepsize' => { 303 => '6.3', 304 => '7.3', 306 => '7.3', 307 => '7.3', 312 => '4.3', 316 => '7.3', 317 => '7.3' },
	'exposurecontrolstep' => { 311 => '6.1', 313 => '6.1' },
	'exposurecontrolstepsize' => { 303 => '6.2', 304 => '7.1', 306 => '7.1', 307 => '7.1', 312 => '4.2', 316 => '7.1', 317 => '7.1', 318 => '7.1', 319 => 0x1b, 320 => 0x1b, 321 => 0x1b },
	'exposurecount' => { 130 => 0x1032 },
	'exposuredelay' => { 247 => 0x800 },
	'exposuredelaymode' => { 303 => '10.1', 304 => '11.1', 306 => '11.1', 307 => '11.1', 308 => '9.1', 309 => '10.1', 310 => '10.1', 312 => '10.4', 313 => '10.1', 314 => '6.4', 316 => '11.1', 317 => '11.1', 318 => '11.2' },
	'exposuredifference' => { 239 => 0xe },
	'exposuregaincustom' => { 141 => 0x89c },
	'exposuregaindaylight' => { 141 => 0x898 },
	'exposuregainflash' => { 141 => 0x89b },
	'exposuregainfluorescent' => { 141 => 0x89a },
	'exposuregaintungsten' => { 141 => 0x899 },
	'exposureindex' => { 122 => 0xa215, 513 => 'ExposureIndex' },
	'exposureindicator' => { 187 => 0x50 },
	'exposurelevelincrements' => { 85 => 0x6, 86 => 0x6, 87 => 0x101, 88 => 0x5, 89 => 0x6, 90 => 0x5, 91 => 0x5, 92 => 0x6, 93 => 0x4, 433 => 0x58, 434 => 0x58 },
	'exposurelockused' => { 495 => 'ExposureLockUsed' },
	'exposuremode' => { 122 => 0xa402, 159 => 'ExposureMode', 184 => 0x1, 185 => 0xa, 186 => 0x0, 187 => 0x0, 190 => 0x34, 323 => 0x200, 343 => 0x40d, 423 => 0x8, 446 => 0xb041, 513 => 'ExposureMode' },
	'exposuremodeinmanual' => { 87 => 0x10b },
	'exposureprogram' => { 122 => 0x8822, 413 => 0x1001, 426 => [0x17e,0x43], 433 => 0x3c, 434 => 0x3c, 435 => 0x5, 439 => 0x14, 444 => 0x3f, 451 => 0x2, 455 => 0x1175, 456 => 0x1179, 457 => 0x1155, 458 => 0x11d1, 459 => 0x11ad, 460 => 0x1065, 461 => 0x25d, 462 => 0x25d, 463 => 0x24c, 474 => 0xb, 475 => 0xc, 476 => 0xb, 478 => 0x48, 513 => 'ExposureProgram' },
	'exposureshift' => { 323 => 0x203 },
	'exposurestandardadjustment' => { 446 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 79 => 0x16, 122 => 0x829a, 140 => 0xfd05, 143 => 0x20, 145 => 0xfa24, 147 => 0xf104, 150 => 0x12, 152 => 0x38, 154 => 0x14, 155 => 0x10, 157 => 0x10, 159 => 'ExposureTime', 184 => 0x9, 185 => 0x35, 186 => 0x48, 187 => 0x8, 190 => 0x49b8, 381 => 0x12, 420 => 0xa018, 423 => [0x32,0x4a], 433 => 0x0, 434 => 0x0, 451 => [0x21,0x23,0x27], 478 => 0x10, 513 => 'ExposureTime' },
	'exposuretime2' => { 423 => [0x33,0x4b] },
	'exposuretuning' => { 239 => 0x1c },
	'exposurevalue' => { 141 => 0x3 },
	'exposurewarning' => { 130 => 0x1302 },
	'exrauto' => { 130 => 0x1033 },
	'exrmode' => { 130 => 0x1034 },
	'extdescraccessibility' => { 520 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 244 => 0x120, 245 => 0x114, 246 => 0x124, 247 => 0x124 },
	'extendedshutterspeeds' => { 319 => 0x102, 320 => 0x102, 321 => 0x118 },
	'extendedwbdetect' => { 323 => 0x902 },
	'extender' => { 324 => 0x301 },
	'extenderfirmwareversion' => { 324 => 0x304 },
	'extendermagnification' => { 161 => 'Magnification' },
	'extendermake' => { 161 => 'Make' },
	'extendermodel' => { 161 => 'Model', 324 => 0x303 },
	'extenderserialnumber' => { 161 => 'SerialNumber', 324 => 0x302 },
	'extenderstatus' => { 379 => 0x3 },
	'externalflash' => { 326 => 0x1201 },
	'externalflashae1' => { 328 => 0x101f },
	'externalflashae1_0' => { 328 => 0x101b },
	'externalflashae2' => { 328 => 0x1020 },
	'externalflashae2_0' => { 328 => 0x101c },
	'externalflashbounce' => { 326 => 0x1204, 328 => 0x1026, 369 => 0x1a },
	'externalflashcompensation' => { 219 => 0x1b },
	'externalflashexposurecomp' => { 239 => 0x17, 369 => 0x19 },
	'externalflashfirmware' => { 217 => 0x6, 218 => 0x6, 219 => 0x6, 220 => 0x6, 221 => 0x6, 222 => 0x6 },
	'externalflashflags' => { 217 => 0x8, 218 => 0x8, 219 => 0x8, 220 => 0x8, 222 => 0x8 },
	'externalflashguidenumber' => { 326 => 0x1203, 369 => '24.1' },
	'externalflashgvalue' => { 328 => 0x1025 },
	'externalflashmode' => { 328 => 0x1028, 369 => 0x2 },
	'externalflashreadystate' => { 221 => '9.1' },
	'externalflashstatus' => { 221 => '8.2' },
	'externalflashzoom' => { 326 => 0x1205, 328 => 0x1027 },
	'externalflashzoomoverride' => { 221 => '8.1' },
	'externalmetadatalink' => { 521 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 341 => 0x311, 344 => 0x311, 345 => 0x311, 348 => 0x3408 },
	'extrainfoversion' => { 437 => 0x1a },
	'eyestartaf' => { 187 => 0x40 },
	'fac100per' => { 141 => 0xe94 },
	'fac170per' => { 141 => 0xe93 },
	'fac18per' => { 141 => 0xe92 },
	'face10position' => { 113 => 0x3f4, 114 => 0x1ec, 215 => 0x28, 366 => 0x12 },
	'face10size' => { 367 => 0x12 },
	'face11position' => { 215 => 0x2c, 366 => 0x14 },
	'face11size' => { 367 => 0x14 },
	'face12position' => { 215 => 0x30, 366 => 0x16 },
	'face12size' => { 367 => 0x16 },
	'face13position' => { 366 => 0x18 },
	'face13size' => { 367 => 0x18 },
	'face14position' => { 366 => 0x1a },
	'face14size' => { 367 => 0x1a },
	'face15position' => { 366 => 0x1c },
	'face15size' => { 367 => 0x1c },
	'face16position' => { 366 => 0x1e },
	'face16size' => { 367 => 0x1e },
	'face17position' => { 366 => 0x20 },
	'face17size' => { 367 => 0x20 },
	'face18position' => { 366 => 0x22 },
	'face18size' => { 367 => 0x22 },
	'face19position' => { 366 => 0x24 },
	'face19size' => { 367 => 0x24 },
	'face1position' => { 56 => 0x8, 113 => 0xd, 114 => 0x18, 215 => 0x4, 338 => 0x1, 366 => 0x0, 410 => 0xbc, 440 => 0x1, 441 => 0x0, 442 => 0x0, 443 => 0x5b },
	'face1size' => { 367 => 0x0 },
	'face20position' => { 366 => 0x26 },
	'face20size' => { 367 => 0x26 },
	'face21position' => { 366 => 0x28 },
	'face21size' => { 367 => 0x28 },
	'face22position' => { 366 => 0x2a },
	'face22size' => { 367 => 0x2a },
	'face23position' => { 366 => 0x2c },
	'face23size' => { 367 => 0x2c },
	'face24position' => { 366 => 0x2e },
	'face24size' => { 367 => 0x2e },
	'face25position' => { 366 => 0x30 },
	'face25size' => { 367 => 0x30 },
	'face26position' => { 366 => 0x32 },
	'face26size' => { 367 => 0x32 },
	'face27position' => { 366 => 0x34 },
	'face27size' => { 367 => 0x34 },
	'face28position' => { 366 => 0x36 },
	'face28size' => { 367 => 0x36 },
	'face29position' => { 366 => 0x38 },
	'face29size' => { 367 => 0x38 },
	'face2position' => { 56 => 0xa, 113 => 0x7c, 114 => 0x4c, 215 => 0x8, 338 => 0x5, 366 => 0x2, 410 => 0xc8, 440 => 0x6, 441 => 0x20, 442 => 0x25, 443 => 0x65 },
	'face2size' => { 367 => 0x2 },
	'face30position' => { 366 => 0x3a },
	'face30size' => { 367 => 0x3a },
	'face31position' => { 366 => 0x3c },
	'face31size' => { 367 => 0x3c },
	'face32position' => { 366 => 0x3e },
	'face32size' => { 367 => 0x3e },
	'face3position' => { 56 => 0xc, 113 => 0xeb, 114 => 0x80, 215 => 0xc, 338 => 0x9, 366 => 0x4, 410 => 0xd4, 440 => 0xb, 441 => 0x40, 442 => 0x4a, 443 => 0x6f },
	'face3size' => { 367 => 0x4 },
	'face4position' => { 56 => 0xe, 113 => 0x15a, 114 => 0xb4, 215 => 0x10, 338 => 0xd, 366 => 0x6, 410 => 0xe0, 440 => 0x10, 441 => 0x60, 442 => 0x6f, 443 => 0x79 },
	'face4size' => { 367 => 0x6 },
	'face5position' => { 56 => 0x10, 113 => 0x1c9, 114 => 0xe8, 215 => 0x14, 338 => 0x11, 366 => 0x8, 410 => 0xec, 440 => 0x15, 441 => 0x80, 442 => 0x94 },
	'face5size' => { 367 => 0x8 },
	'face6position' => { 56 => 0x12, 113 => 0x238, 114 => 0x11c, 215 => 0x18, 366 => 0xa, 410 => 0xf8, 440 => 0x1a, 441 => 0xa0, 442 => 0xb9 },
	'face6size' => { 367 => 0xa },
	'face7position' => { 56 => 0x14, 113 => 0x2a7, 114 => 0x150, 215 => 0x1c, 366 => 0xc, 410 => 0x104, 440 => 0x1f, 441 => 0xc0, 442 => 0xde },
	'face7size' => { 367 => 0xc },
	'face8position' => { 56 => 0x16, 113 => 0x316, 114 => 0x184, 215 => 0x20, 366 => 0xe, 410 => 0x110, 440 => 0x24, 441 => 0xe0, 442 => 0x103 },
	'face8size' => { 367 => 0xe },
	'face9position' => { 56 => 0x18, 113 => 0x385, 114 => 0x1b8, 215 => 0x24, 366 => 0x10 },
	'face9size' => { 367 => 0x10 },
	'facebalanceorigi' => { 501 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 501 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 501 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 501 => 'FaceBalanceWarmth' },
	'facedetect' => { 381 => 0x76, 420 => 0x100 },
	'facedetectarea' => { 327 => 0x1201 },
	'facedetectframecrop' => { 327 => 0x1207 },
	'facedetectframesize' => { 56 => 0x3, 113 => 0x1, 114 => 0x4, 215 => 0x1, 327 => 0x1203, 381 => 0x77, 410 => 0xb6 },
	'facedetection' => { 435 => 0x30, 451 => 0x19 },
	'faceelementpositions' => { 130 => 0x4203 },
	'faceelementselected' => { 130 => 0x4005 },
	'faceelementtypes' => { 130 => 0x4201 },
	'faceid' => { 503 => 'FaceID' },
	'faceinfounknown' => { 116 => 0x2089 },
	'facename' => { 420 => 0x123 },
	'faceorientation' => { 114 => 0x8 },
	'faceposition' => { 365 => 0x2, 421 => 0x4 },
	'facepositions' => { 130 => 0x4103 },
	'facerecognition' => { 420 => 0x120 },
	'facesdetected' => { 56 => 0x2, 57 => 0x2, 58 => 0x3, 113 => 0x0, 114 => 0x2, 116 => 0x211c, 130 => 0x4100, 215 => 0x3, 327 => 0x1200, 346 => 0x3f, 365 => 0x0, 410 => 0xb5, 421 => 0x0, 440 => 0x0, 443 => 0x3, 454 => 0x30 },
	'facesrecognized' => { 339 => 0x0 },
	'facewidth' => { 57 => 0x1 },
	'fade' => { 446 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 112 => 0x38 },
	'faithfuloutputshadowpoint' => { 112 => 0x39 },
	'faithfulrawcolortone' => { 112 => 0x31 },
	'faithfulrawcontrast' => { 112 => 0x33 },
	'faithfulrawhighlight' => { 112 => 0x79 },
	'faithfulrawhighlightpoint' => { 112 => 0x36 },
	'faithfulrawlinear' => { 112 => 0x34 },
	'faithfulrawsaturation' => { 112 => 0x32 },
	'faithfulrawshadow' => { 112 => 0x82 },
	'faithfulrawshadowpoint' => { 112 => 0x37 },
	'faithfulrawsharpness' => { 112 => 0x35 },
	'faithfulunsharpmaskfineness' => { 112 => 0xac },
	'faithfulunsharpmaskstrength' => { 112 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 112 => 0xae },
	'far' => { 492 => 'Far' },
	'fastresetlinetime' => { 141 => 0x1860 },
	'feedidentifier' => { 521 => 'FeedIdentifier' },
	'femicroadjustment' => { 87 => 0x111 },
	'ffid' => { 511 => 'ffid' },
	'field' => { 525 => 'field' },
	'fieldcount' => { 328 => 0x103f },
	'fieldofview' => { 406 => "FOV\x00" },
	'fifoenonepixeldelay' => { 141 => 0x1901 },
	'filecreatedate' => { 123 => 'FileCreateDate' },
	'filedatarate' => { 536 => 'fileDataRate' },
	'fileformat' => { 98 => 0x0, 135 => 0x14, 423 => [0x22,0x26], 446 => 0xb000 },
	'filegroupid' => { 123 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 347 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 123 => 'FileModifyDate' },
	'filename' => { 123 => 'FileName' },
	'filenameasdelivered' => { 333 => 'FileNameAsDelivered' },
	'filenumber' => { 59 => 0x1, 66 => 0x8, 100 => 0x1817, 117 => 'Canon-FileNumber', 216 => 0x4, 409 => 0x10 },
	'filenumbermemory' => { 184 => 0x1a },
	'filenumbersequence' => { 303 => '12.2', 308 => '3.1', 309 => '4.1', 310 => '4.1', 312 => '11.1', 313 => '4.3', 318 => '5.2', 319 => 0x48, 320 => 0x48, 321 => 0x48 },
	'filepermissions' => { 123 => 'FilePermissions' },
	'filesource' => { 122 => 0xa300, 130 => 0x8000, 513 => 'FileSource' },
	'fileuserid' => { 123 => 'FileUserID' },
	'fileversion' => { 135 => 0x16 },
	'fillflashautoreduction' => { 85 => 0xe, 86 => 0xe, 93 => 0xa },
	'filllight' => { 507 => 'FillLight', 509 => 'FillLight' },
	'fillorder' => { 122 => 0x10a },
	'filmgraineffect' => { 323 => 0x538 },
	'filmmode' => { 130 => 0x1401, 343 => 0x412, 346 => 0x42 },
	'filmtype' => { 262 => 0x2 },
	'filtereffect' => { 59 => 0xe, 254 => 0x37, 255 => 0x3f, 256 => 0x47, 346 => 0xa1 },
	'filtereffectauto' => { 73 => 0xa0 },
	'filtereffectfaithful' => { 72 => 0x70, 73 => 0x70 },
	'filtereffectlandscape' => { 72 => 0x40, 73 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 72 => 0x88, 73 => 0x88 },
	'filtereffectneutral' => { 72 => 0x58, 73 => 0x58 },
	'filtereffectportrait' => { 72 => 0x28, 73 => 0x28 },
	'filtereffectstandard' => { 72 => 0x10, 73 => 0x10 },
	'filtereffectuserdef1' => { 72 => 0xa0, 73 => 0xb8 },
	'filtereffectuserdef2' => { 72 => 0xb8, 73 => 0xd0 },
	'filtereffectuserdef3' => { 72 => 0xd0, 73 => 0xe8 },
	'finderdisplayduringexposure' => { 86 => 0x1 },
	'finesharpness' => { 381 => 0x70 },
	'finetuneoptcenterweighted' => { 303 => '7.2', 304 => '9.1', 306 => '9.1', 307 => '9.1', 311 => '8.1', 316 => '9.1', 317 => '9.1', 318 => '9.1', 319 => 0x23, 320 => 0x23, 321 => 0x23 },
	'finetuneopthighlightweighted' => { 306 => '46.1', 307 => '46.1', 316 => '46.1', 317 => '46.1', 319 => 0x27, 320 => 0x27, 321 => 0x27 },
	'finetuneoptmatrixmetering' => { 303 => '8.1', 304 => '8.2', 306 => '8.2', 307 => '8.2', 311 => '7.2', 312 => '6.1', 316 => '8.2', 317 => '8.2', 318 => '8.2', 319 => 0x21, 320 => 0x21, 321 => 0x21 },
	'finetuneoptspotmetering' => { 303 => '8.2', 304 => '9.2', 306 => '9.2', 307 => '9.2', 311 => '8.2', 312 => '6.2', 316 => '9.2', 317 => '9.2', 318 => '9.2', 319 => 0x25, 320 => 0x25, 321 => 0x25 },
	'finishexposure' => { 141 => 0xdbd },
	'finishfiletype' => { 141 => 0xdb8 },
	'finishlook' => { 141 => 0xdbc },
	'finishnoise' => { 141 => 0xdba },
	'finishresolution' => { 141 => 0xdb9 },
	'finishsharpening' => { 141 => 0xdbb },
	'firmware' => { 328 => 0x405, 423 => [0x8c,0x17,0x3b], 504 => 'Firmware' },
	'firmware2' => { 423 => 0x57 },
	'firmwaredate' => { 115 => 0x15, 116 => 0x2001, 407 => 0x4, 409 => 0x30 },
	'firmwareid' => { 191 => 0x0 },
	'firmwarename' => { 420 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 66 => 0x1e, 411 => 0x0 },
	'firmwarerevision2' => { 411 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 141 => [0x415,0xce5], 157 => 0x57, 159 => 'FirmwareVersion', 344 => 0x320, 346 => 0x2, 348 => 0x3109, 381 => 0x230, 406 => ['CNFV','FIRM'], 408 => 0x18, 409 => 0x2a, 413 => 0x2 },
	'firmwareversions' => { 390 => 0x301 },
	'firstphotodate' => { 495 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 333 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 134 => 0x16, 502 => 'FixtureIdentifier' },
	'flash' => { 117 => 'XMP-Flash', 122 => 0x9209, 155 => 0x22, 185 => 0x1f, 186 => 0x15, 409 => 0x5a, 513 => 'Flash' },
	'flashaction' => { 433 => 0x3e, 434 => 0x3e, 446 => 0x2017, 451 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 433 => 0x4c, 434 => 0x4c, 451 => 0x77 },
	'flashactionexternal' => { 451 => [0x78,0x7c] },
	'flashactivity' => { 36 => 0x1c },
	'flashbatterylevel' => { 46 => 0x249 },
	'flashbias' => { 346 => 0x24 },
	'flashbits' => { 36 => 0x1d },
	'flashburstpriority' => { 319 => 0x111, 320 => 0x111, 321 => 0x129 },
	'flashbuttonfunction' => { 87 => 0x70e },
	'flashchargelevel' => { 328 => 0x1010 },
	'flashcolorfilter' => { 219 => 0x10, 220 => 0x10, 222 => 0x10 },
	'flashcommandermode' => { 217 => '9.1', 218 => '9.1', 219 => '9.1', 220 => '9.1', 222 => '9.1' },
	'flashcompensation' => { 141 => 0x3f3, 217 => 0xa, 218 => 0xa, 219 => 0xa, 220 => 0x27, 221 => 0xa, 222 => 0xa, 504 => 'FlashCompensation' },
	'flashcontrol' => { 433 => 0x23, 434 => 0x1f, 435 => 0x21 },
	'flashcontrolbuilt-in' => { 312 => '16.1', 313 => '23.1', 315 => '23.1', 316 => '24.1' },
	'flashcontrolmode' => { 217 => '9.2', 218 => '9.2', 219 => '9.2', 220 => '9.2', 222 => '9.2', 228 => 0x214, 243 => 0x148, 244 => 0x1b8, 245 => 0x1a8, 246 => 0x1bc, 247 => 0x1bc, 323 => 0x404 },
	'flashcurtain' => { 346 => 0x48 },
	'flashdefault' => { 187 => 0x42 },
	'flashdevice' => { 328 => 0x1005 },
	'flashdistance' => { 116 => 0x2034 },
	'flashenergy' => { 122 => 0xa20b, 513 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 239 => 0x18 },
	'flashexposurecomp' => { 79 => 0xf, 130 => 0x1011, 162 => 'ExposureComp', 184 => 0x23, 189 => 0x104, 190 => 0x49c1, 239 => 0x12, 323 => 0x401, 328 => 0x1023, 381 => 0x4d, 413 => 0x100b, 423 => [0x3a,0x56], 446 => 0x104 },
	'flashexposurecomp2' => { 283 => 0x4d2 },
	'flashexposurecomp3' => { 219 => 0x1d },
	'flashexposurecomp4' => { 219 => 0x27 },
	'flashexposurecomparea' => { 304 => '38.4', 306 => '38.4', 307 => '38.4', 316 => '38.4', 317 => '38.4', 319 => 0x59, 320 => 0x59, 321 => 0x59 },
	'flashexposurecompset' => { 187 => 0x10, 354 => 0xe, 433 => 0x14, 434 => 0x12, 435 => 0x23, 451 => 0x1f },
	'flashexposurecompset2' => { 451 => [0x26,0x2c] },
	'flashexposureindicator' => { 187 => 0x54 },
	'flashexposureindicatorlast' => { 187 => 0x56 },
	'flashexposureindicatornext' => { 187 => 0x55 },
	'flashexposurelock' => { 59 => 0x19 },
	'flashfired' => { 143 => 0x5d, 162 => 'Fired', 184 => 0x14, 282 => '590.3', 513 => [\'Flash','FlashFired'] },
	'flashfiring' => { 87 => 0x306, 88 => 0x6, 89 => 0x7, 92 => 0x7 },
	'flashfirmwareversion' => { 324 => 0x1002 },
	'flashfocallength' => { 217 => 0xb, 218 => 0xc, 219 => 0xc, 220 => 0xc, 221 => 0xc, 222 => 0x26 },
	'flashfunction' => { 190 => 0x31, 513 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 217 => 0xe, 218 => 0xf, 219 => 0xf, 220 => 0xf, 221 => 0xf, 222 => 0xf, 228 => 0x21a, 243 => 0x14e, 245 => 0x1ae, 246 => 0x1c2, 247 => 0x1c2 },
	'flashgroupacompensation' => { 217 => 0x11, 218 => 0x12, 219 => 0x13, 220 => 0x28, 221 => 0x28, 222 => 0x28 },
	'flashgroupacontrolmode' => { 217 => 0xf, 218 => '16.1', 219 => '17.1', 220 => '17.1', 221 => '17.1', 222 => '17.1' },
	'flashgroupaoutput' => { 217 => 0x11, 218 => 0x12, 219 => 0x13, 220 => 0x28, 221 => 0x28, 222 => 0x28 },
	'flashgroupbcompensation' => { 217 => 0x12, 218 => 0x13, 219 => 0x14, 220 => 0x29, 221 => 0x29, 222 => 0x29 },
	'flashgroupbcontrolmode' => { 217 => 0x10, 218 => '17.1', 219 => '18.1', 220 => '18.1', 221 => '18.1', 222 => '18.1' },
	'flashgroupboutput' => { 217 => 0x12, 218 => 0x13, 219 => 0x14, 220 => 0x29, 221 => 0x29, 222 => 0x29 },
	'flashgroupccompensation' => { 218 => 0x14, 219 => 0x15, 220 => 0x2a, 221 => 0x2a, 222 => 0x2a },
	'flashgroupccontrolmode' => { 218 => '17.2', 219 => '18.2', 220 => '18.2', 221 => '18.2', 222 => '18.2' },
	'flashgroupcoutput' => { 218 => 0x14, 219 => 0x15, 220 => 0x2a, 221 => 0x2a, 222 => 0x2a },
	'flashguidenumber' => { 79 => 0xd, 97 => 0x0, 162 => 'GuideNumber' },
	'flashilluminationpattern' => { 222 => 0x25 },
	'flashintensity' => { 115 => [0x19,0x5], 323 => 0x405 },
	'flashlevel' => { 305 => 0x9, 446 => 0xb048 },
	'flashmake' => { 162 => 'Make' },
	'flashmanufacturer' => { 181 => 'FlashManufacturer' },
	'flashmastercompensation' => { 228 => 0x22e, 243 => 0x162, 245 => 0x1aa, 246 => 0x1be, 247 => 0x1be },
	'flashmastercontrolmode' => { 228 => 0x22c, 243 => 0x160 },
	'flashmasteroutput' => { 228 => 0x232, 243 => 0x166 },
	'flashmetering' => { 184 => 0x3f, 187 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 381 => 0x20a },
	'flashmode' => { 115 => 0x4, 141 => 0x3f2, 143 => 0x5c, 154 => 0x27, 162 => 'Mode', 184 => 0x2, 185 => 0x20, 186 => 0x16, 187 => 0xf, 239 => 0x87, 323 => 0x400, 328 => 0x1004, 381 => 0xc, 388 => 0x4, 412 => 0x20, 413 => 0x100a, 422 => 0x225, 433 => 0x13, 434 => 0x7f, 435 => 0x20, 451 => 0x10, 455 => 0x1138, 456 => 0x1138, 457 => 0x1114, 458 => 0x1190, 459 => 0x116c, 460 => 0x1024, 461 => 0x21c, 462 => 0x21c, 463 => 0x211, 513 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 247 => 0x80e },
	'flashmodebuttonplaybackmode' => { 247 => 0x818 },
	'flashmodel' => { 162 => 'Model', 181 => 'FlashModel', 324 => 0x1001 },
	'flashoptions' => { 362 => 0x2 },
	'flashoptions2' => { 362 => 0x10 },
	'flashoutput' => { 46 => 0x248, 79 => 0x21, 217 => 0xa, 218 => 0xa, 219 => 0xa, 220 => 0x27, 222 => 0x21, 228 => 0x21e, 243 => 0x152, 245 => 0x1b2, 246 => 0x1c6, 247 => 0x1c6 },
	'flashpixversion' => { 122 => 0xa000, 513 => 'FlashpixVersion' },
	'flashredeyemode' => { 513 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 228 => 0x228, 243 => 0x15c, 245 => 0x1bc, 323 => 0x403 },
	'flashreturn' => { 513 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 162 => 'SerialNumber', 324 => 0x1003 },
	'flashsetting' => { 239 => 0x8 },
	'flashshutterspeed' => { 303 => '20.2', 304 => '23.2', 306 => '23.2', 307 => '23.2', 312 => '15.2', 313 => '22.2', 314 => '7.2', 315 => '22.2', 316 => '23.2', 317 => '23.2', 318 => '23.1', 319 => 0x57, 320 => 0x57, 321 => 0x57 },
	'flashsource' => { 217 => 0x4, 218 => 0x4, 219 => 0x4, 220 => 0x4, 221 => 0x4, 222 => 0x4 },
	'flashstatus' => { 369 => 0x0, 451 => [0x82,0x86], 465 => 0x31, 466 => 0x39, 467 => 0x39 },
	'flashstatusbuilt-in' => { 435 => [0x87,0x287] },
	'flashstatusexternal' => { 435 => [0x88,0x288] },
	'flashsyncspeed' => { 303 => '20.1', 304 => '23.1', 306 => '23.1', 307 => '23.1', 312 => '15.1', 313 => '22.1', 315 => '22.1', 316 => '23.1', 317 => '23.1', 319 => 0x53, 320 => 0x53, 321 => 0x53 },
	'flashsyncspeedav' => { 85 => 0x3, 87 => 0x10f, 88 => 0x2, 89 => 0x3, 90 => 0x2, 91 => 0x2, 92 => 0x3, 93 => 0x6 },
	'flashthreshold' => { 97 => 0x1 },
	'flashtype' => { 162 => 'Type', 187 => 0x59, 239 => 0x9, 324 => 0x1000 },
	'flashwarning' => { 313 => '30.1', 314 => '7.1', 318 => '31.1', 346 => 0x62 },
	'flashwirelessoption' => { 228 => 0x234, 243 => 0x15a, 245 => 0x1c8 },
	'flexiblespotposition' => { 446 => 0x201d },
	'flickadvancedirection' => { 319 => 0x25f, 320 => 0x25f, 321 => 0x277 },
	'flickerreduce' => { 422 => 0x218 },
	'flickerreduction' => { 130 => 0x1446, 266 => 0x7 },
	'flickerreductionindicator' => { 261 => 0x532 },
	'flickerreductionshooting' => { 244 => 0x1b4, 245 => 0x1a4, 246 => 0x1b8, 247 => 0x1b8 },
	'flightpitchdegree' => { 119 => 'FlightPitchDegree' },
	'flightrolldegree' => { 119 => 'FlightRollDegree' },
	'flightxspeed' => { 119 => 'FlightXSpeed' },
	'flightyawdegree' => { 119 => 'FlightYawDegree' },
	'flightyspeed' => { 119 => 'FlightYSpeed' },
	'flightzspeed' => { 119 => 'FlightZSpeed' },
	'fliphorizontal' => { 296 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 79 => 0x15, 122 => 0x829d, 140 => 0xfd04, 143 => 0x1e, 145 => 0xfa23, 147 => 0xf103, 150 => 0x13, 152 => 0x3c, 154 => 0x1c, 155 => 0x18, 157 => 0xc, 166 => 'FNumber', 184 => 0xa, 185 => 0x36, 186 => 0x47, 187 => 0x9, 190 => 0x49c7, 237 => 0x38, 345 => 0x35a, 381 => 0x13, 420 => 0xa019, 423 => [0x31,0x49], 433 => 0x1, 434 => 0x1, 451 => [0x20,0x22,0x26], 513 => 'FNumber' },
	'focaldistance' => { 493 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 61 => 0x1, 116 => 0x1d, 122 => 0x920a, 150 => 0x1d, 166 => 'FocalLength', 184 => 0x12, 232 => 0xa, 233 => 0xb, 237 => [0xc,0x3c], 340 => 0x1, 381 => 0x1d, 390 => 0x403, 413 => 0x1500, 432 => 0xe, 459 => 0x1278, 460 => 0x1134, 461 => 0x32c, 462 => 0x32c, 463 => 0x30a, 513 => 'FocalLength' },
	'focallength2' => { 451 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 122 => 0xa405, 420 => 0xa01a, 513 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 432 => 0x10 },
	'focalplaneafpointarea' => { 464 => 0x2 },
	'focalplaneafpointlocation1' => { 464 => 0x6 },
	'focalplaneafpointlocation10' => { 464 => 0x2a },
	'focalplaneafpointlocation11' => { 464 => 0x2e },
	'focalplaneafpointlocation12' => { 464 => 0x32 },
	'focalplaneafpointlocation13' => { 464 => 0x36 },
	'focalplaneafpointlocation14' => { 464 => 0x3a },
	'focalplaneafpointlocation15' => { 464 => 0x3e },
	'focalplaneafpointlocation2' => { 464 => 0xa },
	'focalplaneafpointlocation3' => { 464 => 0xe },
	'focalplaneafpointlocation4' => { 464 => 0x12 },
	'focalplaneafpointlocation5' => { 464 => 0x16 },
	'focalplaneafpointlocation6' => { 464 => 0x1a },
	'focalplaneafpointlocation7' => { 464 => 0x1e },
	'focalplaneafpointlocation8' => { 464 => 0x22 },
	'focalplaneafpointlocation9' => { 464 => 0x26 },
	'focalplaneafpointsused' => { 464 => 0x1 },
	'focalplanediagonal' => { 324 => 0x103, 328 => 0x205 },
	'focalplaneresolutionunit' => { 122 => 0xa210, 513 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 122 => 0xa20e, 513 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 61 => 0x2 },
	'focalplanexunknown' => { 61 => 0x2 },
	'focalplaneyresolution' => { 122 => 0xa20f, 513 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 61 => 0x3 },
	'focalplaneyunknown' => { 61 => 0x3 },
	'focalpointx' => { 493 => 'FocalPointX' },
	'focalpointy' => { 493 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 61 => 0x0 },
	'focalunits' => { 36 => 0x19 },
	'focus' => { 285 => 0x8 },
	'focusarea' => { 184 => 0x31 },
	'focusareaselection' => { 314 => '15.2' },
	'focusbracket' => { 346 => 0xbd },
	'focusbracketstepsize' => { 323 => 0x308 },
	'focuscontinuous' => { 36 => 0x20 },
	'focusdisplayaiservoandmf' => { 87 => 0x515 },
	'focusdistance' => { 166 => 'FocusDistance', 184 => 0x13, 190 => 0x49bb, 232 => 0x9, 233 => 0xa, 237 => [0xb,0x4e], 326 => 0x305, 340 => 0x0, 344 => 0x304, 345 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 59 => 0x15, 79 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 237 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 59 => 0x14, 79 => 0x13 },
	'focusholdbutton' => { 187 => 0x44 },
	'focusinfoversion' => { 326 => 0x0 },
	'focusingscreen' => { 86 => 0x0, 87 => 0x80b, 92 => 0x0 },
	'focuslocation' => { 446 => 0x2027 },
	'focuslocation2' => { 446 => 0x204a },
	'focuslocked' => { 183 => 0x14 },
	'focusmode' => { 36 => 0x7, 115 => 0x3, 116 => [0x3003,0xd], 130 => 0x1021, 141 => 0x3f5, 143 => 0x38, 159 => 'FocusMode', 184 => 0x30, 186 => 0xe, 187 => 0xc, 239 => 0x7, 323 => 0x301, 328 => 0x100b, 346 => 0x7, 381 => 0xd, 388 => 0x3, 413 => 0x1006, 426 => [0xb,0x5], 432 => [0x15,0x1d], 433 => 0x4d, 434 => 0x4d, 446 => [0xb042,0xb04e,0x201b], 451 => 0x13, 472 => 0x16 },
	'focusmode2' => { 129 => '0.1', 362 => '3.1', 451 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 305 => '10.1', 430 => 0x14, 431 => 0x15, 433 => 0x10, 434 => 0xf, 435 => 0x6 },
	'focusmodeswitch' => { 187 => 0x58, 433 => 0x2e },
	'focuspeakingdisplay' => { 319 => 0x235, 320 => 0x235, 321 => 0x24d },
	'focuspeakinghighlightcolor' => { 319 => 0x4b, 320 => 0x4b, 321 => 0x4b },
	'focuspeakinglevel' => { 319 => 0x49, 320 => 0x49, 321 => 0x49 },
	'focuspixel' => { 130 => 0x1023 },
	'focuspointlock' => { 319 => 0x1d3, 320 => 0x1d3, 321 => 0x1eb },
	'focuspointpersistence' => { 319 => 0x105, 320 => 0x105, 321 => 0x11b },
	'focuspointwrap' => { 303 => '2.2', 304 => '2.2', 306 => '2.1', 307 => '2.1', 311 => '1.1', 312 => '2.2', 313 => '1.1', 316 => '2.2', 317 => '2.1', 318 => '2.5', 319 => 0x16, 320 => 0x16, 321 => 0x16 },
	'focusposition' => { 1 => 0x2f, 232 => 0x8, 233 => 0x8, 381 => 0x10, 444 => 0x9bb },
	'focusposition2' => { 451 => [0x29,0x2b,0x2f], 472 => 0x2d, 475 => 0x20 },
	'focuspositionhorizontal' => { 196 => 0x2f, 197 => 0x43 },
	'focuspositionvertical' => { 196 => 0x31, 197 => 0x45 },
	'focusprocess' => { 323 => 0x302 },
	'focusrange' => { 36 => 0x12, 328 => 0x100a },
	'focusrangeindex' => { 372 => '3.1' },
	'focusresult' => { 197 => 0x4a },
	'focusringrotation' => { 87 => 0x713 },
	'focussetting' => { 423 => 0x6 },
	'focusshiftautoreset' => { 246 => 0x6da, 247 => 0x748 },
	'focusshiftexposurelock' => { 228 => 0x1b4, 243 => 0xe8, 244 => 0x100, 245 => 0xf4, 246 => 0x104, 247 => 0x104 },
	'focusshiftinterval' => { 228 => 0x1b0, 243 => 0xe4, 244 => 0xfc, 245 => 0xf0, 246 => 0x100, 247 => 0x100 },
	'focusshiftnumbershots' => { 228 => 0x1a8, 243 => 0xdc, 244 => 0xf4, 245 => 0xe8, 246 => 0xf8, 247 => 0xf8 },
	'focusshiftshooting' => { 264 => 0x20 },
	'focusshiftstepwidth' => { 228 => 0x1ac, 243 => 0xe0, 244 => 0xf8, 245 => 0xec, 246 => 0xfc, 247 => 0xfc },
	'focusstatus' => { 432 => 0x19, 433 => 0x53, 434 => 0x53 },
	'focusstepcount' => { 326 => 0x301, 328 => 0x100e },
	'focusstepinfinity' => { 326 => 0x303, 328 => 0x103b },
	'focusstepnear' => { 326 => 0x304, 328 => 0x103c },
	'focusstepsfrominfinity' => { 237 => 0x58 },
	'focustrackinglockon' => { 303 => ['1.5','4.1'], 304 => '1.4', 311 => '0.4', 312 => '3.1', 313 => '0.4', 316 => '1.4' },
	'focuswarning' => { 130 => 0x1301 },
	'foldername' => { 184 => 0x27 },
	'foldernumber' => { 433 => 0x9a, 435 => [0x402,0x114,0x316] },
	'fontcomposite' => { 541 => [\'Fonts','FontsComposite'] },
	'fontface' => { 541 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 541 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 541 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 541 => [\'Fonts','FontsFontName'] },
	'fonts' => { 541 => 'Fonts' },
	'fonttype' => { 541 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 541 => [\'Fonts','FontsVersionString'] },
	'for' => { 397 => 'For' },
	'forcewrite' => { 123 => 'ForceWrite' },
	'format' => { 406 => "\xa9fmt", 492 => 'Format', 510 => 'format', 534 => 'Format' },
	'forwardlock' => { 531 => 'forwardlock' },
	'forwardmatrix1' => { 122 => 0xc714 },
	'forwardmatrix2' => { 122 => 0xc715 },
	'forwardmatrix3' => { 122 => 0xcd34 },
	'fossilspecimen' => { 121 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 121 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 69 => [0x2,0x4] },
	'frameheight' => { 130 => 0x3822 },
	'framenum' => { 392 => 0xd7 },
	'framenumber' => { 130 => 0x8003, 190 => 0x3c, 381 => 0x29 },
	'framerate' => { 69 => [0x1,0x6], 122 => 0xc764, 130 => 0x3820 },
	'framereadouttime' => { 400 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 130 => 0x3821 },
	'framing' => { 525 => 'framing' },
	'freebytes' => { 100 => 0x1 },
	'freememorycardimages' => { 185 => [0x37,0x54], 186 => [0x2d,0x4a], 187 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 130 => 0x1010 },
	'fujimodel' => { 130 => 0x1447 },
	'fujimodel2' => { 130 => 0x1448 },
	'fullhdhighspeedrec' => { 130 => 0x3824 },
	'fullimagesize' => { 446 => 0xb02b },
	'fullpanoheightpixels' => { 495 => 'FullPanoHeightPixels', 496 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 495 => 'FullPanoWidthPixels', 496 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 413 => 0x100d },
	'fullsizeimage' => { 165 => 'data' },
	'fullsizeimagename' => { 165 => '1Name' },
	'fullsizeimagetype' => { 165 => '0Type' },
	'func1button' => { 306 => '14.1', 307 => '14.1', 317 => '14.1', 319 => 0x63, 320 => 0x63, 321 => 0x63 },
	'func1buttonplaybackmode' => { 319 => 0x1a5, 320 => 0x1a5, 321 => 0x1bd },
	'func1buttonplusdials' => { 306 => '42.1', 307 => '42.1', 317 => '42.1' },
	'func2button' => { 306 => '80.1', 307 => '80.1', 317 => '80.1', 319 => 0x73, 320 => 0x73, 321 => 0x73 },
	'func2buttonplaybackmode' => { 319 => 0x1a7, 320 => 0x1a7, 321 => 0x1bf },
	'func2buttonplusdials' => { 306 => '81.1' },
	'func3button' => { 306 => '83.1', 320 => 0x119, 321 => 0x131 },
	'func3buttonplaybackmode' => { 320 => 0x1a9, 321 => 0x1c1 },
	'func4button' => { 320 => 0x175, 321 => 0x18d },
	'func4buttonplaybackmode' => { 320 => 0x1af, 321 => 0x1c7 },
	'funcbutton' => { 303 => ['14.1','15.1'], 304 => '14.1', 312 => '28.1', 313 => '13.1', 316 => '14.1', 318 => '14.1' },
	'funcbuttonplusdials' => { 303 => ['14.2','15.2'], 304 => '14.2', 312 => '31.1', 316 => '42.1' },
	'functionbutton' => { 310 => '13.1', 314 => '5.2' },
	'gainbase' => { 327 => 0x610 },
	'gaincontrol' => { 122 => 0xa407, 513 => 'GainControl' },
	'gainmapmax' => { 518 => 'GainMapMax' },
	'gainmapmin' => { 518 => 'GainMapMin' },
	'gamma' => { 122 => 0xa500, 141 => 0x8fe, 334 => 'gAMA', 351 => 0x11c, 514 => 'Gamma', 518 => 'Gamma' },
	'gammablackpoint' => { 108 => 0xc },
	'gammacolortone' => { 108 => 0x3 },
	'gammacompensatedvalue' => { 136 => 0x91 },
	'gammacontrast' => { 108 => 0x2 },
	'gammacurveoutputrange' => { 108 => 0xf },
	'gammahighlight' => { 108 => 0xa },
	'gammalinear' => { 106 => 0x20200 },
	'gammamidpoint' => { 108 => 0xe },
	'gammasaturation' => { 108 => 0x4 },
	'gammashadow' => { 108 => 0x9 },
	'gammasharpnessstrength' => { 108 => 0x8 },
	'gammaunsharpmaskfineness' => { 108 => 0x6 },
	'gammaunsharpmaskstrength' => { 108 => 0x5 },
	'gammaunsharpmaskthreshold' => { 108 => 0x7 },
	'gammawhitepoint' => { 108 => 0xd },
	'garminsettings' => { 406 => 'pmcc' },
	'garminsoftware' => { 406 => 'uuid' },
	'gdalmetadata' => { 122 => 0xa480 },
	'gdalnodata' => { 122 => 0xa481 },
	'geimagesize' => { 130 => 0x1304 },
	'gemake' => { 132 => 0x300 },
	'gemodel' => { 132 => 0x207 },
	'genre' => { 398 => ['gnre',"\xa9gen"], 400 => 'genre', 406 => ['gnre',"\xa9gen"], 521 => 'Genre', 526 => 'genre', 536 => 'genre' },
	'genrecvid' => { 521 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 521 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 521 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 521 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 398 => 'geID' },
	'geography' => { 527 => 'geography' },
	'geologicalcontext' => { 121 => 'GeologicalContext' },
	'geologicalcontextbed' => { 121 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 121 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 121 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 121 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 121 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 123 => 'Geosync' },
	'geotag' => { 123 => 'Geotag' },
	'geotiffasciiparams' => { 122 => 0x87b1 },
	'geotiffdirectory' => { 122 => 0x87af },
	'geotiffdoubleparams' => { 122 => 0x87b0 },
	'geotime' => { 123 => 'Geotime' },
	'giftftppriority' => { 497 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 119 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 119 => 'GimbalReverse' },
	'gimbalrolldegree' => { 119 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 119 => 'GimbalYawDegree' },
	'globalaltitude' => { 395 => 0x419 },
	'globalangle' => { 395 => 0x40d },
	'good' => { 536 => 'good' },
	'googlehostheader' => { 398 => 'gshh' },
	'googlepingmessage' => { 398 => 'gspm' },
	'googlepingurl' => { 398 => 'gspu' },
	'googleplusuploadcode' => { 122 => 0x9009 },
	'googlesourcedata' => { 398 => 'gssd' },
	'googlestarttime' => { 398 => 'gsst' },
	'googletrackduration' => { 398 => 'gstd' },
	'goprotype' => { 406 => 'GoPr' },
	'gpsaltitude' => { 133 => 0x6, 163 => 'Altitude', 513 => 'GPSAltitude' },
	'gpsaltituderef' => { 133 => 0x5, 513 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 133 => 0x1c, 513 => 'GPSAreaInformation' },
	'gpscoordinates' => { 398 => "\xa9xyz", 400 => 'location.ISO6709', 406 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 133 => 0x1d },
	'gpsdatetime' => { 163 => 'DateTime', 513 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 133 => 0x18, 163 => 'Bearing', 513 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 133 => 0x17, 513 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 133 => 0x1a, 163 => 'Distance', 513 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 133 => 0x19, 513 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 133 => 0x14, 513 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 133 => 0x13 },
	'gpsdestlongitude' => { 133 => 0x16, 513 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 133 => 0x15 },
	'gpsdifferential' => { 133 => 0x1e, 163 => 'Differential', 513 => 'GPSDifferential' },
	'gpsdop' => { 133 => 0xb, 513 => 'GPSDOP' },
	'gpshpositioningerror' => { 133 => 0x1f, 513 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 133 => 0x11, 513 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 133 => 0x10, 513 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 117 => 'GPS-GPSLatitude', 119 => 'GpsLatitude', 133 => 0x2, 163 => 'Latitude', 513 => 'GPSLatitude' },
	'gpslatituderef' => { 133 => 0x1 },
	'gpslongitude' => { 117 => 'GPS-GPSLongitude', 119 => 'GpsLongitude', 133 => 0x4, 163 => 'Longitude', 513 => 'GPSLongitude' },
	'gpslongituderef' => { 133 => 0x3 },
	'gpslongtitude' => { 119 => 'GpsLongtitude' },
	'gpsmapdatum' => { 133 => 0x12, 163 => 'Datum', 513 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 133 => 0xa, 163 => 'MeasureMode', 513 => 'GPSMeasureMode' },
	'gpsposition' => { 117 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 133 => 0x1b, 513 => 'GPSProcessingMethod' },
	'gpssatellites' => { 133 => 0x8, 163 => 'Satellites', 513 => 'GPSSatellites' },
	'gpsspeed' => { 133 => 0xd, 163 => 'Speed', 513 => 'GPSSpeed' },
	'gpsspeedref' => { 133 => 0xc, 513 => 'GPSSpeedRef' },
	'gpsstatus' => { 133 => 0x9, 513 => 'GPSStatus' },
	'gpsstring' => { 141 => 0x402 },
	'gpstimestamp' => { 133 => 0x7 },
	'gpstrack' => { 133 => 0xf, 163 => 'Heading', 513 => 'GPSTrack' },
	'gpstrackref' => { 133 => 0xe, 513 => 'GPSTrackRef' },
	'gpsversionid' => { 133 => 0x0, 513 => 'GPSVersionID' },
	'gradation' => { 323 => 0x50f },
	'gradientbasedcorractive' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 507 => 'GradientBasedCorrections', 509 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 509 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 507 => 'GrainAmount', 509 => 'GrainAmount' },
	'graineffectroughness' => { 130 => 0x1047 },
	'graineffectsize' => { 130 => 0x104c },
	'grainfrequency' => { 507 => 'GrainFrequency', 509 => 'GrainFrequency' },
	'grainseed' => { 507 => 'GrainSeed', 509 => 'GrainSeed' },
	'grainsize' => { 507 => 'GrainSize', 509 => 'GrainSize' },
	'graymixeraqua' => { 507 => 'GrayMixerAqua', 509 => 'GrayMixerAqua' },
	'graymixerblue' => { 507 => 'GrayMixerBlue', 509 => 'GrayMixerBlue' },
	'graymixergreen' => { 507 => 'GrayMixerGreen', 509 => 'GrayMixerGreen' },
	'graymixermagenta' => { 507 => 'GrayMixerMagenta', 509 => 'GrayMixerMagenta' },
	'graymixerorange' => { 507 => 'GrayMixerOrange', 509 => 'GrayMixerOrange' },
	'graymixerpurple' => { 507 => 'GrayMixerPurple', 509 => 'GrayMixerPurple' },
	'graymixerred' => { 507 => 'GrayMixerRed', 509 => 'GrayMixerRed' },
	'graymixeryellow' => { 507 => 'GrayMixerYellow', 509 => 'GrayMixerYellow' },
	'graypoint' => { 483 => 0x8021 },
	'grayresponseunit' => { 122 => 0x122 },
	'greencurvelimits' => { 111 => 0x1c4 },
	'greencurvepoints' => { 110 => 0x53, 111 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 106 => 0x20913 },
	'greenhue' => { 507 => 'GreenHue', 509 => 'GreenHue' },
	'greensaturation' => { 507 => 'GreenSaturation', 509 => 'GreenSaturation' },
	'griddisplay' => { 303 => '13.3', 304 => '4.3', 306 => '4.2', 307 => '4.2', 308 => '2.2', 312 => '10.5', 313 => '3.4', 314 => '6.1', 316 => '4.4', 317 => '4.2', 318 => '4.2' },
	'gripbatteryadload' => { 360 => 0x5 },
	'gripbatteryadnoload' => { 360 => 0x4 },
	'gripbatterystate' => { 360 => '1.2' },
	'group' => { 507 => 'Group', 509 => 'Group' },
	'groupareaafillumination' => { 304 => '46.4', 307 => '47.4', 316 => '47.4' },
	'grouping' => { 398 => ['grup',"\xa9grp"], 406 => "\xa9grp" },
	'guid' => { 398 => 'GUID' },
	'h2resetblackpixels' => { 141 => 0x18a6 },
	'h3resetblackcolumns' => { 141 => 0x18ce },
	'h3resetblackpixels' => { 141 => 0x18b0 },
	'halftonehints' => { 122 => 0x141 },
	'hardlink' => { 123 => 'HardLink' },
	'hasalternative' => { 526 => 'hasAlternative' },
	'hascorrection' => { 526 => 'hasCorrection' },
	'hascorrectiona-lang' => { 526 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 526 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 526 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 507 => 'HasCrop', 509 => 'HasCrop' },
	'hasextendedxmp' => { 538 => 'HasExtendedXMP' },
	'hassettings' => { 507 => 'HasSettings', 509 => 'HasSettings' },
	'hastranslation' => { 526 => 'hasTranslation' },
	'hasvisibleoverprint' => { 541 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 541 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 243 => 0x35a },
	'hdmioutputresolution' => { 244 => 0x710, 245 => 0x610, 246 => 0x640, 247 => 0x6a8 },
	'hdmiviewassist' => { 320 => 0x20f, 321 => 0x227 },
	'hdr' => { 62 => 0x1, 224 => 0x4, 225 => 0x4, 244 => 0x23a, 247 => 0x23a, 346 => 0x9e, 381 => 0x85, 446 => 0x200a },
	'hdrcapacitymax' => { 518 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 518 => 'HDRCapacityMin' },
	'hdreditmode' => { 507 => 'HDREditMode', 509 => 'HDREditMode' },
	'hdreffect' => { 62 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 224 => 0x5, 225 => 0x5, 244 => 0x246, 247 => 0x246, 435 => 0x2e, 451 => 0x17 },
	'hdrlevel2' => { 224 => 0x7 },
	'hdrplusmakernote' => { 490 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 490 => 'hdrp_makernote' },
	'hdrsetting' => { 435 => 0x2d, 451 => 0x16, 455 => 0x1148, 456 => 0x1148, 457 => 0x1124, 458 => 0x11a0, 459 => 0x117c, 460 => 0x1034, 461 => 0x22c, 462 => 0x22c, 463 => 0x21f },
	'hdrsmoothing' => { 224 => 0x6 },
	'hdvideo' => { 398 => 'hdvd' },
	'headline' => { 134 => 0x69, 521 => 'Headline', 524 => 'Headline' },
	'hierarchicalkeywords' => { 174 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 174 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 174 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 174 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 174 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 499 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 121 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 244 => 0x48, 246 => 0x48, 247 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 244 => 0x27c, 246 => 0x27c, 247 => 0x27c },
	'highisomultiplierblue' => { 351 => 0x1a },
	'highisomultipliergreen' => { 351 => 0x19 },
	'highisomultiplierred' => { 351 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 64 => 0x5, 87 => 0x202, 239 => 0xb1, 381 => 0x71, 433 => 0x2c, 434 => 0x26, 435 => 0x26, 446 => 0x2009, 451 => 0x12, 478 => 0x42 },
	'highisonoisereduction2' => { 446 => 0xb050 },
	'highlight' => { 423 => 0xf },
	'highlight2012' => { 507 => 'Highlight2012', 509 => 'Highlight2012' },
	'highlightadj' => { 106 => 0x2030c },
	'highlightcolordistortreduct' => { 483 => 0x8026 },
	'highlightlinearitylimit' => { 420 => 0xa025 },
	'highlightprotection' => { 295 => 0x6 },
	'highlightrecovery' => { 507 => 'HighlightRecovery', 509 => 'HighlightRecovery' },
	'highlights' => { 446 => 0x2033, 501 => 'Highlights' },
	'highlights2012' => { 507 => 'Highlights2012', 509 => 'Highlights2012' },
	'highlightsadj' => { 483 => 0x9019 },
	'highlightshadow' => { 346 => 0xad },
	'highlighttone' => { 130 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 64 => 0x3, 87 => 0x203 },
	'highlightwarning' => { 346 => 0x8002 },
	'highlowkeyadj' => { 381 => 0x6c },
	'highspeedsync' => { 187 => 0x5, 319 => 0x55, 320 => 0x55, 321 => 0x55, 433 => 0x2, 434 => 0x2 },
	'hintversion' => { 406 => 'hinv' },
	'histogramxml' => { 296 => 0x83a1a25 },
	'history' => { 524 => 'History', 537 => 'History' },
	'historyaction' => { 537 => [\'History','HistoryAction'] },
	'historychanged' => { 537 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 537 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 537 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 537 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 537 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 141 => 0xc88 },
	'holefilldeltathreshold' => { 141 => 0xc7e },
	'hometowncity' => { 116 => 0x3006, 381 => 0x23, 387 => 0x2 },
	'hometowncitycode' => { 388 => 0x1000 },
	'hometowndst' => { 381 => 0x25, 387 => '0.2' },
	'hostcomputer' => { 122 => 0x13c },
	'hostsoftwarerendering' => { 141 => 0xce7 },
	'hue' => { 192 => 0x3b, 255 => 0x3d, 256 => 0x45, 381 => 0x67 },
	'hueadj' => { 299 => 0x2f, 483 => 0x8019 },
	'hueadjust' => { 413 => 0x1016 },
	'hueadjustment' => { 185 => 0x4a, 186 => 0x40, 239 => 0x92, 254 => 0x36 },
	'hueadjustmentaqua' => { 507 => 'HueAdjustmentAqua', 509 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 507 => 'HueAdjustmentBlue', 509 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 507 => 'HueAdjustmentGreen', 509 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 507 => 'HueAdjustmentMagenta', 509 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 507 => 'HueAdjustmentOrange', 509 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 507 => 'HueAdjustmentPurple', 509 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 507 => 'HueAdjustmentRed', 509 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 507 => 'HueAdjustmentYellow', 509 => 'HueAdjustmentYellow' },
	'huesetting' => { 331 => 0x1011 },
	'humanobservation' => { 121 => 'HumanObservation' },
	'humanobservationday' => { 121 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 121 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 121 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 121 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 121 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 121 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 121 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 121 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 121 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 121 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 121 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 121 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 121 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 121 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 121 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 121 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 121 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 121 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 121 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 121 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 122 => 0x9401, 514 => 'Humidity' },
	'icc_profile' => { 123 => 'ICC_Profile' },
	'iccprofilename' => { 524 => 'ICCProfile' },
	'iconuri' => { 406 => 'icnu' },
	'idccreativestyle' => { 483 => 0x8000 },
	'idcpreviewlength' => { 483 => 0x202 },
	'idcpreviewstart' => { 483 => 0x201 },
	'identification' => { 121 => 'Identification' },
	'identificationid' => { 121 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 121 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 121 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 121 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 121 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 121 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 121 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 510 => 'identifier', 534 => 'Identifier' },
	'ifcameramodel' => { 141 => 0x9c8 },
	'illuminantdata1' => { 122 => 0xcd35 },
	'illuminantdata2' => { 122 => 0xcd36 },
	'illuminantdata3' => { 122 => 0xcd37 },
	'illumination' => { 314 => '0.5', 408 => 0x48 },
	'imageabsolutex' => { 141 => 0x3fe },
	'imageabsolutey' => { 141 => 0x3ff },
	'imageadjustment' => { 239 => 0x80, 285 => 0x5 },
	'imagealterationconstraints' => { 333 => 'ImageAlterationConstraints' },
	'imagearea' => { 229 => 0x2b, 263 => 0x2b, 271 => 0x10, 274 => 0x10 },
	'imageareaoffset' => { 381 => 0x38 },
	'imageauthentication' => { 239 => 0x20 },
	'imageboundary' => { 239 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 130 => 0x1438, 239 => 0xa5, 449 => 0x11b },
	'imagecreator' => { 333 => 'ImageCreator' },
	'imagecreatorid' => { 333 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 333 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 333 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 141 => 0x41f },
	'imagecropy' => { 141 => 0x420 },
	'imagedata' => { 494 => 'Data' },
	'imagedatasize' => { 239 => 0xa2 },
	'imagedescription' => { 122 => 0x10e, 532 => 'ImageDescription' },
	'imageduplicationconstraints' => { 333 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 296 => 0xfe443a45 },
	'imageeditcount' => { 381 => 0x41 },
	'imageediting' => { 381 => 0x32 },
	'imageeditingsoftware' => { 122 => 0xa43b },
	'imageeditor' => { 122 => 0xa438 },
	'imageeffects' => { 413 => 0x1010 },
	'imagefileconstraints' => { 333 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 333 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 333 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 130 => 0x1436 },
	'imageheight' => { 122 => 0x101, 191 => 0xc, 390 => 0x10d, 492 => 'ImageHeight', 532 => 'ImageLength' },
	'imagehistory' => { 122 => 0x9213, 512 => 'ImageHistory' },
	'imageidnumber' => { 341 => 0x340 },
	'imagemimetype' => { 494 => 'Mime' },
	'imagenumber' => { 122 => 0x9211, 159 => 'ImageNumber', 185 => 0xae, 186 => 0x5e, 390 => 0x113, 433 => 0x9b, 435 => [0x400,'276.1',0x314], 504 => 'ImageNumber' },
	'imagenumber2' => { 186 => 0x62 },
	'imageoptimization' => { 239 => 0xa9 },
	'imageorientation' => { 134 => 0x83 },
	'imageprocessing' => { 239 => 0x1a },
	'imageprocessingfiledatecreated' => { 141 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 141 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 327 => 0x0 },
	'imagequality' => { 159 => 'ImageQuality', 273 => '723.2', 274 => '732.2', 282 => '708.1', 346 => 0x1 },
	'imagequality2' => { 323 => 0x603 },
	'imagerank' => { 497 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 141 => 0x600 },
	'imagerboardversion' => { 141 => 0x439 },
	'imagercols' => { 141 => 0x17d4 },
	'imageref' => { 519 => 'ImageRef' },
	'imageregion' => { 521 => 'ImageRegion' },
	'imageregionboundary' => { 521 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 521 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 521 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 521 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 521 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 521 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 521 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 521 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 521 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 521 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 141 => 0x944 },
	'imageresolutionjpg' => { 141 => 0x945 },
	'imagereview' => { 305 => '0.4', 314 => '0.4' },
	'imagereviewmonitorofftime' => { 304 => '21.1', 306 => '21.1', 307 => '21.1', 311 => '20.1', 316 => '21.1', 317 => '21.1', 319 => 0x39, 320 => 0x39, 321 => 0x39 },
	'imagereviewtime' => { 303 => '25.1', 305 => '2.1', 308 => '19.1', 309 => '20.1', 310 => '20.1', 312 => '9.2', 313 => '20.1', 318 => '21.2' },
	'imagerfiledatecreated' => { 141 => 0x9c5 },
	'imagerfileproductionlevel' => { 141 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 141 => 0x9c7 },
	'imagerotated' => { 154 => 0x2a },
	'imagerpowerondelaymsec' => { 141 => 0x5fd },
	'imagerrows' => { 141 => 0x17de },
	'imagesegmentlines' => { 141 => 0x184d },
	'imagesegmentstartline' => { 141 => 0x184c },
	'imagesequenceinfo' => { 122 => 0xcd44 },
	'imagesize' => { 165 => 'ImageSize' },
	'imagesizeraw' => { 239 => 0x3e },
	'imagesizerestriction' => { 529 => 'imageSizeRestriction' },
	'imagesourcedata' => { 122 => 0x935c },
	'imagespace' => { 141 => 0x909 },
	'imagestabilization' => { 36 => 0x22, 116 => 0x3020, 130 => 0x1422, 159 => 'ImageStabilization', 185 => 0xbd, 186 => 0x71, 187 => 0x57, 188 => 0x0, 189 => [0x18,0x107,0x113], 190 => 0x49c2, 239 => 0xac, 323 => 0x604, 326 => 0x1600, 346 => 0x1a, 438 => 0x12, 439 => 0x11, 446 => 0xb026 },
	'imagestabilization2' => { 437 => 0xa },
	'imagestabilizationsetting' => { 190 => 0x14, 433 => 0x3d, 434 => 0x3d, 444 => 0x14 },
	'imagestats' => { 122 => 0xcd46 },
	'imagestyle' => { 433 => 0x2d, 434 => 0x27 },
	'imagesupplier' => { 333 => 'ImageSupplier' },
	'imagesupplierid' => { 333 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 333 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 333 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 124 => 0x1 },
	'imagetemperaturemin' => { 124 => 0x2 },
	'imagetone' => { 381 => 0x4f },
	'imagetype' => { 134 => 0x82, 333 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 66 => 0x28, 122 => 0xa420, 512 => 'ImageUniqueID', 513 => 'ImageUniqueID' },
	'imagewidth' => { 122 => 0x100, 191 => 0xe, 390 => 0x10c, 492 => 'ImageWidth', 532 => 'ImageWidth' },
	'inclinationangle' => { 483 => 0x900f },
	'inclinationcorrection' => { 483 => 0x900e },
	'incrementaltemperature' => { 507 => 'IncrementalTemperature', 509 => 'IncrementalTemperature' },
	'incrementaltint' => { 507 => 'IncrementalTint', 509 => 'IncrementalTint' },
	'industry' => { 526 => 'industry', 527 => 'industry' },
	'infobuttonwhenshooting' => { 87 => 0x409 },
	'information' => { 400 => 'information', 406 => "\xa9inf" },
	'infourl' => { 406 => 'infu' },
	'infraredilluminator' => { 407 => 0x28 },
	'ingredientexclusion' => { 528 => 'ingredientExclusion' },
	'ingredients' => { 537 => 'Ingredients' },
	'ingredientsalternatepaths' => { 537 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 537 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 537 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 537 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 537 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 537 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 537 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 537 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 537 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 537 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 537 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 537 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 537 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 537 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 537 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 537 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 537 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 537 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 537 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 537 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 537 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 537 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 537 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 87 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 495 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 495 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 182 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 495 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 495 => 'InitialViewHeadingDegrees', 496 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 495 => 'InitialViewPitchDegrees', 496 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 495 => 'InitialViewRollDegrees', 496 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 303 => '4.4' },
	'initialzoomsetting' => { 303 => '9.3', 312 => '27.3' },
	'inkset' => { 122 => 0x14c },
	'inputprofile' => { 141 => 0x1389 },
	'instanceid' => { 537 => 'InstanceID' },
	'instantplaybacksetup' => { 187 => 0x3e },
	'instantplaybacktime' => { 187 => 0x3d },
	'instructions' => { 524 => 'Instructions' },
	'instrument' => { 536 => 'instrument' },
	'integrationtime' => { 141 => 0x423 },
	'intellectualgenre' => { 520 => 'IntellectualGenre' },
	'intelligentauto' => { 446 => 0xb052, 474 => 0xd, 475 => 0xe, 476 => 0xd },
	'intelligentcontrast' => { 54 => 0x4 },
	'intelligentd-range' => { 346 => 0x79 },
	'intelligentexposure' => { 346 => 0x5d },
	'intelligentresolution' => { 346 => 0x70 },
	'interchangecolorspace' => { 136 => 0x40 },
	'intergraphmatrix' => { 122 => 0x8480 },
	'internalflash' => { 184 => 0x2b, 303 => '23.1', 305 => '8.1', 308 => '22.1', 310 => '23.1', 314 => '8.1', 318 => '24.1', 326 => 0x1208 },
	'internalflashae1' => { 328 => 0x1021 },
	'internalflashae1_0' => { 328 => 0x101d },
	'internalflashae2' => { 328 => 0x1022 },
	'internalflashae2_0' => { 328 => 0x101e },
	'internalflashmode' => { 369 => 0x1 },
	'internalflashstrength' => { 369 => 0x3 },
	'internalflashtable' => { 328 => 0x1024 },
	'internallensserialnumber' => { 420 => 0xa005 },
	'internalndfilter' => { 346 => 0x9d },
	'internalserialnumber' => { 66 => 0x96, 78 => 0x9, 130 => 0x10, 190 => 0x49dc, 322 => 0x18, 324 => 0x102, 343 => 0x500, 346 => 0x25, 361 => 0x4, 413 => 0x5, 465 => [0x7c,0xf0], 466 => 0x88, 467 => [0x88,0x8a], 468 => 0x38 },
	'interopindex' => { 122 => 0x1, 514 => 'InteroperabilityIndex' },
	'interopversion' => { 122 => 0x2 },
	'interval' => { 261 => 0x20 },
	'intervaldurationhours' => { 243 => 0xa0, 244 => 0xb8 },
	'intervaldurationminutes' => { 243 => 0xa4, 244 => 0xbc },
	'intervaldurationseconds' => { 243 => 0xa8, 244 => 0xc0 },
	'intervalexposuresmoothing' => { 228 => 0x184, 243 => 0xb8, 244 => 0xd0 },
	'intervalframe' => { 261 => 0x24 },
	'intervallength' => { 184 => 0x10 },
	'intervalmode' => { 184 => 0x26 },
	'intervalnumber' => { 184 => 0x11 },
	'intervalpriority' => { 228 => 0x186, 243 => 0xba, 244 => 0xd2 },
	'intervals' => { 228 => 0x17c, 243 => 0xb0, 244 => 0xc8, 245 => 0xbc, 246 => 0xcc, 247 => 0xcc },
	'intervalshooting' => { 229 => 0x24, 263 => 0x24, 264 => 0x28, 381 => 0x92 },
	'introtime' => { 536 => 'introTime' },
	'introtimescale' => { 536 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 536 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 141 => 0xdae },
	'ipfcameramodel' => { 141 => 0xe4d },
	'iptc' => { 123 => 'IPTC' },
	'iptc-naa' => { 122 => 0x83bb, 351 => 0x83bb },
	'iptcbitspersample' => { 136 => 0x56 },
	'iptcdigest' => { 395 => 0x425 },
	'iptcimageheight' => { 136 => 0x1e },
	'iptcimagerotation' => { 136 => 0x66 },
	'iptcimagewidth' => { 136 => 0x14 },
	'iptclastedited' => { 521 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 136 => 0xa },
	'iptcpixelheight' => { 136 => 0x32 },
	'iptcpixelwidth' => { 136 => 0x28 },
	'isalternativeof' => { 526 => 'isAlternativeOf' },
	'isbn' => { 526 => 'isbn' },
	'iscorrectionof' => { 526 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 112 => 0x3 },
	'ismergedhdr' => { 504 => 'IsMergedHDR' },
	'ismergedpanorama' => { 504 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 115 => 0x14, 116 => [0x3014,0x14], 122 => 0x8827, 140 => 0xfd06, 141 => 0x1784, 143 => 0x60, 145 => [0xfa2e,0xfa46], 146 => [0x27,0x28], 147 => 0xf105, 150 => 0x14, 152 => 0x4e, 154 => 0x1e, 155 => 0x1a, 157 => 0x34, 159 => 'ISO', 184 => 0x8, 190 => 0x49ba, 227 => 0x0, 239 => 0x2, 346 => 0xd1, 351 => 0x17, 381 => [0x8b,0x14], 388 => 0x14, 390 => 0x105, 420 => 0xa014, 423 => 0x86, 444 => 0x6f, 451 => [0x1f,0x21,0x25], 513 => 'ISOSpeedRatings' },
	'iso2' => { 227 => 0x6, 268 => 0x265, 269 => 0x25c, 270 => 0x265, 271 => 0x221, 272 => 0x25d, 273 => 0x256, 274 => 0x25d, 277 => 0x2b5, 280 => 0x265, 284 => 0x2b5 },
	'isoauto' => { 362 => '14.4' },
	'isoautoflashlimit' => { 244 => 0x156, 245 => 0x146, 246 => 0x15a, 247 => 0x15a },
	'isoautohilimit' => { 226 => 0x5, 244 => 0x154, 245 => 0x144, 246 => 0x158, 247 => 0x158, 266 => 0x5, 276 => 0x18eb },
	'isoautomax' => { 445 => 0x4 },
	'isoautomin' => { 445 => 0x2 },
	'isoautoparameters' => { 381 => 0x7a },
	'isoautoshuttertime' => { 226 => 0x4, 244 => 0x15e, 245 => 0x14e, 246 => 0x162, 247 => 0x162, 266 => 0x4, 276 => 0x18ea },
	'isobutton' => { 247 => 0x796 },
	'isocalibrationgain' => { 141 => 0x89f },
	'isodisplay' => { 306 => '4.1', 307 => '4.1', 308 => '2.3', 309 => '3.3', 310 => '3.3', 313 => '3.3', 316 => '4.3', 317 => '4.1', 318 => '4.3' },
	'isoexpansion' => { 87 => 0x103, 88 => 0x7, 89 => 0x8, 92 => 0x8, 227 => 0x4 },
	'isoexpansion2' => { 227 => 0xa },
	'isofloor' => { 362 => 0x6 },
	'isoselected' => { 345 => 0x359 },
	'isoselection' => { 239 => 0xf },
	'isosensitivitystep' => { 311 => '6.2', 313 => '6.2' },
	'isosetting' => { 143 => 0x5e, 155 => 0x14, 159 => 'ISOSetting', 184 => 0x24, 185 => 0x26, 186 => 0x1c, 187 => 0x13, 192 => 0x6, 239 => 0x13, 362 => '17.3', 412 => 0x27, 433 => 0x16, 434 => 0x14, 435 => 0x2, 444 => 0x6d, 445 => 0x0 },
	'isospeed' => { 122 => 0x8833, 514 => 'ISOSpeed' },
	'isospeedexpansion' => { 86 => 0x3 },
	'isospeedincrements' => { 87 => 0x102 },
	'isospeedlatitudeyyy' => { 122 => 0x8834, 514 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 122 => 0x8835, 514 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 87 => 0x103 },
	'isostepsize' => { 303 => '6.1', 304 => '7.2', 306 => '7.2', 307 => '7.2', 312 => '4.1', 316 => '7.2', 317 => '7.2', 319 => 0x15d, 320 => 0x15d, 321 => 0x175 },
	'isovalue' => { 328 => 0x1001 },
	'isrc' => { 398 => 'xid ' },
	'isrccode' => { 406 => "\xa9isr" },
	'issn' => { 526 => 'issn' },
	'issueidentifier' => { 526 => 'issueIdentifier' },
	'issuename' => { 526 => 'issueName' },
	'issueteaser' => { 526 => 'issueTeaser' },
	'issuetype' => { 526 => 'issueType' },
	'istranslationof' => { 526 => 'isTranslationOf' },
	'itemsubtype' => { 181 => 'ItemSubType' },
	'itunesu' => { 398 => 'itnu' },
	'jobid' => { 134 => 0xb8 },
	'jobname' => { 515 => 'JobName' },
	'jobref' => { 535 => 'JobRef' },
	'jobrefid' => { 535 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 535 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 535 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 515 => 'JobStatus' },
	'jpeg-heifswitch' => { 446 => 0x2039 },
	'jpeghandling' => { 507 => 'JPEGHandling', 509 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 346 => 0x43, 348 => 0x3034, 446 => 0xb047 },
	'jpegsize' => { 348 => 0x303a },
	'jpgcompression' => { 230 => 0x24, 239 => 0x44, 271 => '671.1' },
	'jpgfromraw' => { 100 => 0x2007, 117 => 'Exif-JpgFromRaw', 351 => 0x2e },
	'jpgfromrawlength' => { 122 => [0x117,0x202] },
	'jpgfromrawstart' => { 122 => [0x111,0x201] },
	'jpgrecordedpixels' => { 362 => '14.1' },
	'jurisdiction' => { 505 => 'jurisdiction' },
	'keepexposure' => { 319 => 0x237, 320 => 0x237, 321 => 0x24f },
	'kelvinwb_01' => { 370 => 0x5 },
	'kelvinwb_02' => { 370 => 0x9 },
	'kelvinwb_03' => { 370 => 0xd },
	'kelvinwb_04' => { 370 => 0x11 },
	'kelvinwb_05' => { 370 => 0x15 },
	'kelvinwb_06' => { 370 => 0x19 },
	'kelvinwb_07' => { 370 => 0x1d },
	'kelvinwb_08' => { 370 => 0x21 },
	'kelvinwb_09' => { 370 => 0x25 },
	'kelvinwb_10' => { 370 => 0x29 },
	'kelvinwb_11' => { 370 => 0x2d },
	'kelvinwb_12' => { 370 => 0x31 },
	'kelvinwb_13' => { 370 => 0x35 },
	'kelvinwb_14' => { 370 => 0x39 },
	'kelvinwb_15' => { 370 => 0x3d },
	'kelvinwb_16' => { 370 => 0x41 },
	'kelvinwb_daylight' => { 370 => 0x1 },
	'kerneldenominators' => { 141 => 0x933 },
	'key' => { 536 => 'key' },
	'keystonecompensation' => { 327 => 0x1900 },
	'keystonedirection' => { 327 => 0x1901 },
	'keystonevalue' => { 327 => 0x1906 },
	'keyword' => { 398 => 'keyw', 526 => 'keyword' },
	'keywordinfo' => { 174 => 'Keywords' },
	'keywords' => { 134 => 0x19, 160 => 'Keywords', 332 => 'Keywords', 397 => 'Keywords', 400 => 'keywords', 502 => 'keywords', 523 => 'Keywords', 534 => 'Keywords' },
	'killdate' => { 526 => 'killDate' },
	'killdatea-platform' => { 526 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 526 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 140 => 0xf908, 143 => 0xe, 145 => [0xfa1e,0xfa52], 151 => 0x70 },
	'kodakimagewidth' => { 140 => 0xf907, 143 => 0xc, 145 => [0xfa1d,0xfa51], 151 => 0x6c },
	'kodakinfotype' => { 140 => 0xfa00 },
	'kodaklook' => { 141 => 0xe4c },
	'kodaklookprofile' => { 141 => 0x138a },
	'kodakmaker' => { 151 => 0x8 },
	'kodakmodel' => { 143 => 0x0, 151 => 0x28 },
	'kodaktag' => { 141 => 0x3ea },
	'kodakversion' => { 141 => 0x0 },
	'label' => { 336 => 'Label', 534 => 'Label' },
	'labelname1' => { 519 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 519 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 346 => 0x6f },
	'landscapeoutputhighlightpoint' => { 112 => 0x26 },
	'landscapeoutputshadowpoint' => { 112 => 0x27 },
	'landscaperawcolortone' => { 112 => 0x1f },
	'landscaperawcontrast' => { 112 => 0x21 },
	'landscaperawhighlight' => { 112 => 0x77 },
	'landscaperawhighlightpoint' => { 112 => 0x24 },
	'landscaperawlinear' => { 112 => 0x22 },
	'landscaperawsaturation' => { 112 => 0x20 },
	'landscaperawshadow' => { 112 => 0x80 },
	'landscaperawshadowpoint' => { 112 => 0x25 },
	'landscaperawsharpness' => { 112 => 0x23 },
	'landscapeunsharpmaskfineness' => { 112 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 112 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 112 => 0xa2 },
	'language' => { 244 => 0x692, 245 => 0x592, 246 => 0x5c2, 247 => 0x5da, 510 => 'language' },
	'languageidentifier' => { 134 => 0x87 },
	'largestvalidinteriorrectheight' => { 495 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 495 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 495 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 495 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 184 => 0x1b },
	'lastkeywordiptc' => { 181 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 181 => 'LastKeywordXMP' },
	'lastphotodate' => { 495 => 'LastPhotoDate' },
	'lasturl' => { 537 => 'LastURL' },
	'lateralchromaticaberration' => { 446 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 504 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 121 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 121 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 121 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 121 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 121 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 119 => 'Latitude' },
	'lc1' => { 372 => 0x2 },
	'lc10' => { 372 => 0xb },
	'lc11' => { 372 => 0xc },
	'lc12' => { 372 => 0xd },
	'lc14' => { 372 => 0xf },
	'lc15' => { 372 => 0x10 },
	'lc3' => { 372 => 0x4 },
	'lc4' => { 372 => 0x5 },
	'lc5' => { 372 => 0x6 },
	'lc6' => { 372 => 0x7 },
	'lc7' => { 372 => 0x8 },
	'lc8' => { 372 => 0x9 },
	'lcddisplayatpoweron' => { 87 => 0x811, 91 => 0xa },
	'lcddisplayreturntoshoot' => { 92 => 0x12 },
	'lcdillumination' => { 303 => '17.5', 304 => '5.2', 306 => '5.1', 307 => '5.1', 312 => '10.3', 313 => '4.2', 316 => '5.2', 317 => '5.1', 318 => '5.4', 319 => 0x101, 320 => 0x101, 321 => 0x117 },
	'lcdilluminationduringbulb' => { 87 => 0x408 },
	'lcdmatrix' => { 141 => 0xe74 },
	'lcdmatrixchickfix' => { 141 => 0xe75 },
	'lcdmatrixmarvin' => { 141 => 0xe76 },
	'lcdpanels' => { 86 => 0x8 },
	'lcheditor' => { 296 => 0x8ae85e },
	'legacyiptcdigest' => { 524 => 'LegacyIPTCDigest' },
	'legalcode' => { 505 => 'legalcode' },
	'lens' => { 122 => 0xfdea, 239 => 0x84, 504 => 'Lens' },
	'lensafstopbutton' => { 85 => 0x11, 86 => 0x13, 87 => 0x506, 88 => 0x10, 89 => 0x12, 92 => 0x13, 93 => 0x9 },
	'lensaperturerange' => { 423 => [0x30,0x48] },
	'lensblur' => { 507 => 'LensBlur', 509 => 'LensBlur' },
	'lensbluractive' => { 507 => [\'LensBlur','LensBlurActive'], 509 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 507 => [\'LensBlur','LensBlurBlurAmount'], 509 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 507 => [\'LensBlur','LensBlurBokehAspect'], 509 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 507 => [\'LensBlur','LensBlurBokehRotation'], 509 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 507 => [\'LensBlur','LensBlurBokehShape'], 509 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 507 => [\'LensBlur','LensBlurBokehShapeDetail'], 509 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 507 => [\'LensBlur','LensBlurCatEyeAmount'], 509 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 507 => [\'LensBlur','LensBlurCatEyeScale'], 509 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 507 => [\'LensBlur','LensBlurFocalRange'], 509 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 507 => [\'LensBlur','LensBlurFocalRangeSource'], 509 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 507 => [\'LensBlur','LensBlurHighlightsBoost'], 509 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 507 => [\'LensBlur','LensBlurHighlightsThreshold'], 509 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 507 => [\'LensBlur','LensBlurSampledArea'], 509 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 507 => [\'LensBlur','LensBlurSampledRange'], 509 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 507 => [\'LensBlur','LensBlurSphericalAberration'], 509 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 507 => [\'LensBlur','LensBlurSubjectRange'], 509 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 507 => [\'LensBlur','LensBlurVersion'], 509 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 319 => 0xad, 320 => 0xad, 321 => 0xad },
	'lenscorrectionsettings' => { 512 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 504 => 'LensDistortInfo' },
	'lensdistortionparams' => { 328 => 0x206 },
	'lensdriveend' => { 237 => 0x56 },
	'lensdrivenoaf' => { 87 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 435 => 0x3f0, 482 => 0xd },
	'lensfirmware' => { 414 => 0x20, 420 => 0xa004 },
	'lensfirmwareversion' => { 324 => 0x204, 346 => 0x60, 435 => 0x3f3, 482 => 0x14 },
	'lensfocallength' => { 106 => 0xf0512, 372 => 0x9 },
	'lensfocalrange' => { 423 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 304 => '55.1', 306 => '52.1', 307 => '52.1', 316 => '52.1', 317 => '52.1' },
	'lensformat' => { 459 => 0x1891, 461 => 0x18bd, 462 => 0x18ed, 463 => 0x17f1, 465 => 0x106, 466 => 0x106, 477 => 0x603, 478 => 0x5d },
	'lensfstops' => { 231 => 0x7, 232 => 0xc, 233 => 0xd, 237 => 0xe, 239 => 0x8b, 372 => '0.3' },
	'lensfunc1button' => { 319 => 0x9f, 320 => 0x9f, 321 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 247 => 0x810 },
	'lensfunc2button' => { 319 => 0xa7, 320 => 0xa7, 321 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 247 => 0x812 },
	'lensid' => { 237 => 0x30, 504 => 'LensID' },
	'lensidnumber' => { 231 => 0x6, 232 => 0xb, 233 => 0xc, 237 => 0xd },
	'lensinfo' => { 122 => 0xa432, 378 => 0x2a, 504 => 'LensInfo', 514 => 'LensSpecification' },
	'lenskind' => { 372 => 0x1 },
	'lensmake' => { 122 => 0xa433, 166 => 'Make', 514 => 'LensMake' },
	'lensmanualdistortionamount' => { 507 => 'LensManualDistortionAmount', 509 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 181 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 423 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 66 => 0x95, 122 => 0xa434, 166 => 'Model', 181 => 'LensModel', 234 => 0x18a, 235 => 0x18b, 236 => 0x2ac, 324 => 0x203, 378 => 0xc, 390 => 0x412, 514 => 'LensModel' },
	'lensmodulationoptimizer' => { 130 => 0x1045 },
	'lensmount' => { 435 => 0x99, 459 => 0x1892, 461 => 0x18be, 462 => 0x18ee, 463 => 0x17f2, 465 => 0x105, 466 => 0x105, 477 => 0x604, 478 => 0x5e },
	'lensmount2' => { 482 => 0x8 },
	'lensmounttype' => { 237 => 0x35 },
	'lenspositionabsolute' => { 237 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 507 => 'LensProfileChromaticAberrationScale', 509 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 507 => 'LensProfileDigest', 509 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 507 => 'LensProfileDistortionScale', 509 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 507 => 'LensProfileEnable', 509 => 'LensProfileEnable' },
	'lensprofilefilename' => { 507 => 'LensProfileFilename', 509 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 507 => 'LensProfileIsEmbedded', 509 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 507 => 'LensProfileMatchKeyCameraModelName', 509 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 507 => 'LensProfileMatchKeyExifMake', 509 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 507 => 'LensProfileMatchKeyExifModel', 509 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 507 => 'LensProfileMatchKeyIsRaw', 509 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 507 => 'LensProfileMatchKeyLensID', 509 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 507 => 'LensProfileMatchKeyLensInfo', 509 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 507 => 'LensProfileMatchKeyLensName', 509 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 507 => 'LensProfileMatchKeySensorFormatFactor', 509 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 507 => 'LensProfileName', 509 => 'LensProfileName' },
	'lensprofilesetup' => { 507 => 'LensProfileSetup', 509 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 507 => 'LensProfileVignettingScale', 509 => 'LensProfileVignettingScale' },
	'lensproperties' => { 324 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 34 => 0x16b, 63 => 0x0, 122 => 0xa435, 166 => 'SerialNumber', 324 => 0x202, 344 => 0x321, 346 => 0x52, 406 => 'LENS', 414 => 0x30, 504 => 'LensSerialNumber', 514 => 'LensSerialNumber' },
	'lensshutterlock' => { 187 => 0x4a },
	'lensspec' => { 430 => 0x0, 431 => 0x0, 432 => 0x0, 446 => 0xb02a },
	'lensspecfeatures' => { 465 => [0x115,0x116], 466 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 328 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 36 => 0x16, 189 => 0x10c, 190 => 0x49bd, 239 => 0x83, 324 => 0x201, 337 => 0x16, 341 => 0x310, 343 => 0x303, 344 => 0x303, 346 => 0x51, 348 => 0x3405, 373 => 0x0, 374 => 0x0, 375 => 0x1, 376 => 0x1, 377 => 0x1, 379 => 0x0, 420 => 0xa003, 423 => 0x27, 446 => 0xb027, 459 => 0x1896, 461 => 0x18c2, 462 => 0x18f2, 463 => 0x17f6, 465 => 0x109, 466 => 0x109, 477 => 0x608, 478 => 0x62 },
	'lenstype2' => { 435 => 0x3f7, 459 => 0x1893, 461 => 0x18bf, 462 => 0x18ef, 463 => 0x17f3, 465 => 0x107, 466 => 0x107, 477 => 0x605, 478 => 0x60 },
	'lenstype3' => { 482 => 0x9 },
	'lenstypemake' => { 346 => 0xc4 },
	'lenstypemodel' => { 346 => [0xc5,0xe4] },
	'lenszoomposition' => { 474 => 0x19, 475 => 0x1e, 478 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 354 => 0x15 },
	'levelmeter' => { 406 => ['Lvlm','lvlm'] },
	'levelorientation' => { 380 => 0x0 },
	'license' => { 505 => 'license' },
	'licensee' => { 333 => 'Licensee' },
	'licenseeid' => { 333 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 333 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 333 => 'LicenseeImageNotes' },
	'licenseename' => { 333 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 333 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 333 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 333 => 'LicenseeTransactionID' },
	'licenseid' => { 333 => 'LicenseID' },
	'licensestartdate' => { 333 => 'LicenseStartDate' },
	'licensetransactiondate' => { 333 => 'LicenseTransactionDate' },
	'licensetype' => { 511 => 'licensetype' },
	'licensor' => { 333 => 'Licensor' },
	'licensorcity' => { 333 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 333 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 333 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 333 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 333 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 333 => 'LicensorImageID' },
	'licensorname' => { 333 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 333 => 'LicensorNotes' },
	'licensorpostalcode' => { 333 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 333 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 333 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 333 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 333 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 333 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 333 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 333 => 'LicensorTransactionID' },
	'licensorurl' => { 333 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 328 => 0x1009 },
	'lightingmode' => { 116 => 0x302a },
	'lightreading' => { 381 => 0x15 },
	'lightsource' => { 122 => 0x9208, 239 => 0x90, 331 => 0x1000, 513 => 'LightSource' },
	'lightsourcespecial' => { 422 => 0x21d },
	'lightswitch' => { 316 => '0.1', 318 => '0.1' },
	'lightvaluecenter' => { 328 => 0x103d },
	'lightvalueperiphery' => { 328 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 319 => 0x153, 320 => 0x153, 321 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 319 => 0x151, 320 => 0x151, 321 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 319 => 0x150, 320 => 0x150, 321 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 319 => 0x14f, 320 => 0x14f, 321 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 319 => 0x11, 320 => 0x11, 321 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 319 => 0x14, 320 => 0x14, 321 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 319 => 0x13, 320 => 0x13, 321 => 0x13 },
	'limitafareamodeselauto' => { 319 => 0x15, 320 => 0x15, 321 => 0x15 },
	'limitafareamodeselection' => { 304 => '51.1', 306 => '49.1', 307 => '49.1', 316 => '49.1', 317 => '49.1' },
	'limitreleasemodeselc120' => { 320 => '269.4', 321 => '293.4' },
	'limitreleasemodeselc30' => { 320 => '269.3', 321 => '293.3' },
	'limitreleasemodeselch' => { 320 => '269.2', 321 => '293.2' },
	'limitreleasemodeselcl' => { 320 => '269.1', 321 => '293.1' },
	'limitreleasemodeselself' => { 320 => '269.5', 321 => '293.5' },
	'limitselectableimagearea16to9' => { 319 => 0x47, 320 => 0x47, 321 => 0x47 },
	'limitselectableimagearea1to1' => { 319 => 0x46, 320 => 0x46, 321 => 0x46 },
	'limitselectableimageareadx' => { 319 => 0x45, 320 => 0x45, 321 => 0x45 },
	'linearitylimitblue' => { 351 => 0x10 },
	'linearitylimitgreen' => { 351 => 0xf },
	'linearitylimitred' => { 351 => 0xe },
	'linearityuppermargin' => { 43 => 0x32c, 44 => 0x282, 47 => [0x2ba,0x2d1,0x2d5], 49 => 0x1e5, 50 => [0x1fe,0x2de], 51 => [0x232,0x310], 52 => 0x31e },
	'linearizationtable' => { 122 => 0xc618 },
	'linearresponselimit' => { 122 => 0xc62e },
	'link' => { 526 => 'link' },
	'linkaetoafpoint' => { 362 => '14.2' },
	'linkedencodedrightsexpr' => { 521 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 521 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 521 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 521 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 141 => 0x904 },
	'lithostratigraphicterms' => { 121 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 400 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 400 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 400 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 308 => '32.1', 318 => '34.1' },
	'liveviewafareamode' => { 313 => '34.1' },
	'liveviewafmethod' => { 451 => 0x20 },
	'liveviewafmode' => { 313 => '34.2' },
	'liveviewafsetting' => { 435 => 0x36 },
	'liveviewbuttonoptions' => { 304 => '50.2', 306 => '48.2', 307 => '48.2', 316 => '48.2', 317 => '48.2' },
	'liveviewexposuresimulation' => { 87 => 0x810 },
	'liveviewfocusmode' => { 435 => [0x8b,0x28b] },
	'liveviewmetering' => { 435 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 304 => '21.2', 306 => '21.2', 307 => '21.2', 309 => '20.2', 310 => '20.2', 311 => '20.2', 313 => '20.2', 316 => '21.2', 317 => '21.2' },
	'liveviewshooting' => { 59 => 0x13 },
	'livingspecimen' => { 121 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 121 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 134 => 0x79 },
	'localizedcameramodel' => { 122 => 0xc615 },
	'locallocationname' => { 420 => 0x30 },
	'location' => { 238 => 0x9, 346 => 0x67, 500 => 'Location', 520 => 'Location', 525 => 'location', 526 => 'location' },
	'locationaccuracyhorizontal' => { 400 => 'location.accuracy.horizontal' },
	'locationareacode' => { 506 => 'lac' },
	'locationbody' => { 400 => 'location.body' },
	'locationcreated' => { 521 => 'LocationCreated' },
	'locationcreatedcity' => { 521 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 521 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 521 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 521 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 521 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 521 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 521 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 521 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 521 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 521 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 521 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 521 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 400 => 'location.date' },
	'locationinformation' => { 406 => 'loci' },
	'locationinfoversion' => { 238 => 0x0 },
	'locationname' => { 400 => 'location.name', 420 => 0x31 },
	'locationnote' => { 400 => 'location.note' },
	'locationrole' => { 400 => 'location.role' },
	'locationshown' => { 521 => 'LocationShown' },
	'locationshowncity' => { 521 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 521 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 521 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 521 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 521 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 521 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 521 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 521 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 521 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 521 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 521 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 521 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 87 => 0x709 },
	'logcomment' => { 536 => 'logComment' },
	'logscale' => { 141 => 0x902 },
	'longdescription' => { 398 => 'ldes' },
	'longexposurenoisereduction' => { 64 => 0x4, 87 => 0x201, 88 => 0x1, 89 => 0x2, 90 => 0x1, 91 => 0x1, 92 => 0x2, 93 => 0x1, 346 => 0x49, 433 => 0x2b, 434 => 0x25, 435 => 0x25, 446 => 0x2008, 451 => 0x11, 478 => 0x44 },
	'longexposurenoisereduction2' => { 59 => 0x8 },
	'longexposurenrused' => { 346 => 0xbe },
	'longitude' => { 119 => 'Longitude' },
	'look' => { 507 => 'Look', 509 => 'Look' },
	'lookamount' => { 507 => [\'Look','LookAmount'], 509 => [\'Look','LookAmount'] },
	'lookcluster' => { 507 => [\'Look','LookCluster'], 509 => [\'Look','LookCluster'] },
	'lookcopyright' => { 507 => [\'Look','LookCopyright'], 509 => [\'Look','LookCopyright'] },
	'lookgroup' => { 507 => [\'Look','LookGroup'], 509 => [\'Look','LookGroup'] },
	'lookname' => { 507 => 'LookName', 509 => 'LookName' },
	'lookparameters' => { 507 => [\'Look','LookParameters'], 509 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 507 => [\'Look','LookParametersCameraProfile'], 509 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 507 => [\'Look','LookParametersClarity2012'], 509 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 507 => [\'Look','LookParametersConvertToGrayscale'], 509 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 507 => [\'Look','LookParametersHighlights2012'], 509 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 507 => [\'Look','LookParametersLookTable'], 509 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 507 => [\'Look','LookParametersProcessVersion'], 509 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 507 => [\'Look','LookParametersShadows2012'], 509 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 507 => [\'Look','LookParametersToneCurvePV2012'], 509 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 507 => [\'Look','LookParametersToneCurvePV2012Blue'], 509 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 507 => [\'Look','LookParametersToneCurvePV2012Green'], 509 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 507 => [\'Look','LookParametersToneCurvePV2012Red'], 509 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 507 => [\'Look','LookParametersVersion'], 509 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 507 => [\'Look','LookSupportsAmount'], 509 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 507 => [\'Look','LookSupportsMonochrome'], 509 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 507 => [\'Look','LookSupportsOutputReferred'], 509 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 507 => [\'Look','LookUUID'], 509 => [\'Look','LookUUID'] },
	'loop' => { 536 => 'loop' },
	'loopstyle' => { 406 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 121 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 507 => 'LuminanceAdjustmentAqua', 509 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 507 => 'LuminanceAdjustmentBlue', 509 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 507 => 'LuminanceAdjustmentGreen', 509 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 507 => 'LuminanceAdjustmentMagenta', 509 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 507 => 'LuminanceAdjustmentOrange', 509 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 507 => 'LuminanceAdjustmentPurple', 509 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 507 => 'LuminanceAdjustmentRed', 509 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 507 => 'LuminanceAdjustmentYellow', 509 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 111 => 0x150 },
	'luminancecurvepoints' => { 111 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 106 => 0x20600, 112 => 0x5f, 423 => 0x1b },
	'luminancenoisereductioncontrast' => { 507 => 'LuminanceNoiseReductionContrast', 509 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 507 => 'LuminanceNoiseReductionDetail', 509 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 112 => 0x6d },
	'luminancesmoothing' => { 507 => 'LuminanceSmoothing', 509 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 87 => [0x40b,0x40c] },
	'lyrics' => { 398 => "\xa9lyr", 406 => "\xa9lyr", 536 => 'lyrics' },
	'lyricsuri' => { 406 => 'lrcu' },
	'm16cversion' => { 341 => 0x333 },
	'macatom' => { 508 => 'macAtom' },
	'macatomapplicationcode' => { 508 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 508 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 508 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 121 => 'MachineObservation' },
	'machineobservationday' => { 121 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 121 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 121 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 121 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 121 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 121 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 121 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 121 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 121 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 121 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 121 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 121 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 121 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 121 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 121 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 121 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 121 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 121 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 121 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 121 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 130 => 0x1020, 132 => 0x202, 154 => 0x2b, 328 => 0x202, 412 => 0x21, 422 => 0x202, 446 => 0xb040 },
	'macroled' => { 326 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 59 => 0x10 },
	'macromode' => { 36 => 0x1, 184 => 0xb, 323 => 0x300, 346 => 0x1c, 413 => 0x1009 },
	'magentahsl' => { 106 => 0x20917 },
	'magicfilter' => { 323 => 0x52c },
	'magnifiedview' => { 89 => 0x11, 91 => 0x9 },
	'mainboardversion' => { 141 => 0x438 },
	'maindialexposurecomp' => { 314 => '0.6' },
	'mainingredient' => { 528 => 'mainIngredient' },
	'majorversion' => { 498 => 'MajorVersion' },
	'make' => { 101 => 0x0, 118 => 0x1, 122 => 0x10f, 159 => 'Make', 336 => 'Make', 351 => 0x10f, 400 => 'make', 406 => ['@mak',"\xa9mak"], 525 => 'make', 532 => 'Make' },
	'makernote' => { 513 => 'MakerNote' },
	'makernoteapple' => { 120 => 'MakN', 122 => 0x927c },
	'makernotecanon' => { 84 => 'CMT3', 120 => 'MakN', 122 => 0x927c },
	'makernotecasio' => { 120 => 'MakN', 122 => 0x927c },
	'makernotecasio2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotedji' => { 120 => 'MakN', 122 => 0x927c },
	'makernotedjiinfo' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteflir' => { 120 => 'MakN', 122 => 0x927c },
	'makernotefujifilm' => { 120 => 'MakN', 122 => 0x927c },
	'makernotege' => { 120 => 'MakN', 122 => 0x927c },
	'makernotege2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehasselblad' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp6' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteisl' => { 120 => 'MakN', 122 => 0x927c },
	'makernotejvc' => { 120 => 'MakN', 122 => 0x927c },
	'makernotejvctext' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak10' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak11' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak12' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak1a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak1b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak6a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak6b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak7' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8c' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak9' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodakunknown' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekyocera' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica10' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica3' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica4' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica5' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica6' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica7' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica8' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica9' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotemotorola' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenintendo' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteoffset' => { 422 => 0xff },
	'makernoteolympus' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteolympus2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteolympus3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax6' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentaxunknown' => { 406 => 'PXMN' },
	'makernotephaseone' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericoh' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericoh2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericohpentax' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericohtext' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesafety' => { 122 => 0xc635 },
	'makernotesamsung1a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesamsung1b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesamsung2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyo' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyoc4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyopatch' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesigma' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesonyericsson' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesonysrf' => { 120 => 'MakN', 122 => 0x927c },
	'makernotetype' => { 413 => 0x1 },
	'makernoteunknown' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteunknownbinary' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteunknowntext' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 189 => 0x0, 239 => 0x1, 328 => 0x0, 346 => 0x8000, 417 => 0x0, 420 => 0x1, 423 => [0x1d,0x1f], 436 => 0x2000 },
	'makerurl' => { 406 => "\xa9mal" },
	'managedfrom' => { 537 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 537 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 537 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 537 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 537 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 537 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 537 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 537 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 537 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 537 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 537 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 537 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 537 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 537 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 537 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 537 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 537 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 537 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 537 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 537 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 537 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 537 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 537 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 537 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 537 => 'Manager' },
	'managervariant' => { 537 => 'ManagerVariant' },
	'manageto' => { 537 => 'ManageTo' },
	'manageui' => { 537 => 'ManageUI' },
	'manifest' => { 537 => 'Manifest' },
	'manifestlinkform' => { 537 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 537 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 537 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 537 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 537 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 537 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 537 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 537 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 537 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 537 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 537 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 537 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 537 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 537 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 537 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 537 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 537 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 537 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 537 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 537 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 537 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 537 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 537 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 537 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 537 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 537 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 537 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 537 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 323 => 0x900, 346 => 0x86 },
	'manometerreading' => { 323 => 0x901 },
	'manualafpointselectpattern' => { 87 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 326 => 0x1209 },
	'manualflashoutput' => { 36 => 0x29, 305 => '8.2', 308 => '22.2', 309 => '23.1', 310 => '23.2', 312 => '16.2', 313 => '23.2', 314 => '8.2', 315 => '23.2', 318 => '24.2', 413 => 0x100c },
	'manualflashstrength' => { 323 => 0x406 },
	'manualfocusdistance' => { 239 => 0x85, 328 => 0x100c, 422 => 0x223 },
	'manualfocuspointillumination' => { 319 => 0x17, 320 => 0x17, 321 => 0x17 },
	'manualfocusringinafmode' => { 319 => 0x1a, 320 => 0x1a, 321 => 0x1a },
	'manualtv' => { 86 => 0x5, 87 => 0x705 },
	'manufacturedate' => { 194 => 0x6705, 361 => 0x1 },
	'manufacturedate1' => { 415 => 0x4 },
	'manufacturedate2' => { 415 => 0x5 },
	'manufacturer' => { 492 => 'Manufacturer', 525 => 'manufacturer' },
	'mariahchromablursize' => { 141 => 0xf0d },
	'mariahmaphithreshold' => { 141 => 0xf0c },
	'mariahmaplothreshold' => { 141 => 0xf0b },
	'mariahsigmathreshold' => { 141 => 0xf0e },
	'mariahtexturethreshold' => { 141 => 0xf0a },
	'marked' => { 523 => 'Marked', 540 => 'Marked' },
	'markers' => { 536 => 'markers' },
	'markerscomment' => { 536 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 536 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 536 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 536 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 536 => [\'markers','markersCuePointType'] },
	'markersduration' => { 536 => [\'markers','markersDuration'] },
	'markerslocation' => { 536 => [\'markers','markersLocation'] },
	'markersname' => { 536 => [\'markers','markersName'] },
	'markersprobability' => { 536 => [\'markers','markersProbability'] },
	'markersspeaker' => { 536 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 536 => [\'markers','markersStartTime'] },
	'markerstarget' => { 536 => [\'markers','markersTarget'] },
	'markerstype' => { 536 => [\'markers','markersType'] },
	'maskedareas' => { 122 => 0xc68e },
	'maskgroupbasedcorractive' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 507 => 'MaskGroupBasedCorrections', 509 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 509 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 134 => 0xb9 },
	'mastergain' => { 262 => 0x50 },
	'materialsample' => { 121 => 'MaterialSample' },
	'materialsampleid' => { 121 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 304 => '50.1', 306 => '48.1', 307 => '48.1', 316 => '48.1', 317 => '48.1', 319 => 0x233, 320 => 0x233, 321 => 0x24b },
	'matrixselectk' => { 141 => 0x91b },
	'matrixselectthreshold' => { 141 => 0x91a },
	'matrixselectthreshold1' => { 141 => 0x91e },
	'matrixselectthreshold2' => { 141 => 0x91f },
	'matrixstructure' => { 405 => 0xa },
	'maxaperture' => { 36 => 0x1a, 141 => 0x3f9, 147 => 0x6103, 166 => 'MaxAperture', 184 => 0x17, 190 => 0x49c5, 237 => 0x36, 324 => 0x20a, 372 => '14.1' },
	'maxapertureatmaxfocal' => { 130 => 0x1407, 166 => 'MaxApertureAtMaxFocal', 231 => 0xb, 232 => 0x10, 233 => 0x11, 237 => 0x12, 324 => 0x206 },
	'maxapertureatminfocal' => { 130 => 0x1406, 231 => 0xa, 232 => 0xf, 233 => 0x10, 237 => 0x11, 324 => 0x205 },
	'maxaperturevalue' => { 122 => 0x9205, 390 => 0x414, 513 => 'MaxApertureValue' },
	'maxavailheight' => { 521 => 'MaxAvailHeight' },
	'maxavailwidth' => { 521 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 303 => 0xb, 304 => 0xc, 306 => '12.1', 307 => '12.1', 312 => 0xc, 313 => 0xb, 316 => '12.1', 317 => '12.1', 319 => 0x3d, 320 => 0x3d, 321 => 0x3d },
	'maxfaces' => { 327 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 36 => 0x17, 130 => 0x1405, 166 => 'MaxFocalLength', 231 => 0x9, 232 => 0xe, 233 => 0xf, 237 => 0x10, 324 => 0x208, 459 => 0x127c, 460 => 0x1138, 461 => 0x330, 462 => 0x330, 463 => 0x30e },
	'maximumdensityrange' => { 136 => 0x8c },
	'maxpagesize' => { 541 => 'MaxPageSize' },
	'maxpagesizeh' => { 541 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 541 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 541 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 141 => 0xc7d },
	'maxsamplevalue' => { 122 => 0x119 },
	'maxstorage' => { 531 => 'maxstorage' },
	'mb-d10batteries' => { 303 => '12.6' },
	'mb-d10batterytype' => { 312 => '13.3' },
	'mb-d11batterytype' => { 313 => '2.3' },
	'mb-d12batterytype' => { 316 => '3.2' },
	'mb-d80batteries' => { 314 => '6.5' },
	'mb-d80batterytype' => { 318 => '3.2' },
	'mcuversion' => { 231 => 0xc, 232 => 0x11, 233 => 0x12, 237 => 0x13 },
	'md5digest' => { 167 => 'zmd5' },
	'mditemfindercomment' => { 176 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 176 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 176 => 'MDItemFSLabel' },
	'mditemusertags' => { 176 => 'MDItemUserTags' },
	'meal' => { 528 => 'meal' },
	'measuredev' => { 28 => 0x9, 79 => 0x3, 100 => 0x1814, 159 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 79 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 190 => 0x690, 341 => 0x312, 344 => 0x312, 345 => 0x312, 348 => 0x3407 },
	'measuredrggb' => { 67 => 0x1 },
	'measuredrggbdata' => { 46 => 0x287 },
	'measurementaccuracy' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 121 => 'MeasurementOrFact' },
	'measurementremarks' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 492 => 'MeasureType' },
	'mechanicalshuttercount' => { 239 => 0x37 },
	'mediaclassprimaryid' => { 182 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 182 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 333 => 'MediaConstraints' },
	'mediacreatedate' => { 402 => 0x1 },
	'mediaeventiddate' => { 497 => 'MediaEventIdDate' },
	'mediamodifydate' => { 402 => 0x2 },
	'mediasummarycode' => { 333 => 'MediaSummaryCode' },
	'mediatype' => { 398 => 'stik' },
	'memoaudioquality' => { 87 => 0x812 },
	'memorycardconfiguration' => { 439 => 0x16 },
	'memorycardnumber' => { 216 => 0x2 },
	'menubuttondisplayposition' => { 85 => 0xb, 88 => 0xa, 89 => 0xb, 92 => 0xb },
	'menubuttonreturn' => { 93 => 0xb },
	'menumonitorofftime' => { 303 => '26.1', 304 => '22.1', 306 => '22.1', 307 => '22.1', 311 => '21.1', 312 => '8.2', 313 => '21.1', 316 => '22.1', 317 => '22.1', 318 => '22.1', 319 => 0x35, 320 => 0x35, 321 => 0x35 },
	'mergedimages' => { 346 => 0x76 },
	'metadataauthority' => { 521 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 521 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 521 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 534 => 'MetadataDate' },
	'metadataeditingsoftware' => { 122 => 0xa43c },
	'metadatalastedited' => { 521 => 'metadataLastEdited' },
	'metadatalasteditor' => { 521 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 521 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 521 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 536 => 'metadataModDate' },
	'metaversion' => { 454 => 0x34 },
	'meterinfo1row1' => { 447 => 0x0, 448 => 0x0 },
	'meterinfo1row2' => { 447 => 0x6c, 448 => 0x5a },
	'meterinfo1row3' => { 447 => 0xd8, 448 => 0xb4 },
	'meterinfo1row4' => { 447 => 0x144, 448 => 0x10e },
	'meterinfo1row5' => { 447 => 0x1b0, 448 => 0x168 },
	'meterinfo1row6' => { 447 => 0x21c, 448 => 0x1c2 },
	'meterinfo1row7' => { 447 => 0x288, 448 => 0x21c },
	'meterinfo2row1' => { 447 => 0x2f4, 448 => 0x276 },
	'meterinfo2row2' => { 447 => 0x378, 448 => 0x2e4 },
	'meterinfo2row3' => { 447 => 0x3fc, 448 => 0x352 },
	'meterinfo2row4' => { 447 => 0x480, 448 => 0x3c0 },
	'meterinfo2row5' => { 447 => 0x504, 448 => 0x42e },
	'meterinfo2row6' => { 447 => 0x588, 448 => 0x49c },
	'meterinfo2row7' => { 447 => 0x60c, 448 => 0x50a },
	'meterinfo2row8' => { 447 => 0x690, 448 => 0x578 },
	'meterinfo2row9' => { 447 => 0x714, 448 => 0x5e6 },
	'metering' => { 305 => '6.1' },
	'meteringmode' => { 36 => 0x11, 122 => 0x9207, 143 => 0x1c, 184 => 0x7, 185 => 0x25, 187 => 0x12, 323 => 0x202, 381 => 0x17, 423 => 0x9, 433 => 0x15, 434 => 0x13, 435 => 0x7, 451 => 0x3, 455 => 0x1174, 456 => 0x1178, 457 => 0x1154, 458 => 0x11d0, 459 => 0x11ac, 460 => 0x1064, 461 => 0x25c, 462 => 0x25c, 463 => 0x24b, 513 => 'MeteringMode' },
	'meteringmode2' => { 362 => '2.1', 446 => 0x202c },
	'meteringmode3' => { 362 => '16.1' },
	'meteringoffscaleindicator' => { 187 => 0x53 },
	'meteringtime' => { 303 => '22.2', 305 => '3.2', 308 => '17.1', 309 => '18.1', 312 => '7.3', 313 => '18.1', 314 => '3.2', 318 => '19.1' },
	'micro1version' => { 408 => 0x1f },
	'micro2version' => { 408 => 0x2d },
	'microphoneattenuator' => { 244 => 0x34e, 245 => 0x2d2, 246 => 0x2fa, 247 => 0x2fa },
	'microphonefrequencyresponse' => { 244 => 0x350, 245 => 0x2d4, 246 => 0x2fc, 247 => 0x2fc },
	'microphonejackpower' => { 244 => 0x376, 245 => 0x2fa, 246 => 0x322, 247 => 0x322 },
	'microphonesensitivity' => { 244 => 0x34c, 245 => 0x2d0, 246 => 0x2f8, 247 => 0x2f8 },
	'microvideo' => { 490 => 'MicroVideo' },
	'microvideooffset' => { 490 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 490 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 490 => 'MicroVideoVersion' },
	'midrangesharpness' => { 256 => 0x3b },
	'mieversion' => { 167 => '0Vers' },
	'mime' => { 492 => 'Mime' },
	'minaperture' => { 36 => 0x1b, 141 => 0x3f8, 166 => 'MinAperture', 372 => '0.2' },
	'minaperturevalue' => { 390 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 36 => 0x18, 130 => 0x1404, 166 => 'MinFocalLength', 231 => 0x8, 232 => 0xd, 233 => 0xe, 237 => 0xf, 324 => 0x207, 459 => 0x127a, 460 => 0x1136, 461 => 0x32e, 462 => 0x32e, 463 => 0x30c },
	'minfocusdistance' => { 372 => 0x3 },
	'minimumiso' => { 346 => 0xe8 },
	'minintegrationrows' => { 141 => 0x1874 },
	'minoltadate' => { 184 => 0x15 },
	'minoltaimagesize' => { 184 => 0x4, 185 => 0xc, 186 => 0x2, 189 => 0x103 },
	'minoltamodelid' => { 184 => 0x25 },
	'minoltaquality' => { 184 => 0x5, 185 => 0xd, 186 => 0x3, 189 => [0x102,0x103] },
	'minoltatime' => { 184 => 0x16 },
	'minormodelagedisclosure' => { 333 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 498 => 'MinorVersion' },
	'minsamplevalue' => { 122 => 0x118 },
	'mirrorlockup' => { 85 => 0xc, 86 => 0xc, 87 => 0x60f, 88 => 0xb, 89 => 0xc, 90 => 0x6, 91 => 0x6, 92 => 0xc, 93 => 0x3 },
	'mobilecountrycode' => { 506 => 'mcc' },
	'mobilenetworkcode' => { 506 => 'mnc' },
	'moddate' => { 336 => 'modify-date', 523 => 'ModDate' },
	'modedialposition' => { 439 => 0x14 },
	'model' => { 101 => 0x6, 122 => 0x110, 159 => 'Model', 336 => 'Model', 351 => 0x110, 381 => 0x23f, 400 => 'model', 406 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 423 => 0x84, 492 => 'Model', 525 => 'model', 532 => 'Model' },
	'modelage' => { 521 => 'ModelAge' },
	'modelid' => { 322 => 0x0 },
	'modelingflash' => { 303 => '21.4', 304 => '31.1', 306 => '31.1', 307 => '31.1', 312 => '26.4', 313 => '30.2', 314 => '7.4', 315 => '30.1', 316 => '31.1', 317 => '31.1', 318 => '31.3', 319 => 0x5d, 320 => 0x5d, 321 => 0x5d },
	'modelreleaseid' => { 333 => 'ModelReleaseID' },
	'modelreleasestatus' => { 333 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 469 => 0x52, 470 => 0x46, 471 => 0x53 },
	'modeltiepoint' => { 122 => 0x8482 },
	'modeltransform' => { 122 => 0x85d8 },
	'modelyear' => { 525 => 'modelYear' },
	'modificationdate' => { 526 => 'modificationDate' },
	'modifiedcolortemp' => { 68 => 0x9 },
	'modifieddigitalgain' => { 68 => 0xb },
	'modifiedparamflag' => { 60 => 0x1 },
	'modifiedpicturestyle' => { 68 => 0xa },
	'modifiedsaturation' => { 323 => 0x504 },
	'modifiedsensorbluelevel' => { 68 => 0x5 },
	'modifiedsensorredlevel' => { 68 => 0x4 },
	'modifiedsharpness' => { 68 => 0x2 },
	'modifiedsharpnessfreq' => { 68 => 0x3 },
	'modifiedtonecurve' => { 68 => 0x1 },
	'modifiedwhitebalance' => { 68 => 0x8 },
	'modifiedwhitebalanceblue' => { 68 => 0x7 },
	'modifiedwhitebalancered' => { 68 => 0x6 },
	'modifydate' => { 122 => 0x132, 160 => 'ModifyDate', 332 => 'ModDate', 334 => 'tIME', 397 => 'ModDate', 403 => 0x2, 534 => 'ModifyDate' },
	'moirefilter' => { 122 => 0xfe58, 507 => 'MoireFilter', 509 => 'MoireFilter' },
	'monitorbrightness' => { 244 => 0x69a, 245 => 0x59a, 246 => 0x5ca, 247 => 0x5e2 },
	'monitordisplayoff' => { 187 => 0x4c },
	'monitormatrix' => { 141 => 0x8fc },
	'monitorofftime' => { 303 => '18.2', 305 => '3.1', 314 => '3.1' },
	'monochromecolor' => { 323 => 0x53b },
	'monochromecontrast' => { 112 => 0x3c },
	'monochromefiltereffect' => { 106 => 0x20307, 112 => 0x3a, 346 => 0xac, 381 => 0x73 },
	'monochromegraineffect' => { 346 => 0xd2 },
	'monochromelinear' => { 112 => 0x3d },
	'monochromeoutputhighlightpoint' => { 112 => 0x41 },
	'monochromeoutputshadowpoint' => { 112 => 0x42 },
	'monochromeprofilesettings' => { 323 => 0x537 },
	'monochromerawhighlight' => { 112 => 0x7a },
	'monochromerawhighlightpoint' => { 112 => 0x3f },
	'monochromerawshadow' => { 112 => 0x83 },
	'monochromerawshadowpoint' => { 112 => 0x40 },
	'monochromesharpness' => { 112 => 0x3e },
	'monochrometoning' => { 381 => 0x74 },
	'monochrometoningeffect' => { 106 => 0x20306, 112 => 0x3b },
	'monochromeunsharpmaskfineness' => { 112 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 112 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 112 => 0xb4 },
	'monochromevignetting' => { 323 => 0x53a },
	'monthdaycreated' => { 143 => 0x12, 152 => 0xe },
	'mood' => { 182 => 'WM/Mood' },
	'moonphase' => { 407 => 0x12, 408 => 0x43, 409 => 0x4c },
	'morepermissions' => { 505 => 'morePermissions' },
	'motionphotovideo' => { 401 => 'mpvd' },
	'motionsensitivity' => { 407 => 0x29, 409 => 0x60 },
	'movementcount' => { 398 => "\xa9mvc" },
	'movementname' => { 398 => "\xa9mvn" },
	'movementnumber' => { 398 => "\xa9mvi" },
	'movieactived-lighting' => { 243 => 0x238, 244 => 0x334, 245 => 0x2b8, 246 => 0x2e0, 247 => 0x2e0 },
	'movieaelockbuttonassignment' => { 316 => '40.1' },
	'movieaf-onbutton' => { 319 => 0xcb, 320 => 0xcb, 321 => 0xcb },
	'movieafareamode' => { 244 => 0x342, 245 => 0x2c6, 246 => 0x2ee, 247 => 0x2ee, 319 => 0x203, 320 => 0x203, 321 => 0x21b },
	'movieafspeed' => { 319 => 0xdd, 320 => 0xdd, 321 => 0xdd },
	'movieafspeedapply' => { 319 => 0xdf, 320 => 0xdf, 321 => 0xdf },
	'movieaftrackingsensitivity' => { 319 => 0xe1, 320 => 0xe1, 321 => 0xe1 },
	'movieaperturelock' => { 319 => 0x259, 320 => 0x259, 321 => 0x271 },
	'movieautodistortioncontrol' => { 243 => 0x242 },
	'moviediffractioncompensation' => { 243 => 0x241 },
	'moviedxcropalert' => { 244 => 0x377, 245 => 0x2fb, 246 => 0x323, 247 => 0x323 },
	'movieelectronicvr' => { 244 => 0x348, 245 => 0x2cc, 246 => 0x2f4, 247 => 0x2f4 },
	'movieevfgrid' => { 319 => 0x21d, 320 => 0x21d, 321 => 0x235 },
	'movieflickerreduction' => { 244 => 0x33c, 245 => 0x2c0, 246 => 0x2e8, 247 => 0x2e8 },
	'moviefocusmode' => { 243 => 0x248, 244 => 0x340, 245 => 0x2c4, 246 => 0x2ec, 247 => 0x2ec },
	'moviefocuspointlock' => { 319 => 0x226, 320 => 0x226, 321 => 0x23e },
	'movieframerate' => { 243 => 0x1f8, 244 => 0x374, 245 => 0x2f4, 246 => 0x31c, 247 => 0x31c },
	'movieframesize' => { 243 => 0x1f6, 244 => 0x372, 245 => 0x2f2, 246 => 0x31a, 247 => 0x31a },
	'moviefunc1button' => { 306 => '41.1', 307 => '41.1', 317 => '41.1', 319 => 0xc3, 320 => 0xc3, 321 => 0xc3 },
	'moviefunc2button' => { 319 => 0xc7, 320 => 0xc7, 321 => 0xc7 },
	'moviefunc3button' => { 320 => 0x127, 321 => 0x13f },
	'moviefunctionbutton' => { 304 => '41.1', 316 => '41.1' },
	'moviefunctionbuttonplusdials' => { 304 => '52.1' },
	'moviehighisonoisereduction' => { 243 => 0x23c, 244 => 0x336, 245 => 0x2ba, 246 => 0x2e2, 247 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 319 => 0x215, 320 => 0x215, 321 => 0x22d },
	'moviehighreszoom' => { 244 => 0x380, 246 => 0x32c, 247 => 0x32c },
	'movieimagearea' => { 244 => 0x2da, 245 => 0x25c, 246 => 0x286, 247 => 0x286 },
	'movieisoautocontrolmanualmode' => { 244 => 0x2e8, 245 => 0x26a, 246 => 0x294, 247 => 0x294 },
	'movieisoautohilimit' => { 244 => 0x2e6, 245 => 0x268, 246 => 0x292, 247 => 0x292 },
	'movieisoautomanualmode' => { 243 => 0x204, 244 => 0x2ea, 245 => 0x26c, 246 => 0x296, 247 => 0x296 },
	'movielenscontrolring' => { 319 => 0xd7, 320 => 0xd7, 321 => 0xd7 },
	'moviemeteringmode' => { 244 => 0x33e, 245 => 0x2c2, 246 => 0x2ea, 247 => 0x2ea },
	'moviemidtonedisplayrange' => { 319 => 0x219, 320 => 0x219, 321 => 0x231 },
	'moviemidtonedisplayvalue' => { 319 => 0x217, 320 => 0x217, 321 => 0x22f },
	'moviemultiselector' => { 319 => 0xd9, 320 => 0xcf, 321 => 0xcf },
	'moviepreviewbutton' => { 304 => '41.2', 306 => '41.2', 307 => '41.2', 316 => '41.2', 317 => '41.2' },
	'moviepreviewbuttonplusdials' => { 304 => '52.2' },
	'movierecordbuttonplaybackmode' => { 319 => 0x1b5, 320 => 0x1b5, 321 => 0x1cd },
	'movieshutterbutton' => { 304 => '38.3', 306 => '38.3', 307 => '38.3', 316 => '38.3', 317 => '38.3' },
	'movieshutterspeedlock' => { 319 => 0x225, 320 => 0x225, 321 => 0x23d },
	'movieslowmotion' => { 243 => 0x1fa },
	'moviesoundrecording' => { 244 => 0x34a, 245 => 0x2ce, 246 => 0x2f6, 247 => 0x2f6 },
	'moviesubjectdetection' => { 244 => 0x378, 245 => 0x2fc, 246 => 0x324, 247 => 0x324 },
	'moviesubselectorassignment' => { 304 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 304 => '53.1' },
	'movietonemap' => { 245 => 0x2ec, 246 => 0x314, 247 => 0x314 },
	'movietype' => { 228 => 0x2ca, 243 => 0x1fe, 244 => 0x2e4, 245 => 0x266, 246 => 0x290, 247 => 0x290 },
	'movievibrationreduction' => { 243 => 0x24e },
	'movievibrationreductionsameasphoto' => { 243 => 0x24f },
	'movievignettecontrol' => { 243 => 0x23e, 244 => 0x1b0, 245 => 0x1a0, 246 => 0x1b4, 247 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 243 => 0x240 },
	'movievrmode' => { 244 => 0x344, 245 => 0x2c8, 246 => 0x2f0, 247 => 0x2f0 },
	'moviezebrapattern' => { 319 => 0x213, 320 => 0x213, 321 => 0x22b },
	'multiburstimageheight' => { 446 => 0x1002 },
	'multiburstimagewidth' => { 446 => 0x1001 },
	'multiburstmode' => { 446 => 0x1000 },
	'multicontrollerwhilemetering' => { 87 => 0x517 },
	'multiexposure' => { 70 => 0x1, 346 => 0xb4 },
	'multiexposureautogain' => { 249 => 0x3 },
	'multiexposurecontrol' => { 70 => 0x2 },
	'multiexposuremode' => { 249 => 0x1, 250 => 0x1 },
	'multiexposureoverlaymode' => { 250 => 0x3 },
	'multiexposureshots' => { 70 => 0x3, 244 => 0x9a, 245 => 0x8e, 246 => 0x9c, 247 => 0x9c, 249 => 0x2, 250 => 0x2 },
	'multiframenoisereduction' => { 435 => 0x35, 446 => 0x200b, 451 => 0x15 },
	'multiframenreffect' => { 446 => 0x2023 },
	'multifunctionlock' => { 87 => 0x70f },
	'multipleexposuremode' => { 244 => 0x98, 245 => 0x8c, 246 => 0x9a, 247 => 0x9a, 327 => 0x101c },
	'multipleexposureset' => { 362 => '10.1' },
	'multisample' => { 262 => 0x40 },
	'multiselector' => { 303 => '9.4', 304 => '10.3', 306 => '10.3', 307 => '10.3', 312 => '27.4', 316 => '10.3', 317 => '10.3' },
	'multiselectorliveview' => { 303 => '4.3', 306 => '37.1', 307 => '37.1', 316 => '37.1', 317 => '37.1' },
	'multiselectorliveviewmode' => { 276 => 0x18c2 },
	'multiselectorplaybackmode' => { 303 => ['13.5','9.2'], 304 => '10.2', 307 => '10.2', 312 => '27.2', 316 => '10.2', 317 => '10.2', 319 => 0xb3, 320 => 0xb3, 321 => 0xb3 },
	'multiselectorshootmode' => { 303 => '9.1', 304 => '10.1', 306 => '10.1', 307 => '10.1', 312 => '27.1', 316 => '10.1', 317 => '10.1', 319 => 0xaf, 320 => 0xaf, 321 => 0xaf },
	'multishot' => { 351 => 0x121 },
	'mute' => { 400 => 'player.movie.audio.mute' },
	'mycolormode' => { 71 => 0x2 },
	'name' => { 406 => 'name', 507 => 'Name', 509 => 'Name' },
	'narrator' => { 398 => "\xa9nrt" },
	'nationalcatalognumber' => { 526 => 'nationalCatalogNumber' },
	'nativedigest' => { 513 => 'NativeDigest', 532 => 'NativeDigest' },
	'ndfilter' => { 79 => 0x1c, 323 => 0x204, 413 => 0x1019 },
	'near' => { 492 => 'Near' },
	'nefbitdepth' => { 239 => 0xe22 },
	'nefcompression' => { 239 => 0x93, 240 => 0xa },
	'neflinearizationtable' => { 239 => 0x96 },
	'negativecachelargepreviewsize' => { 507 => 'NegativeCacheLargePreviewSize', 509 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 507 => 'NegativeCacheMaximumSize', 509 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 507 => 'NegativeCachePath', 509 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 504 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 381 => 0x88 },
	'neutraloutputhighlightpoint' => { 112 => 0x2f },
	'neutraloutputshadowpoint' => { 112 => 0x30 },
	'neutralrawcolortone' => { 112 => 0x28 },
	'neutralrawcontrast' => { 112 => 0x2a },
	'neutralrawhighlight' => { 112 => 0x78 },
	'neutralrawhighlightpoint' => { 112 => 0x2d },
	'neutralrawlinear' => { 112 => 0x2b },
	'neutralrawsaturation' => { 112 => 0x29 },
	'neutralrawshadow' => { 112 => 0x81 },
	'neutralrawshadowpoint' => { 112 => 0x2e },
	'neutralrawsharpness' => { 112 => 0x2c },
	'neutralunsharpmaskfineness' => { 112 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 112 => 0xa8 },
	'neutraunsharpmaskstrength' => { 112 => 0xa4 },
	'newlensdata' => { 237 => 0x2f },
	'newrawimagedigest' => { 122 => 0xc7a7 },
	'newsphotoversion' => { 136 => 0x0 },
	'nickname' => { 534 => 'Nickname' },
	'nikoncapturedata' => { 239 => 0xe01 },
	'nikoncaptureeditversions' => { 239 => 0xe13 },
	'nikoncaptureoffsets' => { 239 => 0xe0e },
	'nikoncaptureoutput' => { 239 => 0xe1e },
	'nikoncaptureversion' => { 239 => 0xe09 },
	'nikoniccprofile' => { 239 => 0xe1d },
	'nikonimagesize' => { 273 => '723.1', 274 => '732.1', 282 => 0x2c4 },
	'nikonmeteringmode' => { 202 => 0x17, 243 => 0x146, 253 => 0x214 },
	'nikonsettings' => { 239 => 0x4e },
	'noisefilter' => { 323 => 0x527 },
	'noiseprofile' => { 122 => 0xc761 },
	'noisereduction' => { 130 => [0x100b,0x100e], 185 => 0xb0, 186 => 0x60, 187 => 0x3f, 239 => 0x95, 296 => 0x753dcbc0, 297 => 0x17, 323 => 0x50a, 328 => 0x103a, 346 => 0x2d, 381 => 0x49, 413 => 0x100f, 415 => 0x2a },
	'noisereduction2' => { 327 => 0x1010 },
	'noisereductionapplied' => { 122 => 0xc6f7 },
	'noisereductionintensity' => { 297 => 0x9 },
	'noisereductionmethod' => { 297 => 0x11 },
	'noisereductionmode' => { 483 => 0x801e },
	'noisereductionparametersatcapture' => { 141 => 0xe73 },
	'noisereductionparameterscamera' => { 141 => 0xe72 },
	'noisereductionparametershost3mp' => { 141 => 0xe71 },
	'noisereductionparametershost6mp' => { 141 => 0xe70 },
	'noisereductionparametershostrgb' => { 141 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 141 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 141 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 141 => 0xe63 },
	'noisereductionparams' => { 351 => 0x1b },
	'noisereductionsharpness' => { 297 => 0xd },
	'noisereductionstrength' => { 346 => 0xd6 },
	'noisereductionvalue' => { 483 => 0x8027 },
	'nomemorycard' => { 303 => '22.1', 304 => '4.2', 305 => '0.3', 308 => '2.4', 309 => '3.2', 310 => '3.2', 312 => '33.7', 313 => '3.2', 314 => '0.3', 316 => '4.2', 318 => '4.5' },
	'nominalmaxaperture' => { 372 => 0xa },
	'nominalminaperture' => { 372 => '10.1' },
	'noncpulens10focallength' => { 244 => 0x6c6, 247 => 0x620 },
	'noncpulens10maxaperture' => { 244 => 0x6ee, 247 => 0x670 },
	'noncpulens11focallength' => { 244 => 0x6c8, 247 => 0x624 },
	'noncpulens11maxaperture' => { 244 => 0x6f0, 247 => 0x674 },
	'noncpulens12focallength' => { 244 => 0x6ca, 247 => 0x628 },
	'noncpulens12maxaperture' => { 244 => 0x6f2, 247 => 0x678 },
	'noncpulens13focallength' => { 244 => 0x6cc, 247 => 0x62c },
	'noncpulens13maxaperture' => { 244 => 0x6f4, 247 => 0x67c },
	'noncpulens14focallength' => { 244 => 0x6ce, 247 => 0x630 },
	'noncpulens14maxaperture' => { 244 => 0x6f6, 247 => 0x680 },
	'noncpulens15focallength' => { 244 => 0x6d0, 247 => 0x634 },
	'noncpulens15maxaperture' => { 244 => 0x6f8, 247 => 0x684 },
	'noncpulens16focallength' => { 244 => 0x6d2, 247 => 0x638 },
	'noncpulens16maxaperture' => { 244 => 0x6fa, 247 => 0x688 },
	'noncpulens17focallength' => { 244 => 0x6d4, 247 => 0x63c },
	'noncpulens17maxaperture' => { 244 => 0x6fc, 247 => 0x68c },
	'noncpulens18focallength' => { 244 => 0x6d6, 247 => 0x640 },
	'noncpulens18maxaperture' => { 244 => 0x6fe, 247 => 0x690 },
	'noncpulens19focallength' => { 244 => 0x6d8, 247 => 0x644 },
	'noncpulens19maxaperture' => { 244 => 0x700, 247 => 0x694 },
	'noncpulens1focallength' => { 244 => 0x6b4, 247 => 0x5fc },
	'noncpulens1maxaperture' => { 244 => 0x6dc, 247 => 0x64c },
	'noncpulens20focallength' => { 244 => 0x6da, 247 => 0x648 },
	'noncpulens20maxaperture' => { 244 => 0x702, 247 => 0x698 },
	'noncpulens2focallength' => { 244 => 0x6b6, 247 => 0x600 },
	'noncpulens2maxaperture' => { 244 => 0x6de, 247 => 0x650 },
	'noncpulens3focallength' => { 244 => 0x6b8, 247 => 0x604 },
	'noncpulens3maxaperture' => { 244 => 0x6e0, 247 => 0x654 },
	'noncpulens4focallength' => { 244 => 0x6ba, 247 => 0x608 },
	'noncpulens4maxaperture' => { 244 => 0x6e2, 247 => 0x658 },
	'noncpulens5focallength' => { 244 => 0x6bc, 247 => 0x60c },
	'noncpulens5maxaperture' => { 244 => 0x6e4, 247 => 0x65c },
	'noncpulens6focallength' => { 244 => 0x6be, 247 => 0x610 },
	'noncpulens6maxaperture' => { 244 => 0x6e6, 247 => 0x660 },
	'noncpulens7focallength' => { 244 => 0x6c0, 247 => 0x614 },
	'noncpulens7maxaperture' => { 244 => 0x6e8, 247 => 0x664 },
	'noncpulens8focallength' => { 244 => 0x6c2, 247 => 0x618 },
	'noncpulens8maxaperture' => { 244 => 0x6ea, 247 => 0x668 },
	'noncpulens9focallength' => { 244 => 0x6c4, 247 => 0x61c },
	'noncpulens9maxaperture' => { 244 => 0x6ec, 247 => 0x66c },
	'normallinetime' => { 141 => 0x186a },
	'normalwhitelevel' => { 43 => 0x32a, 44 => 0x280, 47 => [0x2b8,0x2cf,0x2d3], 48 => 0x569, 49 => 0x1e3, 50 => [0x1fc,0x2dc], 51 => [0x230,0x30e], 52 => 0x31c },
	'notes' => { 484 => 'Notes', 502 => 'notes' },
	'npages' => { 541 => 'NPages' },
	'nullrecord' => { 100 => 0x0 },
	'numafpoints' => { 358 => 0x2 },
	'number' => { 526 => 'number' },
	'numberofbeats' => { 536 => 'numberOfBeats' },
	'numberoffocuspoints' => { 306 => '1.3', 307 => '1.3', 310 => '0.2', 311 => '0.3', 313 => '0.3' },
	'numfaceelements' => { 130 => 0x4200 },
	'numfacepositions' => { 338 => 0x0 },
	'numindexentries' => { 136 => 0x54 },
	'numwbentries' => { 352 => 0x0, 353 => 0x0 },
	'object' => { 526 => 'object' },
	'objectattributereference' => { 134 => 0x4 },
	'objectcycle' => { 134 => 0x4b, 502 => 'ObjectCycle' },
	'objectdescription' => { 525 => 'objectDescription' },
	'objectdistance' => { 115 => 0x6, 116 => 0x2022 },
	'objectname' => { 134 => 0x5 },
	'objectpreviewdata' => { 134 => 0xca },
	'objectpreviewfileformat' => { 134 => 0xc8 },
	'objectpreviewfileversion' => { 134 => 0xc9 },
	'objectsubtype' => { 525 => 'objectSubtype' },
	'objecttype' => { 525 => 'objectType' },
	'objecttypereference' => { 134 => 0x3 },
	'occurrence' => { 121 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 121 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 121 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 121 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 121 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 121 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 121 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 121 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 121 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 121 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 121 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 121 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 121 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 121 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 121 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 121 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 121 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 121 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 121 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 121 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 121 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 121 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 121 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 121 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 121 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 121 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 121 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 121 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 121 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 121 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 513 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 513 => [\'OECF','OECFNames'] },
	'oecfrows' => { 513 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 513 => [\'OECF','OECFValues'] },
	'offsaledate' => { 526 => 'offSaleDate' },
	'offsaledatea-platform' => { 526 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 526 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 141 => 0x190a },
	'offsethdr' => { 518 => 'OffsetHDR' },
	'offsetschema' => { 122 => 0xea1d },
	'offsetsdr' => { 518 => 'OffsetSDR' },
	'offsettime' => { 122 => 0x9010 },
	'offsettimedigitized' => { 122 => 0x9012 },
	'offsettimeoriginal' => { 122 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 313 => '15.1', 318 => '16.1' },
	'oldsubfiletype' => { 122 => 0xff },
	'olympusimageheight' => { 328 => 0x102f },
	'olympusimagewidth' => { 328 => 0x102e },
	'omenatcapturestrength' => { 141 => 0xa60 },
	'omenautostrength' => { 141 => 0xa5f },
	'omenearlystrength' => { 141 => 0xa5e },
	'omenfocallengthlimit' => { 141 => 0xa62 },
	'omeninitialipfstrength' => { 141 => 0xa5d },
	'omensurfaceindex' => { 141 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 328 => 0x302 },
	'onsaledate' => { 526 => 'onSaleDate' },
	'onsaledatea-platform' => { 526 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 526 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 526 => 'onSaleDay' },
	'onsaledaya-platform' => { 526 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 526 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 122 => 0xc740 },
	'opcodelist2' => { 122 => 0xc741 },
	'opcodelist3' => { 122 => 0xc74e },
	'opticalzoom' => { 145 => 0xfa3d, 147 => [0x6006,0xf006], 148 => 0x1000, 149 => 0xf, 152 => 0x1e, 154 => 0x20, 155 => 0x1c, 166 => 'OpticalZoom' },
	'opticalzoomcode' => { 79 => 0xa },
	'opticalzoommode' => { 346 => 0x34 },
	'opticalzoomon' => { 422 => 0x219 },
	'optionenddate' => { 529 => 'optionEndDate' },
	'opto-electricconvfactor' => { 513 => 'OECF' },
	'orangehsl' => { 106 => 0x20911 },
	'ordernumber' => { 130 => 0x8002 },
	'organisationinimagecode' => { 521 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 521 => 'OrganisationInImageName' },
	'organism' => { 121 => 'Organism' },
	'organismassociatedoccurrences' => { 121 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 121 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 121 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 121 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 121 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 121 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 121 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 526 => 'organization' },
	'orientation' => { 122 => 0x112, 351 => 0x112, 525 => 'orientation', 532 => 'Orientation' },
	'orientation2' => { 451 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 87 => 0x516 },
	'originalalbumtitle' => { 182 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 182 => 'WM/OriginalArtist', 398 => "\xa9ope" },
	'originalbestqualitysize' => { 122 => 0xc792 },
	'originalcreatedatetime' => { 497 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 117 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 66 => 0x83 },
	'originaldefaultcropsize' => { 122 => 0xc793 },
	'originaldefaultfinalsize' => { 122 => 0xc791 },
	'originaldirectory' => { 343 => 0x408 },
	'originaldocumentid' => { 537 => 'OriginalDocumentID' },
	'originalfilename' => { 100 => 0x816, 141 => 0x3e9, 153 => 0x20, 343 => 0x407, 497 => 'OriginalFilename' },
	'originalimagehash' => { 487 => 'OriginalImageHash' },
	'originalimagehashtype' => { 487 => 'OriginalImageHashType' },
	'originalimageheight' => { 81 => 0xc, 126 => 0x1 },
	'originalimagemd5' => { 487 => 'OriginalImageMD5' },
	'originalimagesize' => { 165 => 'OriginalImageSize' },
	'originalimagewidth' => { 81 => 0xb, 126 => 0x0 },
	'originallyricist' => { 182 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 122 => 0xc68c },
	'originalrawfiledigest' => { 122 => 0xc71d },
	'originalrawfilename' => { 122 => 0xc68b },
	'originaltransmissionreference' => { 134 => 0x67 },
	'originatingprogram' => { 134 => 0x41, 502 => 'OriginatingProgram' },
	'originplatform' => { 526 => 'originPlatform' },
	'os' => { 511 => 'os' },
	'otherconditions' => { 333 => 'OtherConditions' },
	'otherconstraints' => { 333 => 'OtherConstraints' },
	'otherimage' => { 117 => 'Exif-OtherImage' },
	'otherimageinfo' => { 333 => 'OtherImageInfo' },
	'otherimagelength' => { 122 => 0x202 },
	'otherimagestart' => { 122 => 0x201 },
	'otherlicensedocuments' => { 333 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 333 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 333 => 'OtherLicenseRequirements' },
	'outcue' => { 536 => 'outCue' },
	'outcuescale' => { 536 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 536 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 203 => 0x3 },
	'outputimagewidth' => { 203 => 0x2 },
	'outputlut' => { 346 => 0xa7 },
	'outputprofile' => { 141 => 0x138b },
	'outputresolution' => { 203 => 0x4 },
	'overclockcols' => { 141 => 0x189c },
	'overclockrows' => { 141 => 0x18c4 },
	'overridelookvignette' => { 507 => 'OverrideLookVignette', 509 => 'OverrideLookVignette' },
	'owner' => { 398 => 'ownr', 540 => 'Owner' },
	'ownerid' => { 134 => 0xbc },
	'ownername' => { 15 => 0x10f, 66 => 0x9, 100 => 0x810, 122 => [0xa430,0xfde8], 159 => 'OwnerName', 504 => 'OwnerName', 514 => 'CameraOwnerName' },
	'padding' => { 122 => 0xea1c },
	'pagecount' => { 526 => 'pageCount' },
	'pageimage' => { 534 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 534 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 534 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 534 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 534 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 534 => 'PageInfo' },
	'pagename' => { 122 => 0x11d },
	'pagenumber' => { 122 => 0x129 },
	'pageprogressiondirection' => { 526 => 'pageProgressionDirection' },
	'pagerange' => { 526 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 507 => 'PaintBasedCorrections', 509 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 509 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 349 => 0x0 },
	'panasonicexifversion' => { 346 => 0x26 },
	'panasonicimageheight' => { 346 => 0x4c },
	'panasonicimagewidth' => { 346 => 0x4b },
	'panasonicrawversion' => { 351 => 0x1 },
	'panasonictitle' => { 122 => 0xc6d2 },
	'panasonictitle2' => { 122 => 0xc6d3 },
	'panoramaangle' => { 130 => 0x1153 },
	'panoramacropbottom' => { 452 => 0x7 },
	'panoramacropleft' => { 452 => 0x4 },
	'panoramacropright' => { 452 => 0x6 },
	'panoramacroptop' => { 452 => 0x5 },
	'panoramadirection' => { 74 => 0x5, 130 => 0x1154, 452 => 0x3 },
	'panoramaframeheight' => { 452 => 0x9 },
	'panoramaframenumber' => { 74 => 0x2 },
	'panoramaframewidth' => { 452 => 0x8 },
	'panoramafullheight' => { 452 => 0x2 },
	'panoramafullwidth' => { 452 => 0x1 },
	'panoramamode' => { 143 => 0x3c, 323 => 0x601 },
	'panoramasize3d' => { 435 => 0x38 },
	'panoramasourceheight' => { 452 => 0xb },
	'panoramasourcewidth' => { 452 => 0xa },
	'panoramicstitchcameramotion' => { 179 => 'PanoramicStitchCameraMotion', 180 => 0x1 },
	'panoramicstitchmaptype' => { 179 => 'PanoramicStitchMapType', 180 => 0x2 },
	'panoramicstitchphi0' => { 179 => 'PanoramicStitchPhi0', 180 => 0x5 },
	'panoramicstitchphi1' => { 179 => 'PanoramicStitchPhi1', 180 => 0x6 },
	'panoramicstitchtheta0' => { 179 => 'PanoramicStitchTheta0', 180 => 0x3 },
	'panoramicstitchtheta1' => { 179 => 'PanoramicStitchTheta1', 180 => 0x4 },
	'panoramicstitchversion' => { 180 => 0x0 },
	'pantry' => { 537 => 'Pantry' },
	'pantryinstanceid' => { 537 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 130 => 0xb211, 322 => 0x28 },
	'parametricdarks' => { 507 => 'ParametricDarks', 509 => 'ParametricDarks' },
	'parametrichighlights' => { 507 => 'ParametricHighlights', 509 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 507 => 'ParametricHighlightSplit', 509 => 'ParametricHighlightSplit' },
	'parametriclights' => { 507 => 'ParametricLights', 509 => 'ParametricLights' },
	'parametricmidtonesplit' => { 507 => 'ParametricMidtoneSplit', 509 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 507 => 'ParametricShadows', 509 => 'ParametricShadows' },
	'parametricshadowsplit' => { 507 => 'ParametricShadowSplit', 509 => 'ParametricShadowSplit' },
	'parentalrating' => { 182 => 'WM/ParentalRating' },
	'parentid' => { 521 => 'parentId' },
	'parentmediaeventid' => { 497 => 'ParentMediaEventID' },
	'parentmeid' => { 497 => 'ParentMEID' },
	'parentproductid' => { 398 => '@ppi' },
	'parentreference1' => { 519 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 519 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 398 => '@PST' },
	'parenttitle' => { 398 => '@pti' },
	'partialactivecols1' => { 141 => 0x17e8 },
	'partialactivecols2' => { 141 => 0x17f2 },
	'partialactiverows1' => { 141 => 0x17fc },
	'partialactiverows2' => { 141 => 0x1806 },
	'partofcompilation' => { 536 => 'partOfCompilation' },
	'patientbirthdate' => { 485 => 'PatientDOB' },
	'patientid' => { 485 => 'PatientID' },
	'patientname' => { 485 => 'PatientName' },
	'patientsex' => { 485 => 'PatientSex' },
	'patternareaheight' => { 141 => 0x963 },
	'patternareawidth' => { 141 => 0x962 },
	'patterncorrectionfactorscale' => { 141 => 0x969 },
	'patterncropcols1' => { 141 => 0x96c },
	'patterncropcols2' => { 141 => 0x96d },
	'patterncroprows1' => { 141 => 0x96a },
	'patterncroprows2' => { 141 => 0x96b },
	'patternimagerheight' => { 141 => 0x961 },
	'patternimagerwidth' => { 141 => 0x960 },
	'patternx' => { 141 => 0x966 },
	'patterny' => { 141 => 0x967 },
	'pdfversion' => { 523 => 'PDFVersion' },
	'pentaximagesize' => { 381 => 0x9 },
	'pentaxmodelid' => { 361 => 0x0, 381 => 0x5 },
	'pentaxmodeltype' => { 381 => 0x1 },
	'pentaxversion' => { 381 => 0x0 },
	'people' => { 488 => 'People', 500 => 'People' },
	'perchannelblacklevel' => { 43 => 0x157, 44 => 0x16b, 46 => 0xc4, 47 => [0x2b4,0x2cb,0x2cf], 48 => [0x108,0x14d], 49 => 0x1df, 50 => [0x1f8,0x2d8], 51 => [0x22c,0x30a], 52 => 0x149 },
	'performer' => { 398 => 'perf', 406 => 'perf' },
	'performerkeywords' => { 406 => "\xa9prk" },
	'performers' => { 406 => "\xa9prf" },
	'performerurl' => { 406 => "\xa9prl" },
	'period' => { 182 => 'WM/Period' },
	'peripheralillumcentralradius' => { 483 => 0x8030 },
	'peripheralillumcentralvalue' => { 483 => 0x8031 },
	'peripheralillumination' => { 106 => 0x20702, 112 => 0x68 },
	'peripheralilluminationcorr' => { 64 => 0x1, 371 => 0x2 },
	'peripheralilluminationon' => { 106 => '0x20702.0', 112 => 0x64 },
	'peripheralillumperiphvalue' => { 483 => 0x8032 },
	'peripherallighting' => { 81 => 0x2, 130 => 0x3804 },
	'peripherallightingsetting' => { 82 => 0x5 },
	'peripherallightingvalue' => { 81 => 0x6 },
	'permissions' => { 529 => 'permissions' },
	'permits' => { 505 => 'permits' },
	'person' => { 526 => 'person' },
	'personality' => { 497 => 'Personality' },
	'personheard' => { 521 => 'PersonHeard' },
	'personheardidentifier' => { 521 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 521 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 521 => 'PersonInImage' },
	'personinimagecharacteristic' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 521 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 521 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 507 => 'PerspectiveAspect', 509 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 507 => 'PerspectiveHorizontal', 509 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 507 => 'PerspectiveRotate', 509 => 'PerspectiveRotate' },
	'perspectivescale' => { 507 => 'PerspectiveScale', 509 => 'PerspectiveScale' },
	'perspectiveupright' => { 507 => 'PerspectiveUpright', 509 => 'PerspectiveUpright' },
	'perspectivevertical' => { 507 => 'PerspectiveVertical', 509 => 'PerspectiveVertical' },
	'perspectivex' => { 507 => 'PerspectiveX', 509 => 'PerspectiveX' },
	'perspectivey' => { 507 => 'PerspectiveY', 509 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 95 => 0x1 },
	'pf10retainprogramshift' => { 95 => 0xb },
	'pf13drivepriority' => { 95 => 0xe },
	'pf14disablefocussearch' => { 95 => 0xf },
	'pf15disableafassistbeam' => { 95 => 0x10 },
	'pf16autofocuspointshoot' => { 95 => 0x11 },
	'pf17disableafpointsel' => { 95 => 0x12 },
	'pf18enableautoafpointsel' => { 95 => 0x13 },
	'pf19continuousshootspeed' => { 95 => 0x14 },
	'pf19shootingspeedhigh' => { 94 => 0xa },
	'pf19shootingspeedlow' => { 94 => 0x9 },
	'pf1disableshootingmodes' => { 95 => 0x2 },
	'pf1value' => { 94 => 0x1 },
	'pf20limitcontinousshots' => { 95 => 0x15 },
	'pf20maxcontinousshots' => { 94 => 0xb },
	'pf21enablequietoperation' => { 95 => 0x16 },
	'pf23felocktime' => { 94 => 0xd },
	'pf23postreleasetime' => { 94 => 0xe },
	'pf23settimerlengths' => { 95 => 0x18 },
	'pf23shutterbuttontime' => { 94 => 0xc },
	'pf24lightlcdduringbulb' => { 95 => 0x19 },
	'pf25aemode' => { 94 => 0xf },
	'pf25afmode' => { 94 => 0x12 },
	'pf25afpointsel' => { 94 => 0x13 },
	'pf25colormatrix' => { 94 => 0x17 },
	'pf25defaultclearsettings' => { 95 => 0x1a },
	'pf25drivemode' => { 94 => 0x11 },
	'pf25imagesize' => { 94 => 0x14 },
	'pf25meteringmode' => { 94 => 0x10 },
	'pf25parameters' => { 94 => 0x16 },
	'pf25wbmode' => { 94 => 0x15 },
	'pf26shortenreleaselag' => { 95 => 0x1b },
	'pf27reversedialrotation' => { 95 => 0x1c },
	'pf27value' => { 94 => 0x18 },
	'pf28noquickdialexpcomp' => { 95 => 0x1d },
	'pf29quickdialswitchoff' => { 95 => 0x1e },
	'pf2disablemeteringmodes' => { 95 => 0x3 },
	'pf2value' => { 94 => 0x2 },
	'pf30enlargementmode' => { 95 => 0x1f },
	'pf31originaldecisiondata' => { 95 => 0x20 },
	'pf3manualexposuremetering' => { 95 => 0x4 },
	'pf3value' => { 94 => 0x3 },
	'pf4exposuretimelimits' => { 95 => 0x5 },
	'pf4exposuretimemax' => { 94 => 0x5 },
	'pf4exposuretimemin' => { 94 => 0x4 },
	'pf5aperturelimits' => { 95 => 0x6 },
	'pf5aperturemax' => { 94 => 0x7 },
	'pf5aperturemin' => { 94 => 0x6 },
	'pf6presetshootingmodes' => { 95 => 0x7 },
	'pf7bracketcontinuousshoot' => { 95 => 0x8 },
	'pf8bracketshots' => { 94 => 0x8 },
	'pf8setbracketshots' => { 95 => 0x9 },
	'pf9changebracketsequence' => { 95 => 0xa },
	'phasedetectaf' => { 196 => 0x6 },
	'phonenumber' => { 160 => 'Phone' },
	'photoeffect' => { 36 => 0x28 },
	'photoeffecthistoryxml' => { 296 => 0xe9651831 },
	'photoeffects' => { 296 => 0xab5eca5e },
	'photoeffectsblue' => { 298 => 0x8 },
	'photoeffectsgreen' => { 298 => 0x6 },
	'photoeffectsred' => { 298 => 0x4 },
	'photoeffectstype' => { 298 => 0x0 },
	'photographer' => { 122 => 0xa437 },
	'photographicsensitivity' => { 514 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 303 => '17.6', 312 => '33.6' },
	'photometricinterpretation' => { 122 => 0x106, 532 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 244 => 0x11e, 245 => 0x112, 246 => 0x122, 247 => 0x122, 248 => 0x24, 266 => 0x0 },
	'photoshootingmenubankimagearea' => { 242 => 0x6dd, 244 => 0x144, 245 => 0x134, 246 => 0x148, 247 => 0x148, 266 => '7.1' },
	'photoshopbgrthumbnail' => { 395 => 0x409 },
	'photoshopquality' => { 394 => 0x0 },
	'photoshopthumbnail' => { 395 => 0x40c },
	'photostyle' => { 346 => 0x89 },
	'picasawebgphotoid' => { 512 => 'picasawebGPhotoId' },
	'picklabel' => { 512 => 'PickLabel' },
	'pictinfo' => { 422 => 0x208 },
	'picturecontrol' => { 296 => 0xe2173c47 },
	'picturecontrolactive' => { 299 => 0x0 },
	'picturecontroladjust' => { 254 => 0x30, 255 => 0x30, 256 => 0x36 },
	'picturecontrolbase' => { 254 => 0x18, 255 => 0x18, 256 => 0x1c },
	'picturecontroldata' => { 239 => [0xbd,0x23] },
	'picturecontrolmode' => { 299 => 0x13 },
	'picturecontrolname' => { 254 => 0x4, 255 => 0x4, 256 => 0x8 },
	'picturecontrolquickadjust' => { 254 => 0x31, 255 => 0x31, 256 => 0x37 },
	'pictureeffect' => { 446 => 0x200e },
	'pictureeffect2' => { 455 => 0x1163, 456 => 0x1167, 457 => 0x1143, 458 => 0x11bf, 459 => 0x119b, 460 => 0x1053, 461 => 0x24b, 462 => 0x24b, 463 => 0x23c, 478 => 0x46 },
	'picturefinish' => { 185 => 0x71 },
	'picturemode' => { 130 => 0x1031, 323 => 0x520, 381 => [0xb,0x33], 423 => 0x3d },
	'picturemode2' => { 362 => 0x0 },
	'picturemodebwfilter' => { 323 => 0x525 },
	'picturemodecontrast' => { 323 => 0x523 },
	'picturemodeeffect' => { 323 => 0x52d },
	'picturemodehue' => { 323 => 0x522 },
	'picturemodesaturation' => { 323 => 0x521 },
	'picturemodesharpness' => { 323 => 0x524 },
	'picturemodetone' => { 323 => 0x526 },
	'pictureprofile' => { 455 => [0x115e,0x115f], 456 => [0x1162,0x1163], 457 => [0x113e,0x113f], 458 => [0x11ba,0x11bb], 459 => [0x1196,0x1197], 460 => [0x104e,0x104f], 461 => [0x246,0x247], 462 => [0x246,0x247], 463 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 76 => 0xa, 106 => 0x20301, 112 => 0x2 },
	'picturestylepc' => { 66 => 0x4009 },
	'picturestyleuserdef' => { 66 => 0x4008 },
	'picturewizard' => { 420 => 0x21 },
	'picturewizardcolor' => { 419 => 0x1 },
	'picturewizardcontrast' => { 419 => 0x4 },
	'picturewizardmode' => { 419 => 0x0 },
	'picturewizardsaturation' => { 419 => 0x2 },
	'picturewizardsharpness' => { 419 => 0x3 },
	'pipelineversion' => { 179 => 'PipelineVersion' },
	'pitch' => { 118 => 0x6, 304 => '4.1', 316 => '4.1', 406 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 252 => 0x4, 323 => 0x904, 346 => 0x91, 380 => 0x2, 418 => 0x1 },
	'pitchshift' => { 400 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 399 => 'pasp' },
	'pixelclockfrequency' => { 141 => 0x40b },
	'pixelcorrectionoffset' => { 141 => 0x972 },
	'pixelcorrectionscale' => { 141 => 0x971 },
	'pixelscale' => { 122 => 0x830e },
	'pixelshiftinfo' => { 446 => 0x202f },
	'pixelshiftoffset' => { 130 => 0x1106 },
	'pixelshiftresolution' => { 382 => 0x0 },
	'pixelshiftshots' => { 130 => 0x1105 },
	'pixelsperunitx' => { 335 => 0x0 },
	'pixelsperunity' => { 335 => 0x4 },
	'pixelunits' => { 335 => 0x8 },
	'planarconfiguration' => { 122 => 0x11c, 532 => 'PlanarConfiguration' },
	'plane' => { 486 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 486 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 486 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 486 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 486 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 486 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 486 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 486 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 486 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 486 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 486 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 486 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 486 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 486 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 486 => 'Planes' },
	'planningref' => { 521 => 'PlanningRef' },
	'planningrefidentifier' => { 521 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 521 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 521 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 541 => 'PlateNames' },
	'platform' => { 526 => 'platform' },
	'playallframes' => { 406 => 'AllF' },
	'playbackbutton' => { 247 => 0x808 },
	'playbackbuttonplaybackmode' => { 247 => 0x814 },
	'playbackflickdown' => { 319 => 0x159, 320 => 0x159, 321 => 0x171 },
	'playbackflickup' => { 319 => 0x155, 320 => 0x155, 321 => 0x16d },
	'playbackmenustime' => { 308 => '20.1', 309 => '21.1', 310 => '21.1' },
	'playbackmonitorofftime' => { 303 => '25.2', 304 => '36.1', 306 => '36.1', 307 => '36.1', 311 => '35.1', 312 => '8.1', 313 => '35.1', 316 => '36.1', 317 => '36.1', 318 => '21.1', 319 => 0x33, 320 => 0x33, 321 => 0x33 },
	'playbackzoom' => { 304 => '37.1' },
	'playdisplay' => { 187 => 0x4e },
	'playerversion' => { 400 => 'player.version' },
	'playgap' => { 398 => 'pgap' },
	'playmode' => { 406 => 'SDLN' },
	'playselection' => { 406 => 'SelO' },
	'plusversion' => { 333 => 'Version' },
	'pmversion' => { 393 => 'PMVersion' },
	'pngwarning' => { 336 => 'Warning' },
	'podcast' => { 398 => 'pcst' },
	'podcasturl' => { 398 => 'purl' },
	'poilevel' => { 238 => 0x8 },
	'portraitimpressionbalance' => { 244 => 0x26e, 257 => 0xa0 },
	'portraitnote' => { 490 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 112 => 0x1d },
	'portraitoutputshadowpoint' => { 112 => 0x1e },
	'portraitrawcolortone' => { 112 => 0x16 },
	'portraitrawcontrast' => { 112 => 0x18 },
	'portraitrawhighlight' => { 112 => 0x76 },
	'portraitrawhighlightpoint' => { 112 => 0x1b },
	'portraitrawlinear' => { 112 => 0x19 },
	'portraitrawsaturation' => { 112 => 0x17 },
	'portraitrawshadow' => { 112 => 0x7f },
	'portraitrawshadowpoint' => { 112 => 0x1c },
	'portraitrawsharpness' => { 112 => 0x1a },
	'portraitrefiner' => { 116 => 0x302b },
	'portraitrequest' => { 490 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 112 => 0x9a },
	'portraitunsharpmaskstrength' => { 112 => 0x98 },
	'portraitunsharpmaskthreshold' => { 112 => 0x9c },
	'portraitversion' => { 490 => 'PortraitVersion' },
	'pose' => { 486 => 'Pose' },
	'poseheadingdegrees' => { 495 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 495 => 'PosePitchDegrees' },
	'posepositionx' => { 486 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 486 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 486 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 495 => 'PoseRollDegrees' },
	'poserotationw' => { 486 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 486 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 486 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 486 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 486 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 525 => 'positionDescriptor' },
	'postalcode' => { 164 => 'PostalCode' },
	'postcropvignetteamount' => { 507 => 'PostCropVignetteAmount', 509 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 507 => 'PostCropVignetteFeather', 509 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 507 => 'PostCropVignetteHighlightContrast', 509 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 507 => 'PostCropVignetteMidpoint', 509 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 507 => 'PostCropVignetteRoundness', 509 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 507 => 'PostCropVignetteStyle', 509 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 346 => 0xbf },
	'postreleaseburstlength' => { 246 => 0x714, 247 => 0x784, 319 => 0x289 },
	'potentialface1position' => { 443 => 0xb },
	'potentialface2position' => { 443 => 0x15 },
	'potentialface3position' => { 443 => 0x1f },
	'potentialface4position' => { 443 => 0x29 },
	'potentialface5position' => { 443 => 0x33 },
	'potentialface6position' => { 443 => 0x3d },
	'potentialface7position' => { 443 => 0x47 },
	'potentialface8position' => { 443 => 0x51 },
	'powersource' => { 360 => '0.1' },
	'poweruptime' => { 239 => 0xb6 },
	'preaf' => { 129 => '0.2' },
	'precaptureframes' => { 328 => 0x300 },
	'predictor' => { 122 => 0x13d },
	'preflashreturnstrength' => { 274 => 0x28a },
	'prefs' => { 134 => 0xdd, 393 => 'Prefs' },
	'prereadfastresetcount' => { 141 => 0x187e },
	'prereleaseburstlength' => { 246 => 0x712, 247 => 0x782, 319 => 0x287 },
	'preservedfilename' => { 537 => 'PreservedFileName' },
	'preservedspecimen' => { 121 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 121 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 507 => 'PresetType', 509 => 'PresetType' },
	'presetwhitebalance' => { 187 => 0x24, 483 => 0x8002 },
	'presetwhitebalanceadj' => { 483 => 0x8014 },
	'pressure' => { 122 => 0x9402, 514 => 'Pressure' },
	'previewapplicationname' => { 122 => 0xc716 },
	'previewapplicationversion' => { 122 => 0xc717 },
	'previewbutton' => { 303 => ['14.1','15.1'], 304 => '15.1', 306 => '15.1', 307 => '15.1', 312 => '29.1', 313 => '14.1', 316 => '15.1', 317 => '15.1' },
	'previewbuttonplusdials' => { 303 => ['14.2','15.2'], 304 => '15.2', 306 => '43.1', 307 => '43.1', 312 => '31.2', 316 => '43.1', 317 => '43.1' },
	'previewcolorspace' => { 122 => 0xc71a },
	'previewcropbottom' => { 392 => 0xef },
	'previewcropleft' => { 392 => 0xec },
	'previewcropright' => { 392 => 0xee },
	'previewcroptop' => { 392 => 0xed },
	'previewdate' => { 404 => 0x0 },
	'previewdatetime' => { 122 => 0xc71b },
	'previewimage' => { 116 => 0x2000, 117 => 'Exif-PreviewImage', 123 => 'PreviewImage', 125 => 0x4, 169 => 'data', 189 => 0x81, 328 => 0x280, 344 => 0x300, 406 => 'mcvr', 446 => 0x2001 },
	'previewimageborders' => { 381 => 0x3e },
	'previewimageheight' => { 75 => 0x4, 145 => 0xfa58 },
	'previewimagelength' => { 75 => 0x2, 116 => 0x3, 122 => [0x117,0x202], 189 => 0x89, 258 => 0x202, 323 => 0x102, 328 => 0x1037, 381 => 0x3, 412 => 0x1e, 417 => 0x3, 423 => [0x1b,0x1d], 436 => 0x202 },
	'previewimagename' => { 169 => '1Name' },
	'previewimagesize' => { 116 => 0x2, 150 => 0x2, 169 => 'ImageSize', 381 => 0x2, 423 => [0x1c,0x1e], 446 => 0xb02c, 483 => 0x9012 },
	'previewimagestart' => { 75 => 0x5, 116 => 0x4, 122 => [0x111,0x201], 189 => 0x88, 258 => 0x201, 323 => 0x101, 328 => 0x1036, 381 => 0x4, 412 => 0x1c, 417 => 0x2, 423 => [0x1a,0x1c], 436 => 0x201 },
	'previewimagetype' => { 169 => '0Type' },
	'previewimagevalid' => { 323 => 0x100, 328 => 0x1035 },
	'previewimagewidth' => { 75 => 0x3, 145 => 0xfa57 },
	'previewquality' => { 75 => 0x1 },
	'previewsettingsdigest' => { 122 => 0xc719 },
	'previewsettingsname' => { 122 => 0xc718 },
	'primaryafpoint' => { 196 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 122 => 0x13f, 532 => 'PrimaryChromaticities' },
	'primaryftp' => { 497 => 'PrimaryFTP' },
	'primaryslot' => { 248 => 0x25, 266 => 0x2 },
	'printim' => { 122 => 0xc4a5 },
	'prioritysetinawb' => { 446 => 0x202b },
	'prioritysetupshutterrelease' => { 187 => 0x1d, 433 => 0x28 },
	'privatertkinfo' => { 499 => 'privateRTKInfo' },
	'processbordercolsleft' => { 141 => 0xc61 },
	'processbordercolsright' => { 141 => 0xc62 },
	'processborderrowsbottom' => { 141 => 0xc64 },
	'processborderrowstop' => { 141 => 0xc63 },
	'processingsoftware' => { 122 => 0xb },
	'processversion' => { 507 => 'ProcessVersion', 509 => 'ProcessVersion' },
	'producer' => { 182 => 'WM/Producer', 332 => 'Producer', 398 => "\xa9prd", 400 => 'producer', 406 => "\xa9prd", 523 => 'Producer' },
	'producerkeywords' => { 406 => "\xa9pdk" },
	'productcode' => { 526 => 'productCode' },
	'productid' => { 135 => 0x32, 398 => 'prID', 525 => 'productID' },
	'productidtype' => { 525 => 'productIDType' },
	'productinimage' => { 521 => 'ProductInImage' },
	'productinimagedescription' => { 521 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 521 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 521 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 521 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 361 => 0x2 },
	'productorserviceconstraints' => { 333 => 'ProductOrServiceConstraints' },
	'productversion' => { 398 => 'VERS' },
	'profession' => { 526 => 'profession' },
	'profile' => { 486 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 122 => 0xc6f4 },
	'profilecameraindices' => { 486 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 122 => 0xc6fe },
	'profiledynamicrange' => { 122 => 0xcd47 },
	'profileembedpolicy' => { 122 => 0xc6fd },
	'profilegaintablemap' => { 122 => 0xcd2d },
	'profilegaintablemap2' => { 122 => 0xcd40 },
	'profilegroupname' => { 122 => 0xcd48 },
	'profilehuesatmapdata1' => { 122 => 0xc6fa },
	'profilehuesatmapdata2' => { 122 => 0xc6fb },
	'profilehuesatmapdata3' => { 122 => 0xcd39 },
	'profilehuesatmapdims' => { 122 => 0xc6f9 },
	'profilehuesatmapencoding' => { 122 => 0xc7a3 },
	'profilelooktabledata' => { 122 => 0xc726 },
	'profilelooktabledims' => { 122 => 0xc725 },
	'profilelooktableencoding' => { 122 => 0xc7a4 },
	'profilename' => { 122 => 0xc6f8, 334 => 'iCCP-name' },
	'profiles' => { 486 => 'Profiles' },
	'profiletonecurve' => { 122 => 0xc6fc },
	'profiletype' => { 486 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 346 => 0x3c },
	'programline' => { 362 => '1.1' },
	'programmode' => { 192 => 0x5 },
	'programshift' => { 239 => 0xd },
	'programversion' => { 134 => 0x46 },
	'prohibits' => { 505 => 'prohibits' },
	'projectiontype' => { 495 => 'ProjectionType', 496 => 'ProjectionType' },
	'projectname' => { 536 => 'projectName' },
	'projectref' => { 536 => 'projectRef' },
	'projectrefpath' => { 536 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 536 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 182 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 333 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 333 => 'PropertyReleaseStatus' },
	'provider' => { 182 => 'WM/Provider' },
	'province-state' => { 134 => 0x5f },
	'publicationdate' => { 526 => 'publicationDate' },
	'publicationdatea-platform' => { 526 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 526 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 526 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 526 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 526 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 521 => 'PublicationEvent' },
	'publicationeventdate' => { 521 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 521 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 521 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 526 => 'publicationName' },
	'publisher' => { 182 => 'WM/Publisher', 398 => "\xa9pub", 400 => 'publisher', 510 => 'publisher' },
	'publishingfrequency' => { 526 => 'publishingFrequency' },
	'pulldown' => { 536 => 'pullDown' },
	'purchasedate' => { 398 => 'purd' },
	'purplehsl' => { 106 => 0x20916 },
	'pxshiftperiphedgenr' => { 483 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 483 => 0x9014 },
	'quality' => { 0 => 0x1, 36 => 0x3, 115 => 0x2, 116 => 0x3002, 130 => 0x1000, 143 => 0x9, 239 => 0x4, 285 => 0x3, 328 => 0x201, 341 => 0x300, 381 => 0x8, 388 => 0x2, 423 => 0x16, 433 => 0x56, 434 => 0x56, 435 => 0xb, 446 => [0x102,0x202e] },
	'quality2' => { 455 => 0x1170, 456 => 0x1174, 457 => 0x1150, 459 => 0x11a8, 460 => 0x1060, 461 => 0x258, 462 => 0x258, 463 => 0x247, 469 => 0x29, 470 => 0x25, 471 => 0x2a },
	'qualitybutton' => { 320 => 0x17d, 321 => 0x195 },
	'qualitybuttonplaybackmode' => { 320 => 0x1bf, 321 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 116 => 0x8 },
	'quantizationmethod' => { 136 => 0x78 },
	'quickadjust' => { 299 => 0x2a },
	'quickcontroldialinmeter' => { 87 => 0x703 },
	'quickfix' => { 296 => 0x416391c6 },
	'quickshot' => { 422 => 0x213 },
	'quiettime' => { 141 => 0x188a },
	'radialdistortioncoefficient1' => { 214 => 0x14 },
	'radialdistortioncoefficient2' => { 214 => 0x1c },
	'radialdistortioncoefficient3' => { 214 => 0x24 },
	'rads' => { 406 => 'rads' },
	'rangefinder' => { 308 => '4.1', 309 => '5.1', 310 => '5.1' },
	'rangemask' => { 507 => 'RangeMaskMapInfo', 509 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 509 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 509 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 509 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 509 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 509 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 509 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 134 => 0x7d },
	'rating' => { 122 => 0x4746, 130 => 0x1431, 392 => 0xdf, 398 => 'rtng', 406 => 'rtng', 446 => 0x2002, 502 => 'rating', 511 => 'rating', 521 => 'Rating', 526 => 'rating', 534 => 'Rating' },
	'ratingpercent' => { 122 => 0x4749, 181 => 'Rating', 398 => 'rate', 534 => 'RatingPercent' },
	'ratingregion' => { 521 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 521 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 521 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 521 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 521 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 521 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 521 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 521 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 521 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 521 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 521 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 521 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 521 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 521 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 521 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 521 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 521 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 521 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 85 => 0x8, 189 => 0x109, 362 => 0xd },
	'rawbrightnessadj' => { 106 => 0x20001, 111 => 0x38 },
	'rawburstimagecount' => { 77 => 0x2 },
	'rawburstimagenum' => { 77 => 0x1 },
	'rawcoloradj' => { 111 => 0x2e },
	'rawcropbottom' => { 392 => 0xd4 },
	'rawcropleft' => { 392 => 0xd1 },
	'rawcropright' => { 392 => 0xd3 },
	'rawcroptop' => { 392 => 0xd2 },
	'rawcustomsaturation' => { 111 => 0x30 },
	'rawcustomtone' => { 111 => 0x34 },
	'rawdata' => { 420 => 0xa048 },
	'rawdatabyteorder' => { 420 => 0x40 },
	'rawdatacfapattern' => { 420 => 0x50 },
	'rawdatauniqueid' => { 122 => 0xc65d },
	'rawdepth' => { 191 => 0x10 },
	'rawdevartfilter' => { 330 => 0x121 },
	'rawdevautogradation' => { 330 => 0x119 },
	'rawdevcolorspace' => { 329 => 0x108, 330 => 0x109 },
	'rawdevcontrastvalue' => { 329 => 0x106, 330 => 0x105 },
	'rawdeveditstatus' => { 329 => 0x10b },
	'rawdevelopingsoftware' => { 122 => 0xa43a },
	'rawdevelopmentprocess' => { 381 => 0x62 },
	'rawdevengine' => { 329 => 0x109, 330 => 0x10b },
	'rawdevexposurebiasvalue' => { 329 => 0x100, 330 => 0x100 },
	'rawdevgradation' => { 330 => 0x112 },
	'rawdevgraypoint' => { 329 => 0x103, 330 => 0x104 },
	'rawdevmemorycoloremphasis' => { 329 => 0x105, 330 => 0x108 },
	'rawdevnoisereduction' => { 329 => 0x10a, 330 => 0x10a },
	'rawdevpicturemode' => { 330 => 0x10c },
	'rawdevpm_bwfilter' => { 330 => 0x110 },
	'rawdevpmcontrast' => { 330 => 0x10e },
	'rawdevpmnoisefilter' => { 330 => 0x120 },
	'rawdevpmpicturetone' => { 330 => 0x111 },
	'rawdevpmsaturation' => { 330 => 0x10d },
	'rawdevpmsharpness' => { 330 => 0x10f },
	'rawdevsaturation3' => { 330 => 0x113 },
	'rawdevsaturationemphasis' => { 329 => 0x104, 330 => 0x107 },
	'rawdevsettings' => { 329 => 0x10c },
	'rawdevsharpnessvalue' => { 329 => 0x107, 330 => 0x106 },
	'rawdevversion' => { 329 => 0x0, 330 => 0x0 },
	'rawdevwbfineadjustment' => { 329 => 0x102, 330 => 0x103 },
	'rawdevwhitebalance' => { 330 => 0x101 },
	'rawdevwhitebalancevalue' => { 329 => 0x101, 330 => 0x102 },
	'rawfile' => { 122 => 0xfe4c },
	'rawfilename' => { 507 => 'RawFileName', 509 => 'RawFileName' },
	'rawfiletype' => { 446 => 0x2029 },
	'rawformat' => { 351 => 0x2d, 390 => 0x10e },
	'rawimagecenter' => { 239 => 0x99 },
	'rawimagedigest' => { 122 => 0xc71c },
	'rawimagesize' => { 381 => 0x39 },
	'rawinfoversion' => { 331 => 0x0 },
	'rawjpgheight' => { 102 => 0x4 },
	'rawjpgquality' => { 59 => 0x6, 102 => 0x1 },
	'rawjpgsize' => { 59 => 0x7, 102 => 0x2 },
	'rawjpgwidth' => { 102 => 0x3 },
	'rawmeasuredrggb' => { 45 => 0x26a, 47 => 0x280, 49 => 0x194, 50 => [0x1ad,0x26b] },
	'rawrppused' => { 502 => 'rawrppused' },
	'rawtopreviewgain' => { 122 => 0xc7a8 },
	'readouttypeactual' => { 141 => 0x1903 },
	'readouttyperequested' => { 141 => 0x1902 },
	'reardisplay' => { 303 => '12.3', 304 => '6.2' },
	'recdevice' => { 521 => 'RecDevice' },
	'recdeviceattlensdescription' => { 521 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 521 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 521 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 521 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 521 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 528 => 'recipeEndingPage' },
	'recipepagerange' => { 528 => 'recipePageRange' },
	'recipesource' => { 528 => 'recipeSource' },
	'recipestartingpage' => { 528 => 'recipeStartingPage' },
	'recipetitle' => { 528 => 'recipeTitle' },
	'recognizedface1age' => { 339 => 0x20 },
	'recognizedface1name' => { 339 => 0x4 },
	'recognizedface1position' => { 339 => 0x18 },
	'recognizedface2age' => { 339 => 0x50 },
	'recognizedface2name' => { 339 => 0x34 },
	'recognizedface2position' => { 339 => 0x48 },
	'recognizedface3age' => { 339 => 0x80 },
	'recognizedface3name' => { 339 => 0x64 },
	'recognizedface3position' => { 339 => 0x78 },
	'recognizedfaceflags' => { 346 => 0x63 },
	'recommendedexposureindex' => { 122 => 0x8832, 514 => 'RecommendedExposureIndex' },
	'record' => { 121 => 'Record' },
	'recordbasisofrecord' => { 121 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 121 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 121 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 121 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 121 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 121 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 187 => 0x4d },
	'recorddynamicproperties' => { 121 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 100 => 0x1804 },
	'recordinformationwithheld' => { 121 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 406 => "\xa9phg" },
	'recordingformat' => { 413 => 0x1000 },
	'recordingmode' => { 115 => 0x1, 388 => 0x1 },
	'recordinstitutioncode' => { 121 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 121 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 406 => "\xa9lab" },
	'recordlabelurl' => { 406 => "\xa9lal" },
	'recordlocationdata' => { 245 => 0x660, 246 => 0x690, 247 => 0x6f8 },
	'recordmode' => { 36 => 0x9, 116 => 0x3000 },
	'recordownerinstitutioncode' => { 121 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 422 => 0x217 },
	'redbalance' => { 328 => 0x1017, 351 => 0x11, 381 => 0x1c },
	'redcurvelimits' => { 111 => 0x18a },
	'redcurvepoints' => { 110 => 0x2d, 111 => 0x160 },
	'redeyecorrection' => { 300 => 0x0 },
	'redeyeinfo' => { 507 => 'RedEyeInfo', 509 => 'RedEyeInfo' },
	'redeyereduction' => { 187 => 0x41, 433 => 0x6a, 435 => 0x28 },
	'redeyeremoval' => { 346 => 0xb9 },
	'redhsl' => { 106 => 0x20910 },
	'redhue' => { 507 => 'RedHue', 509 => 'RedHue' },
	'redsaturation' => { 507 => 'RedSaturation', 509 => 'RedSaturation' },
	'reductionmatrix1' => { 122 => 0xc625 },
	'reductionmatrix2' => { 122 => 0xc626 },
	'reductionmatrix3' => { 122 => 0xcd3a },
	'reelname' => { 122 => 0xc789, 406 => 'reel' },
	'reference1' => { 519 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 519 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 122 => 0x214, 532 => 'ReferenceBlackWhite' },
	'referencedate' => { 134 => 0x2f },
	'referencenumber' => { 134 => 0x32 },
	'references' => { 160 => 'References' },
	'referenceservice' => { 134 => 0x2d },
	'regionappliedtodimensions' => { 175 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 175 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 175 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 175 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 175 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 175 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 175 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 175 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 175 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 175 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 175 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 175 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 333 => 'RegionConstraints' },
	'regiondescription' => { 175 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 175 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 175 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 175 => 'Regions' },
	'regioninfodateregionsvalid' => { 178 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 178 => 'RegionInfo' },
	'regioninforegions' => { 178 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 175 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 175 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 178 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 175 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 175 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 175 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 521 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 521 => 'RegistryId' },
	'registryitemid' => { 521 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 521 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 158 => 'data' },
	'relatedaudiofilename' => { 158 => '1Name' },
	'relatedaudiofiletype' => { 158 => '0Type' },
	'relatedimagefileformat' => { 122 => 0x1000 },
	'relatedimageheight' => { 122 => 0x1002 },
	'relatedimagewidth' => { 122 => 0x1001 },
	'relatedresourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 122 => 0xa004, 513 => 'RelatedSoundFile' },
	'relatedvideofile' => { 172 => 'data' },
	'relatedvideofilename' => { 172 => '1Name' },
	'relatedvideofiletype' => { 172 => '0Type' },
	'relation' => { 510 => 'relation' },
	'relationshipaccordingto' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 119 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 536 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 536 => 'relativeTimestamp' },
	'relativetimestampscale' => { 536 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 536 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 303 => '17.8', 304 => '18.5', 306 => '18.4', 307 => '18.4', 312 => '33.8', 313 => '17.6', 316 => '18.5', 317 => '18.4' },
	'releasedate' => { 134 => 0x1e, 398 => 'rldt', 502 => 'ReleaseDate', 536 => 'releaseDate' },
	'releasemode' => { 116 => 0x3001, 243 => 0x5c, 276 => 0x184d, 446 => 0xb049 },
	'releasemode2' => { 455 => 0x112c, 456 => [0x112c,0x8], 457 => [0x1108,0x8], 458 => [0x1184,0x8], 459 => [0x1160,0x8], 460 => [0x4,0x1018], 461 => [0x4,0x210], 462 => [0x4,0x210], 463 => [0x4,0x208], 465 => [0x67,0x3f], 466 => [0x6b,0x6d,0x73,0x4b], 467 => [0x6b,0x4b], 468 => 0x1f, 469 => 0x10, 470 => 0x10, 471 => 0x9, 478 => 0x34 },
	'releasemode3' => { 455 => 0x1128, 456 => 0x1128, 457 => 0x1104, 458 => 0x1180, 459 => 0x115c, 460 => 0x1014, 461 => 0x20c, 462 => 0x20c, 463 => 0x204 },
	'releaseready' => { 521 => 'ReleaseReady' },
	'releasesetting' => { 100 => 0x1016 },
	'releasetime' => { 134 => 0x23, 502 => 'ReleaseTime' },
	'remoteonduration' => { 305 => '3.4', 308 => '17.2', 309 => '18.2', 310 => '18.2', 311 => '18.2', 313 => '18.2', 314 => '4.3', 318 => '19.2' },
	'renditionclass' => { 537 => 'RenditionClass' },
	'renditionof' => { 537 => 'RenditionOf' },
	'renditionofalternatepaths' => { 537 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 537 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 537 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 537 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 537 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 537 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 537 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 537 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 537 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 537 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 537 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 537 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 537 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 537 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 537 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 537 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 537 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 537 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 537 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 537 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 537 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 537 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 537 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 537 => 'RenditionParams' },
	'repeatingflashcount' => { 217 => 0xd, 218 => 0xe, 219 => 0xe, 220 => 0xe, 221 => 0xe, 222 => 0xe, 312 => '17.2', 313 => '24.2', 314 => '9.2', 315 => '24.2', 318 => '25.2' },
	'repeatingflashcountbuilt-in' => { 283 => 0x4db },
	'repeatingflashcountexternal' => { 283 => 0x4c3 },
	'repeatingflashoutput' => { 312 => '17.1', 313 => '24.1', 314 => '9.1', 315 => '24.1', 318 => '25.1' },
	'repeatingflashoutputexternal' => { 283 => 0x4c0 },
	'repeatingflashrate' => { 217 => 0xc, 218 => 0xd, 219 => 0xd, 220 => 0xd, 221 => 0xd, 222 => 0xd, 312 => '18.1', 313 => '25.1', 314 => '10.1', 315 => '25.1', 318 => '26.1' },
	'repeatingflashratebuilt-in' => { 283 => 0x4da },
	'repeatingflashrateexternal' => { 283 => 0x4c2 },
	'requirements' => { 406 => "\xa9req" },
	'requires' => { 505 => 'requires' },
	'resampleparams' => { 536 => 'resampleParams' },
	'resampleparamsquality' => { 536 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 141 => 0xe50 },
	'resamplingkerneldenominators067' => { 141 => 0xe4f },
	'resamplingkerneldenominators100' => { 141 => 0xe51 },
	'resaved' => { 422 => 0x21e },
	'resetblacksegrows' => { 141 => 0x181a },
	'resolution' => { 165 => 'Resolution' },
	'resolutionmode' => { 423 => [0x87,0x4] },
	'resolutionunit' => { 122 => 0x128, 137 => 0x2, 532 => 'ResolutionUnit' },
	'resourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 121 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 121 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 87 => 0x612 },
	'restrictions' => { 529 => 'restrictions' },
	'retouchareafeather' => { 507 => [\'RetouchAreas','RetouchAreasFeather'], 509 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 507 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 509 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 507 => [\'RetouchAreas','RetouchAreasMasksAngle'], 509 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 507 => [\'RetouchAreas','RetouchAreasMasksBottom'], 509 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 507 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 509 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 507 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 509 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 507 => [\'RetouchAreas','RetouchAreasMasksDabs'], 509 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 507 => [\'RetouchAreas','RetouchAreasMasksFeather'], 509 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 507 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 509 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 507 => [\'RetouchAreas','RetouchAreasMasksFlow'], 509 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 507 => [\'RetouchAreas','RetouchAreasMasksFullX'], 509 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 507 => [\'RetouchAreas','RetouchAreasMasksFullY'], 509 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 507 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 509 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 507 => [\'RetouchAreas','RetouchAreasMasksLeft'], 509 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasks'], 509 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 507 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 509 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 507 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 509 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 507 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 509 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 507 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 509 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 507 => [\'RetouchAreas','RetouchAreasMasksRadius'], 509 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 509 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 507 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 509 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 507 => [\'RetouchAreas','RetouchAreasMasksRight'], 509 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 507 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 509 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 507 => [\'RetouchAreas','RetouchAreasMasks'], 509 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 507 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 509 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 507 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 509 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 507 => [\'RetouchAreas','RetouchAreasMasksTop'], 509 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 507 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 509 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 507 => [\'RetouchAreas','RetouchAreasMasksVersion'], 509 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 507 => [\'RetouchAreas','RetouchAreasMasksWhat'], 509 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 507 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 509 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 507 => [\'RetouchAreas','RetouchAreasMasksX'], 509 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 507 => [\'RetouchAreas','RetouchAreasMasksY'], 509 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 507 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 509 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 507 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 509 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 507 => [\'RetouchAreas','RetouchAreasMethod'], 509 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 507 => [\'RetouchAreas','RetouchAreasOffsetY'], 509 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 507 => [\'RetouchAreas','RetouchAreasOpacity'], 509 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 507 => 'RetouchAreas', 509 => 'RetouchAreas' },
	'retouchareaseed' => { 507 => [\'RetouchAreas','RetouchAreasSeed'], 509 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 507 => [\'RetouchAreas','RetouchAreasSourceState'], 509 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 507 => [\'RetouchAreas','RetouchAreasSourceX'], 509 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 507 => [\'RetouchAreas','RetouchAreasSpotType'], 509 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 239 => 0x9e },
	'retouchinfo' => { 507 => 'RetouchInfo', 509 => 'RetouchInfo' },
	'retouchnefprocessing' => { 260 => 0x5 },
	'retractlensonpoweroff' => { 87 => 0x814 },
	'reuse' => { 333 => 'Reuse' },
	'reuseallowed' => { 539 => 'ReuseAllowed' },
	'reuseprohibited' => { 529 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 310 => '5.2' },
	'reversefocusring' => { 319 => 0x163, 320 => 0x163, 321 => 0x17b },
	'reverseindicators' => { 303 => '12.1', 304 => '6.1', 306 => '6.1', 307 => '6.1', 308 => '4.3', 309 => '5.2', 310 => '5.4', 312 => '33.5', 313 => '5.1', 316 => '6.1', 317 => '6.1', 318 => '6.2', 319 => 0xc1, 320 => 0xc1, 321 => 0xc1 },
	'reverseshutterspeedaperture' => { 310 => '5.3' },
	'revision' => { 511 => 'revision' },
	'rflensmffocusringsensitivity' => { 87 => 0x714 },
	'rflenstype' => { 59 => 0x3d },
	'rgbcurvelimits' => { 111 => 0x238 },
	'rgbcurvepoints' => { 110 => 0x7, 111 => 0x20e },
	'rgbtables' => { 122 => 0xcd3b },
	'richtextcomment' => { 516 => 'RichTextComment' },
	'ricohdate' => { 412 => 0x6 },
	'ricohimageheight' => { 412 => 0x2 },
	'ricohimagewidth' => { 412 => 0x0 },
	'rightalbedo' => { 498 => 'RightAlbedo' },
	'rightascension' => { 168 => 'RightAscension' },
	'rights' => { 510 => 'rights' },
	'rightsagent' => { 529 => 'rightsAgent' },
	'rightsowner' => { 529 => 'rightsOwner' },
	'roll' => { 118 => 0x8, 406 => ['roll',"\xa9frl"] },
	'rollangle' => { 130 => 0x144d, 252 => 0x0, 323 => 0x903, 346 => 0x90, 380 => 0x1, 418 => 0x2 },
	'romoperationmode' => { 100 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 99 => 0x3, 106 => 0x10002, 111 => 0x26e, 117 => 'QuickTime-Rotation', 126 => 0x4, 168 => 'Rotation', 185 => [0x65,0x50], 186 => 0x46, 187 => 0x5a, 190 => 0x10, 261 => 0x1a, 276 => 0x3693, 282 => '590.1', 296 => 0x76a43207, 346 => 0x30, 362 => '17.2', 392 => 0xd8, 399 => 'irot', 433 => 0x3f, 434 => 0x3f, 444 => 0x10 },
	'routedto' => { 515 => 'RoutedTo' },
	'routing' => { 397 => 'Routing' },
	'routingdestinations' => { 497 => 'RoutingDestinations' },
	'routingexclusions' => { 497 => 'RoutingExclusions' },
	'routingnotes' => { 515 => 'RoutingNotes' },
	'rowsperstrip' => { 122 => 0x116 },
	'rpp' => { 502 => 'rpp' },
	'rtkflag' => { 119 => 'RtkFlag' },
	'rtkstdhgt' => { 119 => 'RtkStdHgt' },
	'rtkstdlat' => { 119 => 'RtkStdLat' },
	'rtkstdlon' => { 119 => 'RtkStdLon' },
	'safetyshift' => { 87 => 0x108 },
	'safetyshiftinavortv' => { 85 => 0x10, 86 => 0x10, 88 => 0xf, 89 => 0x10, 92 => 0x10 },
	'sameexposurefornewaperture' => { 87 => 0x112 },
	'samplebits' => { 158 => 'SampleBits' },
	'samplepagerange' => { 526 => 'samplePageRange' },
	'samplerate' => { 158 => 'SampleRate' },
	'samplesperpixel' => { 122 => 0x115, 351 => 0x8, 532 => 'SamplesPerPixel' },
	'samplestructure' => { 136 => 0x5a },
	'samsungmodelid' => { 420 => 0x3 },
	'sanyoquality' => { 422 => 0x201 },
	'sanyothumbnail' => { 422 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 36 => 0xe, 53 => 0x1, 65 => 0x7, 115 => 0xd, 116 => [0x3013,0x1f], 122 => [0xa409,0xfe55], 130 => 0x1003, 159 => 'Saturation', 184 => 0x1f, 185 => 0x32, 186 => 0x28, 187 => 0x1a, 192 => 0x1, 239 => 0xaa, 254 => 0x35, 255 => 0x3b, 256 => 0x43, 346 => 0x40, 348 => 0x300d, 381 => 0x1f, 388 => 0xd, 407 => 0x27, 409 => 0x58, 412 => 0x28, 413 => 0x1013, 423 => 0x10, 433 => 0x1e, 434 => 0x1b, 446 => 0x2005, 507 => 'Saturation', 509 => 'Saturation', 513 => 'Saturation' },
	'saturationadj' => { 106 => 0x20901, 111 => 0x116, 239 => 0x94, 295 => 0x1, 299 => 0x2e, 483 => 0x8016 },
	'saturationadjustmentaqua' => { 507 => 'SaturationAdjustmentAqua', 509 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 507 => 'SaturationAdjustmentBlue', 509 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 507 => 'SaturationAdjustmentGreen', 509 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 507 => 'SaturationAdjustmentMagenta', 509 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 507 => 'SaturationAdjustmentOrange', 509 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 507 => 'SaturationAdjustmentPurple', 509 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 507 => 'SaturationAdjustmentRed', 509 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 507 => 'SaturationAdjustmentYellow', 509 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 73 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 72 => 0x68, 73 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 72 => 0x38, 73 => 0x38 },
	'saturationmonochrome' => { 72 => 0x80, 73 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 72 => 0x50, 73 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 72 => 0x20, 73 => 0x20 },
	'saturationsetting' => { 331 => 0x1010, 435 => 0x11, 451 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 72 => 0x8, 73 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 72 => 0x98, 73 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 72 => 0xb0, 73 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 72 => 0xc8, 73 => 0xe0 },
	'saveid' => { 537 => 'SaveID' },
	'sbaanalysiscomplete' => { 141 => 0xc35 },
	'sbablack' => { 141 => 0xc25 },
	'sbagmoffset' => { 141 => 0xc4a },
	'sbagray' => { 141 => 0xc26 },
	'sbagreenmagentabal' => { 141 => 0xc33 },
	'sbahighgray' => { 141 => 0xc46 },
	'sbailloffset' => { 141 => 0xc49 },
	'sbailluminantbal' => { 141 => 0xc34 },
	'sbalowgray' => { 141 => 0xc47 },
	'sbaneutralbal' => { 141 => 0xc32 },
	'sbawhite' => { 141 => 0xc27 },
	'scaletype' => { 536 => 'scaleType' },
	'scanimageenhancer' => { 262 => 0x60 },
	'scanningdirection' => { 136 => 0x64 },
	'scene' => { 406 => 'scen', 520 => 'Scene', 536 => 'scene' },
	'scenearea' => { 326 => 0x211, 328 => 0x1031 },
	'sceneassist' => { 239 => 0x9c },
	'scenecapturetype' => { 122 => 0xa406, 513 => 'SceneCaptureType' },
	'scenedetect' => { 326 => 0x210, 328 => 0x1030 },
	'scenedetectdata' => { 326 => 0x212, 328 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 145 => 0xfa02, 189 => 0x100, 239 => 0x8f, 323 => 0x509, 328 => 0x403, 346 => 0x8001, 355 => 0xf, 446 => 0xb023 },
	'scenemodeused' => { 147 => [0x6002,0xf002] },
	'scenerecognition' => { 130 => 0x1425 },
	'scenereferred' => { 517 => 'scene_referred' },
	'sceneselect' => { 422 => 0x21f },
	'scenetype' => { 122 => 0xa301, 513 => 'SceneType' },
	'screentips' => { 303 => '12.7', 304 => '5.3', 312 => '13.1', 313 => '4.4', 316 => '5.4', 318 => '5.1' },
	'scriptversion' => { 141 => 0x1770 },
	'sdrblend' => { 507 => 'SDRBlend', 509 => 'SDRBlend' },
	'sdrbrightness' => { 507 => 'SDRBrightness', 509 => 'SDRBrightness' },
	'sdrcontrast' => { 507 => 'SDRContrast', 509 => 'SDRContrast' },
	'sdrhighlights' => { 507 => 'SDRHighlights', 509 => 'SDRHighlights' },
	'sdrshadows' => { 507 => 'SDRShadows', 509 => 'SDRShadows' },
	'sdrwhites' => { 507 => 'SDRWhites', 509 => 'SDRWhites' },
	'season' => { 521 => 'Season', 525 => 'season' },
	'seasonidentifier' => { 521 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 521 => [\'Season','SeasonName'] },
	'seasonnumber' => { 521 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 497 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 244 => 0x240, 245 => 0x22c, 246 => 0x240, 247 => 0x240, 265 => 0x13c, 276 => 0x1d0 },
	'section' => { 526 => 'section' },
	'securityclassification' => { 122 => 0x9212 },
	'selectableafpoint' => { 87 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 87 => 0x512 },
	'selfdata' => { 119 => 'SelfData' },
	'selftimer' => { 36 => 0x2, 346 => 0x2e, 422 => 0x214, 455 => 0x1134, 456 => 0x1134, 457 => 0x1110, 458 => 0x118c, 459 => 0x1168, 460 => 0x1020, 461 => 0x218, 462 => 0x218, 463 => 0x210 },
	'selftimer2' => { 79 => 0x1d },
	'selftimerinterval' => { 313 => '19.2' },
	'selftimermode' => { 122 => 0x882b },
	'selftimershotcount' => { 304 => '20.2', 306 => '20.3', 307 => '20.3', 308 => '18.2', 309 => '19.2', 310 => '19.2', 311 => '19.3', 313 => '19.3', 316 => '20.3', 317 => '20.3', 318 => '20.2', 319 => 0x2d, 320 => 0x2d, 321 => 0x2d },
	'selftimershotinterval' => { 304 => '20.3', 306 => '20.2', 307 => '20.2', 311 => '19.2', 316 => '20.2', 317 => '20.2', 319 => 0x31, 320 => 0x31, 321 => 0x31 },
	'selftimertime' => { 100 => 0x1806, 187 => 0x1f, 303 => '18.1', 304 => '20.1', 305 => '3.3', 306 => '20.1', 307 => '20.1', 308 => '18.1', 309 => '19.1', 310 => '19.1', 311 => '19.1', 312 => '7.2', 313 => '19.1', 314 => '3.3', 316 => '20.1', 317 => '20.1', 318 => '20.1', 319 => 0x2b, 320 => 0x2b, 321 => 0x2b },
	'sellingagency' => { 526 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 122 => 0x8546 },
	'sensingmethod' => { 122 => 0xa217, 513 => 'SensingMethod' },
	'sensitivityadjust' => { 381 => 0x40 },
	'sensitivitysteps' => { 362 => ['14.3','17.4'], 364 => 0x1 },
	'sensitivitytype' => { 122 => 0x8830, 514 => 'SensitivityType' },
	'sensor' => { 194 => 0x665e },
	'sensorarea' => { 328 => 0x400 },
	'sensorareas' => { 420 => 0xa010 },
	'sensorbitdepth' => { 348 => 0x312d },
	'sensorbluelevel' => { 76 => 0x5 },
	'sensorcalibration' => { 327 => 0x805 },
	'sensorcleaning' => { 93 => 0xd },
	'sensorfullheight' => { 140 => 0xf904 },
	'sensorfullwidth' => { 140 => 0xf903 },
	'sensorheight' => { 140 => 0xf901, 145 => 0xfa21, 191 => 0x8, 348 => 0x312c, 390 => 0x109, 413 => 0x1602 },
	'sensorimageheight' => { 141 => 0x3ee },
	'sensorimagewidth' => { 141 => 0x3ed },
	'sensorleftborder' => { 141 => 0x3eb },
	'sensorleftmargin' => { 390 => 0x10a },
	'sensorpixelsize' => { 239 => 0x9a },
	'sensorredlevel' => { 76 => 0x4 },
	'sensorserialnumber' => { 141 => 0x9ce },
	'sensorshield' => { 244 => 0x76b, 245 => 0x66d, 246 => 0x69d, 247 => 0x705 },
	'sensorsize' => { 159 => 'SensorSize', 381 => 0x35 },
	'sensortemperature' => { 326 => 0x1500, 328 => 0x1007, 386 => 0xc, 390 => 0x210, 423 => [0x39,0x55] },
	'sensortemperature2' => { 386 => 0xe, 390 => 0x211 },
	'sensortopborder' => { 141 => 0x3ec },
	'sensortopmargin' => { 390 => 0x10b },
	'sensortype' => { 346 => 0xca },
	'sensorwidth' => { 140 => 0xf900, 145 => 0xfa20, 191 => 0xa, 348 => 0x312b, 390 => 0x108, 413 => 0x1601 },
	'sequence' => { 407 => 0x7, 408 => 0x35, 409 => 0x36 },
	'sequencefilenumber' => { 456 => 0x4, 457 => 0x4, 458 => 0x4, 459 => 0x4, 469 => 0xc, 470 => 0xc, 471 => 0x1a },
	'sequenceimagenumber' => { 456 => 0x0, 457 => 0x0, 458 => 0x0, 459 => 0x0, 469 => 0x8, 470 => 0x8, 471 => 0x12, 478 => 0x24 },
	'sequencelength' => { 469 => 0x22, 470 => 0x1e, 471 => [0x16,0x1e] },
	'sequencename' => { 525 => 'sequenceName' },
	'sequencenumber' => { 79 => 0x9, 116 => 0x301c, 130 => 0x1101, 143 => 0x1d, 283 => 0x51c, 346 => 0x2b, 435 => [0x10c,0x30c], 446 => 0xb04a, 525 => 'sequenceNumber' },
	'sequenceshotinterval' => { 422 => 0x224 },
	'sequencetotalnumber' => { 525 => 'sequenceTotalNumber' },
	'sequentialshot' => { 422 => 0x20e },
	'serialnumber' => { 66 => 0xc, 100 => 0x180b, 122 => [0xa431,0xfde9], 140 => 0xfa04, 142 => 0xfa00, 144 => 0xc354, 145 => 0xfa19, 156 => 0x0, 159 => 'SerialNumber', 194 => 0x5501, 239 => [0xa0,0x1d], 324 => 0x101, 328 => [0x404,0x101a], 341 => 0x303, 343 => 0x305, 348 => 0x3103, 381 => 0x229, 390 => 0x102, 391 => 0x407, 406 => ['SNum','slno'], 407 => 0x15, 408 => 0x4b, 409 => 0x7e, 413 => 0x5, 420 => 0xa002, 423 => 0x2, 446 => 0x2031, 504 => 'SerialNumber', 514 => 'BodySerialNumber' },
	'serialnumberformat' => { 66 => 0x15, 100 => 0x183b },
	'serialnumberhash' => { 406 => 'CAME' },
	'series' => { 521 => 'Series' },
	'seriesdatetime' => { 485 => 'SeriesDateTime' },
	'seriesdescription' => { 485 => 'SeriesDescription' },
	'seriesidentifier' => { 521 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 485 => 'SeriesModality' },
	'seriesname' => { 521 => [\'Series','SeriesName'] },
	'seriesnumber' => { 485 => 'SeriesNumber', 526 => 'seriesNumber' },
	'seriestitle' => { 526 => 'seriesTitle' },
	'serviceidentifier' => { 135 => 0x1e },
	'servingsize' => { 528 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 90 => 0x0, 91 => 0x0 },
	'setbuttonwhenshooting' => { 85 => 0x1, 87 => 0x704, 93 => 0xc },
	'setclockfromlocationdata' => { 245 => 0x61d, 246 => 0x64d, 247 => 0x6b5 },
	'setfunctionwhenshooting' => { 88 => 0x0, 89 => 0x1, 92 => 0x1 },
	'setting' => { 525 => 'setting' },
	'shadingcompensation' => { 323 => 0x50c, 346 => 0x8a },
	'shadingcompensation2' => { 327 => 0x1012 },
	'shadow' => { 423 => 0xe },
	'shadowadj' => { 106 => 0x2030b },
	'shadowcorrection' => { 381 => 0x79 },
	'shadowprotection' => { 295 => 0x0 },
	'shadows' => { 122 => 0xfe52, 446 => 0x2032, 501 => 'Shadows', 507 => 'Shadows', 509 => 'Shadows' },
	'shadows2012' => { 507 => 'Shadows2012', 509 => 'Shadows2012' },
	'shadowsadj' => { 483 => 0x901a },
	'shadowscale' => { 122 => 0xc633 },
	'shadowtint' => { 507 => 'ShadowTint', 509 => 'ShadowTint' },
	'shadowtone' => { 130 => 0x1040 },
	'shakereduction' => { 383 => 0x1, 384 => 0x1 },
	'shareduserrating' => { 182 => 'WM/SharedUserRating' },
	'sharpendetail' => { 507 => 'SharpenDetail', 509 => 'SharpenDetail' },
	'sharpenedgemasking' => { 507 => 'SharpenEdgeMasking', 509 => 'SharpenEdgeMasking' },
	'sharpening' => { 348 => 0x300b },
	'sharpeningadj' => { 299 => 0x2b },
	'sharpeningkernel' => { 141 => 0x92f },
	'sharpenradius' => { 507 => 'SharpenRadius', 509 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 36 => 0xf, 65 => 0x6, 76 => 0x2, 115 => 0xb, 116 => [0x3011,0x21], 122 => [0xa40a,0xfe56], 130 => 0x1001, 143 => 0x6b, 152 => 0x37, 159 => 'Sharpness', 184 => 0x21, 185 => 0x30, 186 => 0x26, 187 => 0x18, 192 => 0x3, 239 => 0x6, 254 => 0x32, 255 => 0x33, 256 => 0x39, 328 => 0x100f, 346 => 0x41, 381 => 0x21, 388 => 0xb, 407 => 0x26, 409 => 0x56, 412 => 0x22, 413 => [0x1003,0x1014], 423 => 0x11, 433 => 0x1c, 434 => 0x19, 446 => 0x2006, 478 => 0x52, 507 => 'Sharpness', 509 => 'Sharpness', 513 => 'Sharpness' },
	'sharpnessadj' => { 106 => 0x20310, 111 => 0x25a, 483 => 0x801a },
	'sharpnessadjon' => { 106 => '0x20310.0' },
	'sharpnessauto' => { 73 => 0x94 },
	'sharpnessfactor' => { 328 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 72 => 0x64, 73 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 76 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 72 => 0x34, 73 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 72 => 0x7c, 73 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 72 => 0x4c, 73 => 0x4c },
	'sharpnessovershoot' => { 483 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 72 => 0x1c, 73 => 0x1c },
	'sharpnessrange' => { 446 => 0x2035 },
	'sharpnesssetting' => { 323 => 0x506, 331 => 0x1013, 435 => 0x12, 451 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 72 => 0x4, 73 => 0x4 },
	'sharpnessstrength' => { 106 => 0x20311 },
	'sharpnessthreshold' => { 483 => 0x801d },
	'sharpnessundershoot' => { 483 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 72 => 0x94, 73 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 72 => 0xac, 73 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 72 => 0xc4, 73 => 0xdc },
	'shiftcols' => { 141 => 0xc70 },
	'shootid' => { 525 => 'shootID' },
	'shootingdistance' => { 106 => 0x20701 },
	'shootinginfodisplay' => { 303 => '13.2', 304 => '5.1', 312 => '10.2', 313 => '4.1', 316 => '5.1', 318 => '5.3' },
	'shootinginfomonitorofftime' => { 303 => '26.2', 304 => '22.2', 306 => '22.2', 307 => '22.2', 311 => '21.2', 312 => '9.1', 313 => '21.2', 316 => '22.2', 317 => '22.2', 318 => '22.2', 319 => 0x37, 320 => 0x37, 321 => 0x37 },
	'shootingmode' => { 159 => 'ShootingMode', 239 => 0x89, 346 => 0x1f },
	'shootingmodesetting' => { 305 => '5.1' },
	'shortdescription' => { 511 => 'shortdescription' },
	'shortdocumentid' => { 134 => 0xba },
	'shortname' => { 507 => 'ShortName', 509 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 87 => 0x80d },
	'shorttitle' => { 398 => '@sti' },
	'shotdate' => { 536 => 'shotDate' },
	'shotday' => { 536 => 'shotDay' },
	'shotlocation' => { 536 => 'shotLocation' },
	'shotlogdata' => { 490 => 'shot_log_data' },
	'shotname' => { 406 => 'shot', 536 => 'shotName' },
	'shotnumber' => { 536 => 'shotNumber' },
	'shotnumbersincepowerup' => { 450 => 0x44e, 469 => 0x1a, 470 => 0x16, 471 => 0xa },
	'shotnumbersincepowerup2' => { 435 => 0x200 },
	'shotsize' => { 536 => 'shotSize' },
	'shotsperinterval' => { 228 => 0x180, 243 => 0xb4, 244 => 0xcc, 245 => 0xc0, 246 => 0xd0, 247 => 0xd0 },
	'showmovement' => { 398 => 'shwm' },
	'shownevent' => { 521 => 'EventExt' },
	'showneventidentifier' => { 521 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 521 => [\'EventExt','EventExtName'] },
	'shutter' => { 465 => 0x20, 466 => 0x26, 467 => 0x26 },
	'shutter-aelock' => { 85 => 0x4, 87 => 0x701, 88 => 0x3, 89 => 0x4, 90 => 0x3, 91 => 0x3, 92 => 0x4, 93 => 0x2 },
	'shutteraelbutton' => { 86 => 0x4 },
	'shutterbuttonafonbutton' => { 87 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => 0x293, 33 => 0xaf1, 59 => 0x1, 239 => 0xa7, 267 => [0x6a,0x157,0x24d], 268 => 0x286, 269 => 0x279, 270 => 0x284, 271 => 0x242, 272 => 0x280, 273 => 0x276, 274 => [0x27d,0x27f], 275 => 0x246, 277 => 0x2d6, 278 => 0x321, 279 => 0xbd8, 280 => 0x287, 281 => 0x320, 282 => 0x24a, 283 => 0x5fb, 284 => 0x2d5, 381 => 0x5d, 444 => 0x846, 449 => [0x125,0x14a], 465 => 0x32, 466 => 0x3a, 467 => 0x3a, 468 => 0xa },
	'shuttercount2' => { 465 => 0x4c, 466 => [0x50,0x52,0x58], 467 => 0x50 },
	'shuttercount3' => { 465 => [0x1a0,0x1aa,0x1bd], 466 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 85 => 0xf, 86 => 0xf, 87 => 0x305, 88 => 0xe, 89 => 0xf, 90 => 0x8, 91 => 0x8, 92 => 0xf, 93 => 0x8 },
	'shuttermode' => { 59 => 0x17, 143 => 0x1b, 239 => 0x34 },
	'shutterreleasebuttonae-l' => { 303 => '17.7', 304 => '18.4', 306 => '78.4', 307 => '78.4', 308 => '16.1', 309 => '17.1', 310 => '17.1', 311 => '17.1', 312 => '7.1', 313 => '17.5', 316 => '18.4', 317 => '78.4', 318 => '18.2', 319 => 0x29, 320 => 0x29, 321 => 0x29 },
	'shutterreleasemethod' => { 100 => 0x1010 },
	'shutterreleasenocfcard' => { 85 => 0x2, 86 => 0x2, 93 => 0xf },
	'shutterreleasetiming' => { 100 => 0x1011 },
	'shutterreleasewithoutlens' => { 87 => 0x711 },
	'shutterspeedlock' => { 304 => '38.1', 306 => '38.1', 307 => '38.1', 316 => '38.1', 317 => '38.1', 319 => 0xb7, 320 => 0xb7, 321 => 0xb7 },
	'shutterspeedrange' => { 87 => 0x10c },
	'shutterspeedsetting' => { 187 => 0x6, 433 => 0x2f, 434 => 0x28, 435 => 0x0 },
	'shutterspeedvalue' => { 96 => 0x1, 122 => 0x9201, 328 => 0x1000, 390 => 0x400, 513 => 'ShutterSpeedValue' },
	'shuttertype' => { 130 => 0x1050, 346 => 0x9f, 381 => 0x87, 471 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 524 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 141 => 0xe0d },
	'sigmascalingfactorcamera' => { 141 => 0xe0c },
	'sigmascalingfactorlowres' => { 141 => 0xe0b },
	'sigmasizetable' => { 141 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 239 => 0xbf },
	'similarityindex' => { 134 => 0xe4 },
	'singleframebracketing' => { 187 => 0x21 },
	'skilllevel' => { 528 => 'skillLevel' },
	'skintonecorrection' => { 381 => 0x95 },
	'skiplinetime' => { 141 => 0x184e },
	'slaveflashmeteringsegments' => { 381 => 0x20b },
	'slideshowname' => { 525 => 'slideshowName' },
	'slideshownumber' => { 525 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 525 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 244 => 0x24a, 247 => 0x24a },
	'slowshutter' => { 79 => 0x8 },
	'slowsync' => { 130 => 0x1030 },
	'smartalbumcolor' => { 420 => 0x20 },
	'smartrange' => { 420 => 0xa012 },
	'smileshutter' => { 435 => 0x31 },
	'smileshuttermode' => { 435 => 0x27 },
	'smoothness' => { 122 => 0xfe57, 507 => 'Smoothness', 509 => 'Smoothness' },
	'snapshot' => { 521 => 'SnapshotLink' },
	'snapshotformat' => { 521 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 521 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 521 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 521 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 521 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 502 => 'Snapshots' },
	'snapshotusedvideoframe' => { 521 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 521 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 521 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 521 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 521 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 446 => 0x200f },
	'software' => { 122 => 0x131, 160 => 'Software', 336 => 'Software', 390 => 0x203, 400 => 'software', 423 => 0x18, 492 => 'Software', 532 => 'Software' },
	'softwareversion' => { 406 => ['@swr',"\xa9swr"], 422 => 0x207 },
	'soloist' => { 398 => "\xa9sol" },
	'songwriter' => { 406 => "\xa9swf" },
	'songwriterkeywords' => { 406 => "\xa9swk" },
	'sonycropsize' => { 122 => 0x74c8 },
	'sonycroptopleft' => { 122 => 0x74c7 },
	'sonydatetime' => { 454 => 0x6, 456 => 0x1b6, 457 => 0x210, 458 => 0x1fe, 459 => 0x22c },
	'sonydatetime2' => { 465 => 0x51 },
	'sonyexposuretime' => { 465 => 0x3a, 466 => 0x46, 467 => [0x66,0x46], 468 => 0x1a },
	'sonyexposuretime2' => { 478 => 0xe },
	'sonyfnumber' => { 465 => 0x3c, 466 => 0x48, 467 => [0x68,0x48], 468 => 0x1c, 478 => 0x14 },
	'sonyimageheight' => { 454 => 0x1a, 469 => 0x44, 470 => 0x3f },
	'sonyimageheightmax' => { 478 => 0x40 },
	'sonyimagesize' => { 187 => 0x3b, 433 => 0x54, 434 => 0x54, 435 => 0x9 },
	'sonyimagewidth' => { 454 => 0x1c },
	'sonyimagewidthmax' => { 478 => 0x3e },
	'sonyiso' => { 456 => 0x1218, 457 => 0x11f4, 458 => 0x1270, 459 => [0x1254,0x1258,0x1280], 460 => 0x113c, 461 => 0x344, 462 => 0x346, 463 => 0x320, 478 => 0x4 },
	'sonymaxaperture' => { 465 => 0x0, 466 => 0x0 },
	'sonymaxaperturevalue' => { 478 => 0x16 },
	'sonyminaperture' => { 465 => 0x1, 466 => 0x1 },
	'sonymodelid' => { 446 => 0xb001 },
	'sonyquality' => { 187 => 0x3c },
	'sonyrawimagesize' => { 122 => 0x7038 },
	'sonytimeminsec' => { 466 => 0x61 },
	'sortalbum' => { 398 => 'soal' },
	'sortalbumartist' => { 398 => 'soaa' },
	'sortartist' => { 398 => 'soar' },
	'sortcomposer' => { 398 => 'soco' },
	'sortname' => { 398 => 'sonm', 507 => 'SortName', 509 => 'SortName' },
	'sortshow' => { 398 => 'sosn' },
	'soundengineer' => { 398 => "\xa9sne" },
	'source' => { 134 => 0x73, 336 => 'Source', 510 => 'source', 511 => 'source', 524 => 'Source' },
	'sourcecount' => { 496 => 'SourceCount' },
	'sourcecredits' => { 406 => "\xa9src" },
	'sourcedirectoryindex' => { 368 => 0x0 },
	'sourcefileindex' => { 368 => 0x2 },
	'sourcephotoscount' => { 495 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 141 => 0x1390 },
	'spatialfrequencyresponse' => { 513 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 513 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 513 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 513 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 513 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 536 => 'speakerPlacement' },
	'specialeffectlevel' => { 116 => 0x3030 },
	'specialeffectmode' => { 116 => 0x2076 },
	'specialeffectsetting' => { 116 => 0x3031 },
	'specialinstructions' => { 134 => 0x28 },
	'specialmode' => { 328 => 0x200, 422 => 0x200 },
	'specialoccasion' => { 528 => 'specialOccasion' },
	'specialtypeid' => { 490 => 'SpecialTypeID' },
	'spectralsensitivity' => { 122 => 0x8824, 513 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => 0x32b, 44 => 0x281, 47 => [0x2b9,0x2d0,0x2d4], 48 => [0x56a,0x296], 49 => 0x1e4, 50 => [0x1fd,0x2dd], 51 => [0x231,0x30f], 52 => 0x31d },
	'speedx' => { 118 => 0x3, 406 => "\xa9xsp" },
	'speedy' => { 118 => 0x4, 406 => "\xa9ysp" },
	'speedz' => { 118 => 0x5, 406 => "\xa9zsp" },
	'spherical' => { 496 => 'Spherical' },
	'sphericalvideoxml' => { 123 => 'SphericalVideoXML' },
	'splitcolumn' => { 390 => 0x222 },
	'splittoningbalance' => { 507 => 'SplitToningBalance', 509 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 507 => 'SplitToningHighlightHue', 509 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 507 => 'SplitToningHighlightSaturation', 509 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 507 => 'SplitToningShadowHue', 509 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 507 => 'SplitToningShadowSaturation', 509 => 'SplitToningShadowSaturation' },
	'sport' => { 526 => 'sport' },
	'spotfocuspointx' => { 184 => 0x2d },
	'spotfocuspointy' => { 184 => 0x2e },
	'spotmeteringmode' => { 36 => 0x27 },
	'spotmeterlinktoafpoint' => { 87 => 0x107 },
	'sractive' => { 362 => '17.1' },
	'srawquality' => { 36 => 0x2e },
	'srfocallength' => { 383 => 0x3 },
	'srgbrendering' => { 334 => 'sRGB' },
	'srhalfpresstime' => { 383 => 0x2 },
	'srresult' => { 383 => 0x0, 384 => 0x0 },
	'stackedimage' => { 323 => 0x804 },
	'standardmatrixcustom' => { 141 => 0x7d4 },
	'standardmatrixdaylight' => { 141 => 0x7d0 },
	'standardmatrixflash' => { 141 => 0x7d3 },
	'standardmatrixfluorescent' => { 141 => 0x7d2 },
	'standardmatrixtungsten' => { 141 => 0x7d1 },
	'standardoutputhighlightpoint' => { 112 => 0x14 },
	'standardoutputsensitivity' => { 122 => 0x8831, 514 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 112 => 0x15 },
	'standardrawcolortone' => { 112 => 0xd },
	'standardrawcontrast' => { 112 => 0xf },
	'standardrawhighlight' => { 112 => 0x75 },
	'standardrawhighlightpoint' => { 112 => 0x12 },
	'standardrawlinear' => { 112 => 0x10 },
	'standardrawsaturation' => { 112 => 0xe },
	'standardrawshadow' => { 112 => 0x7e },
	'standardrawshadowpoint' => { 112 => 0x13 },
	'standardrawsharpness' => { 112 => 0x11 },
	'standardunsharpmaskfineness' => { 112 => 0x94 },
	'standardunsharpmaskstrength' => { 112 => 0x92 },
	'standardunsharpmaskthreshold' => { 112 => 0x96 },
	'standardwhitecustom' => { 141 => 0x838 },
	'standardwhitedaylight' => { 141 => 0x834 },
	'standardwhiteflash' => { 141 => 0x837 },
	'standardwhitefluorescent' => { 141 => 0x836 },
	'standardwhitetungsten' => { 141 => 0x835 },
	'standbytimer' => { 304 => '19.1', 306 => '19.1', 307 => '19.1', 310 => '18.1', 311 => '18.1', 316 => '19.1', 317 => '19.1' },
	'starlightview' => { 319 => 0x249, 320 => 0x249, 321 => 0x261 },
	'startingpage' => { 526 => 'startingPage' },
	'startmovieshooting' => { 87 => 0x70d },
	'starttimecode' => { 406 => "\xa9TIM", 536 => 'startTimecode' },
	'starttimecodetimeformat' => { 536 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 536 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 536 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 406 => "\xa9TSZ", 536 => 'startTimeSampleSize' },
	'starttimescale' => { 406 => "\xa9TSC", 536 => 'startTimeScale' },
	'state' => { 164 => 'State', 346 => 0x6b, 524 => 'State' },
	'status' => { 488 => 'Status', 500 => 'Status' },
	'stereomode' => { 496 => 'StereoMode' },
	'stitched' => { 496 => 'Stitched' },
	'stitchingsoftware' => { 495 => 'StitchingSoftware', 496 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 455 => 0x113e, 456 => 0x113e, 457 => 0x111a, 458 => 0x1196, 459 => 0x1172, 460 => 0x102a, 461 => 0x222, 462 => 0x222, 463 => 0x217, 478 => 0xa },
	'storagemethod' => { 191 => 0x12 },
	'storebyorientation' => { 304 => '46.3', 306 => '47.3', 307 => '47.3', 316 => '47.3', 317 => '47.3', 319 => 0xd, 320 => 0xd, 321 => 0xd },
	'storedescription' => { 398 => 'sdes' },
	'storylineidentifier' => { 521 => 'StorylineIdentifier' },
	'straightenangle' => { 296 => 0x2fc08431 },
	'streamready' => { 521 => 'StreamReady' },
	'streamtype' => { 179 => 'StreamType' },
	'stretchmode' => { 536 => 'stretchMode' },
	'studydatetime' => { 485 => 'StudyDateTime' },
	'studydescription' => { 485 => 'StudyDescription' },
	'studyid' => { 485 => 'StudyID' },
	'studyphysician' => { 485 => 'StudyPhysician' },
	'styleperiod' => { 521 => 'StylePeriod' },
	'sub-location' => { 134 => 0x5c },
	'subcommanddialplaybackmode' => { 319 => 0x1cf, 320 => 0x1cf, 321 => 0x1e7 },
	'subfiledata' => { 167 => 'data' },
	'subfiledirectory' => { 167 => '1Directory' },
	'subfilemimetype' => { 167 => '2MIME' },
	'subfilename' => { 167 => '1Name' },
	'subfileresource' => { 167 => 'rsrc' },
	'subfiletype' => { 122 => 0xfe, 167 => '0Type' },
	'subject' => { 332 => 'Subject', 397 => 'Subject', 510 => 'subject', 523 => 'Subject', 537 => 'subject' },
	'subjectarea' => { 122 => 0x9214, 513 => 'SubjectArea' },
	'subjectcode' => { 520 => 'SubjectCode' },
	'subjectdetection' => { 244 => 0x252, 245 => 0x23e, 246 => 0x252, 247 => 0x252 },
	'subjectdistance' => { 122 => 0x9206, 143 => 0x3e, 513 => 'SubjectDistance' },
	'subjectdistancerange' => { 122 => 0xa40c, 513 => 'SubjectDistanceRange' },
	'subjectlocation' => { 122 => 0xa214, 513 => 'SubjectLocation' },
	'subjectmotion' => { 306 => '78.2', 307 => '78.2', 317 => '78.2', 319 => 0x103, 320 => 0x103, 321 => 0x119 },
	'subjectprogram' => { 184 => 0x22 },
	'subjectreference' => { 134 => 0xc },
	'sublabels1' => { 519 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 519 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 117 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 117 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 117 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 122 => 0x9290 },
	'subsectimedigitized' => { 122 => 0x9292 },
	'subsectimeoriginal' => { 122 => 0x9291 },
	'subsection1' => { 526 => 'subsection1' },
	'subsection2' => { 526 => 'subsection2' },
	'subsection3' => { 526 => 'subsection3' },
	'subsection4' => { 526 => 'subsection4' },
	'subselector' => { 304 => '49.1', 306 => '71.1', 307 => '71.1', 317 => '71.1', 319 => 0x8f, 320 => 0x8f, 321 => 0x8f },
	'subselectorassignment' => { 304 => '48.1' },
	'subselectorcenter' => { 306 => '72.1', 307 => '72.1', 317 => '72.1' },
	'subselectorplusdials' => { 304 => '49.2', 306 => '73.1', 307 => '73.1', 317 => '73.1' },
	'subtitle' => { 182 => 'WM/SubTitle', 398 => "\xa9st3", 406 => "\xa9snm", 526 => 'subtitle' },
	'subtitlekeywords' => { 406 => "\xa9snk" },
	'subversionfilename' => { 519 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 519 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 519 => 'SubVersions' },
	'superimposeddisplay' => { 85 => 0xa, 87 => 0x510, 88 => 0x9, 89 => 0xa, 92 => 0xa, 93 => 0xe },
	'supermacro' => { 66 => 0x1a },
	'supplementalcategories' => { 134 => 0x14, 524 => 'SupplementalCategories' },
	'supplementaltype' => { 136 => 0x37 },
	'supplementdisplayid' => { 526 => 'supplementDisplayID' },
	'supplementstartingpage' => { 526 => 'supplementStartingPage' },
	'supplementtitle' => { 526 => 'supplementTitle' },
	'supplychainsource' => { 521 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 521 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 521 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 507 => 'SupportsAmount', 509 => 'SupportsAmount' },
	'supportscolor' => { 507 => 'SupportsColor', 509 => 'SupportsColor' },
	'supportshighdynamicrange' => { 507 => 'SupportsHighDynamicRange', 509 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 507 => 'SupportsMonochrome', 509 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 507 => 'SupportsNormalDynamicRange', 509 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 507 => 'SupportsOutputReferred', 509 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 507 => 'SupportsSceneReferred', 509 => 'SupportsSceneReferred' },
	'svisosetting' => { 362 => 0x14 },
	'swatchcoloranta' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 541 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 541 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 541 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 541 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 541 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 346 => 0x93, 435 => 0x33 },
	'sweeppanoramafieldofview' => { 346 => 0x94 },
	'sweeppanoramasize' => { 435 => 0x32 },
	'switchtoregisteredafpoint' => { 86 => 0x12, 87 => 0x50a },
	'symlink' => { 123 => 'SymLink' },
	'syncreleasemode' => { 306 => '77.1', 307 => '77.1', 317 => '77.1', 319 => 0x41, 320 => 0x41, 321 => 0x41 },
	'system' => { 390 => 0x204 },
	'tagged' => { 392 => 0xdd, 393 => 'Tagged', 502 => 'tagged' },
	'tagslist' => { 512 => 'TagsList' },
	'tagstructure' => { 519 => 'TagStructure' },
	'takenumber' => { 536 => 'takeNumber' },
	'tapename' => { 536 => 'tapeName' },
	'targetaperture' => { 79 => 0x4 },
	'targetcompressionratio' => { 98 => 0x1 },
	'targetdistancesetting' => { 100 => 0x1807 },
	'targetexposuretime' => { 79 => 0x5 },
	'targetimagetype' => { 100 => 0x100a },
	'targetprinter' => { 122 => 0x151 },
	'taxon' => { 121 => 'Taxon' },
	'taxonacceptednameusage' => { 121 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 121 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 121 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 121 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 121 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 121 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 121 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 121 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 121 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 121 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 121 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 121 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 121 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 121 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 121 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 121 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 121 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 121 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 121 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 121 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 121 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 121 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 121 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 121 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 121 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 121 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 121 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 121 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 121 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 121 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 121 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 121 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 121 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 121 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 141 => 0x196f },
	'tda1edgepolarity' => { 141 => 0x1971 },
	'tda1gain' => { 141 => 0x1970 },
	'tda1offset' => { 141 => 0x196e },
	'tda2bandwidth' => { 141 => 0x1979 },
	'tda2edgepolarity' => { 141 => 0x197b },
	'tda2gain' => { 141 => 0x197a },
	'tda2offset' => { 141 => 0x1978 },
	'tda3bandwidth' => { 141 => 0x1983 },
	'tda3edgepolarity' => { 141 => 0x1985 },
	'tda3gain' => { 141 => 0x1984 },
	'tda3offset' => { 141 => 0x1982 },
	'tda4bandwidth' => { 141 => 0x198d },
	'tda4edgepolarity' => { 141 => 0x198f },
	'tda4gain' => { 141 => 0x198e },
	'tda4offset' => { 141 => 0x198c },
	'teaser' => { 526 => 'teaser' },
	'teleconverter' => { 189 => 0x105, 446 => 0x105 },
	'tempampgainx100' => { 141 => 0x1914 },
	'tempo' => { 536 => 'tempo' },
	'temporalcoverage' => { 521 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 521 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 521 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 333 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 333 => 'TermsAndConditionsURL' },
	'testname' => { 123 => 'TestName' },
	'textencoding' => { 238 => 0x4 },
	'textlayername' => { 524 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 524 => 'TextLayers' },
	'textlayertext' => { 524 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 346 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 507 => 'Texture', 509 => 'Texture' },
	'three-dtrackingfacedetection' => { 306 => '1.4', 307 => '1.4', 317 => '1.4' },
	'three-dtrackingwatcharea' => { 306 => '78.1', 307 => '78.1', 317 => '78.1' },
	'thresholding' => { 122 => 0x107 },
	'thumbnailfilename' => { 100 => 0x817 },
	'thumbnailformat' => { 534 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 145 => 0xfa55, 534 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 100 => 0x2008, 117 => 'Exif-ThumbnailImage', 125 => 0x3, 170 => 'data', 328 => 0x100, 406 => 'thmb', 534 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 170 => '1Name' },
	'thumbnailimagesize' => { 170 => 'ImageSize' },
	'thumbnailimagetype' => { 170 => '0Type' },
	'thumbnailimagevalidarea' => { 66 => 0x13 },
	'thumbnaillength' => { 122 => 0x202 },
	'thumbnailoffset' => { 122 => 0x201 },
	'thumbnailpng' => { 406 => 'thmb' },
	'thumbnails' => { 534 => 'Thumbnails' },
	'thumbnailwidth' => { 145 => 0xfa54, 534 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 526 => 'ticker' },
	'tiffhandling' => { 507 => 'TIFFHandling', 509 => 'TIFFHandling' },
	'tiffmeteringimage' => { 190 => 0x104c, 444 => 0x1110 },
	'tilelength' => { 122 => 0x143 },
	'tilewidth' => { 122 => 0x142 },
	'time' => { 141 => 0x401, 381 => 0x7 },
	'timecodes' => { 122 => 0xc763 },
	'timecreated' => { 134 => 0x3c, 143 => 0x14, 152 => 0x10, 393 => 'TimeCreated' },
	'timelapseshotnumber' => { 349 => 0x10 },
	'timeperiod' => { 526 => 'timePeriod' },
	'timerfunctionbutton' => { 305 => '5.2', 308 => '12.1', 309 => '13.1' },
	'timerlength' => { 87 => 0x80c },
	'timerrecording' => { 346 => 0x96 },
	'timescaleparams' => { 536 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 536 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 536 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 536 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 135 => 0x50 },
	'timeshot' => { 497 => 'TimeShot' },
	'timesignature' => { 536 => 'timeSignature' },
	'timesincepoweron' => { 346 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 322 => 0x8, 336 => 'TimeStamp', 346 => 0xaf, 496 => 'Timestamp', 503 => 'Timestamp', 519 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 80 => 0x1, 244 => 0x694, 245 => 0x594, 246 => 0x5c4, 247 => 0x5dc, 288 => 0x0, 416 => 0xa },
	'timezonecity' => { 80 => 0x2 },
	'timezonecode' => { 103 => 0x1 },
	'timezoneinfo' => { 103 => 0x2 },
	'timezoneoffset' => { 122 => 0x882a },
	'tint' => { 400 => 'player.movie.visual.tint', 507 => 'Tint', 509 => 'Tint' },
	'title' => { 122 => 0xa436, 160 => 'Title', 332 => 'Title', 336 => 'Title', 346 => 0x65, 397 => 'Title', 398 => ['titl',"\xa9nam"], 400 => 'title', 406 => ['titl',"\xa9nam"], 510 => 'title', 523 => 'Title', 534 => 'Title' },
	'togglestyleamount' => { 507 => 'ToggleStyleAmount', 509 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 507 => 'ToggleStyleDigest', 509 => 'ToggleStyleDigest' },
	'tonecomp' => { 239 => 0x81 },
	'tonecurve' => { 76 => 0x1, 381 => 0x402, 507 => 'ToneCurve', 509 => 'ToneCurve' },
	'tonecurveactive' => { 111 => 0x110 },
	'tonecurveadobergb' => { 420 => 0xa043 },
	'tonecurveadobergbdefault' => { 420 => 0xa041 },
	'tonecurveblue' => { 507 => 'ToneCurveBlue', 509 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 483 => 0x9003 },
	'tonecurvebluey' => { 483 => 0x9007 },
	'tonecurvebrightness' => { 106 => 0x20410 },
	'tonecurvebrightnessx' => { 483 => 0x9000 },
	'tonecurvebrightnessy' => { 483 => 0x9004 },
	'tonecurvecolorspace' => { 110 => 0x0 },
	'tonecurvecontrast' => { 106 => 0x20411 },
	'tonecurvegreen' => { 507 => 'ToneCurveGreen', 509 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 483 => 0x9002 },
	'tonecurvegreeny' => { 483 => 0x9006 },
	'tonecurveinputrange' => { 110 => 0x3 },
	'tonecurveinterpolation' => { 111 => 0x159 },
	'tonecurvemode' => { 111 => 0x113 },
	'tonecurvename' => { 507 => 'ToneCurveName', 509 => 'ToneCurveName' },
	'tonecurvename2012' => { 507 => 'ToneCurveName2012', 509 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 106 => '0x20400.1' },
	'tonecurveoutputrange' => { 110 => 0x5 },
	'tonecurveprofilename' => { 141 => 0x1391 },
	'tonecurveproperty' => { 111 => 0x3c },
	'tonecurvepv2012' => { 507 => 'ToneCurvePV2012', 509 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 507 => 'ToneCurvePV2012Blue', 509 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 507 => 'ToneCurvePV2012Green', 509 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 507 => 'ToneCurvePV2012Red', 509 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 507 => 'ToneCurveRed', 509 => 'ToneCurveRed' },
	'tonecurveredx' => { 483 => 0x9001 },
	'tonecurveredy' => { 483 => 0x9005 },
	'tonecurves' => { 381 => 0x403 },
	'tonecurveshape' => { 110 => 0x1 },
	'tonecurvesrgb' => { 420 => 0xa042 },
	'tonecurvesrgbdefault' => { 420 => 0xa040 },
	'tonecurvex' => { 110 => 0xa },
	'tonecurvey' => { 110 => 0xb },
	'tonelevel' => { 323 => 0x52e },
	'tonemap' => { 244 => 0x26a },
	'tonemapstrength' => { 507 => 'ToneMapStrength', 509 => 'ToneMapStrength' },
	'toningeffect' => { 59 => 0xf, 239 => 0xb3, 254 => 0x38, 255 => 0x40, 256 => 0x48, 413 => 0x1015 },
	'toningeffectauto' => { 73 => 0xa4 },
	'toningeffectfaithful' => { 72 => 0x74, 73 => 0x74 },
	'toningeffectlandscape' => { 72 => 0x44, 73 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 72 => 0x8c, 73 => 0x8c },
	'toningeffectneutral' => { 72 => 0x5c, 73 => 0x5c },
	'toningeffectportrait' => { 72 => 0x2c, 73 => 0x2c },
	'toningeffectstandard' => { 72 => 0x14, 73 => 0x14 },
	'toningeffectuserdef1' => { 72 => 0xa4, 73 => 0xbc },
	'toningeffectuserdef2' => { 72 => 0xbc, 73 => 0xd4 },
	'toningeffectuserdef3' => { 72 => 0xd4, 73 => 0xec },
	'toningsaturation' => { 254 => 0x39, 255 => 0x41, 256 => 0x49 },
	'totalzoom' => { 143 => 0x62 },
	'touchae' => { 346 => 0xab },
	'track' => { 398 => "\xa9trk", 406 => "\xa9trk" },
	'trackcreatedate' => { 405 => 0x1 },
	'trackmodifydate' => { 405 => 0x2 },
	'tracknumber' => { 398 => 'trkn', 536 => 'trackNumber' },
	'tracks' => { 536 => 'Tracks' },
	'tracksframerate' => { 536 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 536 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 536 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 536 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 536 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 536 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 536 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 536 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 536 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 536 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 536 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 536 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 536 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 536 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 536 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 536 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 536 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 406 => 'kgtt' },
	'trailer' => { 123 => 'Trailer' },
	'trailersignature' => { 167 => 'zmie' },
	'transcript' => { 521 => 'Transcript' },
	'transcriptlink' => { 521 => 'TranscriptLink' },
	'transcriptlinklink' => { 521 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 521 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 122 => 0x12d, 532 => 'TransferFunction' },
	'transfertimenormal' => { 141 => 0x1888 },
	'transfertimetest' => { 141 => 0x1889 },
	'transform' => { 346 => [0x8012,0x59] },
	'transformation' => { 522 => 'Transformation' },
	'transmissionreference' => { 524 => 'TransmissionReference' },
	'trapped' => { 332 => 'Trapped', 523 => 'Trapped' },
	'trashbuttonfunction' => { 87 => 0x710 },
	'travelday' => { 346 => 0x36 },
	'treble' => { 400 => 'player.movie.audio.treble' },
	'triggermode' => { 407 => 0x6, 408 => 0x34, 409 => 0x34 },
	'tstop' => { 122 => 0xc772 },
	'ttl_da_adown' => { 369 => 0x5 },
	'ttl_da_aup' => { 369 => 0x4 },
	'ttl_da_bdown' => { 369 => 0x7 },
	'ttl_da_bup' => { 369 => 0x6 },
	'tungstenawb' => { 359 => 0x1 },
	'tvepisode' => { 398 => 'tves' },
	'tvepisodeid' => { 398 => 'tven' },
	'tvexposuretimesetting' => { 362 => 0x12 },
	'tvnetworkname' => { 398 => 'tvnn' },
	'tvseason' => { 398 => 'tvsn' },
	'tvshow' => { 398 => 'tvsh' },
	'type' => { 491 => 'Type', 510 => 'type', 531 => 'type' },
	'typestatus' => { 121 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 122 => 0xc614 },
	'uniquedocumentid' => { 134 => 0xbb },
	'uniquematrixauto' => { 141 => 0x7e9 },
	'uniquematrixcustom' => { 141 => 0x7e8 },
	'uniquematrixdaylight' => { 141 => 0x7e4 },
	'uniquematrixflash' => { 141 => 0x7e7 },
	'uniquematrixfluorescent' => { 141 => 0x7e6 },
	'uniquematrixtungsten' => { 141 => 0x7e5 },
	'uniqueobjectname' => { 135 => 0x64 },
	'units' => { 492 => 'Units' },
	'unknown_aacr' => { 398 => 'AACR' },
	'unknown_cdek' => { 398 => 'CDEK' },
	'unknown_cdet' => { 398 => 'CDET' },
	'unknownblock' => { 381 => 0x405 },
	'unknownblock1' => { 327 => 0x635 },
	'unknownblock2' => { 327 => 0x636 },
	'unknownblock3' => { 327 => 0x1103 },
	'unknownblock4' => { 327 => 0x1104 },
	'unknowncontrast' => { 112 => 0x45 },
	'unknowndate' => { 390 => 0x212 },
	'unknownev' => { 141 => 0x1 },
	'unknownlinear' => { 112 => 0x46 },
	'unknownnumber' => { 100 => 0x180b },
	'unknownoutputhighlightpoint' => { 112 => 0x4a },
	'unknownoutputshadowpoint' => { 112 => 0x4b },
	'unknownrawhighlight' => { 112 => 0x7b },
	'unknownrawhighlightpoint' => { 112 => 0x48 },
	'unknownrawshadow' => { 112 => 0x84 },
	'unknownrawshadowpoint' => { 112 => 0x49 },
	'unknownsharpness' => { 112 => 0x47 },
	'unknowntags' => { 406 => 'TAGS' },
	'unknowntemperature' => { 124 => 0x4 },
	'unknownthumbnail' => { 406 => 'thmb' },
	'unsharp1color' => { 301 => 0x13 },
	'unsharp1halowidth' => { 301 => 0x19 },
	'unsharp1intensity' => { 301 => 0x17 },
	'unsharp1threshold' => { 301 => 0x1b },
	'unsharp2color' => { 301 => 0x2e },
	'unsharp2halowidth' => { 301 => 0x34 },
	'unsharp2intensity' => { 301 => 0x32 },
	'unsharp2threshold' => { 301 => 0x36 },
	'unsharp3color' => { 301 => 0x49 },
	'unsharp3halowidth' => { 301 => 0x4f },
	'unsharp3intensity' => { 301 => 0x4d },
	'unsharp3threshold' => { 301 => 0x51 },
	'unsharp4color' => { 301 => 0x64 },
	'unsharp4halowidth' => { 301 => 0x6a },
	'unsharp4intensity' => { 301 => 0x68 },
	'unsharp4threshold' => { 301 => 0x6c },
	'unsharpcount' => { 301 => 0x0 },
	'unsharpmask' => { 112 => 0x90, 296 => 0x76a43200 },
	'unsharpmaskfineness' => { 106 => 0x20309 },
	'unsharpmaskstrength' => { 106 => 0x20308 },
	'unsharpmaskthreshold' => { 106 => 0x2030a },
	'uprightcentermode' => { 507 => 'UprightCenterMode', 509 => 'UprightCenterMode' },
	'uprightcenternormx' => { 507 => 'UprightCenterNormX', 509 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 507 => 'UprightCenterNormY', 509 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 507 => 'UprightDependentDigest', 509 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 507 => 'UprightFocalLength35mm', 509 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 507 => 'UprightFocalMode', 509 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 507 => 'UprightFourSegments_0', 509 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 507 => 'UprightFourSegments_1', 509 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 507 => 'UprightFourSegments_2', 509 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 507 => 'UprightFourSegments_3', 509 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 507 => 'UprightFourSegmentsCount', 509 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 507 => 'UprightGuidedDependentDigest', 509 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 507 => 'UprightPreview', 509 => 'UprightPreview' },
	'uprighttransform_0' => { 507 => 'UprightTransform_0', 509 => 'UprightTransform_0' },
	'uprighttransform_1' => { 507 => 'UprightTransform_1', 509 => 'UprightTransform_1' },
	'uprighttransform_2' => { 507 => 'UprightTransform_2', 509 => 'UprightTransform_2' },
	'uprighttransform_3' => { 507 => 'UprightTransform_3', 509 => 'UprightTransform_3' },
	'uprighttransform_4' => { 507 => 'UprightTransform_4', 509 => 'UprightTransform_4' },
	'uprighttransform_5' => { 507 => 'UprightTransform_5', 509 => 'UprightTransform_5' },
	'uprighttransformcount' => { 507 => 'UprightTransformCount', 509 => 'UprightTransformCount' },
	'uprightversion' => { 507 => 'UprightVersion', 509 => 'UprightVersion' },
	'urgency' => { 134 => 0xa, 524 => 'Urgency' },
	'url' => { 160 => 'URL', 336 => 'URL', 395 => 0x40b, 526 => 'url' },
	'url_list' => { 395 => 0x41e },
	'urla-platform' => { 526 => [\'url','urlA-platform'] },
	'urlurl' => { 526 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 87 => 0x10a },
	'usableshootingmodes' => { 87 => 0x109 },
	'usage' => { 527 => 'usage' },
	'usageterms' => { 540 => 'UsageTerms' },
	'usbpowerdelivery' => { 244 => 0x762, 245 => 0x664, 246 => 0x694, 247 => 0x6fc },
	'usedialwithouthold' => { 319 => 0xbf, 320 => 0xbf, 321 => 0xbf },
	'useguidelines' => { 505 => 'useGuidelines' },
	'usepanoramaviewer' => { 495 => 'UsePanoramaViewer' },
	'usercollection' => { 400 => 'collection.user' },
	'usercomment' => { 100 => 0x805, 122 => 0x9286, 513 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 72 => 0xd8, 73 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 72 => 0xda, 73 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 72 => 0xdc, 73 => 0xf4 },
	'userfields' => { 500 => 'UserFields' },
	'userlabel' => { 407 => 0x2b, 408 => 0x5a, 409 => 0x68 },
	'userprofile' => { 341 => 0x302, 345 => 0x34c, 348 => 0x3038 },
	'userrating' => { 400 => 'rating.user', 406 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 86 => 0x7, 87 => 0x501 },
	'uspsnumber' => { 526 => 'uspsNumber' },
	'utmeasting' => { 171 => 'Easting' },
	'utmmapdatum' => { 171 => 'Datum' },
	'utmnorthing' => { 171 => 'Northing' },
	'utmzone' => { 171 => 'Zone' },
	'uuid' => { 507 => 'UUID', 509 => 'UUID' },
	'uv-irfiltercorrection' => { 341 => 0x325 },
	'validbits' => { 327 => 0x611, 328 => 0x102c },
	'validpixeldepth' => { 331 => 0x611 },
	'variablelowpassfilter' => { 446 => 0x2028 },
	'variousmodes' => { 143 => 0x26 },
	'variousmodes2' => { 143 => 0x3a },
	'variprogram' => { 239 => 0xab },
	'varraydacnominalvalues' => { 141 => 0x191e },
	'vendor' => { 406 => 'vndr' },
	'vendorinfo' => { 486 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 486 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 486 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 486 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 121 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 130 => 0x0, 397 => 'Version', 400 => 'version', 507 => 'Version', 509 => 'Version', 518 => 'Version' },
	'versioncreatedate' => { 483 => 0xd100 },
	'versionid' => { 537 => 'VersionID' },
	'versionidentifier' => { 526 => 'versionIdentifier' },
	'versionmodifydate' => { 483 => 0xd101 },
	'versions' => { 537 => 'Versions' },
	'versionscomments' => { 537 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 537 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 537 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 537 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 537 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 537 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 537 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 537 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 537 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 537 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 537 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 303 => '3.2', 304 => '47.2', 306 => '79.1', 320 => 0x11d, 321 => 0x135 },
	'verticalclockoverlaps' => { 141 => 0x412 },
	'verticalfuncbutton' => { 304 => '42.2', 306 => '67.1', 320 => 0x115, 321 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 320 => 0x1b7, 321 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 304 => '43.1' },
	'verticalfuncplusdials' => { 306 => '68.1' },
	'verticalisobutton' => { 247 => 0x792 },
	'verticalmovieafonbutton' => { 320 => 0x1f9, 321 => 0x211 },
	'verticalmoviefuncbutton' => { 320 => 0x1e1, 321 => 0x1f9 },
	'verticalmultiselector' => { 304 => '42.1', 306 => '66.1', 307 => '66.1', 317 => '66.1', 320 => 0x18f, 321 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 320 => 0x125, 321 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 87 => [0x510,0x51d] },
	'vibrance' => { 501 => 'Vibrance', 507 => 'Vibrance', 509 => 'Vibrance' },
	'vibrationreduction' => { 267 => [0x75,0x82,0x1ae], 275 => '586.1', 282 => '590.2', 286 => 0x4 },
	'videoalphamode' => { 536 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 536 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 536 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 536 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 521 => 'videoBitRate' },
	'videobitratemode' => { 521 => 'videoBitRateMode' },
	'videoburstmode' => { 346 => 0xbb },
	'videoburstresolution' => { 346 => 0xb3 },
	'videocodec' => { 69 => 0x74 },
	'videocolorspace' => { 536 => 'videoColorSpace' },
	'videocompression' => { 130 => 0x3806 },
	'videocompressor' => { 536 => 'videoCompressor' },
	'videodisplayaspectratio' => { 521 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 521 => 'videoEncodingProfile' },
	'videofieldorder' => { 536 => 'videoFieldOrder' },
	'videoframerate' => { 346 => 0x27, 536 => 'videoFrameRate' },
	'videoframesize' => { 536 => 'videoFrameSize' },
	'videoframesizeh' => { 536 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 536 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 536 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 536 => 'videoModDate' },
	'videopixelaspectratio' => { 536 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 536 => 'videoPixelDepth' },
	'videopreburst' => { 346 => 0xc1 },
	'videoquality' => { 116 => 0x4003 },
	'videorecordingmode' => { 130 => 0x3803 },
	'videoshottype' => { 521 => 'VideoShotType' },
	'videoshottypeidentifier' => { 521 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 521 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 521 => 'videoStreamsCount' },
	'viewfinder' => { 390 => 0x455 },
	'viewfinderdisplay' => { 303 => '12.4', 304 => '6.3' },
	'viewfinderwarning' => { 303 => '13.4', 313 => '3.5', 314 => '6.2', 318 => '4.4' },
	'viewfinderwarnings' => { 87 => 0x40a },
	'viewinfoduringexposure' => { 87 => 0x407 },
	'viewingmode' => { 435 => 0x2f, 451 => 0x18 },
	'viewingmode2' => { 435 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 247 => 0x7d2, 319 => 0x2a9 },
	'viewpoint' => { 525 => 'viewpoint' },
	'vignetteamount' => { 507 => 'VignetteAmount', 509 => 'VignetteAmount' },
	'vignettecoefficient1' => { 287 => 0x24 },
	'vignettecoefficient2' => { 287 => 0x34 },
	'vignettecoefficient3' => { 287 => 0x44 },
	'vignettecontrol' => { 239 => 0x2a, 296 => 0x76a43205 },
	'vignettecontrolintensity' => { 296 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 504 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 287 => 0x0 },
	'vignettemidpoint' => { 507 => 'VignetteMidpoint', 509 => 'VignetteMidpoint' },
	'vignetting' => { 413 => 0x1011, 420 => 0xa052 },
	'vignettingcorrection' => { 122 => 0x7031, 420 => 0xa053, 446 => 0x2011 },
	'vignettingcorrparams' => { 122 => 0x7032, 477 => 0x64a, 478 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 420 => 0xa054 },
	'virtualfocallength' => { 522 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 319 => 0x167, 320 => 0x167, 321 => 0x17f },
	'virtualimagexcenter' => { 522 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 522 => 'VirtualImageYCenter' },
	'visualcolor' => { 521 => 'VisualColour' },
	'visualtechnique' => { 525 => 'visualTechnique' },
	'voicememo' => { 422 => 0x216 },
	'volume' => { 526 => 'volume' },
	'vr_0x66' => { 267 => 0x66 },
	'vrdoffset' => { 66 => 0xd0 },
	'vrmode' => { 244 => 0x226, 245 => 0x212, 246 => 0x226, 247 => 0x226, 286 => 0x6 },
	'vrtype' => { 286 => 0x8 },
	'waterdepth' => { 122 => 0x9403, 514 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 190 => 0x19a },
	'wb_bluelevel6500k' => { 190 => 0x18a },
	'wb_bluelevelcustom' => { 190 => 0x18e },
	'wb_bluelevelscloudy' => { 190 => 0x106 },
	'wb_bluelevelsdaylight' => { 190 => 0xea },
	'wb_bluelevelsflash' => { 190 => 0x122 },
	'wb_bluelevelsfluorescent' => { 190 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 190 => 0x254 },
	'wb_bluelevelsshade' => { 190 => 0x176 },
	'wb_bluelevelstungsten' => { 190 => 0xce },
	'wb_gbrglevels' => { 190 => 0xae, 193 => 0x4 },
	'wb_glevel' => { 327 => 0x11f },
	'wb_glevel3000k' => { 327 => 0x113 },
	'wb_glevel3300k' => { 327 => 0x114 },
	'wb_glevel3600k' => { 327 => 0x115 },
	'wb_glevel3900k' => { 327 => 0x116 },
	'wb_glevel4000k' => { 327 => 0x117 },
	'wb_glevel4300k' => { 327 => 0x118 },
	'wb_glevel4500k' => { 327 => 0x119 },
	'wb_glevel4800k' => { 327 => 0x11a },
	'wb_glevel5300k' => { 327 => 0x11b },
	'wb_glevel6000k' => { 327 => 0x11c },
	'wb_glevel6600k' => { 327 => 0x11d },
	'wb_glevel7500k' => { 327 => 0x11e },
	'wb_grbglevels' => { 207 => 0x0, 453 => 0x7303 },
	'wb_grbglevelsauto' => { 83 => 0x2, 453 => 0x7302 },
	'wb_grbglevelscloudy' => { 83 => 0x12 },
	'wb_grbglevelscustom1' => { 83 => 0x42 },
	'wb_grbglevelscustom2' => { 83 => 0x4a },
	'wb_grbglevelsdaylight' => { 83 => 0xa },
	'wb_grbglevelsflash' => { 83 => 0x32 },
	'wb_grbglevelsfluorescent' => { 83 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 83 => 0x2a },
	'wb_grbglevelstungsten' => { 83 => 0x1a },
	'wb_grbglevelsunderwater' => { 83 => 0x3a },
	'wb_rbgglevels' => { 204 => 0x0 },
	'wb_rblevels' => { 208 => 0x270, 239 => 0xc, 327 => 0x100 },
	'wb_rblevels1' => { 352 => 0x2 },
	'wb_rblevels2' => { 352 => 0x5 },
	'wb_rblevels3' => { 352 => 0x8 },
	'wb_rblevels3000k' => { 327 => 0x102 },
	'wb_rblevels3300k' => { 327 => 0x103 },
	'wb_rblevels3500k' => { 190 => 0x430 },
	'wb_rblevels3600k' => { 327 => 0x104 },
	'wb_rblevels3900k' => { 327 => 0x105 },
	'wb_rblevels4' => { 352 => 0xb },
	'wb_rblevels4000k' => { 327 => 0x106 },
	'wb_rblevels4300k' => { 327 => 0x107 },
	'wb_rblevels4500k' => { 327 => 0x108 },
	'wb_rblevels4800k' => { 327 => 0x109 },
	'wb_rblevels5' => { 352 => 0xe },
	'wb_rblevels5300k' => { 327 => 0x10a },
	'wb_rblevels6' => { 352 => 0x11 },
	'wb_rblevels6000k' => { 327 => 0x10b },
	'wb_rblevels6500k' => { 190 => 0x420 },
	'wb_rblevels6600k' => { 327 => 0x10c },
	'wb_rblevels7' => { 352 => 0x14 },
	'wb_rblevels7500k' => { 327 => 0x10d },
	'wb_rblevelsauto' => { 208 => 0x272, 331 => 0x110 },
	'wb_rblevelscloudy' => { 190 => 0x3f0, 192 => 0x10, 208 => 0x296, 331 => 0x121 },
	'wb_rblevelscoolwhitef' => { 190 => 0x308, 192 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 331 => 0x132 },
	'wb_rblevelscustom' => { 190 => 0x424, 192 => 0x1c },
	'wb_rblevelscwb1' => { 327 => 0x10e },
	'wb_rblevelscwb2' => { 327 => 0x10f },
	'wb_rblevelscwb3' => { 327 => 0x110 },
	'wb_rblevelscwb4' => { 327 => 0x111 },
	'wb_rblevelsdaylight' => { 190 => [0x3ec,0x528], 192 => 0xc, 208 => 0x274 },
	'wb_rblevelsdaylightf' => { 192 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 331 => 0x130 },
	'wb_rblevelsdaywhitef' => { 192 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 331 => 0x131 },
	'wb_rblevelseveningsunlight' => { 331 => 0x124 },
	'wb_rblevelsfineweather' => { 331 => 0x122 },
	'wb_rblevelsflash' => { 190 => [0x3f4,0x304], 192 => 0x18, 208 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 208 => 0x290 },
	'wb_rblevelsincandescent' => { 208 => 0x282 },
	'wb_rblevelsshade' => { 190 => 0x418, 192 => 0x20, 208 => 0x2b2, 331 => 0x120 },
	'wb_rblevelstungsten' => { 190 => 0x3e8, 192 => 0x8, 331 => 0x123 },
	'wb_rblevelsused' => { 331 => 0x100 },
	'wb_rblevelswhitef' => { 192 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 331 => 0x133 },
	'wb_redlevel3500k' => { 190 => 0x198 },
	'wb_redlevel6500k' => { 190 => 0x188 },
	'wb_redlevelcustom' => { 190 => 0x18c },
	'wb_redlevelscloudy' => { 190 => 0xf8 },
	'wb_redlevelsdaylight' => { 190 => 0xdc },
	'wb_redlevelsflash' => { 190 => 0x114 },
	'wb_redlevelsfluorescent' => { 190 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 190 => 0x1be },
	'wb_redlevelsshade' => { 190 => 0x168 },
	'wb_redlevelstungsten' => { 190 => 0xc0 },
	'wb_rgbglevels' => { 206 => 0x0 },
	'wb_rgblevels' => { 190 => [0x546,0x96], 342 => 0xd, 343 => 0x413, 348 => 0x3036, 390 => 0x107, 455 => 0x117c, 456 => 0x1180, 457 => 0x115c, 458 => 0x11d8, 459 => 0x11b4, 460 => 0x106c, 461 => 0x264, 462 => 0x264, 463 => 0x252 },
	'wb_rgblevels1' => { 353 => 0x2 },
	'wb_rgblevels2' => { 353 => 0x6 },
	'wb_rgblevels2500k' => { 453 => 0x782d },
	'wb_rgblevels3' => { 353 => 0xa },
	'wb_rgblevels3200k' => { 453 => 0x782c },
	'wb_rgblevels4' => { 353 => 0xe },
	'wb_rgblevels4500k' => { 453 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 353 => 0x12 },
	'wb_rgblevels6' => { 353 => 0x16 },
	'wb_rgblevels6000k' => { 453 => 0x782b },
	'wb_rgblevels7' => { 353 => 0x1a },
	'wb_rgblevels8500k' => { 453 => 0x782a },
	'wb_rgblevelsauto' => { 424 => 0x0 },
	'wb_rgblevelscloudy' => { 453 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 424 => 0x15 },
	'wb_rgblevelscustom2' => { 424 => 0x18 },
	'wb_rgblevelscustom3' => { 424 => 0x1b },
	'wb_rgblevelsdaylight' => { 424 => 0x3, 453 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 424 => 0x12, 453 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 424 => 0xf, 453 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 453 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 453 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 453 => 0x7828 },
	'wb_rgblevelsincandescent' => { 424 => 0xc },
	'wb_rgblevelsovercast' => { 424 => 0x9 },
	'wb_rgblevelsshade' => { 424 => 0x6, 453 => 0x7825 },
	'wb_rgblevelstungsten' => { 453 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 425 => 0x0 },
	'wb_rgblevelsunknown1' => { 425 => 0x3 },
	'wb_rgblevelsunknown2' => { 425 => 0x6 },
	'wb_rgblevelsunknown3' => { 425 => 0x9 },
	'wb_rgblevelsunknown4' => { 425 => 0xc },
	'wb_rgblevelsunknown5' => { 425 => 0xf },
	'wb_rgblevelsunknown6' => { 425 => 0x12 },
	'wb_rgblevelsunknown7' => { 425 => 0x15 },
	'wb_rgblevelsunknown8' => { 425 => 0x18 },
	'wb_rgblevelsunknown9' => { 425 => 0x1b },
	'wb_rgbmuldaylight' => { 141 => 0x852 },
	'wb_rgbmulflash' => { 141 => 0x855 },
	'wb_rgbmulfluorescent' => { 141 => 0x854 },
	'wb_rgbmultungsten' => { 141 => 0x853 },
	'wb_rggbblacklevels' => { 37 => 0x25 },
	'wb_rggblevels' => { 122 => 0x7313, 193 => 0x4, 205 => 0x0, 209 => 0x13e8, 210 => 0x38, 453 => 0x7313 },
	'wb_rggblevelsasshot' => { 40 => 0x0, 41 => 0x0, 42 => 0x19, 43 => 0x55, 44 => 0x69, 45 => 0x22, 46 => 0x3f, 49 => 0x3f, 50 => 0x3f, 51 => 0x3f, 52 => 0x47 },
	'wb_rggblevelsauto' => { 37 => 0x1, 40 => 0x5, 41 => 0x8, 42 => 0x1e, 43 => 0x5a, 44 => 0x6e, 45 => 0x18, 46 => 0x44, 49 => 0x44, 50 => 0x44, 51 => 0x44, 52 => 0x4c, 209 => 0x1478, 210 => 0x114, 420 => 0xa022, 453 => 0x7312 },
	'wb_rggblevelsblack' => { 420 => 0xa028 },
	'wb_rggblevelscloudy' => { 37 => 0xd, 40 => 0x1e, 41 => 0x30, 42 => 0x2d, 43 => 0xa0, 44 => 0xd7, 45 => 0x31, 46 => 0x58, 49 => 0x71, 50 => 0x8a, 51 => 0x8f, 52 => 0x92, 209 => 0x1408, 210 => 0x60, 381 => 0x20f, 389 => 0x14 },
	'wb_rggblevelscustom' => { 37 => 0x1d, 46 => 0x80, 209 => 0x1468, 210 => 0x100 },
	'wb_rggblevelscustom1' => { 42 => 0x41 },
	'wb_rggblevelscustom2' => { 42 => 0x46 },
	'wb_rggblevelsdaylight' => { 37 => 0x5, 40 => 0x14, 41 => 0x20, 42 => 0x23, 43 => 0x96, 44 => 0xcd, 45 => 0x27, 46 => 0x4e, 49 => 0x67, 50 => 0x80, 51 => 0x85, 52 => 0x88, 209 => 0x13f8, 210 => 0x4c, 381 => 0x20d, 389 => 0x2 },
	'wb_rggblevelsflash' => { 37 => 0x19, 40 => 0x32, 41 => 0x50, 42 => 0x3c, 43 => 0xb4, 44 => 0xeb, 45 => 0x45, 46 => 0x6c, 49 => 0x85, 50 => 0x9e, 51 => 0xa3, 52 => 0xa6, 209 => 0x1448, 381 => 0x214, 389 => 0x41 },
	'wb_rggblevelsfluorescent' => { 37 => 0x15, 40 => 0x28, 41 => 0x40, 42 => 0x37, 43 => 0xaa, 44 => 0xe1, 45 => 0x3b, 46 => 0x62, 49 => 0x7b, 50 => 0x94, 51 => 0x99, 52 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 210 => 0xc4, 381 => 0x211, 389 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 389 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 210 => 0xb0, 381 => 0x212, 389 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 209 => 0x1438, 210 => 0x9c, 381 => 0x213, 389 => 0x38 },
	'wb_rggblevelshtmercury' => { 210 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 420 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 420 => 0xa024 },
	'wb_rggblevelskelvin' => { 37 => 0x21, 40 => 0x2d, 41 => 0x48, 43 => 0xaf, 44 => 0xe6, 45 => 0x40, 46 => 0x67, 49 => 0x80, 50 => 0x99, 51 => 0x9e, 52 => 0xa1 },
	'wb_rggblevelsmeasured' => { 40 => 0xa, 41 => 0x10, 43 => 0x5f, 44 => 0x73, 46 => 0x49, 49 => 0x49, 50 => 0x49, 51 => 0x49, 52 => 0x51 },
	'wb_rggblevelspc1' => { 45 => 0x90, 46 => 0x71 },
	'wb_rggblevelspc2' => { 45 => 0x95, 46 => 0x76 },
	'wb_rggblevelspc3' => { 45 => 0x9a, 46 => 0x7b },
	'wb_rggblevelsshade' => { 37 => 0x9, 40 => 0x19, 41 => 0x28, 42 => 0x28, 43 => 0x9b, 44 => 0xd2, 45 => 0x2c, 46 => 0x53, 49 => 0x6c, 50 => 0x85, 51 => 0x8a, 52 => 0x8d, 210 => 0x74, 381 => 0x20e, 389 => 0xb },
	'wb_rggblevelstungsten' => { 37 => 0x11, 40 => 0x23, 41 => 0x38, 42 => 0x32, 43 => 0xa5, 44 => 0xdc, 45 => 0x36, 46 => 0x5d, 49 => 0x76, 50 => 0x8f, 51 => 0x94, 52 => 0x97, 209 => 0x1428, 210 => 0x88, 381 => 0x210, 389 => 0x1d },
	'wb_rggblevelsuncorrected' => { 420 => 0xa021 },
	'wb_rggblevelsunknown' => { 40 => 0xf, 41 => 0x18, 43 => 0x64, 44 => 0x78, 45 => 0x1d, 49 => 0x4e, 50 => 0x4e, 51 => 0x4e, 52 => 0x56, 389 => 0x53 },
	'wb_rggblevelsunknown10' => { 40 => 0x5f, 41 => 0x98, 43 => 0x91, 44 => 0xa5, 45 => 0x72, 49 => 0x9e, 50 => 0x7b, 51 => 0x7b, 52 => 0x83 },
	'wb_rggblevelsunknown11' => { 40 => 0x64, 41 => 0xa0, 43 => 0xb9, 44 => [0xaa,0xaf], 45 => 0x77, 49 => 0xa3, 50 => 0xa3, 51 => 0x80, 52 => 0xab },
	'wb_rggblevelsunknown12' => { 40 => 0x69, 41 => 0xa8, 43 => 0xbe, 44 => 0xb4, 45 => 0x7c, 49 => 0xa8, 50 => 0xa8, 51 => 0xa8, 52 => 0xb0 },
	'wb_rggblevelsunknown13' => { 40 => 0x6e, 41 => 0xb0, 43 => 0xc3, 44 => 0xb9, 45 => 0x81, 49 => 0xad, 50 => 0xad, 51 => 0xad, 52 => 0xb5 },
	'wb_rggblevelsunknown14' => { 43 => 0xc8, 44 => 0xbe, 45 => 0x86, 49 => 0xb2, 50 => 0xb2, 51 => 0xb2, 52 => 0xba },
	'wb_rggblevelsunknown15' => { 43 => 0xcd, 44 => 0xc3, 45 => 0x8b, 49 => 0xb7, 50 => 0xb7, 51 => 0xb7, 52 => 0xbf },
	'wb_rggblevelsunknown16' => { 43 => 0xd2, 44 => 0xc8, 45 => 0x9f, 50 => 0xbc, 51 => 0xbc, 52 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xd7, 44 => 0xf0, 50 => 0xc1, 51 => 0xc1, 52 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xdc, 44 => 0xf5, 50 => 0xc6, 51 => 0xc6, 52 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xe1, 44 => 0xfa, 50 => 0xcb, 51 => 0xcb, 52 => 0xd3 },
	'wb_rggblevelsunknown2' => { 40 => 0x37, 41 => 0x58, 43 => 0x69, 44 => 0x7d, 45 => 0x4a, 49 => 0x53, 50 => 0x53, 51 => 0x53, 52 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xe6, 44 => 0xff, 50 => 0xd0, 51 => 0xd0, 52 => 0xd8 },
	'wb_rggblevelsunknown21' => { 43 => 0xeb, 44 => 0x104, 51 => 0xd5, 52 => 0xdd },
	'wb_rggblevelsunknown22' => { 43 => 0xf0, 44 => 0x109, 51 => 0xda, 52 => 0xe2 },
	'wb_rggblevelsunknown23' => { 43 => 0xf5, 44 => 0x10e, 51 => 0xdf, 52 => 0xe7 },
	'wb_rggblevelsunknown24' => { 43 => 0xfa, 44 => 0x113, 51 => 0xe4, 52 => 0xec },
	'wb_rggblevelsunknown25' => { 43 => 0xff, 44 => 0x118, 51 => 0xe9, 52 => 0xf1 },
	'wb_rggblevelsunknown26' => { 43 => 0x104, 44 => 0x11d, 51 => 0xee, 52 => 0xf6 },
	'wb_rggblevelsunknown27' => { 43 => 0x109, 44 => 0x122, 51 => 0xf3, 52 => 0xfb },
	'wb_rggblevelsunknown28' => { 43 => 0x10e, 51 => 0xf8, 52 => 0x100 },
	'wb_rggblevelsunknown29' => { 43 => 0x113, 51 => 0xfd, 52 => 0x105 },
	'wb_rggblevelsunknown3' => { 40 => 0x3c, 41 => 0x60, 43 => 0x6e, 44 => 0x82, 45 => 0x4f, 49 => 0x58, 50 => 0x58, 51 => 0x58, 52 => 0x60 },
	'wb_rggblevelsunknown30' => { 51 => 0x102 },
	'wb_rggblevelsunknown4' => { 40 => 0x41, 41 => 0x68, 43 => 0x73, 44 => 0x87, 45 => 0x54, 49 => 0x5d, 50 => 0x5d, 51 => 0x5d, 52 => 0x65 },
	'wb_rggblevelsunknown5' => { 40 => 0x46, 41 => 0x70, 43 => 0x78, 44 => 0x8c, 45 => 0x59, 49 => 0x62, 50 => 0x62, 51 => 0x62, 52 => 0x6a },
	'wb_rggblevelsunknown6' => { 40 => 0x4b, 41 => 0x78, 43 => 0x7d, 44 => 0x91, 45 => 0x5e, 49 => 0x8a, 50 => 0x67, 51 => 0x67, 52 => 0x6f },
	'wb_rggblevelsunknown7' => { 40 => 0x50, 41 => 0x80, 43 => 0x82, 44 => 0x96, 45 => 0x63, 49 => 0x8f, 50 => 0x6c, 51 => 0x6c, 52 => 0x74 },
	'wb_rggblevelsunknown8' => { 40 => 0x55, 41 => 0x88, 43 => 0x87, 44 => 0x9b, 45 => 0x68, 49 => 0x94, 50 => 0x71, 51 => 0x71, 52 => 0x79 },
	'wb_rggblevelsunknown9' => { 40 => 0x5a, 41 => 0x90, 43 => 0x8c, 44 => 0xa0, 45 => 0x6d, 49 => 0x99, 50 => 0x76, 51 => 0x76, 52 => 0x7e },
	'wb_rggblevelsuserselected' => { 389 => 0x5c },
	'wbadjblueamber' => { 106 => 0x20106 },
	'wbadjbluebalance' => { 302 => 0x8 },
	'wbadjcolortemp' => { 106 => 0x20102, 111 => 0x1a },
	'wbadjlighting' => { 302 => 0x14 },
	'wbadjmagentagreen' => { 106 => 0x20105 },
	'wbadjmode' => { 302 => 0x10 },
	'wbadjredbalance' => { 302 => 0x0 },
	'wbadjrggblevels' => { 106 => 0x20125, 111 => 0x6 },
	'wbadjtemperature' => { 302 => 0x18 },
	'wbadjtint' => { 302 => 0x25 },
	'wbbluelevel' => { 341 => 0x324, 346 => 0x8006, 351 => 0x26 },
	'wbbracketingsteps' => { 201 => 0x10, 202 => 0x10, 276 => 0x174d },
	'wbbracketmode' => { 59 => 0x9 },
	'wbbracketshotnumber' => { 190 => 0x2b, 413 => 0x101a },
	'wbbracketvalueab' => { 59 => 0xc },
	'wbbracketvaluegm' => { 59 => 0xd },
	'wbbutton' => { 247 => 0x80a },
	'wbfinetuneactive' => { 111 => 0x24 },
	'wbfinetunesaturation' => { 111 => 0x28 },
	'wbfinetunetone' => { 111 => 0x2c },
	'wbgreenlevel' => { 341 => 0x323, 346 => 0x8005, 351 => 0x25 },
	'wbmediaimagesizesetting' => { 87 => 0x708 },
	'wbmode' => { 192 => 0x4, 328 => 0x1015 },
	'wbredlevel' => { 341 => 0x322, 346 => 0x8004, 351 => 0x24 },
	'wbscale' => { 193 => 0x0 },
	'wbshiftab' => { 76 => 0xc, 346 => 0x46, 363 => 0x10 },
	'wbshiftab_gm' => { 446 => 0x2014 },
	'wbshiftab_gm_precise' => { 446 => 0x2026 },
	'wbshiftcreativecontrol' => { 346 => 0x92 },
	'wbshiftgm' => { 76 => 0xd, 346 => 0x47, 363 => 0x11 },
	'wbshiftintelligentauto' => { 346 => 0x8b },
	'wbtype1' => { 352 => 0x1, 353 => 0x1 },
	'wbtype2' => { 352 => 0x4, 353 => 0x5 },
	'wbtype3' => { 352 => 0x7, 353 => 0x9 },
	'wbtype4' => { 352 => 0xa, 353 => 0xd },
	'wbtype5' => { 352 => 0xd, 353 => 0x11 },
	'wbtype6' => { 352 => 0x10, 353 => 0x15 },
	'wbtype7' => { 352 => 0x13, 353 => 0x19 },
	'webstatement' => { 540 => 'WebStatement' },
	'weightedflatsubject' => { 499 => 'weightedFlatSubject' },
	'what' => { 507 => 'What', 509 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 76 => 0x8, 79 => 0x7, 115 => 0x7, 116 => [0x19,0x2012], 122 => [0xa403,0xfe4e], 130 => 0x1002, 141 => 0x3fc, 142 => 0xfa0d, 143 => 0x40, 154 => 0x1a, 184 => 0x3, 185 => 0xe, 186 => 0x4, 187 => 0xb, 189 => 0x115, 239 => 0x5, 285 => 0x7, 341 => 0x304, 346 => 0x3, 348 => 0x3033, 381 => 0x19, 388 => 0x7, 412 => 0x26, 413 => 0x1003, 423 => [0x88,0x3c,0x7,0x58], 433 => 0xf, 434 => 0xe, 446 => [0x115,0xb054], 507 => 'WhiteBalance', 509 => 'WhiteBalance', 513 => 'WhiteBalance' },
	'whitebalance0' => { 179 => 'WhiteBalance0' },
	'whitebalance1' => { 179 => 'WhiteBalance1' },
	'whitebalance2' => { 179 => 'WhiteBalance2', 323 => 0x500 },
	'whitebalanceadj' => { 106 => 0x20101, 111 => 0x18, 296 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 359 => 0x0 },
	'whitebalancebias' => { 116 => 0x2011, 328 => 0x304, 346 => 0x23 },
	'whitebalanceblue' => { 76 => 0x7 },
	'whitebalancebracket' => { 323 => 0x502, 328 => 0x303 },
	'whitebalancebracketing' => { 187 => 0x22, 190 => 0x2c, 444 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 320 => 0x1c5, 321 => 0x1dd },
	'whitebalancecomp' => { 331 => 0x1001 },
	'whitebalancedetected' => { 141 => 0x3fb },
	'whitebalancefinetune' => { 130 => 0x100a, 187 => 0x38, 189 => 0x112, 239 => [0xb,0x3f], 413 => 0x1004, 433 => 0x6, 434 => 0x5, 446 => 0x112 },
	'whitebalancemode' => { 141 => 0x3fa, 381 => 0x1a },
	'whitebalancered' => { 76 => 0x6 },
	'whitebalanceset' => { 362 => 0xa },
	'whitebalancesetting' => { 187 => 0x23, 433 => 0x5, 434 => 0x4, 435 => 0x16, 451 => 0xd },
	'whitebalancesetup' => { 420 => 0x41 },
	'whitebalancetemperature' => { 323 => 0x501 },
	'whiteboard' => { 328 => 0x301 },
	'whitelevel' => { 122 => 0xc61d, 381 => 0x7e, 453 => 0x787f },
	'whitepoint' => { 122 => 0x13e, 345 => 0x35d, 381 => 0x201, 532 => 'WhitePoint' },
	'whites2012' => { 507 => 'Whites2012', 509 => 'Whites2012' },
	'whitesadj' => { 483 => 0x9017 },
	'wideadapter' => { 413 => 0x1017 },
	'widefocuszone' => { 184 => 0x2f },
	'widerange' => { 422 => 0x20f },
	'windmode' => { 141 => 0x3f4 },
	'windnoisereduction' => { 244 => 0x352, 245 => 0x2d6, 246 => 0x2fe, 247 => 0x2fe },
	'windowlocation' => { 406 => 'WLOC' },
	'windowsatom' => { 508 => 'windowsAtom' },
	'windowsatomextension' => { 508 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 508 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 508 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 526 => 'wordCount' },
	'work' => { 398 => "\xa9wrk" },
	'workcolorspace' => { 106 => 0x10200, 111 => 0x270 },
	'workflowtag' => { 521 => 'WorkflowTag' },
	'workflowtagcvid' => { 521 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 521 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 521 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 521 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 515 => 'WorkToDo' },
	'worldtimelocation' => { 346 => 0x3a, 381 => 0x22, 387 => '0.1' },
	'writer' => { 182 => 'WM/Writer' },
	'writer-editor' => { 134 => 0x7a },
	'x3filllight' => { 423 => 0x12 },
	'xattrquarantine' => { 177 => 'com.apple.quarantine' },
	'xilinxversion' => { 141 => 0x414 },
	'xml' => { 139 => 'xml ' },
	'xmp' => { 109 => 0xffff00f6, 123 => 'XMP' },
	'xmptoolkit' => { 533 => 'xmptk' },
	'xpauthor' => { 122 => 0x9c9d },
	'xpcomment' => { 122 => 0x9c9c },
	'xpkeywords' => { 122 => 0x9c9e },
	'xposition' => { 122 => 0x11e },
	'xpsubject' => { 122 => 0x9c9f },
	'xptitle' => { 122 => 0x9c9b },
	'xresolution' => { 122 => 0x11a, 137 => 0x3, 396 => 0x0, 532 => 'XResolution' },
	'xyresolution' => { 126 => 0x3 },
	'yaw' => { 118 => 0x7, 406 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 252 => 0x8, 418 => 0x0 },
	'ycbcrcoefficients' => { 122 => 0x211, 532 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 122 => 0x213, 532 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 122 => 0x212, 532 => 'YCbCrSubSampling' },
	'year' => { 398 => 'yrrc', 400 => 'year', 406 => 'yrrc' },
	'yearcreated' => { 143 => 0x10, 152 => 0xc },
	'yellowhsl' => { 106 => 0x20912 },
	'yield' => { 528 => 'yield' },
	'yposition' => { 122 => 0x11f },
	'yresolution' => { 122 => 0x11b, 137 => 0x5, 396 => 0x4, 532 => 'YResolution' },
	'zebrapatterntonerange' => { 319 => 0x211, 320 => 0x211, 321 => 0x229 },
	'zoneidentifier' => { 123 => 'ZoneIdentifier' },
	'zonematching' => { 189 => 0x10a, 192 => [0x3a,0x4a], 446 => 0xb024 },
	'zonematchingmode' => { 187 => 0x14 },
	'zonematchingon' => { 186 => 0x75 },
	'zonematchingvalue' => { 433 => 0x1f },
	'zoomedpreviewlength' => { 328 => 0xf05 },
	'zoomedpreviewsize' => { 328 => 0xf06 },
	'zoomedpreviewstart' => { 328 => 0xf04 },
	'zoomsourcewidth' => { 36 => 0x24 },
	'zoomstepcount' => { 326 => 0x300, 328 => 0x100d },
	'zoomtargetwidth' => { 36 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
