#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 111 => 0x69 },
	'about' => { 525 => 'about' },
	'aboutcvterm' => { 516 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 516 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 516 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 516 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 516 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 118 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 531 => 'absPeakAudioFilePath' },
	'academicfield' => { 521 => 'academicField' },
	'acceleration' => { 121 => 0x9404, 509 => 'Acceleration' },
	'accelerationtracking' => { 86 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 412 => 0x3 },
	'accelerometerdata' => { 402 => 'vrot' },
	'accelerometerx' => { 342 => 0x8d },
	'accelerometery' => { 342 => 0x8e },
	'accelerometerz' => { 342 => 0x8c },
	'accessoryserialnumber' => { 342 => 0x54 },
	'accessorytype' => { 342 => 0x53 },
	'actionadvised' => { 133 => 0x2a },
	'activearea' => { 121 => 0xc68d },
	'actived-lighting' => { 236 => 0x22, 290 => 0x24 },
	'actived-lightingmode' => { 290 => 0x25 },
	'adaptervoltage' => { 140 => 0x407 },
	'addaspectratioinfo' => { 86 => 0x80e },
	'addiptcinformation' => { 86 => 0x815 },
	'additionalmodelinformation' => { 516 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 86 => 0x80f, 87 => 0x11, 88 => 0x13, 91 => 0x14 },
	'address' => { 163 => 'Address' },
	'adjustmentmode' => { 419 => 0x15 },
	'adlbracketingstep' => { 200 => 0x17 },
	'adlbracketingtype' => { 200 => 0x18 },
	'adobe' => { 122 => 'Adobe' },
	'adultcontentwarning' => { 329 => 'AdultContentWarning', 524 => 'adultContentWarning' },
	'advancedfilter' => { 129 => 0x1201 },
	'advancedraw' => { 292 => 0x76a43203 },
	'advancedscenetype' => { 342 => 0x3d },
	'advisory' => { 529 => 'Advisory' },
	'ae_iso' => { 350 => 0x2, 351 => 0x4, 352 => 0x12 },
	'aeaperture' => { 350 => 0x1, 351 => 0x3, 352 => 0x11 },
	'aeaperturesteps' => { 350 => 0x8, 351 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 86 => 0x104 },
	'aebbracketvalue' => { 78 => 0x11 },
	'aebracketingsteps' => { 200 => 0xf, 201 => 0xf, 273 => 0x174c },
	'aebsequence' => { 86 => 0x105 },
	'aebsequenceautocancel' => { 84 => 0x9, 85 => 0x9, 87 => 0x8, 88 => 0x9, 91 => 0x9, 92 => 0x7 },
	'aebshotcount' => { 86 => 0x106 },
	'aebxv' => { 350 => 0x4, 351 => 0x6 },
	'aeerror' => { 351 => 0x8 },
	'aeexposuretime' => { 350 => 0x0, 351 => 0x2, 352 => 0x10 },
	'aelbutton' => { 186 => 0x45 },
	'aelexposureindicator' => { 186 => 0x51 },
	'aelock' => { 186 => 0x5b, 301 => '4.2', 310 => '4.2', 319 => 0x201, 377 => 0x48, 429 => 0x40, 430 => 0x40, 431 => [0x86,0x286] },
	'aelockbutton' => { 299 => '16.1', 301 => '4.1', 304 => '15.1', 305 => '16.1', 306 => '16.1', 308 => '30.1', 309 => '16.1', 310 => '4.1', 312 => '17.1', 314 => '17.1' },
	'aelockbuttonplusdials' => { 299 => '16.2', 308 => '32.1', 312 => '44.1' },
	'aelockformb-d80' => { 314 => '3.1' },
	'aelockmetermodeafterfocus' => { 86 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 350 => 0x9, 351 => 0x10, 352 => 0x1c },
	'aemaxaperture2' => { 350 => 0xa, 351 => 0x11, 352 => 0x1d },
	'aemeteringmode' => { 350 => 0xc },
	'aemeteringmode2' => { 350 => '13.1' },
	'aemeteringsegments' => { 189 => 0x628, 377 => 0x209 },
	'aemicroadjustment' => { 86 => 0x110 },
	'aeminaperture' => { 350 => 0xb, 351 => 0x12, 352 => 0x1e },
	'aeminexposuretime' => { 350 => 0x5, 351 => 0x13, 352 => 0x1f },
	'aeprogrammode' => { 350 => 0x6 },
	'aeprojectlink' => { 503 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 503 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 503 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 503 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 503 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 503 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 35 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 350 => 0xd },
	'aexv' => { 350 => 0x3, 351 => 0x5 },
	'af-assistilluminator' => { 315 => 0x19, 316 => 0x19, 317 => 0x19 },
	'af-cfocusdisplay' => { 315 => 0x234, 316 => 0x234, 317 => 0x24c },
	'af-cpriority' => { 130 => '0.2' },
	'af-cpriorityselection' => { 299 => '1.1', 300 => '1.1', 302 => '1.1', 303 => '1.1', 305 => '0.1', 306 => '0.1', 307 => '0.1', 308 => '1.1', 309 => '0.1', 312 => '1.1', 313 => '1.1', 315 => 0x3, 316 => 0x3, 317 => 0x3 },
	'af-csetting' => { 126 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 126 => '0.2' },
	'af-ctrackingsensitivity' => { 126 => '0.1' },
	'af-czoneareaswitching' => { 126 => '0.3' },
	'af-onbutton' => { 302 => '70.1', 303 => '70.1', 313 => '70.1' },
	'af-onformb-d10' => { 299 => '3.3', 308 => '3.2' },
	'af-onformb-d11' => { 309 => '2.2' },
	'af-onformb-d12' => { 312 => '50.1' },
	'af-onoutoffocusrelease' => { 315 => 0x10, 316 => 0x10, 317 => 0x10 },
	'af-spriority' => { 130 => '0.1' },
	'af-spriorityselection' => { 299 => '1.2', 300 => '1.2', 302 => '1.2', 303 => '1.2', 307 => '0.2', 308 => '1.2', 309 => '0.2', 312 => '1.2', 313 => '1.2', 315 => 0x5, 316 => 0x5, 317 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 299 => '2.1', 300 => '2.1', 302 => '78.3', 303 => '78.3', 308 => '2.1', 312 => '2.1', 313 => '78.3', 315 => 0xf, 316 => 0xf, 317 => 0xf },
	'afadjustment' => { 377 => 0x72, 386 => 0x267 },
	'afandmeteringbuttons' => { 86 => 0x701 },
	'afaperture' => { 229 => 0x5, 230 => 0x5, 234 => 0x5 },
	'afareaheight' => { 195 => [0x1a,0x34,0x50], 196 => 0x48 },
	'afareaillumination' => { 186 => 0x4b, 310 => '15.3' },
	'afareainitialheight' => { 248 => 0xbeb },
	'afareainitialwidth' => { 248 => 0xbea },
	'afareainitialxposition' => { 248 => 0xbe8 },
	'afareainitialyposition' => { 248 => 0xbe9 },
	'afareamode' => { 128 => '0.3', 182 => 0x33, 186 => 0xe, 194 => 0x0, 195 => 0x5, 196 => 0x5, 241 => 0x224, 242 => 0x210, 243 => 0x224, 244 => 0x224, 342 => 0xf, 409 => 0x1205, 422 => [0xa,0x3a], 429 => 0x11, 430 => 0x10, 431 => 0x24, 442 => 0xb043, 468 => 0x17 },
	'afareamodesetting' => { 301 => '11.1', 304 => '0.1', 310 => '16.1', 314 => '2.1', 442 => 0x201c },
	'afareapointsize' => { 128 => '0.4' },
	'afareas' => { 319 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 86 => 0x51b },
	'afareawidth' => { 195 => [0x18,0x32,0x4e], 196 => 0x46 },
	'afareaxposition' => { 195 => [0x14,0x2e,0x4a], 196 => 0x42, 409 => 0x1203 },
	'afareaxposition1' => { 409 => 0x1201 },
	'afareayposition' => { 195 => [0x16,0x30,0x4c], 196 => 0x44, 409 => 0x1204 },
	'afareayposition1' => { 409 => 0x1202 },
	'afareazonesize' => { 128 => '0.5' },
	'afassist' => { 84 => 0x5, 92 => 0x5, 186 => 0x48, 299 => '2.5', 301 => '0.2', 304 => '0.2', 305 => '1.1', 306 => '1.1', 307 => '1.3', 308 => '2.4', 309 => '1.3', 310 => '0.2', 312 => '2.4', 314 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 86 => 0x50e, 87 => 0x4, 88 => 0x5, 89 => 0x4, 90 => 0x4, 91 => 0x5 },
	'afassistlamp' => { 342 => 0x31 },
	'afbuttonpressed' => { 431 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 353 => 0x6 },
	'afduringliveview' => { 86 => 0x511 },
	'affinea' => { 496 => 'AffineA' },
	'affineb' => { 496 => 'AffineB' },
	'affinec' => { 496 => 'AffineC' },
	'affined' => { 496 => 'AffineD' },
	'affinetune' => { 197 => 0x0, 241 => 0x6b0, 242 => 0x5b0, 243 => 0x5e0, 244 => 0x5f8, 319 => 0x306 },
	'affinetuneadj' => { 197 => 0x2, 266 => 0x2d1, 267 => 0x2dc, 319 => 0x307 },
	'affinetuneadjtele' => { 197 => 0x3 },
	'affinetuneindex' => { 197 => 0x1 },
	'affinex' => { 496 => 'AffineX' },
	'affiney' => { 496 => 'AffineY' },
	'afhold' => { 353 => 0x1fd },
	'afilluminator' => { 429 => 0x29, 442 => 0xb044 },
	'afimageheight' => { 195 => [0x12,0x2c,0x48], 196 => 0x40 },
	'afimagewidth' => { 195 => [0x10,0x2a,0x46], 196 => 0x3e },
	'afintegrationtime' => { 353 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 422 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 426 => 0x131 },
	'afmicroadjregisteredlenses' => { 426 => '305.1' },
	'afmicroadjustment' => { 86 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 426 => 0x130 },
	'afmode' => { 115 => 0x3009, 129 => 0x1022, 182 => 0x16, 419 => 0x5 },
	'afmoderestrictions' => { 300 => '50.3', 302 => '48.3', 303 => '48.3', 312 => '48.3', 313 => '48.3' },
	'afonaelockbuttonswitch' => { 86 => 0x702 },
	'afonbutton' => { 299 => '3.1', 300 => '47.1', 315 => 0x83, 316 => 0x83, 317 => 0x83 },
	'afpoint' => { 35 => 0x13, 114 => 0x18, 182 => 0x15, 194 => 0x1, 322 => 0x308, 419 => 0x1f, 422 => [0x37,0x7], 426 => 0x19, 427 => 0x18, 428 => [0x18,0x20] },
	'afpointactivationarea' => { 85 => 0x11, 91 => 0x11 },
	'afpointareaexpansion' => { 86 => 0x508 },
	'afpointatshutterrelease' => { 422 => [0x39,0x9] },
	'afpointautoselection' => { 86 => 0x50b },
	'afpointbrightness' => { 86 => 0x50d, 299 => '2.4', 300 => '46.5', 302 => '2.2', 303 => '2.2', 312 => '2.3', 313 => '2.2' },
	'afpointdetails' => { 322 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 86 => 0x50c },
	'afpointillumination' => { 85 => 0xa, 299 => '2.3', 300 => '46.2', 302 => '47.2', 303 => '47.2', 307 => '1.2', 308 => '2.3', 309 => '1.2', 312 => '47.2', 313 => '47.2', 314 => '2.4' },
	'afpointinfocus' => { 422 => [0x38,0x8] },
	'afpointmode' => { 358 => 0x3 },
	'afpointposition' => { 115 => 0x2021, 342 => 0x4d },
	'afpointregistration' => { 84 => 0x7 },
	'afpoints' => { 185 => 0x10 },
	'afpointsel' => { 315 => 0xb, 316 => 0xb, 317 => 0xb },
	'afpointselected' => { 186 => 0xd, 319 => 0x305, 377 => 0xe, 426 => 0x15, 427 => 0x14, 428 => [0x14,0x1c], 442 => 0x201e },
	'afpointselected2' => { 358 => 0x4 },
	'afpointselection' => { 85 => 0xb, 299 => '1.3', 300 => '1.3', 308 => '1.3', 312 => '1.3', 313 => '1.3' },
	'afpointselectionmethod' => { 86 => 0x50f, 87 => 0xc, 88 => 0xd, 91 => 0xd },
	'afpointsetting' => { 429 => 0x12, 430 => 0x11 },
	'afpointsinfocus' => { 78 => 0xe, 194 => 0x2, 195 => 0x30, 353 => 0xb, 354 => 0x4, 377 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 85 => 0xd },
	'afpointsselected' => { 195 => 0x1c, 354 => '4.1', 476 => 0x4 },
	'afpointsspecial' => { 354 => '4.2' },
	'afpointsunknown1' => { 353 => 0x0 },
	'afpointsunknown2' => { 353 => 0x2 },
	'afpointsused' => { 195 => [0xa,0x8], 196 => 0xa, 422 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 353 => 0x4 },
	'afresponse' => { 236 => 0xad },
	'afresult' => { 324 => 0x1038 },
	'afsearch' => { 319 => 0x303 },
	'afsensoractive' => { 182 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 409 => 0x1200 },
	'afstatus_00_b4' => { 425 => 0x0 },
	'afstatus_01_c4' => { 425 => 0x2 },
	'afstatus_02_d4' => { 425 => 0x4 },
	'afstatus_03_e4' => { 425 => 0x6 },
	'afstatus_04_f4' => { 425 => 0x8 },
	'afstatus_05_g4' => { 425 => 0xa },
	'afstatus_06_h4' => { 425 => 0xc },
	'afstatus_07_b3' => { 425 => 0xe },
	'afstatus_08_c3' => { 425 => 0x10 },
	'afstatus_09_d3' => { 425 => 0x12 },
	'afstatus_10_e3' => { 425 => 0x14 },
	'afstatus_11_f3' => { 425 => 0x16 },
	'afstatus_12_g3' => { 425 => 0x18 },
	'afstatus_13_h3' => { 425 => 0x1a },
	'afstatus_14_b2' => { 425 => 0x1c },
	'afstatus_15_c2' => { 425 => 0x1e },
	'afstatus_16_d2' => { 425 => 0x20 },
	'afstatus_17_e2' => { 425 => 0x22 },
	'afstatus_18_f2' => { 425 => 0x24 },
	'afstatus_19_g2' => { 425 => 0x26 },
	'afstatus_20_h2' => { 425 => 0x28 },
	'afstatus_21_c1' => { 425 => 0x2a },
	'afstatus_22_d1' => { 425 => 0x2c },
	'afstatus_23_e1' => { 425 => 0x2e },
	'afstatus_24_f1' => { 425 => 0x30 },
	'afstatus_25_g1' => { 425 => 0x32 },
	'afstatus_26_a7_vertical' => { 425 => 0x34 },
	'afstatus_27_a6_vertical' => { 425 => 0x36 },
	'afstatus_28_a5_vertical' => { 425 => 0x38 },
	'afstatus_29_c7_vertical' => { 425 => 0x3a },
	'afstatus_30_c6_vertical' => { 425 => 0x3c },
	'afstatus_31_c5_vertical' => { 425 => 0x3e },
	'afstatus_32_e7_vertical' => { 425 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 425 => 0x42 },
	'afstatus_34_e5_vertical' => { 425 => 0x44 },
	'afstatus_35_g7_vertical' => { 425 => 0x46 },
	'afstatus_36_g6_vertical' => { 425 => 0x48 },
	'afstatus_37_g5_vertical' => { 425 => 0x4a },
	'afstatus_38_i7_vertical' => { 425 => 0x4c },
	'afstatus_39_i6_vertical' => { 425 => 0x4e },
	'afstatus_40_i5_vertical' => { 425 => 0x50 },
	'afstatus_41_a7' => { 425 => 0x52 },
	'afstatus_42_b7' => { 425 => 0x54 },
	'afstatus_43_c7' => { 425 => 0x56 },
	'afstatus_44_d7' => { 425 => 0x58 },
	'afstatus_45_e7' => { 425 => 0x5a },
	'afstatus_46_f7' => { 425 => 0x5c },
	'afstatus_47_g7' => { 425 => 0x5e },
	'afstatus_48_h7' => { 425 => 0x60 },
	'afstatus_49_i7' => { 425 => 0x62 },
	'afstatus_50_a6' => { 425 => 0x64 },
	'afstatus_51_b6' => { 425 => 0x66 },
	'afstatus_52_c6' => { 425 => 0x68 },
	'afstatus_53_d6' => { 425 => 0x6a },
	'afstatus_54_e6_center' => { 425 => 0x6c },
	'afstatus_55_f6' => { 425 => 0x6e },
	'afstatus_56_g6' => { 425 => 0x70 },
	'afstatus_57_h6' => { 425 => 0x72 },
	'afstatus_58_i6' => { 425 => 0x74 },
	'afstatus_59_a5' => { 425 => 0x76 },
	'afstatus_60_b5' => { 425 => 0x78 },
	'afstatus_61_c5' => { 425 => 0x7a },
	'afstatus_62_d5' => { 425 => 0x7c },
	'afstatus_63_e5' => { 425 => 0x7e },
	'afstatus_64_f5' => { 425 => 0x80 },
	'afstatus_65_g5' => { 425 => 0x82 },
	'afstatus_66_h5' => { 425 => 0x84 },
	'afstatus_67_i5' => { 425 => 0x86 },
	'afstatus_68_c11' => { 425 => 0x88 },
	'afstatus_69_d11' => { 425 => 0x8a },
	'afstatus_70_e11' => { 425 => 0x8c },
	'afstatus_71_f11' => { 425 => 0x8e },
	'afstatus_72_g11' => { 425 => 0x90 },
	'afstatus_73_b10' => { 425 => 0x92 },
	'afstatus_74_c10' => { 425 => 0x94 },
	'afstatus_75_d10' => { 425 => 0x96 },
	'afstatus_76_e10' => { 425 => 0x98 },
	'afstatus_77_f10' => { 425 => 0x9a },
	'afstatus_78_g10' => { 425 => 0x9c },
	'afstatus_79_h10' => { 425 => 0x9e },
	'afstatus_80_b9' => { 425 => 0xa0 },
	'afstatus_81_c9' => { 425 => 0xa2 },
	'afstatus_82_d9' => { 425 => 0xa4 },
	'afstatus_83_e9' => { 425 => 0xa6 },
	'afstatus_84_f9' => { 425 => 0xa8 },
	'afstatus_85_g9' => { 425 => 0xaa },
	'afstatus_86_h9' => { 425 => 0xac },
	'afstatus_87_b8' => { 425 => 0xae },
	'afstatus_88_c8' => { 425 => 0xb0 },
	'afstatus_89_d8' => { 425 => 0xb2 },
	'afstatus_90_e8' => { 425 => 0xb4 },
	'afstatus_91_f8' => { 425 => 0xb6 },
	'afstatus_92_g8' => { 425 => 0xb8 },
	'afstatus_93_h8' => { 425 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 425 => 0xbc },
	'afstatusactivesensor' => { 182 => 0x2, 422 => [0x4,0x3b], 426 => 0x1e, 427 => 0x1b, 428 => [0x1b,0x21] },
	'afstatusbottom' => { 182 => 0x8, 426 => 0x2a, 427 => 0x21, 428 => 0x21 },
	'afstatusbottom-left' => { 182 => 0x12, 427 => 0x2b, 428 => 0x2b },
	'afstatusbottom-right' => { 182 => 0x6, 427 => 0x1f, 428 => 0x1f },
	'afstatusbottomassist-left' => { 426 => 0x28 },
	'afstatusbottomassist-right' => { 426 => 0x2c },
	'afstatusbottomhorizontal' => { 423 => 0x10, 424 => 0x1c },
	'afstatusbottomvertical' => { 423 => 0x16, 424 => 0x26 },
	'afstatuscenter-10' => { 426 => 0x34 },
	'afstatuscenter-11' => { 426 => 0x36 },
	'afstatuscenter-12' => { 426 => 0x38 },
	'afstatuscenter-14' => { 426 => 0x3c },
	'afstatuscenter-7' => { 426 => 0x2e },
	'afstatuscenter-9' => { 426 => 0x32 },
	'afstatuscenter-horizontal' => { 426 => 0x30 },
	'afstatuscenter-vertical' => { 426 => 0x3a },
	'afstatuscenterf2-8' => { 426 => 0x4c },
	'afstatuscenterhorizontal' => { 182 => 0x2f, 423 => 0xc, 424 => 0x18, 427 => 0x2f, 428 => 0x2f },
	'afstatuscentervertical' => { 182 => 0xc, 423 => 0x14, 424 => 0x22, 427 => 0x25, 428 => 0x25 },
	'afstatusfarleft' => { 423 => 0x6, 426 => 0x26 },
	'afstatusfarlefthorizontal' => { 424 => 0x4 },
	'afstatusfarleftvertical' => { 424 => 0x12 },
	'afstatusfarright' => { 423 => 0x18, 426 => 0x44 },
	'afstatusfarrighthorizontal' => { 424 => 0x2c },
	'afstatusfarrightvertical' => { 424 => 0x34 },
	'afstatusleft' => { 182 => 0x2d, 423 => 0x2, 426 => 0x22, 427 => 0x2d, 428 => 0x2d },
	'afstatuslefthorizontal' => { 424 => 0x6 },
	'afstatusleftvertical' => { 424 => 0xe },
	'afstatuslower-left' => { 423 => 0x4, 426 => 0x24 },
	'afstatuslower-lefthorizontal' => { 424 => 0xa },
	'afstatuslower-leftvertical' => { 424 => 0x10 },
	'afstatuslower-middle' => { 423 => 0x22, 424 => 0x24 },
	'afstatuslower-right' => { 423 => 0x1e, 426 => 0x4a },
	'afstatuslower-righthorizontal' => { 424 => 0x32 },
	'afstatuslower-rightvertical' => { 424 => 0x3a },
	'afstatuslowerfarleft' => { 424 => 0x8 },
	'afstatuslowerfarright' => { 424 => 0x30 },
	'afstatusmiddlehorizontal' => { 182 => 0xa, 427 => 0x23, 428 => 0x23 },
	'afstatusnearleft' => { 423 => 0xe, 424 => 0x1a },
	'afstatusnearright' => { 423 => 0xa, 424 => 0x16 },
	'afstatusright' => { 182 => 0x31, 423 => 0x1c, 426 => 0x48, 427 => 0x31, 428 => 0x31 },
	'afstatusrighthorizontal' => { 424 => 0x2e },
	'afstatusrightvertical' => { 424 => 0x38 },
	'afstatustop' => { 182 => 0xe, 426 => 0x40, 427 => 0x27, 428 => 0x27 },
	'afstatustop-left' => { 182 => 0x10, 427 => 0x29, 428 => 0x29 },
	'afstatustop-right' => { 182 => 0x4, 427 => 0x1d, 428 => 0x1d },
	'afstatustopassist-left' => { 426 => 0x3e },
	'afstatustopassist-right' => { 426 => 0x42 },
	'afstatustophorizontal' => { 423 => 0x8, 424 => 0x14 },
	'afstatustopvertical' => { 423 => 0x12, 424 => 0x1e },
	'afstatusupper-left' => { 423 => 0x0, 426 => 0x20 },
	'afstatusupper-lefthorizontal' => { 424 => 0x2 },
	'afstatusupper-leftvertical' => { 424 => 0xc },
	'afstatusupper-middle' => { 423 => 0x20, 424 => 0x20 },
	'afstatusupper-right' => { 423 => 0x1a, 426 => 0x46 },
	'afstatusupper-righthorizontal' => { 424 => 0x2a },
	'afstatusupper-rightvertical' => { 424 => 0x36 },
	'afstatusupperfarleft' => { 424 => 0x0 },
	'afstatusupperfarright' => { 424 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 442 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 422 => 0x2 },
	'afwithshutter' => { 429 => 0x2a },
	'aggregateissuenumber' => { 521 => 'aggregateIssueNumber' },
	'aggregationtype' => { 521 => 'aggregationType' },
	'agreement' => { 524 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 140 => 0xe4e },
	'airplanemode' => { 241 => 0x722, 242 => 0x624, 243 => 0x654, 244 => 0x6bc },
	'aiservocontinuousshooting' => { 85 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 86 => 0x519 },
	'aiservoimagepriority' => { 86 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 86 => 0x51a },
	'aiservotrackingmethod' => { 86 => 0x504 },
	'aiservotrackingsensitivity' => { 85 => 0x14, 86 => 0x502 },
	'aisubjecttrackingmode' => { 319 => 0x309 },
	'album' => { 394 => ['albm',"\xa9alb"], 396 => 'album', 402 => ['albm',"\xa9alb"], 531 => 'album' },
	'albumartist' => { 181 => 'WM/AlbumArtist', 394 => 'aART', 402 => 'albr' },
	'albumcoverurl' => { 181 => 'WM/AlbumCoverURL' },
	'albumid' => { 394 => 'plID' },
	'albumtitle' => { 181 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 502 => 'AlreadyApplied', 504 => 'AlreadyApplied' },
	'alternatetitle' => { 521 => 'alternateTitle' },
	'alternatetitlea-lang' => { 521 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 521 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 521 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 199 => 0x6 },
	'alttapename' => { 531 => 'altTapeName' },
	'alttextaccessibility' => { 515 => 'AltTextAccessibility' },
	'alttimecode' => { 531 => 'altTimecode' },
	'alttimecodetimeformat' => { 531 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 531 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 531 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 405 => 0x5c },
	'ambientlight' => { 405 => 0x5e },
	'ambienttemperature' => { 121 => 0x9400, 403 => 0x14, 404 => 0x46, 405 => 0x50, 468 => 0x4, 509 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 403 => 0x13, 404 => 0x44, 405 => 0x4e },
	'analogbalance' => { 121 => 0xc627 },
	'analogcaptureiso' => { 140 => 0x89e },
	'analogisotable' => { 140 => 0x89d },
	'androidversion' => { 396 => 'com.android.version' },
	'angleadj' => { 105 => 0x10003, 111 => 0x8b },
	'angleinforoll' => { 498 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 498 => 'AngleInfoYaw' },
	'anti-blur' => { 442 => 0xb04b },
	'antialiasstrength' => { 121 => 0xc632 },
	'aperturelock' => { 300 => '38.2', 302 => '38.2', 303 => '38.2', 312 => '38.2', 313 => '38.2', 315 => 0xb8, 316 => 0xb8, 317 => 0xb8 },
	'aperturemode' => { 402 => 'apmd' },
	'aperturerange' => { 86 => 0x10d },
	'apertureringuse' => { 358 => '1.4' },
	'aperturesetting' => { 186 => 0x7, 429 => 0x30, 430 => 0x29, 431 => 0x1 },
	'aperturevalue' => { 95 => 0x2, 121 => 0x9202, 324 => 0x1002, 386 => 0x401, 508 => 'ApertureValue' },
	'appinfo' => { 481 => 'AppInfo' },
	'appinfoapplication' => { 481 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 481 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 481 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 328 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 396 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 394 => 'apID' },
	'applestoreaccounttype' => { 394 => 'akID' },
	'applestorecatalogid' => { 394 => 'cnID' },
	'applestorecountry' => { 394 => 'sfID' },
	'applicationkeystring' => { 140 => 0x400 },
	'applicationnotes' => { 121 => 0x2bc, 347 => 0x2bc },
	'applicationrecordversion' => { 133 => 0x0 },
	'applyshootingmeteringmode' => { 86 => 0x10e },
	'approved' => { 510 => 'Approved' },
	'approvedby' => { 510 => 'ApprovedBy' },
	'approximatefnumber' => { 337 => 0x313, 344 => 0x3406 },
	'approximatefocusdistance' => { 499 => 'ApproximateFocusDistance' },
	'appversion' => { 514 => 'AppVersion' },
	'aps-csizecapture' => { 461 => 0x114, 462 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 105 => 0x20914 },
	'armidentifier' => { 134 => 0x78 },
	'armversion' => { 134 => 0x7a },
	'arranger' => { 394 => "\xa9arg", 402 => "\xa9arg" },
	'arrangerkeywords' => { 402 => "\xa9ark" },
	'artdirector' => { 394 => "\xa9ard" },
	'artfilter' => { 319 => 0x529 },
	'artfiltereffect' => { 319 => 0x52f },
	'artist' => { 121 => 0x13b, 332 => 'Artist', 347 => 0x13b, 377 => 0x22e, 394 => "\xa9ART", 396 => 'artist', 402 => "\xa9ART", 527 => 'Artist', 531 => 'artist' },
	'artistid' => { 394 => 'atID' },
	'artmode' => { 115 => 0x301b },
	'artmodeparameters' => { 115 => 0x310b },
	'artwork' => { 396 => 'artwork' },
	'artworkcircadatecreated' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 516 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 516 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 323 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 323 => 0x1112, 377 => 0x80, 429 => 0x55, 430 => 0x55, 431 => 0xa, 455 => [0x192c,0x1a88], 456 => 0x192c, 457 => 0x1958, 458 => 0x192c, 459 => 0x188c },
	'assetid' => { 492 => 'AssetID' },
	'asshoticcprofile' => { 121 => 0xc68f },
	'asshotneutral' => { 121 => 0xc628 },
	'asshotpreprofilematrix' => { 121 => 0xc690 },
	'asshotprofilename' => { 121 => 0xc6f6 },
	'asshotwhitexy' => { 121 => 0xc629 },
	'assignbktbutton' => { 299 => '4.2', 300 => '16.1', 302 => '16.1', 303 => '16.1', 312 => '16.1', 313 => '16.1' },
	'assignfuncbutton' => { 86 => 0x70b },
	'assignmb-d17af-onbutton' => { 303 => '79.1' },
	'assignmb-d17funcbutton' => { 303 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 303 => '68.1' },
	'assignmb-d18af-onbutton' => { 313 => '79.1' },
	'assignmb-d18funcbutton' => { 313 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 313 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 302 => '75.1', 303 => '75.1', 313 => '75.1' },
	'assignmoviefunc2button' => { 302 => '82.1', 303 => '82.1', 313 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 302 => '75.2', 303 => '75.2', 313 => '75.2' },
	'assignmovierecordbutton' => { 300 => '43.2', 312 => '45.1', 315 => 0x9b, 316 => 0x9b, 317 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 302 => '45.1', 303 => '45.1', 313 => '45.1' },
	'assignmoviesubselector' => { 302 => '74.1', 303 => '74.1', 313 => '74.1' },
	'assignmoviesubselectorplusdials' => { 302 => '76.1', 303 => '76.1', 313 => '76.1' },
	'assignremotefnbutton' => { 300 => '54.1', 312 => '51.1' },
	'assistbuttonfunction' => { 84 => 0xd },
	'atcaptureusercrop' => { 140 => 0x943 },
	'attributionname' => { 500 => 'attributionName' },
	'attributionurl' => { 500 => 'attributionURL' },
	'audio' => { 342 => 0x20 },
	'audiobitrate' => { 68 => 0x6c, 516 => 'audioBitRate' },
	'audiobitratemode' => { 516 => 'audioBitRateMode' },
	'audiobitspersample' => { 516 => 'audioBitsPerSample' },
	'audiobutton' => { 316 => 0x17b, 317 => 0x193 },
	'audiobuttonplaybackmode' => { 316 => 0x1b9, 317 => 0x1d1 },
	'audiochannelcount' => { 516 => 'audioChannelCount' },
	'audiochannels' => { 68 => 0x70 },
	'audiochanneltype' => { 531 => 'audioChannelType' },
	'audiocompression' => { 86 => 0x816, 157 => 'Compression' },
	'audiocompressor' => { 531 => 'audioCompressor' },
	'audiodata' => { 484 => 'Data' },
	'audioduration' => { 133 => 0x99 },
	'audiogain' => { 396 => 'player.movie.audio.gain' },
	'audiomimetype' => { 484 => 'Mime' },
	'audiomoddate' => { 531 => 'audioModDate' },
	'audiooutcue' => { 133 => 0x9a },
	'audiosamplerate' => { 68 => 0x6e, 531 => 'audioSampleRate' },
	'audiosampletype' => { 531 => 'audioSampleType' },
	'audiosamplingrate' => { 133 => 0x97 },
	'audiosamplingresolution' => { 133 => 0x98 },
	'audiotype' => { 133 => 0x96 },
	'author' => { 159 => 'Author', 328 => 'Author', 332 => 'Author', 393 => 'Author', 394 => ['auth',"\xa9aut"], 396 => 'author', 402 => 'auth', 497 => 'author', 518 => 'Author', 529 => 'Author' },
	'authorsposition' => { 519 => 'AuthorsPosition' },
	'authorurl' => { 181 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 86 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 368 => '0.1' },
	'autobracket' => { 419 => 0x19 },
	'autobracketing' => { 129 => 0x1100, 377 => 0x18, 409 => 0x1007 },
	'autobracketingmode' => { 311 => '12.3' },
	'autobracketingset' => { 311 => '12.1' },
	'autobracketmodem' => { 299 => '21.2', 300 => '13.3', 302 => '13.2', 303 => '13.2', 308 => '26.2', 312 => '13.3', 313 => '13.2', 315 => 0x5f, 316 => 0x5f, 317 => 0x5f },
	'autobracketorder' => { 186 => 0x43, 299 => '21.3', 300 => '13.2', 302 => '13.1', 303 => '13.1', 308 => '26.3', 309 => '12.2', 310 => '2.2', 311 => '12.2', 312 => '13.2', 313 => '13.1', 314 => '13.2', 315 => 0x61, 316 => 0x61, 317 => 0x61 },
	'autobracketset' => { 299 => '21.1', 300 => '13.1', 304 => '11.1', 305 => '12.1', 306 => '12.1', 308 => '26.1', 309 => '12.1', 310 => '2.1', 312 => '13.1', 314 => '13.1' },
	'autobrightness' => { 502 => 'AutoBrightness', 504 => 'AutoBrightness' },
	'autocapturecriteria' => { 198 => 0x1 },
	'autocapturecriteriamotiondirection' => { 198 => 0x5f },
	'autocapturecriteriamotionsize' => { 198 => 0x64 },
	'autocapturecriteriamotionspeed' => { 198 => 0x63 },
	'autocapturecriteriasubjectsize' => { 198 => 0x69 },
	'autocapturecriteriasubjecttype' => { 198 => 0x6a },
	'autocapturedframe' => { 198 => 0x0 },
	'autocapturedistancefar' => { 198 => 0x4a },
	'autocapturedistancenear' => { 198 => 0x4e },
	'autocapturepreset' => { 244 => 0x746 },
	'autocapturerecordingtime' => { 198 => 0x37 },
	'autocapturewaittime' => { 198 => 0x38 },
	'autocontrast' => { 502 => 'AutoContrast', 504 => 'AutoContrast' },
	'autodistortioncontrol' => { 211 => 0x4, 240 => 0x143 },
	'autodynamicrange' => { 129 => 0x140b },
	'autoexposure' => { 502 => 'AutoExposure', 504 => 'AutoExposure' },
	'autoexposurebracketing' => { 78 => 0x10 },
	'autoflashisosensitivity' => { 302 => '38.5', 303 => '38.5', 313 => '38.5', 315 => 0x5b, 316 => 0x5b, 317 => 0x5b },
	'autofocus' => { 322 => 0x209 },
	'autofocusmoderestrictions' => { 315 => 0x107, 316 => 0x107, 317 => 0x11d },
	'autofp' => { 310 => '7.3', 314 => '31.4' },
	'autoiso' => { 78 => 0x1, 115 => 0x3008, 241 => 0x152, 242 => 0x142, 243 => 0x156, 244 => 0x156, 301 => '1.1', 310 => '1.1' },
	'autoisomax' => { 301 => '1.2', 310 => '1.2' },
	'autoisominshutterspeed' => { 301 => '1.3', 310 => '1.3' },
	'autolateralca' => { 502 => 'AutoLateralCA', 504 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 63 => 0x2, 86 => 0x204, 105 => 0x20500, 111 => 0x6f },
	'autolightingoptimizeron' => { 105 => '0x20500.0', 111 => 0x6e },
	'autoportraitframed' => { 442 => 0x2016 },
	'autoredeye' => { 292 => 0xfe28a44f },
	'autorotate' => { 78 => 0x1b },
	'autoshadows' => { 502 => 'AutoShadows', 504 => 'AutoShadows' },
	'autotone' => { 502 => 'AutoTone', 504 => 'AutoTone' },
	'autotonedigest' => { 502 => 'AutoToneDigest', 504 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 502 => 'AutoToneDigestNoSat', 504 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 502 => 'AutoWhiteVersion', 504 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 236 => 0x82 },
	'avaperturesetting' => { 358 => 0x13 },
	'averageblacklevel' => { 46 => 0xe7, 48 => 0xfb, 49 => 0x114, 50 => 0x146 },
	'averagelv' => { 189 => 0x38 },
	'avsettingwithoutlens' => { 86 => 0x707 },
	'azimuth' => { 167 => 'Azimuth' },
	'babyage' => { 342 => [0x8010,0x33] },
	'babyname' => { 342 => 0x66 },
	'backgroundalpha' => { 526 => 'bgalpha' },
	'balance' => { 396 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 358 => 0x15 },
	'baseiso' => { 78 => 0x2, 99 => 0x101c, 140 => 0x903, 344 => 0x312a, 474 => 0x6 },
	'baseisodaylight' => { 140 => 0x910 },
	'baseisoflash' => { 140 => 0x913 },
	'baseisofluorescent' => { 140 => 0x912 },
	'baseisotungsten' => { 140 => 0x911 },
	'baselineexposure' => { 121 => 0xc62a },
	'baselineexposureoffset' => { 121 => 0xc7a5 },
	'baselinenoise' => { 121 => 0xc62b },
	'baselinesharpness' => { 121 => 0xc62c },
	'baserenditionishdr' => { 513 => 'BaseRenditionIsHDR' },
	'baseurl' => { 529 => 'BaseURL' },
	'bass' => { 396 => 'player.movie.audio.bass' },
	'batterylevel' => { 342 => 0x38, 429 => 0x51, 433 => 0xc, 434 => 0x4, 435 => 0x4, 475 => [0x5,0x7] },
	'batterylevelgrip1' => { 475 => 0x6 },
	'batterylevelgrip2' => { 475 => 0x8 },
	'batteryorder' => { 299 => '12.5', 308 => '13.2', 309 => '2.1', 312 => '3.1' },
	'batterystate' => { 186 => 0x60, 429 => 0x50, 435 => 0x14 },
	'batterytemperature' => { 433 => 0x1, 435 => 0x2, 475 => 0x5 },
	'batterytype' => { 65 => 0x38, 405 => 0x66 },
	'batteryunknown' => { 433 => 0x2, 435 => 0x0 },
	'batteryvoltage' => { 140 => 0x408, 403 => 0x2a, 404 => 0x49, 405 => 0x62, 433 => 0x8 },
	'batteryvoltage1' => { 435 => 0x6 },
	'batteryvoltage2' => { 435 => 0x8 },
	'batteryvoltageavg' => { 405 => 0x64 },
	'bayergreensplit' => { 121 => 0xc62d },
	'bayerpattern' => { 139 => 0xf902, 190 => 0x17 },
	'beatsperminute' => { 394 => 'tmpo' },
	'beatspliceparams' => { 531 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 531 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 531 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 531 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 531 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 531 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 299 => '13.1', 300 => '5.4', 301 => '0.1', 304 => '2.1', 305 => '3.1', 306 => '3.1', 308 => '10.1', 310 => '0.1', 312 => '5.5', 314 => '4.1' },
	'beeppitch' => { 309 => '3.1' },
	'beepvolume' => { 309 => '4.5' },
	'bestqualityscale' => { 121 => 0xc65c },
	'bestshotmode' => { 115 => 0x3007 },
	'bitdepth' => { 164 => 'BitDepth', 190 => 0x11, 259 => 0x41 },
	'bitspercomponent' => { 135 => 0x87 },
	'bitspersample' => { 121 => 0x102, 347 => 0xa, 527 => 'BitsPerSample' },
	'blackacquirerows' => { 140 => 0x18ba },
	'blacklevel' => { 121 => [0x7310,0xc61a], 209 => 0x20, 236 => 0x3d, 324 => [0x401,0x1012], 386 => 0x21d, 449 => [0x7300,0x7310] },
	'blacklevel2' => { 323 => 0x600, 327 => 0x600 },
	'blacklevelblue' => { 347 => 0x1e },
	'blacklevelbottom' => { 140 => 0x3f0 },
	'blackleveldata' => { 386 => 0x223 },
	'blackleveldeltah' => { 121 => 0xc61b },
	'blackleveldeltav' => { 121 => 0xc61c },
	'blacklevelgreen' => { 347 => 0x1d },
	'blacklevelred' => { 347 => 0x1c },
	'blacklevelrepeatdim' => { 121 => 0xc619 },
	'blacklevelrough' => { 140 => 0x40e },
	'blacklevelroughafter' => { 140 => 0x416 },
	'blacklevels' => { 36 => 0x1d },
	'blackleveltop' => { 140 => 0x3ef },
	'blackpoint' => { 377 => 0x200 },
	'blacks2012' => { 502 => 'Blacks2012', 504 => 'Blacks2012' },
	'blacksadj' => { 478 => 0x9018 },
	'bleachbypasstoning' => { 377 => 0x7f },
	'blockshotafresponse' => { 302 => '1.5', 303 => '1.5', 313 => '1.5', 315 => 0x7, 316 => 0x7, 317 => 0x7 },
	'blogtitle' => { 521 => 'blogTitle' },
	'blogurl' => { 521 => 'blogURL' },
	'bluebalance' => { 324 => 0x1018, 347 => 0x12, 377 => 0x1b },
	'bluecurvelimits' => { 110 => 0x1fe },
	'bluecurvepoints' => { 109 => 0x79, 110 => 0x1d4 },
	'bluehsl' => { 105 => 0x20915 },
	'bluehue' => { 502 => 'BlueHue', 504 => 'BlueHue' },
	'bluesaturation' => { 502 => 'BlueSaturation', 504 => 'BlueSaturation' },
	'bluratinfinity' => { 488 => 'BlurAtInfinity' },
	'blurcontrol' => { 377 => 0x82 },
	'blurwarning' => { 129 => 0x1300 },
	'bodybatteryadload' => { 356 => 0x3 },
	'bodybatteryadnoload' => { 356 => 0x2 },
	'bodybatterystate' => { 356 => '1.1' },
	'bodybatteryvoltage1' => { 356 => 0x2 },
	'bodybatteryvoltage2' => { 356 => 0x4 },
	'bodybatteryvoltage3' => { 356 => 0x6 },
	'bodybatteryvoltage4' => { 356 => 0x8 },
	'bodyfirmware' => { 410 => 0x0 },
	'bodyfirmwareversion' => { 320 => 0x104, 321 => 0x100, 324 => 0x104 },
	'bodyserialnumber' => { 410 => 0x10 },
	'bookedition' => { 521 => 'bookEdition' },
	'bootloaderversion' => { 404 => 0x26 },
	'bracketbutton' => { 244 => 0x80c },
	'bracketbuttonplaybackmode' => { 244 => 0x816 },
	'bracketincrement' => { 241 => 0x22e, 242 => 0x21a, 243 => 0x22e, 244 => 0x22e },
	'bracketmode' => { 58 => 0x3 },
	'bracketprogram' => { 241 => 0x22c, 242 => 0x218, 243 => 0x22c, 244 => 0x22c },
	'bracketsequence' => { 115 => 0x301d },
	'bracketset' => { 241 => 0x22a, 242 => 0x216, 243 => 0x22a, 244 => 0x22a },
	'bracketsettings' => { 342 => 0x45 },
	'bracketshotnumber' => { 58 => 0x5, 358 => 0x9, 440 => 0x2b },
	'bracketshotnumber2' => { 440 => 0x2d },
	'bracketstep' => { 183 => 0xe },
	'bracketvalue' => { 58 => 0x4 },
	'brightness' => { 121 => 0xfe53, 158 => 'Brightness', 178 => 'Brightness', 183 => 0x2c, 251 => 0x34, 252 => 0x39, 253 => 0x41, 396 => 'player.movie.visual.brightness', 403 => 0x25, 405 => 0x54, 429 => 0x22, 442 => 0x2007, 502 => 'Brightness', 504 => 'Brightness' },
	'brightnessadj' => { 110 => 0x114, 285 => 0x0, 295 => 0x2d, 478 => 0x8018 },
	'brightnessvalue' => { 121 => 0x9203, 189 => [0x691,0x49c3], 324 => 0x1003, 447 => 0x1e, 451 => 0x1140, 452 => 0x1140, 453 => 0x111c, 454 => 0x1198, 455 => 0x1174, 456 => 0x102c, 457 => 0x224, 458 => 0x224, 459 => 0x219, 508 => 'BrightnessValue' },
	'buildnumber' => { 193 => 0x5500 },
	'bulbduration' => { 78 => 0x18 },
	'burstcount' => { 140 => 0x40d },
	'burstgroupid' => { 238 => 0x4 },
	'burstid' => { 485 => 'BurstID' },
	'burstmode' => { 142 => 0xa, 342 => 0x2a },
	'burstmode2' => { 142 => 0x18 },
	'burstprimary' => { 485 => 'BurstPrimary' },
	'burstshot' => { 419 => 0x34 },
	'burstspeed' => { 342 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 86 => 0x70a },
	'bwadjustment' => { 129 => 0x1049 },
	'bwfilter' => { 183 => 0x2a, 191 => 0x39 },
	'bwmagentagreen' => { 129 => 0x104b },
	'bwmode' => { 324 => 0x203 },
	'by-line' => { 133 => 0x50 },
	'by-linetitle' => { 133 => 0x55 },
	'bytecount' => { 521 => 'byteCount' },
	'c14configuration' => { 140 => 0x1964 },
	'cacheversion' => { 121 => 0xc7aa },
	'calibratedfocallength' => { 118 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 118 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 118 => 'CalibratedOpticalCenterY' },
	'calibration' => { 419 => [0x24,0x30] },
	'calibrationhistory' => { 140 => 0x9c9 },
	'calibrationilluminant1' => { 121 => 0xc65a },
	'calibrationilluminant2' => { 121 => 0xc65b },
	'calibrationilluminant3' => { 121 => 0xcd31 },
	'calibrationversion' => { 140 => 0x9c6 },
	'callforimage' => { 492 => 'CallForImage' },
	'camera' => { 481 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 402 => 'angl', 531 => 'cameraAngle' },
	'cameraappinfo' => { 481 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 481 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 481 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 481 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 486 => 'CameraBurstID' },
	'cameracalibration' => { 419 => 0x11f },
	'cameracalibration1' => { 121 => 0xc623 },
	'cameracalibration2' => { 121 => 0xc624 },
	'cameracalibration3' => { 121 => 0xcd32 },
	'cameracalibrationsig' => { 121 => 0xc6f3 },
	'cameracolorcalibration01' => { 37 => 0x0, 38 => 0x0 },
	'cameracolorcalibration02' => { 37 => 0x4, 38 => 0x5 },
	'cameracolorcalibration03' => { 37 => 0x8, 38 => 0xa },
	'cameracolorcalibration04' => { 37 => 0xc, 38 => 0xf },
	'cameracolorcalibration05' => { 37 => 0x10, 38 => 0x14 },
	'cameracolorcalibration06' => { 37 => 0x14, 38 => 0x19 },
	'cameracolorcalibration07' => { 37 => 0x18, 38 => 0x1e },
	'cameracolorcalibration08' => { 37 => 0x1c, 38 => 0x23 },
	'cameracolorcalibration09' => { 37 => 0x20, 38 => 0x28 },
	'cameracolorcalibration10' => { 37 => 0x24, 38 => 0x2d },
	'cameracolorcalibration11' => { 37 => 0x28, 38 => 0x32 },
	'cameracolorcalibration12' => { 37 => 0x2c, 38 => 0x37 },
	'cameracolorcalibration13' => { 37 => 0x30, 38 => 0x3c },
	'cameracolorcalibration14' => { 37 => 0x34, 38 => 0x41 },
	'cameracolorcalibration15' => { 37 => 0x38, 38 => 0x46 },
	'cameradepthmap' => { 481 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 481 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 481 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 481 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 481 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 481 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 481 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 481 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 481 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 481 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 481 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 481 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 396 => 'direction.facing' },
	'camerae-mountversion' => { 477 => 0xb },
	'cameraelevationangle' => { 121 => 0x9405, 509 => 'CameraElevationAngle' },
	'camerafilename' => { 492 => 'CameraFilename' },
	'camerafirmware' => { 121 => 0xa439 },
	'cameraid' => { 324 => 0x209, 402 => 'cmid', 418 => 0x209 },
	'cameraidentifier' => { 396 => 'camera.identifier' },
	'cameraimage' => { 481 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 481 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 481 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 481 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 481 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 481 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 481 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 481 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 481 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 481 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 481 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 481 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 481 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 481 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 35 => 0x10 },
	'cameralabel' => { 121 => 0xc7a1, 531 => 'cameraLabel' },
	'cameralightestimate' => { 481 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 481 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 481 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 481 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 481 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 492 => 'CameraMakeModel' },
	'cameramodel' => { 386 => 0x410, 531 => 'cameraModel' },
	'cameramodelid' => { 178 => 'CameraModelID' },
	'cameramodelrestriction' => { 502 => 'CameraModelRestriction', 504 => 'CameraModelRestriction' },
	'cameramotion' => { 396 => 'direction.motion' },
	'cameramove' => { 531 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 342 => 0x8f, 381 => 0x1, 386 => 0x100, 435 => [0x16,0x18], 465 => 0x28, 466 => 0x24, 467 => 0x29 },
	'cameraowner' => { 143 => 0xc353 },
	'cameraparameters' => { 324 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 117 => 0x9, 402 => "\xa9gpt" },
	'camerapointcloud' => { 481 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 481 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 481 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 481 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 481 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 481 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 481 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 481 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 481 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 481 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 481 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 481 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 481 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 502 => 'CameraProfile', 504 => 'CameraProfile' },
	'cameraprofiledigest' => { 502 => 'CameraProfileDigest', 504 => 'CameraProfileDigest' },
	'cameraprofiles' => { 519 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 519 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 519 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 519 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 519 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 519 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 519 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 519 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 519 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 519 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 519 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 519 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 519 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 519 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 519 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 519 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 111 => 0xe1 },
	'camerarawcontrast' => { 111 => 0xe3 },
	'camerarawhighlightpoint' => { 111 => 0xe6 },
	'camerarawlinear' => { 111 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 111 => 0xe8 },
	'camerarawoutputshadowpoint' => { 111 => 0xe9 },
	'camerarawsaturation' => { 111 => 0xe2 },
	'camerarawshadowpoint' => { 111 => 0xe7 },
	'camerarawsharpness' => { 111 => 0xe5 },
	'cameraroll' => { 117 => 0xb, 402 => "\xa9grl" },
	'cameras' => { 481 => 'Cameras' },
	'cameraserialnumber' => { 121 => 0xc62f, 180 => 'CameraSerialNumber', 492 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 319 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 34 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 78 => 0xc, 140 => 0x406, 323 => 0x1306, 337 => 0x320, 344 => 0x3402, 377 => 0x47, 416 => 0x43, 469 => 0x5 },
	'cameratemperature4' => { 382 => 0x14 },
	'cameratemperature5' => { 382 => 0x16 },
	'cameratemperaturerangemax' => { 123 => 0x5 },
	'cameratemperaturerangemin' => { 123 => 0x6 },
	'cameratrait' => { 481 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 78 => 0x1a, 324 => 0x207 },
	'cameratype2' => { 320 => 0x100 },
	'cameravendorinfo' => { 481 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 481 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 481 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 481 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 117 => 0xa, 402 => "\xa9gyw" },
	'camreverse' => { 118 => 'CamReverse' },
	'canondr4' => { 122 => 'CanonDR4' },
	'canonexposuremode' => { 35 => 0x14 },
	'canonfiledescription' => { 99 => 0x805 },
	'canonfilelength' => { 65 => 0xe },
	'canonfirmwareversion' => { 65 => 0x7, 99 => 0x80b },
	'canonflashinfo' => { 99 => 0x1028 },
	'canonflashmode' => { 35 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 35 => 0xa },
	'canonimagetype' => { 65 => 0x6, 99 => 0x815 },
	'canonlogversion' => { 64 => 0xb },
	'canonmodelid' => { 65 => 0x10, 99 => 0x1834 },
	'canonvrd' => { 122 => 'CanonVRD' },
	'caption' => { 497 => 'caption' },
	'caption-abstract' => { 133 => 0x78 },
	'captionsauthornames' => { 507 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 507 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 519 => 'CaptionWriter' },
	'captureframerate' => { 115 => 0x4001 },
	'captureheightnormal' => { 140 => 0x1839 },
	'capturelook' => { 140 => 0xc48 },
	'capturemode' => { 396 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 490 => 'CaptureSoftware' },
	'capturewidthnormal' => { 140 => 0x1838 },
	'capturewidthtest' => { 140 => 0x1842 },
	'cardshutterlock' => { 186 => 0x49 },
	'casioimagesize' => { 115 => 0x9 },
	'catalogsets' => { 133 => 0xff, 483 => 'CatalogSets', 495 => 'CatalogSets' },
	'categories' => { 65 => 0x23, 497 => 'categories' },
	'category' => { 133 => 0xf, 181 => 'WM/Category', 318 => 0x30, 394 => 'catg', 519 => 'Category' },
	'cbcrgain' => { 416 => 0xa036 },
	'cbcrgaindefault' => { 416 => 0xa035 },
	'cbcrmatrix' => { 416 => 0xa034 },
	'cbcrmatrixdefault' => { 416 => 0xa033 },
	'ccdboardversion' => { 337 => 0x331 },
	'ccdscanmode' => { 324 => 0x1039 },
	'ccdsensitivity' => { 282 => 0x6 },
	'ccdversion' => { 337 => 0x330 },
	'ccvavgluminancenits' => { 512 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 512 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 512 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 512 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 512 => 'ccv_white_xy' },
	'cellglobalid' => { 501 => 'cgi' },
	'celllength' => { 121 => 0x109 },
	'cellr' => { 501 => 'r' },
	'celltowerid' => { 501 => 'cellid' },
	'cellwidth' => { 121 => 0x108 },
	'centerafarea' => { 310 => '15.1' },
	'centerfocuspoint' => { 314 => '2.2' },
	'centerpixel' => { 140 => 0x40c },
	'centerweightedareasize' => { 299 => '7.1', 300 => '8.1', 302 => '8.1', 303 => '8.1', 307 => '7.1', 308 => '5.1', 309 => '7.1', 310 => '6.3', 312 => '8.1', 313 => '8.1', 314 => '8.1', 315 => 0x1f, 316 => 0x1f, 317 => 0x1f },
	'certificate' => { 535 => 'Certificate' },
	'cfainterpolationalgorithm' => { 140 => 0xe60 },
	'cfainterpolationmetric' => { 140 => 0xe61 },
	'cfaoffsetcols' => { 140 => 0xc71 },
	'cfaoffsetrows' => { 140 => 0xc6f },
	'cfapattern' => { 121 => 0xa302, 347 => 0x9, 508 => 'CFAPattern' },
	'cfapattern2' => { 121 => 0x828e },
	'cfapatterncolumns' => { 508 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 508 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 508 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 121 => 0x828d },
	'cfazipperfixthreshold' => { 140 => 0xe62 },
	'channel' => { 521 => 'channel' },
	'channela-lang' => { 521 => [\'channel','channelA-lang'] },
	'channelchannel' => { 521 => [\'channel','channelChannel'] },
	'channels' => { 157 => 'Channels' },
	'channelsubchannel1' => { 521 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 521 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 521 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 521 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 402 => 'chpl' },
	'checkmark' => { 105 => 0x10101, 110 => 0x26a },
	'checkmark2' => { 111 => 0x8e },
	'childfontfiles' => { 536 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 299 => '10.3', 300 => '11.2', 315 => 0x10b, 316 => 0x10b, 317 => 0x121 },
	'chromablurradius' => { 121 => 0xc631 },
	'chromanoisecolorspace' => { 140 => 0xe6d },
	'chromanoiseedgemapthresh' => { 140 => 0xe6c },
	'chromanoisehighfthresh' => { 140 => 0xe6a },
	'chromanoiselowfthresh' => { 140 => 0xe6b },
	'chromaticaberration' => { 105 => 0x20703, 111 => 0x66, 416 => 0xa051 },
	'chromaticaberrationb' => { 502 => 'ChromaticAberrationB', 504 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 105 => 0x20708, 111 => 0x6b },
	'chromaticaberrationcorr' => { 80 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 121 => 0x7034, 367 => 0x1, 478 => 0x900d },
	'chromaticaberrationcorrparams' => { 121 => 0x7035, 473 => 0x66a, 474 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 105 => '0x20703.0', 111 => 0x62 },
	'chromaticaberrationr' => { 502 => 'ChromaticAberrationR', 504 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 105 => 0x20707, 111 => 0x6a },
	'chromaticaberrationsetting' => { 81 => 0x6 },
	'chrominancenoisereduction' => { 105 => 0x20601, 111 => 0x5e, 419 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 111 => 0x60 },
	'circadatecreated' => { 516 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 504 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 502 => 'CircularGradientBasedCorrections', 504 => 'CircularGradientBasedCorrections' },
	'city' => { 133 => 0x5a, 163 => 'City', 342 => 0x6d, 519 => 'City' },
	'city2' => { 342 => 0x80 },
	'clarity' => { 129 => 0x100f, 252 => 0x35, 253 => 0x3d, 442 => 0x2036, 502 => 'Clarity', 504 => 'Clarity' },
	'clarity2012' => { 502 => 'Clarity2012', 504 => 'Clarity2012' },
	'claritycontrol' => { 377 => 0x96 },
	'classification' => { 402 => 'clsf' },
	'classifystate' => { 133 => 0xe1 },
	'clearretouch' => { 342 => 0x7c },
	'clearretouchvalue' => { 342 => 0xa3 },
	'client' => { 531 => 'client' },
	'clientname' => { 510 => 'ClientName' },
	'clipboardaspectratio' => { 502 => 'ClipboardAspectRatio', 504 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 502 => 'ClipboardOrientation', 504 => 'ClipboardOrientation' },
	'clipfilename' => { 402 => 'clfn' },
	'clipid' => { 402 => 'clid' },
	'clmodeshootingspeed' => { 299 => '10.2', 300 => '11.3', 302 => '11.2', 303 => '11.2', 308 => '11.2', 309 => '10.2', 312 => '11.2', 313 => '11.2', 314 => '11.1', 315 => 0x3b, 316 => 0x3b, 317 => 0x3b },
	'cluster' => { 502 => 'Cluster', 504 => 'Cluster' },
	'cmcontrast' => { 327 => 0x2022 },
	'cmddialsreverserotation' => { 315 => 0xba, 316 => 0xba, 317 => 0xba },
	'cmexposurecompensation' => { 327 => 0x2000 },
	'cmhue' => { 327 => 0x2021 },
	'cmsaturation' => { 327 => 0x2020 },
	'cmsharpness' => { 327 => 0x2023 },
	'cmwhitebalance' => { 327 => 0x2001 },
	'cmwhitebalancecomp' => { 327 => 0x2002 },
	'cmwhitebalancegraypoint' => { 327 => 0x2010 },
	'codec' => { 171 => 'Codec' },
	'codedcharacterset' => { 134 => 0x5a },
	'codeversion' => { 402 => 'cver' },
	'collection' => { 332 => 'Collection' },
	'collectionname' => { 172 => [\'Collections','CollectionsCollectionName'], 402 => 'coll' },
	'collections' => { 172 => 'Collections', 497 => 'collections' },
	'collectionuri' => { 172 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 396 => 'player.movie.visual.color', 520 => 'color' },
	'coloraberrationcontrol' => { 292 => 0xc89224b },
	'coloradjustment' => { 419 => 0x14 },
	'coloradjustmentmode' => { 418 => 0x210 },
	'coloranta' => { 536 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 536 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 536 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 536 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 536 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 536 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 536 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 536 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 536 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 536 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 536 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 536 => 'Colorants' },
	'colorantswatchname' => { 536 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 536 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 536 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 536 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 158 => 'ColorBalance' },
	'colorbalanceadj' => { 292 => 0x76a43202 },
	'colorbalanceblue' => { 183 => 0x1e },
	'colorbalancegreen' => { 183 => 0x1d },
	'colorbalancered' => { 183 => 0x1c },
	'colorbalanceversion' => { 208 => 0x4, 209 => 0x4, 210 => 0x0 },
	'colorblur' => { 111 => 0x65 },
	'colorbluron' => { 105 => 0x20704 },
	'colorbooster' => { 292 => 0x5f0e7d23 },
	'colorboostlevel' => { 286 => 0x1 },
	'colorboosttype' => { 286 => 0x0 },
	'colorchromeeffect' => { 129 => 0x1048 },
	'colorchromefxblue' => { 129 => 0x104e },
	'colorclass' => { 388 => 0xde, 389 => 'ColorClass' },
	'colorcompensationfilter' => { 186 => [0x3a,0x5f], 188 => 0x111, 442 => 0xb022 },
	'colorcompensationfiltercustom' => { 429 => 0xd, 430 => 0xc },
	'colorcompensationfilterset' => { 429 => 0x8, 430 => 0x7, 431 => 0x18, 447 => 0xf },
	'colorcontrol' => { 324 => 0x102b },
	'colorcorrection' => { 478 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 319 => 0x532 },
	'colordataversion' => { 42 => 0x0, 43 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0 },
	'coloreffect' => { 342 => 0x28 },
	'colorfilter' => { 114 => 0x17, 115 => 0x3017, 183 => 0x29, 191 => [0x38,0x4d,0x4f], 384 => 0x17 },
	'colorgain' => { 259 => 0x51 },
	'colorgradeblending' => { 502 => 'ColorGradeBlending', 504 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 502 => 'ColorGradeGlobalHue', 504 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 502 => 'ColorGradeGlobalLum', 504 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 502 => 'ColorGradeGlobalSat', 504 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 502 => 'ColorGradeHighlightLum', 504 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 502 => 'ColorGradeMidtoneHue', 504 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 502 => 'ColorGradeMidtoneLum', 504 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 502 => 'ColorGradeMidtoneSat', 504 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 502 => 'ColorGradeShadowLum', 504 => 'ColorGradeShadowLum' },
	'colorhue' => { 105 => 0x20900, 236 => 0x8d },
	'colorimetricreference' => { 121 => 0xc6bf },
	'colorlabel' => { 507 => 'ColorLabel' },
	'colormatrix' => { 64 => 0xa, 323 => 0x200, 324 => 0x1011, 416 => 0xa030 },
	'colormatrix1' => { 121 => 0xc621, 386 => 0x106 },
	'colormatrix2' => { 121 => 0xc622, 327 => 0x200, 386 => 0x226 },
	'colormatrix3' => { 121 => 0xcd33 },
	'colormatrixa' => { 377 => 0x203 },
	'colormatrixa2' => { 377 => 0x21c },
	'colormatrixadobergb' => { 416 => 0xa032 },
	'colormatrixb' => { 377 => 0x204 },
	'colormatrixb2' => { 377 => 0x21d },
	'colormatrixnumber' => { 324 => 0x1019 },
	'colormatrixsrgb' => { 416 => 0xa031 },
	'colormode' => { 115 => 0x3015, 129 => 0x1210, 142 => 0x66, 183 => 0x28, 186 => 0x16, 188 => 0x101, 189 => 0x36, 191 => 0x7, 236 => 0x3, 282 => 0x4, 342 => 0x32, 419 => 0x2c, 442 => 0xb029, 519 => 'ColorMode' },
	'colormoirereduction' => { 105 => 0x20670, 293 => 0x15 },
	'colormoirereductionmode' => { 293 => 0x5 },
	'colormoirereductionon' => { 105 => '0x20670.0' },
	'colornoisereduction' => { 478 => 0x8029, 502 => 'ColorNoiseReduction', 504 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 502 => 'ColorNoiseReductionDetail', 504 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 293 => 0x18 },
	'colornoisereductionsharpness' => { 293 => 0x1c },
	'colornoisereductionsmoothness' => { 502 => 'ColorNoiseReductionSmoothness', 504 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 125 => 0x2 },
	'colorprofile' => { 183 => 0x33 },
	'colorprofilesettings' => { 319 => 0x539 },
	'colorrepresentation' => { 135 => 0x3c },
	'colorsaturationadj' => { 105 => 0x20305 },
	'colorsequence' => { 135 => 0x41 },
	'colorspace' => { 52 => 0x3, 65 => 0xb4, 99 => 0x10b4, 121 => 0xa001, 137 => 0x3, 164 => 'ColorSpace', 184 => 0x2f, 185 => 0x25, 186 => 0x17, 236 => 0x1e, 319 => 0x507, 377 => 0x37, 416 => 0xa011, 419 => 0xb, 429 => 0x1b, 430 => 0x83, 431 => 0xe, 447 => 0x6, 508 => 'ColorSpace' },
	'colorspace2' => { 64 => 0x9 },
	'colorspecapproximation' => { 137 => 0x2 },
	'colorspecdata' => { 137 => 0x3 },
	'colorspecmethod' => { 137 => 0x0 },
	'colorspecprecedence' => { 137 => 0x1 },
	'colortempasshot' => { 39 => 0x4, 40 => 0x7, 41 => 0x1d, 42 => 0x59, 43 => 0x6d, 44 => 0x26, 45 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x43, 51 => 0x4b },
	'colortempauto' => { 39 => 0x9, 40 => 0xf, 41 => 0x22, 42 => 0x5e, 43 => 0x72, 44 => 0x1c, 45 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x48, 51 => 0x50 },
	'colortempcloudy' => { 39 => 0x22, 40 => 0x37, 41 => 0x31, 42 => 0xa4, 43 => 0xdb, 44 => 0x35, 45 => 0x5c, 48 => 0x75, 49 => 0x8e, 50 => 0x93, 51 => 0x96, 377 => 0x55 },
	'colortempcustom' => { 45 => 0x84 },
	'colortempcustom1' => { 41 => 0x45 },
	'colortempcustom2' => { 41 => 0x4a },
	'colortempdaylight' => { 39 => 0x18, 40 => 0x27, 41 => 0x27, 42 => 0x9a, 43 => 0xd1, 44 => 0x2b, 45 => 0x52, 48 => 0x6b, 49 => 0x84, 50 => 0x89, 51 => 0x8c, 377 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 65 => 0xae, 75 => 0x9, 99 => 0x10ae, 129 => 0x1005, 140 => 0x846, 158 => 'ColorTemperature', 184 => [0x6e,0x49], 185 => 0x3f, 186 => [0x39,0x5e], 188 => 0x10b, 191 => [0x3c,0x4c,0x4e], 337 => 0x321, 377 => 0x50, 409 => 0x1308, 442 => 0xb021, 502 => 'Temperature', 504 => 'Temperature' },
	'colortemperatureadj' => { 478 => 0x8013 },
	'colortemperatureauto' => { 236 => 0x4f },
	'colortemperaturebg' => { 324 => 0x1013 },
	'colortemperaturecustom' => { 429 => 0xc, 430 => 0xb },
	'colortemperaturerg' => { 324 => 0x1014 },
	'colortemperatureset' => { 429 => 0x7, 430 => 0x6 },
	'colortemperaturesetting' => { 186 => 0x25, 431 => 0x17, 447 => 0xe },
	'colortempflash' => { 39 => 0x36, 40 => 0x57, 41 => 0x40, 42 => 0xb8, 43 => 0xef, 44 => 0x49, 45 => 0x70, 48 => 0x89, 49 => 0xa2, 50 => 0xa7, 51 => 0xaa, 377 => 0x5a },
	'colortempflashdata' => { 45 => 0x24a },
	'colortempfluorescent' => { 39 => 0x2c, 40 => 0x47, 41 => 0x3b, 42 => 0xae, 43 => 0xe5, 44 => 0x3f, 45 => 0x66, 48 => 0x7f, 49 => 0x98, 50 => 0x9d, 51 => 0xa0 },
	'colortempfluorescentd' => { 377 => 0x57 },
	'colortempfluorescentn' => { 377 => 0x58 },
	'colortempfluorescentw' => { 377 => 0x59 },
	'colortempkelvin' => { 39 => 0x31, 40 => 0x4f, 42 => 0xb3, 43 => 0xea, 44 => 0x44, 45 => 0x6b, 48 => 0x84, 49 => 0x9d, 50 => 0xa2, 51 => 0xa5, 342 => 0x44, 409 => 0x1307 },
	'colortempmeasured' => { 39 => 0xe, 40 => 0x17, 42 => 0x63, 43 => 0x77, 45 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x4d, 51 => 0x55 },
	'colortemppc1' => { 44 => 0x94, 45 => 0x75 },
	'colortemppc2' => { 44 => 0x99, 45 => 0x7a },
	'colortemppc3' => { 44 => 0x9e, 45 => 0x7f },
	'colortempshade' => { 39 => 0x1d, 40 => 0x2f, 41 => 0x2c, 42 => 0x9f, 43 => 0xd6, 44 => 0x30, 45 => 0x57, 48 => 0x70, 49 => 0x89, 50 => 0x8e, 51 => 0x91, 377 => 0x54 },
	'colortemptungsten' => { 39 => 0x27, 40 => 0x3f, 41 => 0x36, 42 => 0xa9, 43 => 0xe0, 44 => 0x3a, 45 => 0x61, 48 => 0x7a, 49 => 0x93, 50 => 0x98, 51 => 0x9b, 377 => 0x56 },
	'colortempunknown' => { 39 => 0x13, 40 => 0x1f, 42 => 0x68, 43 => 0x7c, 44 => 0x21, 48 => 0x52, 49 => 0x52, 50 => 0x52, 51 => 0x5a },
	'colortempunknown10' => { 39 => 0x63, 40 => 0x9f, 42 => 0x95, 43 => 0xa9, 44 => 0x76, 48 => 0xa2, 49 => 0x7f, 50 => 0x7f, 51 => 0x87 },
	'colortempunknown11' => { 39 => 0x68, 40 => 0xa7, 42 => 0xbd, 43 => [0xae,0xb3], 44 => 0x7b, 48 => 0xa7, 49 => 0xa7, 50 => 0x84, 51 => 0xaf },
	'colortempunknown12' => { 39 => 0x6d, 40 => 0xaf, 42 => 0xc2, 43 => 0xb8, 44 => 0x80, 48 => 0xac, 49 => 0xac, 50 => 0xac, 51 => 0xb4 },
	'colortempunknown13' => { 39 => 0x72, 40 => 0xb7, 42 => 0xc7, 43 => 0xbd, 44 => 0x85, 48 => 0xb1, 49 => 0xb1, 50 => 0xb1, 51 => 0xb9 },
	'colortempunknown14' => { 42 => 0xcc, 43 => 0xc2, 44 => 0x8a, 48 => 0xb6, 49 => 0xb6, 50 => 0xb6, 51 => 0xbe },
	'colortempunknown15' => { 42 => 0xd1, 43 => 0xc7, 44 => 0x8f, 48 => 0xbb, 49 => 0xbb, 50 => 0xbb, 51 => 0xc3 },
	'colortempunknown16' => { 42 => 0xd6, 43 => 0xcc, 44 => 0xa3, 49 => 0xc0, 50 => 0xc0, 51 => 0xc8 },
	'colortempunknown17' => { 42 => 0xdb, 43 => 0xf4, 49 => 0xc5, 50 => 0xc5, 51 => 0xcd },
	'colortempunknown18' => { 42 => 0xe0, 43 => 0xf9, 49 => 0xca, 50 => 0xca, 51 => 0xd2 },
	'colortempunknown19' => { 42 => 0xe5, 43 => 0xfe, 49 => 0xcf, 50 => 0xcf, 51 => 0xd7 },
	'colortempunknown2' => { 39 => 0x3b, 40 => 0x5f, 42 => 0x6d, 43 => 0x81, 44 => 0x4e, 48 => 0x57, 49 => 0x57, 50 => 0x57, 51 => 0x5f },
	'colortempunknown20' => { 42 => 0xea, 43 => 0x103, 49 => 0xd4, 50 => 0xd4, 51 => 0xdc },
	'colortempunknown21' => { 42 => 0xef, 43 => 0x108, 50 => 0xd9, 51 => 0xe1 },
	'colortempunknown22' => { 42 => 0xf4, 43 => 0x10d, 50 => 0xde, 51 => 0xe6 },
	'colortempunknown23' => { 42 => 0xf9, 43 => 0x112, 50 => 0xe3, 51 => 0xeb },
	'colortempunknown24' => { 42 => 0xfe, 43 => 0x117, 50 => 0xe8, 51 => 0xf0 },
	'colortempunknown25' => { 42 => 0x103, 43 => 0x11c, 50 => 0xed, 51 => 0xf5 },
	'colortempunknown26' => { 42 => 0x108, 43 => 0x121, 50 => 0xf2, 51 => 0xfa },
	'colortempunknown27' => { 42 => 0x10d, 43 => 0x126, 50 => 0xf7, 51 => 0xff },
	'colortempunknown28' => { 42 => 0x112, 50 => 0xfc, 51 => 0x104 },
	'colortempunknown29' => { 42 => 0x117, 50 => 0x101, 51 => 0x109 },
	'colortempunknown3' => { 39 => 0x40, 40 => 0x67, 42 => 0x72, 43 => 0x86, 44 => 0x53, 48 => 0x5c, 49 => 0x5c, 50 => 0x5c, 51 => 0x64 },
	'colortempunknown30' => { 50 => 0x106 },
	'colortempunknown4' => { 39 => 0x45, 40 => 0x6f, 42 => 0x77, 43 => 0x8b, 44 => 0x58, 48 => 0x61, 49 => 0x61, 50 => 0x61, 51 => 0x69 },
	'colortempunknown5' => { 39 => 0x4a, 40 => 0x77, 42 => 0x7c, 43 => 0x90, 44 => 0x5d, 48 => 0x66, 49 => 0x66, 50 => 0x66, 51 => 0x6e },
	'colortempunknown6' => { 39 => 0x4f, 40 => 0x7f, 42 => 0x81, 43 => 0x95, 44 => 0x62, 48 => 0x8e, 49 => 0x6b, 50 => 0x6b, 51 => 0x73 },
	'colortempunknown7' => { 39 => 0x54, 40 => 0x87, 42 => 0x86, 43 => 0x9a, 44 => 0x67, 48 => 0x93, 49 => 0x70, 50 => 0x70, 51 => 0x78 },
	'colortempunknown8' => { 39 => 0x59, 40 => 0x8f, 42 => 0x8b, 43 => 0x9f, 44 => 0x6c, 48 => 0x98, 49 => 0x75, 50 => 0x75, 51 => 0x7d },
	'colortempunknown9' => { 39 => 0x5e, 40 => 0x97, 42 => 0x90, 43 => 0xa4, 44 => 0x71, 48 => 0x9d, 49 => 0x7a, 50 => 0x7a, 51 => 0x82 },
	'colortint' => { 341 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 35 => 0x2a, 52 => 0x2, 64 => 0x8 },
	'colortoneadj' => { 105 => 0x20304, 110 => 0x11e },
	'colortoneauto' => { 72 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 71 => 0x6c, 72 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 71 => 0x3c, 72 => 0x3c },
	'colortonemonochrome' => { 71 => 0x84, 72 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 71 => 0x54, 72 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 71 => 0x24, 72 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 71 => 0xc, 72 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 71 => 0x9c, 72 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 71 => 0xb4, 72 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 71 => 0xcc, 72 => 0xe4 },
	'columninterleavefactor' => { 121 => 0xcd43 },
	'comlenblksize' => { 140 => 0xfde8 },
	'commanddialplaybackmode' => { 315 => 0x1cb, 316 => 0x1cb, 317 => 0x1e3 },
	'commanddials' => { 310 => '5.1' },
	'commanddialsaperturesetting' => { 299 => '17.3', 300 => '18.3', 302 => '18.3', 303 => '18.3', 308 => '33.3', 309 => '17.3', 312 => '18.3', 313 => '18.3' },
	'commanddialschangemainsub' => { 299 => '17.2', 300 => '18.1', 302 => '18.1', 303 => '18.1', 308 => '33.2', 309 => '17.2', 312 => '18.1', 313 => '18.1' },
	'commanddialsmenuandplayback' => { 299 => '17.4', 300 => '18.2', 302 => '18.2', 303 => '18.2', 308 => '33.4', 309 => '17.4', 312 => '18.2', 313 => '18.2' },
	'commanddialsreverserotation' => { 299 => '17.1', 300 => '6.4', 302 => '6.2', 303 => '6.2', 304 => '16.2', 305 => '17.2', 308 => '33.1', 309 => '17.1', 312 => '6.2', 313 => '6.2', 314 => '18.1' },
	'commanderchannel' => { 310 => '10.2', 311 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 310 => '13.1', 311 => '31.1' },
	'commandergroupa_ttlcomp' => { 314 => '32.1' },
	'commandergroupamanualoutput' => { 310 => '13.2', 311 => '28.2' },
	'commandergroupamode' => { 310 => '11.2', 311 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 310 => '14.1', 311 => '32.1' },
	'commandergroupb_ttlcomp' => { 314 => '33.1' },
	'commandergroupbmanualoutput' => { 310 => '14.2', 311 => '29.2' },
	'commandergroupbmode' => { 310 => '11.3', 311 => '29.1' },
	'commanderinternalflash' => { 310 => '11.1', 311 => '27.1' },
	'commanderinternalmanualoutput' => { 310 => '12.2', 311 => '27.2' },
	'commanderinternalttlchannel' => { 308 => '18.2' },
	'commanderinternalttlcomp' => { 310 => '12.1', 311 => '30.2', 314 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 308 => '20.1', 309 => '26.1' },
	'commanderinternalttlcompgroupa' => { 308 => '21.1', 309 => '27.1' },
	'commanderinternalttlcompgroupb' => { 308 => '22.1', 309 => '28.1' },
	'comment' => { 0 => 0x2, 122 => 'Comment', 159 => 'Comment', 332 => 'Comment', 394 => "\xa9cmt", 396 => 'comment', 402 => "\xa9cmt" },
	'compass' => { 412 => 0x4 },
	'compatibleversion' => { 502 => 'CompatibleVersion', 504 => 'CompatibleVersion' },
	'compilation' => { 394 => 'cpil' },
	'compimageimagespersequence' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 509 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 521 => 'complianceProfile' },
	'componentsconfiguration' => { 121 => 0x9101, 164 => 'Components', 508 => 'ComponentsConfiguration' },
	'componentversion' => { 99 => 0x80c },
	'composer' => { 181 => 'WM/Composer', 394 => ["\xa9com","\xa9wrt"], 402 => ["\xa9com","\xa9wrt"], 531 => 'composer' },
	'composerid' => { 394 => 'cmID' },
	'composerkeywords' => { 402 => "\xa9cok" },
	'compositeimage' => { 121 => 0xa460, 509 => 'CompositeImage' },
	'compositeimagecount' => { 121 => 0xa461, 509 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 121 => 0xa462, 509 => 'CompositeImageExposureTimes' },
	'composition' => { 492 => 'Composition' },
	'compositionadjust' => { 376 => '0.1' },
	'compositionadjustrotation' => { 376 => 0x7 },
	'compositionadjustx' => { 376 => 0x5 },
	'compositionadjusty' => { 376 => 0x6 },
	'compressedbitsperpixel' => { 121 => 0x9102, 508 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 188 => 0x40, 324 => 0x40 },
	'compression' => { 121 => 0x103, 347 => 0xb, 527 => 'Compression' },
	'compressionfactor' => { 319 => 0x50d },
	'compressionformat' => { 64 => 0x4 },
	'compressionratio' => { 164 => 'Compression', 324 => 0x1034 },
	'compressorversion' => { 402 => 'CNCV' },
	'condadobvfactor' => { 140 => 0xf3e },
	'condadodaybvthresh' => { 140 => 0xf3c },
	'condadodayoffsets' => { 140 => 0xf42 },
	'condadofluoffsets' => { 140 => 0xf44 },
	'condadofluthresh' => { 140 => 0xf41 },
	'condadoillfactor' => { 140 => 0xf3f },
	'condadoneurange' => { 140 => 0xf3d },
	'condadotunoffsets' => { 140 => 0xf43 },
	'condadotunthresh' => { 140 => 0xf40 },
	'conductor' => { 181 => 'WM/Conductor', 394 => "\xa9con" },
	'confidence' => { 487 => 'Confidence' },
	'confidencelevel' => { 498 => 'ConfidenceLevel' },
	'confidencemime' => { 487 => 'ConfidenceMime' },
	'constrainedcropheight' => { 110 => 0x266, 388 => 0xd6 },
	'constrainedcropwidth' => { 110 => 0x262, 388 => 0xd5 },
	'contact' => { 133 => 0x76 },
	'contactinfo' => { 502 => 'ContactInfo', 504 => 'ContactInfo', 520 => 'contactInfo' },
	'container' => { 481 => 'Container' },
	'containerdirectory' => { 481 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 481 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 481 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 481 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 481 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 481 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 516 => 'ContainerFormat' },
	'containerformatidentifier' => { 516 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 516 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 394 => "\xa9day", 402 => ['@day',"\xa9day"] },
	'contentdistributor' => { 181 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 402 => 'cdis' },
	'contentid' => { 402 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 396 => 'content.identifier' },
	'contentlocationcode' => { 133 => 0x1a },
	'contentlocationname' => { 133 => 0x1b },
	'contenttype' => { 521 => 'contentType' },
	'continuousbracketing' => { 186 => 0x20 },
	'continuousdrive' => { 35 => 0x5 },
	'continuousmodedisplay' => { 315 => 0x51, 316 => 0x51, 317 => 0x51 },
	'continuousmodeliveview' => { 313 => '77.2' },
	'continuousshootingspeed' => { 86 => 0x610 },
	'continuousshotlimit' => { 86 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 35 => 0xd, 114 => 0xc, 115 => [0x3012,0x20], 121 => [0xa408,0xfe54], 129 => [0x1004,0x1006], 158 => 'Contrast', 178 => 'Contrast', 183 => 0x20, 184 => 0x31, 185 => 0x27, 186 => 0x19, 191 => 0x2, 251 => 0x33, 252 => 0x37, 253 => 0x3f, 324 => 0x1029, 342 => 0x39, 344 => 0x300a, 377 => 0x20, 384 => 0xc, 396 => 'player.movie.visual.contrast', 403 => 0x24, 405 => 0x52, 409 => 0x1012, 419 => 0xd, 429 => 0x1d, 430 => 0x1a, 442 => 0x2004, 502 => 'Contrast', 504 => 'Contrast', 508 => 'Contrast' },
	'contrast2012' => { 502 => 'Contrast2012', 504 => 'Contrast2012' },
	'contrastadj' => { 105 => 0x20303, 110 => 0x115, 295 => 0x2c, 478 => 0x8017 },
	'contrastauto' => { 72 => 0x90 },
	'contrastcurve' => { 236 => 0x8c },
	'contrastdetectaf' => { 195 => 0x4 },
	'contrastdetectafarea' => { 377 => 0x231 },
	'contrastdetectafinfocus' => { 195 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 71 => 0x60, 72 => 0x60 },
	'contrasthighlight' => { 377 => 0x6d },
	'contrasthighlightshadowadj' => { 377 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 71 => 0x30, 72 => 0x30 },
	'contrastmode' => { 342 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 71 => 0x78, 72 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 71 => 0x48, 72 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 71 => 0x18, 72 => 0x18 },
	'contrastsetting' => { 319 => 0x505, 327 => 0x1012, 431 => 0x10, 447 => 0x8 },
	'contrastshadow' => { 377 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 71 => 0x0, 72 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 71 => 0x90, 72 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 71 => 0xa8, 72 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 71 => 0xc0, 72 => 0xd8 },
	'contributedmedia' => { 531 => 'contributedMedia' },
	'contributedmediaduration' => { 531 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 531 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 531 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 531 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 531 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 531 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 531 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 531 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 531 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 531 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 505 => 'contributor', 516 => 'Contributor' },
	'contributoridentifier' => { 516 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 516 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 516 => [\'Contributor','ContributorRole'] },
	'contributors' => { 159 => 'Contributors' },
	'controldialset' => { 186 => 0x46 },
	'controlledvocabularyterm' => { 516 => 'CVterm' },
	'controllerboardversion' => { 337 => 0x332 },
	'controlmode' => { 78 => 0x12 },
	'controlringresponse' => { 315 => 0x1d5, 316 => 0x1d5, 317 => 0x1ed },
	'controlringrotation' => { 86 => 0x712 },
	'conversionlens' => { 320 => 0x403, 342 => 0x35 },
	'converter' => { 121 => 0xfe4d, 282 => 0xb, 502 => 'Converter', 504 => 'Converter' },
	'converttograyscale' => { 502 => 'ConvertToGrayscale', 504 => 'ConvertToGrayscale' },
	'cookingequipment' => { 523 => 'cookingEquipment' },
	'cookingmethod' => { 523 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 121 => 0x8298, 159 => 'Copyright', 332 => 'Copyright', 347 => 0x8298, 377 => 0x22f, 393 => 'Copyright', 394 => ['cprt',"\xa9cpy"], 396 => 'copyright', 402 => ['cprt',"\xa9cpy"], 502 => 'Copyright', 504 => 'Copyright', 518 => 'Copyright', 524 => 'copyright', 527 => 'Copyright', 531 => 'copyright' },
	'copyrightflag' => { 391 => 0x40a },
	'copyrightnotice' => { 133 => 0x74 },
	'copyrightowner' => { 329 => 'CopyrightOwner' },
	'copyrightownerid' => { 329 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 329 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 329 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 329 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 329 => 'CopyrightStatus' },
	'copyrightyear' => { 516 => 'CopyrightYear', 521 => 'copyrightYear' },
	'coringfilter' => { 323 => 0x310, 324 => 0x102d, 327 => 0x310 },
	'coringvalues' => { 323 => 0x311, 327 => 0x311 },
	'corporateentity' => { 521 => 'corporateEntity' },
	'correlatedcolortemp' => { 341 => 0x35b },
	'country' => { 163 => 'Country', 342 => 0x69, 519 => 'Country' },
	'country-primarylocationcode' => { 133 => 0x64 },
	'country-primarylocationname' => { 133 => 0x65 },
	'countrycode' => { 235 => 0x5, 389 => 'CountryCode', 515 => 'CountryCode' },
	'course' => { 523 => 'course' },
	'coverage' => { 505 => 'coverage' },
	'coverart' => { 394 => 'covr' },
	'coverdate' => { 521 => 'coverDate' },
	'coverdisplaydate' => { 521 => 'coverDisplayDate' },
	'coveruri' => { 402 => 'cvru' },
	'cpufirmwareversion' => { 377 => 0x28 },
	'crc32' => { 506 => 'crc32' },
	'createdate' => { 121 => 0x9004, 159 => 'CreateDate', 328 => 'CreationDate', 332 => 'create-date', 393 => 'CreationDate', 399 => 0x1, 529 => 'CreateDate' },
	'creationdate' => { 396 => 'creationdate', 518 => 'CreationDate', 521 => 'creationDate' },
	'creationtime' => { 332 => 'Creation Time' },
	'creativestyle' => { 429 => 0x1a, 430 => 0x18, 440 => 0x41, 442 => 0xb020, 474 => 0x4a },
	'creativestylesetting' => { 431 => 0xf, 447 => 0x7 },
	'creativestylewaschanged' => { 478 => 0x8001 },
	'creator' => { 328 => 'Creator', 393 => 'Creator', 505 => 'creator', 516 => 'Creator', 518 => 'Creator' },
	'creatoraddress' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 180 => 'CreatorAppId' },
	'creatorcity' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 515 => 'CreatorContactInfo' },
	'creatorcountry' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 516 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 389 => 'CreatorIdentity' },
	'creatorname' => { 516 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 180 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 516 => [\'Creator','CreatorRole'] },
	'creatortool' => { 529 => 'CreatorTool' },
	'creatorworkemail' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 515 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 133 => 0x6e, 519 => 'Credit' },
	'creditline' => { 524 => 'creditLine' },
	'creditlinereq' => { 534 => 'CreditLineReq' },
	'creditlinerequired' => { 329 => 'CreditLineRequired' },
	'cropactive' => { 103 => 0x0, 110 => 0x244 },
	'cropangle' => { 502 => 'CropAngle', 504 => 'CropAngle' },
	'croparea' => { 236 => 0x45, 478 => 0x9011 },
	'cropaspectratio' => { 105 => 0x30101, 110 => 0x260 },
	'cropaspectratiocustom' => { 105 => 0x30102 },
	'cropbottom' => { 125 => 0x9, 287 => 0x36, 347 => 0x31, 388 => 0xdc, 502 => 'CropBottom', 504 => 'CropBottom' },
	'cropbottommargin' => { 54 => 0x3 },
	'cropcircleactive' => { 111 => 0xd6 },
	'cropcircleradius' => { 111 => 0xd9 },
	'cropcirclex' => { 111 => 0xd7 },
	'cropcircley' => { 111 => 0xd8 },
	'cropconstraintowarp' => { 502 => 'CropConstrainToWarp', 504 => 'CropConstrainToWarp' },
	'croph' => { 496 => 'CropH' },
	'cropheight' => { 103 => 0x6, 110 => 0x24c, 323 => 0x615, 327 => 0x615, 502 => 'CropHeight', 504 => 'CropHeight' },
	'crophispeed' => { 236 => 0x1b },
	'cropleft' => { 110 => 0x246, 125 => 0x6, 287 => 0x1e, 323 => 0x612, 327 => 0x612, 347 => 0x30, 388 => 0xd9, 502 => 'CropLeft', 504 => 'CropLeft' },
	'cropleftmargin' => { 54 => 0x0 },
	'cropmode' => { 129 => 0x104d, 409 => 0x1018 },
	'croporiginalheight' => { 103 => 0xb },
	'croporiginalwidth' => { 103 => 0xa },
	'cropoutputheight' => { 287 => 0xce },
	'cropoutputheightinches' => { 287 => 0x96 },
	'cropoutputpixels' => { 287 => 0xd6 },
	'cropoutputresolution' => { 287 => 0xb6 },
	'cropoutputscale' => { 287 => 0xbe },
	'cropoutputwidth' => { 287 => 0xc6 },
	'cropoutputwidthinches' => { 287 => 0x8e },
	'croppedareaimageheightpixels' => { 490 => 'CroppedAreaImageHeightPixels', 491 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 490 => 'CroppedAreaImageWidthPixels', 491 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 490 => 'CroppedAreaLeftPixels', 491 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 490 => 'CroppedAreaTopPixels', 491 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 409 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 409 => 0x1603 },
	'cropping' => { 478 => 0x9010 },
	'cropright' => { 125 => 0x8, 287 => 0x2e, 347 => 0x32, 388 => 0xdb, 502 => 'CropRight', 504 => 'CropRight' },
	'croprightmargin' => { 54 => 0x1 },
	'croprotatedoriginalheight' => { 103 => 0x2 },
	'croprotatedoriginalwidth' => { 103 => 0x1 },
	'croprotation' => { 103 => 0x8, 125 => 0xb },
	'cropscaledresolution' => { 287 => 0x9e },
	'cropsourceresolution' => { 287 => 0xae },
	'croptop' => { 110 => 0x248, 125 => 0x7, 287 => 0x26, 323 => 0x613, 327 => 0x613, 347 => 0x2f, 388 => 0xda, 502 => 'CropTop', 504 => 'CropTop' },
	'croptopmargin' => { 54 => 0x2 },
	'cropunit' => { 502 => 'CropUnit', 504 => 'CropUnit' },
	'cropunits' => { 502 => 'CropUnits', 504 => 'CropUnits' },
	'cropw' => { 496 => 'CropW' },
	'cropwidth' => { 103 => 0x5, 110 => 0x24a, 323 => 0x614, 327 => 0x614, 502 => 'CropWidth', 504 => 'CropWidth' },
	'cropx' => { 103 => 0x3, 496 => 'CropX' },
	'cropy' => { 103 => 0x4, 496 => 'CropY' },
	'crossprocess' => { 377 => 0x7b },
	'crossprocessparams' => { 377 => 0x235 },
	'cuisine' => { 523 => 'cuisine' },
	'currenticcprofile' => { 121 => 0xc691 },
	'currentpreprofilematrix' => { 121 => 0xc692 },
	'currentversion' => { 478 => 0xd000 },
	'curve0x' => { 496 => 'Curve0x' },
	'curve0y' => { 496 => 'Curve0y' },
	'curve1x' => { 496 => 'Curve1x' },
	'curve1y' => { 496 => 'Curve1y' },
	'curve2x' => { 496 => 'Curve2x' },
	'curve2y' => { 496 => 'Curve2y' },
	'curve3x' => { 496 => 'Curve3x' },
	'curve3y' => { 496 => 'Curve3y' },
	'curve4x' => { 496 => 'Curve4x' },
	'curve4y' => { 496 => 'Curve4y' },
	'curves' => { 292 => 0x76a43201 },
	'custom1' => { 329 => 'Custom1' },
	'custom10' => { 329 => 'Custom10' },
	'custom2' => { 329 => 'Custom2' },
	'custom3' => { 329 => 'Custom3' },
	'custom4' => { 329 => 'Custom4' },
	'custom5' => { 329 => 'Custom5' },
	'custom6' => { 329 => 'Custom6' },
	'custom7' => { 329 => 'Custom7' },
	'custom8' => { 329 => 'Custom8' },
	'custom9' => { 329 => 'Custom9' },
	'customcolortone' => { 111 => 0x4c },
	'customcontrast' => { 111 => 0x4e },
	'customcontrols' => { 86 => 0x70c },
	'customdefaultunsharpfineness' => { 111 => 0xbe },
	'customdefaultunsharpstrength' => { 111 => 0xbc },
	'customdefaultunsharpthreshold' => { 111 => 0xc0 },
	'customilluminant' => { 140 => 0x405 },
	'customizedials' => { 86 => 0x715 },
	'customlinear' => { 111 => 0x4f },
	'customoutputhighlightpoint' => { 111 => 0x53 },
	'customoutputshadowpoint' => { 111 => 0x54 },
	'custompicturestyle' => { 105 => 0x10021 },
	'custompicturestyledata' => { 105 => 0xf0500 },
	'custompicturestylefilename' => { 65 => 0x4010 },
	'customrawhighlight' => { 111 => 0x7c },
	'customrawhighlightpoint' => { 111 => 0x51 },
	'customrawshadow' => { 111 => 0x85 },
	'customrawshadowpoint' => { 111 => 0x52 },
	'customrendered' => { 121 => 0xa401, 193 => 0x6420, 508 => 'CustomRendered' },
	'customsaturation' => { 111 => 0x4d, 319 => 0x503 },
	'customsettingsalldefault' => { 299 => '0.2', 308 => '0.2' },
	'customsettingsbank' => { 299 => '0.1', 300 => '0.1', 302 => '0.1', 303 => '0.1', 308 => '0.1', 312 => '0.2', 313 => '0.2', 315 => 0x1, 316 => 0x1, 317 => 0x1 },
	'customsharpness' => { 111 => 0x50 },
	'customunsharpmaskfineness' => { 111 => 0xb8 },
	'customunsharpmaskstrength' => { 111 => 0xb6 },
	'customunsharpmaskthreshold' => { 111 => 0xba },
	'customwb_rblevels' => { 447 => 0x1a },
	'customwb_rgblevels' => { 430 => 0x8, 431 => 0x19 },
	'customwbbluelevel' => { 186 => 0x36 },
	'customwberror' => { 186 => 0x37 },
	'customwbgreenlevel' => { 186 => 0x35 },
	'customwbredlevel' => { 186 => 0x34 },
	'customwbsetting' => { 186 => 0x26 },
	'cx' => { 402 => '_cx_' },
	'cy' => { 402 => '_cy_' },
	'd-lightinghq' => { 292 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 288 => 0x2 },
	'd-lightinghqhighlight' => { 288 => 0x1 },
	'd-lightinghqselected' => { 292 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 288 => 0x0 },
	'd-lightinghs' => { 292 => 0xce5554aa },
	'd-lightinghsadjustment' => { 289 => 0x0 },
	'd-lightinghscolorboost' => { 289 => 0x1 },
	'd-rangeoptimizerhighlight' => { 478 => 0x8024 },
	'd-rangeoptimizermode' => { 478 => 0x8022 },
	'd-rangeoptimizershadow' => { 478 => 0x802d },
	'd-rangeoptimizervalue' => { 478 => 0x8023 },
	'darkblacksegrows' => { 140 => 0x18d8 },
	'darkfocusenvironment' => { 342 => 0x8003 },
	'darkframecountfactor' => { 140 => 0xc85 },
	'darkframelongexposure' => { 140 => 0xc84 },
	'darkframeshortexposure' => { 140 => 0xc83 },
	'darkpedestal' => { 140 => 0xc7f },
	'datacompressionmethod' => { 135 => 0x6e },
	'dataimprint' => { 183 => 0x34 },
	'datamining' => { 329 => 'DataMining' },
	'dataonscreen' => { 516 => 'DataOnScreen' },
	'dataonscreenregion' => { 516 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 516 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 516 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 516 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 516 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 516 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 516 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 516 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 377 => 0x3d },
	'date' => { 377 => 0x6, 505 => 'date' },
	'dateacquired' => { 180 => 'DateAcquired', 181 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 133 => 0x37, 519 => 'DateCreated' },
	'datedisplayformat' => { 284 => 0x3 },
	'dateidentified' => { 120 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 304 => '4.2' },
	'daterecieved' => { 521 => 'dateRecieved' },
	'datesent' => { 134 => 0x46 },
	'datestampmode' => { 65 => 0x1c, 236 => 0x9d },
	'datetime' => { 497 => 'datetime', 527 => 'DateTime' },
	'datetimedigitized' => { 508 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 102 => 0x0, 121 => 0x9003, 156 => 0x14, 159 => 'OriginalDate', 397 => 'IDIT', 402 => 'date', 403 => 0xb, 404 => 0x3b, 405 => 0x3e, 508 => 'DateTimeOriginal' },
	'datetimestamp' => { 142 => 0x64 },
	'datetimeutc' => { 319 => 0x908 },
	'daylightsavings' => { 79 => 0x3, 284 => 0x2 },
	'dayofweek' => { 404 => 0x42, 405 => 0x4a },
	'dccontinent' => { 120 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 120 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 120 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 120 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 120 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 120 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 120 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 120 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 120 => 'Event' },
	'dcfootprintspatialfit' => { 120 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 120 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 120 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 120 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 120 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 120 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 120 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 120 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 120 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 120 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 120 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 120 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 120 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 120 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 120 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 120 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 120 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 120 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 120 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 120 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 120 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 120 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 120 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 120 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 120 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 120 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 120 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 120 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 120 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 120 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 120 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 167 => 'Declination' },
	'decposition' => { 183 => 0x32 },
	'defaultautogray' => { 502 => 'DefaultAutoGray', 504 => 'DefaultAutoGray' },
	'defaultautotone' => { 502 => 'DefaultAutoTone', 504 => 'DefaultAutoTone' },
	'defaultblackrender' => { 121 => 0xc7a6 },
	'defaultcroporigin' => { 121 => 0xc61f },
	'defaultcropsize' => { 121 => 0xc620 },
	'defaulteraseoption' => { 86 => 0x813 },
	'defaultscale' => { 121 => 0xc61e },
	'defaultsspecifictoiso' => { 502 => 'DefaultsSpecificToISO', 504 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 502 => 'DefaultsSpecificToSerial', 504 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 121 => 0xc7b5 },
	'defectisocode' => { 140 => 0x90f },
	'defringe' => { 502 => 'Defringe', 504 => 'Defringe' },
	'defringegreenamount' => { 502 => 'DefringeGreenAmount', 504 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 502 => 'DefringeGreenHueHi', 504 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 502 => 'DefringeGreenHueLo', 504 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 502 => 'DefringePurpleAmount', 504 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 502 => 'DefringePurpleHueHi', 504 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 502 => 'DefringePurpleHueLo', 504 => 'DefringePurpleHueLo' },
	'dehaze' => { 502 => 'Dehaze', 504 => 'Dehaze' },
	'deletedimagecount' => { 236 => 0xa6, 264 => 0x6e },
	'deprecatedon' => { 500 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 502 => 'DepthBasedCorrections', 504 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 502 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 504 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 121 => 0xc7eb },
	'depthformat' => { 121 => 0xc7e9 },
	'depthimage' => { 487 => 'Data' },
	'depthmapinfo' => { 502 => 'DepthMapInfo', 504 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 504 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 504 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 504 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 504 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 504 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 504 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 504 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 504 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 502 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 504 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 502 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 504 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 121 => 0xc7ed },
	'depthnear' => { 121 => 0xc7ea },
	'depthunits' => { 121 => 0xc7ec },
	'derivedfrom' => { 532 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 532 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 532 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 532 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 532 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 532 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 532 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 532 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 532 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 532 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 532 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 532 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 532 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 532 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 532 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 532 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 532 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 532 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 532 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 532 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 532 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 532 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 532 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 532 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 332 => 'Description', 394 => ['desc','dscp',"\xa9des"], 396 => 'description', 402 => 'dscp', 502 => 'Description', 504 => 'Description', 505 => 'description', 529 => 'Description' },
	'destination' => { 134 => 0x5 },
	'destinationcity' => { 377 => 0x24, 383 => 0x3 },
	'destinationcitycode' => { 384 => 0x1001 },
	'destinationdst' => { 377 => 0x26, 383 => '0.3' },
	'developmentdynamicrange' => { 129 => 0x1403 },
	'deviantmatrixcustom' => { 140 => 0x7de },
	'deviantmatrixdaylight' => { 140 => 0x7da },
	'deviantmatrixflash' => { 140 => 0x7dd },
	'deviantmatrixfluorescent' => { 140 => 0x7dc },
	'deviantmatrixtungsten' => { 140 => 0x7db },
	'deviantwhitecustom' => { 140 => 0x842 },
	'deviantwhitedaylight' => { 140 => 0x83e },
	'deviantwhiteflash' => { 140 => 0x841 },
	'deviantwhitefluorescent' => { 140 => 0x840 },
	'deviantwhitetungsten' => { 140 => 0x83f },
	'device' => { 521 => 'device' },
	'devicesettingdescription' => { 508 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 508 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 508 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 508 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 416 => 0x2 },
	'dewarpdata' => { 118 => 'DewarpData' },
	'dewarpflag' => { 118 => 'DewarpFlag' },
	'dialdirectiontvav' => { 86 => 0x706 },
	'dietaryneeds' => { 523 => 'dietaryNeeds' },
	'diffractioncompensation' => { 225 => 0x20e, 240 => 0x142, 241 => 0x1b2, 242 => 0x1a2, 243 => 0x1b6, 244 => 0x1b6 },
	'diffractioncorrection' => { 342 => 0xbc, 367 => 0x3 },
	'diffractioncorrectionon' => { 105 => 0x2070b },
	'digitalcreationdate' => { 133 => 0x3e },
	'digitalcreationtime' => { 133 => 0x3f },
	'digitaldeehighlightadj' => { 259 => 0x202 },
	'digitaldeeshadowadj' => { 259 => 0x200 },
	'digitaldeethreshold' => { 259 => 0x201 },
	'digitalfilter' => { 419 => 0x59 },
	'digitalfilter01' => { 364 => 0x5 },
	'digitalfilter02' => { 364 => 0x16 },
	'digitalfilter03' => { 364 => 0x27 },
	'digitalfilter04' => { 364 => 0x38 },
	'digitalfilter05' => { 364 => 0x49 },
	'digitalfilter06' => { 364 => 0x5a },
	'digitalfilter07' => { 364 => 0x6b },
	'digitalfilter08' => { 364 => 0x7c },
	'digitalfilter09' => { 364 => 0x8d },
	'digitalfilter10' => { 364 => 0x9e },
	'digitalfilter11' => { 364 => 0xaf },
	'digitalfilter12' => { 364 => 0xc0 },
	'digitalfilter13' => { 364 => 0xd1 },
	'digitalfilter14' => { 364 => 0xe2 },
	'digitalfilter15' => { 364 => 0xf3 },
	'digitalfilter16' => { 364 => 0x104 },
	'digitalfilter17' => { 364 => 0x115 },
	'digitalfilter18' => { 364 => 0x126 },
	'digitalfilter19' => { 364 => 0x137 },
	'digitalfilter20' => { 364 => 0x148 },
	'digitalgain' => { 75 => 0xb },
	'digitalgem' => { 220 => 0x0 },
	'digitalice' => { 259 => 0x100 },
	'digitalimageguid' => { 516 => 'DigImageGUID' },
	'digitallensoptimizer' => { 63 => 0xa },
	'digitallensoptimizersetting' => { 81 => 0x9 },
	'digitalroc' => { 256 => 0x0 },
	'digitalsourcefiletype' => { 516 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 516 => 'DigitalSourceType' },
	'digitalzoom' => { 35 => 0xc, 114 => 0xa, 129 => 0x1044, 142 => 0x68, 153 => 0x22, 154 => 0x1e, 158 => 'DigitalZoom', 183 => 0xc, 236 => 0x86, 282 => 0xa, 324 => 0x204, 377 => 0x1e, 384 => 0xa, 418 => 0x204, 465 => 0x12, 466 => 0x12 },
	'digitalzoomon' => { 418 => 0x21b },
	'digitalzoomratio' => { 121 => 0xa404, 453 => 0x200, 455 => 0x21c, 508 => 'DigitalZoomRatio' },
	'director' => { 181 => 'WM/Director', 394 => "\xa9dir", 396 => 'director', 402 => "\xa9dir", 531 => 'director' },
	'directorphotography' => { 531 => 'directorPhotography' },
	'directory' => { 122 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 213 => 0x3, 405 => 0x12 },
	'disableautocreation' => { 485 => 'DisableAutoCreation' },
	'disclaimer' => { 332 => 'Disclaimer' },
	'discnumber' => { 531 => 'discNumber' },
	'dishtype' => { 523 => 'dishType' },
	'disknumber' => { 394 => 'disk' },
	'dispbutton' => { 244 => 0x7d4, 315 => 0x2ab },
	'displayallafpoints' => { 86 => 0x514 },
	'displayaperture' => { 35 => 0x23 },
	'displayedunitsx' => { 392 => 0x2 },
	'displayedunitsy' => { 392 => 0x6 },
	'displayname' => { 396 => 'displayname', 520 => 'displayName' },
	'distance1' => { 142 => 0x28 },
	'distance2' => { 142 => 0x2c },
	'distance3' => { 142 => 0x30 },
	'distance4' => { 142 => 0x34 },
	'distortion' => { 416 => 0xa050 },
	'distortioncompensation' => { 478 => 0x8040 },
	'distortioncontrol' => { 264 => 0x10 },
	'distortioncorrection' => { 80 => 0x3, 105 => 0x20705, 111 => 0x67, 121 => 0x7036, 319 => 0x50b, 346 => '7.1', 367 => 0x0, 473 => 0x601, 474 => 0x5b },
	'distortioncorrection2' => { 323 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 499 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 105 => '0x20705.0', 111 => 0x63 },
	'distortioncorrectionsetting' => { 81 => 0x7, 442 => 0x2013 },
	'distortioncorrectionvalue' => { 80 => 0x9 },
	'distortioncorrparams' => { 121 => 0x7037, 452 => 0x1a23, 455 => 0x1870, 457 => 0x189c, 458 => 0x18cc, 459 => 0x17d0, 473 => 0x6ca, 474 => 0x64 },
	'distortioncorrparamsnumber' => { 455 => 0x1899, 457 => 0x18c5, 458 => 0x18f5, 459 => 0x17f9 },
	'distortioncorrparamspresent' => { 455 => 0x1898, 457 => 0x18c4, 458 => 0x18f4, 459 => 0x17f8, 461 => 0x10b, 462 => 0x10b, 473 => 0x600, 474 => 0x5a },
	'distortioneffect' => { 105 => 0x20709 },
	'distortionn' => { 346 => 0xc },
	'distortionparam02' => { 346 => 0x2 },
	'distortionparam04' => { 346 => 0x4 },
	'distortionparam08' => { 346 => 0x8 },
	'distortionparam09' => { 346 => 0x9 },
	'distortionparam11' => { 346 => 0xb },
	'distortionscale' => { 346 => 0x5 },
	'distributor' => { 521 => 'distributor' },
	'distributorproductid' => { 520 => 'distributorProductID' },
	'dloon' => { 105 => '0x20706.0', 111 => 0xdc },
	'dlosetting' => { 105 => 0x20706, 111 => 0xdd },
	'dlosettingapplied' => { 104 => 0x4 },
	'dloshootingdistance' => { 111 => 0xde },
	'dloversion' => { 104 => 0x5 },
	'dmcomment' => { 531 => 'comment' },
	'dmdithermatrix' => { 140 => 0xc7a },
	'dmdithermatrixheight' => { 140 => 0xc7c },
	'dmdithermatrixwidth' => { 140 => 0xc7b },
	'dngadobedata' => { 121 => 0xc634 },
	'dngbackwardversion' => { 121 => 0xc613 },
	'dngignoresidecars' => { 502 => 'DNGIgnoreSidecars', 504 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 121 => 0xc630 },
	'dngprivatedata' => { 121 => 0xc634 },
	'dngversion' => { 121 => 0xc612 },
	'document' => { 332 => 'Document' },
	'documentancestors' => { 519 => 'DocumentAncestors' },
	'documenthistory' => { 133 => 0xe7 },
	'documentid' => { 532 => 'DocumentID' },
	'documentname' => { 121 => 0x10d },
	'documentnotes' => { 133 => 0xe6 },
	'doi' => { 521 => 'doi' },
	'dopesheet' => { 516 => 'Dopesheet' },
	'dopesheetlink' => { 516 => 'DopesheetLink' },
	'dopesheetlinklink' => { 516 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 516 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 140 => 0xc82 },
	'dpp' => { 497 => 'dpp' },
	'dr4cameramodel' => { 106 => 0x3 },
	'drangepriority' => { 129 => 0x1443 },
	'drangepriorityauto' => { 129 => 0x1444 },
	'drangepriorityfixed' => { 129 => 0x1445 },
	'drivemode' => { 115 => 0x3103, 127 => '0.1', 183 => 0x6, 186 => 0x1e, 189 => 0xe, 193 => 0x64d0, 319 => 0x600, 377 => 0x34, 409 => 0x1002, 419 => 0x3, 429 => 0x4, 430 => 0x7e, 431 => 0x34 },
	'drivemode2' => { 186 => 0xa, 358 => 0x7, 440 => 0xe, 447 => 0x1 },
	'drivemodesetting' => { 431 => 0x4 },
	'drivespeed' => { 127 => '0.2' },
	'dspfirmwareversion' => { 377 => 0x27 },
	'duration' => { 68 => 0x6a, 157 => 'Duration', 171 => 'Duration', 523 => 'duration', 531 => 'duration' },
	'durationscale' => { 531 => [\'duration','durationScale'] },
	'durationvalue' => { 531 => [\'duration','durationValue'] },
	'dustremovaldata' => { 65 => 0x97 },
	'dxcropalert' => { 241 => 0x250, 242 => 0x23c, 243 => 0x250, 244 => 0x250 },
	'dynamicafarea' => { 299 => '1.4', 308 => '1.4' },
	'dynamicafareasize' => { 241 => 0x254, 242 => 0x240, 243 => 0x254, 244 => 0x254 },
	'dynamicareaafassist' => { 315 => 0x18, 316 => 0x18, 317 => 0x18 },
	'dynamicareaafdisplay' => { 300 => '46.1', 302 => '47.1', 303 => '47.1', 312 => '47.1', 313 => '47.1' },
	'dynamicrange' => { 129 => 0x1400 },
	'dynamicrangeboost' => { 342 => 0xee },
	'dynamicrangeexpansion' => { 377 => 0x69, 409 => 0x100e },
	'dynamicrangemax' => { 110 => 0x7c },
	'dynamicrangemin' => { 110 => 0x7a },
	'dynamicrangeoptimizer' => { 186 => 0x15, 442 => [0xb025,0xb04f], 451 => 0x1144, 452 => [0x1144,0x324], 453 => [0x1120,0x300], 454 => [0x119c,0x37c], 455 => [0x1178,0x328], 456 => [0x1030,0x50], 457 => [0x228,0x50], 458 => [0x228,0x50], 459 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 440 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 429 => 0x19, 430 => 0x17, 431 => 0xd, 440 => 0x79, 447 => 0x5 },
	'dynamicrangeoptimizermode' => { 189 => 0x15, 429 => 0x18, 430 => 0x16, 440 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 186 => 0x27, 431 => 0xc, 447 => 0x4 },
	'dynamicrangesetting' => { 129 => 0x1402 },
	'e-dialinprogram' => { 358 => '1.3' },
	'earliestageorloweststage' => { 120 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 120 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 120 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 120 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 120 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 481 => 'EarthPos' },
	'earthposaltitude' => { 481 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 481 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 481 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 481 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 481 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 481 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 481 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 481 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 314 => '6.1' },
	'easyexposurecompensation' => { 299 => '6.4', 300 => '6.5', 302 => '6.3', 303 => '6.3', 307 => '5.1', 308 => '4.4', 309 => '5.2', 312 => '6.3', 313 => '6.3', 315 => 0x1d, 316 => 0x1d, 317 => 0x1d },
	'easymode' => { 35 => 0xb },
	'edgemapslope' => { 140 => 0x930 },
	'edgemapx1' => { 140 => 0x931 },
	'edgemapx2' => { 140 => 0x932 },
	'edgemapx3' => { 140 => 0x934 },
	'edgemapx4' => { 140 => 0x935 },
	'edgenoisereduction' => { 293 => 0x4, 478 => 0x8028 },
	'edit1' => { 402 => "\xa9ed1" },
	'edit2' => { 402 => "\xa9ed2" },
	'edit3' => { 402 => "\xa9ed3" },
	'edit4' => { 402 => "\xa9ed4" },
	'edit5' => { 402 => "\xa9ed5" },
	'edit6' => { 402 => "\xa9ed6" },
	'edit7' => { 402 => "\xa9ed7" },
	'edit8' => { 402 => "\xa9ed8" },
	'edit9' => { 402 => "\xa9ed9" },
	'edition' => { 521 => 'edition' },
	'editorialupdate' => { 133 => 0x8 },
	'editstatus' => { 133 => 0x7, 389 => 'EditStatus', 497 => 'EditStatus' },
	'editversionname' => { 292 => 0x3d136244 },
	'effectivelv' => { 377 => 0x2d },
	'effectivemaxaperture' => { 229 => 0x12, 230 => 0x13, 234 => 0x14 },
	'eissn' => { 521 => 'eIssn' },
	'electricalblackcolumns' => { 140 => 0x1810 },
	'electronicfront-curtainshutter' => { 302 => '5.2', 303 => '5.2', 312 => '5.3', 313 => '5.2' },
	'electronicfrontcurtainshutter' => { 442 => 0x201a },
	'elevation' => { 167 => 'Elevation' },
	'email' => { 159 => 'EMail' },
	'embargodate' => { 524 => 'embargoDate' },
	'embdencrightsexpr' => { 516 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 516 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 516 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 516 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 519 => 'EmbeddedXMPDigest' },
	'emissivity' => { 123 => 0x3 },
	'emptyslotrelease' => { 241 => 0x723, 242 => 0x625, 243 => 0x655, 244 => 0x6bd },
	'enablechromanoisereduction' => { 140 => 0xe6e },
	'enablesharpening' => { 140 => 0x92e },
	'encodedby' => { 181 => 'WM/EncodedBy', 394 => "\xa9enc" },
	'encodedwith' => { 396 => 'Encoded_With' },
	'encoder' => { 394 => "\xa9too", 402 => "\xa9too" },
	'encoderid' => { 402 => "\xa9enc" },
	'encodingtime' => { 181 => 'WM/EncodingTime' },
	'encryptionkey' => { 416 => 0xa020 },
	'endingpage' => { 521 => 'endingPage' },
	'enduser' => { 329 => 'EndUser' },
	'enduserid' => { 329 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 329 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 241 => 0x746, 242 => 0x648, 243 => 0x678, 244 => 0x6e0 },
	'engineer' => { 531 => 'engineer' },
	'enhancedarktones' => { 285 => 0x8 },
	'enhancedenoisealreadyapplied' => { 499 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 499 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 499 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 499 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 499 => 'EnhanceDetailsVersion' },
	'enhancement' => { 114 => 0x16, 115 => 0x3016 },
	'enhanceparams' => { 121 => 0xc7ee },
	'enhancer' => { 323 => 0x300 },
	'enhancervalues' => { 323 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 499 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 499 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 499 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 134 => 0x28 },
	'envelopepriority' => { 134 => 0x3c },
	'enveloperecordversion' => { 134 => 0x0 },
	'episode' => { 516 => 'Episode' },
	'episodeglobaluniqueid' => { 394 => 'egid' },
	'episodeidentifier' => { 516 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 516 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 516 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 324 => 0x20c },
	'epsonimagewidth' => { 324 => 0x20b },
	'epsonsoftware' => { 324 => 0x20d },
	'equipmentinstitution' => { 480 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 480 => 'EquipmentManufacturer' },
	'equipmentversion' => { 320 => 0x0 },
	'ettlii' => { 86 => 0x304, 87 => 0xd, 88 => 0xe, 89 => 0x7, 90 => 0x7, 91 => 0xe },
	'event' => { 483 => 'Event', 495 => 'Event', 516 => 'Event', 521 => 'event' },
	'eventalias' => { 520 => 'eventAlias' },
	'eventdate' => { 120 => [\'Event','EventEventDate'] },
	'eventday' => { 120 => [\'Event','EventDay'] },
	'eventearliestdate' => { 120 => [\'Event','EventEarliestDate'] },
	'eventend' => { 520 => 'eventEnd' },
	'eventenddayofyear' => { 120 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 120 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 120 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 120 => [\'Event','EventHabitat'] },
	'eventid' => { 120 => [\'Event','EventEventID'], 516 => 'EventId' },
	'eventlatestdate' => { 120 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 120 => [\'Event','EventMonth'] },
	'eventnumber' => { 403 => 0x9, 404 => 0x37, 405 => 0x3a },
	'eventparenteventid' => { 120 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 120 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 120 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 120 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 120 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 120 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 520 => 'eventStart' },
	'eventstartdayofyear' => { 120 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 520 => 'eventSubtype' },
	'eventtime' => { 120 => [\'Event','EventEventTime'] },
	'eventtype' => { 520 => 'eventType' },
	'eventverbatimeventdate' => { 120 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 120 => [\'Event','EventYear'] },
	'evfgrid' => { 315 => 0x165, 316 => 0x165, 317 => 0x17d },
	'evfimageframe' => { 315 => 0x164, 316 => 0x164, 317 => 0x17c },
	'evfreleaseindicator' => { 315 => 0x24f, 316 => 0x24f, 317 => 0x267 },
	'evfwarmdisplaybrightness' => { 315 => 0x24d, 316 => 0x24d, 317 => 0x265 },
	'evfwarmdisplaymode' => { 315 => 0x24b, 316 => 0x24b, 317 => 0x263 },
	'evsteps' => { 358 => '1.2', 360 => 0x0 },
	'evstepsize' => { 304 => '5.1', 305 => '6.1', 306 => '6.1', 310 => '0.7' },
	'exclusivecoverage' => { 492 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 524 => 'exclusivityEndDate' },
	'excursiontolerance' => { 135 => 0x82 },
	'executiveproducer' => { 394 => "\xa9xpd" },
	'exif' => { 122 => 'EXIF' },
	'exifbyteorder' => { 122 => 'ExifByteOrder' },
	'exifcamerainfo' => { 133 => 0xe8 },
	'exifimageheight' => { 121 => 0xa003, 508 => 'PixelYDimension' },
	'exifimagewidth' => { 121 => 0xa002, 508 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 122 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 121 => 0x9000, 508 => 'ExifVersion' },
	'exitpupilposition' => { 229 => 0x4, 230 => 0x4, 234 => 0x4 },
	'expirationdate' => { 133 => 0x25, 524 => 'expirationDate' },
	'expirationtime' => { 133 => 0x26 },
	'exposure' => { 121 => 0xfe51, 502 => 'Exposure', 504 => 'Exposure' },
	'exposure2012' => { 502 => 'Exposure2012', 504 => 'Exposure2012' },
	'exposureadj' => { 290 => 0x0 },
	'exposureadj2' => { 290 => 0x12 },
	'exposureadjust' => { 419 => 0xc },
	'exposurebracketingindicatorlast' => { 186 => 0x52 },
	'exposurebracketshotnumber' => { 189 => 0x2d, 440 => 0x2f },
	'exposurebracketstepsize' => { 358 => 0x8 },
	'exposurebracketvalue' => { 236 => 0x19 },
	'exposurecompautocancel' => { 86 => 0x113 },
	'exposurecompensation' => { 78 => 0x6, 95 => 0x0, 121 => 0x9204, 142 => 0x24, 158 => 'ExposureComp', 178 => 'ExposureCompensation', 183 => 0xd, 184 => 0x53, 185 => 0x1e, 189 => 0x49c0, 324 => 0x1006, 377 => 0x16, 386 => 0x402, 416 => 0xa013, 419 => [0xc,0x35,0x4d], 451 => 0x114c, 452 => 0x114c, 453 => 0x1128, 455 => 0x1180, 456 => 0x1038, 457 => 0x230, 458 => 0x230, 459 => 0x223, 508 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 447 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 244 => 0x794 },
	'exposurecompensationmode' => { 186 => 0x47, 189 => 0x2a },
	'exposurecompensationset' => { 429 => 0x3, 430 => 0x3, 431 => 0x3, 447 => 0x1e },
	'exposurecompensationsetting' => { 186 => 0x1 },
	'exposurecompstepsize' => { 299 => '6.3', 300 => '7.3', 302 => '7.3', 303 => '7.3', 308 => '4.3', 312 => '7.3', 313 => '7.3' },
	'exposurecontrolstep' => { 307 => '6.1', 309 => '6.1' },
	'exposurecontrolstepsize' => { 299 => '6.2', 300 => '7.1', 302 => '7.1', 303 => '7.1', 308 => '4.2', 312 => '7.1', 313 => '7.1', 314 => '7.1', 315 => 0x1b, 316 => 0x1b, 317 => 0x1b },
	'exposurecount' => { 129 => 0x1032 },
	'exposuredelay' => { 244 => 0x800 },
	'exposuredelaymode' => { 299 => '10.1', 300 => '11.1', 302 => '11.1', 303 => '11.1', 304 => '9.1', 305 => '10.1', 306 => '10.1', 308 => '10.4', 309 => '10.1', 310 => '6.4', 312 => '11.1', 313 => '11.1', 314 => '11.2' },
	'exposuredifference' => { 236 => 0xe },
	'exposuregaincustom' => { 140 => 0x89c },
	'exposuregaindaylight' => { 140 => 0x898 },
	'exposuregainflash' => { 140 => 0x89b },
	'exposuregainfluorescent' => { 140 => 0x89a },
	'exposuregaintungsten' => { 140 => 0x899 },
	'exposureindex' => { 121 => 0xa215, 508 => 'ExposureIndex' },
	'exposureindicator' => { 186 => 0x50 },
	'exposurelevelincrements' => { 84 => 0x6, 85 => 0x6, 86 => 0x101, 87 => 0x5, 88 => 0x6, 89 => 0x5, 90 => 0x5, 91 => 0x6, 92 => 0x4, 429 => 0x58, 430 => 0x58 },
	'exposurelockused' => { 490 => 'ExposureLockUsed' },
	'exposuremode' => { 121 => 0xa402, 158 => 'ExposureMode', 183 => 0x1, 184 => 0xa, 185 => 0x0, 186 => 0x0, 189 => 0x34, 319 => 0x200, 339 => 0x40d, 419 => 0x8, 442 => 0xb041, 508 => 'ExposureMode' },
	'exposuremodeinmanual' => { 86 => 0x10b },
	'exposureprogram' => { 121 => 0x8822, 409 => 0x1001, 422 => [0x17e,0x43], 429 => 0x3c, 430 => 0x3c, 431 => 0x5, 435 => 0x14, 440 => 0x3f, 447 => 0x2, 451 => 0x1175, 452 => 0x1179, 453 => 0x1155, 454 => 0x11d1, 455 => 0x11ad, 456 => 0x1065, 457 => 0x25d, 458 => 0x25d, 459 => 0x24c, 470 => 0xb, 471 => 0xc, 472 => 0xb, 474 => 0x48, 508 => 'ExposureProgram' },
	'exposureshift' => { 319 => 0x203 },
	'exposurestandardadjustment' => { 442 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 78 => 0x16, 121 => 0x829a, 139 => 0xfd05, 142 => 0x20, 144 => 0xfa24, 146 => 0xf104, 149 => 0x12, 151 => 0x38, 153 => 0x14, 154 => 0x10, 156 => 0x10, 158 => 'ExposureTime', 183 => 0x9, 184 => 0x35, 185 => 0x48, 186 => 0x8, 189 => 0x49b8, 377 => 0x12, 416 => 0xa018, 419 => [0x32,0x4a], 429 => 0x0, 430 => 0x0, 447 => [0x21,0x23,0x27], 474 => 0x10, 508 => 'ExposureTime' },
	'exposuretime2' => { 419 => [0x33,0x4b] },
	'exposuretuning' => { 236 => 0x1c },
	'exposurevalue' => { 140 => 0x3 },
	'exposurewarning' => { 129 => 0x1302 },
	'exrauto' => { 129 => 0x1033 },
	'exrmode' => { 129 => 0x1034 },
	'extdescraccessibility' => { 515 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 241 => 0x120, 242 => 0x114, 243 => 0x124, 244 => 0x124 },
	'extendedshutterspeeds' => { 315 => 0x102, 316 => 0x102, 317 => 0x118 },
	'extendedwbdetect' => { 319 => 0x902 },
	'extender' => { 320 => 0x301 },
	'extenderfirmwareversion' => { 320 => 0x304 },
	'extendermagnification' => { 160 => 'Magnification' },
	'extendermake' => { 160 => 'Make' },
	'extendermodel' => { 160 => 'Model', 320 => 0x303 },
	'extenderserialnumber' => { 160 => 'SerialNumber', 320 => 0x302 },
	'extenderstatus' => { 375 => 0x3 },
	'externalflash' => { 322 => 0x1201 },
	'externalflashae1' => { 324 => 0x101f },
	'externalflashae1_0' => { 324 => 0x101b },
	'externalflashae2' => { 324 => 0x1020 },
	'externalflashae2_0' => { 324 => 0x101c },
	'externalflashbounce' => { 322 => 0x1204, 324 => 0x1026, 365 => 0x1a },
	'externalflashcompensation' => { 216 => 0x1b },
	'externalflashexposurecomp' => { 236 => 0x17, 365 => 0x19 },
	'externalflashfirmware' => { 214 => 0x6, 215 => 0x6, 216 => 0x6, 217 => 0x6, 218 => 0x6, 219 => 0x6 },
	'externalflashflags' => { 214 => 0x8, 215 => 0x8, 216 => 0x8, 217 => 0x8, 219 => 0x8 },
	'externalflashguidenumber' => { 322 => 0x1203, 365 => '24.1' },
	'externalflashgvalue' => { 324 => 0x1025 },
	'externalflashmode' => { 324 => 0x1028, 365 => 0x2 },
	'externalflashreadystate' => { 218 => '9.1' },
	'externalflashstatus' => { 218 => '8.2' },
	'externalflashzoom' => { 322 => 0x1205, 324 => 0x1027 },
	'externalflashzoomoverride' => { 218 => '8.1' },
	'externalmetadatalink' => { 516 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 337 => 0x311, 340 => 0x311, 341 => 0x311, 344 => 0x3408 },
	'extrainfoversion' => { 433 => 0x1a },
	'eyestartaf' => { 186 => 0x40 },
	'fac100per' => { 140 => 0xe94 },
	'fac170per' => { 140 => 0xe93 },
	'fac18per' => { 140 => 0xe92 },
	'face10position' => { 112 => 0x3f4, 113 => 0x1ec, 212 => 0x28, 362 => 0x12 },
	'face10size' => { 363 => 0x12 },
	'face11position' => { 212 => 0x2c, 362 => 0x14 },
	'face11size' => { 363 => 0x14 },
	'face12position' => { 212 => 0x30, 362 => 0x16 },
	'face12size' => { 363 => 0x16 },
	'face13position' => { 362 => 0x18 },
	'face13size' => { 363 => 0x18 },
	'face14position' => { 362 => 0x1a },
	'face14size' => { 363 => 0x1a },
	'face15position' => { 362 => 0x1c },
	'face15size' => { 363 => 0x1c },
	'face16position' => { 362 => 0x1e },
	'face16size' => { 363 => 0x1e },
	'face17position' => { 362 => 0x20 },
	'face17size' => { 363 => 0x20 },
	'face18position' => { 362 => 0x22 },
	'face18size' => { 363 => 0x22 },
	'face19position' => { 362 => 0x24 },
	'face19size' => { 363 => 0x24 },
	'face1position' => { 55 => 0x8, 112 => 0xd, 113 => 0x18, 212 => 0x4, 334 => 0x1, 362 => 0x0, 406 => 0xbc, 436 => 0x1, 437 => 0x0, 438 => 0x0, 439 => 0x5b },
	'face1size' => { 363 => 0x0 },
	'face20position' => { 362 => 0x26 },
	'face20size' => { 363 => 0x26 },
	'face21position' => { 362 => 0x28 },
	'face21size' => { 363 => 0x28 },
	'face22position' => { 362 => 0x2a },
	'face22size' => { 363 => 0x2a },
	'face23position' => { 362 => 0x2c },
	'face23size' => { 363 => 0x2c },
	'face24position' => { 362 => 0x2e },
	'face24size' => { 363 => 0x2e },
	'face25position' => { 362 => 0x30 },
	'face25size' => { 363 => 0x30 },
	'face26position' => { 362 => 0x32 },
	'face26size' => { 363 => 0x32 },
	'face27position' => { 362 => 0x34 },
	'face27size' => { 363 => 0x34 },
	'face28position' => { 362 => 0x36 },
	'face28size' => { 363 => 0x36 },
	'face29position' => { 362 => 0x38 },
	'face29size' => { 363 => 0x38 },
	'face2position' => { 55 => 0xa, 112 => 0x7c, 113 => 0x4c, 212 => 0x8, 334 => 0x5, 362 => 0x2, 406 => 0xc8, 436 => 0x6, 437 => 0x20, 438 => 0x25, 439 => 0x65 },
	'face2size' => { 363 => 0x2 },
	'face30position' => { 362 => 0x3a },
	'face30size' => { 363 => 0x3a },
	'face31position' => { 362 => 0x3c },
	'face31size' => { 363 => 0x3c },
	'face32position' => { 362 => 0x3e },
	'face32size' => { 363 => 0x3e },
	'face3position' => { 55 => 0xc, 112 => 0xeb, 113 => 0x80, 212 => 0xc, 334 => 0x9, 362 => 0x4, 406 => 0xd4, 436 => 0xb, 437 => 0x40, 438 => 0x4a, 439 => 0x6f },
	'face3size' => { 363 => 0x4 },
	'face4position' => { 55 => 0xe, 112 => 0x15a, 113 => 0xb4, 212 => 0x10, 334 => 0xd, 362 => 0x6, 406 => 0xe0, 436 => 0x10, 437 => 0x60, 438 => 0x6f, 439 => 0x79 },
	'face4size' => { 363 => 0x6 },
	'face5position' => { 55 => 0x10, 112 => 0x1c9, 113 => 0xe8, 212 => 0x14, 334 => 0x11, 362 => 0x8, 406 => 0xec, 436 => 0x15, 437 => 0x80, 438 => 0x94 },
	'face5size' => { 363 => 0x8 },
	'face6position' => { 55 => 0x12, 112 => 0x238, 113 => 0x11c, 212 => 0x18, 362 => 0xa, 406 => 0xf8, 436 => 0x1a, 437 => 0xa0, 438 => 0xb9 },
	'face6size' => { 363 => 0xa },
	'face7position' => { 55 => 0x14, 112 => 0x2a7, 113 => 0x150, 212 => 0x1c, 362 => 0xc, 406 => 0x104, 436 => 0x1f, 437 => 0xc0, 438 => 0xde },
	'face7size' => { 363 => 0xc },
	'face8position' => { 55 => 0x16, 112 => 0x316, 113 => 0x184, 212 => 0x20, 362 => 0xe, 406 => 0x110, 436 => 0x24, 437 => 0xe0, 438 => 0x103 },
	'face8size' => { 363 => 0xe },
	'face9position' => { 55 => 0x18, 112 => 0x385, 113 => 0x1b8, 212 => 0x24, 362 => 0x10 },
	'face9size' => { 363 => 0x10 },
	'facebalanceorigi' => { 496 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 496 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 496 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 496 => 'FaceBalanceWarmth' },
	'facedetect' => { 377 => 0x76, 416 => 0x100 },
	'facedetectarea' => { 323 => 0x1201 },
	'facedetectframecrop' => { 323 => 0x1207 },
	'facedetectframesize' => { 55 => 0x3, 112 => 0x1, 113 => 0x4, 212 => 0x1, 323 => 0x1203, 377 => 0x77, 406 => 0xb6 },
	'facedetection' => { 431 => 0x30, 447 => 0x19 },
	'faceelementpositions' => { 129 => 0x4203 },
	'faceelementselected' => { 129 => 0x4005 },
	'faceelementtypes' => { 129 => 0x4201 },
	'faceid' => { 498 => 'FaceID' },
	'faceinfounknown' => { 115 => 0x2089 },
	'facename' => { 416 => 0x123 },
	'faceorientation' => { 113 => 0x8 },
	'faceposition' => { 361 => 0x2, 417 => 0x4 },
	'facepositions' => { 129 => 0x4103 },
	'facerecognition' => { 416 => 0x120 },
	'facesdetected' => { 55 => 0x2, 56 => 0x2, 57 => 0x3, 112 => 0x0, 113 => 0x2, 115 => 0x211c, 129 => 0x4100, 212 => 0x3, 323 => 0x1200, 342 => 0x3f, 361 => 0x0, 406 => 0xb5, 417 => 0x0, 436 => 0x0, 439 => 0x3, 450 => 0x30 },
	'facesrecognized' => { 335 => 0x0 },
	'facewidth' => { 56 => 0x1 },
	'fade' => { 442 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 111 => 0x38 },
	'faithfuloutputshadowpoint' => { 111 => 0x39 },
	'faithfulrawcolortone' => { 111 => 0x31 },
	'faithfulrawcontrast' => { 111 => 0x33 },
	'faithfulrawhighlight' => { 111 => 0x79 },
	'faithfulrawhighlightpoint' => { 111 => 0x36 },
	'faithfulrawlinear' => { 111 => 0x34 },
	'faithfulrawsaturation' => { 111 => 0x32 },
	'faithfulrawshadow' => { 111 => 0x82 },
	'faithfulrawshadowpoint' => { 111 => 0x37 },
	'faithfulrawsharpness' => { 111 => 0x35 },
	'faithfulunsharpmaskfineness' => { 111 => 0xac },
	'faithfulunsharpmaskstrength' => { 111 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 111 => 0xae },
	'far' => { 487 => 'Far' },
	'fastresetlinetime' => { 140 => 0x1860 },
	'feedidentifier' => { 516 => 'FeedIdentifier' },
	'femicroadjustment' => { 86 => 0x111 },
	'ffid' => { 506 => 'ffid' },
	'field' => { 520 => 'field' },
	'fieldcount' => { 324 => 0x103f },
	'fieldofview' => { 402 => "FOV\x00" },
	'fifoenonepixeldelay' => { 140 => 0x1901 },
	'filecreatedate' => { 122 => 'FileCreateDate' },
	'filedatarate' => { 531 => 'fileDataRate' },
	'fileformat' => { 97 => 0x0, 134 => 0x14, 419 => [0x22,0x26], 442 => 0xb000 },
	'filegroupid' => { 122 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 343 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 122 => 'FileModifyDate' },
	'filename' => { 122 => 'FileName' },
	'filenameasdelivered' => { 329 => 'FileNameAsDelivered' },
	'filenumber' => { 58 => 0x1, 65 => 0x8, 99 => 0x1817, 116 => 'Canon-FileNumber', 213 => 0x4, 405 => 0x10 },
	'filenumbermemory' => { 183 => 0x1a },
	'filenumbersequence' => { 299 => '12.2', 304 => '3.1', 305 => '4.1', 306 => '4.1', 308 => '11.1', 309 => '4.3', 314 => '5.2', 315 => 0x48, 316 => 0x48, 317 => 0x48 },
	'filepermissions' => { 122 => 'FilePermissions' },
	'filesource' => { 121 => 0xa300, 129 => 0x8000, 508 => 'FileSource' },
	'fileuserid' => { 122 => 'FileUserID' },
	'fileversion' => { 134 => 0x16 },
	'fillflashautoreduction' => { 84 => 0xe, 85 => 0xe, 92 => 0xa },
	'filllight' => { 502 => 'FillLight', 504 => 'FillLight' },
	'fillorder' => { 121 => 0x10a },
	'filmgraineffect' => { 319 => 0x538 },
	'filmmode' => { 129 => 0x1401, 339 => 0x412, 342 => 0x42 },
	'filmtype' => { 259 => 0x2 },
	'filtereffect' => { 58 => 0xe, 251 => 0x37, 252 => 0x3f, 253 => 0x47, 342 => 0xa1 },
	'filtereffectauto' => { 72 => 0xa0 },
	'filtereffectfaithful' => { 71 => 0x70, 72 => 0x70 },
	'filtereffectlandscape' => { 71 => 0x40, 72 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 71 => 0x88, 72 => 0x88 },
	'filtereffectneutral' => { 71 => 0x58, 72 => 0x58 },
	'filtereffectportrait' => { 71 => 0x28, 72 => 0x28 },
	'filtereffectstandard' => { 71 => 0x10, 72 => 0x10 },
	'filtereffectuserdef1' => { 71 => 0xa0, 72 => 0xb8 },
	'filtereffectuserdef2' => { 71 => 0xb8, 72 => 0xd0 },
	'filtereffectuserdef3' => { 71 => 0xd0, 72 => 0xe8 },
	'finderdisplayduringexposure' => { 85 => 0x1 },
	'finesharpness' => { 377 => 0x70 },
	'finetuneoptcenterweighted' => { 299 => '7.2', 300 => '9.1', 302 => '9.1', 303 => '9.1', 307 => '8.1', 312 => '9.1', 313 => '9.1', 314 => '9.1', 315 => 0x23, 316 => 0x23, 317 => 0x23 },
	'finetuneopthighlightweighted' => { 302 => '46.1', 303 => '46.1', 312 => '46.1', 313 => '46.1', 315 => 0x27, 316 => 0x27, 317 => 0x27 },
	'finetuneoptmatrixmetering' => { 299 => '8.1', 300 => '8.2', 302 => '8.2', 303 => '8.2', 307 => '7.2', 308 => '6.1', 312 => '8.2', 313 => '8.2', 314 => '8.2', 315 => 0x21, 316 => 0x21, 317 => 0x21 },
	'finetuneoptspotmetering' => { 299 => '8.2', 300 => '9.2', 302 => '9.2', 303 => '9.2', 307 => '8.2', 308 => '6.2', 312 => '9.2', 313 => '9.2', 314 => '9.2', 315 => 0x25, 316 => 0x25, 317 => 0x25 },
	'finishexposure' => { 140 => 0xdbd },
	'finishfiletype' => { 140 => 0xdb8 },
	'finishlook' => { 140 => 0xdbc },
	'finishnoise' => { 140 => 0xdba },
	'finishresolution' => { 140 => 0xdb9 },
	'finishsharpening' => { 140 => 0xdbb },
	'firmware' => { 324 => 0x405, 419 => [0x8c,0x17,0x3b], 499 => 'Firmware' },
	'firmware2' => { 419 => 0x57 },
	'firmwaredate' => { 114 => 0x15, 115 => 0x2001, 403 => 0x4, 405 => 0x30 },
	'firmwareid' => { 190 => 0x0 },
	'firmwarename' => { 416 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 65 => 0x1e, 407 => 0x0 },
	'firmwarerevision2' => { 407 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 140 => [0x415,0xce5], 156 => 0x57, 158 => 'FirmwareVersion', 340 => 0x320, 342 => 0x2, 344 => 0x3109, 377 => 0x230, 402 => ['CNFV','FIRM'], 404 => 0x18, 405 => 0x2a, 409 => 0x2 },
	'firmwareversions' => { 386 => 0x301 },
	'firstphotodate' => { 490 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 329 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 133 => 0x16, 497 => 'FixtureIdentifier' },
	'flash' => { 116 => 'XMP-Flash', 121 => 0x9209, 154 => 0x22, 184 => 0x1f, 185 => 0x15, 405 => 0x5a, 508 => 'Flash' },
	'flashaction' => { 429 => 0x3e, 430 => 0x3e, 442 => 0x2017, 447 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 429 => 0x4c, 430 => 0x4c, 447 => 0x77 },
	'flashactionexternal' => { 447 => [0x78,0x7c] },
	'flashactivity' => { 35 => 0x1c },
	'flashbatterylevel' => { 45 => 0x249 },
	'flashbias' => { 342 => 0x24 },
	'flashbits' => { 35 => 0x1d },
	'flashburstpriority' => { 315 => 0x111, 316 => 0x111, 317 => 0x129 },
	'flashbuttonfunction' => { 86 => 0x70e },
	'flashchargelevel' => { 324 => 0x1010 },
	'flashcolorfilter' => { 216 => 0x10, 217 => 0x10, 219 => 0x10 },
	'flashcommandermode' => { 214 => '9.1', 215 => '9.1', 216 => '9.1', 217 => '9.1', 219 => '9.1' },
	'flashcompensation' => { 140 => 0x3f3, 214 => 0xa, 215 => 0xa, 216 => 0xa, 217 => 0x27, 218 => 0xa, 219 => 0xa, 499 => 'FlashCompensation' },
	'flashcontrol' => { 429 => 0x23, 430 => 0x1f, 431 => 0x21 },
	'flashcontrolbuilt-in' => { 308 => '16.1', 309 => '23.1', 311 => '23.1', 312 => '24.1' },
	'flashcontrolmode' => { 214 => '9.2', 215 => '9.2', 216 => '9.2', 217 => '9.2', 219 => '9.2', 225 => 0x214, 240 => 0x148, 241 => 0x1b8, 242 => 0x1a8, 243 => 0x1bc, 244 => 0x1bc, 319 => 0x404 },
	'flashcurtain' => { 342 => 0x48 },
	'flashdefault' => { 186 => 0x42 },
	'flashdevice' => { 324 => 0x1005 },
	'flashdistance' => { 115 => 0x2034 },
	'flashenergy' => { 121 => 0xa20b, 508 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 236 => 0x18 },
	'flashexposurecomp' => { 78 => 0xf, 129 => 0x1011, 161 => 'ExposureComp', 183 => 0x23, 188 => 0x104, 189 => 0x49c1, 236 => 0x12, 319 => 0x401, 324 => 0x1023, 377 => 0x4d, 409 => 0x100b, 419 => [0x3a,0x56], 442 => 0x104 },
	'flashexposurecomp2' => { 280 => 0x4d2 },
	'flashexposurecomp3' => { 216 => 0x1d },
	'flashexposurecomp4' => { 216 => 0x27 },
	'flashexposurecomparea' => { 300 => '38.4', 302 => '38.4', 303 => '38.4', 312 => '38.4', 313 => '38.4', 315 => 0x59, 316 => 0x59, 317 => 0x59 },
	'flashexposurecompset' => { 186 => 0x10, 350 => 0xe, 429 => 0x14, 430 => 0x12, 431 => 0x23, 447 => 0x1f },
	'flashexposurecompset2' => { 447 => [0x26,0x2c] },
	'flashexposureindicator' => { 186 => 0x54 },
	'flashexposureindicatorlast' => { 186 => 0x56 },
	'flashexposureindicatornext' => { 186 => 0x55 },
	'flashexposurelock' => { 58 => 0x19 },
	'flashfired' => { 142 => 0x5d, 161 => 'Fired', 183 => 0x14, 279 => '590.3', 508 => [\'Flash','FlashFired'] },
	'flashfiring' => { 86 => 0x306, 87 => 0x6, 88 => 0x7, 91 => 0x7 },
	'flashfirmwareversion' => { 320 => 0x1002 },
	'flashfocallength' => { 214 => 0xb, 215 => 0xc, 216 => 0xc, 217 => 0xc, 218 => 0xc, 219 => 0x26 },
	'flashfunction' => { 189 => 0x31, 508 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 214 => 0xe, 215 => 0xf, 216 => 0xf, 217 => 0xf, 218 => 0xf, 219 => 0xf, 225 => 0x21a, 240 => 0x14e, 242 => 0x1ae, 243 => 0x1c2, 244 => 0x1c2 },
	'flashgroupacompensation' => { 214 => 0x11, 215 => 0x12, 216 => 0x13, 217 => 0x28, 218 => 0x28, 219 => 0x28 },
	'flashgroupacontrolmode' => { 214 => 0xf, 215 => '16.1', 216 => '17.1', 217 => '17.1', 218 => '17.1', 219 => '17.1' },
	'flashgroupaoutput' => { 214 => 0x11, 215 => 0x12, 216 => 0x13, 217 => 0x28, 218 => 0x28, 219 => 0x28 },
	'flashgroupbcompensation' => { 214 => 0x12, 215 => 0x13, 216 => 0x14, 217 => 0x29, 218 => 0x29, 219 => 0x29 },
	'flashgroupbcontrolmode' => { 214 => 0x10, 215 => '17.1', 216 => '18.1', 217 => '18.1', 218 => '18.1', 219 => '18.1' },
	'flashgroupboutput' => { 214 => 0x12, 215 => 0x13, 216 => 0x14, 217 => 0x29, 218 => 0x29, 219 => 0x29 },
	'flashgroupccompensation' => { 215 => 0x14, 216 => 0x15, 217 => 0x2a, 218 => 0x2a, 219 => 0x2a },
	'flashgroupccontrolmode' => { 215 => '17.2', 216 => '18.2', 217 => '18.2', 218 => '18.2', 219 => '18.2' },
	'flashgroupcoutput' => { 215 => 0x14, 216 => 0x15, 217 => 0x2a, 218 => 0x2a, 219 => 0x2a },
	'flashguidenumber' => { 78 => 0xd, 96 => 0x0, 161 => 'GuideNumber' },
	'flashilluminationpattern' => { 219 => 0x25 },
	'flashintensity' => { 114 => [0x19,0x5], 319 => 0x405 },
	'flashlevel' => { 301 => 0x9, 442 => 0xb048 },
	'flashmake' => { 161 => 'Make' },
	'flashmanufacturer' => { 180 => 'FlashManufacturer' },
	'flashmastercompensation' => { 225 => 0x22e, 240 => 0x162, 242 => 0x1aa, 243 => 0x1be, 244 => 0x1be },
	'flashmastercontrolmode' => { 225 => 0x22c, 240 => 0x160 },
	'flashmasteroutput' => { 225 => 0x232, 240 => 0x166 },
	'flashmetering' => { 183 => 0x3f, 186 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 377 => 0x20a },
	'flashmode' => { 114 => 0x4, 140 => 0x3f2, 142 => 0x5c, 153 => 0x27, 161 => 'Mode', 183 => 0x2, 184 => 0x20, 185 => 0x16, 186 => 0xf, 236 => 0x87, 319 => 0x400, 324 => 0x1004, 377 => 0xc, 384 => 0x4, 408 => 0x20, 409 => 0x100a, 418 => 0x225, 429 => 0x13, 430 => 0x7f, 431 => 0x20, 447 => 0x10, 451 => 0x1138, 452 => 0x1138, 453 => 0x1114, 454 => 0x1190, 455 => 0x116c, 456 => 0x1024, 457 => 0x21c, 458 => 0x21c, 459 => 0x211, 508 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 244 => 0x80e },
	'flashmodebuttonplaybackmode' => { 244 => 0x818 },
	'flashmodel' => { 161 => 'Model', 180 => 'FlashModel', 320 => 0x1001 },
	'flashoptions' => { 358 => 0x2 },
	'flashoptions2' => { 358 => 0x10 },
	'flashoutput' => { 45 => 0x248, 78 => 0x21, 214 => 0xa, 215 => 0xa, 216 => 0xa, 217 => 0x27, 219 => 0x21, 225 => 0x21e, 240 => 0x152, 242 => 0x1b2, 243 => 0x1c6, 244 => 0x1c6 },
	'flashpixversion' => { 121 => 0xa000, 508 => 'FlashpixVersion' },
	'flashredeyemode' => { 508 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 225 => 0x228, 240 => 0x15c, 242 => 0x1bc, 319 => 0x403 },
	'flashreturn' => { 508 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 161 => 'SerialNumber', 320 => 0x1003 },
	'flashsetting' => { 236 => 0x8 },
	'flashshutterspeed' => { 299 => '20.2', 300 => '23.2', 302 => '23.2', 303 => '23.2', 308 => '15.2', 309 => '22.2', 310 => '7.2', 311 => '22.2', 312 => '23.2', 313 => '23.2', 314 => '23.1', 315 => 0x57, 316 => 0x57, 317 => 0x57 },
	'flashsource' => { 214 => 0x4, 215 => 0x4, 216 => 0x4, 217 => 0x4, 218 => 0x4, 219 => 0x4 },
	'flashstatus' => { 365 => 0x0, 447 => [0x82,0x86], 461 => 0x31, 462 => 0x39, 463 => 0x39 },
	'flashstatusbuilt-in' => { 431 => [0x87,0x287] },
	'flashstatusexternal' => { 431 => [0x88,0x288] },
	'flashsyncspeed' => { 299 => '20.1', 300 => '23.1', 302 => '23.1', 303 => '23.1', 308 => '15.1', 309 => '22.1', 311 => '22.1', 312 => '23.1', 313 => '23.1', 315 => 0x53, 316 => 0x53, 317 => 0x53 },
	'flashsyncspeedav' => { 84 => 0x3, 86 => 0x10f, 87 => 0x2, 88 => 0x3, 89 => 0x2, 90 => 0x2, 91 => 0x3, 92 => 0x6 },
	'flashthreshold' => { 96 => 0x1 },
	'flashtype' => { 161 => 'Type', 186 => 0x59, 236 => 0x9, 320 => 0x1000 },
	'flashwarning' => { 309 => '30.1', 310 => '7.1', 314 => '31.1', 342 => 0x62 },
	'flashwirelessoption' => { 225 => 0x234, 240 => 0x15a, 242 => 0x1c8 },
	'flexiblespotposition' => { 442 => 0x201d },
	'flickadvancedirection' => { 315 => 0x25f, 316 => 0x25f, 317 => 0x277 },
	'flickerreduce' => { 418 => 0x218 },
	'flickerreduction' => { 129 => 0x1446, 263 => 0x7 },
	'flickerreductionindicator' => { 258 => 0x532 },
	'flickerreductionshooting' => { 241 => 0x1b4, 242 => 0x1a4, 243 => 0x1b8, 244 => 0x1b8 },
	'flightpitchdegree' => { 118 => 'FlightPitchDegree' },
	'flightrolldegree' => { 118 => 'FlightRollDegree' },
	'flightxspeed' => { 118 => 'FlightXSpeed' },
	'flightyawdegree' => { 118 => 'FlightYawDegree' },
	'flightyspeed' => { 118 => 'FlightYSpeed' },
	'flightzspeed' => { 118 => 'FlightZSpeed' },
	'fliphorizontal' => { 292 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 78 => 0x15, 121 => 0x829d, 139 => 0xfd04, 142 => 0x1e, 144 => 0xfa23, 146 => 0xf103, 149 => 0x13, 151 => 0x3c, 153 => 0x1c, 154 => 0x18, 156 => 0xc, 165 => 'FNumber', 183 => 0xa, 184 => 0x36, 185 => 0x47, 186 => 0x9, 189 => 0x49c7, 234 => 0x38, 341 => 0x35a, 377 => 0x13, 416 => 0xa019, 419 => [0x31,0x49], 429 => 0x1, 430 => 0x1, 447 => [0x20,0x22,0x26], 508 => 'FNumber' },
	'focaldistance' => { 488 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 60 => 0x1, 115 => 0x1d, 121 => 0x920a, 149 => 0x1d, 165 => 'FocalLength', 183 => 0x12, 229 => 0xa, 230 => 0xb, 234 => [0xc,0x3c], 336 => 0x1, 377 => 0x1d, 386 => 0x403, 409 => 0x1500, 428 => 0xe, 455 => 0x1278, 456 => 0x1134, 457 => 0x32c, 458 => 0x32c, 459 => 0x30a, 508 => 'FocalLength' },
	'focallength2' => { 447 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 121 => 0xa405, 416 => 0xa01a, 508 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 428 => 0x10 },
	'focalplaneafpointarea' => { 460 => 0x2 },
	'focalplaneafpointlocation1' => { 460 => 0x6 },
	'focalplaneafpointlocation10' => { 460 => 0x2a },
	'focalplaneafpointlocation11' => { 460 => 0x2e },
	'focalplaneafpointlocation12' => { 460 => 0x32 },
	'focalplaneafpointlocation13' => { 460 => 0x36 },
	'focalplaneafpointlocation14' => { 460 => 0x3a },
	'focalplaneafpointlocation15' => { 460 => 0x3e },
	'focalplaneafpointlocation2' => { 460 => 0xa },
	'focalplaneafpointlocation3' => { 460 => 0xe },
	'focalplaneafpointlocation4' => { 460 => 0x12 },
	'focalplaneafpointlocation5' => { 460 => 0x16 },
	'focalplaneafpointlocation6' => { 460 => 0x1a },
	'focalplaneafpointlocation7' => { 460 => 0x1e },
	'focalplaneafpointlocation8' => { 460 => 0x22 },
	'focalplaneafpointlocation9' => { 460 => 0x26 },
	'focalplaneafpointsused' => { 460 => 0x1 },
	'focalplanediagonal' => { 320 => 0x103, 324 => 0x205 },
	'focalplaneresolutionunit' => { 121 => 0xa210, 508 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 121 => 0xa20e, 508 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 60 => 0x2 },
	'focalplanexunknown' => { 60 => 0x2 },
	'focalplaneyresolution' => { 121 => 0xa20f, 508 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 60 => 0x3 },
	'focalplaneyunknown' => { 60 => 0x3 },
	'focalpointx' => { 488 => 'FocalPointX' },
	'focalpointy' => { 488 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 60 => 0x0 },
	'focalunits' => { 35 => 0x19 },
	'focus' => { 282 => 0x8 },
	'focusarea' => { 183 => 0x31 },
	'focusareaselection' => { 310 => '15.2' },
	'focusbracket' => { 342 => 0xbd },
	'focusbracketstepsize' => { 319 => 0x308 },
	'focuscontinuous' => { 35 => 0x20 },
	'focusdisplayaiservoandmf' => { 86 => 0x515 },
	'focusdistance' => { 165 => 'FocusDistance', 183 => 0x13, 189 => 0x49bb, 229 => 0x9, 230 => 0xa, 234 => [0xb,0x4e], 322 => 0x305, 336 => 0x0, 340 => 0x304, 341 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 58 => 0x15, 78 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 234 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 58 => 0x14, 78 => 0x13 },
	'focusholdbutton' => { 186 => 0x44 },
	'focusinfoversion' => { 322 => 0x0 },
	'focusingscreen' => { 85 => 0x0, 86 => 0x80b, 91 => 0x0 },
	'focuslocation' => { 442 => 0x2027 },
	'focuslocked' => { 182 => 0x14 },
	'focusmode' => { 35 => 0x7, 114 => 0x3, 115 => [0x3003,0xd], 129 => 0x1021, 140 => 0x3f5, 142 => 0x38, 158 => 'FocusMode', 183 => 0x30, 185 => 0xe, 186 => 0xc, 236 => 0x7, 319 => 0x301, 324 => 0x100b, 342 => 0x7, 377 => 0xd, 384 => 0x3, 409 => 0x1006, 422 => [0xb,0x5], 428 => [0x15,0x1d], 429 => 0x4d, 430 => 0x4d, 442 => [0xb042,0xb04e,0x201b], 447 => 0x13, 468 => 0x16 },
	'focusmode2' => { 128 => '0.1', 358 => '3.1', 447 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 301 => '10.1', 426 => 0x14, 427 => 0x15, 429 => 0x10, 430 => 0xf, 431 => 0x6 },
	'focusmodeswitch' => { 186 => 0x58, 429 => 0x2e },
	'focuspeakingdisplay' => { 315 => 0x235, 316 => 0x235, 317 => 0x24d },
	'focuspeakinghighlightcolor' => { 315 => 0x4b, 316 => 0x4b, 317 => 0x4b },
	'focuspeakinglevel' => { 315 => 0x49, 316 => 0x49, 317 => 0x49 },
	'focuspixel' => { 129 => 0x1023 },
	'focuspointlock' => { 315 => 0x1d3, 316 => 0x1d3, 317 => 0x1eb },
	'focuspointpersistence' => { 315 => 0x105, 316 => 0x105, 317 => 0x11b },
	'focuspointwrap' => { 299 => '2.2', 300 => '2.2', 302 => '2.1', 303 => '2.1', 307 => '1.1', 308 => '2.2', 309 => '1.1', 312 => '2.2', 313 => '2.1', 314 => '2.5', 315 => 0x16, 316 => 0x16, 317 => 0x16 },
	'focusposition' => { 1 => 0x2f, 229 => 0x8, 230 => 0x8, 377 => 0x10, 440 => 0x9bb },
	'focusposition2' => { 447 => [0x29,0x2b,0x2f], 468 => 0x2d, 471 => 0x20 },
	'focuspositionhorizontal' => { 195 => 0x2f, 196 => 0x43 },
	'focuspositionvertical' => { 195 => 0x31, 196 => 0x45 },
	'focusprocess' => { 319 => 0x302 },
	'focusrange' => { 35 => 0x12, 324 => 0x100a },
	'focusrangeindex' => { 368 => '3.1' },
	'focusresult' => { 196 => 0x4a },
	'focusringrotation' => { 86 => 0x713 },
	'focussetting' => { 419 => 0x6 },
	'focusshiftautoreset' => { 243 => 0x6da, 244 => 0x748 },
	'focusshiftexposurelock' => { 225 => 0x1b4, 240 => 0xe8, 241 => 0x100, 242 => 0xf4, 243 => 0x104, 244 => 0x104 },
	'focusshiftinterval' => { 225 => 0x1b0, 240 => 0xe4, 241 => 0xfc, 242 => 0xf0, 243 => 0x100, 244 => 0x100 },
	'focusshiftnumbershots' => { 225 => 0x1a8, 240 => 0xdc, 241 => 0xf4, 242 => 0xe8, 243 => 0xf8, 244 => 0xf8 },
	'focusshiftshooting' => { 261 => 0x20 },
	'focusshiftstepwidth' => { 225 => 0x1ac, 240 => 0xe0, 241 => 0xf8, 242 => 0xec, 243 => 0xfc, 244 => 0xfc },
	'focusstatus' => { 428 => 0x19, 429 => 0x53, 430 => 0x53 },
	'focusstepcount' => { 322 => 0x301, 324 => 0x100e },
	'focusstepinfinity' => { 322 => 0x303, 324 => 0x103b },
	'focusstepnear' => { 322 => 0x304, 324 => 0x103c },
	'focusstepsfrominfinity' => { 234 => 0x58 },
	'focustrackinglockon' => { 299 => ['1.5','4.1'], 300 => '1.4', 307 => '0.4', 308 => '3.1', 309 => '0.4', 312 => '1.4' },
	'focuswarning' => { 129 => 0x1301 },
	'foldername' => { 183 => 0x27 },
	'foldernumber' => { 429 => 0x9a, 431 => [0x402,0x114,0x316] },
	'fontcomposite' => { 536 => [\'Fonts','FontsComposite'] },
	'fontface' => { 536 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 536 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 536 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 536 => [\'Fonts','FontsFontName'] },
	'fonts' => { 536 => 'Fonts' },
	'fonttype' => { 536 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 536 => [\'Fonts','FontsVersionString'] },
	'for' => { 393 => 'For' },
	'forcewrite' => { 122 => 'ForceWrite' },
	'format' => { 402 => "\xa9fmt", 487 => 'Format', 505 => 'format', 529 => 'Format' },
	'forwardlock' => { 526 => 'forwardlock' },
	'forwardmatrix1' => { 121 => 0xc714 },
	'forwardmatrix2' => { 121 => 0xc715 },
	'forwardmatrix3' => { 121 => 0xcd34 },
	'fossilspecimen' => { 120 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 120 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 68 => [0x2,0x4] },
	'frameheight' => { 129 => 0x3822 },
	'framenum' => { 388 => 0xd7 },
	'framenumber' => { 129 => 0x8003, 189 => 0x3c, 377 => 0x29 },
	'framerate' => { 68 => [0x1,0x6], 121 => 0xc764, 129 => 0x3820 },
	'framereadouttime' => { 396 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 129 => 0x3821 },
	'framing' => { 520 => 'framing' },
	'freebytes' => { 99 => 0x1 },
	'freememorycardimages' => { 184 => [0x37,0x54], 185 => [0x2d,0x4a], 186 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 129 => 0x1010 },
	'fujimodel' => { 129 => 0x1447 },
	'fujimodel2' => { 129 => 0x1448 },
	'fullhdhighspeedrec' => { 129 => 0x3824 },
	'fullimagesize' => { 442 => 0xb02b },
	'fullpanoheightpixels' => { 490 => 'FullPanoHeightPixels', 491 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 490 => 'FullPanoWidthPixels', 491 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 409 => 0x100d },
	'fullsizeimage' => { 164 => 'data' },
	'fullsizeimagename' => { 164 => '1Name' },
	'fullsizeimagetype' => { 164 => '0Type' },
	'func1button' => { 302 => '14.1', 303 => '14.1', 313 => '14.1', 315 => 0x63, 316 => 0x63, 317 => 0x63 },
	'func1buttonplaybackmode' => { 315 => 0x1a5, 316 => 0x1a5, 317 => 0x1bd },
	'func1buttonplusdials' => { 302 => '42.1', 303 => '42.1', 313 => '42.1' },
	'func2button' => { 302 => '80.1', 303 => '80.1', 313 => '80.1', 315 => 0x73, 316 => 0x73, 317 => 0x73 },
	'func2buttonplaybackmode' => { 315 => 0x1a7, 316 => 0x1a7, 317 => 0x1bf },
	'func2buttonplusdials' => { 302 => '81.1' },
	'func3button' => { 302 => '83.1', 316 => 0x119, 317 => 0x131 },
	'func3buttonplaybackmode' => { 316 => 0x1a9, 317 => 0x1c1 },
	'func4button' => { 316 => 0x175, 317 => 0x18d },
	'func4buttonplaybackmode' => { 316 => 0x1af, 317 => 0x1c7 },
	'funcbutton' => { 299 => ['14.1','15.1'], 300 => '14.1', 308 => '28.1', 309 => '13.1', 312 => '14.1', 314 => '14.1' },
	'funcbuttonplusdials' => { 299 => ['14.2','15.2'], 300 => '14.2', 308 => '31.1', 312 => '42.1' },
	'functionbutton' => { 306 => '13.1', 310 => '5.2' },
	'gainbase' => { 323 => 0x610 },
	'gaincontrol' => { 121 => 0xa407, 508 => 'GainControl' },
	'gainmapmax' => { 513 => 'GainMapMax' },
	'gainmapmin' => { 513 => 'GainMapMin' },
	'gamma' => { 121 => 0xa500, 140 => 0x8fe, 330 => 'gAMA', 347 => 0x11c, 509 => 'Gamma', 513 => 'Gamma' },
	'gammablackpoint' => { 107 => 0xc },
	'gammacolortone' => { 107 => 0x3 },
	'gammacompensatedvalue' => { 135 => 0x91 },
	'gammacontrast' => { 107 => 0x2 },
	'gammacurveoutputrange' => { 107 => 0xf },
	'gammahighlight' => { 107 => 0xa },
	'gammalinear' => { 105 => 0x20200 },
	'gammamidpoint' => { 107 => 0xe },
	'gammasaturation' => { 107 => 0x4 },
	'gammashadow' => { 107 => 0x9 },
	'gammasharpnessstrength' => { 107 => 0x8 },
	'gammaunsharpmaskfineness' => { 107 => 0x6 },
	'gammaunsharpmaskstrength' => { 107 => 0x5 },
	'gammaunsharpmaskthreshold' => { 107 => 0x7 },
	'gammawhitepoint' => { 107 => 0xd },
	'garminsettings' => { 402 => 'pmcc' },
	'garminsoftware' => { 402 => 'uuid' },
	'gdalmetadata' => { 121 => 0xa480 },
	'gdalnodata' => { 121 => 0xa481 },
	'geimagesize' => { 129 => 0x1304 },
	'gemake' => { 131 => 0x300 },
	'gemodel' => { 131 => 0x207 },
	'genre' => { 394 => ['gnre',"\xa9gen"], 396 => 'genre', 402 => ['gnre',"\xa9gen"], 516 => 'Genre', 521 => 'genre', 531 => 'genre' },
	'genrecvid' => { 516 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 516 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 516 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 516 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 394 => 'geID' },
	'geography' => { 522 => 'geography' },
	'geologicalcontext' => { 120 => 'GeologicalContext' },
	'geologicalcontextbed' => { 120 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 120 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 120 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 120 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 120 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 122 => 'Geosync' },
	'geotag' => { 122 => 'Geotag' },
	'geotiffasciiparams' => { 121 => 0x87b1 },
	'geotiffdirectory' => { 121 => 0x87af },
	'geotiffdoubleparams' => { 121 => 0x87b0 },
	'geotime' => { 122 => 'Geotime' },
	'giftftppriority' => { 492 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 118 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 118 => 'GimbalReverse' },
	'gimbalrolldegree' => { 118 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 118 => 'GimbalYawDegree' },
	'globalaltitude' => { 391 => 0x419 },
	'globalangle' => { 391 => 0x40d },
	'good' => { 531 => 'good' },
	'googlehostheader' => { 394 => 'gshh' },
	'googlepingmessage' => { 394 => 'gspm' },
	'googlepingurl' => { 394 => 'gspu' },
	'googleplusuploadcode' => { 121 => 0x9009 },
	'googlesourcedata' => { 394 => 'gssd' },
	'googlestarttime' => { 394 => 'gsst' },
	'googletrackduration' => { 394 => 'gstd' },
	'goprotype' => { 402 => 'GoPr' },
	'gpsaltitude' => { 132 => 0x6, 162 => 'Altitude', 508 => 'GPSAltitude' },
	'gpsaltituderef' => { 132 => 0x5, 508 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 132 => 0x1c, 508 => 'GPSAreaInformation' },
	'gpscoordinates' => { 394 => "\xa9xyz", 396 => 'location.ISO6709', 402 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 132 => 0x1d },
	'gpsdatetime' => { 162 => 'DateTime', 508 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 132 => 0x18, 162 => 'Bearing', 508 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 132 => 0x17, 508 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 132 => 0x1a, 162 => 'Distance', 508 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 132 => 0x19, 508 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 132 => 0x14, 508 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 132 => 0x13 },
	'gpsdestlongitude' => { 132 => 0x16, 508 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 132 => 0x15 },
	'gpsdifferential' => { 132 => 0x1e, 162 => 'Differential', 508 => 'GPSDifferential' },
	'gpsdop' => { 132 => 0xb, 508 => 'GPSDOP' },
	'gpshpositioningerror' => { 132 => 0x1f, 508 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 132 => 0x11, 508 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 132 => 0x10, 508 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 116 => 'GPS-GPSLatitude', 118 => 'GpsLatitude', 132 => 0x2, 162 => 'Latitude', 508 => 'GPSLatitude' },
	'gpslatituderef' => { 132 => 0x1 },
	'gpslongitude' => { 116 => 'GPS-GPSLongitude', 118 => 'GpsLongitude', 132 => 0x4, 162 => 'Longitude', 508 => 'GPSLongitude' },
	'gpslongituderef' => { 132 => 0x3 },
	'gpslongtitude' => { 118 => 'GpsLongtitude' },
	'gpsmapdatum' => { 132 => 0x12, 162 => 'Datum', 508 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 132 => 0xa, 162 => 'MeasureMode', 508 => 'GPSMeasureMode' },
	'gpsposition' => { 116 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 132 => 0x1b, 508 => 'GPSProcessingMethod' },
	'gpssatellites' => { 132 => 0x8, 162 => 'Satellites', 508 => 'GPSSatellites' },
	'gpsspeed' => { 132 => 0xd, 162 => 'Speed', 508 => 'GPSSpeed' },
	'gpsspeedref' => { 132 => 0xc, 508 => 'GPSSpeedRef' },
	'gpsstatus' => { 132 => 0x9, 508 => 'GPSStatus' },
	'gpsstring' => { 140 => 0x402 },
	'gpstimestamp' => { 132 => 0x7 },
	'gpstrack' => { 132 => 0xf, 162 => 'Heading', 508 => 'GPSTrack' },
	'gpstrackref' => { 132 => 0xe, 508 => 'GPSTrackRef' },
	'gpsversionid' => { 132 => 0x0, 508 => 'GPSVersionID' },
	'gradation' => { 319 => 0x50f },
	'gradientbasedcorractive' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 502 => 'GradientBasedCorrections', 504 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 504 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 502 => 'GrainAmount', 504 => 'GrainAmount' },
	'graineffectroughness' => { 129 => 0x1047 },
	'graineffectsize' => { 129 => 0x104c },
	'grainfrequency' => { 502 => 'GrainFrequency', 504 => 'GrainFrequency' },
	'grainseed' => { 502 => 'GrainSeed', 504 => 'GrainSeed' },
	'grainsize' => { 502 => 'GrainSize', 504 => 'GrainSize' },
	'graymixeraqua' => { 502 => 'GrayMixerAqua', 504 => 'GrayMixerAqua' },
	'graymixerblue' => { 502 => 'GrayMixerBlue', 504 => 'GrayMixerBlue' },
	'graymixergreen' => { 502 => 'GrayMixerGreen', 504 => 'GrayMixerGreen' },
	'graymixermagenta' => { 502 => 'GrayMixerMagenta', 504 => 'GrayMixerMagenta' },
	'graymixerorange' => { 502 => 'GrayMixerOrange', 504 => 'GrayMixerOrange' },
	'graymixerpurple' => { 502 => 'GrayMixerPurple', 504 => 'GrayMixerPurple' },
	'graymixerred' => { 502 => 'GrayMixerRed', 504 => 'GrayMixerRed' },
	'graymixeryellow' => { 502 => 'GrayMixerYellow', 504 => 'GrayMixerYellow' },
	'graypoint' => { 478 => 0x8021 },
	'grayresponseunit' => { 121 => 0x122 },
	'greencurvelimits' => { 110 => 0x1c4 },
	'greencurvepoints' => { 109 => 0x53, 110 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 105 => 0x20913 },
	'greenhue' => { 502 => 'GreenHue', 504 => 'GreenHue' },
	'greensaturation' => { 502 => 'GreenSaturation', 504 => 'GreenSaturation' },
	'griddisplay' => { 299 => '13.3', 300 => '4.3', 302 => '4.2', 303 => '4.2', 304 => '2.2', 308 => '10.5', 309 => '3.4', 310 => '6.1', 312 => '4.4', 313 => '4.2', 314 => '4.2' },
	'gripbatteryadload' => { 356 => 0x5 },
	'gripbatteryadnoload' => { 356 => 0x4 },
	'gripbatterystate' => { 356 => '1.2' },
	'group' => { 502 => 'Group', 504 => 'Group' },
	'groupareaafillumination' => { 300 => '46.4', 303 => '47.4', 312 => '47.4' },
	'grouping' => { 394 => ['grup',"\xa9grp"], 402 => "\xa9grp" },
	'guid' => { 394 => 'GUID' },
	'h2resetblackpixels' => { 140 => 0x18a6 },
	'h3resetblackcolumns' => { 140 => 0x18ce },
	'h3resetblackpixels' => { 140 => 0x18b0 },
	'halftonehints' => { 121 => 0x141 },
	'hardlink' => { 122 => 'HardLink' },
	'hasalternative' => { 521 => 'hasAlternative' },
	'hascorrection' => { 521 => 'hasCorrection' },
	'hascorrectiona-lang' => { 521 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 521 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 521 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 502 => 'HasCrop', 504 => 'HasCrop' },
	'hasextendedxmp' => { 533 => 'HasExtendedXMP' },
	'hassettings' => { 502 => 'HasSettings', 504 => 'HasSettings' },
	'hastranslation' => { 521 => 'hasTranslation' },
	'hasvisibleoverprint' => { 536 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 536 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 240 => 0x35a },
	'hdmioutputresolution' => { 241 => 0x710, 242 => 0x610, 243 => 0x640, 244 => 0x6a8 },
	'hdmiviewassist' => { 316 => 0x20f, 317 => 0x227 },
	'hdr' => { 61 => 0x1, 221 => 0x4, 222 => 0x4, 241 => 0x23a, 244 => 0x23a, 342 => 0x9e, 377 => 0x85, 442 => 0x200a },
	'hdrcapacitymax' => { 513 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 513 => 'HDRCapacityMin' },
	'hdreditmode' => { 502 => 'HDREditMode', 504 => 'HDREditMode' },
	'hdreffect' => { 61 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 221 => 0x5, 222 => 0x5, 241 => 0x246, 244 => 0x246, 431 => 0x2e, 447 => 0x17 },
	'hdrlevel2' => { 221 => 0x7 },
	'hdrplusmakernote' => { 485 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 485 => 'hdrp_makernote' },
	'hdrsetting' => { 431 => 0x2d, 447 => 0x16, 451 => 0x1148, 452 => 0x1148, 453 => 0x1124, 454 => 0x11a0, 455 => 0x117c, 456 => 0x1034, 457 => 0x22c, 458 => 0x22c, 459 => 0x21f },
	'hdrsmoothing' => { 221 => 0x6 },
	'hdvideo' => { 394 => 'hdvd' },
	'headline' => { 133 => 0x69, 516 => 'Headline', 519 => 'Headline' },
	'hierarchicalkeywords' => { 173 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 173 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 173 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 173 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 173 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 173 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 173 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 494 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 120 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 241 => 0x48, 243 => 0x48, 244 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 241 => 0x27c, 243 => 0x27c, 244 => 0x27c },
	'highisomultiplierblue' => { 347 => 0x1a },
	'highisomultipliergreen' => { 347 => 0x19 },
	'highisomultiplierred' => { 347 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 63 => 0x5, 86 => 0x202, 236 => 0xb1, 377 => 0x71, 429 => 0x2c, 430 => 0x26, 431 => 0x26, 442 => 0x2009, 447 => 0x12, 474 => 0x42 },
	'highisonoisereduction2' => { 442 => 0xb050 },
	'highlight' => { 419 => 0xf },
	'highlight2012' => { 502 => 'Highlight2012', 504 => 'Highlight2012' },
	'highlightadj' => { 105 => 0x2030c },
	'highlightcolordistortreduct' => { 478 => 0x8026 },
	'highlightlinearitylimit' => { 416 => 0xa025 },
	'highlightprotection' => { 291 => 0x6 },
	'highlightrecovery' => { 502 => 'HighlightRecovery', 504 => 'HighlightRecovery' },
	'highlights' => { 442 => 0x2033, 496 => 'Highlights' },
	'highlights2012' => { 502 => 'Highlights2012', 504 => 'Highlights2012' },
	'highlightsadj' => { 478 => 0x9019 },
	'highlightshadow' => { 342 => 0xad },
	'highlighttone' => { 129 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 63 => 0x3, 86 => 0x203 },
	'highlightwarning' => { 342 => 0x8002 },
	'highlowkeyadj' => { 377 => 0x6c },
	'highspeedsync' => { 186 => 0x5, 315 => 0x55, 316 => 0x55, 317 => 0x55, 429 => 0x2, 430 => 0x2 },
	'hintversion' => { 402 => 'hinv' },
	'histogramxml' => { 292 => 0x83a1a25 },
	'history' => { 519 => 'History', 532 => 'History' },
	'historyaction' => { 532 => [\'History','HistoryAction'] },
	'historychanged' => { 532 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 532 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 532 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 532 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 532 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 140 => 0xc88 },
	'holefilldeltathreshold' => { 140 => 0xc7e },
	'hometowncity' => { 115 => 0x3006, 377 => 0x23, 383 => 0x2 },
	'hometowncitycode' => { 384 => 0x1000 },
	'hometowndst' => { 377 => 0x25, 383 => '0.2' },
	'hostcomputer' => { 121 => 0x13c },
	'hostsoftwarerendering' => { 140 => 0xce7 },
	'hue' => { 191 => 0x3b, 252 => 0x3d, 253 => 0x45, 377 => 0x67 },
	'hueadj' => { 295 => 0x2f, 478 => 0x8019 },
	'hueadjust' => { 409 => 0x1016 },
	'hueadjustment' => { 184 => 0x4a, 185 => 0x40, 236 => 0x92, 251 => 0x36 },
	'hueadjustmentaqua' => { 502 => 'HueAdjustmentAqua', 504 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 502 => 'HueAdjustmentBlue', 504 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 502 => 'HueAdjustmentGreen', 504 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 502 => 'HueAdjustmentMagenta', 504 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 502 => 'HueAdjustmentOrange', 504 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 502 => 'HueAdjustmentPurple', 504 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 502 => 'HueAdjustmentRed', 504 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 502 => 'HueAdjustmentYellow', 504 => 'HueAdjustmentYellow' },
	'huesetting' => { 327 => 0x1011 },
	'humanobservation' => { 120 => 'HumanObservation' },
	'humanobservationday' => { 120 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 120 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 120 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 120 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 120 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 120 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 120 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 120 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 120 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 120 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 120 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 120 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 120 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 120 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 120 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 120 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 120 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 120 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 120 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 120 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 121 => 0x9401, 509 => 'Humidity' },
	'icc_profile' => { 122 => 'ICC_Profile' },
	'iccprofilename' => { 519 => 'ICCProfile' },
	'iconuri' => { 402 => 'icnu' },
	'idccreativestyle' => { 478 => 0x8000 },
	'idcpreviewlength' => { 478 => 0x202 },
	'idcpreviewstart' => { 478 => 0x201 },
	'identification' => { 120 => 'Identification' },
	'identificationid' => { 120 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 120 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 120 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 120 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 120 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 120 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 120 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 505 => 'identifier', 529 => 'Identifier' },
	'ifcameramodel' => { 140 => 0x9c8 },
	'illuminantdata1' => { 121 => 0xcd35 },
	'illuminantdata2' => { 121 => 0xcd36 },
	'illuminantdata3' => { 121 => 0xcd37 },
	'illumination' => { 310 => '0.5', 404 => 0x48 },
	'imageabsolutex' => { 140 => 0x3fe },
	'imageabsolutey' => { 140 => 0x3ff },
	'imageadjustment' => { 236 => 0x80, 282 => 0x5 },
	'imagealterationconstraints' => { 329 => 'ImageAlterationConstraints' },
	'imagearea' => { 268 => 0x10, 271 => 0x10 },
	'imageareaoffset' => { 377 => 0x38 },
	'imageauthentication' => { 236 => 0x20 },
	'imageboundary' => { 236 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 129 => 0x1438, 236 => 0xa5, 445 => 0x11b },
	'imagecreator' => { 329 => 'ImageCreator' },
	'imagecreatorid' => { 329 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 329 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 329 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 140 => 0x41f },
	'imagecropy' => { 140 => 0x420 },
	'imagedata' => { 489 => 'Data' },
	'imagedatasize' => { 236 => 0xa2 },
	'imagedescription' => { 121 => 0x10e, 527 => 'ImageDescription' },
	'imageduplicationconstraints' => { 329 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 292 => 0xfe443a45 },
	'imageeditcount' => { 377 => 0x41 },
	'imageediting' => { 377 => 0x32 },
	'imageeditingsoftware' => { 121 => 0xa43b },
	'imageeditor' => { 121 => 0xa438 },
	'imageeffects' => { 409 => 0x1010 },
	'imagefileconstraints' => { 329 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 329 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 329 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 129 => 0x1436 },
	'imageheight' => { 121 => 0x101, 190 => 0xc, 386 => 0x10d, 487 => 'ImageHeight', 527 => 'ImageLength' },
	'imagehistory' => { 121 => 0x9213, 507 => 'ImageHistory' },
	'imageidnumber' => { 337 => 0x340 },
	'imagemimetype' => { 489 => 'Mime' },
	'imagenumber' => { 121 => 0x9211, 158 => 'ImageNumber', 184 => 0xae, 185 => 0x5e, 386 => 0x113, 429 => 0x9b, 431 => [0x400,'276.1',0x314], 499 => 'ImageNumber' },
	'imagenumber2' => { 185 => 0x62 },
	'imageoptimization' => { 236 => 0xa9 },
	'imageorientation' => { 133 => 0x83 },
	'imageprocessing' => { 236 => 0x1a },
	'imageprocessingfiledatecreated' => { 140 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 140 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 323 => 0x0 },
	'imagequality' => { 158 => 'ImageQuality', 270 => '723.2', 271 => '732.2', 279 => '708.1', 342 => 0x1 },
	'imagequality2' => { 319 => 0x603 },
	'imagerank' => { 492 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 140 => 0x600 },
	'imagerboardversion' => { 140 => 0x439 },
	'imagercols' => { 140 => 0x17d4 },
	'imageref' => { 514 => 'ImageRef' },
	'imageregion' => { 516 => 'ImageRegion' },
	'imageregionboundary' => { 516 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 516 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 516 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 516 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 516 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 516 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 516 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 516 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 516 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 516 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 140 => 0x944 },
	'imageresolutionjpg' => { 140 => 0x945 },
	'imagereview' => { 301 => '0.4', 310 => '0.4' },
	'imagereviewmonitorofftime' => { 300 => '21.1', 302 => '21.1', 303 => '21.1', 307 => '20.1', 312 => '21.1', 313 => '21.1', 315 => 0x39, 316 => 0x39, 317 => 0x39 },
	'imagereviewtime' => { 299 => '25.1', 301 => '2.1', 304 => '19.1', 305 => '20.1', 306 => '20.1', 308 => '9.2', 309 => '20.1', 314 => '21.2' },
	'imagerfiledatecreated' => { 140 => 0x9c5 },
	'imagerfileproductionlevel' => { 140 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 140 => 0x9c7 },
	'imagerotated' => { 153 => 0x2a },
	'imagerpowerondelaymsec' => { 140 => 0x5fd },
	'imagerrows' => { 140 => 0x17de },
	'imagesegmentlines' => { 140 => 0x184d },
	'imagesegmentstartline' => { 140 => 0x184c },
	'imagesequenceinfo' => { 121 => 0xcd44 },
	'imagesize' => { 164 => 'ImageSize' },
	'imagesizeraw' => { 236 => 0x3e },
	'imagesizerestriction' => { 524 => 'imageSizeRestriction' },
	'imagesourcedata' => { 121 => 0x935c },
	'imagespace' => { 140 => 0x909 },
	'imagestabilization' => { 35 => 0x22, 115 => 0x3020, 129 => 0x1422, 158 => 'ImageStabilization', 184 => 0xbd, 185 => 0x71, 186 => 0x57, 187 => 0x0, 188 => [0x18,0x107,0x113], 189 => 0x49c2, 236 => 0xac, 319 => 0x604, 322 => 0x1600, 342 => 0x1a, 434 => 0x12, 435 => 0x11, 442 => 0xb026 },
	'imagestabilization2' => { 433 => 0xa },
	'imagestabilizationsetting' => { 189 => 0x14, 429 => 0x3d, 430 => 0x3d, 440 => 0x14 },
	'imagestats' => { 121 => 0xcd46 },
	'imagestyle' => { 429 => 0x2d, 430 => 0x27 },
	'imagesupplier' => { 329 => 'ImageSupplier' },
	'imagesupplierid' => { 329 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 329 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 329 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 123 => 0x1 },
	'imagetemperaturemin' => { 123 => 0x2 },
	'imagetone' => { 377 => 0x4f },
	'imagetype' => { 133 => 0x82, 329 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 65 => 0x28, 121 => 0xa420, 507 => 'ImageUniqueID', 508 => 'ImageUniqueID' },
	'imagewidth' => { 121 => 0x100, 190 => 0xe, 386 => 0x10c, 487 => 'ImageWidth', 527 => 'ImageWidth' },
	'inclinationangle' => { 478 => 0x900f },
	'inclinationcorrection' => { 478 => 0x900e },
	'incrementaltemperature' => { 502 => 'IncrementalTemperature', 504 => 'IncrementalTemperature' },
	'incrementaltint' => { 502 => 'IncrementalTint', 504 => 'IncrementalTint' },
	'industry' => { 521 => 'industry', 522 => 'industry' },
	'infobuttonwhenshooting' => { 86 => 0x409 },
	'information' => { 396 => 'information', 402 => "\xa9inf" },
	'infourl' => { 402 => 'infu' },
	'infraredilluminator' => { 403 => 0x28 },
	'ingredientexclusion' => { 523 => 'ingredientExclusion' },
	'ingredients' => { 532 => 'Ingredients' },
	'ingredientsalternatepaths' => { 532 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 532 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 532 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 532 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 532 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 532 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 532 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 532 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 532 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 532 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 532 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 532 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 532 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 532 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 532 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 532 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 532 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 532 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 532 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 532 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 532 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 532 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 532 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 86 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 490 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 490 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 181 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 490 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 490 => 'InitialViewHeadingDegrees', 491 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 490 => 'InitialViewPitchDegrees', 491 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 490 => 'InitialViewRollDegrees', 491 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 299 => '4.4' },
	'initialzoomsetting' => { 299 => '9.3', 308 => '27.3' },
	'inkset' => { 121 => 0x14c },
	'inputprofile' => { 140 => 0x1389 },
	'instanceid' => { 532 => 'InstanceID' },
	'instantplaybacksetup' => { 186 => 0x3e },
	'instantplaybacktime' => { 186 => 0x3d },
	'instructions' => { 519 => 'Instructions' },
	'instrument' => { 531 => 'instrument' },
	'integrationtime' => { 140 => 0x423 },
	'intellectualgenre' => { 515 => 'IntellectualGenre' },
	'intelligentauto' => { 442 => 0xb052, 470 => 0xd, 471 => 0xe, 472 => 0xd },
	'intelligentcontrast' => { 53 => 0x4 },
	'intelligentd-range' => { 342 => 0x79 },
	'intelligentexposure' => { 342 => 0x5d },
	'intelligentresolution' => { 342 => 0x70 },
	'interchangecolorspace' => { 135 => 0x40 },
	'intergraphmatrix' => { 121 => 0x8480 },
	'internalflash' => { 183 => 0x2b, 299 => '23.1', 301 => '8.1', 304 => '22.1', 306 => '23.1', 310 => '8.1', 314 => '24.1', 322 => 0x1208 },
	'internalflashae1' => { 324 => 0x1021 },
	'internalflashae1_0' => { 324 => 0x101d },
	'internalflashae2' => { 324 => 0x1022 },
	'internalflashae2_0' => { 324 => 0x101e },
	'internalflashmode' => { 365 => 0x1 },
	'internalflashstrength' => { 365 => 0x3 },
	'internalflashtable' => { 324 => 0x1024 },
	'internallensserialnumber' => { 416 => 0xa005 },
	'internalndfilter' => { 342 => 0x9d },
	'internalserialnumber' => { 65 => 0x96, 77 => 0x9, 129 => 0x10, 189 => 0x49dc, 318 => 0x18, 320 => 0x102, 339 => 0x500, 342 => 0x25, 357 => 0x4, 409 => 0x5, 461 => [0x7c,0xf0], 462 => 0x88, 463 => [0x88,0x8a], 464 => 0x38 },
	'interopindex' => { 121 => 0x1, 509 => 'InteroperabilityIndex' },
	'interopversion' => { 121 => 0x2 },
	'interval' => { 258 => 0x20 },
	'intervaldurationhours' => { 240 => 0xa0, 241 => 0xb8 },
	'intervaldurationminutes' => { 240 => 0xa4, 241 => 0xbc },
	'intervaldurationseconds' => { 240 => 0xa8, 241 => 0xc0 },
	'intervalexposuresmoothing' => { 225 => 0x184, 240 => 0xb8, 241 => 0xd0 },
	'intervalframe' => { 258 => 0x24 },
	'intervallength' => { 183 => 0x10 },
	'intervalmode' => { 183 => 0x26 },
	'intervalnumber' => { 183 => 0x11 },
	'intervalpriority' => { 225 => 0x186, 240 => 0xba, 241 => 0xd2 },
	'intervals' => { 225 => 0x17c, 240 => 0xb0, 241 => 0xc8, 242 => 0xbc, 243 => 0xcc, 244 => 0xcc },
	'intervalshooting' => { 226 => 0x24, 260 => 0x24, 261 => 0x28, 377 => 0x92 },
	'introtime' => { 531 => 'introTime' },
	'introtimescale' => { 531 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 531 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 140 => 0xdae },
	'ipfcameramodel' => { 140 => 0xe4d },
	'iptc' => { 122 => 'IPTC' },
	'iptc-naa' => { 121 => 0x83bb, 347 => 0x83bb },
	'iptcbitspersample' => { 135 => 0x56 },
	'iptcdigest' => { 391 => 0x425 },
	'iptcimageheight' => { 135 => 0x1e },
	'iptcimagerotation' => { 135 => 0x66 },
	'iptcimagewidth' => { 135 => 0x14 },
	'iptclastedited' => { 516 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 135 => 0xa },
	'iptcpixelheight' => { 135 => 0x32 },
	'iptcpixelwidth' => { 135 => 0x28 },
	'isalternativeof' => { 521 => 'isAlternativeOf' },
	'isbn' => { 521 => 'isbn' },
	'iscorrectionof' => { 521 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 111 => 0x3 },
	'ismergedhdr' => { 499 => 'IsMergedHDR' },
	'ismergedpanorama' => { 499 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 114 => 0x14, 115 => [0x3014,0x14], 121 => 0x8827, 139 => 0xfd06, 140 => 0x1784, 142 => 0x60, 144 => [0xfa2e,0xfa46], 145 => [0x27,0x28], 146 => 0xf105, 149 => 0x14, 151 => 0x4e, 153 => 0x1e, 154 => 0x1a, 156 => 0x34, 158 => 'ISO', 183 => 0x8, 189 => 0x49ba, 224 => 0x0, 236 => 0x2, 342 => 0xd1, 347 => 0x17, 377 => [0x8b,0x14], 384 => 0x14, 386 => 0x105, 416 => 0xa014, 419 => 0x86, 440 => 0x6f, 447 => [0x1f,0x21,0x25], 508 => 'ISOSpeedRatings' },
	'iso2' => { 224 => 0x6, 265 => 0x265, 266 => 0x25c, 267 => 0x265, 268 => 0x221, 269 => 0x25d, 270 => 0x256, 271 => 0x25d, 274 => 0x2b5, 277 => 0x265, 281 => 0x2b5 },
	'isoauto' => { 358 => '14.4' },
	'isoautoflashlimit' => { 241 => 0x156, 242 => 0x146, 243 => 0x15a, 244 => 0x15a },
	'isoautohilimit' => { 223 => 0x5, 241 => 0x154, 242 => 0x144, 243 => 0x158, 244 => 0x158, 263 => 0x5, 273 => 0x18eb },
	'isoautomax' => { 441 => 0x4 },
	'isoautomin' => { 441 => 0x2 },
	'isoautoparameters' => { 377 => 0x7a },
	'isoautoshuttertime' => { 223 => 0x4, 241 => 0x15e, 242 => 0x14e, 243 => 0x162, 244 => 0x162, 263 => 0x4, 273 => 0x18ea },
	'isobutton' => { 244 => 0x796 },
	'isocalibrationgain' => { 140 => 0x89f },
	'isodisplay' => { 302 => '4.1', 303 => '4.1', 304 => '2.3', 305 => '3.3', 306 => '3.3', 309 => '3.3', 312 => '4.3', 313 => '4.1', 314 => '4.3' },
	'isoexpansion' => { 86 => 0x103, 87 => 0x7, 88 => 0x8, 91 => 0x8, 224 => 0x4 },
	'isoexpansion2' => { 224 => 0xa },
	'isofloor' => { 358 => 0x6 },
	'isoselected' => { 341 => 0x359 },
	'isoselection' => { 236 => 0xf },
	'isosensitivitystep' => { 307 => '6.2', 309 => '6.2' },
	'isosetting' => { 142 => 0x5e, 154 => 0x14, 158 => 'ISOSetting', 183 => 0x24, 184 => 0x26, 185 => 0x1c, 186 => 0x13, 191 => 0x6, 236 => 0x13, 358 => '17.3', 408 => 0x27, 429 => 0x16, 430 => 0x14, 431 => 0x2, 440 => 0x6d, 441 => 0x0 },
	'isospeed' => { 121 => 0x8833, 509 => 'ISOSpeed' },
	'isospeedexpansion' => { 85 => 0x3 },
	'isospeedincrements' => { 86 => 0x102 },
	'isospeedlatitudeyyy' => { 121 => 0x8834, 509 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 121 => 0x8835, 509 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 86 => 0x103 },
	'isostepsize' => { 299 => '6.1', 300 => '7.2', 302 => '7.2', 303 => '7.2', 308 => '4.1', 312 => '7.2', 313 => '7.2', 315 => 0x15d, 316 => 0x15d, 317 => 0x175 },
	'isovalue' => { 324 => 0x1001 },
	'isrc' => { 394 => 'xid ' },
	'isrccode' => { 402 => "\xa9isr" },
	'issn' => { 521 => 'issn' },
	'issueidentifier' => { 521 => 'issueIdentifier' },
	'issuename' => { 521 => 'issueName' },
	'issueteaser' => { 521 => 'issueTeaser' },
	'issuetype' => { 521 => 'issueType' },
	'istranslationof' => { 521 => 'isTranslationOf' },
	'itemsubtype' => { 180 => 'ItemSubType' },
	'itunesu' => { 394 => 'itnu' },
	'jobid' => { 133 => 0xb8 },
	'jobname' => { 510 => 'JobName' },
	'jobref' => { 530 => 'JobRef' },
	'jobrefid' => { 530 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 530 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 530 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 510 => 'JobStatus' },
	'jpeg-heifswitch' => { 442 => 0x2039 },
	'jpeghandling' => { 502 => 'JPEGHandling', 504 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 342 => 0x43, 344 => 0x3034, 442 => 0xb047 },
	'jpegsize' => { 344 => 0x303a },
	'jpgcompression' => { 227 => 0x24, 236 => 0x44, 268 => '671.1' },
	'jpgfromraw' => { 99 => 0x2007, 116 => 'Exif-JpgFromRaw', 347 => 0x2e },
	'jpgfromrawlength' => { 121 => [0x117,0x202] },
	'jpgfromrawstart' => { 121 => [0x111,0x201] },
	'jpgrecordedpixels' => { 358 => '14.1' },
	'jurisdiction' => { 500 => 'jurisdiction' },
	'keepexposure' => { 315 => 0x237, 316 => 0x237, 317 => 0x24f },
	'kelvinwb_01' => { 366 => 0x5 },
	'kelvinwb_02' => { 366 => 0x9 },
	'kelvinwb_03' => { 366 => 0xd },
	'kelvinwb_04' => { 366 => 0x11 },
	'kelvinwb_05' => { 366 => 0x15 },
	'kelvinwb_06' => { 366 => 0x19 },
	'kelvinwb_07' => { 366 => 0x1d },
	'kelvinwb_08' => { 366 => 0x21 },
	'kelvinwb_09' => { 366 => 0x25 },
	'kelvinwb_10' => { 366 => 0x29 },
	'kelvinwb_11' => { 366 => 0x2d },
	'kelvinwb_12' => { 366 => 0x31 },
	'kelvinwb_13' => { 366 => 0x35 },
	'kelvinwb_14' => { 366 => 0x39 },
	'kelvinwb_15' => { 366 => 0x3d },
	'kelvinwb_16' => { 366 => 0x41 },
	'kelvinwb_daylight' => { 366 => 0x1 },
	'kerneldenominators' => { 140 => 0x933 },
	'key' => { 531 => 'key' },
	'keystonecompensation' => { 323 => 0x1900 },
	'keystonedirection' => { 323 => 0x1901 },
	'keystonevalue' => { 323 => 0x1906 },
	'keyword' => { 394 => 'keyw', 521 => 'keyword' },
	'keywordinfo' => { 173 => 'Keywords' },
	'keywords' => { 133 => 0x19, 159 => 'Keywords', 328 => 'Keywords', 393 => 'Keywords', 396 => 'keywords', 497 => 'keywords', 518 => 'Keywords', 529 => 'Keywords' },
	'killdate' => { 521 => 'killDate' },
	'killdatea-platform' => { 521 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 521 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 139 => 0xf908, 142 => 0xe, 144 => [0xfa1e,0xfa52], 150 => 0x70 },
	'kodakimagewidth' => { 139 => 0xf907, 142 => 0xc, 144 => [0xfa1d,0xfa51], 150 => 0x6c },
	'kodakinfotype' => { 139 => 0xfa00 },
	'kodaklook' => { 140 => 0xe4c },
	'kodaklookprofile' => { 140 => 0x138a },
	'kodakmaker' => { 150 => 0x8 },
	'kodakmodel' => { 142 => 0x0, 150 => 0x28 },
	'kodaktag' => { 140 => 0x3ea },
	'kodakversion' => { 140 => 0x0 },
	'label' => { 332 => 'Label', 529 => 'Label' },
	'labelname1' => { 514 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 514 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 342 => 0x6f },
	'landscapeoutputhighlightpoint' => { 111 => 0x26 },
	'landscapeoutputshadowpoint' => { 111 => 0x27 },
	'landscaperawcolortone' => { 111 => 0x1f },
	'landscaperawcontrast' => { 111 => 0x21 },
	'landscaperawhighlight' => { 111 => 0x77 },
	'landscaperawhighlightpoint' => { 111 => 0x24 },
	'landscaperawlinear' => { 111 => 0x22 },
	'landscaperawsaturation' => { 111 => 0x20 },
	'landscaperawshadow' => { 111 => 0x80 },
	'landscaperawshadowpoint' => { 111 => 0x25 },
	'landscaperawsharpness' => { 111 => 0x23 },
	'landscapeunsharpmaskfineness' => { 111 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 111 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 111 => 0xa2 },
	'language' => { 241 => 0x692, 242 => 0x592, 243 => 0x5c2, 244 => 0x5da, 505 => 'language' },
	'languageidentifier' => { 133 => 0x87 },
	'largestvalidinteriorrectheight' => { 490 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 490 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 490 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 490 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 183 => 0x1b },
	'lastkeywordiptc' => { 180 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 180 => 'LastKeywordXMP' },
	'lastphotodate' => { 490 => 'LastPhotoDate' },
	'lasturl' => { 532 => 'LastURL' },
	'lateralchromaticaberration' => { 442 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 499 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 120 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 120 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 120 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 120 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 120 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 118 => 'Latitude' },
	'lc1' => { 368 => 0x2 },
	'lc10' => { 368 => 0xb },
	'lc11' => { 368 => 0xc },
	'lc12' => { 368 => 0xd },
	'lc14' => { 368 => 0xf },
	'lc15' => { 368 => 0x10 },
	'lc3' => { 368 => 0x4 },
	'lc4' => { 368 => 0x5 },
	'lc5' => { 368 => 0x6 },
	'lc6' => { 368 => 0x7 },
	'lc7' => { 368 => 0x8 },
	'lc8' => { 368 => 0x9 },
	'lcddisplayatpoweron' => { 86 => 0x811, 90 => 0xa },
	'lcddisplayreturntoshoot' => { 91 => 0x12 },
	'lcdillumination' => { 299 => '17.5', 300 => '5.2', 302 => '5.1', 303 => '5.1', 308 => '10.3', 309 => '4.2', 312 => '5.2', 313 => '5.1', 314 => '5.4', 315 => 0x101, 316 => 0x101, 317 => 0x117 },
	'lcdilluminationduringbulb' => { 86 => 0x408 },
	'lcdmatrix' => { 140 => 0xe74 },
	'lcdmatrixchickfix' => { 140 => 0xe75 },
	'lcdmatrixmarvin' => { 140 => 0xe76 },
	'lcdpanels' => { 85 => 0x8 },
	'lcheditor' => { 292 => 0x8ae85e },
	'legacyiptcdigest' => { 519 => 'LegacyIPTCDigest' },
	'legalcode' => { 500 => 'legalcode' },
	'lens' => { 121 => 0xfdea, 236 => 0x84, 499 => 'Lens' },
	'lensafstopbutton' => { 84 => 0x11, 85 => 0x13, 86 => 0x506, 87 => 0x10, 88 => 0x12, 91 => 0x13, 92 => 0x9 },
	'lensaperturerange' => { 419 => [0x30,0x48] },
	'lensblur' => { 502 => 'LensBlur', 504 => 'LensBlur' },
	'lensbluractive' => { 502 => [\'LensBlur','LensBlurActive'], 504 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 502 => [\'LensBlur','LensBlurBlurAmount'], 504 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 502 => [\'LensBlur','LensBlurBokehAspect'], 504 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 502 => [\'LensBlur','LensBlurBokehRotation'], 504 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 502 => [\'LensBlur','LensBlurBokehShape'], 504 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 502 => [\'LensBlur','LensBlurBokehShapeDetail'], 504 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 502 => [\'LensBlur','LensBlurCatEyeAmount'], 504 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 502 => [\'LensBlur','LensBlurCatEyeScale'], 504 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 502 => [\'LensBlur','LensBlurFocalRange'], 504 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 502 => [\'LensBlur','LensBlurFocalRangeSource'], 504 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 502 => [\'LensBlur','LensBlurHighlightsBoost'], 504 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 502 => [\'LensBlur','LensBlurHighlightsThreshold'], 504 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 502 => [\'LensBlur','LensBlurSampledArea'], 504 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 502 => [\'LensBlur','LensBlurSampledRange'], 504 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 502 => [\'LensBlur','LensBlurSphericalAberration'], 504 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 502 => [\'LensBlur','LensBlurSubjectRange'], 504 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 502 => [\'LensBlur','LensBlurVersion'], 504 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 315 => 0xad, 316 => 0xad, 317 => 0xad },
	'lenscorrectionsettings' => { 507 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 499 => 'LensDistortInfo' },
	'lensdistortionparams' => { 324 => 0x206 },
	'lensdriveend' => { 234 => 0x56 },
	'lensdrivenoaf' => { 86 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 431 => 0x3f0, 477 => 0xd },
	'lensfirmware' => { 410 => 0x20, 416 => 0xa004 },
	'lensfirmwareversion' => { 320 => 0x204, 342 => 0x60, 431 => 0x3f3, 477 => 0x14 },
	'lensfocallength' => { 105 => 0xf0512, 368 => 0x9 },
	'lensfocalrange' => { 419 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 300 => '55.1', 302 => '52.1', 303 => '52.1', 312 => '52.1', 313 => '52.1' },
	'lensformat' => { 455 => 0x1891, 457 => 0x18bd, 458 => 0x18ed, 459 => 0x17f1, 461 => 0x106, 462 => 0x106, 473 => 0x603, 474 => 0x5d },
	'lensfstops' => { 228 => 0x7, 229 => 0xc, 230 => 0xd, 234 => 0xe, 236 => 0x8b, 368 => '0.3' },
	'lensfunc1button' => { 315 => 0x9f, 316 => 0x9f, 317 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 244 => 0x810 },
	'lensfunc2button' => { 315 => 0xa7, 316 => 0xa7, 317 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 244 => 0x812 },
	'lensid' => { 234 => 0x30, 499 => 'LensID' },
	'lensidnumber' => { 228 => 0x6, 229 => 0xb, 230 => 0xc, 234 => 0xd },
	'lensinfo' => { 121 => 0xa432, 374 => 0x2a, 499 => 'LensInfo', 509 => 'LensSpecification' },
	'lenskind' => { 368 => 0x1 },
	'lensmake' => { 121 => 0xa433, 165 => 'Make', 509 => 'LensMake' },
	'lensmanualdistortionamount' => { 502 => 'LensManualDistortionAmount', 504 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 180 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 419 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 65 => 0x95, 121 => 0xa434, 165 => 'Model', 180 => 'LensModel', 231 => 0x18a, 232 => 0x18b, 233 => 0x2ac, 320 => 0x203, 374 => 0xc, 386 => 0x412, 509 => 'LensModel' },
	'lensmodulationoptimizer' => { 129 => 0x1045 },
	'lensmount' => { 431 => 0x99, 455 => 0x1892, 457 => 0x18be, 458 => 0x18ee, 459 => 0x17f2, 461 => 0x105, 462 => 0x105, 473 => 0x604, 474 => 0x5e },
	'lensmount2' => { 477 => 0x8 },
	'lensmounttype' => { 234 => 0x35 },
	'lenspositionabsolute' => { 234 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 502 => 'LensProfileChromaticAberrationScale', 504 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 502 => 'LensProfileDigest', 504 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 502 => 'LensProfileDistortionScale', 504 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 502 => 'LensProfileEnable', 504 => 'LensProfileEnable' },
	'lensprofilefilename' => { 502 => 'LensProfileFilename', 504 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 502 => 'LensProfileIsEmbedded', 504 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 502 => 'LensProfileMatchKeyCameraModelName', 504 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 502 => 'LensProfileMatchKeyExifMake', 504 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 502 => 'LensProfileMatchKeyExifModel', 504 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 502 => 'LensProfileMatchKeyIsRaw', 504 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 502 => 'LensProfileMatchKeyLensID', 504 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 502 => 'LensProfileMatchKeyLensInfo', 504 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 502 => 'LensProfileMatchKeyLensName', 504 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 502 => 'LensProfileMatchKeySensorFormatFactor', 504 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 502 => 'LensProfileName', 504 => 'LensProfileName' },
	'lensprofilesetup' => { 502 => 'LensProfileSetup', 504 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 502 => 'LensProfileVignettingScale', 504 => 'LensProfileVignettingScale' },
	'lensproperties' => { 320 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 33 => 0x16b, 62 => 0x0, 121 => 0xa435, 165 => 'SerialNumber', 320 => 0x202, 340 => 0x321, 342 => 0x52, 402 => 'LENS', 410 => 0x30, 499 => 'LensSerialNumber', 509 => 'LensSerialNumber' },
	'lensshutterlock' => { 186 => 0x4a },
	'lensspec' => { 426 => 0x0, 427 => 0x0, 428 => 0x0, 442 => 0xb02a },
	'lensspecfeatures' => { 461 => [0x115,0x116], 462 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 324 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 35 => 0x16, 188 => 0x10c, 189 => 0x49bd, 236 => 0x83, 320 => 0x201, 333 => 0x16, 337 => 0x310, 339 => 0x303, 340 => 0x303, 342 => 0x51, 344 => 0x3405, 369 => 0x0, 370 => 0x0, 371 => 0x1, 372 => 0x1, 373 => 0x1, 375 => 0x0, 416 => 0xa003, 419 => 0x27, 442 => 0xb027, 455 => 0x1896, 457 => 0x18c2, 458 => 0x18f2, 459 => 0x17f6, 461 => 0x109, 462 => 0x109, 473 => 0x608, 474 => 0x62 },
	'lenstype2' => { 431 => 0x3f7, 455 => 0x1893, 457 => 0x18bf, 458 => 0x18ef, 459 => 0x17f3, 461 => 0x107, 462 => 0x107, 473 => 0x605, 474 => 0x60 },
	'lenstype3' => { 477 => 0x9 },
	'lenstypemake' => { 342 => 0xc4 },
	'lenstypemodel' => { 342 => [0xc5,0xe4] },
	'lenszoomposition' => { 470 => 0x19, 471 => 0x1e, 474 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 350 => 0x15 },
	'levelmeter' => { 402 => ['Lvlm','lvlm'] },
	'levelorientation' => { 376 => 0x0 },
	'license' => { 500 => 'license' },
	'licensee' => { 329 => 'Licensee' },
	'licenseeid' => { 329 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 329 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 329 => 'LicenseeImageNotes' },
	'licenseename' => { 329 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 329 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 329 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 329 => 'LicenseeTransactionID' },
	'licenseid' => { 329 => 'LicenseID' },
	'licensestartdate' => { 329 => 'LicenseStartDate' },
	'licensetransactiondate' => { 329 => 'LicenseTransactionDate' },
	'licensetype' => { 506 => 'licensetype' },
	'licensor' => { 329 => 'Licensor' },
	'licensorcity' => { 329 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 329 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 329 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 329 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 329 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 329 => 'LicensorImageID' },
	'licensorname' => { 329 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 329 => 'LicensorNotes' },
	'licensorpostalcode' => { 329 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 329 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 329 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 329 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 329 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 329 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 329 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 329 => 'LicensorTransactionID' },
	'licensorurl' => { 329 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 324 => 0x1009 },
	'lightingmode' => { 115 => 0x302a },
	'lightreading' => { 377 => 0x15 },
	'lightsource' => { 121 => 0x9208, 236 => 0x90, 327 => 0x1000, 508 => 'LightSource' },
	'lightsourcespecial' => { 418 => 0x21d },
	'lightswitch' => { 312 => '0.1', 314 => '0.1' },
	'lightvaluecenter' => { 324 => 0x103d },
	'lightvalueperiphery' => { 324 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 315 => 0x153, 316 => 0x153, 317 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 315 => 0x151, 316 => 0x151, 317 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 315 => 0x150, 316 => 0x150, 317 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 315 => 0x14f, 316 => 0x14f, 317 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 315 => 0x11, 316 => 0x11, 317 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 315 => 0x14, 316 => 0x14, 317 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 315 => 0x13, 316 => 0x13, 317 => 0x13 },
	'limitafareamodeselauto' => { 315 => 0x15, 316 => 0x15, 317 => 0x15 },
	'limitafareamodeselection' => { 300 => '51.1', 302 => '49.1', 303 => '49.1', 312 => '49.1', 313 => '49.1' },
	'limitreleasemodeselc120' => { 316 => '269.4', 317 => '293.4' },
	'limitreleasemodeselc30' => { 316 => '269.3', 317 => '293.3' },
	'limitreleasemodeselch' => { 316 => '269.2', 317 => '293.2' },
	'limitreleasemodeselcl' => { 316 => '269.1', 317 => '293.1' },
	'limitreleasemodeselself' => { 316 => '269.5', 317 => '293.5' },
	'limitselectableimagearea16to9' => { 315 => 0x47, 316 => 0x47, 317 => 0x47 },
	'limitselectableimagearea1to1' => { 315 => 0x46, 316 => 0x46, 317 => 0x46 },
	'limitselectableimageareadx' => { 315 => 0x45, 316 => 0x45, 317 => 0x45 },
	'linearitylimitblue' => { 347 => 0x10 },
	'linearitylimitgreen' => { 347 => 0xf },
	'linearitylimitred' => { 347 => 0xe },
	'linearityuppermargin' => { 42 => 0x32c, 43 => 0x282, 46 => [0x2ba,0x2d1,0x2d5], 48 => 0x1e5, 49 => [0x1fe,0x2de], 50 => [0x232,0x310], 51 => 0x31e },
	'linearizationtable' => { 121 => 0xc618 },
	'linearresponselimit' => { 121 => 0xc62e },
	'link' => { 521 => 'link' },
	'linkaetoafpoint' => { 358 => '14.2' },
	'linkedencodedrightsexpr' => { 516 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 516 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 516 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 516 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 140 => 0x904 },
	'lithostratigraphicterms' => { 120 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 396 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 396 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 396 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 304 => '32.1', 314 => '34.1' },
	'liveviewafareamode' => { 309 => '34.1' },
	'liveviewafmethod' => { 447 => 0x20 },
	'liveviewafmode' => { 309 => '34.2' },
	'liveviewafsetting' => { 431 => 0x36 },
	'liveviewbuttonoptions' => { 300 => '50.2', 302 => '48.2', 303 => '48.2', 312 => '48.2', 313 => '48.2' },
	'liveviewexposuresimulation' => { 86 => 0x810 },
	'liveviewfocusmode' => { 431 => [0x8b,0x28b] },
	'liveviewmetering' => { 431 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 300 => '21.2', 302 => '21.2', 303 => '21.2', 305 => '20.2', 306 => '20.2', 307 => '20.2', 309 => '20.2', 312 => '21.2', 313 => '21.2' },
	'liveviewshooting' => { 58 => 0x13 },
	'livingspecimen' => { 120 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 120 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 133 => 0x79 },
	'localizedcameramodel' => { 121 => 0xc615 },
	'locallocationname' => { 416 => 0x30 },
	'location' => { 235 => 0x9, 342 => 0x67, 495 => 'Location', 515 => 'Location', 520 => 'location', 521 => 'location' },
	'locationaccuracyhorizontal' => { 396 => 'location.accuracy.horizontal' },
	'locationareacode' => { 501 => 'lac' },
	'locationbody' => { 396 => 'location.body' },
	'locationcreated' => { 516 => 'LocationCreated' },
	'locationcreatedcity' => { 516 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 516 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 516 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 516 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 516 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 516 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 516 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 516 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 516 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 516 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 516 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 516 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 396 => 'location.date' },
	'locationinformation' => { 402 => 'loci' },
	'locationinfoversion' => { 235 => 0x0 },
	'locationname' => { 396 => 'location.name', 416 => 0x31 },
	'locationnote' => { 396 => 'location.note' },
	'locationrole' => { 396 => 'location.role' },
	'locationshown' => { 516 => 'LocationShown' },
	'locationshowncity' => { 516 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 516 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 516 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 516 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 516 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 516 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 516 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 516 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 516 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 516 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 516 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 516 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 86 => 0x709 },
	'logcomment' => { 531 => 'logComment' },
	'logscale' => { 140 => 0x902 },
	'longdescription' => { 394 => 'ldes' },
	'longexposurenoisereduction' => { 63 => 0x4, 86 => 0x201, 87 => 0x1, 88 => 0x2, 89 => 0x1, 90 => 0x1, 91 => 0x2, 92 => 0x1, 342 => 0x49, 429 => 0x2b, 430 => 0x25, 431 => 0x25, 442 => 0x2008, 447 => 0x11, 474 => 0x44 },
	'longexposurenoisereduction2' => { 58 => 0x8 },
	'longexposurenrused' => { 342 => 0xbe },
	'longitude' => { 118 => 'Longitude' },
	'look' => { 502 => 'Look', 504 => 'Look' },
	'lookamount' => { 502 => [\'Look','LookAmount'], 504 => [\'Look','LookAmount'] },
	'lookcluster' => { 502 => [\'Look','LookCluster'], 504 => [\'Look','LookCluster'] },
	'lookcopyright' => { 502 => [\'Look','LookCopyright'], 504 => [\'Look','LookCopyright'] },
	'lookgroup' => { 502 => [\'Look','LookGroup'], 504 => [\'Look','LookGroup'] },
	'lookname' => { 502 => 'LookName', 504 => 'LookName' },
	'lookparameters' => { 502 => [\'Look','LookParameters'], 504 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 502 => [\'Look','LookParametersCameraProfile'], 504 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 502 => [\'Look','LookParametersClarity2012'], 504 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 502 => [\'Look','LookParametersConvertToGrayscale'], 504 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 502 => [\'Look','LookParametersHighlights2012'], 504 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 502 => [\'Look','LookParametersLookTable'], 504 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 502 => [\'Look','LookParametersProcessVersion'], 504 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 502 => [\'Look','LookParametersShadows2012'], 504 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 502 => [\'Look','LookParametersToneCurvePV2012'], 504 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 502 => [\'Look','LookParametersToneCurvePV2012Blue'], 504 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 502 => [\'Look','LookParametersToneCurvePV2012Green'], 504 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 502 => [\'Look','LookParametersToneCurvePV2012Red'], 504 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 502 => [\'Look','LookParametersVersion'], 504 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 502 => [\'Look','LookSupportsAmount'], 504 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 502 => [\'Look','LookSupportsMonochrome'], 504 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 502 => [\'Look','LookSupportsOutputReferred'], 504 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 502 => [\'Look','LookUUID'], 504 => [\'Look','LookUUID'] },
	'loop' => { 531 => 'loop' },
	'loopstyle' => { 402 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 120 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 502 => 'LuminanceAdjustmentAqua', 504 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 502 => 'LuminanceAdjustmentBlue', 504 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 502 => 'LuminanceAdjustmentGreen', 504 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 502 => 'LuminanceAdjustmentMagenta', 504 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 502 => 'LuminanceAdjustmentOrange', 504 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 502 => 'LuminanceAdjustmentPurple', 504 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 502 => 'LuminanceAdjustmentRed', 504 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 502 => 'LuminanceAdjustmentYellow', 504 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 110 => 0x150 },
	'luminancecurvepoints' => { 110 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 105 => 0x20600, 111 => 0x5f, 419 => 0x1b },
	'luminancenoisereductioncontrast' => { 502 => 'LuminanceNoiseReductionContrast', 504 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 502 => 'LuminanceNoiseReductionDetail', 504 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 111 => 0x6d },
	'luminancesmoothing' => { 502 => 'LuminanceSmoothing', 504 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 86 => [0x40b,0x40c] },
	'lyrics' => { 394 => "\xa9lyr", 402 => "\xa9lyr", 531 => 'lyrics' },
	'lyricsuri' => { 402 => 'lrcu' },
	'm16cversion' => { 337 => 0x333 },
	'macatom' => { 503 => 'macAtom' },
	'macatomapplicationcode' => { 503 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 503 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 503 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 120 => 'MachineObservation' },
	'machineobservationday' => { 120 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 120 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 120 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 120 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 120 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 120 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 120 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 120 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 120 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 120 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 120 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 120 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 120 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 120 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 120 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 120 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 120 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 120 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 120 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 120 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 129 => 0x1020, 131 => 0x202, 153 => 0x2b, 324 => 0x202, 408 => 0x21, 418 => 0x202, 442 => 0xb040 },
	'macroled' => { 322 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 58 => 0x10 },
	'macromode' => { 35 => 0x1, 183 => 0xb, 319 => 0x300, 342 => 0x1c, 409 => 0x1009 },
	'magentahsl' => { 105 => 0x20917 },
	'magicfilter' => { 319 => 0x52c },
	'magnifiedview' => { 88 => 0x11, 90 => 0x9 },
	'mainboardversion' => { 140 => 0x438 },
	'maindialexposurecomp' => { 310 => '0.6' },
	'mainingredient' => { 523 => 'mainIngredient' },
	'majorversion' => { 493 => 'MajorVersion' },
	'make' => { 100 => 0x0, 117 => 0x1, 121 => 0x10f, 158 => 'Make', 332 => 'Make', 347 => 0x10f, 396 => 'make', 402 => ['@mak',"\xa9mak"], 520 => 'make', 527 => 'Make' },
	'makernote' => { 508 => 'MakerNote' },
	'makernoteapple' => { 119 => 'MakN', 121 => 0x927c },
	'makernotecanon' => { 83 => 'CMT3', 119 => 'MakN', 121 => 0x927c },
	'makernotecasio' => { 119 => 'MakN', 121 => 0x927c },
	'makernotecasio2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotedji' => { 119 => 'MakN', 121 => 0x927c },
	'makernotedjiinfo' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteflir' => { 119 => 'MakN', 121 => 0x927c },
	'makernotefujifilm' => { 119 => 'MakN', 121 => 0x927c },
	'makernotege' => { 119 => 'MakN', 121 => 0x927c },
	'makernotege2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotehasselblad' => { 119 => 'MakN', 121 => 0x927c },
	'makernotehp' => { 119 => 'MakN', 121 => 0x927c },
	'makernotehp2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotehp4' => { 119 => 'MakN', 121 => 0x927c },
	'makernotehp6' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteisl' => { 119 => 'MakN', 121 => 0x927c },
	'makernotejvc' => { 119 => 'MakN', 121 => 0x927c },
	'makernotejvctext' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak10' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak11' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak12' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak1a' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak1b' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak4' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak5' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak6a' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak6b' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak7' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak8a' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak8b' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak8c' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodak9' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekodakunknown' => { 119 => 'MakN', 121 => 0x927c },
	'makernotekyocera' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica10' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica2' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica3' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica4' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica5' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica6' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica7' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica8' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteleica9' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteminolta' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteminolta2' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteminolta3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotemotorola' => { 119 => 'MakN', 121 => 0x927c },
	'makernotenikon' => { 119 => 'MakN', 121 => 0x927c },
	'makernotenikon2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotenikon3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotenintendo' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteoffset' => { 418 => 0xff },
	'makernoteolympus' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteolympus2' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteolympus3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepanasonic' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepanasonic2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepanasonic3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentax' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentax2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentax3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentax4' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentax5' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentax6' => { 119 => 'MakN', 121 => 0x927c },
	'makernotepentaxunknown' => { 402 => 'PXMN' },
	'makernotephaseone' => { 119 => 'MakN', 121 => 0x927c },
	'makernotereconyx' => { 119 => 'MakN', 121 => 0x927c },
	'makernotereconyx2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotereconyx3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotericoh' => { 119 => 'MakN', 121 => 0x927c },
	'makernotericoh2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotericohpentax' => { 119 => 'MakN', 121 => 0x927c },
	'makernotericohtext' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesafety' => { 121 => 0xc635 },
	'makernotesamsung1a' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesamsung1b' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesamsung2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesanyo' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesanyoc4' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesanyopatch' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesigma' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesony' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesony2' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesony3' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesony4' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesony5' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesonyericsson' => { 119 => 'MakN', 121 => 0x927c },
	'makernotesonysrf' => { 119 => 'MakN', 121 => 0x927c },
	'makernotetype' => { 409 => 0x1 },
	'makernoteunknown' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteunknownbinary' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteunknowntext' => { 119 => 'MakN', 121 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 188 => 0x0, 236 => 0x1, 324 => 0x0, 342 => 0x8000, 413 => 0x0, 416 => 0x1, 419 => [0x1d,0x1f], 432 => 0x2000 },
	'makerurl' => { 402 => "\xa9mal" },
	'managedfrom' => { 532 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 532 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 532 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 532 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 532 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 532 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 532 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 532 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 532 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 532 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 532 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 532 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 532 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 532 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 532 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 532 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 532 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 532 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 532 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 532 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 532 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 532 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 532 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 532 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 532 => 'Manager' },
	'managervariant' => { 532 => 'ManagerVariant' },
	'manageto' => { 532 => 'ManageTo' },
	'manageui' => { 532 => 'ManageUI' },
	'manifest' => { 532 => 'Manifest' },
	'manifestlinkform' => { 532 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 532 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 532 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 532 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 532 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 532 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 532 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 532 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 532 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 532 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 532 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 532 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 532 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 532 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 532 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 532 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 532 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 532 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 532 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 532 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 532 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 532 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 532 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 532 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 532 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 532 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 532 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 532 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 319 => 0x900, 342 => 0x86 },
	'manometerreading' => { 319 => 0x901 },
	'manualafpointselectpattern' => { 86 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 322 => 0x1209 },
	'manualflashoutput' => { 35 => 0x29, 301 => '8.2', 304 => '22.2', 305 => '23.1', 306 => '23.2', 308 => '16.2', 309 => '23.2', 310 => '8.2', 311 => '23.2', 314 => '24.2', 409 => 0x100c },
	'manualflashstrength' => { 319 => 0x406 },
	'manualfocusdistance' => { 236 => 0x85, 324 => 0x100c, 418 => 0x223 },
	'manualfocuspointillumination' => { 315 => 0x17, 316 => 0x17, 317 => 0x17 },
	'manualfocusringinafmode' => { 315 => 0x1a, 316 => 0x1a, 317 => 0x1a },
	'manualtv' => { 85 => 0x5, 86 => 0x705 },
	'manufacturedate' => { 193 => 0x6705, 357 => 0x1 },
	'manufacturedate1' => { 411 => 0x4 },
	'manufacturedate2' => { 411 => 0x5 },
	'manufacturer' => { 487 => 'Manufacturer', 520 => 'manufacturer' },
	'mariahchromablursize' => { 140 => 0xf0d },
	'mariahmaphithreshold' => { 140 => 0xf0c },
	'mariahmaplothreshold' => { 140 => 0xf0b },
	'mariahsigmathreshold' => { 140 => 0xf0e },
	'mariahtexturethreshold' => { 140 => 0xf0a },
	'marked' => { 518 => 'Marked', 535 => 'Marked' },
	'markers' => { 531 => 'markers' },
	'markerscomment' => { 531 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 531 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 531 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 531 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 531 => [\'markers','markersCuePointType'] },
	'markersduration' => { 531 => [\'markers','markersDuration'] },
	'markerslocation' => { 531 => [\'markers','markersLocation'] },
	'markersname' => { 531 => [\'markers','markersName'] },
	'markersprobability' => { 531 => [\'markers','markersProbability'] },
	'markersspeaker' => { 531 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 531 => [\'markers','markersStartTime'] },
	'markerstarget' => { 531 => [\'markers','markersTarget'] },
	'markerstype' => { 531 => [\'markers','markersType'] },
	'maskedareas' => { 121 => 0xc68e },
	'maskgroupbasedcorractive' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 502 => 'MaskGroupBasedCorrections', 504 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 504 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 133 => 0xb9 },
	'mastergain' => { 259 => 0x50 },
	'materialsample' => { 120 => 'MaterialSample' },
	'materialsampleid' => { 120 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 300 => '50.1', 302 => '48.1', 303 => '48.1', 312 => '48.1', 313 => '48.1', 315 => 0x233, 316 => 0x233, 317 => 0x24b },
	'matrixselectk' => { 140 => 0x91b },
	'matrixselectthreshold' => { 140 => 0x91a },
	'matrixselectthreshold1' => { 140 => 0x91e },
	'matrixselectthreshold2' => { 140 => 0x91f },
	'matrixstructure' => { 401 => 0xa },
	'maxaperture' => { 35 => 0x1a, 140 => 0x3f9, 146 => 0x6103, 165 => 'MaxAperture', 183 => 0x17, 189 => 0x49c5, 234 => 0x36, 320 => 0x20a, 368 => '14.1' },
	'maxapertureatmaxfocal' => { 129 => 0x1407, 165 => 'MaxApertureAtMaxFocal', 228 => 0xb, 229 => 0x10, 230 => 0x11, 234 => 0x12, 320 => 0x206 },
	'maxapertureatminfocal' => { 129 => 0x1406, 228 => 0xa, 229 => 0xf, 230 => 0x10, 234 => 0x11, 320 => 0x205 },
	'maxaperturevalue' => { 121 => 0x9205, 386 => 0x414, 508 => 'MaxApertureValue' },
	'maxavailheight' => { 516 => 'MaxAvailHeight' },
	'maxavailwidth' => { 516 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 299 => 0xb, 300 => 0xc, 302 => '12.1', 303 => '12.1', 308 => 0xc, 309 => 0xb, 312 => '12.1', 313 => '12.1', 315 => 0x3d, 316 => 0x3d, 317 => 0x3d },
	'maxfaces' => { 323 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 35 => 0x17, 129 => 0x1405, 165 => 'MaxFocalLength', 228 => 0x9, 229 => 0xe, 230 => 0xf, 234 => 0x10, 320 => 0x208, 455 => 0x127c, 456 => 0x1138, 457 => 0x330, 458 => 0x330, 459 => 0x30e },
	'maximumdensityrange' => { 135 => 0x8c },
	'maxpagesize' => { 536 => 'MaxPageSize' },
	'maxpagesizeh' => { 536 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 536 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 536 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 140 => 0xc7d },
	'maxsamplevalue' => { 121 => 0x119 },
	'maxstorage' => { 526 => 'maxstorage' },
	'mb-d10batteries' => { 299 => '12.6' },
	'mb-d10batterytype' => { 308 => '13.3' },
	'mb-d11batterytype' => { 309 => '2.3' },
	'mb-d12batterytype' => { 312 => '3.2' },
	'mb-d80batteries' => { 310 => '6.5' },
	'mb-d80batterytype' => { 314 => '3.2' },
	'mcuversion' => { 228 => 0xc, 229 => 0x11, 230 => 0x12, 234 => 0x13 },
	'md5digest' => { 166 => 'zmd5' },
	'mditemfindercomment' => { 175 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 175 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 175 => 'MDItemFSLabel' },
	'mditemusertags' => { 175 => 'MDItemUserTags' },
	'meal' => { 523 => 'meal' },
	'measuredev' => { 28 => 0x9, 78 => 0x3, 99 => 0x1814, 158 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 78 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 189 => 0x690, 337 => 0x312, 340 => 0x312, 341 => 0x312, 344 => 0x3407 },
	'measuredrggb' => { 66 => 0x1 },
	'measuredrggbdata' => { 45 => 0x287 },
	'measurementaccuracy' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 120 => 'MeasurementOrFact' },
	'measurementremarks' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 120 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 487 => 'MeasureType' },
	'mechanicalshuttercount' => { 236 => 0x37 },
	'mediaclassprimaryid' => { 181 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 181 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 329 => 'MediaConstraints' },
	'mediacreatedate' => { 398 => 0x1 },
	'mediaeventiddate' => { 492 => 'MediaEventIdDate' },
	'mediamodifydate' => { 398 => 0x2 },
	'mediasummarycode' => { 329 => 'MediaSummaryCode' },
	'mediatype' => { 394 => 'stik' },
	'memoaudioquality' => { 86 => 0x812 },
	'memorycardconfiguration' => { 435 => 0x16 },
	'memorycardnumber' => { 213 => 0x2 },
	'menubuttondisplayposition' => { 84 => 0xb, 87 => 0xa, 88 => 0xb, 91 => 0xb },
	'menubuttonreturn' => { 92 => 0xb },
	'menumonitorofftime' => { 299 => '26.1', 300 => '22.1', 302 => '22.1', 303 => '22.1', 307 => '21.1', 308 => '8.2', 309 => '21.1', 312 => '22.1', 313 => '22.1', 314 => '22.1', 315 => 0x35, 316 => 0x35, 317 => 0x35 },
	'mergedimages' => { 342 => 0x76 },
	'metadataauthority' => { 516 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 516 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 516 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 529 => 'MetadataDate' },
	'metadataeditingsoftware' => { 121 => 0xa43c },
	'metadatalastedited' => { 516 => 'metadataLastEdited' },
	'metadatalasteditor' => { 516 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 516 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 516 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 531 => 'metadataModDate' },
	'metaversion' => { 450 => 0x34 },
	'meterinfo1row1' => { 443 => 0x0, 444 => 0x0 },
	'meterinfo1row2' => { 443 => 0x6c, 444 => 0x5a },
	'meterinfo1row3' => { 443 => 0xd8, 444 => 0xb4 },
	'meterinfo1row4' => { 443 => 0x144, 444 => 0x10e },
	'meterinfo1row5' => { 443 => 0x1b0, 444 => 0x168 },
	'meterinfo1row6' => { 443 => 0x21c, 444 => 0x1c2 },
	'meterinfo1row7' => { 443 => 0x288, 444 => 0x21c },
	'meterinfo2row1' => { 443 => 0x2f4, 444 => 0x276 },
	'meterinfo2row2' => { 443 => 0x378, 444 => 0x2e4 },
	'meterinfo2row3' => { 443 => 0x3fc, 444 => 0x352 },
	'meterinfo2row4' => { 443 => 0x480, 444 => 0x3c0 },
	'meterinfo2row5' => { 443 => 0x504, 444 => 0x42e },
	'meterinfo2row6' => { 443 => 0x588, 444 => 0x49c },
	'meterinfo2row7' => { 443 => 0x60c, 444 => 0x50a },
	'meterinfo2row8' => { 443 => 0x690, 444 => 0x578 },
	'meterinfo2row9' => { 443 => 0x714, 444 => 0x5e6 },
	'metering' => { 301 => '6.1' },
	'meteringmode' => { 35 => 0x11, 121 => 0x9207, 142 => 0x1c, 183 => 0x7, 184 => 0x25, 186 => 0x12, 319 => 0x202, 377 => 0x17, 419 => 0x9, 429 => 0x15, 430 => 0x13, 431 => 0x7, 447 => 0x3, 451 => 0x1174, 452 => 0x1178, 453 => 0x1154, 454 => 0x11d0, 455 => 0x11ac, 456 => 0x1064, 457 => 0x25c, 458 => 0x25c, 459 => 0x24b, 508 => 'MeteringMode' },
	'meteringmode2' => { 358 => '2.1', 442 => 0x202c },
	'meteringmode3' => { 358 => '16.1' },
	'meteringoffscaleindicator' => { 186 => 0x53 },
	'meteringtime' => { 299 => '22.2', 301 => '3.2', 304 => '17.1', 305 => '18.1', 308 => '7.3', 309 => '18.1', 310 => '3.2', 314 => '19.1' },
	'micro1version' => { 404 => 0x1f },
	'micro2version' => { 404 => 0x2d },
	'microphoneattenuator' => { 241 => 0x34e, 242 => 0x2d2, 243 => 0x2fa, 244 => 0x2fa },
	'microphonefrequencyresponse' => { 241 => 0x350, 242 => 0x2d4, 243 => 0x2fc, 244 => 0x2fc },
	'microphonejackpower' => { 241 => 0x376, 242 => 0x2fa, 243 => 0x322, 244 => 0x322 },
	'microphonesensitivity' => { 241 => 0x34c, 242 => 0x2d0, 243 => 0x2f8, 244 => 0x2f8 },
	'microvideo' => { 485 => 'MicroVideo' },
	'microvideooffset' => { 485 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 485 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 485 => 'MicroVideoVersion' },
	'midrangesharpness' => { 253 => 0x3b },
	'mieversion' => { 166 => '0Vers' },
	'mime' => { 487 => 'Mime' },
	'minaperture' => { 35 => 0x1b, 140 => 0x3f8, 165 => 'MinAperture', 368 => '0.2' },
	'minaperturevalue' => { 386 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 35 => 0x18, 129 => 0x1404, 165 => 'MinFocalLength', 228 => 0x8, 229 => 0xd, 230 => 0xe, 234 => 0xf, 320 => 0x207, 455 => 0x127a, 456 => 0x1136, 457 => 0x32e, 458 => 0x32e, 459 => 0x30c },
	'minfocusdistance' => { 368 => 0x3 },
	'minimumiso' => { 342 => 0xe8 },
	'minintegrationrows' => { 140 => 0x1874 },
	'minoltadate' => { 183 => 0x15 },
	'minoltaimagesize' => { 183 => 0x4, 184 => 0xc, 185 => 0x2, 188 => 0x103 },
	'minoltamodelid' => { 183 => 0x25 },
	'minoltaquality' => { 183 => 0x5, 184 => 0xd, 185 => 0x3, 188 => [0x102,0x103] },
	'minoltatime' => { 183 => 0x16 },
	'minormodelagedisclosure' => { 329 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 493 => 'MinorVersion' },
	'minsamplevalue' => { 121 => 0x118 },
	'mirrorlockup' => { 84 => 0xc, 85 => 0xc, 86 => 0x60f, 87 => 0xb, 88 => 0xc, 89 => 0x6, 90 => 0x6, 91 => 0xc, 92 => 0x3 },
	'mobilecountrycode' => { 501 => 'mcc' },
	'mobilenetworkcode' => { 501 => 'mnc' },
	'moddate' => { 332 => 'modify-date', 518 => 'ModDate' },
	'modedialposition' => { 435 => 0x14 },
	'model' => { 100 => 0x6, 121 => 0x110, 158 => 'Model', 332 => 'Model', 347 => 0x110, 377 => 0x23f, 396 => 'model', 402 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 419 => 0x84, 487 => 'Model', 520 => 'model', 527 => 'Model' },
	'modelage' => { 516 => 'ModelAge' },
	'modelid' => { 318 => 0x0 },
	'modelingflash' => { 299 => '21.4', 300 => '31.1', 302 => '31.1', 303 => '31.1', 308 => '26.4', 309 => '30.2', 310 => '7.4', 311 => '30.1', 312 => '31.1', 313 => '31.1', 314 => '31.3', 315 => 0x5d, 316 => 0x5d, 317 => 0x5d },
	'modelreleaseid' => { 329 => 'ModelReleaseID' },
	'modelreleasestatus' => { 329 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 465 => 0x52, 466 => 0x46, 467 => 0x53 },
	'modeltiepoint' => { 121 => 0x8482 },
	'modeltransform' => { 121 => 0x85d8 },
	'modelyear' => { 520 => 'modelYear' },
	'modificationdate' => { 521 => 'modificationDate' },
	'modifiedcolortemp' => { 67 => 0x9 },
	'modifieddigitalgain' => { 67 => 0xb },
	'modifiedparamflag' => { 59 => 0x1 },
	'modifiedpicturestyle' => { 67 => 0xa },
	'modifiedsaturation' => { 319 => 0x504 },
	'modifiedsensorbluelevel' => { 67 => 0x5 },
	'modifiedsensorredlevel' => { 67 => 0x4 },
	'modifiedsharpness' => { 67 => 0x2 },
	'modifiedsharpnessfreq' => { 67 => 0x3 },
	'modifiedtonecurve' => { 67 => 0x1 },
	'modifiedwhitebalance' => { 67 => 0x8 },
	'modifiedwhitebalanceblue' => { 67 => 0x7 },
	'modifiedwhitebalancered' => { 67 => 0x6 },
	'modifydate' => { 121 => 0x132, 159 => 'ModifyDate', 328 => 'ModDate', 330 => 'tIME', 393 => 'ModDate', 399 => 0x2, 529 => 'ModifyDate' },
	'moirefilter' => { 121 => 0xfe58, 502 => 'MoireFilter', 504 => 'MoireFilter' },
	'monitorbrightness' => { 241 => 0x69a, 242 => 0x59a, 243 => 0x5ca, 244 => 0x5e2 },
	'monitordisplayoff' => { 186 => 0x4c },
	'monitormatrix' => { 140 => 0x8fc },
	'monitorofftime' => { 299 => '18.2', 301 => '3.1', 310 => '3.1' },
	'monochromecolor' => { 319 => 0x53b },
	'monochromecontrast' => { 111 => 0x3c },
	'monochromefiltereffect' => { 105 => 0x20307, 111 => 0x3a, 342 => 0xac, 377 => 0x73 },
	'monochromegraineffect' => { 342 => 0xd2 },
	'monochromelinear' => { 111 => 0x3d },
	'monochromeoutputhighlightpoint' => { 111 => 0x41 },
	'monochromeoutputshadowpoint' => { 111 => 0x42 },
	'monochromeprofilesettings' => { 319 => 0x537 },
	'monochromerawhighlight' => { 111 => 0x7a },
	'monochromerawhighlightpoint' => { 111 => 0x3f },
	'monochromerawshadow' => { 111 => 0x83 },
	'monochromerawshadowpoint' => { 111 => 0x40 },
	'monochromesharpness' => { 111 => 0x3e },
	'monochrometoning' => { 377 => 0x74 },
	'monochrometoningeffect' => { 105 => 0x20306, 111 => 0x3b },
	'monochromeunsharpmaskfineness' => { 111 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 111 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 111 => 0xb4 },
	'monochromevignetting' => { 319 => 0x53a },
	'monthdaycreated' => { 142 => 0x12, 151 => 0xe },
	'mood' => { 181 => 'WM/Mood' },
	'moonphase' => { 403 => 0x12, 404 => 0x43, 405 => 0x4c },
	'morepermissions' => { 500 => 'morePermissions' },
	'motionphotovideo' => { 397 => 'mpvd' },
	'motionsensitivity' => { 403 => 0x29, 405 => 0x60 },
	'movementcount' => { 394 => "\xa9mvc" },
	'movementname' => { 394 => "\xa9mvn" },
	'movementnumber' => { 394 => "\xa9mvi" },
	'movieactived-lighting' => { 240 => 0x238, 241 => 0x334, 242 => 0x2b8, 243 => 0x2e0, 244 => 0x2e0 },
	'movieaelockbuttonassignment' => { 312 => '40.1' },
	'movieaf-onbutton' => { 315 => 0xcb, 316 => 0xcb, 317 => 0xcb },
	'movieafareamode' => { 241 => 0x342, 242 => 0x2c6, 243 => 0x2ee, 244 => 0x2ee, 315 => 0x203, 316 => 0x203, 317 => 0x21b },
	'movieafspeed' => { 315 => 0xdd, 316 => 0xdd, 317 => 0xdd },
	'movieafspeedapply' => { 315 => 0xdf, 316 => 0xdf, 317 => 0xdf },
	'movieaftrackingsensitivity' => { 315 => 0xe1, 316 => 0xe1, 317 => 0xe1 },
	'movieaperturelock' => { 315 => 0x259, 316 => 0x259, 317 => 0x271 },
	'movieautodistortioncontrol' => { 240 => 0x242 },
	'moviediffractioncompensation' => { 240 => 0x241 },
	'moviedxcropalert' => { 241 => 0x377, 242 => 0x2fb, 243 => 0x323, 244 => 0x323 },
	'movieelectronicvr' => { 241 => 0x348, 242 => 0x2cc, 243 => 0x2f4, 244 => 0x2f4 },
	'movieevfgrid' => { 315 => 0x21d, 316 => 0x21d, 317 => 0x235 },
	'movieflickerreduction' => { 241 => 0x33c, 242 => 0x2c0, 243 => 0x2e8, 244 => 0x2e8 },
	'moviefocusmode' => { 240 => 0x248, 241 => 0x340, 242 => 0x2c4, 243 => 0x2ec, 244 => 0x2ec },
	'moviefocuspointlock' => { 315 => 0x226, 316 => 0x226, 317 => 0x23e },
	'movieframerate' => { 240 => 0x1f8, 241 => 0x374, 242 => 0x2f4, 243 => 0x31c, 244 => 0x31c },
	'movieframesize' => { 240 => 0x1f6, 241 => 0x372, 242 => 0x2f2, 243 => 0x31a, 244 => 0x31a },
	'moviefunc1button' => { 302 => '41.1', 303 => '41.1', 313 => '41.1', 315 => 0xc3, 316 => 0xc3, 317 => 0xc3 },
	'moviefunc2button' => { 315 => 0xc7, 316 => 0xc7, 317 => 0xc7 },
	'moviefunc3button' => { 316 => 0x127, 317 => 0x13f },
	'moviefunctionbutton' => { 300 => '41.1', 312 => '41.1' },
	'moviefunctionbuttonplusdials' => { 300 => '52.1' },
	'moviehighisonoisereduction' => { 240 => 0x23c, 241 => 0x336, 242 => 0x2ba, 243 => 0x2e2, 244 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 315 => 0x215, 316 => 0x215, 317 => 0x22d },
	'moviehighreszoom' => { 241 => 0x380, 243 => 0x32c, 244 => 0x32c },
	'movieimagearea' => { 241 => 0x2da, 242 => 0x25c, 243 => 0x286, 244 => 0x286 },
	'movieisoautocontrolmanualmode' => { 241 => 0x2e8, 242 => 0x26a, 243 => 0x294, 244 => 0x294 },
	'movieisoautohilimit' => { 241 => 0x2e6, 242 => 0x268, 243 => 0x292, 244 => 0x292 },
	'movieisoautomanualmode' => { 240 => 0x204, 241 => 0x2ea, 242 => 0x26c, 243 => 0x296, 244 => 0x296 },
	'movielenscontrolring' => { 315 => 0xd7, 316 => 0xd7, 317 => 0xd7 },
	'moviemeteringmode' => { 241 => 0x33e, 242 => 0x2c2, 243 => 0x2ea, 244 => 0x2ea },
	'moviemidtonedisplayrange' => { 315 => 0x219, 316 => 0x219, 317 => 0x231 },
	'moviemidtonedisplayvalue' => { 315 => 0x217, 316 => 0x217, 317 => 0x22f },
	'moviemultiselector' => { 315 => 0xd9, 316 => 0xcf, 317 => 0xcf },
	'moviepreviewbutton' => { 300 => '41.2', 302 => '41.2', 303 => '41.2', 312 => '41.2', 313 => '41.2' },
	'moviepreviewbuttonplusdials' => { 300 => '52.2' },
	'movierecordbuttonplaybackmode' => { 315 => 0x1b5, 316 => 0x1b5, 317 => 0x1cd },
	'movieshutterbutton' => { 300 => '38.3', 302 => '38.3', 303 => '38.3', 312 => '38.3', 313 => '38.3' },
	'movieshutterspeedlock' => { 315 => 0x225, 316 => 0x225, 317 => 0x23d },
	'movieslowmotion' => { 240 => 0x1fa },
	'moviesoundrecording' => { 241 => 0x34a, 242 => 0x2ce, 243 => 0x2f6, 244 => 0x2f6 },
	'moviesubjectdetection' => { 241 => 0x378, 242 => 0x2fc, 243 => 0x324, 244 => 0x324 },
	'moviesubselectorassignment' => { 300 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 300 => '53.1' },
	'movietonemap' => { 242 => 0x2ec, 243 => 0x314, 244 => 0x314 },
	'movietype' => { 225 => 0x2ca, 240 => 0x1fe, 241 => 0x2e4, 242 => 0x266, 243 => 0x290, 244 => 0x290 },
	'movievibrationreduction' => { 240 => 0x24e },
	'movievibrationreductionsameasphoto' => { 240 => 0x24f },
	'movievignettecontrol' => { 240 => 0x23e, 241 => 0x1b0, 242 => 0x1a0, 243 => 0x1b4, 244 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 240 => 0x240 },
	'movievrmode' => { 241 => 0x344, 242 => 0x2c8, 243 => 0x2f0, 244 => 0x2f0 },
	'moviezebrapattern' => { 315 => 0x213, 316 => 0x213, 317 => 0x22b },
	'multiburstimageheight' => { 442 => 0x1002 },
	'multiburstimagewidth' => { 442 => 0x1001 },
	'multiburstmode' => { 442 => 0x1000 },
	'multicontrollerwhilemetering' => { 86 => 0x517 },
	'multiexposure' => { 69 => 0x1, 342 => 0xb4 },
	'multiexposureautogain' => { 246 => 0x3 },
	'multiexposurecontrol' => { 69 => 0x2 },
	'multiexposuremode' => { 246 => 0x1, 247 => 0x1 },
	'multiexposureoverlaymode' => { 247 => 0x3 },
	'multiexposureshots' => { 69 => 0x3, 241 => 0x9a, 242 => 0x8e, 243 => 0x9c, 244 => 0x9c, 246 => 0x2, 247 => 0x2 },
	'multiframenoisereduction' => { 431 => 0x35, 442 => 0x200b, 447 => 0x15 },
	'multiframenreffect' => { 442 => 0x2023 },
	'multifunctionlock' => { 86 => 0x70f },
	'multipleexposuremode' => { 241 => 0x98, 242 => 0x8c, 243 => 0x9a, 244 => 0x9a, 323 => 0x101c },
	'multipleexposureset' => { 358 => '10.1' },
	'multisample' => { 259 => 0x40 },
	'multiselector' => { 299 => '9.4', 300 => '10.3', 302 => '10.3', 303 => '10.3', 308 => '27.4', 312 => '10.3', 313 => '10.3' },
	'multiselectorliveview' => { 299 => '4.3', 302 => '37.1', 303 => '37.1', 312 => '37.1', 313 => '37.1' },
	'multiselectorliveviewmode' => { 273 => 0x18c2 },
	'multiselectorplaybackmode' => { 299 => ['13.5','9.2'], 300 => '10.2', 303 => '10.2', 308 => '27.2', 312 => '10.2', 313 => '10.2', 315 => 0xb3, 316 => 0xb3, 317 => 0xb3 },
	'multiselectorshootmode' => { 299 => '9.1', 300 => '10.1', 302 => '10.1', 303 => '10.1', 308 => '27.1', 312 => '10.1', 313 => '10.1', 315 => 0xaf, 316 => 0xaf, 317 => 0xaf },
	'multishot' => { 347 => 0x121 },
	'mute' => { 396 => 'player.movie.audio.mute' },
	'mycolormode' => { 70 => 0x2 },
	'name' => { 402 => 'name', 502 => 'Name', 504 => 'Name' },
	'narrator' => { 394 => "\xa9nrt" },
	'nationalcatalognumber' => { 521 => 'nationalCatalogNumber' },
	'nativedigest' => { 508 => 'NativeDigest', 527 => 'NativeDigest' },
	'ndfilter' => { 78 => 0x1c, 319 => 0x204, 409 => 0x1019 },
	'near' => { 487 => 'Near' },
	'nefbitdepth' => { 236 => 0xe22 },
	'nefcompression' => { 236 => 0x93, 237 => 0xa },
	'neflinearizationtable' => { 236 => 0x96 },
	'negativecachelargepreviewsize' => { 502 => 'NegativeCacheLargePreviewSize', 504 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 502 => 'NegativeCacheMaximumSize', 504 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 502 => 'NegativeCachePath', 504 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 499 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 377 => 0x88 },
	'neutraloutputhighlightpoint' => { 111 => 0x2f },
	'neutraloutputshadowpoint' => { 111 => 0x30 },
	'neutralrawcolortone' => { 111 => 0x28 },
	'neutralrawcontrast' => { 111 => 0x2a },
	'neutralrawhighlight' => { 111 => 0x78 },
	'neutralrawhighlightpoint' => { 111 => 0x2d },
	'neutralrawlinear' => { 111 => 0x2b },
	'neutralrawsaturation' => { 111 => 0x29 },
	'neutralrawshadow' => { 111 => 0x81 },
	'neutralrawshadowpoint' => { 111 => 0x2e },
	'neutralrawsharpness' => { 111 => 0x2c },
	'neutralunsharpmaskfineness' => { 111 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 111 => 0xa8 },
	'neutraunsharpmaskstrength' => { 111 => 0xa4 },
	'newlensdata' => { 234 => 0x2f },
	'newrawimagedigest' => { 121 => 0xc7a7 },
	'newsphotoversion' => { 135 => 0x0 },
	'nickname' => { 529 => 'Nickname' },
	'nikoncapturedata' => { 236 => 0xe01 },
	'nikoncaptureeditversions' => { 236 => 0xe13 },
	'nikoncaptureoffsets' => { 236 => 0xe0e },
	'nikoncaptureoutput' => { 236 => 0xe1e },
	'nikoncaptureversion' => { 236 => 0xe09 },
	'nikoniccprofile' => { 236 => 0xe1d },
	'nikonimagesize' => { 270 => '723.1', 271 => '732.1', 279 => 0x2c4 },
	'nikonmeteringmode' => { 201 => 0x17, 240 => 0x146, 250 => 0x214 },
	'nikonsettings' => { 236 => 0x4e },
	'noisefilter' => { 319 => 0x527 },
	'noiseprofile' => { 121 => 0xc761 },
	'noisereduction' => { 129 => [0x100b,0x100e], 184 => 0xb0, 185 => 0x60, 186 => 0x3f, 236 => 0x95, 292 => 0x753dcbc0, 293 => 0x17, 319 => 0x50a, 324 => 0x103a, 342 => 0x2d, 377 => 0x49, 409 => 0x100f, 411 => 0x2a },
	'noisereduction2' => { 323 => 0x1010 },
	'noisereductionapplied' => { 121 => 0xc6f7 },
	'noisereductionintensity' => { 293 => 0x9 },
	'noisereductionmethod' => { 293 => 0x11 },
	'noisereductionmode' => { 478 => 0x801e },
	'noisereductionparametersatcapture' => { 140 => 0xe73 },
	'noisereductionparameterscamera' => { 140 => 0xe72 },
	'noisereductionparametershost3mp' => { 140 => 0xe71 },
	'noisereductionparametershost6mp' => { 140 => 0xe70 },
	'noisereductionparametershostrgb' => { 140 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 140 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 140 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 140 => 0xe63 },
	'noisereductionparams' => { 347 => 0x1b },
	'noisereductionsharpness' => { 293 => 0xd },
	'noisereductionstrength' => { 342 => 0xd6 },
	'noisereductionvalue' => { 478 => 0x8027 },
	'nomemorycard' => { 299 => '22.1', 300 => '4.2', 301 => '0.3', 304 => '2.4', 305 => '3.2', 306 => '3.2', 308 => '33.7', 309 => '3.2', 310 => '0.3', 312 => '4.2', 314 => '4.5' },
	'nominalmaxaperture' => { 368 => 0xa },
	'nominalminaperture' => { 368 => '10.1' },
	'noncpulens10focallength' => { 241 => 0x6c6, 244 => 0x620 },
	'noncpulens10maxaperture' => { 241 => 0x6ee, 244 => 0x670 },
	'noncpulens11focallength' => { 241 => 0x6c8, 244 => 0x624 },
	'noncpulens11maxaperture' => { 241 => 0x6f0, 244 => 0x674 },
	'noncpulens12focallength' => { 241 => 0x6ca, 244 => 0x628 },
	'noncpulens12maxaperture' => { 241 => 0x6f2, 244 => 0x678 },
	'noncpulens13focallength' => { 241 => 0x6cc, 244 => 0x62c },
	'noncpulens13maxaperture' => { 241 => 0x6f4, 244 => 0x67c },
	'noncpulens14focallength' => { 241 => 0x6ce, 244 => 0x630 },
	'noncpulens14maxaperture' => { 241 => 0x6f6, 244 => 0x680 },
	'noncpulens15focallength' => { 241 => 0x6d0, 244 => 0x634 },
	'noncpulens15maxaperture' => { 241 => 0x6f8, 244 => 0x684 },
	'noncpulens16focallength' => { 241 => 0x6d2, 244 => 0x638 },
	'noncpulens16maxaperture' => { 241 => 0x6fa, 244 => 0x688 },
	'noncpulens17focallength' => { 241 => 0x6d4, 244 => 0x63c },
	'noncpulens17maxaperture' => { 241 => 0x6fc, 244 => 0x68c },
	'noncpulens18focallength' => { 241 => 0x6d6, 244 => 0x640 },
	'noncpulens18maxaperture' => { 241 => 0x6fe, 244 => 0x690 },
	'noncpulens19focallength' => { 241 => 0x6d8, 244 => 0x644 },
	'noncpulens19maxaperture' => { 241 => 0x700, 244 => 0x694 },
	'noncpulens1focallength' => { 241 => 0x6b4, 244 => 0x5fc },
	'noncpulens1maxaperture' => { 241 => 0x6dc, 244 => 0x64c },
	'noncpulens20focallength' => { 241 => 0x6da, 244 => 0x648 },
	'noncpulens20maxaperture' => { 241 => 0x702, 244 => 0x698 },
	'noncpulens2focallength' => { 241 => 0x6b6, 244 => 0x600 },
	'noncpulens2maxaperture' => { 241 => 0x6de, 244 => 0x650 },
	'noncpulens3focallength' => { 241 => 0x6b8, 244 => 0x604 },
	'noncpulens3maxaperture' => { 241 => 0x6e0, 244 => 0x654 },
	'noncpulens4focallength' => { 241 => 0x6ba, 244 => 0x608 },
	'noncpulens4maxaperture' => { 241 => 0x6e2, 244 => 0x658 },
	'noncpulens5focallength' => { 241 => 0x6bc, 244 => 0x60c },
	'noncpulens5maxaperture' => { 241 => 0x6e4, 244 => 0x65c },
	'noncpulens6focallength' => { 241 => 0x6be, 244 => 0x610 },
	'noncpulens6maxaperture' => { 241 => 0x6e6, 244 => 0x660 },
	'noncpulens7focallength' => { 241 => 0x6c0, 244 => 0x614 },
	'noncpulens7maxaperture' => { 241 => 0x6e8, 244 => 0x664 },
	'noncpulens8focallength' => { 241 => 0x6c2, 244 => 0x618 },
	'noncpulens8maxaperture' => { 241 => 0x6ea, 244 => 0x668 },
	'noncpulens9focallength' => { 241 => 0x6c4, 244 => 0x61c },
	'noncpulens9maxaperture' => { 241 => 0x6ec, 244 => 0x66c },
	'normallinetime' => { 140 => 0x186a },
	'normalwhitelevel' => { 42 => 0x32a, 43 => 0x280, 46 => [0x2b8,0x2cf,0x2d3], 47 => 0x569, 48 => 0x1e3, 49 => [0x1fc,0x2dc], 50 => [0x230,0x30e], 51 => 0x31c },
	'notes' => { 479 => 'Notes', 497 => 'notes' },
	'npages' => { 536 => 'NPages' },
	'nullrecord' => { 99 => 0x0 },
	'numafpoints' => { 354 => 0x2 },
	'number' => { 521 => 'number' },
	'numberofbeats' => { 531 => 'numberOfBeats' },
	'numberoffocuspoints' => { 302 => '1.3', 303 => '1.3', 306 => '0.2', 307 => '0.3', 309 => '0.3' },
	'numfaceelements' => { 129 => 0x4200 },
	'numfacepositions' => { 334 => 0x0 },
	'numindexentries' => { 135 => 0x54 },
	'numwbentries' => { 348 => 0x0, 349 => 0x0 },
	'object' => { 521 => 'object' },
	'objectattributereference' => { 133 => 0x4 },
	'objectcycle' => { 133 => 0x4b, 497 => 'ObjectCycle' },
	'objectdescription' => { 520 => 'objectDescription' },
	'objectdistance' => { 114 => 0x6, 115 => 0x2022 },
	'objectname' => { 133 => 0x5 },
	'objectpreviewdata' => { 133 => 0xca },
	'objectpreviewfileformat' => { 133 => 0xc8 },
	'objectpreviewfileversion' => { 133 => 0xc9 },
	'objectsubtype' => { 520 => 'objectSubtype' },
	'objecttype' => { 520 => 'objectType' },
	'objecttypereference' => { 133 => 0x3 },
	'occurrence' => { 120 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 120 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 120 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 120 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 120 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 120 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 120 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 120 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 120 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 120 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 120 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 120 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 120 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 120 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 120 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 120 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 120 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 120 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 120 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 120 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 120 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 120 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 120 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 120 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 120 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 120 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 120 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 120 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 120 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 120 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 508 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 508 => [\'OECF','OECFNames'] },
	'oecfrows' => { 508 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 508 => [\'OECF','OECFValues'] },
	'offsaledate' => { 521 => 'offSaleDate' },
	'offsaledatea-platform' => { 521 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 521 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 140 => 0x190a },
	'offsethdr' => { 513 => 'OffsetHDR' },
	'offsetschema' => { 121 => 0xea1d },
	'offsetsdr' => { 513 => 'OffsetSDR' },
	'offsettime' => { 121 => 0x9010 },
	'offsettimedigitized' => { 121 => 0x9012 },
	'offsettimeoriginal' => { 121 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 309 => '15.1', 314 => '16.1' },
	'oldsubfiletype' => { 121 => 0xff },
	'olympusimageheight' => { 324 => 0x102f },
	'olympusimagewidth' => { 324 => 0x102e },
	'omenatcapturestrength' => { 140 => 0xa60 },
	'omenautostrength' => { 140 => 0xa5f },
	'omenearlystrength' => { 140 => 0xa5e },
	'omenfocallengthlimit' => { 140 => 0xa62 },
	'omeninitialipfstrength' => { 140 => 0xa5d },
	'omensurfaceindex' => { 140 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 324 => 0x302 },
	'onsaledate' => { 521 => 'onSaleDate' },
	'onsaledatea-platform' => { 521 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 521 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 521 => 'onSaleDay' },
	'onsaledaya-platform' => { 521 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 521 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 121 => 0xc740 },
	'opcodelist2' => { 121 => 0xc741 },
	'opcodelist3' => { 121 => 0xc74e },
	'opticalzoom' => { 144 => 0xfa3d, 146 => [0x6006,0xf006], 147 => 0x1000, 148 => 0xf, 151 => 0x1e, 153 => 0x20, 154 => 0x1c, 165 => 'OpticalZoom' },
	'opticalzoomcode' => { 78 => 0xa },
	'opticalzoommode' => { 342 => 0x34 },
	'opticalzoomon' => { 418 => 0x219 },
	'optionenddate' => { 524 => 'optionEndDate' },
	'opto-electricconvfactor' => { 508 => 'OECF' },
	'orangehsl' => { 105 => 0x20911 },
	'ordernumber' => { 129 => 0x8002 },
	'organisationinimagecode' => { 516 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 516 => 'OrganisationInImageName' },
	'organism' => { 120 => 'Organism' },
	'organismassociatedoccurrences' => { 120 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 120 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 120 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 120 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 120 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 120 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 120 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 521 => 'organization' },
	'orientation' => { 121 => 0x112, 347 => 0x112, 520 => 'orientation', 527 => 'Orientation' },
	'orientation2' => { 447 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 86 => 0x516 },
	'originalalbumtitle' => { 181 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 181 => 'WM/OriginalArtist', 394 => "\xa9ope" },
	'originalbestqualitysize' => { 121 => 0xc792 },
	'originalcreatedatetime' => { 492 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 116 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 65 => 0x83 },
	'originaldefaultcropsize' => { 121 => 0xc793 },
	'originaldefaultfinalsize' => { 121 => 0xc791 },
	'originaldirectory' => { 339 => 0x408 },
	'originaldocumentid' => { 532 => 'OriginalDocumentID' },
	'originalfilename' => { 99 => 0x816, 140 => 0x3e9, 152 => 0x20, 339 => 0x407, 492 => 'OriginalFilename' },
	'originalimagehash' => { 482 => 'OriginalImageHash' },
	'originalimagehashtype' => { 482 => 'OriginalImageHashType' },
	'originalimageheight' => { 80 => 0xc, 125 => 0x1 },
	'originalimagemd5' => { 482 => 'OriginalImageMD5' },
	'originalimagesize' => { 164 => 'OriginalImageSize' },
	'originalimagewidth' => { 80 => 0xb, 125 => 0x0 },
	'originallyricist' => { 181 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 121 => 0xc68c },
	'originalrawfiledigest' => { 121 => 0xc71d },
	'originalrawfilename' => { 121 => 0xc68b },
	'originaltransmissionreference' => { 133 => 0x67 },
	'originatingprogram' => { 133 => 0x41, 497 => 'OriginatingProgram' },
	'originplatform' => { 521 => 'originPlatform' },
	'os' => { 506 => 'os' },
	'otherconditions' => { 329 => 'OtherConditions' },
	'otherconstraints' => { 329 => 'OtherConstraints' },
	'otherimage' => { 116 => 'Exif-OtherImage' },
	'otherimageinfo' => { 329 => 'OtherImageInfo' },
	'otherimagelength' => { 121 => 0x202 },
	'otherimagestart' => { 121 => 0x201 },
	'otherlicensedocuments' => { 329 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 329 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 329 => 'OtherLicenseRequirements' },
	'outcue' => { 531 => 'outCue' },
	'outcuescale' => { 531 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 531 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 202 => 0x3 },
	'outputimagewidth' => { 202 => 0x2 },
	'outputlut' => { 342 => 0xa7 },
	'outputprofile' => { 140 => 0x138b },
	'outputresolution' => { 202 => 0x4 },
	'overclockcols' => { 140 => 0x189c },
	'overclockrows' => { 140 => 0x18c4 },
	'overridelookvignette' => { 502 => 'OverrideLookVignette', 504 => 'OverrideLookVignette' },
	'owner' => { 394 => 'ownr', 535 => 'Owner' },
	'ownerid' => { 133 => 0xbc },
	'ownername' => { 15 => 0x10f, 65 => 0x9, 99 => 0x810, 121 => [0xa430,0xfde8], 158 => 'OwnerName', 499 => 'OwnerName', 509 => 'CameraOwnerName' },
	'padding' => { 121 => 0xea1c },
	'pagecount' => { 521 => 'pageCount' },
	'pageimage' => { 529 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 529 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 529 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 529 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 529 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 529 => 'PageInfo' },
	'pagename' => { 121 => 0x11d },
	'pagenumber' => { 121 => 0x129 },
	'pageprogressiondirection' => { 521 => 'pageProgressionDirection' },
	'pagerange' => { 521 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 502 => 'PaintBasedCorrections', 504 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 504 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 345 => 0x0 },
	'panasonicexifversion' => { 342 => 0x26 },
	'panasonicimageheight' => { 342 => 0x4c },
	'panasonicimagewidth' => { 342 => 0x4b },
	'panasonicrawversion' => { 347 => 0x1 },
	'panasonictitle' => { 121 => 0xc6d2 },
	'panasonictitle2' => { 121 => 0xc6d3 },
	'panoramaangle' => { 129 => 0x1153 },
	'panoramacropbottom' => { 448 => 0x7 },
	'panoramacropleft' => { 448 => 0x4 },
	'panoramacropright' => { 448 => 0x6 },
	'panoramacroptop' => { 448 => 0x5 },
	'panoramadirection' => { 73 => 0x5, 129 => 0x1154, 448 => 0x3 },
	'panoramaframeheight' => { 448 => 0x9 },
	'panoramaframenumber' => { 73 => 0x2 },
	'panoramaframewidth' => { 448 => 0x8 },
	'panoramafullheight' => { 448 => 0x2 },
	'panoramafullwidth' => { 448 => 0x1 },
	'panoramamode' => { 142 => 0x3c, 319 => 0x601 },
	'panoramasize3d' => { 431 => 0x38 },
	'panoramasourceheight' => { 448 => 0xb },
	'panoramasourcewidth' => { 448 => 0xa },
	'panoramicstitchcameramotion' => { 178 => 'PanoramicStitchCameraMotion', 179 => 0x1 },
	'panoramicstitchmaptype' => { 178 => 'PanoramicStitchMapType', 179 => 0x2 },
	'panoramicstitchphi0' => { 178 => 'PanoramicStitchPhi0', 179 => 0x5 },
	'panoramicstitchphi1' => { 178 => 'PanoramicStitchPhi1', 179 => 0x6 },
	'panoramicstitchtheta0' => { 178 => 'PanoramicStitchTheta0', 179 => 0x3 },
	'panoramicstitchtheta1' => { 178 => 'PanoramicStitchTheta1', 179 => 0x4 },
	'panoramicstitchversion' => { 179 => 0x0 },
	'pantry' => { 532 => 'Pantry' },
	'pantryinstanceid' => { 532 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 129 => 0xb211, 318 => 0x28 },
	'parametricdarks' => { 502 => 'ParametricDarks', 504 => 'ParametricDarks' },
	'parametrichighlights' => { 502 => 'ParametricHighlights', 504 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 502 => 'ParametricHighlightSplit', 504 => 'ParametricHighlightSplit' },
	'parametriclights' => { 502 => 'ParametricLights', 504 => 'ParametricLights' },
	'parametricmidtonesplit' => { 502 => 'ParametricMidtoneSplit', 504 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 502 => 'ParametricShadows', 504 => 'ParametricShadows' },
	'parametricshadowsplit' => { 502 => 'ParametricShadowSplit', 504 => 'ParametricShadowSplit' },
	'parentalrating' => { 181 => 'WM/ParentalRating' },
	'parentid' => { 516 => 'parentId' },
	'parentmediaeventid' => { 492 => 'ParentMediaEventID' },
	'parentmeid' => { 492 => 'ParentMEID' },
	'parentproductid' => { 394 => '@ppi' },
	'parentreference1' => { 514 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 514 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 394 => '@PST' },
	'parenttitle' => { 394 => '@pti' },
	'partialactivecols1' => { 140 => 0x17e8 },
	'partialactivecols2' => { 140 => 0x17f2 },
	'partialactiverows1' => { 140 => 0x17fc },
	'partialactiverows2' => { 140 => 0x1806 },
	'partofcompilation' => { 531 => 'partOfCompilation' },
	'patientbirthdate' => { 480 => 'PatientDOB' },
	'patientid' => { 480 => 'PatientID' },
	'patientname' => { 480 => 'PatientName' },
	'patientsex' => { 480 => 'PatientSex' },
	'patternareaheight' => { 140 => 0x963 },
	'patternareawidth' => { 140 => 0x962 },
	'patterncorrectionfactorscale' => { 140 => 0x969 },
	'patterncropcols1' => { 140 => 0x96c },
	'patterncropcols2' => { 140 => 0x96d },
	'patterncroprows1' => { 140 => 0x96a },
	'patterncroprows2' => { 140 => 0x96b },
	'patternimagerheight' => { 140 => 0x961 },
	'patternimagerwidth' => { 140 => 0x960 },
	'patternx' => { 140 => 0x966 },
	'patterny' => { 140 => 0x967 },
	'pdfversion' => { 518 => 'PDFVersion' },
	'pentaximagesize' => { 377 => 0x9 },
	'pentaxmodelid' => { 357 => 0x0, 377 => 0x5 },
	'pentaxmodeltype' => { 377 => 0x1 },
	'pentaxversion' => { 377 => 0x0 },
	'people' => { 483 => 'People', 495 => 'People' },
	'perchannelblacklevel' => { 42 => 0x157, 43 => 0x16b, 45 => 0xc4, 46 => [0x2b4,0x2cb,0x2cf], 47 => [0x108,0x14d], 48 => 0x1df, 49 => [0x1f8,0x2d8], 50 => [0x22c,0x30a], 51 => 0x149 },
	'performer' => { 394 => 'perf', 402 => 'perf' },
	'performerkeywords' => { 402 => "\xa9prk" },
	'performers' => { 402 => "\xa9prf" },
	'performerurl' => { 402 => "\xa9prl" },
	'period' => { 181 => 'WM/Period' },
	'peripheralillumcentralradius' => { 478 => 0x8030 },
	'peripheralillumcentralvalue' => { 478 => 0x8031 },
	'peripheralillumination' => { 105 => 0x20702, 111 => 0x68 },
	'peripheralilluminationcorr' => { 63 => 0x1, 367 => 0x2 },
	'peripheralilluminationon' => { 105 => '0x20702.0', 111 => 0x64 },
	'peripheralillumperiphvalue' => { 478 => 0x8032 },
	'peripherallighting' => { 80 => 0x2, 129 => 0x3804 },
	'peripherallightingsetting' => { 81 => 0x5 },
	'peripherallightingvalue' => { 80 => 0x6 },
	'permissions' => { 524 => 'permissions' },
	'permits' => { 500 => 'permits' },
	'person' => { 521 => 'person' },
	'personality' => { 492 => 'Personality' },
	'personheard' => { 516 => 'PersonHeard' },
	'personheardidentifier' => { 516 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 516 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 516 => 'PersonInImage' },
	'personinimagecharacteristic' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 516 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 516 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 502 => 'PerspectiveAspect', 504 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 502 => 'PerspectiveHorizontal', 504 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 502 => 'PerspectiveRotate', 504 => 'PerspectiveRotate' },
	'perspectivescale' => { 502 => 'PerspectiveScale', 504 => 'PerspectiveScale' },
	'perspectiveupright' => { 502 => 'PerspectiveUpright', 504 => 'PerspectiveUpright' },
	'perspectivevertical' => { 502 => 'PerspectiveVertical', 504 => 'PerspectiveVertical' },
	'perspectivex' => { 502 => 'PerspectiveX', 504 => 'PerspectiveX' },
	'perspectivey' => { 502 => 'PerspectiveY', 504 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 94 => 0x1 },
	'pf10retainprogramshift' => { 94 => 0xb },
	'pf13drivepriority' => { 94 => 0xe },
	'pf14disablefocussearch' => { 94 => 0xf },
	'pf15disableafassistbeam' => { 94 => 0x10 },
	'pf16autofocuspointshoot' => { 94 => 0x11 },
	'pf17disableafpointsel' => { 94 => 0x12 },
	'pf18enableautoafpointsel' => { 94 => 0x13 },
	'pf19continuousshootspeed' => { 94 => 0x14 },
	'pf19shootingspeedhigh' => { 93 => 0xa },
	'pf19shootingspeedlow' => { 93 => 0x9 },
	'pf1disableshootingmodes' => { 94 => 0x2 },
	'pf1value' => { 93 => 0x1 },
	'pf20limitcontinousshots' => { 94 => 0x15 },
	'pf20maxcontinousshots' => { 93 => 0xb },
	'pf21enablequietoperation' => { 94 => 0x16 },
	'pf23felocktime' => { 93 => 0xd },
	'pf23postreleasetime' => { 93 => 0xe },
	'pf23settimerlengths' => { 94 => 0x18 },
	'pf23shutterbuttontime' => { 93 => 0xc },
	'pf24lightlcdduringbulb' => { 94 => 0x19 },
	'pf25aemode' => { 93 => 0xf },
	'pf25afmode' => { 93 => 0x12 },
	'pf25afpointsel' => { 93 => 0x13 },
	'pf25colormatrix' => { 93 => 0x17 },
	'pf25defaultclearsettings' => { 94 => 0x1a },
	'pf25drivemode' => { 93 => 0x11 },
	'pf25imagesize' => { 93 => 0x14 },
	'pf25meteringmode' => { 93 => 0x10 },
	'pf25parameters' => { 93 => 0x16 },
	'pf25wbmode' => { 93 => 0x15 },
	'pf26shortenreleaselag' => { 94 => 0x1b },
	'pf27reversedialrotation' => { 94 => 0x1c },
	'pf27value' => { 93 => 0x18 },
	'pf28noquickdialexpcomp' => { 94 => 0x1d },
	'pf29quickdialswitchoff' => { 94 => 0x1e },
	'pf2disablemeteringmodes' => { 94 => 0x3 },
	'pf2value' => { 93 => 0x2 },
	'pf30enlargementmode' => { 94 => 0x1f },
	'pf31originaldecisiondata' => { 94 => 0x20 },
	'pf3manualexposuremetering' => { 94 => 0x4 },
	'pf3value' => { 93 => 0x3 },
	'pf4exposuretimelimits' => { 94 => 0x5 },
	'pf4exposuretimemax' => { 93 => 0x5 },
	'pf4exposuretimemin' => { 93 => 0x4 },
	'pf5aperturelimits' => { 94 => 0x6 },
	'pf5aperturemax' => { 93 => 0x7 },
	'pf5aperturemin' => { 93 => 0x6 },
	'pf6presetshootingmodes' => { 94 => 0x7 },
	'pf7bracketcontinuousshoot' => { 94 => 0x8 },
	'pf8bracketshots' => { 93 => 0x8 },
	'pf8setbracketshots' => { 94 => 0x9 },
	'pf9changebracketsequence' => { 94 => 0xa },
	'phasedetectaf' => { 195 => 0x6 },
	'phonenumber' => { 159 => 'Phone' },
	'photoeffect' => { 35 => 0x28 },
	'photoeffecthistoryxml' => { 292 => 0xe9651831 },
	'photoeffects' => { 292 => 0xab5eca5e },
	'photoeffectsblue' => { 294 => 0x8 },
	'photoeffectsgreen' => { 294 => 0x6 },
	'photoeffectsred' => { 294 => 0x4 },
	'photoeffectstype' => { 294 => 0x0 },
	'photographer' => { 121 => 0xa437 },
	'photographicsensitivity' => { 509 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 299 => '17.6', 308 => '33.6' },
	'photometricinterpretation' => { 121 => 0x106, 527 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 241 => 0x11e, 242 => 0x112, 243 => 0x122, 244 => 0x122, 245 => 0x24, 263 => 0x0 },
	'photoshootingmenubankimagearea' => { 239 => 0x6dd, 241 => 0x144, 242 => 0x134, 243 => 0x148, 244 => 0x148, 263 => '7.1' },
	'photoshopbgrthumbnail' => { 391 => 0x409 },
	'photoshopquality' => { 390 => 0x0 },
	'photoshopthumbnail' => { 391 => 0x40c },
	'photostyle' => { 342 => 0x89 },
	'picasawebgphotoid' => { 507 => 'picasawebGPhotoId' },
	'picklabel' => { 507 => 'PickLabel' },
	'pictinfo' => { 418 => 0x208 },
	'picturecontrol' => { 292 => 0xe2173c47 },
	'picturecontrolactive' => { 295 => 0x0 },
	'picturecontroladjust' => { 251 => 0x30, 252 => 0x30, 253 => 0x36 },
	'picturecontrolbase' => { 251 => 0x18, 252 => 0x18, 253 => 0x1c },
	'picturecontroldata' => { 236 => [0xbd,0x23] },
	'picturecontrolmode' => { 295 => 0x13 },
	'picturecontrolname' => { 251 => 0x4, 252 => 0x4, 253 => 0x8 },
	'picturecontrolquickadjust' => { 251 => 0x31, 252 => 0x31, 253 => 0x37 },
	'pictureeffect' => { 442 => 0x200e },
	'pictureeffect2' => { 451 => 0x1163, 452 => 0x1167, 453 => 0x1143, 454 => 0x11bf, 455 => 0x119b, 456 => 0x1053, 457 => 0x24b, 458 => 0x24b, 459 => 0x23c, 474 => 0x46 },
	'picturefinish' => { 184 => 0x71 },
	'picturemode' => { 129 => 0x1031, 319 => 0x520, 377 => [0xb,0x33], 419 => 0x3d },
	'picturemode2' => { 358 => 0x0 },
	'picturemodebwfilter' => { 319 => 0x525 },
	'picturemodecontrast' => { 319 => 0x523 },
	'picturemodeeffect' => { 319 => 0x52d },
	'picturemodehue' => { 319 => 0x522 },
	'picturemodesaturation' => { 319 => 0x521 },
	'picturemodesharpness' => { 319 => 0x524 },
	'picturemodetone' => { 319 => 0x526 },
	'pictureprofile' => { 451 => [0x115e,0x115f], 452 => [0x1162,0x1163], 453 => [0x113e,0x113f], 454 => [0x11ba,0x11bb], 455 => [0x1196,0x1197], 456 => [0x104e,0x104f], 457 => [0x246,0x247], 458 => [0x246,0x247], 459 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 75 => 0xa, 105 => 0x20301, 111 => 0x2 },
	'picturestylepc' => { 65 => 0x4009 },
	'picturestyleuserdef' => { 65 => 0x4008 },
	'picturewizard' => { 416 => 0x21 },
	'picturewizardcolor' => { 415 => 0x1 },
	'picturewizardcontrast' => { 415 => 0x4 },
	'picturewizardmode' => { 415 => 0x0 },
	'picturewizardsaturation' => { 415 => 0x2 },
	'picturewizardsharpness' => { 415 => 0x3 },
	'pipelineversion' => { 178 => 'PipelineVersion' },
	'pitch' => { 117 => 0x6, 300 => '4.1', 312 => '4.1', 402 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 249 => 0x4, 319 => 0x904, 342 => 0x91, 376 => 0x2, 414 => 0x1 },
	'pitchshift' => { 396 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 395 => 'pasp' },
	'pixelclockfrequency' => { 140 => 0x40b },
	'pixelcorrectionoffset' => { 140 => 0x972 },
	'pixelcorrectionscale' => { 140 => 0x971 },
	'pixelscale' => { 121 => 0x830e },
	'pixelshiftinfo' => { 442 => 0x202f },
	'pixelshiftoffset' => { 129 => 0x1106 },
	'pixelshiftresolution' => { 378 => 0x0 },
	'pixelshiftshots' => { 129 => 0x1105 },
	'pixelsperunitx' => { 331 => 0x0 },
	'pixelsperunity' => { 331 => 0x4 },
	'pixelunits' => { 331 => 0x8 },
	'planarconfiguration' => { 121 => 0x11c, 527 => 'PlanarConfiguration' },
	'plane' => { 481 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 481 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 481 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 481 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 481 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 481 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 481 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 481 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 481 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 481 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 481 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 481 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 481 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 481 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 481 => 'Planes' },
	'planningref' => { 516 => 'PlanningRef' },
	'planningrefidentifier' => { 516 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 516 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 516 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 536 => 'PlateNames' },
	'platform' => { 521 => 'platform' },
	'playallframes' => { 402 => 'AllF' },
	'playbackbutton' => { 244 => 0x808 },
	'playbackbuttonplaybackmode' => { 244 => 0x814 },
	'playbackflickdown' => { 315 => 0x159, 316 => 0x159, 317 => 0x171 },
	'playbackflickup' => { 315 => 0x155, 316 => 0x155, 317 => 0x16d },
	'playbackmenustime' => { 304 => '20.1', 305 => '21.1', 306 => '21.1' },
	'playbackmonitorofftime' => { 299 => '25.2', 300 => '36.1', 302 => '36.1', 303 => '36.1', 307 => '35.1', 308 => '8.1', 309 => '35.1', 312 => '36.1', 313 => '36.1', 314 => '21.1', 315 => 0x33, 316 => 0x33, 317 => 0x33 },
	'playbackzoom' => { 300 => '37.1' },
	'playdisplay' => { 186 => 0x4e },
	'playerversion' => { 396 => 'player.version' },
	'playgap' => { 394 => 'pgap' },
	'playmode' => { 402 => 'SDLN' },
	'playselection' => { 402 => 'SelO' },
	'plusversion' => { 329 => 'Version' },
	'pmversion' => { 389 => 'PMVersion' },
	'pngwarning' => { 332 => 'Warning' },
	'podcast' => { 394 => 'pcst' },
	'podcasturl' => { 394 => 'purl' },
	'poilevel' => { 235 => 0x8 },
	'portraitimpressionbalance' => { 241 => 0x26e, 254 => 0xa0 },
	'portraitnote' => { 485 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 111 => 0x1d },
	'portraitoutputshadowpoint' => { 111 => 0x1e },
	'portraitrawcolortone' => { 111 => 0x16 },
	'portraitrawcontrast' => { 111 => 0x18 },
	'portraitrawhighlight' => { 111 => 0x76 },
	'portraitrawhighlightpoint' => { 111 => 0x1b },
	'portraitrawlinear' => { 111 => 0x19 },
	'portraitrawsaturation' => { 111 => 0x17 },
	'portraitrawshadow' => { 111 => 0x7f },
	'portraitrawshadowpoint' => { 111 => 0x1c },
	'portraitrawsharpness' => { 111 => 0x1a },
	'portraitrefiner' => { 115 => 0x302b },
	'portraitrequest' => { 485 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 111 => 0x9a },
	'portraitunsharpmaskstrength' => { 111 => 0x98 },
	'portraitunsharpmaskthreshold' => { 111 => 0x9c },
	'portraitversion' => { 485 => 'PortraitVersion' },
	'pose' => { 481 => 'Pose' },
	'poseheadingdegrees' => { 490 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 490 => 'PosePitchDegrees' },
	'posepositionx' => { 481 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 481 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 481 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 490 => 'PoseRollDegrees' },
	'poserotationw' => { 481 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 481 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 481 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 481 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 481 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 520 => 'positionDescriptor' },
	'postalcode' => { 163 => 'PostalCode' },
	'postcropvignetteamount' => { 502 => 'PostCropVignetteAmount', 504 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 502 => 'PostCropVignetteFeather', 504 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 502 => 'PostCropVignetteHighlightContrast', 504 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 502 => 'PostCropVignetteMidpoint', 504 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 502 => 'PostCropVignetteRoundness', 504 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 502 => 'PostCropVignetteStyle', 504 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 342 => 0xbf },
	'postreleaseburstlength' => { 243 => 0x714, 244 => 0x784, 315 => 0x289 },
	'potentialface1position' => { 439 => 0xb },
	'potentialface2position' => { 439 => 0x15 },
	'potentialface3position' => { 439 => 0x1f },
	'potentialface4position' => { 439 => 0x29 },
	'potentialface5position' => { 439 => 0x33 },
	'potentialface6position' => { 439 => 0x3d },
	'potentialface7position' => { 439 => 0x47 },
	'potentialface8position' => { 439 => 0x51 },
	'powersource' => { 356 => '0.1' },
	'poweruptime' => { 236 => 0xb6 },
	'preaf' => { 128 => '0.2' },
	'precaptureframes' => { 324 => 0x300 },
	'predictor' => { 121 => 0x13d },
	'preflashreturnstrength' => { 271 => 0x28a },
	'prefs' => { 133 => 0xdd, 389 => 'Prefs' },
	'prereadfastresetcount' => { 140 => 0x187e },
	'prereleaseburstlength' => { 243 => 0x712, 244 => 0x782, 315 => 0x287 },
	'preservedfilename' => { 532 => 'PreservedFileName' },
	'preservedspecimen' => { 120 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 120 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 502 => 'PresetType', 504 => 'PresetType' },
	'presetwhitebalance' => { 186 => 0x24, 478 => 0x8002 },
	'presetwhitebalanceadj' => { 478 => 0x8014 },
	'pressure' => { 121 => 0x9402, 509 => 'Pressure' },
	'previewapplicationname' => { 121 => 0xc716 },
	'previewapplicationversion' => { 121 => 0xc717 },
	'previewbutton' => { 299 => ['14.1','15.1'], 300 => '15.1', 302 => '15.1', 303 => '15.1', 308 => '29.1', 309 => '14.1', 312 => '15.1', 313 => '15.1' },
	'previewbuttonplusdials' => { 299 => ['14.2','15.2'], 300 => '15.2', 302 => '43.1', 303 => '43.1', 308 => '31.2', 312 => '43.1', 313 => '43.1' },
	'previewcolorspace' => { 121 => 0xc71a },
	'previewcropbottom' => { 388 => 0xef },
	'previewcropleft' => { 388 => 0xec },
	'previewcropright' => { 388 => 0xee },
	'previewcroptop' => { 388 => 0xed },
	'previewdate' => { 400 => 0x0 },
	'previewdatetime' => { 121 => 0xc71b },
	'previewimage' => { 115 => 0x2000, 116 => 'Exif-PreviewImage', 122 => 'PreviewImage', 124 => 0x4, 168 => 'data', 188 => 0x81, 324 => 0x280, 340 => 0x300, 402 => 'mcvr', 442 => 0x2001 },
	'previewimageborders' => { 377 => 0x3e },
	'previewimageheight' => { 74 => 0x4, 144 => 0xfa58 },
	'previewimagelength' => { 74 => 0x2, 115 => 0x3, 121 => [0x117,0x202], 188 => 0x89, 255 => 0x202, 319 => 0x102, 324 => 0x1037, 377 => 0x3, 408 => 0x1e, 413 => 0x3, 419 => [0x1b,0x1d], 432 => 0x202 },
	'previewimagename' => { 168 => '1Name' },
	'previewimagesize' => { 115 => 0x2, 149 => 0x2, 168 => 'ImageSize', 377 => 0x2, 419 => [0x1c,0x1e], 442 => 0xb02c, 478 => 0x9012 },
	'previewimagestart' => { 74 => 0x5, 115 => 0x4, 121 => [0x111,0x201], 188 => 0x88, 255 => 0x201, 319 => 0x101, 324 => 0x1036, 377 => 0x4, 408 => 0x1c, 413 => 0x2, 419 => [0x1a,0x1c], 432 => 0x201 },
	'previewimagetype' => { 168 => '0Type' },
	'previewimagevalid' => { 319 => 0x100, 324 => 0x1035 },
	'previewimagewidth' => { 74 => 0x3, 144 => 0xfa57 },
	'previewquality' => { 74 => 0x1 },
	'previewsettingsdigest' => { 121 => 0xc719 },
	'previewsettingsname' => { 121 => 0xc718 },
	'primaryafpoint' => { 195 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 121 => 0x13f, 527 => 'PrimaryChromaticities' },
	'primaryftp' => { 492 => 'PrimaryFTP' },
	'primaryslot' => { 245 => 0x25, 263 => 0x2 },
	'printim' => { 121 => 0xc4a5 },
	'prioritysetinawb' => { 442 => 0x202b },
	'prioritysetupshutterrelease' => { 186 => 0x1d, 429 => 0x28 },
	'privatertkinfo' => { 494 => 'privateRTKInfo' },
	'processbordercolsleft' => { 140 => 0xc61 },
	'processbordercolsright' => { 140 => 0xc62 },
	'processborderrowsbottom' => { 140 => 0xc64 },
	'processborderrowstop' => { 140 => 0xc63 },
	'processingsoftware' => { 121 => 0xb },
	'processversion' => { 502 => 'ProcessVersion', 504 => 'ProcessVersion' },
	'producer' => { 181 => 'WM/Producer', 328 => 'Producer', 394 => "\xa9prd", 396 => 'producer', 402 => "\xa9prd", 518 => 'Producer' },
	'producerkeywords' => { 402 => "\xa9pdk" },
	'productcode' => { 521 => 'productCode' },
	'productid' => { 134 => 0x32, 394 => 'prID', 520 => 'productID' },
	'productidtype' => { 520 => 'productIDType' },
	'productinimage' => { 516 => 'ProductInImage' },
	'productinimagedescription' => { 516 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 516 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 516 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 516 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 357 => 0x2 },
	'productorserviceconstraints' => { 329 => 'ProductOrServiceConstraints' },
	'productversion' => { 394 => 'VERS' },
	'profession' => { 521 => 'profession' },
	'profile' => { 481 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 121 => 0xc6f4 },
	'profilecameraindices' => { 481 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 121 => 0xc6fe },
	'profiledynamicrange' => { 121 => 0xcd47 },
	'profileembedpolicy' => { 121 => 0xc6fd },
	'profilegaintablemap' => { 121 => 0xcd2d },
	'profilegaintablemap2' => { 121 => 0xcd40 },
	'profilegroupname' => { 121 => 0xcd48 },
	'profilehuesatmapdata1' => { 121 => 0xc6fa },
	'profilehuesatmapdata2' => { 121 => 0xc6fb },
	'profilehuesatmapdata3' => { 121 => 0xcd39 },
	'profilehuesatmapdims' => { 121 => 0xc6f9 },
	'profilehuesatmapencoding' => { 121 => 0xc7a3 },
	'profilelooktabledata' => { 121 => 0xc726 },
	'profilelooktabledims' => { 121 => 0xc725 },
	'profilelooktableencoding' => { 121 => 0xc7a4 },
	'profilename' => { 121 => 0xc6f8, 330 => 'iCCP-name' },
	'profiles' => { 481 => 'Profiles' },
	'profiletonecurve' => { 121 => 0xc6fc },
	'profiletype' => { 481 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 342 => 0x3c },
	'programline' => { 358 => '1.1' },
	'programmode' => { 191 => 0x5 },
	'programshift' => { 236 => 0xd },
	'programversion' => { 133 => 0x46 },
	'prohibits' => { 500 => 'prohibits' },
	'projectiontype' => { 490 => 'ProjectionType', 491 => 'ProjectionType' },
	'projectname' => { 531 => 'projectName' },
	'projectref' => { 531 => 'projectRef' },
	'projectrefpath' => { 531 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 531 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 181 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 329 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 329 => 'PropertyReleaseStatus' },
	'provider' => { 181 => 'WM/Provider' },
	'province-state' => { 133 => 0x5f },
	'publicationdate' => { 521 => 'publicationDate' },
	'publicationdatea-platform' => { 521 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 521 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 521 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 521 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 521 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 516 => 'PublicationEvent' },
	'publicationeventdate' => { 516 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 516 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 516 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 521 => 'publicationName' },
	'publisher' => { 181 => 'WM/Publisher', 394 => "\xa9pub", 396 => 'publisher', 505 => 'publisher' },
	'publishingfrequency' => { 521 => 'publishingFrequency' },
	'pulldown' => { 531 => 'pullDown' },
	'purchasedate' => { 394 => 'purd' },
	'purplehsl' => { 105 => 0x20916 },
	'pxshiftperiphedgenr' => { 478 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 478 => 0x9014 },
	'quality' => { 0 => 0x1, 35 => 0x3, 114 => 0x2, 115 => 0x3002, 129 => 0x1000, 142 => 0x9, 236 => 0x4, 282 => 0x3, 324 => 0x201, 337 => 0x300, 377 => 0x8, 384 => 0x2, 419 => 0x16, 429 => 0x56, 430 => 0x56, 431 => 0xb, 442 => [0x102,0x202e] },
	'quality2' => { 451 => 0x1170, 452 => 0x1174, 453 => 0x1150, 455 => 0x11a8, 456 => 0x1060, 457 => 0x258, 458 => 0x258, 459 => 0x247, 465 => 0x29, 466 => 0x25, 467 => 0x2a },
	'qualitybutton' => { 316 => 0x17d, 317 => 0x195 },
	'qualitybuttonplaybackmode' => { 316 => 0x1bf, 317 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 115 => 0x8 },
	'quantizationmethod' => { 135 => 0x78 },
	'quickadjust' => { 295 => 0x2a },
	'quickcontroldialinmeter' => { 86 => 0x703 },
	'quickfix' => { 292 => 0x416391c6 },
	'quickshot' => { 418 => 0x213 },
	'quiettime' => { 140 => 0x188a },
	'rads' => { 402 => 'rads' },
	'rangefinder' => { 304 => '4.1', 305 => '5.1', 306 => '5.1' },
	'rangemask' => { 502 => 'RangeMaskMapInfo', 504 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 504 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 504 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 504 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 504 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 504 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 504 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 133 => 0x7d },
	'rating' => { 121 => 0x4746, 129 => 0x1431, 388 => 0xdf, 394 => 'rtng', 402 => 'rtng', 442 => 0x2002, 497 => 'rating', 506 => 'rating', 516 => 'Rating', 521 => 'rating', 529 => 'Rating' },
	'ratingpercent' => { 121 => 0x4749, 180 => 'Rating', 394 => 'rate', 529 => 'RatingPercent' },
	'ratingregion' => { 516 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 516 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 516 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 516 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 516 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 516 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 516 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 516 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 516 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 516 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 516 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 516 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 516 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 516 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 516 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 516 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 516 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 516 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 84 => 0x8, 188 => 0x109, 358 => 0xd },
	'rawbrightnessadj' => { 105 => 0x20001, 110 => 0x38 },
	'rawburstimagecount' => { 76 => 0x2 },
	'rawburstimagenum' => { 76 => 0x1 },
	'rawcoloradj' => { 110 => 0x2e },
	'rawcropbottom' => { 388 => 0xd4 },
	'rawcropleft' => { 388 => 0xd1 },
	'rawcropright' => { 388 => 0xd3 },
	'rawcroptop' => { 388 => 0xd2 },
	'rawcustomsaturation' => { 110 => 0x30 },
	'rawcustomtone' => { 110 => 0x34 },
	'rawdata' => { 416 => 0xa048 },
	'rawdatabyteorder' => { 416 => 0x40 },
	'rawdatacfapattern' => { 416 => 0x50 },
	'rawdatauniqueid' => { 121 => 0xc65d },
	'rawdepth' => { 190 => 0x10 },
	'rawdevartfilter' => { 326 => 0x121 },
	'rawdevautogradation' => { 326 => 0x119 },
	'rawdevcolorspace' => { 325 => 0x108, 326 => 0x109 },
	'rawdevcontrastvalue' => { 325 => 0x106, 326 => 0x105 },
	'rawdeveditstatus' => { 325 => 0x10b },
	'rawdevelopingsoftware' => { 121 => 0xa43a },
	'rawdevelopmentprocess' => { 377 => 0x62 },
	'rawdevengine' => { 325 => 0x109, 326 => 0x10b },
	'rawdevexposurebiasvalue' => { 325 => 0x100, 326 => 0x100 },
	'rawdevgradation' => { 326 => 0x112 },
	'rawdevgraypoint' => { 325 => 0x103, 326 => 0x104 },
	'rawdevmemorycoloremphasis' => { 325 => 0x105, 326 => 0x108 },
	'rawdevnoisereduction' => { 325 => 0x10a, 326 => 0x10a },
	'rawdevpicturemode' => { 326 => 0x10c },
	'rawdevpm_bwfilter' => { 326 => 0x110 },
	'rawdevpmcontrast' => { 326 => 0x10e },
	'rawdevpmnoisefilter' => { 326 => 0x120 },
	'rawdevpmpicturetone' => { 326 => 0x111 },
	'rawdevpmsaturation' => { 326 => 0x10d },
	'rawdevpmsharpness' => { 326 => 0x10f },
	'rawdevsaturation3' => { 326 => 0x113 },
	'rawdevsaturationemphasis' => { 325 => 0x104, 326 => 0x107 },
	'rawdevsettings' => { 325 => 0x10c },
	'rawdevsharpnessvalue' => { 325 => 0x107, 326 => 0x106 },
	'rawdevversion' => { 325 => 0x0, 326 => 0x0 },
	'rawdevwbfineadjustment' => { 325 => 0x102, 326 => 0x103 },
	'rawdevwhitebalance' => { 326 => 0x101 },
	'rawdevwhitebalancevalue' => { 325 => 0x101, 326 => 0x102 },
	'rawfile' => { 121 => 0xfe4c },
	'rawfilename' => { 502 => 'RawFileName', 504 => 'RawFileName' },
	'rawfiletype' => { 442 => 0x2029 },
	'rawformat' => { 347 => 0x2d, 386 => 0x10e },
	'rawimagecenter' => { 236 => 0x99 },
	'rawimagedigest' => { 121 => 0xc71c },
	'rawimagesize' => { 377 => 0x39 },
	'rawinfoversion' => { 327 => 0x0 },
	'rawjpgheight' => { 101 => 0x4 },
	'rawjpgquality' => { 58 => 0x6, 101 => 0x1 },
	'rawjpgsize' => { 58 => 0x7, 101 => 0x2 },
	'rawjpgwidth' => { 101 => 0x3 },
	'rawmeasuredrggb' => { 44 => 0x26a, 46 => 0x280, 48 => 0x194, 49 => [0x1ad,0x26b] },
	'rawrppused' => { 497 => 'rawrppused' },
	'rawtopreviewgain' => { 121 => 0xc7a8 },
	'readouttypeactual' => { 140 => 0x1903 },
	'readouttyperequested' => { 140 => 0x1902 },
	'reardisplay' => { 299 => '12.3', 300 => '6.2' },
	'recdevice' => { 516 => 'RecDevice' },
	'recdeviceattlensdescription' => { 516 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 516 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 516 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 516 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 516 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 523 => 'recipeEndingPage' },
	'recipepagerange' => { 523 => 'recipePageRange' },
	'recipesource' => { 523 => 'recipeSource' },
	'recipestartingpage' => { 523 => 'recipeStartingPage' },
	'recipetitle' => { 523 => 'recipeTitle' },
	'recognizedface1age' => { 335 => 0x20 },
	'recognizedface1name' => { 335 => 0x4 },
	'recognizedface1position' => { 335 => 0x18 },
	'recognizedface2age' => { 335 => 0x50 },
	'recognizedface2name' => { 335 => 0x34 },
	'recognizedface2position' => { 335 => 0x48 },
	'recognizedface3age' => { 335 => 0x80 },
	'recognizedface3name' => { 335 => 0x64 },
	'recognizedface3position' => { 335 => 0x78 },
	'recognizedfaceflags' => { 342 => 0x63 },
	'recommendedexposureindex' => { 121 => 0x8832, 509 => 'RecommendedExposureIndex' },
	'record' => { 120 => 'Record' },
	'recordbasisofrecord' => { 120 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 120 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 120 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 120 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 120 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 120 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 186 => 0x4d },
	'recorddynamicproperties' => { 120 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 99 => 0x1804 },
	'recordinformationwithheld' => { 120 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 402 => "\xa9phg" },
	'recordingformat' => { 409 => 0x1000 },
	'recordingmode' => { 114 => 0x1, 384 => 0x1 },
	'recordinstitutioncode' => { 120 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 120 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 402 => "\xa9lab" },
	'recordlabelurl' => { 402 => "\xa9lal" },
	'recordlocationdata' => { 242 => 0x660, 243 => 0x690, 244 => 0x6f8 },
	'recordmode' => { 35 => 0x9, 115 => 0x3000 },
	'recordownerinstitutioncode' => { 120 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 418 => 0x217 },
	'redbalance' => { 324 => 0x1017, 347 => 0x11, 377 => 0x1c },
	'redcurvelimits' => { 110 => 0x18a },
	'redcurvepoints' => { 109 => 0x2d, 110 => 0x160 },
	'redeyecorrection' => { 296 => 0x0 },
	'redeyeinfo' => { 502 => 'RedEyeInfo', 504 => 'RedEyeInfo' },
	'redeyereduction' => { 186 => 0x41, 429 => 0x6a, 431 => 0x28 },
	'redeyeremoval' => { 342 => 0xb9 },
	'redhsl' => { 105 => 0x20910 },
	'redhue' => { 502 => 'RedHue', 504 => 'RedHue' },
	'redsaturation' => { 502 => 'RedSaturation', 504 => 'RedSaturation' },
	'reductionmatrix1' => { 121 => 0xc625 },
	'reductionmatrix2' => { 121 => 0xc626 },
	'reductionmatrix3' => { 121 => 0xcd3a },
	'reelname' => { 121 => 0xc789, 402 => 'reel' },
	'reference1' => { 514 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 514 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 121 => 0x214, 527 => 'ReferenceBlackWhite' },
	'referencedate' => { 133 => 0x2f },
	'referencenumber' => { 133 => 0x32 },
	'references' => { 159 => 'References' },
	'referenceservice' => { 133 => 0x2d },
	'regionappliedtodimensions' => { 174 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 174 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 174 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 174 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 174 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 174 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 174 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 174 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 174 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 174 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 174 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 174 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 329 => 'RegionConstraints' },
	'regiondescription' => { 174 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 174 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 174 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 174 => 'Regions' },
	'regioninfodateregionsvalid' => { 177 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 177 => 'RegionInfo' },
	'regioninforegions' => { 177 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 174 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 174 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 177 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 177 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 177 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 177 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 177 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 174 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 174 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 174 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 516 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 516 => 'RegistryId' },
	'registryitemid' => { 516 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 516 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 157 => 'data' },
	'relatedaudiofilename' => { 157 => '1Name' },
	'relatedaudiofiletype' => { 157 => '0Type' },
	'relatedimagefileformat' => { 121 => 0x1000 },
	'relatedimageheight' => { 121 => 0x1002 },
	'relatedimagewidth' => { 121 => 0x1001 },
	'relatedresourceid' => { 120 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 121 => 0xa004, 508 => 'RelatedSoundFile' },
	'relatedvideofile' => { 171 => 'data' },
	'relatedvideofilename' => { 171 => '1Name' },
	'relatedvideofiletype' => { 171 => '0Type' },
	'relation' => { 505 => 'relation' },
	'relationshipaccordingto' => { 120 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 120 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 120 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 120 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 120 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 118 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 531 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 531 => 'relativeTimestamp' },
	'relativetimestampscale' => { 531 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 531 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 299 => '17.8', 300 => '18.5', 302 => '18.4', 303 => '18.4', 308 => '33.8', 309 => '17.6', 312 => '18.5', 313 => '18.4' },
	'releasedate' => { 133 => 0x1e, 394 => 'rldt', 497 => 'ReleaseDate', 531 => 'releaseDate' },
	'releasemode' => { 115 => 0x3001, 240 => 0x5c, 273 => 0x184d, 442 => 0xb049 },
	'releasemode2' => { 451 => 0x112c, 452 => [0x112c,0x8], 453 => [0x1108,0x8], 454 => [0x1184,0x8], 455 => [0x1160,0x8], 456 => [0x4,0x1018], 457 => [0x4,0x210], 458 => [0x4,0x210], 459 => [0x4,0x208], 461 => [0x67,0x3f], 462 => [0x6b,0x6d,0x73,0x4b], 463 => [0x6b,0x4b], 464 => 0x1f, 465 => 0x10, 466 => 0x10, 467 => 0x9, 474 => 0x34 },
	'releasemode3' => { 451 => 0x1128, 452 => 0x1128, 453 => 0x1104, 454 => 0x1180, 455 => 0x115c, 456 => 0x1014, 457 => 0x20c, 458 => 0x20c, 459 => 0x204 },
	'releaseready' => { 516 => 'ReleaseReady' },
	'releasesetting' => { 99 => 0x1016 },
	'releasetime' => { 133 => 0x23, 497 => 'ReleaseTime' },
	'remoteonduration' => { 301 => '3.4', 304 => '17.2', 305 => '18.2', 306 => '18.2', 307 => '18.2', 309 => '18.2', 310 => '4.3', 314 => '19.2' },
	'renditionclass' => { 532 => 'RenditionClass' },
	'renditionof' => { 532 => 'RenditionOf' },
	'renditionofalternatepaths' => { 532 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 532 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 532 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 532 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 532 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 532 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 532 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 532 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 532 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 532 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 532 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 532 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 532 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 532 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 532 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 532 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 532 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 532 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 532 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 532 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 532 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 532 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 532 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 532 => 'RenditionParams' },
	'repeatingflashcount' => { 214 => 0xd, 215 => 0xe, 216 => 0xe, 217 => 0xe, 218 => 0xe, 219 => 0xe, 308 => '17.2', 309 => '24.2', 310 => '9.2', 311 => '24.2', 314 => '25.2' },
	'repeatingflashcountbuilt-in' => { 280 => 0x4db },
	'repeatingflashcountexternal' => { 280 => 0x4c3 },
	'repeatingflashoutput' => { 308 => '17.1', 309 => '24.1', 310 => '9.1', 311 => '24.1', 314 => '25.1' },
	'repeatingflashoutputexternal' => { 280 => 0x4c0 },
	'repeatingflashrate' => { 214 => 0xc, 215 => 0xd, 216 => 0xd, 217 => 0xd, 218 => 0xd, 219 => 0xd, 308 => '18.1', 309 => '25.1', 310 => '10.1', 311 => '25.1', 314 => '26.1' },
	'repeatingflashratebuilt-in' => { 280 => 0x4da },
	'repeatingflashrateexternal' => { 280 => 0x4c2 },
	'requirements' => { 402 => "\xa9req" },
	'requires' => { 500 => 'requires' },
	'resampleparams' => { 531 => 'resampleParams' },
	'resampleparamsquality' => { 531 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 140 => 0xe50 },
	'resamplingkerneldenominators067' => { 140 => 0xe4f },
	'resamplingkerneldenominators100' => { 140 => 0xe51 },
	'resaved' => { 418 => 0x21e },
	'resetblacksegrows' => { 140 => 0x181a },
	'resolution' => { 164 => 'Resolution' },
	'resolutionmode' => { 419 => [0x87,0x4] },
	'resolutionunit' => { 121 => 0x128, 136 => 0x2, 527 => 'ResolutionUnit' },
	'resourceid' => { 120 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 120 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 120 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 86 => 0x612 },
	'restrictions' => { 524 => 'restrictions' },
	'retouchareafeather' => { 502 => [\'RetouchAreas','RetouchAreasFeather'], 504 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 502 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 504 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 502 => [\'RetouchAreas','RetouchAreasMasksAngle'], 504 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 502 => [\'RetouchAreas','RetouchAreasMasksBottom'], 504 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 502 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 504 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 502 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 504 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 502 => [\'RetouchAreas','RetouchAreasMasksDabs'], 504 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 502 => [\'RetouchAreas','RetouchAreasMasksFeather'], 504 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 502 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 504 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 502 => [\'RetouchAreas','RetouchAreasMasksFlow'], 504 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 502 => [\'RetouchAreas','RetouchAreasMasksFullX'], 504 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 502 => [\'RetouchAreas','RetouchAreasMasksFullY'], 504 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 502 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 504 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 502 => [\'RetouchAreas','RetouchAreasMasksLeft'], 504 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasks'], 504 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 502 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 504 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 502 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 504 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 502 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 504 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 502 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 504 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 502 => [\'RetouchAreas','RetouchAreasMasksRadius'], 504 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 504 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 502 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 504 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 502 => [\'RetouchAreas','RetouchAreasMasksRight'], 504 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 502 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 504 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 502 => [\'RetouchAreas','RetouchAreasMasks'], 504 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 502 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 504 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 502 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 504 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 502 => [\'RetouchAreas','RetouchAreasMasksTop'], 504 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 502 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 504 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 502 => [\'RetouchAreas','RetouchAreasMasksVersion'], 504 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 502 => [\'RetouchAreas','RetouchAreasMasksWhat'], 504 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 502 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 504 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 502 => [\'RetouchAreas','RetouchAreasMasksX'], 504 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 502 => [\'RetouchAreas','RetouchAreasMasksY'], 504 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 502 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 504 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 502 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 504 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 502 => [\'RetouchAreas','RetouchAreasMethod'], 504 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 502 => [\'RetouchAreas','RetouchAreasOffsetY'], 504 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 502 => [\'RetouchAreas','RetouchAreasOpacity'], 504 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 502 => 'RetouchAreas', 504 => 'RetouchAreas' },
	'retouchareaseed' => { 502 => [\'RetouchAreas','RetouchAreasSeed'], 504 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 502 => [\'RetouchAreas','RetouchAreasSourceState'], 504 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 502 => [\'RetouchAreas','RetouchAreasSourceX'], 504 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 502 => [\'RetouchAreas','RetouchAreasSpotType'], 504 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 236 => 0x9e },
	'retouchinfo' => { 502 => 'RetouchInfo', 504 => 'RetouchInfo' },
	'retouchnefprocessing' => { 257 => 0x5 },
	'retractlensonpoweroff' => { 86 => 0x814 },
	'reuse' => { 329 => 'Reuse' },
	'reuseallowed' => { 534 => 'ReuseAllowed' },
	'reuseprohibited' => { 524 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 306 => '5.2' },
	'reversefocusring' => { 315 => 0x163, 316 => 0x163, 317 => 0x17b },
	'reverseindicators' => { 299 => '12.1', 300 => '6.1', 302 => '6.1', 303 => '6.1', 304 => '4.3', 305 => '5.2', 306 => '5.4', 308 => '33.5', 309 => '5.1', 312 => '6.1', 313 => '6.1', 314 => '6.2', 315 => 0xc1, 316 => 0xc1, 317 => 0xc1 },
	'reverseshutterspeedaperture' => { 306 => '5.3' },
	'revision' => { 506 => 'revision' },
	'rflensmffocusringsensitivity' => { 86 => 0x714 },
	'rflenstype' => { 58 => 0x3d },
	'rgbcurvelimits' => { 110 => 0x238 },
	'rgbcurvepoints' => { 109 => 0x7, 110 => 0x20e },
	'rgbtables' => { 121 => 0xcd3b },
	'richtextcomment' => { 511 => 'RichTextComment' },
	'ricohdate' => { 408 => 0x6 },
	'ricohimageheight' => { 408 => 0x2 },
	'ricohimagewidth' => { 408 => 0x0 },
	'rightalbedo' => { 493 => 'RightAlbedo' },
	'rightascension' => { 167 => 'RightAscension' },
	'rights' => { 505 => 'rights' },
	'rightsagent' => { 524 => 'rightsAgent' },
	'rightsowner' => { 524 => 'rightsOwner' },
	'roll' => { 117 => 0x8, 402 => ['roll',"\xa9frl"] },
	'rollangle' => { 129 => 0x144d, 249 => 0x0, 319 => 0x903, 342 => 0x90, 376 => 0x1, 414 => 0x2 },
	'romoperationmode' => { 99 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 98 => 0x3, 105 => 0x10002, 110 => 0x26e, 116 => 'QuickTime-Rotation', 125 => 0x4, 167 => 'Rotation', 184 => [0x65,0x50], 185 => 0x46, 186 => 0x5a, 189 => 0x10, 258 => 0x1a, 273 => 0x3693, 279 => '590.1', 292 => 0x76a43207, 342 => 0x30, 358 => '17.2', 388 => 0xd8, 395 => 'irot', 429 => 0x3f, 430 => 0x3f, 440 => 0x10 },
	'routedto' => { 510 => 'RoutedTo' },
	'routing' => { 393 => 'Routing' },
	'routingdestinations' => { 492 => 'RoutingDestinations' },
	'routingexclusions' => { 492 => 'RoutingExclusions' },
	'routingnotes' => { 510 => 'RoutingNotes' },
	'rowsperstrip' => { 121 => 0x116 },
	'rpp' => { 497 => 'rpp' },
	'rtkflag' => { 118 => 'RtkFlag' },
	'rtkstdhgt' => { 118 => 'RtkStdHgt' },
	'rtkstdlat' => { 118 => 'RtkStdLat' },
	'rtkstdlon' => { 118 => 'RtkStdLon' },
	'safetyshift' => { 86 => 0x108 },
	'safetyshiftinavortv' => { 84 => 0x10, 85 => 0x10, 87 => 0xf, 88 => 0x10, 91 => 0x10 },
	'sameexposurefornewaperture' => { 86 => 0x112 },
	'samplebits' => { 157 => 'SampleBits' },
	'samplepagerange' => { 521 => 'samplePageRange' },
	'samplerate' => { 157 => 'SampleRate' },
	'samplesperpixel' => { 121 => 0x115, 347 => 0x8, 527 => 'SamplesPerPixel' },
	'samplestructure' => { 135 => 0x5a },
	'samsungmodelid' => { 416 => 0x3 },
	'sanyoquality' => { 418 => 0x201 },
	'sanyothumbnail' => { 418 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 35 => 0xe, 52 => 0x1, 64 => 0x7, 114 => 0xd, 115 => [0x3013,0x1f], 121 => [0xa409,0xfe55], 129 => 0x1003, 158 => 'Saturation', 183 => 0x1f, 184 => 0x32, 185 => 0x28, 186 => 0x1a, 191 => 0x1, 236 => 0xaa, 251 => 0x35, 252 => 0x3b, 253 => 0x43, 342 => 0x40, 344 => 0x300d, 377 => 0x1f, 384 => 0xd, 403 => 0x27, 405 => 0x58, 408 => 0x28, 409 => 0x1013, 419 => 0x10, 429 => 0x1e, 430 => 0x1b, 442 => 0x2005, 502 => 'Saturation', 504 => 'Saturation', 508 => 'Saturation' },
	'saturationadj' => { 105 => 0x20901, 110 => 0x116, 236 => 0x94, 291 => 0x1, 295 => 0x2e, 478 => 0x8016 },
	'saturationadjustmentaqua' => { 502 => 'SaturationAdjustmentAqua', 504 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 502 => 'SaturationAdjustmentBlue', 504 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 502 => 'SaturationAdjustmentGreen', 504 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 502 => 'SaturationAdjustmentMagenta', 504 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 502 => 'SaturationAdjustmentOrange', 504 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 502 => 'SaturationAdjustmentPurple', 504 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 502 => 'SaturationAdjustmentRed', 504 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 502 => 'SaturationAdjustmentYellow', 504 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 72 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 71 => 0x68, 72 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 71 => 0x38, 72 => 0x38 },
	'saturationmonochrome' => { 71 => 0x80, 72 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 71 => 0x50, 72 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 71 => 0x20, 72 => 0x20 },
	'saturationsetting' => { 327 => 0x1010, 431 => 0x11, 447 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 71 => 0x8, 72 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 71 => 0x98, 72 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 71 => 0xb0, 72 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 71 => 0xc8, 72 => 0xe0 },
	'saveid' => { 532 => 'SaveID' },
	'sbaanalysiscomplete' => { 140 => 0xc35 },
	'sbablack' => { 140 => 0xc25 },
	'sbagmoffset' => { 140 => 0xc4a },
	'sbagray' => { 140 => 0xc26 },
	'sbagreenmagentabal' => { 140 => 0xc33 },
	'sbahighgray' => { 140 => 0xc46 },
	'sbailloffset' => { 140 => 0xc49 },
	'sbailluminantbal' => { 140 => 0xc34 },
	'sbalowgray' => { 140 => 0xc47 },
	'sbaneutralbal' => { 140 => 0xc32 },
	'sbawhite' => { 140 => 0xc27 },
	'scaletype' => { 531 => 'scaleType' },
	'scanimageenhancer' => { 259 => 0x60 },
	'scanningdirection' => { 135 => 0x64 },
	'scene' => { 402 => 'scen', 515 => 'Scene', 531 => 'scene' },
	'scenearea' => { 322 => 0x211, 324 => 0x1031 },
	'sceneassist' => { 236 => 0x9c },
	'scenecapturetype' => { 121 => 0xa406, 508 => 'SceneCaptureType' },
	'scenedetect' => { 322 => 0x210, 324 => 0x1030 },
	'scenedetectdata' => { 322 => 0x212, 324 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 144 => 0xfa02, 188 => 0x100, 236 => 0x8f, 319 => 0x509, 324 => 0x403, 342 => 0x8001, 351 => 0xf, 442 => 0xb023 },
	'scenemodeused' => { 146 => [0x6002,0xf002] },
	'scenerecognition' => { 129 => 0x1425 },
	'scenereferred' => { 512 => 'scene_referred' },
	'sceneselect' => { 418 => 0x21f },
	'scenetype' => { 121 => 0xa301, 508 => 'SceneType' },
	'screentips' => { 299 => '12.7', 300 => '5.3', 308 => '13.1', 309 => '4.4', 312 => '5.4', 314 => '5.1' },
	'scriptversion' => { 140 => 0x1770 },
	'sdrblend' => { 502 => 'SDRBlend', 504 => 'SDRBlend' },
	'sdrbrightness' => { 502 => 'SDRBrightness', 504 => 'SDRBrightness' },
	'sdrcontrast' => { 502 => 'SDRContrast', 504 => 'SDRContrast' },
	'sdrhighlights' => { 502 => 'SDRHighlights', 504 => 'SDRHighlights' },
	'sdrshadows' => { 502 => 'SDRShadows', 504 => 'SDRShadows' },
	'sdrwhites' => { 502 => 'SDRWhites', 504 => 'SDRWhites' },
	'season' => { 516 => 'Season', 520 => 'season' },
	'seasonidentifier' => { 516 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 516 => [\'Season','SeasonName'] },
	'seasonnumber' => { 516 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 492 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 241 => 0x240, 242 => 0x22c, 243 => 0x240, 244 => 0x240, 262 => 0x13c, 273 => 0x1d0 },
	'section' => { 521 => 'section' },
	'securityclassification' => { 121 => 0x9212 },
	'selectableafpoint' => { 86 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 86 => 0x512 },
	'selfdata' => { 118 => 'SelfData' },
	'selftimer' => { 35 => 0x2, 342 => 0x2e, 418 => 0x214, 451 => 0x1134, 452 => 0x1134, 453 => 0x1110, 454 => 0x118c, 455 => 0x1168, 456 => 0x1020, 457 => 0x218, 458 => 0x218, 459 => 0x210 },
	'selftimer2' => { 78 => 0x1d },
	'selftimerinterval' => { 309 => '19.2' },
	'selftimermode' => { 121 => 0x882b },
	'selftimershotcount' => { 300 => '20.2', 302 => '20.3', 303 => '20.3', 304 => '18.2', 305 => '19.2', 306 => '19.2', 307 => '19.3', 309 => '19.3', 312 => '20.3', 313 => '20.3', 314 => '20.2', 315 => 0x2d, 316 => 0x2d, 317 => 0x2d },
	'selftimershotinterval' => { 300 => '20.3', 302 => '20.2', 303 => '20.2', 307 => '19.2', 312 => '20.2', 313 => '20.2', 315 => 0x31, 316 => 0x31, 317 => 0x31 },
	'selftimertime' => { 99 => 0x1806, 186 => 0x1f, 299 => '18.1', 300 => '20.1', 301 => '3.3', 302 => '20.1', 303 => '20.1', 304 => '18.1', 305 => '19.1', 306 => '19.1', 307 => '19.1', 308 => '7.2', 309 => '19.1', 310 => '3.3', 312 => '20.1', 313 => '20.1', 314 => '20.1', 315 => 0x2b, 316 => 0x2b, 317 => 0x2b },
	'sellingagency' => { 521 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 121 => 0x8546 },
	'sensingmethod' => { 121 => 0xa217, 508 => 'SensingMethod' },
	'sensitivityadjust' => { 377 => 0x40 },
	'sensitivitysteps' => { 358 => ['14.3','17.4'], 360 => 0x1 },
	'sensitivitytype' => { 121 => 0x8830, 509 => 'SensitivityType' },
	'sensor' => { 193 => 0x665e },
	'sensorarea' => { 324 => 0x400 },
	'sensorareas' => { 416 => 0xa010 },
	'sensorbitdepth' => { 344 => 0x312d },
	'sensorbluelevel' => { 75 => 0x5 },
	'sensorcalibration' => { 323 => 0x805 },
	'sensorcleaning' => { 92 => 0xd },
	'sensorfullheight' => { 139 => 0xf904 },
	'sensorfullwidth' => { 139 => 0xf903 },
	'sensorheight' => { 139 => 0xf901, 144 => 0xfa21, 190 => 0x8, 344 => 0x312c, 386 => 0x109, 409 => 0x1602 },
	'sensorimageheight' => { 140 => 0x3ee },
	'sensorimagewidth' => { 140 => 0x3ed },
	'sensorleftborder' => { 140 => 0x3eb },
	'sensorleftmargin' => { 386 => 0x10a },
	'sensorpixelsize' => { 236 => 0x9a },
	'sensorredlevel' => { 75 => 0x4 },
	'sensorserialnumber' => { 140 => 0x9ce },
	'sensorshield' => { 241 => 0x76b, 242 => 0x66d, 243 => 0x69d, 244 => 0x705 },
	'sensorsize' => { 158 => 'SensorSize', 377 => 0x35 },
	'sensortemperature' => { 322 => 0x1500, 324 => 0x1007, 382 => 0xc, 386 => 0x210, 419 => [0x39,0x55] },
	'sensortemperature2' => { 382 => 0xe, 386 => 0x211 },
	'sensortopborder' => { 140 => 0x3ec },
	'sensortopmargin' => { 386 => 0x10b },
	'sensortype' => { 342 => 0xca },
	'sensorwidth' => { 139 => 0xf900, 144 => 0xfa20, 190 => 0xa, 344 => 0x312b, 386 => 0x108, 409 => 0x1601 },
	'sequence' => { 403 => 0x7, 404 => 0x35, 405 => 0x36 },
	'sequencefilenumber' => { 452 => 0x4, 453 => 0x4, 454 => 0x4, 455 => 0x4, 465 => 0xc, 466 => 0xc, 467 => 0x1a },
	'sequenceimagenumber' => { 452 => 0x0, 453 => 0x0, 454 => 0x0, 455 => 0x0, 465 => 0x8, 466 => 0x8, 467 => 0x12, 474 => 0x24 },
	'sequencelength' => { 465 => 0x22, 466 => 0x1e, 467 => [0x16,0x1e] },
	'sequencename' => { 520 => 'sequenceName' },
	'sequencenumber' => { 78 => 0x9, 115 => 0x301c, 129 => 0x1101, 142 => 0x1d, 280 => 0x51c, 342 => 0x2b, 431 => [0x10c,0x30c], 442 => 0xb04a, 520 => 'sequenceNumber' },
	'sequenceshotinterval' => { 418 => 0x224 },
	'sequencetotalnumber' => { 520 => 'sequenceTotalNumber' },
	'sequentialshot' => { 418 => 0x20e },
	'serialnumber' => { 65 => 0xc, 99 => 0x180b, 121 => [0xa431,0xfde9], 139 => 0xfa04, 141 => 0xfa00, 143 => 0xc354, 144 => 0xfa19, 155 => 0x0, 158 => 'SerialNumber', 193 => 0x5501, 236 => [0xa0,0x1d], 320 => 0x101, 324 => [0x404,0x101a], 337 => 0x303, 339 => 0x305, 344 => 0x3103, 377 => 0x229, 386 => 0x102, 387 => 0x407, 402 => ['SNum','slno'], 403 => 0x15, 404 => 0x4b, 405 => 0x7e, 409 => 0x5, 416 => 0xa002, 419 => 0x2, 442 => 0x2031, 499 => 'SerialNumber', 509 => 'BodySerialNumber' },
	'serialnumberformat' => { 65 => 0x15, 99 => 0x183b },
	'serialnumberhash' => { 402 => 'CAME' },
	'series' => { 516 => 'Series' },
	'seriesdatetime' => { 480 => 'SeriesDateTime' },
	'seriesdescription' => { 480 => 'SeriesDescription' },
	'seriesidentifier' => { 516 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 480 => 'SeriesModality' },
	'seriesname' => { 516 => [\'Series','SeriesName'] },
	'seriesnumber' => { 480 => 'SeriesNumber', 521 => 'seriesNumber' },
	'seriestitle' => { 521 => 'seriesTitle' },
	'serviceidentifier' => { 134 => 0x1e },
	'servingsize' => { 523 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 89 => 0x0, 90 => 0x0 },
	'setbuttonwhenshooting' => { 84 => 0x1, 86 => 0x704, 92 => 0xc },
	'setclockfromlocationdata' => { 242 => 0x61d, 243 => 0x64d, 244 => 0x6b5 },
	'setfunctionwhenshooting' => { 87 => 0x0, 88 => 0x1, 91 => 0x1 },
	'setting' => { 520 => 'setting' },
	'shadingcompensation' => { 319 => 0x50c, 342 => 0x8a },
	'shadingcompensation2' => { 323 => 0x1012 },
	'shadow' => { 419 => 0xe },
	'shadowadj' => { 105 => 0x2030b },
	'shadowcorrection' => { 377 => 0x79 },
	'shadowprotection' => { 291 => 0x0 },
	'shadows' => { 121 => 0xfe52, 442 => 0x2032, 496 => 'Shadows', 502 => 'Shadows', 504 => 'Shadows' },
	'shadows2012' => { 502 => 'Shadows2012', 504 => 'Shadows2012' },
	'shadowsadj' => { 478 => 0x901a },
	'shadowscale' => { 121 => 0xc633 },
	'shadowtint' => { 502 => 'ShadowTint', 504 => 'ShadowTint' },
	'shadowtone' => { 129 => 0x1040 },
	'shakereduction' => { 379 => 0x1, 380 => 0x1 },
	'shareduserrating' => { 181 => 'WM/SharedUserRating' },
	'sharpendetail' => { 502 => 'SharpenDetail', 504 => 'SharpenDetail' },
	'sharpenedgemasking' => { 502 => 'SharpenEdgeMasking', 504 => 'SharpenEdgeMasking' },
	'sharpening' => { 344 => 0x300b },
	'sharpeningadj' => { 295 => 0x2b },
	'sharpeningkernel' => { 140 => 0x92f },
	'sharpenradius' => { 502 => 'SharpenRadius', 504 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 35 => 0xf, 64 => 0x6, 75 => 0x2, 114 => 0xb, 115 => [0x3011,0x21], 121 => [0xa40a,0xfe56], 129 => 0x1001, 142 => 0x6b, 151 => 0x37, 158 => 'Sharpness', 183 => 0x21, 184 => 0x30, 185 => 0x26, 186 => 0x18, 191 => 0x3, 236 => 0x6, 251 => 0x32, 252 => 0x33, 253 => 0x39, 324 => 0x100f, 342 => 0x41, 377 => 0x21, 384 => 0xb, 403 => 0x26, 405 => 0x56, 408 => 0x22, 409 => [0x1003,0x1014], 419 => 0x11, 429 => 0x1c, 430 => 0x19, 442 => 0x2006, 474 => 0x52, 502 => 'Sharpness', 504 => 'Sharpness', 508 => 'Sharpness' },
	'sharpnessadj' => { 105 => 0x20310, 110 => 0x25a, 478 => 0x801a },
	'sharpnessadjon' => { 105 => '0x20310.0' },
	'sharpnessauto' => { 72 => 0x94 },
	'sharpnessfactor' => { 324 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 71 => 0x64, 72 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 75 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 71 => 0x34, 72 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 71 => 0x7c, 72 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 71 => 0x4c, 72 => 0x4c },
	'sharpnessovershoot' => { 478 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 71 => 0x1c, 72 => 0x1c },
	'sharpnessrange' => { 442 => 0x2035 },
	'sharpnesssetting' => { 319 => 0x506, 327 => 0x1013, 431 => 0x12, 447 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 71 => 0x4, 72 => 0x4 },
	'sharpnessstrength' => { 105 => 0x20311 },
	'sharpnessthreshold' => { 478 => 0x801d },
	'sharpnessundershoot' => { 478 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 71 => 0x94, 72 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 71 => 0xac, 72 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 71 => 0xc4, 72 => 0xdc },
	'shiftcols' => { 140 => 0xc70 },
	'shootid' => { 520 => 'shootID' },
	'shootingdistance' => { 105 => 0x20701 },
	'shootinginfodisplay' => { 299 => '13.2', 300 => '5.1', 308 => '10.2', 309 => '4.1', 312 => '5.1', 314 => '5.3' },
	'shootinginfomonitorofftime' => { 299 => '26.2', 300 => '22.2', 302 => '22.2', 303 => '22.2', 307 => '21.2', 308 => '9.1', 309 => '21.2', 312 => '22.2', 313 => '22.2', 314 => '22.2', 315 => 0x37, 316 => 0x37, 317 => 0x37 },
	'shootingmode' => { 158 => 'ShootingMode', 236 => 0x89, 342 => 0x1f },
	'shootingmodesetting' => { 301 => '5.1' },
	'shortdescription' => { 506 => 'shortdescription' },
	'shortdocumentid' => { 133 => 0xba },
	'shortname' => { 502 => 'ShortName', 504 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 86 => 0x80d },
	'shorttitle' => { 394 => '@sti' },
	'shotdate' => { 531 => 'shotDate' },
	'shotday' => { 531 => 'shotDay' },
	'shotlocation' => { 531 => 'shotLocation' },
	'shotlogdata' => { 485 => 'shot_log_data' },
	'shotname' => { 402 => 'shot', 531 => 'shotName' },
	'shotnumber' => { 531 => 'shotNumber' },
	'shotnumbersincepowerup' => { 446 => 0x44e, 465 => 0x1a, 466 => 0x16, 467 => 0xa },
	'shotnumbersincepowerup2' => { 431 => 0x200 },
	'shotsize' => { 531 => 'shotSize' },
	'shotsperinterval' => { 225 => 0x180, 240 => 0xb4, 241 => 0xcc, 242 => 0xc0, 243 => 0xd0, 244 => 0xd0 },
	'showmovement' => { 394 => 'shwm' },
	'shownevent' => { 516 => 'EventExt' },
	'showneventidentifier' => { 516 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 516 => [\'EventExt','EventExtName'] },
	'shutter' => { 461 => 0x20, 462 => 0x26, 463 => 0x26 },
	'shutter-aelock' => { 84 => 0x4, 86 => 0x701, 87 => 0x3, 88 => 0x4, 89 => 0x3, 90 => 0x3, 91 => 0x4, 92 => 0x2 },
	'shutteraelbutton' => { 85 => 0x4 },
	'shutterbuttonafonbutton' => { 86 => 0x701 },
	'shuttercount' => { 11 => 0x176, 32 => 0xaf1, 58 => 0x1, 236 => 0xa7, 264 => [0x6a,0x157,0x24d], 265 => 0x286, 266 => 0x279, 267 => 0x284, 268 => 0x242, 269 => 0x280, 270 => 0x276, 271 => [0x27d,0x27f], 272 => 0x246, 274 => 0x2d6, 275 => 0x321, 276 => 0xbd8, 277 => 0x287, 278 => 0x320, 279 => 0x24a, 280 => 0x5fb, 281 => 0x2d5, 377 => 0x5d, 440 => 0x846, 445 => [0x125,0x14a], 461 => 0x32, 462 => 0x3a, 463 => 0x3a, 464 => 0xa },
	'shuttercount2' => { 461 => 0x4c, 462 => [0x50,0x52,0x58], 463 => 0x50 },
	'shuttercount3' => { 461 => [0x1a0,0x1aa,0x1bd], 462 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 84 => 0xf, 85 => 0xf, 86 => 0x305, 87 => 0xe, 88 => 0xf, 89 => 0x8, 90 => 0x8, 91 => 0xf, 92 => 0x8 },
	'shuttermode' => { 58 => 0x17, 142 => 0x1b, 236 => 0x34 },
	'shutterreleasebuttonae-l' => { 299 => '17.7', 300 => '18.4', 302 => '78.4', 303 => '78.4', 304 => '16.1', 305 => '17.1', 306 => '17.1', 307 => '17.1', 308 => '7.1', 309 => '17.5', 312 => '18.4', 313 => '78.4', 314 => '18.2', 315 => 0x29, 316 => 0x29, 317 => 0x29 },
	'shutterreleasemethod' => { 99 => 0x1010 },
	'shutterreleasenocfcard' => { 84 => 0x2, 85 => 0x2, 92 => 0xf },
	'shutterreleasetiming' => { 99 => 0x1011 },
	'shutterreleasewithoutlens' => { 86 => 0x711 },
	'shutterspeedlock' => { 300 => '38.1', 302 => '38.1', 303 => '38.1', 312 => '38.1', 313 => '38.1', 315 => 0xb7, 316 => 0xb7, 317 => 0xb7 },
	'shutterspeedrange' => { 86 => 0x10c },
	'shutterspeedsetting' => { 186 => 0x6, 429 => 0x2f, 430 => 0x28, 431 => 0x0 },
	'shutterspeedvalue' => { 95 => 0x1, 121 => 0x9201, 324 => 0x1000, 386 => 0x400, 508 => 'ShutterSpeedValue' },
	'shuttertype' => { 129 => 0x1050, 342 => 0x9f, 377 => 0x87, 467 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 519 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 140 => 0xe0d },
	'sigmascalingfactorcamera' => { 140 => 0xe0c },
	'sigmascalingfactorlowres' => { 140 => 0xe0b },
	'sigmasizetable' => { 140 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 236 => 0xbf },
	'similarityindex' => { 133 => 0xe4 },
	'singleframebracketing' => { 186 => 0x21 },
	'skilllevel' => { 523 => 'skillLevel' },
	'skintonecorrection' => { 377 => 0x95 },
	'skiplinetime' => { 140 => 0x184e },
	'slaveflashmeteringsegments' => { 377 => 0x20b },
	'slideshowname' => { 520 => 'slideshowName' },
	'slideshownumber' => { 520 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 520 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 241 => 0x24a, 244 => 0x24a },
	'slowshutter' => { 78 => 0x8 },
	'slowsync' => { 129 => 0x1030 },
	'smartalbumcolor' => { 416 => 0x20 },
	'smartrange' => { 416 => 0xa012 },
	'smileshutter' => { 431 => 0x31 },
	'smileshuttermode' => { 431 => 0x27 },
	'smoothness' => { 121 => 0xfe57, 502 => 'Smoothness', 504 => 'Smoothness' },
	'snapshot' => { 516 => 'SnapshotLink' },
	'snapshotformat' => { 516 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 516 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 516 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 516 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 516 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 497 => 'Snapshots' },
	'snapshotusedvideoframe' => { 516 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 516 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 516 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 516 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 516 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 442 => 0x200f },
	'software' => { 121 => 0x131, 159 => 'Software', 332 => 'Software', 386 => 0x203, 396 => 'software', 419 => 0x18, 487 => 'Software', 527 => 'Software' },
	'softwareversion' => { 402 => ['@swr',"\xa9swr"], 418 => 0x207 },
	'soloist' => { 394 => "\xa9sol" },
	'songwriter' => { 402 => "\xa9swf" },
	'songwriterkeywords' => { 402 => "\xa9swk" },
	'sonycropsize' => { 121 => 0x74c8 },
	'sonycroptopleft' => { 121 => 0x74c7 },
	'sonydatetime' => { 450 => 0x6, 452 => 0x1b6, 453 => 0x210, 454 => 0x1fe, 455 => 0x22c },
	'sonydatetime2' => { 461 => 0x51 },
	'sonyexposuretime' => { 461 => 0x3a, 462 => 0x46, 463 => [0x66,0x46], 464 => 0x1a },
	'sonyexposuretime2' => { 474 => 0xe },
	'sonyfnumber' => { 461 => 0x3c, 462 => 0x48, 463 => [0x68,0x48], 464 => 0x1c, 474 => 0x14 },
	'sonyimageheight' => { 450 => 0x1a, 465 => 0x44, 466 => 0x3f, 467 => 0x47 },
	'sonyimageheightmax' => { 474 => 0x40 },
	'sonyimagesize' => { 186 => 0x3b, 429 => 0x54, 430 => 0x54, 431 => 0x9 },
	'sonyimagewidth' => { 450 => 0x1c },
	'sonyimagewidthmax' => { 474 => 0x3e },
	'sonyiso' => { 452 => 0x1218, 453 => 0x11f4, 454 => 0x1270, 455 => [0x1254,0x1258,0x1280], 456 => 0x113c, 457 => 0x344, 458 => 0x346, 459 => 0x320, 474 => 0x4 },
	'sonymaxaperture' => { 461 => 0x0, 462 => 0x0 },
	'sonymaxaperturevalue' => { 474 => 0x16 },
	'sonyminaperture' => { 461 => 0x1, 462 => 0x1 },
	'sonymodelid' => { 442 => 0xb001 },
	'sonyquality' => { 186 => 0x3c },
	'sonyrawimagesize' => { 121 => 0x7038 },
	'sonytimeminsec' => { 462 => 0x61 },
	'sortalbum' => { 394 => 'soal' },
	'sortalbumartist' => { 394 => 'soaa' },
	'sortartist' => { 394 => 'soar' },
	'sortcomposer' => { 394 => 'soco' },
	'sortname' => { 394 => 'sonm', 502 => 'SortName', 504 => 'SortName' },
	'sortshow' => { 394 => 'sosn' },
	'soundengineer' => { 394 => "\xa9sne" },
	'source' => { 133 => 0x73, 332 => 'Source', 505 => 'source', 506 => 'source', 519 => 'Source' },
	'sourcecount' => { 491 => 'SourceCount' },
	'sourcecredits' => { 402 => "\xa9src" },
	'sourcedirectoryindex' => { 364 => 0x0 },
	'sourcefileindex' => { 364 => 0x2 },
	'sourcephotoscount' => { 490 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 140 => 0x1390 },
	'spatialfrequencyresponse' => { 508 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 508 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 508 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 508 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 508 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 531 => 'speakerPlacement' },
	'specialeffectlevel' => { 115 => 0x3030 },
	'specialeffectmode' => { 115 => 0x2076 },
	'specialeffectsetting' => { 115 => 0x3031 },
	'specialinstructions' => { 133 => 0x28 },
	'specialmode' => { 324 => 0x200, 418 => 0x200 },
	'specialoccasion' => { 523 => 'specialOccasion' },
	'specialtypeid' => { 485 => 'SpecialTypeID' },
	'spectralsensitivity' => { 121 => 0x8824, 508 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => 0x32b, 43 => 0x281, 46 => [0x2b9,0x2d0,0x2d4], 47 => 0x56a, 48 => 0x1e4, 49 => [0x1fd,0x2dd], 50 => [0x231,0x30f], 51 => 0x31d },
	'speedx' => { 117 => 0x3, 402 => "\xa9xsp" },
	'speedy' => { 117 => 0x4, 402 => "\xa9ysp" },
	'speedz' => { 117 => 0x5, 402 => "\xa9zsp" },
	'spherical' => { 491 => 'Spherical' },
	'sphericalvideoxml' => { 122 => 'SphericalVideoXML' },
	'splitcolumn' => { 386 => 0x222 },
	'splittoningbalance' => { 502 => 'SplitToningBalance', 504 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 502 => 'SplitToningHighlightHue', 504 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 502 => 'SplitToningHighlightSaturation', 504 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 502 => 'SplitToningShadowHue', 504 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 502 => 'SplitToningShadowSaturation', 504 => 'SplitToningShadowSaturation' },
	'sport' => { 521 => 'sport' },
	'spotfocuspointx' => { 183 => 0x2d },
	'spotfocuspointy' => { 183 => 0x2e },
	'spotmeteringmode' => { 35 => 0x27 },
	'spotmeterlinktoafpoint' => { 86 => 0x107 },
	'sractive' => { 358 => '17.1' },
	'srawquality' => { 35 => 0x2e },
	'srfocallength' => { 379 => 0x3 },
	'srgbrendering' => { 330 => 'sRGB' },
	'srhalfpresstime' => { 379 => 0x2 },
	'srresult' => { 379 => 0x0, 380 => 0x0 },
	'stackedimage' => { 319 => 0x804 },
	'standardmatrixcustom' => { 140 => 0x7d4 },
	'standardmatrixdaylight' => { 140 => 0x7d0 },
	'standardmatrixflash' => { 140 => 0x7d3 },
	'standardmatrixfluorescent' => { 140 => 0x7d2 },
	'standardmatrixtungsten' => { 140 => 0x7d1 },
	'standardoutputhighlightpoint' => { 111 => 0x14 },
	'standardoutputsensitivity' => { 121 => 0x8831, 509 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 111 => 0x15 },
	'standardrawcolortone' => { 111 => 0xd },
	'standardrawcontrast' => { 111 => 0xf },
	'standardrawhighlight' => { 111 => 0x75 },
	'standardrawhighlightpoint' => { 111 => 0x12 },
	'standardrawlinear' => { 111 => 0x10 },
	'standardrawsaturation' => { 111 => 0xe },
	'standardrawshadow' => { 111 => 0x7e },
	'standardrawshadowpoint' => { 111 => 0x13 },
	'standardrawsharpness' => { 111 => 0x11 },
	'standardunsharpmaskfineness' => { 111 => 0x94 },
	'standardunsharpmaskstrength' => { 111 => 0x92 },
	'standardunsharpmaskthreshold' => { 111 => 0x96 },
	'standardwhitecustom' => { 140 => 0x838 },
	'standardwhitedaylight' => { 140 => 0x834 },
	'standardwhiteflash' => { 140 => 0x837 },
	'standardwhitefluorescent' => { 140 => 0x836 },
	'standardwhitetungsten' => { 140 => 0x835 },
	'standbytimer' => { 300 => '19.1', 302 => '19.1', 303 => '19.1', 306 => '18.1', 307 => '18.1', 312 => '19.1', 313 => '19.1' },
	'starlightview' => { 315 => 0x249, 316 => 0x249, 317 => 0x261 },
	'startingpage' => { 521 => 'startingPage' },
	'startmovieshooting' => { 86 => 0x70d },
	'starttimecode' => { 402 => "\xa9TIM", 531 => 'startTimecode' },
	'starttimecodetimeformat' => { 531 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 531 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 531 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 402 => "\xa9TSZ", 531 => 'startTimeSampleSize' },
	'starttimescale' => { 402 => "\xa9TSC", 531 => 'startTimeScale' },
	'state' => { 163 => 'State', 342 => 0x6b, 519 => 'State' },
	'status' => { 483 => 'Status', 495 => 'Status' },
	'stereomode' => { 491 => 'StereoMode' },
	'stitched' => { 491 => 'Stitched' },
	'stitchingsoftware' => { 490 => 'StitchingSoftware', 491 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 451 => 0x113e, 452 => 0x113e, 453 => 0x111a, 454 => 0x1196, 455 => 0x1172, 456 => 0x102a, 457 => 0x222, 458 => 0x222, 459 => 0x217, 474 => 0xa },
	'storagemethod' => { 190 => 0x12 },
	'storebyorientation' => { 300 => '46.3', 302 => '47.3', 303 => '47.3', 312 => '47.3', 313 => '47.3', 315 => 0xd, 316 => 0xd, 317 => 0xd },
	'storedescription' => { 394 => 'sdes' },
	'storylineidentifier' => { 516 => 'StorylineIdentifier' },
	'straightenangle' => { 292 => 0x2fc08431 },
	'streamready' => { 516 => 'StreamReady' },
	'streamtype' => { 178 => 'StreamType' },
	'stretchmode' => { 531 => 'stretchMode' },
	'studydatetime' => { 480 => 'StudyDateTime' },
	'studydescription' => { 480 => 'StudyDescription' },
	'studyid' => { 480 => 'StudyID' },
	'studyphysician' => { 480 => 'StudyPhysician' },
	'styleperiod' => { 516 => 'StylePeriod' },
	'sub-location' => { 133 => 0x5c },
	'subcommanddialplaybackmode' => { 315 => 0x1cf, 316 => 0x1cf, 317 => 0x1e7 },
	'subfiledata' => { 166 => 'data' },
	'subfiledirectory' => { 166 => '1Directory' },
	'subfilemimetype' => { 166 => '2MIME' },
	'subfilename' => { 166 => '1Name' },
	'subfileresource' => { 166 => 'rsrc' },
	'subfiletype' => { 121 => 0xfe, 166 => '0Type' },
	'subject' => { 328 => 'Subject', 393 => 'Subject', 505 => 'subject', 518 => 'Subject', 532 => 'subject' },
	'subjectarea' => { 121 => 0x9214, 508 => 'SubjectArea' },
	'subjectcode' => { 515 => 'SubjectCode' },
	'subjectdetection' => { 241 => 0x252, 242 => 0x23e, 243 => 0x252, 244 => 0x252 },
	'subjectdistance' => { 121 => 0x9206, 142 => 0x3e, 508 => 'SubjectDistance' },
	'subjectdistancerange' => { 121 => 0xa40c, 508 => 'SubjectDistanceRange' },
	'subjectlocation' => { 121 => 0xa214, 508 => 'SubjectLocation' },
	'subjectmotion' => { 302 => '78.2', 303 => '78.2', 313 => '78.2', 315 => 0x103, 316 => 0x103, 317 => 0x119 },
	'subjectprogram' => { 183 => 0x22 },
	'subjectreference' => { 133 => 0xc },
	'sublabels1' => { 514 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 514 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 116 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 116 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 116 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 121 => 0x9290 },
	'subsectimedigitized' => { 121 => 0x9292 },
	'subsectimeoriginal' => { 121 => 0x9291 },
	'subsection1' => { 521 => 'subsection1' },
	'subsection2' => { 521 => 'subsection2' },
	'subsection3' => { 521 => 'subsection3' },
	'subsection4' => { 521 => 'subsection4' },
	'subselector' => { 300 => '49.1', 302 => '71.1', 303 => '71.1', 313 => '71.1', 315 => 0x8f, 316 => 0x8f, 317 => 0x8f },
	'subselectorassignment' => { 300 => '48.1' },
	'subselectorcenter' => { 302 => '72.1', 303 => '72.1', 313 => '72.1' },
	'subselectorplusdials' => { 300 => '49.2', 302 => '73.1', 303 => '73.1', 313 => '73.1' },
	'subtitle' => { 181 => 'WM/SubTitle', 394 => "\xa9st3", 402 => "\xa9snm", 521 => 'subtitle' },
	'subtitlekeywords' => { 402 => "\xa9snk" },
	'subversionfilename' => { 514 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 514 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 514 => 'SubVersions' },
	'superimposeddisplay' => { 84 => 0xa, 86 => 0x510, 87 => 0x9, 88 => 0xa, 91 => 0xa, 92 => 0xe },
	'supermacro' => { 65 => 0x1a },
	'supplementalcategories' => { 133 => 0x14, 519 => 'SupplementalCategories' },
	'supplementaltype' => { 135 => 0x37 },
	'supplementdisplayid' => { 521 => 'supplementDisplayID' },
	'supplementstartingpage' => { 521 => 'supplementStartingPage' },
	'supplementtitle' => { 521 => 'supplementTitle' },
	'supplychainsource' => { 516 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 516 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 516 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 502 => 'SupportsAmount', 504 => 'SupportsAmount' },
	'supportscolor' => { 502 => 'SupportsColor', 504 => 'SupportsColor' },
	'supportshighdynamicrange' => { 502 => 'SupportsHighDynamicRange', 504 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 502 => 'SupportsMonochrome', 504 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 502 => 'SupportsNormalDynamicRange', 504 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 502 => 'SupportsOutputReferred', 504 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 502 => 'SupportsSceneReferred', 504 => 'SupportsSceneReferred' },
	'svisosetting' => { 358 => 0x14 },
	'swatchcoloranta' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 536 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 536 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 536 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 536 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 536 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 342 => 0x93, 431 => 0x33 },
	'sweeppanoramafieldofview' => { 342 => 0x94 },
	'sweeppanoramasize' => { 431 => 0x32 },
	'switchtoregisteredafpoint' => { 85 => 0x12, 86 => 0x50a },
	'symlink' => { 122 => 'SymLink' },
	'syncreleasemode' => { 302 => '77.1', 303 => '77.1', 313 => '77.1', 315 => 0x41, 316 => 0x41, 317 => 0x41 },
	'system' => { 386 => 0x204 },
	'tagged' => { 388 => 0xdd, 389 => 'Tagged', 497 => 'tagged' },
	'tagslist' => { 507 => 'TagsList' },
	'tagstructure' => { 514 => 'TagStructure' },
	'takenumber' => { 531 => 'takeNumber' },
	'tapename' => { 531 => 'tapeName' },
	'targetaperture' => { 78 => 0x4 },
	'targetcompressionratio' => { 97 => 0x1 },
	'targetdistancesetting' => { 99 => 0x1807 },
	'targetexposuretime' => { 78 => 0x5 },
	'targetimagetype' => { 99 => 0x100a },
	'targetprinter' => { 121 => 0x151 },
	'taxon' => { 120 => 'Taxon' },
	'taxonacceptednameusage' => { 120 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 120 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 120 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 120 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 120 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 120 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 120 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 120 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 120 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 120 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 120 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 120 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 120 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 120 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 120 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 120 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 120 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 120 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 120 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 120 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 120 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 120 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 120 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 120 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 120 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 120 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 120 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 120 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 120 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 120 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 120 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 120 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 120 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 120 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 140 => 0x196f },
	'tda1edgepolarity' => { 140 => 0x1971 },
	'tda1gain' => { 140 => 0x1970 },
	'tda1offset' => { 140 => 0x196e },
	'tda2bandwidth' => { 140 => 0x1979 },
	'tda2edgepolarity' => { 140 => 0x197b },
	'tda2gain' => { 140 => 0x197a },
	'tda2offset' => { 140 => 0x1978 },
	'tda3bandwidth' => { 140 => 0x1983 },
	'tda3edgepolarity' => { 140 => 0x1985 },
	'tda3gain' => { 140 => 0x1984 },
	'tda3offset' => { 140 => 0x1982 },
	'tda4bandwidth' => { 140 => 0x198d },
	'tda4edgepolarity' => { 140 => 0x198f },
	'tda4gain' => { 140 => 0x198e },
	'tda4offset' => { 140 => 0x198c },
	'teaser' => { 521 => 'teaser' },
	'teleconverter' => { 188 => 0x105, 442 => 0x105 },
	'tempampgainx100' => { 140 => 0x1914 },
	'tempo' => { 531 => 'tempo' },
	'temporalcoverage' => { 516 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 516 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 516 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 329 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 329 => 'TermsAndConditionsURL' },
	'testname' => { 122 => 'TestName' },
	'textencoding' => { 235 => 0x4 },
	'textlayername' => { 519 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 519 => 'TextLayers' },
	'textlayertext' => { 519 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 342 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 502 => 'Texture', 504 => 'Texture' },
	'three-dtrackingfacedetection' => { 302 => '1.4', 303 => '1.4', 313 => '1.4' },
	'three-dtrackingwatcharea' => { 302 => '78.1', 303 => '78.1', 313 => '78.1' },
	'thresholding' => { 121 => 0x107 },
	'thumbnailfilename' => { 99 => 0x817 },
	'thumbnailformat' => { 529 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 144 => 0xfa55, 529 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 99 => 0x2008, 116 => 'Exif-ThumbnailImage', 124 => 0x3, 169 => 'data', 324 => 0x100, 402 => 'thmb', 529 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 169 => '1Name' },
	'thumbnailimagesize' => { 169 => 'ImageSize' },
	'thumbnailimagetype' => { 169 => '0Type' },
	'thumbnailimagevalidarea' => { 65 => 0x13 },
	'thumbnaillength' => { 121 => 0x202 },
	'thumbnailoffset' => { 121 => 0x201 },
	'thumbnailpng' => { 402 => 'thmb' },
	'thumbnails' => { 529 => 'Thumbnails' },
	'thumbnailwidth' => { 144 => 0xfa54, 529 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 521 => 'ticker' },
	'tiffhandling' => { 502 => 'TIFFHandling', 504 => 'TIFFHandling' },
	'tiffmeteringimage' => { 189 => 0x104c, 440 => 0x1110 },
	'tilelength' => { 121 => 0x143 },
	'tilewidth' => { 121 => 0x142 },
	'time' => { 140 => 0x401, 377 => 0x7 },
	'timecodes' => { 121 => 0xc763 },
	'timecreated' => { 133 => 0x3c, 142 => 0x14, 151 => 0x10, 389 => 'TimeCreated' },
	'timelapseshotnumber' => { 345 => 0x10 },
	'timeperiod' => { 521 => 'timePeriod' },
	'timerfunctionbutton' => { 301 => '5.2', 304 => '12.1', 305 => '13.1' },
	'timerlength' => { 86 => 0x80c },
	'timerrecording' => { 342 => 0x96 },
	'timescaleparams' => { 531 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 531 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 531 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 531 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 134 => 0x50 },
	'timeshot' => { 492 => 'TimeShot' },
	'timesignature' => { 531 => 'timeSignature' },
	'timesincepoweron' => { 342 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 318 => 0x8, 332 => 'TimeStamp', 342 => 0xaf, 491 => 'Timestamp', 498 => 'Timestamp', 514 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 79 => 0x1, 241 => 0x694, 242 => 0x594, 243 => 0x5c4, 244 => 0x5dc, 284 => 0x0, 412 => 0xa },
	'timezonecity' => { 79 => 0x2 },
	'timezonecode' => { 102 => 0x1 },
	'timezoneinfo' => { 102 => 0x2 },
	'timezoneoffset' => { 121 => 0x882a },
	'tint' => { 396 => 'player.movie.visual.tint', 502 => 'Tint', 504 => 'Tint' },
	'title' => { 121 => 0xa436, 159 => 'Title', 328 => 'Title', 332 => 'Title', 342 => 0x65, 393 => 'Title', 394 => ['titl',"\xa9nam"], 396 => 'title', 402 => ['titl',"\xa9nam"], 505 => 'title', 518 => 'Title', 529 => 'Title' },
	'togglestyleamount' => { 502 => 'ToggleStyleAmount', 504 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 502 => 'ToggleStyleDigest', 504 => 'ToggleStyleDigest' },
	'tonecomp' => { 236 => 0x81 },
	'tonecurve' => { 75 => 0x1, 377 => 0x402, 502 => 'ToneCurve', 504 => 'ToneCurve' },
	'tonecurveactive' => { 110 => 0x110 },
	'tonecurveadobergb' => { 416 => 0xa043 },
	'tonecurveadobergbdefault' => { 416 => 0xa041 },
	'tonecurveblue' => { 502 => 'ToneCurveBlue', 504 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 478 => 0x9003 },
	'tonecurvebluey' => { 478 => 0x9007 },
	'tonecurvebrightness' => { 105 => 0x20410 },
	'tonecurvebrightnessx' => { 478 => 0x9000 },
	'tonecurvebrightnessy' => { 478 => 0x9004 },
	'tonecurvecolorspace' => { 109 => 0x0 },
	'tonecurvecontrast' => { 105 => 0x20411 },
	'tonecurvegreen' => { 502 => 'ToneCurveGreen', 504 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 478 => 0x9002 },
	'tonecurvegreeny' => { 478 => 0x9006 },
	'tonecurveinputrange' => { 109 => 0x3 },
	'tonecurveinterpolation' => { 110 => 0x159 },
	'tonecurvemode' => { 110 => 0x113 },
	'tonecurvename' => { 502 => 'ToneCurveName', 504 => 'ToneCurveName' },
	'tonecurvename2012' => { 502 => 'ToneCurveName2012', 504 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 105 => '0x20400.1' },
	'tonecurveoutputrange' => { 109 => 0x5 },
	'tonecurveprofilename' => { 140 => 0x1391 },
	'tonecurveproperty' => { 110 => 0x3c },
	'tonecurvepv2012' => { 502 => 'ToneCurvePV2012', 504 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 502 => 'ToneCurvePV2012Blue', 504 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 502 => 'ToneCurvePV2012Green', 504 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 502 => 'ToneCurvePV2012Red', 504 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 502 => 'ToneCurveRed', 504 => 'ToneCurveRed' },
	'tonecurveredx' => { 478 => 0x9001 },
	'tonecurveredy' => { 478 => 0x9005 },
	'tonecurves' => { 377 => 0x403 },
	'tonecurveshape' => { 109 => 0x1 },
	'tonecurvesrgb' => { 416 => 0xa042 },
	'tonecurvesrgbdefault' => { 416 => 0xa040 },
	'tonecurvex' => { 109 => 0xa },
	'tonecurvey' => { 109 => 0xb },
	'tonelevel' => { 319 => 0x52e },
	'tonemap' => { 241 => 0x26a },
	'tonemapstrength' => { 502 => 'ToneMapStrength', 504 => 'ToneMapStrength' },
	'toningeffect' => { 58 => 0xf, 236 => 0xb3, 251 => 0x38, 252 => 0x40, 253 => 0x48, 409 => 0x1015 },
	'toningeffectauto' => { 72 => 0xa4 },
	'toningeffectfaithful' => { 71 => 0x74, 72 => 0x74 },
	'toningeffectlandscape' => { 71 => 0x44, 72 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 71 => 0x8c, 72 => 0x8c },
	'toningeffectneutral' => { 71 => 0x5c, 72 => 0x5c },
	'toningeffectportrait' => { 71 => 0x2c, 72 => 0x2c },
	'toningeffectstandard' => { 71 => 0x14, 72 => 0x14 },
	'toningeffectuserdef1' => { 71 => 0xa4, 72 => 0xbc },
	'toningeffectuserdef2' => { 71 => 0xbc, 72 => 0xd4 },
	'toningeffectuserdef3' => { 71 => 0xd4, 72 => 0xec },
	'toningsaturation' => { 251 => 0x39, 252 => 0x41, 253 => 0x49 },
	'totalzoom' => { 142 => 0x62 },
	'touchae' => { 342 => 0xab },
	'track' => { 394 => "\xa9trk", 402 => "\xa9trk" },
	'trackcreatedate' => { 401 => 0x1 },
	'trackmodifydate' => { 401 => 0x2 },
	'tracknumber' => { 394 => 'trkn', 531 => 'trackNumber' },
	'tracks' => { 531 => 'Tracks' },
	'tracksframerate' => { 531 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 531 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 531 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 531 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 531 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 531 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 531 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 531 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 531 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 531 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 531 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 531 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 531 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 531 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 531 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 531 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 531 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 402 => 'kgtt' },
	'trailer' => { 122 => 'Trailer' },
	'trailersignature' => { 166 => 'zmie' },
	'transcript' => { 516 => 'Transcript' },
	'transcriptlink' => { 516 => 'TranscriptLink' },
	'transcriptlinklink' => { 516 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 516 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 121 => 0x12d, 527 => 'TransferFunction' },
	'transfertimenormal' => { 140 => 0x1888 },
	'transfertimetest' => { 140 => 0x1889 },
	'transform' => { 342 => [0x8012,0x59] },
	'transformation' => { 517 => 'Transformation' },
	'transmissionreference' => { 519 => 'TransmissionReference' },
	'trapped' => { 328 => 'Trapped', 518 => 'Trapped' },
	'trashbuttonfunction' => { 86 => 0x710 },
	'travelday' => { 342 => 0x36 },
	'treble' => { 396 => 'player.movie.audio.treble' },
	'triggermode' => { 403 => 0x6, 404 => 0x34, 405 => 0x34 },
	'tstop' => { 121 => 0xc772 },
	'ttl_da_adown' => { 365 => 0x5 },
	'ttl_da_aup' => { 365 => 0x4 },
	'ttl_da_bdown' => { 365 => 0x7 },
	'ttl_da_bup' => { 365 => 0x6 },
	'tungstenawb' => { 355 => 0x1 },
	'tvepisode' => { 394 => 'tves' },
	'tvepisodeid' => { 394 => 'tven' },
	'tvexposuretimesetting' => { 358 => 0x12 },
	'tvnetworkname' => { 394 => 'tvnn' },
	'tvseason' => { 394 => 'tvsn' },
	'tvshow' => { 394 => 'tvsh' },
	'type' => { 486 => 'Type', 505 => 'type', 526 => 'type' },
	'typestatus' => { 120 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 121 => 0xc614 },
	'uniquedocumentid' => { 133 => 0xbb },
	'uniquematrixauto' => { 140 => 0x7e9 },
	'uniquematrixcustom' => { 140 => 0x7e8 },
	'uniquematrixdaylight' => { 140 => 0x7e4 },
	'uniquematrixflash' => { 140 => 0x7e7 },
	'uniquematrixfluorescent' => { 140 => 0x7e6 },
	'uniquematrixtungsten' => { 140 => 0x7e5 },
	'uniqueobjectname' => { 134 => 0x64 },
	'units' => { 487 => 'Units' },
	'unknown_aacr' => { 394 => 'AACR' },
	'unknown_cdek' => { 394 => 'CDEK' },
	'unknown_cdet' => { 394 => 'CDET' },
	'unknownblock' => { 377 => 0x405 },
	'unknownblock1' => { 323 => 0x635 },
	'unknownblock2' => { 323 => 0x636 },
	'unknownblock3' => { 323 => 0x1103 },
	'unknownblock4' => { 323 => 0x1104 },
	'unknowncontrast' => { 111 => 0x45 },
	'unknowndate' => { 386 => 0x212 },
	'unknownev' => { 140 => 0x1 },
	'unknownlinear' => { 111 => 0x46 },
	'unknownnumber' => { 99 => 0x180b },
	'unknownoutputhighlightpoint' => { 111 => 0x4a },
	'unknownoutputshadowpoint' => { 111 => 0x4b },
	'unknownrawhighlight' => { 111 => 0x7b },
	'unknownrawhighlightpoint' => { 111 => 0x48 },
	'unknownrawshadow' => { 111 => 0x84 },
	'unknownrawshadowpoint' => { 111 => 0x49 },
	'unknownsharpness' => { 111 => 0x47 },
	'unknowntags' => { 402 => 'TAGS' },
	'unknowntemperature' => { 123 => 0x4 },
	'unknownthumbnail' => { 402 => 'thmb' },
	'unsharp1color' => { 297 => 0x13 },
	'unsharp1halowidth' => { 297 => 0x19 },
	'unsharp1intensity' => { 297 => 0x17 },
	'unsharp1threshold' => { 297 => 0x1b },
	'unsharp2color' => { 297 => 0x2e },
	'unsharp2halowidth' => { 297 => 0x34 },
	'unsharp2intensity' => { 297 => 0x32 },
	'unsharp2threshold' => { 297 => 0x36 },
	'unsharp3color' => { 297 => 0x49 },
	'unsharp3halowidth' => { 297 => 0x4f },
	'unsharp3intensity' => { 297 => 0x4d },
	'unsharp3threshold' => { 297 => 0x51 },
	'unsharp4color' => { 297 => 0x64 },
	'unsharp4halowidth' => { 297 => 0x6a },
	'unsharp4intensity' => { 297 => 0x68 },
	'unsharp4threshold' => { 297 => 0x6c },
	'unsharpcount' => { 297 => 0x0 },
	'unsharpmask' => { 111 => 0x90, 292 => 0x76a43200 },
	'unsharpmaskfineness' => { 105 => 0x20309 },
	'unsharpmaskstrength' => { 105 => 0x20308 },
	'unsharpmaskthreshold' => { 105 => 0x2030a },
	'uprightcentermode' => { 502 => 'UprightCenterMode', 504 => 'UprightCenterMode' },
	'uprightcenternormx' => { 502 => 'UprightCenterNormX', 504 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 502 => 'UprightCenterNormY', 504 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 502 => 'UprightDependentDigest', 504 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 502 => 'UprightFocalLength35mm', 504 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 502 => 'UprightFocalMode', 504 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 502 => 'UprightFourSegments_0', 504 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 502 => 'UprightFourSegments_1', 504 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 502 => 'UprightFourSegments_2', 504 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 502 => 'UprightFourSegments_3', 504 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 502 => 'UprightFourSegmentsCount', 504 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 502 => 'UprightGuidedDependentDigest', 504 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 502 => 'UprightPreview', 504 => 'UprightPreview' },
	'uprighttransform_0' => { 502 => 'UprightTransform_0', 504 => 'UprightTransform_0' },
	'uprighttransform_1' => { 502 => 'UprightTransform_1', 504 => 'UprightTransform_1' },
	'uprighttransform_2' => { 502 => 'UprightTransform_2', 504 => 'UprightTransform_2' },
	'uprighttransform_3' => { 502 => 'UprightTransform_3', 504 => 'UprightTransform_3' },
	'uprighttransform_4' => { 502 => 'UprightTransform_4', 504 => 'UprightTransform_4' },
	'uprighttransform_5' => { 502 => 'UprightTransform_5', 504 => 'UprightTransform_5' },
	'uprighttransformcount' => { 502 => 'UprightTransformCount', 504 => 'UprightTransformCount' },
	'uprightversion' => { 502 => 'UprightVersion', 504 => 'UprightVersion' },
	'urgency' => { 133 => 0xa, 519 => 'Urgency' },
	'url' => { 159 => 'URL', 332 => 'URL', 391 => 0x40b, 521 => 'url' },
	'url_list' => { 391 => 0x41e },
	'urla-platform' => { 521 => [\'url','urlA-platform'] },
	'urlurl' => { 521 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 86 => 0x10a },
	'usableshootingmodes' => { 86 => 0x109 },
	'usage' => { 522 => 'usage' },
	'usageterms' => { 535 => 'UsageTerms' },
	'usbpowerdelivery' => { 241 => 0x762, 242 => 0x664, 243 => 0x694, 244 => 0x6fc },
	'usedialwithouthold' => { 315 => 0xbf, 316 => 0xbf, 317 => 0xbf },
	'useguidelines' => { 500 => 'useGuidelines' },
	'usepanoramaviewer' => { 490 => 'UsePanoramaViewer' },
	'usercollection' => { 396 => 'collection.user' },
	'usercomment' => { 99 => 0x805, 121 => 0x9286, 508 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 71 => 0xd8, 72 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 71 => 0xda, 72 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 71 => 0xdc, 72 => 0xf4 },
	'userfields' => { 495 => 'UserFields' },
	'userlabel' => { 403 => 0x2b, 404 => 0x5a, 405 => 0x68 },
	'userprofile' => { 337 => 0x302, 341 => 0x34c, 344 => 0x3038 },
	'userrating' => { 396 => 'rating.user', 402 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 85 => 0x7, 86 => 0x501 },
	'uspsnumber' => { 521 => 'uspsNumber' },
	'utmeasting' => { 170 => 'Easting' },
	'utmmapdatum' => { 170 => 'Datum' },
	'utmnorthing' => { 170 => 'Northing' },
	'utmzone' => { 170 => 'Zone' },
	'uuid' => { 502 => 'UUID', 504 => 'UUID' },
	'uv-irfiltercorrection' => { 337 => 0x325 },
	'validbits' => { 323 => 0x611, 324 => 0x102c },
	'validpixeldepth' => { 327 => 0x611 },
	'variablelowpassfilter' => { 442 => 0x2028 },
	'variousmodes' => { 142 => 0x26 },
	'variousmodes2' => { 142 => 0x3a },
	'variprogram' => { 236 => 0xab },
	'varraydacnominalvalues' => { 140 => 0x191e },
	'vendor' => { 402 => 'vndr' },
	'vendorinfo' => { 481 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 481 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 481 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 481 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 120 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 129 => 0x0, 393 => 'Version', 396 => 'version', 502 => 'Version', 504 => 'Version', 513 => 'Version' },
	'versioncreatedate' => { 478 => 0xd100 },
	'versionid' => { 532 => 'VersionID' },
	'versionidentifier' => { 521 => 'versionIdentifier' },
	'versionmodifydate' => { 478 => 0xd101 },
	'versions' => { 532 => 'Versions' },
	'versionscomments' => { 532 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 532 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 532 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 532 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 532 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 532 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 532 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 532 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 532 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 532 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 532 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 299 => '3.2', 300 => '47.2', 302 => '79.1', 316 => 0x11d, 317 => 0x135 },
	'verticalclockoverlaps' => { 140 => 0x412 },
	'verticalfuncbutton' => { 300 => '42.2', 302 => '67.1', 316 => 0x115, 317 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 316 => 0x1b7, 317 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 300 => '43.1' },
	'verticalfuncplusdials' => { 302 => '68.1' },
	'verticalisobutton' => { 244 => 0x792 },
	'verticalmovieafonbutton' => { 316 => 0x1f9, 317 => 0x211 },
	'verticalmoviefuncbutton' => { 316 => 0x1e1, 317 => 0x1f9 },
	'verticalmultiselector' => { 300 => '42.1', 302 => '66.1', 303 => '66.1', 313 => '66.1', 316 => 0x18f, 317 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 316 => 0x125, 317 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 86 => [0x510,0x51d] },
	'vibrance' => { 496 => 'Vibrance', 502 => 'Vibrance', 504 => 'Vibrance' },
	'vibrationreduction' => { 264 => [0x75,0x82,0x1ae], 272 => '586.1', 279 => '590.2', 283 => 0x4 },
	'videoalphamode' => { 531 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 531 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 531 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 531 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 516 => 'videoBitRate' },
	'videobitratemode' => { 516 => 'videoBitRateMode' },
	'videoburstmode' => { 342 => 0xbb },
	'videoburstresolution' => { 342 => 0xb3 },
	'videocodec' => { 68 => 0x74 },
	'videocolorspace' => { 531 => 'videoColorSpace' },
	'videocompression' => { 129 => 0x3806 },
	'videocompressor' => { 531 => 'videoCompressor' },
	'videodisplayaspectratio' => { 516 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 516 => 'videoEncodingProfile' },
	'videofieldorder' => { 531 => 'videoFieldOrder' },
	'videoframerate' => { 342 => 0x27, 531 => 'videoFrameRate' },
	'videoframesize' => { 531 => 'videoFrameSize' },
	'videoframesizeh' => { 531 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 531 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 531 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 531 => 'videoModDate' },
	'videopixelaspectratio' => { 531 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 531 => 'videoPixelDepth' },
	'videopreburst' => { 342 => 0xc1 },
	'videoquality' => { 115 => 0x4003 },
	'videorecordingmode' => { 129 => 0x3803 },
	'videoshottype' => { 516 => 'VideoShotType' },
	'videoshottypeidentifier' => { 516 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 516 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 516 => 'videoStreamsCount' },
	'viewfinder' => { 386 => 0x455 },
	'viewfinderdisplay' => { 299 => '12.4', 300 => '6.3' },
	'viewfinderwarning' => { 299 => '13.4', 309 => '3.5', 310 => '6.2', 314 => '4.4' },
	'viewfinderwarnings' => { 86 => 0x40a },
	'viewinfoduringexposure' => { 86 => 0x407 },
	'viewingmode' => { 431 => 0x2f, 447 => 0x18 },
	'viewingmode2' => { 431 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 244 => 0x7d2, 315 => 0x2a9 },
	'viewpoint' => { 520 => 'viewpoint' },
	'vignetteamount' => { 502 => 'VignetteAmount', 504 => 'VignetteAmount' },
	'vignettecontrol' => { 236 => 0x2a, 292 => 0x76a43205 },
	'vignettecontrolintensity' => { 292 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 499 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 502 => 'VignetteMidpoint', 504 => 'VignetteMidpoint' },
	'vignetting' => { 409 => 0x1011, 416 => 0xa052 },
	'vignettingcorrection' => { 121 => 0x7031, 416 => 0xa053, 442 => 0x2011 },
	'vignettingcorrparams' => { 121 => 0x7032, 473 => 0x64a, 474 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 416 => 0xa054 },
	'virtualfocallength' => { 517 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 315 => 0x167, 316 => 0x167, 317 => 0x17f },
	'virtualimagexcenter' => { 517 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 517 => 'VirtualImageYCenter' },
	'visualcolor' => { 516 => 'VisualColour' },
	'visualtechnique' => { 520 => 'visualTechnique' },
	'voicememo' => { 418 => 0x216 },
	'volume' => { 521 => 'volume' },
	'vr_0x66' => { 264 => 0x66 },
	'vrdoffset' => { 65 => 0xd0 },
	'vrmode' => { 241 => 0x226, 242 => 0x212, 243 => 0x226, 244 => 0x226, 283 => 0x6 },
	'vrtype' => { 283 => 0x8 },
	'waterdepth' => { 121 => 0x9403, 509 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 189 => 0x19a },
	'wb_bluelevel6500k' => { 189 => 0x18a },
	'wb_bluelevelcustom' => { 189 => 0x18e },
	'wb_bluelevelscloudy' => { 189 => 0x106 },
	'wb_bluelevelsdaylight' => { 189 => 0xea },
	'wb_bluelevelsflash' => { 189 => 0x122 },
	'wb_bluelevelsfluorescent' => { 189 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 189 => 0x254 },
	'wb_bluelevelsshade' => { 189 => 0x176 },
	'wb_bluelevelstungsten' => { 189 => 0xce },
	'wb_gbrglevels' => { 189 => 0xae, 192 => 0x4 },
	'wb_glevel' => { 323 => 0x11f },
	'wb_glevel3000k' => { 323 => 0x113 },
	'wb_glevel3300k' => { 323 => 0x114 },
	'wb_glevel3600k' => { 323 => 0x115 },
	'wb_glevel3900k' => { 323 => 0x116 },
	'wb_glevel4000k' => { 323 => 0x117 },
	'wb_glevel4300k' => { 323 => 0x118 },
	'wb_glevel4500k' => { 323 => 0x119 },
	'wb_glevel4800k' => { 323 => 0x11a },
	'wb_glevel5300k' => { 323 => 0x11b },
	'wb_glevel6000k' => { 323 => 0x11c },
	'wb_glevel6600k' => { 323 => 0x11d },
	'wb_glevel7500k' => { 323 => 0x11e },
	'wb_grbglevels' => { 206 => 0x0, 449 => 0x7303 },
	'wb_grbglevelsauto' => { 82 => 0x2, 449 => 0x7302 },
	'wb_grbglevelscloudy' => { 82 => 0x12 },
	'wb_grbglevelscustom1' => { 82 => 0x42 },
	'wb_grbglevelscustom2' => { 82 => 0x4a },
	'wb_grbglevelsdaylight' => { 82 => 0xa },
	'wb_grbglevelsflash' => { 82 => 0x32 },
	'wb_grbglevelsfluorescent' => { 82 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 82 => 0x2a },
	'wb_grbglevelstungsten' => { 82 => 0x1a },
	'wb_grbglevelsunderwater' => { 82 => 0x3a },
	'wb_rbgglevels' => { 203 => 0x0 },
	'wb_rblevels' => { 207 => 0x270, 236 => 0xc, 323 => 0x100 },
	'wb_rblevels1' => { 348 => 0x2 },
	'wb_rblevels2' => { 348 => 0x5 },
	'wb_rblevels3' => { 348 => 0x8 },
	'wb_rblevels3000k' => { 323 => 0x102 },
	'wb_rblevels3300k' => { 323 => 0x103 },
	'wb_rblevels3500k' => { 189 => 0x430 },
	'wb_rblevels3600k' => { 323 => 0x104 },
	'wb_rblevels3900k' => { 323 => 0x105 },
	'wb_rblevels4' => { 348 => 0xb },
	'wb_rblevels4000k' => { 323 => 0x106 },
	'wb_rblevels4300k' => { 323 => 0x107 },
	'wb_rblevels4500k' => { 323 => 0x108 },
	'wb_rblevels4800k' => { 323 => 0x109 },
	'wb_rblevels5' => { 348 => 0xe },
	'wb_rblevels5300k' => { 323 => 0x10a },
	'wb_rblevels6' => { 348 => 0x11 },
	'wb_rblevels6000k' => { 323 => 0x10b },
	'wb_rblevels6500k' => { 189 => 0x420 },
	'wb_rblevels6600k' => { 323 => 0x10c },
	'wb_rblevels7' => { 348 => 0x14 },
	'wb_rblevels7500k' => { 323 => 0x10d },
	'wb_rblevelsauto' => { 207 => 0x272, 327 => 0x110 },
	'wb_rblevelscloudy' => { 189 => 0x3f0, 191 => 0x10, 207 => 0x296, 327 => 0x121 },
	'wb_rblevelscoolwhitef' => { 189 => 0x308, 191 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 327 => 0x132 },
	'wb_rblevelscustom' => { 189 => 0x424, 191 => 0x1c },
	'wb_rblevelscwb1' => { 323 => 0x10e },
	'wb_rblevelscwb2' => { 323 => 0x10f },
	'wb_rblevelscwb3' => { 323 => 0x110 },
	'wb_rblevelscwb4' => { 323 => 0x111 },
	'wb_rblevelsdaylight' => { 189 => [0x3ec,0x528], 191 => 0xc, 207 => 0x274 },
	'wb_rblevelsdaylightf' => { 191 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 327 => 0x130 },
	'wb_rblevelsdaywhitef' => { 191 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 327 => 0x131 },
	'wb_rblevelseveningsunlight' => { 327 => 0x124 },
	'wb_rblevelsfineweather' => { 327 => 0x122 },
	'wb_rblevelsflash' => { 189 => [0x3f4,0x304], 191 => 0x18, 207 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 207 => 0x290 },
	'wb_rblevelsincandescent' => { 207 => 0x282 },
	'wb_rblevelsshade' => { 189 => 0x418, 191 => 0x20, 207 => 0x2b2, 327 => 0x120 },
	'wb_rblevelstungsten' => { 189 => 0x3e8, 191 => 0x8, 327 => 0x123 },
	'wb_rblevelsused' => { 327 => 0x100 },
	'wb_rblevelswhitef' => { 191 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 327 => 0x133 },
	'wb_redlevel3500k' => { 189 => 0x198 },
	'wb_redlevel6500k' => { 189 => 0x188 },
	'wb_redlevelcustom' => { 189 => 0x18c },
	'wb_redlevelscloudy' => { 189 => 0xf8 },
	'wb_redlevelsdaylight' => { 189 => 0xdc },
	'wb_redlevelsflash' => { 189 => 0x114 },
	'wb_redlevelsfluorescent' => { 189 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 189 => 0x1be },
	'wb_redlevelsshade' => { 189 => 0x168 },
	'wb_redlevelstungsten' => { 189 => 0xc0 },
	'wb_rgbglevels' => { 205 => 0x0 },
	'wb_rgblevels' => { 189 => [0x546,0x96], 338 => 0xd, 339 => 0x413, 344 => 0x3036, 386 => 0x107, 451 => 0x117c, 452 => 0x1180, 453 => 0x115c, 454 => 0x11d8, 455 => 0x11b4, 456 => 0x106c, 457 => 0x264, 458 => 0x264, 459 => 0x252 },
	'wb_rgblevels1' => { 349 => 0x2 },
	'wb_rgblevels2' => { 349 => 0x6 },
	'wb_rgblevels2500k' => { 449 => 0x782d },
	'wb_rgblevels3' => { 349 => 0xa },
	'wb_rgblevels3200k' => { 449 => 0x782c },
	'wb_rgblevels4' => { 349 => 0xe },
	'wb_rgblevels4500k' => { 449 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 349 => 0x12 },
	'wb_rgblevels6' => { 349 => 0x16 },
	'wb_rgblevels6000k' => { 449 => 0x782b },
	'wb_rgblevels7' => { 349 => 0x1a },
	'wb_rgblevels8500k' => { 449 => 0x782a },
	'wb_rgblevelsauto' => { 420 => 0x0 },
	'wb_rgblevelscloudy' => { 449 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 420 => 0x15 },
	'wb_rgblevelscustom2' => { 420 => 0x18 },
	'wb_rgblevelscustom3' => { 420 => 0x1b },
	'wb_rgblevelsdaylight' => { 420 => 0x3, 449 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 420 => 0x12, 449 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 420 => 0xf, 449 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 449 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 449 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 449 => 0x7828 },
	'wb_rgblevelsincandescent' => { 420 => 0xc },
	'wb_rgblevelsovercast' => { 420 => 0x9 },
	'wb_rgblevelsshade' => { 420 => 0x6, 449 => 0x7825 },
	'wb_rgblevelstungsten' => { 449 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 421 => 0x0 },
	'wb_rgblevelsunknown1' => { 421 => 0x3 },
	'wb_rgblevelsunknown2' => { 421 => 0x6 },
	'wb_rgblevelsunknown3' => { 421 => 0x9 },
	'wb_rgblevelsunknown4' => { 421 => 0xc },
	'wb_rgblevelsunknown5' => { 421 => 0xf },
	'wb_rgblevelsunknown6' => { 421 => 0x12 },
	'wb_rgblevelsunknown7' => { 421 => 0x15 },
	'wb_rgblevelsunknown8' => { 421 => 0x18 },
	'wb_rgblevelsunknown9' => { 421 => 0x1b },
	'wb_rgbmuldaylight' => { 140 => 0x852 },
	'wb_rgbmulflash' => { 140 => 0x855 },
	'wb_rgbmulfluorescent' => { 140 => 0x854 },
	'wb_rgbmultungsten' => { 140 => 0x853 },
	'wb_rggbblacklevels' => { 36 => 0x25 },
	'wb_rggblevels' => { 121 => 0x7313, 192 => 0x4, 204 => 0x0, 208 => 0x13e8, 209 => 0x38, 449 => 0x7313 },
	'wb_rggblevelsasshot' => { 39 => 0x0, 40 => 0x0, 41 => 0x19, 42 => 0x55, 43 => 0x69, 44 => 0x22, 45 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x3f, 51 => 0x47 },
	'wb_rggblevelsauto' => { 36 => 0x1, 39 => 0x5, 40 => 0x8, 41 => 0x1e, 42 => 0x5a, 43 => 0x6e, 44 => 0x18, 45 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x44, 51 => 0x4c, 208 => 0x1478, 209 => 0x114, 416 => 0xa022, 449 => 0x7312 },
	'wb_rggblevelsblack' => { 416 => 0xa028 },
	'wb_rggblevelscloudy' => { 36 => 0xd, 39 => 0x1e, 40 => 0x30, 41 => 0x2d, 42 => 0xa0, 43 => 0xd7, 44 => 0x31, 45 => 0x58, 48 => 0x71, 49 => 0x8a, 50 => 0x8f, 51 => 0x92, 208 => 0x1408, 209 => 0x60, 377 => 0x20f, 385 => 0x14 },
	'wb_rggblevelscustom' => { 36 => 0x1d, 45 => 0x80, 208 => 0x1468, 209 => 0x100 },
	'wb_rggblevelscustom1' => { 41 => 0x41 },
	'wb_rggblevelscustom2' => { 41 => 0x46 },
	'wb_rggblevelsdaylight' => { 36 => 0x5, 39 => 0x14, 40 => 0x20, 41 => 0x23, 42 => 0x96, 43 => 0xcd, 44 => 0x27, 45 => 0x4e, 48 => 0x67, 49 => 0x80, 50 => 0x85, 51 => 0x88, 208 => 0x13f8, 209 => 0x4c, 377 => 0x20d, 385 => 0x2 },
	'wb_rggblevelsflash' => { 36 => 0x19, 39 => 0x32, 40 => 0x50, 41 => 0x3c, 42 => 0xb4, 43 => 0xeb, 44 => 0x45, 45 => 0x6c, 48 => 0x85, 49 => 0x9e, 50 => 0xa3, 51 => 0xa6, 208 => 0x1448, 377 => 0x214, 385 => 0x41 },
	'wb_rggblevelsfluorescent' => { 36 => 0x15, 39 => 0x28, 40 => 0x40, 41 => 0x37, 42 => 0xaa, 43 => 0xe1, 44 => 0x3b, 45 => 0x62, 48 => 0x7b, 49 => 0x94, 50 => 0x99, 51 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 209 => 0xc4, 377 => 0x211, 385 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 385 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 209 => 0xb0, 377 => 0x212, 385 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 208 => 0x1438, 209 => 0x9c, 377 => 0x213, 385 => 0x38 },
	'wb_rggblevelshtmercury' => { 209 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 416 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 416 => 0xa024 },
	'wb_rggblevelskelvin' => { 36 => 0x21, 39 => 0x2d, 40 => 0x48, 42 => 0xaf, 43 => 0xe6, 44 => 0x40, 45 => 0x67, 48 => 0x80, 49 => 0x99, 50 => 0x9e, 51 => 0xa1 },
	'wb_rggblevelsmeasured' => { 39 => 0xa, 40 => 0x10, 42 => 0x5f, 43 => 0x73, 45 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x49, 51 => 0x51 },
	'wb_rggblevelspc1' => { 44 => 0x90, 45 => 0x71 },
	'wb_rggblevelspc2' => { 44 => 0x95, 45 => 0x76 },
	'wb_rggblevelspc3' => { 44 => 0x9a, 45 => 0x7b },
	'wb_rggblevelsshade' => { 36 => 0x9, 39 => 0x19, 40 => 0x28, 41 => 0x28, 42 => 0x9b, 43 => 0xd2, 44 => 0x2c, 45 => 0x53, 48 => 0x6c, 49 => 0x85, 50 => 0x8a, 51 => 0x8d, 209 => 0x74, 377 => 0x20e, 385 => 0xb },
	'wb_rggblevelstungsten' => { 36 => 0x11, 39 => 0x23, 40 => 0x38, 41 => 0x32, 42 => 0xa5, 43 => 0xdc, 44 => 0x36, 45 => 0x5d, 48 => 0x76, 49 => 0x8f, 50 => 0x94, 51 => 0x97, 208 => 0x1428, 209 => 0x88, 377 => 0x210, 385 => 0x1d },
	'wb_rggblevelsuncorrected' => { 416 => 0xa021 },
	'wb_rggblevelsunknown' => { 39 => 0xf, 40 => 0x18, 42 => 0x64, 43 => 0x78, 44 => 0x1d, 48 => 0x4e, 49 => 0x4e, 50 => 0x4e, 51 => 0x56, 385 => 0x53 },
	'wb_rggblevelsunknown10' => { 39 => 0x5f, 40 => 0x98, 42 => 0x91, 43 => 0xa5, 44 => 0x72, 48 => 0x9e, 49 => 0x7b, 50 => 0x7b, 51 => 0x83 },
	'wb_rggblevelsunknown11' => { 39 => 0x64, 40 => 0xa0, 42 => 0xb9, 43 => [0xaa,0xaf], 44 => 0x77, 48 => 0xa3, 49 => 0xa3, 50 => 0x80, 51 => 0xab },
	'wb_rggblevelsunknown12' => { 39 => 0x69, 40 => 0xa8, 42 => 0xbe, 43 => 0xb4, 44 => 0x7c, 48 => 0xa8, 49 => 0xa8, 50 => 0xa8, 51 => 0xb0 },
	'wb_rggblevelsunknown13' => { 39 => 0x6e, 40 => 0xb0, 42 => 0xc3, 43 => 0xb9, 44 => 0x81, 48 => 0xad, 49 => 0xad, 50 => 0xad, 51 => 0xb5 },
	'wb_rggblevelsunknown14' => { 42 => 0xc8, 43 => 0xbe, 44 => 0x86, 48 => 0xb2, 49 => 0xb2, 50 => 0xb2, 51 => 0xba },
	'wb_rggblevelsunknown15' => { 42 => 0xcd, 43 => 0xc3, 44 => 0x8b, 48 => 0xb7, 49 => 0xb7, 50 => 0xb7, 51 => 0xbf },
	'wb_rggblevelsunknown16' => { 42 => 0xd2, 43 => 0xc8, 44 => 0x9f, 49 => 0xbc, 50 => 0xbc, 51 => 0xc4 },
	'wb_rggblevelsunknown17' => { 42 => 0xd7, 43 => 0xf0, 49 => 0xc1, 50 => 0xc1, 51 => 0xc9 },
	'wb_rggblevelsunknown18' => { 42 => 0xdc, 43 => 0xf5, 49 => 0xc6, 50 => 0xc6, 51 => 0xce },
	'wb_rggblevelsunknown19' => { 42 => 0xe1, 43 => 0xfa, 49 => 0xcb, 50 => 0xcb, 51 => 0xd3 },
	'wb_rggblevelsunknown2' => { 39 => 0x37, 40 => 0x58, 42 => 0x69, 43 => 0x7d, 44 => 0x4a, 48 => 0x53, 49 => 0x53, 50 => 0x53, 51 => 0x5b },
	'wb_rggblevelsunknown20' => { 42 => 0xe6, 43 => 0xff, 49 => 0xd0, 50 => 0xd0, 51 => 0xd8 },
	'wb_rggblevelsunknown21' => { 42 => 0xeb, 43 => 0x104, 50 => 0xd5, 51 => 0xdd },
	'wb_rggblevelsunknown22' => { 42 => 0xf0, 43 => 0x109, 50 => 0xda, 51 => 0xe2 },
	'wb_rggblevelsunknown23' => { 42 => 0xf5, 43 => 0x10e, 50 => 0xdf, 51 => 0xe7 },
	'wb_rggblevelsunknown24' => { 42 => 0xfa, 43 => 0x113, 50 => 0xe4, 51 => 0xec },
	'wb_rggblevelsunknown25' => { 42 => 0xff, 43 => 0x118, 50 => 0xe9, 51 => 0xf1 },
	'wb_rggblevelsunknown26' => { 42 => 0x104, 43 => 0x11d, 50 => 0xee, 51 => 0xf6 },
	'wb_rggblevelsunknown27' => { 42 => 0x109, 43 => 0x122, 50 => 0xf3, 51 => 0xfb },
	'wb_rggblevelsunknown28' => { 42 => 0x10e, 50 => 0xf8, 51 => 0x100 },
	'wb_rggblevelsunknown29' => { 42 => 0x113, 50 => 0xfd, 51 => 0x105 },
	'wb_rggblevelsunknown3' => { 39 => 0x3c, 40 => 0x60, 42 => 0x6e, 43 => 0x82, 44 => 0x4f, 48 => 0x58, 49 => 0x58, 50 => 0x58, 51 => 0x60 },
	'wb_rggblevelsunknown30' => { 50 => 0x102 },
	'wb_rggblevelsunknown4' => { 39 => 0x41, 40 => 0x68, 42 => 0x73, 43 => 0x87, 44 => 0x54, 48 => 0x5d, 49 => 0x5d, 50 => 0x5d, 51 => 0x65 },
	'wb_rggblevelsunknown5' => { 39 => 0x46, 40 => 0x70, 42 => 0x78, 43 => 0x8c, 44 => 0x59, 48 => 0x62, 49 => 0x62, 50 => 0x62, 51 => 0x6a },
	'wb_rggblevelsunknown6' => { 39 => 0x4b, 40 => 0x78, 42 => 0x7d, 43 => 0x91, 44 => 0x5e, 48 => 0x8a, 49 => 0x67, 50 => 0x67, 51 => 0x6f },
	'wb_rggblevelsunknown7' => { 39 => 0x50, 40 => 0x80, 42 => 0x82, 43 => 0x96, 44 => 0x63, 48 => 0x8f, 49 => 0x6c, 50 => 0x6c, 51 => 0x74 },
	'wb_rggblevelsunknown8' => { 39 => 0x55, 40 => 0x88, 42 => 0x87, 43 => 0x9b, 44 => 0x68, 48 => 0x94, 49 => 0x71, 50 => 0x71, 51 => 0x79 },
	'wb_rggblevelsunknown9' => { 39 => 0x5a, 40 => 0x90, 42 => 0x8c, 43 => 0xa0, 44 => 0x6d, 48 => 0x99, 49 => 0x76, 50 => 0x76, 51 => 0x7e },
	'wb_rggblevelsuserselected' => { 385 => 0x5c },
	'wbadjblueamber' => { 105 => 0x20106 },
	'wbadjbluebalance' => { 298 => 0x8 },
	'wbadjcolortemp' => { 105 => 0x20102, 110 => 0x1a },
	'wbadjlighting' => { 298 => 0x14 },
	'wbadjmagentagreen' => { 105 => 0x20105 },
	'wbadjmode' => { 298 => 0x10 },
	'wbadjredbalance' => { 298 => 0x0 },
	'wbadjrggblevels' => { 105 => 0x20125, 110 => 0x6 },
	'wbadjtemperature' => { 298 => 0x18 },
	'wbadjtint' => { 298 => 0x25 },
	'wbbluelevel' => { 337 => 0x324, 342 => 0x8006, 347 => 0x26 },
	'wbbracketingsteps' => { 200 => 0x10, 201 => 0x10, 273 => 0x174d },
	'wbbracketmode' => { 58 => 0x9 },
	'wbbracketshotnumber' => { 189 => 0x2b, 409 => 0x101a },
	'wbbracketvalueab' => { 58 => 0xc },
	'wbbracketvaluegm' => { 58 => 0xd },
	'wbbutton' => { 244 => 0x80a },
	'wbfinetuneactive' => { 110 => 0x24 },
	'wbfinetunesaturation' => { 110 => 0x28 },
	'wbfinetunetone' => { 110 => 0x2c },
	'wbgreenlevel' => { 337 => 0x323, 342 => 0x8005, 347 => 0x25 },
	'wbmediaimagesizesetting' => { 86 => 0x708 },
	'wbmode' => { 191 => 0x4, 324 => 0x1015 },
	'wbredlevel' => { 337 => 0x322, 342 => 0x8004, 347 => 0x24 },
	'wbscale' => { 192 => 0x0 },
	'wbshiftab' => { 75 => 0xc, 342 => 0x46, 359 => 0x10 },
	'wbshiftab_gm' => { 442 => 0x2014 },
	'wbshiftab_gm_precise' => { 442 => 0x2026 },
	'wbshiftcreativecontrol' => { 342 => 0x92 },
	'wbshiftgm' => { 75 => 0xd, 342 => 0x47, 359 => 0x11 },
	'wbshiftintelligentauto' => { 342 => 0x8b },
	'wbtype1' => { 348 => 0x1, 349 => 0x1 },
	'wbtype2' => { 348 => 0x4, 349 => 0x5 },
	'wbtype3' => { 348 => 0x7, 349 => 0x9 },
	'wbtype4' => { 348 => 0xa, 349 => 0xd },
	'wbtype5' => { 348 => 0xd, 349 => 0x11 },
	'wbtype6' => { 348 => 0x10, 349 => 0x15 },
	'wbtype7' => { 348 => 0x13, 349 => 0x19 },
	'webstatement' => { 535 => 'WebStatement' },
	'weightedflatsubject' => { 494 => 'weightedFlatSubject' },
	'what' => { 502 => 'What', 504 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 75 => 0x8, 78 => 0x7, 114 => 0x7, 115 => [0x19,0x2012], 121 => [0xa403,0xfe4e], 129 => 0x1002, 140 => 0x3fc, 141 => 0xfa0d, 142 => 0x40, 153 => 0x1a, 183 => 0x3, 184 => 0xe, 185 => 0x4, 186 => 0xb, 188 => 0x115, 236 => 0x5, 282 => 0x7, 337 => 0x304, 342 => 0x3, 344 => 0x3033, 377 => 0x19, 384 => 0x7, 408 => 0x26, 409 => 0x1003, 419 => [0x88,0x3c,0x7,0x58], 429 => 0xf, 430 => 0xe, 442 => [0x115,0xb054], 502 => 'WhiteBalance', 504 => 'WhiteBalance', 508 => 'WhiteBalance' },
	'whitebalance0' => { 178 => 'WhiteBalance0' },
	'whitebalance1' => { 178 => 'WhiteBalance1' },
	'whitebalance2' => { 178 => 'WhiteBalance2', 319 => 0x500 },
	'whitebalanceadj' => { 105 => 0x20101, 110 => 0x18, 292 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 355 => 0x0 },
	'whitebalancebias' => { 115 => 0x2011, 324 => 0x304, 342 => 0x23 },
	'whitebalanceblue' => { 75 => 0x7 },
	'whitebalancebracket' => { 319 => 0x502, 324 => 0x303 },
	'whitebalancebracketing' => { 186 => 0x22, 189 => 0x2c, 440 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 316 => 0x1c5, 317 => 0x1dd },
	'whitebalancecomp' => { 327 => 0x1001 },
	'whitebalancedetected' => { 140 => 0x3fb },
	'whitebalancefinetune' => { 129 => 0x100a, 186 => 0x38, 188 => 0x112, 236 => [0xb,0x3f], 409 => 0x1004, 429 => 0x6, 430 => 0x5, 442 => 0x112 },
	'whitebalancemode' => { 140 => 0x3fa, 377 => 0x1a },
	'whitebalancered' => { 75 => 0x6 },
	'whitebalanceset' => { 358 => 0xa },
	'whitebalancesetting' => { 186 => 0x23, 429 => 0x5, 430 => 0x4, 431 => 0x16, 447 => 0xd },
	'whitebalancesetup' => { 416 => 0x41 },
	'whitebalancetemperature' => { 319 => 0x501 },
	'whiteboard' => { 324 => 0x301 },
	'whitelevel' => { 121 => 0xc61d, 377 => 0x7e, 449 => 0x787f },
	'whitepoint' => { 121 => 0x13e, 341 => 0x35d, 377 => 0x201, 527 => 'WhitePoint' },
	'whites2012' => { 502 => 'Whites2012', 504 => 'Whites2012' },
	'whitesadj' => { 478 => 0x9017 },
	'wideadapter' => { 409 => 0x1017 },
	'widefocuszone' => { 183 => 0x2f },
	'widerange' => { 418 => 0x20f },
	'windmode' => { 140 => 0x3f4 },
	'windnoisereduction' => { 241 => 0x352, 242 => 0x2d6, 243 => 0x2fe, 244 => 0x2fe },
	'windowlocation' => { 402 => 'WLOC' },
	'windowsatom' => { 503 => 'windowsAtom' },
	'windowsatomextension' => { 503 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 503 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 503 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 521 => 'wordCount' },
	'work' => { 394 => "\xa9wrk" },
	'workcolorspace' => { 105 => 0x10200, 110 => 0x270 },
	'workflowtag' => { 516 => 'WorkflowTag' },
	'workflowtagcvid' => { 516 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 516 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 516 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 516 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 510 => 'WorkToDo' },
	'worldtimelocation' => { 342 => 0x3a, 377 => 0x22, 383 => '0.1' },
	'writer' => { 181 => 'WM/Writer' },
	'writer-editor' => { 133 => 0x7a },
	'x3filllight' => { 419 => 0x12 },
	'xattrquarantine' => { 176 => 'com.apple.quarantine' },
	'xilinxversion' => { 140 => 0x414 },
	'xml' => { 138 => 'xml ' },
	'xmp' => { 108 => 0xffff00f6, 122 => 'XMP' },
	'xmptoolkit' => { 528 => 'xmptk' },
	'xpauthor' => { 121 => 0x9c9d },
	'xpcomment' => { 121 => 0x9c9c },
	'xpkeywords' => { 121 => 0x9c9e },
	'xposition' => { 121 => 0x11e },
	'xpsubject' => { 121 => 0x9c9f },
	'xptitle' => { 121 => 0x9c9b },
	'xresolution' => { 121 => 0x11a, 136 => 0x3, 392 => 0x0, 527 => 'XResolution' },
	'xyresolution' => { 125 => 0x3 },
	'yaw' => { 117 => 0x7, 402 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 249 => 0x8, 414 => 0x0 },
	'ycbcrcoefficients' => { 121 => 0x211, 527 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 121 => 0x213, 527 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 121 => 0x212, 527 => 'YCbCrSubSampling' },
	'year' => { 394 => 'yrrc', 396 => 'year', 402 => 'yrrc' },
	'yearcreated' => { 142 => 0x10, 151 => 0xc },
	'yellowhsl' => { 105 => 0x20912 },
	'yield' => { 523 => 'yield' },
	'yposition' => { 121 => 0x11f },
	'yresolution' => { 121 => 0x11b, 136 => 0x5, 392 => 0x4, 527 => 'YResolution' },
	'zebrapatterntonerange' => { 315 => 0x211, 316 => 0x211, 317 => 0x229 },
	'zoneidentifier' => { 122 => 'ZoneIdentifier' },
	'zonematching' => { 188 => 0x10a, 191 => [0x3a,0x4a], 442 => 0xb024 },
	'zonematchingmode' => { 186 => 0x14 },
	'zonematchingon' => { 185 => 0x75 },
	'zonematchingvalue' => { 429 => 0x1f },
	'zoomedpreviewlength' => { 324 => 0xf05 },
	'zoomedpreviewsize' => { 324 => 0xf06 },
	'zoomedpreviewstart' => { 324 => 0xf04 },
	'zoomsourcewidth' => { 35 => 0x24 },
	'zoomstepcount' => { 322 => 0x300, 324 => 0x100d },
	'zoomtargetwidth' => { 35 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
