#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 110 => 0x69 },
	'about' => { 524 => 'about' },
	'aboutcvterm' => { 515 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 515 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 515 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 515 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 515 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 117 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 530 => 'absPeakAudioFilePath' },
	'academicfield' => { 520 => 'academicField' },
	'acceleration' => { 120 => 0x9404, 508 => 'Acceleration' },
	'accelerationtracking' => { 85 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 411 => 0x3 },
	'accelerometerdata' => { 401 => 'vrot' },
	'accelerometerx' => { 341 => 0x8d },
	'accelerometery' => { 341 => 0x8e },
	'accelerometerz' => { 341 => 0x8c },
	'accessoryserialnumber' => { 341 => 0x54 },
	'accessorytype' => { 341 => 0x53 },
	'actionadvised' => { 132 => 0x2a },
	'activearea' => { 120 => 0xc68d },
	'actived-lighting' => { 235 => 0x22, 289 => 0x24 },
	'actived-lightingmode' => { 289 => 0x25 },
	'adaptervoltage' => { 139 => 0x407 },
	'addaspectratioinfo' => { 85 => 0x80e },
	'addiptcinformation' => { 85 => 0x815 },
	'additionalmodelinformation' => { 515 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 85 => 0x80f, 86 => 0x11, 87 => 0x13, 90 => 0x14 },
	'address' => { 162 => 'Address' },
	'adjustmentmode' => { 418 => 0x15 },
	'adlbracketingstep' => { 199 => 0x17 },
	'adlbracketingtype' => { 199 => 0x18 },
	'adobe' => { 121 => 'Adobe' },
	'adultcontentwarning' => { 328 => 'AdultContentWarning', 523 => 'adultContentWarning' },
	'advancedfilter' => { 128 => 0x1201 },
	'advancedraw' => { 291 => 0x76a43203 },
	'advancedscenetype' => { 341 => 0x3d },
	'advisory' => { 528 => 'Advisory' },
	'ae_iso' => { 349 => 0x2, 350 => 0x4, 351 => 0x12 },
	'aeaperture' => { 349 => 0x1, 350 => 0x3, 351 => 0x11 },
	'aeaperturesteps' => { 349 => 0x8, 350 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 85 => 0x104 },
	'aebbracketvalue' => { 78 => 0x11 },
	'aebracketingsteps' => { 199 => 0xf, 200 => 0xf, 272 => 0x174c },
	'aebsequence' => { 85 => 0x105 },
	'aebsequenceautocancel' => { 83 => 0x9, 84 => 0x9, 86 => 0x8, 87 => 0x9, 90 => 0x9, 91 => 0x7 },
	'aebshotcount' => { 85 => 0x106 },
	'aebxv' => { 349 => 0x4, 350 => 0x6 },
	'aeerror' => { 350 => 0x8 },
	'aeexposuretime' => { 349 => 0x0, 350 => 0x2, 351 => 0x10 },
	'aelbutton' => { 185 => 0x45 },
	'aelexposureindicator' => { 185 => 0x51 },
	'aelock' => { 185 => 0x5b, 300 => '4.2', 309 => '4.2', 318 => 0x201, 376 => 0x48, 428 => 0x40, 429 => 0x40, 430 => [0x86,0x286] },
	'aelockbutton' => { 298 => '16.1', 300 => '4.1', 303 => '15.1', 304 => '16.1', 305 => '16.1', 307 => '30.1', 308 => '16.1', 309 => '4.1', 311 => '17.1', 313 => '17.1' },
	'aelockbuttonplusdials' => { 298 => '16.2', 307 => '32.1', 311 => '44.1' },
	'aelockformb-d80' => { 313 => '3.1' },
	'aelockmetermodeafterfocus' => { 85 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 349 => 0x9, 350 => 0x10, 351 => 0x1c },
	'aemaxaperture2' => { 349 => 0xa, 350 => 0x11, 351 => 0x1d },
	'aemeteringmode' => { 349 => 0xc },
	'aemeteringmode2' => { 349 => '13.1' },
	'aemeteringsegments' => { 188 => 0x628, 376 => 0x209 },
	'aemicroadjustment' => { 85 => 0x110 },
	'aeminaperture' => { 349 => 0xb, 350 => 0x12, 351 => 0x1e },
	'aeminexposuretime' => { 349 => 0x5, 350 => 0x13, 351 => 0x1f },
	'aeprogrammode' => { 349 => 0x6 },
	'aeprojectlink' => { 502 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 502 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 502 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 502 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 502 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 502 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 35 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 349 => 0xd },
	'aexv' => { 349 => 0x3, 350 => 0x5 },
	'af-assistilluminator' => { 314 => 0x19, 315 => 0x19, 316 => 0x19 },
	'af-cfocusdisplay' => { 314 => 0x234, 315 => 0x234, 316 => 0x24c },
	'af-cpriority' => { 129 => '0.2' },
	'af-cpriorityselection' => { 298 => '1.1', 299 => '1.1', 301 => '1.1', 302 => '1.1', 304 => '0.1', 305 => '0.1', 306 => '0.1', 307 => '1.1', 308 => '0.1', 311 => '1.1', 312 => '1.1', 314 => 0x3, 315 => 0x3, 316 => 0x3 },
	'af-csetting' => { 125 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 125 => '0.2' },
	'af-ctrackingsensitivity' => { 125 => '0.1' },
	'af-czoneareaswitching' => { 125 => '0.3' },
	'af-onbutton' => { 301 => '70.1', 302 => '70.1', 312 => '70.1' },
	'af-onformb-d10' => { 298 => '3.3', 307 => '3.2' },
	'af-onformb-d11' => { 308 => '2.2' },
	'af-onformb-d12' => { 311 => '50.1' },
	'af-onoutoffocusrelease' => { 314 => 0x10, 315 => 0x10, 316 => 0x10 },
	'af-spriority' => { 129 => '0.1' },
	'af-spriorityselection' => { 298 => '1.2', 299 => '1.2', 301 => '1.2', 302 => '1.2', 306 => '0.2', 307 => '1.2', 308 => '0.2', 311 => '1.2', 312 => '1.2', 314 => 0x5, 315 => 0x5, 316 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 298 => '2.1', 299 => '2.1', 301 => '78.3', 302 => '78.3', 307 => '2.1', 311 => '2.1', 312 => '78.3', 314 => 0xf, 315 => 0xf, 316 => 0xf },
	'afadjustment' => { 376 => 0x72, 385 => 0x267 },
	'afandmeteringbuttons' => { 85 => 0x701 },
	'afaperture' => { 228 => 0x5, 229 => 0x5, 233 => 0x5 },
	'afareaheight' => { 194 => [0x1a,0x34,0x50], 195 => 0x48 },
	'afareaillumination' => { 185 => 0x4b, 309 => '15.3' },
	'afareainitialheight' => { 247 => 0xbeb },
	'afareainitialwidth' => { 247 => 0xbea },
	'afareainitialxposition' => { 247 => 0xbe8 },
	'afareainitialyposition' => { 247 => 0xbe9 },
	'afareamode' => { 127 => '0.3', 181 => 0x33, 185 => 0xe, 193 => 0x0, 194 => 0x5, 195 => 0x5, 240 => 0x224, 241 => 0x210, 242 => 0x224, 243 => 0x224, 341 => 0xf, 408 => 0x1205, 421 => [0xa,0x3a], 428 => 0x11, 429 => 0x10, 430 => 0x24, 441 => 0xb043, 467 => 0x17 },
	'afareamodesetting' => { 300 => '11.1', 303 => '0.1', 309 => '16.1', 313 => '2.1', 441 => 0x201c },
	'afareapointsize' => { 127 => '0.4' },
	'afareas' => { 318 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 85 => 0x51b },
	'afareawidth' => { 194 => [0x18,0x32,0x4e], 195 => 0x46 },
	'afareaxposition' => { 194 => [0x14,0x2e,0x4a], 195 => 0x42, 408 => 0x1203 },
	'afareaxposition1' => { 408 => 0x1201 },
	'afareayposition' => { 194 => [0x16,0x30,0x4c], 195 => 0x44, 408 => 0x1204 },
	'afareayposition1' => { 408 => 0x1202 },
	'afareazonesize' => { 127 => '0.5' },
	'afassist' => { 83 => 0x5, 91 => 0x5, 185 => 0x48, 298 => '2.5', 300 => '0.2', 303 => '0.2', 304 => '1.1', 305 => '1.1', 306 => '1.3', 307 => '2.4', 308 => '1.3', 309 => '0.2', 311 => '2.4', 313 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 85 => 0x50e, 86 => 0x4, 87 => 0x5, 88 => 0x4, 89 => 0x4, 90 => 0x5 },
	'afassistlamp' => { 341 => 0x31 },
	'afbuttonpressed' => { 430 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 352 => 0x6 },
	'afduringliveview' => { 85 => 0x511 },
	'affinea' => { 495 => 'AffineA' },
	'affineb' => { 495 => 'AffineB' },
	'affinec' => { 495 => 'AffineC' },
	'affined' => { 495 => 'AffineD' },
	'affinetune' => { 196 => 0x0, 240 => 0x6b0, 241 => 0x5b0, 242 => 0x5e0, 243 => 0x5f8, 318 => 0x306 },
	'affinetuneadj' => { 196 => 0x2, 265 => 0x2d1, 266 => 0x2dc, 318 => 0x307 },
	'affinetuneadjtele' => { 196 => 0x3 },
	'affinetuneindex' => { 196 => 0x1 },
	'affinex' => { 495 => 'AffineX' },
	'affiney' => { 495 => 'AffineY' },
	'afhold' => { 352 => 0x1fd },
	'afilluminator' => { 428 => 0x29, 441 => 0xb044 },
	'afimageheight' => { 194 => [0x12,0x2c,0x48], 195 => 0x40 },
	'afimagewidth' => { 194 => [0x10,0x2a,0x46], 195 => 0x3e },
	'afintegrationtime' => { 352 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 421 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 425 => 0x131 },
	'afmicroadjregisteredlenses' => { 425 => '305.1' },
	'afmicroadjustment' => { 85 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 425 => 0x130 },
	'afmode' => { 114 => 0x3009, 128 => 0x1022, 181 => 0x16, 418 => 0x5 },
	'afmoderestrictions' => { 299 => '50.3', 301 => '48.3', 302 => '48.3', 311 => '48.3', 312 => '48.3' },
	'afonaelockbuttonswitch' => { 85 => 0x702 },
	'afonbutton' => { 298 => '3.1', 299 => '47.1', 314 => 0x83, 315 => 0x83, 316 => 0x83 },
	'afpoint' => { 35 => 0x13, 113 => 0x18, 181 => 0x15, 193 => 0x1, 321 => 0x308, 418 => 0x1f, 421 => [0x37,0x7], 425 => 0x19, 426 => 0x18, 427 => [0x18,0x20] },
	'afpointactivationarea' => { 84 => 0x11, 90 => 0x11 },
	'afpointareaexpansion' => { 85 => 0x508 },
	'afpointatshutterrelease' => { 421 => [0x39,0x9] },
	'afpointautoselection' => { 85 => 0x50b },
	'afpointbrightness' => { 85 => 0x50d, 298 => '2.4', 299 => '46.5', 301 => '2.2', 302 => '2.2', 311 => '2.3', 312 => '2.2' },
	'afpointdetails' => { 321 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 85 => 0x50c },
	'afpointillumination' => { 84 => 0xa, 298 => '2.3', 299 => '46.2', 301 => '47.2', 302 => '47.2', 306 => '1.2', 307 => '2.3', 308 => '1.2', 311 => '47.2', 312 => '47.2', 313 => '2.4' },
	'afpointinfocus' => { 421 => [0x38,0x8] },
	'afpointmode' => { 357 => 0x3 },
	'afpointposition' => { 114 => 0x2021, 341 => 0x4d },
	'afpointregistration' => { 83 => 0x7 },
	'afpoints' => { 184 => 0x10 },
	'afpointsel' => { 314 => 0xb, 315 => 0xb, 316 => 0xb },
	'afpointselected' => { 185 => 0xd, 318 => 0x305, 376 => 0xe, 425 => 0x15, 426 => 0x14, 427 => [0x14,0x1c], 441 => 0x201e },
	'afpointselected2' => { 357 => 0x4 },
	'afpointselection' => { 84 => 0xb, 298 => '1.3', 299 => '1.3', 307 => '1.3', 311 => '1.3', 312 => '1.3' },
	'afpointselectionmethod' => { 85 => 0x50f, 86 => 0xc, 87 => 0xd, 90 => 0xd },
	'afpointsetting' => { 428 => 0x12, 429 => 0x11 },
	'afpointsinfocus' => { 78 => 0xe, 193 => 0x2, 194 => 0x30, 352 => 0xb, 353 => 0x4, 376 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 84 => 0xd },
	'afpointsselected' => { 194 => 0x1c, 353 => '4.1', 475 => 0x4 },
	'afpointsspecial' => { 353 => '4.2' },
	'afpointsunknown1' => { 352 => 0x0 },
	'afpointsunknown2' => { 352 => 0x2 },
	'afpointsused' => { 194 => [0xa,0x8], 195 => 0xa, 421 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 352 => 0x4 },
	'afresponse' => { 235 => 0xad },
	'afresult' => { 323 => 0x1038 },
	'afsearch' => { 318 => 0x303 },
	'afsensoractive' => { 181 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 408 => 0x1200 },
	'afstatus_00_b4' => { 424 => 0x0 },
	'afstatus_01_c4' => { 424 => 0x2 },
	'afstatus_02_d4' => { 424 => 0x4 },
	'afstatus_03_e4' => { 424 => 0x6 },
	'afstatus_04_f4' => { 424 => 0x8 },
	'afstatus_05_g4' => { 424 => 0xa },
	'afstatus_06_h4' => { 424 => 0xc },
	'afstatus_07_b3' => { 424 => 0xe },
	'afstatus_08_c3' => { 424 => 0x10 },
	'afstatus_09_d3' => { 424 => 0x12 },
	'afstatus_10_e3' => { 424 => 0x14 },
	'afstatus_11_f3' => { 424 => 0x16 },
	'afstatus_12_g3' => { 424 => 0x18 },
	'afstatus_13_h3' => { 424 => 0x1a },
	'afstatus_14_b2' => { 424 => 0x1c },
	'afstatus_15_c2' => { 424 => 0x1e },
	'afstatus_16_d2' => { 424 => 0x20 },
	'afstatus_17_e2' => { 424 => 0x22 },
	'afstatus_18_f2' => { 424 => 0x24 },
	'afstatus_19_g2' => { 424 => 0x26 },
	'afstatus_20_h2' => { 424 => 0x28 },
	'afstatus_21_c1' => { 424 => 0x2a },
	'afstatus_22_d1' => { 424 => 0x2c },
	'afstatus_23_e1' => { 424 => 0x2e },
	'afstatus_24_f1' => { 424 => 0x30 },
	'afstatus_25_g1' => { 424 => 0x32 },
	'afstatus_26_a7_vertical' => { 424 => 0x34 },
	'afstatus_27_a6_vertical' => { 424 => 0x36 },
	'afstatus_28_a5_vertical' => { 424 => 0x38 },
	'afstatus_29_c7_vertical' => { 424 => 0x3a },
	'afstatus_30_c6_vertical' => { 424 => 0x3c },
	'afstatus_31_c5_vertical' => { 424 => 0x3e },
	'afstatus_32_e7_vertical' => { 424 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 424 => 0x42 },
	'afstatus_34_e5_vertical' => { 424 => 0x44 },
	'afstatus_35_g7_vertical' => { 424 => 0x46 },
	'afstatus_36_g6_vertical' => { 424 => 0x48 },
	'afstatus_37_g5_vertical' => { 424 => 0x4a },
	'afstatus_38_i7_vertical' => { 424 => 0x4c },
	'afstatus_39_i6_vertical' => { 424 => 0x4e },
	'afstatus_40_i5_vertical' => { 424 => 0x50 },
	'afstatus_41_a7' => { 424 => 0x52 },
	'afstatus_42_b7' => { 424 => 0x54 },
	'afstatus_43_c7' => { 424 => 0x56 },
	'afstatus_44_d7' => { 424 => 0x58 },
	'afstatus_45_e7' => { 424 => 0x5a },
	'afstatus_46_f7' => { 424 => 0x5c },
	'afstatus_47_g7' => { 424 => 0x5e },
	'afstatus_48_h7' => { 424 => 0x60 },
	'afstatus_49_i7' => { 424 => 0x62 },
	'afstatus_50_a6' => { 424 => 0x64 },
	'afstatus_51_b6' => { 424 => 0x66 },
	'afstatus_52_c6' => { 424 => 0x68 },
	'afstatus_53_d6' => { 424 => 0x6a },
	'afstatus_54_e6_center' => { 424 => 0x6c },
	'afstatus_55_f6' => { 424 => 0x6e },
	'afstatus_56_g6' => { 424 => 0x70 },
	'afstatus_57_h6' => { 424 => 0x72 },
	'afstatus_58_i6' => { 424 => 0x74 },
	'afstatus_59_a5' => { 424 => 0x76 },
	'afstatus_60_b5' => { 424 => 0x78 },
	'afstatus_61_c5' => { 424 => 0x7a },
	'afstatus_62_d5' => { 424 => 0x7c },
	'afstatus_63_e5' => { 424 => 0x7e },
	'afstatus_64_f5' => { 424 => 0x80 },
	'afstatus_65_g5' => { 424 => 0x82 },
	'afstatus_66_h5' => { 424 => 0x84 },
	'afstatus_67_i5' => { 424 => 0x86 },
	'afstatus_68_c11' => { 424 => 0x88 },
	'afstatus_69_d11' => { 424 => 0x8a },
	'afstatus_70_e11' => { 424 => 0x8c },
	'afstatus_71_f11' => { 424 => 0x8e },
	'afstatus_72_g11' => { 424 => 0x90 },
	'afstatus_73_b10' => { 424 => 0x92 },
	'afstatus_74_c10' => { 424 => 0x94 },
	'afstatus_75_d10' => { 424 => 0x96 },
	'afstatus_76_e10' => { 424 => 0x98 },
	'afstatus_77_f10' => { 424 => 0x9a },
	'afstatus_78_g10' => { 424 => 0x9c },
	'afstatus_79_h10' => { 424 => 0x9e },
	'afstatus_80_b9' => { 424 => 0xa0 },
	'afstatus_81_c9' => { 424 => 0xa2 },
	'afstatus_82_d9' => { 424 => 0xa4 },
	'afstatus_83_e9' => { 424 => 0xa6 },
	'afstatus_84_f9' => { 424 => 0xa8 },
	'afstatus_85_g9' => { 424 => 0xaa },
	'afstatus_86_h9' => { 424 => 0xac },
	'afstatus_87_b8' => { 424 => 0xae },
	'afstatus_88_c8' => { 424 => 0xb0 },
	'afstatus_89_d8' => { 424 => 0xb2 },
	'afstatus_90_e8' => { 424 => 0xb4 },
	'afstatus_91_f8' => { 424 => 0xb6 },
	'afstatus_92_g8' => { 424 => 0xb8 },
	'afstatus_93_h8' => { 424 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 424 => 0xbc },
	'afstatusactivesensor' => { 181 => 0x2, 421 => [0x4,0x3b], 425 => 0x1e, 426 => 0x1b, 427 => [0x1b,0x21] },
	'afstatusbottom' => { 181 => 0x8, 425 => 0x2a, 426 => 0x21, 427 => 0x21 },
	'afstatusbottom-left' => { 181 => 0x12, 426 => 0x2b, 427 => 0x2b },
	'afstatusbottom-right' => { 181 => 0x6, 426 => 0x1f, 427 => 0x1f },
	'afstatusbottomassist-left' => { 425 => 0x28 },
	'afstatusbottomassist-right' => { 425 => 0x2c },
	'afstatusbottomhorizontal' => { 422 => 0x10, 423 => 0x1c },
	'afstatusbottomvertical' => { 422 => 0x16, 423 => 0x26 },
	'afstatuscenter-10' => { 425 => 0x34 },
	'afstatuscenter-11' => { 425 => 0x36 },
	'afstatuscenter-12' => { 425 => 0x38 },
	'afstatuscenter-14' => { 425 => 0x3c },
	'afstatuscenter-7' => { 425 => 0x2e },
	'afstatuscenter-9' => { 425 => 0x32 },
	'afstatuscenter-horizontal' => { 425 => 0x30 },
	'afstatuscenter-vertical' => { 425 => 0x3a },
	'afstatuscenterf2-8' => { 425 => 0x4c },
	'afstatuscenterhorizontal' => { 181 => 0x2f, 422 => 0xc, 423 => 0x18, 426 => 0x2f, 427 => 0x2f },
	'afstatuscentervertical' => { 181 => 0xc, 422 => 0x14, 423 => 0x22, 426 => 0x25, 427 => 0x25 },
	'afstatusfarleft' => { 422 => 0x6, 425 => 0x26 },
	'afstatusfarlefthorizontal' => { 423 => 0x4 },
	'afstatusfarleftvertical' => { 423 => 0x12 },
	'afstatusfarright' => { 422 => 0x18, 425 => 0x44 },
	'afstatusfarrighthorizontal' => { 423 => 0x2c },
	'afstatusfarrightvertical' => { 423 => 0x34 },
	'afstatusleft' => { 181 => 0x2d, 422 => 0x2, 425 => 0x22, 426 => 0x2d, 427 => 0x2d },
	'afstatuslefthorizontal' => { 423 => 0x6 },
	'afstatusleftvertical' => { 423 => 0xe },
	'afstatuslower-left' => { 422 => 0x4, 425 => 0x24 },
	'afstatuslower-lefthorizontal' => { 423 => 0xa },
	'afstatuslower-leftvertical' => { 423 => 0x10 },
	'afstatuslower-middle' => { 422 => 0x22, 423 => 0x24 },
	'afstatuslower-right' => { 422 => 0x1e, 425 => 0x4a },
	'afstatuslower-righthorizontal' => { 423 => 0x32 },
	'afstatuslower-rightvertical' => { 423 => 0x3a },
	'afstatuslowerfarleft' => { 423 => 0x8 },
	'afstatuslowerfarright' => { 423 => 0x30 },
	'afstatusmiddlehorizontal' => { 181 => 0xa, 426 => 0x23, 427 => 0x23 },
	'afstatusnearleft' => { 422 => 0xe, 423 => 0x1a },
	'afstatusnearright' => { 422 => 0xa, 423 => 0x16 },
	'afstatusright' => { 181 => 0x31, 422 => 0x1c, 425 => 0x48, 426 => 0x31, 427 => 0x31 },
	'afstatusrighthorizontal' => { 423 => 0x2e },
	'afstatusrightvertical' => { 423 => 0x38 },
	'afstatustop' => { 181 => 0xe, 425 => 0x40, 426 => 0x27, 427 => 0x27 },
	'afstatustop-left' => { 181 => 0x10, 426 => 0x29, 427 => 0x29 },
	'afstatustop-right' => { 181 => 0x4, 426 => 0x1d, 427 => 0x1d },
	'afstatustopassist-left' => { 425 => 0x3e },
	'afstatustopassist-right' => { 425 => 0x42 },
	'afstatustophorizontal' => { 422 => 0x8, 423 => 0x14 },
	'afstatustopvertical' => { 422 => 0x12, 423 => 0x1e },
	'afstatusupper-left' => { 422 => 0x0, 425 => 0x20 },
	'afstatusupper-lefthorizontal' => { 423 => 0x2 },
	'afstatusupper-leftvertical' => { 423 => 0xc },
	'afstatusupper-middle' => { 422 => 0x20, 423 => 0x20 },
	'afstatusupper-right' => { 422 => 0x1a, 425 => 0x46 },
	'afstatusupper-righthorizontal' => { 423 => 0x2a },
	'afstatusupper-rightvertical' => { 423 => 0x36 },
	'afstatusupperfarleft' => { 423 => 0x0 },
	'afstatusupperfarright' => { 423 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 441 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 421 => 0x2 },
	'afwithshutter' => { 428 => 0x2a },
	'aggregateissuenumber' => { 520 => 'aggregateIssueNumber' },
	'aggregationtype' => { 520 => 'aggregationType' },
	'agreement' => { 523 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 139 => 0xe4e },
	'airplanemode' => { 240 => 0x722, 241 => 0x624, 242 => 0x654, 243 => 0x6bc },
	'aiservocontinuousshooting' => { 84 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 85 => 0x519 },
	'aiservoimagepriority' => { 85 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 85 => 0x51a },
	'aiservotrackingmethod' => { 85 => 0x504 },
	'aiservotrackingsensitivity' => { 84 => 0x14, 85 => 0x502 },
	'aisubjecttrackingmode' => { 318 => 0x309 },
	'album' => { 393 => ['albm',"\xa9alb"], 395 => 'album', 401 => ['albm',"\xa9alb"], 530 => 'album' },
	'albumartist' => { 180 => 'WM/AlbumArtist', 393 => 'aART', 401 => 'albr' },
	'albumcoverurl' => { 180 => 'WM/AlbumCoverURL' },
	'albumid' => { 393 => 'plID' },
	'albumtitle' => { 180 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 501 => 'AlreadyApplied', 503 => 'AlreadyApplied' },
	'alternatetitle' => { 520 => 'alternateTitle' },
	'alternatetitlea-lang' => { 520 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 520 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 520 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 198 => 0x6 },
	'alttapename' => { 530 => 'altTapeName' },
	'alttextaccessibility' => { 514 => 'AltTextAccessibility' },
	'alttimecode' => { 530 => 'altTimecode' },
	'alttimecodetimeformat' => { 530 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 530 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 530 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 404 => 0x5c },
	'ambientlight' => { 404 => 0x5e },
	'ambienttemperature' => { 120 => 0x9400, 402 => 0x14, 403 => 0x46, 404 => 0x50, 467 => 0x4, 508 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 402 => 0x13, 403 => 0x44, 404 => 0x4e },
	'analogbalance' => { 120 => 0xc627 },
	'analogcaptureiso' => { 139 => 0x89e },
	'analogisotable' => { 139 => 0x89d },
	'androidversion' => { 395 => 'com.android.version' },
	'angleadj' => { 104 => 0x10003, 110 => 0x8b },
	'angleinforoll' => { 497 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 497 => 'AngleInfoYaw' },
	'anti-blur' => { 441 => 0xb04b },
	'antialiasstrength' => { 120 => 0xc632 },
	'aperturelock' => { 299 => '38.2', 301 => '38.2', 302 => '38.2', 311 => '38.2', 312 => '38.2', 314 => 0xb8, 315 => 0xb8, 316 => 0xb8 },
	'aperturemode' => { 401 => 'apmd' },
	'aperturerange' => { 85 => 0x10d },
	'apertureringuse' => { 357 => '1.4' },
	'aperturesetting' => { 185 => 0x7, 428 => 0x30, 429 => 0x29, 430 => 0x1 },
	'aperturevalue' => { 94 => 0x2, 120 => 0x9202, 323 => 0x1002, 385 => 0x401, 507 => 'ApertureValue' },
	'appinfo' => { 480 => 'AppInfo' },
	'appinfoapplication' => { 480 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 480 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 480 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 327 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 395 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 393 => 'apID' },
	'applestoreaccounttype' => { 393 => 'akID' },
	'applestorecatalogid' => { 393 => 'cnID' },
	'applestorecountry' => { 393 => 'sfID' },
	'applicationkeystring' => { 139 => 0x400 },
	'applicationnotes' => { 120 => 0x2bc, 346 => 0x2bc },
	'applicationrecordversion' => { 132 => 0x0 },
	'applyshootingmeteringmode' => { 85 => 0x10e },
	'approved' => { 509 => 'Approved' },
	'approvedby' => { 509 => 'ApprovedBy' },
	'approximatefnumber' => { 336 => 0x313, 343 => 0x3406 },
	'approximatefocusdistance' => { 498 => 'ApproximateFocusDistance' },
	'appversion' => { 513 => 'AppVersion' },
	'aps-csizecapture' => { 460 => 0x114, 461 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 104 => 0x20914 },
	'armidentifier' => { 133 => 0x78 },
	'armversion' => { 133 => 0x7a },
	'arranger' => { 393 => "\xa9arg", 401 => "\xa9arg" },
	'arrangerkeywords' => { 401 => "\xa9ark" },
	'artdirector' => { 393 => "\xa9ard" },
	'artfilter' => { 318 => 0x529 },
	'artfiltereffect' => { 318 => 0x52f },
	'artist' => { 120 => 0x13b, 331 => 'Artist', 346 => 0x13b, 376 => 0x22e, 393 => "\xa9ART", 395 => 'artist', 401 => "\xa9ART", 526 => 'Artist', 530 => 'artist' },
	'artistid' => { 393 => 'atID' },
	'artmode' => { 114 => 0x301b },
	'artmodeparameters' => { 114 => 0x310b },
	'artwork' => { 395 => 'artwork' },
	'artworkcircadatecreated' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 515 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 515 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 322 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 322 => 0x1112, 376 => 0x80, 428 => 0x55, 429 => 0x55, 430 => 0xa, 454 => [0x192c,0x1a88], 455 => 0x192c, 456 => 0x1958, 457 => 0x192c, 458 => 0x188c },
	'assetid' => { 491 => 'AssetID' },
	'asshoticcprofile' => { 120 => 0xc68f },
	'asshotneutral' => { 120 => 0xc628 },
	'asshotpreprofilematrix' => { 120 => 0xc690 },
	'asshotprofilename' => { 120 => 0xc6f6 },
	'asshotwhitexy' => { 120 => 0xc629 },
	'assignbktbutton' => { 298 => '4.2', 299 => '16.1', 301 => '16.1', 302 => '16.1', 311 => '16.1', 312 => '16.1' },
	'assignfuncbutton' => { 85 => 0x70b },
	'assignmb-d17af-onbutton' => { 302 => '79.1' },
	'assignmb-d17funcbutton' => { 302 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 302 => '68.1' },
	'assignmb-d18af-onbutton' => { 312 => '79.1' },
	'assignmb-d18funcbutton' => { 312 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 312 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 301 => '75.1', 302 => '75.1', 312 => '75.1' },
	'assignmoviefunc2button' => { 301 => '82.1', 302 => '82.1', 312 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 301 => '75.2', 302 => '75.2', 312 => '75.2' },
	'assignmovierecordbutton' => { 299 => '43.2', 311 => '45.1', 314 => 0x9b, 315 => 0x9b, 316 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 301 => '45.1', 302 => '45.1', 312 => '45.1' },
	'assignmoviesubselector' => { 301 => '74.1', 302 => '74.1', 312 => '74.1' },
	'assignmoviesubselectorplusdials' => { 301 => '76.1', 302 => '76.1', 312 => '76.1' },
	'assignremotefnbutton' => { 299 => '54.1', 311 => '51.1' },
	'assistbuttonfunction' => { 83 => 0xd },
	'atcaptureusercrop' => { 139 => 0x943 },
	'attributionname' => { 499 => 'attributionName' },
	'attributionurl' => { 499 => 'attributionURL' },
	'audio' => { 341 => 0x20 },
	'audiobitrate' => { 68 => 0x6c, 515 => 'audioBitRate' },
	'audiobitratemode' => { 515 => 'audioBitRateMode' },
	'audiobitspersample' => { 515 => 'audioBitsPerSample' },
	'audiobutton' => { 315 => 0x17b, 316 => 0x193 },
	'audiobuttonplaybackmode' => { 315 => 0x1b9, 316 => 0x1d1 },
	'audiochannelcount' => { 515 => 'audioChannelCount' },
	'audiochannels' => { 68 => 0x70 },
	'audiochanneltype' => { 530 => 'audioChannelType' },
	'audiocompression' => { 85 => 0x816, 156 => 'Compression' },
	'audiocompressor' => { 530 => 'audioCompressor' },
	'audiodata' => { 483 => 'Data' },
	'audioduration' => { 132 => 0x99 },
	'audiogain' => { 395 => 'player.movie.audio.gain' },
	'audiomimetype' => { 483 => 'Mime' },
	'audiomoddate' => { 530 => 'audioModDate' },
	'audiooutcue' => { 132 => 0x9a },
	'audiosamplerate' => { 68 => 0x6e, 530 => 'audioSampleRate' },
	'audiosampletype' => { 530 => 'audioSampleType' },
	'audiosamplingrate' => { 132 => 0x97 },
	'audiosamplingresolution' => { 132 => 0x98 },
	'audiotype' => { 132 => 0x96 },
	'author' => { 158 => 'Author', 327 => 'Author', 331 => 'Author', 392 => 'Author', 393 => ['auth',"\xa9aut"], 395 => 'author', 401 => 'auth', 496 => 'author', 517 => 'Author', 528 => 'Author' },
	'authorsposition' => { 518 => 'AuthorsPosition' },
	'authorurl' => { 180 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 85 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 367 => '0.1' },
	'autobracket' => { 418 => 0x19 },
	'autobracketing' => { 128 => 0x1100, 376 => 0x18, 408 => 0x1007 },
	'autobracketingmode' => { 310 => '12.3' },
	'autobracketingset' => { 310 => '12.1' },
	'autobracketmodem' => { 298 => '21.2', 299 => '13.3', 301 => '13.2', 302 => '13.2', 307 => '26.2', 311 => '13.3', 312 => '13.2', 314 => 0x5f, 315 => 0x5f, 316 => 0x5f },
	'autobracketorder' => { 185 => 0x43, 298 => '21.3', 299 => '13.2', 301 => '13.1', 302 => '13.1', 307 => '26.3', 308 => '12.2', 309 => '2.2', 310 => '12.2', 311 => '13.2', 312 => '13.1', 313 => '13.2', 314 => 0x61, 315 => 0x61, 316 => 0x61 },
	'autobracketset' => { 298 => '21.1', 299 => '13.1', 303 => '11.1', 304 => '12.1', 305 => '12.1', 307 => '26.1', 308 => '12.1', 309 => '2.1', 311 => '13.1', 313 => '13.1' },
	'autobrightness' => { 501 => 'AutoBrightness', 503 => 'AutoBrightness' },
	'autocapturecriteria' => { 197 => 0x1 },
	'autocapturecriteriamotiondirection' => { 197 => 0x5f },
	'autocapturecriteriamotionsize' => { 197 => 0x64 },
	'autocapturecriteriamotionspeed' => { 197 => 0x63 },
	'autocapturecriteriasubjectsize' => { 197 => 0x69 },
	'autocapturecriteriasubjecttype' => { 197 => 0x6a },
	'autocapturedframe' => { 197 => 0x0 },
	'autocapturedistancefar' => { 197 => 0x4a },
	'autocapturedistancenear' => { 197 => 0x4e },
	'autocapturepreset' => { 243 => 0x746 },
	'autocapturerecordingtime' => { 197 => 0x37 },
	'autocapturewaittime' => { 197 => 0x38 },
	'autocontrast' => { 501 => 'AutoContrast', 503 => 'AutoContrast' },
	'autodistortioncontrol' => { 210 => 0x4, 239 => 0x143 },
	'autodynamicrange' => { 128 => 0x140b },
	'autoexposure' => { 501 => 'AutoExposure', 503 => 'AutoExposure' },
	'autoexposurebracketing' => { 78 => 0x10 },
	'autoflashisosensitivity' => { 301 => '38.5', 302 => '38.5', 312 => '38.5', 314 => 0x5b, 315 => 0x5b, 316 => 0x5b },
	'autofocus' => { 321 => 0x209 },
	'autofocusmoderestrictions' => { 314 => 0x107, 315 => 0x107, 316 => 0x11d },
	'autofp' => { 309 => '7.3', 313 => '31.4' },
	'autoiso' => { 78 => 0x1, 114 => 0x3008, 240 => 0x152, 241 => 0x142, 242 => 0x156, 243 => 0x156, 300 => '1.1', 309 => '1.1' },
	'autoisomax' => { 300 => '1.2', 309 => '1.2' },
	'autoisominshutterspeed' => { 300 => '1.3', 309 => '1.3' },
	'autolateralca' => { 501 => 'AutoLateralCA', 503 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 63 => 0x2, 85 => 0x204, 104 => 0x20500, 110 => 0x6f },
	'autolightingoptimizeron' => { 104 => '0x20500.0', 110 => 0x6e },
	'autoportraitframed' => { 441 => 0x2016 },
	'autoredeye' => { 291 => 0xfe28a44f },
	'autorotate' => { 78 => 0x1b },
	'autoshadows' => { 501 => 'AutoShadows', 503 => 'AutoShadows' },
	'autotone' => { 501 => 'AutoTone', 503 => 'AutoTone' },
	'autotonedigest' => { 501 => 'AutoToneDigest', 503 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 501 => 'AutoToneDigestNoSat', 503 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 501 => 'AutoWhiteVersion', 503 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 235 => 0x82 },
	'avaperturesetting' => { 357 => 0x13 },
	'averageblacklevel' => { 46 => 0xe7, 48 => 0xfb, 49 => 0x114, 50 => 0x146 },
	'averagelv' => { 188 => 0x38 },
	'avsettingwithoutlens' => { 85 => 0x707 },
	'azimuth' => { 166 => 'Azimuth' },
	'babyage' => { 341 => [0x8010,0x33] },
	'babyname' => { 341 => 0x66 },
	'backgroundalpha' => { 525 => 'bgalpha' },
	'balance' => { 395 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 357 => 0x15 },
	'baseiso' => { 78 => 0x2, 98 => 0x101c, 139 => 0x903, 343 => 0x312a, 473 => 0x6 },
	'baseisodaylight' => { 139 => 0x910 },
	'baseisoflash' => { 139 => 0x913 },
	'baseisofluorescent' => { 139 => 0x912 },
	'baseisotungsten' => { 139 => 0x911 },
	'baselineexposure' => { 120 => 0xc62a },
	'baselineexposureoffset' => { 120 => 0xc7a5 },
	'baselinenoise' => { 120 => 0xc62b },
	'baselinesharpness' => { 120 => 0xc62c },
	'baserenditionishdr' => { 512 => 'BaseRenditionIsHDR' },
	'baseurl' => { 528 => 'BaseURL' },
	'bass' => { 395 => 'player.movie.audio.bass' },
	'batterylevel' => { 341 => 0x38, 428 => 0x51, 432 => 0xc, 433 => 0x4, 434 => 0x4, 474 => [0x5,0x7] },
	'batterylevelgrip1' => { 474 => 0x6 },
	'batterylevelgrip2' => { 474 => 0x8 },
	'batteryorder' => { 298 => '12.5', 307 => '13.2', 308 => '2.1', 311 => '3.1' },
	'batterystate' => { 185 => 0x60, 428 => 0x50, 434 => 0x14 },
	'batterytemperature' => { 432 => 0x1, 434 => 0x2, 474 => 0x5 },
	'batterytype' => { 65 => 0x38, 404 => 0x66 },
	'batteryunknown' => { 432 => 0x2, 434 => 0x0 },
	'batteryvoltage' => { 139 => 0x408, 402 => 0x2a, 403 => 0x49, 404 => 0x62, 432 => 0x8 },
	'batteryvoltage1' => { 434 => 0x6 },
	'batteryvoltage2' => { 434 => 0x8 },
	'batteryvoltageavg' => { 404 => 0x64 },
	'bayergreensplit' => { 120 => 0xc62d },
	'bayerpattern' => { 138 => 0xf902, 189 => 0x17 },
	'beatsperminute' => { 393 => 'tmpo' },
	'beatspliceparams' => { 530 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 530 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 530 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 530 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 530 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 530 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 298 => '13.1', 299 => '5.4', 300 => '0.1', 303 => '2.1', 304 => '3.1', 305 => '3.1', 307 => '10.1', 309 => '0.1', 311 => '5.5', 313 => '4.1' },
	'beeppitch' => { 308 => '3.1' },
	'beepvolume' => { 308 => '4.5' },
	'bestqualityscale' => { 120 => 0xc65c },
	'bestshotmode' => { 114 => 0x3007 },
	'bitdepth' => { 163 => 'BitDepth', 189 => 0x11, 258 => 0x41 },
	'bitspercomponent' => { 134 => 0x87 },
	'bitspersample' => { 120 => 0x102, 346 => 0xa, 526 => 'BitsPerSample' },
	'blackacquirerows' => { 139 => 0x18ba },
	'blacklevel' => { 120 => [0x7310,0xc61a], 208 => 0x20, 235 => 0x3d, 323 => [0x401,0x1012], 385 => 0x21d, 448 => [0x7300,0x7310] },
	'blacklevel2' => { 322 => 0x600, 326 => 0x600 },
	'blacklevelblue' => { 346 => 0x1e },
	'blacklevelbottom' => { 139 => 0x3f0 },
	'blackleveldata' => { 385 => 0x223 },
	'blackleveldeltah' => { 120 => 0xc61b },
	'blackleveldeltav' => { 120 => 0xc61c },
	'blacklevelgreen' => { 346 => 0x1d },
	'blacklevelred' => { 346 => 0x1c },
	'blacklevelrepeatdim' => { 120 => 0xc619 },
	'blacklevelrough' => { 139 => 0x40e },
	'blacklevelroughafter' => { 139 => 0x416 },
	'blacklevels' => { 36 => 0x1d },
	'blackleveltop' => { 139 => 0x3ef },
	'blackpoint' => { 376 => 0x200 },
	'blacks2012' => { 501 => 'Blacks2012', 503 => 'Blacks2012' },
	'blacksadj' => { 477 => 0x9018 },
	'bleachbypasstoning' => { 376 => 0x7f },
	'blockshotafresponse' => { 301 => '1.5', 302 => '1.5', 312 => '1.5', 314 => 0x7, 315 => 0x7, 316 => 0x7 },
	'blogtitle' => { 520 => 'blogTitle' },
	'blogurl' => { 520 => 'blogURL' },
	'bluebalance' => { 323 => 0x1018, 346 => 0x12, 376 => 0x1b },
	'bluecurvelimits' => { 109 => 0x1fe },
	'bluecurvepoints' => { 108 => 0x79, 109 => 0x1d4 },
	'bluehsl' => { 104 => 0x20915 },
	'bluehue' => { 501 => 'BlueHue', 503 => 'BlueHue' },
	'bluesaturation' => { 501 => 'BlueSaturation', 503 => 'BlueSaturation' },
	'bluratinfinity' => { 487 => 'BlurAtInfinity' },
	'blurcontrol' => { 376 => 0x82 },
	'blurwarning' => { 128 => 0x1300 },
	'bodybatteryadload' => { 355 => 0x3 },
	'bodybatteryadnoload' => { 355 => 0x2 },
	'bodybatterystate' => { 355 => '1.1' },
	'bodybatteryvoltage1' => { 355 => 0x2 },
	'bodybatteryvoltage2' => { 355 => 0x4 },
	'bodybatteryvoltage3' => { 355 => 0x6 },
	'bodybatteryvoltage4' => { 355 => 0x8 },
	'bodyfirmware' => { 409 => 0x0 },
	'bodyfirmwareversion' => { 319 => 0x104, 320 => 0x100, 323 => 0x104 },
	'bodyserialnumber' => { 409 => 0x10 },
	'bookedition' => { 520 => 'bookEdition' },
	'bootloaderversion' => { 403 => 0x26 },
	'bracketbutton' => { 243 => 0x80c },
	'bracketbuttonplaybackmode' => { 243 => 0x816 },
	'bracketincrement' => { 240 => 0x22e, 241 => 0x21a, 242 => 0x22e, 243 => 0x22e },
	'bracketmode' => { 58 => 0x3 },
	'bracketprogram' => { 240 => 0x22c, 241 => 0x218, 242 => 0x22c, 243 => 0x22c },
	'bracketsequence' => { 114 => 0x301d },
	'bracketset' => { 240 => 0x22a, 241 => 0x216, 242 => 0x22a, 243 => 0x22a },
	'bracketsettings' => { 341 => 0x45 },
	'bracketshotnumber' => { 58 => 0x5, 357 => 0x9, 439 => 0x2b },
	'bracketshotnumber2' => { 439 => 0x2d },
	'bracketstep' => { 182 => 0xe },
	'bracketvalue' => { 58 => 0x4 },
	'brightness' => { 120 => 0xfe53, 157 => 'Brightness', 177 => 'Brightness', 182 => 0x2c, 250 => 0x34, 251 => 0x39, 252 => 0x41, 395 => 'player.movie.visual.brightness', 402 => 0x25, 404 => 0x54, 428 => 0x22, 441 => 0x2007, 501 => 'Brightness', 503 => 'Brightness' },
	'brightnessadj' => { 109 => 0x114, 284 => 0x0, 294 => 0x2d, 477 => 0x8018 },
	'brightnessvalue' => { 120 => 0x9203, 188 => [0x691,0x49c3], 323 => 0x1003, 446 => 0x1e, 450 => 0x1140, 451 => 0x1140, 452 => 0x111c, 453 => 0x1198, 454 => 0x1174, 455 => 0x102c, 456 => 0x224, 457 => 0x224, 458 => 0x219, 507 => 'BrightnessValue' },
	'buildnumber' => { 192 => 0x5500 },
	'bulbduration' => { 78 => 0x18 },
	'burstcount' => { 139 => 0x40d },
	'burstgroupid' => { 237 => 0x4 },
	'burstid' => { 484 => 'BurstID' },
	'burstmode' => { 141 => 0xa, 341 => 0x2a },
	'burstmode2' => { 141 => 0x18 },
	'burstprimary' => { 484 => 'BurstPrimary' },
	'burstshot' => { 418 => 0x34 },
	'burstspeed' => { 341 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 85 => 0x70a },
	'bwadjustment' => { 128 => 0x1049 },
	'bwfilter' => { 182 => 0x2a, 190 => 0x39 },
	'bwmagentagreen' => { 128 => 0x104b },
	'bwmode' => { 323 => 0x203 },
	'by-line' => { 132 => 0x50 },
	'by-linetitle' => { 132 => 0x55 },
	'bytecount' => { 520 => 'byteCount' },
	'c14configuration' => { 139 => 0x1964 },
	'cacheversion' => { 120 => 0xc7aa },
	'calibratedfocallength' => { 117 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 117 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 117 => 'CalibratedOpticalCenterY' },
	'calibration' => { 418 => [0x24,0x30] },
	'calibrationhistory' => { 139 => 0x9c9 },
	'calibrationilluminant1' => { 120 => 0xc65a },
	'calibrationilluminant2' => { 120 => 0xc65b },
	'calibrationilluminant3' => { 120 => 0xcd31 },
	'calibrationversion' => { 139 => 0x9c6 },
	'callforimage' => { 491 => 'CallForImage' },
	'camera' => { 480 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 401 => 'angl', 530 => 'cameraAngle' },
	'cameraappinfo' => { 480 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 480 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 480 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 480 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 485 => 'CameraBurstID' },
	'cameracalibration' => { 418 => 0x11f },
	'cameracalibration1' => { 120 => 0xc623 },
	'cameracalibration2' => { 120 => 0xc624 },
	'cameracalibration3' => { 120 => 0xcd32 },
	'cameracalibrationsig' => { 120 => 0xc6f3 },
	'cameracolorcalibration01' => { 37 => 0x0, 38 => 0x0 },
	'cameracolorcalibration02' => { 37 => 0x4, 38 => 0x5 },
	'cameracolorcalibration03' => { 37 => 0x8, 38 => 0xa },
	'cameracolorcalibration04' => { 37 => 0xc, 38 => 0xf },
	'cameracolorcalibration05' => { 37 => 0x10, 38 => 0x14 },
	'cameracolorcalibration06' => { 37 => 0x14, 38 => 0x19 },
	'cameracolorcalibration07' => { 37 => 0x18, 38 => 0x1e },
	'cameracolorcalibration08' => { 37 => 0x1c, 38 => 0x23 },
	'cameracolorcalibration09' => { 37 => 0x20, 38 => 0x28 },
	'cameracolorcalibration10' => { 37 => 0x24, 38 => 0x2d },
	'cameracolorcalibration11' => { 37 => 0x28, 38 => 0x32 },
	'cameracolorcalibration12' => { 37 => 0x2c, 38 => 0x37 },
	'cameracolorcalibration13' => { 37 => 0x30, 38 => 0x3c },
	'cameracolorcalibration14' => { 37 => 0x34, 38 => 0x41 },
	'cameracolorcalibration15' => { 37 => 0x38, 38 => 0x46 },
	'cameradepthmap' => { 480 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 480 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 480 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 480 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 480 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 480 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 480 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 480 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 480 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 480 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 480 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 480 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 395 => 'direction.facing' },
	'camerae-mountversion' => { 476 => 0xb },
	'cameraelevationangle' => { 120 => 0x9405, 508 => 'CameraElevationAngle' },
	'camerafilename' => { 491 => 'CameraFilename' },
	'camerafirmware' => { 120 => 0xa439 },
	'cameraid' => { 323 => 0x209, 401 => 'cmid', 417 => 0x209 },
	'cameraidentifier' => { 395 => 'camera.identifier' },
	'cameraimage' => { 480 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 480 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 480 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 480 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 480 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 480 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 480 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 480 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 480 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 480 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 480 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 480 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 480 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 480 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 35 => 0x10 },
	'cameralabel' => { 120 => 0xc7a1, 530 => 'cameraLabel' },
	'cameralightestimate' => { 480 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 480 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 480 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 480 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 480 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 491 => 'CameraMakeModel' },
	'cameramodel' => { 385 => 0x410, 530 => 'cameraModel' },
	'cameramodelid' => { 177 => 'CameraModelID' },
	'cameramodelrestriction' => { 501 => 'CameraModelRestriction', 503 => 'CameraModelRestriction' },
	'cameramotion' => { 395 => 'direction.motion' },
	'cameramove' => { 530 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 341 => 0x8f, 380 => 0x1, 385 => 0x100, 434 => [0x16,0x18], 464 => 0x28, 465 => 0x24, 466 => 0x29 },
	'cameraowner' => { 142 => 0xc353 },
	'cameraparameters' => { 323 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 116 => 0x9, 401 => "\xa9gpt" },
	'camerapointcloud' => { 480 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 480 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 480 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 480 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 480 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 480 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 480 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 480 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 480 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 480 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 480 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 480 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 480 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 501 => 'CameraProfile', 503 => 'CameraProfile' },
	'cameraprofiledigest' => { 501 => 'CameraProfileDigest', 503 => 'CameraProfileDigest' },
	'cameraprofiles' => { 518 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 518 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 518 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 518 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 518 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 518 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 518 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 518 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 518 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 518 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 518 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 518 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 518 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 518 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 518 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 518 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 110 => 0xe1 },
	'camerarawcontrast' => { 110 => 0xe3 },
	'camerarawhighlightpoint' => { 110 => 0xe6 },
	'camerarawlinear' => { 110 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 110 => 0xe8 },
	'camerarawoutputshadowpoint' => { 110 => 0xe9 },
	'camerarawsaturation' => { 110 => 0xe2 },
	'camerarawshadowpoint' => { 110 => 0xe7 },
	'camerarawsharpness' => { 110 => 0xe5 },
	'cameraroll' => { 116 => 0xb, 401 => "\xa9grl" },
	'cameras' => { 480 => 'Cameras' },
	'cameraserialnumber' => { 120 => 0xc62f, 179 => 'CameraSerialNumber', 491 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 318 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 34 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 78 => 0xc, 139 => 0x406, 322 => 0x1306, 336 => 0x320, 343 => 0x3402, 376 => 0x47, 415 => 0x43, 468 => 0x5 },
	'cameratemperature4' => { 381 => 0x14 },
	'cameratemperature5' => { 381 => 0x16 },
	'cameratemperaturerangemax' => { 122 => 0x5 },
	'cameratemperaturerangemin' => { 122 => 0x6 },
	'cameratrait' => { 480 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 78 => 0x1a, 323 => 0x207 },
	'cameratype2' => { 319 => 0x100 },
	'cameravendorinfo' => { 480 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 480 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 480 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 480 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 116 => 0xa, 401 => "\xa9gyw" },
	'camreverse' => { 117 => 'CamReverse' },
	'canondr4' => { 121 => 'CanonDR4' },
	'canonexposuremode' => { 35 => 0x14 },
	'canonfiledescription' => { 98 => 0x805 },
	'canonfilelength' => { 65 => 0xe },
	'canonfirmwareversion' => { 65 => 0x7, 98 => 0x80b },
	'canonflashinfo' => { 98 => 0x1028 },
	'canonflashmode' => { 35 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 35 => 0xa },
	'canonimagetype' => { 65 => 0x6, 98 => 0x815 },
	'canonlogversion' => { 64 => 0xb },
	'canonmodelid' => { 65 => 0x10, 98 => 0x1834 },
	'canonvrd' => { 121 => 'CanonVRD' },
	'caption' => { 496 => 'caption' },
	'caption-abstract' => { 132 => 0x78 },
	'captionsauthornames' => { 506 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 506 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 518 => 'CaptionWriter' },
	'captureframerate' => { 114 => 0x4001 },
	'captureheightnormal' => { 139 => 0x1839 },
	'capturelook' => { 139 => 0xc48 },
	'capturemode' => { 395 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 489 => 'CaptureSoftware' },
	'capturewidthnormal' => { 139 => 0x1838 },
	'capturewidthtest' => { 139 => 0x1842 },
	'cardshutterlock' => { 185 => 0x49 },
	'casioimagesize' => { 114 => 0x9 },
	'catalogsets' => { 132 => 0xff, 482 => 'CatalogSets', 494 => 'CatalogSets' },
	'categories' => { 65 => 0x23, 496 => 'categories' },
	'category' => { 132 => 0xf, 180 => 'WM/Category', 317 => 0x30, 393 => 'catg', 518 => 'Category' },
	'cbcrgain' => { 415 => 0xa036 },
	'cbcrgaindefault' => { 415 => 0xa035 },
	'cbcrmatrix' => { 415 => 0xa034 },
	'cbcrmatrixdefault' => { 415 => 0xa033 },
	'ccdboardversion' => { 336 => 0x331 },
	'ccdscanmode' => { 323 => 0x1039 },
	'ccdsensitivity' => { 281 => 0x6 },
	'ccdversion' => { 336 => 0x330 },
	'ccvavgluminancenits' => { 511 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 511 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 511 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 511 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 511 => 'ccv_white_xy' },
	'cellglobalid' => { 500 => 'cgi' },
	'celllength' => { 120 => 0x109 },
	'cellr' => { 500 => 'r' },
	'celltowerid' => { 500 => 'cellid' },
	'cellwidth' => { 120 => 0x108 },
	'centerafarea' => { 309 => '15.1' },
	'centerfocuspoint' => { 313 => '2.2' },
	'centerpixel' => { 139 => 0x40c },
	'centerweightedareasize' => { 298 => '7.1', 299 => '8.1', 301 => '8.1', 302 => '8.1', 306 => '7.1', 307 => '5.1', 308 => '7.1', 309 => '6.3', 311 => '8.1', 312 => '8.1', 313 => '8.1', 314 => 0x1f, 315 => 0x1f, 316 => 0x1f },
	'certificate' => { 534 => 'Certificate' },
	'cfainterpolationalgorithm' => { 139 => 0xe60 },
	'cfainterpolationmetric' => { 139 => 0xe61 },
	'cfaoffsetcols' => { 139 => 0xc71 },
	'cfaoffsetrows' => { 139 => 0xc6f },
	'cfapattern' => { 120 => 0xa302, 346 => 0x9, 507 => 'CFAPattern' },
	'cfapattern2' => { 120 => 0x828e },
	'cfapatterncolumns' => { 507 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 507 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 507 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 120 => 0x828d },
	'cfazipperfixthreshold' => { 139 => 0xe62 },
	'channel' => { 520 => 'channel' },
	'channela-lang' => { 520 => [\'channel','channelA-lang'] },
	'channelchannel' => { 520 => [\'channel','channelChannel'] },
	'channels' => { 156 => 'Channels' },
	'channelsubchannel1' => { 520 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 520 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 520 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 520 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 401 => 'chpl' },
	'checkmark' => { 104 => 0x10101, 109 => 0x26a },
	'checkmark2' => { 110 => 0x8e },
	'childfontfiles' => { 535 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 298 => '10.3', 299 => '11.2', 314 => 0x10b, 315 => 0x10b, 316 => 0x121 },
	'chromablurradius' => { 120 => 0xc631 },
	'chromanoisecolorspace' => { 139 => 0xe6d },
	'chromanoiseedgemapthresh' => { 139 => 0xe6c },
	'chromanoisehighfthresh' => { 139 => 0xe6a },
	'chromanoiselowfthresh' => { 139 => 0xe6b },
	'chromaticaberration' => { 104 => 0x20703, 110 => 0x66, 415 => 0xa051 },
	'chromaticaberrationb' => { 501 => 'ChromaticAberrationB', 503 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 104 => 0x20708, 110 => 0x6b },
	'chromaticaberrationcorr' => { 80 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 120 => 0x7034, 366 => 0x1, 477 => 0x900d },
	'chromaticaberrationcorrparams' => { 120 => 0x7035, 472 => 0x66a, 473 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 104 => '0x20703.0', 110 => 0x62 },
	'chromaticaberrationr' => { 501 => 'ChromaticAberrationR', 503 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 104 => 0x20707, 110 => 0x6a },
	'chromaticaberrationsetting' => { 81 => 0x6 },
	'chrominancenoisereduction' => { 104 => 0x20601, 110 => 0x5e, 418 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 110 => 0x60 },
	'circadatecreated' => { 515 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 501 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 503 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 501 => 'CircularGradientBasedCorrections', 503 => 'CircularGradientBasedCorrections' },
	'city' => { 132 => 0x5a, 162 => 'City', 341 => 0x6d, 518 => 'City' },
	'city2' => { 341 => 0x80 },
	'clarity' => { 128 => 0x100f, 251 => 0x35, 252 => 0x3d, 441 => 0x2036, 501 => 'Clarity', 503 => 'Clarity' },
	'clarity2012' => { 501 => 'Clarity2012', 503 => 'Clarity2012' },
	'claritycontrol' => { 376 => 0x96 },
	'classification' => { 401 => 'clsf' },
	'classifystate' => { 132 => 0xe1 },
	'clearretouch' => { 341 => 0x7c },
	'clearretouchvalue' => { 341 => 0xa3 },
	'client' => { 530 => 'client' },
	'clientname' => { 509 => 'ClientName' },
	'clipboardaspectratio' => { 501 => 'ClipboardAspectRatio', 503 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 501 => 'ClipboardOrientation', 503 => 'ClipboardOrientation' },
	'clipfilename' => { 401 => 'clfn' },
	'clipid' => { 401 => 'clid' },
	'clmodeshootingspeed' => { 298 => '10.2', 299 => '11.3', 301 => '11.2', 302 => '11.2', 307 => '11.2', 308 => '10.2', 311 => '11.2', 312 => '11.2', 313 => '11.1', 314 => 0x3b, 315 => 0x3b, 316 => 0x3b },
	'cluster' => { 501 => 'Cluster', 503 => 'Cluster' },
	'cmcontrast' => { 326 => 0x2022 },
	'cmddialsreverserotation' => { 314 => 0xba, 315 => 0xba, 316 => 0xba },
	'cmexposurecompensation' => { 326 => 0x2000 },
	'cmhue' => { 326 => 0x2021 },
	'cmsaturation' => { 326 => 0x2020 },
	'cmsharpness' => { 326 => 0x2023 },
	'cmwhitebalance' => { 326 => 0x2001 },
	'cmwhitebalancecomp' => { 326 => 0x2002 },
	'cmwhitebalancegraypoint' => { 326 => 0x2010 },
	'codec' => { 170 => 'Codec' },
	'codedcharacterset' => { 133 => 0x5a },
	'codeversion' => { 401 => 'cver' },
	'collection' => { 331 => 'Collection' },
	'collectionname' => { 171 => [\'Collections','CollectionsCollectionName'], 401 => 'coll' },
	'collections' => { 171 => 'Collections', 496 => 'collections' },
	'collectionuri' => { 171 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 395 => 'player.movie.visual.color', 519 => 'color' },
	'coloraberrationcontrol' => { 291 => 0xc89224b },
	'coloradjustment' => { 418 => 0x14 },
	'coloradjustmentmode' => { 417 => 0x210 },
	'coloranta' => { 535 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 535 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 535 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 535 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 535 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 535 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 535 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 535 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 535 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 535 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 535 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 535 => 'Colorants' },
	'colorantswatchname' => { 535 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 535 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 535 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 535 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 157 => 'ColorBalance' },
	'colorbalanceadj' => { 291 => 0x76a43202 },
	'colorbalanceblue' => { 182 => 0x1e },
	'colorbalancegreen' => { 182 => 0x1d },
	'colorbalancered' => { 182 => 0x1c },
	'colorbalanceversion' => { 207 => 0x4, 208 => 0x4, 209 => 0x0 },
	'colorblur' => { 110 => 0x65 },
	'colorbluron' => { 104 => 0x20704 },
	'colorbooster' => { 291 => 0x5f0e7d23 },
	'colorboostlevel' => { 285 => 0x1 },
	'colorboosttype' => { 285 => 0x0 },
	'colorchromeeffect' => { 128 => 0x1048 },
	'colorchromefxblue' => { 128 => 0x104e },
	'colorclass' => { 387 => 0xde, 388 => 'ColorClass' },
	'colorcompensationfilter' => { 185 => [0x3a,0x5f], 187 => 0x111, 441 => 0xb022 },
	'colorcompensationfiltercustom' => { 428 => 0xd, 429 => 0xc },
	'colorcompensationfilterset' => { 428 => 0x8, 429 => 0x7, 430 => 0x18, 446 => 0xf },
	'colorcontrol' => { 323 => 0x102b },
	'colorcorrection' => { 477 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 318 => 0x532 },
	'colordataversion' => { 42 => 0x0, 43 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0 },
	'coloreffect' => { 341 => 0x28 },
	'colorfilter' => { 113 => 0x17, 114 => 0x3017, 182 => 0x29, 190 => [0x38,0x4d,0x4f], 383 => 0x17 },
	'colorgain' => { 258 => 0x51 },
	'colorgradeblending' => { 501 => 'ColorGradeBlending', 503 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 501 => 'ColorGradeGlobalHue', 503 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 501 => 'ColorGradeGlobalLum', 503 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 501 => 'ColorGradeGlobalSat', 503 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 501 => 'ColorGradeHighlightLum', 503 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 501 => 'ColorGradeMidtoneHue', 503 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 501 => 'ColorGradeMidtoneLum', 503 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 501 => 'ColorGradeMidtoneSat', 503 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 501 => 'ColorGradeShadowLum', 503 => 'ColorGradeShadowLum' },
	'colorhue' => { 104 => 0x20900, 235 => 0x8d },
	'colorimetricreference' => { 120 => 0xc6bf },
	'colorlabel' => { 506 => 'ColorLabel' },
	'colormatrix' => { 64 => 0xa, 322 => 0x200, 323 => 0x1011, 415 => 0xa030 },
	'colormatrix1' => { 120 => 0xc621, 385 => 0x106 },
	'colormatrix2' => { 120 => 0xc622, 326 => 0x200, 385 => 0x226 },
	'colormatrix3' => { 120 => 0xcd33 },
	'colormatrixa' => { 376 => 0x203 },
	'colormatrixa2' => { 376 => 0x21c },
	'colormatrixadobergb' => { 415 => 0xa032 },
	'colormatrixb' => { 376 => 0x204 },
	'colormatrixb2' => { 376 => 0x21d },
	'colormatrixnumber' => { 323 => 0x1019 },
	'colormatrixsrgb' => { 415 => 0xa031 },
	'colormode' => { 114 => 0x3015, 128 => 0x1210, 141 => 0x66, 182 => 0x28, 185 => 0x16, 187 => 0x101, 188 => 0x36, 190 => 0x7, 235 => 0x3, 281 => 0x4, 341 => 0x32, 418 => 0x2c, 441 => 0xb029, 518 => 'ColorMode' },
	'colormoirereduction' => { 104 => 0x20670, 292 => 0x15 },
	'colormoirereductionmode' => { 292 => 0x5 },
	'colormoirereductionon' => { 104 => '0x20670.0' },
	'colornoisereduction' => { 477 => 0x8029, 501 => 'ColorNoiseReduction', 503 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 501 => 'ColorNoiseReductionDetail', 503 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 292 => 0x18 },
	'colornoisereductionsharpness' => { 292 => 0x1c },
	'colornoisereductionsmoothness' => { 501 => 'ColorNoiseReductionSmoothness', 503 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 124 => 0x2 },
	'colorprofile' => { 182 => 0x33 },
	'colorprofilesettings' => { 318 => 0x539 },
	'colorrepresentation' => { 134 => 0x3c },
	'colorsaturationadj' => { 104 => 0x20305 },
	'colorsequence' => { 134 => 0x41 },
	'colorspace' => { 52 => 0x3, 65 => 0xb4, 98 => 0x10b4, 120 => 0xa001, 136 => 0x3, 163 => 'ColorSpace', 183 => 0x2f, 184 => 0x25, 185 => 0x17, 235 => 0x1e, 318 => 0x507, 376 => 0x37, 415 => 0xa011, 418 => 0xb, 428 => 0x1b, 429 => 0x83, 430 => 0xe, 446 => 0x6, 507 => 'ColorSpace' },
	'colorspace2' => { 64 => 0x9 },
	'colorspecapproximation' => { 136 => 0x2 },
	'colorspecdata' => { 136 => 0x3 },
	'colorspecmethod' => { 136 => 0x0 },
	'colorspecprecedence' => { 136 => 0x1 },
	'colortempasshot' => { 39 => 0x4, 40 => 0x7, 41 => 0x1d, 42 => 0x59, 43 => 0x6d, 44 => 0x26, 45 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x43, 51 => 0x4b },
	'colortempauto' => { 39 => 0x9, 40 => 0xf, 41 => 0x22, 42 => 0x5e, 43 => 0x72, 44 => 0x1c, 45 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x48, 51 => 0x50 },
	'colortempcloudy' => { 39 => 0x22, 40 => 0x37, 41 => 0x31, 42 => 0xa4, 43 => 0xdb, 44 => 0x35, 45 => 0x5c, 48 => 0x75, 49 => 0x8e, 50 => 0x93, 51 => 0x96, 376 => 0x55 },
	'colortempcustom' => { 45 => 0x84 },
	'colortempcustom1' => { 41 => 0x45 },
	'colortempcustom2' => { 41 => 0x4a },
	'colortempdaylight' => { 39 => 0x18, 40 => 0x27, 41 => 0x27, 42 => 0x9a, 43 => 0xd1, 44 => 0x2b, 45 => 0x52, 48 => 0x6b, 49 => 0x84, 50 => 0x89, 51 => 0x8c, 376 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 65 => 0xae, 75 => 0x9, 98 => 0x10ae, 128 => 0x1005, 139 => 0x846, 157 => 'ColorTemperature', 183 => [0x6e,0x49], 184 => 0x3f, 185 => [0x39,0x5e], 187 => 0x10b, 190 => [0x3c,0x4c,0x4e], 336 => 0x321, 376 => 0x50, 408 => 0x1308, 441 => 0xb021, 501 => 'Temperature', 503 => 'Temperature' },
	'colortemperatureadj' => { 477 => 0x8013 },
	'colortemperatureauto' => { 235 => 0x4f },
	'colortemperaturebg' => { 323 => 0x1013 },
	'colortemperaturecustom' => { 428 => 0xc, 429 => 0xb },
	'colortemperaturerg' => { 323 => 0x1014 },
	'colortemperatureset' => { 428 => 0x7, 429 => 0x6 },
	'colortemperaturesetting' => { 185 => 0x25, 430 => 0x17, 446 => 0xe },
	'colortempflash' => { 39 => 0x36, 40 => 0x57, 41 => 0x40, 42 => 0xb8, 43 => 0xef, 44 => 0x49, 45 => 0x70, 48 => 0x89, 49 => 0xa2, 50 => 0xa7, 51 => 0xaa, 376 => 0x5a },
	'colortempflashdata' => { 45 => 0x24a },
	'colortempfluorescent' => { 39 => 0x2c, 40 => 0x47, 41 => 0x3b, 42 => 0xae, 43 => 0xe5, 44 => 0x3f, 45 => 0x66, 48 => 0x7f, 49 => 0x98, 50 => 0x9d, 51 => 0xa0 },
	'colortempfluorescentd' => { 376 => 0x57 },
	'colortempfluorescentn' => { 376 => 0x58 },
	'colortempfluorescentw' => { 376 => 0x59 },
	'colortempkelvin' => { 39 => 0x31, 40 => 0x4f, 42 => 0xb3, 43 => 0xea, 44 => 0x44, 45 => 0x6b, 48 => 0x84, 49 => 0x9d, 50 => 0xa2, 51 => 0xa5, 341 => 0x44, 408 => 0x1307 },
	'colortempmeasured' => { 39 => 0xe, 40 => 0x17, 42 => 0x63, 43 => 0x77, 45 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x4d, 51 => 0x55 },
	'colortemppc1' => { 44 => 0x94, 45 => 0x75 },
	'colortemppc2' => { 44 => 0x99, 45 => 0x7a },
	'colortemppc3' => { 44 => 0x9e, 45 => 0x7f },
	'colortempshade' => { 39 => 0x1d, 40 => 0x2f, 41 => 0x2c, 42 => 0x9f, 43 => 0xd6, 44 => 0x30, 45 => 0x57, 48 => 0x70, 49 => 0x89, 50 => 0x8e, 51 => 0x91, 376 => 0x54 },
	'colortemptungsten' => { 39 => 0x27, 40 => 0x3f, 41 => 0x36, 42 => 0xa9, 43 => 0xe0, 44 => 0x3a, 45 => 0x61, 48 => 0x7a, 49 => 0x93, 50 => 0x98, 51 => 0x9b, 376 => 0x56 },
	'colortempunknown' => { 39 => 0x13, 40 => 0x1f, 42 => 0x68, 43 => 0x7c, 44 => 0x21, 48 => 0x52, 49 => 0x52, 50 => 0x52, 51 => 0x5a },
	'colortempunknown10' => { 39 => 0x63, 40 => 0x9f, 42 => 0x95, 43 => 0xa9, 44 => 0x76, 48 => 0xa2, 49 => 0x7f, 50 => 0x7f, 51 => 0x87 },
	'colortempunknown11' => { 39 => 0x68, 40 => 0xa7, 42 => 0xbd, 43 => [0xae,0xb3], 44 => 0x7b, 48 => 0xa7, 49 => 0xa7, 50 => 0x84, 51 => 0xaf },
	'colortempunknown12' => { 39 => 0x6d, 40 => 0xaf, 42 => 0xc2, 43 => 0xb8, 44 => 0x80, 48 => 0xac, 49 => 0xac, 50 => 0xac, 51 => 0xb4 },
	'colortempunknown13' => { 39 => 0x72, 40 => 0xb7, 42 => 0xc7, 43 => 0xbd, 44 => 0x85, 48 => 0xb1, 49 => 0xb1, 50 => 0xb1, 51 => 0xb9 },
	'colortempunknown14' => { 42 => 0xcc, 43 => 0xc2, 44 => 0x8a, 48 => 0xb6, 49 => 0xb6, 50 => 0xb6, 51 => 0xbe },
	'colortempunknown15' => { 42 => 0xd1, 43 => 0xc7, 44 => 0x8f, 48 => 0xbb, 49 => 0xbb, 50 => 0xbb, 51 => 0xc3 },
	'colortempunknown16' => { 42 => 0xd6, 43 => 0xcc, 44 => 0xa3, 49 => 0xc0, 50 => 0xc0, 51 => 0xc8 },
	'colortempunknown17' => { 42 => 0xdb, 43 => 0xf4, 49 => 0xc5, 50 => 0xc5, 51 => 0xcd },
	'colortempunknown18' => { 42 => 0xe0, 43 => 0xf9, 49 => 0xca, 50 => 0xca, 51 => 0xd2 },
	'colortempunknown19' => { 42 => 0xe5, 43 => 0xfe, 49 => 0xcf, 50 => 0xcf, 51 => 0xd7 },
	'colortempunknown2' => { 39 => 0x3b, 40 => 0x5f, 42 => 0x6d, 43 => 0x81, 44 => 0x4e, 48 => 0x57, 49 => 0x57, 50 => 0x57, 51 => 0x5f },
	'colortempunknown20' => { 42 => 0xea, 43 => 0x103, 49 => 0xd4, 50 => 0xd4, 51 => 0xdc },
	'colortempunknown21' => { 42 => 0xef, 43 => 0x108, 50 => 0xd9, 51 => 0xe1 },
	'colortempunknown22' => { 42 => 0xf4, 43 => 0x10d, 50 => 0xde, 51 => 0xe6 },
	'colortempunknown23' => { 42 => 0xf9, 43 => 0x112, 50 => 0xe3, 51 => 0xeb },
	'colortempunknown24' => { 42 => 0xfe, 43 => 0x117, 50 => 0xe8, 51 => 0xf0 },
	'colortempunknown25' => { 42 => 0x103, 43 => 0x11c, 50 => 0xed, 51 => 0xf5 },
	'colortempunknown26' => { 42 => 0x108, 43 => 0x121, 50 => 0xf2, 51 => 0xfa },
	'colortempunknown27' => { 42 => 0x10d, 43 => 0x126, 50 => 0xf7, 51 => 0xff },
	'colortempunknown28' => { 42 => 0x112, 50 => 0xfc, 51 => 0x104 },
	'colortempunknown29' => { 42 => 0x117, 50 => 0x101, 51 => 0x109 },
	'colortempunknown3' => { 39 => 0x40, 40 => 0x67, 42 => 0x72, 43 => 0x86, 44 => 0x53, 48 => 0x5c, 49 => 0x5c, 50 => 0x5c, 51 => 0x64 },
	'colortempunknown30' => { 50 => 0x106 },
	'colortempunknown4' => { 39 => 0x45, 40 => 0x6f, 42 => 0x77, 43 => 0x8b, 44 => 0x58, 48 => 0x61, 49 => 0x61, 50 => 0x61, 51 => 0x69 },
	'colortempunknown5' => { 39 => 0x4a, 40 => 0x77, 42 => 0x7c, 43 => 0x90, 44 => 0x5d, 48 => 0x66, 49 => 0x66, 50 => 0x66, 51 => 0x6e },
	'colortempunknown6' => { 39 => 0x4f, 40 => 0x7f, 42 => 0x81, 43 => 0x95, 44 => 0x62, 48 => 0x8e, 49 => 0x6b, 50 => 0x6b, 51 => 0x73 },
	'colortempunknown7' => { 39 => 0x54, 40 => 0x87, 42 => 0x86, 43 => 0x9a, 44 => 0x67, 48 => 0x93, 49 => 0x70, 50 => 0x70, 51 => 0x78 },
	'colortempunknown8' => { 39 => 0x59, 40 => 0x8f, 42 => 0x8b, 43 => 0x9f, 44 => 0x6c, 48 => 0x98, 49 => 0x75, 50 => 0x75, 51 => 0x7d },
	'colortempunknown9' => { 39 => 0x5e, 40 => 0x97, 42 => 0x90, 43 => 0xa4, 44 => 0x71, 48 => 0x9d, 49 => 0x7a, 50 => 0x7a, 51 => 0x82 },
	'colortint' => { 340 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 35 => 0x2a, 52 => 0x2, 64 => 0x8 },
	'colortoneadj' => { 104 => 0x20304, 109 => 0x11e },
	'colortoneauto' => { 72 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 71 => 0x6c, 72 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 71 => 0x3c, 72 => 0x3c },
	'colortonemonochrome' => { 71 => 0x84, 72 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 71 => 0x54, 72 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 71 => 0x24, 72 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 71 => 0xc, 72 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 71 => 0x9c, 72 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 71 => 0xb4, 72 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 71 => 0xcc, 72 => 0xe4 },
	'comlenblksize' => { 139 => 0xfde8 },
	'commanddialplaybackmode' => { 314 => 0x1cb, 315 => 0x1cb, 316 => 0x1e3 },
	'commanddials' => { 309 => '5.1' },
	'commanddialsaperturesetting' => { 298 => '17.3', 299 => '18.3', 301 => '18.3', 302 => '18.3', 307 => '33.3', 308 => '17.3', 311 => '18.3', 312 => '18.3' },
	'commanddialschangemainsub' => { 298 => '17.2', 299 => '18.1', 301 => '18.1', 302 => '18.1', 307 => '33.2', 308 => '17.2', 311 => '18.1', 312 => '18.1' },
	'commanddialsmenuandplayback' => { 298 => '17.4', 299 => '18.2', 301 => '18.2', 302 => '18.2', 307 => '33.4', 308 => '17.4', 311 => '18.2', 312 => '18.2' },
	'commanddialsreverserotation' => { 298 => '17.1', 299 => '6.4', 301 => '6.2', 302 => '6.2', 303 => '16.2', 304 => '17.2', 307 => '33.1', 308 => '17.1', 311 => '6.2', 312 => '6.2', 313 => '18.1' },
	'commanderchannel' => { 309 => '10.2', 310 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 309 => '13.1', 310 => '31.1' },
	'commandergroupa_ttlcomp' => { 313 => '32.1' },
	'commandergroupamanualoutput' => { 309 => '13.2', 310 => '28.2' },
	'commandergroupamode' => { 309 => '11.2', 310 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 309 => '14.1', 310 => '32.1' },
	'commandergroupb_ttlcomp' => { 313 => '33.1' },
	'commandergroupbmanualoutput' => { 309 => '14.2', 310 => '29.2' },
	'commandergroupbmode' => { 309 => '11.3', 310 => '29.1' },
	'commanderinternalflash' => { 309 => '11.1', 310 => '27.1' },
	'commanderinternalmanualoutput' => { 309 => '12.2', 310 => '27.2' },
	'commanderinternalttlchannel' => { 307 => '18.2' },
	'commanderinternalttlcomp' => { 309 => '12.1', 310 => '30.2', 313 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 307 => '20.1', 308 => '26.1' },
	'commanderinternalttlcompgroupa' => { 307 => '21.1', 308 => '27.1' },
	'commanderinternalttlcompgroupb' => { 307 => '22.1', 308 => '28.1' },
	'comment' => { 0 => 0x2, 121 => 'Comment', 158 => 'Comment', 331 => 'Comment', 393 => "\xa9cmt", 395 => 'comment', 401 => "\xa9cmt" },
	'compass' => { 411 => 0x4 },
	'compatibleversion' => { 501 => 'CompatibleVersion', 503 => 'CompatibleVersion' },
	'compilation' => { 393 => 'cpil' },
	'compimageimagespersequence' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 508 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 520 => 'complianceProfile' },
	'componentsconfiguration' => { 120 => 0x9101, 163 => 'Components', 507 => 'ComponentsConfiguration' },
	'componentversion' => { 98 => 0x80c },
	'composer' => { 180 => 'WM/Composer', 393 => ["\xa9com","\xa9wrt"], 401 => ["\xa9com","\xa9wrt"], 530 => 'composer' },
	'composerid' => { 393 => 'cmID' },
	'composerkeywords' => { 401 => "\xa9cok" },
	'compositeimage' => { 120 => 0xa460, 508 => 'CompositeImage' },
	'compositeimagecount' => { 120 => 0xa461, 508 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 120 => 0xa462, 508 => 'CompositeImageExposureTimes' },
	'composition' => { 491 => 'Composition' },
	'compositionadjust' => { 375 => '0.1' },
	'compositionadjustrotation' => { 375 => 0x7 },
	'compositionadjustx' => { 375 => 0x5 },
	'compositionadjusty' => { 375 => 0x6 },
	'compressedbitsperpixel' => { 120 => 0x9102, 507 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 187 => 0x40, 323 => 0x40 },
	'compression' => { 120 => 0x103, 346 => 0xb, 526 => 'Compression' },
	'compressionfactor' => { 318 => 0x50d },
	'compressionformat' => { 64 => 0x4 },
	'compressionratio' => { 163 => 'Compression', 323 => 0x1034 },
	'compressorversion' => { 401 => 'CNCV' },
	'condadobvfactor' => { 139 => 0xf3e },
	'condadodaybvthresh' => { 139 => 0xf3c },
	'condadodayoffsets' => { 139 => 0xf42 },
	'condadofluoffsets' => { 139 => 0xf44 },
	'condadofluthresh' => { 139 => 0xf41 },
	'condadoillfactor' => { 139 => 0xf3f },
	'condadoneurange' => { 139 => 0xf3d },
	'condadotunoffsets' => { 139 => 0xf43 },
	'condadotunthresh' => { 139 => 0xf40 },
	'conductor' => { 180 => 'WM/Conductor', 393 => "\xa9con" },
	'confidence' => { 486 => 'Confidence' },
	'confidencelevel' => { 497 => 'ConfidenceLevel' },
	'confidencemime' => { 486 => 'ConfidenceMime' },
	'constrainedcropheight' => { 109 => 0x266, 387 => 0xd6 },
	'constrainedcropwidth' => { 109 => 0x262, 387 => 0xd5 },
	'contact' => { 132 => 0x76 },
	'contactinfo' => { 501 => 'ContactInfo', 503 => 'ContactInfo', 519 => 'contactInfo' },
	'container' => { 480 => 'Container' },
	'containerdirectory' => { 480 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 480 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 480 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 480 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 480 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 480 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 515 => 'ContainerFormat' },
	'containerformatidentifier' => { 515 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 515 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 393 => "\xa9day", 401 => ['@day',"\xa9day"] },
	'contentdistributor' => { 180 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 401 => 'cdis' },
	'contentid' => { 401 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 395 => 'content.identifier' },
	'contentlocationcode' => { 132 => 0x1a },
	'contentlocationname' => { 132 => 0x1b },
	'contenttype' => { 520 => 'contentType' },
	'continuousbracketing' => { 185 => 0x20 },
	'continuousdrive' => { 35 => 0x5 },
	'continuousmodedisplay' => { 314 => 0x51, 315 => 0x51, 316 => 0x51 },
	'continuousmodeliveview' => { 312 => '77.2' },
	'continuousshootingspeed' => { 85 => 0x610 },
	'continuousshotlimit' => { 85 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 35 => 0xd, 113 => 0xc, 114 => [0x3012,0x20], 120 => [0xa408,0xfe54], 128 => [0x1004,0x1006], 157 => 'Contrast', 177 => 'Contrast', 182 => 0x20, 183 => 0x31, 184 => 0x27, 185 => 0x19, 190 => 0x2, 250 => 0x33, 251 => 0x37, 252 => 0x3f, 323 => 0x1029, 341 => 0x39, 343 => 0x300a, 376 => 0x20, 383 => 0xc, 395 => 'player.movie.visual.contrast', 402 => 0x24, 404 => 0x52, 408 => 0x1012, 418 => 0xd, 428 => 0x1d, 429 => 0x1a, 441 => 0x2004, 501 => 'Contrast', 503 => 'Contrast', 507 => 'Contrast' },
	'contrast2012' => { 501 => 'Contrast2012', 503 => 'Contrast2012' },
	'contrastadj' => { 104 => 0x20303, 109 => 0x115, 294 => 0x2c, 477 => 0x8017 },
	'contrastauto' => { 72 => 0x90 },
	'contrastcurve' => { 235 => 0x8c },
	'contrastdetectaf' => { 194 => 0x4 },
	'contrastdetectafarea' => { 376 => 0x231 },
	'contrastdetectafinfocus' => { 194 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 71 => 0x60, 72 => 0x60 },
	'contrasthighlight' => { 376 => 0x6d },
	'contrasthighlightshadowadj' => { 376 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 71 => 0x30, 72 => 0x30 },
	'contrastmode' => { 341 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 71 => 0x78, 72 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 71 => 0x48, 72 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 71 => 0x18, 72 => 0x18 },
	'contrastsetting' => { 318 => 0x505, 326 => 0x1012, 430 => 0x10, 446 => 0x8 },
	'contrastshadow' => { 376 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 71 => 0x0, 72 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 71 => 0x90, 72 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 71 => 0xa8, 72 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 71 => 0xc0, 72 => 0xd8 },
	'contributedmedia' => { 530 => 'contributedMedia' },
	'contributedmediaduration' => { 530 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 530 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 530 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 530 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 530 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 530 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 530 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 530 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 530 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 530 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 504 => 'contributor', 515 => 'Contributor' },
	'contributoridentifier' => { 515 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 515 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 515 => [\'Contributor','ContributorRole'] },
	'contributors' => { 158 => 'Contributors' },
	'controldialset' => { 185 => 0x46 },
	'controlledvocabularyterm' => { 515 => 'CVterm' },
	'controllerboardversion' => { 336 => 0x332 },
	'controlmode' => { 78 => 0x12 },
	'controlringresponse' => { 314 => 0x1d5, 315 => 0x1d5, 316 => 0x1ed },
	'controlringrotation' => { 85 => 0x712 },
	'conversionlens' => { 319 => 0x403, 341 => 0x35 },
	'converter' => { 120 => 0xfe4d, 281 => 0xb, 501 => 'Converter', 503 => 'Converter' },
	'converttograyscale' => { 501 => 'ConvertToGrayscale', 503 => 'ConvertToGrayscale' },
	'cookingequipment' => { 522 => 'cookingEquipment' },
	'cookingmethod' => { 522 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 120 => 0x8298, 158 => 'Copyright', 331 => 'Copyright', 346 => 0x8298, 376 => 0x22f, 392 => 'Copyright', 393 => ['cprt',"\xa9cpy"], 395 => 'copyright', 401 => ['cprt',"\xa9cpy"], 501 => 'Copyright', 503 => 'Copyright', 517 => 'Copyright', 523 => 'copyright', 526 => 'Copyright', 530 => 'copyright' },
	'copyrightflag' => { 390 => 0x40a },
	'copyrightnotice' => { 132 => 0x74 },
	'copyrightowner' => { 328 => 'CopyrightOwner' },
	'copyrightownerid' => { 328 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 328 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 328 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 328 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 328 => 'CopyrightStatus' },
	'copyrightyear' => { 515 => 'CopyrightYear', 520 => 'copyrightYear' },
	'coringfilter' => { 322 => 0x310, 323 => 0x102d, 326 => 0x310 },
	'coringvalues' => { 322 => 0x311, 326 => 0x311 },
	'corporateentity' => { 520 => 'corporateEntity' },
	'correlatedcolortemp' => { 340 => 0x35b },
	'country' => { 162 => 'Country', 341 => 0x69, 518 => 'Country' },
	'country-primarylocationcode' => { 132 => 0x64 },
	'country-primarylocationname' => { 132 => 0x65 },
	'countrycode' => { 234 => 0x5, 388 => 'CountryCode', 514 => 'CountryCode' },
	'course' => { 522 => 'course' },
	'coverage' => { 504 => 'coverage' },
	'coverart' => { 393 => 'covr' },
	'coverdate' => { 520 => 'coverDate' },
	'coverdisplaydate' => { 520 => 'coverDisplayDate' },
	'coveruri' => { 401 => 'cvru' },
	'cpufirmwareversion' => { 376 => 0x28 },
	'crc32' => { 505 => 'crc32' },
	'createdate' => { 120 => 0x9004, 158 => 'CreateDate', 327 => 'CreationDate', 331 => 'create-date', 392 => 'CreationDate', 398 => 0x1, 528 => 'CreateDate' },
	'creationdate' => { 395 => 'creationdate', 517 => 'CreationDate', 520 => 'creationDate' },
	'creationtime' => { 331 => 'Creation Time' },
	'creativestyle' => { 428 => 0x1a, 429 => 0x18, 439 => 0x41, 441 => 0xb020, 473 => 0x4a },
	'creativestylesetting' => { 430 => 0xf, 446 => 0x7 },
	'creativestylewaschanged' => { 477 => 0x8001 },
	'creator' => { 327 => 'Creator', 392 => 'Creator', 504 => 'creator', 515 => 'Creator', 517 => 'Creator' },
	'creatoraddress' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 179 => 'CreatorAppId' },
	'creatorcity' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 514 => 'CreatorContactInfo' },
	'creatorcountry' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 515 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 388 => 'CreatorIdentity' },
	'creatorname' => { 515 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 179 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 515 => [\'Creator','CreatorRole'] },
	'creatortool' => { 528 => 'CreatorTool' },
	'creatorworkemail' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 514 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 132 => 0x6e, 518 => 'Credit' },
	'creditline' => { 523 => 'creditLine' },
	'creditlinereq' => { 533 => 'CreditLineReq' },
	'creditlinerequired' => { 328 => 'CreditLineRequired' },
	'cropactive' => { 102 => 0x0, 109 => 0x244 },
	'cropangle' => { 501 => 'CropAngle', 503 => 'CropAngle' },
	'croparea' => { 235 => 0x45, 477 => 0x9011 },
	'cropaspectratio' => { 104 => 0x30101, 109 => 0x260 },
	'cropaspectratiocustom' => { 104 => 0x30102 },
	'cropbottom' => { 124 => 0x9, 286 => 0x36, 346 => 0x31, 387 => 0xdc, 501 => 'CropBottom', 503 => 'CropBottom' },
	'cropbottommargin' => { 54 => 0x3 },
	'cropcircleactive' => { 110 => 0xd6 },
	'cropcircleradius' => { 110 => 0xd9 },
	'cropcirclex' => { 110 => 0xd7 },
	'cropcircley' => { 110 => 0xd8 },
	'cropconstraintowarp' => { 501 => 'CropConstrainToWarp', 503 => 'CropConstrainToWarp' },
	'croph' => { 495 => 'CropH' },
	'cropheight' => { 102 => 0x6, 109 => 0x24c, 322 => 0x615, 326 => 0x615, 501 => 'CropHeight', 503 => 'CropHeight' },
	'crophispeed' => { 235 => 0x1b },
	'cropleft' => { 109 => 0x246, 124 => 0x6, 286 => 0x1e, 322 => 0x612, 326 => 0x612, 346 => 0x30, 387 => 0xd9, 501 => 'CropLeft', 503 => 'CropLeft' },
	'cropleftmargin' => { 54 => 0x0 },
	'cropmode' => { 128 => 0x104d, 408 => 0x1018 },
	'croporiginalheight' => { 102 => 0xb },
	'croporiginalwidth' => { 102 => 0xa },
	'cropoutputheight' => { 286 => 0xce },
	'cropoutputheightinches' => { 286 => 0x96 },
	'cropoutputpixels' => { 286 => 0xd6 },
	'cropoutputresolution' => { 286 => 0xb6 },
	'cropoutputscale' => { 286 => 0xbe },
	'cropoutputwidth' => { 286 => 0xc6 },
	'cropoutputwidthinches' => { 286 => 0x8e },
	'croppedareaimageheightpixels' => { 489 => 'CroppedAreaImageHeightPixels', 490 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 489 => 'CroppedAreaImageWidthPixels', 490 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 489 => 'CroppedAreaLeftPixels', 490 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 489 => 'CroppedAreaTopPixels', 490 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 408 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 408 => 0x1603 },
	'cropping' => { 477 => 0x9010 },
	'cropright' => { 124 => 0x8, 286 => 0x2e, 346 => 0x32, 387 => 0xdb, 501 => 'CropRight', 503 => 'CropRight' },
	'croprightmargin' => { 54 => 0x1 },
	'croprotatedoriginalheight' => { 102 => 0x2 },
	'croprotatedoriginalwidth' => { 102 => 0x1 },
	'croprotation' => { 102 => 0x8, 124 => 0xb },
	'cropscaledresolution' => { 286 => 0x9e },
	'cropsourceresolution' => { 286 => 0xae },
	'croptop' => { 109 => 0x248, 124 => 0x7, 286 => 0x26, 322 => 0x613, 326 => 0x613, 346 => 0x2f, 387 => 0xda, 501 => 'CropTop', 503 => 'CropTop' },
	'croptopmargin' => { 54 => 0x2 },
	'cropunit' => { 501 => 'CropUnit', 503 => 'CropUnit' },
	'cropunits' => { 501 => 'CropUnits', 503 => 'CropUnits' },
	'cropw' => { 495 => 'CropW' },
	'cropwidth' => { 102 => 0x5, 109 => 0x24a, 322 => 0x614, 326 => 0x614, 501 => 'CropWidth', 503 => 'CropWidth' },
	'cropx' => { 102 => 0x3, 495 => 'CropX' },
	'cropy' => { 102 => 0x4, 495 => 'CropY' },
	'crossprocess' => { 376 => 0x7b },
	'crossprocessparams' => { 376 => 0x235 },
	'cuisine' => { 522 => 'cuisine' },
	'currenticcprofile' => { 120 => 0xc691 },
	'currentpreprofilematrix' => { 120 => 0xc692 },
	'currentversion' => { 477 => 0xd000 },
	'curve0x' => { 495 => 'Curve0x' },
	'curve0y' => { 495 => 'Curve0y' },
	'curve1x' => { 495 => 'Curve1x' },
	'curve1y' => { 495 => 'Curve1y' },
	'curve2x' => { 495 => 'Curve2x' },
	'curve2y' => { 495 => 'Curve2y' },
	'curve3x' => { 495 => 'Curve3x' },
	'curve3y' => { 495 => 'Curve3y' },
	'curve4x' => { 495 => 'Curve4x' },
	'curve4y' => { 495 => 'Curve4y' },
	'curves' => { 291 => 0x76a43201 },
	'custom1' => { 328 => 'Custom1' },
	'custom10' => { 328 => 'Custom10' },
	'custom2' => { 328 => 'Custom2' },
	'custom3' => { 328 => 'Custom3' },
	'custom4' => { 328 => 'Custom4' },
	'custom5' => { 328 => 'Custom5' },
	'custom6' => { 328 => 'Custom6' },
	'custom7' => { 328 => 'Custom7' },
	'custom8' => { 328 => 'Custom8' },
	'custom9' => { 328 => 'Custom9' },
	'customcolortone' => { 110 => 0x4c },
	'customcontrast' => { 110 => 0x4e },
	'customcontrols' => { 85 => 0x70c },
	'customdefaultunsharpfineness' => { 110 => 0xbe },
	'customdefaultunsharpstrength' => { 110 => 0xbc },
	'customdefaultunsharpthreshold' => { 110 => 0xc0 },
	'customilluminant' => { 139 => 0x405 },
	'customizedials' => { 85 => 0x715 },
	'customlinear' => { 110 => 0x4f },
	'customoutputhighlightpoint' => { 110 => 0x53 },
	'customoutputshadowpoint' => { 110 => 0x54 },
	'custompicturestyle' => { 104 => 0x10021 },
	'custompicturestyledata' => { 104 => 0xf0500 },
	'custompicturestylefilename' => { 65 => 0x4010 },
	'customrawhighlight' => { 110 => 0x7c },
	'customrawhighlightpoint' => { 110 => 0x51 },
	'customrawshadow' => { 110 => 0x85 },
	'customrawshadowpoint' => { 110 => 0x52 },
	'customrendered' => { 120 => 0xa401, 192 => 0x6420, 507 => 'CustomRendered' },
	'customsaturation' => { 110 => 0x4d, 318 => 0x503 },
	'customsettingsalldefault' => { 298 => '0.2', 307 => '0.2' },
	'customsettingsbank' => { 298 => '0.1', 299 => '0.1', 301 => '0.1', 302 => '0.1', 307 => '0.1', 311 => '0.2', 312 => '0.2', 314 => 0x1, 315 => 0x1, 316 => 0x1 },
	'customsharpness' => { 110 => 0x50 },
	'customunsharpmaskfineness' => { 110 => 0xb8 },
	'customunsharpmaskstrength' => { 110 => 0xb6 },
	'customunsharpmaskthreshold' => { 110 => 0xba },
	'customwb_rblevels' => { 446 => 0x1a },
	'customwb_rgblevels' => { 429 => 0x8, 430 => 0x19 },
	'customwbbluelevel' => { 185 => 0x36 },
	'customwberror' => { 185 => 0x37 },
	'customwbgreenlevel' => { 185 => 0x35 },
	'customwbredlevel' => { 185 => 0x34 },
	'customwbsetting' => { 185 => 0x26 },
	'cx' => { 401 => '_cx_' },
	'cy' => { 401 => '_cy_' },
	'd-lightinghq' => { 291 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 287 => 0x2 },
	'd-lightinghqhighlight' => { 287 => 0x1 },
	'd-lightinghqselected' => { 291 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 287 => 0x0 },
	'd-lightinghs' => { 291 => 0xce5554aa },
	'd-lightinghsadjustment' => { 288 => 0x0 },
	'd-lightinghscolorboost' => { 288 => 0x1 },
	'd-rangeoptimizerhighlight' => { 477 => 0x8024 },
	'd-rangeoptimizermode' => { 477 => 0x8022 },
	'd-rangeoptimizershadow' => { 477 => 0x802d },
	'd-rangeoptimizervalue' => { 477 => 0x8023 },
	'darkblacksegrows' => { 139 => 0x18d8 },
	'darkfocusenvironment' => { 341 => 0x8003 },
	'darkframecountfactor' => { 139 => 0xc85 },
	'darkframelongexposure' => { 139 => 0xc84 },
	'darkframeshortexposure' => { 139 => 0xc83 },
	'darkpedestal' => { 139 => 0xc7f },
	'datacompressionmethod' => { 134 => 0x6e },
	'dataimprint' => { 182 => 0x34 },
	'datamining' => { 328 => 'DataMining' },
	'dataonscreen' => { 515 => 'DataOnScreen' },
	'dataonscreenregion' => { 515 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 515 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 515 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 515 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 515 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 515 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 515 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 515 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 376 => 0x3d },
	'date' => { 376 => 0x6, 504 => 'date' },
	'dateacquired' => { 179 => 'DateAcquired', 180 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 132 => 0x37, 518 => 'DateCreated' },
	'datedisplayformat' => { 283 => 0x3 },
	'dateidentified' => { 119 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 303 => '4.2' },
	'daterecieved' => { 520 => 'dateRecieved' },
	'datesent' => { 133 => 0x46 },
	'datestampmode' => { 65 => 0x1c, 235 => 0x9d },
	'datetime' => { 496 => 'datetime', 526 => 'DateTime' },
	'datetimedigitized' => { 507 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 101 => 0x0, 120 => 0x9003, 155 => 0x14, 158 => 'OriginalDate', 396 => 'IDIT', 401 => 'date', 402 => 0xb, 403 => 0x3b, 404 => 0x3e, 507 => 'DateTimeOriginal' },
	'datetimestamp' => { 141 => 0x64 },
	'datetimeutc' => { 318 => 0x908 },
	'daylightsavings' => { 79 => 0x3, 283 => 0x2 },
	'dayofweek' => { 403 => 0x42, 404 => 0x4a },
	'dccontinent' => { 119 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 119 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 119 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 119 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 119 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 119 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 119 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 119 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 119 => 'Event' },
	'dcfootprintspatialfit' => { 119 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 119 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 119 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 119 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 119 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 119 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 119 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 119 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 119 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 119 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 119 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 119 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 119 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 119 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 119 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 119 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 119 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 119 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 119 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 119 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 119 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 119 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 119 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 119 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 119 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 119 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 119 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 119 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 119 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 119 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 119 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 166 => 'Declination' },
	'decposition' => { 182 => 0x32 },
	'defaultautogray' => { 501 => 'DefaultAutoGray', 503 => 'DefaultAutoGray' },
	'defaultautotone' => { 501 => 'DefaultAutoTone', 503 => 'DefaultAutoTone' },
	'defaultblackrender' => { 120 => 0xc7a6 },
	'defaultcroporigin' => { 120 => 0xc61f },
	'defaultcropsize' => { 120 => 0xc620 },
	'defaulteraseoption' => { 85 => 0x813 },
	'defaultscale' => { 120 => 0xc61e },
	'defaultsspecifictoiso' => { 501 => 'DefaultsSpecificToISO', 503 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 501 => 'DefaultsSpecificToSerial', 503 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 120 => 0xc7b5 },
	'defectisocode' => { 139 => 0x90f },
	'defringe' => { 501 => 'Defringe', 503 => 'Defringe' },
	'defringegreenamount' => { 501 => 'DefringeGreenAmount', 503 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 501 => 'DefringeGreenHueHi', 503 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 501 => 'DefringeGreenHueLo', 503 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 501 => 'DefringePurpleAmount', 503 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 501 => 'DefringePurpleHueHi', 503 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 501 => 'DefringePurpleHueLo', 503 => 'DefringePurpleHueLo' },
	'dehaze' => { 501 => 'Dehaze', 503 => 'Dehaze' },
	'deletedimagecount' => { 235 => 0xa6, 263 => 0x6e },
	'deprecatedon' => { 499 => 'deprecatedOn' },
	'depthfar' => { 120 => 0xc7eb },
	'depthformat' => { 120 => 0xc7e9 },
	'depthimage' => { 486 => 'Data' },
	'depthmeasuretype' => { 120 => 0xc7ed },
	'depthnear' => { 120 => 0xc7ea },
	'depthunits' => { 120 => 0xc7ec },
	'derivedfrom' => { 531 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 531 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 531 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 531 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 531 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 531 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 531 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 531 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 531 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 531 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 531 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 531 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 531 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 531 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 531 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 531 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 531 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 531 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 531 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 531 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 531 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 531 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 531 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 531 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 331 => 'Description', 393 => ['desc','dscp',"\xa9des"], 395 => 'description', 401 => 'dscp', 501 => 'Description', 503 => 'Description', 504 => 'description', 528 => 'Description' },
	'destination' => { 133 => 0x5 },
	'destinationcity' => { 376 => 0x24, 382 => 0x3 },
	'destinationcitycode' => { 383 => 0x1001 },
	'destinationdst' => { 376 => 0x26, 382 => '0.3' },
	'developmentdynamicrange' => { 128 => 0x1403 },
	'deviantmatrixcustom' => { 139 => 0x7de },
	'deviantmatrixdaylight' => { 139 => 0x7da },
	'deviantmatrixflash' => { 139 => 0x7dd },
	'deviantmatrixfluorescent' => { 139 => 0x7dc },
	'deviantmatrixtungsten' => { 139 => 0x7db },
	'deviantwhitecustom' => { 139 => 0x842 },
	'deviantwhitedaylight' => { 139 => 0x83e },
	'deviantwhiteflash' => { 139 => 0x841 },
	'deviantwhitefluorescent' => { 139 => 0x840 },
	'deviantwhitetungsten' => { 139 => 0x83f },
	'device' => { 520 => 'device' },
	'devicesettingdescription' => { 507 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 507 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 507 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 507 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 415 => 0x2 },
	'dewarpdata' => { 117 => 'DewarpData' },
	'dewarpflag' => { 117 => 'DewarpFlag' },
	'dialdirectiontvav' => { 85 => 0x706 },
	'dietaryneeds' => { 522 => 'dietaryNeeds' },
	'diffractioncompensation' => { 224 => 0x20e, 239 => 0x142, 240 => 0x1b2, 241 => 0x1a2, 242 => 0x1b6, 243 => 0x1b6 },
	'diffractioncorrection' => { 341 => 0xbc, 366 => 0x3 },
	'diffractioncorrectionon' => { 104 => 0x2070b },
	'digitalcreationdate' => { 132 => 0x3e },
	'digitalcreationtime' => { 132 => 0x3f },
	'digitaldeehighlightadj' => { 258 => 0x202 },
	'digitaldeeshadowadj' => { 258 => 0x200 },
	'digitaldeethreshold' => { 258 => 0x201 },
	'digitalfilter' => { 418 => 0x59 },
	'digitalfilter01' => { 363 => 0x5 },
	'digitalfilter02' => { 363 => 0x16 },
	'digitalfilter03' => { 363 => 0x27 },
	'digitalfilter04' => { 363 => 0x38 },
	'digitalfilter05' => { 363 => 0x49 },
	'digitalfilter06' => { 363 => 0x5a },
	'digitalfilter07' => { 363 => 0x6b },
	'digitalfilter08' => { 363 => 0x7c },
	'digitalfilter09' => { 363 => 0x8d },
	'digitalfilter10' => { 363 => 0x9e },
	'digitalfilter11' => { 363 => 0xaf },
	'digitalfilter12' => { 363 => 0xc0 },
	'digitalfilter13' => { 363 => 0xd1 },
	'digitalfilter14' => { 363 => 0xe2 },
	'digitalfilter15' => { 363 => 0xf3 },
	'digitalfilter16' => { 363 => 0x104 },
	'digitalfilter17' => { 363 => 0x115 },
	'digitalfilter18' => { 363 => 0x126 },
	'digitalfilter19' => { 363 => 0x137 },
	'digitalfilter20' => { 363 => 0x148 },
	'digitalgain' => { 75 => 0xb },
	'digitalgem' => { 219 => 0x0 },
	'digitalice' => { 258 => 0x100 },
	'digitalimageguid' => { 515 => 'DigImageGUID' },
	'digitallensoptimizer' => { 63 => 0xa },
	'digitallensoptimizersetting' => { 81 => 0x9 },
	'digitalroc' => { 255 => 0x0 },
	'digitalsourcefiletype' => { 515 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 515 => 'DigitalSourceType' },
	'digitalzoom' => { 35 => 0xc, 113 => 0xa, 128 => 0x1044, 141 => 0x68, 152 => 0x22, 153 => 0x1e, 157 => 'DigitalZoom', 182 => 0xc, 235 => 0x86, 281 => 0xa, 323 => 0x204, 376 => 0x1e, 383 => 0xa, 417 => 0x204, 464 => 0x12, 465 => 0x12 },
	'digitalzoomon' => { 417 => 0x21b },
	'digitalzoomratio' => { 120 => 0xa404, 452 => 0x200, 454 => 0x21c, 507 => 'DigitalZoomRatio' },
	'director' => { 180 => 'WM/Director', 393 => "\xa9dir", 395 => 'director', 401 => "\xa9dir", 530 => 'director' },
	'directorphotography' => { 530 => 'directorPhotography' },
	'directory' => { 121 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 212 => 0x3, 404 => 0x12 },
	'disableautocreation' => { 484 => 'DisableAutoCreation' },
	'disclaimer' => { 331 => 'Disclaimer' },
	'discnumber' => { 530 => 'discNumber' },
	'dishtype' => { 522 => 'dishType' },
	'disknumber' => { 393 => 'disk' },
	'dispbutton' => { 243 => 0x7d4, 314 => 0x2ab },
	'displayallafpoints' => { 85 => 0x514 },
	'displayaperture' => { 35 => 0x23 },
	'displayedunitsx' => { 391 => 0x2 },
	'displayedunitsy' => { 391 => 0x6 },
	'displayname' => { 395 => 'displayname', 519 => 'displayName' },
	'distance1' => { 141 => 0x28 },
	'distance2' => { 141 => 0x2c },
	'distance3' => { 141 => 0x30 },
	'distance4' => { 141 => 0x34 },
	'distortion' => { 415 => 0xa050 },
	'distortioncompensation' => { 477 => 0x8040 },
	'distortioncontrol' => { 263 => 0x10 },
	'distortioncorrection' => { 80 => 0x3, 104 => 0x20705, 110 => 0x67, 120 => 0x7036, 318 => 0x50b, 345 => '7.1', 366 => 0x0, 472 => 0x601, 473 => 0x5b },
	'distortioncorrection2' => { 322 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 498 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 104 => '0x20705.0', 110 => 0x63 },
	'distortioncorrectionsetting' => { 81 => 0x7, 441 => 0x2013 },
	'distortioncorrectionvalue' => { 80 => 0x9 },
	'distortioncorrparams' => { 120 => 0x7037, 451 => 0x1a23, 454 => 0x1870, 456 => 0x189c, 457 => 0x18cc, 458 => 0x17d0, 472 => 0x6ca, 473 => 0x64 },
	'distortioncorrparamsnumber' => { 454 => 0x1899, 456 => 0x18c5, 457 => 0x18f5, 458 => 0x17f9 },
	'distortioncorrparamspresent' => { 454 => 0x1898, 456 => 0x18c4, 457 => 0x18f4, 458 => 0x17f8, 460 => 0x10b, 461 => 0x10b, 472 => 0x600, 473 => 0x5a },
	'distortioneffect' => { 104 => 0x20709 },
	'distortionn' => { 345 => 0xc },
	'distortionparam02' => { 345 => 0x2 },
	'distortionparam04' => { 345 => 0x4 },
	'distortionparam08' => { 345 => 0x8 },
	'distortionparam09' => { 345 => 0x9 },
	'distortionparam11' => { 345 => 0xb },
	'distortionscale' => { 345 => 0x5 },
	'distributor' => { 520 => 'distributor' },
	'distributorproductid' => { 519 => 'distributorProductID' },
	'dloon' => { 104 => '0x20706.0', 110 => 0xdc },
	'dlosetting' => { 104 => 0x20706, 110 => 0xdd },
	'dlosettingapplied' => { 103 => 0x4 },
	'dloshootingdistance' => { 110 => 0xde },
	'dloversion' => { 103 => 0x5 },
	'dmcomment' => { 530 => 'comment' },
	'dmdithermatrix' => { 139 => 0xc7a },
	'dmdithermatrixheight' => { 139 => 0xc7c },
	'dmdithermatrixwidth' => { 139 => 0xc7b },
	'dngadobedata' => { 120 => 0xc634 },
	'dngbackwardversion' => { 120 => 0xc613 },
	'dngignoresidecars' => { 501 => 'DNGIgnoreSidecars', 503 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 120 => 0xc630 },
	'dngprivatedata' => { 120 => 0xc634 },
	'dngversion' => { 120 => 0xc612 },
	'document' => { 331 => 'Document' },
	'documentancestors' => { 518 => 'DocumentAncestors' },
	'documenthistory' => { 132 => 0xe7 },
	'documentid' => { 531 => 'DocumentID' },
	'documentname' => { 120 => 0x10d },
	'documentnotes' => { 132 => 0xe6 },
	'doi' => { 520 => 'doi' },
	'dopesheet' => { 515 => 'Dopesheet' },
	'dopesheetlink' => { 515 => 'DopesheetLink' },
	'dopesheetlinklink' => { 515 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 515 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 139 => 0xc82 },
	'dpp' => { 496 => 'dpp' },
	'dr4cameramodel' => { 105 => 0x3 },
	'drangepriority' => { 128 => 0x1443 },
	'drangepriorityauto' => { 128 => 0x1444 },
	'drangepriorityfixed' => { 128 => 0x1445 },
	'drivemode' => { 114 => 0x3103, 126 => '0.1', 182 => 0x6, 185 => 0x1e, 188 => 0xe, 192 => 0x64d0, 318 => 0x600, 376 => 0x34, 408 => 0x1002, 418 => 0x3, 428 => 0x4, 429 => 0x7e, 430 => 0x34 },
	'drivemode2' => { 185 => 0xa, 357 => 0x7, 439 => 0xe, 446 => 0x1 },
	'drivemodesetting' => { 430 => 0x4 },
	'drivespeed' => { 126 => '0.2' },
	'dspfirmwareversion' => { 376 => 0x27 },
	'duration' => { 68 => 0x6a, 156 => 'Duration', 170 => 'Duration', 522 => 'duration', 530 => 'duration' },
	'durationscale' => { 530 => [\'duration','durationScale'] },
	'durationvalue' => { 530 => [\'duration','durationValue'] },
	'dustremovaldata' => { 65 => 0x97 },
	'dxcropalert' => { 240 => 0x250, 241 => 0x23c, 242 => 0x250, 243 => 0x250 },
	'dynamicafarea' => { 298 => '1.4', 307 => '1.4' },
	'dynamicafareasize' => { 240 => 0x254, 241 => 0x240, 242 => 0x254, 243 => 0x254 },
	'dynamicareaafassist' => { 314 => 0x18, 315 => 0x18, 316 => 0x18 },
	'dynamicareaafdisplay' => { 299 => '46.1', 301 => '47.1', 302 => '47.1', 311 => '47.1', 312 => '47.1' },
	'dynamicrange' => { 128 => 0x1400 },
	'dynamicrangeboost' => { 341 => 0xee },
	'dynamicrangeexpansion' => { 376 => 0x69, 408 => 0x100e },
	'dynamicrangemax' => { 109 => 0x7c },
	'dynamicrangemin' => { 109 => 0x7a },
	'dynamicrangeoptimizer' => { 185 => 0x15, 441 => [0xb025,0xb04f], 450 => 0x1144, 451 => [0x1144,0x324], 452 => [0x1120,0x300], 453 => [0x119c,0x37c], 454 => [0x1178,0x328], 455 => [0x1030,0x50], 456 => [0x228,0x50], 457 => [0x228,0x50], 458 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 439 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 428 => 0x19, 429 => 0x17, 430 => 0xd, 439 => 0x79, 446 => 0x5 },
	'dynamicrangeoptimizermode' => { 188 => 0x15, 428 => 0x18, 429 => 0x16, 439 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 185 => 0x27, 430 => 0xc, 446 => 0x4 },
	'dynamicrangesetting' => { 128 => 0x1402 },
	'e-dialinprogram' => { 357 => '1.3' },
	'earliestageorloweststage' => { 119 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 119 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 119 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 119 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 119 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 480 => 'EarthPos' },
	'earthposaltitude' => { 480 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 480 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 480 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 480 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 480 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 480 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 480 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 480 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 313 => '6.1' },
	'easyexposurecompensation' => { 298 => '6.4', 299 => '6.5', 301 => '6.3', 302 => '6.3', 306 => '5.1', 307 => '4.4', 308 => '5.2', 311 => '6.3', 312 => '6.3', 314 => 0x1d, 315 => 0x1d, 316 => 0x1d },
	'easymode' => { 35 => 0xb },
	'edgemapslope' => { 139 => 0x930 },
	'edgemapx1' => { 139 => 0x931 },
	'edgemapx2' => { 139 => 0x932 },
	'edgemapx3' => { 139 => 0x934 },
	'edgemapx4' => { 139 => 0x935 },
	'edgenoisereduction' => { 292 => 0x4, 477 => 0x8028 },
	'edit1' => { 401 => "\xa9ed1" },
	'edit2' => { 401 => "\xa9ed2" },
	'edit3' => { 401 => "\xa9ed3" },
	'edit4' => { 401 => "\xa9ed4" },
	'edit5' => { 401 => "\xa9ed5" },
	'edit6' => { 401 => "\xa9ed6" },
	'edit7' => { 401 => "\xa9ed7" },
	'edit8' => { 401 => "\xa9ed8" },
	'edit9' => { 401 => "\xa9ed9" },
	'edition' => { 520 => 'edition' },
	'editorialupdate' => { 132 => 0x8 },
	'editstatus' => { 132 => 0x7, 388 => 'EditStatus', 496 => 'EditStatus' },
	'editversionname' => { 291 => 0x3d136244 },
	'effectivelv' => { 376 => 0x2d },
	'effectivemaxaperture' => { 228 => 0x12, 229 => 0x13, 233 => 0x14 },
	'eissn' => { 520 => 'eIssn' },
	'electricalblackcolumns' => { 139 => 0x1810 },
	'electronicfront-curtainshutter' => { 301 => '5.2', 302 => '5.2', 311 => '5.3', 312 => '5.2' },
	'electronicfrontcurtainshutter' => { 441 => 0x201a },
	'elevation' => { 166 => 'Elevation' },
	'email' => { 158 => 'EMail' },
	'embargodate' => { 523 => 'embargoDate' },
	'embdencrightsexpr' => { 515 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 515 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 515 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 515 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 518 => 'EmbeddedXMPDigest' },
	'emissivity' => { 122 => 0x3 },
	'emptyslotrelease' => { 240 => 0x723, 241 => 0x625, 242 => 0x655, 243 => 0x6bd },
	'enablechromanoisereduction' => { 139 => 0xe6e },
	'enablesharpening' => { 139 => 0x92e },
	'encodedby' => { 180 => 'WM/EncodedBy', 393 => "\xa9enc" },
	'encodedwith' => { 395 => 'Encoded_With' },
	'encoder' => { 393 => "\xa9too", 401 => "\xa9too" },
	'encoderid' => { 401 => "\xa9enc" },
	'encodingtime' => { 180 => 'WM/EncodingTime' },
	'encryptionkey' => { 415 => 0xa020 },
	'endingpage' => { 520 => 'endingPage' },
	'enduser' => { 328 => 'EndUser' },
	'enduserid' => { 328 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 328 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 240 => 0x746, 241 => 0x648, 242 => 0x678, 243 => 0x6e0 },
	'engineer' => { 530 => 'engineer' },
	'enhancedarktones' => { 284 => 0x8 },
	'enhancedenoisealreadyapplied' => { 498 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 498 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 498 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 498 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 498 => 'EnhanceDetailsVersion' },
	'enhancement' => { 113 => 0x16, 114 => 0x3016 },
	'enhanceparams' => { 120 => 0xc7ee },
	'enhancer' => { 322 => 0x300 },
	'enhancervalues' => { 322 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 498 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 498 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 498 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 133 => 0x28 },
	'envelopepriority' => { 133 => 0x3c },
	'enveloperecordversion' => { 133 => 0x0 },
	'episode' => { 515 => 'Episode' },
	'episodeglobaluniqueid' => { 393 => 'egid' },
	'episodeidentifier' => { 515 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 515 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 515 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 323 => 0x20c },
	'epsonimagewidth' => { 323 => 0x20b },
	'epsonsoftware' => { 323 => 0x20d },
	'equipmentinstitution' => { 479 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 479 => 'EquipmentManufacturer' },
	'equipmentversion' => { 319 => 0x0 },
	'ettlii' => { 85 => 0x304, 86 => 0xd, 87 => 0xe, 88 => 0x7, 89 => 0x7, 90 => 0xe },
	'event' => { 482 => 'Event', 494 => 'Event', 515 => 'Event', 520 => 'event' },
	'eventalias' => { 519 => 'eventAlias' },
	'eventdate' => { 119 => [\'Event','EventEventDate'] },
	'eventday' => { 119 => [\'Event','EventDay'] },
	'eventearliestdate' => { 119 => [\'Event','EventEarliestDate'] },
	'eventend' => { 519 => 'eventEnd' },
	'eventenddayofyear' => { 119 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 119 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 119 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 119 => [\'Event','EventHabitat'] },
	'eventid' => { 119 => [\'Event','EventEventID'], 515 => 'EventId' },
	'eventlatestdate' => { 119 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 119 => [\'Event','EventMonth'] },
	'eventnumber' => { 402 => 0x9, 403 => 0x37, 404 => 0x3a },
	'eventparenteventid' => { 119 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 119 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 119 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 119 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 119 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 119 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 519 => 'eventStart' },
	'eventstartdayofyear' => { 119 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 519 => 'eventSubtype' },
	'eventtime' => { 119 => [\'Event','EventEventTime'] },
	'eventtype' => { 519 => 'eventType' },
	'eventverbatimeventdate' => { 119 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 119 => [\'Event','EventYear'] },
	'evfgrid' => { 314 => 0x165, 315 => 0x165, 316 => 0x17d },
	'evfimageframe' => { 314 => 0x164, 315 => 0x164, 316 => 0x17c },
	'evfreleaseindicator' => { 314 => 0x24f, 315 => 0x24f, 316 => 0x267 },
	'evfwarmdisplaybrightness' => { 314 => 0x24d, 315 => 0x24d, 316 => 0x265 },
	'evfwarmdisplaymode' => { 314 => 0x24b, 315 => 0x24b, 316 => 0x263 },
	'evsteps' => { 357 => '1.2', 359 => 0x0 },
	'evstepsize' => { 303 => '5.1', 304 => '6.1', 305 => '6.1', 309 => '0.7' },
	'exclusivecoverage' => { 491 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 523 => 'exclusivityEndDate' },
	'excursiontolerance' => { 134 => 0x82 },
	'executiveproducer' => { 393 => "\xa9xpd" },
	'exif' => { 121 => 'EXIF' },
	'exifbyteorder' => { 121 => 'ExifByteOrder' },
	'exifcamerainfo' => { 132 => 0xe8 },
	'exifimageheight' => { 120 => 0xa003, 507 => 'PixelYDimension' },
	'exifimagewidth' => { 120 => 0xa002, 507 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 121 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 120 => 0x9000, 507 => 'ExifVersion' },
	'exitpupilposition' => { 228 => 0x4, 229 => 0x4, 233 => 0x4 },
	'expirationdate' => { 132 => 0x25, 523 => 'expirationDate' },
	'expirationtime' => { 132 => 0x26 },
	'exposure' => { 120 => 0xfe51, 501 => 'Exposure', 503 => 'Exposure' },
	'exposure2012' => { 501 => 'Exposure2012', 503 => 'Exposure2012' },
	'exposureadj' => { 289 => 0x0 },
	'exposureadj2' => { 289 => 0x12 },
	'exposureadjust' => { 418 => 0xc },
	'exposurebracketingindicatorlast' => { 185 => 0x52 },
	'exposurebracketshotnumber' => { 188 => 0x2d, 439 => 0x2f },
	'exposurebracketstepsize' => { 357 => 0x8 },
	'exposurebracketvalue' => { 235 => 0x19 },
	'exposurecompautocancel' => { 85 => 0x113 },
	'exposurecompensation' => { 78 => 0x6, 94 => 0x0, 120 => 0x9204, 141 => 0x24, 157 => 'ExposureComp', 177 => 'ExposureCompensation', 182 => 0xd, 183 => 0x53, 184 => 0x1e, 188 => 0x49c0, 323 => 0x1006, 376 => 0x16, 385 => 0x402, 415 => 0xa013, 418 => [0xc,0x35,0x4d], 450 => 0x114c, 451 => 0x114c, 452 => 0x1128, 454 => 0x1180, 455 => 0x1038, 456 => 0x230, 457 => 0x230, 458 => 0x223, 507 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 446 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 243 => 0x794 },
	'exposurecompensationmode' => { 185 => 0x47, 188 => 0x2a },
	'exposurecompensationset' => { 428 => 0x3, 429 => 0x3, 430 => 0x3, 446 => 0x1e },
	'exposurecompensationsetting' => { 185 => 0x1 },
	'exposurecompstepsize' => { 298 => '6.3', 299 => '7.3', 301 => '7.3', 302 => '7.3', 307 => '4.3', 311 => '7.3', 312 => '7.3' },
	'exposurecontrolstep' => { 306 => '6.1', 308 => '6.1' },
	'exposurecontrolstepsize' => { 298 => '6.2', 299 => '7.1', 301 => '7.1', 302 => '7.1', 307 => '4.2', 311 => '7.1', 312 => '7.1', 313 => '7.1', 314 => 0x1b, 315 => 0x1b, 316 => 0x1b },
	'exposurecount' => { 128 => 0x1032 },
	'exposuredelay' => { 243 => 0x800 },
	'exposuredelaymode' => { 298 => '10.1', 299 => '11.1', 301 => '11.1', 302 => '11.1', 303 => '9.1', 304 => '10.1', 305 => '10.1', 307 => '10.4', 308 => '10.1', 309 => '6.4', 311 => '11.1', 312 => '11.1', 313 => '11.2' },
	'exposuredifference' => { 235 => 0xe },
	'exposuregaincustom' => { 139 => 0x89c },
	'exposuregaindaylight' => { 139 => 0x898 },
	'exposuregainflash' => { 139 => 0x89b },
	'exposuregainfluorescent' => { 139 => 0x89a },
	'exposuregaintungsten' => { 139 => 0x899 },
	'exposureindex' => { 120 => 0xa215, 507 => 'ExposureIndex' },
	'exposureindicator' => { 185 => 0x50 },
	'exposurelevelincrements' => { 83 => 0x6, 84 => 0x6, 85 => 0x101, 86 => 0x5, 87 => 0x6, 88 => 0x5, 89 => 0x5, 90 => 0x6, 91 => 0x4, 428 => 0x58, 429 => 0x58 },
	'exposurelockused' => { 489 => 'ExposureLockUsed' },
	'exposuremode' => { 120 => 0xa402, 157 => 'ExposureMode', 182 => 0x1, 183 => 0xa, 184 => 0x0, 185 => 0x0, 188 => 0x34, 318 => 0x200, 338 => 0x40d, 418 => 0x8, 441 => 0xb041, 507 => 'ExposureMode' },
	'exposuremodeinmanual' => { 85 => 0x10b },
	'exposureprogram' => { 120 => 0x8822, 408 => 0x1001, 421 => [0x17e,0x43], 428 => 0x3c, 429 => 0x3c, 430 => 0x5, 434 => 0x14, 439 => 0x3f, 446 => 0x2, 450 => 0x1175, 451 => 0x1179, 452 => 0x1155, 453 => 0x11d1, 454 => 0x11ad, 455 => 0x1065, 456 => 0x25d, 457 => 0x25d, 458 => 0x24c, 469 => 0xb, 470 => 0xc, 471 => 0xb, 473 => 0x48, 507 => 'ExposureProgram' },
	'exposureshift' => { 318 => 0x203 },
	'exposurestandardadjustment' => { 441 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 78 => 0x16, 120 => 0x829a, 138 => 0xfd05, 141 => 0x20, 143 => 0xfa24, 145 => 0xf104, 148 => 0x12, 150 => 0x38, 152 => 0x14, 153 => 0x10, 155 => 0x10, 157 => 'ExposureTime', 182 => 0x9, 183 => 0x35, 184 => 0x48, 185 => 0x8, 188 => 0x49b8, 376 => 0x12, 415 => 0xa018, 418 => [0x32,0x4a], 428 => 0x0, 429 => 0x0, 446 => [0x21,0x23,0x27], 473 => 0x10, 507 => 'ExposureTime' },
	'exposuretime2' => { 418 => [0x33,0x4b] },
	'exposuretuning' => { 235 => 0x1c },
	'exposurevalue' => { 139 => 0x3 },
	'exposurewarning' => { 128 => 0x1302 },
	'exrauto' => { 128 => 0x1033 },
	'exrmode' => { 128 => 0x1034 },
	'extdescraccessibility' => { 514 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 240 => 0x120, 241 => 0x114, 242 => 0x124, 243 => 0x124 },
	'extendedshutterspeeds' => { 314 => 0x102, 315 => 0x102, 316 => 0x118 },
	'extendedwbdetect' => { 318 => 0x902 },
	'extender' => { 319 => 0x301 },
	'extenderfirmwareversion' => { 319 => 0x304 },
	'extendermagnification' => { 159 => 'Magnification' },
	'extendermake' => { 159 => 'Make' },
	'extendermodel' => { 159 => 'Model', 319 => 0x303 },
	'extenderserialnumber' => { 159 => 'SerialNumber', 319 => 0x302 },
	'extenderstatus' => { 374 => 0x3 },
	'externalflash' => { 321 => 0x1201 },
	'externalflashae1' => { 323 => 0x101f },
	'externalflashae1_0' => { 323 => 0x101b },
	'externalflashae2' => { 323 => 0x1020 },
	'externalflashae2_0' => { 323 => 0x101c },
	'externalflashbounce' => { 321 => 0x1204, 323 => 0x1026, 364 => 0x1a },
	'externalflashcompensation' => { 215 => 0x1b },
	'externalflashexposurecomp' => { 235 => 0x17, 364 => 0x19 },
	'externalflashfirmware' => { 213 => 0x6, 214 => 0x6, 215 => 0x6, 216 => 0x6, 217 => 0x6, 218 => 0x6 },
	'externalflashflags' => { 213 => 0x8, 214 => 0x8, 215 => 0x8, 216 => 0x8, 218 => 0x8 },
	'externalflashguidenumber' => { 321 => 0x1203, 364 => '24.1' },
	'externalflashgvalue' => { 323 => 0x1025 },
	'externalflashmode' => { 323 => 0x1028, 364 => 0x2 },
	'externalflashreadystate' => { 217 => '9.1' },
	'externalflashstatus' => { 217 => '8.2' },
	'externalflashzoom' => { 321 => 0x1205, 323 => 0x1027 },
	'externalflashzoomoverride' => { 217 => '8.1' },
	'externalmetadatalink' => { 515 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 336 => 0x311, 339 => 0x311, 340 => 0x311, 343 => 0x3408 },
	'extrainfoversion' => { 432 => 0x1a },
	'eyestartaf' => { 185 => 0x40 },
	'fac100per' => { 139 => 0xe94 },
	'fac170per' => { 139 => 0xe93 },
	'fac18per' => { 139 => 0xe92 },
	'face10position' => { 111 => 0x3f4, 112 => 0x1ec, 211 => 0x28, 361 => 0x12 },
	'face10size' => { 362 => 0x12 },
	'face11position' => { 211 => 0x2c, 361 => 0x14 },
	'face11size' => { 362 => 0x14 },
	'face12position' => { 211 => 0x30, 361 => 0x16 },
	'face12size' => { 362 => 0x16 },
	'face13position' => { 361 => 0x18 },
	'face13size' => { 362 => 0x18 },
	'face14position' => { 361 => 0x1a },
	'face14size' => { 362 => 0x1a },
	'face15position' => { 361 => 0x1c },
	'face15size' => { 362 => 0x1c },
	'face16position' => { 361 => 0x1e },
	'face16size' => { 362 => 0x1e },
	'face17position' => { 361 => 0x20 },
	'face17size' => { 362 => 0x20 },
	'face18position' => { 361 => 0x22 },
	'face18size' => { 362 => 0x22 },
	'face19position' => { 361 => 0x24 },
	'face19size' => { 362 => 0x24 },
	'face1position' => { 55 => 0x8, 111 => 0xd, 112 => 0x18, 211 => 0x4, 333 => 0x1, 361 => 0x0, 405 => 0xbc, 435 => 0x1, 436 => 0x0, 437 => 0x0, 438 => 0x5b },
	'face1size' => { 362 => 0x0 },
	'face20position' => { 361 => 0x26 },
	'face20size' => { 362 => 0x26 },
	'face21position' => { 361 => 0x28 },
	'face21size' => { 362 => 0x28 },
	'face22position' => { 361 => 0x2a },
	'face22size' => { 362 => 0x2a },
	'face23position' => { 361 => 0x2c },
	'face23size' => { 362 => 0x2c },
	'face24position' => { 361 => 0x2e },
	'face24size' => { 362 => 0x2e },
	'face25position' => { 361 => 0x30 },
	'face25size' => { 362 => 0x30 },
	'face26position' => { 361 => 0x32 },
	'face26size' => { 362 => 0x32 },
	'face27position' => { 361 => 0x34 },
	'face27size' => { 362 => 0x34 },
	'face28position' => { 361 => 0x36 },
	'face28size' => { 362 => 0x36 },
	'face29position' => { 361 => 0x38 },
	'face29size' => { 362 => 0x38 },
	'face2position' => { 55 => 0xa, 111 => 0x7c, 112 => 0x4c, 211 => 0x8, 333 => 0x5, 361 => 0x2, 405 => 0xc8, 435 => 0x6, 436 => 0x20, 437 => 0x25, 438 => 0x65 },
	'face2size' => { 362 => 0x2 },
	'face30position' => { 361 => 0x3a },
	'face30size' => { 362 => 0x3a },
	'face31position' => { 361 => 0x3c },
	'face31size' => { 362 => 0x3c },
	'face32position' => { 361 => 0x3e },
	'face32size' => { 362 => 0x3e },
	'face3position' => { 55 => 0xc, 111 => 0xeb, 112 => 0x80, 211 => 0xc, 333 => 0x9, 361 => 0x4, 405 => 0xd4, 435 => 0xb, 436 => 0x40, 437 => 0x4a, 438 => 0x6f },
	'face3size' => { 362 => 0x4 },
	'face4position' => { 55 => 0xe, 111 => 0x15a, 112 => 0xb4, 211 => 0x10, 333 => 0xd, 361 => 0x6, 405 => 0xe0, 435 => 0x10, 436 => 0x60, 437 => 0x6f, 438 => 0x79 },
	'face4size' => { 362 => 0x6 },
	'face5position' => { 55 => 0x10, 111 => 0x1c9, 112 => 0xe8, 211 => 0x14, 333 => 0x11, 361 => 0x8, 405 => 0xec, 435 => 0x15, 436 => 0x80, 437 => 0x94 },
	'face5size' => { 362 => 0x8 },
	'face6position' => { 55 => 0x12, 111 => 0x238, 112 => 0x11c, 211 => 0x18, 361 => 0xa, 405 => 0xf8, 435 => 0x1a, 436 => 0xa0, 437 => 0xb9 },
	'face6size' => { 362 => 0xa },
	'face7position' => { 55 => 0x14, 111 => 0x2a7, 112 => 0x150, 211 => 0x1c, 361 => 0xc, 405 => 0x104, 435 => 0x1f, 436 => 0xc0, 437 => 0xde },
	'face7size' => { 362 => 0xc },
	'face8position' => { 55 => 0x16, 111 => 0x316, 112 => 0x184, 211 => 0x20, 361 => 0xe, 405 => 0x110, 435 => 0x24, 436 => 0xe0, 437 => 0x103 },
	'face8size' => { 362 => 0xe },
	'face9position' => { 55 => 0x18, 111 => 0x385, 112 => 0x1b8, 211 => 0x24, 361 => 0x10 },
	'face9size' => { 362 => 0x10 },
	'facebalanceorigi' => { 495 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 495 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 495 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 495 => 'FaceBalanceWarmth' },
	'facedetect' => { 376 => 0x76, 415 => 0x100 },
	'facedetectarea' => { 322 => 0x1201 },
	'facedetectframecrop' => { 322 => 0x1207 },
	'facedetectframesize' => { 55 => 0x3, 111 => 0x1, 112 => 0x4, 211 => 0x1, 322 => 0x1203, 376 => 0x77, 405 => 0xb6 },
	'facedetection' => { 430 => 0x30, 446 => 0x19 },
	'faceelementpositions' => { 128 => 0x4203 },
	'faceelementselected' => { 128 => 0x4005 },
	'faceelementtypes' => { 128 => 0x4201 },
	'faceid' => { 497 => 'FaceID' },
	'faceinfounknown' => { 114 => 0x2089 },
	'facename' => { 415 => 0x123 },
	'faceorientation' => { 112 => 0x8 },
	'faceposition' => { 360 => 0x2, 416 => 0x4 },
	'facepositions' => { 128 => 0x4103 },
	'facerecognition' => { 415 => 0x120 },
	'facesdetected' => { 55 => 0x2, 56 => 0x2, 57 => 0x3, 111 => 0x0, 112 => 0x2, 114 => 0x211c, 128 => 0x4100, 211 => 0x3, 322 => 0x1200, 341 => 0x3f, 360 => 0x0, 405 => 0xb5, 416 => 0x0, 435 => 0x0, 438 => 0x3, 449 => 0x30 },
	'facesrecognized' => { 334 => 0x0 },
	'facewidth' => { 56 => 0x1 },
	'fade' => { 441 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 110 => 0x38 },
	'faithfuloutputshadowpoint' => { 110 => 0x39 },
	'faithfulrawcolortone' => { 110 => 0x31 },
	'faithfulrawcontrast' => { 110 => 0x33 },
	'faithfulrawhighlight' => { 110 => 0x79 },
	'faithfulrawhighlightpoint' => { 110 => 0x36 },
	'faithfulrawlinear' => { 110 => 0x34 },
	'faithfulrawsaturation' => { 110 => 0x32 },
	'faithfulrawshadow' => { 110 => 0x82 },
	'faithfulrawshadowpoint' => { 110 => 0x37 },
	'faithfulrawsharpness' => { 110 => 0x35 },
	'faithfulunsharpmaskfineness' => { 110 => 0xac },
	'faithfulunsharpmaskstrength' => { 110 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 110 => 0xae },
	'far' => { 486 => 'Far' },
	'fastresetlinetime' => { 139 => 0x1860 },
	'feedidentifier' => { 515 => 'FeedIdentifier' },
	'femicroadjustment' => { 85 => 0x111 },
	'ffid' => { 505 => 'ffid' },
	'field' => { 519 => 'field' },
	'fieldcount' => { 323 => 0x103f },
	'fieldofview' => { 401 => "FOV\x00" },
	'fifoenonepixeldelay' => { 139 => 0x1901 },
	'filecreatedate' => { 121 => 'FileCreateDate' },
	'filedatarate' => { 530 => 'fileDataRate' },
	'fileformat' => { 96 => 0x0, 133 => 0x14, 418 => [0x22,0x26], 441 => 0xb000 },
	'filegroupid' => { 121 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 342 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 121 => 'FileModifyDate' },
	'filename' => { 121 => 'FileName' },
	'filenameasdelivered' => { 328 => 'FileNameAsDelivered' },
	'filenumber' => { 58 => 0x1, 65 => 0x8, 98 => 0x1817, 115 => 'Canon-FileNumber', 212 => 0x4, 404 => 0x10 },
	'filenumbermemory' => { 182 => 0x1a },
	'filenumbersequence' => { 298 => '12.2', 303 => '3.1', 304 => '4.1', 305 => '4.1', 307 => '11.1', 308 => '4.3', 313 => '5.2', 314 => 0x48, 315 => 0x48, 316 => 0x48 },
	'filepermissions' => { 121 => 'FilePermissions' },
	'filesource' => { 120 => 0xa300, 128 => 0x8000, 507 => 'FileSource' },
	'fileuserid' => { 121 => 'FileUserID' },
	'fileversion' => { 133 => 0x16 },
	'fillflashautoreduction' => { 83 => 0xe, 84 => 0xe, 91 => 0xa },
	'filllight' => { 501 => 'FillLight', 503 => 'FillLight' },
	'fillorder' => { 120 => 0x10a },
	'filmgraineffect' => { 318 => 0x538 },
	'filmmode' => { 128 => 0x1401, 338 => 0x412, 341 => 0x42 },
	'filmtype' => { 258 => 0x2 },
	'filtereffect' => { 58 => 0xe, 250 => 0x37, 251 => 0x3f, 252 => 0x47, 341 => 0xa1 },
	'filtereffectauto' => { 72 => 0xa0 },
	'filtereffectfaithful' => { 71 => 0x70, 72 => 0x70 },
	'filtereffectlandscape' => { 71 => 0x40, 72 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 71 => 0x88, 72 => 0x88 },
	'filtereffectneutral' => { 71 => 0x58, 72 => 0x58 },
	'filtereffectportrait' => { 71 => 0x28, 72 => 0x28 },
	'filtereffectstandard' => { 71 => 0x10, 72 => 0x10 },
	'filtereffectuserdef1' => { 71 => 0xa0, 72 => 0xb8 },
	'filtereffectuserdef2' => { 71 => 0xb8, 72 => 0xd0 },
	'filtereffectuserdef3' => { 71 => 0xd0, 72 => 0xe8 },
	'finderdisplayduringexposure' => { 84 => 0x1 },
	'finesharpness' => { 376 => 0x70 },
	'finetuneoptcenterweighted' => { 298 => '7.2', 299 => '9.1', 301 => '9.1', 302 => '9.1', 306 => '8.1', 311 => '9.1', 312 => '9.1', 313 => '9.1', 314 => 0x23, 315 => 0x23, 316 => 0x23 },
	'finetuneopthighlightweighted' => { 301 => '46.1', 302 => '46.1', 311 => '46.1', 312 => '46.1', 314 => 0x27, 315 => 0x27, 316 => 0x27 },
	'finetuneoptmatrixmetering' => { 298 => '8.1', 299 => '8.2', 301 => '8.2', 302 => '8.2', 306 => '7.2', 307 => '6.1', 311 => '8.2', 312 => '8.2', 313 => '8.2', 314 => 0x21, 315 => 0x21, 316 => 0x21 },
	'finetuneoptspotmetering' => { 298 => '8.2', 299 => '9.2', 301 => '9.2', 302 => '9.2', 306 => '8.2', 307 => '6.2', 311 => '9.2', 312 => '9.2', 313 => '9.2', 314 => 0x25, 315 => 0x25, 316 => 0x25 },
	'finishexposure' => { 139 => 0xdbd },
	'finishfiletype' => { 139 => 0xdb8 },
	'finishlook' => { 139 => 0xdbc },
	'finishnoise' => { 139 => 0xdba },
	'finishresolution' => { 139 => 0xdb9 },
	'finishsharpening' => { 139 => 0xdbb },
	'firmware' => { 323 => 0x405, 418 => [0x8c,0x17,0x3b], 498 => 'Firmware' },
	'firmware2' => { 418 => 0x57 },
	'firmwaredate' => { 113 => 0x15, 114 => 0x2001, 402 => 0x4, 404 => 0x30 },
	'firmwareid' => { 189 => 0x0 },
	'firmwarename' => { 415 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 65 => 0x1e, 406 => 0x0 },
	'firmwarerevision2' => { 406 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 139 => [0x415,0xce5], 155 => 0x57, 157 => 'FirmwareVersion', 339 => 0x320, 341 => 0x2, 343 => 0x3109, 376 => 0x230, 401 => ['CNFV','FIRM'], 403 => 0x18, 404 => 0x2a, 408 => 0x2 },
	'firmwareversions' => { 385 => 0x301 },
	'firstphotodate' => { 489 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 328 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 132 => 0x16, 496 => 'FixtureIdentifier' },
	'flash' => { 115 => 'XMP-Flash', 120 => 0x9209, 153 => 0x22, 183 => 0x1f, 184 => 0x15, 404 => 0x5a, 507 => 'Flash' },
	'flashaction' => { 428 => 0x3e, 429 => 0x3e, 441 => 0x2017, 446 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 428 => 0x4c, 429 => 0x4c, 446 => 0x77 },
	'flashactionexternal' => { 446 => [0x78,0x7c] },
	'flashactivity' => { 35 => 0x1c },
	'flashbatterylevel' => { 45 => 0x249 },
	'flashbias' => { 341 => 0x24 },
	'flashbits' => { 35 => 0x1d },
	'flashburstpriority' => { 314 => 0x111, 315 => 0x111, 316 => 0x129 },
	'flashbuttonfunction' => { 85 => 0x70e },
	'flashchargelevel' => { 323 => 0x1010 },
	'flashcolorfilter' => { 215 => 0x10, 216 => 0x10, 218 => 0x10 },
	'flashcommandermode' => { 213 => '9.1', 214 => '9.1', 215 => '9.1', 216 => '9.1', 218 => '9.1' },
	'flashcompensation' => { 139 => 0x3f3, 213 => 0xa, 214 => 0xa, 215 => 0xa, 216 => 0x27, 217 => 0xa, 218 => 0xa, 498 => 'FlashCompensation' },
	'flashcontrol' => { 428 => 0x23, 429 => 0x1f, 430 => 0x21 },
	'flashcontrolbuilt-in' => { 307 => '16.1', 308 => '23.1', 310 => '23.1', 311 => '24.1' },
	'flashcontrolmode' => { 213 => '9.2', 214 => '9.2', 215 => '9.2', 216 => '9.2', 218 => '9.2', 224 => 0x214, 239 => 0x148, 240 => 0x1b8, 241 => 0x1a8, 242 => 0x1bc, 243 => 0x1bc, 318 => 0x404 },
	'flashcurtain' => { 341 => 0x48 },
	'flashdefault' => { 185 => 0x42 },
	'flashdevice' => { 323 => 0x1005 },
	'flashdistance' => { 114 => 0x2034 },
	'flashenergy' => { 120 => 0xa20b, 507 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 235 => 0x18 },
	'flashexposurecomp' => { 78 => 0xf, 128 => 0x1011, 160 => 'ExposureComp', 182 => 0x23, 187 => 0x104, 188 => 0x49c1, 235 => 0x12, 318 => 0x401, 323 => 0x1023, 376 => 0x4d, 408 => 0x100b, 418 => [0x3a,0x56], 441 => 0x104 },
	'flashexposurecomp2' => { 279 => 0x4d2 },
	'flashexposurecomp3' => { 215 => 0x1d },
	'flashexposurecomp4' => { 215 => 0x27 },
	'flashexposurecomparea' => { 299 => '38.4', 301 => '38.4', 302 => '38.4', 311 => '38.4', 312 => '38.4', 314 => 0x59, 315 => 0x59, 316 => 0x59 },
	'flashexposurecompset' => { 185 => 0x10, 349 => 0xe, 428 => 0x14, 429 => 0x12, 430 => 0x23, 446 => 0x1f },
	'flashexposurecompset2' => { 446 => [0x26,0x2c] },
	'flashexposureindicator' => { 185 => 0x54 },
	'flashexposureindicatorlast' => { 185 => 0x56 },
	'flashexposureindicatornext' => { 185 => 0x55 },
	'flashexposurelock' => { 58 => 0x19 },
	'flashfired' => { 141 => 0x5d, 160 => 'Fired', 182 => 0x14, 278 => '590.3', 507 => [\'Flash','FlashFired'] },
	'flashfiring' => { 85 => 0x306, 86 => 0x6, 87 => 0x7, 90 => 0x7 },
	'flashfirmwareversion' => { 319 => 0x1002 },
	'flashfocallength' => { 213 => 0xb, 214 => 0xc, 215 => 0xc, 216 => 0xc, 217 => 0xc, 218 => 0x26 },
	'flashfunction' => { 188 => 0x31, 507 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 213 => 0xe, 214 => 0xf, 215 => 0xf, 216 => 0xf, 217 => 0xf, 218 => 0xf, 224 => 0x21a, 239 => 0x14e, 241 => 0x1ae, 242 => 0x1c2, 243 => 0x1c2 },
	'flashgroupacompensation' => { 213 => 0x11, 214 => 0x12, 215 => 0x13, 216 => 0x28, 217 => 0x28, 218 => 0x28 },
	'flashgroupacontrolmode' => { 213 => 0xf, 214 => '16.1', 215 => '17.1', 216 => '17.1', 217 => '17.1', 218 => '17.1' },
	'flashgroupaoutput' => { 213 => 0x11, 214 => 0x12, 215 => 0x13, 216 => 0x28, 217 => 0x28, 218 => 0x28 },
	'flashgroupbcompensation' => { 213 => 0x12, 214 => 0x13, 215 => 0x14, 216 => 0x29, 217 => 0x29, 218 => 0x29 },
	'flashgroupbcontrolmode' => { 213 => 0x10, 214 => '17.1', 215 => '18.1', 216 => '18.1', 217 => '18.1', 218 => '18.1' },
	'flashgroupboutput' => { 213 => 0x12, 214 => 0x13, 215 => 0x14, 216 => 0x29, 217 => 0x29, 218 => 0x29 },
	'flashgroupccompensation' => { 214 => 0x14, 215 => 0x15, 216 => 0x2a, 217 => 0x2a, 218 => 0x2a },
	'flashgroupccontrolmode' => { 214 => '17.2', 215 => '18.2', 216 => '18.2', 217 => '18.2', 218 => '18.2' },
	'flashgroupcoutput' => { 214 => 0x14, 215 => 0x15, 216 => 0x2a, 217 => 0x2a, 218 => 0x2a },
	'flashguidenumber' => { 78 => 0xd, 95 => 0x0, 160 => 'GuideNumber' },
	'flashilluminationpattern' => { 218 => 0x25 },
	'flashintensity' => { 113 => [0x19,0x5], 318 => 0x405 },
	'flashlevel' => { 300 => 0x9, 441 => 0xb048 },
	'flashmake' => { 160 => 'Make' },
	'flashmanufacturer' => { 179 => 'FlashManufacturer' },
	'flashmastercompensation' => { 224 => 0x22e, 239 => 0x162, 241 => 0x1aa, 242 => 0x1be, 243 => 0x1be },
	'flashmastercontrolmode' => { 224 => 0x22c, 239 => 0x160 },
	'flashmasteroutput' => { 224 => 0x232, 239 => 0x166 },
	'flashmetering' => { 182 => 0x3f, 185 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 376 => 0x20a },
	'flashmode' => { 113 => 0x4, 139 => 0x3f2, 141 => 0x5c, 152 => 0x27, 160 => 'Mode', 182 => 0x2, 183 => 0x20, 184 => 0x16, 185 => 0xf, 235 => 0x87, 318 => 0x400, 323 => 0x1004, 376 => 0xc, 383 => 0x4, 407 => 0x20, 408 => 0x100a, 417 => 0x225, 428 => 0x13, 429 => 0x7f, 430 => 0x20, 446 => 0x10, 450 => 0x1138, 451 => 0x1138, 452 => 0x1114, 453 => 0x1190, 454 => 0x116c, 455 => 0x1024, 456 => 0x21c, 457 => 0x21c, 458 => 0x211, 507 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 243 => 0x80e },
	'flashmodebuttonplaybackmode' => { 243 => 0x818 },
	'flashmodel' => { 160 => 'Model', 179 => 'FlashModel', 319 => 0x1001 },
	'flashoptions' => { 357 => 0x2 },
	'flashoptions2' => { 357 => 0x10 },
	'flashoutput' => { 45 => 0x248, 78 => 0x21, 213 => 0xa, 214 => 0xa, 215 => 0xa, 216 => 0x27, 218 => 0x21, 224 => 0x21e, 239 => 0x152, 241 => 0x1b2, 242 => 0x1c6, 243 => 0x1c6 },
	'flashpixversion' => { 120 => 0xa000, 507 => 'FlashpixVersion' },
	'flashredeyemode' => { 507 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 224 => 0x228, 239 => 0x15c, 241 => 0x1bc, 318 => 0x403 },
	'flashreturn' => { 507 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 160 => 'SerialNumber', 319 => 0x1003 },
	'flashsetting' => { 235 => 0x8 },
	'flashshutterspeed' => { 298 => '20.2', 299 => '23.2', 301 => '23.2', 302 => '23.2', 307 => '15.2', 308 => '22.2', 309 => '7.2', 310 => '22.2', 311 => '23.2', 312 => '23.2', 313 => '23.1', 314 => 0x57, 315 => 0x57, 316 => 0x57 },
	'flashsource' => { 213 => 0x4, 214 => 0x4, 215 => 0x4, 216 => 0x4, 217 => 0x4, 218 => 0x4 },
	'flashstatus' => { 364 => 0x0, 446 => [0x82,0x86], 460 => 0x31, 461 => 0x39, 462 => 0x39 },
	'flashstatusbuilt-in' => { 430 => [0x87,0x287] },
	'flashstatusexternal' => { 430 => [0x88,0x288] },
	'flashsyncspeed' => { 298 => '20.1', 299 => '23.1', 301 => '23.1', 302 => '23.1', 307 => '15.1', 308 => '22.1', 310 => '22.1', 311 => '23.1', 312 => '23.1', 314 => 0x53, 315 => 0x53, 316 => 0x53 },
	'flashsyncspeedav' => { 83 => 0x3, 85 => 0x10f, 86 => 0x2, 87 => 0x3, 88 => 0x2, 89 => 0x2, 90 => 0x3, 91 => 0x6 },
	'flashthreshold' => { 95 => 0x1 },
	'flashtype' => { 160 => 'Type', 185 => 0x59, 235 => 0x9, 319 => 0x1000 },
	'flashwarning' => { 308 => '30.1', 309 => '7.1', 313 => '31.1', 341 => 0x62 },
	'flashwirelessoption' => { 224 => 0x234, 239 => 0x15a, 241 => 0x1c8 },
	'flexiblespotposition' => { 441 => 0x201d },
	'flickadvancedirection' => { 314 => 0x25f, 315 => 0x25f, 316 => 0x277 },
	'flickerreduce' => { 417 => 0x218 },
	'flickerreduction' => { 128 => 0x1446, 262 => 0x7 },
	'flickerreductionindicator' => { 257 => 0x532 },
	'flickerreductionshooting' => { 240 => 0x1b4, 241 => 0x1a4, 242 => 0x1b8, 243 => 0x1b8 },
	'flightpitchdegree' => { 117 => 'FlightPitchDegree' },
	'flightrolldegree' => { 117 => 'FlightRollDegree' },
	'flightxspeed' => { 117 => 'FlightXSpeed' },
	'flightyawdegree' => { 117 => 'FlightYawDegree' },
	'flightyspeed' => { 117 => 'FlightYSpeed' },
	'flightzspeed' => { 117 => 'FlightZSpeed' },
	'fliphorizontal' => { 291 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 78 => 0x15, 120 => 0x829d, 138 => 0xfd04, 141 => 0x1e, 143 => 0xfa23, 145 => 0xf103, 148 => 0x13, 150 => 0x3c, 152 => 0x1c, 153 => 0x18, 155 => 0xc, 164 => 'FNumber', 182 => 0xa, 183 => 0x36, 184 => 0x47, 185 => 0x9, 188 => 0x49c7, 233 => 0x38, 340 => 0x35a, 376 => 0x13, 415 => 0xa019, 418 => [0x31,0x49], 428 => 0x1, 429 => 0x1, 446 => [0x20,0x22,0x26], 507 => 'FNumber' },
	'focaldistance' => { 487 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 60 => 0x1, 114 => 0x1d, 120 => 0x920a, 148 => 0x1d, 164 => 'FocalLength', 182 => 0x12, 228 => 0xa, 229 => 0xb, 233 => [0xc,0x3c], 335 => 0x1, 376 => 0x1d, 385 => 0x403, 408 => 0x1500, 427 => 0xe, 454 => 0x1278, 455 => 0x1134, 456 => 0x32c, 457 => 0x32c, 458 => 0x30a, 507 => 'FocalLength' },
	'focallength2' => { 446 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 120 => 0xa405, 415 => 0xa01a, 507 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 427 => 0x10 },
	'focalplaneafpointarea' => { 459 => 0x2 },
	'focalplaneafpointlocation1' => { 459 => 0x6 },
	'focalplaneafpointlocation10' => { 459 => 0x2a },
	'focalplaneafpointlocation11' => { 459 => 0x2e },
	'focalplaneafpointlocation12' => { 459 => 0x32 },
	'focalplaneafpointlocation13' => { 459 => 0x36 },
	'focalplaneafpointlocation14' => { 459 => 0x3a },
	'focalplaneafpointlocation15' => { 459 => 0x3e },
	'focalplaneafpointlocation2' => { 459 => 0xa },
	'focalplaneafpointlocation3' => { 459 => 0xe },
	'focalplaneafpointlocation4' => { 459 => 0x12 },
	'focalplaneafpointlocation5' => { 459 => 0x16 },
	'focalplaneafpointlocation6' => { 459 => 0x1a },
	'focalplaneafpointlocation7' => { 459 => 0x1e },
	'focalplaneafpointlocation8' => { 459 => 0x22 },
	'focalplaneafpointlocation9' => { 459 => 0x26 },
	'focalplaneafpointsused' => { 459 => 0x1 },
	'focalplanediagonal' => { 319 => 0x103, 323 => 0x205 },
	'focalplaneresolutionunit' => { 120 => 0xa210, 507 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 120 => 0xa20e, 507 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 60 => 0x2 },
	'focalplanexunknown' => { 60 => 0x2 },
	'focalplaneyresolution' => { 120 => 0xa20f, 507 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 60 => 0x3 },
	'focalplaneyunknown' => { 60 => 0x3 },
	'focalpointx' => { 487 => 'FocalPointX' },
	'focalpointy' => { 487 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 60 => 0x0 },
	'focalunits' => { 35 => 0x19 },
	'focus' => { 281 => 0x8 },
	'focusarea' => { 182 => 0x31 },
	'focusareaselection' => { 309 => '15.2' },
	'focusbracket' => { 341 => 0xbd },
	'focusbracketstepsize' => { 318 => 0x308 },
	'focuscontinuous' => { 35 => 0x20 },
	'focusdisplayaiservoandmf' => { 85 => 0x515 },
	'focusdistance' => { 164 => 'FocusDistance', 182 => 0x13, 188 => 0x49bb, 228 => 0x9, 229 => 0xa, 233 => [0xb,0x4e], 321 => 0x305, 335 => 0x0, 339 => 0x304, 340 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 58 => 0x15, 78 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 233 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 58 => 0x14, 78 => 0x13 },
	'focusholdbutton' => { 185 => 0x44 },
	'focusinfoversion' => { 321 => 0x0 },
	'focusingscreen' => { 84 => 0x0, 85 => 0x80b, 90 => 0x0 },
	'focuslocation' => { 441 => 0x2027 },
	'focuslocked' => { 181 => 0x14 },
	'focusmode' => { 35 => 0x7, 113 => 0x3, 114 => [0x3003,0xd], 128 => 0x1021, 139 => 0x3f5, 141 => 0x38, 157 => 'FocusMode', 182 => 0x30, 184 => 0xe, 185 => 0xc, 235 => 0x7, 318 => 0x301, 323 => 0x100b, 341 => 0x7, 376 => 0xd, 383 => 0x3, 408 => 0x1006, 421 => [0xb,0x5], 427 => [0x15,0x1d], 428 => 0x4d, 429 => 0x4d, 441 => [0xb042,0xb04e,0x201b], 446 => 0x13, 467 => 0x16 },
	'focusmode2' => { 127 => '0.1', 357 => '3.1', 446 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 300 => '10.1', 425 => 0x14, 426 => 0x15, 428 => 0x10, 429 => 0xf, 430 => 0x6 },
	'focusmodeswitch' => { 185 => 0x58, 428 => 0x2e },
	'focuspeakingdisplay' => { 314 => 0x235, 315 => 0x235, 316 => 0x24d },
	'focuspeakinghighlightcolor' => { 314 => 0x4b, 315 => 0x4b, 316 => 0x4b },
	'focuspeakinglevel' => { 314 => 0x49, 315 => 0x49, 316 => 0x49 },
	'focuspixel' => { 128 => 0x1023 },
	'focuspointlock' => { 314 => 0x1d3, 315 => 0x1d3, 316 => 0x1eb },
	'focuspointpersistence' => { 314 => 0x105, 315 => 0x105, 316 => 0x11b },
	'focuspointwrap' => { 298 => '2.2', 299 => '2.2', 301 => '2.1', 302 => '2.1', 306 => '1.1', 307 => '2.2', 308 => '1.1', 311 => '2.2', 312 => '2.1', 313 => '2.5', 314 => 0x16, 315 => 0x16, 316 => 0x16 },
	'focusposition' => { 1 => 0x2f, 228 => 0x8, 229 => 0x8, 376 => 0x10, 439 => 0x9bb },
	'focusposition2' => { 446 => [0x29,0x2b,0x2f], 467 => 0x2d, 470 => 0x20 },
	'focuspositionhorizontal' => { 194 => 0x2f, 195 => 0x43 },
	'focuspositionvertical' => { 194 => 0x31, 195 => 0x45 },
	'focusprocess' => { 318 => 0x302 },
	'focusrange' => { 35 => 0x12, 323 => 0x100a },
	'focusrangeindex' => { 367 => '3.1' },
	'focusresult' => { 195 => 0x4a },
	'focusringrotation' => { 85 => 0x713 },
	'focussetting' => { 418 => 0x6 },
	'focusshiftautoreset' => { 242 => 0x6da, 243 => 0x748 },
	'focusshiftexposurelock' => { 224 => 0x1b4, 239 => 0xe8, 240 => 0x100, 241 => 0xf4, 242 => 0x104, 243 => 0x104 },
	'focusshiftinterval' => { 224 => 0x1b0, 239 => 0xe4, 240 => 0xfc, 241 => 0xf0, 242 => 0x100, 243 => 0x100 },
	'focusshiftnumbershots' => { 224 => 0x1a8, 239 => 0xdc, 240 => 0xf4, 241 => 0xe8, 242 => 0xf8, 243 => 0xf8 },
	'focusshiftshooting' => { 260 => 0x20 },
	'focusshiftstepwidth' => { 224 => 0x1ac, 239 => 0xe0, 240 => 0xf8, 241 => 0xec, 242 => 0xfc, 243 => 0xfc },
	'focusstatus' => { 427 => 0x19, 428 => 0x53, 429 => 0x53 },
	'focusstepcount' => { 321 => 0x301, 323 => 0x100e },
	'focusstepinfinity' => { 321 => 0x303, 323 => 0x103b },
	'focusstepnear' => { 321 => 0x304, 323 => 0x103c },
	'focusstepsfrominfinity' => { 233 => 0x58 },
	'focustrackinglockon' => { 298 => ['1.5','4.1'], 299 => '1.4', 306 => '0.4', 307 => '3.1', 308 => '0.4', 311 => '1.4' },
	'focuswarning' => { 128 => 0x1301 },
	'foldername' => { 182 => 0x27 },
	'foldernumber' => { 428 => 0x9a, 430 => [0x402,0x114,0x316] },
	'fontcomposite' => { 535 => [\'Fonts','FontsComposite'] },
	'fontface' => { 535 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 535 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 535 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 535 => [\'Fonts','FontsFontName'] },
	'fonts' => { 535 => 'Fonts' },
	'fonttype' => { 535 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 535 => [\'Fonts','FontsVersionString'] },
	'for' => { 392 => 'For' },
	'forcewrite' => { 121 => 'ForceWrite' },
	'format' => { 401 => "\xa9fmt", 486 => 'Format', 504 => 'format', 528 => 'Format' },
	'forwardlock' => { 525 => 'forwardlock' },
	'forwardmatrix1' => { 120 => 0xc714 },
	'forwardmatrix2' => { 120 => 0xc715 },
	'forwardmatrix3' => { 120 => 0xcd34 },
	'fossilspecimen' => { 119 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 119 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 68 => [0x2,0x4] },
	'frameheight' => { 128 => 0x3822 },
	'framenum' => { 387 => 0xd7 },
	'framenumber' => { 128 => 0x8003, 188 => 0x3c, 376 => 0x29 },
	'framerate' => { 68 => [0x1,0x6], 120 => 0xc764, 128 => 0x3820 },
	'framereadouttime' => { 395 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 128 => 0x3821 },
	'framing' => { 519 => 'framing' },
	'freebytes' => { 98 => 0x1 },
	'freememorycardimages' => { 183 => [0x37,0x54], 184 => [0x2d,0x4a], 185 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 128 => 0x1010 },
	'fujimodel' => { 128 => 0x1447 },
	'fujimodel2' => { 128 => 0x1448 },
	'fullhdhighspeedrec' => { 128 => 0x3824 },
	'fullimagesize' => { 441 => 0xb02b },
	'fullpanoheightpixels' => { 489 => 'FullPanoHeightPixels', 490 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 489 => 'FullPanoWidthPixels', 490 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 408 => 0x100d },
	'fullsizeimage' => { 163 => 'data' },
	'fullsizeimagename' => { 163 => '1Name' },
	'fullsizeimagetype' => { 163 => '0Type' },
	'func1button' => { 301 => '14.1', 302 => '14.1', 312 => '14.1', 314 => 0x63, 315 => 0x63, 316 => 0x63 },
	'func1buttonplaybackmode' => { 314 => 0x1a5, 315 => 0x1a5, 316 => 0x1bd },
	'func1buttonplusdials' => { 301 => '42.1', 302 => '42.1', 312 => '42.1' },
	'func2button' => { 301 => '80.1', 302 => '80.1', 312 => '80.1', 314 => 0x73, 315 => 0x73, 316 => 0x73 },
	'func2buttonplaybackmode' => { 314 => 0x1a7, 315 => 0x1a7, 316 => 0x1bf },
	'func2buttonplusdials' => { 301 => '81.1' },
	'func3button' => { 301 => '83.1', 315 => 0x119, 316 => 0x131 },
	'func3buttonplaybackmode' => { 315 => 0x1a9, 316 => 0x1c1 },
	'func4button' => { 315 => 0x175, 316 => 0x18d },
	'func4buttonplaybackmode' => { 315 => 0x1af, 316 => 0x1c7 },
	'funcbutton' => { 298 => ['14.1','15.1'], 299 => '14.1', 307 => '28.1', 308 => '13.1', 311 => '14.1', 313 => '14.1' },
	'funcbuttonplusdials' => { 298 => ['14.2','15.2'], 299 => '14.2', 307 => '31.1', 311 => '42.1' },
	'functionbutton' => { 305 => '13.1', 309 => '5.2' },
	'gainbase' => { 322 => 0x610 },
	'gaincontrol' => { 120 => 0xa407, 507 => 'GainControl' },
	'gainmapmax' => { 512 => 'GainMapMax' },
	'gainmapmin' => { 512 => 'GainMapMin' },
	'gamma' => { 120 => 0xa500, 139 => 0x8fe, 329 => 'gAMA', 346 => 0x11c, 508 => 'Gamma', 512 => 'Gamma' },
	'gammablackpoint' => { 106 => 0xc },
	'gammacolortone' => { 106 => 0x3 },
	'gammacompensatedvalue' => { 134 => 0x91 },
	'gammacontrast' => { 106 => 0x2 },
	'gammacurveoutputrange' => { 106 => 0xf },
	'gammahighlight' => { 106 => 0xa },
	'gammalinear' => { 104 => 0x20200 },
	'gammamidpoint' => { 106 => 0xe },
	'gammasaturation' => { 106 => 0x4 },
	'gammashadow' => { 106 => 0x9 },
	'gammasharpnessstrength' => { 106 => 0x8 },
	'gammaunsharpmaskfineness' => { 106 => 0x6 },
	'gammaunsharpmaskstrength' => { 106 => 0x5 },
	'gammaunsharpmaskthreshold' => { 106 => 0x7 },
	'gammawhitepoint' => { 106 => 0xd },
	'garminsettings' => { 401 => 'pmcc' },
	'garminsoftware' => { 401 => 'uuid' },
	'gdalmetadata' => { 120 => 0xa480 },
	'gdalnodata' => { 120 => 0xa481 },
	'geimagesize' => { 128 => 0x1304 },
	'gemake' => { 130 => 0x300 },
	'gemodel' => { 130 => 0x207 },
	'genre' => { 393 => ['gnre',"\xa9gen"], 395 => 'genre', 401 => ['gnre',"\xa9gen"], 515 => 'Genre', 520 => 'genre', 530 => 'genre' },
	'genrecvid' => { 515 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 515 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 515 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 515 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 393 => 'geID' },
	'geography' => { 521 => 'geography' },
	'geologicalcontext' => { 119 => 'GeologicalContext' },
	'geologicalcontextbed' => { 119 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 119 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 119 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 119 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 119 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 121 => 'Geosync' },
	'geotag' => { 121 => 'Geotag' },
	'geotiffasciiparams' => { 120 => 0x87b1 },
	'geotiffdirectory' => { 120 => 0x87af },
	'geotiffdoubleparams' => { 120 => 0x87b0 },
	'geotime' => { 121 => 'Geotime' },
	'giftftppriority' => { 491 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 117 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 117 => 'GimbalReverse' },
	'gimbalrolldegree' => { 117 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 117 => 'GimbalYawDegree' },
	'globalaltitude' => { 390 => 0x419 },
	'globalangle' => { 390 => 0x40d },
	'good' => { 530 => 'good' },
	'googlehostheader' => { 393 => 'gshh' },
	'googlepingmessage' => { 393 => 'gspm' },
	'googlepingurl' => { 393 => 'gspu' },
	'googleplusuploadcode' => { 120 => 0x9009 },
	'googlesourcedata' => { 393 => 'gssd' },
	'googlestarttime' => { 393 => 'gsst' },
	'googletrackduration' => { 393 => 'gstd' },
	'goprotype' => { 401 => 'GoPr' },
	'gpsaltitude' => { 131 => 0x6, 161 => 'Altitude', 507 => 'GPSAltitude' },
	'gpsaltituderef' => { 131 => 0x5, 507 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 131 => 0x1c, 507 => 'GPSAreaInformation' },
	'gpscoordinates' => { 393 => "\xa9xyz", 395 => 'location.ISO6709', 401 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 131 => 0x1d },
	'gpsdatetime' => { 161 => 'DateTime', 507 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 131 => 0x18, 161 => 'Bearing', 507 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 131 => 0x17, 507 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 131 => 0x1a, 161 => 'Distance', 507 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 131 => 0x19, 507 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 131 => 0x14, 507 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 131 => 0x13 },
	'gpsdestlongitude' => { 131 => 0x16, 507 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 131 => 0x15 },
	'gpsdifferential' => { 131 => 0x1e, 161 => 'Differential', 507 => 'GPSDifferential' },
	'gpsdop' => { 131 => 0xb, 507 => 'GPSDOP' },
	'gpshpositioningerror' => { 131 => 0x1f, 507 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 131 => 0x11, 507 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 131 => 0x10, 507 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 115 => 'GPS-GPSLatitude', 117 => 'GpsLatitude', 131 => 0x2, 161 => 'Latitude', 507 => 'GPSLatitude' },
	'gpslatituderef' => { 131 => 0x1 },
	'gpslongitude' => { 115 => 'GPS-GPSLongitude', 117 => 'GpsLongitude', 131 => 0x4, 161 => 'Longitude', 507 => 'GPSLongitude' },
	'gpslongituderef' => { 131 => 0x3 },
	'gpslongtitude' => { 117 => 'GpsLongtitude' },
	'gpsmapdatum' => { 131 => 0x12, 161 => 'Datum', 507 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 131 => 0xa, 161 => 'MeasureMode', 507 => 'GPSMeasureMode' },
	'gpsposition' => { 115 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 131 => 0x1b, 507 => 'GPSProcessingMethod' },
	'gpssatellites' => { 131 => 0x8, 161 => 'Satellites', 507 => 'GPSSatellites' },
	'gpsspeed' => { 131 => 0xd, 161 => 'Speed', 507 => 'GPSSpeed' },
	'gpsspeedref' => { 131 => 0xc, 507 => 'GPSSpeedRef' },
	'gpsstatus' => { 131 => 0x9, 507 => 'GPSStatus' },
	'gpsstring' => { 139 => 0x402 },
	'gpstimestamp' => { 131 => 0x7 },
	'gpstrack' => { 131 => 0xf, 161 => 'Heading', 507 => 'GPSTrack' },
	'gpstrackref' => { 131 => 0xe, 507 => 'GPSTrackRef' },
	'gpsversionid' => { 131 => 0x0, 507 => 'GPSVersionID' },
	'gradation' => { 318 => 0x50f },
	'gradientbasedcorractive' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 501 => 'GradientBasedCorrections', 503 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 501 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 503 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 501 => 'GrainAmount', 503 => 'GrainAmount' },
	'graineffectroughness' => { 128 => 0x1047 },
	'graineffectsize' => { 128 => 0x104c },
	'grainfrequency' => { 501 => 'GrainFrequency', 503 => 'GrainFrequency' },
	'grainseed' => { 501 => 'GrainSeed', 503 => 'GrainSeed' },
	'grainsize' => { 501 => 'GrainSize', 503 => 'GrainSize' },
	'graymixeraqua' => { 501 => 'GrayMixerAqua', 503 => 'GrayMixerAqua' },
	'graymixerblue' => { 501 => 'GrayMixerBlue', 503 => 'GrayMixerBlue' },
	'graymixergreen' => { 501 => 'GrayMixerGreen', 503 => 'GrayMixerGreen' },
	'graymixermagenta' => { 501 => 'GrayMixerMagenta', 503 => 'GrayMixerMagenta' },
	'graymixerorange' => { 501 => 'GrayMixerOrange', 503 => 'GrayMixerOrange' },
	'graymixerpurple' => { 501 => 'GrayMixerPurple', 503 => 'GrayMixerPurple' },
	'graymixerred' => { 501 => 'GrayMixerRed', 503 => 'GrayMixerRed' },
	'graymixeryellow' => { 501 => 'GrayMixerYellow', 503 => 'GrayMixerYellow' },
	'graypoint' => { 477 => 0x8021 },
	'grayresponseunit' => { 120 => 0x122 },
	'greencurvelimits' => { 109 => 0x1c4 },
	'greencurvepoints' => { 108 => 0x53, 109 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 104 => 0x20913 },
	'greenhue' => { 501 => 'GreenHue', 503 => 'GreenHue' },
	'greensaturation' => { 501 => 'GreenSaturation', 503 => 'GreenSaturation' },
	'griddisplay' => { 298 => '13.3', 299 => '4.3', 301 => '4.2', 302 => '4.2', 303 => '2.2', 307 => '10.5', 308 => '3.4', 309 => '6.1', 311 => '4.4', 312 => '4.2', 313 => '4.2' },
	'gripbatteryadload' => { 355 => 0x5 },
	'gripbatteryadnoload' => { 355 => 0x4 },
	'gripbatterystate' => { 355 => '1.2' },
	'group' => { 501 => 'Group', 503 => 'Group' },
	'groupareaafillumination' => { 299 => '46.4', 302 => '47.4', 311 => '47.4' },
	'grouping' => { 393 => ['grup',"\xa9grp"], 401 => "\xa9grp" },
	'guid' => { 393 => 'GUID' },
	'h2resetblackpixels' => { 139 => 0x18a6 },
	'h3resetblackcolumns' => { 139 => 0x18ce },
	'h3resetblackpixels' => { 139 => 0x18b0 },
	'halftonehints' => { 120 => 0x141 },
	'hardlink' => { 121 => 'HardLink' },
	'hasalternative' => { 520 => 'hasAlternative' },
	'hascorrection' => { 520 => 'hasCorrection' },
	'hascorrectiona-lang' => { 520 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 520 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 520 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 501 => 'HasCrop', 503 => 'HasCrop' },
	'hasextendedxmp' => { 532 => 'HasExtendedXMP' },
	'hassettings' => { 501 => 'HasSettings', 503 => 'HasSettings' },
	'hastranslation' => { 520 => 'hasTranslation' },
	'hasvisibleoverprint' => { 535 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 535 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 239 => 0x35a },
	'hdmioutputresolution' => { 240 => 0x710, 241 => 0x610, 242 => 0x640, 243 => 0x6a8 },
	'hdmiviewassist' => { 315 => 0x20f, 316 => 0x227 },
	'hdr' => { 61 => 0x1, 220 => 0x4, 221 => 0x4, 240 => 0x23a, 243 => 0x23a, 341 => 0x9e, 376 => 0x85, 441 => 0x200a },
	'hdrcapacitymax' => { 512 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 512 => 'HDRCapacityMin' },
	'hdreditmode' => { 501 => 'HDREditMode', 503 => 'HDREditMode' },
	'hdreffect' => { 61 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 220 => 0x5, 221 => 0x5, 240 => 0x246, 243 => 0x246, 430 => 0x2e, 446 => 0x17 },
	'hdrlevel2' => { 220 => 0x7 },
	'hdrpmakernote' => { 484 => 'hdrp_makernote' },
	'hdrsetting' => { 430 => 0x2d, 446 => 0x16, 450 => 0x1148, 451 => 0x1148, 452 => 0x1124, 453 => 0x11a0, 454 => 0x117c, 455 => 0x1034, 456 => 0x22c, 457 => 0x22c, 458 => 0x21f },
	'hdrsmoothing' => { 220 => 0x6 },
	'hdvideo' => { 393 => 'hdvd' },
	'headline' => { 132 => 0x69, 515 => 'Headline', 518 => 'Headline' },
	'hierarchicalkeywords' => { 172 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 172 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 172 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 172 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 172 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 172 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 172 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 493 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 119 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 240 => 0x48, 242 => 0x48, 243 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 240 => 0x27c, 242 => 0x27c, 243 => 0x27c },
	'highisomultiplierblue' => { 346 => 0x1a },
	'highisomultipliergreen' => { 346 => 0x19 },
	'highisomultiplierred' => { 346 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 63 => 0x5, 85 => 0x202, 235 => 0xb1, 376 => 0x71, 428 => 0x2c, 429 => 0x26, 430 => 0x26, 441 => 0x2009, 446 => 0x12, 473 => 0x42 },
	'highisonoisereduction2' => { 441 => 0xb050 },
	'highlight' => { 418 => 0xf },
	'highlight2012' => { 501 => 'Highlight2012', 503 => 'Highlight2012' },
	'highlightadj' => { 104 => 0x2030c },
	'highlightcolordistortreduct' => { 477 => 0x8026 },
	'highlightlinearitylimit' => { 415 => 0xa025 },
	'highlightprotection' => { 290 => 0x6 },
	'highlightrecovery' => { 501 => 'HighlightRecovery', 503 => 'HighlightRecovery' },
	'highlights' => { 441 => 0x2033, 495 => 'Highlights' },
	'highlights2012' => { 501 => 'Highlights2012', 503 => 'Highlights2012' },
	'highlightsadj' => { 477 => 0x9019 },
	'highlightshadow' => { 341 => 0xad },
	'highlighttone' => { 128 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 63 => 0x3, 85 => 0x203 },
	'highlightwarning' => { 341 => 0x8002 },
	'highlowkeyadj' => { 376 => 0x6c },
	'highspeedsync' => { 185 => 0x5, 314 => 0x55, 315 => 0x55, 316 => 0x55, 428 => 0x2, 429 => 0x2 },
	'hintversion' => { 401 => 'hinv' },
	'histogramxml' => { 291 => 0x83a1a25 },
	'history' => { 518 => 'History', 531 => 'History' },
	'historyaction' => { 531 => [\'History','HistoryAction'] },
	'historychanged' => { 531 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 531 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 531 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 531 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 531 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 139 => 0xc88 },
	'holefilldeltathreshold' => { 139 => 0xc7e },
	'hometowncity' => { 114 => 0x3006, 376 => 0x23, 382 => 0x2 },
	'hometowncitycode' => { 383 => 0x1000 },
	'hometowndst' => { 376 => 0x25, 382 => '0.2' },
	'hostcomputer' => { 120 => 0x13c },
	'hostsoftwarerendering' => { 139 => 0xce7 },
	'hue' => { 190 => 0x3b, 251 => 0x3d, 252 => 0x45, 376 => 0x67 },
	'hueadj' => { 294 => 0x2f, 477 => 0x8019 },
	'hueadjust' => { 408 => 0x1016 },
	'hueadjustment' => { 183 => 0x4a, 184 => 0x40, 235 => 0x92, 250 => 0x36 },
	'hueadjustmentaqua' => { 501 => 'HueAdjustmentAqua', 503 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 501 => 'HueAdjustmentBlue', 503 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 501 => 'HueAdjustmentGreen', 503 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 501 => 'HueAdjustmentMagenta', 503 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 501 => 'HueAdjustmentOrange', 503 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 501 => 'HueAdjustmentPurple', 503 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 501 => 'HueAdjustmentRed', 503 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 501 => 'HueAdjustmentYellow', 503 => 'HueAdjustmentYellow' },
	'huesetting' => { 326 => 0x1011 },
	'humanobservation' => { 119 => 'HumanObservation' },
	'humanobservationday' => { 119 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 119 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 119 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 119 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 119 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 119 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 119 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 119 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 119 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 119 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 119 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 119 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 119 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 119 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 119 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 119 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 119 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 119 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 119 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 119 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 120 => 0x9401, 508 => 'Humidity' },
	'icc_profile' => { 121 => 'ICC_Profile' },
	'iccprofilename' => { 518 => 'ICCProfile' },
	'iconuri' => { 401 => 'icnu' },
	'idccreativestyle' => { 477 => 0x8000 },
	'idcpreviewlength' => { 477 => 0x202 },
	'idcpreviewstart' => { 477 => 0x201 },
	'identification' => { 119 => 'Identification' },
	'identificationid' => { 119 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 119 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 119 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 119 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 119 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 119 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 119 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 504 => 'identifier', 528 => 'Identifier' },
	'ifcameramodel' => { 139 => 0x9c8 },
	'illuminantdata1' => { 120 => 0xcd35 },
	'illuminantdata2' => { 120 => 0xcd36 },
	'illuminantdata3' => { 120 => 0xcd37 },
	'illumination' => { 309 => '0.5', 403 => 0x48 },
	'imageabsolutex' => { 139 => 0x3fe },
	'imageabsolutey' => { 139 => 0x3ff },
	'imageadjustment' => { 235 => 0x80, 281 => 0x5 },
	'imagealterationconstraints' => { 328 => 'ImageAlterationConstraints' },
	'imagearea' => { 267 => 0x10, 270 => 0x10 },
	'imageareaoffset' => { 376 => 0x38 },
	'imageauthentication' => { 235 => 0x20 },
	'imageboundary' => { 235 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 128 => 0x1438, 235 => 0xa5, 444 => 0x11b },
	'imagecreator' => { 328 => 'ImageCreator' },
	'imagecreatorid' => { 328 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 328 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 328 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 139 => 0x41f },
	'imagecropy' => { 139 => 0x420 },
	'imagedata' => { 488 => 'Data' },
	'imagedatasize' => { 235 => 0xa2 },
	'imagedescription' => { 120 => 0x10e, 526 => 'ImageDescription' },
	'imageduplicationconstraints' => { 328 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 291 => 0xfe443a45 },
	'imageeditcount' => { 376 => 0x41 },
	'imageediting' => { 376 => 0x32 },
	'imageeditingsoftware' => { 120 => 0xa43b },
	'imageeditor' => { 120 => 0xa438 },
	'imageeffects' => { 408 => 0x1010 },
	'imagefileconstraints' => { 328 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 328 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 328 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 128 => 0x1436 },
	'imageheight' => { 120 => 0x101, 189 => 0xc, 385 => 0x10d, 486 => 'ImageHeight', 526 => 'ImageLength' },
	'imagehistory' => { 120 => 0x9213, 506 => 'ImageHistory' },
	'imageidnumber' => { 336 => 0x340 },
	'imagemimetype' => { 488 => 'Mime' },
	'imagenumber' => { 120 => 0x9211, 157 => 'ImageNumber', 183 => 0xae, 184 => 0x5e, 385 => 0x113, 428 => 0x9b, 430 => [0x400,'276.1',0x314], 498 => 'ImageNumber' },
	'imagenumber2' => { 184 => 0x62 },
	'imageoptimization' => { 235 => 0xa9 },
	'imageorientation' => { 132 => 0x83 },
	'imageprocessing' => { 235 => 0x1a },
	'imageprocessingfiledatecreated' => { 139 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 139 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 322 => 0x0 },
	'imagequality' => { 157 => 'ImageQuality', 269 => '723.2', 270 => '732.2', 278 => '708.1', 341 => 0x1 },
	'imagequality2' => { 318 => 0x603 },
	'imagerank' => { 491 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 139 => 0x600 },
	'imagerboardversion' => { 139 => 0x439 },
	'imagercols' => { 139 => 0x17d4 },
	'imageref' => { 513 => 'ImageRef' },
	'imageregion' => { 515 => 'ImageRegion' },
	'imageregionboundary' => { 515 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 515 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 515 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 515 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 515 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 515 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 515 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 515 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 515 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 515 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 139 => 0x944 },
	'imageresolutionjpg' => { 139 => 0x945 },
	'imagereview' => { 300 => '0.4', 309 => '0.4' },
	'imagereviewmonitorofftime' => { 299 => '21.1', 301 => '21.1', 302 => '21.1', 306 => '20.1', 311 => '21.1', 312 => '21.1', 314 => 0x39, 315 => 0x39, 316 => 0x39 },
	'imagereviewtime' => { 298 => '25.1', 300 => '2.1', 303 => '19.1', 304 => '20.1', 305 => '20.1', 307 => '9.2', 308 => '20.1', 313 => '21.2' },
	'imagerfiledatecreated' => { 139 => 0x9c5 },
	'imagerfileproductionlevel' => { 139 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 139 => 0x9c7 },
	'imagerotated' => { 152 => 0x2a },
	'imagerpowerondelaymsec' => { 139 => 0x5fd },
	'imagerrows' => { 139 => 0x17de },
	'imagesegmentlines' => { 139 => 0x184d },
	'imagesegmentstartline' => { 139 => 0x184c },
	'imagesize' => { 163 => 'ImageSize' },
	'imagesizeraw' => { 235 => 0x3e },
	'imagesizerestriction' => { 523 => 'imageSizeRestriction' },
	'imagesourcedata' => { 120 => 0x935c },
	'imagespace' => { 139 => 0x909 },
	'imagestabilization' => { 35 => 0x22, 114 => 0x3020, 128 => 0x1422, 157 => 'ImageStabilization', 183 => 0xbd, 184 => 0x71, 185 => 0x57, 186 => 0x0, 187 => [0x18,0x107,0x113], 188 => 0x49c2, 235 => 0xac, 318 => 0x604, 321 => 0x1600, 341 => 0x1a, 433 => 0x12, 434 => 0x11, 441 => 0xb026 },
	'imagestabilization2' => { 432 => 0xa },
	'imagestabilizationsetting' => { 188 => 0x14, 428 => 0x3d, 429 => 0x3d, 439 => 0x14 },
	'imagestyle' => { 428 => 0x2d, 429 => 0x27 },
	'imagesupplier' => { 328 => 'ImageSupplier' },
	'imagesupplierid' => { 328 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 328 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 328 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 122 => 0x1 },
	'imagetemperaturemin' => { 122 => 0x2 },
	'imagetone' => { 376 => 0x4f },
	'imagetype' => { 132 => 0x82, 328 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 65 => 0x28, 120 => 0xa420, 506 => 'ImageUniqueID', 507 => 'ImageUniqueID' },
	'imagewidth' => { 120 => 0x100, 189 => 0xe, 385 => 0x10c, 486 => 'ImageWidth', 526 => 'ImageWidth' },
	'inclinationangle' => { 477 => 0x900f },
	'inclinationcorrection' => { 477 => 0x900e },
	'incrementaltemperature' => { 501 => 'IncrementalTemperature', 503 => 'IncrementalTemperature' },
	'incrementaltint' => { 501 => 'IncrementalTint', 503 => 'IncrementalTint' },
	'industry' => { 520 => 'industry', 521 => 'industry' },
	'infobuttonwhenshooting' => { 85 => 0x409 },
	'information' => { 395 => 'information', 401 => "\xa9inf" },
	'infourl' => { 401 => 'infu' },
	'infraredilluminator' => { 402 => 0x28 },
	'ingredientexclusion' => { 522 => 'ingredientExclusion' },
	'ingredients' => { 531 => 'Ingredients' },
	'ingredientsalternatepaths' => { 531 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 531 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 531 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 531 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 531 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 531 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 531 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 531 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 531 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 531 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 531 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 531 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 531 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 531 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 531 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 531 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 531 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 531 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 531 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 531 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 531 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 531 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 531 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 85 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 489 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 489 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 180 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 489 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 489 => 'InitialViewHeadingDegrees', 490 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 489 => 'InitialViewPitchDegrees', 490 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 489 => 'InitialViewRollDegrees', 490 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 298 => '4.4' },
	'initialzoomsetting' => { 298 => '9.3', 307 => '27.3' },
	'inkset' => { 120 => 0x14c },
	'inputprofile' => { 139 => 0x1389 },
	'instanceid' => { 531 => 'InstanceID' },
	'instantplaybacksetup' => { 185 => 0x3e },
	'instantplaybacktime' => { 185 => 0x3d },
	'instructions' => { 518 => 'Instructions' },
	'instrument' => { 530 => 'instrument' },
	'integrationtime' => { 139 => 0x423 },
	'intellectualgenre' => { 514 => 'IntellectualGenre' },
	'intelligentauto' => { 441 => 0xb052, 469 => 0xd, 470 => 0xe, 471 => 0xd },
	'intelligentcontrast' => { 53 => 0x4 },
	'intelligentd-range' => { 341 => 0x79 },
	'intelligentexposure' => { 341 => 0x5d },
	'intelligentresolution' => { 341 => 0x70 },
	'interchangecolorspace' => { 134 => 0x40 },
	'intergraphmatrix' => { 120 => 0x8480 },
	'internalflash' => { 182 => 0x2b, 298 => '23.1', 300 => '8.1', 303 => '22.1', 305 => '23.1', 309 => '8.1', 313 => '24.1', 321 => 0x1208 },
	'internalflashae1' => { 323 => 0x1021 },
	'internalflashae1_0' => { 323 => 0x101d },
	'internalflashae2' => { 323 => 0x1022 },
	'internalflashae2_0' => { 323 => 0x101e },
	'internalflashmode' => { 364 => 0x1 },
	'internalflashstrength' => { 364 => 0x3 },
	'internalflashtable' => { 323 => 0x1024 },
	'internallensserialnumber' => { 415 => 0xa005 },
	'internalndfilter' => { 341 => 0x9d },
	'internalserialnumber' => { 65 => 0x96, 77 => 0x9, 128 => 0x10, 188 => 0x49dc, 317 => 0x18, 319 => 0x102, 338 => 0x500, 341 => 0x25, 356 => 0x4, 408 => 0x5, 460 => [0x7c,0xf0], 461 => 0x88, 462 => [0x88,0x8a], 463 => 0x38 },
	'interopindex' => { 120 => 0x1, 508 => 'InteroperabilityIndex' },
	'interopversion' => { 120 => 0x2 },
	'interval' => { 257 => 0x20 },
	'intervaldurationhours' => { 239 => 0xa0, 240 => 0xb8 },
	'intervaldurationminutes' => { 239 => 0xa4, 240 => 0xbc },
	'intervaldurationseconds' => { 239 => 0xa8, 240 => 0xc0 },
	'intervalexposuresmoothing' => { 224 => 0x184, 239 => 0xb8, 240 => 0xd0 },
	'intervalframe' => { 257 => 0x24 },
	'intervallength' => { 182 => 0x10 },
	'intervalmode' => { 182 => 0x26 },
	'intervalnumber' => { 182 => 0x11 },
	'intervalpriority' => { 224 => 0x186, 239 => 0xba, 240 => 0xd2 },
	'intervals' => { 224 => 0x17c, 239 => 0xb0, 240 => 0xc8, 241 => 0xbc, 242 => 0xcc, 243 => 0xcc },
	'intervalshooting' => { 225 => 0x24, 259 => 0x24, 260 => 0x28, 376 => 0x92 },
	'introtime' => { 530 => 'introTime' },
	'introtimescale' => { 530 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 530 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 139 => 0xdae },
	'ipfcameramodel' => { 139 => 0xe4d },
	'iptc' => { 121 => 'IPTC' },
	'iptc-naa' => { 120 => 0x83bb, 346 => 0x83bb },
	'iptcbitspersample' => { 134 => 0x56 },
	'iptcdigest' => { 390 => 0x425 },
	'iptcimageheight' => { 134 => 0x1e },
	'iptcimagerotation' => { 134 => 0x66 },
	'iptcimagewidth' => { 134 => 0x14 },
	'iptclastedited' => { 515 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 134 => 0xa },
	'iptcpixelheight' => { 134 => 0x32 },
	'iptcpixelwidth' => { 134 => 0x28 },
	'isalternativeof' => { 520 => 'isAlternativeOf' },
	'isbn' => { 520 => 'isbn' },
	'iscorrectionof' => { 520 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 110 => 0x3 },
	'ismergedhdr' => { 498 => 'IsMergedHDR' },
	'ismergedpanorama' => { 498 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 113 => 0x14, 114 => [0x3014,0x14], 120 => 0x8827, 138 => 0xfd06, 139 => 0x1784, 141 => 0x60, 143 => [0xfa2e,0xfa46], 144 => [0x27,0x28], 145 => 0xf105, 148 => 0x14, 150 => 0x4e, 152 => 0x1e, 153 => 0x1a, 155 => 0x34, 157 => 'ISO', 182 => 0x8, 188 => 0x49ba, 223 => 0x0, 235 => 0x2, 341 => 0xd1, 346 => 0x17, 376 => [0x8b,0x14], 383 => 0x14, 385 => 0x105, 415 => 0xa014, 418 => 0x86, 439 => 0x6f, 446 => [0x1f,0x21,0x25], 507 => 'ISOSpeedRatings' },
	'iso2' => { 223 => 0x6, 264 => 0x265, 265 => 0x25c, 266 => 0x265, 267 => 0x221, 268 => 0x25d, 269 => 0x256, 270 => 0x25d, 273 => 0x2b5, 276 => 0x265, 280 => 0x2b5 },
	'isoauto' => { 357 => '14.4' },
	'isoautoflashlimit' => { 240 => 0x156, 241 => 0x146, 242 => 0x15a, 243 => 0x15a },
	'isoautohilimit' => { 222 => 0x5, 240 => 0x154, 241 => 0x144, 242 => 0x158, 243 => 0x158, 262 => 0x5, 272 => 0x18eb },
	'isoautomax' => { 440 => 0x4 },
	'isoautomin' => { 440 => 0x2 },
	'isoautoparameters' => { 376 => 0x7a },
	'isoautoshuttertime' => { 222 => 0x4, 240 => 0x15e, 241 => 0x14e, 242 => 0x162, 243 => 0x162, 262 => 0x4, 272 => 0x18ea },
	'isobutton' => { 243 => 0x796 },
	'isocalibrationgain' => { 139 => 0x89f },
	'isodisplay' => { 301 => '4.1', 302 => '4.1', 303 => '2.3', 304 => '3.3', 305 => '3.3', 308 => '3.3', 311 => '4.3', 312 => '4.1', 313 => '4.3' },
	'isoexpansion' => { 85 => 0x103, 86 => 0x7, 87 => 0x8, 90 => 0x8, 223 => 0x4 },
	'isoexpansion2' => { 223 => 0xa },
	'isofloor' => { 357 => 0x6 },
	'isoselected' => { 340 => 0x359 },
	'isoselection' => { 235 => 0xf },
	'isosensitivitystep' => { 306 => '6.2', 308 => '6.2' },
	'isosetting' => { 141 => 0x5e, 153 => 0x14, 157 => 'ISOSetting', 182 => 0x24, 183 => 0x26, 184 => 0x1c, 185 => 0x13, 190 => 0x6, 235 => 0x13, 357 => '17.3', 407 => 0x27, 428 => 0x16, 429 => 0x14, 430 => 0x2, 439 => 0x6d, 440 => 0x0 },
	'isospeed' => { 120 => 0x8833, 508 => 'ISOSpeed' },
	'isospeedexpansion' => { 84 => 0x3 },
	'isospeedincrements' => { 85 => 0x102 },
	'isospeedlatitudeyyy' => { 120 => 0x8834, 508 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 120 => 0x8835, 508 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 85 => 0x103 },
	'isostepsize' => { 298 => '6.1', 299 => '7.2', 301 => '7.2', 302 => '7.2', 307 => '4.1', 311 => '7.2', 312 => '7.2', 314 => 0x15d, 315 => 0x15d, 316 => 0x175 },
	'isovalue' => { 323 => 0x1001 },
	'isrc' => { 393 => 'xid ' },
	'isrccode' => { 401 => "\xa9isr" },
	'issn' => { 520 => 'issn' },
	'issueidentifier' => { 520 => 'issueIdentifier' },
	'issuename' => { 520 => 'issueName' },
	'issueteaser' => { 520 => 'issueTeaser' },
	'issuetype' => { 520 => 'issueType' },
	'istranslationof' => { 520 => 'isTranslationOf' },
	'itemsubtype' => { 179 => 'ItemSubType' },
	'itunesu' => { 393 => 'itnu' },
	'jobid' => { 132 => 0xb8 },
	'jobname' => { 509 => 'JobName' },
	'jobref' => { 529 => 'JobRef' },
	'jobrefid' => { 529 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 529 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 529 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 509 => 'JobStatus' },
	'jpeg-heifswitch' => { 441 => 0x2039 },
	'jpeghandling' => { 501 => 'JPEGHandling', 503 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 341 => 0x43, 343 => 0x3034, 441 => 0xb047 },
	'jpegsize' => { 343 => 0x303a },
	'jpgcompression' => { 226 => 0x24, 235 => 0x44, 267 => '671.1' },
	'jpgfromraw' => { 98 => 0x2007, 115 => 'Exif-JpgFromRaw', 346 => 0x2e },
	'jpgfromrawlength' => { 120 => [0x117,0x202] },
	'jpgfromrawstart' => { 120 => [0x111,0x201] },
	'jpgrecordedpixels' => { 357 => '14.1' },
	'jurisdiction' => { 499 => 'jurisdiction' },
	'keepexposure' => { 314 => 0x237, 315 => 0x237, 316 => 0x24f },
	'kelvinwb_01' => { 365 => 0x5 },
	'kelvinwb_02' => { 365 => 0x9 },
	'kelvinwb_03' => { 365 => 0xd },
	'kelvinwb_04' => { 365 => 0x11 },
	'kelvinwb_05' => { 365 => 0x15 },
	'kelvinwb_06' => { 365 => 0x19 },
	'kelvinwb_07' => { 365 => 0x1d },
	'kelvinwb_08' => { 365 => 0x21 },
	'kelvinwb_09' => { 365 => 0x25 },
	'kelvinwb_10' => { 365 => 0x29 },
	'kelvinwb_11' => { 365 => 0x2d },
	'kelvinwb_12' => { 365 => 0x31 },
	'kelvinwb_13' => { 365 => 0x35 },
	'kelvinwb_14' => { 365 => 0x39 },
	'kelvinwb_15' => { 365 => 0x3d },
	'kelvinwb_16' => { 365 => 0x41 },
	'kelvinwb_daylight' => { 365 => 0x1 },
	'kerneldenominators' => { 139 => 0x933 },
	'key' => { 530 => 'key' },
	'keystonecompensation' => { 322 => 0x1900 },
	'keystonedirection' => { 322 => 0x1901 },
	'keystonevalue' => { 322 => 0x1906 },
	'keyword' => { 393 => 'keyw', 520 => 'keyword' },
	'keywordinfo' => { 172 => 'Keywords' },
	'keywords' => { 132 => 0x19, 158 => 'Keywords', 327 => 'Keywords', 392 => 'Keywords', 395 => 'keywords', 496 => 'keywords', 517 => 'Keywords', 528 => 'Keywords' },
	'killdate' => { 520 => 'killDate' },
	'killdatea-platform' => { 520 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 520 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 138 => 0xf908, 141 => 0xe, 143 => [0xfa1e,0xfa52], 149 => 0x70 },
	'kodakimagewidth' => { 138 => 0xf907, 141 => 0xc, 143 => [0xfa1d,0xfa51], 149 => 0x6c },
	'kodakinfotype' => { 138 => 0xfa00 },
	'kodaklook' => { 139 => 0xe4c },
	'kodaklookprofile' => { 139 => 0x138a },
	'kodakmaker' => { 149 => 0x8 },
	'kodakmodel' => { 141 => 0x0, 149 => 0x28 },
	'kodaktag' => { 139 => 0x3ea },
	'kodakversion' => { 139 => 0x0 },
	'label' => { 331 => 'Label', 528 => 'Label' },
	'labelname1' => { 513 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 513 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 341 => 0x6f },
	'landscapeoutputhighlightpoint' => { 110 => 0x26 },
	'landscapeoutputshadowpoint' => { 110 => 0x27 },
	'landscaperawcolortone' => { 110 => 0x1f },
	'landscaperawcontrast' => { 110 => 0x21 },
	'landscaperawhighlight' => { 110 => 0x77 },
	'landscaperawhighlightpoint' => { 110 => 0x24 },
	'landscaperawlinear' => { 110 => 0x22 },
	'landscaperawsaturation' => { 110 => 0x20 },
	'landscaperawshadow' => { 110 => 0x80 },
	'landscaperawshadowpoint' => { 110 => 0x25 },
	'landscaperawsharpness' => { 110 => 0x23 },
	'landscapeunsharpmaskfineness' => { 110 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 110 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 110 => 0xa2 },
	'language' => { 240 => 0x692, 241 => 0x592, 242 => 0x5c2, 243 => 0x5da, 504 => 'language' },
	'languageidentifier' => { 132 => 0x87 },
	'largestvalidinteriorrectheight' => { 489 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 489 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 489 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 489 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 182 => 0x1b },
	'lastkeywordiptc' => { 179 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 179 => 'LastKeywordXMP' },
	'lastphotodate' => { 489 => 'LastPhotoDate' },
	'lasturl' => { 531 => 'LastURL' },
	'lateralchromaticaberration' => { 441 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 498 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 119 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 119 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 119 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 119 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 119 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 117 => 'Latitude' },
	'lc1' => { 367 => 0x2 },
	'lc10' => { 367 => 0xb },
	'lc11' => { 367 => 0xc },
	'lc12' => { 367 => 0xd },
	'lc14' => { 367 => 0xf },
	'lc15' => { 367 => 0x10 },
	'lc3' => { 367 => 0x4 },
	'lc4' => { 367 => 0x5 },
	'lc5' => { 367 => 0x6 },
	'lc6' => { 367 => 0x7 },
	'lc7' => { 367 => 0x8 },
	'lc8' => { 367 => 0x9 },
	'lcddisplayatpoweron' => { 85 => 0x811, 89 => 0xa },
	'lcddisplayreturntoshoot' => { 90 => 0x12 },
	'lcdillumination' => { 298 => '17.5', 299 => '5.2', 301 => '5.1', 302 => '5.1', 307 => '10.3', 308 => '4.2', 311 => '5.2', 312 => '5.1', 313 => '5.4', 314 => 0x101, 315 => 0x101, 316 => 0x117 },
	'lcdilluminationduringbulb' => { 85 => 0x408 },
	'lcdmatrix' => { 139 => 0xe74 },
	'lcdmatrixchickfix' => { 139 => 0xe75 },
	'lcdmatrixmarvin' => { 139 => 0xe76 },
	'lcdpanels' => { 84 => 0x8 },
	'lcheditor' => { 291 => 0x8ae85e },
	'legacyiptcdigest' => { 518 => 'LegacyIPTCDigest' },
	'legalcode' => { 499 => 'legalcode' },
	'lens' => { 120 => 0xfdea, 235 => 0x84, 498 => 'Lens' },
	'lensafstopbutton' => { 83 => 0x11, 84 => 0x13, 85 => 0x506, 86 => 0x10, 87 => 0x12, 90 => 0x13, 91 => 0x9 },
	'lensaperturerange' => { 418 => [0x30,0x48] },
	'lenscontrolring' => { 314 => 0xad, 315 => 0xad, 316 => 0xad },
	'lenscorrectionsettings' => { 506 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 498 => 'LensDistortInfo' },
	'lensdistortionparams' => { 323 => 0x206 },
	'lensdriveend' => { 233 => 0x56 },
	'lensdrivenoaf' => { 85 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 430 => 0x3f0, 476 => 0xd },
	'lensfirmware' => { 409 => 0x20, 415 => 0xa004 },
	'lensfirmwareversion' => { 319 => 0x204, 341 => 0x60, 430 => 0x3f3, 476 => 0x14 },
	'lensfocallength' => { 104 => 0xf0512, 367 => 0x9 },
	'lensfocalrange' => { 418 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 299 => '55.1', 301 => '52.1', 302 => '52.1', 311 => '52.1', 312 => '52.1' },
	'lensformat' => { 454 => 0x1891, 456 => 0x18bd, 457 => 0x18ed, 458 => 0x17f1, 460 => 0x106, 461 => 0x106, 472 => 0x603, 473 => 0x5d },
	'lensfstops' => { 227 => 0x7, 228 => 0xc, 229 => 0xd, 233 => 0xe, 235 => 0x8b, 367 => '0.3' },
	'lensfunc1button' => { 314 => 0x9f, 315 => 0x9f, 316 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 243 => 0x810 },
	'lensfunc2button' => { 314 => 0xa7, 315 => 0xa7, 316 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 243 => 0x812 },
	'lensid' => { 233 => 0x30, 498 => 'LensID' },
	'lensidnumber' => { 227 => 0x6, 228 => 0xb, 229 => 0xc, 233 => 0xd },
	'lensinfo' => { 120 => 0xa432, 373 => 0x2a, 498 => 'LensInfo', 508 => 'LensSpecification' },
	'lenskind' => { 367 => 0x1 },
	'lensmake' => { 120 => 0xa433, 164 => 'Make', 508 => 'LensMake' },
	'lensmanualdistortionamount' => { 501 => 'LensManualDistortionAmount', 503 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 179 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 418 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 65 => 0x95, 120 => 0xa434, 164 => 'Model', 179 => 'LensModel', 230 => 0x18a, 231 => 0x18b, 232 => 0x2ac, 319 => 0x203, 373 => 0xc, 385 => 0x412, 508 => 'LensModel' },
	'lensmodulationoptimizer' => { 128 => 0x1045 },
	'lensmount' => { 430 => 0x99, 454 => 0x1892, 456 => 0x18be, 457 => 0x18ee, 458 => 0x17f2, 460 => 0x105, 461 => 0x105, 472 => 0x604, 473 => 0x5e },
	'lensmount2' => { 476 => 0x8 },
	'lensmounttype' => { 233 => 0x35 },
	'lenspositionabsolute' => { 233 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 501 => 'LensProfileChromaticAberrationScale', 503 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 501 => 'LensProfileDigest', 503 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 501 => 'LensProfileDistortionScale', 503 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 501 => 'LensProfileEnable', 503 => 'LensProfileEnable' },
	'lensprofilefilename' => { 501 => 'LensProfileFilename', 503 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 501 => 'LensProfileIsEmbedded', 503 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 501 => 'LensProfileMatchKeyCameraModelName', 503 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 501 => 'LensProfileMatchKeyExifMake', 503 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 501 => 'LensProfileMatchKeyExifModel', 503 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 501 => 'LensProfileMatchKeyIsRaw', 503 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 501 => 'LensProfileMatchKeyLensID', 503 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 501 => 'LensProfileMatchKeyLensInfo', 503 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 501 => 'LensProfileMatchKeyLensName', 503 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 501 => 'LensProfileMatchKeySensorFormatFactor', 503 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 501 => 'LensProfileName', 503 => 'LensProfileName' },
	'lensprofilesetup' => { 501 => 'LensProfileSetup', 503 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 501 => 'LensProfileVignettingScale', 503 => 'LensProfileVignettingScale' },
	'lensproperties' => { 319 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 33 => 0x16b, 62 => 0x0, 120 => 0xa435, 164 => 'SerialNumber', 319 => 0x202, 339 => 0x321, 341 => 0x52, 401 => 'LENS', 409 => 0x30, 498 => 'LensSerialNumber', 508 => 'LensSerialNumber' },
	'lensshutterlock' => { 185 => 0x4a },
	'lensspec' => { 425 => 0x0, 426 => 0x0, 427 => 0x0, 441 => 0xb02a },
	'lensspecfeatures' => { 460 => [0x115,0x116], 461 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 323 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 35 => 0x16, 187 => 0x10c, 188 => 0x49bd, 235 => 0x83, 319 => 0x201, 332 => 0x16, 336 => 0x310, 338 => 0x303, 339 => 0x303, 341 => 0x51, 343 => 0x3405, 368 => 0x0, 369 => 0x0, 370 => 0x1, 371 => 0x1, 372 => 0x1, 374 => 0x0, 415 => 0xa003, 418 => 0x27, 441 => 0xb027, 454 => 0x1896, 456 => 0x18c2, 457 => 0x18f2, 458 => 0x17f6, 460 => 0x109, 461 => 0x109, 472 => 0x608, 473 => 0x62 },
	'lenstype2' => { 430 => 0x3f7, 454 => 0x1893, 456 => 0x18bf, 457 => 0x18ef, 458 => 0x17f3, 460 => 0x107, 461 => 0x107, 472 => 0x605, 473 => 0x60 },
	'lenstype3' => { 476 => 0x9 },
	'lenstypemake' => { 341 => 0xc4 },
	'lenstypemodel' => { 341 => [0xc5,0xe4] },
	'lenszoomposition' => { 469 => 0x19, 470 => 0x1e, 473 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 349 => 0x15 },
	'levelmeter' => { 401 => ['Lvlm','lvlm'] },
	'levelorientation' => { 375 => 0x0 },
	'license' => { 499 => 'license' },
	'licensee' => { 328 => 'Licensee' },
	'licenseeid' => { 328 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 328 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 328 => 'LicenseeImageNotes' },
	'licenseename' => { 328 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 328 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 328 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 328 => 'LicenseeTransactionID' },
	'licenseid' => { 328 => 'LicenseID' },
	'licensestartdate' => { 328 => 'LicenseStartDate' },
	'licensetransactiondate' => { 328 => 'LicenseTransactionDate' },
	'licensetype' => { 505 => 'licensetype' },
	'licensor' => { 328 => 'Licensor' },
	'licensorcity' => { 328 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 328 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 328 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 328 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 328 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 328 => 'LicensorImageID' },
	'licensorname' => { 328 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 328 => 'LicensorNotes' },
	'licensorpostalcode' => { 328 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 328 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 328 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 328 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 328 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 328 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 328 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 328 => 'LicensorTransactionID' },
	'licensorurl' => { 328 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 323 => 0x1009 },
	'lightingmode' => { 114 => 0x302a },
	'lightreading' => { 376 => 0x15 },
	'lightsource' => { 120 => 0x9208, 235 => 0x90, 326 => 0x1000, 507 => 'LightSource' },
	'lightsourcespecial' => { 417 => 0x21d },
	'lightswitch' => { 311 => '0.1', 313 => '0.1' },
	'lightvaluecenter' => { 323 => 0x103d },
	'lightvalueperiphery' => { 323 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 314 => 0x153, 315 => 0x153, 316 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 314 => 0x151, 315 => 0x151, 316 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 314 => 0x150, 315 => 0x150, 316 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 314 => 0x14f, 315 => 0x14f, 316 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 314 => 0x11, 315 => 0x11, 316 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 314 => 0x14, 315 => 0x14, 316 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 314 => 0x13, 315 => 0x13, 316 => 0x13 },
	'limitafareamodeselauto' => { 314 => 0x15, 315 => 0x15, 316 => 0x15 },
	'limitafareamodeselection' => { 299 => '51.1', 301 => '49.1', 302 => '49.1', 311 => '49.1', 312 => '49.1' },
	'limitreleasemodeselc120' => { 315 => '269.4', 316 => '293.4' },
	'limitreleasemodeselc30' => { 315 => '269.3', 316 => '293.3' },
	'limitreleasemodeselch' => { 315 => '269.2', 316 => '293.2' },
	'limitreleasemodeselcl' => { 315 => '269.1', 316 => '293.1' },
	'limitreleasemodeselself' => { 315 => '269.5', 316 => '293.5' },
	'limitselectableimagearea16to9' => { 314 => 0x47, 315 => 0x47, 316 => 0x47 },
	'limitselectableimagearea1to1' => { 314 => 0x46, 315 => 0x46, 316 => 0x46 },
	'limitselectableimageareadx' => { 314 => 0x45, 315 => 0x45, 316 => 0x45 },
	'linearitylimitblue' => { 346 => 0x10 },
	'linearitylimitgreen' => { 346 => 0xf },
	'linearitylimitred' => { 346 => 0xe },
	'linearityuppermargin' => { 42 => 0x32c, 43 => 0x282, 46 => [0x2ba,0x2d1,0x2d5], 48 => 0x1e5, 49 => [0x1fe,0x2de], 50 => [0x232,0x310], 51 => 0x31e },
	'linearizationtable' => { 120 => 0xc618 },
	'linearresponselimit' => { 120 => 0xc62e },
	'link' => { 520 => 'link' },
	'linkaetoafpoint' => { 357 => '14.2' },
	'linkedencodedrightsexpr' => { 515 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 515 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 515 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 515 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 139 => 0x904 },
	'lithostratigraphicterms' => { 119 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 395 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 395 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 395 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 303 => '32.1', 313 => '34.1' },
	'liveviewafareamode' => { 308 => '34.1' },
	'liveviewafmethod' => { 446 => 0x20 },
	'liveviewafmode' => { 308 => '34.2' },
	'liveviewafsetting' => { 430 => 0x36 },
	'liveviewbuttonoptions' => { 299 => '50.2', 301 => '48.2', 302 => '48.2', 311 => '48.2', 312 => '48.2' },
	'liveviewexposuresimulation' => { 85 => 0x810 },
	'liveviewfocusmode' => { 430 => [0x8b,0x28b] },
	'liveviewmetering' => { 430 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 299 => '21.2', 301 => '21.2', 302 => '21.2', 304 => '20.2', 305 => '20.2', 306 => '20.2', 308 => '20.2', 311 => '21.2', 312 => '21.2' },
	'liveviewshooting' => { 58 => 0x13 },
	'livingspecimen' => { 119 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 119 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 132 => 0x79 },
	'localizedcameramodel' => { 120 => 0xc615 },
	'locallocationname' => { 415 => 0x30 },
	'location' => { 234 => 0x9, 341 => 0x67, 494 => 'Location', 514 => 'Location', 519 => 'location', 520 => 'location' },
	'locationaccuracyhorizontal' => { 395 => 'location.accuracy.horizontal' },
	'locationareacode' => { 500 => 'lac' },
	'locationbody' => { 395 => 'location.body' },
	'locationcreated' => { 515 => 'LocationCreated' },
	'locationcreatedcity' => { 515 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 515 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 515 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 515 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 515 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 515 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 515 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 515 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 515 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 515 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 515 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 515 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 395 => 'location.date' },
	'locationinformation' => { 401 => 'loci' },
	'locationinfoversion' => { 234 => 0x0 },
	'locationname' => { 395 => 'location.name', 415 => 0x31 },
	'locationnote' => { 395 => 'location.note' },
	'locationrole' => { 395 => 'location.role' },
	'locationshown' => { 515 => 'LocationShown' },
	'locationshowncity' => { 515 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 515 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 515 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 515 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 515 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 515 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 515 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 515 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 515 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 515 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 515 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 515 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 85 => 0x709 },
	'logcomment' => { 530 => 'logComment' },
	'logscale' => { 139 => 0x902 },
	'longdescription' => { 393 => 'ldes' },
	'longexposurenoisereduction' => { 63 => 0x4, 85 => 0x201, 86 => 0x1, 87 => 0x2, 88 => 0x1, 89 => 0x1, 90 => 0x2, 91 => 0x1, 341 => 0x49, 428 => 0x2b, 429 => 0x25, 430 => 0x25, 441 => 0x2008, 446 => 0x11, 473 => 0x44 },
	'longexposurenoisereduction2' => { 58 => 0x8 },
	'longexposurenrused' => { 341 => 0xbe },
	'longitude' => { 117 => 'Longitude' },
	'look' => { 501 => 'Look', 503 => 'Look' },
	'lookamount' => { 501 => [\'Look','LookAmount'], 503 => [\'Look','LookAmount'] },
	'lookcluster' => { 501 => [\'Look','LookCluster'], 503 => [\'Look','LookCluster'] },
	'lookcopyright' => { 501 => [\'Look','LookCopyright'], 503 => [\'Look','LookCopyright'] },
	'lookgroup' => { 501 => [\'Look','LookGroup'], 503 => [\'Look','LookGroup'] },
	'lookname' => { 501 => 'LookName', 503 => 'LookName' },
	'lookparameters' => { 501 => [\'Look','LookParameters'], 503 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 501 => [\'Look','LookParametersCameraProfile'], 503 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 501 => [\'Look','LookParametersClarity2012'], 503 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 501 => [\'Look','LookParametersConvertToGrayscale'], 503 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 501 => [\'Look','LookParametersLookTable'], 503 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 501 => [\'Look','LookParametersProcessVersion'], 503 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 501 => [\'Look','LookParametersToneCurvePV2012'], 503 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 501 => [\'Look','LookParametersToneCurvePV2012Blue'], 503 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 501 => [\'Look','LookParametersToneCurvePV2012Green'], 503 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 501 => [\'Look','LookParametersToneCurvePV2012Red'], 503 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 501 => [\'Look','LookParametersVersion'], 503 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 501 => [\'Look','LookSupportsAmount'], 503 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 501 => [\'Look','LookSupportsMonochrome'], 503 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 501 => [\'Look','LookSupportsOutputReferred'], 503 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 501 => [\'Look','LookUUID'], 503 => [\'Look','LookUUID'] },
	'loop' => { 530 => 'loop' },
	'loopstyle' => { 401 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 119 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 501 => 'LuminanceAdjustmentAqua', 503 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 501 => 'LuminanceAdjustmentBlue', 503 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 501 => 'LuminanceAdjustmentGreen', 503 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 501 => 'LuminanceAdjustmentMagenta', 503 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 501 => 'LuminanceAdjustmentOrange', 503 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 501 => 'LuminanceAdjustmentPurple', 503 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 501 => 'LuminanceAdjustmentRed', 503 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 501 => 'LuminanceAdjustmentYellow', 503 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 109 => 0x150 },
	'luminancecurvepoints' => { 109 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 104 => 0x20600, 110 => 0x5f, 418 => 0x1b },
	'luminancenoisereductioncontrast' => { 501 => 'LuminanceNoiseReductionContrast', 503 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 501 => 'LuminanceNoiseReductionDetail', 503 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 110 => 0x6d },
	'luminancesmoothing' => { 501 => 'LuminanceSmoothing', 503 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 85 => [0x40b,0x40c] },
	'lyrics' => { 393 => "\xa9lyr", 401 => "\xa9lyr", 530 => 'lyrics' },
	'lyricsuri' => { 401 => 'lrcu' },
	'm16cversion' => { 336 => 0x333 },
	'macatom' => { 502 => 'macAtom' },
	'macatomapplicationcode' => { 502 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 502 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 502 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 119 => 'MachineObservation' },
	'machineobservationday' => { 119 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 119 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 119 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 119 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 119 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 119 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 119 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 119 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 119 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 119 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 119 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 119 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 119 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 119 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 119 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 119 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 119 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 119 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 119 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 119 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 128 => 0x1020, 130 => 0x202, 152 => 0x2b, 323 => 0x202, 407 => 0x21, 417 => 0x202, 441 => 0xb040 },
	'macroled' => { 321 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 58 => 0x10 },
	'macromode' => { 35 => 0x1, 182 => 0xb, 318 => 0x300, 341 => 0x1c, 408 => 0x1009 },
	'magentahsl' => { 104 => 0x20917 },
	'magicfilter' => { 318 => 0x52c },
	'magnifiedview' => { 87 => 0x11, 89 => 0x9 },
	'mainboardversion' => { 139 => 0x438 },
	'maindialexposurecomp' => { 309 => '0.6' },
	'mainingredient' => { 522 => 'mainIngredient' },
	'majorversion' => { 492 => 'MajorVersion' },
	'make' => { 99 => 0x0, 116 => 0x1, 120 => 0x10f, 157 => 'Make', 331 => 'Make', 346 => 0x10f, 395 => 'make', 401 => ['@mak',"\xa9mak"], 519 => 'make', 526 => 'Make' },
	'makernote' => { 507 => 'MakerNote' },
	'makernoteapple' => { 118 => 'MakN', 120 => 0x927c },
	'makernotecanon' => { 118 => 'MakN', 120 => 0x927c },
	'makernotecasio' => { 118 => 'MakN', 120 => 0x927c },
	'makernotecasio2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotedji' => { 118 => 'MakN', 120 => 0x927c },
	'makernotedjiinfo' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteflir' => { 118 => 'MakN', 120 => 0x927c },
	'makernotefujifilm' => { 118 => 'MakN', 120 => 0x927c },
	'makernotege' => { 118 => 'MakN', 120 => 0x927c },
	'makernotege2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotehasselblad' => { 118 => 'MakN', 120 => 0x927c },
	'makernotehp' => { 118 => 'MakN', 120 => 0x927c },
	'makernotehp2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotehp4' => { 118 => 'MakN', 120 => 0x927c },
	'makernotehp6' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteisl' => { 118 => 'MakN', 120 => 0x927c },
	'makernotejvc' => { 118 => 'MakN', 120 => 0x927c },
	'makernotejvctext' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak10' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak11' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak12' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak1a' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak1b' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak4' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak5' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak6a' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak6b' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak7' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak8a' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak8b' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak8c' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodak9' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekodakunknown' => { 118 => 'MakN', 120 => 0x927c },
	'makernotekyocera' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica10' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica2' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica3' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica4' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica5' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica6' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica7' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica8' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteleica9' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteminolta' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteminolta2' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteminolta3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotemotorola' => { 118 => 'MakN', 120 => 0x927c },
	'makernotenikon' => { 118 => 'MakN', 120 => 0x927c },
	'makernotenikon2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotenikon3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotenintendo' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteoffset' => { 417 => 0xff },
	'makernoteolympus' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteolympus2' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteolympus3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepanasonic' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepanasonic2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepanasonic3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentax' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentax2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentax3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentax4' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentax5' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentax6' => { 118 => 'MakN', 120 => 0x927c },
	'makernotepentaxunknown' => { 401 => 'PXMN' },
	'makernotephaseone' => { 118 => 'MakN', 120 => 0x927c },
	'makernotereconyx' => { 118 => 'MakN', 120 => 0x927c },
	'makernotereconyx2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotereconyx3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotericoh' => { 118 => 'MakN', 120 => 0x927c },
	'makernotericoh2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotericohpentax' => { 118 => 'MakN', 120 => 0x927c },
	'makernotericohtext' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesafety' => { 120 => 0xc635 },
	'makernotesamsung1a' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesamsung1b' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesamsung2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesanyo' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesanyoc4' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesanyopatch' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesigma' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesony' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesony2' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesony3' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesony4' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesony5' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesonyericsson' => { 118 => 'MakN', 120 => 0x927c },
	'makernotesonysrf' => { 118 => 'MakN', 120 => 0x927c },
	'makernotetype' => { 408 => 0x1 },
	'makernoteunknown' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteunknownbinary' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteunknowntext' => { 118 => 'MakN', 120 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 187 => 0x0, 235 => 0x1, 323 => 0x0, 341 => 0x8000, 412 => 0x0, 415 => 0x1, 418 => [0x1d,0x1f], 431 => 0x2000 },
	'makerurl' => { 401 => "\xa9mal" },
	'managedfrom' => { 531 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 531 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 531 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 531 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 531 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 531 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 531 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 531 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 531 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 531 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 531 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 531 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 531 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 531 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 531 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 531 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 531 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 531 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 531 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 531 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 531 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 531 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 531 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 531 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 531 => 'Manager' },
	'managervariant' => { 531 => 'ManagerVariant' },
	'manageto' => { 531 => 'ManageTo' },
	'manageui' => { 531 => 'ManageUI' },
	'manifest' => { 531 => 'Manifest' },
	'manifestlinkform' => { 531 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 531 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 531 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 531 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 531 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 531 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 531 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 531 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 531 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 531 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 531 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 531 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 531 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 531 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 531 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 531 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 531 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 531 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 531 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 531 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 531 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 531 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 531 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 531 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 531 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 531 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 531 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 531 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 318 => 0x900, 341 => 0x86 },
	'manometerreading' => { 318 => 0x901 },
	'manualafpointselectpattern' => { 85 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 321 => 0x1209 },
	'manualflashoutput' => { 35 => 0x29, 300 => '8.2', 303 => '22.2', 304 => '23.1', 305 => '23.2', 307 => '16.2', 308 => '23.2', 309 => '8.2', 310 => '23.2', 313 => '24.2', 408 => 0x100c },
	'manualflashstrength' => { 318 => 0x406 },
	'manualfocusdistance' => { 235 => 0x85, 323 => 0x100c, 417 => 0x223 },
	'manualfocuspointillumination' => { 314 => 0x17, 315 => 0x17, 316 => 0x17 },
	'manualfocusringinafmode' => { 314 => 0x1a, 315 => 0x1a, 316 => 0x1a },
	'manualtv' => { 84 => 0x5, 85 => 0x705 },
	'manufacturedate' => { 192 => 0x6705, 356 => 0x1 },
	'manufacturedate1' => { 410 => 0x4 },
	'manufacturedate2' => { 410 => 0x5 },
	'manufacturer' => { 486 => 'Manufacturer', 519 => 'manufacturer' },
	'mariahchromablursize' => { 139 => 0xf0d },
	'mariahmaphithreshold' => { 139 => 0xf0c },
	'mariahmaplothreshold' => { 139 => 0xf0b },
	'mariahsigmathreshold' => { 139 => 0xf0e },
	'mariahtexturethreshold' => { 139 => 0xf0a },
	'marked' => { 517 => 'Marked', 534 => 'Marked' },
	'markers' => { 530 => 'markers' },
	'markerscomment' => { 530 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 530 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 530 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 530 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 530 => [\'markers','markersCuePointType'] },
	'markersduration' => { 530 => [\'markers','markersDuration'] },
	'markerslocation' => { 530 => [\'markers','markersLocation'] },
	'markersname' => { 530 => [\'markers','markersName'] },
	'markersprobability' => { 530 => [\'markers','markersProbability'] },
	'markersspeaker' => { 530 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 530 => [\'markers','markersStartTime'] },
	'markerstarget' => { 530 => [\'markers','markersTarget'] },
	'markerstype' => { 530 => [\'markers','markersType'] },
	'maskedareas' => { 120 => 0xc68e },
	'maskgroupbasedcorractive' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 501 => 'MaskGroupBasedCorrections', 503 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 501 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 503 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 132 => 0xb9 },
	'mastergain' => { 258 => 0x50 },
	'materialsample' => { 119 => 'MaterialSample' },
	'materialsampleid' => { 119 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 299 => '50.1', 301 => '48.1', 302 => '48.1', 311 => '48.1', 312 => '48.1', 314 => 0x233, 315 => 0x233, 316 => 0x24b },
	'matrixselectk' => { 139 => 0x91b },
	'matrixselectthreshold' => { 139 => 0x91a },
	'matrixselectthreshold1' => { 139 => 0x91e },
	'matrixselectthreshold2' => { 139 => 0x91f },
	'matrixstructure' => { 400 => 0xa },
	'maxaperture' => { 35 => 0x1a, 139 => 0x3f9, 145 => 0x6103, 164 => 'MaxAperture', 182 => 0x17, 188 => 0x49c5, 233 => 0x36, 319 => 0x20a, 367 => '14.1' },
	'maxapertureatmaxfocal' => { 128 => 0x1407, 164 => 'MaxApertureAtMaxFocal', 227 => 0xb, 228 => 0x10, 229 => 0x11, 233 => 0x12, 319 => 0x206 },
	'maxapertureatminfocal' => { 128 => 0x1406, 227 => 0xa, 228 => 0xf, 229 => 0x10, 233 => 0x11, 319 => 0x205 },
	'maxaperturevalue' => { 120 => 0x9205, 385 => 0x414, 507 => 'MaxApertureValue' },
	'maxavailheight' => { 515 => 'MaxAvailHeight' },
	'maxavailwidth' => { 515 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 298 => 0xb, 299 => 0xc, 301 => '12.1', 302 => '12.1', 307 => 0xc, 308 => 0xb, 311 => '12.1', 312 => '12.1', 314 => 0x3d, 315 => 0x3d, 316 => 0x3d },
	'maxfaces' => { 322 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 35 => 0x17, 128 => 0x1405, 164 => 'MaxFocalLength', 227 => 0x9, 228 => 0xe, 229 => 0xf, 233 => 0x10, 319 => 0x208, 454 => 0x127c, 455 => 0x1138, 456 => 0x330, 457 => 0x330, 458 => 0x30e },
	'maximumdensityrange' => { 134 => 0x8c },
	'maxpagesize' => { 535 => 'MaxPageSize' },
	'maxpagesizeh' => { 535 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 535 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 535 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 139 => 0xc7d },
	'maxsamplevalue' => { 120 => 0x119 },
	'maxstorage' => { 525 => 'maxstorage' },
	'mb-d10batteries' => { 298 => '12.6' },
	'mb-d10batterytype' => { 307 => '13.3' },
	'mb-d11batterytype' => { 308 => '2.3' },
	'mb-d12batterytype' => { 311 => '3.2' },
	'mb-d80batteries' => { 309 => '6.5' },
	'mb-d80batterytype' => { 313 => '3.2' },
	'mcuversion' => { 227 => 0xc, 228 => 0x11, 229 => 0x12, 233 => 0x13 },
	'md5digest' => { 165 => 'zmd5' },
	'mditemfindercomment' => { 174 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 174 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 174 => 'MDItemFSLabel' },
	'mditemusertags' => { 174 => 'MDItemUserTags' },
	'meal' => { 522 => 'meal' },
	'measuredev' => { 28 => 0x9, 78 => 0x3, 98 => 0x1814, 157 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 78 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 188 => 0x690, 336 => 0x312, 339 => 0x312, 340 => 0x312, 343 => 0x3407 },
	'measuredrggb' => { 66 => 0x1 },
	'measuredrggbdata' => { 45 => 0x287 },
	'measurementaccuracy' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 119 => 'MeasurementOrFact' },
	'measurementremarks' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 119 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 486 => 'MeasureType' },
	'mechanicalshuttercount' => { 235 => 0x37 },
	'mediaclassprimaryid' => { 180 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 180 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 328 => 'MediaConstraints' },
	'mediacreatedate' => { 397 => 0x1 },
	'mediaeventiddate' => { 491 => 'MediaEventIdDate' },
	'mediamodifydate' => { 397 => 0x2 },
	'mediasummarycode' => { 328 => 'MediaSummaryCode' },
	'mediatype' => { 393 => 'stik' },
	'memoaudioquality' => { 85 => 0x812 },
	'memorycardconfiguration' => { 434 => 0x16 },
	'memorycardnumber' => { 212 => 0x2 },
	'menubuttondisplayposition' => { 83 => 0xb, 86 => 0xa, 87 => 0xb, 90 => 0xb },
	'menubuttonreturn' => { 91 => 0xb },
	'menumonitorofftime' => { 298 => '26.1', 299 => '22.1', 301 => '22.1', 302 => '22.1', 306 => '21.1', 307 => '8.2', 308 => '21.1', 311 => '22.1', 312 => '22.1', 313 => '22.1', 314 => 0x35, 315 => 0x35, 316 => 0x35 },
	'mergedimages' => { 341 => 0x76 },
	'metadataauthority' => { 515 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 515 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 515 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 528 => 'MetadataDate' },
	'metadataeditingsoftware' => { 120 => 0xa43c },
	'metadatalastedited' => { 515 => 'metadataLastEdited' },
	'metadatalasteditor' => { 515 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 515 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 515 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 530 => 'metadataModDate' },
	'metaversion' => { 449 => 0x34 },
	'meterinfo1row1' => { 442 => 0x0, 443 => 0x0 },
	'meterinfo1row2' => { 442 => 0x6c, 443 => 0x5a },
	'meterinfo1row3' => { 442 => 0xd8, 443 => 0xb4 },
	'meterinfo1row4' => { 442 => 0x144, 443 => 0x10e },
	'meterinfo1row5' => { 442 => 0x1b0, 443 => 0x168 },
	'meterinfo1row6' => { 442 => 0x21c, 443 => 0x1c2 },
	'meterinfo1row7' => { 442 => 0x288, 443 => 0x21c },
	'meterinfo2row1' => { 442 => 0x2f4, 443 => 0x276 },
	'meterinfo2row2' => { 442 => 0x378, 443 => 0x2e4 },
	'meterinfo2row3' => { 442 => 0x3fc, 443 => 0x352 },
	'meterinfo2row4' => { 442 => 0x480, 443 => 0x3c0 },
	'meterinfo2row5' => { 442 => 0x504, 443 => 0x42e },
	'meterinfo2row6' => { 442 => 0x588, 443 => 0x49c },
	'meterinfo2row7' => { 442 => 0x60c, 443 => 0x50a },
	'meterinfo2row8' => { 442 => 0x690, 443 => 0x578 },
	'meterinfo2row9' => { 442 => 0x714, 443 => 0x5e6 },
	'metering' => { 300 => '6.1' },
	'meteringmode' => { 35 => 0x11, 120 => 0x9207, 141 => 0x1c, 182 => 0x7, 183 => 0x25, 185 => 0x12, 318 => 0x202, 376 => 0x17, 418 => 0x9, 428 => 0x15, 429 => 0x13, 430 => 0x7, 446 => 0x3, 450 => 0x1174, 451 => 0x1178, 452 => 0x1154, 453 => 0x11d0, 454 => 0x11ac, 455 => 0x1064, 456 => 0x25c, 457 => 0x25c, 458 => 0x24b, 507 => 'MeteringMode' },
	'meteringmode2' => { 357 => '2.1', 441 => 0x202c },
	'meteringmode3' => { 357 => '16.1' },
	'meteringoffscaleindicator' => { 185 => 0x53 },
	'meteringtime' => { 298 => '22.2', 300 => '3.2', 303 => '17.1', 304 => '18.1', 307 => '7.3', 308 => '18.1', 309 => '3.2', 313 => '19.1' },
	'micro1version' => { 403 => 0x1f },
	'micro2version' => { 403 => 0x2d },
	'microphoneattenuator' => { 240 => 0x34e, 241 => 0x2d2, 242 => 0x2fa, 243 => 0x2fa },
	'microphonefrequencyresponse' => { 240 => 0x350, 241 => 0x2d4, 242 => 0x2fc, 243 => 0x2fc },
	'microphonejackpower' => { 240 => 0x376, 241 => 0x2fa, 242 => 0x322, 243 => 0x322 },
	'microphonesensitivity' => { 240 => 0x34c, 241 => 0x2d0, 242 => 0x2f8, 243 => 0x2f8 },
	'microvideo' => { 484 => 'MicroVideo' },
	'microvideooffset' => { 484 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 484 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 484 => 'MicroVideoVersion' },
	'midrangesharpness' => { 252 => 0x3b },
	'mieversion' => { 165 => '0Vers' },
	'mime' => { 486 => 'Mime' },
	'minaperture' => { 35 => 0x1b, 139 => 0x3f8, 164 => 'MinAperture', 367 => '0.2' },
	'minaperturevalue' => { 385 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 35 => 0x18, 128 => 0x1404, 164 => 'MinFocalLength', 227 => 0x8, 228 => 0xd, 229 => 0xe, 233 => 0xf, 319 => 0x207, 454 => 0x127a, 455 => 0x1136, 456 => 0x32e, 457 => 0x32e, 458 => 0x30c },
	'minfocusdistance' => { 367 => 0x3 },
	'minimumiso' => { 341 => 0xe8 },
	'minintegrationrows' => { 139 => 0x1874 },
	'minoltadate' => { 182 => 0x15 },
	'minoltaimagesize' => { 182 => 0x4, 183 => 0xc, 184 => 0x2, 187 => 0x103 },
	'minoltamodelid' => { 182 => 0x25 },
	'minoltaquality' => { 182 => 0x5, 183 => 0xd, 184 => 0x3, 187 => [0x102,0x103] },
	'minoltatime' => { 182 => 0x16 },
	'minormodelagedisclosure' => { 328 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 492 => 'MinorVersion' },
	'minsamplevalue' => { 120 => 0x118 },
	'mirrorlockup' => { 83 => 0xc, 84 => 0xc, 85 => 0x60f, 86 => 0xb, 87 => 0xc, 88 => 0x6, 89 => 0x6, 90 => 0xc, 91 => 0x3 },
	'mobilecountrycode' => { 500 => 'mcc' },
	'mobilenetworkcode' => { 500 => 'mnc' },
	'moddate' => { 331 => 'modify-date', 517 => 'ModDate' },
	'modedialposition' => { 434 => 0x14 },
	'model' => { 99 => 0x6, 120 => 0x110, 157 => 'Model', 331 => 'Model', 346 => 0x110, 376 => 0x23f, 395 => 'model', 401 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 418 => 0x84, 486 => 'Model', 519 => 'model', 526 => 'Model' },
	'modelage' => { 515 => 'ModelAge' },
	'modelid' => { 317 => 0x0 },
	'modelingflash' => { 298 => '21.4', 299 => '31.1', 301 => '31.1', 302 => '31.1', 307 => '26.4', 308 => '30.2', 309 => '7.4', 310 => '30.1', 311 => '31.1', 312 => '31.1', 313 => '31.3', 314 => 0x5d, 315 => 0x5d, 316 => 0x5d },
	'modelreleaseid' => { 328 => 'ModelReleaseID' },
	'modelreleasestatus' => { 328 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 464 => 0x52, 465 => 0x46, 466 => 0x53 },
	'modeltiepoint' => { 120 => 0x8482 },
	'modeltransform' => { 120 => 0x85d8 },
	'modelyear' => { 519 => 'modelYear' },
	'modificationdate' => { 520 => 'modificationDate' },
	'modifiedcolortemp' => { 67 => 0x9 },
	'modifieddigitalgain' => { 67 => 0xb },
	'modifiedparamflag' => { 59 => 0x1 },
	'modifiedpicturestyle' => { 67 => 0xa },
	'modifiedsaturation' => { 318 => 0x504 },
	'modifiedsensorbluelevel' => { 67 => 0x5 },
	'modifiedsensorredlevel' => { 67 => 0x4 },
	'modifiedsharpness' => { 67 => 0x2 },
	'modifiedsharpnessfreq' => { 67 => 0x3 },
	'modifiedtonecurve' => { 67 => 0x1 },
	'modifiedwhitebalance' => { 67 => 0x8 },
	'modifiedwhitebalanceblue' => { 67 => 0x7 },
	'modifiedwhitebalancered' => { 67 => 0x6 },
	'modifydate' => { 120 => 0x132, 158 => 'ModifyDate', 327 => 'ModDate', 329 => 'tIME', 392 => 'ModDate', 398 => 0x2, 528 => 'ModifyDate' },
	'moirefilter' => { 120 => 0xfe58, 501 => 'MoireFilter', 503 => 'MoireFilter' },
	'monitorbrightness' => { 240 => 0x69a, 241 => 0x59a, 242 => 0x5ca, 243 => 0x5e2 },
	'monitordisplayoff' => { 185 => 0x4c },
	'monitormatrix' => { 139 => 0x8fc },
	'monitorofftime' => { 298 => '18.2', 300 => '3.1', 309 => '3.1' },
	'monochromecolor' => { 318 => 0x53b },
	'monochromecontrast' => { 110 => 0x3c },
	'monochromefiltereffect' => { 104 => 0x20307, 110 => 0x3a, 341 => 0xac, 376 => 0x73 },
	'monochromegraineffect' => { 341 => 0xd2 },
	'monochromelinear' => { 110 => 0x3d },
	'monochromeoutputhighlightpoint' => { 110 => 0x41 },
	'monochromeoutputshadowpoint' => { 110 => 0x42 },
	'monochromeprofilesettings' => { 318 => 0x537 },
	'monochromerawhighlight' => { 110 => 0x7a },
	'monochromerawhighlightpoint' => { 110 => 0x3f },
	'monochromerawshadow' => { 110 => 0x83 },
	'monochromerawshadowpoint' => { 110 => 0x40 },
	'monochromesharpness' => { 110 => 0x3e },
	'monochrometoning' => { 376 => 0x74 },
	'monochrometoningeffect' => { 104 => 0x20306, 110 => 0x3b },
	'monochromeunsharpmaskfineness' => { 110 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 110 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 110 => 0xb4 },
	'monochromevignetting' => { 318 => 0x53a },
	'monthdaycreated' => { 141 => 0x12, 150 => 0xe },
	'mood' => { 180 => 'WM/Mood' },
	'moonphase' => { 402 => 0x12, 403 => 0x43, 404 => 0x4c },
	'morepermissions' => { 499 => 'morePermissions' },
	'motionphotovideo' => { 396 => 'mpvd' },
	'motionsensitivity' => { 402 => 0x29, 404 => 0x60 },
	'movementcount' => { 393 => "\xa9mvc" },
	'movementname' => { 393 => "\xa9mvn" },
	'movementnumber' => { 393 => "\xa9mvi" },
	'movieactived-lighting' => { 239 => 0x238, 240 => 0x334, 241 => 0x2b8, 242 => 0x2e0, 243 => 0x2e0 },
	'movieaelockbuttonassignment' => { 311 => '40.1' },
	'movieaf-onbutton' => { 314 => 0xcb, 315 => 0xcb, 316 => 0xcb },
	'movieafareamode' => { 240 => 0x342, 241 => 0x2c6, 242 => 0x2ee, 243 => 0x2ee, 314 => 0x203, 315 => 0x203, 316 => 0x21b },
	'movieafspeed' => { 314 => 0xdd, 315 => 0xdd, 316 => 0xdd },
	'movieafspeedapply' => { 314 => 0xdf, 315 => 0xdf, 316 => 0xdf },
	'movieaftrackingsensitivity' => { 314 => 0xe1, 315 => 0xe1, 316 => 0xe1 },
	'movieaperturelock' => { 314 => 0x259, 315 => 0x259, 316 => 0x271 },
	'movieautodistortioncontrol' => { 239 => 0x242 },
	'moviediffractioncompensation' => { 239 => 0x241 },
	'moviedxcropalert' => { 240 => 0x377, 241 => 0x2fb, 242 => 0x323, 243 => 0x323 },
	'movieelectronicvr' => { 240 => 0x348, 241 => 0x2cc, 242 => 0x2f4, 243 => 0x2f4 },
	'movieevfgrid' => { 314 => 0x21d, 315 => 0x21d, 316 => 0x235 },
	'movieflickerreduction' => { 240 => 0x33c, 241 => 0x2c0, 242 => 0x2e8, 243 => 0x2e8 },
	'moviefocusmode' => { 239 => 0x248, 240 => 0x340, 241 => 0x2c4, 242 => 0x2ec, 243 => 0x2ec },
	'moviefocuspointlock' => { 314 => 0x226, 315 => 0x226, 316 => 0x23e },
	'movieframerate' => { 239 => 0x1f8, 240 => 0x374, 241 => 0x2f4, 242 => 0x31c, 243 => 0x31c },
	'movieframesize' => { 239 => 0x1f6, 240 => 0x372, 241 => 0x2f2, 242 => 0x31a, 243 => 0x31a },
	'moviefunc1button' => { 301 => '41.1', 302 => '41.1', 312 => '41.1', 314 => 0xc3, 315 => 0xc3, 316 => 0xc3 },
	'moviefunc2button' => { 314 => 0xc7, 315 => 0xc7, 316 => 0xc7 },
	'moviefunc3button' => { 315 => 0x127, 316 => 0x13f },
	'moviefunctionbutton' => { 299 => '41.1', 311 => '41.1' },
	'moviefunctionbuttonplusdials' => { 299 => '52.1' },
	'moviehighisonoisereduction' => { 239 => 0x23c, 240 => 0x336, 241 => 0x2ba, 242 => 0x2e2, 243 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 314 => 0x215, 315 => 0x215, 316 => 0x22d },
	'moviehighreszoom' => { 240 => 0x380, 242 => 0x32c, 243 => 0x32c },
	'movieimagearea' => { 240 => 0x2da, 241 => 0x25c, 242 => 0x286, 243 => 0x286 },
	'movieisoautocontrolmanualmode' => { 240 => 0x2e8, 241 => 0x26a, 242 => 0x294, 243 => 0x294 },
	'movieisoautohilimit' => { 240 => 0x2e6, 241 => 0x268, 242 => 0x292, 243 => 0x292 },
	'movieisoautomanualmode' => { 239 => 0x204, 240 => 0x2ea, 241 => 0x26c, 242 => 0x296, 243 => 0x296 },
	'movielenscontrolring' => { 314 => 0xd7, 315 => 0xd7, 316 => 0xd7 },
	'moviemeteringmode' => { 240 => 0x33e, 241 => 0x2c2, 242 => 0x2ea, 243 => 0x2ea },
	'moviemidtonedisplayrange' => { 314 => 0x219, 315 => 0x219, 316 => 0x231 },
	'moviemidtonedisplayvalue' => { 314 => 0x217, 315 => 0x217, 316 => 0x22f },
	'moviemultiselector' => { 314 => 0xd9, 315 => 0xcf, 316 => 0xcf },
	'moviepreviewbutton' => { 299 => '41.2', 301 => '41.2', 302 => '41.2', 311 => '41.2', 312 => '41.2' },
	'moviepreviewbuttonplusdials' => { 299 => '52.2' },
	'movierecordbuttonplaybackmode' => { 314 => 0x1b5, 315 => 0x1b5, 316 => 0x1cd },
	'movieshutterbutton' => { 299 => '38.3', 301 => '38.3', 302 => '38.3', 311 => '38.3', 312 => '38.3' },
	'movieshutterspeedlock' => { 314 => 0x225, 315 => 0x225, 316 => 0x23d },
	'movieslowmotion' => { 239 => 0x1fa },
	'moviesoundrecording' => { 240 => 0x34a, 241 => 0x2ce, 242 => 0x2f6, 243 => 0x2f6 },
	'moviesubjectdetection' => { 240 => 0x378, 241 => 0x2fc, 242 => 0x324, 243 => 0x324 },
	'moviesubselectorassignment' => { 299 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 299 => '53.1' },
	'movietonemap' => { 241 => 0x2ec, 242 => 0x314, 243 => 0x314 },
	'movietype' => { 224 => 0x2ca, 239 => 0x1fe, 240 => 0x2e4, 241 => 0x266, 242 => 0x290, 243 => 0x290 },
	'movievibrationreduction' => { 239 => 0x24e },
	'movievibrationreductionsameasphoto' => { 239 => 0x24f },
	'movievignettecontrol' => { 239 => 0x23e, 240 => 0x1b0, 241 => 0x1a0, 242 => 0x1b4, 243 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 239 => 0x240 },
	'movievrmode' => { 240 => 0x344, 241 => 0x2c8, 242 => 0x2f0, 243 => 0x2f0 },
	'moviezebrapattern' => { 314 => 0x213, 315 => 0x213, 316 => 0x22b },
	'multiburstimageheight' => { 441 => 0x1002 },
	'multiburstimagewidth' => { 441 => 0x1001 },
	'multiburstmode' => { 441 => 0x1000 },
	'multicontrollerwhilemetering' => { 85 => 0x517 },
	'multiexposure' => { 69 => 0x1, 341 => 0xb4 },
	'multiexposureautogain' => { 245 => 0x3 },
	'multiexposurecontrol' => { 69 => 0x2 },
	'multiexposuremode' => { 245 => 0x1, 246 => 0x1 },
	'multiexposureoverlaymode' => { 246 => 0x3 },
	'multiexposureshots' => { 69 => 0x3, 240 => 0x9a, 241 => 0x8e, 242 => 0x9c, 243 => 0x9c, 245 => 0x2, 246 => 0x2 },
	'multiframenoisereduction' => { 430 => 0x35, 441 => 0x200b, 446 => 0x15 },
	'multiframenreffect' => { 441 => 0x2023 },
	'multifunctionlock' => { 85 => 0x70f },
	'multipleexposuremode' => { 240 => 0x98, 241 => 0x8c, 242 => 0x9a, 243 => 0x9a, 322 => 0x101c },
	'multipleexposureset' => { 357 => '10.1' },
	'multisample' => { 258 => 0x40 },
	'multiselector' => { 298 => '9.4', 299 => '10.3', 301 => '10.3', 302 => '10.3', 307 => '27.4', 311 => '10.3', 312 => '10.3' },
	'multiselectorliveview' => { 298 => '4.3', 301 => '37.1', 302 => '37.1', 311 => '37.1', 312 => '37.1' },
	'multiselectorliveviewmode' => { 272 => 0x18c2 },
	'multiselectorplaybackmode' => { 298 => ['13.5','9.2'], 299 => '10.2', 302 => '10.2', 307 => '27.2', 311 => '10.2', 312 => '10.2', 314 => 0xb3, 315 => 0xb3, 316 => 0xb3 },
	'multiselectorshootmode' => { 298 => '9.1', 299 => '10.1', 301 => '10.1', 302 => '10.1', 307 => '27.1', 311 => '10.1', 312 => '10.1', 314 => 0xaf, 315 => 0xaf, 316 => 0xaf },
	'multishot' => { 346 => 0x121 },
	'mute' => { 395 => 'player.movie.audio.mute' },
	'mycolormode' => { 70 => 0x2 },
	'name' => { 401 => 'name', 501 => 'Name', 503 => 'Name' },
	'narrator' => { 393 => "\xa9nrt" },
	'nationalcatalognumber' => { 520 => 'nationalCatalogNumber' },
	'nativedigest' => { 507 => 'NativeDigest', 526 => 'NativeDigest' },
	'ndfilter' => { 78 => 0x1c, 318 => 0x204, 408 => 0x1019 },
	'near' => { 486 => 'Near' },
	'nefbitdepth' => { 235 => 0xe22 },
	'nefcompression' => { 235 => 0x93, 236 => 0xa },
	'neflinearizationtable' => { 235 => 0x96 },
	'negativecachelargepreviewsize' => { 501 => 'NegativeCacheLargePreviewSize', 503 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 501 => 'NegativeCacheMaximumSize', 503 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 501 => 'NegativeCachePath', 503 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 498 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 376 => 0x88 },
	'neutraloutputhighlightpoint' => { 110 => 0x2f },
	'neutraloutputshadowpoint' => { 110 => 0x30 },
	'neutralrawcolortone' => { 110 => 0x28 },
	'neutralrawcontrast' => { 110 => 0x2a },
	'neutralrawhighlight' => { 110 => 0x78 },
	'neutralrawhighlightpoint' => { 110 => 0x2d },
	'neutralrawlinear' => { 110 => 0x2b },
	'neutralrawsaturation' => { 110 => 0x29 },
	'neutralrawshadow' => { 110 => 0x81 },
	'neutralrawshadowpoint' => { 110 => 0x2e },
	'neutralrawsharpness' => { 110 => 0x2c },
	'neutralunsharpmaskfineness' => { 110 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 110 => 0xa8 },
	'neutraunsharpmaskstrength' => { 110 => 0xa4 },
	'newlensdata' => { 233 => 0x2f },
	'newrawimagedigest' => { 120 => 0xc7a7 },
	'newsphotoversion' => { 134 => 0x0 },
	'nickname' => { 528 => 'Nickname' },
	'nikoncapturedata' => { 235 => 0xe01 },
	'nikoncaptureeditversions' => { 235 => 0xe13 },
	'nikoncaptureoffsets' => { 235 => 0xe0e },
	'nikoncaptureoutput' => { 235 => 0xe1e },
	'nikoncaptureversion' => { 235 => 0xe09 },
	'nikoniccprofile' => { 235 => 0xe1d },
	'nikonimagesize' => { 269 => '723.1', 270 => '732.1', 278 => 0x2c4 },
	'nikonmeteringmode' => { 200 => 0x17, 239 => 0x146, 249 => 0x214 },
	'nikonsettings' => { 235 => 0x4e },
	'noisefilter' => { 318 => 0x527 },
	'noiseprofile' => { 120 => 0xc761 },
	'noisereduction' => { 128 => [0x100b,0x100e], 183 => 0xb0, 184 => 0x60, 185 => 0x3f, 235 => 0x95, 291 => 0x753dcbc0, 292 => 0x17, 318 => 0x50a, 323 => 0x103a, 341 => 0x2d, 376 => 0x49, 408 => 0x100f, 410 => 0x2a },
	'noisereduction2' => { 322 => 0x1010 },
	'noisereductionapplied' => { 120 => 0xc6f7 },
	'noisereductionintensity' => { 292 => 0x9 },
	'noisereductionmethod' => { 292 => 0x11 },
	'noisereductionmode' => { 477 => 0x801e },
	'noisereductionparametersatcapture' => { 139 => 0xe73 },
	'noisereductionparameterscamera' => { 139 => 0xe72 },
	'noisereductionparametershost3mp' => { 139 => 0xe71 },
	'noisereductionparametershost6mp' => { 139 => 0xe70 },
	'noisereductionparametershostrgb' => { 139 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 139 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 139 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 139 => 0xe63 },
	'noisereductionparams' => { 346 => 0x1b },
	'noisereductionsharpness' => { 292 => 0xd },
	'noisereductionstrength' => { 341 => 0xd6 },
	'noisereductionvalue' => { 477 => 0x8027 },
	'nomemorycard' => { 298 => '22.1', 299 => '4.2', 300 => '0.3', 303 => '2.4', 304 => '3.2', 305 => '3.2', 307 => '33.7', 308 => '3.2', 309 => '0.3', 311 => '4.2', 313 => '4.5' },
	'nominalmaxaperture' => { 367 => 0xa },
	'nominalminaperture' => { 367 => '10.1' },
	'noncpulens10focallength' => { 240 => 0x6c6, 243 => 0x620 },
	'noncpulens10maxaperture' => { 240 => 0x6ee, 243 => 0x670 },
	'noncpulens11focallength' => { 240 => 0x6c8, 243 => 0x624 },
	'noncpulens11maxaperture' => { 240 => 0x6f0, 243 => 0x674 },
	'noncpulens12focallength' => { 240 => 0x6ca, 243 => 0x628 },
	'noncpulens12maxaperture' => { 240 => 0x6f2, 243 => 0x678 },
	'noncpulens13focallength' => { 240 => 0x6cc, 243 => 0x62c },
	'noncpulens13maxaperture' => { 240 => 0x6f4, 243 => 0x67c },
	'noncpulens14focallength' => { 240 => 0x6ce, 243 => 0x630 },
	'noncpulens14maxaperture' => { 240 => 0x6f6, 243 => 0x680 },
	'noncpulens15focallength' => { 240 => 0x6d0, 243 => 0x634 },
	'noncpulens15maxaperture' => { 240 => 0x6f8, 243 => 0x684 },
	'noncpulens16focallength' => { 240 => 0x6d2, 243 => 0x638 },
	'noncpulens16maxaperture' => { 240 => 0x6fa, 243 => 0x688 },
	'noncpulens17focallength' => { 240 => 0x6d4, 243 => 0x63c },
	'noncpulens17maxaperture' => { 240 => 0x6fc, 243 => 0x68c },
	'noncpulens18focallength' => { 240 => 0x6d6, 243 => 0x640 },
	'noncpulens18maxaperture' => { 240 => 0x6fe, 243 => 0x690 },
	'noncpulens19focallength' => { 240 => 0x6d8, 243 => 0x644 },
	'noncpulens19maxaperture' => { 240 => 0x700, 243 => 0x694 },
	'noncpulens1focallength' => { 240 => 0x6b4, 243 => 0x5fc },
	'noncpulens1maxaperture' => { 240 => 0x6dc, 243 => 0x64c },
	'noncpulens20focallength' => { 240 => 0x6da, 243 => 0x648 },
	'noncpulens20maxaperture' => { 240 => 0x702, 243 => 0x698 },
	'noncpulens2focallength' => { 240 => 0x6b6, 243 => 0x600 },
	'noncpulens2maxaperture' => { 240 => 0x6de, 243 => 0x650 },
	'noncpulens3focallength' => { 240 => 0x6b8, 243 => 0x604 },
	'noncpulens3maxaperture' => { 240 => 0x6e0, 243 => 0x654 },
	'noncpulens4focallength' => { 240 => 0x6ba, 243 => 0x608 },
	'noncpulens4maxaperture' => { 240 => 0x6e2, 243 => 0x658 },
	'noncpulens5focallength' => { 240 => 0x6bc, 243 => 0x60c },
	'noncpulens5maxaperture' => { 240 => 0x6e4, 243 => 0x65c },
	'noncpulens6focallength' => { 240 => 0x6be, 243 => 0x610 },
	'noncpulens6maxaperture' => { 240 => 0x6e6, 243 => 0x660 },
	'noncpulens7focallength' => { 240 => 0x6c0, 243 => 0x614 },
	'noncpulens7maxaperture' => { 240 => 0x6e8, 243 => 0x664 },
	'noncpulens8focallength' => { 240 => 0x6c2, 243 => 0x618 },
	'noncpulens8maxaperture' => { 240 => 0x6ea, 243 => 0x668 },
	'noncpulens9focallength' => { 240 => 0x6c4, 243 => 0x61c },
	'noncpulens9maxaperture' => { 240 => 0x6ec, 243 => 0x66c },
	'normallinetime' => { 139 => 0x186a },
	'normalwhitelevel' => { 42 => 0x32a, 43 => 0x280, 46 => [0x2b8,0x2cf,0x2d3], 47 => 0x569, 48 => 0x1e3, 49 => [0x1fc,0x2dc], 50 => [0x230,0x30e], 51 => 0x31c },
	'notes' => { 478 => 'Notes', 496 => 'notes' },
	'npages' => { 535 => 'NPages' },
	'nullrecord' => { 98 => 0x0 },
	'numafpoints' => { 353 => 0x2 },
	'number' => { 520 => 'number' },
	'numberofbeats' => { 530 => 'numberOfBeats' },
	'numberoffocuspoints' => { 301 => '1.3', 302 => '1.3', 305 => '0.2', 306 => '0.3', 308 => '0.3' },
	'numfaceelements' => { 128 => 0x4200 },
	'numfacepositions' => { 333 => 0x0 },
	'numindexentries' => { 134 => 0x54 },
	'numwbentries' => { 347 => 0x0, 348 => 0x0 },
	'object' => { 520 => 'object' },
	'objectattributereference' => { 132 => 0x4 },
	'objectcycle' => { 132 => 0x4b, 496 => 'ObjectCycle' },
	'objectdescription' => { 519 => 'objectDescription' },
	'objectdistance' => { 113 => 0x6, 114 => 0x2022 },
	'objectname' => { 132 => 0x5 },
	'objectpreviewdata' => { 132 => 0xca },
	'objectpreviewfileformat' => { 132 => 0xc8 },
	'objectpreviewfileversion' => { 132 => 0xc9 },
	'objectsubtype' => { 519 => 'objectSubtype' },
	'objecttype' => { 519 => 'objectType' },
	'objecttypereference' => { 132 => 0x3 },
	'occurrence' => { 119 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 119 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 119 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 119 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 119 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 119 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 119 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 119 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 119 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 119 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 119 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 119 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 119 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 119 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 119 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 119 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 119 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 119 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 119 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 119 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 119 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 119 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 119 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 119 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 119 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 119 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 119 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 119 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 119 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 119 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 507 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 507 => [\'OECF','OECFNames'] },
	'oecfrows' => { 507 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 507 => [\'OECF','OECFValues'] },
	'offsaledate' => { 520 => 'offSaleDate' },
	'offsaledatea-platform' => { 520 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 520 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 139 => 0x190a },
	'offsethdr' => { 512 => 'OffsetHDR' },
	'offsetschema' => { 120 => 0xea1d },
	'offsetsdr' => { 512 => 'OffsetSDR' },
	'offsettime' => { 120 => 0x9010 },
	'offsettimedigitized' => { 120 => 0x9012 },
	'offsettimeoriginal' => { 120 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 308 => '15.1', 313 => '16.1' },
	'oldsubfiletype' => { 120 => 0xff },
	'olympusimageheight' => { 323 => 0x102f },
	'olympusimagewidth' => { 323 => 0x102e },
	'omenatcapturestrength' => { 139 => 0xa60 },
	'omenautostrength' => { 139 => 0xa5f },
	'omenearlystrength' => { 139 => 0xa5e },
	'omenfocallengthlimit' => { 139 => 0xa62 },
	'omeninitialipfstrength' => { 139 => 0xa5d },
	'omensurfaceindex' => { 139 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 323 => 0x302 },
	'onsaledate' => { 520 => 'onSaleDate' },
	'onsaledatea-platform' => { 520 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 520 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 520 => 'onSaleDay' },
	'onsaledaya-platform' => { 520 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 520 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 120 => 0xc740 },
	'opcodelist2' => { 120 => 0xc741 },
	'opcodelist3' => { 120 => 0xc74e },
	'opticalzoom' => { 143 => 0xfa3d, 145 => [0x6006,0xf006], 146 => 0x1000, 147 => 0xf, 150 => 0x1e, 152 => 0x20, 153 => 0x1c, 164 => 'OpticalZoom' },
	'opticalzoomcode' => { 78 => 0xa },
	'opticalzoommode' => { 341 => 0x34 },
	'opticalzoomon' => { 417 => 0x219 },
	'optionenddate' => { 523 => 'optionEndDate' },
	'opto-electricconvfactor' => { 507 => 'OECF' },
	'orangehsl' => { 104 => 0x20911 },
	'ordernumber' => { 128 => 0x8002 },
	'organisationinimagecode' => { 515 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 515 => 'OrganisationInImageName' },
	'organism' => { 119 => 'Organism' },
	'organismassociatedoccurrences' => { 119 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 119 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 119 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 119 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 119 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 119 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 119 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 520 => 'organization' },
	'orientation' => { 120 => 0x112, 346 => 0x112, 519 => 'orientation', 526 => 'Orientation' },
	'orientation2' => { 446 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 85 => 0x516 },
	'originalalbumtitle' => { 180 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 180 => 'WM/OriginalArtist', 393 => "\xa9ope" },
	'originalbestqualitysize' => { 120 => 0xc792 },
	'originalcreatedatetime' => { 491 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 115 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 65 => 0x83 },
	'originaldefaultcropsize' => { 120 => 0xc793 },
	'originaldefaultfinalsize' => { 120 => 0xc791 },
	'originaldirectory' => { 338 => 0x408 },
	'originaldocumentid' => { 531 => 'OriginalDocumentID' },
	'originalfilename' => { 98 => 0x816, 139 => 0x3e9, 151 => 0x20, 338 => 0x407, 491 => 'OriginalFilename' },
	'originalimagehash' => { 481 => 'OriginalImageHash' },
	'originalimagehashtype' => { 481 => 'OriginalImageHashType' },
	'originalimageheight' => { 80 => 0xc, 124 => 0x1 },
	'originalimagemd5' => { 481 => 'OriginalImageMD5' },
	'originalimagesize' => { 163 => 'OriginalImageSize' },
	'originalimagewidth' => { 80 => 0xb, 124 => 0x0 },
	'originallyricist' => { 180 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 120 => 0xc68c },
	'originalrawfiledigest' => { 120 => 0xc71d },
	'originalrawfilename' => { 120 => 0xc68b },
	'originaltransmissionreference' => { 132 => 0x67 },
	'originatingprogram' => { 132 => 0x41, 496 => 'OriginatingProgram' },
	'originplatform' => { 520 => 'originPlatform' },
	'os' => { 505 => 'os' },
	'otherconditions' => { 328 => 'OtherConditions' },
	'otherconstraints' => { 328 => 'OtherConstraints' },
	'otherimage' => { 115 => 'Exif-OtherImage' },
	'otherimageinfo' => { 328 => 'OtherImageInfo' },
	'otherimagelength' => { 120 => 0x202 },
	'otherimagestart' => { 120 => 0x201 },
	'otherlicensedocuments' => { 328 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 328 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 328 => 'OtherLicenseRequirements' },
	'outcue' => { 530 => 'outCue' },
	'outcuescale' => { 530 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 530 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 201 => 0x3 },
	'outputimagewidth' => { 201 => 0x2 },
	'outputlut' => { 341 => 0xa7 },
	'outputprofile' => { 139 => 0x138b },
	'outputresolution' => { 201 => 0x4 },
	'overclockcols' => { 139 => 0x189c },
	'overclockrows' => { 139 => 0x18c4 },
	'overridelookvignette' => { 501 => 'OverrideLookVignette', 503 => 'OverrideLookVignette' },
	'owner' => { 393 => 'ownr', 534 => 'Owner' },
	'ownerid' => { 132 => 0xbc },
	'ownername' => { 15 => 0x10f, 65 => 0x9, 98 => 0x810, 120 => [0xa430,0xfde8], 157 => 'OwnerName', 498 => 'OwnerName', 508 => 'CameraOwnerName' },
	'padding' => { 120 => 0xea1c },
	'pagecount' => { 520 => 'pageCount' },
	'pageimage' => { 528 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 528 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 528 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 528 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 528 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 528 => 'PageInfo' },
	'pagename' => { 120 => 0x11d },
	'pagenumber' => { 120 => 0x129 },
	'pageprogressiondirection' => { 520 => 'pageProgressionDirection' },
	'pagerange' => { 520 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 501 => 'PaintBasedCorrections', 503 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 501 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 503 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 344 => 0x0 },
	'panasonicexifversion' => { 341 => 0x26 },
	'panasonicimageheight' => { 341 => 0x4c },
	'panasonicimagewidth' => { 341 => 0x4b },
	'panasonicrawversion' => { 346 => 0x1 },
	'panasonictitle' => { 120 => 0xc6d2 },
	'panasonictitle2' => { 120 => 0xc6d3 },
	'panoramaangle' => { 128 => 0x1153 },
	'panoramacropbottom' => { 447 => 0x7 },
	'panoramacropleft' => { 447 => 0x4 },
	'panoramacropright' => { 447 => 0x6 },
	'panoramacroptop' => { 447 => 0x5 },
	'panoramadirection' => { 73 => 0x5, 128 => 0x1154, 447 => 0x3 },
	'panoramaframeheight' => { 447 => 0x9 },
	'panoramaframenumber' => { 73 => 0x2 },
	'panoramaframewidth' => { 447 => 0x8 },
	'panoramafullheight' => { 447 => 0x2 },
	'panoramafullwidth' => { 447 => 0x1 },
	'panoramamode' => { 141 => 0x3c, 318 => 0x601 },
	'panoramasize3d' => { 430 => 0x38 },
	'panoramasourceheight' => { 447 => 0xb },
	'panoramasourcewidth' => { 447 => 0xa },
	'panoramicstitchcameramotion' => { 177 => 'PanoramicStitchCameraMotion', 178 => 0x1 },
	'panoramicstitchmaptype' => { 177 => 'PanoramicStitchMapType', 178 => 0x2 },
	'panoramicstitchphi0' => { 177 => 'PanoramicStitchPhi0', 178 => 0x5 },
	'panoramicstitchphi1' => { 177 => 'PanoramicStitchPhi1', 178 => 0x6 },
	'panoramicstitchtheta0' => { 177 => 'PanoramicStitchTheta0', 178 => 0x3 },
	'panoramicstitchtheta1' => { 177 => 'PanoramicStitchTheta1', 178 => 0x4 },
	'panoramicstitchversion' => { 178 => 0x0 },
	'pantry' => { 531 => 'Pantry' },
	'pantryinstanceid' => { 531 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 128 => 0xb211, 317 => 0x28 },
	'parametricdarks' => { 501 => 'ParametricDarks', 503 => 'ParametricDarks' },
	'parametrichighlights' => { 501 => 'ParametricHighlights', 503 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 501 => 'ParametricHighlightSplit', 503 => 'ParametricHighlightSplit' },
	'parametriclights' => { 501 => 'ParametricLights', 503 => 'ParametricLights' },
	'parametricmidtonesplit' => { 501 => 'ParametricMidtoneSplit', 503 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 501 => 'ParametricShadows', 503 => 'ParametricShadows' },
	'parametricshadowsplit' => { 501 => 'ParametricShadowSplit', 503 => 'ParametricShadowSplit' },
	'parentalrating' => { 180 => 'WM/ParentalRating' },
	'parentid' => { 515 => 'parentId' },
	'parentmediaeventid' => { 491 => 'ParentMediaEventID' },
	'parentmeid' => { 491 => 'ParentMEID' },
	'parentproductid' => { 393 => '@ppi' },
	'parentreference1' => { 513 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 513 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 393 => '@PST' },
	'parenttitle' => { 393 => '@pti' },
	'partialactivecols1' => { 139 => 0x17e8 },
	'partialactivecols2' => { 139 => 0x17f2 },
	'partialactiverows1' => { 139 => 0x17fc },
	'partialactiverows2' => { 139 => 0x1806 },
	'partofcompilation' => { 530 => 'partOfCompilation' },
	'patientbirthdate' => { 479 => 'PatientDOB' },
	'patientid' => { 479 => 'PatientID' },
	'patientname' => { 479 => 'PatientName' },
	'patientsex' => { 479 => 'PatientSex' },
	'patternareaheight' => { 139 => 0x963 },
	'patternareawidth' => { 139 => 0x962 },
	'patterncorrectionfactorscale' => { 139 => 0x969 },
	'patterncropcols1' => { 139 => 0x96c },
	'patterncropcols2' => { 139 => 0x96d },
	'patterncroprows1' => { 139 => 0x96a },
	'patterncroprows2' => { 139 => 0x96b },
	'patternimagerheight' => { 139 => 0x961 },
	'patternimagerwidth' => { 139 => 0x960 },
	'patternx' => { 139 => 0x966 },
	'patterny' => { 139 => 0x967 },
	'pdfversion' => { 517 => 'PDFVersion' },
	'pentaximagesize' => { 376 => 0x9 },
	'pentaxmodelid' => { 356 => 0x0, 376 => 0x5 },
	'pentaxmodeltype' => { 376 => 0x1 },
	'pentaxversion' => { 376 => 0x0 },
	'people' => { 482 => 'People', 494 => 'People' },
	'perchannelblacklevel' => { 42 => 0x157, 43 => 0x16b, 45 => 0xc4, 46 => [0x2b4,0x2cb,0x2cf], 47 => [0x108,0x14d], 48 => 0x1df, 49 => [0x1f8,0x2d8], 50 => [0x22c,0x30a], 51 => 0x149 },
	'performer' => { 393 => 'perf', 401 => 'perf' },
	'performerkeywords' => { 401 => "\xa9prk" },
	'performers' => { 401 => "\xa9prf" },
	'performerurl' => { 401 => "\xa9prl" },
	'period' => { 180 => 'WM/Period' },
	'peripheralillumcentralradius' => { 477 => 0x8030 },
	'peripheralillumcentralvalue' => { 477 => 0x8031 },
	'peripheralillumination' => { 104 => 0x20702, 110 => 0x68 },
	'peripheralilluminationcorr' => { 63 => 0x1, 366 => 0x2 },
	'peripheralilluminationon' => { 104 => '0x20702.0', 110 => 0x64 },
	'peripheralillumperiphvalue' => { 477 => 0x8032 },
	'peripherallighting' => { 80 => 0x2, 128 => 0x3804 },
	'peripherallightingsetting' => { 81 => 0x5 },
	'peripherallightingvalue' => { 80 => 0x6 },
	'permissions' => { 523 => 'permissions' },
	'permits' => { 499 => 'permits' },
	'person' => { 520 => 'person' },
	'personality' => { 491 => 'Personality' },
	'personheard' => { 515 => 'PersonHeard' },
	'personheardidentifier' => { 515 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 515 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 515 => 'PersonInImage' },
	'personinimagecharacteristic' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 515 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 515 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 501 => 'PerspectiveAspect', 503 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 501 => 'PerspectiveHorizontal', 503 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 501 => 'PerspectiveRotate', 503 => 'PerspectiveRotate' },
	'perspectivescale' => { 501 => 'PerspectiveScale', 503 => 'PerspectiveScale' },
	'perspectiveupright' => { 501 => 'PerspectiveUpright', 503 => 'PerspectiveUpright' },
	'perspectivevertical' => { 501 => 'PerspectiveVertical', 503 => 'PerspectiveVertical' },
	'perspectivex' => { 501 => 'PerspectiveX', 503 => 'PerspectiveX' },
	'perspectivey' => { 501 => 'PerspectiveY', 503 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 93 => 0x1 },
	'pf10retainprogramshift' => { 93 => 0xb },
	'pf13drivepriority' => { 93 => 0xe },
	'pf14disablefocussearch' => { 93 => 0xf },
	'pf15disableafassistbeam' => { 93 => 0x10 },
	'pf16autofocuspointshoot' => { 93 => 0x11 },
	'pf17disableafpointsel' => { 93 => 0x12 },
	'pf18enableautoafpointsel' => { 93 => 0x13 },
	'pf19continuousshootspeed' => { 93 => 0x14 },
	'pf19shootingspeedhigh' => { 92 => 0xa },
	'pf19shootingspeedlow' => { 92 => 0x9 },
	'pf1disableshootingmodes' => { 93 => 0x2 },
	'pf1value' => { 92 => 0x1 },
	'pf20limitcontinousshots' => { 93 => 0x15 },
	'pf20maxcontinousshots' => { 92 => 0xb },
	'pf21enablequietoperation' => { 93 => 0x16 },
	'pf23felocktime' => { 92 => 0xd },
	'pf23postreleasetime' => { 92 => 0xe },
	'pf23settimerlengths' => { 93 => 0x18 },
	'pf23shutterbuttontime' => { 92 => 0xc },
	'pf24lightlcdduringbulb' => { 93 => 0x19 },
	'pf25aemode' => { 92 => 0xf },
	'pf25afmode' => { 92 => 0x12 },
	'pf25afpointsel' => { 92 => 0x13 },
	'pf25colormatrix' => { 92 => 0x17 },
	'pf25defaultclearsettings' => { 93 => 0x1a },
	'pf25drivemode' => { 92 => 0x11 },
	'pf25imagesize' => { 92 => 0x14 },
	'pf25meteringmode' => { 92 => 0x10 },
	'pf25parameters' => { 92 => 0x16 },
	'pf25wbmode' => { 92 => 0x15 },
	'pf26shortenreleaselag' => { 93 => 0x1b },
	'pf27reversedialrotation' => { 93 => 0x1c },
	'pf27value' => { 92 => 0x18 },
	'pf28noquickdialexpcomp' => { 93 => 0x1d },
	'pf29quickdialswitchoff' => { 93 => 0x1e },
	'pf2disablemeteringmodes' => { 93 => 0x3 },
	'pf2value' => { 92 => 0x2 },
	'pf30enlargementmode' => { 93 => 0x1f },
	'pf31originaldecisiondata' => { 93 => 0x20 },
	'pf3manualexposuremetering' => { 93 => 0x4 },
	'pf3value' => { 92 => 0x3 },
	'pf4exposuretimelimits' => { 93 => 0x5 },
	'pf4exposuretimemax' => { 92 => 0x5 },
	'pf4exposuretimemin' => { 92 => 0x4 },
	'pf5aperturelimits' => { 93 => 0x6 },
	'pf5aperturemax' => { 92 => 0x7 },
	'pf5aperturemin' => { 92 => 0x6 },
	'pf6presetshootingmodes' => { 93 => 0x7 },
	'pf7bracketcontinuousshoot' => { 93 => 0x8 },
	'pf8bracketshots' => { 92 => 0x8 },
	'pf8setbracketshots' => { 93 => 0x9 },
	'pf9changebracketsequence' => { 93 => 0xa },
	'phasedetectaf' => { 194 => 0x6 },
	'phonenumber' => { 158 => 'Phone' },
	'photoeffect' => { 35 => 0x28 },
	'photoeffecthistoryxml' => { 291 => 0xe9651831 },
	'photoeffects' => { 291 => 0xab5eca5e },
	'photoeffectsblue' => { 293 => 0x8 },
	'photoeffectsgreen' => { 293 => 0x6 },
	'photoeffectsred' => { 293 => 0x4 },
	'photoeffectstype' => { 293 => 0x0 },
	'photographer' => { 120 => 0xa437 },
	'photographicsensitivity' => { 508 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 298 => '17.6', 307 => '33.6' },
	'photometricinterpretation' => { 120 => 0x106, 526 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 240 => 0x11e, 241 => 0x112, 242 => 0x122, 243 => 0x122, 244 => 0x24, 262 => 0x0 },
	'photoshootingmenubankimagearea' => { 238 => 0x6dd, 240 => 0x144, 241 => 0x134, 242 => 0x148, 243 => 0x148, 262 => '7.1' },
	'photoshopbgrthumbnail' => { 390 => 0x409 },
	'photoshopquality' => { 389 => 0x0 },
	'photoshopthumbnail' => { 390 => 0x40c },
	'photostyle' => { 341 => 0x89 },
	'picasawebgphotoid' => { 506 => 'picasawebGPhotoId' },
	'picklabel' => { 506 => 'PickLabel' },
	'pictinfo' => { 417 => 0x208 },
	'picturecontrol' => { 291 => 0xe2173c47 },
	'picturecontrolactive' => { 294 => 0x0 },
	'picturecontroladjust' => { 250 => 0x30, 251 => 0x30, 252 => 0x36 },
	'picturecontrolbase' => { 250 => 0x18, 251 => 0x18, 252 => 0x1c },
	'picturecontroldata' => { 235 => [0xbd,0x23] },
	'picturecontrolmode' => { 294 => 0x13 },
	'picturecontrolname' => { 250 => 0x4, 251 => 0x4, 252 => 0x8 },
	'picturecontrolquickadjust' => { 250 => 0x31, 251 => 0x31, 252 => 0x37 },
	'pictureeffect' => { 441 => 0x200e },
	'pictureeffect2' => { 450 => 0x1163, 451 => 0x1167, 452 => 0x1143, 453 => 0x11bf, 454 => 0x119b, 455 => 0x1053, 456 => 0x24b, 457 => 0x24b, 458 => 0x23c, 473 => 0x46 },
	'picturefinish' => { 183 => 0x71 },
	'picturemode' => { 128 => 0x1031, 318 => 0x520, 376 => [0xb,0x33], 418 => 0x3d },
	'picturemode2' => { 357 => 0x0 },
	'picturemodebwfilter' => { 318 => 0x525 },
	'picturemodecontrast' => { 318 => 0x523 },
	'picturemodeeffect' => { 318 => 0x52d },
	'picturemodehue' => { 318 => 0x522 },
	'picturemodesaturation' => { 318 => 0x521 },
	'picturemodesharpness' => { 318 => 0x524 },
	'picturemodetone' => { 318 => 0x526 },
	'pictureprofile' => { 450 => [0x115e,0x115f], 451 => [0x1162,0x1163], 452 => [0x113e,0x113f], 453 => [0x11ba,0x11bb], 454 => [0x1196,0x1197], 455 => [0x104e,0x104f], 456 => [0x246,0x247], 457 => [0x246,0x247], 458 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 75 => 0xa, 104 => 0x20301, 110 => 0x2 },
	'picturestylepc' => { 65 => 0x4009 },
	'picturestyleuserdef' => { 65 => 0x4008 },
	'picturewizard' => { 415 => 0x21 },
	'picturewizardcolor' => { 414 => 0x1 },
	'picturewizardcontrast' => { 414 => 0x4 },
	'picturewizardmode' => { 414 => 0x0 },
	'picturewizardsaturation' => { 414 => 0x2 },
	'picturewizardsharpness' => { 414 => 0x3 },
	'pipelineversion' => { 177 => 'PipelineVersion' },
	'pitch' => { 116 => 0x6, 299 => '4.1', 311 => '4.1', 401 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 248 => 0x4, 318 => 0x904, 341 => 0x91, 375 => 0x2, 413 => 0x1 },
	'pitchshift' => { 395 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 394 => 'pasp' },
	'pixelclockfrequency' => { 139 => 0x40b },
	'pixelcorrectionoffset' => { 139 => 0x972 },
	'pixelcorrectionscale' => { 139 => 0x971 },
	'pixelscale' => { 120 => 0x830e },
	'pixelshiftinfo' => { 441 => 0x202f },
	'pixelshiftoffset' => { 128 => 0x1106 },
	'pixelshiftresolution' => { 377 => 0x0 },
	'pixelshiftshots' => { 128 => 0x1105 },
	'pixelsperunitx' => { 330 => 0x0 },
	'pixelsperunity' => { 330 => 0x4 },
	'pixelunits' => { 330 => 0x8 },
	'planarconfiguration' => { 120 => 0x11c, 526 => 'PlanarConfiguration' },
	'plane' => { 480 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 480 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 480 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 480 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 480 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 480 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 480 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 480 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 480 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 480 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 480 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 480 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 480 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 480 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 480 => 'Planes' },
	'planningref' => { 515 => 'PlanningRef' },
	'planningrefidentifier' => { 515 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 515 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 515 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 535 => 'PlateNames' },
	'platform' => { 520 => 'platform' },
	'playallframes' => { 401 => 'AllF' },
	'playbackbutton' => { 243 => 0x808 },
	'playbackbuttonplaybackmode' => { 243 => 0x814 },
	'playbackflickdown' => { 314 => 0x159, 315 => 0x159, 316 => 0x171 },
	'playbackflickup' => { 314 => 0x155, 315 => 0x155, 316 => 0x16d },
	'playbackmenustime' => { 303 => '20.1', 304 => '21.1', 305 => '21.1' },
	'playbackmonitorofftime' => { 298 => '25.2', 299 => '36.1', 301 => '36.1', 302 => '36.1', 306 => '35.1', 307 => '8.1', 308 => '35.1', 311 => '36.1', 312 => '36.1', 313 => '21.1', 314 => 0x33, 315 => 0x33, 316 => 0x33 },
	'playbackzoom' => { 299 => '37.1' },
	'playdisplay' => { 185 => 0x4e },
	'playerversion' => { 395 => 'player.version' },
	'playgap' => { 393 => 'pgap' },
	'playmode' => { 401 => 'SDLN' },
	'playselection' => { 401 => 'SelO' },
	'plusversion' => { 328 => 'Version' },
	'pmversion' => { 388 => 'PMVersion' },
	'pngwarning' => { 331 => 'Warning' },
	'podcast' => { 393 => 'pcst' },
	'podcasturl' => { 393 => 'purl' },
	'poilevel' => { 234 => 0x8 },
	'portraitimpressionbalance' => { 240 => 0x26e, 253 => 0xa0 },
	'portraitnote' => { 484 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 110 => 0x1d },
	'portraitoutputshadowpoint' => { 110 => 0x1e },
	'portraitrawcolortone' => { 110 => 0x16 },
	'portraitrawcontrast' => { 110 => 0x18 },
	'portraitrawhighlight' => { 110 => 0x76 },
	'portraitrawhighlightpoint' => { 110 => 0x1b },
	'portraitrawlinear' => { 110 => 0x19 },
	'portraitrawsaturation' => { 110 => 0x17 },
	'portraitrawshadow' => { 110 => 0x7f },
	'portraitrawshadowpoint' => { 110 => 0x1c },
	'portraitrawsharpness' => { 110 => 0x1a },
	'portraitrefiner' => { 114 => 0x302b },
	'portraitrequest' => { 484 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 110 => 0x9a },
	'portraitunsharpmaskstrength' => { 110 => 0x98 },
	'portraitunsharpmaskthreshold' => { 110 => 0x9c },
	'portraitversion' => { 484 => 'PortraitVersion' },
	'pose' => { 480 => 'Pose' },
	'poseheadingdegrees' => { 489 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 489 => 'PosePitchDegrees' },
	'posepositionx' => { 480 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 480 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 480 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 489 => 'PoseRollDegrees' },
	'poserotationw' => { 480 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 480 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 480 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 480 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 480 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 519 => 'positionDescriptor' },
	'postalcode' => { 162 => 'PostalCode' },
	'postcropvignetteamount' => { 501 => 'PostCropVignetteAmount', 503 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 501 => 'PostCropVignetteFeather', 503 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 501 => 'PostCropVignetteHighlightContrast', 503 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 501 => 'PostCropVignetteMidpoint', 503 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 501 => 'PostCropVignetteRoundness', 503 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 501 => 'PostCropVignetteStyle', 503 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 341 => 0xbf },
	'postreleaseburstlength' => { 242 => 0x714, 243 => 0x784, 314 => 0x289 },
	'potentialface1position' => { 438 => 0xb },
	'potentialface2position' => { 438 => 0x15 },
	'potentialface3position' => { 438 => 0x1f },
	'potentialface4position' => { 438 => 0x29 },
	'potentialface5position' => { 438 => 0x33 },
	'potentialface6position' => { 438 => 0x3d },
	'potentialface7position' => { 438 => 0x47 },
	'potentialface8position' => { 438 => 0x51 },
	'powersource' => { 355 => '0.1' },
	'poweruptime' => { 235 => 0xb6 },
	'preaf' => { 127 => '0.2' },
	'precaptureframes' => { 323 => 0x300 },
	'predictor' => { 120 => 0x13d },
	'preflashreturnstrength' => { 270 => 0x28a },
	'prefs' => { 132 => 0xdd, 388 => 'Prefs' },
	'prereadfastresetcount' => { 139 => 0x187e },
	'prereleaseburstlength' => { 242 => 0x712, 243 => 0x782, 314 => 0x287 },
	'preservedfilename' => { 531 => 'PreservedFileName' },
	'preservedspecimen' => { 119 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 119 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 501 => 'PresetType', 503 => 'PresetType' },
	'presetwhitebalance' => { 185 => 0x24, 477 => 0x8002 },
	'presetwhitebalanceadj' => { 477 => 0x8014 },
	'pressure' => { 120 => 0x9402, 508 => 'Pressure' },
	'previewapplicationname' => { 120 => 0xc716 },
	'previewapplicationversion' => { 120 => 0xc717 },
	'previewbutton' => { 298 => ['14.1','15.1'], 299 => '15.1', 301 => '15.1', 302 => '15.1', 307 => '29.1', 308 => '14.1', 311 => '15.1', 312 => '15.1' },
	'previewbuttonplusdials' => { 298 => ['14.2','15.2'], 299 => '15.2', 301 => '43.1', 302 => '43.1', 307 => '31.2', 311 => '43.1', 312 => '43.1' },
	'previewcolorspace' => { 120 => 0xc71a },
	'previewcropbottom' => { 387 => 0xef },
	'previewcropleft' => { 387 => 0xec },
	'previewcropright' => { 387 => 0xee },
	'previewcroptop' => { 387 => 0xed },
	'previewdate' => { 399 => 0x0 },
	'previewdatetime' => { 120 => 0xc71b },
	'previewimage' => { 114 => 0x2000, 115 => 'Exif-PreviewImage', 121 => 'PreviewImage', 123 => 0x4, 167 => 'data', 187 => 0x81, 323 => 0x280, 339 => 0x300, 401 => 'mcvr', 441 => 0x2001 },
	'previewimageborders' => { 376 => 0x3e },
	'previewimageheight' => { 74 => 0x4, 143 => 0xfa58 },
	'previewimagelength' => { 74 => 0x2, 114 => 0x3, 120 => [0x117,0x202], 187 => 0x89, 254 => 0x202, 318 => 0x102, 323 => 0x1037, 376 => 0x3, 407 => 0x1e, 412 => 0x3, 418 => [0x1b,0x1d], 431 => 0x202 },
	'previewimagename' => { 167 => '1Name' },
	'previewimagesize' => { 114 => 0x2, 148 => 0x2, 167 => 'ImageSize', 376 => 0x2, 418 => [0x1c,0x1e], 441 => 0xb02c, 477 => 0x9012 },
	'previewimagestart' => { 74 => 0x5, 114 => 0x4, 120 => [0x111,0x201], 187 => 0x88, 254 => 0x201, 318 => 0x101, 323 => 0x1036, 376 => 0x4, 407 => 0x1c, 412 => 0x2, 418 => [0x1a,0x1c], 431 => 0x201 },
	'previewimagetype' => { 167 => '0Type' },
	'previewimagevalid' => { 318 => 0x100, 323 => 0x1035 },
	'previewimagewidth' => { 74 => 0x3, 143 => 0xfa57 },
	'previewquality' => { 74 => 0x1 },
	'previewsettingsdigest' => { 120 => 0xc719 },
	'previewsettingsname' => { 120 => 0xc718 },
	'primaryafpoint' => { 194 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 120 => 0x13f, 526 => 'PrimaryChromaticities' },
	'primaryftp' => { 491 => 'PrimaryFTP' },
	'primaryslot' => { 244 => 0x25, 262 => 0x2 },
	'printim' => { 120 => 0xc4a5 },
	'prioritysetinawb' => { 441 => 0x202b },
	'prioritysetupshutterrelease' => { 185 => 0x1d, 428 => 0x28 },
	'privatertkinfo' => { 493 => 'privateRTKInfo' },
	'processbordercolsleft' => { 139 => 0xc61 },
	'processbordercolsright' => { 139 => 0xc62 },
	'processborderrowsbottom' => { 139 => 0xc64 },
	'processborderrowstop' => { 139 => 0xc63 },
	'processingsoftware' => { 120 => 0xb },
	'processversion' => { 501 => 'ProcessVersion', 503 => 'ProcessVersion' },
	'producer' => { 180 => 'WM/Producer', 327 => 'Producer', 393 => "\xa9prd", 395 => 'producer', 401 => "\xa9prd", 517 => 'Producer' },
	'producerkeywords' => { 401 => "\xa9pdk" },
	'productcode' => { 520 => 'productCode' },
	'productid' => { 133 => 0x32, 393 => 'prID', 519 => 'productID' },
	'productidtype' => { 519 => 'productIDType' },
	'productinimage' => { 515 => 'ProductInImage' },
	'productinimagedescription' => { 515 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 515 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 515 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 515 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 356 => 0x2 },
	'productorserviceconstraints' => { 328 => 'ProductOrServiceConstraints' },
	'productversion' => { 393 => 'VERS' },
	'profession' => { 520 => 'profession' },
	'profile' => { 480 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 120 => 0xc6f4 },
	'profilecameraindices' => { 480 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 120 => 0xc6fe },
	'profileembedpolicy' => { 120 => 0xc6fd },
	'profilegaintablemap' => { 120 => 0xcd2d },
	'profilehuesatmapdata1' => { 120 => 0xc6fa },
	'profilehuesatmapdata2' => { 120 => 0xc6fb },
	'profilehuesatmapdata3' => { 120 => 0xcd39 },
	'profilehuesatmapdims' => { 120 => 0xc6f9 },
	'profilehuesatmapencoding' => { 120 => 0xc7a3 },
	'profilelooktabledata' => { 120 => 0xc726 },
	'profilelooktabledims' => { 120 => 0xc725 },
	'profilelooktableencoding' => { 120 => 0xc7a4 },
	'profilename' => { 120 => 0xc6f8, 329 => 'iCCP-name' },
	'profiles' => { 480 => 'Profiles' },
	'profiletonecurve' => { 120 => 0xc6fc },
	'profiletype' => { 480 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 341 => 0x3c },
	'programline' => { 357 => '1.1' },
	'programmode' => { 190 => 0x5 },
	'programshift' => { 235 => 0xd },
	'programversion' => { 132 => 0x46 },
	'prohibits' => { 499 => 'prohibits' },
	'projectiontype' => { 489 => 'ProjectionType', 490 => 'ProjectionType' },
	'projectname' => { 530 => 'projectName' },
	'projectref' => { 530 => 'projectRef' },
	'projectrefpath' => { 530 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 530 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 180 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 328 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 328 => 'PropertyReleaseStatus' },
	'provider' => { 180 => 'WM/Provider' },
	'province-state' => { 132 => 0x5f },
	'publicationdate' => { 520 => 'publicationDate' },
	'publicationdatea-platform' => { 520 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 520 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 520 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 520 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 520 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 515 => 'PublicationEvent' },
	'publicationeventdate' => { 515 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 515 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 515 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 520 => 'publicationName' },
	'publisher' => { 180 => 'WM/Publisher', 393 => "\xa9pub", 395 => 'publisher', 504 => 'publisher' },
	'publishingfrequency' => { 520 => 'publishingFrequency' },
	'pulldown' => { 530 => 'pullDown' },
	'purchasedate' => { 393 => 'purd' },
	'purplehsl' => { 104 => 0x20916 },
	'pxshiftperiphedgenr' => { 477 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 477 => 0x9014 },
	'quality' => { 0 => 0x1, 35 => 0x3, 113 => 0x2, 114 => 0x3002, 128 => 0x1000, 141 => 0x9, 235 => 0x4, 281 => 0x3, 323 => 0x201, 336 => 0x300, 376 => 0x8, 383 => 0x2, 418 => 0x16, 428 => 0x56, 429 => 0x56, 430 => 0xb, 441 => [0x102,0x202e] },
	'quality2' => { 450 => 0x1170, 451 => 0x1174, 452 => 0x1150, 454 => 0x11a8, 455 => 0x1060, 456 => 0x258, 457 => 0x258, 458 => 0x247, 464 => 0x29, 465 => 0x25, 466 => 0x2a },
	'qualitybutton' => { 315 => 0x17d, 316 => 0x195 },
	'qualitybuttonplaybackmode' => { 315 => 0x1bf, 316 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 114 => 0x8 },
	'quantizationmethod' => { 134 => 0x78 },
	'quickadjust' => { 294 => 0x2a },
	'quickcontroldialinmeter' => { 85 => 0x703 },
	'quickfix' => { 291 => 0x416391c6 },
	'quickshot' => { 417 => 0x213 },
	'quiettime' => { 139 => 0x188a },
	'rads' => { 401 => 'rads' },
	'rangefinder' => { 303 => '4.1', 304 => '5.1', 305 => '5.1' },
	'rangemask' => { 501 => 'RangeMaskMapInfo', 503 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 501 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 503 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 501 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 503 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 501 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 503 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 501 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 503 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 501 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 503 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 501 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 503 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 132 => 0x7d },
	'rating' => { 120 => 0x4746, 128 => 0x1431, 387 => 0xdf, 393 => 'rtng', 401 => 'rtng', 441 => 0x2002, 496 => 'rating', 505 => 'rating', 515 => 'Rating', 520 => 'rating', 528 => 'Rating' },
	'ratingpercent' => { 120 => 0x4749, 179 => 'Rating', 393 => 'rate', 528 => 'RatingPercent' },
	'ratingregion' => { 515 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 515 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 515 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 515 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 515 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 515 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 515 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 515 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 515 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 515 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 515 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 515 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 515 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 515 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 515 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 515 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 515 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 515 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 83 => 0x8, 187 => 0x109, 357 => 0xd },
	'rawbrightnessadj' => { 104 => 0x20001, 109 => 0x38 },
	'rawburstimagecount' => { 76 => 0x2 },
	'rawburstimagenum' => { 76 => 0x1 },
	'rawcoloradj' => { 109 => 0x2e },
	'rawcropbottom' => { 387 => 0xd4 },
	'rawcropleft' => { 387 => 0xd1 },
	'rawcropright' => { 387 => 0xd3 },
	'rawcroptop' => { 387 => 0xd2 },
	'rawcustomsaturation' => { 109 => 0x30 },
	'rawcustomtone' => { 109 => 0x34 },
	'rawdata' => { 415 => 0xa048 },
	'rawdatabyteorder' => { 415 => 0x40 },
	'rawdatacfapattern' => { 415 => 0x50 },
	'rawdatauniqueid' => { 120 => 0xc65d },
	'rawdepth' => { 189 => 0x10 },
	'rawdevartfilter' => { 325 => 0x121 },
	'rawdevautogradation' => { 325 => 0x119 },
	'rawdevcolorspace' => { 324 => 0x108, 325 => 0x109 },
	'rawdevcontrastvalue' => { 324 => 0x106, 325 => 0x105 },
	'rawdeveditstatus' => { 324 => 0x10b },
	'rawdevelopingsoftware' => { 120 => 0xa43a },
	'rawdevelopmentprocess' => { 376 => 0x62 },
	'rawdevengine' => { 324 => 0x109, 325 => 0x10b },
	'rawdevexposurebiasvalue' => { 324 => 0x100, 325 => 0x100 },
	'rawdevgradation' => { 325 => 0x112 },
	'rawdevgraypoint' => { 324 => 0x103, 325 => 0x104 },
	'rawdevmemorycoloremphasis' => { 324 => 0x105, 325 => 0x108 },
	'rawdevnoisereduction' => { 324 => 0x10a, 325 => 0x10a },
	'rawdevpicturemode' => { 325 => 0x10c },
	'rawdevpm_bwfilter' => { 325 => 0x110 },
	'rawdevpmcontrast' => { 325 => 0x10e },
	'rawdevpmnoisefilter' => { 325 => 0x120 },
	'rawdevpmpicturetone' => { 325 => 0x111 },
	'rawdevpmsaturation' => { 325 => 0x10d },
	'rawdevpmsharpness' => { 325 => 0x10f },
	'rawdevsaturation3' => { 325 => 0x113 },
	'rawdevsaturationemphasis' => { 324 => 0x104, 325 => 0x107 },
	'rawdevsettings' => { 324 => 0x10c },
	'rawdevsharpnessvalue' => { 324 => 0x107, 325 => 0x106 },
	'rawdevversion' => { 324 => 0x0, 325 => 0x0 },
	'rawdevwbfineadjustment' => { 324 => 0x102, 325 => 0x103 },
	'rawdevwhitebalance' => { 325 => 0x101 },
	'rawdevwhitebalancevalue' => { 324 => 0x101, 325 => 0x102 },
	'rawfile' => { 120 => 0xfe4c },
	'rawfilename' => { 501 => 'RawFileName', 503 => 'RawFileName' },
	'rawfiletype' => { 441 => 0x2029 },
	'rawformat' => { 346 => 0x2d, 385 => 0x10e },
	'rawimagecenter' => { 235 => 0x99 },
	'rawimagedigest' => { 120 => 0xc71c },
	'rawimagesize' => { 376 => 0x39 },
	'rawinfoversion' => { 326 => 0x0 },
	'rawjpgheight' => { 100 => 0x4 },
	'rawjpgquality' => { 58 => 0x6, 100 => 0x1 },
	'rawjpgsize' => { 58 => 0x7, 100 => 0x2 },
	'rawjpgwidth' => { 100 => 0x3 },
	'rawmeasuredrggb' => { 44 => 0x26a, 46 => 0x280, 48 => 0x194, 49 => [0x1ad,0x26b] },
	'rawrppused' => { 496 => 'rawrppused' },
	'rawtopreviewgain' => { 120 => 0xc7a8 },
	'readouttypeactual' => { 139 => 0x1903 },
	'readouttyperequested' => { 139 => 0x1902 },
	'reardisplay' => { 298 => '12.3', 299 => '6.2' },
	'recdevice' => { 515 => 'RecDevice' },
	'recdeviceattlensdescription' => { 515 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 515 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 515 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 515 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 515 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 522 => 'recipeEndingPage' },
	'recipepagerange' => { 522 => 'recipePageRange' },
	'recipesource' => { 522 => 'recipeSource' },
	'recipestartingpage' => { 522 => 'recipeStartingPage' },
	'recipetitle' => { 522 => 'recipeTitle' },
	'recognizedface1age' => { 334 => 0x20 },
	'recognizedface1name' => { 334 => 0x4 },
	'recognizedface1position' => { 334 => 0x18 },
	'recognizedface2age' => { 334 => 0x50 },
	'recognizedface2name' => { 334 => 0x34 },
	'recognizedface2position' => { 334 => 0x48 },
	'recognizedface3age' => { 334 => 0x80 },
	'recognizedface3name' => { 334 => 0x64 },
	'recognizedface3position' => { 334 => 0x78 },
	'recognizedfaceflags' => { 341 => 0x63 },
	'recommendedexposureindex' => { 120 => 0x8832, 508 => 'RecommendedExposureIndex' },
	'record' => { 119 => 'Record' },
	'recordbasisofrecord' => { 119 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 119 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 119 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 119 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 119 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 119 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 185 => 0x4d },
	'recorddynamicproperties' => { 119 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 98 => 0x1804 },
	'recordinformationwithheld' => { 119 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 401 => "\xa9phg" },
	'recordingformat' => { 408 => 0x1000 },
	'recordingmode' => { 113 => 0x1, 383 => 0x1 },
	'recordinstitutioncode' => { 119 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 119 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 401 => "\xa9lab" },
	'recordlabelurl' => { 401 => "\xa9lal" },
	'recordlocationdata' => { 241 => 0x660, 242 => 0x690, 243 => 0x6f8 },
	'recordmode' => { 35 => 0x9, 114 => 0x3000 },
	'recordownerinstitutioncode' => { 119 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 417 => 0x217 },
	'redbalance' => { 323 => 0x1017, 346 => 0x11, 376 => 0x1c },
	'redcurvelimits' => { 109 => 0x18a },
	'redcurvepoints' => { 108 => 0x2d, 109 => 0x160 },
	'redeyecorrection' => { 295 => 0x0 },
	'redeyeinfo' => { 501 => 'RedEyeInfo', 503 => 'RedEyeInfo' },
	'redeyereduction' => { 185 => 0x41, 428 => 0x6a, 430 => 0x28 },
	'redeyeremoval' => { 341 => 0xb9 },
	'redhsl' => { 104 => 0x20910 },
	'redhue' => { 501 => 'RedHue', 503 => 'RedHue' },
	'redsaturation' => { 501 => 'RedSaturation', 503 => 'RedSaturation' },
	'reductionmatrix1' => { 120 => 0xc625 },
	'reductionmatrix2' => { 120 => 0xc626 },
	'reductionmatrix3' => { 120 => 0xcd3a },
	'reelname' => { 120 => 0xc789, 401 => 'reel' },
	'reference1' => { 513 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 513 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 120 => 0x214, 526 => 'ReferenceBlackWhite' },
	'referencedate' => { 132 => 0x2f },
	'referencenumber' => { 132 => 0x32 },
	'references' => { 158 => 'References' },
	'referenceservice' => { 132 => 0x2d },
	'regionappliedtodimensions' => { 173 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 173 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 173 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 173 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 173 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 173 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 173 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 173 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 173 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 173 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 173 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 173 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 328 => 'RegionConstraints' },
	'regiondescription' => { 173 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 173 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 173 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 173 => 'Regions' },
	'regioninfodateregionsvalid' => { 176 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 176 => 'RegionInfo' },
	'regioninforegions' => { 176 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 173 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 173 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 176 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 176 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 176 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 176 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 176 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 173 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 173 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 173 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 515 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 515 => 'RegistryId' },
	'registryitemid' => { 515 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 515 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 156 => 'data' },
	'relatedaudiofilename' => { 156 => '1Name' },
	'relatedaudiofiletype' => { 156 => '0Type' },
	'relatedimagefileformat' => { 120 => 0x1000 },
	'relatedimageheight' => { 120 => 0x1002 },
	'relatedimagewidth' => { 120 => 0x1001 },
	'relatedresourceid' => { 119 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 120 => 0xa004, 507 => 'RelatedSoundFile' },
	'relatedvideofile' => { 170 => 'data' },
	'relatedvideofilename' => { 170 => '1Name' },
	'relatedvideofiletype' => { 170 => '0Type' },
	'relation' => { 504 => 'relation' },
	'relationshipaccordingto' => { 119 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 119 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 119 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 119 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 119 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 117 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 530 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 530 => 'relativeTimestamp' },
	'relativetimestampscale' => { 530 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 530 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 298 => '17.8', 299 => '18.5', 301 => '18.4', 302 => '18.4', 307 => '33.8', 308 => '17.6', 311 => '18.5', 312 => '18.4' },
	'releasedate' => { 132 => 0x1e, 393 => 'rldt', 496 => 'ReleaseDate', 530 => 'releaseDate' },
	'releasemode' => { 114 => 0x3001, 239 => 0x5c, 272 => 0x184d, 441 => 0xb049 },
	'releasemode2' => { 450 => 0x112c, 451 => [0x112c,0x8], 452 => [0x1108,0x8], 453 => [0x1184,0x8], 454 => [0x1160,0x8], 455 => [0x4,0x1018], 456 => [0x4,0x210], 457 => [0x4,0x210], 458 => [0x4,0x208], 460 => [0x67,0x3f], 461 => [0x6b,0x6d,0x73,0x4b], 462 => [0x6b,0x4b], 463 => 0x1f, 464 => 0x10, 465 => 0x10, 466 => 0x9, 473 => 0x34 },
	'releasemode3' => { 450 => 0x1128, 451 => 0x1128, 452 => 0x1104, 453 => 0x1180, 454 => 0x115c, 455 => 0x1014, 456 => 0x20c, 457 => 0x20c, 458 => 0x204 },
	'releaseready' => { 515 => 'ReleaseReady' },
	'releasesetting' => { 98 => 0x1016 },
	'releasetime' => { 132 => 0x23, 496 => 'ReleaseTime' },
	'remoteonduration' => { 300 => '3.4', 303 => '17.2', 304 => '18.2', 305 => '18.2', 306 => '18.2', 308 => '18.2', 309 => '4.3', 313 => '19.2' },
	'renditionclass' => { 531 => 'RenditionClass' },
	'renditionof' => { 531 => 'RenditionOf' },
	'renditionofalternatepaths' => { 531 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 531 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 531 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 531 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 531 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 531 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 531 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 531 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 531 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 531 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 531 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 531 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 531 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 531 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 531 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 531 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 531 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 531 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 531 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 531 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 531 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 531 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 531 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 531 => 'RenditionParams' },
	'repeatingflashcount' => { 213 => 0xd, 214 => 0xe, 215 => 0xe, 216 => 0xe, 217 => 0xe, 218 => 0xe, 307 => '17.2', 308 => '24.2', 309 => '9.2', 310 => '24.2', 313 => '25.2' },
	'repeatingflashcountbuilt-in' => { 279 => 0x4db },
	'repeatingflashcountexternal' => { 279 => 0x4c3 },
	'repeatingflashoutput' => { 307 => '17.1', 308 => '24.1', 309 => '9.1', 310 => '24.1', 313 => '25.1' },
	'repeatingflashoutputexternal' => { 279 => 0x4c0 },
	'repeatingflashrate' => { 213 => 0xc, 214 => 0xd, 215 => 0xd, 216 => 0xd, 217 => 0xd, 218 => 0xd, 307 => '18.1', 308 => '25.1', 309 => '10.1', 310 => '25.1', 313 => '26.1' },
	'repeatingflashratebuilt-in' => { 279 => 0x4da },
	'repeatingflashrateexternal' => { 279 => 0x4c2 },
	'requirements' => { 401 => "\xa9req" },
	'requires' => { 499 => 'requires' },
	'resampleparams' => { 530 => 'resampleParams' },
	'resampleparamsquality' => { 530 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 139 => 0xe50 },
	'resamplingkerneldenominators067' => { 139 => 0xe4f },
	'resamplingkerneldenominators100' => { 139 => 0xe51 },
	'resaved' => { 417 => 0x21e },
	'resetblacksegrows' => { 139 => 0x181a },
	'resolution' => { 163 => 'Resolution' },
	'resolutionmode' => { 418 => [0x87,0x4] },
	'resolutionunit' => { 120 => 0x128, 135 => 0x2, 526 => 'ResolutionUnit' },
	'resourceid' => { 119 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 119 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 119 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 85 => 0x612 },
	'restrictions' => { 523 => 'restrictions' },
	'retouchareafeather' => { 501 => [\'RetouchAreas','RetouchAreasFeather'], 503 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 501 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 503 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 501 => [\'RetouchAreas','RetouchAreasMasksAngle'], 503 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 501 => [\'RetouchAreas','RetouchAreasMasksBottom'], 503 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 501 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 503 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 501 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 503 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 501 => [\'RetouchAreas','RetouchAreasMasksDabs'], 503 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 501 => [\'RetouchAreas','RetouchAreasMasksFeather'], 503 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 501 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 503 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 501 => [\'RetouchAreas','RetouchAreasMasksFlow'], 503 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 501 => [\'RetouchAreas','RetouchAreasMasksFullX'], 503 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 501 => [\'RetouchAreas','RetouchAreasMasksFullY'], 503 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 501 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 503 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 501 => [\'RetouchAreas','RetouchAreasMasksLeft'], 503 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasks'], 503 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 501 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 503 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 501 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 503 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 501 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 503 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 501 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 503 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 501 => [\'RetouchAreas','RetouchAreasMasksRadius'], 503 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 501 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 503 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 501 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 503 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 501 => [\'RetouchAreas','RetouchAreasMasksRight'], 503 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 501 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 503 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 501 => [\'RetouchAreas','RetouchAreasMasks'], 503 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 501 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 503 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 501 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 503 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 501 => [\'RetouchAreas','RetouchAreasMasksTop'], 503 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 501 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 503 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 501 => [\'RetouchAreas','RetouchAreasMasksVersion'], 503 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 501 => [\'RetouchAreas','RetouchAreasMasksWhat'], 503 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 501 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 503 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 501 => [\'RetouchAreas','RetouchAreasMasksX'], 503 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 501 => [\'RetouchAreas','RetouchAreasMasksY'], 503 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 501 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 503 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 501 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 503 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 501 => [\'RetouchAreas','RetouchAreasMethod'], 503 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 501 => [\'RetouchAreas','RetouchAreasOffsetY'], 503 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 501 => [\'RetouchAreas','RetouchAreasOpacity'], 503 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 501 => 'RetouchAreas', 503 => 'RetouchAreas' },
	'retouchareaseed' => { 501 => [\'RetouchAreas','RetouchAreasSeed'], 503 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 501 => [\'RetouchAreas','RetouchAreasSourceState'], 503 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 501 => [\'RetouchAreas','RetouchAreasSourceX'], 503 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 501 => [\'RetouchAreas','RetouchAreasSpotType'], 503 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 235 => 0x9e },
	'retouchinfo' => { 501 => 'RetouchInfo', 503 => 'RetouchInfo' },
	'retouchnefprocessing' => { 256 => 0x5 },
	'retractlensonpoweroff' => { 85 => 0x814 },
	'reuse' => { 328 => 'Reuse' },
	'reuseallowed' => { 533 => 'ReuseAllowed' },
	'reuseprohibited' => { 523 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 305 => '5.2' },
	'reversefocusring' => { 314 => 0x163, 315 => 0x163, 316 => 0x17b },
	'reverseindicators' => { 298 => '12.1', 299 => '6.1', 301 => '6.1', 302 => '6.1', 303 => '4.3', 304 => '5.2', 305 => '5.4', 307 => '33.5', 308 => '5.1', 311 => '6.1', 312 => '6.1', 313 => '6.2', 314 => 0xc1, 315 => 0xc1, 316 => 0xc1 },
	'reverseshutterspeedaperture' => { 305 => '5.3' },
	'revision' => { 505 => 'revision' },
	'rflensmffocusringsensitivity' => { 85 => 0x714 },
	'rflenstype' => { 58 => 0x3d },
	'rgbcurvelimits' => { 109 => 0x238 },
	'rgbcurvepoints' => { 108 => 0x7, 109 => 0x20e },
	'rgbtables' => { 120 => 0xcd3b },
	'richtextcomment' => { 510 => 'RichTextComment' },
	'ricohdate' => { 407 => 0x6 },
	'ricohimageheight' => { 407 => 0x2 },
	'ricohimagewidth' => { 407 => 0x0 },
	'rightalbedo' => { 492 => 'RightAlbedo' },
	'rightascension' => { 166 => 'RightAscension' },
	'rights' => { 504 => 'rights' },
	'rightsagent' => { 523 => 'rightsAgent' },
	'rightsowner' => { 523 => 'rightsOwner' },
	'roll' => { 116 => 0x8, 401 => ['roll',"\xa9frl"] },
	'rollangle' => { 128 => 0x144d, 248 => 0x0, 318 => 0x903, 341 => 0x90, 375 => 0x1, 413 => 0x2 },
	'romoperationmode' => { 98 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 97 => 0x3, 104 => 0x10002, 109 => 0x26e, 115 => 'QuickTime-Rotation', 124 => 0x4, 166 => 'Rotation', 183 => [0x65,0x50], 184 => 0x46, 185 => 0x5a, 188 => 0x10, 257 => 0x1a, 272 => 0x3693, 278 => '590.1', 291 => 0x76a43207, 341 => 0x30, 357 => '17.2', 387 => 0xd8, 394 => 'irot', 428 => 0x3f, 429 => 0x3f, 439 => 0x10 },
	'routedto' => { 509 => 'RoutedTo' },
	'routing' => { 392 => 'Routing' },
	'routingdestinations' => { 491 => 'RoutingDestinations' },
	'routingexclusions' => { 491 => 'RoutingExclusions' },
	'routingnotes' => { 509 => 'RoutingNotes' },
	'rowsperstrip' => { 120 => 0x116 },
	'rpp' => { 496 => 'rpp' },
	'rtkflag' => { 117 => 'RtkFlag' },
	'rtkstdhgt' => { 117 => 'RtkStdHgt' },
	'rtkstdlat' => { 117 => 'RtkStdLat' },
	'rtkstdlon' => { 117 => 'RtkStdLon' },
	'safetyshift' => { 85 => 0x108 },
	'safetyshiftinavortv' => { 83 => 0x10, 84 => 0x10, 86 => 0xf, 87 => 0x10, 90 => 0x10 },
	'sameexposurefornewaperture' => { 85 => 0x112 },
	'samplebits' => { 156 => 'SampleBits' },
	'samplepagerange' => { 520 => 'samplePageRange' },
	'samplerate' => { 156 => 'SampleRate' },
	'samplesperpixel' => { 120 => 0x115, 346 => 0x8, 526 => 'SamplesPerPixel' },
	'samplestructure' => { 134 => 0x5a },
	'samsungmodelid' => { 415 => 0x3 },
	'sanyoquality' => { 417 => 0x201 },
	'sanyothumbnail' => { 417 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 35 => 0xe, 52 => 0x1, 64 => 0x7, 113 => 0xd, 114 => [0x3013,0x1f], 120 => [0xa409,0xfe55], 128 => 0x1003, 157 => 'Saturation', 182 => 0x1f, 183 => 0x32, 184 => 0x28, 185 => 0x1a, 190 => 0x1, 235 => 0xaa, 250 => 0x35, 251 => 0x3b, 252 => 0x43, 341 => 0x40, 343 => 0x300d, 376 => 0x1f, 383 => 0xd, 402 => 0x27, 404 => 0x58, 407 => 0x28, 408 => 0x1013, 418 => 0x10, 428 => 0x1e, 429 => 0x1b, 441 => 0x2005, 501 => 'Saturation', 503 => 'Saturation', 507 => 'Saturation' },
	'saturationadj' => { 104 => 0x20901, 109 => 0x116, 235 => 0x94, 290 => 0x1, 294 => 0x2e, 477 => 0x8016 },
	'saturationadjustmentaqua' => { 501 => 'SaturationAdjustmentAqua', 503 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 501 => 'SaturationAdjustmentBlue', 503 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 501 => 'SaturationAdjustmentGreen', 503 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 501 => 'SaturationAdjustmentMagenta', 503 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 501 => 'SaturationAdjustmentOrange', 503 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 501 => 'SaturationAdjustmentPurple', 503 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 501 => 'SaturationAdjustmentRed', 503 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 501 => 'SaturationAdjustmentYellow', 503 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 72 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 71 => 0x68, 72 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 71 => 0x38, 72 => 0x38 },
	'saturationmonochrome' => { 71 => 0x80, 72 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 71 => 0x50, 72 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 71 => 0x20, 72 => 0x20 },
	'saturationsetting' => { 326 => 0x1010, 430 => 0x11, 446 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 71 => 0x8, 72 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 71 => 0x98, 72 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 71 => 0xb0, 72 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 71 => 0xc8, 72 => 0xe0 },
	'saveid' => { 531 => 'SaveID' },
	'sbaanalysiscomplete' => { 139 => 0xc35 },
	'sbablack' => { 139 => 0xc25 },
	'sbagmoffset' => { 139 => 0xc4a },
	'sbagray' => { 139 => 0xc26 },
	'sbagreenmagentabal' => { 139 => 0xc33 },
	'sbahighgray' => { 139 => 0xc46 },
	'sbailloffset' => { 139 => 0xc49 },
	'sbailluminantbal' => { 139 => 0xc34 },
	'sbalowgray' => { 139 => 0xc47 },
	'sbaneutralbal' => { 139 => 0xc32 },
	'sbawhite' => { 139 => 0xc27 },
	'scaletype' => { 530 => 'scaleType' },
	'scanimageenhancer' => { 258 => 0x60 },
	'scanningdirection' => { 134 => 0x64 },
	'scene' => { 401 => 'scen', 514 => 'Scene', 530 => 'scene' },
	'scenearea' => { 321 => 0x211, 323 => 0x1031 },
	'sceneassist' => { 235 => 0x9c },
	'scenecapturetype' => { 120 => 0xa406, 507 => 'SceneCaptureType' },
	'scenedetect' => { 321 => 0x210, 323 => 0x1030 },
	'scenedetectdata' => { 321 => 0x212, 323 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 143 => 0xfa02, 187 => 0x100, 235 => 0x8f, 318 => 0x509, 323 => 0x403, 341 => 0x8001, 350 => 0xf, 441 => 0xb023 },
	'scenemodeused' => { 145 => [0x6002,0xf002] },
	'scenerecognition' => { 128 => 0x1425 },
	'scenereferred' => { 511 => 'scene_referred' },
	'sceneselect' => { 417 => 0x21f },
	'scenetype' => { 120 => 0xa301, 507 => 'SceneType' },
	'screentips' => { 298 => '12.7', 299 => '5.3', 307 => '13.1', 308 => '4.4', 311 => '5.4', 313 => '5.1' },
	'scriptversion' => { 139 => 0x1770 },
	'sdrblend' => { 501 => 'SDRBlend', 503 => 'SDRBlend' },
	'sdrbrightness' => { 501 => 'SDRBrightness', 503 => 'SDRBrightness' },
	'sdrcontrast' => { 501 => 'SDRContrast', 503 => 'SDRContrast' },
	'sdrhighlights' => { 501 => 'SDRHighlights', 503 => 'SDRHighlights' },
	'sdrshadows' => { 501 => 'SDRShadows', 503 => 'SDRShadows' },
	'sdrwhites' => { 501 => 'SDRWhites', 503 => 'SDRWhites' },
	'season' => { 515 => 'Season', 519 => 'season' },
	'seasonidentifier' => { 515 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 515 => [\'Season','SeasonName'] },
	'seasonnumber' => { 515 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 491 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 240 => 0x240, 241 => 0x22c, 242 => 0x240, 243 => 0x240, 261 => 0x13c, 272 => 0x1d0 },
	'section' => { 520 => 'section' },
	'securityclassification' => { 120 => 0x9212 },
	'selectableafpoint' => { 85 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 85 => 0x512 },
	'selfdata' => { 117 => 'SelfData' },
	'selftimer' => { 35 => 0x2, 341 => 0x2e, 417 => 0x214, 450 => 0x1134, 451 => 0x1134, 452 => 0x1110, 453 => 0x118c, 454 => 0x1168, 455 => 0x1020, 456 => 0x218, 457 => 0x218, 458 => 0x210 },
	'selftimer2' => { 78 => 0x1d },
	'selftimerinterval' => { 308 => '19.2' },
	'selftimermode' => { 120 => 0x882b },
	'selftimershotcount' => { 299 => '20.2', 301 => '20.3', 302 => '20.3', 303 => '18.2', 304 => '19.2', 305 => '19.2', 306 => '19.3', 308 => '19.3', 311 => '20.3', 312 => '20.3', 313 => '20.2', 314 => 0x2d, 315 => 0x2d, 316 => 0x2d },
	'selftimershotinterval' => { 299 => '20.3', 301 => '20.2', 302 => '20.2', 306 => '19.2', 311 => '20.2', 312 => '20.2', 314 => 0x31, 315 => 0x31, 316 => 0x31 },
	'selftimertime' => { 98 => 0x1806, 185 => 0x1f, 298 => '18.1', 299 => '20.1', 300 => '3.3', 301 => '20.1', 302 => '20.1', 303 => '18.1', 304 => '19.1', 305 => '19.1', 306 => '19.1', 307 => '7.2', 308 => '19.1', 309 => '3.3', 311 => '20.1', 312 => '20.1', 313 => '20.1', 314 => 0x2b, 315 => 0x2b, 316 => 0x2b },
	'sellingagency' => { 520 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 120 => 0x8546 },
	'sensingmethod' => { 120 => 0xa217, 507 => 'SensingMethod' },
	'sensitivityadjust' => { 376 => 0x40 },
	'sensitivitysteps' => { 357 => ['14.3','17.4'], 359 => 0x1 },
	'sensitivitytype' => { 120 => 0x8830, 508 => 'SensitivityType' },
	'sensor' => { 192 => 0x665e },
	'sensorarea' => { 323 => 0x400 },
	'sensorareas' => { 415 => 0xa010 },
	'sensorbitdepth' => { 343 => 0x312d },
	'sensorbluelevel' => { 75 => 0x5 },
	'sensorcalibration' => { 322 => 0x805 },
	'sensorcleaning' => { 91 => 0xd },
	'sensorfullheight' => { 138 => 0xf904 },
	'sensorfullwidth' => { 138 => 0xf903 },
	'sensorheight' => { 138 => 0xf901, 143 => 0xfa21, 189 => 0x8, 343 => 0x312c, 385 => 0x109, 408 => 0x1602 },
	'sensorimageheight' => { 139 => 0x3ee },
	'sensorimagewidth' => { 139 => 0x3ed },
	'sensorleftborder' => { 139 => 0x3eb },
	'sensorleftmargin' => { 385 => 0x10a },
	'sensorpixelsize' => { 235 => 0x9a },
	'sensorredlevel' => { 75 => 0x4 },
	'sensorserialnumber' => { 139 => 0x9ce },
	'sensorshield' => { 240 => 0x76b, 241 => 0x66d, 242 => 0x69d, 243 => 0x705 },
	'sensorsize' => { 157 => 'SensorSize', 376 => 0x35 },
	'sensortemperature' => { 321 => 0x1500, 323 => 0x1007, 381 => 0xc, 385 => 0x210, 418 => [0x39,0x55] },
	'sensortemperature2' => { 381 => 0xe, 385 => 0x211 },
	'sensortopborder' => { 139 => 0x3ec },
	'sensortopmargin' => { 385 => 0x10b },
	'sensortype' => { 341 => 0xca },
	'sensorwidth' => { 138 => 0xf900, 143 => 0xfa20, 189 => 0xa, 343 => 0x312b, 385 => 0x108, 408 => 0x1601 },
	'sequence' => { 402 => 0x7, 403 => 0x35, 404 => 0x36 },
	'sequencefilenumber' => { 451 => 0x4, 452 => 0x4, 453 => 0x4, 454 => 0x4, 464 => 0xc, 465 => 0xc, 466 => 0x1a },
	'sequenceimagenumber' => { 451 => 0x0, 452 => 0x0, 453 => 0x0, 454 => 0x0, 464 => 0x8, 465 => 0x8, 466 => 0x12, 473 => 0x24 },
	'sequencelength' => { 464 => 0x22, 465 => 0x1e, 466 => [0x16,0x1e] },
	'sequencename' => { 519 => 'sequenceName' },
	'sequencenumber' => { 78 => 0x9, 114 => 0x301c, 128 => 0x1101, 141 => 0x1d, 279 => 0x51c, 341 => 0x2b, 430 => [0x10c,0x30c], 441 => 0xb04a, 519 => 'sequenceNumber' },
	'sequenceshotinterval' => { 417 => 0x224 },
	'sequencetotalnumber' => { 519 => 'sequenceTotalNumber' },
	'sequentialshot' => { 417 => 0x20e },
	'serialnumber' => { 65 => 0xc, 98 => 0x180b, 120 => [0xa431,0xfde9], 138 => 0xfa04, 140 => 0xfa00, 142 => 0xc354, 143 => 0xfa19, 154 => 0x0, 157 => 'SerialNumber', 192 => 0x5501, 235 => [0xa0,0x1d], 319 => 0x101, 323 => [0x404,0x101a], 336 => 0x303, 338 => 0x305, 343 => 0x3103, 376 => 0x229, 385 => 0x102, 386 => 0x407, 401 => ['SNum','slno'], 402 => 0x15, 403 => 0x4b, 404 => 0x7e, 408 => 0x5, 415 => 0xa002, 418 => 0x2, 441 => 0x2031, 498 => 'SerialNumber', 508 => 'BodySerialNumber' },
	'serialnumberformat' => { 65 => 0x15, 98 => 0x183b },
	'serialnumberhash' => { 401 => 'CAME' },
	'series' => { 515 => 'Series' },
	'seriesdatetime' => { 479 => 'SeriesDateTime' },
	'seriesdescription' => { 479 => 'SeriesDescription' },
	'seriesidentifier' => { 515 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 479 => 'SeriesModality' },
	'seriesname' => { 515 => [\'Series','SeriesName'] },
	'seriesnumber' => { 479 => 'SeriesNumber', 520 => 'seriesNumber' },
	'seriestitle' => { 520 => 'seriesTitle' },
	'serviceidentifier' => { 133 => 0x1e },
	'servingsize' => { 522 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 88 => 0x0, 89 => 0x0 },
	'setbuttonwhenshooting' => { 83 => 0x1, 85 => 0x704, 91 => 0xc },
	'setclockfromlocationdata' => { 241 => 0x61d, 242 => 0x64d, 243 => 0x6b5 },
	'setfunctionwhenshooting' => { 86 => 0x0, 87 => 0x1, 90 => 0x1 },
	'setting' => { 519 => 'setting' },
	'shadingcompensation' => { 318 => 0x50c, 341 => 0x8a },
	'shadingcompensation2' => { 322 => 0x1012 },
	'shadow' => { 418 => 0xe },
	'shadowadj' => { 104 => 0x2030b },
	'shadowcorrection' => { 376 => 0x79 },
	'shadowprotection' => { 290 => 0x0 },
	'shadows' => { 120 => 0xfe52, 441 => 0x2032, 495 => 'Shadows', 501 => 'Shadows', 503 => 'Shadows' },
	'shadows2012' => { 501 => 'Shadows2012', 503 => 'Shadows2012' },
	'shadowsadj' => { 477 => 0x901a },
	'shadowscale' => { 120 => 0xc633 },
	'shadowtint' => { 501 => 'ShadowTint', 503 => 'ShadowTint' },
	'shadowtone' => { 128 => 0x1040 },
	'shakereduction' => { 378 => 0x1, 379 => 0x1 },
	'shareduserrating' => { 180 => 'WM/SharedUserRating' },
	'sharpendetail' => { 501 => 'SharpenDetail', 503 => 'SharpenDetail' },
	'sharpenedgemasking' => { 501 => 'SharpenEdgeMasking', 503 => 'SharpenEdgeMasking' },
	'sharpening' => { 343 => 0x300b },
	'sharpeningadj' => { 294 => 0x2b },
	'sharpeningkernel' => { 139 => 0x92f },
	'sharpenradius' => { 501 => 'SharpenRadius', 503 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 35 => 0xf, 64 => 0x6, 75 => 0x2, 113 => 0xb, 114 => [0x3011,0x21], 120 => [0xa40a,0xfe56], 128 => 0x1001, 141 => 0x6b, 150 => 0x37, 157 => 'Sharpness', 182 => 0x21, 183 => 0x30, 184 => 0x26, 185 => 0x18, 190 => 0x3, 235 => 0x6, 250 => 0x32, 251 => 0x33, 252 => 0x39, 323 => 0x100f, 341 => 0x41, 376 => 0x21, 383 => 0xb, 402 => 0x26, 404 => 0x56, 407 => 0x22, 408 => [0x1003,0x1014], 418 => 0x11, 428 => 0x1c, 429 => 0x19, 441 => 0x2006, 473 => 0x52, 501 => 'Sharpness', 503 => 'Sharpness', 507 => 'Sharpness' },
	'sharpnessadj' => { 104 => 0x20310, 109 => 0x25a, 477 => 0x801a },
	'sharpnessadjon' => { 104 => '0x20310.0' },
	'sharpnessauto' => { 72 => 0x94 },
	'sharpnessfactor' => { 323 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 71 => 0x64, 72 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 75 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 71 => 0x34, 72 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 71 => 0x7c, 72 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 71 => 0x4c, 72 => 0x4c },
	'sharpnessovershoot' => { 477 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 71 => 0x1c, 72 => 0x1c },
	'sharpnessrange' => { 441 => 0x2035 },
	'sharpnesssetting' => { 318 => 0x506, 326 => 0x1013, 430 => 0x12, 446 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 71 => 0x4, 72 => 0x4 },
	'sharpnessstrength' => { 104 => 0x20311 },
	'sharpnessthreshold' => { 477 => 0x801d },
	'sharpnessundershoot' => { 477 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 71 => 0x94, 72 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 71 => 0xac, 72 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 71 => 0xc4, 72 => 0xdc },
	'shiftcols' => { 139 => 0xc70 },
	'shootid' => { 519 => 'shootID' },
	'shootingdistance' => { 104 => 0x20701 },
	'shootinginfodisplay' => { 298 => '13.2', 299 => '5.1', 307 => '10.2', 308 => '4.1', 311 => '5.1', 313 => '5.3' },
	'shootinginfomonitorofftime' => { 298 => '26.2', 299 => '22.2', 301 => '22.2', 302 => '22.2', 306 => '21.2', 307 => '9.1', 308 => '21.2', 311 => '22.2', 312 => '22.2', 313 => '22.2', 314 => 0x37, 315 => 0x37, 316 => 0x37 },
	'shootingmode' => { 157 => 'ShootingMode', 235 => 0x89, 341 => 0x1f },
	'shootingmodesetting' => { 300 => '5.1' },
	'shortdescription' => { 505 => 'shortdescription' },
	'shortdocumentid' => { 132 => 0xba },
	'shortname' => { 501 => 'ShortName', 503 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 85 => 0x80d },
	'shorttitle' => { 393 => '@sti' },
	'shotdate' => { 530 => 'shotDate' },
	'shotday' => { 530 => 'shotDay' },
	'shotlocation' => { 530 => 'shotLocation' },
	'shotlogdata' => { 484 => 'shot_log_data' },
	'shotname' => { 401 => 'shot', 530 => 'shotName' },
	'shotnumber' => { 530 => 'shotNumber' },
	'shotnumbersincepowerup' => { 445 => 0x44e, 464 => 0x1a, 465 => 0x16, 466 => 0xa },
	'shotnumbersincepowerup2' => { 430 => 0x200 },
	'shotsize' => { 530 => 'shotSize' },
	'shotsperinterval' => { 224 => 0x180, 239 => 0xb4, 240 => 0xcc, 241 => 0xc0, 242 => 0xd0, 243 => 0xd0 },
	'showmovement' => { 393 => 'shwm' },
	'shownevent' => { 515 => 'EventExt' },
	'showneventidentifier' => { 515 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 515 => [\'EventExt','EventExtName'] },
	'shutter' => { 460 => 0x20, 461 => 0x26, 462 => 0x26 },
	'shutter-aelock' => { 83 => 0x4, 85 => 0x701, 86 => 0x3, 87 => 0x4, 88 => 0x3, 89 => 0x3, 90 => 0x4, 91 => 0x2 },
	'shutteraelbutton' => { 84 => 0x4 },
	'shutterbuttonafonbutton' => { 85 => 0x701 },
	'shuttercount' => { 11 => 0x176, 32 => 0xaf1, 58 => 0x1, 235 => 0xa7, 263 => [0x6a,0x157,0x24d], 264 => 0x286, 265 => 0x279, 266 => 0x284, 267 => 0x242, 268 => 0x280, 269 => 0x276, 270 => [0x27d,0x27f], 271 => 0x246, 273 => 0x2d6, 274 => 0x321, 275 => 0xbd8, 276 => 0x287, 277 => 0x320, 278 => 0x24a, 279 => 0x5fb, 280 => 0x2d5, 376 => 0x5d, 439 => 0x846, 444 => [0x125,0x14a], 460 => 0x32, 461 => 0x3a, 462 => 0x3a, 463 => 0xa },
	'shuttercount2' => { 460 => 0x4c, 461 => [0x50,0x52,0x58], 462 => 0x50 },
	'shuttercount3' => { 460 => [0x1a0,0x1aa,0x1bd], 461 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 83 => 0xf, 84 => 0xf, 85 => 0x305, 86 => 0xe, 87 => 0xf, 88 => 0x8, 89 => 0x8, 90 => 0xf, 91 => 0x8 },
	'shuttermode' => { 58 => 0x17, 141 => 0x1b, 235 => 0x34 },
	'shutterreleasebuttonae-l' => { 298 => '17.7', 299 => '18.4', 301 => '78.4', 302 => '78.4', 303 => '16.1', 304 => '17.1', 305 => '17.1', 306 => '17.1', 307 => '7.1', 308 => '17.5', 311 => '18.4', 312 => '78.4', 313 => '18.2', 314 => 0x29, 315 => 0x29, 316 => 0x29 },
	'shutterreleasemethod' => { 98 => 0x1010 },
	'shutterreleasenocfcard' => { 83 => 0x2, 84 => 0x2, 91 => 0xf },
	'shutterreleasetiming' => { 98 => 0x1011 },
	'shutterreleasewithoutlens' => { 85 => 0x711 },
	'shutterspeedlock' => { 299 => '38.1', 301 => '38.1', 302 => '38.1', 311 => '38.1', 312 => '38.1', 314 => 0xb7, 315 => 0xb7, 316 => 0xb7 },
	'shutterspeedrange' => { 85 => 0x10c },
	'shutterspeedsetting' => { 185 => 0x6, 428 => 0x2f, 429 => 0x28, 430 => 0x0 },
	'shutterspeedvalue' => { 94 => 0x1, 120 => 0x9201, 323 => 0x1000, 385 => 0x400, 507 => 'ShutterSpeedValue' },
	'shuttertype' => { 128 => 0x1050, 341 => 0x9f, 376 => 0x87, 466 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 518 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 139 => 0xe0d },
	'sigmascalingfactorcamera' => { 139 => 0xe0c },
	'sigmascalingfactorlowres' => { 139 => 0xe0b },
	'sigmasizetable' => { 139 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 235 => 0xbf },
	'similarityindex' => { 132 => 0xe4 },
	'singleframebracketing' => { 185 => 0x21 },
	'skilllevel' => { 522 => 'skillLevel' },
	'skintonecorrection' => { 376 => 0x95 },
	'skiplinetime' => { 139 => 0x184e },
	'slaveflashmeteringsegments' => { 376 => 0x20b },
	'slideshowname' => { 519 => 'slideshowName' },
	'slideshownumber' => { 519 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 519 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 240 => 0x24a, 243 => 0x24a },
	'slowshutter' => { 78 => 0x8 },
	'slowsync' => { 128 => 0x1030 },
	'smartalbumcolor' => { 415 => 0x20 },
	'smartrange' => { 415 => 0xa012 },
	'smileshutter' => { 430 => 0x31 },
	'smileshuttermode' => { 430 => 0x27 },
	'smoothness' => { 120 => 0xfe57, 501 => 'Smoothness', 503 => 'Smoothness' },
	'snapshot' => { 515 => 'SnapshotLink' },
	'snapshotformat' => { 515 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 515 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 515 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 515 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 515 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 496 => 'Snapshots' },
	'snapshotusedvideoframe' => { 515 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 515 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 515 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 515 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 515 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 441 => 0x200f },
	'software' => { 120 => 0x131, 158 => 'Software', 331 => 'Software', 385 => 0x203, 395 => 'software', 418 => 0x18, 486 => 'Software', 526 => 'Software' },
	'softwareversion' => { 401 => ['@swr',"\xa9swr"], 417 => 0x207 },
	'soloist' => { 393 => "\xa9sol" },
	'songwriter' => { 401 => "\xa9swf" },
	'songwriterkeywords' => { 401 => "\xa9swk" },
	'sonycropsize' => { 120 => 0x74c8 },
	'sonycroptopleft' => { 120 => 0x74c7 },
	'sonydatetime' => { 449 => 0x6, 451 => 0x1b6, 452 => 0x210, 453 => 0x1fe, 454 => 0x22c },
	'sonydatetime2' => { 460 => 0x51 },
	'sonyexposuretime' => { 460 => 0x3a, 461 => 0x46, 462 => [0x66,0x46], 463 => 0x1a },
	'sonyexposuretime2' => { 473 => 0xe },
	'sonyfnumber' => { 460 => 0x3c, 461 => 0x48, 462 => [0x68,0x48], 463 => 0x1c, 473 => 0x14 },
	'sonyimageheight' => { 449 => 0x1a, 464 => 0x44, 465 => 0x3f, 466 => 0x47 },
	'sonyimageheightmax' => { 473 => 0x40 },
	'sonyimagesize' => { 185 => 0x3b, 428 => 0x54, 429 => 0x54, 430 => 0x9 },
	'sonyimagewidth' => { 449 => 0x1c },
	'sonyimagewidthmax' => { 473 => 0x3e },
	'sonyiso' => { 451 => 0x1218, 452 => 0x11f4, 453 => 0x1270, 454 => [0x1254,0x1258,0x1280], 455 => 0x113c, 456 => 0x344, 457 => 0x346, 458 => 0x320, 473 => 0x4 },
	'sonymaxaperture' => { 460 => 0x0, 461 => 0x0 },
	'sonymaxaperturevalue' => { 473 => 0x16 },
	'sonyminaperture' => { 460 => 0x1, 461 => 0x1 },
	'sonymodelid' => { 441 => 0xb001 },
	'sonyquality' => { 185 => 0x3c },
	'sonyrawimagesize' => { 120 => 0x7038 },
	'sonytimeminsec' => { 461 => 0x61 },
	'sortalbum' => { 393 => 'soal' },
	'sortalbumartist' => { 393 => 'soaa' },
	'sortartist' => { 393 => 'soar' },
	'sortcomposer' => { 393 => 'soco' },
	'sortname' => { 393 => 'sonm', 501 => 'SortName', 503 => 'SortName' },
	'sortshow' => { 393 => 'sosn' },
	'soundengineer' => { 393 => "\xa9sne" },
	'source' => { 132 => 0x73, 331 => 'Source', 504 => 'source', 505 => 'source', 518 => 'Source' },
	'sourcecount' => { 490 => 'SourceCount' },
	'sourcecredits' => { 401 => "\xa9src" },
	'sourcedirectoryindex' => { 363 => 0x0 },
	'sourcefileindex' => { 363 => 0x2 },
	'sourcephotoscount' => { 489 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 139 => 0x1390 },
	'spatialfrequencyresponse' => { 507 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 507 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 507 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 507 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 507 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 530 => 'speakerPlacement' },
	'specialeffectlevel' => { 114 => 0x3030 },
	'specialeffectmode' => { 114 => 0x2076 },
	'specialeffectsetting' => { 114 => 0x3031 },
	'specialinstructions' => { 132 => 0x28 },
	'specialmode' => { 323 => 0x200, 417 => 0x200 },
	'specialoccasion' => { 522 => 'specialOccasion' },
	'specialtypeid' => { 484 => 'SpecialTypeID' },
	'spectralsensitivity' => { 120 => 0x8824, 507 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => 0x32b, 43 => 0x281, 46 => [0x2b9,0x2d0,0x2d4], 47 => 0x56a, 48 => 0x1e4, 49 => [0x1fd,0x2dd], 50 => [0x231,0x30f], 51 => 0x31d },
	'speedx' => { 116 => 0x3, 401 => "\xa9xsp" },
	'speedy' => { 116 => 0x4, 401 => "\xa9ysp" },
	'speedz' => { 116 => 0x5, 401 => "\xa9zsp" },
	'spherical' => { 490 => 'Spherical' },
	'sphericalvideoxml' => { 121 => 'SphericalVideoXML' },
	'splitcolumn' => { 385 => 0x222 },
	'splittoningbalance' => { 501 => 'SplitToningBalance', 503 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 501 => 'SplitToningHighlightHue', 503 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 501 => 'SplitToningHighlightSaturation', 503 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 501 => 'SplitToningShadowHue', 503 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 501 => 'SplitToningShadowSaturation', 503 => 'SplitToningShadowSaturation' },
	'sport' => { 520 => 'sport' },
	'spotfocuspointx' => { 182 => 0x2d },
	'spotfocuspointy' => { 182 => 0x2e },
	'spotmeteringmode' => { 35 => 0x27 },
	'spotmeterlinktoafpoint' => { 85 => 0x107 },
	'sractive' => { 357 => '17.1' },
	'srawquality' => { 35 => 0x2e },
	'srfocallength' => { 378 => 0x3 },
	'srgbrendering' => { 329 => 'sRGB' },
	'srhalfpresstime' => { 378 => 0x2 },
	'srresult' => { 378 => 0x0, 379 => 0x0 },
	'stackedimage' => { 318 => 0x804 },
	'standardmatrixcustom' => { 139 => 0x7d4 },
	'standardmatrixdaylight' => { 139 => 0x7d0 },
	'standardmatrixflash' => { 139 => 0x7d3 },
	'standardmatrixfluorescent' => { 139 => 0x7d2 },
	'standardmatrixtungsten' => { 139 => 0x7d1 },
	'standardoutputhighlightpoint' => { 110 => 0x14 },
	'standardoutputsensitivity' => { 120 => 0x8831, 508 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 110 => 0x15 },
	'standardrawcolortone' => { 110 => 0xd },
	'standardrawcontrast' => { 110 => 0xf },
	'standardrawhighlight' => { 110 => 0x75 },
	'standardrawhighlightpoint' => { 110 => 0x12 },
	'standardrawlinear' => { 110 => 0x10 },
	'standardrawsaturation' => { 110 => 0xe },
	'standardrawshadow' => { 110 => 0x7e },
	'standardrawshadowpoint' => { 110 => 0x13 },
	'standardrawsharpness' => { 110 => 0x11 },
	'standardunsharpmaskfineness' => { 110 => 0x94 },
	'standardunsharpmaskstrength' => { 110 => 0x92 },
	'standardunsharpmaskthreshold' => { 110 => 0x96 },
	'standardwhitecustom' => { 139 => 0x838 },
	'standardwhitedaylight' => { 139 => 0x834 },
	'standardwhiteflash' => { 139 => 0x837 },
	'standardwhitefluorescent' => { 139 => 0x836 },
	'standardwhitetungsten' => { 139 => 0x835 },
	'standbytimer' => { 299 => '19.1', 301 => '19.1', 302 => '19.1', 305 => '18.1', 306 => '18.1', 311 => '19.1', 312 => '19.1' },
	'starlightview' => { 314 => 0x249, 315 => 0x249, 316 => 0x261 },
	'startingpage' => { 520 => 'startingPage' },
	'startmovieshooting' => { 85 => 0x70d },
	'starttimecode' => { 401 => "\xa9TIM", 530 => 'startTimecode' },
	'starttimecodetimeformat' => { 530 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 530 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 530 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 401 => "\xa9TSZ", 530 => 'startTimeSampleSize' },
	'starttimescale' => { 401 => "\xa9TSC", 530 => 'startTimeScale' },
	'state' => { 162 => 'State', 341 => 0x6b, 518 => 'State' },
	'status' => { 482 => 'Status', 494 => 'Status' },
	'stereomode' => { 490 => 'StereoMode' },
	'stitched' => { 490 => 'Stitched' },
	'stitchingsoftware' => { 489 => 'StitchingSoftware', 490 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 450 => 0x113e, 451 => 0x113e, 452 => 0x111a, 453 => 0x1196, 454 => 0x1172, 455 => 0x102a, 456 => 0x222, 457 => 0x222, 458 => 0x217, 473 => 0xa },
	'storagemethod' => { 189 => 0x12 },
	'storebyorientation' => { 299 => '46.3', 301 => '47.3', 302 => '47.3', 311 => '47.3', 312 => '47.3', 314 => 0xd, 315 => 0xd, 316 => 0xd },
	'storedescription' => { 393 => 'sdes' },
	'storylineidentifier' => { 515 => 'StorylineIdentifier' },
	'straightenangle' => { 291 => 0x2fc08431 },
	'streamready' => { 515 => 'StreamReady' },
	'streamtype' => { 177 => 'StreamType' },
	'stretchmode' => { 530 => 'stretchMode' },
	'studydatetime' => { 479 => 'StudyDateTime' },
	'studydescription' => { 479 => 'StudyDescription' },
	'studyid' => { 479 => 'StudyID' },
	'studyphysician' => { 479 => 'StudyPhysician' },
	'styleperiod' => { 515 => 'StylePeriod' },
	'sub-location' => { 132 => 0x5c },
	'subcommanddialplaybackmode' => { 314 => 0x1cf, 315 => 0x1cf, 316 => 0x1e7 },
	'subfiledata' => { 165 => 'data' },
	'subfiledirectory' => { 165 => '1Directory' },
	'subfilemimetype' => { 165 => '2MIME' },
	'subfilename' => { 165 => '1Name' },
	'subfileresource' => { 165 => 'rsrc' },
	'subfiletype' => { 120 => 0xfe, 165 => '0Type' },
	'subject' => { 327 => 'Subject', 392 => 'Subject', 504 => 'subject', 517 => 'Subject', 531 => 'subject' },
	'subjectarea' => { 120 => 0x9214, 507 => 'SubjectArea' },
	'subjectcode' => { 514 => 'SubjectCode' },
	'subjectdetection' => { 240 => 0x252, 241 => 0x23e, 242 => 0x252, 243 => 0x252 },
	'subjectdistance' => { 120 => 0x9206, 141 => 0x3e, 507 => 'SubjectDistance' },
	'subjectdistancerange' => { 120 => 0xa40c, 507 => 'SubjectDistanceRange' },
	'subjectlocation' => { 120 => 0xa214, 507 => 'SubjectLocation' },
	'subjectmotion' => { 301 => '78.2', 302 => '78.2', 312 => '78.2', 314 => 0x103, 315 => 0x103, 316 => 0x119 },
	'subjectprogram' => { 182 => 0x22 },
	'subjectreference' => { 132 => 0xc },
	'sublabels1' => { 513 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 513 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 115 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 115 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 115 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 120 => 0x9290 },
	'subsectimedigitized' => { 120 => 0x9292 },
	'subsectimeoriginal' => { 120 => 0x9291 },
	'subsection1' => { 520 => 'subsection1' },
	'subsection2' => { 520 => 'subsection2' },
	'subsection3' => { 520 => 'subsection3' },
	'subsection4' => { 520 => 'subsection4' },
	'subselector' => { 299 => '49.1', 301 => '71.1', 302 => '71.1', 312 => '71.1', 314 => 0x8f, 315 => 0x8f, 316 => 0x8f },
	'subselectorassignment' => { 299 => '48.1' },
	'subselectorcenter' => { 301 => '72.1', 302 => '72.1', 312 => '72.1' },
	'subselectorplusdials' => { 299 => '49.2', 301 => '73.1', 302 => '73.1', 312 => '73.1' },
	'subtitle' => { 180 => 'WM/SubTitle', 393 => "\xa9st3", 401 => "\xa9snm", 520 => 'subtitle' },
	'subtitlekeywords' => { 401 => "\xa9snk" },
	'subversionfilename' => { 513 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 513 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 513 => 'SubVersions' },
	'superimposeddisplay' => { 83 => 0xa, 85 => 0x510, 86 => 0x9, 87 => 0xa, 90 => 0xa, 91 => 0xe },
	'supermacro' => { 65 => 0x1a },
	'supplementalcategories' => { 132 => 0x14, 518 => 'SupplementalCategories' },
	'supplementaltype' => { 134 => 0x37 },
	'supplementdisplayid' => { 520 => 'supplementDisplayID' },
	'supplementstartingpage' => { 520 => 'supplementStartingPage' },
	'supplementtitle' => { 520 => 'supplementTitle' },
	'supplychainsource' => { 515 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 515 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 515 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 501 => 'SupportsAmount', 503 => 'SupportsAmount' },
	'supportscolor' => { 501 => 'SupportsColor', 503 => 'SupportsColor' },
	'supportshighdynamicrange' => { 501 => 'SupportsHighDynamicRange', 503 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 501 => 'SupportsMonochrome', 503 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 501 => 'SupportsNormalDynamicRange', 503 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 501 => 'SupportsOutputReferred', 503 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 501 => 'SupportsSceneReferred', 503 => 'SupportsSceneReferred' },
	'svisosetting' => { 357 => 0x14 },
	'swatchcoloranta' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 535 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 535 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 535 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 535 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 535 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 341 => 0x93, 430 => 0x33 },
	'sweeppanoramafieldofview' => { 341 => 0x94 },
	'sweeppanoramasize' => { 430 => 0x32 },
	'switchtoregisteredafpoint' => { 84 => 0x12, 85 => 0x50a },
	'symlink' => { 121 => 'SymLink' },
	'syncreleasemode' => { 301 => '77.1', 302 => '77.1', 312 => '77.1', 314 => 0x41, 315 => 0x41, 316 => 0x41 },
	'system' => { 385 => 0x204 },
	'tagged' => { 387 => 0xdd, 388 => 'Tagged', 496 => 'tagged' },
	'tagslist' => { 506 => 'TagsList' },
	'tagstructure' => { 513 => 'TagStructure' },
	'takenumber' => { 530 => 'takeNumber' },
	'tapename' => { 530 => 'tapeName' },
	'targetaperture' => { 78 => 0x4 },
	'targetcompressionratio' => { 96 => 0x1 },
	'targetdistancesetting' => { 98 => 0x1807 },
	'targetexposuretime' => { 78 => 0x5 },
	'targetimagetype' => { 98 => 0x100a },
	'targetprinter' => { 120 => 0x151 },
	'taxon' => { 119 => 'Taxon' },
	'taxonacceptednameusage' => { 119 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 119 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 119 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 119 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 119 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 119 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 119 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 119 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 119 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 119 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 119 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 119 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 119 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 119 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 119 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 119 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 119 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 119 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 119 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 119 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 119 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 119 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 119 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 119 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 119 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 119 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 119 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 119 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 119 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 119 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 119 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 119 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 119 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 119 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 139 => 0x196f },
	'tda1edgepolarity' => { 139 => 0x1971 },
	'tda1gain' => { 139 => 0x1970 },
	'tda1offset' => { 139 => 0x196e },
	'tda2bandwidth' => { 139 => 0x1979 },
	'tda2edgepolarity' => { 139 => 0x197b },
	'tda2gain' => { 139 => 0x197a },
	'tda2offset' => { 139 => 0x1978 },
	'tda3bandwidth' => { 139 => 0x1983 },
	'tda3edgepolarity' => { 139 => 0x1985 },
	'tda3gain' => { 139 => 0x1984 },
	'tda3offset' => { 139 => 0x1982 },
	'tda4bandwidth' => { 139 => 0x198d },
	'tda4edgepolarity' => { 139 => 0x198f },
	'tda4gain' => { 139 => 0x198e },
	'tda4offset' => { 139 => 0x198c },
	'teaser' => { 520 => 'teaser' },
	'teleconverter' => { 187 => 0x105, 441 => 0x105 },
	'tempampgainx100' => { 139 => 0x1914 },
	'tempo' => { 530 => 'tempo' },
	'temporalcoverage' => { 515 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 515 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 515 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 328 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 328 => 'TermsAndConditionsURL' },
	'testname' => { 121 => 'TestName' },
	'textencoding' => { 234 => 0x4 },
	'textlayername' => { 518 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 518 => 'TextLayers' },
	'textlayertext' => { 518 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 341 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 501 => 'Texture', 503 => 'Texture' },
	'three-dtrackingfacedetection' => { 301 => '1.4', 302 => '1.4', 312 => '1.4' },
	'three-dtrackingwatcharea' => { 301 => '78.1', 302 => '78.1', 312 => '78.1' },
	'thresholding' => { 120 => 0x107 },
	'thumbnailfilename' => { 98 => 0x817 },
	'thumbnailformat' => { 528 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 143 => 0xfa55, 528 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 98 => 0x2008, 115 => 'Exif-ThumbnailImage', 123 => 0x3, 168 => 'data', 323 => 0x100, 401 => 'thmb', 528 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 168 => '1Name' },
	'thumbnailimagesize' => { 168 => 'ImageSize' },
	'thumbnailimagetype' => { 168 => '0Type' },
	'thumbnailimagevalidarea' => { 65 => 0x13 },
	'thumbnaillength' => { 120 => 0x202 },
	'thumbnailoffset' => { 120 => 0x201 },
	'thumbnailpng' => { 401 => 'thmb' },
	'thumbnails' => { 528 => 'Thumbnails' },
	'thumbnailwidth' => { 143 => 0xfa54, 528 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 520 => 'ticker' },
	'tiffhandling' => { 501 => 'TIFFHandling', 503 => 'TIFFHandling' },
	'tiffmeteringimage' => { 188 => 0x104c, 439 => 0x1110 },
	'tilelength' => { 120 => 0x143 },
	'tilewidth' => { 120 => 0x142 },
	'time' => { 139 => 0x401, 376 => 0x7 },
	'timecodes' => { 120 => 0xc763 },
	'timecreated' => { 132 => 0x3c, 141 => 0x14, 150 => 0x10, 388 => 'TimeCreated' },
	'timelapseshotnumber' => { 344 => 0x10 },
	'timeperiod' => { 520 => 'timePeriod' },
	'timerfunctionbutton' => { 300 => '5.2', 303 => '12.1', 304 => '13.1' },
	'timerlength' => { 85 => 0x80c },
	'timerrecording' => { 341 => 0x96 },
	'timescaleparams' => { 530 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 530 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 530 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 530 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 133 => 0x50 },
	'timeshot' => { 491 => 'TimeShot' },
	'timesignature' => { 530 => 'timeSignature' },
	'timesincepoweron' => { 341 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 317 => 0x8, 331 => 'TimeStamp', 341 => 0xaf, 490 => 'Timestamp', 497 => 'Timestamp', 513 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 79 => 0x1, 240 => 0x694, 241 => 0x594, 242 => 0x5c4, 243 => 0x5dc, 283 => 0x0, 411 => 0xa },
	'timezonecity' => { 79 => 0x2 },
	'timezonecode' => { 101 => 0x1 },
	'timezoneinfo' => { 101 => 0x2 },
	'timezoneoffset' => { 120 => 0x882a },
	'tint' => { 395 => 'player.movie.visual.tint', 501 => 'Tint', 503 => 'Tint' },
	'title' => { 120 => 0xa436, 158 => 'Title', 327 => 'Title', 331 => 'Title', 341 => 0x65, 392 => 'Title', 393 => ['titl',"\xa9nam"], 395 => 'title', 401 => ['titl',"\xa9nam"], 504 => 'title', 517 => 'Title', 528 => 'Title' },
	'togglestyleamount' => { 501 => 'ToggleStyleAmount', 503 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 501 => 'ToggleStyleDigest', 503 => 'ToggleStyleDigest' },
	'tonecomp' => { 235 => 0x81 },
	'tonecurve' => { 75 => 0x1, 376 => 0x402, 501 => 'ToneCurve', 503 => 'ToneCurve' },
	'tonecurveactive' => { 109 => 0x110 },
	'tonecurveadobergb' => { 415 => 0xa043 },
	'tonecurveadobergbdefault' => { 415 => 0xa041 },
	'tonecurveblue' => { 501 => 'ToneCurveBlue', 503 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 477 => 0x9003 },
	'tonecurvebluey' => { 477 => 0x9007 },
	'tonecurvebrightness' => { 104 => 0x20410 },
	'tonecurvebrightnessx' => { 477 => 0x9000 },
	'tonecurvebrightnessy' => { 477 => 0x9004 },
	'tonecurvecolorspace' => { 108 => 0x0 },
	'tonecurvecontrast' => { 104 => 0x20411 },
	'tonecurvegreen' => { 501 => 'ToneCurveGreen', 503 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 477 => 0x9002 },
	'tonecurvegreeny' => { 477 => 0x9006 },
	'tonecurveinputrange' => { 108 => 0x3 },
	'tonecurveinterpolation' => { 109 => 0x159 },
	'tonecurvemode' => { 109 => 0x113 },
	'tonecurvename' => { 501 => 'ToneCurveName', 503 => 'ToneCurveName' },
	'tonecurvename2012' => { 501 => 'ToneCurveName2012', 503 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 104 => '0x20400.1' },
	'tonecurveoutputrange' => { 108 => 0x5 },
	'tonecurveprofilename' => { 139 => 0x1391 },
	'tonecurveproperty' => { 109 => 0x3c },
	'tonecurvepv2012' => { 501 => 'ToneCurvePV2012', 503 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 501 => 'ToneCurvePV2012Blue', 503 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 501 => 'ToneCurvePV2012Green', 503 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 501 => 'ToneCurvePV2012Red', 503 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 501 => 'ToneCurveRed', 503 => 'ToneCurveRed' },
	'tonecurveredx' => { 477 => 0x9001 },
	'tonecurveredy' => { 477 => 0x9005 },
	'tonecurves' => { 376 => 0x403 },
	'tonecurveshape' => { 108 => 0x1 },
	'tonecurvesrgb' => { 415 => 0xa042 },
	'tonecurvesrgbdefault' => { 415 => 0xa040 },
	'tonecurvex' => { 108 => 0xa },
	'tonecurvey' => { 108 => 0xb },
	'tonelevel' => { 318 => 0x52e },
	'tonemap' => { 240 => 0x26a },
	'tonemapstrength' => { 501 => 'ToneMapStrength', 503 => 'ToneMapStrength' },
	'toningeffect' => { 58 => 0xf, 235 => 0xb3, 250 => 0x38, 251 => 0x40, 252 => 0x48, 408 => 0x1015 },
	'toningeffectauto' => { 72 => 0xa4 },
	'toningeffectfaithful' => { 71 => 0x74, 72 => 0x74 },
	'toningeffectlandscape' => { 71 => 0x44, 72 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 71 => 0x8c, 72 => 0x8c },
	'toningeffectneutral' => { 71 => 0x5c, 72 => 0x5c },
	'toningeffectportrait' => { 71 => 0x2c, 72 => 0x2c },
	'toningeffectstandard' => { 71 => 0x14, 72 => 0x14 },
	'toningeffectuserdef1' => { 71 => 0xa4, 72 => 0xbc },
	'toningeffectuserdef2' => { 71 => 0xbc, 72 => 0xd4 },
	'toningeffectuserdef3' => { 71 => 0xd4, 72 => 0xec },
	'toningsaturation' => { 250 => 0x39, 251 => 0x41, 252 => 0x49 },
	'totalzoom' => { 141 => 0x62 },
	'touchae' => { 341 => 0xab },
	'track' => { 393 => "\xa9trk", 401 => "\xa9trk" },
	'trackcreatedate' => { 400 => 0x1 },
	'trackmodifydate' => { 400 => 0x2 },
	'tracknumber' => { 393 => 'trkn', 530 => 'trackNumber' },
	'tracks' => { 530 => 'Tracks' },
	'tracksframerate' => { 530 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 530 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 530 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 530 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 530 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 530 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 530 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 530 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 530 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 530 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 530 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 530 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 530 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 530 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 530 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 530 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 530 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 401 => 'kgtt' },
	'trailer' => { 121 => 'Trailer' },
	'trailersignature' => { 165 => 'zmie' },
	'transcript' => { 515 => 'Transcript' },
	'transcriptlink' => { 515 => 'TranscriptLink' },
	'transcriptlinklink' => { 515 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 515 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 120 => 0x12d, 526 => 'TransferFunction' },
	'transfertimenormal' => { 139 => 0x1888 },
	'transfertimetest' => { 139 => 0x1889 },
	'transform' => { 341 => [0x8012,0x59] },
	'transformation' => { 516 => 'Transformation' },
	'transmissionreference' => { 518 => 'TransmissionReference' },
	'trapped' => { 327 => 'Trapped', 517 => 'Trapped' },
	'trashbuttonfunction' => { 85 => 0x710 },
	'travelday' => { 341 => 0x36 },
	'treble' => { 395 => 'player.movie.audio.treble' },
	'triggermode' => { 402 => 0x6, 403 => 0x34, 404 => 0x34 },
	'tstop' => { 120 => 0xc772 },
	'ttl_da_adown' => { 364 => 0x5 },
	'ttl_da_aup' => { 364 => 0x4 },
	'ttl_da_bdown' => { 364 => 0x7 },
	'ttl_da_bup' => { 364 => 0x6 },
	'tungstenawb' => { 354 => 0x1 },
	'tvepisode' => { 393 => 'tves' },
	'tvepisodeid' => { 393 => 'tven' },
	'tvexposuretimesetting' => { 357 => 0x12 },
	'tvnetworkname' => { 393 => 'tvnn' },
	'tvseason' => { 393 => 'tvsn' },
	'tvshow' => { 393 => 'tvsh' },
	'type' => { 485 => 'Type', 504 => 'type', 525 => 'type' },
	'typestatus' => { 119 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 120 => 0xc614 },
	'uniquedocumentid' => { 132 => 0xbb },
	'uniquematrixauto' => { 139 => 0x7e9 },
	'uniquematrixcustom' => { 139 => 0x7e8 },
	'uniquematrixdaylight' => { 139 => 0x7e4 },
	'uniquematrixflash' => { 139 => 0x7e7 },
	'uniquematrixfluorescent' => { 139 => 0x7e6 },
	'uniquematrixtungsten' => { 139 => 0x7e5 },
	'uniqueobjectname' => { 133 => 0x64 },
	'units' => { 486 => 'Units' },
	'unknown_aacr' => { 393 => 'AACR' },
	'unknown_cdek' => { 393 => 'CDEK' },
	'unknown_cdet' => { 393 => 'CDET' },
	'unknownblock' => { 376 => 0x405 },
	'unknownblock1' => { 322 => 0x635 },
	'unknownblock2' => { 322 => 0x636 },
	'unknownblock3' => { 322 => 0x1103 },
	'unknownblock4' => { 322 => 0x1104 },
	'unknowncontrast' => { 110 => 0x45 },
	'unknowndate' => { 385 => 0x212 },
	'unknownev' => { 139 => 0x1 },
	'unknownlinear' => { 110 => 0x46 },
	'unknownnumber' => { 98 => 0x180b },
	'unknownoutputhighlightpoint' => { 110 => 0x4a },
	'unknownoutputshadowpoint' => { 110 => 0x4b },
	'unknownrawhighlight' => { 110 => 0x7b },
	'unknownrawhighlightpoint' => { 110 => 0x48 },
	'unknownrawshadow' => { 110 => 0x84 },
	'unknownrawshadowpoint' => { 110 => 0x49 },
	'unknownsharpness' => { 110 => 0x47 },
	'unknowntags' => { 401 => 'TAGS' },
	'unknowntemperature' => { 122 => 0x4 },
	'unknownthumbnail' => { 401 => 'thmb' },
	'unsharp1color' => { 296 => 0x13 },
	'unsharp1halowidth' => { 296 => 0x19 },
	'unsharp1intensity' => { 296 => 0x17 },
	'unsharp1threshold' => { 296 => 0x1b },
	'unsharp2color' => { 296 => 0x2e },
	'unsharp2halowidth' => { 296 => 0x34 },
	'unsharp2intensity' => { 296 => 0x32 },
	'unsharp2threshold' => { 296 => 0x36 },
	'unsharp3color' => { 296 => 0x49 },
	'unsharp3halowidth' => { 296 => 0x4f },
	'unsharp3intensity' => { 296 => 0x4d },
	'unsharp3threshold' => { 296 => 0x51 },
	'unsharp4color' => { 296 => 0x64 },
	'unsharp4halowidth' => { 296 => 0x6a },
	'unsharp4intensity' => { 296 => 0x68 },
	'unsharp4threshold' => { 296 => 0x6c },
	'unsharpcount' => { 296 => 0x0 },
	'unsharpmask' => { 110 => 0x90, 291 => 0x76a43200 },
	'unsharpmaskfineness' => { 104 => 0x20309 },
	'unsharpmaskstrength' => { 104 => 0x20308 },
	'unsharpmaskthreshold' => { 104 => 0x2030a },
	'uprightcentermode' => { 501 => 'UprightCenterMode', 503 => 'UprightCenterMode' },
	'uprightcenternormx' => { 501 => 'UprightCenterNormX', 503 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 501 => 'UprightCenterNormY', 503 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 501 => 'UprightDependentDigest', 503 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 501 => 'UprightFocalLength35mm', 503 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 501 => 'UprightFocalMode', 503 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 501 => 'UprightFourSegments_0', 503 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 501 => 'UprightFourSegments_1', 503 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 501 => 'UprightFourSegments_2', 503 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 501 => 'UprightFourSegments_3', 503 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 501 => 'UprightFourSegmentsCount', 503 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 501 => 'UprightGuidedDependentDigest', 503 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 501 => 'UprightPreview', 503 => 'UprightPreview' },
	'uprighttransform_0' => { 501 => 'UprightTransform_0', 503 => 'UprightTransform_0' },
	'uprighttransform_1' => { 501 => 'UprightTransform_1', 503 => 'UprightTransform_1' },
	'uprighttransform_2' => { 501 => 'UprightTransform_2', 503 => 'UprightTransform_2' },
	'uprighttransform_3' => { 501 => 'UprightTransform_3', 503 => 'UprightTransform_3' },
	'uprighttransform_4' => { 501 => 'UprightTransform_4', 503 => 'UprightTransform_4' },
	'uprighttransform_5' => { 501 => 'UprightTransform_5', 503 => 'UprightTransform_5' },
	'uprighttransformcount' => { 501 => 'UprightTransformCount', 503 => 'UprightTransformCount' },
	'uprightversion' => { 501 => 'UprightVersion', 503 => 'UprightVersion' },
	'urgency' => { 132 => 0xa, 518 => 'Urgency' },
	'url' => { 158 => 'URL', 331 => 'URL', 390 => 0x40b, 520 => 'url' },
	'url_list' => { 390 => 0x41e },
	'urla-platform' => { 520 => [\'url','urlA-platform'] },
	'urlurl' => { 520 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 85 => 0x10a },
	'usableshootingmodes' => { 85 => 0x109 },
	'usage' => { 521 => 'usage' },
	'usageterms' => { 534 => 'UsageTerms' },
	'usbpowerdelivery' => { 240 => 0x762, 241 => 0x664, 242 => 0x694, 243 => 0x6fc },
	'usedialwithouthold' => { 314 => 0xbf, 315 => 0xbf, 316 => 0xbf },
	'useguidelines' => { 499 => 'useGuidelines' },
	'usepanoramaviewer' => { 489 => 'UsePanoramaViewer' },
	'usercollection' => { 395 => 'collection.user' },
	'usercomment' => { 98 => 0x805, 120 => 0x9286, 507 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 71 => 0xd8, 72 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 71 => 0xda, 72 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 71 => 0xdc, 72 => 0xf4 },
	'userfields' => { 494 => 'UserFields' },
	'userlabel' => { 402 => 0x2b, 403 => 0x5a, 404 => 0x68 },
	'userprofile' => { 336 => 0x302, 340 => 0x34c, 343 => 0x3038 },
	'userrating' => { 395 => 'rating.user', 401 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 84 => 0x7, 85 => 0x501 },
	'uspsnumber' => { 520 => 'uspsNumber' },
	'utmeasting' => { 169 => 'Easting' },
	'utmmapdatum' => { 169 => 'Datum' },
	'utmnorthing' => { 169 => 'Northing' },
	'utmzone' => { 169 => 'Zone' },
	'uuid' => { 501 => 'UUID', 503 => 'UUID' },
	'uv-irfiltercorrection' => { 336 => 0x325 },
	'validbits' => { 322 => 0x611, 323 => 0x102c },
	'validpixeldepth' => { 326 => 0x611 },
	'variablelowpassfilter' => { 441 => 0x2028 },
	'variousmodes' => { 141 => 0x26 },
	'variousmodes2' => { 141 => 0x3a },
	'variprogram' => { 235 => 0xab },
	'varraydacnominalvalues' => { 139 => 0x191e },
	'vendor' => { 401 => 'vndr' },
	'vendorinfo' => { 480 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 480 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 480 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 480 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 119 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 128 => 0x0, 392 => 'Version', 395 => 'version', 501 => 'Version', 503 => 'Version', 512 => 'Version' },
	'versioncreatedate' => { 477 => 0xd100 },
	'versionid' => { 531 => 'VersionID' },
	'versionidentifier' => { 520 => 'versionIdentifier' },
	'versionmodifydate' => { 477 => 0xd101 },
	'versions' => { 531 => 'Versions' },
	'versionscomments' => { 531 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 531 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 531 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 531 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 531 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 531 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 531 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 531 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 531 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 531 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 531 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 298 => '3.2', 299 => '47.2', 301 => '79.1', 315 => 0x11d, 316 => 0x135 },
	'verticalclockoverlaps' => { 139 => 0x412 },
	'verticalfuncbutton' => { 299 => '42.2', 301 => '67.1', 315 => 0x115, 316 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 315 => 0x1b7, 316 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 299 => '43.1' },
	'verticalfuncplusdials' => { 301 => '68.1' },
	'verticalisobutton' => { 243 => 0x792 },
	'verticalmovieafonbutton' => { 315 => 0x1f9, 316 => 0x211 },
	'verticalmoviefuncbutton' => { 315 => 0x1e1, 316 => 0x1f9 },
	'verticalmultiselector' => { 299 => '42.1', 301 => '66.1', 302 => '66.1', 312 => '66.1', 315 => 0x18f, 316 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 315 => 0x125, 316 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 85 => [0x510,0x51d] },
	'vibrance' => { 495 => 'Vibrance', 501 => 'Vibrance', 503 => 'Vibrance' },
	'vibrationreduction' => { 263 => [0x75,0x82,0x1ae], 271 => '586.1', 278 => '590.2', 282 => 0x4 },
	'videoalphamode' => { 530 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 530 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 530 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 530 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 515 => 'videoBitRate' },
	'videobitratemode' => { 515 => 'videoBitRateMode' },
	'videoburstmode' => { 341 => 0xbb },
	'videoburstresolution' => { 341 => 0xb3 },
	'videocodec' => { 68 => 0x74 },
	'videocolorspace' => { 530 => 'videoColorSpace' },
	'videocompression' => { 128 => 0x3806 },
	'videocompressor' => { 530 => 'videoCompressor' },
	'videodisplayaspectratio' => { 515 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 515 => 'videoEncodingProfile' },
	'videofieldorder' => { 530 => 'videoFieldOrder' },
	'videoframerate' => { 341 => 0x27, 530 => 'videoFrameRate' },
	'videoframesize' => { 530 => 'videoFrameSize' },
	'videoframesizeh' => { 530 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 530 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 530 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 530 => 'videoModDate' },
	'videopixelaspectratio' => { 530 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 530 => 'videoPixelDepth' },
	'videopreburst' => { 341 => 0xc1 },
	'videoquality' => { 114 => 0x4003 },
	'videorecordingmode' => { 128 => 0x3803 },
	'videoshottype' => { 515 => 'VideoShotType' },
	'videoshottypeidentifier' => { 515 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 515 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 515 => 'videoStreamsCount' },
	'viewfinder' => { 385 => 0x455 },
	'viewfinderdisplay' => { 298 => '12.4', 299 => '6.3' },
	'viewfinderwarning' => { 298 => '13.4', 308 => '3.5', 309 => '6.2', 313 => '4.4' },
	'viewfinderwarnings' => { 85 => 0x40a },
	'viewinfoduringexposure' => { 85 => 0x407 },
	'viewingmode' => { 430 => 0x2f, 446 => 0x18 },
	'viewingmode2' => { 430 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 243 => 0x7d2, 314 => 0x2a9 },
	'viewpoint' => { 519 => 'viewpoint' },
	'vignetteamount' => { 501 => 'VignetteAmount', 503 => 'VignetteAmount' },
	'vignettecontrol' => { 235 => 0x2a, 291 => 0x76a43205 },
	'vignettecontrolintensity' => { 291 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 498 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 501 => 'VignetteMidpoint', 503 => 'VignetteMidpoint' },
	'vignetting' => { 408 => 0x1011, 415 => 0xa052 },
	'vignettingcorrection' => { 120 => 0x7031, 415 => 0xa053, 441 => 0x2011 },
	'vignettingcorrparams' => { 120 => 0x7032, 472 => 0x64a, 473 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 415 => 0xa054 },
	'virtualfocallength' => { 516 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 314 => 0x167, 315 => 0x167, 316 => 0x17f },
	'virtualimagexcenter' => { 516 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 516 => 'VirtualImageYCenter' },
	'visualcolor' => { 515 => 'VisualColour' },
	'visualtechnique' => { 519 => 'visualTechnique' },
	'voicememo' => { 417 => 0x216 },
	'volume' => { 520 => 'volume' },
	'vr_0x66' => { 263 => 0x66 },
	'vrdoffset' => { 65 => 0xd0 },
	'vrmode' => { 240 => 0x226, 241 => 0x212, 242 => 0x226, 243 => 0x226, 282 => 0x6 },
	'vrtype' => { 282 => 0x8 },
	'waterdepth' => { 120 => 0x9403, 508 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 188 => 0x19a },
	'wb_bluelevel6500k' => { 188 => 0x18a },
	'wb_bluelevelcustom' => { 188 => 0x18e },
	'wb_bluelevelscloudy' => { 188 => 0x106 },
	'wb_bluelevelsdaylight' => { 188 => 0xea },
	'wb_bluelevelsflash' => { 188 => 0x122 },
	'wb_bluelevelsfluorescent' => { 188 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 188 => 0x254 },
	'wb_bluelevelsshade' => { 188 => 0x176 },
	'wb_bluelevelstungsten' => { 188 => 0xce },
	'wb_gbrglevels' => { 188 => 0xae, 191 => 0x4 },
	'wb_glevel' => { 322 => 0x11f },
	'wb_glevel3000k' => { 322 => 0x113 },
	'wb_glevel3300k' => { 322 => 0x114 },
	'wb_glevel3600k' => { 322 => 0x115 },
	'wb_glevel3900k' => { 322 => 0x116 },
	'wb_glevel4000k' => { 322 => 0x117 },
	'wb_glevel4300k' => { 322 => 0x118 },
	'wb_glevel4500k' => { 322 => 0x119 },
	'wb_glevel4800k' => { 322 => 0x11a },
	'wb_glevel5300k' => { 322 => 0x11b },
	'wb_glevel6000k' => { 322 => 0x11c },
	'wb_glevel6600k' => { 322 => 0x11d },
	'wb_glevel7500k' => { 322 => 0x11e },
	'wb_grbglevels' => { 205 => 0x0, 448 => 0x7303 },
	'wb_grbglevelsauto' => { 82 => 0x2, 448 => 0x7302 },
	'wb_grbglevelscloudy' => { 82 => 0x12 },
	'wb_grbglevelscustom1' => { 82 => 0x42 },
	'wb_grbglevelscustom2' => { 82 => 0x4a },
	'wb_grbglevelsdaylight' => { 82 => 0xa },
	'wb_grbglevelsflash' => { 82 => 0x32 },
	'wb_grbglevelsfluorescent' => { 82 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 82 => 0x2a },
	'wb_grbglevelstungsten' => { 82 => 0x1a },
	'wb_grbglevelsunderwater' => { 82 => 0x3a },
	'wb_rbgglevels' => { 202 => 0x0 },
	'wb_rblevels' => { 206 => 0x270, 235 => 0xc, 322 => 0x100 },
	'wb_rblevels1' => { 347 => 0x2 },
	'wb_rblevels2' => { 347 => 0x5 },
	'wb_rblevels3' => { 347 => 0x8 },
	'wb_rblevels3000k' => { 322 => 0x102 },
	'wb_rblevels3300k' => { 322 => 0x103 },
	'wb_rblevels3500k' => { 188 => 0x430 },
	'wb_rblevels3600k' => { 322 => 0x104 },
	'wb_rblevels3900k' => { 322 => 0x105 },
	'wb_rblevels4' => { 347 => 0xb },
	'wb_rblevels4000k' => { 322 => 0x106 },
	'wb_rblevels4300k' => { 322 => 0x107 },
	'wb_rblevels4500k' => { 322 => 0x108 },
	'wb_rblevels4800k' => { 322 => 0x109 },
	'wb_rblevels5' => { 347 => 0xe },
	'wb_rblevels5300k' => { 322 => 0x10a },
	'wb_rblevels6' => { 347 => 0x11 },
	'wb_rblevels6000k' => { 322 => 0x10b },
	'wb_rblevels6500k' => { 188 => 0x420 },
	'wb_rblevels6600k' => { 322 => 0x10c },
	'wb_rblevels7' => { 347 => 0x14 },
	'wb_rblevels7500k' => { 322 => 0x10d },
	'wb_rblevelsauto' => { 206 => 0x272, 326 => 0x110 },
	'wb_rblevelscloudy' => { 188 => 0x3f0, 190 => 0x10, 206 => 0x296, 326 => 0x121 },
	'wb_rblevelscoolwhitef' => { 188 => 0x308, 190 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 326 => 0x132 },
	'wb_rblevelscustom' => { 188 => 0x424, 190 => 0x1c },
	'wb_rblevelscwb1' => { 322 => 0x10e },
	'wb_rblevelscwb2' => { 322 => 0x10f },
	'wb_rblevelscwb3' => { 322 => 0x110 },
	'wb_rblevelscwb4' => { 322 => 0x111 },
	'wb_rblevelsdaylight' => { 188 => [0x3ec,0x528], 190 => 0xc, 206 => 0x274 },
	'wb_rblevelsdaylightf' => { 190 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 326 => 0x130 },
	'wb_rblevelsdaywhitef' => { 190 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 326 => 0x131 },
	'wb_rblevelseveningsunlight' => { 326 => 0x124 },
	'wb_rblevelsfineweather' => { 326 => 0x122 },
	'wb_rblevelsflash' => { 188 => [0x3f4,0x304], 190 => 0x18, 206 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 206 => 0x290 },
	'wb_rblevelsincandescent' => { 206 => 0x282 },
	'wb_rblevelsshade' => { 188 => 0x418, 190 => 0x20, 206 => 0x2b2, 326 => 0x120 },
	'wb_rblevelstungsten' => { 188 => 0x3e8, 190 => 0x8, 326 => 0x123 },
	'wb_rblevelsused' => { 326 => 0x100 },
	'wb_rblevelswhitef' => { 190 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 326 => 0x133 },
	'wb_redlevel3500k' => { 188 => 0x198 },
	'wb_redlevel6500k' => { 188 => 0x188 },
	'wb_redlevelcustom' => { 188 => 0x18c },
	'wb_redlevelscloudy' => { 188 => 0xf8 },
	'wb_redlevelsdaylight' => { 188 => 0xdc },
	'wb_redlevelsflash' => { 188 => 0x114 },
	'wb_redlevelsfluorescent' => { 188 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 188 => 0x1be },
	'wb_redlevelsshade' => { 188 => 0x168 },
	'wb_redlevelstungsten' => { 188 => 0xc0 },
	'wb_rgbglevels' => { 204 => 0x0 },
	'wb_rgblevels' => { 188 => [0x546,0x96], 337 => 0xd, 338 => 0x413, 343 => 0x3036, 385 => 0x107, 450 => 0x117c, 451 => 0x1180, 452 => 0x115c, 453 => 0x11d8, 454 => 0x11b4, 455 => 0x106c, 456 => 0x264, 457 => 0x264, 458 => 0x252 },
	'wb_rgblevels1' => { 348 => 0x2 },
	'wb_rgblevels2' => { 348 => 0x6 },
	'wb_rgblevels2500k' => { 448 => 0x782d },
	'wb_rgblevels3' => { 348 => 0xa },
	'wb_rgblevels3200k' => { 448 => 0x782c },
	'wb_rgblevels4' => { 348 => 0xe },
	'wb_rgblevels4500k' => { 448 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 348 => 0x12 },
	'wb_rgblevels6' => { 348 => 0x16 },
	'wb_rgblevels6000k' => { 448 => 0x782b },
	'wb_rgblevels7' => { 348 => 0x1a },
	'wb_rgblevels8500k' => { 448 => 0x782a },
	'wb_rgblevelsauto' => { 419 => 0x0 },
	'wb_rgblevelscloudy' => { 448 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 419 => 0x15 },
	'wb_rgblevelscustom2' => { 419 => 0x18 },
	'wb_rgblevelscustom3' => { 419 => 0x1b },
	'wb_rgblevelsdaylight' => { 419 => 0x3, 448 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 419 => 0x12, 448 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 419 => 0xf, 448 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 448 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 448 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 448 => 0x7828 },
	'wb_rgblevelsincandescent' => { 419 => 0xc },
	'wb_rgblevelsovercast' => { 419 => 0x9 },
	'wb_rgblevelsshade' => { 419 => 0x6, 448 => 0x7825 },
	'wb_rgblevelstungsten' => { 448 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 420 => 0x0 },
	'wb_rgblevelsunknown1' => { 420 => 0x3 },
	'wb_rgblevelsunknown2' => { 420 => 0x6 },
	'wb_rgblevelsunknown3' => { 420 => 0x9 },
	'wb_rgblevelsunknown4' => { 420 => 0xc },
	'wb_rgblevelsunknown5' => { 420 => 0xf },
	'wb_rgblevelsunknown6' => { 420 => 0x12 },
	'wb_rgblevelsunknown7' => { 420 => 0x15 },
	'wb_rgblevelsunknown8' => { 420 => 0x18 },
	'wb_rgblevelsunknown9' => { 420 => 0x1b },
	'wb_rgbmuldaylight' => { 139 => 0x852 },
	'wb_rgbmulflash' => { 139 => 0x855 },
	'wb_rgbmulfluorescent' => { 139 => 0x854 },
	'wb_rgbmultungsten' => { 139 => 0x853 },
	'wb_rggbblacklevels' => { 36 => 0x25 },
	'wb_rggblevels' => { 120 => 0x7313, 191 => 0x4, 203 => 0x0, 207 => 0x13e8, 208 => 0x38, 448 => 0x7313 },
	'wb_rggblevelsasshot' => { 39 => 0x0, 40 => 0x0, 41 => 0x19, 42 => 0x55, 43 => 0x69, 44 => 0x22, 45 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x3f, 51 => 0x47 },
	'wb_rggblevelsauto' => { 36 => 0x1, 39 => 0x5, 40 => 0x8, 41 => 0x1e, 42 => 0x5a, 43 => 0x6e, 44 => 0x18, 45 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x44, 51 => 0x4c, 207 => 0x1478, 208 => 0x114, 415 => 0xa022, 448 => 0x7312 },
	'wb_rggblevelsblack' => { 415 => 0xa028 },
	'wb_rggblevelscloudy' => { 36 => 0xd, 39 => 0x1e, 40 => 0x30, 41 => 0x2d, 42 => 0xa0, 43 => 0xd7, 44 => 0x31, 45 => 0x58, 48 => 0x71, 49 => 0x8a, 50 => 0x8f, 51 => 0x92, 207 => 0x1408, 208 => 0x60, 376 => 0x20f, 384 => 0x14 },
	'wb_rggblevelscustom' => { 36 => 0x1d, 45 => 0x80, 207 => 0x1468, 208 => 0x100 },
	'wb_rggblevelscustom1' => { 41 => 0x41 },
	'wb_rggblevelscustom2' => { 41 => 0x46 },
	'wb_rggblevelsdaylight' => { 36 => 0x5, 39 => 0x14, 40 => 0x20, 41 => 0x23, 42 => 0x96, 43 => 0xcd, 44 => 0x27, 45 => 0x4e, 48 => 0x67, 49 => 0x80, 50 => 0x85, 51 => 0x88, 207 => 0x13f8, 208 => 0x4c, 376 => 0x20d, 384 => 0x2 },
	'wb_rggblevelsflash' => { 36 => 0x19, 39 => 0x32, 40 => 0x50, 41 => 0x3c, 42 => 0xb4, 43 => 0xeb, 44 => 0x45, 45 => 0x6c, 48 => 0x85, 49 => 0x9e, 50 => 0xa3, 51 => 0xa6, 207 => 0x1448, 376 => 0x214, 384 => 0x41 },
	'wb_rggblevelsfluorescent' => { 36 => 0x15, 39 => 0x28, 40 => 0x40, 41 => 0x37, 42 => 0xaa, 43 => 0xe1, 44 => 0x3b, 45 => 0x62, 48 => 0x7b, 49 => 0x94, 50 => 0x99, 51 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 208 => 0xc4, 376 => 0x211, 384 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 384 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 208 => 0xb0, 376 => 0x212, 384 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 207 => 0x1438, 208 => 0x9c, 376 => 0x213, 384 => 0x38 },
	'wb_rggblevelshtmercury' => { 208 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 415 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 415 => 0xa024 },
	'wb_rggblevelskelvin' => { 36 => 0x21, 39 => 0x2d, 40 => 0x48, 42 => 0xaf, 43 => 0xe6, 44 => 0x40, 45 => 0x67, 48 => 0x80, 49 => 0x99, 50 => 0x9e, 51 => 0xa1 },
	'wb_rggblevelsmeasured' => { 39 => 0xa, 40 => 0x10, 42 => 0x5f, 43 => 0x73, 45 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x49, 51 => 0x51 },
	'wb_rggblevelspc1' => { 44 => 0x90, 45 => 0x71 },
	'wb_rggblevelspc2' => { 44 => 0x95, 45 => 0x76 },
	'wb_rggblevelspc3' => { 44 => 0x9a, 45 => 0x7b },
	'wb_rggblevelsshade' => { 36 => 0x9, 39 => 0x19, 40 => 0x28, 41 => 0x28, 42 => 0x9b, 43 => 0xd2, 44 => 0x2c, 45 => 0x53, 48 => 0x6c, 49 => 0x85, 50 => 0x8a, 51 => 0x8d, 208 => 0x74, 376 => 0x20e, 384 => 0xb },
	'wb_rggblevelstungsten' => { 36 => 0x11, 39 => 0x23, 40 => 0x38, 41 => 0x32, 42 => 0xa5, 43 => 0xdc, 44 => 0x36, 45 => 0x5d, 48 => 0x76, 49 => 0x8f, 50 => 0x94, 51 => 0x97, 207 => 0x1428, 208 => 0x88, 376 => 0x210, 384 => 0x1d },
	'wb_rggblevelsuncorrected' => { 415 => 0xa021 },
	'wb_rggblevelsunknown' => { 39 => 0xf, 40 => 0x18, 42 => 0x64, 43 => 0x78, 44 => 0x1d, 48 => 0x4e, 49 => 0x4e, 50 => 0x4e, 51 => 0x56, 384 => 0x53 },
	'wb_rggblevelsunknown10' => { 39 => 0x5f, 40 => 0x98, 42 => 0x91, 43 => 0xa5, 44 => 0x72, 48 => 0x9e, 49 => 0x7b, 50 => 0x7b, 51 => 0x83 },
	'wb_rggblevelsunknown11' => { 39 => 0x64, 40 => 0xa0, 42 => 0xb9, 43 => [0xaa,0xaf], 44 => 0x77, 48 => 0xa3, 49 => 0xa3, 50 => 0x80, 51 => 0xab },
	'wb_rggblevelsunknown12' => { 39 => 0x69, 40 => 0xa8, 42 => 0xbe, 43 => 0xb4, 44 => 0x7c, 48 => 0xa8, 49 => 0xa8, 50 => 0xa8, 51 => 0xb0 },
	'wb_rggblevelsunknown13' => { 39 => 0x6e, 40 => 0xb0, 42 => 0xc3, 43 => 0xb9, 44 => 0x81, 48 => 0xad, 49 => 0xad, 50 => 0xad, 51 => 0xb5 },
	'wb_rggblevelsunknown14' => { 42 => 0xc8, 43 => 0xbe, 44 => 0x86, 48 => 0xb2, 49 => 0xb2, 50 => 0xb2, 51 => 0xba },
	'wb_rggblevelsunknown15' => { 42 => 0xcd, 43 => 0xc3, 44 => 0x8b, 48 => 0xb7, 49 => 0xb7, 50 => 0xb7, 51 => 0xbf },
	'wb_rggblevelsunknown16' => { 42 => 0xd2, 43 => 0xc8, 44 => 0x9f, 49 => 0xbc, 50 => 0xbc, 51 => 0xc4 },
	'wb_rggblevelsunknown17' => { 42 => 0xd7, 43 => 0xf0, 49 => 0xc1, 50 => 0xc1, 51 => 0xc9 },
	'wb_rggblevelsunknown18' => { 42 => 0xdc, 43 => 0xf5, 49 => 0xc6, 50 => 0xc6, 51 => 0xce },
	'wb_rggblevelsunknown19' => { 42 => 0xe1, 43 => 0xfa, 49 => 0xcb, 50 => 0xcb, 51 => 0xd3 },
	'wb_rggblevelsunknown2' => { 39 => 0x37, 40 => 0x58, 42 => 0x69, 43 => 0x7d, 44 => 0x4a, 48 => 0x53, 49 => 0x53, 50 => 0x53, 51 => 0x5b },
	'wb_rggblevelsunknown20' => { 42 => 0xe6, 43 => 0xff, 49 => 0xd0, 50 => 0xd0, 51 => 0xd8 },
	'wb_rggblevelsunknown21' => { 42 => 0xeb, 43 => 0x104, 50 => 0xd5, 51 => 0xdd },
	'wb_rggblevelsunknown22' => { 42 => 0xf0, 43 => 0x109, 50 => 0xda, 51 => 0xe2 },
	'wb_rggblevelsunknown23' => { 42 => 0xf5, 43 => 0x10e, 50 => 0xdf, 51 => 0xe7 },
	'wb_rggblevelsunknown24' => { 42 => 0xfa, 43 => 0x113, 50 => 0xe4, 51 => 0xec },
	'wb_rggblevelsunknown25' => { 42 => 0xff, 43 => 0x118, 50 => 0xe9, 51 => 0xf1 },
	'wb_rggblevelsunknown26' => { 42 => 0x104, 43 => 0x11d, 50 => 0xee, 51 => 0xf6 },
	'wb_rggblevelsunknown27' => { 42 => 0x109, 43 => 0x122, 50 => 0xf3, 51 => 0xfb },
	'wb_rggblevelsunknown28' => { 42 => 0x10e, 50 => 0xf8, 51 => 0x100 },
	'wb_rggblevelsunknown29' => { 42 => 0x113, 50 => 0xfd, 51 => 0x105 },
	'wb_rggblevelsunknown3' => { 39 => 0x3c, 40 => 0x60, 42 => 0x6e, 43 => 0x82, 44 => 0x4f, 48 => 0x58, 49 => 0x58, 50 => 0x58, 51 => 0x60 },
	'wb_rggblevelsunknown30' => { 50 => 0x102 },
	'wb_rggblevelsunknown4' => { 39 => 0x41, 40 => 0x68, 42 => 0x73, 43 => 0x87, 44 => 0x54, 48 => 0x5d, 49 => 0x5d, 50 => 0x5d, 51 => 0x65 },
	'wb_rggblevelsunknown5' => { 39 => 0x46, 40 => 0x70, 42 => 0x78, 43 => 0x8c, 44 => 0x59, 48 => 0x62, 49 => 0x62, 50 => 0x62, 51 => 0x6a },
	'wb_rggblevelsunknown6' => { 39 => 0x4b, 40 => 0x78, 42 => 0x7d, 43 => 0x91, 44 => 0x5e, 48 => 0x8a, 49 => 0x67, 50 => 0x67, 51 => 0x6f },
	'wb_rggblevelsunknown7' => { 39 => 0x50, 40 => 0x80, 42 => 0x82, 43 => 0x96, 44 => 0x63, 48 => 0x8f, 49 => 0x6c, 50 => 0x6c, 51 => 0x74 },
	'wb_rggblevelsunknown8' => { 39 => 0x55, 40 => 0x88, 42 => 0x87, 43 => 0x9b, 44 => 0x68, 48 => 0x94, 49 => 0x71, 50 => 0x71, 51 => 0x79 },
	'wb_rggblevelsunknown9' => { 39 => 0x5a, 40 => 0x90, 42 => 0x8c, 43 => 0xa0, 44 => 0x6d, 48 => 0x99, 49 => 0x76, 50 => 0x76, 51 => 0x7e },
	'wb_rggblevelsuserselected' => { 384 => 0x5c },
	'wbadjblueamber' => { 104 => 0x20106 },
	'wbadjbluebalance' => { 297 => 0x8 },
	'wbadjcolortemp' => { 104 => 0x20102, 109 => 0x1a },
	'wbadjlighting' => { 297 => 0x14 },
	'wbadjmagentagreen' => { 104 => 0x20105 },
	'wbadjmode' => { 297 => 0x10 },
	'wbadjredbalance' => { 297 => 0x0 },
	'wbadjrggblevels' => { 104 => 0x20125, 109 => 0x6 },
	'wbadjtemperature' => { 297 => 0x18 },
	'wbadjtint' => { 297 => 0x25 },
	'wbbluelevel' => { 336 => 0x324, 341 => 0x8006, 346 => 0x26 },
	'wbbracketingsteps' => { 199 => 0x10, 200 => 0x10, 272 => 0x174d },
	'wbbracketmode' => { 58 => 0x9 },
	'wbbracketshotnumber' => { 188 => 0x2b, 408 => 0x101a },
	'wbbracketvalueab' => { 58 => 0xc },
	'wbbracketvaluegm' => { 58 => 0xd },
	'wbbutton' => { 243 => 0x80a },
	'wbfinetuneactive' => { 109 => 0x24 },
	'wbfinetunesaturation' => { 109 => 0x28 },
	'wbfinetunetone' => { 109 => 0x2c },
	'wbgreenlevel' => { 336 => 0x323, 341 => 0x8005, 346 => 0x25 },
	'wbmediaimagesizesetting' => { 85 => 0x708 },
	'wbmode' => { 190 => 0x4, 323 => 0x1015 },
	'wbredlevel' => { 336 => 0x322, 341 => 0x8004, 346 => 0x24 },
	'wbscale' => { 191 => 0x0 },
	'wbshiftab' => { 75 => 0xc, 341 => 0x46, 358 => 0x10 },
	'wbshiftab_gm' => { 441 => 0x2014 },
	'wbshiftab_gm_precise' => { 441 => 0x2026 },
	'wbshiftcreativecontrol' => { 341 => 0x92 },
	'wbshiftgm' => { 75 => 0xd, 341 => 0x47, 358 => 0x11 },
	'wbshiftintelligentauto' => { 341 => 0x8b },
	'wbtype1' => { 347 => 0x1, 348 => 0x1 },
	'wbtype2' => { 347 => 0x4, 348 => 0x5 },
	'wbtype3' => { 347 => 0x7, 348 => 0x9 },
	'wbtype4' => { 347 => 0xa, 348 => 0xd },
	'wbtype5' => { 347 => 0xd, 348 => 0x11 },
	'wbtype6' => { 347 => 0x10, 348 => 0x15 },
	'wbtype7' => { 347 => 0x13, 348 => 0x19 },
	'webstatement' => { 534 => 'WebStatement' },
	'weightedflatsubject' => { 493 => 'weightedFlatSubject' },
	'what' => { 501 => 'What', 503 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 75 => 0x8, 78 => 0x7, 113 => 0x7, 114 => [0x19,0x2012], 120 => [0xa403,0xfe4e], 128 => 0x1002, 139 => 0x3fc, 140 => 0xfa0d, 141 => 0x40, 152 => 0x1a, 182 => 0x3, 183 => 0xe, 184 => 0x4, 185 => 0xb, 187 => 0x115, 235 => 0x5, 281 => 0x7, 336 => 0x304, 341 => 0x3, 343 => 0x3033, 376 => 0x19, 383 => 0x7, 407 => 0x26, 408 => 0x1003, 418 => [0x88,0x3c,0x7,0x58], 428 => 0xf, 429 => 0xe, 441 => [0x115,0xb054], 501 => 'WhiteBalance', 503 => 'WhiteBalance', 507 => 'WhiteBalance' },
	'whitebalance0' => { 177 => 'WhiteBalance0' },
	'whitebalance1' => { 177 => 'WhiteBalance1' },
	'whitebalance2' => { 177 => 'WhiteBalance2', 318 => 0x500 },
	'whitebalanceadj' => { 104 => 0x20101, 109 => 0x18, 291 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 354 => 0x0 },
	'whitebalancebias' => { 114 => 0x2011, 323 => 0x304, 341 => 0x23 },
	'whitebalanceblue' => { 75 => 0x7 },
	'whitebalancebracket' => { 318 => 0x502, 323 => 0x303 },
	'whitebalancebracketing' => { 185 => 0x22, 188 => 0x2c, 439 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 315 => 0x1c5, 316 => 0x1dd },
	'whitebalancecomp' => { 326 => 0x1001 },
	'whitebalancedetected' => { 139 => 0x3fb },
	'whitebalancefinetune' => { 128 => 0x100a, 185 => 0x38, 187 => 0x112, 235 => [0xb,0x3f], 408 => 0x1004, 428 => 0x6, 429 => 0x5, 441 => 0x112 },
	'whitebalancemode' => { 139 => 0x3fa, 376 => 0x1a },
	'whitebalancered' => { 75 => 0x6 },
	'whitebalanceset' => { 357 => 0xa },
	'whitebalancesetting' => { 185 => 0x23, 428 => 0x5, 429 => 0x4, 430 => 0x16, 446 => 0xd },
	'whitebalancesetup' => { 415 => 0x41 },
	'whitebalancetemperature' => { 318 => 0x501 },
	'whiteboard' => { 323 => 0x301 },
	'whitelevel' => { 120 => 0xc61d, 376 => 0x7e, 448 => 0x787f },
	'whitepoint' => { 120 => 0x13e, 340 => 0x35d, 376 => 0x201, 526 => 'WhitePoint' },
	'whites2012' => { 501 => 'Whites2012', 503 => 'Whites2012' },
	'whitesadj' => { 477 => 0x9017 },
	'wideadapter' => { 408 => 0x1017 },
	'widefocuszone' => { 182 => 0x2f },
	'widerange' => { 417 => 0x20f },
	'windmode' => { 139 => 0x3f4 },
	'windnoisereduction' => { 240 => 0x352, 241 => 0x2d6, 242 => 0x2fe, 243 => 0x2fe },
	'windowlocation' => { 401 => 'WLOC' },
	'windowsatom' => { 502 => 'windowsAtom' },
	'windowsatomextension' => { 502 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 502 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 502 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 520 => 'wordCount' },
	'work' => { 393 => "\xa9wrk" },
	'workcolorspace' => { 104 => 0x10200, 109 => 0x270 },
	'workflowtag' => { 515 => 'WorkflowTag' },
	'workflowtagcvid' => { 515 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 515 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 515 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 515 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 509 => 'WorkToDo' },
	'worldtimelocation' => { 341 => 0x3a, 376 => 0x22, 382 => '0.1' },
	'writer' => { 180 => 'WM/Writer' },
	'writer-editor' => { 132 => 0x7a },
	'x3filllight' => { 418 => 0x12 },
	'xattrquarantine' => { 175 => 'com.apple.quarantine' },
	'xilinxversion' => { 139 => 0x414 },
	'xml' => { 137 => 'xml ' },
	'xmp' => { 107 => 0xffff00f6, 121 => 'XMP' },
	'xmptoolkit' => { 527 => 'xmptk' },
	'xpauthor' => { 120 => 0x9c9d },
	'xpcomment' => { 120 => 0x9c9c },
	'xpkeywords' => { 120 => 0x9c9e },
	'xposition' => { 120 => 0x11e },
	'xpsubject' => { 120 => 0x9c9f },
	'xptitle' => { 120 => 0x9c9b },
	'xresolution' => { 120 => 0x11a, 135 => 0x3, 391 => 0x0, 526 => 'XResolution' },
	'xyresolution' => { 124 => 0x3 },
	'yaw' => { 116 => 0x7, 401 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 248 => 0x8, 413 => 0x0 },
	'ycbcrcoefficients' => { 120 => 0x211, 526 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 120 => 0x213, 526 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 120 => 0x212, 526 => 'YCbCrSubSampling' },
	'year' => { 393 => 'yrrc', 395 => 'year', 401 => 'yrrc' },
	'yearcreated' => { 141 => 0x10, 150 => 0xc },
	'yellowhsl' => { 104 => 0x20912 },
	'yield' => { 522 => 'yield' },
	'yposition' => { 120 => 0x11f },
	'yresolution' => { 120 => 0x11b, 135 => 0x5, 391 => 0x4, 526 => 'YResolution' },
	'zebrapatterntonerange' => { 314 => 0x211, 315 => 0x211, 316 => 0x229 },
	'zoneidentifier' => { 121 => 'ZoneIdentifier' },
	'zonematching' => { 187 => 0x10a, 190 => [0x3a,0x4a], 441 => 0xb024 },
	'zonematchingmode' => { 185 => 0x14 },
	'zonematchingon' => { 184 => 0x75 },
	'zonematchingvalue' => { 428 => 0x1f },
	'zoomedpreviewlength' => { 323 => 0xf05 },
	'zoomedpreviewsize' => { 323 => 0xf06 },
	'zoomedpreviewstart' => { 323 => 0xf04 },
	'zoomsourcewidth' => { 35 => 0x24 },
	'zoomstepcount' => { 321 => 0x300, 323 => 0x100d },
	'zoomtargetwidth' => { 35 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
