#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.16';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 103 => 0x69 },
	'about' => { 449 => 'about' },
	'aboutcvterm' => { 441 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 441 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 441 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 441 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 441 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 110 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 455 => 'absPeakAudioFilePath' },
	'academicfield' => { 445 => 'academicField' },
	'acceleration' => { 113 => 0x9404 },
	'accelerationtracking' => { 78 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 351 => 0x3 },
	'accelerometerx' => { 288 => 0x8d },
	'accelerometery' => { 288 => 0x8e },
	'accelerometerz' => { 288 => 0x8c },
	'accessoryserialnumber' => { 288 => 0x54 },
	'accessorytype' => { 288 => 0x53 },
	'actionadvised' => { 121 => 0x2a },
	'activearea' => { 113 => 0xc68d },
	'actived-lighting' => { 204 => 0x22, 241 => 0x24 },
	'actived-lightingmode' => { 241 => 0x25 },
	'adaptervoltage' => { 127 => 0x407 },
	'addaspectratioinfo' => { 78 => 0x80e },
	'additionalmodelinformation' => { 441 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 78 => 0x80f, 79 => 0x11, 80 => 0x13, 83 => 0x14 },
	'address' => { 148 => 'Address' },
	'adjustmentmode' => { 358 => 0x15 },
	'adlbracketingstep' => { 222 => 0x883 },
	'adlbracketingtype' => { 222 => 0x884 },
	'adobe' => { 114 => 'Adobe' },
	'adultcontentwarning' => { 277 => 'AdultContentWarning', 448 => 'adultContentWarning' },
	'advancedfilter' => { 118 => 0x1201 },
	'advancedraw' => { 243 => 0x76a43203 },
	'advancedscenetype' => { 288 => 0x3d },
	'advisory' => { 453 => 'Advisory' },
	'ae_iso' => { 295 => 0x2, 296 => 0x4, 297 => 0x12 },
	'aeaperture' => { 295 => 0x1, 296 => 0x3, 297 => 0x11 },
	'aeaperturesteps' => { 295 => 0x8, 296 => 0xb },
	'aebautocancel' => { 78 => 0x104 },
	'aebbracketvalue' => { 72 => 0x11 },
	'aebracketingsteps' => { 221 => 0x174c, 222 => 0x87b, 230 => 0x1756 },
	'aebsequence' => { 78 => 0x105 },
	'aebsequenceautocancel' => { 76 => 0x9, 77 => 0x9, 79 => 0x8, 80 => 0x9, 83 => 0x9, 84 => 0x7 },
	'aebshotcount' => { 78 => 0x106 },
	'aebxv' => { 295 => 0x4, 296 => 0x6 },
	'aeerror' => { 296 => 0x8 },
	'aeexposuretime' => { 295 => 0x0, 296 => 0x2, 297 => 0x10 },
	'aelbutton' => { 170 => 0x45 },
	'aelexposureindicator' => { 170 => 0x51 },
	'aelock' => { 170 => 0x5b, 252 => '4.2', 261 => '4.2', 267 => 0x201, 322 => 0x48, 366 => 0x40, 367 => 0x40, 368 => [0x86,0x286] },
	'aelockbutton' => { 250 => '16.1', 252 => '4.1', 255 => '15.1', 256 => '16.1', 257 => '16.1', 259 => '30.1', 260 => '16.1', 261 => '4.1', 263 => '17.1', 265 => '17.1' },
	'aelockbuttonplusdials' => { 250 => '16.2', 259 => '32.1', 263 => '44.1' },
	'aelockformb-d80' => { 265 => '3.1' },
	'aemaxaperture' => { 295 => 0x9, 296 => 0x10, 297 => 0x1c },
	'aemaxaperture2' => { 295 => 0xa, 296 => 0x11, 297 => 0x1d },
	'aemeteringmode' => { 295 => 0xc },
	'aemeteringmode2' => { 295 => '13.1' },
	'aemeteringsegments' => { 173 => 0x628, 322 => 0x209 },
	'aemicroadjustment' => { 78 => 0x110 },
	'aeminaperture' => { 295 => 0xb, 296 => 0x12, 297 => 0x1e },
	'aeminexposuretime' => { 295 => 0x5, 296 => 0x13, 297 => 0x1f },
	'aeprogrammode' => { 295 => 0x6 },
	'aeprojectlink' => { 430 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 430 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 430 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 430 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 430 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 430 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 33 => 0x21 },
	'aewhitebalance' => { 295 => 0xd },
	'aexv' => { 295 => 0x3, 296 => 0x5 },
	'af-cpriorityselection' => { 250 => '1.1', 251 => '1.1', 253 => '1.1', 254 => '1.1', 256 => '0.1', 257 => '0.1', 258 => '0.1', 259 => '1.1', 260 => '0.1', 263 => '1.1', 264 => '1.1' },
	'af-onbutton' => { 253 => '70.1', 254 => '70.1', 264 => '70.1' },
	'af-onformb-d10' => { 250 => '3.3', 259 => '3.2' },
	'af-onformb-d11' => { 260 => '2.2' },
	'af-onformb-d12' => { 263 => '50.1' },
	'af-spriorityselection' => { 250 => '1.2', 251 => '1.2', 253 => '1.4', 254 => '1.4', 258 => '0.2', 259 => '1.2', 260 => '0.2', 263 => '1.2', 264 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 250 => '2.1', 251 => '2.1', 253 => '78.3', 254 => '78.3', 259 => '2.1', 263 => '2.1', 264 => '78.3' },
	'afadjustment' => { 322 => 0x72, 331 => 0x267 },
	'afandmeteringbuttons' => { 78 => 0x701 },
	'afaperture' => { 200 => 0x5, 201 => 0x5 },
	'afareaheight' => { 179 => [0x1a,0x50] },
	'afareaillumination' => { 170 => 0x4b, 261 => '15.3' },
	'afareamode' => { 166 => 0x33, 170 => 0xe, 178 => 0x0, 179 => 0x5, 288 => 0xf, 348 => 0x1205, 359 => [0xa,0x3a], 366 => 0x11, 367 => 0x10, 368 => 0x24, 378 => 0xb043, 401 => 0x17 },
	'afareamodesetting' => { 252 => '11.1', 255 => '0.1', 261 => '16.1', 265 => '2.1', 378 => 0x201c },
	'afareas' => { 267 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 78 => 0x51b },
	'afareawidth' => { 179 => [0x18,0x4e] },
	'afareaxposition' => { 179 => [0x14,0x4a], 348 => 0x1203 },
	'afareaxposition1' => { 348 => 0x1201 },
	'afareayposition' => { 179 => [0x16,0x4c], 348 => 0x1204 },
	'afareayposition1' => { 348 => 0x1202 },
	'afassist' => { 76 => 0x5, 84 => 0x5, 170 => 0x48, 250 => '2.5', 252 => '0.2', 255 => '0.2', 256 => '1.1', 257 => '1.1', 258 => '1.3', 259 => '2.4', 260 => '1.3', 261 => '0.2', 263 => '2.4', 265 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 78 => 0x50e, 79 => 0x4, 80 => 0x5, 81 => 0x4, 82 => 0x4, 83 => 0x5 },
	'afassistlamp' => { 288 => 0x31 },
	'afbuttonpressed' => { 368 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 298 => 0x6 },
	'afduringliveview' => { 78 => 0x511 },
	'affinea' => { 424 => 'AffineA' },
	'affineb' => { 424 => 'AffineB' },
	'affinec' => { 424 => 'AffineC' },
	'affined' => { 424 => 'AffineD' },
	'affinetune' => { 180 => 0x0, 267 => 0x306 },
	'affinetuneadj' => { 180 => 0x2, 214 => 0x2d1, 215 => 0x2dc, 267 => 0x307 },
	'affinetuneindex' => { 180 => 0x1 },
	'affinex' => { 424 => 'AffineX' },
	'affiney' => { 424 => 'AffineY' },
	'afhold' => { 298 => 0x1fd },
	'afilluminator' => { 366 => 0x29, 378 => 0xb044 },
	'afimageheight' => { 179 => [0x12,0x48] },
	'afimagewidth' => { 179 => [0x10,0x46] },
	'afintegrationtime' => { 298 => 0x7 },
	'afmicroadj' => { 359 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 363 => 0x131 },
	'afmicroadjregisteredlenses' => { 363 => '305.1' },
	'afmicroadjustment' => { 78 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 363 => 0x130 },
	'afmode' => { 107 => 0x3009, 118 => 0x1022, 166 => 0x16, 358 => 0x5 },
	'afmoderestrictions' => { 251 => '50.3', 253 => '48.3', 254 => '48.3', 263 => '48.3', 264 => '48.3' },
	'afonaelockbuttonswitch' => { 78 => 0x702 },
	'afonbutton' => { 250 => '3.1', 251 => '47.1' },
	'afpoint' => { 33 => 0x13, 106 => 0x18, 166 => 0x15, 178 => 0x1, 270 => 0x308, 358 => 0x1f, 359 => [0x37,0x7], 363 => 0x19, 364 => 0x18, 365 => [0x18,0x20] },
	'afpointactivationarea' => { 77 => 0x11, 83 => 0x11 },
	'afpointareaexpansion' => { 78 => 0x508 },
	'afpointatshutterrelease' => { 359 => [0x39,0x9] },
	'afpointautoselection' => { 78 => 0x50b },
	'afpointbrightness' => { 78 => 0x50d, 250 => '2.4', 251 => '46.5', 253 => '2.2', 254 => '2.2', 263 => '2.3', 264 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 78 => 0x50c },
	'afpointillumination' => { 77 => 0xa, 250 => '2.3', 251 => '46.2', 253 => '47.2', 254 => '47.2', 258 => '1.2', 259 => '2.3', 260 => '1.2', 263 => '47.2', 264 => '47.2', 265 => '2.4' },
	'afpointinfocus' => { 359 => [0x38,0x8] },
	'afpointmode' => { 303 => 0x3 },
	'afpointposition' => { 107 => 0x2021, 288 => 0x4d },
	'afpointregistration' => { 76 => 0x7 },
	'afpoints' => { 169 => 0x10 },
	'afpointselected' => { 170 => 0xd, 267 => 0x305, 322 => 0xe, 363 => 0x15, 364 => 0x14, 365 => [0x14,0x1c], 378 => 0x201e },
	'afpointselected2' => { 303 => 0x4 },
	'afpointselection' => { 77 => 0xb, 250 => '1.3', 251 => '1.3', 259 => '1.3', 263 => '1.3', 264 => '1.3' },
	'afpointselectionmethod' => { 78 => 0x50f, 79 => 0xc, 80 => 0xd, 83 => 0xd },
	'afpointsetting' => { 366 => 0x12, 367 => 0x11 },
	'afpointsinfocus' => { 72 => 0xe, 178 => 0x2, 298 => 0xb, 299 => 0x4, 322 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 77 => 0xd },
	'afpointsselected' => { 299 => '4.1', 409 => 0x4 },
	'afpointsspecial' => { 299 => '4.2' },
	'afpointsunknown1' => { 298 => 0x0 },
	'afpointsunknown2' => { 298 => 0x2 },
	'afpointsused' => { 179 => 0x8, 359 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 298 => 0x4 },
	'afresponse' => { 204 => 0xad },
	'afresult' => { 272 => 0x1038 },
	'afsearch' => { 267 => 0x303 },
	'afsensoractive' => { 166 => 0x1 },
	'afstatus' => { 348 => 0x1200 },
	'afstatus_00_b4' => { 362 => 0x0 },
	'afstatus_01_c4' => { 362 => 0x2 },
	'afstatus_02_d4' => { 362 => 0x4 },
	'afstatus_03_e4' => { 362 => 0x6 },
	'afstatus_04_f4' => { 362 => 0x8 },
	'afstatus_05_g4' => { 362 => 0xa },
	'afstatus_06_h4' => { 362 => 0xc },
	'afstatus_07_b3' => { 362 => 0xe },
	'afstatus_08_c3' => { 362 => 0x10 },
	'afstatus_09_d3' => { 362 => 0x12 },
	'afstatus_10_e3' => { 362 => 0x14 },
	'afstatus_11_f3' => { 362 => 0x16 },
	'afstatus_12_g3' => { 362 => 0x18 },
	'afstatus_13_h3' => { 362 => 0x1a },
	'afstatus_14_b2' => { 362 => 0x1c },
	'afstatus_15_c2' => { 362 => 0x1e },
	'afstatus_16_d2' => { 362 => 0x20 },
	'afstatus_17_e2' => { 362 => 0x22 },
	'afstatus_18_f2' => { 362 => 0x24 },
	'afstatus_19_g2' => { 362 => 0x26 },
	'afstatus_20_h2' => { 362 => 0x28 },
	'afstatus_21_c1' => { 362 => 0x2a },
	'afstatus_22_d1' => { 362 => 0x2c },
	'afstatus_23_e1' => { 362 => 0x2e },
	'afstatus_24_f1' => { 362 => 0x30 },
	'afstatus_25_g1' => { 362 => 0x32 },
	'afstatus_26_a7_vertical' => { 362 => 0x34 },
	'afstatus_27_a6_vertical' => { 362 => 0x36 },
	'afstatus_28_a5_vertical' => { 362 => 0x38 },
	'afstatus_29_c7_vertical' => { 362 => 0x3a },
	'afstatus_30_c6_vertical' => { 362 => 0x3c },
	'afstatus_31_c5_vertical' => { 362 => 0x3e },
	'afstatus_32_e7_vertical' => { 362 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 362 => 0x42 },
	'afstatus_34_e5_vertical' => { 362 => 0x44 },
	'afstatus_35_g7_vertical' => { 362 => 0x46 },
	'afstatus_36_g6_vertical' => { 362 => 0x48 },
	'afstatus_37_g5_vertical' => { 362 => 0x4a },
	'afstatus_38_i7_vertical' => { 362 => 0x4c },
	'afstatus_39_i6_vertical' => { 362 => 0x4e },
	'afstatus_40_i5_vertical' => { 362 => 0x50 },
	'afstatus_41_a7' => { 362 => 0x52 },
	'afstatus_42_b7' => { 362 => 0x54 },
	'afstatus_43_c7' => { 362 => 0x56 },
	'afstatus_44_d7' => { 362 => 0x58 },
	'afstatus_45_e7' => { 362 => 0x5a },
	'afstatus_46_f7' => { 362 => 0x5c },
	'afstatus_47_g7' => { 362 => 0x5e },
	'afstatus_48_h7' => { 362 => 0x60 },
	'afstatus_49_i7' => { 362 => 0x62 },
	'afstatus_50_a6' => { 362 => 0x64 },
	'afstatus_51_b6' => { 362 => 0x66 },
	'afstatus_52_c6' => { 362 => 0x68 },
	'afstatus_53_d6' => { 362 => 0x6a },
	'afstatus_54_e6_center' => { 362 => 0x6c },
	'afstatus_55_f6' => { 362 => 0x6e },
	'afstatus_56_g6' => { 362 => 0x70 },
	'afstatus_57_h6' => { 362 => 0x72 },
	'afstatus_58_i6' => { 362 => 0x74 },
	'afstatus_59_a5' => { 362 => 0x76 },
	'afstatus_60_b5' => { 362 => 0x78 },
	'afstatus_61_c5' => { 362 => 0x7a },
	'afstatus_62_d5' => { 362 => 0x7c },
	'afstatus_63_e5' => { 362 => 0x7e },
	'afstatus_64_f5' => { 362 => 0x80 },
	'afstatus_65_g5' => { 362 => 0x82 },
	'afstatus_66_h5' => { 362 => 0x84 },
	'afstatus_67_i5' => { 362 => 0x86 },
	'afstatus_68_c11' => { 362 => 0x88 },
	'afstatus_69_d11' => { 362 => 0x8a },
	'afstatus_70_e11' => { 362 => 0x8c },
	'afstatus_71_f11' => { 362 => 0x8e },
	'afstatus_72_g11' => { 362 => 0x90 },
	'afstatus_73_b10' => { 362 => 0x92 },
	'afstatus_74_c10' => { 362 => 0x94 },
	'afstatus_75_d10' => { 362 => 0x96 },
	'afstatus_76_e10' => { 362 => 0x98 },
	'afstatus_77_f10' => { 362 => 0x9a },
	'afstatus_78_g10' => { 362 => 0x9c },
	'afstatus_79_h10' => { 362 => 0x9e },
	'afstatus_80_b9' => { 362 => 0xa0 },
	'afstatus_81_c9' => { 362 => 0xa2 },
	'afstatus_82_d9' => { 362 => 0xa4 },
	'afstatus_83_e9' => { 362 => 0xa6 },
	'afstatus_84_f9' => { 362 => 0xa8 },
	'afstatus_85_g9' => { 362 => 0xaa },
	'afstatus_86_h9' => { 362 => 0xac },
	'afstatus_87_b8' => { 362 => 0xae },
	'afstatus_88_c8' => { 362 => 0xb0 },
	'afstatus_89_d8' => { 362 => 0xb2 },
	'afstatus_90_e8' => { 362 => 0xb4 },
	'afstatus_91_f8' => { 362 => 0xb6 },
	'afstatus_92_g8' => { 362 => 0xb8 },
	'afstatus_93_h8' => { 362 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 362 => 0xbc },
	'afstatusactivesensor' => { 166 => 0x2, 359 => [0x4,0x3b], 363 => 0x1e, 364 => 0x1b, 365 => [0x1b,0x21] },
	'afstatusbottom' => { 166 => 0x8, 363 => 0x2a, 364 => 0x21, 365 => 0x21 },
	'afstatusbottom-left' => { 166 => 0x12, 364 => 0x2b, 365 => 0x2b },
	'afstatusbottom-right' => { 166 => 0x6, 364 => 0x1f, 365 => 0x1f },
	'afstatusbottomassist-left' => { 363 => 0x28 },
	'afstatusbottomassist-right' => { 363 => 0x2c },
	'afstatusbottomhorizontal' => { 360 => 0x10, 361 => 0x1c },
	'afstatusbottomvertical' => { 360 => 0x16, 361 => 0x26 },
	'afstatuscenter-10' => { 363 => 0x34 },
	'afstatuscenter-11' => { 363 => 0x36 },
	'afstatuscenter-12' => { 363 => 0x38 },
	'afstatuscenter-14' => { 363 => 0x3c },
	'afstatuscenter-7' => { 363 => 0x2e },
	'afstatuscenter-9' => { 363 => 0x32 },
	'afstatuscenter-horizontal' => { 363 => 0x30 },
	'afstatuscenter-vertical' => { 363 => 0x3a },
	'afstatuscenterf2-8' => { 363 => 0x4c },
	'afstatuscenterhorizontal' => { 166 => 0x2f, 360 => 0xc, 361 => 0x18, 364 => 0x2f, 365 => 0x2f },
	'afstatuscentervertical' => { 166 => 0xc, 360 => 0x14, 361 => 0x22, 364 => 0x25, 365 => 0x25 },
	'afstatusfarleft' => { 360 => 0x6, 363 => 0x26 },
	'afstatusfarlefthorizontal' => { 361 => 0x4 },
	'afstatusfarleftvertical' => { 361 => 0x12 },
	'afstatusfarright' => { 360 => 0x18, 363 => 0x44 },
	'afstatusfarrighthorizontal' => { 361 => 0x2c },
	'afstatusfarrightvertical' => { 361 => 0x34 },
	'afstatusleft' => { 166 => 0x2d, 360 => 0x2, 363 => 0x22, 364 => 0x2d, 365 => 0x2d },
	'afstatuslefthorizontal' => { 361 => 0x6 },
	'afstatusleftvertical' => { 361 => 0xe },
	'afstatuslower-left' => { 360 => 0x4, 363 => 0x24 },
	'afstatuslower-lefthorizontal' => { 361 => 0xa },
	'afstatuslower-leftvertical' => { 361 => 0x10 },
	'afstatuslower-middle' => { 360 => 0x22, 361 => 0x24 },
	'afstatuslower-right' => { 360 => 0x1e, 363 => 0x4a },
	'afstatuslower-righthorizontal' => { 361 => 0x32 },
	'afstatuslower-rightvertical' => { 361 => 0x3a },
	'afstatuslowerfarleft' => { 361 => 0x8 },
	'afstatuslowerfarright' => { 361 => 0x30 },
	'afstatusmiddlehorizontal' => { 166 => 0xa, 364 => 0x23, 365 => 0x23 },
	'afstatusnearleft' => { 360 => 0xe, 361 => 0x1a },
	'afstatusnearright' => { 360 => 0xa, 361 => 0x16 },
	'afstatusright' => { 166 => 0x31, 360 => 0x1c, 363 => 0x48, 364 => 0x31, 365 => 0x31 },
	'afstatusrighthorizontal' => { 361 => 0x2e },
	'afstatusrightvertical' => { 361 => 0x38 },
	'afstatustop' => { 166 => 0xe, 363 => 0x40, 364 => 0x27, 365 => 0x27 },
	'afstatustop-left' => { 166 => 0x10, 364 => 0x29, 365 => 0x29 },
	'afstatustop-right' => { 166 => 0x4, 364 => 0x1d, 365 => 0x1d },
	'afstatustopassist-left' => { 363 => 0x3e },
	'afstatustopassist-right' => { 363 => 0x42 },
	'afstatustophorizontal' => { 360 => 0x8, 361 => 0x14 },
	'afstatustopvertical' => { 360 => 0x12, 361 => 0x1e },
	'afstatusupper-left' => { 360 => 0x0, 363 => 0x20 },
	'afstatusupper-lefthorizontal' => { 361 => 0x2 },
	'afstatusupper-leftvertical' => { 361 => 0xc },
	'afstatusupper-middle' => { 360 => 0x20, 361 => 0x20 },
	'afstatusupper-right' => { 360 => 0x1a, 363 => 0x46 },
	'afstatusupper-righthorizontal' => { 361 => 0x2a },
	'afstatusupper-rightvertical' => { 361 => 0x36 },
	'afstatusupperfarleft' => { 361 => 0x0 },
	'afstatusupperfarright' => { 361 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 378 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 359 => 0x2 },
	'afwithshutter' => { 366 => 0x2a },
	'aggregateissuenumber' => { 445 => 'aggregateIssueNumber' },
	'aggregationtype' => { 445 => 'aggregationType' },
	'agreement' => { 448 => 'agreement' },
	'aiservocontinuousshooting' => { 77 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 78 => 0x519 },
	'aiservoimagepriority' => { 78 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 78 => 0x51a },
	'aiservotrackingmethod' => { 78 => 0x504 },
	'aiservotrackingsensitivity' => { 77 => 0x14, 78 => 0x502 },
	'album' => { 455 => 'album' },
	'alreadyapplied' => { 431 => 'AlreadyApplied' },
	'alternatetitle' => { 445 => 'alternateTitle' },
	'alternatetitlea-lang' => { 445 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 445 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 445 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 181 => 0x6 },
	'alttapename' => { 455 => 'altTapeName' },
	'alttimecode' => { 455 => 'altTimecode' },
	'alttimecodetimeformat' => { 455 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 455 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 455 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 113 => 0x9400, 343 => 0x14, 344 => 0x46, 401 => 0x4 },
	'ambienttemperaturefahrenheit' => { 343 => 0x13, 344 => 0x44 },
	'analogbalance' => { 113 => 0xc627 },
	'angleadj' => { 97 => 0x10003, 103 => 0x8b },
	'angleinforoll' => { 426 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 426 => 'AngleInfoYaw' },
	'anti-blur' => { 378 => 0xb04b },
	'antialiasstrength' => { 113 => 0xc632 },
	'aperturelock' => { 251 => '38.2', 253 => '38.2', 254 => '38.2', 263 => '38.2', 264 => '38.2' },
	'aperturerange' => { 78 => 0x10d },
	'apertureringuse' => { 303 => '1.4' },
	'aperturesetting' => { 170 => 0x7, 366 => 0x30, 367 => 0x29, 368 => 0x1 },
	'aperturevalue' => { 87 => 0x2, 113 => 0x9202, 272 => 0x1002, 331 => 0x401, 435 => 'ApertureValue' },
	'applekeywords' => { 276 => 'AAPL:Keywords' },
	'applicationnotes' => { 113 => 0x2bc, 292 => 0x2bc },
	'applicationrecordversion' => { 121 => 0x0 },
	'applyshootingmeteringmode' => { 78 => 0x10e },
	'approved' => { 437 => 'Approved' },
	'approvedby' => { 437 => 'ApprovedBy' },
	'approximatefnumber' => { 284 => 0x313, 290 => 0x3406 },
	'approximatefocusdistance' => { 427 => 'ApproximateFocusDistance' },
	'appversion' => { 439 => 'AppVersion' },
	'aquahsl' => { 97 => 0x20914 },
	'armidentifier' => { 122 => 0x78 },
	'armversion' => { 122 => 0x7a },
	'artfilter' => { 267 => 0x529 },
	'artfiltereffect' => { 267 => 0x52f },
	'artist' => { 113 => 0x13b, 280 => 'Artist', 322 => 0x22e, 451 => 'Artist', 455 => 'artist' },
	'artmode' => { 107 => 0x301b },
	'artmodeparameters' => { 107 => 0x310b },
	'artworkcircadatecreated' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 441 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 441 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 271 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 271 => 0x1112, 322 => 0x80, 366 => 0x55, 367 => 0x55, 368 => 0xa },
	'assetid' => { 421 => 'AssetID' },
	'asshoticcprofile' => { 113 => 0xc68f },
	'asshotneutral' => { 113 => 0xc628 },
	'asshotpreprofilematrix' => { 113 => 0xc690 },
	'asshotprofilename' => { 113 => 0xc6f6 },
	'asshotwhitexy' => { 113 => 0xc629 },
	'assignbktbutton' => { 250 => '4.2', 251 => '16.1', 253 => '16.1', 254 => '16.1', 263 => '16.1', 264 => '16.1' },
	'assignfuncbutton' => { 78 => 0x70b },
	'assignmb-d17af-onbutton' => { 254 => '79.1' },
	'assignmb-d17funcbutton' => { 254 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 254 => '68.1' },
	'assignmb-d18af-onbutton' => { 264 => '79.1' },
	'assignmb-d18funcbutton' => { 264 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 264 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 253 => '75.1', 254 => '75.1', 264 => '75.1' },
	'assignmoviefunc2button' => { 253 => '82.1', 254 => '82.1', 264 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 253 => '75.2', 254 => '75.2', 264 => '75.2' },
	'assignmovierecordbutton' => { 251 => '43.2', 263 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 253 => '45.1', 254 => '45.1', 264 => '45.1' },
	'assignmoviesubselector' => { 253 => '74.1', 254 => '74.1', 264 => '74.1' },
	'assignmoviesubselectorplusdials' => { 253 => '76.1', 254 => '76.1', 264 => '76.1' },
	'assignremotefnbutton' => { 251 => '54.1', 263 => '51.1' },
	'assistbuttonfunction' => { 76 => 0xd },
	'attributionname' => { 428 => 'attributionName' },
	'attributionurl' => { 428 => 'attributionURL' },
	'audio' => { 288 => 0x20 },
	'audiobitrate' => { 63 => 0x6c, 441 => 'audioBitRate' },
	'audiobitratemode' => { 441 => 'audioBitRateMode' },
	'audiochannelcount' => { 441 => 'audioChannelCount' },
	'audiochannels' => { 63 => 0x70 },
	'audiochanneltype' => { 455 => 'audioChannelType' },
	'audiocompression' => { 142 => 'Compression' },
	'audiocompressor' => { 455 => 'audioCompressor' },
	'audiodata' => { 415 => 'Data' },
	'audioduration' => { 121 => 0x99 },
	'audiomimetype' => { 415 => 'Mime' },
	'audiomoddate' => { 455 => 'audioModDate' },
	'audiooutcue' => { 121 => 0x9a },
	'audiosamplerate' => { 63 => 0x6e, 455 => 'audioSampleRate' },
	'audiosampletype' => { 455 => 'audioSampleType' },
	'audiosamplingrate' => { 121 => 0x97 },
	'audiosamplingresolution' => { 121 => 0x98 },
	'audiotype' => { 121 => 0x96 },
	'author' => { 144 => 'Author', 276 => 'Author', 280 => 'Author', 338 => 'Author', 425 => 'author', 442 => 'Author', 453 => 'Author' },
	'authorsposition' => { 443 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 78 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 313 => '0.1' },
	'autobracket' => { 358 => 0x19 },
	'autobracketing' => { 118 => 0x1100, 322 => 0x18, 348 => 0x1007 },
	'autobracketingmode' => { 262 => '12.3' },
	'autobracketingset' => { 262 => '12.1' },
	'autobracketmodem' => { 250 => '21.2', 251 => '13.3', 253 => '13.2', 254 => '13.2', 259 => '26.2', 263 => '13.3', 264 => '13.2' },
	'autobracketorder' => { 170 => 0x43, 250 => '21.3', 251 => '13.2', 253 => '13.1', 254 => '13.1', 259 => '26.3', 260 => '12.2', 261 => '2.2', 262 => '12.2', 263 => '13.2', 264 => '13.1', 265 => '13.2' },
	'autobracketset' => { 250 => '21.1', 251 => '13.1', 255 => '11.1', 256 => '12.1', 257 => '12.1', 259 => '26.1', 260 => '12.1', 261 => '2.1', 263 => '13.1', 265 => '13.1' },
	'autobrightness' => { 431 => 'AutoBrightness' },
	'autocontrast' => { 431 => 'AutoContrast' },
	'autodistortioncontrol' => { 189 => 0x4 },
	'autodynamicrange' => { 118 => 0x140b },
	'autoexposure' => { 431 => 'AutoExposure' },
	'autoexposurebracketing' => { 72 => 0x10 },
	'autoflashisosensitivity' => { 253 => '38.5', 254 => '38.5', 264 => '38.5' },
	'autofocus' => { 270 => 0x209 },
	'autofp' => { 261 => '7.3', 265 => '31.4' },
	'autoiso' => { 72 => 0x1, 107 => 0x3008, 252 => '1.1', 261 => '1.1' },
	'autoisomax' => { 252 => '1.2', 261 => '1.2' },
	'autoisominshutterspeed' => { 252 => '1.3', 261 => '1.3' },
	'autolateralca' => { 431 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 59 => 0x2, 78 => 0x204, 97 => 0x20500, 103 => 0x6f },
	'autolightingoptimizeron' => { 97 => '0x20500.0', 103 => 0x6e },
	'autoportraitframed' => { 378 => 0x2016 },
	'autoredeye' => { 243 => 0xfe28a44f },
	'autorotate' => { 72 => 0x1b },
	'autoshadows' => { 431 => 'AutoShadows' },
	'autowhiteversion' => { 431 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 204 => 0x82 },
	'avaperturesetting' => { 303 => 0x13 },
	'averageblacklevel' => { 42 => 0xe7, 44 => 0xfb, 45 => 0x114, 46 => 0x146 },
	'averagelv' => { 173 => 0x38 },
	'avsettingwithoutlens' => { 78 => 0x707 },
	'azimuth' => { 152 => 'Azimuth' },
	'babyage' => { 288 => [0x8010,0x33] },
	'babyname' => { 288 => 0x66 },
	'backgroundalpha' => { 450 => 'bgalpha' },
	'baseexposurecompensation' => { 303 => 0x15 },
	'baseiso' => { 72 => 0x2, 91 => 0x101c, 127 => 0x903, 290 => 0x312a, 407 => 0x6 },
	'baselineexposure' => { 113 => 0xc62a },
	'baselineexposureoffset' => { 113 => 0xc7a5 },
	'baselinenoise' => { 113 => 0xc62b },
	'baselinesharpness' => { 113 => 0xc62c },
	'baseurl' => { 453 => 'BaseURL' },
	'batterylevel' => { 366 => 0x51, 370 => 0xc, 371 => 0x4, 372 => 0x4, 408 => 0x7 },
	'batterylevelgrip1' => { 408 => 0x6 },
	'batterylevelgrip2' => { 408 => 0x8 },
	'batteryorder' => { 250 => '12.5', 259 => '13.2', 260 => '2.1', 263 => '3.1' },
	'batterystate' => { 170 => 0x60, 366 => 0x50, 372 => 0x14 },
	'batterytemperature' => { 370 => 0x1, 372 => 0x2, 408 => 0x5 },
	'batterytype' => { 60 => 0x38 },
	'batteryunknown' => { 370 => 0x2, 372 => 0x0 },
	'batteryvoltage' => { 127 => 0x408, 343 => 0x2a, 344 => 0x49, 370 => 0x8 },
	'batteryvoltage1' => { 372 => 0x6 },
	'batteryvoltage2' => { 372 => 0x8 },
	'bayergreensplit' => { 113 => 0xc62d },
	'bayerpattern' => { 126 => 0xf902, 174 => 0x17 },
	'beatspliceparams' => { 455 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 455 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 455 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 455 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 455 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 455 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 250 => '13.1', 251 => '5.4', 252 => '0.1', 255 => '2.1', 256 => '3.1', 257 => '3.1', 259 => '10.1', 261 => '0.1', 263 => '5.5', 265 => '4.1' },
	'beeppitch' => { 260 => '3.1' },
	'beepvolume' => { 260 => '4.5' },
	'bestqualityscale' => { 113 => 0xc65c },
	'bestshotmode' => { 107 => 0x3007 },
	'bitdepth' => { 149 => 'BitDepth', 174 => 0x11, 211 => 0x41 },
	'bitspercomponent' => { 123 => 0x87 },
	'bitspersample' => { 113 => 0x102, 292 => 0xa, 451 => 'BitsPerSample' },
	'blacklevel' => { 113 => 0xc61a, 204 => 0x3d, 272 => [0x401,0x1012], 331 => 0x21d },
	'blacklevel2' => { 271 => 0x600, 275 => 0x600 },
	'blacklevelblue' => { 292 => 0x1e },
	'blackleveldata' => { 331 => 0x223 },
	'blackleveldeltah' => { 113 => 0xc61b },
	'blackleveldeltav' => { 113 => 0xc61c },
	'blacklevelgreen' => { 292 => 0x1d },
	'blacklevelred' => { 292 => 0x1c },
	'blacklevelrepeatdim' => { 113 => 0xc619 },
	'blackpoint' => { 322 => 0x200 },
	'blacks2012' => { 431 => 'Blacks2012' },
	'bleachbypasstoning' => { 322 => 0x7f },
	'blockshotafresponse' => { 253 => '1.5', 254 => '1.5', 264 => '1.5' },
	'blogtitle' => { 445 => 'blogTitle' },
	'blogurl' => { 445 => 'blogURL' },
	'bluebalance' => { 187 => 0x271, 272 => 0x1018, 292 => 0x12, 322 => 0x1b },
	'bluecurvelimits' => { 102 => 0x1fe },
	'bluecurvepoints' => { 101 => 0x79, 102 => 0x1d4 },
	'bluehsl' => { 97 => 0x20915 },
	'bluehue' => { 431 => 'BlueHue' },
	'bluesaturation' => { 431 => 'BlueSaturation' },
	'bluratinfinity' => { 417 => 'BlurAtInfinity' },
	'blurcontrol' => { 322 => 0x82 },
	'blurwarning' => { 118 => 0x1300 },
	'bodybatteryadload' => { 301 => 0x3 },
	'bodybatteryadnoload' => { 301 => 0x2 },
	'bodybatterystate' => { 301 => '1.1' },
	'bodybatteryvoltage1' => { 301 => 0x2 },
	'bodybatteryvoltage2' => { 301 => 0x4 },
	'bodybatteryvoltage3' => { 301 => 0x6 },
	'bodybatteryvoltage4' => { 301 => 0x8 },
	'bodyfirmware' => { 349 => 0x0 },
	'bodyfirmwareversion' => { 268 => 0x104, 269 => 0x100, 272 => 0x104 },
	'bodyserialnumber' => { 349 => 0x10 },
	'bookedition' => { 445 => 'bookEdition' },
	'bootloaderversion' => { 344 => 0x26 },
	'bracketmode' => { 54 => 0x3 },
	'bracketsequence' => { 107 => 0x301d },
	'bracketsettings' => { 288 => 0x45 },
	'bracketshotnumber' => { 54 => 0x5, 303 => 0x9, 377 => 0x2b },
	'bracketshotnumber2' => { 377 => 0x2d },
	'bracketstep' => { 167 => 0xe },
	'bracketvalue' => { 54 => 0x4 },
	'brightness' => { 113 => 0xfe53, 143 => 'Brightness', 163 => 'Brightness', 167 => 0x2c, 206 => 0x34, 207 => 0x39, 343 => 0x25, 366 => 0x22, 378 => 0x2007, 431 => 'Brightness' },
	'brightnessadj' => { 102 => 0x114, 236 => 0x0, 246 => 0x2d, 411 => 0x8018 },
	'brightnessvalue' => { 113 => 0x9203, 173 => [0x691,0x49c3], 272 => 0x1003, 383 => 0x1e, 386 => 0x1140, 387 => 0x1140, 388 => 0x111c, 389 => 0x1198, 390 => 0x1174, 391 => 0x102c, 392 => 0x224, 393 => 0x224, 394 => 0x219, 435 => 'BrightnessValue' },
	'bulbduration' => { 72 => 0x18 },
	'burstmode' => { 129 => 0xa, 288 => 0x2a },
	'burstmode2' => { 129 => 0x18 },
	'burstshot' => { 358 => 0x34 },
	'burstspeed' => { 288 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 78 => 0x70a },
	'bwfilter' => { 167 => 0x2a, 175 => 0x39 },
	'bwmode' => { 272 => 0x203 },
	'by-line' => { 121 => 0x50 },
	'by-linetitle' => { 121 => 0x55 },
	'bytecount' => { 445 => 'byteCount' },
	'calibration' => { 358 => [0x24,0x30] },
	'calibrationilluminant1' => { 113 => 0xc65a },
	'calibrationilluminant2' => { 113 => 0xc65b },
	'callforimage' => { 421 => 'CallForImage' },
	'cameraangle' => { 455 => 'cameraAngle' },
	'cameracalibration1' => { 113 => 0xc623 },
	'cameracalibration2' => { 113 => 0xc624 },
	'cameracalibrationsig' => { 113 => 0xc6f3 },
	'cameracolorcalibration01' => { 35 => 0x0, 36 => 0x0 },
	'cameracolorcalibration02' => { 35 => 0x4, 36 => 0x5 },
	'cameracolorcalibration03' => { 35 => 0x8, 36 => 0xa },
	'cameracolorcalibration04' => { 35 => 0xc, 36 => 0xf },
	'cameracolorcalibration05' => { 35 => 0x10, 36 => 0x14 },
	'cameracolorcalibration06' => { 35 => 0x14, 36 => 0x19 },
	'cameracolorcalibration07' => { 35 => 0x18, 36 => 0x1e },
	'cameracolorcalibration08' => { 35 => 0x1c, 36 => 0x23 },
	'cameracolorcalibration09' => { 35 => 0x20, 36 => 0x28 },
	'cameracolorcalibration10' => { 35 => 0x24, 36 => 0x2d },
	'cameracolorcalibration11' => { 35 => 0x28, 36 => 0x32 },
	'cameracolorcalibration12' => { 35 => 0x2c, 36 => 0x37 },
	'cameracolorcalibration13' => { 35 => 0x30, 36 => 0x3c },
	'cameracolorcalibration14' => { 35 => 0x34, 36 => 0x41 },
	'cameracolorcalibration15' => { 35 => 0x38, 36 => 0x46 },
	'camerae-mountversion' => { 410 => 0xb },
	'cameraelevationangle' => { 113 => 0x9405 },
	'camerafilename' => { 421 => 'CameraFilename' },
	'cameraid' => { 272 => 0x209, 357 => 0x209 },
	'cameraiso' => { 33 => 0x10 },
	'cameralabel' => { 113 => 0xc7a1, 455 => 'cameraLabel' },
	'cameramakemodel' => { 421 => 'CameraMakeModel' },
	'cameramodel' => { 331 => 0x410, 455 => 'cameraModel' },
	'cameramodelid' => { 163 => 'CameraModelID' },
	'cameramove' => { 455 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 27 => 0x35, 28 => 0x96, 288 => 0x8f, 326 => 0x1, 331 => 0x100, 372 => [0x16,0x18], 398 => 0x28, 399 => 0x24, 400 => 0x29 },
	'cameraowner' => { 130 => 0xc353 },
	'cameraparameters' => { 272 => 0x2050 },
	'camerapicturestyle' => { 27 => 0xaf },
	'camerapitch' => { 109 => 0x9 },
	'cameraprofile' => { 431 => 'CameraProfile' },
	'cameraprofiledigest' => { 431 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 103 => 0xe1 },
	'camerarawcontrast' => { 103 => 0xe3 },
	'camerarawhighlightpoint' => { 103 => 0xe6 },
	'camerarawlinear' => { 103 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 103 => 0xe8 },
	'camerarawoutputshadowpoint' => { 103 => 0xe9 },
	'camerarawsaturation' => { 103 => 0xe2 },
	'camerarawshadowpoint' => { 103 => 0xe7 },
	'camerarawsharpness' => { 103 => 0xe5 },
	'cameraroll' => { 109 => 0xb },
	'cameraserialnumber' => { 113 => 0xc62f, 165 => 'CameraSerialNumber', 421 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 267 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x19, 28 => 0x1b, 29 => [0x87,0x91], 30 => [0x99,0x9f,0xa4,0xa8,0x105], 32 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 72 => 0xc, 127 => 0x406, 271 => 0x1306, 284 => 0x320, 290 => 0x3402, 322 => 0x47, 355 => 0x43, 402 => 0x5 },
	'cameratemperature4' => { 327 => 0x14 },
	'cameratemperature5' => { 327 => 0x16 },
	'cameratemperaturerangemax' => { 115 => 0x5 },
	'cameratemperaturerangemin' => { 115 => 0x6 },
	'cameratype' => { 72 => 0x1a, 272 => 0x207 },
	'cameratype2' => { 268 => 0x100 },
	'camerayaw' => { 109 => 0xa },
	'canondr4' => { 114 => 'CanonDR4' },
	'canonexposuremode' => { 33 => 0x14 },
	'canonfiledescription' => { 91 => 0x805 },
	'canonfilelength' => { 60 => 0xe },
	'canonfirmwareversion' => { 60 => 0x7, 91 => 0x80b },
	'canonflashinfo' => { 91 => 0x1028 },
	'canonflashmode' => { 33 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 33 => 0xa },
	'canonimagetype' => { 60 => 0x6, 91 => 0x815 },
	'canonmodelid' => { 60 => 0x10, 91 => 0x1834 },
	'canonvrd' => { 114 => 'CanonVRD' },
	'caption' => { 425 => 'caption' },
	'caption-abstract' => { 121 => 0x78 },
	'captionsauthornames' => { 434 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 434 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 443 => 'CaptionWriter' },
	'captureframerate' => { 107 => 0x4001 },
	'capturesoftware' => { 419 => 'CaptureSoftware' },
	'cardshutterlock' => { 170 => 0x49 },
	'casioimagesize' => { 107 => 0x9 },
	'catalogsets' => { 121 => 0xff, 414 => 'CatalogSets', 423 => 'CatalogSets' },
	'categories' => { 60 => 0x23, 425 => 'categories' },
	'category' => { 121 => 0xf, 266 => 0x30, 443 => 'Category' },
	'cbcrgain' => { 355 => 0xa036 },
	'cbcrgaindefault' => { 355 => 0xa035 },
	'cbcrmatrix' => { 355 => 0xa034 },
	'cbcrmatrixdefault' => { 355 => 0xa033 },
	'ccdboardversion' => { 284 => 0x331 },
	'ccdscanmode' => { 272 => 0x1039 },
	'ccdsensitivity' => { 233 => 0x6 },
	'ccdversion' => { 284 => 0x330 },
	'cellglobalid' => { 429 => 'cgi' },
	'celllength' => { 113 => 0x109 },
	'cellr' => { 429 => 'r' },
	'celltowerid' => { 429 => 'cellid' },
	'cellwidth' => { 113 => 0x108 },
	'centerafarea' => { 261 => '15.1' },
	'centerfocuspoint' => { 265 => '2.2' },
	'centerweightedareasize' => { 250 => '7.1', 251 => '8.1', 253 => '8.1', 254 => '8.1', 258 => '7.1', 259 => '5.1', 260 => '7.1', 261 => '6.3', 263 => '8.1', 264 => '8.1', 265 => '8.1' },
	'certificate' => { 459 => 'Certificate' },
	'cfapattern' => { 113 => 0xa302, 292 => 0x9, 435 => 'CFAPattern' },
	'cfapattern2' => { 113 => 0x828e },
	'cfapatterncolumns' => { 435 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 435 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 435 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 113 => 0x828d },
	'channel' => { 445 => 'channel' },
	'channela-lang' => { 445 => [\'channel','channelA-lang'] },
	'channelchannel' => { 445 => [\'channel','channelChannel'] },
	'channels' => { 142 => 'Channels' },
	'channelsubchannel1' => { 445 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 445 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 445 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 445 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 97 => 0x10101, 102 => 0x26a },
	'checkmark2' => { 103 => 0x8e },
	'childfontfiles' => { 460 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 250 => '10.3', 251 => '11.2' },
	'chromablurradius' => { 113 => 0xc631 },
	'chromaticaberration' => { 97 => 0x20703, 103 => 0x66, 355 => 0xa051 },
	'chromaticaberrationb' => { 431 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 97 => 0x20708, 103 => 0x6b },
	'chromaticaberrationcorr' => { 74 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 312 => 0x1 },
	'chromaticaberrationcorrparams' => { 113 => 0x7035, 406 => 0x66a, 407 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 97 => '0x20703.0', 103 => 0x62 },
	'chromaticaberrationr' => { 431 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 97 => 0x20707, 103 => 0x6a },
	'chromaticaberrationsetting' => { 75 => 0x6 },
	'chrominancenoisereduction' => { 97 => 0x20601, 103 => 0x5e, 358 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 103 => 0x60 },
	'circadatecreated' => { 441 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 431 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 431 => 'CircularGradientBasedCorrections' },
	'city' => { 121 => 0x5a, 148 => 'City', 288 => 0x6d, 443 => 'City' },
	'city2' => { 288 => 0x80 },
	'clarity' => { 207 => 0x35, 431 => 'Clarity' },
	'clarity2012' => { 431 => 'Clarity2012' },
	'claritycontrol' => { 322 => 0x96 },
	'classifystate' => { 121 => 0xe1 },
	'clearretouch' => { 288 => 0x7c },
	'clearretouchvalue' => { 288 => 0xa3 },
	'client' => { 455 => 'client' },
	'clientname' => { 437 => 'ClientName' },
	'clmodeshootingspeed' => { 250 => '10.2', 251 => '11.3', 253 => '11.2', 254 => '11.2', 259 => '11.2', 260 => '10.2', 263 => '11.2', 264 => '11.2', 265 => '11.1' },
	'cmcontrast' => { 275 => 0x2022 },
	'cmexposurecompensation' => { 275 => 0x2000 },
	'cmhue' => { 275 => 0x2021 },
	'cmsaturation' => { 275 => 0x2020 },
	'cmsharpness' => { 275 => 0x2023 },
	'cmwhitebalance' => { 275 => 0x2001 },
	'cmwhitebalancecomp' => { 275 => 0x2002 },
	'cmwhitebalancegraypoint' => { 275 => 0x2010 },
	'codec' => { 156 => 'Codec' },
	'codedcharacterset' => { 122 => 0x5a },
	'collection' => { 280 => 'Collection' },
	'collectionname' => { 157 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 157 => 'Collections', 425 => 'collections' },
	'collectionuri' => { 157 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 444 => 'color' },
	'coloraberrationcontrol' => { 243 => 0xc89224b },
	'coloradjustment' => { 358 => 0x14 },
	'coloradjustmentmode' => { 357 => 0x210 },
	'coloranta' => { 460 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 460 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 460 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 460 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 460 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 460 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 460 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 460 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 460 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 460 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 460 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 460 => 'Colorants' },
	'colorantswatchname' => { 460 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 460 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 460 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 460 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 143 => 'ColorBalance' },
	'colorbalanceadj' => { 243 => 0x76a43202 },
	'colorbalanceblue' => { 167 => 0x1e },
	'colorbalancegreen' => { 167 => 0x1d },
	'colorbalancered' => { 167 => 0x1c },
	'colorbalanceversion' => { 188 => 0x0 },
	'colorblur' => { 103 => 0x65 },
	'colorbluron' => { 97 => 0x20704 },
	'colorbooster' => { 243 => 0x5f0e7d23 },
	'colorboostlevel' => { 237 => 0x1 },
	'colorboosttype' => { 237 => 0x0 },
	'colorclass' => { 333 => 0xde, 334 => 'ColorClass' },
	'colorcompensationfilter' => { 170 => [0x3a,0x5f], 172 => 0x111, 378 => 0xb022 },
	'colorcompensationfiltercustom' => { 366 => 0xd, 367 => 0xc },
	'colorcompensationfilterset' => { 366 => 0x8, 367 => 0x7, 368 => 0x18, 383 => 0xf },
	'colorcontrol' => { 272 => 0x102b },
	'colorcorrection' => { 411 => 0x8015 },
	'colorcreatoreffect' => { 267 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0 },
	'coloreffect' => { 288 => 0x28 },
	'colorfilter' => { 106 => 0x17, 107 => 0x3017, 167 => 0x29, 175 => [0x38,0x4d,0x4f], 329 => 0x17 },
	'colorgain' => { 211 => 0x51 },
	'colorhue' => { 97 => 0x20900, 204 => 0x8d },
	'colorimetricreference' => { 113 => 0xc6bf },
	'colorlabel' => { 434 => 'ColorLabel' },
	'colormatrix' => { 271 => 0x200, 272 => 0x1011, 355 => 0xa030 },
	'colormatrix1' => { 113 => 0xc621, 331 => 0x106 },
	'colormatrix2' => { 113 => 0xc622, 275 => 0x200, 331 => 0x226 },
	'colormatrixa' => { 322 => 0x203 },
	'colormatrixadobergb' => { 355 => 0xa032 },
	'colormatrixb' => { 322 => 0x204 },
	'colormatrixnumber' => { 272 => 0x1019 },
	'colormatrixsrgb' => { 355 => 0xa031 },
	'colormode' => { 107 => 0x3015, 118 => 0x1210, 129 => 0x66, 167 => 0x28, 170 => 0x16, 172 => 0x101, 173 => 0x36, 175 => 0x7, 204 => 0x3, 233 => 0x4, 288 => 0x32, 358 => 0x2c, 378 => 0xb029, 443 => 'ColorMode' },
	'colormoirereduction' => { 97 => 0x20670, 244 => 0x15 },
	'colormoirereductionmode' => { 244 => 0x5 },
	'colormoirereductionon' => { 97 => '0x20670.0' },
	'colornoisereduction' => { 411 => 0x8029, 431 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 431 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 244 => 0x18 },
	'colornoisereductionsharpness' => { 244 => 0x1c },
	'colornoisereductionsmoothness' => { 431 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 117 => 0x2 },
	'colorprofile' => { 167 => 0x33 },
	'colorprofilesettings' => { 267 => 0x539 },
	'colorrepresentation' => { 123 => 0x3c },
	'colorsaturationadj' => { 97 => 0x20305 },
	'colorsequence' => { 123 => 0x41 },
	'colorspace' => { 48 => 0x3, 60 => 0xb4, 91 => 0x10b4, 113 => 0xa001, 149 => 'ColorSpace', 168 => 0x2f, 169 => 0x25, 170 => 0x17, 204 => 0x1e, 267 => 0x507, 322 => 0x37, 355 => 0xa011, 358 => 0xb, 366 => 0x1b, 367 => 0x83, 368 => 0xe, 383 => 0x6, 435 => 'ColorSpace' },
	'colortempasshot' => { 37 => 0x4, 38 => 0x7, 39 => 0x1d, 40 => 0x26, 41 => 0x43, 44 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x4b },
	'colortempauto' => { 37 => 0x9, 38 => 0xf, 39 => 0x22, 40 => 0x1c, 41 => 0x48, 44 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x50 },
	'colortempcloudy' => { 37 => 0x22, 38 => 0x37, 39 => 0x31, 40 => 0x35, 41 => 0x5c, 44 => 0x75, 45 => 0x8e, 46 => 0x93, 47 => 0x96, 322 => 0x55 },
	'colortempcustom' => { 41 => 0x84 },
	'colortempcustom1' => { 39 => 0x45 },
	'colortempcustom2' => { 39 => 0x4a },
	'colortempdaylight' => { 37 => 0x18, 38 => 0x27, 39 => 0x27, 40 => 0x2b, 41 => 0x52, 44 => 0x6b, 45 => 0x84, 46 => 0x89, 47 => 0x8c, 322 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x135, 27 => 0x7b, 28 => 0x13a, 60 => 0xae, 70 => 0x9, 91 => 0x10ae, 118 => 0x1005, 127 => 0x846, 143 => 'ColorTemperature', 168 => [0x6e,0x49], 169 => 0x3f, 170 => [0x39,0x5e], 172 => 0x10b, 175 => [0x3c,0x4c,0x4e], 284 => 0x321, 322 => 0x50, 348 => 0x1308, 378 => 0xb021, 431 => 'Temperature' },
	'colortemperatureadj' => { 411 => 0x8013 },
	'colortemperatureauto' => { 204 => 0x4f },
	'colortemperaturebg' => { 272 => 0x1013 },
	'colortemperaturecustom' => { 366 => 0xc, 367 => 0xb },
	'colortemperaturerg' => { 272 => 0x1014 },
	'colortemperatureset' => { 366 => 0x7, 367 => 0x6 },
	'colortemperaturesetting' => { 170 => 0x25, 368 => 0x17, 383 => 0xe },
	'colortempflash' => { 37 => 0x36, 38 => 0x57, 39 => 0x40, 40 => 0x49, 41 => 0x70, 44 => 0x89, 45 => 0xa2, 46 => 0xa7, 47 => 0xaa, 322 => 0x5a },
	'colortempflashdata' => { 41 => 0x24a },
	'colortempfluorescent' => { 37 => 0x2c, 38 => 0x47, 39 => 0x3b, 40 => 0x3f, 41 => 0x66, 44 => 0x7f, 45 => 0x98, 46 => 0x9d, 47 => 0xa0 },
	'colortempfluorescentd' => { 322 => 0x57 },
	'colortempfluorescentn' => { 322 => 0x58 },
	'colortempfluorescentw' => { 322 => 0x59 },
	'colortempkelvin' => { 37 => 0x31, 38 => 0x4f, 40 => 0x44, 41 => 0x6b, 44 => 0x84, 45 => 0x9d, 46 => 0xa2, 47 => 0xa5, 288 => 0x44, 348 => 0x1307 },
	'colortempmeasured' => { 37 => 0xe, 38 => 0x17, 41 => 0x4d, 44 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x55 },
	'colortemppc1' => { 40 => 0x94, 41 => 0x75 },
	'colortemppc2' => { 40 => 0x99, 41 => 0x7a },
	'colortemppc3' => { 40 => 0x9e, 41 => 0x7f },
	'colortempshade' => { 37 => 0x1d, 38 => 0x2f, 39 => 0x2c, 40 => 0x30, 41 => 0x57, 44 => 0x70, 45 => 0x89, 46 => 0x8e, 47 => 0x91, 322 => 0x54 },
	'colortemptungsten' => { 37 => 0x27, 38 => 0x3f, 39 => 0x36, 40 => 0x3a, 41 => 0x61, 44 => 0x7a, 45 => 0x93, 46 => 0x98, 47 => 0x9b, 322 => 0x56 },
	'colortempunknown' => { 37 => 0x13, 38 => 0x1f, 40 => 0x21, 44 => 0x52, 45 => 0x52, 46 => 0x52, 47 => 0x5a },
	'colortempunknown10' => { 37 => 0x63, 38 => 0x9f, 40 => 0x76, 44 => 0xa2, 45 => 0x7f, 46 => 0x7f, 47 => 0x87 },
	'colortempunknown11' => { 37 => 0x68, 38 => 0xa7, 40 => 0x7b, 44 => 0xa7, 45 => 0xa7, 46 => 0x84, 47 => 0xaf },
	'colortempunknown12' => { 37 => 0x6d, 38 => 0xaf, 40 => 0x80, 44 => 0xac, 45 => 0xac, 46 => 0xac, 47 => 0xb4 },
	'colortempunknown13' => { 37 => 0x72, 38 => 0xb7, 40 => 0x85, 44 => 0xb1, 45 => 0xb1, 46 => 0xb1, 47 => 0xb9 },
	'colortempunknown14' => { 40 => 0x8a, 44 => 0xb6, 45 => 0xb6, 46 => 0xb6, 47 => 0xbe },
	'colortempunknown15' => { 40 => 0x8f, 44 => 0xbb, 45 => 0xbb, 46 => 0xbb, 47 => 0xc3 },
	'colortempunknown16' => { 40 => 0xa3, 45 => 0xc0, 46 => 0xc0, 47 => 0xc8 },
	'colortempunknown17' => { 45 => 0xc5, 46 => 0xc5, 47 => 0xcd },
	'colortempunknown18' => { 45 => 0xca, 46 => 0xca, 47 => 0xd2 },
	'colortempunknown19' => { 45 => 0xcf, 46 => 0xcf, 47 => 0xd7 },
	'colortempunknown2' => { 37 => 0x3b, 38 => 0x5f, 40 => 0x4e, 44 => 0x57, 45 => 0x57, 46 => 0x57, 47 => 0x5f },
	'colortempunknown20' => { 45 => 0xd4, 46 => 0xd4, 47 => 0xdc },
	'colortempunknown21' => { 46 => 0xd9, 47 => 0xe1 },
	'colortempunknown22' => { 46 => 0xde, 47 => 0xe6 },
	'colortempunknown23' => { 46 => 0xe3, 47 => 0xeb },
	'colortempunknown24' => { 46 => 0xe8, 47 => 0xf0 },
	'colortempunknown25' => { 46 => 0xed, 47 => 0xf5 },
	'colortempunknown26' => { 46 => 0xf2, 47 => 0xfa },
	'colortempunknown27' => { 46 => 0xf7, 47 => 0xff },
	'colortempunknown28' => { 46 => 0xfc, 47 => 0x104 },
	'colortempunknown29' => { 46 => 0x101, 47 => 0x109 },
	'colortempunknown3' => { 37 => 0x40, 38 => 0x67, 40 => 0x53, 44 => 0x5c, 45 => 0x5c, 46 => 0x5c, 47 => 0x64 },
	'colortempunknown30' => { 46 => 0x106 },
	'colortempunknown4' => { 37 => 0x45, 38 => 0x6f, 40 => 0x58, 44 => 0x61, 45 => 0x61, 46 => 0x61, 47 => 0x69 },
	'colortempunknown5' => { 37 => 0x4a, 38 => 0x77, 40 => 0x5d, 44 => 0x66, 45 => 0x66, 46 => 0x66, 47 => 0x6e },
	'colortempunknown6' => { 37 => 0x4f, 38 => 0x7f, 40 => 0x62, 44 => 0x8e, 45 => 0x6b, 46 => 0x6b, 47 => 0x73 },
	'colortempunknown7' => { 37 => 0x54, 38 => 0x87, 40 => 0x67, 44 => 0x93, 45 => 0x70, 46 => 0x70, 47 => 0x78 },
	'colortempunknown8' => { 37 => 0x59, 38 => 0x8f, 40 => 0x6c, 44 => 0x98, 45 => 0x75, 46 => 0x75, 47 => 0x7d },
	'colortempunknown9' => { 37 => 0x5e, 38 => 0x97, 40 => 0x71, 44 => 0x9d, 45 => 0x7a, 46 => 0x7a, 47 => 0x82 },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 33 => 0x2a, 48 => 0x2 },
	'colortoneadj' => { 97 => 0x20304, 102 => 0x11e },
	'colortoneauto' => { 67 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 66 => 0x6c, 67 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 66 => 0x3c, 67 => 0x3c },
	'colortonemonochrome' => { 66 => 0x84, 67 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 66 => 0x54, 67 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 66 => 0x24, 67 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 66 => 0xc, 67 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 66 => 0x9c, 67 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 66 => 0xb4, 67 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 66 => 0xcc, 67 => 0xe4 },
	'commanddials' => { 261 => '5.1' },
	'commanddialsaperturesetting' => { 250 => '17.3', 251 => '18.3', 253 => '18.3', 254 => '18.3', 259 => '33.3', 260 => '17.3', 263 => '18.3', 264 => '18.3' },
	'commanddialschangemainsub' => { 250 => '17.2', 251 => '18.1', 253 => '18.1', 254 => '18.1', 259 => '33.2', 260 => '17.2', 263 => '18.1', 264 => '18.1' },
	'commanddialsmenuandplayback' => { 250 => '17.4', 251 => '18.2', 253 => '18.2', 254 => '18.2', 259 => '33.4', 260 => '17.4', 263 => '18.2', 264 => '18.2' },
	'commanddialsreverserotation' => { 250 => '17.1', 251 => '6.4', 253 => '6.2', 254 => '6.2', 255 => '16.2', 256 => '17.2', 259 => '33.1', 260 => '17.1', 263 => '6.2', 264 => '6.2', 265 => '18.1' },
	'commanderchannel' => { 261 => '10.2', 262 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 261 => '13.1', 262 => '31.1' },
	'commandergroupa_ttlcomp' => { 265 => '32.1' },
	'commandergroupamanualoutput' => { 261 => '13.2', 262 => '28.2' },
	'commandergroupamode' => { 261 => '11.2', 262 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 261 => '14.1', 262 => '32.1' },
	'commandergroupb_ttlcomp' => { 265 => '33.1' },
	'commandergroupbmanualoutput' => { 261 => '14.2', 262 => '29.2' },
	'commandergroupbmode' => { 261 => '11.3', 262 => '29.1' },
	'commanderinternalflash' => { 261 => '11.1', 262 => '27.1' },
	'commanderinternalmanualoutput' => { 261 => '12.2', 262 => '27.2' },
	'commanderinternalttlchannel' => { 259 => '18.2' },
	'commanderinternalttlcomp' => { 261 => '12.1', 262 => '30.2', 265 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 259 => '20.1', 260 => '26.1' },
	'commanderinternalttlcompgroupa' => { 259 => '21.1', 260 => '27.1' },
	'commanderinternalttlcompgroupb' => { 259 => '22.1', 260 => '28.1' },
	'comment' => { 0 => 0x2, 114 => 'Comment', 144 => 'Comment', 280 => 'Comment' },
	'compass' => { 351 => 0x4 },
	'complianceprofile' => { 445 => 'complianceProfile' },
	'componentsconfiguration' => { 113 => 0x9101, 149 => 'Components', 435 => 'ComponentsConfiguration' },
	'componentversion' => { 91 => 0x80c },
	'composer' => { 455 => 'composer' },
	'composition' => { 421 => 'Composition' },
	'compositionadjust' => { 321 => '0.1' },
	'compositionadjustrotation' => { 321 => 0x7 },
	'compositionadjustx' => { 321 => 0x5 },
	'compositionadjusty' => { 321 => 0x6 },
	'compressedbitsperpixel' => { 113 => 0x9102, 435 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 172 => 0x40, 272 => 0x40 },
	'compression' => { 113 => 0x103, 292 => 0xb, 451 => 'Compression' },
	'compressionfactor' => { 267 => 0x50d },
	'compressionratio' => { 149 => 'Compression', 272 => 0x1034 },
	'confidence' => { 416 => 'Confidence' },
	'confidencelevel' => { 426 => 'ConfidenceLevel' },
	'confidencemime' => { 416 => 'ConfidenceMime' },
	'constrainedcropheight' => { 102 => 0x266, 333 => 0xd6 },
	'constrainedcropwidth' => { 102 => 0x262, 333 => 0xd5 },
	'contact' => { 121 => 0x76 },
	'contactinfo' => { 444 => 'contactInfo' },
	'containerformat' => { 441 => 'ContainerFormat' },
	'containerformatidentifier' => { 441 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 441 => [\'ContainerFormat','ContainerFormatName'] },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 121 => 0x1a },
	'contentlocationname' => { 121 => 0x1b },
	'contenttype' => { 445 => 'contentType' },
	'continuousbracketing' => { 170 => 0x20 },
	'continuousdrive' => { 33 => 0x5 },
	'continuousmodeliveview' => { 264 => '77.2' },
	'continuousshootingspeed' => { 78 => 0x610 },
	'continuousshotlimit' => { 78 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 33 => 0xd, 106 => 0xc, 107 => [0x3012,0x20], 113 => [0xa408,0xfe54], 118 => [0x1004,0x1006], 143 => 'Contrast', 163 => 'Contrast', 167 => 0x20, 168 => 0x31, 169 => 0x27, 170 => 0x19, 175 => 0x2, 206 => 0x33, 207 => 0x37, 272 => 0x1029, 288 => 0x39, 290 => 0x300a, 322 => 0x20, 329 => 0xc, 343 => 0x24, 348 => 0x1012, 358 => 0xd, 366 => 0x1d, 367 => 0x1a, 378 => 0x2004, 431 => 'Contrast', 435 => 'Contrast' },
	'contrast2012' => { 431 => 'Contrast2012' },
	'contrastadj' => { 97 => 0x20303, 102 => 0x115, 246 => 0x2c, 411 => 0x8017 },
	'contrastauto' => { 67 => 0x90 },
	'contrastcurve' => { 204 => 0x8c },
	'contrastdetectaf' => { 179 => 0x4 },
	'contrastdetectafarea' => { 322 => 0x231 },
	'contrastdetectafinfocus' => { 179 => [0x1c,0x52] },
	'contrastfaithful' => { 18 => 0xec, 66 => 0x60, 67 => 0x60 },
	'contrasthighlight' => { 322 => 0x6d },
	'contrasthighlightshadowadj' => { 322 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 66 => 0x30, 67 => 0x30 },
	'contrastmode' => { 288 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 66 => 0x78, 67 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 66 => 0x48, 67 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 66 => 0x18, 67 => 0x18 },
	'contrastsetting' => { 267 => 0x505, 275 => 0x1012, 368 => 0x10, 383 => 0x8 },
	'contrastshadow' => { 322 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 66 => 0x0, 67 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 66 => 0x90, 67 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 66 => 0xa8, 67 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 66 => 0xc0, 67 => 0xd8 },
	'contributedmedia' => { 455 => 'contributedMedia' },
	'contributedmediaduration' => { 455 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 455 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 455 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 455 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 455 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 455 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 455 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 455 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 455 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 455 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 432 => 'contributor', 441 => 'Contributor' },
	'contributoridentifier' => { 441 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 441 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 441 => [\'Contributor','ContributorRole'] },
	'contributors' => { 144 => 'Contributors' },
	'controldialset' => { 170 => 0x46 },
	'controlledvocabularyterm' => { 441 => 'CVterm' },
	'controllerboardversion' => { 284 => 0x332 },
	'controlmode' => { 72 => 0x12 },
	'conversionlens' => { 268 => 0x403, 288 => 0x35 },
	'converter' => { 113 => 0xfe4d, 233 => 0xb, 431 => 'Converter' },
	'converttograyscale' => { 431 => 'ConvertToGrayscale' },
	'cookingequipment' => { 447 => 'cookingEquipment' },
	'cookingmethod' => { 447 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 113 => 0x8298, 144 => 'Copyright', 280 => 'Copyright', 322 => 0x22f, 338 => 'Copyright', 442 => 'Copyright', 448 => 'copyright', 451 => 'Copyright', 455 => 'copyright' },
	'copyrightflag' => { 336 => 0x40a },
	'copyrightnotice' => { 121 => 0x74 },
	'copyrightowner' => { 277 => 'CopyrightOwner' },
	'copyrightownerid' => { 277 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 277 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 277 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 277 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 277 => 'CopyrightStatus' },
	'copyrightyear' => { 441 => 'CopyrightYear', 445 => 'copyrightYear' },
	'coringfilter' => { 271 => 0x310, 272 => 0x102d, 275 => 0x310 },
	'coringvalues' => { 271 => 0x311, 275 => 0x311 },
	'corporateentity' => { 445 => 'corporateEntity' },
	'country' => { 148 => 'Country', 288 => 0x69, 443 => 'Country' },
	'country-primarylocationcode' => { 121 => 0x64 },
	'country-primarylocationname' => { 121 => 0x65 },
	'countrycode' => { 203 => 0x5, 334 => 'CountryCode', 440 => 'CountryCode' },
	'course' => { 447 => 'course' },
	'coverage' => { 432 => 'coverage' },
	'coverdate' => { 445 => 'coverDate' },
	'coverdisplaydate' => { 445 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 322 => 0x28 },
	'crc32' => { 433 => 'crc32' },
	'createdate' => { 113 => 0x9004, 144 => 'CreateDate', 276 => 'CreationDate', 280 => 'create-date', 338 => 'CreationDate', 340 => 0x1, 453 => 'CreateDate' },
	'creationdate' => { 442 => 'CreationDate', 445 => 'creationDate' },
	'creationtime' => { 280 => 'Creation Time' },
	'creativestyle' => { 366 => 0x1a, 367 => 0x18, 377 => 0x41, 378 => 0xb020, 407 => 0x4a },
	'creativestylesetting' => { 368 => 0xf, 383 => 0x7 },
	'creativestylewaschanged' => { 411 => 0x8001 },
	'creator' => { 276 => 'Creator', 338 => 'Creator', 432 => 'creator', 441 => 'Creator', 442 => 'Creator' },
	'creatoraddress' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 165 => 'CreatorAppId' },
	'creatorcity' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 440 => 'CreatorContactInfo' },
	'creatorcountry' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 441 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 441 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 165 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 441 => [\'Creator','CreatorRole'] },
	'creatortool' => { 453 => 'CreatorTool' },
	'creatorworkemail' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 440 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 121 => 0x6e, 443 => 'Credit' },
	'creditline' => { 448 => 'creditLine' },
	'creditlinereq' => { 458 => 'CreditLineReq' },
	'creditlinerequired' => { 277 => 'CreditLineRequired' },
	'cropactive' => { 95 => 0x0, 102 => 0x244 },
	'cropangle' => { 431 => 'CropAngle' },
	'cropaspectratio' => { 97 => 0x30101, 102 => 0x260 },
	'cropaspectratiocustom' => { 97 => 0x30102 },
	'cropbottom' => { 117 => 0x9, 238 => 0x36, 292 => 0x31, 333 => 0xdc, 431 => 'CropBottom' },
	'cropbottommargin' => { 50 => 0x3 },
	'cropcircleactive' => { 103 => 0xd6 },
	'cropcircleradius' => { 103 => 0xd9 },
	'cropcirclex' => { 103 => 0xd7 },
	'cropcircley' => { 103 => 0xd8 },
	'cropconstraintowarp' => { 431 => 'CropConstrainToWarp' },
	'croph' => { 424 => 'CropH' },
	'cropheight' => { 95 => 0x6, 102 => 0x24c, 271 => 0x615, 275 => 0x615, 431 => 'CropHeight' },
	'crophispeed' => { 204 => 0x1b },
	'cropleft' => { 102 => 0x246, 117 => 0x6, 238 => 0x1e, 271 => 0x612, 275 => 0x612, 292 => 0x30, 333 => 0xd9, 431 => 'CropLeft' },
	'cropleftmargin' => { 50 => 0x0 },
	'cropmode35mm' => { 348 => 0x1018 },
	'croporiginalheight' => { 95 => 0xb },
	'croporiginalwidth' => { 95 => 0xa },
	'cropoutputheight' => { 238 => 0xce },
	'cropoutputheightinches' => { 238 => 0x96 },
	'cropoutputpixels' => { 238 => 0xd6 },
	'cropoutputresolution' => { 238 => 0xb6 },
	'cropoutputscale' => { 238 => 0xbe },
	'cropoutputwidth' => { 238 => 0xc6 },
	'cropoutputwidthinches' => { 238 => 0x8e },
	'croppedareaimageheightpixels' => { 419 => 'CroppedAreaImageHeightPixels', 420 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 419 => 'CroppedAreaImageWidthPixels', 420 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 419 => 'CroppedAreaLeftPixels', 420 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 419 => 'CroppedAreaTopPixels', 420 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 348 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 348 => 0x1603 },
	'cropright' => { 117 => 0x8, 238 => 0x2e, 292 => 0x32, 333 => 0xdb, 431 => 'CropRight' },
	'croprightmargin' => { 50 => 0x1 },
	'croprotatedoriginalheight' => { 95 => 0x2 },
	'croprotatedoriginalwidth' => { 95 => 0x1 },
	'croprotation' => { 95 => 0x8, 117 => 0xb },
	'cropscaledresolution' => { 238 => 0x9e },
	'cropsourceresolution' => { 238 => 0xae },
	'croptop' => { 102 => 0x248, 117 => 0x7, 238 => 0x26, 271 => 0x613, 275 => 0x613, 292 => 0x2f, 333 => 0xda, 431 => 'CropTop' },
	'croptopmargin' => { 50 => 0x2 },
	'cropunit' => { 431 => 'CropUnit' },
	'cropunits' => { 431 => 'CropUnits' },
	'cropw' => { 424 => 'CropW' },
	'cropwidth' => { 95 => 0x5, 102 => 0x24a, 271 => 0x614, 275 => 0x614, 431 => 'CropWidth' },
	'cropx' => { 95 => 0x3, 424 => 'CropX' },
	'cropy' => { 95 => 0x4, 424 => 'CropY' },
	'crossprocess' => { 322 => 0x7b },
	'crossprocessparams' => { 322 => 0x235 },
	'cuisine' => { 447 => 'cuisine' },
	'currenticcprofile' => { 113 => 0xc691 },
	'currentpreprofilematrix' => { 113 => 0xc692 },
	'currentversion' => { 411 => 0xd000 },
	'curve0x' => { 424 => 'Curve0x' },
	'curve0y' => { 424 => 'Curve0y' },
	'curve1x' => { 424 => 'Curve1x' },
	'curve1y' => { 424 => 'Curve1y' },
	'curve2x' => { 424 => 'Curve2x' },
	'curve2y' => { 424 => 'Curve2y' },
	'curve3x' => { 424 => 'Curve3x' },
	'curve3y' => { 424 => 'Curve3y' },
	'curve4x' => { 424 => 'Curve4x' },
	'curve4y' => { 424 => 'Curve4y' },
	'curves' => { 243 => 0x76a43201 },
	'custom1' => { 277 => 'Custom1' },
	'custom10' => { 277 => 'Custom10' },
	'custom2' => { 277 => 'Custom2' },
	'custom3' => { 277 => 'Custom3' },
	'custom4' => { 277 => 'Custom4' },
	'custom5' => { 277 => 'Custom5' },
	'custom6' => { 277 => 'Custom6' },
	'custom7' => { 277 => 'Custom7' },
	'custom8' => { 277 => 'Custom8' },
	'custom9' => { 277 => 'Custom9' },
	'customcolortone' => { 103 => 0x4c },
	'customcontrast' => { 103 => 0x4e },
	'customcontrols' => { 78 => 0x70c },
	'customdefaultunsharpfineness' => { 103 => 0xbe },
	'customdefaultunsharpstrength' => { 103 => 0xbc },
	'customdefaultunsharpthreshold' => { 103 => 0xc0 },
	'customlinear' => { 103 => 0x4f },
	'customoutputhighlightpoint' => { 103 => 0x53 },
	'customoutputshadowpoint' => { 103 => 0x54 },
	'custompicturestyle' => { 97 => 0x10021 },
	'custompicturestyledata' => { 97 => 0xf0500 },
	'custompicturestylefilename' => { 60 => 0x4010 },
	'customrawhighlight' => { 103 => 0x7c },
	'customrawhighlightpoint' => { 103 => 0x51 },
	'customrawshadow' => { 103 => 0x85 },
	'customrawshadowpoint' => { 103 => 0x52 },
	'customrendered' => { 113 => 0xa401, 435 => 'CustomRendered' },
	'customsaturation' => { 103 => 0x4d, 267 => 0x503 },
	'customsettingsalldefault' => { 250 => '0.2', 259 => '0.2' },
	'customsettingsbank' => { 250 => '0.1', 251 => '0.1', 253 => '0.1', 254 => '0.1', 259 => '0.1', 263 => '0.2', 264 => '0.2' },
	'customsharpness' => { 103 => 0x50 },
	'customunsharpmaskfineness' => { 103 => 0xb8 },
	'customunsharpmaskstrength' => { 103 => 0xb6 },
	'customunsharpmaskthreshold' => { 103 => 0xba },
	'customwb_rblevels' => { 383 => 0x1a },
	'customwb_rgblevels' => { 367 => 0x8, 368 => 0x19 },
	'customwbbluelevel' => { 170 => 0x36 },
	'customwberror' => { 170 => 0x37 },
	'customwbgreenlevel' => { 170 => 0x35 },
	'customwbredlevel' => { 170 => 0x34 },
	'customwbsetting' => { 170 => 0x26 },
	'd-lightinghq' => { 243 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 239 => 0x2 },
	'd-lightinghqhighlight' => { 239 => 0x1 },
	'd-lightinghqselected' => { 243 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 239 => 0x0 },
	'd-lightinghs' => { 243 => 0xce5554aa },
	'd-lightinghsadjustment' => { 240 => 0x0 },
	'd-lightinghscolorboost' => { 240 => 0x1 },
	'd-rangeoptimizerhighlight' => { 411 => 0x8024 },
	'd-rangeoptimizermode' => { 411 => 0x8022 },
	'd-rangeoptimizershadow' => { 411 => 0x802d },
	'd-rangeoptimizervalue' => { 411 => 0x8023 },
	'd810meteringmode' => { 230 => 0x175e },
	'data' => { 416 => 'Data' },
	'datacompressionmethod' => { 123 => 0x6e },
	'dataimprint' => { 167 => 0x34 },
	'dataonscreen' => { 441 => 'DataOnScreen' },
	'dataonscreenregion' => { 441 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 441 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 441 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 441 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 441 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 441 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 441 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 441 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 322 => 0x3d },
	'date' => { 322 => 0x6, 432 => 'date' },
	'dateacquired' => { 165 => 'DateAcquired' },
	'datecreated' => { 121 => 0x37, 443 => 'DateCreated' },
	'datedisplayformat' => { 235 => 0x3 },
	'dateidentified' => { 112 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 255 => '4.2' },
	'daterecieved' => { 445 => 'dateRecieved' },
	'datesent' => { 122 => 0x46 },
	'datestampmode' => { 60 => 0x1c },
	'datetime' => { 425 => 'datetime', 451 => 'DateTime' },
	'datetimedigitized' => { 435 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 94 => 0x0, 113 => 0x9003, 141 => 0x14, 144 => 'OriginalDate', 343 => 0xb, 344 => 0x3b, 435 => 'DateTimeOriginal' },
	'datetimestamp' => { 129 => 0x64 },
	'datetimeutc' => { 267 => 0x908 },
	'daylightsavings' => { 73 => 0x3, 235 => 0x2 },
	'dayofweek' => { 344 => 0x42 },
	'dccontinent' => { 112 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 112 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 112 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 112 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 112 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 112 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 112 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 112 => 'Event' },
	'dcfootprintspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 112 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 112 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 112 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 112 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 112 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 112 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 112 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 112 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 112 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 112 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 112 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 112 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 112 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 112 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 112 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 112 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 112 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 112 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 152 => 'Declination' },
	'decposition' => { 167 => 0x32 },
	'defaultautogray' => { 431 => 'DefaultAutoGray' },
	'defaultautotone' => { 431 => 'DefaultAutoTone' },
	'defaultblackrender' => { 113 => 0xc7a6 },
	'defaultcroporigin' => { 113 => 0xc61f },
	'defaultcropsize' => { 113 => 0xc620 },
	'defaulteraseoption' => { 78 => 0x813 },
	'defaultscale' => { 113 => 0xc61e },
	'defaultsspecifictoiso' => { 431 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 431 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 113 => 0xc7b5 },
	'defringe' => { 431 => 'Defringe' },
	'defringegreenamount' => { 431 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 431 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 431 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 431 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 431 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 431 => 'DefringePurpleHueLo' },
	'dehaze' => { 431 => 'Dehaze' },
	'deletedimagecount' => { 204 => 0xa6, 212 => 0x6e },
	'deprecatedon' => { 428 => 'deprecatedOn' },
	'derivedfrom' => { 456 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 456 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 456 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 456 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 456 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 456 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 456 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 456 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 456 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 456 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 456 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 456 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 456 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 456 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 456 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 456 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 456 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 456 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 456 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 456 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 456 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 456 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 456 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 456 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 280 => 'Description', 432 => 'description', 453 => 'Description' },
	'destination' => { 122 => 0x5 },
	'destinationcity' => { 322 => 0x24, 328 => 0x3 },
	'destinationcitycode' => { 329 => 0x1001 },
	'destinationdst' => { 322 => 0x26, 328 => '0.3' },
	'developmentdynamicrange' => { 118 => 0x1403 },
	'device' => { 445 => 'device' },
	'devicesettingdescription' => { 435 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 435 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 435 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 435 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 355 => 0x2 },
	'dialdirectiontvav' => { 78 => 0x706 },
	'dietaryneeds' => { 447 => 'dietaryNeeds' },
	'diffractioncorrection' => { 312 => 0x3 },
	'diffractioncorrectionon' => { 97 => 0x2070b },
	'digitalcreationdate' => { 121 => 0x3e },
	'digitalcreationtime' => { 121 => 0x3f },
	'digitaldeehighlightadj' => { 211 => 0x202 },
	'digitaldeeshadowadj' => { 211 => 0x200 },
	'digitaldeethreshold' => { 211 => 0x201 },
	'digitalfilter' => { 358 => 0x59 },
	'digitalfilter01' => { 309 => 0x5 },
	'digitalfilter02' => { 309 => 0x16 },
	'digitalfilter03' => { 309 => 0x27 },
	'digitalfilter04' => { 309 => 0x38 },
	'digitalfilter05' => { 309 => 0x49 },
	'digitalfilter06' => { 309 => 0x5a },
	'digitalfilter07' => { 309 => 0x6b },
	'digitalfilter08' => { 309 => 0x7c },
	'digitalfilter09' => { 309 => 0x8d },
	'digitalfilter10' => { 309 => 0x9e },
	'digitalfilter11' => { 309 => 0xaf },
	'digitalfilter12' => { 309 => 0xc0 },
	'digitalfilter13' => { 309 => 0xd1 },
	'digitalfilter14' => { 309 => 0xe2 },
	'digitalfilter15' => { 309 => 0xf3 },
	'digitalfilter16' => { 309 => 0x104 },
	'digitalfilter17' => { 309 => 0x115 },
	'digitalfilter18' => { 309 => 0x126 },
	'digitalfilter19' => { 309 => 0x137 },
	'digitalfilter20' => { 309 => 0x148 },
	'digitalgain' => { 70 => 0xb },
	'digitalgem' => { 196 => 0x0 },
	'digitalice' => { 211 => 0x100 },
	'digitalimageguid' => { 441 => 'DigImageGUID' },
	'digitalroc' => { 209 => 0x0 },
	'digitalsourcefiletype' => { 441 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 441 => 'DigitalSourceType' },
	'digitalzoom' => { 33 => 0xc, 106 => 0xa, 118 => 0x1044, 129 => 0x68, 143 => 'DigitalZoom', 167 => 0xc, 204 => 0x86, 233 => 0xa, 272 => 0x204, 322 => 0x1e, 329 => 0xa, 357 => 0x204, 398 => 0x12, 399 => 0x12 },
	'digitalzoomon' => { 357 => 0x21b },
	'digitalzoomratio' => { 113 => 0xa404, 388 => 0x200, 390 => 0x21c, 435 => 'DigitalZoomRatio' },
	'director' => { 455 => 'director' },
	'directorphotography' => { 455 => 'directorPhotography' },
	'directory' => { 114 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 27 => 0x1f7, 28 => 0x4ba },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 191 => 0x3 },
	'disclaimer' => { 280 => 'Disclaimer' },
	'discnumber' => { 455 => 'discNumber' },
	'dishtype' => { 447 => 'dishType' },
	'displayallafpoints' => { 78 => 0x514 },
	'displayaperture' => { 33 => 0x23 },
	'displayedunitsx' => { 337 => 0x2 },
	'displayedunitsy' => { 337 => 0x6 },
	'displayname' => { 444 => 'displayName' },
	'distance1' => { 129 => 0x28 },
	'distance2' => { 129 => 0x2c },
	'distance3' => { 129 => 0x30 },
	'distance4' => { 129 => 0x34 },
	'distortion' => { 355 => 0xa050 },
	'distortioncontrol' => { 212 => 0x10 },
	'distortioncorrection' => { 97 => 0x20705, 103 => 0x67, 267 => 0x50b, 291 => '7.1', 312 => 0x0, 406 => 0x601, 407 => 0x5b },
	'distortioncorrection2' => { 271 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 427 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 97 => '0x20705.0', 103 => 0x63 },
	'distortioncorrectionsetting' => { 378 => 0x2013 },
	'distortioncorrparams' => { 113 => 0x7037, 387 => 0x1a23, 390 => 0x1870, 392 => 0x189c, 393 => 0x18cc, 394 => 0x17d0, 406 => 0x6ca, 407 => 0x64 },
	'distortioncorrparamsnumber' => { 390 => 0x1899, 392 => 0x18c5, 393 => 0x18f5, 394 => 0x17f9 },
	'distortioncorrparamspresent' => { 390 => 0x1898, 392 => 0x18c4, 393 => 0x18f4, 394 => 0x17f8, 396 => 0x10b, 397 => 0x10b, 406 => 0x600, 407 => 0x5a },
	'distortioneffect' => { 97 => 0x20709 },
	'distortionn' => { 291 => 0xc },
	'distortionparam02' => { 291 => 0x2 },
	'distortionparam04' => { 291 => 0x4 },
	'distortionparam08' => { 291 => 0x8 },
	'distortionparam09' => { 291 => 0x9 },
	'distortionparam11' => { 291 => 0xb },
	'distortionscale' => { 291 => 0x5 },
	'distributor' => { 445 => 'distributor' },
	'distributorproductid' => { 444 => 'distributorProductID' },
	'dloon' => { 97 => '0x20706.0', 103 => 0xdc },
	'dlosetting' => { 97 => 0x20706, 103 => 0xdd },
	'dlosettingapplied' => { 96 => 0x4 },
	'dloshootingdistance' => { 103 => 0xde },
	'dloversion' => { 96 => 0x5 },
	'dmcomment' => { 455 => 'comment' },
	'dngadobedata' => { 113 => 0xc634 },
	'dngbackwardversion' => { 113 => 0xc613 },
	'dngignoresidecars' => { 431 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 113 => 0xc630 },
	'dngprivatedata' => { 113 => 0xc634 },
	'dngversion' => { 113 => 0xc612 },
	'document' => { 280 => 'Document' },
	'documentancestors' => { 443 => 'DocumentAncestors' },
	'documenthistory' => { 121 => 0xe7 },
	'documentid' => { 456 => 'DocumentID' },
	'documentname' => { 113 => 0x10d },
	'documentnotes' => { 121 => 0xe6 },
	'doi' => { 445 => 'doi' },
	'dopesheet' => { 441 => 'Dopesheet' },
	'dopesheetlink' => { 441 => 'DopesheetLink' },
	'dopesheetlinklink' => { 441 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 441 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'dpp' => { 425 => 'dpp' },
	'dr4cameramodel' => { 98 => 0x3 },
	'drivemode' => { 107 => 0x3103, 167 => 0x6, 170 => 0x1e, 173 => 0xe, 267 => 0x600, 322 => 0x34, 348 => 0x1002, 358 => 0x3, 366 => 0x4, 367 => 0x7e, 368 => 0x34 },
	'drivemode2' => { 170 => 0xa, 303 => 0x7, 377 => 0xe, 383 => 0x1 },
	'drivemodesetting' => { 368 => 0x4 },
	'dspfirmwareversion' => { 322 => 0x27 },
	'duration' => { 63 => 0x6a, 142 => 'Duration', 156 => 'Duration', 447 => 'duration', 455 => 'duration' },
	'durationscale' => { 455 => [\'duration','durationScale'] },
	'durationvalue' => { 455 => [\'duration','durationValue'] },
	'dustremovaldata' => { 60 => 0x97 },
	'dynamicafarea' => { 250 => '1.4', 259 => '1.4' },
	'dynamicareaafdisplay' => { 251 => '46.1', 253 => '47.1', 254 => '47.1', 263 => '47.1', 264 => '47.1' },
	'dynamicrange' => { 118 => 0x1400 },
	'dynamicrangeexpansion' => { 322 => 0x69, 348 => 0x100e },
	'dynamicrangemax' => { 102 => 0x7c },
	'dynamicrangemin' => { 102 => 0x7a },
	'dynamicrangeoptimizer' => { 170 => 0x15, 378 => [0xb025,0xb04f], 386 => 0x1144, 387 => [0x1144,0x324], 388 => [0x1120,0x300], 389 => [0x119c,0x37c], 390 => [0x1178,0x328], 391 => [0x1030,0x50], 392 => [0x228,0x50], 393 => [0x228,0x50], 394 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 377 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 366 => 0x19, 367 => 0x17, 368 => 0xd, 377 => 0x79, 383 => 0x5 },
	'dynamicrangeoptimizermode' => { 173 => 0x15, 366 => 0x18, 367 => 0x16, 377 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 170 => 0x27, 368 => 0xc, 383 => 0x4 },
	'dynamicrangesetting' => { 118 => 0x1402 },
	'e-dialinprogram' => { 303 => '1.3' },
	'earliestageorloweststage' => { 112 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 112 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 265 => '6.1' },
	'easyexposurecompensation' => { 250 => '6.4', 251 => '6.5', 253 => '6.3', 254 => '6.3', 258 => '5.1', 259 => '4.4', 260 => '5.2', 263 => '6.3', 264 => '6.3' },
	'easymode' => { 33 => 0xb },
	'edgenoisereduction' => { 244 => 0x4, 411 => 0x8028 },
	'edition' => { 445 => 'edition' },
	'editorialupdate' => { 121 => 0x8 },
	'editstatus' => { 121 => 0x7, 334 => 'EditStatus', 425 => 'EditStatus' },
	'editversionname' => { 243 => 0x3d136244 },
	'effectivelv' => { 322 => 0x2d },
	'effectivemaxaperture' => { 200 => 0x12, 201 => 0x13 },
	'eissn' => { 445 => 'eIssn' },
	'electronicfront-curtainshutter' => { 253 => '5.2', 254 => '5.2', 263 => '5.3', 264 => '5.2' },
	'electronicfrontcurtainshutter' => { 378 => 0x201a },
	'elevation' => { 152 => 'Elevation' },
	'email' => { 144 => 'EMail' },
	'embargodate' => { 448 => 'embargoDate' },
	'embdencrightsexpr' => { 441 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 441 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 441 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 441 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 443 => 'EmbeddedXMPDigest' },
	'emissivity' => { 115 => 0x3 },
	'encryptionkey' => { 355 => 0xa020 },
	'endingpage' => { 445 => 'endingPage' },
	'enduser' => { 277 => 'EndUser' },
	'enduserid' => { 277 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 277 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 455 => 'engineer' },
	'enhancedarktones' => { 236 => 0x8 },
	'enhancement' => { 106 => 0x16, 107 => 0x3016 },
	'enhancer' => { 271 => 0x300 },
	'enhancervalues' => { 271 => 0x301 },
	'envelopenumber' => { 122 => 0x28 },
	'envelopepriority' => { 122 => 0x3c },
	'enveloperecordversion' => { 122 => 0x0 },
	'episode' => { 441 => 'Episode' },
	'episodeidentifier' => { 441 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 441 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 441 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 272 => 0x20c },
	'epsonimagewidth' => { 272 => 0x20b },
	'epsonsoftware' => { 272 => 0x20d },
	'equipmentinstitution' => { 413 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 413 => 'EquipmentManufacturer' },
	'equipmentversion' => { 268 => 0x0 },
	'ettlii' => { 78 => 0x304, 79 => 0xd, 80 => 0xe, 81 => 0x7, 82 => 0x7, 83 => 0xe },
	'event' => { 414 => 'Event', 423 => 'Event', 441 => 'Event', 445 => 'event' },
	'eventalias' => { 444 => 'eventAlias' },
	'eventday' => { 112 => [\'Event','EventDay'] },
	'eventearliestdate' => { 112 => [\'Event','EventEarliestDate'] },
	'eventend' => { 444 => 'eventEnd' },
	'eventenddayofyear' => { 112 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 112 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 112 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 112 => [\'Event','EventHabitat'] },
	'eventid' => { 112 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 112 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 112 => [\'Event','EventMonth'] },
	'eventnumber' => { 343 => 0x9, 344 => 0x37 },
	'eventremarks' => { 112 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 112 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 112 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 444 => 'eventStart' },
	'eventstartdayofyear' => { 112 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 444 => 'eventSubtype' },
	'eventtime' => { 112 => [\'Event','EventEventTime'] },
	'eventtype' => { 444 => 'eventType' },
	'eventverbatimeventdate' => { 112 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 112 => [\'Event','EventYear'] },
	'evsteps' => { 303 => '1.2', 305 => 0x0 },
	'evstepsize' => { 255 => '5.1', 256 => '6.1', 257 => '6.1', 261 => '0.7' },
	'exclusivecoverage' => { 421 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 448 => 'exclusivityEndDate' },
	'excursiontolerance' => { 123 => 0x82 },
	'exif' => { 114 => 'EXIF' },
	'exifbyteorder' => { 114 => 'ExifByteOrder' },
	'exifcamerainfo' => { 121 => 0xe8 },
	'exifimageheight' => { 113 => 0xa003, 435 => 'PixelYDimension' },
	'exifimagewidth' => { 113 => 0xa002, 435 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 114 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 113 => 0x9000, 435 => 'ExifVersion' },
	'exitpupilposition' => { 200 => 0x4, 201 => 0x4 },
	'expirationdate' => { 121 => 0x25, 448 => 'expirationDate' },
	'expirationtime' => { 121 => 0x26 },
	'exposure' => { 113 => 0xfe51, 431 => 'Exposure' },
	'exposure2012' => { 431 => 'Exposure2012' },
	'exposureadj' => { 241 => 0x0 },
	'exposureadj2' => { 241 => 0x12 },
	'exposureadjust' => { 358 => 0xc },
	'exposurebracketingindicatorlast' => { 170 => 0x52 },
	'exposurebracketshotnumber' => { 173 => 0x2d, 377 => 0x2f },
	'exposurebracketstepsize' => { 303 => 0x8 },
	'exposurebracketvalue' => { 204 => 0x19 },
	'exposurecompensation' => { 72 => 0x6, 87 => 0x0, 113 => 0x9204, 129 => 0x24, 143 => 'ExposureComp', 163 => 'ExposureCompensation', 167 => 0xd, 168 => 0x53, 169 => 0x1e, 173 => 0x49c0, 272 => 0x1006, 322 => 0x16, 331 => 0x402, 355 => 0xa013, 358 => [0xc,0x35,0x4d], 386 => 0x114c, 387 => 0x114c, 388 => 0x1128, 390 => 0x1180, 391 => 0x1038, 392 => 0x230, 393 => 0x230, 394 => 0x223, 435 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 383 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 170 => 0x47, 173 => 0x2a },
	'exposurecompensationset' => { 366 => 0x3, 367 => 0x3, 368 => 0x3, 383 => 0x1e },
	'exposurecompensationsetting' => { 170 => 0x1 },
	'exposurecompstepsize' => { 250 => '6.3', 251 => '7.3', 253 => '7.3', 254 => '7.3', 259 => '4.3', 263 => '7.3', 264 => '7.3' },
	'exposurecontrolstep' => { 258 => '6.1', 260 => '6.1' },
	'exposurecontrolstepsize' => { 250 => '6.2', 251 => '7.1', 253 => '7.1', 254 => '7.1', 259 => '4.2', 263 => '7.1', 264 => '7.1', 265 => '7.1' },
	'exposurecount' => { 118 => 0x1032 },
	'exposuredelaymode' => { 250 => '10.1', 251 => '11.1', 253 => '11.1', 254 => '11.1', 255 => '9.1', 256 => '10.1', 257 => '10.1', 259 => '10.4', 260 => '10.1', 261 => '6.4', 263 => '11.1', 264 => '11.1', 265 => '11.2' },
	'exposuredifference' => { 204 => 0xe },
	'exposureindex' => { 113 => 0xa215, 435 => 'ExposureIndex' },
	'exposureindicator' => { 170 => 0x50 },
	'exposurelevelincrements' => { 76 => 0x6, 77 => 0x6, 78 => 0x101, 79 => 0x5, 80 => 0x6, 81 => 0x5, 82 => 0x5, 83 => 0x6, 84 => 0x4, 366 => 0x58, 367 => 0x58 },
	'exposurelockused' => { 419 => 'ExposureLockUsed' },
	'exposuremode' => { 113 => 0xa402, 143 => 'ExposureMode', 167 => 0x1, 168 => 0xa, 169 => 0x0, 170 => 0x0, 173 => 0x34, 267 => 0x200, 286 => 0x40d, 358 => 0x8, 378 => 0xb041, 435 => 'ExposureMode' },
	'exposuremodeinmanual' => { 78 => 0x10b },
	'exposureprogram' => { 113 => 0x8822, 348 => 0x1001, 359 => [0x17e,0x43], 366 => 0x3c, 367 => 0x3c, 368 => 0x5, 372 => 0x14, 377 => 0x3f, 383 => 0x2, 386 => 0x1175, 387 => 0x1179, 388 => 0x1155, 389 => 0x11d1, 390 => 0x11ad, 391 => 0x1065, 392 => 0x25d, 393 => 0x25d, 394 => 0x24c, 403 => 0xb, 404 => 0xc, 405 => 0xb, 407 => 0x48, 435 => 'ExposureProgram' },
	'exposureshift' => { 267 => 0x203 },
	'exposurestandardadjustment' => { 378 => 0x202d },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x6, 30 => 0x7, 72 => 0x16, 113 => 0x829a, 126 => 0xfd05, 129 => 0x20, 131 => 0xfa24, 133 => 0xf104, 136 => 0x12, 138 => 0x38, 141 => 0x10, 143 => 'ExposureTime', 167 => 0x9, 168 => 0x35, 169 => 0x48, 170 => 0x8, 173 => 0x49b8, 322 => 0x12, 355 => 0xa018, 358 => [0x32,0x4a], 366 => 0x0, 367 => 0x0, 383 => [0x21,0x23,0x27], 407 => 0x10, 435 => 'ExposureTime' },
	'exposuretime2' => { 358 => [0x33,0x4b] },
	'exposuretuning' => { 204 => 0x1c },
	'exposurevalue' => { 127 => 0x3 },
	'exposurewarning' => { 118 => 0x1302 },
	'exrauto' => { 118 => 0x1033 },
	'exrmode' => { 118 => 0x1034 },
	'extendedwbdetect' => { 267 => 0x902 },
	'extender' => { 268 => 0x301 },
	'extenderfirmwareversion' => { 268 => 0x304 },
	'extendermagnification' => { 145 => 'Magnification' },
	'extendermake' => { 145 => 'Make' },
	'extendermodel' => { 145 => 'Model', 268 => 0x303 },
	'extenderserialnumber' => { 145 => 'SerialNumber', 268 => 0x302 },
	'extenderstatus' => { 320 => 0x3 },
	'externalflash' => { 270 => 0x1201 },
	'externalflashae1' => { 272 => 0x101f },
	'externalflashae1_0' => { 272 => 0x101b },
	'externalflashae2' => { 272 => 0x1020 },
	'externalflashae2_0' => { 272 => 0x101c },
	'externalflashbounce' => { 270 => 0x1204, 272 => 0x1026, 310 => 0x1a },
	'externalflashcompensation' => { 194 => 0x1b },
	'externalflashexposurecomp' => { 204 => 0x17, 310 => 0x19 },
	'externalflashfirmware' => { 192 => 0x6, 193 => 0x6, 194 => 0x6, 195 => 0x6 },
	'externalflashflags' => { 192 => 0x8, 193 => 0x8, 194 => 0x8 },
	'externalflashguidenumber' => { 270 => 0x1203, 310 => '24.1' },
	'externalflashgvalue' => { 272 => 0x1025 },
	'externalflashmode' => { 272 => 0x1028, 310 => 0x2 },
	'externalflashreadystate' => { 195 => '9.1' },
	'externalflashstatus' => { 195 => '8.2' },
	'externalflashzoom' => { 270 => 0x1205, 272 => 0x1027 },
	'externalflashzoomoverride' => { 195 => '8.1' },
	'externalmetadatalink' => { 441 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 284 => 0x311, 290 => 0x3408 },
	'extrainfoversion' => { 370 => 0x1a },
	'eyestartaf' => { 170 => 0x40 },
	'face10position' => { 104 => 0x3f4, 105 => 0x1ec, 190 => 0x28, 307 => 0x12 },
	'face10size' => { 308 => 0x12 },
	'face11position' => { 190 => 0x2c, 307 => 0x14 },
	'face11size' => { 308 => 0x14 },
	'face12position' => { 190 => 0x30, 307 => 0x16 },
	'face12size' => { 308 => 0x16 },
	'face13position' => { 307 => 0x18 },
	'face13size' => { 308 => 0x18 },
	'face14position' => { 307 => 0x1a },
	'face14size' => { 308 => 0x1a },
	'face15position' => { 307 => 0x1c },
	'face15size' => { 308 => 0x1c },
	'face16position' => { 307 => 0x1e },
	'face16size' => { 308 => 0x1e },
	'face17position' => { 307 => 0x20 },
	'face17size' => { 308 => 0x20 },
	'face18position' => { 307 => 0x22 },
	'face18size' => { 308 => 0x22 },
	'face19position' => { 307 => 0x24 },
	'face19size' => { 308 => 0x24 },
	'face1position' => { 51 => 0x8, 104 => 0xd, 105 => 0x18, 190 => 0x4, 282 => 0x1, 307 => 0x0, 345 => 0xbc, 373 => 0x1, 374 => 0x0, 375 => 0x0, 376 => 0x5b },
	'face1size' => { 308 => 0x0 },
	'face20position' => { 307 => 0x26 },
	'face20size' => { 308 => 0x26 },
	'face21position' => { 307 => 0x28 },
	'face21size' => { 308 => 0x28 },
	'face22position' => { 307 => 0x2a },
	'face22size' => { 308 => 0x2a },
	'face23position' => { 307 => 0x2c },
	'face23size' => { 308 => 0x2c },
	'face24position' => { 307 => 0x2e },
	'face24size' => { 308 => 0x2e },
	'face25position' => { 307 => 0x30 },
	'face25size' => { 308 => 0x30 },
	'face26position' => { 307 => 0x32 },
	'face26size' => { 308 => 0x32 },
	'face27position' => { 307 => 0x34 },
	'face27size' => { 308 => 0x34 },
	'face28position' => { 307 => 0x36 },
	'face28size' => { 308 => 0x36 },
	'face29position' => { 307 => 0x38 },
	'face29size' => { 308 => 0x38 },
	'face2position' => { 51 => 0xa, 104 => 0x7c, 105 => 0x4c, 190 => 0x8, 282 => 0x5, 307 => 0x2, 345 => 0xc8, 373 => 0x6, 374 => 0x20, 375 => 0x25, 376 => 0x65 },
	'face2size' => { 308 => 0x2 },
	'face30position' => { 307 => 0x3a },
	'face30size' => { 308 => 0x3a },
	'face31position' => { 307 => 0x3c },
	'face31size' => { 308 => 0x3c },
	'face32position' => { 307 => 0x3e },
	'face32size' => { 308 => 0x3e },
	'face3position' => { 51 => 0xc, 104 => 0xeb, 105 => 0x80, 190 => 0xc, 282 => 0x9, 307 => 0x4, 345 => 0xd4, 373 => 0xb, 374 => 0x40, 375 => 0x4a, 376 => 0x6f },
	'face3size' => { 308 => 0x4 },
	'face4position' => { 51 => 0xe, 104 => 0x15a, 105 => 0xb4, 190 => 0x10, 282 => 0xd, 307 => 0x6, 345 => 0xe0, 373 => 0x10, 374 => 0x60, 375 => 0x6f, 376 => 0x79 },
	'face4size' => { 308 => 0x6 },
	'face5position' => { 51 => 0x10, 104 => 0x1c9, 105 => 0xe8, 190 => 0x14, 282 => 0x11, 307 => 0x8, 345 => 0xec, 373 => 0x15, 374 => 0x80, 375 => 0x94 },
	'face5size' => { 308 => 0x8 },
	'face6position' => { 51 => 0x12, 104 => 0x238, 105 => 0x11c, 190 => 0x18, 307 => 0xa, 345 => 0xf8, 373 => 0x1a, 374 => 0xa0, 375 => 0xb9 },
	'face6size' => { 308 => 0xa },
	'face7position' => { 51 => 0x14, 104 => 0x2a7, 105 => 0x150, 190 => 0x1c, 307 => 0xc, 345 => 0x104, 373 => 0x1f, 374 => 0xc0, 375 => 0xde },
	'face7size' => { 308 => 0xc },
	'face8position' => { 51 => 0x16, 104 => 0x316, 105 => 0x184, 190 => 0x20, 307 => 0xe, 345 => 0x110, 373 => 0x24, 374 => 0xe0, 375 => 0x103 },
	'face8size' => { 308 => 0xe },
	'face9position' => { 51 => 0x18, 104 => 0x385, 105 => 0x1b8, 190 => 0x24, 307 => 0x10 },
	'face9size' => { 308 => 0x10 },
	'facebalanceorigi' => { 424 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 424 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 424 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 424 => 'FaceBalanceWarmth' },
	'facedetect' => { 322 => 0x76, 355 => 0x100 },
	'facedetectarea' => { 271 => 0x1201 },
	'facedetectframecrop' => { 271 => 0x1207 },
	'facedetectframesize' => { 51 => 0x3, 104 => 0x1, 105 => 0x4, 190 => 0x1, 271 => 0x1203, 322 => 0x77, 345 => 0xb6 },
	'facedetection' => { 368 => 0x30, 383 => 0x19 },
	'faceelementpositions' => { 118 => 0x4203 },
	'faceelementtypes' => { 118 => 0x4201 },
	'faceid' => { 426 => 'FaceID' },
	'faceinfounknown' => { 107 => 0x2089 },
	'facename' => { 355 => 0x123 },
	'faceorientation' => { 105 => 0x8 },
	'faceposition' => { 306 => 0x2, 356 => 0x4 },
	'facepositions' => { 118 => 0x4103 },
	'facerecognition' => { 355 => 0x120 },
	'facesdetected' => { 51 => 0x2, 52 => 0x2, 53 => 0x3, 104 => 0x0, 105 => 0x2, 107 => 0x211c, 118 => 0x4100, 190 => 0x3, 271 => 0x1200, 288 => 0x3f, 306 => 0x0, 345 => 0xb5, 356 => 0x0, 373 => 0x0, 376 => 0x3, 385 => 0x30 },
	'facesrecognized' => { 283 => 0x0 },
	'facewidth' => { 52 => 0x1 },
	'faithfuloutputhighlightpoint' => { 103 => 0x38 },
	'faithfuloutputshadowpoint' => { 103 => 0x39 },
	'faithfulrawcolortone' => { 103 => 0x31 },
	'faithfulrawcontrast' => { 103 => 0x33 },
	'faithfulrawhighlight' => { 103 => 0x79 },
	'faithfulrawhighlightpoint' => { 103 => 0x36 },
	'faithfulrawlinear' => { 103 => 0x34 },
	'faithfulrawsaturation' => { 103 => 0x32 },
	'faithfulrawshadow' => { 103 => 0x82 },
	'faithfulrawshadowpoint' => { 103 => 0x37 },
	'faithfulrawsharpness' => { 103 => 0x35 },
	'faithfulunsharpmaskfineness' => { 103 => 0xac },
	'faithfulunsharpmaskstrength' => { 103 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 103 => 0xae },
	'far' => { 416 => 'Far' },
	'feedidentifier' => { 441 => 'FeedIdentifier' },
	'femicroadjustment' => { 78 => 0x111 },
	'ffid' => { 433 => 'ffid' },
	'field' => { 444 => 'field' },
	'fieldcount' => { 272 => 0x103f },
	'filecreatedate' => { 114 => 'FileCreateDate' },
	'filedatarate' => { 455 => 'fileDataRate' },
	'fileformat' => { 89 => 0x0, 122 => 0x14, 358 => [0x22,0x26], 378 => 0xb000 },
	'filegroupid' => { 114 => 'FileGroupID' },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 27 => 0x1eb, 28 => 0x4ae, 289 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 114 => 'FileModifyDate' },
	'filename' => { 114 => 'FileName' },
	'filenameasdelivered' => { 277 => 'FileNameAsDelivered' },
	'filenumber' => { 54 => 0x1, 60 => 0x8, 91 => 0x1817, 108 => 'FileNumber', 191 => 0x4 },
	'filenumbermemory' => { 167 => 0x1a },
	'filenumbersequence' => { 250 => '12.2', 255 => '3.1', 256 => '4.1', 257 => '4.1', 259 => '11.1', 260 => '4.3', 265 => '5.2' },
	'filepermissions' => { 114 => 'FilePermissions' },
	'filesource' => { 113 => 0xa300, 118 => 0x8000, 435 => 'FileSource' },
	'fileuserid' => { 114 => 'FileUserID' },
	'fileversion' => { 122 => 0x16 },
	'fillflashautoreduction' => { 76 => 0xe, 77 => 0xe, 84 => 0xa },
	'filllight' => { 431 => 'FillLight' },
	'fillorder' => { 113 => 0x10a },
	'filmgraineffect' => { 267 => 0x538 },
	'filmmode' => { 118 => 0x1401, 286 => 0x412, 288 => 0x42 },
	'filmtype' => { 211 => 0x2 },
	'filtereffect' => { 54 => 0xe, 206 => 0x37, 207 => 0x3f },
	'filtereffectauto' => { 67 => 0xa0 },
	'filtereffectfaithful' => { 66 => 0x70, 67 => 0x70 },
	'filtereffectlandscape' => { 66 => 0x40, 67 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 66 => 0x88, 67 => 0x88 },
	'filtereffectneutral' => { 66 => 0x58, 67 => 0x58 },
	'filtereffectportrait' => { 66 => 0x28, 67 => 0x28 },
	'filtereffectstandard' => { 66 => 0x10, 67 => 0x10 },
	'filtereffectuserdef1' => { 66 => 0xa0, 67 => 0xb8 },
	'filtereffectuserdef2' => { 66 => 0xb8, 67 => 0xd0 },
	'filtereffectuserdef3' => { 66 => 0xd0, 67 => 0xe8 },
	'finderdisplayduringexposure' => { 77 => 0x1 },
	'finesharpness' => { 322 => 0x70 },
	'finetuneoptcenterweighted' => { 250 => '7.2', 251 => '9.1', 253 => '9.1', 254 => '9.1', 258 => '8.1', 263 => '9.1', 264 => '9.1', 265 => '9.1' },
	'finetuneopthighlightweighted' => { 253 => '46.1', 254 => '46.1', 263 => '46.1', 264 => '46.1' },
	'finetuneoptmatrixmetering' => { 250 => '8.1', 251 => '8.2', 253 => '8.2', 254 => '8.2', 258 => '7.2', 259 => '6.1', 263 => '8.2', 264 => '8.2', 265 => '8.2' },
	'finetuneoptspotmetering' => { 250 => '8.2', 251 => '9.2', 253 => '9.2', 254 => '9.2', 258 => '8.2', 259 => '6.2', 263 => '9.2', 264 => '9.2', 265 => '9.2' },
	'firmware' => { 272 => 0x405, 358 => [0x17,0x3b,0x57], 427 => 'Firmware' },
	'firmwaredate' => { 106 => 0x15, 107 => 0x2001, 343 => 0x4 },
	'firmwareid' => { 174 => 0x0 },
	'firmwarename' => { 355 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 60 => 0x1e, 346 => 0x0 },
	'firmwarerevision2' => { 346 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 127 => 0xce5, 141 => 0x57, 143 => 'FirmwareVersion', 288 => 0x2, 290 => 0x3109, 322 => 0x230, 344 => 0x18, 348 => 0x2 },
	'firmwareversions' => { 331 => 0x301 },
	'firstphotodate' => { 419 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 277 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 121 => 0x16, 425 => 'FixtureIdentifier' },
	'flash' => { 108 => 'Flash', 113 => 0x9209, 168 => 0x1f, 169 => 0x15, 435 => 'Flash' },
	'flashaction' => { 366 => 0x3e, 367 => 0x3e, 378 => 0x2017, 383 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 366 => 0x4c, 367 => 0x4c, 383 => 0x77 },
	'flashactionexternal' => { 383 => [0x78,0x7c] },
	'flashactivity' => { 33 => 0x1c },
	'flashbatterylevel' => { 41 => 0x249 },
	'flashbias' => { 288 => 0x24 },
	'flashbits' => { 33 => 0x1d },
	'flashbuttonfunction' => { 78 => 0x70e },
	'flashchargelevel' => { 272 => 0x1010 },
	'flashcolorfilter' => { 194 => 0x10 },
	'flashcommandermode' => { 192 => '9.1', 193 => '9.1', 194 => '9.1' },
	'flashcompensation' => { 192 => 0xa, 193 => 0xa, 194 => 0xa, 195 => 0xa, 427 => 'FlashCompensation' },
	'flashcontrol' => { 366 => 0x23, 367 => 0x1f, 368 => 0x21 },
	'flashcontrolbuilt-in' => { 259 => '16.1', 260 => '23.1', 262 => '23.1', 263 => '24.1' },
	'flashcontrolmode' => { 192 => '9.2', 193 => '9.2', 194 => '9.2', 267 => 0x404 },
	'flashcurtain' => { 288 => 0x48 },
	'flashdefault' => { 170 => 0x42 },
	'flashdevice' => { 272 => 0x1005 },
	'flashdistance' => { 107 => 0x2034 },
	'flashenergy' => { 113 => 0xa20b, 435 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 204 => 0x18 },
	'flashexposurecomp' => { 72 => 0xf, 118 => 0x1011, 146 => 'ExposureComp', 167 => 0x23, 172 => 0x104, 173 => 0x49c1, 204 => 0x12, 267 => 0x401, 272 => 0x1023, 322 => 0x4d, 348 => 0x100b, 358 => [0x3a,0x56], 378 => 0x104 },
	'flashexposurecomp2' => { 229 => 0x4d2 },
	'flashexposurecomp3' => { 194 => 0x1d },
	'flashexposurecomp4' => { 194 => 0x27 },
	'flashexposurecomparea' => { 251 => '38.4', 253 => '38.4', 254 => '38.4', 263 => '38.4', 264 => '38.4' },
	'flashexposurecompset' => { 170 => 0x10, 295 => 0xe, 366 => 0x14, 367 => 0x12, 368 => 0x23, 383 => 0x1f },
	'flashexposurecompset2' => { 383 => [0x26,0x2c] },
	'flashexposureindicator' => { 170 => 0x54 },
	'flashexposureindicatorlast' => { 170 => 0x56 },
	'flashexposureindicatornext' => { 170 => 0x55 },
	'flashexposurelock' => { 54 => 0x19 },
	'flashfired' => { 129 => 0x5d, 146 => 'Fired', 167 => 0x14, 228 => '590.3', 288 => 0x8007, 435 => [\'Flash','FlashFired'] },
	'flashfiring' => { 78 => 0x306, 79 => 0x6, 80 => 0x7, 83 => 0x7 },
	'flashfirmwareversion' => { 268 => 0x1002 },
	'flashfocallength' => { 192 => 0xb, 193 => 0xc, 194 => 0xc, 195 => 0xc },
	'flashfunction' => { 173 => 0x31, 435 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 192 => 0xe, 193 => 0xf, 194 => 0xf, 195 => 0xf },
	'flashgroupacompensation' => { 192 => 0x11, 193 => 0x12, 194 => 0x13 },
	'flashgroupacontrolmode' => { 192 => 0xf, 193 => '16.1', 194 => '17.1' },
	'flashgroupaoutput' => { 192 => 0x11, 193 => 0x12, 194 => 0x13 },
	'flashgroupbcompensation' => { 192 => 0x12, 193 => 0x13, 194 => 0x14 },
	'flashgroupbcontrolmode' => { 192 => 0x10, 193 => '17.1', 194 => '18.1' },
	'flashgroupboutput' => { 192 => 0x12, 193 => 0x13, 194 => 0x14 },
	'flashgroupccompensation' => { 193 => 0x14, 194 => 0x15 },
	'flashgroupccontrolmode' => { 193 => '17.2', 194 => '18.2' },
	'flashgroupcoutput' => { 193 => 0x14, 194 => 0x15 },
	'flashguidenumber' => { 72 => 0xd, 88 => 0x0, 146 => 'GuideNumber' },
	'flashintensity' => { 106 => [0x19,0x5], 267 => 0x405 },
	'flashlevel' => { 252 => 0x9, 378 => 0xb048 },
	'flashmake' => { 146 => 'Make' },
	'flashmanufacturer' => { 165 => 'FlashManufacturer' },
	'flashmetering' => { 167 => 0x3f, 170 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 27 => 0x15 },
	'flashmeteringsegments' => { 322 => 0x20a },
	'flashmode' => { 106 => 0x4, 129 => 0x5c, 146 => 'Mode', 167 => 0x2, 168 => 0x20, 169 => 0x16, 170 => 0xf, 204 => 0x87, 267 => 0x400, 272 => 0x1004, 322 => 0xc, 329 => 0x4, 347 => 0x20, 348 => 0x100a, 357 => 0x225, 366 => 0x13, 367 => 0x7f, 368 => 0x20, 383 => 0x10, 386 => 0x1138, 387 => 0x1138, 388 => 0x1114, 389 => 0x1190, 390 => 0x116c, 391 => 0x1024, 392 => 0x21c, 393 => 0x21c, 394 => 0x211, 435 => [\'Flash','FlashMode'] },
	'flashmodel' => { 146 => 'Model', 165 => 'FlashModel', 268 => 0x1001 },
	'flashoptions' => { 303 => 0x2 },
	'flashoptions2' => { 303 => 0x10 },
	'flashoutput' => { 41 => 0x248, 72 => 0x21, 192 => 0xa, 193 => 0xa, 194 => 0xa },
	'flashpixversion' => { 113 => 0xa000, 435 => 'FlashpixVersion' },
	'flashredeyemode' => { 435 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 267 => 0x403 },
	'flashreturn' => { 435 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 146 => 'SerialNumber', 268 => 0x1003 },
	'flashsetting' => { 204 => 0x8 },
	'flashshutterspeed' => { 250 => '20.2', 251 => '23.2', 253 => '23.2', 254 => '23.2', 259 => '15.2', 260 => '22.2', 261 => '7.2', 262 => '22.2', 263 => '23.2', 264 => '23.2', 265 => '23.1' },
	'flashsource' => { 192 => 0x4, 193 => 0x4, 194 => 0x4, 195 => 0x4 },
	'flashstatus' => { 310 => 0x0, 383 => [0x82,0x86], 396 => 0x31, 397 => 0x39 },
	'flashstatusbuilt-in' => { 368 => [0x87,0x287] },
	'flashstatusexternal' => { 368 => [0x88,0x288] },
	'flashsyncspeed' => { 250 => '20.1', 251 => '23.1', 253 => '23.1', 254 => '23.1', 259 => '15.1', 260 => '22.1', 262 => '22.1', 263 => '23.1', 264 => '23.1' },
	'flashsyncspeedav' => { 76 => 0x3, 78 => 0x10f, 79 => 0x2, 80 => 0x3, 81 => 0x2, 82 => 0x2, 83 => 0x3, 84 => 0x6 },
	'flashthreshold' => { 88 => 0x1 },
	'flashtype' => { 146 => 'Type', 170 => 0x59, 204 => 0x9, 268 => 0x1000 },
	'flashwarning' => { 260 => '30.1', 261 => '7.1', 265 => '31.1', 288 => 0x62 },
	'flexiblespotposition' => { 378 => 0x201d },
	'flickerreduce' => { 357 => 0x218 },
	'flickerreduction' => { 222 => 0xe84 },
	'flickerreductionindicator' => { 222 => 0x5e2 },
	'flightpitchdegree' => { 110 => 'FlightPitchDegree' },
	'flightrolldegree' => { 110 => 'FlightRollDegree' },
	'flightyawdegree' => { 110 => 'FlightYawDegree' },
	'fliphorizontal' => { 243 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x5, 30 => 0x6, 72 => 0x15, 113 => 0x829d, 126 => 0xfd04, 129 => 0x1e, 131 => 0xfa23, 133 => 0xf103, 136 => 0x13, 138 => 0x3c, 141 => 0xc, 150 => 'FNumber', 167 => 0xa, 168 => 0x36, 169 => 0x47, 170 => 0x9, 173 => 0x49c7, 322 => 0x13, 355 => 0xa019, 358 => [0x31,0x49], 366 => 0x1, 367 => 0x1, 383 => [0x20,0x22,0x26], 435 => 'FNumber' },
	'focaldistance' => { 417 => 'FocalDistance' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x1e, 28 => 0x23, 56 => 0x1, 107 => 0x1d, 113 => 0x920a, 136 => 0x1d, 150 => 'FocalLength', 167 => 0x12, 200 => 0xa, 201 => 0xb, 322 => 0x1d, 331 => 0x403, 348 => 0x1500, 365 => 0xe, 390 => 0x1278, 391 => 0x1134, 392 => 0x32c, 393 => 0x32c, 394 => 0x30a, 435 => 'FocalLength' },
	'focallength2' => { 383 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 113 => 0xa405, 355 => 0xa01a, 435 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 365 => 0x10 },
	'focalplaneafpointarea' => { 395 => 0x2 },
	'focalplaneafpointlocation1' => { 395 => 0x6 },
	'focalplaneafpointlocation10' => { 395 => 0x2a },
	'focalplaneafpointlocation11' => { 395 => 0x2e },
	'focalplaneafpointlocation12' => { 395 => 0x32 },
	'focalplaneafpointlocation13' => { 395 => 0x36 },
	'focalplaneafpointlocation14' => { 395 => 0x3a },
	'focalplaneafpointlocation15' => { 395 => 0x3e },
	'focalplaneafpointlocation2' => { 395 => 0xa },
	'focalplaneafpointlocation3' => { 395 => 0xe },
	'focalplaneafpointlocation4' => { 395 => 0x12 },
	'focalplaneafpointlocation5' => { 395 => 0x16 },
	'focalplaneafpointlocation6' => { 395 => 0x1a },
	'focalplaneafpointlocation7' => { 395 => 0x1e },
	'focalplaneafpointlocation8' => { 395 => 0x22 },
	'focalplaneafpointlocation9' => { 395 => 0x26 },
	'focalplaneafpointsused' => { 395 => 0x1 },
	'focalplanediagonal' => { 268 => 0x103, 272 => 0x205 },
	'focalplaneresolutionunit' => { 113 => 0xa210, 435 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 113 => 0xa20e, 435 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 56 => 0x2 },
	'focalplanexunknown' => { 56 => 0x2 },
	'focalplaneyresolution' => { 113 => 0xa20f, 435 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 56 => 0x3 },
	'focalplaneyunknown' => { 56 => 0x3 },
	'focalpointx' => { 417 => 'FocalPointX' },
	'focalpointy' => { 417 => 'FocalPointY' },
	'focaltype' => { 9 => 0x2d, 56 => 0x0 },
	'focalunits' => { 33 => 0x19 },
	'focus' => { 233 => 0x8 },
	'focusarea' => { 167 => 0x31 },
	'focusareaselection' => { 261 => '15.2' },
	'focuscontinuous' => { 33 => 0x20 },
	'focusdisplayaiservoandmf' => { 78 => 0x515 },
	'focusdistance' => { 150 => 'FocusDistance', 167 => 0x13, 173 => 0x49bb, 200 => 0x9, 201 => 0xa, 270 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0xa7, 27 => 0x56, 28 => 0xa7, 54 => 0x15, 72 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0xa5, 27 => 0x54, 28 => 0xa5, 54 => 0x14, 72 => 0x13 },
	'focusholdbutton' => { 170 => 0x44 },
	'focusinfoversion' => { 270 => 0x0 },
	'focusingscreen' => { 77 => 0x0, 78 => 0x80b, 83 => 0x0 },
	'focuslocation' => { 378 => 0x2027 },
	'focuslocked' => { 166 => 0x14 },
	'focusmode' => { 33 => 0x7, 106 => 0x3, 107 => [0x3003,0xd], 118 => 0x1021, 129 => 0x38, 143 => 'FocusMode', 167 => 0x30, 169 => 0xe, 170 => 0xc, 204 => 0x7, 267 => 0x301, 272 => 0x100b, 288 => 0x7, 322 => 0xd, 329 => 0x3, 348 => 0x1006, 359 => [0xb,0x5], 365 => [0x15,0x1d], 366 => 0x4d, 367 => 0x4d, 378 => [0xb042,0xb04e,0x201b], 383 => 0x13, 401 => 0x16 },
	'focusmode2' => { 303 => '3.1', 383 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 252 => '10.1', 363 => 0x14, 364 => 0x15, 366 => 0x10, 367 => 0xf, 368 => 0x6 },
	'focusmodeswitch' => { 170 => 0x58, 366 => 0x2e },
	'focuspixel' => { 118 => 0x1023 },
	'focuspointwrap' => { 250 => '2.2', 251 => '2.2', 253 => '2.1', 254 => '2.1', 258 => '1.1', 259 => '2.2', 260 => '1.1', 263 => '2.2', 264 => '2.1', 265 => '2.5' },
	'focusposition' => { 200 => 0x8, 201 => 0x8, 322 => 0x10, 377 => 0x9bb },
	'focusposition2' => { 383 => [0x29,0x2b,0x2f], 401 => 0x2d, 404 => 0x20 },
	'focusprocess' => { 267 => 0x302 },
	'focusrange' => { 33 => 0x12, 272 => 0x100a },
	'focusrangeindex' => { 313 => '3.1' },
	'focussetting' => { 358 => 0x6 },
	'focusstatus' => { 365 => 0x19, 366 => 0x53, 367 => 0x53 },
	'focusstepcount' => { 270 => 0x301, 272 => 0x100e },
	'focusstepinfinity' => { 270 => 0x303, 272 => 0x103b },
	'focusstepnear' => { 270 => 0x304, 272 => 0x103c },
	'focustrackinglockon' => { 250 => ['1.5','4.1'], 251 => '1.4', 258 => '0.4', 259 => '3.1', 260 => '0.4', 263 => '1.4' },
	'focuswarning' => { 118 => 0x1301 },
	'foldername' => { 167 => 0x27 },
	'foldernumber' => { 366 => 0x9a, 368 => [0x402,0x114,0x316] },
	'fontcomposite' => { 460 => [\'Fonts','FontsComposite'] },
	'fontface' => { 460 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 460 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 460 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 460 => [\'Fonts','FontsFontName'] },
	'fonts' => { 460 => 'Fonts' },
	'fonttype' => { 460 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 460 => [\'Fonts','FontsVersionString'] },
	'for' => { 338 => 'For' },
	'forcewrite' => { 114 => 'ForceWrite' },
	'format' => { 416 => 'Format', 432 => 'format', 453 => 'Format' },
	'forwardlock' => { 450 => 'forwardlock' },
	'forwardmatrix1' => { 113 => 0xc714 },
	'forwardmatrix2' => { 113 => 0xc715 },
	'framecount' => { 63 => [0x2,0x4] },
	'frameheight' => { 118 => 0x3822 },
	'framenum' => { 333 => 0xd7 },
	'framenumber' => { 118 => 0x8003, 173 => 0x3c, 322 => 0x29 },
	'framerate' => { 63 => [0x1,0x6], 113 => 0xc764, 118 => 0x3820 },
	'framewidth' => { 118 => 0x3821 },
	'framing' => { 444 => 'framing' },
	'freebytes' => { 91 => 0x1 },
	'freememorycardimages' => { 168 => [0x37,0x54], 169 => [0x2d,0x4a], 170 => 0x32 },
	'fujiflashmode' => { 118 => 0x1010 },
	'fullimagesize' => { 378 => 0xb02b },
	'fullpanoheightpixels' => { 419 => 'FullPanoHeightPixels', 420 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 419 => 'FullPanoWidthPixels', 420 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 348 => 0x100d },
	'fullsizeimage' => { 149 => 'data' },
	'fullsizeimagename' => { 149 => '1Name' },
	'fullsizeimagetype' => { 149 => '0Type' },
	'func1button' => { 253 => '14.1', 254 => '14.1', 264 => '14.1' },
	'func1buttonplusdials' => { 253 => '42.1', 254 => '42.1', 264 => '42.1' },
	'func2button' => { 253 => '80.1', 254 => '80.1', 264 => '80.1' },
	'func2buttonplusdials' => { 253 => '81.1' },
	'func3button' => { 253 => '83.1' },
	'funcbutton' => { 250 => ['14.1','15.1'], 251 => '14.1', 259 => '28.1', 260 => '13.1', 263 => '14.1', 265 => '14.1' },
	'funcbuttonplusdials' => { 250 => ['14.2','15.2'], 251 => '14.2', 259 => '31.1', 263 => '42.1' },
	'functionbutton' => { 257 => '13.1', 261 => '5.2' },
	'gainbase' => { 271 => 0x610 },
	'gaincontrol' => { 113 => 0xa407, 435 => 'GainControl' },
	'gamma' => { 113 => 0xa500, 436 => 'Gamma' },
	'gammablackpoint' => { 99 => 0xc },
	'gammacolortone' => { 99 => 0x3 },
	'gammacompensatedvalue' => { 123 => 0x91 },
	'gammacontrast' => { 99 => 0x2 },
	'gammacurveoutputrange' => { 99 => 0xf },
	'gammahighlight' => { 99 => 0xa },
	'gammalinear' => { 97 => 0x20200 },
	'gammamidpoint' => { 99 => 0xe },
	'gammasaturation' => { 99 => 0x4 },
	'gammashadow' => { 99 => 0x9 },
	'gammasharpnessstrength' => { 99 => 0x8 },
	'gammaunsharpmaskfineness' => { 99 => 0x6 },
	'gammaunsharpmaskstrength' => { 99 => 0x5 },
	'gammaunsharpmaskthreshold' => { 99 => 0x7 },
	'gammawhitepoint' => { 99 => 0xd },
	'geimagesize' => { 118 => 0x1304 },
	'gemake' => { 119 => 0x300 },
	'gemodel' => { 119 => 0x207 },
	'genre' => { 441 => 'Genre', 445 => 'genre', 455 => 'genre' },
	'genrecvid' => { 441 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 441 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 441 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 441 => [\'Genre','GenreCvTermRefinedAbout'] },
	'geography' => { 446 => 'geography' },
	'geologicalcontext' => { 112 => 'GeologicalContext' },
	'geologicalcontextbed' => { 112 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 112 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 112 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 112 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 112 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 114 => 'Geosync' },
	'geotag' => { 114 => 'Geotag' },
	'geotiffasciiparams' => { 113 => 0x87b1 },
	'geotiffdirectory' => { 113 => 0x87af },
	'geotiffdoubleparams' => { 113 => 0x87b0 },
	'geotime' => { 114 => 'Geotime' },
	'giftftppriority' => { 421 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 110 => 'GimbalPitchDegree' },
	'gimbalrolldegree' => { 110 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 110 => 'GimbalYawDegree' },
	'globalaltitude' => { 336 => 0x419 },
	'globalangle' => { 336 => 0x40d },
	'good' => { 455 => 'good' },
	'googleplusuploadcode' => { 113 => 0x9009 },
	'gpsaltitude' => { 120 => 0x6, 147 => 'Altitude', 435 => 'GPSAltitude' },
	'gpsaltituderef' => { 120 => 0x5, 435 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 120 => 0x1c, 435 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 120 => 0x1d },
	'gpsdatetime' => { 147 => 'DateTime', 435 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 120 => 0x18, 147 => 'Bearing', 435 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 120 => 0x17, 435 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 120 => 0x1a, 147 => 'Distance', 435 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 120 => 0x19, 435 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 120 => 0x14, 435 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 120 => 0x13 },
	'gpsdestlongitude' => { 120 => 0x16, 435 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 120 => 0x15 },
	'gpsdifferential' => { 120 => 0x1e, 147 => 'Differential', 435 => 'GPSDifferential' },
	'gpsdop' => { 120 => 0xb, 435 => 'GPSDOP' },
	'gpshpositioningerror' => { 120 => 0x1f, 435 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 120 => 0x11, 435 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 120 => 0x10, 435 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 120 => 0x2, 147 => 'Latitude', 435 => 'GPSLatitude' },
	'gpslatituderef' => { 120 => 0x1 },
	'gpslongitude' => { 120 => 0x4, 147 => 'Longitude', 435 => 'GPSLongitude' },
	'gpslongituderef' => { 120 => 0x3 },
	'gpsmapdatum' => { 120 => 0x12, 147 => 'Datum', 435 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 120 => 0xa, 147 => 'MeasureMode', 435 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 120 => 0x1b, 435 => 'GPSProcessingMethod' },
	'gpssatellites' => { 120 => 0x8, 147 => 'Satellites', 435 => 'GPSSatellites' },
	'gpsspeed' => { 120 => 0xd, 147 => 'Speed', 435 => 'GPSSpeed' },
	'gpsspeedref' => { 120 => 0xc, 435 => 'GPSSpeedRef' },
	'gpsstatus' => { 120 => 0x9, 435 => 'GPSStatus' },
	'gpstimestamp' => { 120 => 0x7 },
	'gpstrack' => { 120 => 0xf, 147 => 'Heading', 435 => 'GPSTrack' },
	'gpstrackref' => { 120 => 0xe, 435 => 'GPSTrackRef' },
	'gpsversionid' => { 120 => 0x0, 435 => 'GPSVersionID' },
	'gradation' => { 267 => 0x50f },
	'gradientbasedcorractive' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 431 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 431 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 431 => 'GrainAmount' },
	'grainfrequency' => { 431 => 'GrainFrequency' },
	'grainsize' => { 431 => 'GrainSize' },
	'graymixeraqua' => { 431 => 'GrayMixerAqua' },
	'graymixerblue' => { 431 => 'GrayMixerBlue' },
	'graymixergreen' => { 431 => 'GrayMixerGreen' },
	'graymixermagenta' => { 431 => 'GrayMixerMagenta' },
	'graymixerorange' => { 431 => 'GrayMixerOrange' },
	'graymixerpurple' => { 431 => 'GrayMixerPurple' },
	'graymixerred' => { 431 => 'GrayMixerRed' },
	'graymixeryellow' => { 431 => 'GrayMixerYellow' },
	'graypoint' => { 411 => 0x8021 },
	'grayresponseunit' => { 113 => 0x122 },
	'greencurvelimits' => { 102 => 0x1c4 },
	'greencurvepoints' => { 101 => 0x53, 102 => 0x19a },
	'greenhsl' => { 97 => 0x20913 },
	'greenhue' => { 431 => 'GreenHue' },
	'greensaturation' => { 431 => 'GreenSaturation' },
	'griddisplay' => { 250 => '13.3', 251 => '4.3', 253 => '4.2', 254 => '4.2', 255 => '2.2', 259 => '10.5', 260 => '3.4', 261 => '6.1', 263 => '4.4', 264 => '4.2', 265 => '4.2' },
	'gripbatteryadload' => { 301 => 0x5 },
	'gripbatteryadnoload' => { 301 => 0x4 },
	'gripbatterystate' => { 301 => '1.2' },
	'groupareaafillumination' => { 251 => '46.4', 254 => '47.4', 263 => '47.4' },
	'halftonehints' => { 113 => 0x141 },
	'hardlink' => { 114 => 'HardLink' },
	'hasalternative' => { 445 => 'hasAlternative' },
	'hascorrection' => { 445 => 'hasCorrection' },
	'hascorrectiona-lang' => { 445 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 445 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 445 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 431 => 'HasCrop' },
	'hasextendedxmp' => { 457 => 'HasExtendedXMP' },
	'hassettings' => { 431 => 'HasSettings' },
	'hastranslation' => { 445 => 'hasTranslation' },
	'hasvisibleoverprint' => { 460 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 460 => 'HasVisibleTransparency' },
	'hdr' => { 57 => 0x1, 197 => 0x4, 288 => 0x9e, 322 => 0x85, 378 => 0x200a },
	'hdreffect' => { 57 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 197 => 0x0 },
	'hdrlevel' => { 197 => 0x5, 368 => 0x2e, 383 => 0x17 },
	'hdrlevel2' => { 197 => 0x7 },
	'hdrsetting' => { 368 => 0x2d, 383 => 0x16, 386 => 0x1148, 387 => 0x1148, 388 => 0x1124, 389 => 0x11a0, 390 => 0x117c, 391 => 0x1034, 392 => 0x22c, 393 => 0x22c, 394 => 0x21f },
	'hdrsmoothing' => { 197 => 0x6 },
	'headline' => { 121 => 0x69, 441 => 'Headline', 443 => 'Headline' },
	'hierarchicalkeywords' => { 158 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 158 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 158 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 158 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 158 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 158 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 422 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 292 => 0x1a },
	'highisomultipliergreen' => { 292 => 0x19 },
	'highisomultiplierred' => { 292 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 27 => 0xc9, 59 => 0x5, 78 => 0x202, 118 => 0x100e, 204 => 0xb1, 322 => 0x71, 366 => 0x2c, 367 => 0x26, 368 => 0x26, 378 => 0x2009, 383 => 0x12, 407 => 0x42 },
	'highisonoisereduction2' => { 378 => 0xb050 },
	'highlight' => { 358 => 0xf },
	'highlightadj' => { 97 => 0x2030c },
	'highlightcolordistortreduct' => { 411 => 0x8026 },
	'highlightlinearitylimit' => { 355 => 0xa025 },
	'highlightprotection' => { 242 => 0x6 },
	'highlightrecovery' => { 431 => 'HighlightRecovery' },
	'highlights' => { 424 => 'Highlights' },
	'highlights2012' => { 431 => 'Highlights2012' },
	'highlighttone' => { 118 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 27 => 0x7, 59 => 0x3, 78 => 0x203 },
	'highlowkeyadj' => { 322 => 0x6c },
	'highspeedsync' => { 170 => 0x5, 366 => 0x2, 367 => 0x2 },
	'histogramxml' => { 243 => 0x83a1a25 },
	'history' => { 443 => 'History', 456 => 'History' },
	'historyaction' => { 456 => [\'History','HistoryAction'] },
	'historychanged' => { 456 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 456 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 456 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 456 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 456 => [\'History','HistoryWhen'] },
	'hometowncity' => { 107 => 0x3006, 322 => 0x23, 328 => 0x2 },
	'hometowncitycode' => { 329 => 0x1000 },
	'hometowndst' => { 322 => 0x25, 328 => '0.2' },
	'hostcomputer' => { 113 => 0x13c },
	'hue' => { 175 => 0x3b, 207 => 0x3d, 322 => 0x67 },
	'hueadj' => { 246 => 0x2f, 411 => 0x8019 },
	'hueadjust' => { 348 => 0x1016 },
	'hueadjustment' => { 168 => 0x4a, 169 => 0x40, 204 => 0x92, 206 => 0x36 },
	'hueadjustmentaqua' => { 431 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 431 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 431 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 431 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 431 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 431 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 431 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 431 => 'HueAdjustmentYellow' },
	'huesetting' => { 275 => 0x1011 },
	'humidity' => { 113 => 0x9401 },
	'icc_profile' => { 114 => 'ICC_Profile' },
	'iccprofilename' => { 443 => 'ICCProfile' },
	'idccreativestyle' => { 411 => 0x8000 },
	'idcpreviewlength' => { 411 => 0x202 },
	'idcpreviewstart' => { 411 => 0x201 },
	'identification' => { 112 => 'Identification' },
	'identificationid' => { 112 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 112 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 112 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 112 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 112 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 112 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 432 => 'identifier', 453 => 'Identifier' },
	'illumination' => { 261 => '0.5', 344 => 0x48 },
	'imageadjustment' => { 204 => 0x80, 233 => 0x5 },
	'imagealterationconstraints' => { 277 => 'ImageAlterationConstraints' },
	'imagearea' => { 216 => 0x10, 219 => 0x10 },
	'imageareaoffset' => { 322 => 0x38 },
	'imageauthentication' => { 204 => 0x20 },
	'imageboundary' => { 204 => 0x16 },
	'imagecount' => { 118 => 0x1438, 204 => 0xa5, 381 => 0x11b, 396 => 0x32, 397 => 0x3a },
	'imagecount2' => { 396 => 0x4c, 397 => [0x52,0x58] },
	'imagecount3' => { 396 => [0x1a0,0x1aa,0x1bd], 397 => [0x19f,0x1cb,0x1cd] },
	'imagecreator' => { 277 => 'ImageCreator' },
	'imagecreatorid' => { 277 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 277 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 277 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedata' => { 418 => 'Data' },
	'imagedatasize' => { 204 => 0xa2 },
	'imagedescription' => { 113 => 0x10e, 451 => 'ImageDescription' },
	'imageduplicationconstraints' => { 277 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 243 => 0xfe443a45 },
	'imageeditcount' => { 322 => 0x41 },
	'imageediting' => { 322 => 0x32 },
	'imageeffects' => { 348 => 0x1010 },
	'imagefileconstraints' => { 277 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 277 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 277 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 118 => 0x1436 },
	'imageheight' => { 113 => 0x101, 174 => 0xc, 331 => 0x10d, 416 => 'ImageHeight', 451 => 'ImageLength' },
	'imagehistory' => { 113 => 0x9213, 434 => 'ImageHistory' },
	'imageidnumber' => { 284 => 0x340 },
	'imagemimetype' => { 418 => 'Mime' },
	'imagenumber' => { 113 => 0x9211, 143 => 'ImageNumber', 168 => 0xae, 169 => 0x5e, 331 => 0x113, 366 => 0x9b, 368 => [0x400,'276.1',0x314], 427 => 'ImageNumber' },
	'imagenumber2' => { 169 => 0x62 },
	'imageoptimization' => { 204 => 0xa9 },
	'imageorientation' => { 121 => 0x83 },
	'imageprocessing' => { 204 => 0x1a },
	'imageprocessingversion' => { 271 => 0x0 },
	'imagequality' => { 143 => 'ImageQuality', 218 => '723.2', 219 => '732.2', 228 => '708.1', 288 => 0x1 },
	'imagequality2' => { 267 => 0x603 },
	'imagerank' => { 421 => 'ImageRank' },
	'imageref' => { 439 => 'ImageRef' },
	'imagereview' => { 252 => '0.4', 261 => '0.4' },
	'imagereviewmonitorofftime' => { 251 => '21.1', 253 => '21.1', 254 => '21.1', 258 => '20.1', 263 => '21.1', 264 => '21.1' },
	'imagereviewtime' => { 250 => '25.1', 252 => '2.1', 255 => '19.1', 256 => '20.1', 257 => '20.1', 259 => '9.2', 260 => '20.1', 265 => '21.2' },
	'imagesize' => { 149 => 'ImageSize' },
	'imagesizerestriction' => { 448 => 'imageSizeRestriction' },
	'imagesourcedata' => { 113 => 0x935c },
	'imagestabilization' => { 33 => 0x22, 107 => 0x3020, 118 => 0x1422, 143 => 'ImageStabilization', 168 => 0xbd, 169 => 0x71, 170 => 0x57, 171 => 0x0, 172 => [0x18,0x107,0x113], 173 => 0x49c2, 204 => 0xac, 267 => 0x604, 270 => 0x1600, 288 => 0x1a, 371 => 0x12, 372 => 0x11, 378 => 0xb026 },
	'imagestabilization2' => { 370 => 0xa },
	'imagestabilizationsetting' => { 173 => 0x14, 366 => 0x3d, 367 => 0x3d, 377 => 0x14 },
	'imagestyle' => { 366 => 0x2d, 367 => 0x27 },
	'imagesupplier' => { 277 => 'ImageSupplier' },
	'imagesupplierid' => { 277 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 277 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 277 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 115 => 0x1 },
	'imagetemperaturemin' => { 115 => 0x2 },
	'imagetone' => { 322 => 0x4f },
	'imagetype' => { 121 => 0x82, 277 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 60 => 0x28, 113 => 0xa420, 434 => 'ImageUniqueID', 435 => 'ImageUniqueID' },
	'imagewidth' => { 113 => 0x100, 174 => 0xe, 331 => 0x10c, 416 => 'ImageWidth', 451 => 'ImageWidth' },
	'incrementaltemperature' => { 431 => 'IncrementalTemperature' },
	'incrementaltint' => { 431 => 'IncrementalTint' },
	'industry' => { 445 => 'industry', 446 => 'industry' },
	'infobuttonwhenshooting' => { 78 => 0x409 },
	'infraredilluminator' => { 343 => 0x28 },
	'ingredientexclusion' => { 447 => 'ingredientExclusion' },
	'ingredients' => { 456 => 'Ingredients' },
	'ingredientsalternatepaths' => { 456 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 456 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 456 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 456 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 456 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 456 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 456 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 456 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 456 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 456 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 456 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 456 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 456 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 456 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 456 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 456 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 456 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 456 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 456 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 456 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 456 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 456 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 456 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 78 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 419 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 419 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 419 => 'InitialViewHeadingDegrees', 420 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 419 => 'InitialViewPitchDegrees', 420 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 419 => 'InitialViewRollDegrees', 420 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 250 => '4.4' },
	'initialzoomsetting' => { 250 => '9.3', 259 => '27.3' },
	'inkset' => { 113 => 0x14c },
	'inputprofile' => { 127 => 0x1389 },
	'instanceid' => { 456 => 'InstanceID' },
	'instantplaybacksetup' => { 170 => 0x3e },
	'instantplaybacktime' => { 170 => 0x3d },
	'instructions' => { 443 => 'Instructions' },
	'instrument' => { 455 => 'instrument' },
	'intellectualgenre' => { 440 => 'IntellectualGenre' },
	'intelligentauto' => { 378 => 0xb052, 403 => 0xd, 404 => 0xe, 405 => 0xd },
	'intelligentcontrast' => { 49 => 0x4 },
	'intelligentd-range' => { 288 => 0x79 },
	'intelligentexposure' => { 288 => 0x5d },
	'intelligentresolution' => { 288 => 0x70 },
	'interchangecolorspace' => { 123 => 0x40 },
	'internalflash' => { 167 => 0x2b, 250 => '23.1', 252 => '8.1', 255 => '22.1', 257 => '23.1', 261 => '8.1', 265 => '24.1', 270 => 0x1208 },
	'internalflashae1' => { 272 => 0x1021 },
	'internalflashae1_0' => { 272 => 0x101d },
	'internalflashae2' => { 272 => 0x1022 },
	'internalflashae2_0' => { 272 => 0x101e },
	'internalflashmode' => { 310 => 0x1 },
	'internalflashstrength' => { 310 => 0x3 },
	'internalflashtable' => { 272 => 0x1024 },
	'internallensserialnumber' => { 355 => 0xa005 },
	'internalndfilter' => { 288 => 0x9d },
	'internalserialnumber' => { 60 => 0x96, 71 => 0x9, 118 => 0x10, 173 => 0x49dc, 266 => 0x18, 268 => 0x102, 286 => 0x500, 288 => 0x25, 302 => 0x4, 348 => 0x5, 396 => [0x7c,0xf0], 397 => 0x88 },
	'interopindex' => { 113 => 0x1, 436 => 'InteroperabilityIndex' },
	'interopversion' => { 113 => 0x2 },
	'intervallength' => { 167 => 0x10 },
	'intervalmode' => { 167 => 0x26 },
	'intervalnumber' => { 167 => 0x11 },
	'intervalshooting' => { 322 => 0x92 },
	'introtime' => { 455 => 'introTime' },
	'introtimescale' => { 455 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 455 => [\'introTime','introTimeValue'] },
	'iptc' => { 114 => 'IPTC' },
	'iptc-naa' => { 113 => 0x83bb, 292 => 0x83bb },
	'iptcbitspersample' => { 123 => 0x56 },
	'iptcdigest' => { 336 => 0x425 },
	'iptcimageheight' => { 123 => 0x1e },
	'iptcimagerotation' => { 123 => 0x66 },
	'iptcimagewidth' => { 123 => 0x14 },
	'iptclastedited' => { 441 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 123 => 0xa },
	'iptcpixelheight' => { 123 => 0x32 },
	'iptcpixelwidth' => { 123 => 0x28 },
	'isalternativeof' => { 445 => 'isAlternativeOf' },
	'isbn' => { 445 => 'isbn' },
	'iscorrectionof' => { 445 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 103 => 0x3 },
	'ismergedhdr' => { 427 => 'IsMergedHDR' },
	'ismergedpanorama' => { 427 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x0, 30 => 0x1, 106 => 0x14, 107 => [0x3014,0x14], 113 => 0x8827, 126 => 0xfd06, 127 => 0x1784, 129 => 0x60, 131 => [0xfa2e,0xfa46], 132 => [0x27,0x28], 133 => 0xf105, 136 => 0x14, 138 => 0x4e, 141 => 0x34, 143 => 'ISO', 167 => 0x8, 173 => 0x49ba, 198 => 0x0, 204 => 0x2, 292 => 0x17, 322 => [0x8b,0x14], 329 => 0x14, 331 => 0x105, 355 => 0xa014, 377 => 0x6f, 383 => [0x1f,0x21,0x25], 435 => 'ISOSpeedRatings' },
	'iso2' => { 198 => 0x6, 213 => 0x265, 214 => 0x25c, 215 => 0x265, 216 => 0x221, 217 => 0x25d, 218 => 0x256, 219 => 0x25d, 223 => 0x2b5, 226 => 0x265, 232 => 0x2b5 },
	'isoauto' => { 303 => '14.4' },
	'isoautohilimit' => { 221 => 0x18eb, 222 => 0xe82, 230 => 0x185d },
	'isoautoparameters' => { 322 => 0x7a },
	'isoautoshuttertime' => { 221 => 0x18ea, 222 => 0xe81, 230 => 0x185c },
	'isodisplay' => { 253 => '4.1', 254 => '4.1', 255 => '2.3', 256 => '3.3', 257 => '3.3', 260 => '3.3', 263 => '4.3', 264 => '4.1', 265 => '4.3' },
	'isoexpansion' => { 78 => 0x103, 79 => 0x7, 80 => 0x8, 83 => 0x8, 198 => 0x4 },
	'isoexpansion2' => { 198 => 0xa },
	'isofloor' => { 303 => 0x6 },
	'isoselection' => { 204 => 0xf },
	'isosensitivitystep' => { 258 => '6.2', 260 => '6.2' },
	'isosetting' => { 129 => 0x5e, 143 => 'ISOSetting', 167 => 0x24, 168 => 0x26, 169 => 0x1c, 170 => 0x13, 175 => 0x6, 204 => 0x13, 303 => '17.3', 347 => 0x27, 366 => 0x16, 367 => 0x14, 368 => 0x2, 377 => 0x6d },
	'isospeed' => { 113 => 0x8833, 436 => 'ISOSpeed' },
	'isospeedexpansion' => { 77 => 0x3 },
	'isospeedincrements' => { 78 => 0x102 },
	'isospeedlatitudeyyy' => { 113 => 0x8834, 436 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 113 => 0x8835, 436 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 78 => 0x103 },
	'isostepsize' => { 250 => '6.1', 251 => '7.2', 253 => '7.2', 254 => '7.2', 259 => '4.1', 263 => '7.2', 264 => '7.2' },
	'isovalue' => { 272 => 0x1001 },
	'issn' => { 445 => 'issn' },
	'issueidentifier' => { 445 => 'issueIdentifier' },
	'issuename' => { 445 => 'issueName' },
	'issueteaser' => { 445 => 'issueTeaser' },
	'issuetype' => { 445 => 'issueType' },
	'istranslationof' => { 445 => 'isTranslationOf' },
	'itemsubtype' => { 165 => 'ItemSubType' },
	'jobid' => { 121 => 0xb8 },
	'jobname' => { 437 => 'JobName' },
	'jobref' => { 454 => 'JobRef' },
	'jobrefid' => { 454 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 454 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 454 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 437 => 'JobStatus' },
	'jpeghandling' => { 431 => 'JPEGHandling' },
	'jpegquality' => { 9 => 0x66, 290 => 0x3034, 378 => 0xb047 },
	'jpegsize' => { 290 => 0x303a },
	'jpgcompression' => { 222 => 0x7d4 },
	'jpgfromraw' => { 91 => 0x2007, 108 => 'JpgFromRaw', 292 => 0x2e },
	'jpgfromrawlength' => { 113 => [0x117,0x202] },
	'jpgfromrawstart' => { 113 => [0x111,0x201] },
	'jpgrecordedpixels' => { 303 => '14.1' },
	'jurisdiction' => { 428 => 'jurisdiction' },
	'kelvinwb_01' => { 311 => 0x5 },
	'kelvinwb_02' => { 311 => 0x9 },
	'kelvinwb_03' => { 311 => 0xd },
	'kelvinwb_04' => { 311 => 0x11 },
	'kelvinwb_05' => { 311 => 0x15 },
	'kelvinwb_06' => { 311 => 0x19 },
	'kelvinwb_07' => { 311 => 0x1d },
	'kelvinwb_08' => { 311 => 0x21 },
	'kelvinwb_09' => { 311 => 0x25 },
	'kelvinwb_10' => { 311 => 0x29 },
	'kelvinwb_11' => { 311 => 0x2d },
	'kelvinwb_12' => { 311 => 0x31 },
	'kelvinwb_13' => { 311 => 0x35 },
	'kelvinwb_14' => { 311 => 0x39 },
	'kelvinwb_15' => { 311 => 0x3d },
	'kelvinwb_16' => { 311 => 0x41 },
	'kelvinwb_daylight' => { 311 => 0x1 },
	'key' => { 455 => 'key' },
	'keystonecompensation' => { 271 => 0x1900 },
	'keystonedirection' => { 271 => 0x1901 },
	'keystonevalue' => { 271 => 0x1906 },
	'keyword' => { 445 => 'keyword' },
	'keywordinfo' => { 158 => 'Keywords' },
	'keywords' => { 121 => 0x19, 144 => 'Keywords', 276 => 'Keywords', 338 => 'Keywords', 425 => 'keywords', 442 => 'Keywords', 453 => 'Keywords' },
	'killdate' => { 445 => 'killDate' },
	'killdatea-platform' => { 445 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 445 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 126 => 0xf908, 129 => 0xe, 131 => [0xfa1e,0xfa52], 137 => 0x70 },
	'kodakimagewidth' => { 126 => 0xf907, 129 => 0xc, 131 => [0xfa1d,0xfa51], 137 => 0x6c },
	'kodakinfotype' => { 126 => 0xfa00 },
	'kodaklook' => { 127 => 0xe4c },
	'kodaklookprofile' => { 127 => 0x138a },
	'kodakmaker' => { 137 => 0x8 },
	'kodakmodel' => { 129 => 0x0, 137 => 0x28 },
	'label' => { 280 => 'Label', 453 => 'Label' },
	'labelname1' => { 439 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 439 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 288 => 0x6f },
	'landscapeoutputhighlightpoint' => { 103 => 0x26 },
	'landscapeoutputshadowpoint' => { 103 => 0x27 },
	'landscaperawcolortone' => { 103 => 0x1f },
	'landscaperawcontrast' => { 103 => 0x21 },
	'landscaperawhighlight' => { 103 => 0x77 },
	'landscaperawhighlightpoint' => { 103 => 0x24 },
	'landscaperawlinear' => { 103 => 0x22 },
	'landscaperawsaturation' => { 103 => 0x20 },
	'landscaperawshadow' => { 103 => 0x80 },
	'landscaperawshadowpoint' => { 103 => 0x25 },
	'landscaperawsharpness' => { 103 => 0x23 },
	'landscapeunsharpmaskfineness' => { 103 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 103 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 103 => 0xa2 },
	'language' => { 432 => 'language' },
	'languageidentifier' => { 121 => 0x87 },
	'largestvalidinteriorrectheight' => { 419 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 419 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 419 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 419 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 167 => 0x1b },
	'lastkeywordiptc' => { 165 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 165 => 'LastKeywordXMP' },
	'lastphotodate' => { 419 => 'LastPhotoDate' },
	'lasturl' => { 456 => 'LastURL' },
	'lateralchromaticaberration' => { 378 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 427 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 112 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 112 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 112 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 112 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 313 => 0x2 },
	'lc10' => { 313 => 0xb },
	'lc11' => { 313 => 0xc },
	'lc12' => { 313 => 0xd },
	'lc14' => { 313 => 0xf },
	'lc15' => { 313 => 0x10 },
	'lc3' => { 313 => 0x4 },
	'lc4' => { 313 => 0x5 },
	'lc5' => { 313 => 0x6 },
	'lc6' => { 313 => 0x7 },
	'lc7' => { 313 => 0x8 },
	'lc8' => { 313 => 0x9 },
	'lcddisplayatpoweron' => { 78 => 0x811, 82 => 0xa },
	'lcddisplayreturntoshoot' => { 83 => 0x12 },
	'lcdillumination' => { 250 => '17.5', 251 => '5.2', 253 => '5.1', 254 => '5.1', 259 => '10.3', 260 => '4.2', 263 => '5.2', 264 => '5.1', 265 => '5.4' },
	'lcdilluminationduringbulb' => { 78 => 0x408 },
	'lcdpanels' => { 77 => 0x8 },
	'lcheditor' => { 243 => 0x8ae85e },
	'legacyiptcdigest' => { 443 => 'LegacyIPTCDigest' },
	'legalcode' => { 428 => 'legalcode' },
	'lens' => { 113 => 0xfdea, 204 => 0x84, 427 => 'Lens' },
	'lensafstopbutton' => { 76 => 0x11, 77 => 0x13, 78 => 0x506, 79 => 0x10, 80 => 0x12, 83 => 0x13, 84 => 0x9 },
	'lensaperturerange' => { 358 => [0x30,0x48] },
	'lenscorrectionsettings' => { 434 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 427 => 'LensDistortInfo' },
	'lensdistortionparams' => { 272 => 0x206 },
	'lensdrivenoaf' => { 78 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 368 => 0x3f0, 410 => 0xd },
	'lensfirmware' => { 349 => 0x20, 355 => 0xa004 },
	'lensfirmwareversion' => { 268 => 0x204, 288 => 0x60, 368 => 0x3f3, 410 => 0x14 },
	'lensfocallength' => { 97 => 0xf0512, 313 => 0x9 },
	'lensfocalrange' => { 358 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 251 => '55.1', 253 => '52.1', 254 => '52.1', 263 => '52.1', 264 => '52.1' },
	'lensformat' => { 390 => 0x1891, 392 => 0x18bd, 393 => 0x18ed, 394 => 0x17f1, 396 => 0x106, 397 => 0x106, 406 => 0x603, 407 => 0x5d },
	'lensfstops' => { 199 => 0x7, 200 => 0xc, 201 => 0xd, 204 => 0x8b, 313 => '0.3' },
	'lensid' => { 427 => 'LensID' },
	'lensidnumber' => { 199 => 0x6, 200 => 0xb, 201 => 0xc },
	'lensinfo' => { 113 => 0xa432, 319 => 0x2a, 427 => 'LensInfo', 436 => 'LensSpecification' },
	'lenskind' => { 313 => 0x1 },
	'lensmake' => { 113 => 0xa433, 150 => 'Make', 436 => 'LensMake' },
	'lensmanualdistortionamount' => { 431 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 165 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 358 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 60 => 0x95, 113 => 0xa434, 150 => 'Model', 165 => 'LensModel', 202 => 0x18a, 268 => 0x203, 286 => 0x303, 319 => 0xc, 331 => 0x412, 436 => 'LensModel' },
	'lensmount' => { 368 => 0x99, 390 => 0x1892, 392 => 0x18be, 393 => 0x18ee, 394 => 0x17f2, 396 => 0x105, 397 => 0x105, 406 => 0x604, 407 => 0x5e },
	'lensmount2' => { 410 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 431 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 431 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 431 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 431 => 'LensProfileEnable' },
	'lensprofilefilename' => { 431 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 431 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 431 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 431 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 431 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 431 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 431 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 431 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 431 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 431 => 'LensProfileName' },
	'lensprofilesetup' => { 431 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 431 => 'LensProfileVignettingScale' },
	'lensproperties' => { 268 => 0x20b },
	'lensserialnumber' => { 20 => 0x164, 31 => 0x16b, 58 => 0x0, 113 => 0xa435, 150 => 'SerialNumber', 268 => 0x202, 288 => 0x52, 349 => 0x30, 427 => 'LensSerialNumber', 436 => 'LensSerialNumber' },
	'lensshutterlock' => { 170 => 0x4a },
	'lensspec' => { 363 => 0x0, 364 => 0x0, 365 => 0x0, 378 => 0xb02a },
	'lensspecfeatures' => { 396 => [0x115,0x116], 397 => [0x116,0x21c,0x21e] },
	'lenstemperature' => { 272 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x184, 27 => 0x112, 28 => 0x189, 33 => 0x16, 172 => 0x10c, 173 => 0x49bd, 204 => 0x83, 268 => 0x201, 281 => 0x16, 284 => 0x310, 287 => 0x303, 288 => 0x51, 290 => 0x3405, 314 => 0x0, 315 => 0x0, 316 => 0x1, 317 => 0x1, 318 => 0x1, 320 => 0x0, 355 => 0xa003, 358 => 0x27, 378 => 0xb027, 390 => 0x1896, 392 => 0x18c2, 393 => 0x18f2, 394 => 0x17f6, 396 => 0x109, 397 => 0x109, 406 => 0x608, 407 => 0x62 },
	'lenstype2' => { 368 => 0x3f7, 390 => 0x1893, 392 => 0x18bf, 393 => 0x18ef, 394 => 0x17f3, 396 => 0x107, 397 => 0x107, 406 => 0x605, 407 => 0x60 },
	'lenstype3' => { 410 => 0x9 },
	'lenszoomposition' => { 403 => 0x19, 404 => 0x1e, 407 => [0x342,0x35a] },
	'levelindicator' => { 295 => 0x15 },
	'levelorientation' => { 321 => 0x0 },
	'license' => { 428 => 'license' },
	'licensee' => { 277 => 'Licensee' },
	'licenseeid' => { 277 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 277 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 277 => 'LicenseeImageNotes' },
	'licenseename' => { 277 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 277 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 277 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 277 => 'LicenseeTransactionID' },
	'licenseid' => { 277 => 'LicenseID' },
	'licensestartdate' => { 277 => 'LicenseStartDate' },
	'licensetransactiondate' => { 277 => 'LicenseTransactionDate' },
	'licensetype' => { 433 => 'licensetype' },
	'licensor' => { 277 => 'Licensor' },
	'licensorcity' => { 277 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 277 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 277 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 277 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 277 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 277 => 'LicensorImageID' },
	'licensorname' => { 277 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 277 => 'LicensorNotes' },
	'licensorpostalcode' => { 277 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 277 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 277 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 277 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 277 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 277 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 277 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 277 => 'LicensorTransactionID' },
	'licensorurl' => { 277 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 272 => 0x1009 },
	'lightingmode' => { 107 => 0x302a },
	'lightreading' => { 322 => 0x15 },
	'lightsource' => { 113 => 0x9208, 204 => 0x90, 275 => 0x1000, 435 => 'LightSource' },
	'lightsourcespecial' => { 357 => 0x21d },
	'lightswitch' => { 263 => '0.1', 265 => '0.1' },
	'lightvaluecenter' => { 272 => 0x103d },
	'lightvalueperiphery' => { 272 => 0x103e },
	'limitafareamodeselection' => { 251 => '51.1', 253 => '49.1', 254 => '49.1', 263 => '49.1', 264 => '49.1' },
	'linearitylimitblue' => { 292 => 0x10 },
	'linearitylimitgreen' => { 292 => 0xf },
	'linearitylimitred' => { 292 => 0xe },
	'linearityuppermargin' => { 42 => [0x2ba,0x2d1,0x2d5], 44 => 0x1e5, 45 => [0x1fe,0x2de], 46 => [0x232,0x310], 47 => 0x31e },
	'linearizationtable' => { 113 => 0xc618 },
	'linearresponselimit' => { 113 => 0xc62e },
	'link' => { 445 => 'link' },
	'linkaetoafpoint' => { 303 => '14.2' },
	'linkedencodedrightsexpr' => { 441 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 441 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 441 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 441 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 112 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 255 => '32.1', 265 => '34.1' },
	'liveviewafareamode' => { 260 => '34.1' },
	'liveviewafmethod' => { 383 => 0x20 },
	'liveviewafmode' => { 260 => '34.2' },
	'liveviewafsetting' => { 368 => 0x36 },
	'liveviewbuttonoptions' => { 251 => '50.2', 253 => '48.2', 254 => '48.2', 263 => '48.2', 264 => '48.2' },
	'liveviewexposuresimulation' => { 78 => 0x810 },
	'liveviewfocusmode' => { 368 => [0x8b,0x28b] },
	'liveviewmetering' => { 368 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 251 => '21.2', 253 => '21.2', 254 => '21.2', 256 => '20.2', 257 => '20.2', 258 => '20.2', 260 => '20.2', 263 => '21.2', 264 => '21.2' },
	'liveviewshooting' => { 54 => 0x13 },
	'localcaption' => { 121 => 0x79 },
	'localizedcameramodel' => { 113 => 0xc615 },
	'locallocationname' => { 355 => 0x30 },
	'location' => { 203 => 0x9, 288 => 0x67, 423 => 'Location', 440 => 'Location', 444 => 'location', 445 => 'location' },
	'locationareacode' => { 429 => 'lac' },
	'locationcreated' => { 441 => 'LocationCreated' },
	'locationcreatedcity' => { 441 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 441 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 441 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 441 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 441 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 441 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 441 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 441 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 441 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 441 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 441 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 441 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 203 => 0x0 },
	'locationname' => { 355 => 0x31 },
	'locationshown' => { 441 => 'LocationShown' },
	'locationshowncity' => { 441 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 441 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 441 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 441 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 441 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 441 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 441 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 441 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 441 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 441 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 441 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 441 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 78 => 0x709 },
	'logcomment' => { 455 => 'logComment' },
	'longexposurenoisereduction' => { 59 => 0x4, 78 => 0x201, 79 => 0x1, 80 => 0x2, 81 => 0x1, 82 => 0x1, 83 => 0x2, 84 => 0x1, 288 => 0x49, 366 => 0x2b, 367 => 0x25, 368 => 0x25, 378 => 0x2008, 383 => 0x11, 407 => 0x44 },
	'longexposurenoisereduction2' => { 54 => 0x8 },
	'loop' => { 455 => 'loop' },
	'lowestbiostratigraphiczone' => { 112 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 431 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 431 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 431 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 431 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 431 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 431 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 431 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 431 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 102 => 0x150 },
	'luminancecurvepoints' => { 102 => 0x126 },
	'luminancenoisereduction' => { 97 => 0x20600, 103 => 0x5f, 358 => 0x1b },
	'luminancenoisereductioncontrast' => { 431 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 431 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 103 => 0x6d },
	'luminancesmoothing' => { 431 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 78 => [0x40b,0x40c] },
	'lyrics' => { 455 => 'lyrics' },
	'm16cversion' => { 284 => 0x333 },
	'macatom' => { 430 => 'macAtom' },
	'macatomapplicationcode' => { 430 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 430 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 430 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 118 => 0x1020, 119 => 0x202, 272 => 0x202, 347 => 0x21, 357 => 0x202, 378 => 0xb040 },
	'macroled' => { 270 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 54 => 0x10 },
	'macromode' => { 33 => 0x1, 167 => 0xb, 267 => 0x300, 288 => 0x1c, 348 => 0x1009 },
	'magentahsl' => { 97 => 0x20917 },
	'magicfilter' => { 267 => 0x52c },
	'magnifiedview' => { 80 => 0x11, 82 => 0x9 },
	'maindialexposurecomp' => { 261 => '0.6' },
	'mainingredient' => { 447 => 'mainIngredient' },
	'make' => { 92 => 0x0, 109 => 0x1, 113 => 0x10f, 143 => 'Make', 280 => 'Make', 292 => 0x10f, 444 => 'make', 451 => 'Make' },
	'makernote' => { 435 => 'MakerNote' },
	'makernoteapple' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecanon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio' => { 111 => 'MakN', 113 => 0x927c },
	'makernotecasio2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotedji' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteflir' => { 111 => 'MakN', 113 => 0x927c },
	'makernotefujifilm' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege' => { 111 => 'MakN', 113 => 0x927c },
	'makernotege2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehasselblad' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotehp6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteisl' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvc' => { 111 => 'MakN', 113 => 0x927c },
	'makernotejvctext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak10' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak11' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak6b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak7' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak8c' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodak9' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekodakunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernotekyocera' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica3' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica4' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica5' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica6' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica7' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica8' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteleica9' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta2' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteminolta3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotemotorola' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenikon3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotenintendo' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteoffset' => { 357 => 0xff },
	'makernoteolympus' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteolympus2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepanasonic2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotepentax6' => { 111 => 'MakN', 113 => 0x927c },
	'makernotephaseone' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx' => { 111 => 'MakN', 113 => 0x927c },
	'makernotereconyx2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericoh2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotericohtext' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesafety' => { 113 => 0xc635 },
	'makernotesamsung1a' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung1b' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesamsung2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyo' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyoc4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesanyopatch' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesigma' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony2' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony3' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony4' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesony5' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonyericsson' => { 111 => 'MakN', 113 => 0x927c },
	'makernotesonysrf' => { 111 => 'MakN', 113 => 0x927c },
	'makernotetype' => { 348 => 0x1 },
	'makernoteunknown' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknownbinary' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteunknowntext' => { 111 => 'MakN', 113 => 0x927c },
	'makernoteversion' => { 172 => 0x0, 204 => 0x1, 272 => 0x0, 288 => 0x8000, 352 => 0x0, 355 => 0x1, 358 => [0x1d,0x1f], 369 => 0x2000 },
	'managedfrom' => { 456 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 456 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 456 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 456 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 456 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 456 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 456 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 456 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 456 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 456 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 456 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 456 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 456 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 456 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 456 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 456 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 456 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 456 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 456 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 456 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 456 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 456 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 456 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 456 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 456 => 'Manager' },
	'managervariant' => { 456 => 'ManagerVariant' },
	'manageto' => { 456 => 'ManageTo' },
	'manageui' => { 456 => 'ManageUI' },
	'manifest' => { 456 => 'Manifest' },
	'manifestlinkform' => { 456 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 456 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 456 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 456 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 456 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 456 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 456 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 456 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 456 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 456 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 456 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 456 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 456 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 456 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 456 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 456 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 456 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 456 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 456 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 456 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 456 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 456 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 456 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 456 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 456 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 456 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 456 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 456 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 267 => 0x900, 288 => 0x86 },
	'manometerreading' => { 267 => 0x901 },
	'manualafpointselectpattern' => { 78 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 270 => 0x1209 },
	'manualflashoutput' => { 33 => 0x29, 252 => '8.2', 255 => '22.2', 256 => '23.1', 257 => '23.2', 259 => '16.2', 260 => '23.2', 261 => '8.2', 262 => '23.2', 265 => '24.2', 348 => 0x100c },
	'manualflashstrength' => { 267 => 0x406 },
	'manualfocusdistance' => { 204 => 0x85, 272 => 0x100c, 357 => 0x223 },
	'manualtv' => { 77 => 0x5, 78 => 0x705 },
	'manufacturedate' => { 177 => 0x6705, 302 => 0x1 },
	'manufacturedate1' => { 350 => 0x4 },
	'manufacturedate2' => { 350 => 0x5 },
	'manufacturer' => { 416 => 'Manufacturer', 444 => 'manufacturer' },
	'marked' => { 442 => 'Marked', 459 => 'Marked' },
	'markers' => { 455 => 'markers' },
	'markerscomment' => { 455 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 455 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 455 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 455 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 455 => [\'markers','markersCuePointType'] },
	'markersduration' => { 455 => [\'markers','markersDuration'] },
	'markerslocation' => { 455 => [\'markers','markersLocation'] },
	'markersname' => { 455 => [\'markers','markersName'] },
	'markersprobability' => { 455 => [\'markers','markersProbability'] },
	'markersspeaker' => { 455 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 455 => [\'markers','markersStartTime'] },
	'markerstarget' => { 455 => [\'markers','markersTarget'] },
	'markerstype' => { 455 => [\'markers','markersType'] },
	'maskedareas' => { 113 => 0xc68e },
	'masterdocumentid' => { 121 => 0xb9 },
	'mastergain' => { 211 => 0x50 },
	'matrixmetering' => { 251 => '50.1', 253 => '48.1', 254 => '48.1', 263 => '48.1', 264 => '48.1' },
	'maxaperture' => { 33 => 0x1a, 133 => 0x6103, 150 => 'MaxAperture', 167 => 0x17, 173 => 0x49c5, 268 => 0x20a, 313 => '14.1' },
	'maxapertureatmaxfocal' => { 118 => 0x1407, 150 => 'MaxApertureAtMaxFocal', 199 => 0xb, 200 => 0x10, 201 => 0x11, 268 => 0x206 },
	'maxapertureatminfocal' => { 118 => 0x1406, 199 => 0xa, 200 => 0xf, 201 => 0x10, 268 => 0x205 },
	'maxaperturevalue' => { 113 => 0x9205, 331 => 0x414, 435 => 'MaxApertureValue' },
	'maxavailheight' => { 441 => 'MaxAvailHeight' },
	'maxavailwidth' => { 441 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 250 => 0xb, 251 => 0xc, 253 => '12.1', 254 => '12.1', 259 => 0xc, 260 => 0xb, 263 => '12.1', 264 => '12.1' },
	'maxfaces' => { 271 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x188, 27 => 0x116, 28 => 0x18d, 33 => 0x17, 118 => 0x1405, 150 => 'MaxFocalLength', 199 => 0x9, 200 => 0xe, 201 => 0xf, 268 => 0x208, 390 => 0x127c, 391 => 0x1138, 392 => 0x330, 393 => 0x330, 394 => 0x30e },
	'maximumdensityrange' => { 123 => 0x8c },
	'maxpagesize' => { 460 => 'MaxPageSize' },
	'maxpagesizeh' => { 460 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 460 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 460 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 113 => 0x119 },
	'maxstorage' => { 450 => 'maxstorage' },
	'mb-d10batteries' => { 250 => '12.6' },
	'mb-d10batterytype' => { 259 => '13.3' },
	'mb-d11batterytype' => { 260 => '2.3' },
	'mb-d12batterytype' => { 263 => '3.2' },
	'mb-d80batteries' => { 261 => '6.5' },
	'mb-d80batterytype' => { 265 => '3.2' },
	'mcuversion' => { 199 => 0xc, 200 => 0x11, 201 => 0x12 },
	'md5digest' => { 151 => 'zmd5' },
	'mditemfindercomment' => { 160 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 160 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 160 => 'MDItemFSLabel' },
	'meal' => { 447 => 'meal' },
	'measuredev' => { 27 => 0x9, 72 => 0x3, 91 => 0x1814, 143 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 27 => 0x8, 72 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 173 => 0x690, 284 => 0x312, 290 => 0x3407 },
	'measuredrggb' => { 61 => 0x1 },
	'measuredrggbdata' => { 41 => 0x287 },
	'measurementaccuracy' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 112 => 'MeasurementOrFact' },
	'measurementremarks' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 112 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 416 => 'MeasureType' },
	'mechanicalshuttercount' => { 204 => 0x37 },
	'mediaconstraints' => { 277 => 'MediaConstraints' },
	'mediacreatedate' => { 339 => 0x1 },
	'mediaeventiddate' => { 421 => 'MediaEventIdDate' },
	'mediamodifydate' => { 339 => 0x2 },
	'mediasummarycode' => { 277 => 'MediaSummaryCode' },
	'memoaudioquality' => { 78 => 0x812 },
	'memorycardconfiguration' => { 372 => 0x16 },
	'memorycardnumber' => { 191 => 0x2 },
	'menubuttondisplayposition' => { 76 => 0xb, 79 => 0xa, 80 => 0xb, 83 => 0xb },
	'menubuttonreturn' => { 84 => 0xb },
	'menumonitorofftime' => { 250 => '26.1', 251 => '22.1', 253 => '22.1', 254 => '22.1', 258 => '21.1', 259 => '8.2', 260 => '21.1', 263 => '22.1', 264 => '22.1', 265 => '22.1' },
	'metadatadate' => { 453 => 'MetadataDate' },
	'metadatamoddate' => { 455 => 'metadataModDate' },
	'metaversion' => { 385 => 0x34 },
	'meterinfo1row1' => { 379 => 0x0, 380 => 0x0 },
	'meterinfo1row2' => { 379 => 0x6c, 380 => 0x5a },
	'meterinfo1row3' => { 379 => 0xd8, 380 => 0xb4 },
	'meterinfo1row4' => { 379 => 0x144, 380 => 0x10e },
	'meterinfo1row5' => { 379 => 0x1b0, 380 => 0x168 },
	'meterinfo1row6' => { 379 => 0x21c, 380 => 0x1c2 },
	'meterinfo1row7' => { 379 => 0x288, 380 => 0x21c },
	'meterinfo2row1' => { 379 => 0x2f4, 380 => 0x276 },
	'meterinfo2row2' => { 379 => 0x378, 380 => 0x2e4 },
	'meterinfo2row3' => { 379 => 0x3fc, 380 => 0x352 },
	'meterinfo2row4' => { 379 => 0x480, 380 => 0x3c0 },
	'meterinfo2row5' => { 379 => 0x504, 380 => 0x42e },
	'meterinfo2row6' => { 379 => 0x588, 380 => 0x49c },
	'meterinfo2row7' => { 379 => 0x60c, 380 => 0x50a },
	'meterinfo2row8' => { 379 => 0x690, 380 => 0x578 },
	'meterinfo2row9' => { 379 => 0x714, 380 => 0x5e6 },
	'metering' => { 252 => '6.1' },
	'meteringmode' => { 33 => 0x11, 113 => 0x9207, 129 => 0x1c, 167 => 0x7, 168 => 0x25, 170 => 0x12, 267 => 0x202, 322 => 0x17, 358 => 0x9, 366 => 0x15, 367 => 0x13, 368 => 0x7, 383 => 0x3, 386 => 0x1174, 387 => 0x1178, 388 => 0x1154, 389 => 0x11d0, 390 => 0x11ac, 391 => 0x1064, 392 => 0x25c, 393 => 0x25c, 394 => 0x24b, 435 => 'MeteringMode' },
	'meteringmode2' => { 303 => '2.1', 378 => 0x202c },
	'meteringmode3' => { 303 => '16.1' },
	'meteringoffscaleindicator' => { 170 => 0x53 },
	'meteringtime' => { 250 => '22.2', 252 => '3.2', 255 => '17.1', 256 => '18.1', 259 => '7.3', 260 => '18.1', 261 => '3.2', 265 => '19.1' },
	'micro1version' => { 344 => 0x1f },
	'micro2version' => { 344 => 0x2d },
	'mieversion' => { 151 => '0Vers' },
	'mime' => { 416 => 'Mime' },
	'minaperture' => { 33 => 0x1b, 150 => 'MinAperture', 313 => '0.2' },
	'minaperturevalue' => { 331 => 0x415 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x186, 27 => 0x114, 28 => 0x18b, 33 => 0x18, 118 => 0x1404, 150 => 'MinFocalLength', 199 => 0x8, 200 => 0xd, 201 => 0xe, 268 => 0x207, 390 => 0x127a, 391 => 0x1136, 392 => 0x32e, 393 => 0x32e, 394 => 0x30c },
	'minfocusdistance' => { 313 => 0x3 },
	'minoltadate' => { 167 => 0x15 },
	'minoltaimagesize' => { 167 => 0x4, 168 => 0xc, 169 => 0x2, 172 => 0x103 },
	'minoltamodelid' => { 167 => 0x25 },
	'minoltaquality' => { 167 => 0x5, 168 => 0xd, 169 => 0x3, 172 => [0x102,0x103] },
	'minoltatime' => { 167 => 0x16 },
	'minormodelagedisclosure' => { 277 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 113 => 0x118 },
	'mirrorlockup' => { 76 => 0xc, 77 => 0xc, 78 => 0x60f, 79 => 0xb, 80 => 0xc, 81 => 0x6, 82 => 0x6, 83 => 0xc, 84 => 0x3 },
	'mobilecountrycode' => { 429 => 'mcc' },
	'mobilenetworkcode' => { 429 => 'mnc' },
	'moddate' => { 280 => 'modify-date', 442 => 'ModDate' },
	'modedialposition' => { 372 => 0x14 },
	'model' => { 92 => 0x6, 113 => 0x110, 143 => 'Model', 280 => 'Model', 292 => 0x110, 322 => 0x23f, 358 => 0x84, 416 => 'Model', 444 => 'model', 451 => 'Model' },
	'modelage' => { 441 => 'ModelAge' },
	'modelid' => { 266 => 0x0 },
	'modelingflash' => { 250 => '21.4', 251 => '31.1', 253 => '31.1', 254 => '31.1', 259 => '26.4', 260 => '30.2', 261 => '7.4', 262 => '30.1', 263 => '31.1', 264 => '31.1', 265 => '31.3' },
	'modelreleaseid' => { 277 => 'ModelReleaseID' },
	'modelreleasestatus' => { 277 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 398 => 0x52, 399 => 0x46, 400 => 0x53 },
	'modelyear' => { 444 => 'modelYear' },
	'modificationdate' => { 445 => 'modificationDate' },
	'modifiedcolortemp' => { 62 => 0x9 },
	'modifieddigitalgain' => { 62 => 0xb },
	'modifiedparamflag' => { 55 => 0x1 },
	'modifiedpicturestyle' => { 62 => 0xa },
	'modifiedsaturation' => { 267 => 0x504 },
	'modifiedsensorbluelevel' => { 62 => 0x5 },
	'modifiedsensorredlevel' => { 62 => 0x4 },
	'modifiedsharpness' => { 62 => 0x2 },
	'modifiedsharpnessfreq' => { 62 => 0x3 },
	'modifiedtonecurve' => { 62 => 0x1 },
	'modifiedwhitebalance' => { 62 => 0x8 },
	'modifiedwhitebalanceblue' => { 62 => 0x7 },
	'modifiedwhitebalancered' => { 62 => 0x6 },
	'modifydate' => { 113 => 0x132, 144 => 'ModifyDate', 276 => 'ModDate', 278 => 'tIME', 338 => 'ModDate', 340 => 0x2, 453 => 'ModifyDate' },
	'moirefilter' => { 113 => 0xfe58, 431 => 'MoireFilter' },
	'monitordisplayoff' => { 170 => 0x4c },
	'monitorofftime' => { 250 => '18.2', 252 => '3.1', 261 => '3.1' },
	'monochromecolor' => { 267 => 0x53b },
	'monochromecontrast' => { 103 => 0x3c },
	'monochromefiltereffect' => { 97 => 0x20307, 103 => 0x3a, 322 => 0x73 },
	'monochromelinear' => { 103 => 0x3d },
	'monochromeoutputhighlightpoint' => { 103 => 0x41 },
	'monochromeoutputshadowpoint' => { 103 => 0x42 },
	'monochromeprofilesettings' => { 267 => 0x537 },
	'monochromerawhighlight' => { 103 => 0x7a },
	'monochromerawhighlightpoint' => { 103 => 0x3f },
	'monochromerawshadow' => { 103 => 0x83 },
	'monochromerawshadowpoint' => { 103 => 0x40 },
	'monochromesharpness' => { 103 => 0x3e },
	'monochrometoning' => { 322 => 0x74 },
	'monochrometoningeffect' => { 97 => 0x20306, 103 => 0x3b },
	'monochromeunsharpmaskfineness' => { 103 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 103 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 103 => 0xb4 },
	'monochromevignetting' => { 267 => 0x53a },
	'monthdaycreated' => { 129 => 0x12, 138 => 0xe },
	'moonphase' => { 343 => 0x12, 344 => 0x43 },
	'morepermissions' => { 428 => 'morePermissions' },
	'motionsensitivity' => { 343 => 0x29 },
	'movieaelockbuttonassignment' => { 263 => '40.1' },
	'moviefunc1button' => { 253 => '41.1', 254 => '41.1', 264 => '41.1' },
	'moviefunctionbutton' => { 251 => '41.1', 263 => '41.1' },
	'moviefunctionbuttonplusdials' => { 251 => '52.1' },
	'moviepreviewbutton' => { 251 => '41.2', 253 => '41.2', 254 => '41.2', 263 => '41.2', 264 => '41.2' },
	'moviepreviewbuttonplusdials' => { 251 => '52.2' },
	'movieshutterbutton' => { 251 => '38.3', 253 => '38.3', 254 => '38.3', 263 => '38.3', 264 => '38.3' },
	'moviesubselectorassignment' => { 251 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 251 => '53.1' },
	'multiburstimageheight' => { 378 => 0x1002 },
	'multiburstimagewidth' => { 378 => 0x1001 },
	'multiburstmode' => { 378 => 0x1000 },
	'multicontrollerwhilemetering' => { 78 => 0x517 },
	'multiexposure' => { 64 => 0x1 },
	'multiexposureautogain' => { 205 => 0x3 },
	'multiexposurecontrol' => { 64 => 0x2 },
	'multiexposuremode' => { 205 => 0x1 },
	'multiexposureshots' => { 64 => 0x3, 205 => 0x2 },
	'multiframenoisereduction' => { 368 => 0x35, 378 => 0x200b, 383 => 0x15 },
	'multiframenreffect' => { 378 => 0x2023 },
	'multifunctionlock' => { 78 => 0x70f },
	'multipleexposuremode' => { 271 => 0x101c },
	'multipleexposureset' => { 303 => '10.1' },
	'multisample' => { 211 => 0x40 },
	'multiselector' => { 250 => '9.4', 251 => '10.3', 253 => '10.3', 254 => '10.3', 259 => '27.4', 263 => '10.3', 264 => '10.3' },
	'multiselectorliveview' => { 250 => '4.3', 253 => '37.1', 254 => '37.1', 263 => '37.1', 264 => '37.1' },
	'multiselectorliveviewmode' => { 221 => 0x18c2 },
	'multiselectorplaybackmode' => { 250 => ['13.5','9.2'], 251 => '10.2', 254 => '10.2', 259 => '27.2', 263 => '10.2', 264 => '10.2' },
	'multiselectorshootmode' => { 250 => '9.1', 251 => '10.1', 253 => '10.1', 254 => '10.1', 259 => '27.1', 263 => '10.1', 264 => '10.1' },
	'mycolormode' => { 65 => 0x2 },
	'nationalcatalognumber' => { 445 => 'nationalCatalogNumber' },
	'nativedigest' => { 435 => 'NativeDigest', 451 => 'NativeDigest' },
	'ncdfileinfo' => { 127 => 0x414 },
	'ndfilter' => { 72 => 0x1c, 267 => 0x204, 348 => 0x1019 },
	'near' => { 416 => 'Near' },
	'nefbitdepth' => { 204 => 0xe22 },
	'nefcompression' => { 204 => 0x93 },
	'neflinearizationtable' => { 204 => 0x96 },
	'negativecachelargepreviewsize' => { 431 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 431 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 431 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 322 => 0x88 },
	'neutraloutputhighlightpoint' => { 103 => 0x2f },
	'neutraloutputshadowpoint' => { 103 => 0x30 },
	'neutralrawcolortone' => { 103 => 0x28 },
	'neutralrawcontrast' => { 103 => 0x2a },
	'neutralrawhighlight' => { 103 => 0x78 },
	'neutralrawhighlightpoint' => { 103 => 0x2d },
	'neutralrawlinear' => { 103 => 0x2b },
	'neutralrawsaturation' => { 103 => 0x29 },
	'neutralrawshadow' => { 103 => 0x81 },
	'neutralrawshadowpoint' => { 103 => 0x2e },
	'neutralrawsharpness' => { 103 => 0x2c },
	'neutralunsharpmaskfineness' => { 103 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 103 => 0xa8 },
	'neutraunsharpmaskstrength' => { 103 => 0xa4 },
	'newrawimagedigest' => { 113 => 0xc7a7 },
	'newsphotoversion' => { 123 => 0x0 },
	'nickname' => { 453 => 'Nickname' },
	'nikoncapturedata' => { 204 => 0xe01 },
	'nikoncaptureeditversions' => { 204 => 0xe13 },
	'nikoncaptureoutput' => { 204 => 0xe1e },
	'nikoncaptureversion' => { 204 => 0xe09 },
	'nikoniccprofile' => { 204 => 0xe1d },
	'nikonimagesize' => { 218 => '723.1', 219 => '732.1', 228 => 0x2c4 },
	'noisefilter' => { 267 => 0x527 },
	'noiseprofile' => { 113 => 0xc761 },
	'noisereduction' => { 118 => 0x100b, 168 => 0xb0, 169 => 0x60, 170 => 0x3f, 204 => 0x95, 243 => 0x753dcbc0, 244 => 0x17, 267 => 0x50a, 272 => 0x103a, 288 => 0x2d, 322 => 0x49, 348 => 0x100f, 350 => 0x2a },
	'noisereduction2' => { 271 => 0x1010 },
	'noisereductionapplied' => { 113 => 0xc6f7 },
	'noisereductionintensity' => { 244 => 0x9 },
	'noisereductionmethod' => { 244 => 0x11 },
	'noisereductionmode' => { 411 => 0x801e },
	'noisereductionsharpness' => { 244 => 0xd },
	'noisereductionvalue' => { 411 => 0x8027 },
	'nomemorycard' => { 250 => '22.1', 251 => '4.2', 252 => '0.3', 255 => '2.4', 256 => '3.2', 257 => '3.2', 259 => '33.7', 260 => '3.2', 261 => '0.3', 263 => '4.2', 265 => '4.5' },
	'nominalmaxaperture' => { 313 => 0xa },
	'nominalminaperture' => { 313 => '10.1' },
	'normalwhitelevel' => { 42 => [0x2b8,0x2cf,0x2d3], 44 => 0x1e3, 45 => [0x1fc,0x2dc], 46 => [0x230,0x30e], 47 => 0x31c },
	'notes' => { 412 => 'Notes', 425 => 'notes' },
	'npages' => { 460 => 'NPages' },
	'nrwdata' => { 204 => 0x14 },
	'nullrecord' => { 91 => 0x0 },
	'numafpoints' => { 299 => 0x2 },
	'number' => { 445 => 'number' },
	'numberofbeats' => { 455 => 'numberOfBeats' },
	'numberoffocuspoints' => { 253 => '1.2', 254 => '1.2', 257 => '0.2', 258 => '0.3', 260 => '0.3' },
	'numfaceelements' => { 118 => 0x4200 },
	'numfacepositions' => { 282 => 0x0 },
	'numindexentries' => { 123 => 0x54 },
	'numwbentries' => { 293 => 0x0, 294 => 0x0 },
	'object' => { 445 => 'object' },
	'objectattributereference' => { 121 => 0x4 },
	'objectcycle' => { 121 => 0x4b, 425 => 'ObjectCycle' },
	'objectdescription' => { 444 => 'objectDescription' },
	'objectdistance' => { 106 => 0x6, 107 => 0x2022 },
	'objectname' => { 121 => 0x5 },
	'objectpreviewdata' => { 121 => 0xca },
	'objectpreviewfileformat' => { 121 => 0xc8 },
	'objectpreviewfileversion' => { 121 => 0xc9 },
	'objectsubtype' => { 444 => 'objectSubtype' },
	'objecttype' => { 444 => 'objectType' },
	'objecttypereference' => { 121 => 0x3 },
	'occurrence' => { 112 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 112 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 112 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 112 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 112 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 112 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 112 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 112 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 112 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 112 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 112 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 112 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 112 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 112 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 112 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 112 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 112 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 112 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 112 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 112 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 112 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 112 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 112 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 112 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 435 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 435 => [\'OECF','OECFNames'] },
	'oecfrows' => { 435 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 435 => [\'OECF','OECFValues'] },
	'offsaledate' => { 445 => 'offSaleDate' },
	'offsaledatea-platform' => { 445 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 445 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 113 => 0xea1d },
	'offsettime' => { 113 => 0x9010 },
	'offsettimedigitized' => { 113 => 0x9012 },
	'offsettimeoriginal' => { 113 => 0x9011 },
	'okbutton' => { 260 => '15.1', 265 => '16.1' },
	'oldsubfiletype' => { 113 => 0xff },
	'olympusimageheight' => { 272 => 0x102f },
	'olympusimagewidth' => { 272 => 0x102e },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 272 => 0x302 },
	'onsaledate' => { 445 => 'onSaleDate' },
	'onsaledatea-platform' => { 445 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 445 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 445 => 'onSaleDay' },
	'onsaledaya-platform' => { 445 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 445 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 113 => 0xc740 },
	'opcodelist2' => { 113 => 0xc741 },
	'opcodelist3' => { 113 => 0xc74e },
	'opticalzoom' => { 131 => 0xfa3d, 133 => [0x6006,0xf006], 134 => 0x1000, 135 => 0xf, 138 => 0x1e, 150 => 'OpticalZoom' },
	'opticalzoomcode' => { 72 => 0xa },
	'opticalzoommode' => { 288 => 0x34 },
	'opticalzoomon' => { 357 => 0x219 },
	'optionenddate' => { 448 => 'optionEndDate' },
	'opto-electricconvfactor' => { 435 => 'OECF' },
	'orangehsl' => { 97 => 0x20911 },
	'ordernumber' => { 118 => 0x8002 },
	'organisationinimagecode' => { 441 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 441 => 'OrganisationInImageName' },
	'organization' => { 445 => 'organization' },
	'orientation' => { 113 => 0x112, 292 => 0x112, 444 => 'orientation', 451 => 'Orientation' },
	'orientation2' => { 383 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 78 => 0x516 },
	'originalbestqualitysize' => { 113 => 0xc792 },
	'originalcreatedatetime' => { 421 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 108 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 60 => 0x83 },
	'originaldefaultcropsize' => { 113 => 0xc793 },
	'originaldefaultfinalsize' => { 113 => 0xc791 },
	'originaldirectory' => { 286 => 0x408 },
	'originaldocumentid' => { 456 => 'OriginalDocumentID' },
	'originalfilename' => { 91 => 0x816, 127 => 0x3e9, 139 => 0x20, 286 => 0x407, 421 => 'OriginalFilename' },
	'originalimageheight' => { 74 => 0xc, 117 => 0x1 },
	'originalimagewidth' => { 74 => 0xb, 117 => 0x0 },
	'originalrawfiledata' => { 113 => 0xc68c },
	'originalrawfiledigest' => { 113 => 0xc71d },
	'originalrawfilename' => { 113 => 0xc68b },
	'originaltransmissionreference' => { 121 => 0x67 },
	'originatingprogram' => { 121 => 0x41, 425 => 'OriginatingProgram' },
	'originplatform' => { 445 => 'originPlatform' },
	'os' => { 433 => 'os' },
	'otherconditions' => { 277 => 'OtherConditions' },
	'otherconstraints' => { 277 => 'OtherConstraints' },
	'otherimage' => { 108 => 'OtherImage' },
	'otherimageinfo' => { 277 => 'OtherImageInfo' },
	'otherimagelength' => { 113 => 0x202 },
	'otherimagestart' => { 113 => 0x201 },
	'otherlicensedocuments' => { 277 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 277 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 277 => 'OtherLicenseRequirements' },
	'outcue' => { 455 => 'outCue' },
	'outcuescale' => { 455 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 455 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 182 => 0x3 },
	'outputimagewidth' => { 182 => 0x2 },
	'outputprofile' => { 127 => 0x138b },
	'outputresolution' => { 182 => 0x4 },
	'owner' => { 459 => 'Owner' },
	'ownerid' => { 121 => 0xbc },
	'ownername' => { 14 => 0x10f, 60 => 0x9, 91 => 0x810, 113 => [0xa430,0xfde8], 143 => 'OwnerName', 427 => 'OwnerName', 436 => 'CameraOwnerName' },
	'padding' => { 113 => 0xea1c },
	'pagecount' => { 445 => 'pageCount' },
	'pageimage' => { 453 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 453 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 453 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 453 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 453 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 453 => 'PageInfo' },
	'pagename' => { 113 => 0x11d },
	'pagenumber' => { 113 => 0x129 },
	'pageprogressiondirection' => { 445 => 'pageProgressionDirection' },
	'pagerange' => { 445 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 431 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 431 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 288 => 0x26 },
	'panasonicimageheight' => { 288 => 0x4c },
	'panasonicimagewidth' => { 288 => 0x4b },
	'panasonicrawversion' => { 292 => 0x1 },
	'panasonictitle' => { 113 => 0xc6d2 },
	'panasonictitle2' => { 113 => 0xc6d3 },
	'panoramaangle' => { 118 => 0x1153 },
	'panoramacropbottom' => { 384 => 0x7 },
	'panoramacropleft' => { 384 => 0x4 },
	'panoramacropright' => { 384 => 0x6 },
	'panoramacroptop' => { 384 => 0x5 },
	'panoramadirection' => { 68 => 0x5, 118 => 0x1154, 384 => 0x3 },
	'panoramaframeheight' => { 384 => 0x9 },
	'panoramaframenumber' => { 68 => 0x2 },
	'panoramaframewidth' => { 384 => 0x8 },
	'panoramafullheight' => { 384 => 0x2 },
	'panoramafullwidth' => { 384 => 0x1 },
	'panoramamode' => { 129 => 0x3c, 267 => 0x601 },
	'panoramasize3d' => { 368 => 0x38 },
	'panoramasourceheight' => { 384 => 0xb },
	'panoramasourcewidth' => { 384 => 0xa },
	'panoramicstitchcameramotion' => { 163 => 'PanoramicStitchCameraMotion', 164 => 0x1 },
	'panoramicstitchmaptype' => { 163 => 'PanoramicStitchMapType', 164 => 0x2 },
	'panoramicstitchphi0' => { 163 => 'PanoramicStitchPhi0', 164 => 0x5 },
	'panoramicstitchphi1' => { 163 => 'PanoramicStitchPhi1', 164 => 0x6 },
	'panoramicstitchtheta0' => { 163 => 'PanoramicStitchTheta0', 164 => 0x3 },
	'panoramicstitchtheta1' => { 163 => 'PanoramicStitchTheta1', 164 => 0x4 },
	'panoramicstitchversion' => { 164 => 0x0 },
	'pantry' => { 456 => 'Pantry' },
	'parallax' => { 118 => 0xb211, 266 => 0x28 },
	'parametricdarks' => { 431 => 'ParametricDarks' },
	'parametrichighlights' => { 431 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 431 => 'ParametricHighlightSplit' },
	'parametriclights' => { 431 => 'ParametricLights' },
	'parametricmidtonesplit' => { 431 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 431 => 'ParametricShadows' },
	'parametricshadowsplit' => { 431 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 421 => 'ParentMediaEventID' },
	'parentmeid' => { 421 => 'ParentMEID' },
	'parentreference1' => { 439 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 439 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 455 => 'partOfCompilation' },
	'patientbirthdate' => { 413 => 'PatientDOB' },
	'patientid' => { 413 => 'PatientID' },
	'patientname' => { 413 => 'PatientName' },
	'patientsex' => { 413 => 'PatientSex' },
	'pdfversion' => { 442 => 'PDFVersion' },
	'pentaximagesize' => { 322 => 0x9 },
	'pentaxmodelid' => { 302 => 0x0, 322 => 0x5 },
	'pentaxmodeltype' => { 322 => 0x1 },
	'pentaxversion' => { 322 => 0x0 },
	'people' => { 414 => 'People', 423 => 'People' },
	'perchannelblacklevel' => { 41 => 0xc4, 42 => [0x2b4,0x2cb,0x2cf], 43 => [0x108,0x14d], 44 => 0x1df, 45 => [0x1f8,0x2d8], 46 => [0x22c,0x30a], 47 => 0x149 },
	'peripheralillumcentralradius' => { 411 => 0x8030 },
	'peripheralillumcentralvalue' => { 411 => 0x8031 },
	'peripheralillumination' => { 97 => 0x20702, 103 => 0x68 },
	'peripheralilluminationcorr' => { 59 => 0x1, 312 => 0x2 },
	'peripheralilluminationon' => { 97 => '0x20702.0', 103 => 0x64 },
	'peripheralillumperiphvalue' => { 411 => 0x8032 },
	'peripherallighting' => { 74 => 0x2 },
	'peripherallightingsetting' => { 75 => 0x5 },
	'peripherallightingvalue' => { 74 => 0x6 },
	'permissions' => { 448 => 'permissions' },
	'permits' => { 428 => 'permits' },
	'person' => { 445 => 'person' },
	'personality' => { 421 => 'Personality' },
	'personheard' => { 441 => 'PersonHeard' },
	'personheardidentifier' => { 441 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 441 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 441 => 'PersonInImage' },
	'personinimagecharacteristic' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 441 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 441 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 431 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 431 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 431 => 'PerspectiveRotate' },
	'perspectivescale' => { 431 => 'PerspectiveScale' },
	'perspectiveupright' => { 431 => 'PerspectiveUpright' },
	'perspectivevertical' => { 431 => 'PerspectiveVertical' },
	'perspectivex' => { 431 => 'PerspectiveX' },
	'perspectivey' => { 431 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 86 => 0x1 },
	'pf10retainprogramshift' => { 86 => 0xb },
	'pf13drivepriority' => { 86 => 0xe },
	'pf14disablefocussearch' => { 86 => 0xf },
	'pf15disableafassistbeam' => { 86 => 0x10 },
	'pf16autofocuspointshoot' => { 86 => 0x11 },
	'pf17disableafpointsel' => { 86 => 0x12 },
	'pf18enableautoafpointsel' => { 86 => 0x13 },
	'pf19continuousshootspeed' => { 86 => 0x14 },
	'pf19shootingspeedhigh' => { 85 => 0xa },
	'pf19shootingspeedlow' => { 85 => 0x9 },
	'pf1disableshootingmodes' => { 86 => 0x2 },
	'pf1value' => { 85 => 0x1 },
	'pf20limitcontinousshots' => { 86 => 0x15 },
	'pf20maxcontinousshots' => { 85 => 0xb },
	'pf21enablequietoperation' => { 86 => 0x16 },
	'pf23felocktime' => { 85 => 0xd },
	'pf23postreleasetime' => { 85 => 0xe },
	'pf23settimerlengths' => { 86 => 0x18 },
	'pf23shutterbuttontime' => { 85 => 0xc },
	'pf24lightlcdduringbulb' => { 86 => 0x19 },
	'pf25aemode' => { 85 => 0xf },
	'pf25afmode' => { 85 => 0x12 },
	'pf25afpointsel' => { 85 => 0x13 },
	'pf25colormatrix' => { 85 => 0x17 },
	'pf25defaultclearsettings' => { 86 => 0x1a },
	'pf25drivemode' => { 85 => 0x11 },
	'pf25imagesize' => { 85 => 0x14 },
	'pf25meteringmode' => { 85 => 0x10 },
	'pf25parameters' => { 85 => 0x16 },
	'pf25wbmode' => { 85 => 0x15 },
	'pf26shortenreleaselag' => { 86 => 0x1b },
	'pf27reversedialrotation' => { 86 => 0x1c },
	'pf27value' => { 85 => 0x18 },
	'pf28noquickdialexpcomp' => { 86 => 0x1d },
	'pf29quickdialswitchoff' => { 86 => 0x1e },
	'pf2disablemeteringmodes' => { 86 => 0x3 },
	'pf2value' => { 85 => 0x2 },
	'pf30enlargementmode' => { 86 => 0x1f },
	'pf31originaldecisiondata' => { 86 => 0x20 },
	'pf3manualexposuremetering' => { 86 => 0x4 },
	'pf3value' => { 85 => 0x3 },
	'pf4exposuretimelimits' => { 86 => 0x5 },
	'pf4exposuretimemax' => { 85 => 0x5 },
	'pf4exposuretimemin' => { 85 => 0x4 },
	'pf5aperturelimits' => { 86 => 0x6 },
	'pf5aperturemax' => { 85 => 0x7 },
	'pf5aperturemin' => { 85 => 0x6 },
	'pf6presetshootingmodes' => { 86 => 0x7 },
	'pf7bracketcontinuousshoot' => { 86 => 0x8 },
	'pf8bracketshots' => { 85 => 0x8 },
	'pf8setbracketshots' => { 86 => 0x9 },
	'pf9changebracketsequence' => { 86 => 0xa },
	'phasedetectaf' => { 179 => 0x6 },
	'phonenumber' => { 144 => 'Phone' },
	'photoeffect' => { 33 => 0x28 },
	'photoeffecthistoryxml' => { 243 => 0xe9651831 },
	'photoeffects' => { 243 => 0xab5eca5e },
	'photoeffectsblue' => { 245 => 0x8 },
	'photoeffectsgreen' => { 245 => 0x6 },
	'photoeffectsred' => { 245 => 0x4 },
	'photoeffectstype' => { 245 => 0x0 },
	'photographicsensitivity' => { 436 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 250 => '17.6', 259 => '33.6' },
	'photometricinterpretation' => { 113 => 0x106, 451 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 222 => 0xe7d, 231 => 0xfbd },
	'photoshootingmenubankimagearea' => { 222 => '3716.1', 231 => 0x791 },
	'photoshopbgrthumbnail' => { 336 => 0x409 },
	'photoshopquality' => { 335 => 0x0 },
	'photoshopthumbnail' => { 336 => 0x40c },
	'photostyle' => { 288 => 0x89 },
	'picklabel' => { 434 => 'PickLabel' },
	'pictinfo' => { 357 => 0x208 },
	'picturecontrol' => { 243 => 0xe2173c47 },
	'picturecontrolactive' => { 246 => 0x0 },
	'picturecontroladjust' => { 206 => 0x30, 207 => 0x30 },
	'picturecontrolbase' => { 206 => 0x18, 207 => 0x18 },
	'picturecontroldata' => { 204 => [0xbd,0x23] },
	'picturecontrolmode' => { 246 => 0x13 },
	'picturecontrolname' => { 206 => 0x4, 207 => 0x4 },
	'picturecontrolquickadjust' => { 206 => 0x31, 207 => 0x31 },
	'pictureeffect' => { 378 => 0x200e },
	'pictureeffect2' => { 386 => 0x1163, 387 => 0x1167, 388 => 0x1143, 389 => 0x11bf, 390 => 0x119b, 391 => 0x1053, 392 => 0x24b, 393 => 0x24b, 394 => 0x23c, 407 => 0x46 },
	'picturefinish' => { 168 => 0x71 },
	'picturemode' => { 118 => 0x1031, 267 => 0x520, 322 => [0xb,0x33], 358 => 0x3d },
	'picturemode2' => { 303 => 0x0 },
	'picturemodebwfilter' => { 267 => 0x525 },
	'picturemodecontrast' => { 267 => 0x523 },
	'picturemodeeffect' => { 267 => 0x52d },
	'picturemodehue' => { 267 => 0x522 },
	'picturemodesaturation' => { 267 => 0x521 },
	'picturemodesharpness' => { 267 => 0x524 },
	'picturemodetone' => { 267 => 0x526 },
	'pictureprofile' => { 386 => [0x115e,0x115f], 387 => [0x1162,0x1163], 388 => [0x113e,0x113f], 389 => [0x11ba,0x11bb], 390 => [0x1196,0x1197], 391 => [0x104e,0x104f], 392 => [0x246,0x247], 393 => [0x246,0x247], 394 => [0x237,0x238] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 26 => 0x169, 70 => 0xa, 97 => 0x20301, 103 => 0x2 },
	'picturewizard' => { 355 => 0x21 },
	'picturewizardcolor' => { 354 => 0x1 },
	'picturewizardcontrast' => { 354 => 0x4 },
	'picturewizardmode' => { 354 => 0x0 },
	'picturewizardsaturation' => { 354 => 0x2 },
	'picturewizardsharpness' => { 354 => 0x3 },
	'pipelineversion' => { 163 => 'PipelineVersion' },
	'pitch' => { 109 => 0x6, 251 => '4.1', 263 => '4.1' },
	'pitchangle' => { 221 => 0x350f, 222 => 0x2c28, 230 => 0x36f8, 267 => 0x904, 288 => 0x91, 321 => 0x2, 353 => 0x1 },
	'pixelshiftinfo' => { 378 => 0x202f },
	'pixelshiftresolution' => { 323 => 0x0 },
	'pixelsperunitx' => { 279 => 0x0 },
	'pixelsperunity' => { 279 => 0x4 },
	'pixelunits' => { 279 => 0x8 },
	'planarconfiguration' => { 113 => 0x11c, 451 => 'PlanarConfiguration' },
	'platenames' => { 460 => 'PlateNames' },
	'platform' => { 445 => 'platform' },
	'playbackmenustime' => { 255 => '20.1', 256 => '21.1', 257 => '21.1' },
	'playbackmonitorofftime' => { 250 => '25.2', 251 => '36.1', 253 => '36.1', 254 => '36.1', 258 => '35.1', 259 => '8.1', 260 => '35.1', 263 => '36.1', 264 => '36.1', 265 => '21.1' },
	'playbackzoom' => { 251 => '37.1' },
	'playdisplay' => { 170 => 0x4e },
	'plusversion' => { 277 => 'Version' },
	'pmversion' => { 334 => 'PMVersion' },
	'pngwarning' => { 280 => 'Warning' },
	'poilevel' => { 203 => 0x8 },
	'portraitoutputhighlightpoint' => { 103 => 0x1d },
	'portraitoutputshadowpoint' => { 103 => 0x1e },
	'portraitrawcolortone' => { 103 => 0x16 },
	'portraitrawcontrast' => { 103 => 0x18 },
	'portraitrawhighlight' => { 103 => 0x76 },
	'portraitrawhighlightpoint' => { 103 => 0x1b },
	'portraitrawlinear' => { 103 => 0x19 },
	'portraitrawsaturation' => { 103 => 0x17 },
	'portraitrawshadow' => { 103 => 0x7f },
	'portraitrawshadowpoint' => { 103 => 0x1c },
	'portraitrawsharpness' => { 103 => 0x1a },
	'portraitrefiner' => { 107 => 0x302b },
	'portraitunsharpmaskfineness' => { 103 => 0x9a },
	'portraitunsharpmaskstrength' => { 103 => 0x98 },
	'portraitunsharpmaskthreshold' => { 103 => 0x9c },
	'poseheadingdegrees' => { 419 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 419 => 'PosePitchDegrees' },
	'poserolldegrees' => { 419 => 'PoseRollDegrees' },
	'positiondescriptor' => { 444 => 'positionDescriptor' },
	'postalcode' => { 148 => 'PostalCode' },
	'postcropvignetteamount' => { 431 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 431 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 431 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 431 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 431 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 431 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 376 => 0xb },
	'potentialface2position' => { 376 => 0x15 },
	'potentialface3position' => { 376 => 0x1f },
	'potentialface4position' => { 376 => 0x29 },
	'potentialface5position' => { 376 => 0x33 },
	'potentialface6position' => { 376 => 0x3d },
	'potentialface7position' => { 376 => 0x47 },
	'potentialface8position' => { 376 => 0x51 },
	'powersource' => { 301 => '0.1' },
	'poweruptime' => { 204 => 0xb6 },
	'precaptureframes' => { 272 => 0x300 },
	'predictor' => { 113 => 0x13d },
	'preflashreturnstrength' => { 219 => 0x28a },
	'prefs' => { 121 => 0xdd, 334 => 'Prefs' },
	'preservedfilename' => { 456 => 'PreservedFileName' },
	'presetwhitebalance' => { 170 => 0x24, 411 => 0x8002 },
	'presetwhitebalanceadj' => { 411 => 0x8014 },
	'pressure' => { 113 => 0x9402 },
	'previewapplicationname' => { 113 => 0xc716 },
	'previewapplicationversion' => { 113 => 0xc717 },
	'previewbutton' => { 250 => ['14.1','15.1'], 251 => '15.1', 253 => '15.1', 254 => '15.1', 259 => '29.1', 260 => '14.1', 263 => '15.1', 264 => '15.1' },
	'previewbuttonplusdials' => { 250 => ['14.2','15.2'], 251 => '15.2', 253 => '43.1', 254 => '43.1', 259 => '31.2', 263 => '43.1', 264 => '43.1' },
	'previewcolorspace' => { 113 => 0xc71a },
	'previewcropbottom' => { 333 => 0xef },
	'previewcropleft' => { 333 => 0xec },
	'previewcropright' => { 333 => 0xee },
	'previewcroptop' => { 333 => 0xed },
	'previewdate' => { 341 => 0x0 },
	'previewdatetime' => { 113 => 0xc71b },
	'previewimage' => { 107 => 0x2000, 108 => 'PreviewImage', 114 => 'PreviewImage', 116 => 0x4, 153 => 'data', 172 => 0x81, 272 => 0x280, 287 => 0x300, 378 => 0x2001 },
	'previewimageborders' => { 322 => 0x3e },
	'previewimageheight' => { 69 => 0x4, 131 => 0xfa58 },
	'previewimagelength' => { 69 => 0x2, 107 => 0x3, 113 => [0x117,0x202], 172 => 0x89, 208 => 0x202, 267 => 0x102, 272 => 0x1037, 322 => 0x3, 347 => 0x1e, 352 => 0x3, 358 => [0x1b,0x1d], 369 => 0x202 },
	'previewimagename' => { 153 => '1Name' },
	'previewimagesize' => { 107 => 0x2, 136 => 0x2, 153 => 'ImageSize', 322 => 0x2, 358 => [0x1c,0x1e], 378 => 0xb02c },
	'previewimagestart' => { 69 => 0x5, 107 => 0x4, 113 => [0x111,0x201], 172 => 0x88, 208 => 0x201, 267 => 0x101, 272 => 0x1036, 322 => 0x4, 347 => 0x1c, 352 => 0x2, 358 => [0x1a,0x1c], 369 => 0x201 },
	'previewimagetype' => { 153 => '0Type' },
	'previewimagevalid' => { 267 => 0x100, 272 => 0x1035 },
	'previewimagewidth' => { 69 => 0x3, 131 => 0xfa57 },
	'previewquality' => { 69 => 0x1 },
	'previewsettingsdigest' => { 113 => 0xc719 },
	'previewsettingsname' => { 113 => 0xc718 },
	'primaryafpoint' => { 179 => [0x44,0x7] },
	'primarychromaticities' => { 113 => 0x13f, 451 => 'PrimaryChromaticities' },
	'primaryftp' => { 421 => 'PrimaryFTP' },
	'primaryslot' => { 222 => 0xe7f, 231 => 0xfbf },
	'printim' => { 113 => 0xc4a5 },
	'prioritysetinawb' => { 378 => 0x202b },
	'prioritysetupshutterrelease' => { 170 => 0x1d, 366 => 0x28 },
	'privatertkinfo' => { 422 => 'privateRTKInfo' },
	'processingsoftware' => { 113 => 0xb },
	'processversion' => { 431 => 'ProcessVersion' },
	'producer' => { 276 => 'Producer', 442 => 'Producer' },
	'productcode' => { 445 => 'productCode' },
	'productid' => { 122 => 0x32, 444 => 'productID' },
	'productidtype' => { 444 => 'productIDType' },
	'productinimage' => { 441 => 'ProductInImage' },
	'productinimagedescription' => { 441 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 441 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 441 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 302 => 0x2 },
	'productorserviceconstraints' => { 277 => 'ProductOrServiceConstraints' },
	'profession' => { 445 => 'profession' },
	'profilecalibrationsig' => { 113 => 0xc6f4 },
	'profilecopyright' => { 113 => 0xc6fe },
	'profileembedpolicy' => { 113 => 0xc6fd },
	'profilehuesatmapdata1' => { 113 => 0xc6fa },
	'profilehuesatmapdata2' => { 113 => 0xc6fb },
	'profilehuesatmapdims' => { 113 => 0xc6f9 },
	'profilehuesatmapencoding' => { 113 => 0xc7a3 },
	'profilelooktabledata' => { 113 => 0xc726 },
	'profilelooktabledims' => { 113 => 0xc725 },
	'profilelooktableencoding' => { 113 => 0xc7a4 },
	'profilename' => { 113 => 0xc6f8 },
	'profiletonecurve' => { 113 => 0xc6fc },
	'programiso' => { 288 => 0x3c },
	'programline' => { 303 => '1.1' },
	'programmode' => { 175 => 0x5 },
	'programshift' => { 204 => 0xd },
	'programversion' => { 121 => 0x46 },
	'prohibits' => { 428 => 'prohibits' },
	'projectiontype' => { 419 => 'ProjectionType', 420 => 'ProjectionType' },
	'projectname' => { 455 => 'projectName' },
	'projectref' => { 455 => 'projectRef' },
	'projectrefpath' => { 455 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 455 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 277 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 277 => 'PropertyReleaseStatus' },
	'province-state' => { 121 => 0x5f },
	'publicationdate' => { 445 => 'publicationDate' },
	'publicationdatea-platform' => { 445 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 445 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 445 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 445 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 445 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 441 => 'PublicationEvent' },
	'publicationeventdate' => { 441 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 441 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 441 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 445 => 'publicationName' },
	'publisher' => { 432 => 'publisher' },
	'publishingfrequency' => { 445 => 'publishingFrequency' },
	'pulldown' => { 455 => 'pullDown' },
	'purplehsl' => { 97 => 0x20916 },
	'quality' => { 0 => 0x1, 33 => 0x3, 106 => 0x2, 107 => 0x3002, 118 => 0x1000, 129 => 0x9, 204 => 0x4, 233 => 0x3, 272 => 0x201, 284 => 0x300, 322 => 0x8, 329 => 0x2, 358 => 0x16, 366 => 0x56, 367 => 0x56, 368 => 0xb, 378 => [0x102,0x202e] },
	'quality2' => { 386 => 0x1170, 387 => 0x1174, 388 => 0x1150, 390 => 0x11a8, 391 => 0x1060, 392 => 0x258, 393 => 0x258, 394 => 0x247, 398 => 0x29, 399 => 0x25, 400 => 0x2a },
	'qualitymode' => { 107 => 0x8 },
	'quantizationmethod' => { 123 => 0x78 },
	'quickadjust' => { 246 => 0x2a },
	'quickcontroldialinmeter' => { 78 => 0x703 },
	'quickfix' => { 243 => 0x416391c6 },
	'quickshot' => { 357 => 0x213 },
	'rangefinder' => { 255 => '4.1', 256 => '5.1', 257 => '5.1' },
	'rasterizedcaption' => { 121 => 0x7d },
	'rating' => { 113 => 0x4746, 118 => 0x1431, 333 => 0xdf, 378 => 0x2002, 425 => 'rating', 433 => 'rating', 441 => 'Rating', 445 => 'rating', 453 => 'Rating' },
	'ratingpercent' => { 113 => 0x4749, 165 => 'Rating' },
	'ratingratingregion' => { 441 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 441 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 441 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 441 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 441 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 441 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 441 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 441 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 441 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 441 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 441 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 441 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 441 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 441 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 441 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 441 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 441 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 441 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 76 => 0x8, 172 => 0x109, 303 => 0xd },
	'rawbrightnessadj' => { 97 => 0x20001, 102 => 0x38 },
	'rawcoloradj' => { 102 => 0x2e },
	'rawcropbottom' => { 333 => 0xd4 },
	'rawcropleft' => { 333 => 0xd1 },
	'rawcropright' => { 333 => 0xd3 },
	'rawcroptop' => { 333 => 0xd2 },
	'rawcustomsaturation' => { 102 => 0x30 },
	'rawcustomtone' => { 102 => 0x34 },
	'rawdata' => { 355 => 0xa048 },
	'rawdatabyteorder' => { 355 => 0x40 },
	'rawdatacfapattern' => { 355 => 0x50 },
	'rawdatauniqueid' => { 113 => 0xc65d },
	'rawdepth' => { 174 => 0x10 },
	'rawdevartfilter' => { 274 => 0x121 },
	'rawdevautogradation' => { 274 => 0x119 },
	'rawdevcolorspace' => { 273 => 0x108, 274 => 0x109 },
	'rawdevcontrastvalue' => { 273 => 0x106, 274 => 0x105 },
	'rawdeveditstatus' => { 273 => 0x10b },
	'rawdevelopmentprocess' => { 322 => 0x62 },
	'rawdevengine' => { 273 => 0x109, 274 => 0x10b },
	'rawdevexposurebiasvalue' => { 273 => 0x100, 274 => 0x100 },
	'rawdevgradation' => { 274 => 0x112 },
	'rawdevgraypoint' => { 273 => 0x103, 274 => 0x104 },
	'rawdevmemorycoloremphasis' => { 273 => 0x105, 274 => 0x108 },
	'rawdevnoisereduction' => { 273 => 0x10a, 274 => 0x10a },
	'rawdevpicturemode' => { 274 => 0x10c },
	'rawdevpm_bwfilter' => { 274 => 0x110 },
	'rawdevpmcontrast' => { 274 => 0x10e },
	'rawdevpmnoisefilter' => { 274 => 0x120 },
	'rawdevpmpicturetone' => { 274 => 0x111 },
	'rawdevpmsaturation' => { 274 => 0x10d },
	'rawdevpmsharpness' => { 274 => 0x10f },
	'rawdevsaturation3' => { 274 => 0x113 },
	'rawdevsaturationemphasis' => { 273 => 0x104, 274 => 0x107 },
	'rawdevsettings' => { 273 => 0x10c },
	'rawdevsharpnessvalue' => { 273 => 0x107, 274 => 0x106 },
	'rawdevversion' => { 273 => 0x0, 274 => 0x0 },
	'rawdevwbfineadjustment' => { 273 => 0x102, 274 => 0x103 },
	'rawdevwhitebalance' => { 274 => 0x101 },
	'rawdevwhitebalancevalue' => { 273 => 0x101, 274 => 0x102 },
	'rawfile' => { 113 => 0xfe4c },
	'rawfilename' => { 431 => 'RawFileName' },
	'rawfiletype' => { 378 => 0x2029 },
	'rawformat' => { 292 => 0x2d, 331 => 0x10e },
	'rawimagecenter' => { 204 => 0x99 },
	'rawimagedigest' => { 113 => 0xc71c },
	'rawimagesize' => { 322 => 0x39 },
	'rawinfoversion' => { 275 => 0x0 },
	'rawjpgheight' => { 93 => 0x4 },
	'rawjpgquality' => { 54 => 0x6, 93 => 0x1 },
	'rawjpgsize' => { 54 => 0x7, 93 => 0x2 },
	'rawjpgwidth' => { 93 => 0x3 },
	'rawmeasuredrggb' => { 40 => 0x26a, 42 => 0x280, 44 => 0x194, 45 => [0x1ad,0x26b] },
	'rawrppused' => { 425 => 'rawrppused' },
	'rawtopreviewgain' => { 113 => 0xc7a8 },
	'reardisplay' => { 250 => '12.3', 251 => '6.2' },
	'recipeendingpage' => { 447 => 'recipeEndingPage' },
	'recipepagerange' => { 447 => 'recipePageRange' },
	'recipesource' => { 447 => 'recipeSource' },
	'recipestartingpage' => { 447 => 'recipeStartingPage' },
	'recipetitle' => { 447 => 'recipeTitle' },
	'recognizedface1age' => { 283 => 0x20 },
	'recognizedface1name' => { 283 => 0x4 },
	'recognizedface1position' => { 283 => 0x18 },
	'recognizedface2age' => { 283 => 0x50 },
	'recognizedface2name' => { 283 => 0x34 },
	'recognizedface2position' => { 283 => 0x48 },
	'recognizedface3age' => { 283 => 0x80 },
	'recognizedface3name' => { 283 => 0x64 },
	'recognizedface3position' => { 283 => 0x78 },
	'recognizedfaceflags' => { 288 => 0x63 },
	'recommendedexposureindex' => { 113 => 0x8832, 436 => 'RecommendedExposureIndex' },
	'record' => { 112 => 'Record' },
	'recordbasisofrecord' => { 112 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 112 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 112 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 112 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 112 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 112 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 170 => 0x4d },
	'recorddynamicproperties' => { 112 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 91 => 0x1804 },
	'recordinformationwithheld' => { 112 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 348 => 0x1000 },
	'recordingmode' => { 106 => 0x1, 329 => 0x1 },
	'recordinstitutioncode' => { 112 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 112 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 33 => 0x9, 107 => 0x3000 },
	'recordownerinstitutioncode' => { 112 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 357 => 0x217 },
	'redbalance' => { 187 => 0x270, 272 => 0x1017, 292 => 0x11, 322 => 0x1c },
	'redcurvelimits' => { 102 => 0x18a },
	'redcurvepoints' => { 101 => 0x2d, 102 => 0x160 },
	'redeyecorrection' => { 247 => 0x0 },
	'redeyeinfo' => { 431 => 'RedEyeInfo' },
	'redeyereduction' => { 170 => 0x41, 366 => 0x6a, 368 => 0x28 },
	'redhsl' => { 97 => 0x20910 },
	'redhue' => { 431 => 'RedHue' },
	'redsaturation' => { 431 => 'RedSaturation' },
	'reductionmatrix1' => { 113 => 0xc625 },
	'reductionmatrix2' => { 113 => 0xc626 },
	'reelname' => { 113 => 0xc789 },
	'reference1' => { 439 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 439 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 113 => 0x214, 451 => 'ReferenceBlackWhite' },
	'referencedate' => { 121 => 0x2f },
	'referencenumber' => { 121 => 0x32 },
	'references' => { 144 => 'References' },
	'referenceservice' => { 121 => 0x2d },
	'regionappliedtodimensions' => { 159 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 159 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 159 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 159 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 159 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 159 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 159 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 159 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 159 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 159 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 159 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 159 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 277 => 'RegionConstraints' },
	'regiondescription' => { 159 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 159 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 159 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 159 => 'Regions' },
	'regioninfodateregionsvalid' => { 162 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 162 => 'RegionInfo' },
	'regioninforegions' => { 162 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 159 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 159 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 162 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 162 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 159 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 159 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 159 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 441 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 441 => 'RegistryId' },
	'registryitemid' => { 441 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 441 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 142 => 'data' },
	'relatedaudiofilename' => { 142 => '1Name' },
	'relatedaudiofiletype' => { 142 => '0Type' },
	'relatedimagefileformat' => { 113 => 0x1000 },
	'relatedimageheight' => { 113 => 0x1002 },
	'relatedimagewidth' => { 113 => 0x1001 },
	'relatedresourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 113 => 0xa004, 435 => 'RelatedSoundFile' },
	'relatedvideofile' => { 156 => 'data' },
	'relatedvideofilename' => { 156 => '1Name' },
	'relatedvideofiletype' => { 156 => '0Type' },
	'relation' => { 432 => 'relation' },
	'relationshipaccordingto' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 112 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 110 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 455 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 455 => 'relativeTimestamp' },
	'relativetimestampscale' => { 455 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 455 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 250 => '17.8', 251 => '18.5', 253 => '18.4', 254 => '18.4', 259 => '33.8', 260 => '17.6', 263 => '18.5', 264 => '18.4' },
	'releasedate' => { 121 => 0x1e, 425 => 'ReleaseDate', 455 => 'releaseDate' },
	'releasemode' => { 107 => 0x3001, 221 => 0x184d, 378 => 0xb049 },
	'releasemode2' => { 386 => 0x112c, 387 => [0x112c,0x8], 388 => [0x1108,0x8], 389 => [0x1184,0x8], 390 => [0x1160,0x8], 391 => [0x4,0x1018], 392 => [0x4,0x210], 393 => [0x4,0x210], 394 => [0x4,0x208], 396 => [0x67,0x3f], 397 => [0x73,0x4b], 398 => 0x10, 399 => 0x10, 400 => 0x9, 407 => 0x34 },
	'releasemode3' => { 386 => 0x1128, 387 => 0x1128, 388 => 0x1104, 389 => 0x1180, 390 => 0x115c, 391 => 0x1014, 392 => 0x20c, 393 => 0x20c, 394 => 0x204 },
	'releaseready' => { 441 => 'ReleaseReady' },
	'releasesetting' => { 91 => 0x1016 },
	'releasetime' => { 121 => 0x23, 425 => 'ReleaseTime' },
	'remoteonduration' => { 252 => '3.4', 255 => '17.2', 256 => '18.2', 257 => '18.2', 258 => '18.2', 260 => '18.2', 261 => '4.3', 265 => '19.2' },
	'renditionclass' => { 456 => 'RenditionClass' },
	'renditionof' => { 456 => 'RenditionOf' },
	'renditionofalternatepaths' => { 456 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 456 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 456 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 456 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 456 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 456 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 456 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 456 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 456 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 456 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 456 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 456 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 456 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 456 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 456 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 456 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 456 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 456 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 456 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 456 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 456 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 456 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 456 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 456 => 'RenditionParams' },
	'repeatingflashcount' => { 192 => 0xd, 193 => 0xe, 194 => 0xe, 195 => 0xe, 259 => '17.2', 260 => '24.2', 261 => '9.2', 262 => '24.2', 265 => '25.2' },
	'repeatingflashcountbuilt-in' => { 229 => 0x4db },
	'repeatingflashcountexternal' => { 229 => 0x4c3 },
	'repeatingflashoutput' => { 259 => '17.1', 260 => '24.1', 261 => '9.1', 262 => '24.1', 265 => '25.1' },
	'repeatingflashoutputexternal' => { 229 => 0x4c0 },
	'repeatingflashrate' => { 192 => 0xc, 193 => 0xd, 194 => 0xd, 195 => 0xd, 259 => '18.1', 260 => '25.1', 261 => '10.1', 262 => '25.1', 265 => '26.1' },
	'repeatingflashratebuilt-in' => { 229 => 0x4da },
	'repeatingflashrateexternal' => { 229 => 0x4c2 },
	'requires' => { 428 => 'requires' },
	'resampleparams' => { 455 => 'resampleParams' },
	'resampleparamsquality' => { 455 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 357 => 0x21e },
	'resolution' => { 149 => 'Resolution' },
	'resolutionmode' => { 358 => 0x4 },
	'resolutionunit' => { 113 => 0x128, 124 => 0x2, 451 => 'ResolutionUnit' },
	'resourceid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 112 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 112 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 78 => 0x612 },
	'restrictions' => { 448 => 'restrictions' },
	'retouchareafeather' => { 431 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 431 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 431 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 431 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 431 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 431 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 431 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 431 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 431 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 431 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 431 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 431 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 431 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 431 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 431 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 431 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 431 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 431 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 431 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 431 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 431 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 431 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 431 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 431 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 431 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 431 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 431 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 431 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 431 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 431 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 431 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 431 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 431 => 'RetouchAreas' },
	'retouchareaseed' => { 431 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 431 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 431 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 431 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 204 => 0x9e },
	'retouchinfo' => { 431 => 'RetouchInfo' },
	'retouchnefprocessing' => { 210 => 0x5 },
	'retractlensonpoweroff' => { 78 => 0x814 },
	'reuse' => { 277 => 'Reuse' },
	'reuseallowed' => { 458 => 'ReuseAllowed' },
	'reuseprohibited' => { 448 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 257 => '5.2' },
	'reverseindicators' => { 250 => '12.1', 251 => '6.1', 253 => '6.1', 254 => '6.1', 255 => '4.3', 256 => '5.2', 257 => '5.4', 259 => '33.5', 260 => '5.1', 263 => '6.1', 264 => '6.1', 265 => '6.2' },
	'reverseshutterspeedaperture' => { 257 => '5.3' },
	'revision' => { 433 => 'revision' },
	'rgbcurvelimits' => { 102 => 0x238 },
	'rgbcurvepoints' => { 101 => 0x7, 102 => 0x20e },
	'richtextcomment' => { 438 => 'RichTextComment' },
	'ricohdate' => { 347 => 0x6 },
	'ricohimageheight' => { 347 => 0x2 },
	'ricohimagewidth' => { 347 => 0x0 },
	'rightascension' => { 152 => 'RightAscension' },
	'rights' => { 432 => 'rights' },
	'rightsagent' => { 448 => 'rightsAgent' },
	'rightsowner' => { 448 => 'rightsOwner' },
	'roll' => { 109 => 0x8 },
	'rollangle' => { 221 => 0x350b, 222 => 0x2c24, 230 => 0x36f4, 267 => 0x903, 288 => 0x90, 321 => 0x1, 353 => 0x2 },
	'romoperationmode' => { 91 => 0x80d },
	'rotation' => { 29 => 0x17, 30 => 0x18, 90 => 0x3, 97 => 0x10002, 102 => 0x26e, 117 => 0x4, 152 => 'Rotation', 168 => [0x65,0x50], 169 => 0x46, 170 => 0x5a, 173 => 0x10, 221 => 0x3693, 222 => 0xca, 228 => '590.1', 243 => 0x76a43207, 288 => 0x30, 303 => '17.2', 333 => 0xd8, 366 => 0x3f, 367 => 0x3f, 377 => 0x10 },
	'routedto' => { 437 => 'RoutedTo' },
	'routing' => { 338 => 'Routing' },
	'routingdestinations' => { 421 => 'RoutingDestinations' },
	'routingexclusions' => { 421 => 'RoutingExclusions' },
	'routingnotes' => { 437 => 'RoutingNotes' },
	'rowsperstrip' => { 113 => 0x116 },
	'rpp' => { 425 => 'rpp' },
	'safetyshift' => { 78 => 0x108 },
	'safetyshiftinavortv' => { 76 => 0x10, 77 => 0x10, 79 => 0xf, 80 => 0x10, 83 => 0x10 },
	'sameexposurefornewaperture' => { 78 => 0x112 },
	'samplebits' => { 142 => 'SampleBits' },
	'samplepagerange' => { 445 => 'samplePageRange' },
	'samplerate' => { 142 => 'SampleRate' },
	'samplesperpixel' => { 113 => 0x115, 292 => 0x8, 451 => 'SamplesPerPixel' },
	'samplestructure' => { 123 => 0x5a },
	'samsungmodelid' => { 355 => 0x3 },
	'sanyoquality' => { 357 => 0x201 },
	'sanyothumbnail' => { 357 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 33 => 0xe, 48 => 0x1, 106 => 0xd, 107 => [0x3013,0x1f], 113 => [0xa409,0xfe55], 118 => 0x1003, 143 => 'Saturation', 167 => 0x1f, 168 => 0x32, 169 => 0x28, 170 => 0x1a, 175 => 0x1, 204 => [0x94,0xaa], 206 => 0x35, 207 => 0x3b, 288 => 0x40, 290 => 0x300d, 322 => 0x1f, 329 => 0xd, 343 => 0x27, 347 => 0x28, 348 => 0x1013, 358 => 0x10, 366 => 0x1e, 367 => 0x1b, 378 => 0x2005, 431 => 'Saturation', 435 => 'Saturation' },
	'saturationadj' => { 97 => 0x20901, 102 => 0x116, 242 => 0x1, 246 => 0x2e, 411 => 0x8016 },
	'saturationadjustmentaqua' => { 431 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 431 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 431 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 431 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 431 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 431 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 431 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 431 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 67 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 66 => 0x68, 67 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 66 => 0x38, 67 => 0x38 },
	'saturationmonochrome' => { 66 => 0x80, 67 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 66 => 0x50, 67 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 66 => 0x20, 67 => 0x20 },
	'saturationsetting' => { 275 => 0x1010, 368 => 0x11, 383 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 66 => 0x8, 67 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 66 => 0x98, 67 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 66 => 0xb0, 67 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 66 => 0xc8, 67 => 0xe0 },
	'saveid' => { 456 => 'SaveID' },
	'scaletype' => { 455 => 'scaleType' },
	'scanimageenhancer' => { 211 => 0x60 },
	'scanningdirection' => { 123 => 0x64 },
	'scene' => { 440 => 'Scene', 455 => 'scene' },
	'scenearea' => { 270 => 0x211, 272 => 0x1031 },
	'sceneassist' => { 204 => 0x9c },
	'scenecapturetype' => { 113 => 0xa406, 435 => 'SceneCaptureType' },
	'scenedetect' => { 270 => 0x210, 272 => 0x1030 },
	'scenedetectdata' => { 270 => 0x212, 272 => 0x1033 },
	'scenemode' => { 131 => 0xfa02, 172 => 0x100, 204 => 0x8f, 267 => 0x509, 272 => 0x403, 288 => 0x8001, 296 => 0xf, 378 => 0xb023 },
	'scenemodeused' => { 133 => [0x6002,0xf002] },
	'scenerecognition' => { 118 => 0x1425 },
	'sceneselect' => { 357 => 0x21f },
	'scenetype' => { 113 => 0xa301, 435 => 'SceneType' },
	'screentips' => { 250 => '12.7', 251 => '5.3', 259 => '13.1', 260 => '4.4', 263 => '5.4', 265 => '5.1' },
	'season' => { 441 => 'Season', 444 => 'season' },
	'seasonidentifier' => { 441 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 441 => [\'Season','SeasonName'] },
	'seasonnumber' => { 441 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 421 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 221 => 0x1d0, 230 => 0x1d0 },
	'section' => { 445 => 'section' },
	'securityclassification' => { 113 => 0x9212 },
	'selectableafpoint' => { 78 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 78 => 0x512 },
	'selftimer' => { 33 => 0x2, 288 => 0x2e, 357 => 0x214, 386 => 0x1134, 387 => 0x1134, 388 => 0x1110, 389 => 0x118c, 390 => 0x1168, 391 => 0x1020, 392 => 0x218, 393 => 0x218, 394 => 0x210 },
	'selftimer2' => { 72 => 0x1d },
	'selftimerinterval' => { 260 => '19.2' },
	'selftimermode' => { 113 => 0x882b },
	'selftimershotcount' => { 251 => '20.2', 253 => '20.3', 254 => '20.3', 255 => '18.2', 256 => '19.2', 257 => '19.2', 258 => '19.3', 260 => '19.3', 263 => '20.3', 264 => '20.3', 265 => '20.2' },
	'selftimershotinterval' => { 251 => '20.3', 253 => '20.2', 254 => '20.2', 258 => '19.2', 263 => '20.2', 264 => '20.2' },
	'selftimertime' => { 91 => 0x1806, 170 => 0x1f, 250 => '18.1', 251 => '20.1', 252 => '3.3', 253 => '20.1', 254 => '20.1', 255 => '18.1', 256 => '19.1', 257 => '19.1', 258 => '19.1', 259 => '7.2', 260 => '19.1', 261 => '3.3', 263 => '20.1', 264 => '20.1', 265 => '20.1' },
	'sellingagency' => { 445 => 'sellingAgency' },
	'seminfo' => { 113 => 0x8546 },
	'sensingmethod' => { 113 => 0xa217, 435 => 'SensingMethod' },
	'sensitivityadjust' => { 322 => 0x40 },
	'sensitivitysteps' => { 303 => ['14.3','17.4'], 305 => 0x1 },
	'sensitivitytype' => { 113 => 0x8830, 436 => 'SensitivityType' },
	'sensor' => { 177 => 0x665e },
	'sensorareas' => { 355 => 0xa010 },
	'sensorbitdepth' => { 290 => 0x312d },
	'sensorbluelevel' => { 70 => 0x5 },
	'sensorcalibration' => { 271 => 0x805 },
	'sensorcleaning' => { 84 => 0xd },
	'sensorfullheight' => { 126 => 0xf904 },
	'sensorfullwidth' => { 126 => 0xf903 },
	'sensorheight' => { 126 => 0xf901, 131 => 0xfa21, 174 => 0x8, 290 => 0x312c, 331 => 0x109, 348 => 0x1602 },
	'sensorleftmargin' => { 331 => 0x10a },
	'sensorpixelsize' => { 204 => 0x9a },
	'sensorredlevel' => { 70 => 0x4 },
	'sensorserialnumber' => { 127 => 0x9ce },
	'sensorsize' => { 143 => 'SensorSize', 322 => 0x35 },
	'sensortemperature' => { 270 => 0x1500, 272 => 0x1007, 327 => 0xc, 331 => 0x210, 358 => [0x39,0x55] },
	'sensortemperature2' => { 327 => 0xe, 331 => 0x211 },
	'sensortopmargin' => { 331 => 0x10b },
	'sensorwidth' => { 126 => 0xf900, 131 => 0xfa20, 174 => 0xa, 290 => 0x312b, 331 => 0x108, 348 => 0x1601 },
	'sequence' => { 343 => 0x7, 344 => 0x35 },
	'sequencefilenumber' => { 387 => 0x4, 388 => 0x4, 389 => 0x4, 390 => 0x4, 398 => 0xc, 399 => 0xc, 400 => 0x1a },
	'sequenceimagenumber' => { 387 => 0x0, 388 => 0x0, 389 => 0x0, 390 => 0x0, 398 => 0x8, 399 => 0x8, 400 => 0x12, 407 => 0x24 },
	'sequencelength' => { 398 => 0x22, 399 => 0x1e, 400 => [0x16,0x1e] },
	'sequencename' => { 444 => 'sequenceName' },
	'sequencenumber' => { 72 => 0x9, 107 => 0x301c, 118 => 0x1101, 129 => 0x1d, 229 => 0x51c, 288 => 0x2b, 368 => [0x10c,0x30c], 378 => 0xb04a, 444 => 'sequenceNumber' },
	'sequenceshotinterval' => { 357 => 0x224 },
	'sequencetotalnumber' => { 444 => 'sequenceTotalNumber' },
	'sequentialshot' => { 357 => 0x20e },
	'serialnumber' => { 60 => 0xc, 91 => 0x180b, 113 => [0xa431,0xfde9], 126 => 0xfa04, 128 => 0xfa00, 130 => 0xc354, 131 => 0xfa19, 140 => 0x0, 143 => 'SerialNumber', 204 => [0xa0,0x1d], 268 => 0x101, 272 => [0x404,0x101a], 284 => 0x303, 290 => 0x3103, 322 => 0x229, 331 => 0x102, 332 => 0x407, 343 => 0x15, 344 => 0x4b, 348 => 0x5, 358 => 0x2, 378 => 0x2031, 427 => 'SerialNumber', 436 => 'BodySerialNumber' },
	'serialnumberformat' => { 60 => 0x15, 91 => 0x183b },
	'series' => { 441 => 'Series' },
	'seriesdatetime' => { 413 => 'SeriesDateTime' },
	'seriesdescription' => { 413 => 'SeriesDescription' },
	'seriesidentifier' => { 441 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 413 => 'SeriesModality' },
	'seriesname' => { 441 => [\'Series','SeriesName'] },
	'seriesnumber' => { 413 => 'SeriesNumber', 445 => 'seriesNumber' },
	'seriestitle' => { 445 => 'seriesTitle' },
	'serviceidentifier' => { 122 => 0x1e },
	'servingsize' => { 447 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 81 => 0x0, 82 => 0x0 },
	'setbuttonwhenshooting' => { 76 => 0x1, 78 => 0x704, 84 => 0xc },
	'setfunctionwhenshooting' => { 79 => 0x0, 80 => 0x1, 83 => 0x1 },
	'setting' => { 444 => 'setting' },
	'shadingcompensation' => { 267 => 0x50c, 288 => 0x8a },
	'shadingcompensation2' => { 271 => 0x1012 },
	'shadow' => { 358 => 0xe },
	'shadowadj' => { 97 => 0x2030b },
	'shadowcorrection' => { 322 => 0x79 },
	'shadowprotection' => { 242 => 0x0 },
	'shadows' => { 113 => 0xfe52, 424 => 'Shadows', 431 => 'Shadows' },
	'shadows2012' => { 431 => 'Shadows2012' },
	'shadowscale' => { 113 => 0xc633 },
	'shadowtint' => { 431 => 'ShadowTint' },
	'shadowtone' => { 118 => 0x1040 },
	'shakereduction' => { 324 => 0x1, 325 => 0x1 },
	'sharpendetail' => { 431 => 'SharpenDetail' },
	'sharpenedgemasking' => { 431 => 'SharpenEdgeMasking' },
	'sharpening' => { 290 => 0x300b },
	'sharpeningadj' => { 246 => 0x2b },
	'sharpenradius' => { 431 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 33 => 0xf, 70 => 0x2, 106 => 0xb, 107 => [0x3011,0x21], 113 => [0xa40a,0xfe56], 118 => 0x1001, 129 => 0x6b, 138 => 0x37, 143 => 'Sharpness', 167 => 0x21, 168 => 0x30, 169 => 0x26, 170 => 0x18, 175 => 0x3, 204 => 0x6, 206 => 0x32, 207 => 0x33, 272 => 0x100f, 288 => 0x41, 322 => 0x21, 329 => 0xb, 343 => 0x26, 347 => 0x22, 348 => [0x1003,0x1014], 358 => 0x11, 366 => 0x1c, 367 => 0x19, 378 => 0x2006, 407 => 0x52, 431 => 'Sharpness', 435 => 'Sharpness' },
	'sharpnessadj' => { 97 => 0x20310, 102 => 0x25a, 411 => 0x801a },
	'sharpnessadjon' => { 97 => '0x20310.0' },
	'sharpnessauto' => { 67 => 0x94 },
	'sharpnessfactor' => { 272 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 66 => 0x64, 67 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 70 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 66 => 0x34, 67 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 66 => 0x7c, 67 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 66 => 0x4c, 67 => 0x4c },
	'sharpnessovershoot' => { 411 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 66 => 0x1c, 67 => 0x1c },
	'sharpnesssetting' => { 267 => 0x506, 275 => 0x1013, 368 => 0x12, 383 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 66 => 0x4, 67 => 0x4 },
	'sharpnessstrength' => { 97 => 0x20311 },
	'sharpnessthreshold' => { 411 => 0x801d },
	'sharpnessundershoot' => { 411 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 66 => 0x94, 67 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 66 => 0xac, 67 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 66 => 0xc4, 67 => 0xdc },
	'shootid' => { 444 => 'shootID' },
	'shootingdistance' => { 97 => 0x20701 },
	'shootinginfodisplay' => { 250 => '13.2', 251 => '5.1', 259 => '10.2', 260 => '4.1', 263 => '5.1', 265 => '5.3' },
	'shootinginfomonitorofftime' => { 250 => '26.2', 251 => '22.2', 253 => '22.2', 254 => '22.2', 258 => '21.2', 259 => '9.1', 260 => '21.2', 263 => '22.2', 264 => '22.2', 265 => '22.2' },
	'shootingmode' => { 143 => 'ShootingMode', 204 => 0x89, 288 => 0x1f },
	'shootingmodesetting' => { 252 => '5.1' },
	'shortdescription' => { 433 => 'shortdescription' },
	'shortdocumentid' => { 121 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 78 => 0x80d },
	'shotdate' => { 455 => 'shotDate' },
	'shotday' => { 455 => 'shotDay' },
	'shotlocation' => { 455 => 'shotLocation' },
	'shotname' => { 455 => 'shotName' },
	'shotnumber' => { 455 => 'shotNumber' },
	'shotnumbersincepowerup' => { 382 => 0x44e, 398 => 0x1a, 399 => 0x16, 400 => 0xa },
	'shotnumbersincepowerup2' => { 368 => 0x200 },
	'shotsize' => { 455 => 'shotSize' },
	'shownevent' => { 441 => 'EventExt' },
	'showneventidentifier' => { 441 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 441 => [\'EventExt','EventExtName'] },
	'shutter-aelock' => { 76 => 0x4, 78 => 0x701, 79 => 0x3, 80 => 0x4, 81 => 0x3, 82 => 0x3, 83 => 0x4, 84 => 0x2 },
	'shutteraelbutton' => { 77 => 0x4 },
	'shutterbuttonafonbutton' => { 78 => 0x701 },
	'shuttercount' => { 10 => 0x176, 54 => 0x1, 204 => 0xa7, 212 => [0x6a,0x157,0x24d], 213 => 0x286, 214 => 0x279, 215 => 0x284, 216 => 0x242, 217 => 0x280, 218 => 0x276, 219 => [0x27d,0x27f], 220 => 0x246, 223 => 0x2d6, 224 => 0x321, 225 => 0xbd8, 226 => 0x287, 227 => 0x320, 228 => 0x24a, 229 => 0x5fb, 232 => 0x2d5, 322 => 0x5d, 377 => 0x846, 381 => [0x125,0x14a] },
	'shuttercurtainsync' => { 76 => 0xf, 77 => 0xf, 78 => 0x305, 79 => 0xe, 80 => 0xf, 81 => 0x8, 82 => 0x8, 83 => 0xf, 84 => 0x8 },
	'shuttermode' => { 129 => 0x1b },
	'shutterreleasebuttonae-l' => { 250 => '17.7', 251 => '18.4', 253 => '78.4', 254 => '78.4', 255 => '16.1', 256 => '17.1', 257 => '17.1', 258 => '17.1', 259 => '7.1', 260 => '17.5', 263 => '18.4', 264 => '78.4', 265 => '18.2' },
	'shutterreleasemethod' => { 91 => 0x1010 },
	'shutterreleasenocfcard' => { 76 => 0x2, 77 => 0x2, 84 => 0xf },
	'shutterreleasetiming' => { 91 => 0x1011 },
	'shutterreleasewithoutlens' => { 78 => 0x711 },
	'shutterspeedlock' => { 251 => '38.1', 253 => '38.1', 254 => '38.1', 263 => '38.1', 264 => '38.1' },
	'shutterspeedrange' => { 78 => 0x10c },
	'shutterspeedsetting' => { 170 => 0x6, 366 => 0x2f, 367 => 0x28, 368 => 0x0 },
	'shutterspeedvalue' => { 87 => 0x1, 113 => 0x9201, 272 => 0x1000, 331 => 0x400, 435 => 'ShutterSpeedValue' },
	'shuttertype' => { 118 => 0x1050, 288 => 0x9f },
	'sidecarforextension' => { 443 => 'SidecarForExtension' },
	'similarityindex' => { 121 => 0xe4 },
	'singleframebracketing' => { 170 => 0x21 },
	'skilllevel' => { 447 => 'skillLevel' },
	'skintonecorrection' => { 322 => 0x95 },
	'slaveflashmeteringsegments' => { 322 => 0x20b },
	'slideshowname' => { 444 => 'slideshowName' },
	'slideshownumber' => { 444 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 444 => 'slideshowTotalNumber' },
	'slowshutter' => { 72 => 0x8 },
	'slowsync' => { 118 => 0x1030 },
	'smartalbumcolor' => { 355 => 0x20 },
	'smartrange' => { 355 => 0xa012 },
	'smileshutter' => { 368 => 0x31 },
	'smileshuttermode' => { 368 => 0x27 },
	'smoothness' => { 113 => 0xfe57, 431 => 'Smoothness' },
	'snapshot' => { 441 => 'SnapshotLink' },
	'snapshotformat' => { 441 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 441 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 441 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 441 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 441 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 425 => 'Snapshots' },
	'snapshotusedvideoframe' => { 441 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 441 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 441 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 441 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 441 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 378 => 0x200f },
	'software' => { 113 => 0x131, 144 => 'Software', 280 => 'Software', 331 => 0x203, 358 => 0x18, 416 => 'Software', 451 => 'Software' },
	'softwareversion' => { 357 => 0x207 },
	'sonydatetime' => { 385 => 0x6, 387 => 0x1b6, 388 => 0x210, 389 => 0x1fe, 390 => 0x22c },
	'sonydatetime2' => { 396 => 0x51 },
	'sonyexposuretime' => { 396 => 0x3a, 397 => 0x46 },
	'sonyexposuretime2' => { 407 => 0xe },
	'sonyfnumber' => { 396 => 0x3c, 397 => 0x48, 407 => 0x14 },
	'sonyimageheight' => { 385 => 0x1a, 398 => 0x44, 399 => 0x3f, 400 => 0x47 },
	'sonyimageheightmax' => { 407 => 0x40 },
	'sonyimagesize' => { 170 => 0x3b, 366 => 0x54, 367 => 0x54, 368 => 0x9 },
	'sonyimagewidth' => { 385 => 0x1c },
	'sonyimagewidthmax' => { 407 => 0x3e },
	'sonyiso' => { 387 => 0x1218, 388 => 0x11f4, 389 => 0x1270, 390 => [0x1254,0x1258,0x1280], 391 => 0x113c, 392 => 0x344, 393 => 0x346, 394 => 0x320, 407 => 0x4 },
	'sonymaxaperture' => { 396 => 0x0, 397 => 0x0 },
	'sonymaxaperturevalue' => { 407 => 0x16 },
	'sonyminaperture' => { 396 => 0x1, 397 => 0x1 },
	'sonymodelid' => { 378 => 0xb001 },
	'sonyquality' => { 170 => 0x3c },
	'sonytimeminsec' => { 397 => 0x61 },
	'source' => { 121 => 0x73, 280 => 'Source', 432 => 'source', 433 => 'source', 443 => 'Source' },
	'sourcecount' => { 420 => 'SourceCount' },
	'sourcedirectoryindex' => { 309 => 0x0 },
	'sourcefileindex' => { 309 => 0x2 },
	'sourcephotoscount' => { 419 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 435 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 435 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 435 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 435 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 435 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 455 => 'speakerPlacement' },
	'specialeffectlevel' => { 107 => 0x3030 },
	'specialeffectmode' => { 107 => 0x2076 },
	'specialeffectsetting' => { 107 => 0x3031 },
	'specialinstructions' => { 121 => 0x28 },
	'specialmode' => { 272 => 0x200, 357 => 0x200 },
	'specialoccasion' => { 447 => 'specialOccasion' },
	'spectralsensitivity' => { 113 => 0x8824, 435 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 42 => [0x2b9,0x2d0,0x2d4], 44 => 0x1e4, 45 => [0x1fd,0x2dd], 46 => [0x231,0x30f], 47 => 0x31d },
	'speedx' => { 109 => 0x3 },
	'speedy' => { 109 => 0x4 },
	'speedz' => { 109 => 0x5 },
	'spherical' => { 420 => 'Spherical' },
	'splitcolumn' => { 331 => 0x222 },
	'splittoningbalance' => { 431 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 431 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 431 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 431 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 431 => 'SplitToningShadowSaturation' },
	'sport' => { 445 => 'sport' },
	'spotfocuspointx' => { 167 => 0x2d },
	'spotfocuspointy' => { 167 => 0x2e },
	'spotmeteringmode' => { 33 => 0x27 },
	'spotmeterlinktoafpoint' => { 78 => 0x107 },
	'sractive' => { 303 => '17.1' },
	'srawquality' => { 33 => 0x2e },
	'srfocallength' => { 324 => 0x3 },
	'srhalfpresstime' => { 324 => 0x2 },
	'srresult' => { 324 => 0x0, 325 => 0x0 },
	'stackedimage' => { 267 => 0x804 },
	'standardoutputhighlightpoint' => { 103 => 0x14 },
	'standardoutputsensitivity' => { 113 => 0x8831, 436 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 103 => 0x15 },
	'standardrawcolortone' => { 103 => 0xd },
	'standardrawcontrast' => { 103 => 0xf },
	'standardrawhighlight' => { 103 => 0x75 },
	'standardrawhighlightpoint' => { 103 => 0x12 },
	'standardrawlinear' => { 103 => 0x10 },
	'standardrawsaturation' => { 103 => 0xe },
	'standardrawshadow' => { 103 => 0x7e },
	'standardrawshadowpoint' => { 103 => 0x13 },
	'standardrawsharpness' => { 103 => 0x11 },
	'standardunsharpmaskfineness' => { 103 => 0x94 },
	'standardunsharpmaskstrength' => { 103 => 0x92 },
	'standardunsharpmaskthreshold' => { 103 => 0x96 },
	'standbytimer' => { 251 => '19.1', 253 => '19.1', 254 => '19.1', 257 => '18.1', 258 => '18.1', 263 => '19.1', 264 => '19.1' },
	'startingpage' => { 445 => 'startingPage' },
	'startmovieshooting' => { 78 => 0x70d },
	'starttimecode' => { 455 => 'startTimecode' },
	'starttimecodetimeformat' => { 455 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 455 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 455 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 455 => 'startTimeSampleSize' },
	'starttimescale' => { 455 => 'startTimeScale' },
	'state' => { 148 => 'State', 288 => 0x6b, 443 => 'State' },
	'status' => { 414 => 'Status', 423 => 'Status' },
	'stereomode' => { 420 => 'StereoMode' },
	'stitched' => { 420 => 'Stitched' },
	'stitchingsoftware' => { 419 => 'StitchingSoftware', 420 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 386 => 0x113e, 387 => 0x113e, 388 => 0x111a, 389 => 0x1196, 390 => 0x1172, 391 => 0x102a, 392 => 0x222, 393 => 0x222, 394 => 0x217, 407 => 0xa },
	'storagemethod' => { 174 => 0x12 },
	'storebyorientation' => { 251 => '46.3', 253 => '47.3', 254 => '47.3', 263 => '47.3', 264 => '47.3' },
	'storylineidentifier' => { 441 => 'StorylineIdentifier' },
	'straightenangle' => { 243 => 0x2fc08431 },
	'streamready' => { 441 => 'StreamReady' },
	'streamtype' => { 163 => 'StreamType' },
	'stretchmode' => { 455 => 'stretchMode' },
	'studydatetime' => { 413 => 'StudyDateTime' },
	'studydescription' => { 413 => 'StudyDescription' },
	'studyid' => { 413 => 'StudyID' },
	'studyphysician' => { 413 => 'StudyPhysician' },
	'styleperiod' => { 441 => 'StylePeriod' },
	'sub-location' => { 121 => 0x5c },
	'subfiledata' => { 151 => 'data' },
	'subfiledirectory' => { 151 => '1Directory' },
	'subfilemimetype' => { 151 => '2MIME' },
	'subfilename' => { 151 => '1Name' },
	'subfileresource' => { 151 => 'rsrc' },
	'subfiletype' => { 113 => 0xfe, 151 => '0Type' },
	'subject' => { 276 => 'Subject', 338 => 'Subject', 432 => 'subject', 442 => 'Subject', 456 => 'subject' },
	'subjectarea' => { 113 => 0x9214, 435 => 'SubjectArea' },
	'subjectcode' => { 440 => 'SubjectCode' },
	'subjectdistance' => { 113 => 0x9206, 129 => 0x3e, 435 => 'SubjectDistance' },
	'subjectdistancerange' => { 113 => 0xa40c, 435 => 'SubjectDistanceRange' },
	'subjectlocation' => { 113 => 0xa214, 435 => 'SubjectLocation' },
	'subjectmotion' => { 253 => '78.2', 254 => '78.2', 264 => '78.2' },
	'subjectprogram' => { 167 => 0x22 },
	'subjectreference' => { 121 => 0xc },
	'sublabels4' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 439 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 439 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 108 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 108 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 108 => 'SubSecModifyDate' },
	'subsectime' => { 113 => 0x9290 },
	'subsectimedigitized' => { 113 => 0x9292 },
	'subsectimeoriginal' => { 113 => 0x9291 },
	'subsection1' => { 445 => 'subsection1' },
	'subsection2' => { 445 => 'subsection2' },
	'subsection3' => { 445 => 'subsection3' },
	'subsection4' => { 445 => 'subsection4' },
	'subselector' => { 251 => '49.1', 253 => '71.1', 254 => '71.1', 264 => '71.1' },
	'subselectorassignment' => { 251 => '48.1' },
	'subselectorcenter' => { 253 => '72.1', 254 => '72.1', 264 => '72.1' },
	'subselectorplusdials' => { 251 => '49.2', 253 => '73.1', 254 => '73.1', 264 => '73.1' },
	'subtitle' => { 445 => 'subtitle' },
	'subversionfilename' => { 439 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 439 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 439 => 'SubVersions' },
	'superimposeddisplay' => { 76 => 0xa, 78 => 0x510, 79 => 0x9, 80 => 0xa, 83 => 0xa, 84 => 0xe },
	'supermacro' => { 60 => 0x1a },
	'supplementalcategories' => { 121 => 0x14, 443 => 'SupplementalCategories' },
	'supplementaltype' => { 123 => 0x37 },
	'supplementdisplayid' => { 445 => 'supplementDisplayID' },
	'supplementstartingpage' => { 445 => 'supplementStartingPage' },
	'supplementtitle' => { 445 => 'supplementTitle' },
	'supplychainsource' => { 441 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 441 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 441 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 303 => 0x14 },
	'swatchcoloranta' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 460 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 460 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 460 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 460 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 460 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 288 => 0x93, 368 => 0x33 },
	'sweeppanoramafieldofview' => { 288 => 0x94 },
	'sweeppanoramasize' => { 368 => 0x32 },
	'switchtoregisteredafpoint' => { 77 => 0x12, 78 => 0x50a },
	'syncreleasemode' => { 253 => '77.1', 254 => '77.1', 264 => '77.1' },
	'system' => { 331 => 0x204 },
	'tagged' => { 333 => 0xdd, 334 => 'Tagged', 425 => 'tagged' },
	'tagslist' => { 434 => 'TagsList' },
	'tagstructure' => { 439 => 'TagStructure' },
	'takenumber' => { 455 => 'takeNumber' },
	'tapename' => { 455 => 'tapeName' },
	'targetaperture' => { 72 => 0x4 },
	'targetcompressionratio' => { 89 => 0x1 },
	'targetdistancesetting' => { 91 => 0x1807 },
	'targetexposuretime' => { 72 => 0x5 },
	'targetimagetype' => { 91 => 0x100a },
	'targetprinter' => { 113 => 0x151 },
	'taxon' => { 112 => 'Taxon' },
	'taxonacceptednameusage' => { 112 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 112 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 112 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 112 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 112 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 112 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 112 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 112 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 112 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 112 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 112 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 112 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 112 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 112 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 112 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 112 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 112 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 112 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 112 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 112 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 112 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 112 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 112 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 112 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 112 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 112 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 112 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 112 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 112 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 112 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 112 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 112 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 112 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 445 => 'teaser' },
	'teleconverter' => { 172 => 0x105, 378 => 0x105 },
	'tempo' => { 455 => 'tempo' },
	'temporalcoverage' => { 441 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 441 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 441 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 277 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 277 => 'TermsAndConditionsURL' },
	'testname' => { 114 => 'TestName' },
	'textencoding' => { 203 => 0x4 },
	'textlayername' => { 443 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 443 => 'TextLayers' },
	'textlayertext' => { 443 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 288 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 253 => '1.3', 254 => '1.3', 264 => '1.4' },
	'three-dtrackingwatcharea' => { 253 => '78.1', 254 => '78.1', 264 => '78.1' },
	'thresholding' => { 113 => 0x107 },
	'thumbnailfilename' => { 91 => 0x817 },
	'thumbnailformat' => { 453 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 131 => 0xfa55, 453 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 91 => 0x2008, 108 => 'ThumbnailImage', 116 => 0x3, 154 => 'data', 272 => 0x100, 453 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 154 => '1Name' },
	'thumbnailimagesize' => { 154 => 'ImageSize' },
	'thumbnailimagetype' => { 154 => '0Type' },
	'thumbnailimagevalidarea' => { 60 => 0x13 },
	'thumbnaillength' => { 113 => 0x202 },
	'thumbnailoffset' => { 113 => 0x201 },
	'thumbnails' => { 453 => 'Thumbnails' },
	'thumbnailwidth' => { 131 => 0xfa54, 453 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 445 => 'ticker' },
	'tiffhandling' => { 431 => 'TIFFHandling' },
	'tiffmeteringimage' => { 173 => 0x104c, 377 => 0x1110 },
	'tilelength' => { 113 => 0x143 },
	'tilewidth' => { 113 => 0x142 },
	'time' => { 127 => 0x401, 322 => 0x7 },
	'timecodes' => { 113 => 0xc763 },
	'timecreated' => { 121 => 0x3c, 129 => 0x14, 138 => 0x10, 334 => 'TimeCreated' },
	'timeperiod' => { 445 => 'timePeriod' },
	'timerfunctionbutton' => { 252 => '5.2', 255 => '12.1', 256 => '13.1' },
	'timerlength' => { 78 => 0x80c },
	'timerrecording' => { 288 => 0x96 },
	'timescaleparams' => { 455 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 455 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 455 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 455 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 122 => 0x50 },
	'timeshot' => { 421 => 'TimeShot' },
	'timesignature' => { 455 => 'timeSignature' },
	'timesincepoweron' => { 288 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 266 => 0x8, 280 => 'TimeStamp', 288 => 0xaf, 420 => 'Timestamp', 426 => 'Timestamp', 439 => 'TimeStamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 73 => 0x1, 235 => 0x0, 351 => 0xa },
	'timezonecity' => { 73 => 0x2 },
	'timezonecode' => { 94 => 0x1 },
	'timezoneinfo' => { 94 => 0x2 },
	'timezoneoffset' => { 113 => 0x882a },
	'tint' => { 431 => 'Tint' },
	'title' => { 144 => 'Title', 276 => 'Title', 280 => 'Title', 288 => 0x65, 338 => 'Title', 432 => 'title', 442 => 'Title', 453 => 'Title' },
	'tonecomp' => { 204 => 0x81 },
	'tonecurve' => { 70 => 0x1, 322 => 0x402, 431 => 'ToneCurve' },
	'tonecurveactive' => { 102 => 0x110 },
	'tonecurveadobergb' => { 355 => 0xa043 },
	'tonecurveadobergbdefault' => { 355 => 0xa041 },
	'tonecurveblue' => { 431 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 411 => 0x9003 },
	'tonecurvebluey' => { 411 => 0x9007 },
	'tonecurvebrightness' => { 97 => 0x20410 },
	'tonecurvebrightnessx' => { 411 => 0x9000 },
	'tonecurvebrightnessy' => { 411 => 0x9004 },
	'tonecurvecolorspace' => { 101 => 0x0 },
	'tonecurvecontrast' => { 97 => 0x20411 },
	'tonecurvefilename' => { 127 => 0x1391 },
	'tonecurvegreen' => { 431 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 411 => 0x9002 },
	'tonecurvegreeny' => { 411 => 0x9006 },
	'tonecurveinputrange' => { 101 => 0x3 },
	'tonecurveinterpolation' => { 102 => 0x159 },
	'tonecurvemode' => { 102 => 0x113 },
	'tonecurvename' => { 431 => 'ToneCurveName' },
	'tonecurvename2012' => { 431 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 97 => '0x20400.1' },
	'tonecurveoutputrange' => { 101 => 0x5 },
	'tonecurveproperty' => { 102 => 0x3c },
	'tonecurvepv2012' => { 431 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 431 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 431 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 431 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 431 => 'ToneCurveRed' },
	'tonecurveredx' => { 411 => 0x9001 },
	'tonecurveredy' => { 411 => 0x9005 },
	'tonecurves' => { 322 => 0x403 },
	'tonecurveshape' => { 101 => 0x1 },
	'tonecurvesrgb' => { 355 => 0xa042 },
	'tonecurvesrgbdefault' => { 355 => 0xa040 },
	'tonecurvex' => { 101 => 0xa },
	'tonecurvey' => { 101 => 0xb },
	'tonelevel' => { 267 => 0x52e },
	'tonemapstrength' => { 431 => 'ToneMapStrength' },
	'toningeffect' => { 54 => 0xf, 204 => 0xb3, 206 => 0x38, 207 => 0x40, 348 => 0x1015 },
	'toningeffectauto' => { 67 => 0xa4 },
	'toningeffectfaithful' => { 66 => 0x74, 67 => 0x74 },
	'toningeffectlandscape' => { 66 => 0x44, 67 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 66 => 0x8c, 67 => 0x8c },
	'toningeffectneutral' => { 66 => 0x5c, 67 => 0x5c },
	'toningeffectportrait' => { 66 => 0x2c, 67 => 0x2c },
	'toningeffectstandard' => { 66 => 0x14, 67 => 0x14 },
	'toningeffectuserdef1' => { 66 => 0xa4, 67 => 0xbc },
	'toningeffectuserdef2' => { 66 => 0xbc, 67 => 0xd4 },
	'toningeffectuserdef3' => { 66 => 0xd4, 67 => 0xec },
	'toningsaturation' => { 206 => 0x39, 207 => 0x41 },
	'totalzoom' => { 129 => 0x62 },
	'touchae' => { 288 => 0xab },
	'trackcreatedate' => { 342 => 0x1 },
	'trackmodifydate' => { 342 => 0x2 },
	'tracknumber' => { 455 => 'trackNumber' },
	'tracks' => { 455 => 'Tracks' },
	'tracksframerate' => { 455 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 455 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 455 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 455 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 455 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 455 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 455 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 455 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 455 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 455 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 455 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 455 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 455 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 455 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 455 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 455 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 455 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 151 => 'zmie' },
	'transcript' => { 441 => 'Transcript' },
	'transcriptlink' => { 441 => 'TranscriptLink' },
	'transcriptlinklink' => { 441 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 441 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 113 => 0x12d, 451 => 'TransferFunction' },
	'transform' => { 288 => [0x8012,0x59] },
	'transmissionreference' => { 443 => 'TransmissionReference' },
	'trapped' => { 276 => 'Trapped', 442 => 'Trapped' },
	'trashbuttonfunction' => { 78 => 0x710 },
	'travelday' => { 288 => 0x36 },
	'triggermode' => { 343 => 0x6, 344 => 0x34 },
	'tstop' => { 113 => 0xc772 },
	'ttl_da_adown' => { 310 => 0x5 },
	'ttl_da_aup' => { 310 => 0x4 },
	'ttl_da_bdown' => { 310 => 0x7 },
	'ttl_da_bup' => { 310 => 0x6 },
	'tungstenawb' => { 300 => 0x1 },
	'tvexposuretimesetting' => { 303 => 0x12 },
	'type' => { 432 => 'type', 450 => 'type' },
	'typestatus' => { 112 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 113 => 0xc614 },
	'uniquedocumentid' => { 121 => 0xbb },
	'uniqueobjectname' => { 122 => 0x64 },
	'units' => { 416 => 'Units' },
	'unknownblock' => { 322 => 0x405 },
	'unknownblock1' => { 271 => 0x635 },
	'unknownblock2' => { 271 => 0x636 },
	'unknownblock3' => { 271 => 0x1103 },
	'unknownblock4' => { 271 => 0x1104 },
	'unknowncontrast' => { 103 => 0x45 },
	'unknowndate' => { 331 => 0x212 },
	'unknownev' => { 127 => 0x1 },
	'unknownlinear' => { 103 => 0x46 },
	'unknownnumber' => { 91 => 0x180b },
	'unknownoutputhighlightpoint' => { 103 => 0x4a },
	'unknownoutputshadowpoint' => { 103 => 0x4b },
	'unknownrawhighlight' => { 103 => 0x7b },
	'unknownrawhighlightpoint' => { 103 => 0x48 },
	'unknownrawshadow' => { 103 => 0x84 },
	'unknownrawshadowpoint' => { 103 => 0x49 },
	'unknownsharpness' => { 103 => 0x47 },
	'unknowntemperature' => { 115 => 0x4 },
	'unsharp1color' => { 248 => 0x13 },
	'unsharp1halowidth' => { 248 => 0x19 },
	'unsharp1intensity' => { 248 => 0x17 },
	'unsharp1threshold' => { 248 => 0x1b },
	'unsharp2color' => { 248 => 0x2e },
	'unsharp2halowidth' => { 248 => 0x34 },
	'unsharp2intensity' => { 248 => 0x32 },
	'unsharp2threshold' => { 248 => 0x36 },
	'unsharp3color' => { 248 => 0x49 },
	'unsharp3halowidth' => { 248 => 0x4f },
	'unsharp3intensity' => { 248 => 0x4d },
	'unsharp3threshold' => { 248 => 0x51 },
	'unsharp4color' => { 248 => 0x64 },
	'unsharp4halowidth' => { 248 => 0x6a },
	'unsharp4intensity' => { 248 => 0x68 },
	'unsharp4threshold' => { 248 => 0x6c },
	'unsharpcount' => { 248 => 0x0 },
	'unsharpmask' => { 103 => 0x90, 243 => 0x76a43200 },
	'unsharpmaskfineness' => { 97 => 0x20309 },
	'unsharpmaskstrength' => { 97 => 0x20308 },
	'unsharpmaskthreshold' => { 97 => 0x2030a },
	'uprightcentermode' => { 431 => 'UprightCenterMode' },
	'uprightcenternormx' => { 431 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 431 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 431 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 431 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 431 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 431 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 431 => 'UprightPreview' },
	'uprighttransform_0' => { 431 => 'UprightTransform_0' },
	'uprighttransform_1' => { 431 => 'UprightTransform_1' },
	'uprighttransform_2' => { 431 => 'UprightTransform_2' },
	'uprighttransform_3' => { 431 => 'UprightTransform_3' },
	'uprighttransform_4' => { 431 => 'UprightTransform_4' },
	'uprighttransform_5' => { 431 => 'UprightTransform_5' },
	'uprighttransformcount' => { 431 => 'UprightTransformCount' },
	'uprightversion' => { 431 => 'UprightVersion' },
	'urgency' => { 121 => 0xa, 443 => 'Urgency' },
	'url' => { 144 => 'URL', 280 => 'URL', 336 => 0x40b, 445 => 'url' },
	'url_list' => { 336 => 0x41e },
	'urla-platform' => { 445 => [\'url','urlA-platform'] },
	'urlurl' => { 445 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 78 => 0x10a },
	'usableshootingmodes' => { 78 => 0x109 },
	'usage' => { 446 => 'usage' },
	'usageterms' => { 459 => 'UsageTerms' },
	'useguidelines' => { 428 => 'useGuidelines' },
	'usepanoramaviewer' => { 419 => 'UsePanoramaViewer' },
	'usercomment' => { 91 => 0x805, 113 => 0x9286, 435 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 66 => 0xd8, 67 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 66 => 0xda, 67 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 66 => 0xdc, 67 => 0xf4 },
	'userfields' => { 423 => 'UserFields' },
	'userlabel' => { 343 => 0x2b, 344 => 0x5a },
	'userprofile' => { 284 => 0x302, 290 => 0x3038 },
	'usmlenselectronicmf' => { 2 => 0x7, 77 => 0x7, 78 => 0x501 },
	'uspsnumber' => { 445 => 'uspsNumber' },
	'utmeasting' => { 155 => 'Easting' },
	'utmmapdatum' => { 155 => 'Datum' },
	'utmnorthing' => { 155 => 'Northing' },
	'utmzone' => { 155 => 'Zone' },
	'uv-irfiltercorrection' => { 284 => 0x325 },
	'validbits' => { 271 => 0x611, 272 => 0x102c },
	'validpixeldepth' => { 275 => 0x611 },
	'variablelowpassfilter' => { 378 => 0x2028 },
	'variousmodes' => { 129 => 0x26 },
	'variousmodes2' => { 129 => 0x3a },
	'variprogram' => { 204 => 0xab },
	'version' => { 118 => 0x0, 338 => 'Version', 431 => 'Version' },
	'versioncreatedate' => { 411 => 0xd100 },
	'versionid' => { 456 => 'VersionID' },
	'versionidentifier' => { 445 => 'versionIdentifier' },
	'versionmodifydate' => { 411 => 0xd101 },
	'versions' => { 456 => 'Versions' },
	'versionscomments' => { 456 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 456 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 456 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 456 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 456 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 456 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 456 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 456 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 456 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 456 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 456 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 250 => '3.2', 251 => '47.2', 253 => '79.1' },
	'verticalfuncbutton' => { 251 => '42.2', 253 => '67.1' },
	'verticalfuncbuttonplusdials' => { 251 => '43.1' },
	'verticalfuncplusdials' => { 253 => '68.1' },
	'verticalmultiselector' => { 251 => '42.1', 253 => '66.1', 254 => '66.1', 264 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 78 => [0x510,0x51d] },
	'vibrance' => { 424 => 'Vibrance', 431 => 'Vibrance' },
	'vibrationreduction' => { 212 => [0x75,0x82,0x1ae], 220 => '586.1', 228 => '590.2', 234 => 0x4 },
	'videoalphamode' => { 455 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 455 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 455 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 455 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 441 => 'videoBitRate' },
	'videobitratemode' => { 441 => 'videoBitRateMode' },
	'videocodec' => { 63 => 0x74 },
	'videocolorspace' => { 455 => 'videoColorSpace' },
	'videocompressor' => { 455 => 'videoCompressor' },
	'videodisplayaspectratio' => { 441 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 441 => 'videoEncodingProfile' },
	'videofieldorder' => { 455 => 'videoFieldOrder' },
	'videoframerate' => { 455 => 'videoFrameRate' },
	'videoframesize' => { 455 => 'videoFrameSize' },
	'videoframesizeh' => { 455 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 455 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 455 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 455 => 'videoModDate' },
	'videopixelaspectratio' => { 455 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 455 => 'videoPixelDepth' },
	'videoquality' => { 107 => 0x4003 },
	'videoshottype' => { 441 => 'VideoShotType' },
	'videoshottypeidentifier' => { 441 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 441 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 441 => 'videoStreamsCount' },
	'viewfinder' => { 331 => 0x455 },
	'viewfinderdisplay' => { 250 => '12.4', 251 => '6.3' },
	'viewfinderwarning' => { 250 => '13.4', 260 => '3.5', 261 => '6.2', 265 => '4.4' },
	'viewfinderwarnings' => { 78 => 0x40a },
	'viewinfoduringexposure' => { 78 => 0x407 },
	'viewingmode' => { 368 => 0x2f, 383 => 0x18 },
	'viewingmode2' => { 368 => [0x85,0x285] },
	'viewpoint' => { 444 => 'viewpoint' },
	'vignetteamount' => { 431 => 'VignetteAmount' },
	'vignettecontrol' => { 204 => 0x2a, 243 => 0x76a43205 },
	'vignettecontrolintensity' => { 243 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 427 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 431 => 'VignetteMidpoint' },
	'vignetting' => { 348 => 0x1011, 355 => 0xa052 },
	'vignettingcorrection' => { 355 => 0xa053, 378 => 0x2011 },
	'vignettingcorrparams' => { 113 => 0x7032, 406 => 0x64a, 407 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 355 => 0xa054 },
	'visualcolor' => { 441 => 'VisualColour' },
	'visualtechnique' => { 444 => 'visualTechnique' },
	'voicememo' => { 357 => 0x216 },
	'volume' => { 445 => 'volume' },
	'vr_0x66' => { 212 => 0x66 },
	'vrdoffset' => { 60 => 0xd0 },
	'vrmode' => { 234 => 0x6 },
	'waterdepth' => { 113 => 0x9403 },
	'wb_bluelevel3500k' => { 173 => 0x19a },
	'wb_bluelevel6500k' => { 173 => 0x18a },
	'wb_bluelevelcustom' => { 173 => 0x18e },
	'wb_bluelevelscloudy' => { 173 => 0x106 },
	'wb_bluelevelsdaylight' => { 173 => 0xea },
	'wb_bluelevelsflash' => { 173 => 0x122 },
	'wb_bluelevelsfluorescent' => { 173 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 173 => 0x254 },
	'wb_bluelevelsshade' => { 173 => 0x176 },
	'wb_bluelevelstungsten' => { 173 => 0xce },
	'wb_gbrglevels' => { 173 => 0xae, 176 => 0x4 },
	'wb_glevel' => { 271 => 0x11f },
	'wb_glevel3000k' => { 271 => 0x113 },
	'wb_glevel3300k' => { 271 => 0x114 },
	'wb_glevel3600k' => { 271 => 0x115 },
	'wb_glevel3900k' => { 271 => 0x116 },
	'wb_glevel4000k' => { 271 => 0x117 },
	'wb_glevel4300k' => { 271 => 0x118 },
	'wb_glevel4500k' => { 271 => 0x119 },
	'wb_glevel4800k' => { 271 => 0x11a },
	'wb_glevel5300k' => { 271 => 0x11b },
	'wb_glevel6000k' => { 271 => 0x11c },
	'wb_glevel6600k' => { 271 => 0x11d },
	'wb_glevel7500k' => { 271 => 0x11e },
	'wb_grbglevels' => { 186 => 0x0 },
	'wb_rbgglevels' => { 183 => 0x0 },
	'wb_rblevels' => { 204 => 0xc, 271 => 0x100 },
	'wb_rblevels1' => { 293 => 0x2 },
	'wb_rblevels2' => { 293 => 0x5 },
	'wb_rblevels3' => { 293 => 0x8 },
	'wb_rblevels3000k' => { 271 => 0x102 },
	'wb_rblevels3300k' => { 271 => 0x103 },
	'wb_rblevels3500k' => { 173 => 0x430 },
	'wb_rblevels3600k' => { 271 => 0x104 },
	'wb_rblevels3900k' => { 271 => 0x105 },
	'wb_rblevels4' => { 293 => 0xb },
	'wb_rblevels4000k' => { 271 => 0x106 },
	'wb_rblevels4300k' => { 271 => 0x107 },
	'wb_rblevels4500k' => { 271 => 0x108 },
	'wb_rblevels4800k' => { 271 => 0x109 },
	'wb_rblevels5' => { 293 => 0xe },
	'wb_rblevels5300k' => { 271 => 0x10a },
	'wb_rblevels6' => { 293 => 0x11 },
	'wb_rblevels6000k' => { 271 => 0x10b },
	'wb_rblevels6500k' => { 173 => 0x420 },
	'wb_rblevels6600k' => { 271 => 0x10c },
	'wb_rblevels7' => { 293 => 0x14 },
	'wb_rblevels7500k' => { 271 => 0x10d },
	'wb_rblevelsauto' => { 275 => 0x110 },
	'wb_rblevelscloudy' => { 173 => 0x3f0, 175 => 0x10, 275 => 0x121 },
	'wb_rblevelscoolwhitef' => { 173 => 0x308, 175 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 275 => 0x132 },
	'wb_rblevelscustom' => { 173 => 0x424 },
	'wb_rblevelscwb1' => { 271 => 0x10e },
	'wb_rblevelscwb2' => { 271 => 0x10f },
	'wb_rblevelscwb3' => { 271 => 0x110 },
	'wb_rblevelscwb4' => { 271 => 0x111 },
	'wb_rblevelsdaylight' => { 173 => [0x3ec,0x528], 175 => 0xc },
	'wb_rblevelsdaylightf' => { 175 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 275 => 0x130 },
	'wb_rblevelsdaywhitef' => { 175 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 275 => 0x131 },
	'wb_rblevelseveningsunlight' => { 275 => 0x124 },
	'wb_rblevelsfineweather' => { 275 => 0x122 },
	'wb_rblevelsflash' => { 173 => [0x3f4,0x304], 175 => 0x18 },
	'wb_rblevelsshade' => { 173 => 0x418, 175 => 0x20, 275 => 0x120 },
	'wb_rblevelstungsten' => { 173 => 0x3e8, 175 => 0x8, 275 => 0x123 },
	'wb_rblevelsunknown' => { 175 => 0x1c },
	'wb_rblevelsused' => { 275 => 0x100 },
	'wb_rblevelswhitef' => { 175 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 275 => 0x133 },
	'wb_redlevel3500k' => { 173 => 0x198 },
	'wb_redlevel6500k' => { 173 => 0x188 },
	'wb_redlevelcustom' => { 173 => 0x18c },
	'wb_redlevelscloudy' => { 173 => 0xf8 },
	'wb_redlevelsdaylight' => { 173 => 0xdc },
	'wb_redlevelsflash' => { 173 => 0x114 },
	'wb_redlevelsfluorescent' => { 173 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 173 => 0x1be },
	'wb_redlevelsshade' => { 173 => 0x168 },
	'wb_redlevelstungsten' => { 173 => 0xc0 },
	'wb_rgbglevels' => { 185 => 0x0 },
	'wb_rgblevels' => { 173 => [0x546,0x96], 285 => 0xd, 286 => 0x413, 290 => 0x3036, 331 => 0x107, 386 => 0x117c, 387 => 0x1180, 388 => 0x115c, 389 => 0x11d8, 390 => 0x11b4, 391 => 0x106c, 392 => 0x264, 393 => 0x264, 394 => 0x252 },
	'wb_rgblevels1' => { 294 => 0x2 },
	'wb_rgblevels2' => { 294 => 0x6 },
	'wb_rgblevels3' => { 294 => 0xa },
	'wb_rgblevels4' => { 294 => 0xe },
	'wb_rgblevels5' => { 294 => 0x12 },
	'wb_rgblevels6' => { 294 => 0x16 },
	'wb_rgblevels7' => { 294 => 0x1a },
	'wb_rggbblacklevels' => { 34 => 0x25 },
	'wb_rggblevels' => { 176 => 0x4, 184 => 0x0 },
	'wb_rggblevelsasshot' => { 37 => 0x0, 38 => 0x0, 39 => 0x19, 40 => 0x22, 41 => 0x3f, 44 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x47 },
	'wb_rggblevelsauto' => { 34 => 0x1, 37 => 0x5, 38 => 0x8, 39 => 0x1e, 40 => 0x18, 41 => 0x44, 44 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x4c, 355 => 0xa022 },
	'wb_rggblevelsblack' => { 355 => 0xa028 },
	'wb_rggblevelscloudy' => { 34 => 0xd, 37 => 0x1e, 38 => 0x30, 39 => 0x2d, 40 => 0x31, 41 => 0x58, 44 => 0x71, 45 => 0x8a, 46 => 0x8f, 47 => 0x92, 322 => 0x20f, 330 => 0x14 },
	'wb_rggblevelscustom' => { 34 => 0x1d, 41 => 0x80 },
	'wb_rggblevelscustom1' => { 39 => 0x41 },
	'wb_rggblevelscustom2' => { 39 => 0x46 },
	'wb_rggblevelsdaylight' => { 34 => 0x5, 37 => 0x14, 38 => 0x20, 39 => 0x23, 40 => 0x27, 41 => 0x4e, 44 => 0x67, 45 => 0x80, 46 => 0x85, 47 => 0x88, 322 => 0x20d, 330 => 0x2 },
	'wb_rggblevelsflash' => { 34 => 0x19, 37 => 0x32, 38 => 0x50, 39 => 0x3c, 40 => 0x45, 41 => 0x6c, 44 => 0x85, 45 => 0x9e, 46 => 0xa3, 47 => 0xa6, 322 => 0x214, 330 => 0x41 },
	'wb_rggblevelsfluorescent' => { 34 => 0x15, 37 => 0x28, 38 => 0x40, 39 => 0x37, 40 => 0x3b, 41 => 0x62, 44 => 0x7b, 45 => 0x94, 46 => 0x99, 47 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 322 => 0x211, 330 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 330 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 322 => 0x212, 330 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 322 => 0x213, 330 => 0x38 },
	'wb_rggblevelsilluminator1' => { 355 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 355 => 0xa024 },
	'wb_rggblevelskelvin' => { 34 => 0x21, 37 => 0x2d, 38 => 0x48, 40 => 0x40, 41 => 0x67, 44 => 0x80, 45 => 0x99, 46 => 0x9e, 47 => 0xa1 },
	'wb_rggblevelsmeasured' => { 37 => 0xa, 38 => 0x10, 41 => 0x49, 44 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x51 },
	'wb_rggblevelspc1' => { 40 => 0x90, 41 => 0x71 },
	'wb_rggblevelspc2' => { 40 => 0x95, 41 => 0x76 },
	'wb_rggblevelspc3' => { 40 => 0x9a, 41 => 0x7b },
	'wb_rggblevelsshade' => { 34 => 0x9, 37 => 0x19, 38 => 0x28, 39 => 0x28, 40 => 0x2c, 41 => 0x53, 44 => 0x6c, 45 => 0x85, 46 => 0x8a, 47 => 0x8d, 322 => 0x20e, 330 => 0xb },
	'wb_rggblevelstungsten' => { 34 => 0x11, 37 => 0x23, 38 => 0x38, 39 => 0x32, 40 => 0x36, 41 => 0x5d, 44 => 0x76, 45 => 0x8f, 46 => 0x94, 47 => 0x97, 322 => 0x210, 330 => 0x1d },
	'wb_rggblevelsuncorrected' => { 355 => 0xa021 },
	'wb_rggblevelsunknown' => { 37 => 0xf, 38 => 0x18, 40 => 0x1d, 44 => 0x4e, 45 => 0x4e, 46 => 0x4e, 47 => 0x56, 330 => 0x53 },
	'wb_rggblevelsunknown10' => { 37 => 0x5f, 38 => 0x98, 40 => 0x72, 44 => 0x9e, 45 => 0x7b, 46 => 0x7b, 47 => 0x83 },
	'wb_rggblevelsunknown11' => { 37 => 0x64, 38 => 0xa0, 40 => 0x77, 44 => 0xa3, 45 => 0xa3, 46 => 0x80, 47 => 0xab },
	'wb_rggblevelsunknown12' => { 37 => 0x69, 38 => 0xa8, 40 => 0x7c, 44 => 0xa8, 45 => 0xa8, 46 => 0xa8, 47 => 0xb0 },
	'wb_rggblevelsunknown13' => { 37 => 0x6e, 38 => 0xb0, 40 => 0x81, 44 => 0xad, 45 => 0xad, 46 => 0xad, 47 => 0xb5 },
	'wb_rggblevelsunknown14' => { 40 => 0x86, 44 => 0xb2, 45 => 0xb2, 46 => 0xb2, 47 => 0xba },
	'wb_rggblevelsunknown15' => { 40 => 0x8b, 44 => 0xb7, 45 => 0xb7, 46 => 0xb7, 47 => 0xbf },
	'wb_rggblevelsunknown16' => { 40 => 0x9f, 45 => 0xbc, 46 => 0xbc, 47 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xc1, 46 => 0xc1, 47 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xc6, 46 => 0xc6, 47 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xcb, 46 => 0xcb, 47 => 0xd3 },
	'wb_rggblevelsunknown2' => { 37 => 0x37, 38 => 0x58, 40 => 0x4a, 44 => 0x53, 45 => 0x53, 46 => 0x53, 47 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xd0, 46 => 0xd0, 47 => 0xd8 },
	'wb_rggblevelsunknown21' => { 46 => 0xd5, 47 => 0xdd },
	'wb_rggblevelsunknown22' => { 46 => 0xda, 47 => 0xe2 },
	'wb_rggblevelsunknown23' => { 46 => 0xdf, 47 => 0xe7 },
	'wb_rggblevelsunknown24' => { 46 => 0xe4, 47 => 0xec },
	'wb_rggblevelsunknown25' => { 46 => 0xe9, 47 => 0xf1 },
	'wb_rggblevelsunknown26' => { 46 => 0xee, 47 => 0xf6 },
	'wb_rggblevelsunknown27' => { 46 => 0xf3, 47 => 0xfb },
	'wb_rggblevelsunknown28' => { 46 => 0xf8, 47 => 0x100 },
	'wb_rggblevelsunknown29' => { 46 => 0xfd, 47 => 0x105 },
	'wb_rggblevelsunknown3' => { 37 => 0x3c, 38 => 0x60, 40 => 0x4f, 44 => 0x58, 45 => 0x58, 46 => 0x58, 47 => 0x60 },
	'wb_rggblevelsunknown30' => { 46 => 0x102 },
	'wb_rggblevelsunknown4' => { 37 => 0x41, 38 => 0x68, 40 => 0x54, 44 => 0x5d, 45 => 0x5d, 46 => 0x5d, 47 => 0x65 },
	'wb_rggblevelsunknown5' => { 37 => 0x46, 38 => 0x70, 40 => 0x59, 44 => 0x62, 45 => 0x62, 46 => 0x62, 47 => 0x6a },
	'wb_rggblevelsunknown6' => { 37 => 0x4b, 38 => 0x78, 40 => 0x5e, 44 => 0x8a, 45 => 0x67, 46 => 0x67, 47 => 0x6f },
	'wb_rggblevelsunknown7' => { 37 => 0x50, 38 => 0x80, 40 => 0x63, 44 => 0x8f, 45 => 0x6c, 46 => 0x6c, 47 => 0x74 },
	'wb_rggblevelsunknown8' => { 37 => 0x55, 38 => 0x88, 40 => 0x68, 44 => 0x94, 45 => 0x71, 46 => 0x71, 47 => 0x79 },
	'wb_rggblevelsunknown9' => { 37 => 0x5a, 38 => 0x90, 40 => 0x6d, 44 => 0x99, 45 => 0x76, 46 => 0x76, 47 => 0x7e },
	'wb_rggblevelsuserselected' => { 330 => 0x5c },
	'wbadjblueamber' => { 97 => 0x20106 },
	'wbadjbluebalance' => { 249 => 0x8 },
	'wbadjcolortemp' => { 97 => 0x20102, 102 => 0x1a },
	'wbadjlighting' => { 249 => 0x14 },
	'wbadjmagentagreen' => { 97 => 0x20105 },
	'wbadjmode' => { 249 => 0x10 },
	'wbadjredbalance' => { 249 => 0x0 },
	'wbadjrggblevels' => { 97 => 0x20125, 102 => 0x6 },
	'wbadjtemperature' => { 249 => 0x18 },
	'wbadjtint' => { 249 => 0x25 },
	'wbbluelevel' => { 284 => 0x324, 288 => 0x8006, 292 => 0x26 },
	'wbbracketingsteps' => { 221 => 0x174d, 222 => 0x87c, 230 => 0x1757 },
	'wbbracketmode' => { 54 => 0x9 },
	'wbbracketshotnumber' => { 173 => 0x2b, 348 => 0x101a },
	'wbbracketvalueab' => { 54 => 0xc },
	'wbbracketvaluegm' => { 54 => 0xd },
	'wbfinetuneactive' => { 102 => 0x24 },
	'wbfinetunesaturation' => { 102 => 0x28 },
	'wbfinetunetone' => { 102 => 0x2c },
	'wbgreenlevel' => { 284 => 0x323, 288 => 0x8005, 292 => 0x25 },
	'wbmediaimagesizesetting' => { 78 => 0x708 },
	'wbmode' => { 175 => 0x4, 272 => 0x1015 },
	'wbredlevel' => { 284 => 0x322, 288 => 0x8004, 292 => 0x24 },
	'wbscale' => { 176 => 0x0 },
	'wbshiftab' => { 70 => 0xc, 288 => 0x46, 304 => 0x10 },
	'wbshiftab_gm' => { 378 => 0x2014 },
	'wbshiftab_gm_precise' => { 378 => 0x2026 },
	'wbshiftgm' => { 70 => 0xd, 288 => 0x47, 304 => 0x11 },
	'wbtype1' => { 293 => 0x1, 294 => 0x1 },
	'wbtype2' => { 293 => 0x4, 294 => 0x5 },
	'wbtype3' => { 293 => 0x7, 294 => 0x9 },
	'wbtype4' => { 293 => 0xa, 294 => 0xd },
	'wbtype5' => { 293 => 0xd, 294 => 0x11 },
	'wbtype6' => { 293 => 0x10, 294 => 0x15 },
	'wbtype7' => { 293 => 0x13, 294 => 0x19 },
	'webstatement' => { 459 => 'WebStatement' },
	'what' => { 431 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x131, 27 => 0x77, 70 => 0x8, 72 => 0x7, 106 => 0x7, 107 => [0x19,0x2012], 113 => [0xa403,0xfe4e], 118 => 0x1002, 127 => 0x3fc, 128 => 0xfa0d, 129 => 0x40, 167 => 0x3, 168 => 0xe, 169 => 0x4, 170 => 0xb, 172 => 0x115, 204 => 0x5, 233 => 0x7, 284 => 0x304, 288 => 0x3, 290 => 0x3033, 322 => 0x19, 329 => 0x7, 347 => 0x26, 348 => 0x1003, 358 => [0x3c,0x7,0x58], 366 => 0xf, 367 => 0xe, 378 => [0x115,0xb054], 431 => 'WhiteBalance', 435 => 'WhiteBalance' },
	'whitebalance0' => { 163 => 'WhiteBalance0' },
	'whitebalance1' => { 163 => 'WhiteBalance1' },
	'whitebalance2' => { 163 => 'WhiteBalance2', 267 => 0x500 },
	'whitebalanceadj' => { 97 => 0x20101, 102 => 0x18, 243 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 300 => 0x0 },
	'whitebalancebias' => { 107 => 0x2011, 272 => 0x304, 288 => 0x23 },
	'whitebalanceblue' => { 70 => 0x7 },
	'whitebalancebracket' => { 267 => 0x502, 272 => 0x303 },
	'whitebalancebracketing' => { 170 => 0x22, 173 => 0x2c, 377 => 0x2c },
	'whitebalancecomp' => { 275 => 0x1001 },
	'whitebalancefinetune' => { 118 => 0x100a, 170 => 0x38, 172 => 0x112, 204 => 0xb, 348 => 0x1004, 366 => 0x6, 367 => 0x5, 378 => 0x112 },
	'whitebalancemode' => { 322 => 0x1a },
	'whitebalancered' => { 70 => 0x6 },
	'whitebalanceset' => { 303 => 0xa },
	'whitebalancesetting' => { 170 => 0x23, 366 => 0x5, 367 => 0x4, 368 => 0x16, 383 => 0xd },
	'whitebalancesetup' => { 355 => 0x41 },
	'whitebalancetemperature' => { 267 => 0x501 },
	'whiteboard' => { 272 => 0x301 },
	'whitelevel' => { 113 => 0xc61d, 322 => 0x7e },
	'whitepoint' => { 113 => 0x13e, 322 => 0x201, 451 => 'WhitePoint' },
	'whites2012' => { 431 => 'Whites2012' },
	'wideadapter' => { 348 => 0x1017 },
	'widefocuszone' => { 167 => 0x2f },
	'widerange' => { 357 => 0x20f },
	'windowsatom' => { 430 => 'windowsAtom' },
	'windowsatomextension' => { 430 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 430 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 430 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 445 => 'wordCount' },
	'workcolorspace' => { 97 => 0x10200, 102 => 0x270 },
	'workflowtag' => { 441 => 'WorkflowTag' },
	'workflowtagcvid' => { 441 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 441 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 441 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 441 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 437 => 'WorkToDo' },
	'worldtimelocation' => { 288 => 0x3a, 322 => 0x22, 328 => '0.1' },
	'writer-editor' => { 121 => 0x7a },
	'x3filllight' => { 358 => 0x12 },
	'xattrquarantine' => { 161 => 'com.apple.quarantine' },
	'xml' => { 125 => 'xml ' },
	'xmp' => { 100 => 0xffff00f6, 114 => 'XMP' },
	'xmptoolkit' => { 452 => 'xmptk' },
	'xpauthor' => { 113 => 0x9c9d },
	'xpcomment' => { 113 => 0x9c9c },
	'xpkeywords' => { 113 => 0x9c9e },
	'xposition' => { 113 => 0x11e },
	'xpsubject' => { 113 => 0x9c9f },
	'xptitle' => { 113 => 0x9c9b },
	'xresolution' => { 113 => 0x11a, 124 => 0x3, 337 => 0x0, 451 => 'XResolution' },
	'xyresolution' => { 117 => 0x3 },
	'yaw' => { 109 => 0x7 },
	'yawangle' => { 221 => 0x3513, 222 => 0x2c2c, 230 => 0x36fc, 353 => 0x0 },
	'ycbcrcoefficients' => { 113 => 0x211, 451 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 113 => 0x213, 451 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 113 => 0x212, 451 => 'YCbCrSubSampling' },
	'yearcreated' => { 129 => 0x10, 138 => 0xc },
	'yellowhsl' => { 97 => 0x20912 },
	'yield' => { 447 => 'yield' },
	'yposition' => { 113 => 0x11f },
	'yresolution' => { 113 => 0x11b, 124 => 0x5, 337 => 0x4, 451 => 'YResolution' },
	'zonematching' => { 172 => 0x10a, 175 => [0x3a,0x4a], 378 => 0xb024 },
	'zonematchingmode' => { 170 => 0x14 },
	'zonematchingon' => { 169 => 0x75 },
	'zonematchingvalue' => { 366 => 0x1f },
	'zoomedpreviewlength' => { 272 => 0xf05 },
	'zoomedpreviewsize' => { 272 => 0xf06 },
	'zoomedpreviewstart' => { 272 => 0xf04 },
	'zoomsourcewidth' => { 33 => 0x24 },
	'zoomstepcount' => { 270 => 0x300, 272 => 0x100d },
	'zoomtargetwidth' => { 33 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemailflagged' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketinginfooffset' => 1,
	'bracketingoffset' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm6' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'croparea' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'cx' => 1,
	'cy' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaytime' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dualshotinfo' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpscoordinates' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'levelmeter' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'listtype' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlatitude' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemusertags' => 1,
	'mditemversion' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metasampledesc' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rads' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'serialnumberhash' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrfinderinfo' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2018, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
