/* -*- mode: C++; c-basic-offset: 4; indent-tabs-mode: nil -*- */
// vim: ft=cpp:expandtab:ts=8:sw=4:softtabstop=4:
/*======
This file is part of Percona TokuBackup.

Copyright (c) 2006, 2015, Percona and/or its affiliates. All rights reserved.

    Percona TokuBackup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2,
    as published by the Free Software Foundation.

     Percona TokuBackup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Percona TokuBackup.  If not, see <http://www.gnu.org/licenses/>.

----------------------------------------

    Percona TokuBackup is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License, version 3,
    as published by the Free Software Foundation.

    Percona TokuBackup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with Percona TokuBackup.  If not, see <http://www.gnu.org/licenses/>.
======= */
#ifndef MANAGER_STATE_H
#define MANAGER_STATE_H

#ident "Copyright (c) 2012-2013 Tokutek Inc.  All rights reserved."
#ident "$Id: e13eb3223e35fb4a2cd133fceb0e0f6c9c3becd0 $"

#include <pthread.h>

class manager_state {
public:
    manager_state() throw();
    bool is_dead(void) throw();
    bool is_alive(void) throw();
    void kill(void) throw();
    bool capture_is_enabled(void) throw();
    bool copy_is_enabled(void) throw();
protected:
    void enable_capture(void) throw();
    void disable_capture(void) throw();
    void enable_copy(void) throw();
    void disable_copy(void) throw();
private:
    volatile bool m_is_dead;
    volatile bool m_capture_enabled;
    volatile bool m_copy_enabled;
};

#endif // End of header guardian.
