% Database Tools

Introduction
============

dbtools is a library and set of utilities for examining, transforming,
and editing PennMUSH database files. Unless otherwise specified, all
programs can work with either uncompressed databases, or ones
compressed with gzip (**.gz**) or bzip2 (**.bz2**). Old compress
(**.Z**) files are a different format that the compression library
used can't handle.

Currently, any database generated by PennMUSH 1.7.6 and up *should* be
readable, as well as many older formats. Further testing and
compability work is ongoing.

It does not currently support mail or chat databases.

Building
========

dbtools programs are written in C++, not C like Penn itself. They
depend on OpenSSL, and the [boost.iostreams] and
[boost.program-options] libraries as well as some header-only boost
libraries. The latter can be installed on Ubuntu like systems with
`sudo apt install libboost-dev libboost-iostreams-dev
libboost-program-options-dev`, and arch via `sudo pacman -S boost`.
`cmake` is used for configuration and creating Makefiles.

Unix
----

To build:

    % cd dbtools
    % cmake -DCMAKE_BUILD_TYPE=Release .
    % make -j4

Windows, using Visual Studio 2017
---------------------------------

### Installing dependencies

1. Install a git client if not already present.

2. Install [vcpkg] if not already present, following the instuctions
   on that page.

3. Install the following packages if needed (Via `.\vcpkg install`):
   **boost-iostreams boost-program-options boost-algorithm boost-container**
   (This might take a while)

   vcpkg supports both 32-bit and 64-bit targets. You might need to
   explicitly request the one you want to use (64 bit is suggested),
   by `.\vcpkg install boost-iostreams:x64-windows` or `.\vcpkg install
   boost-iostreams:x86-windows`.

### Actually building

1. Open VS 2017.

2. *File->Open->Folder* and select the dbtools directory.

3. Right click on *CMakeLists.txt* in the Solution Explorer and select
   *Change CMake Settings*. This will bring up a file called
   *CMakeSettings.json*. It has an assortment of build targets (Like
   `x64-Release`), any of which you plan on using needs to be updated to
   let CMake know about the vcpkg installation. Instructions and an
   example are
   [here](https://vcpkg.readthedocs.io/en/latest/examples/using-sqlite/#cmake).

4. Select *CMake->Build All*.

The Utilities
=============

dbupgrade
---------

Read a database in any supported format, and write out the database
in the current format.

### Options

-z

:    Database is compressed with gzip.

-j

:    Database is compressed with bzip2.

-i

:    Modify the database file in-place. If not given, the database is
printed to standard output.

If a filename is not given on the command line, standard input is used.

### Examples

To upgrade an old, uncompressed database in place: `dbtools/dbupgrade
-i game/data/outdb`

To upgrade an old, compressed database: `uncompress -c
game/data/outdb.Z | dbtools/dbupgrade | gzip -c >
game/data/indb.gz`

grepdb
------

A smart version of grep: Given a regular expression, searches a
database and displays the locations it matches. Potentially looks in
object names, lock keys and attribute contents.

### Options

-z

:    Database is compressed with gzip.

-j

:    Database is compressed with bzip2.

-i

:    The regular expression is matched case-insensitively.

-n

:    Search object names.

-l

:    Search locks.

-t

:    Search attribute bodies.

-a

:    Search all fields. If none of -n, -l, -t are given this is the
     default.

One mandatory command line argument is needed: The pattern to search
for. If a database file name is not also given, standard input is
used.

### Examples

To search for a dbref: `./dbtools/grepdb -z "#1622\\b"
game/data/outdb.gz` (The `\b` is a word boundry assertation that stops
things like "#16222" from matching.)

To search for a phrase, ignoring case: `./dbtools/grepdb -i "White
Rabbit" < game/data/outdb`

pwutil
------

A replacement for `utils/pwutil.pl`, this program lets you alter
passwords of players. Handy if, for example, you forgot God's
password.

### Options

-d DBREF | -a

:    Specifies a particular player dbref (Without the \#), or `-a` for
     all players. One of these two options **must** be given.

-p PASSWORD

:    The password to use. The default is *hunter2*.

-c

:    Instead of setting a password, erase it. `-ac` clears all players
     passwords.

-z

:    The database file is gzipped.

-j

:    Database is compressed with bzip2.

-i

:    Modify the database file in place. If not given, the modified db is
printed to standard output.


If a filename is not given on the command line, standard input is used.

### Examples

To reset #1's password to *foobar*: `dbtools/pwutil -iz -d 1 -p foobar
game/data/outdb.gz`

To erase every player's passwords in a new database: `dbtools/pwutil
-acz game/data/outdb.gz > newdb.gz` 

db2dot
------

Creates a graph of the database's rooms and exits in the dot language
used by [graphviz]. Graphviz tools can then be used to visualize the
grid, and manipulate the graph first if desired.

Exits without locks are represented by solid lines, exits with locks
by dashed.

If a room or exit has a *COLOR* attribute, its value is used as the
color for that part of the graph. (TODO: Parse *MONIKER* attributes?)

If an exit has a *DISTANCE* attribute that is an integer, its value is
used as the length of that edge (Used by some graphviz utilities like
`dijsktra`).

### Options

-z

:    Indicates the database is gzipped.

-j

:    Database is compressed with bzip2.

If a filename is not given on the command line, standard input is
used. The resulting graph is always printed to standard output.

### Examples

To create a map of your world: `dbtools/db2dot -z
game/data/outdb.gz | dot -Tsvg > world.svg`. It might look like ![this sample].

To limit the output to only rooms reachable from #0: `dbtools/db2dot
-z game/data/outdb.gz | ccomps -X room0 > grid.dot`

[graphviz]: https://graphviz.org
[this sample]: world.svg
[boost.iostreams]: https://www.boost.org/doc/libs/1_66_0/libs/iostreams/doc/index.html
[boost.program-options]: https://www.boost.org/doc/libs/1_66_0/doc/html/program_options.html
[vcpkg]: https://github.com/Microsoft/vcpkg
