/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <boost/test/unit_test.hpp>

#include "../Types.hh"

using namespace peekabot;



BOOST_AUTO_TEST_SUITE( GeneralTests );


//
// Make sure typedef'd datatype are actually of the sizes the 
// claim to be.
//
BOOST_AUTO_TEST_CASE( datatype_sizes )
{
    BOOST_REQUIRE( sizeof(int64_t) == 8 );
    BOOST_REQUIRE( sizeof(uint64_t) == 8 );
    BOOST_REQUIRE( sizeof(int32_t) == 4 );
    BOOST_REQUIRE( sizeof(uint32_t) == 4 );
    BOOST_REQUIRE( sizeof(int16_t) == 2 );
    BOOST_REQUIRE( sizeof(uint16_t) == 2 );
    BOOST_REQUIRE( sizeof(int8_t) == 1 );
    BOOST_REQUIRE( sizeof(uint8_t) == 1 );
    BOOST_REQUIRE( sizeof(real32) == 4 );
    BOOST_REQUIRE( sizeof(real64) == 8 );
}


BOOST_AUTO_TEST_SUITE_END();
