/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <boost/test/unit_test.hpp>

#include "../Pair.hh"
#include "Fixture.hh"


using namespace peekabot;



BOOST_AUTO_TEST_SUITE( Serialization_Pair );


BOOST_FIXTURE_TEST_CASE( save_load_pair, Fixture )
{
    const std::pair<int16_t, double> data(std::make_pair(42, 3.14159));

    {
        SerializationInterface *ret;

        BOOST_CHECK_NO_THROW( ret = &(m_ser << data) );
        // Check returned serialization interface, should be the same as
        // the one we passed along (or m_ser << foo << bar; won't work)
        BOOST_CHECK_EQUAL( ret, &m_ser );
        // Check to see that the buffer has grown accordingly
        // after we've saved a value in it
        BOOST_CHECK_EQUAL( m_buf.get_size(), sizeof(int16_t) + sizeof(double) );
    }
    {
        DeserializationInterface *ret;
        std::pair<int16_t, double> read_back;

        BOOST_CHECK_NO_THROW( ret = &(m_deser >> read_back) );
        BOOST_CHECK_EQUAL( ret, &m_deser );
        BOOST_CHECK_EQUAL( read_back.first, data.first );
        BOOST_CHECK_EQUAL( read_back.second, data.second );
        BOOST_CHECK_EQUAL( m_buf.get_size(), 0u );
    }
}

BOOST_FIXTURE_TEST_CASE( save_load_pair_array, Fixture )
{
    const size_t n = 5;
    const std::pair<double,int> data[n] = {
        std::make_pair(1.0, 55),
        std::make_pair(1.8, 55131),
        std::make_pair(3.88e-17, -12355),
        std::make_pair(1.0e9, 0),
        std::make_pair(1.0333, 424242)
    };

    {
        SerializationInterface *ret;

        BOOST_CHECK_NO_THROW( ret = &(m_ser << data) );
        // Check returned serialization interface, should be the same as
        // the one we passed along (or m_ser << foo << bar; won't work)
        BOOST_CHECK_EQUAL( ret, &m_ser );

        BOOST_CHECK_EQUAL( m_buf.get_size(), n*(sizeof(int)+sizeof(double)) );
    }
    {
        DeserializationInterface *ret;
        std::pair<double,int> read_back[n];

        BOOST_CHECK_NO_THROW( ret = &(m_deser >> read_back) );
        BOOST_CHECK_EQUAL( ret, &m_deser );
        BOOST_CHECK_EQUAL( m_buf.get_size(), 0u );

        for( size_t i = 0; i < n; ++i )
        {
            BOOST_CHECK_EQUAL( read_back[i].first, data[i].first );
            BOOST_CHECK_EQUAL( read_back[i].second, data[i].second );
        }

        BOOST_CHECK( m_buf.is_empty() );
    }
}


BOOST_AUTO_TEST_SUITE_END();
