/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PEEKABOT_SERIALIZATION_TESTS_FIXTURE_HH
#define __PEEKABOT_SERIALIZATION_TESTS_FIXTURE_HH


#include "../../ChunkedBuffer.hh"
#include "../SerializationInterface.hh"
#include "../DeserializationInterface.hh"
#include "../../Bytesex.hh"


namespace peekabot
{
    struct Fixture
    {
        Fixture() 
            : m_buf(1024), m_adapter(m_buf),
              m_ser(m_adapter),
              m_deser(m_adapter, __BYTE_ORDER == __BIG_ENDIAN),
              m_deser_foreign(m_adapter, !(__BYTE_ORDER == __BIG_ENDIAN))
        {
        }
        
        ChunkedBuffer m_buf;
        ChunkedBuffer::StreambufAdapter m_adapter;
        
        SerializationInterface m_ser;
        DeserializationInterface m_deser;
        DeserializationInterface m_deser_foreign;
    };
}

#endif // __PEEKABOT_SERIALIZATION_TESTS_FIXTURE_HH
